<?php
namespace App\Http\Controllers\Api\Verify\ProductManage;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Validator;
use Illuminate\Validation\Rule;

class VerifyGiftListsController extends Controller
{
    // 列表验证器
    public function indexValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'pri_id.required' => '参数错误',
            'pri_id.integer' => '数据类型不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'pri_id' => 'required|integer'
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 新增验证器
    public function addValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'goo_name.required' => '请输入:商品名称',
            'goo_name.max' => '商品名称长度超过最大限制',
            'goo_goods_code.required' => '请输入:商品编号',
            'goo_goods_code.max' => '商品编号长度超过最大限制',
            'goo_goods_encode.required' => '请输入:检索编码',
            'goo_goods_encode.max' => '检索编码长度超过最大限制',
            'goaf_another_name.required' => '请输入:商品别名',
            'goaf_another_name.max' => '商品别名长度超过最大限制',
            'goo_bra_name.required_with' => '请输入:品牌名称',
            'goo_bra_name.max' => '品牌名称长度超过最大限制',
            'goo_bra_id.required' => '请选择品牌',
            'goo_bra_id.integer' => '参数类型错误',
            'goo_bra_id.min' => '请选择正确的品牌',
            'goo_cate_name.required_with' => '请输入:品类名称',
            'goo_cate_name.max' => '品类名称长度超过最大限制',
            'goo_cate_id.required' => '请选择品类',
            'goo_cate_id.integer' => '参数类型错误',
            'goo_cate_id.min' => '请选择正确的品类',
            'goo_price.required' => '请输入:售价金额',
            'goo_price.numeric' => '参数类型错误',
            'goo_wholesale_price.required' => '请输入:批发价',
            'goo_wholesale_price.numeric' => '参数类型错误',
            'goo_purchase_price.required' => '请输入:采购价',
            'goo_purchase_price.numeric' => '参数类型错误',
            'goo_price.min' => '请输入正数',
            'info_name.required_with' => '请输入:属性名称',
            'info_name.array' => '参数类型错误',
            'info_content.required_with' => '请输入:属性内容',
            'info_content.array' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'goo_name' => 'required|max:20',
            'goo_goods_code' => 'sometimes|max:13',
            'goo_goods_encode' => 'sometimes|max:15',
            'goaf_another_name' => 'sometimes|required|max:10',
            'goo_cate_name' => 'required_with:goo_cate_id|max:10',
            'goo_cate_id' => 'required|integer|min:1',
            'goo_bra_name' => 'required_with:goo_bra_id|max:10',
            'goo_bra_id' => 'sometimes|required|integer|min:0',
            'goo_price' => 'required|numeric|min:0',
            'goo_wholesale_price' => 'required|numeric|min:0',
            'goo_purchase_price' => 'required|numeric|min:0',
            'info_name' => 'required_with:info_name,info_content|array',
            'info_content' => 'required_with:info_name,info_content|array',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 编辑页面查看验证器
    public function editShowValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'type.required' => '参数错误',
            'type.in' => '参数类型错误',
            'goo_id.required' => '参数错误',
            'goo_id.integer' => '参数错误',
            'goo_id.min' => '参数错误',
            'goaf_id.required_if' => '参数错误',
            'goaf_id.integer' => '参数错误',
            'goaf_id.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
                'type' => [
                    'required',
                    Rule::in(['1', '2']),
                ],
                'goo_id' => 'required|integer|min:1',
                'goaf_id' => 'required_if:type,2|integer|min:0',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 启用验证器
    public function startValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'goo_id.required' => '参数错误',
            'goo_id.array' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'goo_id' => 'required|array',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 搜索库存
    public function searchStockValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'goo_id.required' => '参数错误',
            'goo_id.integer' => '数据类型不正确',
            'goo_id.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'goo_id' => 'required|integer|min:1'
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }
}
