<?php

namespace App\Http\Controllers\Api\Verify\ProductManage;

use Illuminate\Http\Request;

use App\Http\Requests;
use App\Http\Controllers\Controller;
use Validator;

class VerifyCategoryListController extends Controller
{
    // 列表验证器
    public function indexValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'pri_id.required' => '参数错误',
            'pri_id.integer' => '数据类型不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'pri_id' => 'required|integer'
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 新增验证器
    public function addValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'cate_name.required' => '请输入:品类',
            'cate_name.max' => '品类名称长度超过最大限制',
            'cate_parent_id.required' => '请选择隶属上级',
            'cate_parent_id.integer' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'cate_name' => 'required|max:10',
            'cate_parent_id' => 'required|integer',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 编辑验证器
    public function editValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'cate_id.required' => '参数错误',
            'cate_id.integer' => '参数错误',
            'cate_name.required' => '请输入:品类',
            'cate_name.max' => '品类名称长度超过最大限制',
            'cate_parent_id.required' => '请选择隶属上级',
            'cate_parent_id.integer' => '参数类型错误',
            'cate_parent_id.different' => '请选择其他品类',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'cate_id' => 'required|integer',
            'cate_name' => 'required|max:10',
            'cate_parent_id' => 'required|integer|different:cate_id',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 启用验证器
    public function startValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'cate_id.required' => '参数错误',
            'cate_id.array' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'cate_id' => 'required|array',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 搜索品类编辑器
    public function getCategory($data)
    {
        // 自定义错误消息
        $messages = [
            'cate_id.integer' => '参数类型错误',
            'cate_id.min' => '参数错误'
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'cate_id' => 'sometimes|integer|min:1'
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }
}
