<?php

namespace App\Http\Controllers\Api\Verify\ProductManage;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Validator;

class VerifyBrandSerieController extends Controller
{
    // 列表验证器
    public function indexValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'pri_id.required' => '参数错误',
            'pri_id.integer' => '数据类型不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'pri_id' => 'required|integer'
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 新增验证器
    public function addValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'cate_id.required' => '请选择所属品类',
            'cate_id.integer' => '品类参数错误',
            'cate_id.min' => '品类参数错误',
            'bra_id.required' => '请选择所属品牌',
            'bra_id.integer' => '品牌参数错误',
            'bra_id.min' => '品牌参数错误',
            'brse_name.required' => '请输入:品牌系列',
            'brse_name.max' => '品牌系列名称长度超过最大限制',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'cate_id' => 'required|integer|min:1',
            'bra_id' => 'required|integer|min:1',
            'brse_name' => 'required|max:20',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 编辑验证器
    public function editValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'cate_id' => 'required|integer|min:1',
            'bra_id.required' => '请选择所属品牌',
            'bra_id.integer' => '品牌参数错误',
            'bra_id.min' => '品牌参数错误',
            'brse_id.required' => '参数错误',
            'brse_id.integer' => '参数错误',
            'brse_id.min' => '参数错误',
            'brse_name.required' => '请输入:品牌系列',
            'brse_name.max' => '品牌系列名称长度超过最大限制',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'cate_id.required' => '请选择所属品类',
            'cate_id.integer' => '品类参数错误',
            'cate_id.min' => '品类参数错误',
            'bra_id' => 'required|integer|min:1',
            'brse_id' => 'required|integer|min:1',
            'brse_name' => 'required|max:10',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 启用验证器
    public function startValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'brse_id.required' => '参数错误',
            'brse_id.array' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'brse_id' => 'required|array',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }
}
