<?php

namespace App\Http\Controllers\Api\Verify\ProductManage;

use Illuminate\Http\Request;
use App\Http\Requests;
use App\Http\Controllers\Controller;
use Validator;

class VerifyBrandListController extends Controller
{
    // 列表验证器
    public function indexValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'pri_id.required' => '参数错误',
            'pri_id.integer' => '数据类型不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'pri_id' => 'required|integer'
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 新增验证器
    public function addValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'bra_name.required' => '请输入:品牌',
            'bra_name.max' => '品牌名称长度超过最大限制',
            'bra_sequence.required' => '参数错误',
            'bra_sequence.integer' => '参数错误',
            'bra_sequence.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'bra_name' => 'required|max:10',
            // 'bra_sequence' => 'required|integer|min:0',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 编辑验证器
    public function editValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'bra_id.required' => '参数错误',
            'bra_id.integer' => '参数错误',
            'bra_id.min' => '参数错误',
            'bra_name.required' => '请输入:品牌',
            'bra_name.max' => '品牌名称长度超过最大限制',
            'bra_sequence.required' => '参数错误',
            'bra_sequence.integer' => '参数错误',
            'bra_sequence.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'bra_id' => 'required|integer|min:1',
            'bra_name' => 'required|max:10',
            'bra_sequence' => 'required|integer|min:0',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 启用验证器
    public function startValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'bra_id.required' => '参数错误',
            'bra_id.array' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'bra_id' => 'required|array',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }
}
