<?php
namespace App\Http\Controllers\Api\Verify\OtherSystemInterfaces;

use Illuminate\Http\Request;
use App\Http\Requests;
use App\Http\Controllers\Controller;
use Validator;
use Illuminate\Validation\Rule;

class VerifyOtherSystemAfterOrdersController extends Controller
{
    // 接单
    public function orderReceivingValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'oraf_id.required' => '参数错误',
            'oraf_id.integer' => '参数错误',
            'oraf_id.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'oraf_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }
}
