<?php
namespace App\Http\Controllers\Api\Verify\OrderManage;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Validator;
use Illuminate\Validation\Rule;

class VerifyWorkOrderController extends Controller
{
    // 列表验证器
    public function indexValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'pri_id.required' => '参数错误',
            'pri_id.integer' => '数据类型不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'pri_id' => 'required|integer'
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 详情验证器
    public function infoValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'wor_id.required' => '参数错误',
            'wor_id.integer' => '参数错误',
            'wor_id.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'wor_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 驳回
    public function rejectValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'wor_id.required' => '参数错误',
            'wor_id.integer' => '参数错误',
            'wor_id.min' => '参数错误',
            'remark.required' => '请输入备注',
            'remark.min' => '参数错误',
            'remark.max' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'wor_id' => 'required|integer|min:1',
            'remark' => 'required|min:1|max:255',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 派单验证器
    public function assignShowValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'wor_id.required' => '参数错误',
            'wor_id.integer' => '参数错误',
            'wor_id.min' => '参数错误',
            'type.required' => '参数错误',
            'type.in' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'wor_id' => 'required|integer|min:1',
            'type' => [
                    'required',
                    Rule::in(['1', '2']),
                ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 派单验证器
    public function assignValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'service_adm_id.required' => '请选择服务技师',
            'service_adm_data.required' => '请选择服务技师',
            'service_adm_id.integer' => '数据类型不正确',
            'service_adm_id.min' => '参数错误',
            'type.required' => '参数错误',
            'type.in' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'service_adm_id' => 'required|integer|min:1',
            'service_adm_data' => 'required',
            'type' => [
                    'required',
                    Rule::in(['1', '2']),
                ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 工单审核-旧货回收验证器
    public function junkRecycleValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'jur_id.required' => '参数错误',
            'jur_id.integer' => '数据类型不正确',
            'jur_id.min' => '参数错误',
            'recycle_state.required' => '参数错误',
            'recycle_state.in' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'jur_id' => 'required|integer|min:0',
            'recycle_state' => [
                'required',
                Rule::in(['1','2']),
            ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 生成账单验证器
    public function createBillValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'wor_id.required' => '参数错误',
            'wor_id.array' => '参数错误',
            'start_time.required' => '参数错误',
            'start_time.date' => '参数错误',
            'end_time.required' => '参数错误',
            'end_time.date' => '参数错误',
            'wobi_bill_price.required' => '参数错误',
            'wobi_bill_price.numeric' => '参数错误',
            'wobi_type.required' => '参数错误',
            'wobi_type.in' => '参数错误',
            'wor_service_shop_id.required' => '请选择加盟店',
            'wor_service_shop_id.integer' => '参数错误',
            'wor_service_shop_id.min' => '参数错误',
            'merge.required' => '参数错误',
            'merge.in' => '参数错误'
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'wor_id' => 'required|array',
            'start_time' => 'required|date',
            'end_time' => 'required|date',
            'wobi_bill_price' => 'required|numeric',
            'wobi_type' => [
                'required',
                Rule::in(['3','4']),
            ],
            'merge' => [
                'required',
                Rule::in(['1','2']),
            ],
            'wor_service_shop_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 改单显示验证器
    public function editShowValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'wor_id.required' => '请输入工单id',
            'wor_id.integer' => '工单id参数错误',
            'wor_id.min' => '工单id参数错误',
            'type.required' => '请输入类型字段',
            'type.in' => '类型参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'wor_id' => 'required|integer|min:1',
            'type' => [
                    'required',
                    Rule::in(['1', '2', '3']),
                ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 改单验证器
    public function editValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'wor_number.required' => '参数错误',
            'wor_number.max' => '参数错误',
            'wogo_id.required' => '参数错误',
            'wogo_id.array' => '数据类型不正确',
            'wogo_goo_id.required' => '请输入商品id',
            'wogo_goo_id.array' => '数据类型不正确',
            'wogo_goo_price.required' => '请输入商品金额',
            'wogo_goo_price.array' => '数据类型不正确',
            'wogo_goo_amount.required' => '请输入商品数量',
            'wogo_goo_amount.array' => '数据类型不正确',
            'wogo_is_recycle.required' => '请输选择是否回收',
            'wogo_is_recycle.array' => '数据类型不正确',
            'wogo_state.required' => '请输入商品状态',
            'wogo_state.array' => '数据类型不正确',
            'wogo_collection_price.required' => '请输入代收金额',
            'wogo_collection_price.array' => '数据类型不正确',
            'wogo_goo_inventory.required' => '请输入商品出库类型',
            'wogo_goo_inventory.array' => '数据类型不正确',
            'wor_service_sepr_id.required' => '请选择服务项目',
            'wor_service_sepr_id.integer' => '数据类型不正确', 
            'wor_service_sepr_id.min' => '数据类型不正确', 
            // 'wor_service_adm_id.required' => '请选择服务技师',
            // 'wor_service_adm_id.integer' => '数据类型不正确', 
            // 'wor_service_adm_id.min' => '数据类型不正确', 
            'wocl_collect_state.required' => '请选择服务技师',
            'wocl_collect_state.integer' => '数据类型不正确',           
            'wocl_collect_state.min' => '数据类型不正确',           
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'wor_number' => 'required|max:20',
            'wogo_id' => 'required|array',
            'wogo_goo_id' => 'required|array',
            'wogo_state' => 'required|array',
            'wogo_goo_price' => 'required|array',
            'wogo_goo_amount' => 'required|array',
            'wogo_is_recycle' => 'required|array',
            'wogo_collection_price' => 'required|array',
            'wogo_goo_inventory' => 'required|array',
            'wor_service_sepr_id' => 'required|integer|min:1',
            // 'wor_service_adm_id' => 'required|integer|min:1',
            'wocl_collect_state' => 'required|integer|min:0',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 行驶轨迹
    public function runningRouteValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'wor_id.required' => '参数错误',
            'wor_id.integer' => '参数错误',
            'wor_id.min' => '参数错误',
            'wor_service_adm_id.required' => '参数错误',
            'wor_service_adm_id.integer' => '参数错误',
            'wor_service_adm_id.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'wor_id' => 'required|integer|min:1',
            'wor_service_adm_id' => 'required|integer|min:0',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 打印验证器
    public function printNumberValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'wor_id.required' => '参数错误',
            'wor_id.integer' => '参数错误',
            'wor_id.min' => '参数错误',
            'wor_remark.sometimes' => '参数错误',
            'wor_remark.max' => '参数错误',
            // 'prca_com_name.required' => '请输入公司名称',
            'prca_com_name.max' => '公司名称超过长度限制',
            // 'prca_serve_provider.required' => '请输入服务提供商',
            'prca_serve_provider.max' => '服务提供商超过长度限制',
            // 'prca_serve_order.required' => '请输入打印单的类型',
            'prca_serve_order.max' => '打印单的类型超过长度限制',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'wor_id' => 'required|integer|min:1',
            'wor_remark' => 'sometimes|max:255',
            'prca_com_name' => 'sometimes|max:30', //公司名称
            'prca_serve_provider' => 'sometimes|max:30', //服务提供商
            'prca_serve_order' => 'sometimes|max:10', //打印单的类型
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 工单反审核
    public function cancelAuditValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'wor_id.required' => '参数错误',
            'wor_id.integer' => '参数类型错误',
            'wor_id.min' => '参数错误'
        ];
        // 数据验证
        $validator = Validator::make($data, [
            'wor_id' => 'required|integer|min:1'
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 工单催单
    public function reminderValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'wor_id.required' => '请输入工单id',
            'wor_id.integer' => '参数类型错误',
            'wor_id.min' => '参数错误',
            'wor_number.required' => '请输入工单号',
            'wor_number.min' => '工单号参数错误',
            'wor_number.max' => '工单号参数错误',
            'wor_service_adm_id.required' => '请输入技师id',
            'wor_service_adm_id.integer' => '参数类型错误',
            'wor_service_adm_id.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'wor_id' => 'required|integer|min:1',
            'wor_number' => 'required|min:20|max:20',
            'wor_service_adm_id' => 'required|integer|min:0',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }
    
    // 加盟店改单审核通过
    public function changePassValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'ord_id.required' => '参数错误',
            'ord_id.integer' => '参数类型错误',
            'ord_id.min' => '参数错误',
            'type.required' => '参数错误',
            'type.in' => '参数错误',
        ];
        // 数据验证
        $validator = Validator::make($data, [
            'ord_id' => 'required|integer|min:1',
            'type' => [
                'required',
                 Rule::in(['1', '2']),
            ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 加盟店改单审核驳回
    public function changeRejectValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'ord_id.required' => '参数错误',
            'ord_id.integer' => '参数类型错误',
            'ord_id.min' => '参数错误',
        ];
        // 数据验证
        $validator = Validator::make($data, [
            'ord_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 加盟店改单总店审核通过
    public function headChangePassValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'wor_id.required' => '参数错误',
            'wor_id.integer' => '参数类型错误',
            'wor_id.min' => '参数错误',
            'type.required' => '参数错误',
            'type.in' => '参数错误',
        ];
        // 数据验证
        $validator = Validator::make($data, [
            'wor_id' => 'required|integer|min:1',
            'type' => [
                'required',
                 Rule::in(['1', '2']),
            ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 加盟店改单总店审核驳回
    public function headChangeRejectValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'wor_id.required' => '参数错误',
            'wor_id.integer' => '参数类型错误',
            'wor_id.min' => '参数错误',
        ];
        // 数据验证
        $validator = Validator::make($data, [
            'wor_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }
    
    // 结算验证器
    public function settlementValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'wor_id.required' => '参数错误',
            'wor_id.integer' => '参数错误',
            'wor_id.min' => '参数错误',
            'orcl_acc_subject_id.required' => '请选择会计科目',
            'orcl_acc_subject_id.integer' => '参数错误',
            'orcl_acc_subject_id.min' => '参数错误',
            'orcl_img.sometimes' => '参数错误',
            'orcl_img.array' => '参数错误',
            'merge_collection.required' => '参数错误',
            'merge_collection.in' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'wor_id' => 'required|integer|min:1',
            'orcl_acc_subject_id' => 'required|integer|min:1',
            'orcl_img' => 'sometimes|array',
            'merge_collection' => [
                'required',
                Rule::in(['1', '2']),
            ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 强制终止技师的工单
    public function forceTerminationValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'wor_id.required' => '参数错误',
            'wor_id.integer' => '参数错误',
            'wor_id.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'wor_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 改单验证器
    public function editVirtualValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'wor_number.required' => '参数错误',
            'wor_number.max' => '参数错误',
            'wogo_id.required' => '参数错误',
            'wogo_id.array' => '数据类型不正确',
            'wogo_goo_id.required' => '请输入商品id',
            'wogo_goo_id.array' => '数据类型不正确',
            'wogo_goo_price.required' => '请输入商品金额',
            'wogo_goo_price.array' => '数据类型不正确',
            'orgo_goo_price.required' => '请输入商品金额',
            'orgo_goo_price.array' => '数据类型不正确',
            'wogo_goo_amount.required' => '请输入商品数量',
            'wogo_goo_amount.array' => '数据类型不正确',
            'wogo_is_recycle.required' => '请输选择是否回收',
            'wogo_is_recycle.array' => '数据类型不正确',
            'wogo_state.required' => '请输入商品状态',
            'wogo_state.array' => '数据类型不正确',
            'wogo_collection_price.required' => '请输入代收金额',
            'wogo_collection_price.array' => '数据类型不正确',
            'wor_service_sepr_id.required' => '请选择服务项目',
            'wor_service_sepr_id.integer' => '数据类型不正确', 
            'wor_service_sepr_id.min' => '数据类型不正确', 
            'wor_service_adm_id.required' => '请选择服务技师',
            'wor_service_adm_id.integer' => '数据类型不正确', 
            'wor_service_adm_id.min' => '数据类型不正确',            
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'wor_number' => 'required|max:20',
            'wogo_id' => 'required|array',
            'wogo_goo_id' => 'required|array',
            'wogo_state' => 'required|array',
            'wogo_goo_price' => 'required|array',
            'orgo_goo_price' => 'required|array',
            'wogo_goo_amount' => 'required|array',
            'wogo_is_recycle' => 'required|array',
            'wogo_collection_price' => 'required|array',
            'wor_service_sepr_id' => 'required|integer|min:1',
            'wor_service_adm_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 强制终止
    public function terminationValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'wor_id.required' => '参数错误',
            'wor_id.integer' => '参数类型错误',
            'wor_id.min' => '参数错误'
        ];
        // 数据验证
        $validator = Validator::make($data, [
            'wor_id' => 'required|integer|min:1'
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 精确打卡开关
    public function preciseLockValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'wor_id.required' => '参数错误',
            'wor_id.integer' => '参数类型错误',
            'wor_id.min' => '参数错误',
            'precise_lock.required' => '参数错误',
            'precise_lock.in' => '参数错误',
        ];
        // 数据验证
        $validator = Validator::make($data, [
            'wor_id' => 'required|integer|min:1',
            'precise_lock' => [
                'required',
                Rule::in(['1', '2']),
            ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 预约设置
    public function appointmentSetValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'wor_id.required' => '参数错误',
            'wor_id.integer' => '参数错误',
            'wor_id.min' => '参数错误',
            'appoint_time.required' => '请填写备注',
            'appoint_time.date' => '请选择日期',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'wor_id' => 'required|integer|min:1',
            'appoint_time' => 'required|date',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    //技师改派
    public function updateTechnicianValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'wor_id.required' => '参数错误',
            'wor_id.integer' => '参数类型错误',
            'wor_id.min' => '参数错误',
            'adm_id.required'=>'参数错误',
            'adm_id.integer'=>'参数错误',
            'adm_id.min'=>'参数错误',
        ];
        // 数据验证
        $validator = Validator::make($data, [
            'wor_id' => 'required|integer|min:1',
            'adm_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }
}
