<?php

namespace App\Http\Controllers\Api\Verify\OrderManage;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Validator;
use Illuminate\Validation\Rule;

class VerifyUploadImageController extends Controller
{
	// 列表验证器
    public function indexValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'pri_id.required' => '参数错误',
            'pri_id.integer' => '数据类型不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'pri_id' => 'required|integer'
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

	// 详情验证器
    public function imagePassValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'wor_id.required' => '参数错误',
            'wor_id.integer' => '参数错误',
            'wor_id.min' => '参数错误',
            'wor_image_pass_state.required' => '参数错误',
            'wor_image_pass_state.in' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'wor_id' => 'required|integer|min:1',
            'wor_image_pass_state' => [
                'required',
                Rule::in(['1', '2']),
            ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }
}
