<?php

namespace App\Http\Controllers\Api\Verify\MobileManage;

use Validator;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Validation\Rule;

class VerifyServeInfoController extends Controller
{
    // 链接页面获取信息 验证器
    public function acquireInfoValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'uniqueid.required' => '参数错误',
            'uniqueid.min' => '参数错误',
        ];
        // 数据验证
        $validator = Validator::make($data, [
            // 'uniqueid' => ['required','size:32','regex:/^[a-zA-Z0-9]+$/u'],
            'uniqueid' => 'required|min:8',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 获取工单信息/第一次获取经纬度 验证器
    public function getInfoValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'uniqueid.required' => '参数错误',
            'uniqueid.min' => '参数错误',
            // 'uniqueid.regex' => '参数类型错误',
            // 'uniqueid.size' => '参数错误',
        ];
        // 数据验证
        $validator = Validator::make($data, [
            // 'uniqueid' => ['required','size:32','regex:/^[a-zA-Z0-9]+$/u'],
        	'uniqueid' => 'required|min:16',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 获取工单信息/第一次获取经纬度 验证器
    public function realTimeLocationValidator($data)
    {
        // 自定义错误消息
        $messages = [
            // 'uniqueid.required' => '参数错误',
            // 'uniqueid.regex' => '参数类型错误',
            // 'uniqueid.size' => '参数错误',
            'uniqueid.required' => '参数错误',
            'uniqueid.min' => '参数错误',
            'loc_id.required' => '参数错误',
            'loc_id.integer' => '参数类型错误',
            'loc_id.min' => '参数错误',
        ];
        // 数据验证
        $validator = Validator::make($data, [
            // 'uniqueid' => ['required','size:32','regex:/^[a-zA-Z0-9]+$/u'],
            'uniqueid' => 'required|min:16',
        	'loc_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 客户评价提交验证器
    public function evaluateSubmitValidator($data)
    {
        // 自定义错误消息
        $messages = [
            // 'uniqueid.required' => '参数错误',
            // 'uniqueid.regex' => '参数类型错误',
            // 'uniqueid.size' => '参数错误',

            'uniqueid.required' => '参数错误',
            'uniqueid.min' => '参数错误',
            'install_standard_avg.required' => '参数错误',
            'install_standard_avg.in' => '参数错误',
            'serve_aging_avg.required' => '参数错误',
            'serve_aging_avg.in' => '参数错误',
            'serve_manner_avg.required' => '参数错误',
            'serve_manner_avg.in' => '参数错误',
            'car_clean_avg.required' => '参数错误',
            'car_clean_avg.in' => '参数错误',
            'install_timely_select.required' => '参数错误',
            'install_timely_select.in' => '参数错误',
            'install_standard_select.required' => '参数错误',
            'install_standard_select.in' => '参数错误',
            'manner_excellent_select.required' => '参数错误',
            'manner_excellent_select.in' => '参数错误',
            'desc.required' => '参数错误',
            'desc.max' => '评价描述超过最大长度限制',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            // 'uniqueid' => ['required','size:32','regex:/^[a-zA-Z0-9]+$/u'],
            'uniqueid' => 'required|min:16',
            'install_standard_avg' => [
                        'required',
                        Rule::in(['1', '2', '3', '4', '5']),
                    ],
            'serve_aging_avg' => [
                        'required',
                        Rule::in(['1', '2', '3', '4', '5']),
                    ],
            'serve_manner_avg' => [
                        'required',
                        Rule::in(['1', '2', '3', '4', '5']),
                    ],
            'car_clean_avg' => [
                        'required',
                        Rule::in(['1', '2', '3', '4', '5']),
                    ],
            'install_timely_select' => [
                        'required',
                        Rule::in(['1', '0']),
                    ],
            'install_standard_select' => [
                        'required',
                        Rule::in(['1', '0']),
                    ],
            'manner_excellent_select' => [
                        'required',
                        Rule::in(['1', '0']),
                    ],
            'desc' =>'required|max:255',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }
}
