<?php

namespace App\Http\Controllers\Api\Verify\MobileManage;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Validator;
use Illuminate\Validation\Rule;

class VerifyOrderManageController extends Controller
{
    // 新增验证器
    public function addValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'ord_service_type.required' => '请选择订单类型',
            'ord_service_type.in' => '订单类型参数错误',
            'service_adm_id.required' => '请选择服务技师',
            'service_adm_id.integer' => '服务技师数据类型不正确',
            'service_adm_id.min' => '服务技师参数错误',
            'service_shop_id.required' => '请选择服务门店',
            'service_shop_id.integer' => '服务门店数据类型不正确',
            'service_shop_id.min' => '服务门店参数错误',

            'service_sepr_id.required' => '请选择服务项目',
            'service_sepr_id.integer' => '服务项目数据类型不正确',
            'service_sepr_id.min' => '服务项目参数错误',
            // 'ware_id.required_unless' => '请选择供货仓库',
            // 'ware_id.integer' => '供货仓库数据类型不正确',
            // 'ware_id.min' => '供货仓库参数错误',
            'orcl_shipment_party.required' => '请选择出库方',
            'orcl_shipment_party.in' => '出库方参数错误',
            'ord_payment_way.required' => '请选择结算方式',
            'ord_payment_way.in' => '结算方式参数错误',
            'ord_type.required' => '请选择买家类型',
            'ord_type.in' => '买家类型参数错误',

            'orcl_name.required' => '请输入:姓名',
            'orcl_name.max' => '姓名长度超过最大限制',
            'orcl_car_num.required_if' => '请输入:车牌号',
            'orcl_car_num.max' => '车牌号长度超过最大限制',
            'orcl_province.required' => '请输入:省',
            'orcl_province.max' => '省长度超过最大限制',
            'orcl_city.required' => '请输入:市',
            'orcl_city.max' => '市长度超过最大限制',
            'orcl_county.required' => '请输入:县',
            'orcl_county.max' => '县长度超过最大限制',
            'orcl_address.required' => '请输入:地址',
            'orcl_address.max' => '地址长度超过最大限制',
            'orcl_channel_unit.required_if' => '请输入:客户单位',
            'orcl_channel_unit.max' => '客户单位长度超过最大限制',
            'orcl_standby_battery_type.required' => '参数错误',
            'orcl_standby_battery_type.in' => '参数错误',

            'ord_client_id.required' => '请选择客户信息',
            'ord_client_id.integer' => '数据类型不正确',
            'ord_client_id.min' => '参数错误',

            'orcl_chin_type.required' => '请选择是否铺货',
            'orcl_chin_type.in' => '参数错误',
            'orcl_collect_state.required' => '请选择技师是否收钱',
            'orcl_collect_state.in' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'ord_service_type' => [
                    'required',
                    Rule::in(config('apisystem.ORDER_TYPE')),
                ],//订单类型：1服务单 2销售单 3换货单 4退货单 5发货单 6结清单
            // 'service_adm_id' => 'required|integer|min:1',//服务技师id
            'service_shop_id' => 'required|integer|min:0',//服务门店id
            'service_sepr_id' => 'required|integer|min:0',//服务项目id
            'orcl_shipment_party' => [//出库方1库房2直营店3加盟店4虚拟加盟店
                'required',
                Rule::in([1,4]),
            ],
            // 'ware_id' => 'required_if:orcl_shipment_party,1|integer|min:1',//仓库id
            'ord_payment_way' => [//结算方式1.账期 2.现结 3微信 4支付宝
                    'required',
                    Rule::in(config('apisystem.ORDER_PAYMENT_WAY')),
                ],
            'ord_type' => [//读取配置文件数据，买家类型：1门店零售2渠道单位
                    'required',
                    Rule::in(config('apisystem.ORDER_BUYER_TYPE')),
                ],
            // 'ord_remark' => 'sometimes|required|max:255',

            'orcl_name' => 'required|max:20',//客户姓名
            // 'orcl_phone' => ['sometimes','regex:/^1[3456789]\d{9}$/'],// 客户手机号
            'orcl_car_num' => 'sometimes|required_if:ord_type,1|max:10',//客户车牌号
            'orcl_province' => 'required|max:50',
            'orcl_city' => 'required|max:50',
            'orcl_county' => 'required|max:50',
            'orcl_address' => 'required|max:255',
            'orcl_channel_unit' => 'sometimes|required_if:ord_type,2|max:50',
            'ord_client_id' => 'required|integer|min:0',
            'orcl_standby_battery_type' => [
                'sometimes',
                Rule::in(['1', '2']),
            ], //是否为备用电池1是2否

            'orcl_chin_type' => [
                'required',
                Rule::in(['1', '2']),
            ], //铺货类型：1是铺货 2不是铺货
            'orcl_collect_state' => [
                    'required',
                    Rule::in(['1', '2']),
                ], //技师收钱：1是2否
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 详情验证器
    public function infoValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'ord_id.required' => '参数错误',
            'ord_id.integer' => '参数错误',
            'ord_id.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'ord_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 发货验证器
    public function shipmentsValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'ord_id.required' => '参数错误',
            'ord_id.integer' => '参数错误',
            'ord_id.min' => '参数错误',
            'ord_order_number.required' => '参数错误',
            'ord_order_number.max' => '订单单号长度超过最大限制',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'ord_id' => 'required|integer|min:1',
            'ord_order_number' => 'required|max:20',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }
}
