<?php

namespace App\Http\Controllers\Api\Verify\MobileManage;

use Validator;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Validation\Rule;

class VerifyMyselfController extends Controller
{
    // 忘记密码验证器
    public function forgetPwdValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'type.required' => '参数类型错误',
            'type.in' => '参数类型错误',
            'tel.required' => '请输入手机号',
            'tel.regex' => '请输入正确的手机号',
        ];
        // 数据验证
        $validator = Validator::make($data, [
            'type' => [
                    'required',
                    Rule::in(['1', '2']),
                ], //type为1或者2
            'tel' => ['required','regex:/^1[3456789]\d{9}$/'],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $errors =  $validator->errors()->toArray();
            $errors =  array_shift($errors);
            return $errors[0];
        }
    }

    // 忘记密码提交验证器
    public function forgetPwdSbumitValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'code.required' => '请输入验证码',
            'code.digits' => '验证码错误',
            'pwd.required' => '请输入新密码',
            'pwd.regex' => '密码由6-15位数字或字母,或下划线组成！',
            'affirm_pwd.required' => '请输入确认密码',
            'affirm_pwd.same'=>'确认密码与密码不一致',
        ];
        // 数据验证
        $validator = Validator::make($data, [
            'code' => 'required|digits:6', //指定为六位数字
            'pwd' => ['required','regex:/^[\w\_]{6,15}$/u'],
            'affirm_pwd' => ['required',"same:pwd"], //不为空,两次密码是否相同
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $errors =  $validator->errors()->toArray();
            $errors =  array_shift($errors);
            return $errors[0];
        }
    }

    // 修改密码验证器
    public function editPwdValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'ago_pwd.required' => '请输入原密码',
            'ago_pwd.regex' => '原密码由6-15位数字或字母,或下划线组成！',
            'new_pwd.required' => '请输入新密码',
            'new_pwd.regex' => '新密码由6-15位数字或字母,或下划线组成！',
            'affirm_pwd.required' => '请输入确认密码',
            'affirm_pwd.same'=>'确认密码与新密码不一致',
        ];
        // 数据验证
        $validator = Validator::make($data, [
            'ago_pwd' => ['required','regex:/^[\w\_]{6,15}$/u'],
            'new_pwd' => ['required','regex:/^[\w\_]{6,15}$/u'],
            'affirm_pwd' => ['required',"same:new_pwd"], //不为空,两次密码是否相同
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 修改密码验证器
    public function editPersonalValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'adm_name.required' => '请输入:员工姓名',
            'adm_name.max' => '员工姓名长度超过最大限制',
            'adm_phone.required' => '请输入:联系人电话',
            'adm_phone.regex' => '手机号格式不正确',
        ];
        // 数据验证
        $validator = Validator::make($data, [
            'adm_name' => 'required|max:50',
            'adm_phone' => ['required','regex:/^1[3456789]\d{9}$/'],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }
}
