<?php

namespace App\Http\Controllers\Api\Verify\MobileManage;

use Illuminate\Http\Request;

use App\Http\Requests;
use App\Http\Controllers\Controller;
use Validator;
use Illuminate\Validation\Rule;

class VerifyMobileVisitsController extends Controller
{
    // 详情接口
    public function detailsValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'vis_id.required' => '参数错误',
            'vis_id.integer' => '类型不正确',
            'vis_id.min' => '类型不正确',
            'type.required' => '参数错误',
            'type.in' => '类型不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'vis_id' => 'required|integer|min:1',
            'type' => [ //1.获取单号 2.提交数据
                'required',
                 Rule::in(['1', '2']),
            ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 领取接口
    public function receiveValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'vis_id.required' => '参数错误',
            'vis_id.integer' => '类型不正确',
            'vis_id.min' => '类型不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'vis_id' => 'required|integer|min:1'
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 出发
    public function departValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'vis_id.required' => '参数错误',
            'vis_id.integer' => '类型不正确',
            'vis_id.min' => '类型不正确',
            'chun_id.required' => '参数错误',
            'chun_id.integer' => '类型不正确',
            'chun_id.min' => '类型不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'vis_id' => 'required|integer|min:1',
            'chun_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 打卡接口
    public function signInValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'vis_id.required' => '参数错误',
            'vis_id.integer' => '类型不正确',
            'vis_id.min' => '类型不正确',
            'chun_id.required' => '参数错误',
            'chun_id.integer' => '类型不正确',
            'chun_id.min' => '类型不正确',
            'chin_latitude.required' => '参数错误',
            'chin_longitude.required' => '参数错误',
            'type.required' => '参数错误',
            'type.in' => '类型不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'vis_id' => 'required|integer|min:1',
            'chun_id' => 'required|integer|min:1',
            'chin_latitude' => 'required',
            'chin_longitude' => 'required',
            'type' => [ //1.获取单号 2.提交数据
                'required',
                 Rule::in(['1', '2']),
            ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 提交接口
    public function submitDetailsValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'vis_id.required' => '参数错误',
            'vis_id.integer' => '类型不正确',
            'vis_id.min' => '类型不正确',
            'chun_id.required' => '参数错误',
            'chun_id.integer' => '类型不正确',
            'chun_id.min' => '类型不正确',
            'type.required' => '参数错误',
            'type.in' => '类型不正确',
            'vis_content.required' => '参数错误',
            // 'cogo_type.required' => '竞品必传',
            // 'cogo_type.in' => '参数错误',
            'dist_type.required' => '铺货必传',
            'dist_type.in' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'vis_id' => 'required|integer|min:1',
            'chun_id' => 'required|integer|min:1',
            'type' => [ //1.获取单号 2.提交数据
                'required',
                 Rule::in(['1', '2']),
            ],
            'dist_type' => [ //1.是铺货 2.不是铺货
                'required',
                 Rule::in(['1', '2']),
            ],
            'vis_content' => 'required',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 获取经纬度
    public function locationValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'chin_latitude.required' => '经度不能为空',
            'chin_latitude.max' => '经度长度超过最大限制',
            'chin_longitude.required' => '纬度不能为空',
            'chin_longitude.max' => '纬度长度超过最大限制',
            'state.required' => '服务单id不能为空',
            'vire_id.required' => '当前状态不能为空',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'chin_latitude' => 'required|max:20',
            'chin_longitude' => 'required|max:20',
            'state' => 'required',
            'vire_id' => 'required',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 获取经纬度
    public function recordValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'vis_id.required' => '参数错误',
            'vis_id.integer' => '类型不正确',
            'vis_id.min' => '类型不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'vis_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }
}