<?php

namespace App\Http\Controllers\Api\Verify\MemberManage;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Validator;
use Illuminate\Validation\Rule;

class VerifyMemberCarController extends Controller
{
    // 列表验证器
    public function indexValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'pri_id.required' => '参数错误',
            'pri_id.integer' => '数据类型不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'pri_id' => 'required|integer'
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 新增验证器
    public function addValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'meca_mem_id.required' => '请选择会员',
            'meca_mem_id.integer' => '参数错误',
            'meca_mem_id.min' => '参数错误',

            'meca_car_num.required' => '请输入:车牌号',
            'meca_car_num.max' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'meca_mem_id' => 'required|integer|min:1',
            'meca_car_num' => 'required|max:10',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 编辑页面查看验证器
    public function editShowValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'meca_id.required' => '参数错误',
            'meca_id.integer' => '参数错误',
            'meca_id.min' => '参数错误',
            'type.required' => '参数错误',
            'type.in' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'meca_id' => 'required|integer|min:1',
            'type' => [
                    'required',
                    Rule::in(['1', '2']),
                ], //mem_sex为1或者2
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 详情查看验证器
    public function infoValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'meca_id.required' => '参数错误',
            'meca_id.integer' => '参数错误',
            'meca_id.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'meca_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 删除
    public function deleteValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'meca_id.required' => '参数错误',
            'meca_id.array' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'meca_id' => 'required|array',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }
}
