<?php

namespace App\Http\Controllers\Api\Verify\InformationHint;

use Validator;
use App\Http\Requests;
use Illuminate\Http\Request;
use Illuminate\Validation\Rule;
use App\Http\Controllers\Controller;

class VerifyInformationHintController extends Controller
{
	// 更改状态
    public function changeStateValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'inhi_id.required' => '请传入id',
            'inhi_id.array' => '参数类型错误',
            'inhi_original_number.required' => '请传入单号',
            'inhi_original_number.array' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'inhi_id' => 'required|array',
            'inhi_original_number' => 'required|array',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }
}
