<?php

namespace App\Http\Controllers\Api\Verify\DistributorsManages;

use Validator;
use App\Http\Requests;
use Illuminate\Http\Request;
use Illuminate\Validation\Rule;
use App\Http\Controllers\Controller;

class VerifyDamagedReportsController extends Controller
{
    // 详情验证器
    public function addValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'img.required' => '参数错误',
            'img.array' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'img' => 'required|array',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 备注验证器
    public function remarkValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'dadw_id.required' => '参数错误',
            'dadw_id.integer' => '参数类型错误',
            'dadw_id.min' => '参数错误',
            'remark.required' => '参数错误',
            'remark.max' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'dadw_id' => 'required|integer|min:1',
            'remark' => 'required|max:255',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 详情验证器
    public function detailsValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'dadw_id.required' => '参数错误',
            'dadw_id.integer' => '参数类型错误',
            'dadw_id.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'dadw_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 编辑验证器
    public function editValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'img.required' => '参数错误',
            'img.array' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'img' => 'required|array',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    //撤回
    public function revocationValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'dadw_id.required' => '参数错误',
            'dadw_id.integer' => '参数类型错误',
            'dadw_id.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'dadw_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    //删除
    public function deleteValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'dadw_id.required' => '参数错误',
            'dadw_id.integer' => '参数类型错误',
            'dadw_id.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'dadw_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }
}
