<?php

namespace App\Http\Controllers\Api\Verify\DistributorsManages;

use Validator;
use App\Http\Requests;
use Illuminate\Http\Request;
use Illuminate\Validation\Rule;
use App\Http\Controllers\Controller;

class VerifyDamagedReplenishsController extends Controller
{
    // 备注验证器
    public function remarkValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'darw_id.required' => '参数错误',
            'darw_id.integer' => '参数类型错误',
            'darw_id.min' => '参数错误',
            'remark.required' => '参数错误',
            'remark.max' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'darw_id' => 'required|integer|min:1',
            'remark' => 'required|max:255',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 详情
    public function detailsValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'darw_id.required' => '参数错误',
            'darw_id.integer' => '参数类型错误',
            'darw_id.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'darw_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 残损单号详情
    public function reportsDetailsValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'damaged_number.required' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'damaged_number' => 'required',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 收货接口
    public function showTakeDeliveryValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'darw_id.required' => '参数错误',
            'darw_id.int' => '参数类型错误',
            'darw_id.min' => '参数类型错误',
            'type.required'=>'参数类型错误',
            'type.in' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'darw_id' => 'required|int|min:1',
            'type' => [
                'required',
                Rule::in(['1', '2']),
            ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 收货接口
    public function takeDeliveryValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'amount.required' => '参数错误',
            'amount.array' => '参数类型错误',
            'drgw_id.required' => '参数类型错误',
            'drgw_id.array'=>'参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'amount' => 'required|array',
            'drgw_id' => 'required|array',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }
}
