<?php

namespace App\Http\Controllers\Api\Verify\DataSearch;

use Validator;
use App\Http\Requests;
use Illuminate\Http\Request;
use Illuminate\Validation\Rule;
use App\Http\Controllers\Controller;

class VerifyVehicleInquireController extends Controller
{
    // 详情验证器
    public function correctionValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'psj_pjid.required' => '参数错误',
            'psj_pjid.integer' => '参数类型错误',
            'psj_pjid.min' => '参数错误',
            'good_id.required' => '参数错误',
            'good_id.integer' => '参数类型错误',
            'good_id.min' => '参数错误',
            'good_name.required' => '参数错误',
            'good_name.min' => '参数错误',
            'good_namenew.required' => '参数错误',
            'good_namenew.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'psj_pjid' => 'required|integer|min:1',
            'good_id' => 'required|integer|min:1',
            'good_name' => 'required|min:1',
            'good_namenew' => 'required|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }
}
