<?php

namespace App\Http\Controllers\Api\Verify\DataSearch;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Validator;
use Illuminate\Validation\Rule;

class VerifyLockGoodsOrderController extends Controller
{
	// 列表验证器
    public function indexValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'ware_id.required' => '请选择仓库',
            'ware_id.integer' => '数据类型不正确',
            'ware_id.min' => '取值范围不正确',
            'wago_id.required' => '请选择商品',
            'wago_id.integer' => '数据类型不正确',
            'wago_id.min' => '取值范围不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'ware_id' => 'required|integer|min:1',
            'wago_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }
}
