<?php

namespace App\Http\Controllers\Api\Verify\ChannelManage;

use Illuminate\Http\Request;

use App\Http\Requests;
use App\Http\Controllers\Controller;
use Validator;
use Illuminate\Validation\Rule;

class VerifyChannelTypeController extends Controller
{
    // 列表验证器
    public function indexValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'pri_id.required' => '参数错误',
            'pri_id.integer' => '数据类型不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'pri_id' => 'required|integer'
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 新增验证器
    public function addValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'chty_name.required' => '请输入:渠道类型',
            'chty_name.max' => '渠道类型长度超过最大限制',
            'chty_state.required' => '参数错误',
            'chty_state.in' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'chty_name' => 'required|max:10',
            'chty_state' => [
                    'required',
                    Rule::in(['1', '2']),
                ], //chty_state为1或者2
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 编辑验证器
    public function editValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'chty_id.required' => '参数错误',
            'chty_id.integer' => '参数错误',
            'chty_id.min' => '参数错误',
            'chty_name.required' => '请输入:渠道类型',
            'chty_name.max' => '渠道类型长度超过最大限制',
            'chty_state.required' => '参数错误',
            'chty_state.in' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'chty_id' => 'required|integer|min:1',
            'chty_name' => 'required|max:10',
            'chty_state' => [
                    'required',
                    Rule::in(['1', '2']),
                ], //chty_state为1或者2
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 停启用/删除验证器
    public function startValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'chty_id.required' => '参数错误',
            'chty_id.array' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'chty_id' => 'required|array',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }
}
