<?php

namespace App\Http\Controllers\Api\Verify\AfterSaleManage;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Validator;
use Illuminate\Validation\Rule;

class VerifyOrderAfterSaleController extends Controller
{
    // 列表验证器
    public function indexValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'pri_id.required' => '参数错误',
            'pri_id.integer' => '数据类型不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'pri_id' => 'required|integer'
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 详情验证器
    public function infoValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'ord_id.required' => '参数错误',
            'ord_id.integer' => '参数错误',
            'ord_id.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'ord_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 取消售后验证器
    public function cancelValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'oras_id.required' => '参数错误',
            'oras_id.integer' => '参数错误',
            'oras_id.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'oras_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 备注验证器
    public function remarkValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'oras_id.required' => '参数错误',
            'oras_id.integer' => '参数错误',
            'oras_id.min' => '参数错误',
            'remark.required' => '参数错误',
            'remark.min' => '参数错误',
            'remark.max' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'oras_id' => 'required|integer|min:1',
            'remark' => 'required|min:1|max:255',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 售后处理验证器
    public function disposeValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'oras_id.required' => '参数错误',
            'oras_id.integer' => '参数错误',
            'oras_id.min' => '参数错误',
            'type.required' => '参数错误',
            'type.in' => '参数错误',
            'goo_id.required_if' => '参数错误',
            'goo_id.array' => '参数错误',
            'exchange_number.required_if' => '参数错误',
            'exchange_number.array' => '参数错误',
            'ord_id.required_if' => '参数错误',
            'ord_id.integer' => '参数错误',
            'ord_id.min' => '参数错误',

            'ware_id.required_if' => '参数错误',
            'ware_id.integer' => '参数错误',
            'ware_id.min' => '参数错误',

            // 'orcl_channel_unit.required_if' => '参数错误',
            // 'orcl_channel_unit.min' => '参数错误',
            // 'orcl_channel_unit.max' => '参数错误',
            'client_name.required_if' => '参数错误',
            'client_name.max' => '参数错误',
            'client_name.min' => '参数错误',
            'client_phone.required_if' => '参数错误',
            'client_phone.regex' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'oras_id' => 'required|integer|min:1',
            'type' => [
                    'required',
                    Rule::in(['1', '2']),
                ],

            'goo_id' => 'required_if:type,2|array',
            'exchange_number' => 'required_if:type,2|array',
            'ord_id' => 'required_if:type,2|integer|min:1',
            'ware_id' => 'required_if:type,2|integer|min:1',
            // 'orcl_channel_unit' => 'required_if:type,2|min:0|max:20',
            'client_name' => 'required_if:type,2|min:1|max:20',
            'client_phone' => ['required_if:type,2','regex:/^1[3456789]\d{9}$/'],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }
}
