<?php
namespace App\Http\Controllers\Api\Verify\AfterSaleManage;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Validator;
use Illuminate\Validation\Rule;

class VerifyOrderAfterController extends Controller
{
    // 列表验证器
    public function indexValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'pri_id.required' => '参数错误',
            'pri_id.integer' => '数据类型不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'pri_id' => 'required|integer'
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 详情验证器
    public function infoValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'oraf_id.required' => '参数错误',
            'oraf_id.integer' => '参数错误',
            'oraf_id.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'oraf_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 取消售后验证器
    public function cancelValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'oraf_id.required' => '参数错误',
            'oraf_id.integer' => '参数错误',
            'oraf_id.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'oraf_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 售后备注验证器
    public function afterNoteValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'oraf_id.required' => '参数错误',
            'oraf_id.integer' => '参数错误',
            'oraf_id.min' => '参数错误',
            'oran_afla_id.required' => '参数错误',
            'oran_afla_id.integer' => '参数错误',
            'oran_afla_id.min' => '参数错误',
            'oran_content.required' => '参数错误',
            'oran_content.min' => '参数错误',
            'oran_content.max' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'oraf_id' => 'required|integer|min:1',
            'oran_afla_id' => 'required|integer|min:1',
            'oran_content' => 'required|min:1|max:255',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 日常反馈验证器
    public function dailyFeedbackValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'oraf_id.required' => '参数错误',
            'oraf_id.integer' => '参数错误',
            'oraf_id.min' => '参数错误',
            'orap_remark.required' => '参数错误',
            'orap_remark.min' => '参数错误',
            'orap_remark.max' => '参数错误',
            'orap_image.required' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'oraf_id' => 'required|integer|min:1',
            'orap_remark' => 'required|min:1|max:255',
            'orap_image' => 'required',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 派单验证器
    public function sendOrdersValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'oraf_id.required' => '参数错误',
            'oraf_id.integer' => '数据类型不正确',
            'oraf_id.min' => '参数错误',
            'ware_id.required' => '请选择供货仓库',
            'ware_id.integer' => '数据类型不正确',
            'ware_id.min' => '参数错误',
            'service_adm_id.required' => '请选择服务技师',
            'service_adm_id.integer' => '数据类型不正确',
            'service_adm_id.min' => '参数错误',
            'goo_id.required' => '参数错误',
            'goo_id.array' => '数据类型不正确',
            'goo_waon_class.required' => '请选择仓库类别',
            'goo_waon_class.array' => '数据类型不正确',
            'goo_quantity.required' => '请输入商品数量',
            'goo_quantity.array' => '数据类型不正确',
            'goo_inventory.required' => '请输入库存扣除方式',
            'goo_inventory.array' => '数据类型不正确',
            'longitude.required' => '请输入经度',
            'longitude.numeric' => '经度长度超过最大限制',
            'latitude.required' => '请输入纬度',
            'latitude.numeric' => '纬度长度超过最大限制',
            'orcl_standby_battery_type.required' => '参数错误',
            'orcl_standby_battery_type.in' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'oraf_id' => 'required|integer|min:1',
            'ware_id' => 'required|integer|min:1',

            'goo_id' => 'required|array',
            'goo_waon_class' => 'required|array',//仓库类别1货物仓2非货物仓3旧货仓4临时仓
            'goo_quantity' => 'required|array',
            'goo_inventory' => 'required|array', //库存扣除方式 1.良品 2.优先
            
            'service_adm_id' => 'required|integer|min:1',
            'longitude' => 'required|numeric', //经度
            'latitude' => 'required|numeric', //纬度
            'orcl_standby_battery_type' => [
                'sometimes',
                Rule::in(['1', '2']),
            ], //是否为备用电池1是2否
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 审核验证器
    public function passValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'oraf_id.required' => '参数错误',
            'oraf_id.integer' => '参数错误',
            'oraf_id.min' => '参数错误',
            'oraf_actual_price.required' => '参数错误',
            // 'oraf_actual_price.integer' => '参数错误',
            'oraf_actual_price.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'oraf_id' => 'required|integer|min:1',
            'oraf_actual_price' => 'required|min:0',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 结算验证器
    public function settlementValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'oraf_id.required' => '参数错误',
            'oraf_id.integer' => '参数错误',
            'oraf_id.min' => '参数错误',
            'orac_acc_subject_id.required' => '参数错误',
            'orac_acc_subject_id.integer' => '参数错误',
            'orac_acc_subject_id.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'oraf_id' => 'required|integer|min:1',
            'orac_acc_subject_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 行驶轨迹
    public function runningRouteValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'oraf_id.required' => '参数错误',
            'oraf_id.integer' => '参数错误',
            'oraf_id.min' => '参数错误',
            'oraf_service_adm_id.required' => '参数错误',
            'oraf_service_adm_id.integer' => '参数错误',
            'oraf_service_adm_id.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'oraf_id' => 'required|integer|min:1',
            'oraf_service_adm_id' => 'required|integer|min:0',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 详情验证器
    public function feedbackValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'oraf_id.required' => '参数错误',
            'oraf_id.integer' => '参数错误',
            'oraf_id.min' => '参数错误',
            'label_id.required' => '参数错误',
            'label_name.required' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'oraf_id' => 'required|integer|min:1',
            'label_id' => 'required',
            'label_name' => 'required',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }
}
