<?php

namespace App\Http\Controllers\Api\Verify\AfterOrderManage;

use Validator;
use App\Http\Requests;
use Illuminate\Http\Request;
use Illuminate\Validation\Rule;
use App\Http\Controllers\Controller;

class AfterOrderManageController extends Controller
{
    // 列表验证器
    public function indexValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'pri_id.required' => '参数错误',
            'pri_id.integer' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'pri_id' => 'required|integer',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 详情验证器
    public function infoValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'pri_id.required' => '参数错误',
            'pri_id.integer' => '参数类型错误',
            'awlo_id.required' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'pri_id' => 'required|integer',
            'awlo_id' => 'required|integer',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 售后处理验证器
    public function dealwithValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'awlo_id.required' => '参数错误',
            'awlo_id.integer' => '参数类型错误',
            'awlo_text.required' => '请填写备注',
            'awlo_pic_data.required' => '请上传图片',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'awlo_id' => 'required|integer',
            'awlo_text' => 'required',
            'awlo_pic_data' => 'required',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $messages = $validator->errors()->all();
            return $messages[0];
        }
    }

    // 售后处理完工验证器
    public function completeValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'awlo_id.required' => '参数错误',
            'awlo_id.integer' => '参数类型错误',
            'awlo_work_parts.required' => '请选择施工位置',
            'awlo_complete_pic.required' => '请上传图片',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'awlo_id' => 'required|integer',
            'awlo_work_parts' => 'required',
            'awlo_pic_data' => 'required',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $messages = $validator->errors()->all();
            return $messages[0];
        }
    }
}
