<?php

namespace App\Http\Controllers\Api\Verify\AccountManage;

use Validator;
use App\Http\Requests;
use Illuminate\Http\Request;
use Illuminate\Validation\Rule;
use App\Http\Controllers\Controller;

class VerifyWorkBillController extends Controller
{
    // 列表验证器
    public function indexValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'pri_id.required' => '参数错误',
            'pri_id.integer' => '数据类型不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'pri_id' => 'required|integer'
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 单量验证器
    public function billNumberValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'wobi_id.required' => '参数错误',
            'wobi_id.integer' => '数据类型不正确',
            'wobi_id.min' => '参数错误',
            'type.required' => '参数错误',
            'type.in' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'wobi_id' => 'required|integer|min:1',
            'type' => [
                    'required',
                     Rule::in(['1', '2']),
                ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 结款获取数据验证器
    public function getInfoValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'wobi_id.required' => '参数错误',
            'wobi_id.integer' => '数据类型不正确',
            'wobi_id.min' => '参数错误',
            'type.required' => '参数错误',
            'type.in' => '参数错误'
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'wobi_id' => 'required|integer|min:1', //账单id
            'type' => [ //1.获取数据 2.提交数据
                    'required',
                     Rule::in(['1', '2']),
                ]
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 结款提交验证器
    public function settleAccountsValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'wobi_id.required' => '参数错误',
            'wobi_id.integer' => '数据类型不正确',
            'wobi_id.min' => '参数错误',
            'type.required' => '参数错误',
            'type.in' => '参数错误',
            'wobi_payment_way.required' => '请选择结款方式', 
            'wobi_payment_way.in' => '参数错误',
            'wobi_payment_type.required' => '请选择结款类型',
            'wobi_payment_type.in' => '参数错误',
            'zero_price.required_if' => '请输入抹零金额',
            'zero_price.numeric' => '参数错误',
            'zero_price.min' => '参数错误',
            'recr_actual_price.required_if' => '参数错误',
            'recr_actual_price.numeric' => '参数错误',
            'recr_actual_price.min' => '参数错误',
            'recr_id.required_if' => '请选择预收款',
            'recr_id.integer' => '参数错误',
            'recr_id.min' => '参数错误',
            'acti_id.required' => '请选择会计科目',
            'acti_id.integer' => '参数错误',
            'acti_id.min' => '参数错误',
            'wobi_actual_price.required' => '请输入实收金额',
            'wobi_actual_price.numeric' => '参数错误',
            'wobi_actual_price.min' => '参数错误',
            'wobi_remark.sometimes' => '参数错误',
            'wobi_remark.max' => '备注长度超过最大限制',
            'wobi_img.required' => '请上传结算凭证',
            'wobi_img.array' => '参数错误',
            'wobi_client_id.required' => '参数错误',
            'wobi_client_id.integer' => '参数错误',
            'wobi_client_id.min' => '参数错误',
            'wobi_type.required' => '客户类型',
            'wobi_type.in' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'wobi_id' => 'required|integer|min:1', //账单id
            'type' => [ //1.获取数据 2.提交数据
                    'required',
                     Rule::in(['1', '2']),
                ],
            'wobi_payment_way' => [ //结算方式 2.现结 3微信 4支付宝
                    'required',
                     Rule::in(['2', '3', '4']),
                ],
            'wobi_payment_type' => [ //结算类型1.抹零 2.分期结款 3.预收款抵账
                    'required',
                     Rule::in(['1', '2', '3']),
                ],
            'zero_price' => 'required_if:wobi_payment_type,1|numeric|min:0', //抹零金额
            'recr_id' => 'required_if:wobi_payment_type,3|integer|min:1', // 预收款id
            'recr_actual_price' => 'required_if:wobi_payment_type,3|numeric|min:0', // 预收款钱数
            'acti_id' => 'required|integer|min:1', //会计科目id
            'wobi_actual_price' => 'required|numeric|min:0', //实收金额
            'wobi_remark' => 'sometimes|max:255', //备注
            'wobi_img' => 'required|array', //结算凭证
            'wobi_client_id' => 'required|integer|min:1', // 会员/来往单位id
            'wobi_type' => [ //客户类型：1.门店零售 2.来往单位
                    'required',
                     Rule::in(['1', '2','3']),
                ], // 客户类型 1.门店零售 2.来往单位3.加盟店
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 删除验证器
    public function delValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'wobi_id.required' => '参数错误',
            'wobi_id.integer' => '数据类型不正确',
            'wobi_id.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'wobi_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 审核验证器
    public function auditValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'wobi_id.required' => '参数错误',
            'wobi_id.integer' => '数据类型不正确',
            'wobi_id.min' => '参数错误',
            'type.required' => '参数错误',
            'type.in' => '参数错误',
            'wobi_state.required_if' => '参数错误',
            'wobi_state.in' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'wobi_id' => 'required|integer|min:1',
            'type' => [
                    'required',
                     Rule::in(['1', '2']),
                ],
            'wobi_state' => [
                    'required_if:type,2',
                     Rule::in(['1', '4']), //同意：1 驳回：4
                ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 编辑验证器
    public function editValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'wobi_id.required' => '参数错误',
            'wobi_id.integer' => '数据类型不正确',
            'wobi_id.min' => '参数错误',
            'wobi_number.required' => '参数错误',
            'wobi_number.max' => '参数错误',
            'wor_id.required' => '参数错误',
            'wor_id.array' => '数据类型不正确'
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'wobi_id' => 'required|integer|min:1',
            'wobi_number' => 'required|max:20',
            'wor_id' => 'required|array',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }
}
