<?php

namespace App\Http\Controllers\Api\Verify\AccountManage;

use Validator;
use App\Http\Requests;
use Illuminate\Http\Request;
use Illuminate\Validation\Rule;
use App\Http\Controllers\Controller;

class VerifySellBillController extends Controller
{
    // 列表验证器
    public function indexValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'pri_id.required' => '参数错误',
            'pri_id.integer' => '数据类型不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'pri_id' => 'required|integer'
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 单量验证器
    public function billNumberValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'sebi_id.required' => '参数错误',
            'sebi_id.integer' => '数据类型不正确',
            'sebi_id.min' => '参数错误',
            'type.required' => '参数错误',
            'type.in' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'sebi_id' => 'required|integer|min:1',
            'type' => [
                    'required',
                     Rule::in(['1', '2']),
                ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 结款获取数据验证器
    public function getInfoValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'sebi_id.required' => '参数错误',
            'sebi_id.integer' => '数据类型不正确',
            'sebi_id.min' => '参数错误',
            'type.required' => '参数错误',
            'type.in' => '参数错误'
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'sebi_id' => 'required|integer|min:1', //账单id
            'type' => [ //1.获取数据 2.提交数据
                    'required',
                     Rule::in(['1', '2']),
                ]
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 结款提交验证器
    public function settleAccountsValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'sebi_id.required' => '参数错误',
            'sebi_id.integer' => '数据类型不正确',
            'sebi_id.min' => '参数错误',
            'type.required' => '参数错误',
            'type.in' => '参数错误',
            'sebi_payment_type.required' => '请选择结款类型',
            'sebi_payment_type.in' => '参数错误',
            'acti_id.required_unless' => '请选择会计科目',
            'acti_id.integer' => '参数错误',
            'acti_id.min' => '参数错误',
            'sebi_actual_price.required' => '请输入实收金额',
            'sebi_actual_price.numeric' => '参数错误',
            'sebi_actual_price.min' => '参数错误',
            'zero_price.required_if' => '请输入抹零金额',
            'zero_price.numeric' => '参数错误',
            'zero_price.min' => '参数错误',
            'sebi_remark.sometimes' => '参数错误',
            'sebi_remark.max' => '备注长度超过最大限制',
            'sebi_img.required_unless' => '请上传结算凭证',
            'sebi_img.array' => '参数错误',
            'sebi_client_id.required' => '参数错误',
            'sebi_client_id.integer' => '参数错误',
            'sebi_client_id.min' => '参数错误',
            'sebi_type.required' => '客户类型',
            'sebi_type.in' => '参数错误',
            'recr_actual_price.required_if' => '参数错误',
            'recr_actual_price.numeric' => '参数错误',
            'recr_actual_price.min' => '参数错误',
            'recr_id.required_if' => '请选择预收款',
            'recr_id.integer' => '参数错误',
            'recr_id.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'sebi_id' => 'required|integer|min:1', //账单id
            'type' => [ //1.获取数据 2.提交数据
                    'required',
                     Rule::in(['1', '2']),
                ],
            'sebi_payment_type' => [ //结算类型1.抹零 2.分期结款 3.预收款抵账 4正常
                    'required',
                     Rule::in(['1', '2', '3', '4']),
                ],
            'acti_id' => 'required_unless:sebi_payment_type,3|integer|min:1', //会计科目id
            'sebi_actual_price' => 'required|numeric|min:0', //实收金额
            'zero_price' => 'required_if:sebi_payment_type,1|numeric|min:0', //抹零金额
            'sebi_remark' => 'sometimes|max:255', //备注
            'sebi_img' => 'required_unless:sebi_payment_type,3|array', //结款凭证
            'sebi_type' => [ //客户类型：1.门店零售 2.来往单位
                    'required',
                     Rule::in(['1', '2']),
                ], // 客户类型 1.门店零售 2.来往单位
            'sebi_client_id' => 'required|integer|min:1', // 会员/来往单位id
            'recr_id' => 'required_if:sebi_payment_type,3|integer|min:1', // 预收款id
            'recr_actual_price' => 'required_if:sebi_payment_type,3|numeric|min:0', // 预收款钱数            
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 审核验证器
    public function auditValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'sebi_id.required' => '参数错误',
            'sebi_id.integer' => '数据类型不正确',
            'sebi_id.min' => '参数错误',
            'type.required' => '参数错误',
            'type.in' => '参数错误',
            'sebi_state.required_if' => '参数错误',
            'sebi_state.in' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'sebi_id' => 'required|integer|min:1',
            'type' => [
                    'required',
                     Rule::in(['1', '2']),
                ],
            'sebi_state' => [
                    'required_if:type,2',
                     Rule::in(['1', '4']), //同意：1 驳回：4
                ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 删除验证器
    public function delValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'sebi_id.required' => '参数错误',
            'sebi_id.integer' => '数据类型不正确',
            'sebi_id.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'sebi_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 编辑验证器
    public function editValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'sebi_id.required' => '参数错误',
            'sebi_id.integer' => '数据类型不正确',
            'sebi_id.min' => '参数错误',
            'sebi_number.required' => '参数错误',
            'sebi_number.max' => '参数错误',
            'sell_id.required' => '参数错误',
            'sell_id.array' => '数据类型不正确'
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'sebi_id' => 'required|integer|min:1',
            'sebi_number' => 'required|max:20',
            'sell_id' => 'required|array',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }
}
