<?php

namespace App\Http\Controllers\Api\Verify\AccountControl;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Validator;
use Illuminate\Validation\Rule;

class VerifyStockSellStorageGoodsController extends Controller
{
	    // 列表验证器
    public function indexValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'pri_id.required' => '请输入权限id',
            'pri_id.integer' => '数据类型不正确',
            'pri_id.min' => '数据类型不正确',
            'sssg_ware_id.required' => '请输入权限id',
            'sssg_ware_id.integer' => '数据类型不正确',
            'sssg_ware_id.min' => '数据类型不正确',
            'sssg_waon_class.required' => '请输入权限id',
            'sssg_waon_class.integer' => '数据类型不正确',
            'sssg_waon_class.min' => '数据类型不正确',
            'sssg_year.integer' => '数据类型不正确',
            'sssg_year.min' => '数据类型不正确',
            // 'sssg_month.integer' => '数据类型不正确',
            // 'sssg_month.min' => '数据类型不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'pri_id' => 'required|integer|min:0',
            'sssg_ware_id' => 'required|integer|min:1',
            'sssg_waon_class' => 'required|integer|min:1',
            'sssg_year' => 'sometimes|integer|min:0',
            // 'sssg_month' => 'sometimes|integer|min:0',
            // 'goo_goods_encode' => 'sometimes|integer|min:1',
            // 'goo_name' => 'sometimes|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }
}
