<?php

namespace App\Http\Controllers\Api\Verify\AccountControl;

use Validator;
use App\Http\Requests;
use Illuminate\Http\Request;
use Illuminate\Validation\Rule;
use App\Http\Controllers\Controller;

class VerifyReceivableBillController extends Controller
{
    // 列表验证器
    public function indexValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'pri_id.required' => '参数错误',
            'pri_id.integer' => '数据类型不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'pri_id' => 'required|integer'
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 预收款验证器
    public function advanceMoneyValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'type.required' => '参数错误',
            'type.in' => '参数错误',
            'recr_original_number.required_if' => '参数错误',
            'recr_original_number.size' => '参数错误',
            'recr_client_id.required_if' => '请选择客户单位',
            'recr_client_id.integer' => '参数错误',
            'recr_client_id.min' => '参数错误',
            'recr_client_name.required_if' => '请选择客户单位',
            'recr_client_name.max' => '参数错误',
            'recr_settle_time.required_if' => '请选择结款时间',
            'recr_settle_time.date' => '参数错误',
            'recr_settle_id.required_if' => '请选择结款人',
            'recr_settle_id.integer' => '参数错误',
            'recr_settle_id.min' => '参数错误',
            'recr_actual_price.required_if' => '请输入金额',
            'recr_actual_price.numeric' => '参数错误',
            'recr_actual_price.min' => '参数错误',
            'recr_acti_id.required_if' => '请选择会计科目',
            'recr_acti_id.integer' => '参数错误',
            'recr_acti_id.min' => '参数错误',
            'recr_abort_time.required_if' => '请输入截止时间',
            'recr_abort_time.date' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'type' => [ //1.获取单号 2.提交数据
                    'required',
                     Rule::in(['1', '2']),
                ],
            'recr_original_number' => 'required_if:type,2|size:20',
            'recr_client_id' => 'required_if:type,2|integer|min:1',
            'recr_client_name' => 'required_if:type,2|max:20',
            'recr_settle_time' => 'required_if:type,2|date',
            'recr_settle_id' => 'required_if:type,2|integer|min:1',
            'recr_actual_price' => 'required_if:type,2|numeric|min:0',
            'recr_acti_id' => 'required_if:type,2|integer|min:1',
            'recr_abort_time' => 'required_if:type,2|date',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 详情验证器
    public function detailsValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'recr_id.required' => '参数错误',
            'recr_id.integer' => '参数错误',
            'recr_id.min' => '参数错误',
            'type.required' => '参数错误',
            'type.in' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'recr_id' => 'required|integer|min:1',
            'type' => [ //1.获取单号 2.提交数据
                    'required',
                     Rule::in(['1', '2']),
                ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 编辑预收款时间验证器
    public function editTimeValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'recr_id.required' => '参数错误',
            'recr_id.integer' => '参数错误',
            'recr_id.min' => '参数错误',
            'recr_abort_time.required' => '请输入截止时间',
            'recr_abort_time.date' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'recr_id' => 'required|integer|min:1',
            'recr_abort_time' => 'required|date',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 应收账款详情列表验证器
    public function particularsValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'recr_original_id.required' => '参数错误',
            'recr_id.required' => '参数错误',
            'recr_original_id.integer' => '数据类型不正确',
            'recr_id.integer' => '数据类型不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'recr_original_id' => 'required|integer',
            'recr_id' => 'required|integer',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 收款  还款验证器
    public function leisurelyValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'recr_id.required' => '参数错误',
            'recr_id.integer' => '数据类型不正确',
            'acti_id.required' => '参数错误',
            'acti_id.integer' => '数据类型不正确',
            'type.required' => '参数错误',
            'type.in' => '数据类型不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'recr_id' => 'required|integer',
            'acti_id' => 'required|integer',
            'type' => [ //1.收款 2.还款
                    'required',
                     Rule::in(['1', '2']),
                ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 非实物开单验证器
    public function nonphysicalValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'recr_client_id.required' => '请输入客户id',
            'recr_client_id.integer' => '客户id数据类型不正确',
            'recr_client_id.min' => '数据类型不正确',
            'recr_client_type.required' => '请选择客户类型',
            'recr_client_type.in' => '客户类型数据不正确',
            'recr_client_name.required' => '请选择客户姓名',
            'recr_client_name.min' => '客户姓名小于最小长度',
            'recr_client_name.max' => '客户姓名超出最大长度',

            'recr_acti_id.required' => '请选择会计科目',
            'recr_acti_id.integer' => '会计科目数据类型不正确',
            'recr_acti_id.min' => '会计科目数据类型不正确',
            'recr_settle_price.required' => '请输入结算金额',
            'recr_settle_price.numeric' => '结算金额数据类型不正确',
            'recr_settle_price.min' => '结算金额数据类型不正确',
            'recr_plus_minus.required' => '请选择金额正负',
            'recr_plus_minus.in' => '金额正负数据不正确',
            'recr_settle_time.required' => '请选择结款时间',
            'recr_settle_time.date' => '结款时间数据不正确',
            'recr_account_type.required' => '请选择显示类型',
            'recr_account_type.in' => '显示类型数据不正确',
            'recr_remark.max' => '请输入备注',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'recr_client_id' => 'required|integer|min:1',
            'recr_client_type' => [ //客户类型：1.会员零售 2.来往单位 3.加盟店 4会员零售(工单代收）
                    'required',
                     Rule::in(['1', '2', '3', '4']),
                ],
            'recr_client_name' => 'required|min:1|max:50',
            // 'recr_acti_id' => 'required|integer|min:0',
            // 'recr_settle_price' => 'required|numeric|min:0',
            // 'recr_plus_minus' => [ //金额正负：1正值2负值
            //         'required',
            //          Rule::in(['0', '1', '2']),
            //     ],
            'recr_settle_time' => 'required|date',
            'recr_account_type' => [ //显示类型： 11发票 12价外费 13折扣金额抵货款
                    'required',
                     Rule::in(['11', '12', '13']),
                ],
            'recr_remark' => 'sometimes|max:255',//备注
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 冲红搜索验证器
    public function showAgainstBillValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'type.required' => '参数错误',
            'type.in' => '数据类型不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'type' => [ //1.收款 2.还款
                    'required',
                     Rule::in(['1', '2']),
                ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 冲红提交验证器
    public function againstBillValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'recr_id.required' => '参数错误',
            'recr_id.array' => '数据类型不正确',
            'recr_client_type.required' => '参数错误',
            'recr_client_type.integer' => '参数错误',
            'recr_client_type.min' => '参数错误',
            'recr_client_id.required' => '参数错误',
            'recr_client_id.integer' => '参数错误',
            'recr_client_name.required' => '参数错误',
            'recr_client_name.max' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'recr_id' => 'required|array',
            'recr_client_type' => 'required|integer|min:1',
            'recr_client_id' => 'required|integer|min:1',
            'recr_client_name' => 'required|max:50',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 预付款验证器
    public function prepaymentValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'type.required' => '参数错误',
            'type.in' => '参数错误',
            'recr_original_number.required_if' => '参数错误',
            'recr_original_number.size' => '参数错误',
            'recr_client_id.required_if' => '请选择客户单位',
            'recr_client_id.integer' => '参数错误',
            'recr_client_id.min' => '参数错误',
            'recr_client_name.required_if' => '请选择客户单位',
            'recr_client_name.max' => '参数错误',
            'recr_settle_time.required_if' => '请选择结款时间',
            'recr_settle_time.date' => '参数错误',
            'recr_settle_id.required_if' => '请选择结款人',
            'recr_settle_id.integer' => '参数错误',
            'recr_settle_id.min' => '参数错误',
            'recr_actual_price.required_if' => '请输入金额',
            'recr_actual_price.numeric' => '参数错误',
            'recr_actual_price.min' => '参数错误',
            'recr_acti_id.required_if' => '请选择会计科目',
            'recr_acti_id.integer' => '参数错误',
            'recr_acti_id.min' => '参数错误',
            'recr_abort_time.required_if' => '请输入截止时间',
            'recr_abort_time.date' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'type' => [ //1.获取单号 2.提交数据
                'required',
                    Rule::in(['1', '2']),
            ],
            'recr_original_number' => 'required_if:type,2|size:20',
            'recr_client_id' => 'required_if:type,2|integer|min:1',
            'recr_client_name' => 'required_if:type,2|max:20',
            'recr_settle_time' => 'required_if:type,2|date',
            'recr_settle_id' => 'required_if:type,2|integer|min:1',
            'recr_actual_price' => 'required_if:type,2|numeric|min:0',
            'recr_acti_id' => 'required_if:type,2|integer|min:1',
            'recr_abort_time' => 'required_if:type,2|date',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }
}
