<?php

namespace App\Http\Controllers\Api\Verify\AccountControl;

use Validator;
use App\Http\Requests;
use Illuminate\Http\Request;
use Illuminate\Validation\Rule;
use App\Http\Controllers\Controller;

class VerifyPaymentBillController extends Controller
{
    // 列表验证器
    public function indexValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'pri_id.required' => '参数错误',
            'pri_id.integer' => '数据类型不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'pri_id' => 'required|integer'
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 预收款验证器
    public function paymentMoneyValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'type.required' => '参数错误',
            'type.in' => '参数错误',
            'acpa_original_number.required_if' => '参数错误',
            'acpa_original_number.size' => '参数错误',
            'acpa_client_id.required_if' => '请选择客户单位',
            'acpa_client_id.integer' => '参数错误',
            'acpa_client_id.min' => '参数错误',
            'acpa_client_name.required_if' => '请选择客户单位',
            'acpa_client_name.max' => '参数错误',
            'acpa_settle_time.required_if' => '请选择结款时间',
            'acpa_settle_time.date' => '参数错误',
            'acpa_settle_id.required_if' => '请选择结款人',
            'acpa_settle_id.integer' => '参数错误',
            'acpa_settle_id.min' => '参数错误',
            'acpa_actual_price.required_if' => '请输入金额',
            'acpa_actual_price.numeric' => '参数错误',
            'acpa_actual_price.min' => '参数错误',
            'acpa_acti_id.required_if' => '请选择会计科目',
            'acpa_acti_id.integer' => '参数错误',
            'acpa_acti_id.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'type' => [ //1.获取单号 2.提交数据
                    'required',
                     Rule::in(['1', '2']),
                ],
            'acpa_original_number' => 'required_if:type,2|size:20',
            'acpa_client_id' => 'required_if:type,2|integer|min:1',
            'acpa_client_name' => 'required_if:type,2|max:20',
            'acpa_settle_time' => 'required_if:type,2|date',
            'acpa_settle_id' => 'required_if:type,2|integer|min:1',
            'acpa_actual_price' => 'required_if:type,2|numeric|min:0',
            'acpa_acti_id' => 'required_if:type,2|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 详情验证器
    public function detailsValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'acpa_id.required' => '参数错误',
            'acpa_id.integer' => '参数错误',
            'acpa_id.min' => '参数错误',
            'type.required' => '参数错误',
            'type.in' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'acpa_id' => 'required|integer|min:1',
            'type' => [ //1.获取单号 2.提交数据
                    'required',
                     Rule::in(['1', '2']),
                ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

        // 列表验证器
    public function particularsValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'acpa_original_id.required' => '参数错误',
            'acpa_original_id.integer' => '数据类型不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'acpa_original_id' => 'required|integer'
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }
}
