<?php

namespace App\Http\Controllers\Api\Verify\AccountControl;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Validator;
use Illuminate\Validation\Rule;

class VerifyAccountSubjectController extends Controller
{
    // 列表验证器
    public function indexValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'pri_id.required' => '参数错误',
            'pri_id.integer' => '数据类型不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'pri_id' => 'required|integer'
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 详情验证器
    public function infoValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'acsu_id.required' => '参数错误',
            'acsu_id.integer' => '数据类型不正确',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'acsu_id' => 'required|integer'
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 新增验证器
    public function addValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'subjname.required' => '参数错误',
            'subjname.max' => '科目名称超过最大限制',
            'subjcode.required' => '参数错误',
            'subjcode.max' => '科目编码超过最大限制',
            'engsubjname.max' => '英文名称超过最大限制',
            'balanorient.required' => '参数错误',
            'balanorient.in' => '科目方向参数错误',
            'incurflag.required' => '参数错误',
            'incurflag.in' => '参数错误',
            'balanflag.required' => '参数错误',
            'balanflag.in' => '参数错误',
            'bothorient.required' => '参数错误',
            'bothorient.in' => '参数错误',
            'innersubj.required' => '参数错误',
            'innersubj.in' => '参数错误',
            'accremove.required' => '参数错误',
            'accremove.in' => '参数错误',
            'outflag.required' => '参数错误',
            'outflag.in' => '参数错误',
            'cashbankflag.required' => '参数错误',
            'cashbankflag.in' => '参数错误',
            'sumprint_level.required' => '请选择汇总打印级次',
            'sumprint_level.integer' => '汇总打印级次参数错误',
            'typeindex.required' => '请选择科目类型',
            'typeindex.integer' => '科目类型参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'subjname' => 'required|max:200',
            'subjcode' => 'required|max:40',
            'engsubjname' => 'sometimes|max:100',
            'balanorient' => [ //科目方向 1:借2:贷【余额方向】
                    'required',
                     Rule::in(['1', '2']),
                ],
            'incurflag' => [ //发生额方向控制取值：Y：是/N：否
                    'required',
                     Rule::in(['Y', 'N']),
                ],
            'balanflag' => [ //余额方向控制取值：Y：是/N：否
                    'required',
                     Rule::in(['Y', 'N']),
                ],
            'bothorient' => [ //帐簿余额双向显示取值：Y：是/N：否
                    'required',
                     Rule::in(['Y', 'N']),
                ],
            'innersubj' => [ //内部交易科目取值：Y：是/N：否
                    'required',
                     Rule::in(['Y', 'N']),
                ],
            'accremove' => [ //是否核销科目取值：Y：是/N：否
                    'required',
                     Rule::in(['Y', 'N']),
                ],
            'outflag' => [ //表外科目取值：Y：是/N：否
                    'required',
                     Rule::in(['Y', 'N']),
                ],
            'cashbankflag' => [ //现金银行科目 0:其他1:现金科目2:银行科目3:现金等价物
                    'required',
                     Rule::in(['0', '1', '2', '3']),
                ],
            'sumprint_level' => 'required|integer',
            'typeindex' => 'required|integer',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }
}
