<?php
namespace App\Http\Controllers\Api\SystemsManage;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Controllers\Api\Verify\SystemsManage\VerifySystemLogController;
use Illuminate\Support\Facades\DB;
use App\Http\Models\Api\Common;

class SystemLogController extends Controller
{
    // 列表每页显示数据个数
    protected $show_count = 10;

    // 列表
    public function index(Request $request)
    {
        // 验证数据
        // $verify_data = new VerifySystemLogController;
        // $error_message = $verify_data->indexValidator($request->all());
        // if ($error_message) {
        //     return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        // }
        
        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);

        $search_data = $request->all();
        $page_size = $request['show_count'] ? $request['show_count'] : 10;
        $list_data = DB::table('operation_log')
                    ->where('oplo_cid', $user_info->adm_cid)
                    ->where('oplo_shop_id', $user_info->adm_shop_id)
                    ->where(function ($query) use ($search_data) {
                        if (!empty($search_data['oplo_adm_name'])) {
                            $query->where('oplo_adm_name', 'like', '%'.$search_data['oplo_adm_name'].'%');
                        }
                    })
                    ->where(function ($query) use ($search_data) {
                        if (!empty($search_data['oplo_module'])) {
                            $query->where('oplo_module', 'like', '%'.$search_data['oplo_module'].'%');
                        }
                    })
                    ->where(function ($query) use ($search_data) {
                        if (!empty($search_data['oplo_action'])) {
                            $query->where('oplo_action', 'like', '%'.$search_data['oplo_action'].'%');
                        }
                    })
                    ->where(function ($query) use ($search_data) {
                        if (!empty($search_data['oplo_content'])) {
                            $query->where('oplo_content', 'like', '%'.$search_data['oplo_content'].'%');
                        }
                    })
                    ->where(function ($query) use ($search_data) {
                        //如果选择开始时间并且选择结束时间
                        if (!empty($search_data['oplo_create_time_start']) && !empty($search_data['oplo_create_time_end'])) {
                            $query->whereBetween('oplo_create_time', [$search_data['oplo_create_time_start'], $search_data['oplo_create_time_end'].' 23:59:59']);
                        } else {
                            // 如果选择开始时间
                            if (!empty($search_data['oplo_create_time_start'])) {
                                $query->where('oplo_create_time', '>=', $search_data['oplo_create_time_start']);
                            } else {
                                // 如果选择结束时间
                                if (!empty($search_data['oplo_create_time_end'])) {
                                    $query->where('oplo_create_time', '<=', $search_data['oplo_create_time_end'].' 23:59:59');
                                }
                            }
                        }
                    })
                    ->orderBy('oplo_id', 'desc')
                    ->select('oplo_adm_name', 'oplo_module', 'oplo_action', 'oplo_content', 'oplo_ip', 'oplo_create_time')
                    ->paginate($page_size);

        $data_info['current_page'] = $list_data->currentPage();  //当前页面页码
        $data_info['last_page'] = $list_data->lastPage();        //表示最后一页的页码
        $data_info['total'] = $list_data->total();               //总数据个数
        $data_info['current_number'] = $page_size;       //一页显示多少个
        $data_info['data'] = $list_data->items();                //返回数据

        if ($list_data) {
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$data_info]);
        } else {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'暂无数据']);
        }
    }
}
