<?php

namespace App\Http\Controllers\Api\SystemsManage;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Controllers\Api\Verify\SystemsManage\VerifyShoprCarController;
use Illuminate\Support\Facades\DB;
use App\Http\Models\Api\Common;

class ShoprCarController extends Controller
{
    // 列表每页显示数据个数
    protected $show_count = 10;

    // 列表
    public function index(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyShoprCarController;
        $error_message = $verify_data->indexValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }

        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);

        $search_data = $request->all();
        $list_data = DB::table('shop_car as a')
        	            ->leftJoin('warehouse as b', 'b.ware_id', '=', 'a.shca_ware_id')
                        ->where('shca_cid', $user_info->adm_cid)
                        ->where('shca_shop_id', $user_info->adm_shop_id)
                        ->where(function($query) use($search_data) {
                            if (!empty($search_data['shca_car_num'])) {
                                $query->where('shca_car_num', 'like', $search_data['shca_car_num'].'%' );
                            }
                        })
                        ->where(function($query) use($search_data) {
                            if (!empty($search_data['shca_car_series'])) {
                                $query->where('shca_car_series', 'like', $search_data['shca_car_series'].'%' );
                            }
                        })
                        ->where(function($query) use($search_data) {
                            if (!empty($search_data['shca_car_model'])) {
                                $query->where('shca_car_model', 'like', $search_data['shca_car_model'].'%' );
                            }
                        })
                        ->where(function($query) use($search_data) {
                            if (!empty($search_data['ware_name'])) {
                                $query->where('ware_name', 'like', $search_data['ware_name'].'%' );
                            }
                        })
                        ->where(function($query) use($search_data) {
                            if (!empty($search_data['shca_insure_time'])) {
                                $query->where('shca_insure_time', 'like', $search_data['shca_insure_time'].'%' );
                            }
                        })
                        ->select('shca_id', 'ware_name', 'shca_car_num', 'shca_car_series', 'shca_car_model', 
                            'shca_insure_time')
                        ->orderBy('shca_id', 'desc')
                        ->paginate($this->show_count);

        $list_items = $list_data->items();         
        if ($list_items) {
            foreach ($list_items as $key => $value) {
                if ($value->shca_insure_time == '0000-00-00') {
                    $value->shca_insure_time = ''; 
                }
            }
        }
        $data_info['current_page'] = $list_data->currentPage();  //当前页面页码
        $data_info['last_page'] = $list_data->lastPage();        //表示最后一页的页码
        $data_info['total'] = $list_data->total();               //总数据个数
        $data_info['current_number'] = $this->show_count;       //一页显示多少个
        $data_info['data'] = $list_items;                //返回数据

        // 获取当前列表下的按钮
        $list_button = getListButton($request['api_token'], $request['pri_id']);
        if($list_data) {
            return response()->json(['code'=> 200,'msg'=>'success','data'=>$data_info, 'list_button'=>$list_button]);
        }else{
            return response()->json(['code'=> 500,'msg'=>'error','data'=>'暂无数据']);
        }
    }

    // 新增
    public function add(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyShoprCarController;
        $error_message = $verify_data->addValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }

        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);

        // 1. 判断车牌号是否存在
        $find_meca = DB::table('shop_car')
                    ->where('shca_cid', $user_info->adm_cid)
                    ->where('shca_shop_id', $user_info->adm_shop_id)
                    ->where('shca_car_num', $request['shca_car_num'])
                    ->first(['shca_id']);
        if ($find_meca) {
            return response()->json(["code"=>500,'msg'=>'error','data'=>'该车牌号已存在']);
        }

        // 2 新增一个车牌号
        $shca_add_data['shca_cid'] = $user_info->adm_cid;
        $shca_add_data['shca_shop_id'] = $user_info->adm_shop_id;
        $shca_add_data['shca_create_adm_id'] = $user_info->adm_id;
        $shca_add_data['shca_car_num'] = $request['shca_car_num'];
        $shca_add_data['shca_car_series'] = $request['shca_car_series'] ? $request['shca_car_series'] : '';
        $shca_add_data['shca_car_model'] = $request['shca_car_model'] ? $request['shca_car_model'] : '';
        $shca_add_data['shca_insure_time'] = $request['shca_insure_time'] ? $request['shca_insure_time'] : '';
        $shca_add_data['shca_insure_company'] = $request['shca_insure_company'] ? $request['shca_insure_company'] : '';
        $shca_add_data['shca_year'] = $request['shca_year'] ? $request['shca_year'] : '';
        $shca_add_data['shca_car_frame'] = $request['shca_car_frame'] ? $request['shca_car_frame'] : '';
        $shca_res =  DB::table('shop_car')->insert($shca_add_data);
        if ($shca_res) {
            Common::addLog($user_info, getRealIp($request), '门店车辆','新增','新增车辆：'.$request['shca_car_num'].'成功');
            return response()->json(["code"=>200,'msg'=>'success','data'=>'新增车辆成功']);
        }else{
            return response()->json(["code"=>500,'msg'=>'error','data'=>'新增车辆失败']);
        }
    }

    // 编辑
    public function edit(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyShoprCarController;
        $error_message = $verify_data->editShowValidator($request->all()); //验证编辑id是否存在
        if ($error_message) {
            return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }

        if ($request['type'] == 1) {
        	// 查询车辆信息
    		$find_meca = DB::table('shop_car')
                    ->where('shca_id', $request['shca_id'])
                    ->select('shca_car_num', 'shca_car_series', 'shca_car_model', 'shca_insure_time', 
                    'shca_insure_company',  'shca_year', 'shca_car_frame')
                    ->first();
            if ($find_meca->shca_insure_time == '0000-00-00') {
                $find_meca->shca_insure_time = ''; 
            }
            return response()->json(['code'=> 200, 'msg'=>'success', 'data'=>$find_meca]);
        }

        $error_message = $verify_data->addValidator($request->all()); //验证除编辑id外的参数是否存在
        if ($error_message) {
            return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }

        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);

        // 1. 判断车牌号是否存在
        $find_meca = DB::table('shop_car')
                        ->where('shca_cid', $user_info->adm_cid)
                    	->where('shca_shop_id', $user_info->adm_shop_id)
                        ->where('shca_id', '<>', $request['shca_id'])
                    	->where('shca_car_num', $request['shca_car_num'])
                        ->first(['shca_id']);
        if ($find_meca) {
            return response()->json(["code"=>500,'msg'=>'error','data'=>'该车牌号已存在']);
        }

        // 2 编辑车牌号
        $shca_edit_data['shca_car_num'] = $request['shca_car_num'];
        $shca_edit_data['shca_car_series'] = $request['shca_car_series'] ? $request['shca_car_series'] : '';
        $shca_edit_data['shca_car_model'] = $request['shca_car_model'] ? $request['shca_car_model'] : '';
        $shca_edit_data['shca_insure_time'] = $request['shca_insure_time'] ? $request['shca_insure_time'] : '';
        $shca_edit_data['shca_insure_company'] = $request['shca_insure_company'] ? $request['shca_insure_company'] : '';
        $shca_edit_data['shca_year'] = $request['shca_year'] ? $request['shca_year'] : '';
        $shca_edit_data['shca_car_frame'] = $request['shca_car_frame'] ? $request['shca_car_frame'] : '';
        $shca_edit_data['shca_update_time'] = date('Y-m-d H:i:s');
        $shca_res = DB::table('shop_car')
                    ->where('shca_id', $request['shca_id'])
                    ->update($shca_edit_data);
        if ($shca_res) {
            Common::addLog($user_info, getRealIp($request), '门店车辆','编辑','编辑车辆：'.$request['shca_car_num'].'成功');
            return response()->json(["code"=>200,'msg'=>'success','data'=>'编辑车辆成功']);
        }else{
            return response()->json(["code"=>500,'msg'=>'error','data'=>'编辑车辆失败']);
        }
    }

    // 详情
    public function info(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyShoprCarController;
        $error_message = $verify_data->infoValidator($request->all()); //验证编辑id是否存在
        if ($error_message) {
            return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }
    	// 查询车辆信息
    	$find_meca = DB::table('shop_car as a')
        	        ->leftJoin('warehouse as b', 'b.ware_id', '=', 'a.shca_ware_id')
                    ->where('shca_id', $request['shca_id'])
                    ->select('shca_car_num', 'shca_car_series', 'shca_car_model', 'shca_insure_time', 
                    'shca_insure_company',  'shca_year', 'shca_car_frame', 'ware_name')
                    ->first();
        if ($find_meca->shca_insure_time == '0000-00-00') {
            $find_meca->shca_insure_time = '';
        }
        return response()->json(['code'=> 200, 'msg'=>'success', 'data'=>$find_meca]);
    }

    // 删除
    public function delete(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyShoprCarController;
        $error_message = $verify_data->deleteValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }

        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);

        // 查询信息
        $find_shca = DB::table('shop_car')
                    ->whereIn('shca_id',$request['shca_id'])
                    ->select('shca_car_num')
                    ->get();
        foreach ($find_shca as $key => $value) {
            $shca_car_num[] = $value->shca_car_num;
        }

        $shca_res = DB::table('shop_car')
                    ->whereIn('shca_id', $request['shca_id'])
                    ->delete();
        if($shca_res) {
            Common::addLog($user_info, getRealIp($request), '门店车辆','删除','车辆：（'.implode(',', $shca_car_num).'）删除成功');
            return response()->json(["code"=>200,'msg'=>'success','data'=>'删除成功']);
        }else{
            return response()->json(["code"=>500,'msg'=>'error','data'=>'删除失败']);
        }
    }

    // 搜索车辆
    public function searchShopCar(Request $request)
    {
        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);

        $search_data = $request->all();
        // 查询信息
        $find_shca = DB::table('shop_car')
                    ->where('shca_cid', $user_info->adm_cid)
                    ->where('shca_shop_id', $user_info->adm_shop_id)
                    ->where('shca_ware_id', 0)
                    ->where(function($query) use($search_data) {
                        if (!empty($search_data['shca_car_num'])) {
                            $query->where('shca_car_num', 'like', $search_data['search_data'].'%' );
                        }
                    })
                    ->select('shca_id', 'shca_car_num')
                    ->get();
        return response()->json(["code"=>200,'msg'=>'success','data'=>$find_shca]);
    }
}
