<?php

namespace App\Http\Controllers\Api\SystemsManage;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Controllers\Api\Verify\SystemsManage\VerifyLoginEquipmentController;
use Illuminate\Support\Facades\DB;
use App\Http\Models\Api\Common;

class LoginEquipmentController extends Controller
{
	// 列表每页显示数据个数
    protected $show_count = 10;

    // 列表
	public function index(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyLoginEquipmentController;
        $error_message = $verify_data->indexValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }
        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);
        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;

        $search_data = $request->all();
        $list_data = DB::table('login_device as lode')
            ->leftjoin('admin as adm','adm.adm_id','=','lode.lode_adm_id')
            ->leftjoin('shop as s','s.shop_id','=','lode.lode_shop_id')
            ->where('lode_shop_superior_id', $shop_id)
            ->where(function($query) use($search_data) {
                if (!empty($search_data['lode_unique_identifier'])) {
                    $query->where('lode_unique_identifier', 'like', '%'.$search_data['lode_unique_identifier'].'%' );
                }
            })
            ->where(function($query) use($search_data) {
                if (!empty($search_data['shop_store_name'])) {
                    $query->where('shop_store_name', 'like', '%'.$search_data['shop_store_name'].'%' );
                }
            })
            ->where(function($query) use($search_data) {
                if (!empty($search_data['adm_account'])) {
                    $query->where('adm_name', 'like', '%'. $search_data['adm_account'] .'%');
                }
            })
            ->where(function($query) use($search_data) {
                if (!empty($search_data['adm_phone'])) {
                    $query->where('adm_phone', 'like', '%'.$search_data['adm_phone'].'%' );
                }
            })
            ->where(function($query) use($search_data) {
                if (!empty($search_data['lode_state'])) {
                    $query->where('lode_state',$search_data['lode_state']);
                }
            })
            ->select('lode_id', 'lode_create_time','lode_unique_identifier','shop_store_name', 'adm_account', 'adm_phone','lode_remark','lode_state','adm_name')
            ->orderBy('lode_id', 'desc')
            ->paginate($this->show_count);
        $data_info['current_page'] = $list_data->currentPage();  //当前页面页码
        $data_info['last_page'] = $list_data->lastPage();        //表示最后一页的页码
        $data_info['total'] = $list_data->total();               //总数据个数
        $data_info['current_number'] = $this->show_count;       //一页显示多少个
        $data_info['data'] = $list_data->items();                //返回数据


        // 获取当前列表下的按钮
        $list_button = getListButton($request['api_token'], $request['pri_id']);
        if($list_data) {
            return response()->json(['code'=> 200,'msg'=>'success','data'=>$data_info, 'list_button'=>$list_button]);
        }else{
            return response()->json(['code'=> 500,'msg'=>'error','data'=>'暂无数据', 'list_button'=>$list_button]);
        }
    }

	// 通过
	public function consent(Request $request)
	{
    	// 验证数据
        $verify_data = new VerifyLoginEquipmentController;
        $error_message = $verify_data->startValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }

        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);

        // 查询登录设备信息
        $find_data = DB::table('login_device')
			        ->whereIn('lode_id',$request['lode_id'])
			        ->select('lode_unique_identifier')
			        ->get();
        foreach ($find_data as $key => $value) {
            $lode_unique_identifier[] = $value->lode_unique_identifier;
        }

        // 通过
        $update_data['lode_state'] = 2;//状态1待审核2通过3启用4禁用
        $update_data['lode_remark'] = $request['lode_remark'];
        $update_data['lode_update_time'] = date('Y-m-d H:i:s');
        $lode_res = DB::table('login_device')
            ->whereIn('lode_id',$request['lode_id'])
            ->update($update_data);

        if($lode_res) {
        	Common::addLog($user_info, getRealIp($request), '登录设备','通过','mac地址：（'.implode(',', $lode_unique_identifier).'）通过成功');
            return response()->json(["code"=>200,'msg'=>'success','data'=>'通过成功']);
        }else{
            return response()->json(["code"=>500,'msg'=>'error','data'=>'通过失败']);
        }
	}

    // 启用
    public function start(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyLoginEquipmentController;
        $error_message = $verify_data->startValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }

        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);

        // 查询登录设备信息
        $find_data = DB::table('login_device')
            ->whereIn('lode_id',$request['lode_id'])
            ->select('lode_unique_identifier')
            ->get();
        foreach ($find_data as $key => $value) {
            $lode_unique_identifier[] = $value->lode_unique_identifier;
        }

        // 启用
        $update_data['lode_state'] = 3;//状态1待审核2通过3启用4禁用
        $update_data['lode_remark'] = $request['lode_remark'];
        $update_data['lode_update_time'] = date('Y-m-d H:i:s');
        $lode_res = DB::table('login_device')
            ->whereIn('lode_id',$request['lode_id'])
            ->update($update_data);

        if($lode_res) {
            Common::addLog($user_info, getRealIp($request), '登录设备','启用','mac地址：（'.implode(',', $lode_unique_identifier).'）启用成功');
            return response()->json(["code"=>200,'msg'=>'success','data'=>'启用成功']);
        }else{
            return response()->json(["code"=>500,'msg'=>'error','data'=>'启用失败']);
        }
    }

	// 禁用
    public function reject(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyLoginEquipmentController;
        $error_message = $verify_data->startValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }

        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);

        // 查询登录设备信息
        $find_data = DB::table('login_device')
            ->whereIn('lode_id',$request['lode_id'])
            ->select('lode_unique_identifier')
            ->get();
        foreach ($find_data as $key => $value) {
            $lode_unique_identifier[] = $value->lode_unique_identifier;
        }

        // 禁用
        $update_data['lode_state'] = 4;//状态1待审核2通过3启用4禁用
        $update_data['lode_remark'] = $request['lode_remark'];
        $update_data['lode_update_time'] = date('Y-m-d H:i:s');
        $lode_res = DB::table('login_device')
            ->whereIn('lode_id',$request['lode_id'])
            ->update($update_data);

        if($lode_res) {
            Common::addLog($user_info, getRealIp($request), '登录设备','禁用','mac地址：（'.implode(',', $lode_unique_identifier).'）禁用成功');
            return response()->json(["code"=>200,'msg'=>'success','data'=>'禁用成功']);
        }else{
            return response()->json(["code"=>500,'msg'=>'error','data'=>'禁用失败']);
        }
    }
}
