<?php
namespace App\Http\Controllers\Api\SystemPlatform;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Controllers\Api\Verify\SystemPlatform\VerifyPlatformGoodsListsController;
use Illuminate\Support\Facades\DB;
use App\Http\Models\Api\Common;
use \PhpOffice\PhpSpreadsheet\IOFactory;
use App\Http\Models\Api\Export;

class PlatformGoodsListsController extends Controller
{
    // 列表每页显示数据个数
    protected $show_count = 10;

    // 列表
    public function index(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyPlatformGoodsListsController;
        $error_message = $verify_data->indexValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }
        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);
        $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;
        $search_data = $request->all();
        $list_data = DB::table('system_goods as sg')
            // ->leftjoin('goods_correlation as gc','gc.goco_system_goo_id','=','sg.sygo_system_goo_id')
            // ->leftjoin('admin as a','a.adm_id','=','gc.goco_adm_id')
            // ->where('sygo_system_cid', $user_info->adm_cid)
            // ->where('goco_superior_shop_id', $shop_id)
            ->where('sygo_delete', 1)
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['sygo_name'])) {
                    $query->where('sygo_name', 'like', '%'.$search_data['sygo_name'].'%');
                }
            })//商品名称
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['sygo_goods_encode'])) {
                    $query->where('sygo_goods_code', 'like', '%'.$search_data['sygo_goods_encode'].'%');
                }
            })//商品编码
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['sygo_bra_name'])) {
                    $query->where('sygo_bra_name', 'like', '%'.$search_data['sygo_bra_name'].'%');
                }
            })//品牌名称
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['sygo_brse_name'])) {
                    $query->where('sygo_brse_name', 'like', '%'.$search_data['sygo_brse_name'].'%');
                }
            })//品牌系列名称
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['sygo_cate_name'])) {
                    $query->where('sygo_cate_name', 'like', '%'.$search_data['sygo_cate_name'].'%');
                }
            })//品类名称
            ->select('sygo_id', 'sygo_name', 'sygo_system_goo_id', 'sygo_goods_encode', 'sygo_goods_code', 'sygo_bra_name', 'sygo_cate_name', 'sygo_brse_name')
            ->orderBy('sygo_id', 'desc')
            ->paginate($this->show_count);
        $data = $list_data->items();
        $system_goo_id= [];
        foreach ($data as $key => $value) {
            $system_goo_id[] = $value->sygo_system_goo_id;
        }
        $system_goods_data = DB::table('goods_correlation')
            ->whereIn('goco_system_goo_id', $system_goo_id)
            ->where('goco_superior_shop_id', $shop_id)
            ->get(['goco_goo_id','goco_adm_id','goco_binding_time','goco_state','goco_system_goo_id']);
        $goo_id = [];
        $adm_id = [];
        foreach ($data as $k => $v) {
            foreach ($system_goods_data as $key => $value) {
                $goo_id[] = $value->goco_goo_id;
                $adm_id[] = $value->goco_adm_id;
                if ($value->goco_system_goo_id == $v->sygo_system_goo_id) {
                    $data[$k]->sygo_state = $value->goco_state;
                    $data[$k]->sygo_binding_time = $value->goco_binding_time;
                    $data[$k]->goco_goo_id = $value->goco_goo_id;
                    $data[$k]->goco_adm_id = $value->goco_adm_id;
                }
            }
        }
        foreach ($data as $key => $value) {
            if (!isset($value->sygo_state)) {
                $data[$key]->sygo_state = '';
                $data[$key]->sygo_binding_time = '';
                $data[$key]->goco_goo_id = '';
                $data[$key]->goco_adm_id = '';
            }
        }
        $data_info['goods_data'] = DB::table('goods')
            ->whereIn('goo_id', $goo_id)
            ->get(['goo_name', 'goo_system_code', 'goo_id']);
        $data_info['adm_data'] = DB::table('admin')
            ->whereIn('adm_id', $adm_id)
            ->get(['adm_name','adm_id']);

        // 商品下架数量
        $data_info['goods_quantity'] = DB::table('system_goods')
            // ->where('sygo_system_cid', $user_info->adm_cid)
            ->where('sygo_delete', 1)->where(function ($query) use ($search_data) {
                if (!empty($search_data['sygo_name'])) {
                    $query->where('sygo_name', 'like', '%'.$search_data['sygo_name'].'%');
                }
            })//商品名称
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['sygo_goods_encode'])) {
                    $query->where('sygo_goods_encode', 'like', '%'.$search_data['sygo_goods_encode'].'%');
                }
            })//商品编码
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['sygo_bra_name'])) {
                    $query->where('sygo_bra_name', 'like', '%'.$search_data['sygo_bra_name'].'%');
                }
            })//品牌名称
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['sygo_cate_name'])) {
                    $query->where('sygo_cate_name', 'like', '%'.$search_data['sygo_cate_name'].'%');
                }
            })//品类名称
            ->count();
        $data_info['current_page'] = $list_data->currentPage();  //当前页面页码
        $data_info['last_page'] = $list_data->lastPage();        //表示最后一页的页码
        $data_info['total'] = $list_data->total();               //总数据个数
        $data_info['current_number'] = $this->show_count;       //一页显示多少个
        $data_info['data'] = $list_data->items();                //返回数据

        // 获取当前列表下的按钮
        $list_button = getListButton($request['api_token'], $request['pri_id']);
        if ($list_data) {
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$data_info, 'list_button'=>$list_button]);
        } else {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'暂无数据']);
        }
    }

    // 同步商品信息
    public function sync(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyPlatformGoodsListsController;
        $error_message = $verify_data->syncValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'请选择同步的商品', 'error_message'=>$error_message]);
        }
        
        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);

        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;

        // 判断商品是否绑定
        $find_sygo_id = DB::table('system_goods as sygo')
            ->leftjoin('goods_correlation as goco', 'goco.goco_system_goo_id', '=', 'sygo.sygo_system_goo_id')
            ->whereIn('sygo_id', $request['sygo_id'])
            ->select('sygo_name')
            ->get();
        if ($find_sygo_id) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>$find_sygo_id.'当前商品已同步']);
        }
        $goo_id = DB::table('system_goods')
            ->whereIn('sygo_id', $request['sygo_id'])
            ->select('sygo_id', 'sygo_system_goo_id', 'sygo_bra_name', 'sygo_cate_name', 'sygo_name', 'sygo_goods_encode', 'sygo_create_time', 'sygo_update_time')
            ->get();
        DB::beginTransaction();
        foreach ($goo_id as $key => $value) {
            // 商品表
            $goo_data['goo_cid'] = $user_info->adm_cid;//公司id
            $goo_data['goo_superior_shop_id'] = $shop_id;//所属总店id
            $goo_data['goo_shop_id'] = $user_info->adm_shop_id;//所属门店id
            $goo_data['goo_bra_name'] = $value->sygo_bra_name;//品牌名称
            if (empty($value->sygo_bra_name)) {
                $bra_id = 0;
            } else {
                $bra_id = DB::table('brand')
                    ->where('bra_cid', $user_info->adm_cid)
                    ->where('bra_shop_id', $user_info->adm_shop_id)
                    ->where('bra_superior_shop_id', $shop_id)
                    ->where('bra_name', $value->sygo_bra_name)
                    ->value('bra_id');
                if (empty($bra_id)) {
                    $bra_data['bra_cid'] = $user_info->adm_cid;
                    $bra_data['bra_shop_id'] = $user_info->adm_shop_id;
                    $bra_data['bra_superior_shop_id'] = $shop_id;
                    $bra_data['bra_name'] = $value->sygo_bra_name;
                    $bra_data['bra_create_time'] = date('Y-m-d H:i:s');
                    $bra_data['bra_goods_number'] = 1;
                    $bra_id = DB::table('brand')->insertGetId($bra_data);
                } else {
                    DB::table('brand')->where('bra_id', $bra_id)->increment('bra_goods_number');
                }
                $goo_data['goo_bra_id'] = $bra_id;
            }
            $goo_data['goo_cate_name'] = $value->sygo_cate_name;//品类名称
            $cate_id = DB::table('category')
                ->where('cate_cid', $user_info->adm_cid)
                ->where('cate_shop_id', $user_info->adm_shop_id)
                ->where('cate_superior_shop_id', $shop_id)
                ->where('cate_name', $value->sygo_cate_name)
                ->value('cate_id');
            if (empty($cate_id)) {
                $chty_data['cate_cid'] = $user_info->adm_cid;
                $chty_data['cate_shop_id'] = $user_info->adm_shop_id;
                $chty_data['cate_superior_shop_id'] = $shop_id;
                $chty_data['cate_name'] = $value->sygo_cate_name;
                $chty_data['cate_create_time'] = date('Y-m-d H:i:s');
                $chty_data['cate_goods_number'] = 1;
                $cate_id = DB::table('category')->insertGetId($chty_data);
            } else {
                DB::table('category')->where('cate_id', $cate_id)->increment('cate_goods_number');
            }
            $goo_data['goo_cate_id'] = $cate_id;//品类id
            $goo_data['goo_name'] = $value->sygo_name;//商品名称
            $goo_data['goo_goods_encode'] = $value->sygo_goods_encode;//检索编码
            $goods_id = DB::table('goods')->insertGetid($goo_data);
            // 商品关联表
            $goco_data['goco_cid'] = $user_info->adm_cid;//公司id
            $goco_data['goco_superior_shop_id'] = $shop_id;//所属总店id
            $goco_data['goco_shop_id'] = $user_info->adm_shop_id;//所属门店id
            $goco_data['goco_goo_id'] = $goods_id;//商品id
            $goco_data['goco_sygo_id'] = $value->sygo_id;//系统商品id
            $goco_data['goco_system_goo_id'] = $value->sygo_system_goo_id;//第三方系统商品id
            $goco_data['goco_update_time'] = date('Y-m-d H:i:s');//更新时间
            $goco_id = DB::table('goods_correlation')->insert($goco_data);
        }
        if ($goods_id && $goco_id) {
            DB::commit();
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>'同步成功']);
        } else {
            DB::rollBack();
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'同步失败']);
        }
    }

    // 改绑商品
    public function changeBindGoods(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyPlatformGoodsListsController;
        $error_message = $verify_data->showChangeBindGoodsValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }
        $user_info = Common::getUserInfo($request['api_token']);
        $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;
        if ($request['type'] == 1) {
            $goo_id = [];
            $goo_id = DB::table('goods_correlation')
                ->where('goco_cid', $user_info->adm_cid)
                ->where('goco_superior_shop_id', $shop_id)
                ->where('goco_shop_id', $user_info->adm_shop_id)
                ->pluck('goco_goo_id');
            $shop_state = true;
            if (in_array($shop_id, config('apisystem.NO_SHOPID'))) {
                $shop_state = false;
            }
            $list_data = DB::table('goods')
                ->where(function ($query) use ($user_info, $shop_state) {
                    if ($shop_state) {
                        $query->where('goo_cid', 0)
                            ->orwhere('goo_cid', $user_info->adm_cid);
                    } else {
                        $query->where('goo_cid', $user_info->adm_cid);
                    }
                })
                ->where(function ($query) use ($user_info, $shop_state) {
                    if ($shop_state) {
                        $query->where('goo_shop_id', 0)
                            ->orwhere('goo_shop_id', $user_info->adm_shop_id);
                    } else {
                        $query->where('goo_shop_id', $user_info->adm_shop_id);
                    }
                })
                ->where('goo_type', 1)
                ->where('goo_state', 1)
                ->whereNotIn('goo_id', $goo_id)
                ->where('goo_delete', 1)
                ->where(function ($query) use ($request) {
                    if (!empty($request['import'])) {
                        $query->where('goo_name', 'like', '%'.$request['import'].'%')
                            ->orWhere('goo_goods_encode', 'like', '%'.$request['import'].'%');
                    }
                })//商品名称、检索编码
                ->where(function ($query) use ($request) {
                    if (!empty($request['goo_cate_name'])) {
                        $query->where('goo_cate_name', 'like', '%'.$request['goo_cate_name'].'%');
                    }
                })//品类
                ->where(function ($query) use ($request) {
                    if (!empty($request['goo_bra_name'])) {
                        $query->where('goo_bra_name', 'like', '%'.$request['goo_bra_name'].'%');
                    }
                })//品牌
                ->where(function ($query) use ($request) {
                    if (!empty($request['goo_bra_id'])) {
                        $query->where('goo_bra_id', $request['goo_bra_id']);
                    }
                })//品牌id
                ->where(function ($query) use ($request) {
                    if (!empty($request['goo_brse_id'])) {
                        $query->where('goo_brse_id', 'like', '%'.$request['goo_brse_id'].'%');
                    }
                })//品牌系列id
                ->select('goo_id', 'goo_name', 'goo_goods_encode', 'goo_cate_name', 'goo_bra_name', 'goo_brse_id')
                ->orderBy('goo_id', 'desc')
                ->paginate($this->show_count);
            $data_info['current_page'] = $list_data->currentPage();  //当前页面页码
            $data_info['last_page'] = $list_data->lastPage();        //表示最后一页的页码
            $data_info['total'] = $list_data->total();               //总数据个数
            $data_info['current_number'] = $this->show_count;       //一页显示多少个
            $list_items = $list_data->items();                //返回数据
            $brse_data = [];//品牌系列数据
            if ($list_items) {
                // 查询品牌系列数据
                $goo_brse_id = array_filter(array_unique(array_column($list_items, 'goo_brse_id')));
                if ($goo_brse_id) {
                    $brse_data = DB::table('brand_serie')
                        ->whereIn('brse_id', $goo_brse_id)
                        ->select('brse_id', 'brse_name')
                        ->get();
                }
            }
            $data_info['data'] = $list_items;//返回数据
            $data_info['brse_data'] = $brse_data;
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$data_info]);
        }

        // 验证数据
        $verify_data = new VerifyPlatformGoodsListsController;
        $error_message = $verify_data->changeBindGoodsValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }
        
        $goco_id = DB::table('goods_correlation')
            ->where('goco_goo_id', $request['goo_id'])
            ->where('goco_cid', $user_info->adm_cid)
            ->where('goco_superior_shop_id', $shop_id)
            ->where('goco_shop_id', $user_info->adm_shop_id)
            ->value('goco_id');
        if ($goco_id) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'此商品已经被绑定']);
        }
        $sygo_system_goo_id = DB::table('system_goods')
            ->where('sygo_id', $request['sygo_id'])
            ->where('sygo_system_cid', 1)
            ->where('sygo_delete', 1)
            ->value('sygo_system_goo_id');

        $goco_id = DB::table('goods_correlation')
            ->where('goco_system_goo_id', $sygo_system_goo_id)
            ->where('goco_cid', $user_info->adm_cid)
            ->where('goco_superior_shop_id', $shop_id)
            ->where('goco_shop_id', $user_info->adm_shop_id)
            ->value('goco_id');
        if (empty($goco_id)) {
            $data['goco_cid'] = $user_info->adm_cid;
            $data['goco_superior_shop_id'] = $shop_id;
            $data['goco_shop_id'] = $user_info->adm_shop_id;
            $data['goco_system_goo_id'] = $sygo_system_goo_id;//第三方系统id
            $data['goco_goo_id'] = $request['goo_id'];//系统商品id
            $data['goco_adm_id'] = $user_info->adm_id;
            $data['goco_state'] = 2;
            $data['goco_binding_time'] = date('Y-m-d H:i:s');
            $goco_res = DB::table('goods_correlation')->insert($data);
        } else {
            $data['goco_goo_id'] = $request['goo_id'];
            $data['goco_adm_id'] = $user_info->adm_id;
            $data['goco_state'] = 2;
            $data['goco_binding_time'] = date('Y-m-d H:i:s');
            $data['goco_update_time'] = date('Y-m-d H:i:s');
            $goco_res = DB::table('goods_correlation')
                ->where('goco_id', $goco_id)
                ->where('goco_shop_id', $user_info->adm_shop_id)
                ->update($data);
        }
        if ($goco_res) {
            Common::addLog($user_info, getRealIp($request), '网单商品', '改绑', '商品改绑：'.$request['goo_name'].'成功');
            return response()->json(["code"=>200,'msg'=>'success','data'=>'商品改绑成功']);
        } else {
            DB::rollBack();
            return response()->json(["code"=>500,'msg'=>'error','data'=>'商品改绑失败']);
        }
    }

    // 导出
    public function exportGoods(Request $request)
    {
        // 获取当前操作账号信息
        $userinfo  = Common::getUserInfo($request['api_token']);

        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $userinfo->shop_superior_id ? $userinfo->shop_superior_id : $userinfo->adm_shop_id;
            
        $search_data = $request->all();
            
        // 基本与查询一致
        $data = DB::table('system_goods as sygo')
            ->leftjoin('goods_correlation as gocr', 'gocr.goco_system_goo_id', '=', 'sygo.sygo_system_goo_id')
            ->leftjoin('goods as goo', 'goo.goo_id', '=', 'gocr.goco_goo_id')
            // ->leftjoin('admin as a','a.adm_id','=','gc.goco_adm_id')
            // ->where('sygo_system_cid', $user_info->adm_cid)
            // ->where('goco_superior_shop_id', $shop_id)
            ->where('sygo_delete', 1)
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['sygo_name'])) {
                    $query->where('sygo_name', 'like', '%'.$search_data['sygo_name'].'%');
                }
            })//商品名称
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['sygo_goods_encode'])) {
                    $query->where('sygo_goods_code', 'like', '%'.$search_data['sygo_goods_encode'].'%');
                }
            })//商品编码
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['sygo_bra_name'])) {
                    $query->where('sygo_bra_name', 'like', '%'.$search_data['sygo_bra_name'].'%');
                }
            })//品牌名称
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['sygo_brse_name'])) {
                    $query->where('sygo_brse_name', 'like', '%'.$search_data['sygo_brse_name'].'%');
                }
            })//品牌系列名称
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['sygo_cate_name'])) {
                    $query->where('sygo_cate_name', 'like', '%'.$search_data['sygo_cate_name'].'%');
                }
            })//品类名称
            ->select('sygo_id', 'sygo_name', 'sygo_goods_code', 'goo_name', 'goo_system_code', 'sygo_bra_name', 'sygo_brse_name', 'sygo_cate_name')
            ->orderBy('sygo_id', 'desc')
            ->get()->toArray();
        if (!empty($data)) {
            // 将对象转为数组
            $data = json_decode(json_encode($data), true);
        } else {
            return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'暂无导出数据']);
        }
        
        $pathName = storage_path()."/app/public/excel";//获取上传excel路径
        // 创建文件夹
        if (!file_exists($pathName)) {
            mkdir($pathName, 0775, true);
            chmod($pathName, 0775);
        }

        $streamFileRand = time() . rand(10000, 99999).'.xls';//
        // 产生一个随机文件名（因为你base64上来肯定没有文件名，这里你可以自己设置一个也行）
        $streamFilename = $pathName . '/' .$streamFileRand;

        $where['action_name'] = '网单商品';
        $where['field_name'] = ['序号', '网单商品名称', '网单商品编号', '商品名称', '系统编码', '品牌名称', '系列名称', '品类名称'];
        // 调用导出的公共方法
        export::publicExport(
            $streamFilename, //路径
            $where,    //sheet名及其每一行的标题
            $data      //导出数据
        );

        // 判断文件是否存在 存在则成功  不存在则失败
        if (file_exists($pathName)) {
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>'storage/excel/'.$streamFileRand]);
        } else {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'导出失败']);
        }
    }

    // 导入-下载模板
    public function downTemplate(Request $request)
    {
        return response()->json(['code'=>200,'msg'=>'success','data'=>'storage/Template/temps.xlsx']);
    }

    // 导入
    public function importGoods(Request $request)
    {
        // 获取当前操作账号信息
        $user_info  = Common::getUserInfo($request['api_token']);

        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;
            
        $file = $request->file('file');
        
        if ($file->isValid()) {
            //获取表格的大小，限制上传表格的大小5M
            $file_size = $_FILES['file']['size'];
            if ($file_size > 5 * 1024 * 1024) {
                return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'文件大小不能超过5M']);
            }

            //限制上传表格类型
            $ext = $file->getClientOriginalExtension();//文件拓展名
            if ($ext != 'xlsx') {
                return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'仅允许上传以xlsx结尾的后缀文件']);
            }

            // 有Xls和Xlsx格式两种
            $objReader = IOFactory::createReader('Xlsx');
            $filename = $_FILES['file']['tmp_name'];
            $objPHPExcel = $objReader->load($filename);  //$filename可以是上传的表格，或者是指定的表格
            $sheet = $objPHPExcel->getSheet(0);   //excel中的第一张sheet
            $highestRow = $sheet->getHighestRow();       // 取得总行数
            // if ($highestRow > 52) {
            //     return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'一次最多导入50条数据']);
            // }

            //循环读取excel表格，整合成数组,如果是不指定key的二维,就用$data[i][j]表示。
            $usersExits = [];
            $xuhao = $objPHPExcel->getActiveSheet()->getCell("A" . 2)->getValue();
            if (trim($xuhao) != '序号') {
                return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'请先下载模板文件,在进行导入']);
            }

            for ($j = 3; $j <= $highestRow; $j++) {
                $goo_name = $objPHPExcel->getActiveSheet()->getCell("D" . $j)->getValue();
                $goo_id = DB::table('goods')
                    ->where('goo_cid', $user_info->adm_cid)
                    ->where('goo_superior_shop_id', $shop_id)
                    ->where('goo_shop_id', $user_info->adm_shop_id)
                    ->where('goo_name', trim($goo_name))
                    ->value('goo_id');
                $sygo_id = $objPHPExcel->getActiveSheet()->getCell("A" . $j)->getValue();
                // 查询第三方系统商品id
                $sygo_system_goo_id = DB::table('system_goods')
                    ->where('sygo_id', trim($sygo_id))
                    ->where('sygo_system_cid', 1)
                    ->where('sygo_delete', 1)
                    ->value('sygo_system_goo_id');
                $goco_id = DB::table('goods_correlation')
                    ->where('goco_system_goo_id', $sygo_system_goo_id)
                    ->where('goco_cid', $user_info->adm_cid)
                    ->where('goco_superior_shop_id', $shop_id)
                    ->where('goco_shop_id', $user_info->adm_shop_id)
                    ->value('goco_id');
                if (empty($goco_id)) {
                    $goco_data['goco_cid'] = $user_info->adm_cid; //所属企业id
                    $goco_data['goco_shop_id'] = $user_info->adm_shop_id; //所属门店id
                    $goco_data['goco_superior_shop_id'] = $shop_id; //所属总店id
                    $goco_data['goco_adm_id'] = $user_info->adm_id; //绑定人id
                    $goco_data['goco_binding_time'] = date('Y-m-d H:i:s'); //绑定时间
                    $goco_data['goco_state'] = 2; //绑定状态1未绑定2已绑定
                    $goco_data['goco_goo_id'] = $goo_id; //系统商品id
                    $goco_data['goco_system_goo_id'] = $sygo_system_goo_id; //第三方系统商品id
                    $goco_res = DB::table('goods_correlation')->insert($goco_data);
                } else {
                    $goco_datas['goco_adm_id'] = $user_info->adm_id; //绑定人id
                    $goco_datas['goco_state'] = 2; //绑定状态1未绑定2已绑定
                    $goco_datas['goco_goo_id'] = $goo_id; //系统商品id
                    $data['goco_binding_time'] = date('Y-m-d H:i:s');
                    $goco_datas['goco_update_time'] = date('Y-m-d H:i:s'); //修改时间
                    $goco_res = DB::table('goods_correlation')
                        ->where('goco_shop_id', $user_info->adm_shop_id)
                        ->where('goco_id', trim($goco_id))
                        ->update($goco_datas);
                }
                if (!$goco_res) {
                    return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'上传失败']);
                }
            }
            Common::addLog($user_info, getRealIp($request), '网单商品', '导入', '导入网单商品成功');
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>'上传成功']);
        } else {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'上传有误,请重新上传']);
        }
    }
}
