<?php

namespace App\Http\Controllers\Api\ReturnGoodsManage;

use App\Services\CommonService;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Services\ReturnGoods\ReturnGoodsService;

// 退货管理 -- 退货管理
class ReturnGoodsController extends Controller
{
    // 列表每页显示数据个数
    protected $show_count = 10;

    //添加申请退货
    public function add(Request $request){

        $request = $request->all();
        $data = ReturnGoodsService::add($request);
        return response()->json($data);

    }

    //申请退货获取订单信息
    public function getInfo(Request $request){
        $request = $request->all();
        $data = ReturnGoodsService::getInfo($request);
        return response()->json($data);
    }

    //列表
    public function index(Request $request){

        $request = $request->all();
        $data = ReturnGoodsService::index($request);
        return response()->json($data);
    }

    /*
     * @name 打款记录
     * @param string ju_ordernum 订单单号
     * @retrun array
     * @author Ma 2023/9/12 16:14
     *
    */
    public function payment(Request $request){
        $request = $request->all();
        $data = ReturnGoodsService::payment($request);
        return response()->json($data);
    }

    /*
     * @name 回收记录
     * @param string ju_ordernum 订单单号
     * @retrun array
     * @author Ma 2023/9/14 10:29
     *
    */
    public function recovery(Request $request)
    {
        $request = $request->all();
        $data = ReturnGoodsService::recovery($request);
        return response()->json($data);
    }


    /*
     * @name 撤销
     * @param string ju_ordernum 订单单号
     * @retrun array
     * @author Ma 2023/9/14 10:29
     *
    */
    public function revoke(Request $request)
    {
        $request = $request->all();
        $data = ReturnGoodsService::revoke($request);
        return response()->json($data);
    }
}
