<?php

namespace App\Http\Controllers\Api\ReturnGoodsManage;

use App\Services\CommonService;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Services\ReturnGoods\ReturnGoodsService;

// 退货管理 -- 退款管理
class RefundGoodsController extends Controller
{
    // 列表每页显示数据个数
    protected $show_count = 10;


    //列表
    public function index(Request $request){

        $request = $request->all();
        $data = ReturnGoodsService::refundIndex($request);
        return response()->json($data);

    }

   /*
    * @name 编辑
    * @param string ju_ordernum 订单单号
    * @retrun array
    * @author Ma 2023/9/13 9:12
    *
   */
   public function edit(Request $request){

       $request = $request->all();
       $data = ReturnGoodsService::edit($request);
       return response()->json($data);

   }

    /*
     * @name 状态下拉
     * @param string ju_ordernum 订单单号
     * @retrun array
     * @author Ma 2023/9/13 9:12
     *
    */
    public function getStatusList(Request $request){

        $request = $request->all();
        $data = ReturnGoodsService::getStatusName(false);
        return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$data]);

    }
}
