<?php
namespace App\Http\Controllers\Api\Push;

use Illuminate\Http\Request;
use App\Http\Requests;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;

// 消息推送
class PushMessageController extends Controller
{
    //新增生产消息
    public function add(Request $request)
    {
        echo 33;die;
        $url = config('apimesssage.SERVER_URL').'/im/push-record/save';//消息推送url
        $param['appId'] = config('apimesssage.APPID');
        $param['moduleDataId'] = 8506;//模块数据编号,工单id/订单id/
        $param['moduleId'] = 2;//模块id；单号类型:1订单2工单3速电网单
        $param['pushTime'] = '2020-10-15 17:22:00';//推送触发时间,为空则表示立即推送
        if ($request['push_time']) {
        }
        $param['recId'] = 12;//接收用户id(与门店id两者必填其一)
        $param['storeId'] = 0;//门店系统门店id，有门店id就推送门店下的所有用户，没有门店id就推送用户id
        $param['targetType'] = 1;//接收端类型0=浏览器;1=移动端

        // 消息体，pc端弹框提示信息数据
        $msg_bogy['inhi_operation_state'] = 2;//操作状态：1新订单2生成工单3拒单4终止5接单6预约7出发8抵达9完成10工单审核通过11订单结算12取消订单13工单改单14工单派单15工单审核通过16工单反审核17新速电网单18门店接单19门店拒单20速电申请改单21速电改单通过22速电催单23暂停
        $msg_bogy['inhi_original_operation'] = '新工单';//操作
        $msg_bogy['inhi_original_number'] = 'G2020101517105900004';//原始单号
        $msg_bogy['inhi_original_state'] = 1;//原始单状态
        $msg_bogy['inhi_create_time'] = '2020-10-15 17:16:00';//操作时间
        $msg_bogy['inhi_type'] = 2;////单号类型:1订单2工单3速电网单
        $msg_bogy['app_extras_type'] = 1;//APP提示音类型：1新工单2催单3售后催单
        // if (isset($request['app_extras_type'])) {
        //     $msg_bogy['app_extras_type'] = $request['app_extras_type'];//APP提示音类型：1新工单2催单3售后催单
        // }
        $param['msgBody'] = json_encode($msg_bogy, JSON_UNESCAPED_UNICODE);//消息体
        $param = json_encode($param, JSON_UNESCAPED_UNICODE);
        //请求接口密钥：md5(参数json + SECRET_KEY)
        $signature = md5($param.config('apimesssage.SECRET_KEY'));
        // 请求消息推送接口
        $curl_return = $this->curlPost($url, $param, $signature);
        //接口返回结果数据
        $curl_return = json_decode($curl_return, true);
        // 判断接口是否请求成功
        if ($curl_return['code'] != 0 || empty($curl_return['state'])) {
            // 接口请求失败，记录请求日志
            $curl_return['param'] = $param;
            $curl_return['request_time'] = date('Y-m-d H:i:s');
            logRecord($curl_return, 'push_error_log', 2);
            return ['code'=>500, 'msg'=>'error', 'data'=>'提示消息推送失败'];
        }else{
            return ['code'=>200, 'msg'=>'success', 'data'=>''];
        }


        // $url = config('apimesssage.SERVER_URL').'/im/push-record/save';//消息推送url
        // $param['appId'] = config('apimesssage.APPID');
        // $param['moduleDataId'] = 1;//模块数据编号,工单id/订单id/
        // $param['moduleId'] = 1;//模块id；单号类型:1订单2工单3速电网单
        // $param['pushTime'] = '';//推送触发时间,为空则表示立即推送
        // $param['recId'] = 1;//接收用户id(与门店id两者必填其一)
        // $param['storeId'] = 1;//门店系统门店id
        // $param['targetType'] = 0;//接收端类型0=浏览器;1=移动端

        // $msg_bogy['inhi_operation_state'] = 17;//操作状态：1新订单2生成工单3拒单4终止5接单6预约7出发8抵达9完成10工单审核通过11订单结算12取消订单13工单改单14工单派单15工单审核通过16工单反审核17新速电网单18门店接单19门店拒单20速电申请改单21速电改单通过22速电催单23暂停
        // $msg_bogy['text'] = '测试';

        // $param['msgBody'] = json_encode($msg_bogy, JSON_UNESCAPED_UNICODE);//消息体
        // $param = json_encode($param, JSON_UNESCAPED_UNICODE);

        // //请求接口密钥：md5(参数json + SECRET_KEY)
        // $signature = md5($param.config('apimesssage.SECRET_KEY'));
        // // 请求消息推送接口
        // $curl_return = $this->curlPost($url, $param, $signature);
        // //接口返回结果数据
        // $curl_return = json_decode($curl_return, true);
        // dump($curl_return);
        // // 判断接口是否请求成功
        // if ($curl_return['code'] != 0 || empty($curl_return['state'])) {
        // 	// 接口请求失败，记录请求日志
        // 	$curl_return['param'] = $param;
        // 	$curl_return['request_time'] = date('Y-m-d H:i:s');
        // 	logRecord($curl_return, 'push_error_log', 2);
        // }
    }

    /**
     * [create 新增推送消息]
     * @param  [type] $request [description]
     * @return [type]          [description]
     */
    public function create($request)
    {

        $url = config('apimesssage.SERVER_URL').'/im/push-record/save';//消息推送url
        $param['appId'] = config('apimesssage.APPID');
        $param['moduleDataId'] = $request['inhi_original_id'];//模块数据编号,工单id/订单id/
        $param['moduleId'] = $request['modeule_type'];//模块id；单号类型:1订单2工单3速电网单
        if ($request['push_time']) {
        	$param['pushTime'] = $request['push_time'];//推送触发时间,为空则表示立即推送
        }
        $param['recId'] = $request['inhi_original_adm_id'];//接收用户id(与门店id两者必填其一)
        $param['storeId'] = $request['shop_id'];//门店系统门店id，有门店id就推送门店下的所有用户，没有门店id就推送用户id
        $param['targetType'] = $request['target_type'];//接收端类型0=浏览器;1=移动端

        // 消息体，pc端弹框提示信息数据
        $msg_bogy['inhi_operation_state'] = $request['inhi_operation_state'];//操作状态：1新订单2生成工单3拒单4终止5接单6预约7出发8抵达9完成10工单审核通过11订单结算12取消订单13工单改单14工单派单15工单审核通过16工单反审核17新速电网单18门店接单19门店拒单20速电申请改单21速电改单通过22速电催单23暂停
        $msg_bogy['inhi_original_operation'] = $request['inhi_original_operation'];//操作
        $msg_bogy['inhi_original_number'] = $request['inhi_original_number'];//原始单号
        $msg_bogy['inhi_original_state'] = $request['inhi_original_state'];//原始单状态
        if (isset($request['inhi_create_time']) && $request['inhi_create_time']) {
            $msg_bogy['inhi_create_time'] = $request['inhi_create_time'];//操作时间
        }
        $msg_bogy['inhi_type'] = $request['modeule_type'];////单号类型:1订单2工单3速电网单
        if (isset($request['app_extras_type'])) {
            $msg_bogy['app_extras_type'] = $request['app_extras_type'];//APP提示音类型：1新工单2催单3售后催单
        }
        $param['msgBody'] = json_encode($msg_bogy, JSON_UNESCAPED_UNICODE);//消息体
        $param = json_encode($param, JSON_UNESCAPED_UNICODE);
        //请求接口密钥：md5(参数json + SECRET_KEY)
        $signature = md5($param.config('apimesssage.SECRET_KEY'));
        // 请求消息推送接口
        $curl_return = $this->curlPost($url, $param, $signature);
        //接口返回结果数据
        $curl_return = json_decode($curl_return, true);
        // 判断接口是否请求成功
        if ($curl_return['code'] != 0 || empty($curl_return['state'])) {
        	// 接口请求失败，记录请求日志
        	$curl_return['param'] = $param;
        	$curl_return['request_time'] = date('Y-m-d H:i:s');
        	logRecord($curl_return, 'push_error_log', 2);
            return ['code'=>500, 'msg'=>'error', 'data'=>'提示消息推送失败'];
        }else{
            return ['code'=>200, 'msg'=>'success', 'data'=>''];
        }
    }

    // 删除消息
    public function delete($request)
    {
        $url = config('apimesssage.SERVER_URL').'/im/push-record/save';//消息推送url
        $param['appId'] = config('apimesssage.APPID');
        $param['moduleDataId'] = $request['inhi_original_id'];//模块数据编号,工单id/订单id/
        $param['moduleId'] = $request['modeule_type'];//模块id；单号类型:1订单2工单3速电网单
        $param['targetType'] = $request['target_type'];//接收端类型0=浏览器;1=移动端

        $param = json_encode($param, JSON_UNESCAPED_UNICODE);
        //请求接口密钥：md5(参数json + SECRET_KEY)
        $signature = md5($param.config('apimesssage.SECRET_KEY'));
        // 请求消息推送接口
        $curl_return = $this->curlPost($url, $param, $signature);
        //接口返回结果数据
        $curl_return = json_decode($curl_return, true);
        // 判断接口是否请求成功
        if ($curl_return['code'] != 0 || empty($curl_return['state'])) {
            // 接口请求失败，记录请求日志
            $curl_return['param'] = $param;
            $curl_return['request_time'] = date('Y-m-d H:i:s');
            logRecord($curl_return, 'push_error_log', 2);
            return ['code'=>500, 'msg'=>'error', 'data'=>'提示消息推送失败'];
        }else{
            return ['code'=>200, 'msg'=>'success', 'data'=>''];
        }
    }

    /**
     * [pushApp APP推送提醒]
     * @return [type] [description]
     */
	public function pushApp(Request $request)
	{
        $adm_phone =  DB::table('admin')
            ->where('adm_id', $request['recId'])
            ->value('adm_phone');
        $push_name['alias'][] = $adm_phone; //发送对象
        $msg_bogy = json_decode($request['msgBody'], true);
        $hint = '您有新的工单：' . $msg_bogy['inhi_original_number'] . ' 请注意查收';//APP的提示信息
        $result_push = pushMessage($push_name, $hint, $msg_bogy['app_extras_type']);
        return response()->json($result_push);
	}

    /**
     * [curlPost 模拟post请求]
     * @param  [type] $url       [接口地址]
     * @param  [type] $param     [请求参数]
     * @param  [type] $signature [密钥]
     * @return [type]            [description]
     */
    private function curlPost($url, $param, $signature){
        $header = array(
            'Content-Type: application/json',
            'signature: '.$signature,
        );
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $header);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $param);
        $response = curl_exec($ch);
        curl_close($ch);
        return trim($response);
    }
}
