<?php
namespace App\Http\Controllers\Api\OtherSystemInterfaces;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Controllers\Api\Verify\OtherSystemInterfaces\VerifyOtherSystemOrdersController;
use Illuminate\Support\Facades\DB;
use App\Http\Models\Api\Common;
use App\Http\Models\Api\WorkOrder;
use App\Http\Models\Api\Warehouse;
use App\Http\Models\Api\ReceivableBill;
use App\Http\Controllers\Api\Push\PushMessageController;
use App\Http\Models\Services\Order;
use App\Http\Models\Services\WarehouseLock;
use App\Services\Business\NewOrderService;

class OtherSystemOrdersController extends Controller
{
    // 列表每页显示数据个数
    protected $show_count = 10;

    /**
     * 获取施工门店
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-07-03
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function getServiceShop(Request $request) {
        // 接收数据流
        $request = file_get_contents("php://input");
        // 解析
        Common::write_log($request, 1, 'getServiceShop');
        $request = json_decode($request, true);
        if (!isset($request['timeStamp']) || !isset($request['key']) || !isset($request['shop_code']) || !isset($request['signature'])) {
            return response()->json(['code'=>501,'msg'=>'签名参数错误','data'=>'']);
        }
        $get_signature = $this->signature($request);
        if (!isset($request['shop_code']) || empty($request['shop_code'])) {
            return response()->json(['code'=>500,'msg'=>'请传入门店编码','data'=>'']);
        }
        $shop = DB::table('shop')
            ->where('shop_code', $request['shop_code'])
            ->select('shop_id', 'shop_store_name')
            ->first();
        if (!$shop) {
            return response()->json(['code'=>500,'msg'=>'未查询到此门店','data'=>'']);
        }
        $list = DB::table('business_client as bucl')
            ->where('bucl_shop_id', $shop->shop_id)
            ->where('bucl_del', 1)
            ->select('bucl_id', 'bucl_user_phone', 'bucl_user_name', 'bucl_name', 'bucl_province', 'bucl_city', 'bucl_county', 'bucl_address')
            ->get();
        if ($shop) {
            $new_data[0]['company_code'] = $shop->shop_id;
            $new_data[0]['company_type'] = 1;
            $new_data[0]['company_name'] = $shop->shop_store_name;
        }
        $i = 1;
        foreach ($list as $key => $value) {
            $new_data[$i]['company_code'] = $value->bucl_id;
            $new_data[$i]['company_type'] = 2;
            $new_data[$i]['company_name'] = $value->bucl_name;
            $i++;
        }
        return response()->json(['code'=>200,'msg'=>'success','data'=>$new_data]);
    }

    /**
     * 下单
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-07-01
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function placeOrder(Request $request) {
        $get_ip = getRealIp($request); //获取ip
        // 接收数据流
        $request = file_get_contents("php://input");

        // 解析
        Common::write_log($request, 1, 'placeOrder');
        $request = json_decode($request, true);

        // 验证数据
        $verify_data = new VerifyOtherSystemOrdersController;
        $error_message = $verify_data->placeOrderValidator($request);
        if ($error_message) {
            return response()->json(['code'=>202, 'msg'=>$error_message]);
        }
        $get_signature = $this->signature($request);
        if (!$get_signature) {
            return response()->json(['code'=>501, 'msg'=>'签名错误','data'=>'']);
        }
        DB::beginTransaction();
        $request['ord_address_type'] = $request['ord_company_type'];
        $request['ord_address_id'] = $request['ord_company_code'];
        $request['ord_address'] = $request['ord_company_name'];
        $res = NewOrderService::placeOrder($request);
        if ($res['code'] == 200) {
            DB::commit();
        } else {
            DB::rollBack();
        }
        return response()->json($res);
    }

    /**
     * 修改预约时间
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-07-03
     * @param  Request          $request [description]
     * @return [type]                    [description]
     */
    public function editAppointTime(Request $request) {
        $get_ip = getRealIp($request); //获取ip
        // 接收数据流
        $request = file_get_contents("php://input");

        // 解析
        Common::write_log($request, 1, 'editAppointTime');
        $request = json_decode($request, true);
        if (!isset($request['timeStamp']) || !isset($request['key']) || !isset($request['shop_code']) || !isset($request['signature'])) {
            return response()->json(['code'=>501,'msg'=>'签名参数错误','data'=>'']);
        }
        $get_signature = $this->signature($request);
        if (!$get_signature) {
            return response()->json(['code'=>501, 'msg'=>'签名错误','data'=>'']);
        }
        if (empty($request['order_number'])) {
            return response()->json(['code'=>500, 'msg'=>'订单号不能为空','data'=>'']);
        }
        $find_order = DB::table('order')
            ->where('ord_other_system_number', $request['order_number'])
            ->first();
        if (empty($find_order)) {
            return response()->json(['code'=>500, 'msg'=>'未查询到此订单','data'=>'']);
        }
        if (!in_array($find_order->ord_wor_state, [1, 2, 5, 7])) {
            return response()->json(['code'=>500, 'msg'=>'当前订单已完成或终止！', 'data'=>'']);
        }
        // 查询当前订单下是否有正常服务工单
        $find_wor_data = DB::table('work_order')
            ->where('wor_order_id', $find_order->ord_id)
            ->where('wor_delete', 1)
            ->where('wor_state', '<>', 11)
            ->first(['wor_id', 'wor_state']);
        if ($find_wor_data && $find_wor_data->wor_state > 7) {
            return response()->json(['code'=>500, 'msg'=>'当前订单所属工单正在施工中，无法更改预约时间！', 'data'=>'']);
        }
        if (empty($request['orcl_appoint_time'])) {
            return response()->json(['code'=>500, 'msg'=>'预约时间不能为空','data'=>'']);
        }
        $update_data['orcl_appoint_time'] = $request['orcl_appoint_time'];
        $update_data['orcl_update_time'] = date('Y-m-d H:i:s');
        $update_res = DB::table('order_client')
            ->where('orcl_ord_id', $find_order->ord_id)
            ->update($update_data);
        if ($find_wor_data) {
            $update_work['wor_appoint_time'] = $request['orcl_appoint_time'];
            $update_work['wor_update_time'] = date('Y-m-d H:i:s');
            $update_work_res = DB::table('work_order')
                ->where('wor_id', $find_wor_data->wor_id)
                ->update($update_work);
        }
        return response()->json(['code'=>200, 'msg'=>'修改预约时间成功','data'=>'']);
    }

    // 时间+门店编码+随机给门店分配的字符串
    public function signature($data) {
        $find_signature = DB::table('shop_key')
            ->where('shke_shop_code', $data['shop_code'])
            ->where('shke_key', $data['key'])
            ->first();
        if (!$find_signature) {
            return false;
        }
        $signature = md5($data['timeStamp'].$data['shop_code'].$data['key']);
        if ($signature == $data['signature']) {
            return true;
        } else {
            return false;
        }
    }

    // 同步订单
    public function importOrders(Request $request)
    {
        $get_ip = getRealIp($request); //获取ip
        // 接收数据流
        $request = file_get_contents("php://input");

        // 解析
        Common::write_log($request, 1, 'importOrders');
        $request = json_decode($request, true);
        // 验证数据
        $verify_data = new VerifyOtherSystemOrdersController;
        $error_message = $verify_data->importOrdersValidator($request);
        if ($error_message) {
            return response()->json(['code'=>202, 'msg'=>$error_message]);
        }

        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_data = DB::table('shop as s')
            ->leftjoin('shop_correlation as sc', 'sc.shco_shop_id', '=', 's.shop_id')
            ->where('sc.shco_system_shop_id', $request['ord_service_shop_id'])
            // ->where('shco_system_cid',1)
            ->first(['shop_id as adm_shop_id', 'shop_cid as adm_cid', 'shop_superior_id', 'shop_store_name']);
        if (empty($shop_data)) {
            return response()->json(['code'=>203, 'msg'=>'此门店未绑定']);
        }
        // 添加订单表数据
        $ord_order_number = Common::orderRule($shop_data);

        $syor_id = DB::table('system_orders')
            ->where('order_number', $request['ord_order_number'])
            ->value('syor_id');
        if (!empty($syor_id)) {
            return response()->json(['code'=>203, 'msg'=>'工单号重复']);
        }

        $system_orders_data['syor_system_cid'] = $shop_data->adm_cid;
        $system_orders_data['platform_number'] = $request['platform_number']; //速电平台单号
        $system_orders_data['order_number'] = $request['ord_order_number']; //速电平台单号
        $system_orders_data['ord_order_number'] = $ord_order_number; //速电工单号
        $system_orders_data['orcl_name'] = $request['orcl_name'];
        $system_orders_data['orcl_phone'] = $request['orcl_phone']; //客户电话
        $system_orders_data['orcl_province'] = $request['orcl_province']; //省
        $system_orders_data['orcl_city'] = $request['orcl_city']; //市
        $system_orders_data['orcl_county'] = $request['orcl_county']; //区县
        $system_orders_data['orcl_address'] = $request['orcl_address']; //详细地址
        $system_orders_data['ord_service_shop_id'] = $request['ord_service_shop_id']; //速电指派门店id
        $system_orders_data['goo_id'] = $request['goo_id']; //速电系统商品id
        $system_orders_data['goo_name'] = $request['goo_name']; //商品名称
        $system_orders_data['goo_goods_encode'] = $request['goo_code']; //检索编码
        $system_orders_data['goo_quantity'] = $request['goo_quantity']; //商品数量
        $system_orders_data['ord_service_adm_id'] = $request['ord_service_adm_id']; //技师id（门店系统）
        $system_orders_data['ord_service_type'] = $request['ord_service_type'];
        $system_orders_data['ord_client_id'] = $request['ord_client_id'];
        $request['goo_is_recycle'] = 2;
        $system_orders_data['goo_is_recycle'] = $request['goo_is_recycle'];
        $system_orders_data['goo_price'] = $request['goo_price'];

        try {
            DB::beginTransaction();
            $system_orders_res = DB::table('system_orders')->insert($system_orders_data);

            $shop_id = $shop_data->shop_superior_id ? $shop_data->shop_superior_id : $shop_data->adm_shop_id;
            //订单数据
            $ord_data['ord_cid'] = $shop_data->adm_cid;
            $ord_data['ord_shop_id'] = $shop_data->adm_shop_id;
            $ord_data['ord_superior_shop_id'] = $shop_id;
            $ord_data['ord_order_number'] = $ord_order_number;
            $ord_data['ord_service_type'] = 7; //订单类型
            $ord_data['ord_type'] = 3; //速电派单
            $ord_data['ord_order_price'] = $request['goo_price'] * 100; //商品价格
            $ord_data['ord_actual_price'] = $request['goo_price'] * 100; //商品价格
            $ord_data['ord_wor_state'] = 7; //1未派工单2服务中3售后中4已完成5无工单6审核活动7待接单8锁定
            $ord_data['ord_service_shop_id'] = $shop_data->adm_shop_id; //服务门店id
            $ord_data['ord_other_system_number'] = $request['ord_order_number']; //速电单号
            $ord_data['ord_payment_way'] = 1; //结算方式1.账期 2.现结
            $ord_data['ord_goods_quantity'] = $request['goo_quantity']; //商品总数量
            $ord_data['ord_unique_string'] = md5(md5($ord_order_number . $shop_data->adm_shop_id . date('Y-m-d H:i:s') . rand(10000, 99999)) . rand(10000, 99999));
            $ord_data['ord_update_time'] = date('Y-m-d H:i:s');
            $ord_id = DB::table('order')->insertGetid($ord_data);

            $order_client_data['orcl_ord_id'] = $ord_id; //订单id
            $order_client_data['orcl_name'] = $request['orcl_name']; //客户姓名
            $order_client_data['orcl_channel_unit'] = '北京速电快保'; //渠道单位
            $order_client_data['orcl_phone'] = $request['orcl_phone']; //客户电话
            $order_client_data['orcl_province'] = $request['orcl_province']; //省
            $order_client_data['orcl_city'] = $request['orcl_city']; //市
            $order_client_data['orcl_county'] = $request['orcl_county']; //区县
            $order_client_data['orcl_address'] = $request['orcl_address']; //详细地址
            $order_client_data['orcl_order_type'] = 3; //1系统订单2外派订单3速电派单
            // 查询速电的图片上传模板id
            $shit_id = DB::table('shop_image_template')
                ->where('shit_shop_id', 0)
                ->where('shit_delete', 1) //是否删除：1正常2删除
                ->where('shit_template_type', 3) //模板类型：1系统模板2自定义模板3速电模板
                ->value('shit_id');
            $order_client_data['orcl_shit_id'] = $shit_id; //图片模板id
            $order_client_id = DB::table('order_client')->insertGetid($order_client_data);

            // 查找半径与第三方商品绑定关联表关系(半径系统商品id)
            if ($shop_data->adm_shop_id == 0) { //北京门店
                $goco_goo_id = DB::table('goods_correlation')
                    ->where('goco_cid', $shop_data->adm_cid)
                    ->where('goco_shop_id', $shop_data->adm_shop_id)
                    ->where('goco_system_goo_id', $request['goo_id'])
                    ->value('goco_goo_id');
            } else {
                if (empty($request['goo_code']) || empty($request['goo_codenew'])) {
                    return response()->json(['code'=>203, 'msg'=>'系统商品编码不能为空！']);
                }
                // goo_codenew 有X的编码字段
                $goco_goo_id = DB::table('goods')
                    ->where('goo_cid', 0)
                    ->where('goo_shop_id', 0)
                    ->where('goo_delete', 1)
                    ->where('goo_goods_encode', $request['goo_codenew'])
                    ->value('goo_id');
                if (empty($goco_goo_id)) {
                    // goo_code 7位数字系统编码
                    $goco_goo_id = DB::table('goods')
                        ->where('goo_cid', 0)
                        ->where('goo_shop_id', 0)
                        ->where('goo_delete', 1)
                        ->where('goo_goods_encode', $request['goo_code'])
                        ->value('goo_id');
                    if (empty($goco_goo_id)) {
                        return response()->json(['code'=>203, 'msg'=>'非系统商品编码无法派单！']);
                    }
                }
            }
            $goods_data = DB::table('goods')
                ->where('goo_id', $goco_goo_id)
                ->first(['goo_name', 'goo_goods_encode', 'goo_id']);
            if (empty($goods_data)) {
                return response()->json(['code'=>203, 'msg'=>'此订单商品未绑定']);
            }
            $order_goods_data['orgo_ord_id'] = $ord_id; //订单id
            $order_goods_data['orgo_order_number'] = $ord_order_number; //订单号
            $order_goods_data['orgo_goo_id'] = $goods_data->goo_id; //商品id
            $order_goods_data['orgo_goo_name'] = $goods_data->goo_name; //商品名称
            $order_goods_data['orgo_goo_goods_encode'] = $goods_data->goo_goods_encode; //检索编号
            $order_goods_data['orgo_goo_quantity'] = $request['goo_quantity']; //商品数量
            $order_goods_data['orgo_can_assign_quantity'] = $request['goo_quantity']; //商品数量
            $order_goods_data['orgo_is_recycle'] = $request['goo_is_recycle']; //商品是否回收
            $order_goods_data['orgo_goo_price'] = $request['goo_price'] * 100; //商品价格
            $order_goods_res = DB::table('order_goods')->insert($order_goods_data);
            $ord_edit_data['ord_orcl_id'] = $order_client_id;
            $ord_eidt_res = DB::table('order')
                ->where('ord_id', $ord_id)
                ->update($ord_edit_data);
            if ($order_goods_res && $order_client_id && $ord_id && $system_orders_res && $ord_eidt_res) {
                // 添加新增订单信息的提示
                $inhi_data['inhi_original_adm_id'] = 0; //原始单号创建人
                $inhi_data['inhi_original_id'] = $ord_id; //原始单id
                $inhi_data['inhi_original_number'] = $ord_order_number; //原始单号
                $inhi_data['inhi_original_state'] = $ord_data['ord_wor_state']; //原始单状态
                $inhi_data['inhi_original_operation'] = '速电网单'; //操作
                $inhi_data['inhi_operation_state'] = 17; //操作状态：17新速电网单

                // 第三方推送数据
                $inhi_data['modeule_type'] = 3; //模块id；单号类型:1订单2工单3速电网单
                $inhi_data['push_time'] = ''; //推送触发时间,为空则表示立即推送
                $inhi_data['shop_id'] = $ord_data['ord_shop_id']; //门店系统门店id，有门店id就推送门店下的所有用户，没有门店id就推送用户id
                $inhi_data['target_type'] = 0; //接收端类型0=浏览器;1=移动端
                $inhi_data['inhi_create_time'] = date('Y-m-d H:i:s');
                if (config('apimesssage.WHETHER_OPEN')) {
                    $push = new PushMessageController;
                    $push_return = $push->create($inhi_data);
                    if ($push_return['code'] == 500) {
                        $log_data['function'] = 'sdOrderLock';
                        $log_data['order_number'] = $ord_order_number;
                        $log_data['inhi_data'] = $inhi_data;
                        Common::write_record_log($log_data, 'pc/pushMessage.txt', 'importOrders');
                    }
                }

                $user_info['shop_superior_id'] = $ord_data['ord_superior_shop_id'];
                $user_info['adm_shop_id'] = $ord_data['ord_shop_id'];
                $user_info['adm_cid'] = $ord_data['ord_cid'];
                $user_info['adm_id'] = 0;
                addInformationHint((object)$user_info, $inhi_data, 3);

                DB::commit();
                return response()->json(['code'=>200, 'msg'=>'回传成功']);
            } else {
                DB::rollBack();
                return response()->json(['code'=>201, 'msg'=>'回传失败']);
            }
        } catch (Exception $e) {
            return response()->json(['code'=>201, 'msg'=>'回传失败']);
        }
    }

    // 接单
    public function orderReceiving(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyOtherSystemOrdersController;
        $error_message = $verify_data->orderReceivingValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=>500, 'msg'=>$error_message]);
        }

        $order_data = DB::table('order as o')
            ->leftjoin('order_client as oc', 'o.ord_id', '=', 'oc.orcl_ord_id')
            ->where('ord_id', $request['ord_id'])
            ->first(['ord_cid', 'ord_shop_id', 'ord_superior_shop_id', 'ord_other_system_number', 'ord_wor_state', 'ord_order_number', 'ord_type', 'orcl_join_wor_id']);
        if ($order_data->ord_wor_state != 7) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'不是待接单状态,不能接单']);
        }

        $user_info = Common::getUserInfo($request['api_token']);
        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_type = $user_info->shop_superior_id ? 2 : 1; //接单类型：1总店接单2加盟店接单

        DB::beginTransaction();
        $order_update['ord_wor_state'] = 1;
        $order_update['ord_update_time'] = date('Y-m-d H:i:s');
        $order_res = DB::table('order')
            ->where('ord_id', $request['ord_id'])
            ->update($order_update);

        // 判断是否有预约时间
        if (!empty($request['appoint_time'])) {
            $param['daytime'] = $request['appoint_time']; //速电-预约时间

            $orcl_edit['orcl_appoint_time'] = $request['appoint_time'];
            $orcl_edit['orcl_appoint_remark'] = $request['appoint_remark'];
            $orcl_res =  DB::table('order_client')
                ->where('orcl_ord_id', $request['ord_id'])
                ->update($orcl_edit);

            // 预约备注内容
            $remark_data = '预约时间：' . $request['appoint_time'];
            if (!empty($request['appoint_remark'])) {
                $remark_data .= ' ' . $request['appoint_remark'];
            }
            $remark_res = orderRemark($user_info, $request['ord_id'], 0, $remark_data, '订单列表-接单预约');

            if ($orcl_res && $remark_res) {
                $appoint_res = true;
            } else {
                $appoint_res = false;
            }
        } else {
            $appoint_res = true;
        }

        $log_res = orderLog($user_info, $request['ord_id'], 0, '接受订单');
        if ($order_res && $log_res && $appoint_res) {
            // 判断总店、加盟店接单
            if (config('apisystem.SYNC_STATE') && $shop_type == 1) {
                // 总店接单，同步速电
                sdOrderLog($order_data, 0, $order_data->orcl_join_wor_id, '接受订单');
                $url = config('apisystem.sd_server_name') . '/index.php/sync_receipt_status';
                $param['serial_number'] = $order_data->ord_other_system_number; //第三方工单号
                $param['type'] = 1;
                $param['ip'] = getRealIp($request);
                $param['time'] = date('Y-m-d H:i:s'); //收货时间
                $param['token'] = md5(md5($param['time'] . config('apisystem.sd_token'))); //token
                $doPost_res = Common::doPost($param, $url, 2);
                $doPost_res = json_decode($doPost_res);
                if ($doPost_res->code != 200) {
                    DB::rollBack();
                    return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'失败']);
                }
            } else {
                // 加盟店接单
                $wor = DB::table('work_order')->where('wor_id', $order_data->orcl_join_wor_id)->first(['wor_cid as adm_cid', 'wor_superior_shop_id as shop_superior_id', 'wor_shop_id as adm_shop_id']);
                $store_name = DB::table('shop')->where('shop_id', $user_info->adm_shop_id)->value('shop_store_name');
                $wor->adm_name = $store_name;
                $wor->adm_id = 0;
                orderLog($wor, 0, $order_data->orcl_join_wor_id, '接受订单');
            }

            // 添加新增订单信息的提示
            $inhi_data['inhi_original_adm_id'] = 0; //原始单号创建人
            $inhi_data['inhi_original_id'] = $request['ord_id']; //原始单id
            $inhi_data['inhi_original_number'] = $order_data->ord_order_number; //原始单号
            $inhi_data['inhi_original_state'] = $order_update['ord_wor_state']; //原始单状态
            $inhi_data['inhi_original_operation'] = '门店接单'; //操作
            $inhi_data['inhi_operation_state'] = 18; //操作状态：18门店接单
            addInformationHint($user_info, $inhi_data, 3);

            Common::addLog($user_info, getRealIp($request), '订单列表', '接单', '订单:' . $order_data->ord_order_number . ' 接单成功');
            DB::commit();
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>'接单成功']);
        } else {
            DB::rollBack();
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'接单失败']);
        }
    }

    // 门店接单
    public function cyorderReceiving(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyOtherSystemOrdersController;
        $error_message = $verify_data->cyorderReceivingValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=>500, 'msg'=>$error_message]);
        }

        $order_data = DB::table('order as o')
            ->leftjoin('order_client as oc', 'o.ord_id', '=', 'oc.orcl_ord_id')
            ->where('ord_id', $request['ord_id'])
            ->first(['ord_cid', 'ord_shop_id', 'ord_superior_shop_id', 'ord_other_system_number', 'ord_wor_state', 'ord_order_number', 'ord_type', 'orcl_join_wor_id']);
        if ($order_data->ord_wor_state != 7) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'不是待接单状态,不能接单']);
        }

        $user_info = Common::getUserInfo($request['api_token']);
        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_type = $user_info->shop_superior_id ? 2 : 1; //接单类型：1总店接单2加盟店接单

        DB::beginTransaction();
        $order_update['ord_wor_state'] = 1;
        $order_update['ord_update_time'] = date('Y-m-d H:i:s');
        $order_res = DB::table('order')
            ->where('ord_id', $request['ord_id'])
            ->update($order_update);

        // 判断是否有预约时间
        if (!empty($request['appoint_time'])) {
            $orcl_edit['orcl_appoint_time'] = $request['appoint_time'];
            $orcl_edit['orcl_appoint_remark'] = $request['appoint_remark'];
            $orcl_res =  DB::table('order_client')
                ->where('orcl_ord_id', $request['ord_id'])
                ->update($orcl_edit);

            // 预约备注内容
            $remark_data = '预约时间：' . $request['appoint_time'];
            if (!empty($request['appoint_remark'])) {
                $remark_data .= ' ' . $request['appoint_remark'];
            }
            $remark_res = orderRemark($user_info, $request['ord_id'], 0, $remark_data, '订单列表-接单预约');

            if ($orcl_res && $remark_res) {
                $appoint_res = true;
            } else {
                $appoint_res = false;
            }
        } else {
            $appoint_res = true;
        }
        // 门店接单
        // 城市运营中心工单表修改为接单
        $update_data['wor_update_time'] = date('Y-m-d H:i:s');
        // 订单类型：1服务单 2销售单 3换货单 4退货单 5发货单 6结清单
        // 服务类型为销售单/换货单 状态直接修改为：抵达
        // 服务状态：1待接单2已接单3预约4出发5抵达6完成待审核7完成已驳回8完成通过
        $update_data['wor_service_state'] = 2;
        // 1.新订单 2未派单 3待接单/已派单 4.未出发/已接单 5.预约/已预约 6.出发/已出发  7.抵达/抵达 8.待审核/完成待审核 9驳回/完成已驳回 10完成/完成已通过
        $update_data['wor_state'] = 4;
        $sel_paretorid = DB::table('work_client')
            ->where('wocl_join_ord_id', $request['ord_id'])
            ->value('wocl_wor_id');
        $save_state = DB::table('work_order')
            ->where('wor_id', $sel_paretorid)
            ->update($update_data);

        $log_res = orderLog($user_info, $request['ord_id'], 0, '接受订单');
        if ($order_res && $log_res && $appoint_res && $save_state) {

            // 添加新增订单信息的提示
            $inhi_data['inhi_original_adm_id'] = 0; //原始单号创建人
            $inhi_data['inhi_original_id'] = $request['ord_id']; //原始单id
            $inhi_data['inhi_original_number'] = $order_data->ord_order_number; //原始单号
            $inhi_data['inhi_original_state'] = $order_update['ord_wor_state']; //原始单状态
            $inhi_data['inhi_original_operation'] = '门店接单'; //操作
            $inhi_data['inhi_operation_state'] = 18; //操作状态：18门店接单
            addInformationHint($user_info, $inhi_data, 3);

            Common::addLog($user_info, getRealIp($request), '订单列表', '接单', '订单:' . $order_data->ord_order_number . ' 接单成功');
            DB::commit();
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>'接单成功']);
        } else {
            DB::rollBack();
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'接单失败']);
        }
    }

    // 拒单
    public function orderRefuse(Request $request)
    {
        // 验证数据 wocl_wor_id
        $verify_data = new VerifyOtherSystemOrdersController;
        $error_message = $verify_data->orderRefuseValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=>500, 'msg'=>$error_message]);
        }

        $user_info = Common::getUserInfo($request['api_token']);
        $order_data = DB::table('order')
            ->where('ord_id', $request['ord_id'])
            ->first(['ord_other_system_number', 'ord_wor_state', 'ord_order_number', 'ord_type']);
        if (in_array($order_data->ord_wor_state, [2, 3, 4, 5, 6, 8])) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'此订单已派工单,不能拒单']);
        }
        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_type = $user_info->shop_superior_id ? 2 : 1;

        DB::beginTransaction();

        // 加盟店拒单
        if ($shop_type == 2) {
            $join_data = DB::table('order_client as oc')
                ->leftjoin('work_order as wo', 'oc.orcl_join_wor_id', '=', 'wo.wor_id')
                ->where('orcl_ord_id', $request['ord_id'])
                ->first(['wor_order_id', 'orcl_join_wor_id']);

            // 总店工单数据
            $ord_data = DB::table('work_order')
                ->where('wor_id', $join_data->orcl_join_wor_id)
                ->first(['wor_cid as ord_cid', 'wor_shop_id as ord_shop_id', 'wor_superior_shop_id as ord_superior_shop_id', 'wor_order_id']);
            // 总店下的工单数量,总店订单状态为无工单状态
            $ord_res = DB::table('order')
                ->where('ord_id', $ord_data->wor_order_id)
                ->decrement('ord_wor_quantity', 1, ['ord_wor_state' => 5, 'ord_update_time' => date('Y-m-d H:i:s')]);

            $order_record = orderLog($user_info, $request['ord_id'], 0, '加盟店拒单');
            $order_record = sdOrderLog($ord_data, 0, $join_data->orcl_join_wor_id, '加盟店拒单');

            // 删除总店工单数据
            $join_wor_res = DB::table('work_order')
                ->where('wor_id', $join_data->orcl_join_wor_id)
                ->delete();
            $join_good_res = DB::table('work_good')
                ->where('wogo_wor_id', $join_data->orcl_join_wor_id)
                ->delete();
            $join_client_res = DB::table('work_client')
                ->where('wocl_wor_id', $join_data->orcl_join_wor_id)
                ->delete();
        } else {
            $join_wor_res = true;
            $join_good_res = true;
            $join_client_res = true;
            $ord_res = true;
            $order_record = true;
        }
        $order_res = DB::table('order')
            ->where('ord_id', $request['ord_id'])
            ->delete();

        $order_goods_res = DB::table('order_goods')
            ->where('orgo_ord_id', $request['ord_id'])
            ->value('orgo_ord_id');
        if (!empty($order_goods_res)) {
            $order_goods_res = DB::table('order_goods')
                ->where('orgo_ord_id', $request['ord_id'])
                ->delete();
        } else {
            $order_goods_res = true;
        }
        $order_client_res = DB::table('order_client')
            ->where('orcl_ord_id', $request['ord_id'])
            ->delete();

        // 运营中心派单 门店拒单
        if ($order_data->ord_type == 5) {
            // 工单表修改为拒单
            $update_data['wor_update_time'] = date('Y-m-d H:i:s');

            // 服务状态：1待接单2已接单3预约4出发5抵达6完成待审核7完成已驳回8完成通过9终止10锁定11速电撤销回收12工单冲单
            $update_data['wor_service_state'] = 1;

            // 1.新订单 2未派单 3待接单/已派单 4.未出发/已接单 5.预约/已预约 6.出发/已出发  7.抵达/抵达 8.待审核/完成待审核 9驳回/完成已驳回 10完成/完成已通过
            $update_data['wor_state'] = 2;
            $sel_paretworid = DB::table('work_client')
                ->where('wocl_join_ord_id', $request['ord_id'])
                ->value('wocl_wor_id');
            $save_state = DB::table('work_order')
                ->where('wor_id', $sel_paretworid)
                ->update($update_data);
            $ord_parid = DB::table('work_order')
                ->where('wor_id', $sel_paretworid)
                ->value('wor_order_id');

            $update_orddata['ord_wor_state'] = 1;
            $ord_res = DB::table('order')
                ->where('ord_id', $ord_parid)
                ->update($update_orddata);
        } else {
            $ord_res = true;
            $save_state = true;
        }
        if ($order_res && $order_goods_res && $order_client_res && $join_wor_res && $order_record && $ord_res && $save_state) {
            // 速电网单
            if (config('apisystem.SYNC_STATE') && $order_data->ord_type == 3) {
                $url = config('apisystem.sd_server_name') . '/index.php/sync_receipt_status';
                $param['type'] = 2;
                $param['time'] = date('Y-m-d H:i:s'); //收货时间
                $param['ip'] = getRealIp($request);
                $param['sin_bid'] = $request['label_id']; //拒单标签
                $param['sin_bcentent'] = $request['label_name']; //拒单标签名称
                $param['content'] = $request['remark']; //拒单备注
                $param['token'] = md5(md5($param['time'] . config('apisystem.sd_token'))); //token
                $param['serial_number'] = $order_data->ord_other_system_number; //第三方工单号
                $doPost_res = Common::doPost($param, $url, 2);
                $doPost_res = json_decode($doPost_res);
                if ($doPost_res->code != 200) {
                    DB::rollBack();
                    return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'失败']);
                }
            }

            // 添加新增订单信息的提示
            $inhi_data['inhi_original_adm_id'] = 0; //原始单号创建人
            $inhi_data['inhi_original_id'] = $request['ord_id']; //原始单id
            $inhi_data['inhi_original_number'] = $order_data->ord_order_number; //原始单号
            $inhi_data['inhi_original_state'] = 0; //原始单状态
            $inhi_data['inhi_original_operation'] = '门店拒单'; //操作
            $inhi_data['inhi_operation_state'] = 19; //操作状态：19门店拒单
            addInformationHint($user_info, $inhi_data, 3);

            Common::addLog($user_info, getRealIp($request), '订单列表', '拒单', '订单:' . $order_data->ord_order_number . ' 拒单成功');
            DB::commit();
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>'拒单成功']);
        } else {
            DB::rollBack();
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'拒单失败']);
        }
    }

    // 速电锁单/取消锁单
    public function sdOrderLock(Request $request)
    {
        // 接收数据流
        $request = file_get_contents("php://input");
        // 解析
        Common::write_log($request, 2, 'sdOrderLock');
        $request = json_decode($request, true);

        if (empty($request['order_num']) || empty($request['type'])) {
            return response()->json(['code'=>202, 'msg'=>'参数错误']);
        }

        $order_data = DB::table('order')
            ->where('ord_other_system_number', $request['order_num'])
            ->where('ord_type', 3) //1门店零售2渠道单位3速电派单4第三方派单
            ->first(['ord_order_state', 'ord_id', 'ord_wor_state', 'ord_cid', 'ord_superior_shop_id', 'ord_shop_id', 'ord_order_number']);
        if (!$order_data->ord_order_state) {
            return response()->json(['code'=>203, 'msg'=>'未找到此订单']);
        }
        if ($request['type'] == 1) {
            if ($order_data->ord_order_state != 1) {
                return response()->json(['code'=>203, 'msg'=>'此订单已经被锁定,不能锁定']);
            }
            DB::beginTransaction();
            // 锁定
            $lock_return = Common::publicOrderLock(1, 2, $order_data->ord_id, $order_data->ord_wor_state);
            // 记录日志
            $log_data['function'] = 'sdOrderLock';
            $log_data['order_num'] = $request['order_num'];
            $log_data['request'] = $request;
            $log_data['lock_return'] = $lock_return;
            Common::write_record_log($log_data, 'app/OtherSystemOrdersController.txt', 'sdOrderLock');
            if ($lock_return) {
                sdOrderLog($order_data, $order_data->ord_id, 0, '速电锁单');
                // 查询技师信息，推送消息
                $find_wor_data = DB::table('work_order')
                    ->where('wor_order_id', $order_data->ord_id)
                    ->where('wor_delete', 1)
                    ->where('wor_state', '<>', 11)
                    ->select('wor_id', 'wor_number', 'wor_service_adm_id')
                    ->first();
                if (!empty($find_wor_data) && $find_wor_data->wor_service_adm_id) {
                    $adm_phone =  DB::table('admin')
                        ->where('adm_id', $find_wor_data->wor_service_adm_id)
                        ->value('adm_phone');
                    $push_name['alias'][] = $adm_phone; //发送对象
                    $result_push = pushMessage($push_name, '工单：' . $find_wor_data->wor_number . ' 速电已锁定', 5);
                }
                DB::commit();
                return response()->json(['code'=>200, 'msg'=>'锁单成功']);
            } else {
                DB::rollBack();
                return response()->json(['code'=>203, 'msg'=>'锁单失败']);
            }
        } else {
            if ($order_data->ord_order_state != 3) {
                return response()->json(['code'=>200, 'msg'=>'取消锁单成功']);
                // return response()->json(['code'=> 203, 'msg'=>'当前订单不是速电锁定状态，无法取消锁定']);
            }
            DB::beginTransaction();
            // 锁定
            $lock_return = Common::publicOrderLock(2, 2, $order_data->ord_id, $order_data->ord_wor_state);
            // 记录日志
            $log_data['function'] = 'sdOrderLock';
            $log_data['order_num'] = $request['order_num'];
            $log_data['request'] = $request;
            $log_data['lock_return'] = $lock_return;
            Common::write_record_log($log_data, 'app/OtherSystemOrdersController.txt', 'sdOrderLock');
            if ($lock_return) {
                sdOrderLog($order_data, $order_data->ord_id, 0, '速电取消锁单');
                // 查询技师信息，推送消息
                $find_wor_data = DB::table('work_order')
                    ->where('wor_order_id', $order_data->ord_id)
                    ->where('wor_delete', 1)
                    ->where('wor_state', '<>', 11)
                    ->select('wor_id', 'wor_number', 'wor_service_adm_id')
                    ->first();
                if (!empty($find_wor_data) && $find_wor_data->wor_service_adm_id) {
                    $adm_phone =  DB::table('admin')
                        ->where('adm_id', $find_wor_data->wor_service_adm_id)
                        ->value('adm_phone');
                    $push_name['alias'][] = $adm_phone; //发送对象
                    $result_push = pushMessage($push_name, '工单：' . $find_wor_data->wor_number . ' 速电取消锁定', 7);
                }
                DB::commit();
                return response()->json(['code'=>200, 'msg'=>'取消锁单成功']);
            } else {
                DB::rollBack();
                return response()->json(['code'=>203, 'msg'=>'取消锁单失败']);
            }
        }
    }

    // 系统锁单
    public function orderLock(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyOtherSystemOrdersController;
        $error_message = $verify_data->orderLockValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=>500, 'msg'=>$error_message]);
        }

        $order_data = DB::table('order')
            ->where('ord_id', $request['ord_id'])
            ->where('ord_type', 3) //1门店零售2渠道单位3速电派单4第三方派单
            ->first(['ord_order_state', 'ord_id', 'ord_wor_state', 'ord_order_number', 'ord_other_system_number']);
        if (!$order_data->ord_order_state) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'未找到此订单']);
        }
        if ($order_data->ord_order_state != 1) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'此订单已经被锁单,不能锁单']);
        }
        DB::beginTransaction();
        // 锁定
        $lock_return = Common::publicOrderLock(1, 1, $order_data->ord_id, $order_data->ord_wor_state);
        if ($lock_return) {
            // 获取当前操作账号信息
            $user_info = Common::getUserInfo($request['api_token']);
            orderLog($user_info, $order_data->ord_id, 0, '锁单');
            Common::addLog($user_info, getRealIp($request), '订单列表', '锁单', $order_data->ord_order_number . '锁单成功');

            $param['time'] = date('Y-m-d H:i:s'); //收货时间
            $param['serial_num'] = $order_data->ord_other_system_number; //派工单号
            $param['token'] = md5(md5($param['time'] . 'c883e5e641818d993a2d8d966ca450bf')); //token
            $url = config('apisystem.sd_server_name') . '/index.php/lockorder';
            $doPost_res = Common::doPost($param, $url);
            $doPost_res = json_decode($doPost_res);
            if ($doPost_res->code != 200) {
                DB::rollBack();
                return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'失败']);
            }
            // 查询技师信息，推送消息
            $find_wor_data = DB::table('work_order')
                ->where('wor_order_id', $request['ord_id'])
                ->where('wor_delete', 1)
                ->where('wor_state', '<>', 11)
                ->select('wor_id', 'wor_number', 'wor_service_adm_id')
                ->first();
            if (!empty($find_wor_data) && $find_wor_data->wor_service_adm_id) {
                $adm_phone =  DB::table('admin')
                    ->where('adm_id', $find_wor_data->wor_service_adm_id)
                    ->value('adm_phone');
                $push_name['alias'][] = $adm_phone; //发送对象
                $result_push = pushMessage($push_name, '工单：' . $find_wor_data->wor_number . ' 系统已锁定', 6);
            }
            DB::commit();
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>'锁单成功']);
        } else {
            DB::rollBack();
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'锁单失败']);
        }
    }

    // 系统取消锁单
    public function unOrderLock(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyOtherSystemOrdersController;
        $error_message = $verify_data->unOrderLockValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=>500, 'msg'=>$error_message]);
        }

        $order_data = DB::table('order')
            ->where('ord_id', $request['ord_id'])
            ->where('ord_type', 3) //1门店零售2渠道单位3速电派单4第三方派单
            ->first(['ord_order_state', 'ord_id', 'ord_wor_state', 'ord_order_number', 'ord_other_system_number']);
        if (!$order_data->ord_order_state) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'未找到此订单']);
        }
        if ($order_data->ord_order_state != 2) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'此订单没有被锁单,不能取消锁单']);
        }
        DB::beginTransaction();
        // 锁定
        $lock_return = Common::publicOrderLock(2, 1, $order_data->ord_id, $order_data->ord_wor_state);
        if ($lock_return) {
            // 获取当前操作账号信息
            $user_info = Common::getUserInfo($request['api_token']);
            orderLog($user_info, $order_data->ord_id, 0, '取消锁单');
            Common::addLog($user_info, getRealIp($request), '订单列表', '取消锁单', $order_data->ord_order_number . '取消锁单成功');

            $param['time'] = date('Y-m-d H:i:s'); //收货时间
            $param['serial_num'] = $order_data->ord_other_system_number; //派工单号
            $param['token'] = md5(md5($param['time'] . 'c883e5e641818d993a2d8d966ca450bf')); //token
            $url = config('apisystem.sd_server_name') . '/index.php/undoive';
            $doPost_res = Common::doPost($param, $url);
            $doPost_res = json_decode($doPost_res);
            if ($doPost_res->code != 200) {
                DB::rollBack();
                return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'失败']);
            }
            // 查询技师信息，推送消息
            $find_wor_data = DB::table('work_order')
                ->where('wor_order_id', $request['ord_id'])
                ->where('wor_delete', 1)
                ->where('wor_state', '<>', 11)
                ->select('wor_id', 'wor_number', 'wor_service_adm_id')
                ->first();
            if (!empty($find_wor_data) && $find_wor_data->wor_service_adm_id) {
                $adm_phone =  DB::table('admin')
                    ->where('adm_id', $find_wor_data->wor_service_adm_id)
                    ->value('adm_phone');
                $push_name['alias'][] = $adm_phone; //发送对象
                $result_push = pushMessage($push_name, '工单：' . $find_wor_data->wor_number . ' 系统取消锁定', 8);
            }
            DB::commit();
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>'取消锁单成功']);
        } else {
            DB::rollBack();
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'取消锁单失败']);
        }
    }

    // 速电改单
    public function sdOrderEdit(Request $request)
    {
        // 接收数据流
        $request = file_get_contents("php://input");
        // 解析
        Common::write_log($request, 2, 'sdOrderEdit');
        $request = json_decode($request, true);

        if (empty($request['type']) || !in_array($request['type'], [1, 2]) || empty($request['ord_order_number'])) {
            return response()->json(['code'=>202, 'msg'=>'参数错误']);
        }
        $order_data = DB::table('order')
            ->where('ord_other_system_number', $request['ord_order_number'])
            ->where('ord_type', 3)
            ->first(['ord_order_number', 'ord_id', 'ord_cid', 'ord_superior_shop_id', 'ord_shop_id', 'ord_wor_state']);
        if (empty($order_data)) {
            return response()->json(['code'=>203, 'msg'=>'无此订单']);
        }
        DB::beginTransaction();
        // type等于1的时候为修改地址
        if ($request['type'] == 1) {
            if (empty($request['orcl_name']) || empty($request['orcl_phone']) || empty($request['orcl_province']) || empty($request['orcl_city']) || empty($request['orcl_county']) || empty($request['orcl_address'])) {
                return response()->json(['code'=>202, 'msg'=>'参数错误']);
            }

            DB::table('work_client_edit')
                ->where('wced_order_id', $order_data->ord_id)
                ->delete();

            $wced_data['wced_name'] = $request['orcl_name'];
            $wced_data['wced_order_id'] = $order_data->ord_id;
            $wced_data['wced_phone'] = $request['orcl_phone'];
            $wced_data['wced_province'] = $request['orcl_province'];
            $wced_data['wced_city'] = $request['orcl_city'];
            $wced_data['wced_county'] = $request['orcl_county'];
            $wced_data['wced_address'] = $request['orcl_address'];
            $wged_res = DB::table('work_client_edit')->insert($wced_data);
        } else {
            if (empty($request['goo_id']) || empty($request['goo_name']) || empty($request['goo_is_recycle']) || !is_numeric($request['goo_quantity']) || !is_numeric($request['goo_is_recycle'])) {
                return response()->json(['code'=>202, 'msg'=>'参数错误']);
            }
            if (!is_numeric($request['goo_price'])) {
                $request['goo_price'] = 0;
            }
            // 查找半径系统商品id
            if (empty($request['goo_code']) || empty($request['goo_codenew'])) {
                return response()->json(['code'=>203, 'msg'=>'系统商品编码不能为空！']);
            }
            // goo_codenew 有X的编码字段
            $goco_goo_id = DB::table('goods')
                ->where('goo_cid', 0)
                ->where('goo_shop_id', 0)
                ->where('goo_delete', 1)
                ->where('goo_goods_encode', $request['goo_codenew'])
                ->value('goo_id');
            if (empty($goco_goo_id)) {
                // goo_code 7位数字系统编码
                $goco_goo_id = DB::table('goods')
                    ->where('goo_cid', 0)
                    ->where('goo_shop_id', 0)
                    ->where('goo_delete', 1)
                    ->where('goo_goods_encode', $request['goo_code'])
                    ->value('goo_id');
                if (empty($goco_goo_id)) {
                    return response()->json(['code'=>203, 'msg'=>'非系统商品编码无法派单！']);
                }
            }

            $goods_data = DB::table('goods')
                ->where('goo_id', $goco_goo_id)
                ->first(['goo_name', 'goo_goods_encode', 'goo_id']);
            if (empty($goods_data)) {
                return response()->json(['code'=>203, 'msg'=>'此订单商品未绑定']);
            }

            $edit_data[0]['wged_order_id'] = $order_data->ord_id; //订单id
            $edit_data[0]['wged_wogo_id'] = 0;
            $edit_data[0]['wged_wor_id'] = 0;
            $edit_data[0]['wged_goo_id'] = $goods_data->goo_id; //商品id
            $edit_data[0]['wged_goo_name'] = $goods_data->goo_name; //商品名称
            $edit_data[0]['wged_goo_goods_encode'] = $goods_data->goo_goods_encode; //检索编号
            $edit_data[0]['wged_goo_amount'] = $request['goo_quantity']; //商品数量
            $edit_data[0]['wged_is_recycle'] = $request['goo_is_recycle']; //商品是否回收
            $edit_data[0]['wged_goo_price'] = $request['goo_price'] * 100; //商品价格
            $edit_data[0]['wged_state'] = 1; //1正常2删除

            DB::table('work_good_edit')
                ->where('wged_order_id', $order_data->ord_id)
                ->delete();
            $wor_id = DB::table('work_order')
                ->where('wor_order_id', $order_data->ord_id)
                ->value('wor_id');
            if (!empty($wor_id)) {
                $data = DB::table('work_good')
                    ->where('wogo_wor_id', $wor_id)
                    ->first(['wogo_id', 'wogo_goo_id', 'wogo_goo_name', 'wogo_goo_goods_encode', 'wogo_goo_amount', 'wogo_is_recycle', 'wogo_goo_price', 'wogo_waon_class', 'wogo_goo_inventory']);
                $edit_data[1]['wged_order_id'] = $order_data->ord_id; //订单id
                $edit_data[1]['wged_wogo_id'] = $data->wogo_id; //id
                $edit_data[1]['wged_wor_id'] = $wor_id; //工单
                $edit_data[1]['wged_goo_id'] = $data->wogo_goo_id; //商品id
                $edit_data[1]['wged_goo_name'] = $data->wogo_goo_name;
                $edit_data[1]['wged_goo_goods_encode'] = $data->wogo_goo_goods_encode;
                $edit_data[1]['wged_goo_amount'] = $data->wogo_goo_amount;
                $edit_data[1]['wged_is_recycle'] = $data->wogo_is_recycle;
                $edit_data[1]['wged_goo_price'] = $data->wogo_goo_price;
                $edit_data[1]['wged_waon_class'] = $data->wogo_waon_class;
                $edit_data[0]['wged_waon_class'] = $data->wogo_waon_class;
                $edit_data[0]['wged_goo_inventory'] = $data->wogo_goo_inventory;
                $edit_data[1]['wged_goo_inventory'] = $data->wogo_goo_inventory;
                $edit_data[1]['wged_state'] = 2;
            }
            $wged_res = DB::table('work_good_edit')->insert($edit_data);
        }
        // 已经锁定的就不用锁定了
        if ($order_data->ord_wor_state == 8) {
            $lock_res = true;
        } else {
            $lock_res = Common::publicOrderLock(1, 2, $order_data->ord_id, $order_data->ord_wor_state);
        }
        $order_res = DB::table('order')
            ->where('ord_id', $order_data->ord_id)
            ->update(['ord_order_state' => 9, 'ord_update_time' => date('Y-m-d H:i:s')]);
        if ($wged_res && $order_res) {
            sdOrderLog($order_data, $order_data->ord_id, 0, '速电改单');
            // 添加新增订单信息的提示
            $inhi_data['inhi_original_adm_id'] = 0; //原始单号创建人
            $inhi_data['inhi_original_id'] = $order_data->ord_id; //原始单id
            $inhi_data['inhi_original_number'] = $order_data->ord_order_number; //原始单号
            $inhi_data['inhi_original_state'] = $order_data->ord_wor_state; //原始单状态
            $inhi_data['inhi_original_operation'] = '速电申请改单'; //操作
            $inhi_data['inhi_operation_state'] = 20; //操作状态：20速电申请改单
            $user_info['shop_superior_id'] = $order_data->ord_superior_shop_id;
            $user_info['adm_shop_id'] = $order_data->ord_shop_id;
            $user_info['adm_cid'] = $order_data->ord_cid;
            $user_info['adm_id'] = 0;
            addInformationHint((object)$user_info, $inhi_data, 3);

            DB::commit();
            return response()->json(['code'=>200, 'msg'=>'改单申请成功']);
        } else {
            DB::rollBack();
            return response()->json(['code'=>500, 'msg'=>'改单申请失败']);
        }
    }

    // 审核速电的改单请求
    public function changePass(Request $request)
    {
        // 使用验证器 验证数据
        $verify_data = new VerifyOtherSystemOrdersController;
        $error_message = $verify_data->changePassValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=>500, 'msg'=>$error_message, 'data'=>'{}']);
        }

        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);
        $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;
        if ($request['type'] == 1) { //返回页面数据
            // 要改成的商品
            $data['new_good_edit'] = DB::table('work_good_edit')
                ->where('wged_order_id', $request['ord_id'])
                ->where('wged_wogo_id', 0)
                ->get(['wged_id', 'wged_goo_name', 'wged_goo_goods_encode', 'wged_goo_type', 'wged_state', 'wged_goo_price', 'wged_collection_price', 'wged_goo_amount', 'wged_goo_inventory', 'wged_goo_id']);
            $data['new_good_edit'] = json_decode(json_encode($data['new_good_edit']), true);
            if (!empty($data['new_good_edit'])) {
                // 改单之前的商品
                $data['old_good_edit'] = DB::table('order_goods')
                    ->where('orgo_ord_id', $request['ord_id'])
                    ->get(['orgo_goo_name', 'orgo_goo_goods_encode', 'orgo_goo_type', 'orgo_state', 'orgo_goo_price', 'orgo_collection_price', 'orgo_goo_quantity', 'orgo_goo_inventory']);
            } else {
                $data['old_good_edit'] = [];
                $data['new_good_edit'] = [];
            }
            $data['new_client_edit'] = DB::table('work_client_edit')
                ->where('wced_order_id', $request['ord_id'])
                ->first(['wced_name', 'wced_phone', 'wced_car_num', 'wced_province', 'wced_city', 'wced_county', 'wced_address']);
            $data['new_client_edit'] = json_decode(json_encode($data['new_client_edit']), true);
            if (!empty($data['new_client_edit'])) {
                $data['old_client_edit'] = DB::table('order_client')
                    ->where('orcl_ord_id', $request['ord_id'])
                    ->first(['orcl_name', 'orcl_phone', 'orcl_car_num', 'orcl_province', 'orcl_city', 'orcl_county', 'orcl_address']);
            } else {
                $data['old_client_edit'] = [];
                $data['new_client_edit'] = [];
            }
            // 查询工单信息，查询不是删除状态的工单，不是终止状态的工单
            $wocl_sd_virtual_type = DB::table('work_order as wo')
                ->leftjoin('work_client as wc', 'wc.wocl_wor_id', '=', 'wo.wor_id')
                ->where('wor_order_id', $request['ord_id'])
                ->where('wor_delete', 1)
                ->where('wor_state', '<>', 11)
                ->value('wocl_sd_virtual_type');
            // 是否为速电派到加盟店的工单1是 2否
            if (empty($wocl_sd_virtual_type)) {
                $wocl_sd_virtual_type = 2;
            }
            $data['sd_virtual_type'] = $wocl_sd_virtual_type;
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$data]);
        }

        // 查找订单信息
        $find_order = DB::table('order')
            ->where('ord_id', $request['ord_id'])
            ->select('ord_state', 'ord_type', 'ord_other_system_number', 'ord_cid', 'ord_superior_shop_id', 'ord_shop_id', 'ord_order_state', 'ord_id', 'ord_order_number', 'ord_client_id')
            ->first();
        // 判断订单是否存在
        if (empty($find_order)) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'未找到此订单']);
        }
        // 结算状态1未结算2已结算3已核销4已收款
        if ($find_order->ord_state != 1) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'当前订单已结算，无法审核！']);
        }
        // 查询工单信息，查询不是删除状态的工单，不是终止状态的工单
        $find_wor_data = DB::table('work_order as wo')
            ->leftjoin('work_client as wc', 'wc.wocl_wor_id', 'wo.wor_id')
            ->where('wor_order_id', $request['ord_id'])
            ->where('wor_delete', 1)
            ->where('wor_state', '<>', 11)
            ->select('wor_id', 'wor_number', 'wor_order_number', 'wor_create_id', 'wor_service_type', 'wor_service_sepr_id', 'wor_state', 'wor_service_state', 'wor_pass', 'wor_service_adm_id', 'wor_service_shop_id', 'wor_ware_id', 'wor_remark', 'wor_orla_id', 'wor_type', 'wocl_wor_type', 'wor_plus_minus', 'wocl_before_wor_state')
            ->first();

        // 查询速电改单的客户信息
        $find_change_client = DB::table('work_client_edit')
            ->where('wced_order_id', $request['ord_id'])
            ->first();
        // 查询速电改单的商品信息
        $find_change_goods = DB::table('work_good_edit')
            ->where('wged_order_id', $request['ord_id'])
            ->get()->toArray();
        if (empty($find_change_client) && empty($find_change_goods)) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'未查询到改单信息！']);
        }
        // 更改商品信息
        if (!empty($find_change_goods)) {
            if (empty($request['ware_id']) && ($find_wor_data->wocl_wor_type != 4)) {
                return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'请选择仓库！']);
            }
            // 并且门店已经派单 不是虚拟加盟的
            if ($find_wor_data && ($find_wor_data->wocl_wor_type != 4)) {
                // 查询工单生成的发货单是否有未发货单的
                $find_disp = DB::table('dispatch_bill')
                    ->where('dego_order_type', 2) //类型：1.订单发货 2.工单发货3售后单发货
                    ->whereIn('dego_type', [1, 4]) //类型：1未出库2已出库3作废4锁定
                    ->where('dego_wor_id', $find_wor_data->wor_id)
                    ->select('dego_id', 'dego_type', 'dego_wor_id')
                    ->first();
                // 如果发货单已经发货
                if (empty($find_disp)) {
                    // 技师没有拒单或终止，不允许审核通过
                    if ($find_wor_data->wor_service_adm_id != 0) {
                        return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'技师尚未拒单或终止，无法审核改单！']);
                    }
                    // 查询APP拒单、终止生成的退换回收单是否入库
                    $find_rec_data = DB::table('recede_recycle')
                        ->where('rec_ord_id', $find_wor_data->wor_id)
                        ->whereIn('rec_source_type', [6, 7])
                        ->select('rec_id', 'rec_state', 'rec_ware_id')
                        ->orderBy('rec_id', 'desc')
                        ->first();
                    if ($find_rec_data && $find_rec_data->rec_state == 1) {
                        return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'已拒单商品未入库，无法审核改单！']);
                    }
                }
            }
        }

        DB::beginTransaction();
        // 判断是否有更改客户信息
        if (!empty($find_change_client)) {
            // 更改订单的客户信息
            $orcl_edit['orcl_name']  = $find_change_client->wced_name;
            $orcl_edit['orcl_phone']  = $find_change_client->wced_phone;
            $orcl_edit['orcl_car_num']  = $find_change_client->wced_car_num;
            $orcl_edit['orcl_province']  = $find_change_client->wced_province;
            $orcl_edit['orcl_city']  = $find_change_client->wced_city;
            $orcl_edit['orcl_county']  = $find_change_client->wced_county;
            $orcl_edit['orcl_address']  = $find_change_client->wced_address;
            $orcl_edit['ord_order_state']  = 1; //订单锁定状态1正常2系统锁定3速电锁定
            if (!empty($find_change_client->wced_collect_state)) {
                $orcl_edit['orcl_collect_state'] = $find_change_client->wced_collect_state; //技师收钱：0未选择1是2否
            }
            $ord_client_res = DB::table('order as o')
                ->leftjoin('order_client as oc', 'oc.orcl_ord_id', '=', 'o.ord_id')
                ->where('ord_id', $request['ord_id'])
                ->update($orcl_edit);

            // 更改工单的客户信息
            $wocl_edit['wocl_name']  = $find_change_client->wced_name;
            $wocl_edit['wocl_phone']  = $find_change_client->wced_phone;
            $wocl_edit['wocl_car_num']  = $find_change_client->wced_car_num;
            $wocl_edit['wocl_province']  = $find_change_client->wced_province;
            $wocl_edit['wocl_city']  = $find_change_client->wced_city;
            $wocl_edit['wocl_county']  = $find_change_client->wced_county;
            $wocl_edit['wocl_address']  = $find_change_client->wced_address;
            $wocl_edit['wocl_longitude']  = $request['wocl_longitude'] ?? '';
            $wocl_edit['wocl_latitude']  = $request['wocl_latitude'] ?? '';
            if (!empty($find_wor_data->wor_id)) {
                // 工单
                $work_client_res = DB::table('work_client')
                    ->where('wocl_wor_id', $find_wor_data->wor_id)
                    ->update($wocl_edit);
            } else {
                $work_client_res = true;
            }
            // 删除速电改单的数据
            $wced_del_res = DB::table('work_client_edit')
                ->where('wced_order_id', $request['ord_id'])
                ->delete();
        } else {
            $ord_client_res = true;
            $work_client_res = true;
            $wced_del_res = true;
        }

        // 如果工单是虚拟加盟店
        if (isset($find_wor_data->wocl_wor_type) &&  $find_wor_data->wocl_wor_type == 4) {
            $virtual_update_res = $this->virtualUpdate($user_info, $find_change_goods, $request, $find_wor_data, $find_order);
            return response()->json($virtual_update_res);
        }

        // 判断是否有更改商品信息
        if (!empty($find_change_goods)) {
            $request_new_good = json_decode($request['new_good'], true);
            $request_new_good = array_column($request_new_good, null, 'wged_id');
            // 查询订单商品信息
            $find_old_order_goods = DB::table('order_goods')
                ->where('orgo_ord_id', $request['ord_id'])
                ->whereNotIn('orgo_state', [2, 3, 4])
                ->select('orgo_ware_id', 'orgo_waon_class', 'orgo_wago_id', 'orgo_goo_id', 'orgo_goo_quantity', 'orgo_goo_inventory', 'orgo_wafr_id', 'orgo_wafg_id')
                ->get()->toArray();
            // 删除原来的速电订单商品，商品表里没有存订单商品id
            $orgo_del_res = DB::table('order_goods')
                ->where('orgo_ord_id', $request['ord_id'])
                ->where('orgo_state', 1)
                ->delete();
            if (!$orgo_del_res) {
                DB::rollBack();
                return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'审核失败！001']);
            }
            $orgo = [];
            $wogo = [];
            $order_price = 0;
            $num = 0;
            $goo_all_quantity = 0;
            foreach ($find_change_goods as $key => $value) {
                // 速电改单的商品
                if ($value->wged_wogo_id == 0) {
                    if (isset($request_new_good[$value->wged_id])) {
                        $value->wged_goo_inventory = $request_new_good[$value->wged_id]['wged_goo_inventory'];
                    } else {
                        DB::rollBack();
                        return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'请选择出库方式！']);
                    }
                    // 工单商品主键id为0的，说明是新添加的商品
                    $find_goods_data = DB::table('goods')
                        ->where('goo_id', $value->wged_goo_id)
                        ->first(['goo_ampere_hour']);
                    // 根据仓库id,仓库类别和商品id查询对应仓库商品表的主键id
                    $wago_id = DB::table('warehouse_goods')
                        ->where('wago_ware_id', $request['ware_id'])
                        ->where('wago_class', $value->wged_waon_class)
                        ->where('wago_goo_id', $value->wged_goo_id)
                        ->value('wago_id');
                    // 订单商品数据
                    $add_orgo['orgo_ord_id'] = $request['ord_id'];
                    $add_orgo['orgo_order_number'] = $find_order->ord_order_number;
                    $add_orgo['orgo_ware_id'] = $request['ware_id'];
                    $add_orgo['orgo_wago_id'] = $wago_id;
                    $add_orgo['orgo_goo_id'] = $value->wged_goo_id;
                    $add_orgo['orgo_is_recycle'] = $value->wged_is_recycle;
                    $add_orgo['orgo_goo_name'] = $value->wged_goo_name;
                    $add_orgo['orgo_goo_goods_encode'] = $value->wged_goo_goods_encode;
                    $add_orgo['orgo_goo_type'] = $value->wged_goo_type;
                    $add_orgo['orgo_state'] = $value->wged_state;
                    $add_orgo['orgo_goo_inventory'] = $value->wged_goo_inventory;
                    $add_orgo['orgo_recycle_quantity'] = $value->wged_recycle_quantity;
                    $add_orgo['orgo_goo_price'] = $value->wged_goo_price;
                    $add_orgo['orgo_goo_quantity'] = $value->wged_goo_amount;
                    $add_orgo['orgo_can_assign_quantity'] = $value->wged_goo_amount;
                    $add_orgo['orgo_goo_ampere_hour'] = $find_goods_data->goo_ampere_hour;
                    $add_orgo['orgo_update_time'] = date('Y-m-d H:i:s');
                    // 更改订单商品信息
                    $orgo_add_res = DB::table('order_goods')->insertGetId($add_orgo);
                    if (!$orgo_add_res) {
                        DB::rollBack();
                        return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'审核失败！002']);
                    }
                    // 工单商品数据
                    if ($find_wor_data) {
                        $add_wogo[$num]['wogo_wor_id'] = $find_wor_data->wor_id;
                    }
                    $add_wogo[$num]['wogo_ware_id'] = $request['ware_id'];
                    $add_wogo[$num]['wogo_wago_id'] = $wago_id;
                    $add_wogo[$num]['wogo_orgo_id'] = $orgo_add_res;
                    $add_wogo[$num]['wogo_goo_id'] = $value->wged_goo_id;
                    $add_wogo[$num]['wogo_is_recycle'] = $value->wged_is_recycle;
                    $add_wogo[$num]['wogo_goo_name'] = $value->wged_goo_name;
                    $add_wogo[$num]['wogo_goo_goods_encode'] = $value->wged_goo_goods_encode;
                    $add_wogo[$num]['wogo_goo_type'] = $value->wged_goo_type;
                    $add_wogo[$num]['wogo_state'] = $value->wged_state;
                    $add_wogo[$num]['wogo_goo_inventory'] = $value->wged_goo_inventory;
                    $add_wogo[$num]['wogo_recycle_quantity'] = $value->wged_recycle_quantity;
                    $add_wogo[$num]['wogo_goo_price'] = $value->wged_goo_price;
                    $add_wogo[$num]['wogo_goo_amount'] = $value->wged_goo_amount;
                    $add_wogo[$num]['wogo_update_time'] = date('Y-m-d H:i:s');

                    // 固定仓库商品正常库存转锁定
                    $normal_digo_goo_id[] = $value->wged_goo_id;
                    $normal_digo_goo_number[$value->wged_goo_id] = $value->wged_goo_amount;
                    $normal_digo_goo_inventory[$value->wged_goo_id] = $value->wged_goo_inventory;
                    $normal_digo_wago_class[$value->wged_goo_id] = 1;
                    // [仓库商品id][出库类型：良品/优先]，用于判断仓库是否有库存
                    if (isset($neaten_goods_data[$wago_id][$value->wged_goo_inventory])) {
                        $neaten_goods_data[$wago_id][$value->wged_goo_inventory]['goo_quantity'] += $value->wged_goo_amount;
                        $value->goo_id = $value->wged_goo_id;
                        $value->goo_quantity = $value->wged_goo_amount;
                        $value->goo_waon_class = $value->wged_waon_class;
                    } else {
                        $neaten_goods_data[$wago_id][$value->wged_goo_inventory] = $value;
                        $value->goo_id = $value->wged_goo_id;
                        $value->goo_quantity = $value->wged_goo_amount;
                        $value->goo_waon_class = $value->wged_waon_class;
                    }
                    // 发货单商品数据
                    $dego_goo_data[$num]['digo_orgo_id'] = $orgo_add_res;
                    $dego_goo_data[$num]['digo_wago_id'] = $wago_id;
                    $dego_goo_data[$num]['digo_wago_class'] = $value->wged_waon_class;
                    $dego_goo_data[$num]['digo_goo_id'] = $value->wged_goo_id;
                    $dego_goo_data[$num]['digo_goo_price'] = $value->wged_goo_price;
                    $dego_goo_data[$num]['digo_goo_quantity'] = $value->wged_goo_amount;
                    $dego_goo_data[$num]['digo_is_recycle'] = $value->wged_is_recycle;
                    $dego_goo_data[$num]['digo_goo_inventory'] = $value->wged_goo_inventory;
                    $dego_goo_data[$num]['digo_goo_name'] = $value->wged_goo_name;
                    $dego_goo_data[$num]['digo_goo_goods_encode'] = $value->wged_goo_goods_encode;
                    $dego_goo_data[$num]['digo_goo_type'] = $value->wged_goo_type;

                    $num++;
                    $order_price += $value->wged_goo_price * $value->wged_goo_amount;
                    $goo_all_quantity += $value->wged_goo_amount;

                    // [仓库商品id]，用于锁定库存处理
                    if (isset($neaten_wagl_data[$wago_id])) {
                        $neaten_wagl_data[$wago_id]['goo_quantity'] += $value->wged_goo_amount;
                    } else {
                        $neaten_wagl_data[$wago_id]['goo_quantity'] = $value->wged_goo_amount;
                    }
                }
            }
            // 更改订单商品信息
            if ($add_orgo) {
                // 更改订单信息
                $order_update['ord_order_state'] = 1; //订单锁定状态1正常2系统锁定3速电锁定4第三方系统锁定
                $order_update['ord_ware_id'] = $request['ware_id'];
                $order_update['ord_order_price'] = $order_price;
                $order_update['ord_actual_price'] = $order_price;
                $order_update['ord_update_time'] = date('Y-m-d H:i:s');
                $ord_update_res = DB::table('order')
                    ->where('ord_id', $request['ord_id'])
                    ->update($order_update);
                if (!$ord_update_res) {
                    DB::rollBack();
                    return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'审核失败1']);
                }
            }

            // 更改工单商品信息
            if (!empty($find_wor_data) && $add_wogo) {
                // 删除之前的商品
                $wogo_del_res = DB::table('work_good')
                    ->where('wogo_wor_id', $find_wor_data->wor_id)
                    ->where('wogo_state', 1)
                    ->delete();
                // 新增速电换货的商品
                $wogo_add_res = DB::table('work_good')->insert($add_wogo);

                $wor_update['wor_ware_id'] = $request['ware_id'];
                $wor_update['wor_actual_price'] = $order_price;
                $wor_update['wor_update_time'] = date('Y-m-d H:i:s');
                $wor_update_res = DB::table('work_order')
                    ->where('wor_id', $find_wor_data->wor_id)
                    ->update($wor_update);
                // 判断订单的可派单数量
                $find_order_goods = DB::table('order_goods')
                    ->where('orgo_ord_id', $request['ord_id'])
                    ->select('orgo_id', 'orgo_goo_quantity', 'orgo_can_assign_quantity')
                    ->get();
                $find_order_goods = json_decode(json_encode($find_order_goods, true), true);
                foreach ($find_order_goods as $key => $value) {
                    $assign_quantity = $value['orgo_can_assign_quantity'] - $value['orgo_goo_quantity'];
                    if ($assign_quantity < 0) {
                        DB::rollBack();
                        return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'可派单商品数量不足，无法派单']);
                    }
                    $orgo_res = DB::table('order_goods')
                        ->where('orgo_ord_id', $request['ord_id'])
                        ->update(['orgo_can_assign_quantity' => $assign_quantity]);
                    if (!$orgo_res) {
                        DB::rollBack();
                        return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'审核失败2']);
                    }
                }
                if (!$wogo_del_res || !$wogo_add_res || !$wor_update_res) {
                    DB::rollBack();
                    return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'审核失败2']);
                }
            }

            /*
                1.判断是否需要更改商品锁定数量
                1.1如果没有生成工单或者工单取消了，不需要更改商品锁定数量

                1.2如果已经生成工单，需要更改商品锁定数量
                1.2.1如果已经生成工单，并且已经派单，会有发货单，判断发货单是否发货
                1.2.1.1如果发货单没有发货，作废原来的发货单，生成新的发货单
                固定仓库原来商品锁定数量减少，库存数量增加
                固定仓库新的商品锁定数量增加，库存数量减少
                1.2.1.2如果发货单已经发货，需要技师拒单之后才能审核改单；
                技师拒单或终止之后，工单是未派单状态，固定仓库新的商品锁定数量增加，库存数量减少

                还有一种情况需要在确定，技师终止工单，会有一个终止的工单，一个新生成的工单，把新生成的工单取消
            */
            // 已经生成工单
            if (!empty($find_wor_data) && $add_wogo) {
                $find_order->ord_ware_id = $request['ware_id'];
                // 查询仓库id是否为移动仓库，移动仓库没有锁定库存
                // ware_type 类型：1固定仓2技师库3移动仓
                $ware_type = DB::table('warehouse')
                    ->where('ware_id', $find_order->ord_ware_id)
                    ->value('ware_type');

                if ($find_disp) {
                    // 已经派单的工单有未发货的发货单，作废原来的发货单，固定仓库原来的商品锁定数量减少，库存数量增加
                    // 查询出原来发货单的商品
                    $find_digo_goods = DB::table('dispatch_goods')
                        ->where('digo_dego_id', $find_disp->dego_id)
                        ->get()->toArray();
                    foreach ($find_digo_goods as $key => $value) {
                        $digo_goo_id[] = $value->digo_goo_id;
                        $digo_goo_number[$value->digo_goo_id] = $value->digo_goo_quantity;
                        $digo_goo_inventory[$value->digo_goo_id] = $value->digo_goo_inventory;
                        $digo_wago_class[$value->digo_goo_id] = $value->digo_wago_class;
                    }
                    // 原来的固定仓库商品锁定库存转正常库存
                    $lock_turn_normal = Order::cancelOrderChangeWafgstock(
                        $user_info,
                        $ware_type,
                        $request,
                        $find_old_order_goods,
                        $find_order
                    );
                    if ($lock_turn_normal['code'] == 500) {
                        DB::rollBack();
                        return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'审核失败3']);
                    }
                    // 作废原来的发货单
                    $edit_disp['dego_type'] = 3;
                    $edit_disp['dego_update_time'] = date('Y-m-d H:i:s');
                    $disp_res = DB::table('dispatch_bill')
                        ->where('dego_id', $find_disp->dego_id)
                        ->update($edit_disp);
                    if (!$disp_res) {
                        DB::rollBack();
                        return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'审核失败4']);
                    }
                } else {
                    // 没有未发货的发货单，可能的情况
                    // 1.没有生成发货单，
                    // 2. 发货单已经发货了
                    // 3. 技师拒单或终止了，工单是未派单状态

                    // 如果发货单已经发货，并且技师拒单或终止，会生成退换入库单，
                    // 退换入库单商品入库之后在仓库内会增加商品的锁定数量，这个是原来商品的锁定数量，需要减去
                    if ($find_rec_data && $find_rec_data->rec_state == 2) {
                        $find_rego_goods = DB::table('recede_goods')
                            ->where('rego_rec_id', $find_rec_data->rec_id)
                            ->select('rego_goo_id', 'rego_waon_class', 'rego_recycle_number', 'rego_goo_inventory', 'rego_ware_id')
                            ->get()->toArray();
                        foreach ($find_rego_goods as $key => $value) {
                            $rego_goo_id[] = $value->rego_goo_id;
                            $rego_goo_number[$value->rego_goo_id] = $value->rego_recycle_number;
                            $rego_goo_inventory[$value->rego_goo_id] = $value->rego_goo_inventory;
                            $rego_wago_class[$value->rego_goo_id] = $value->rego_waon_class;
                        }
                        // 原来的固定仓库商品锁定库存转正常库存
                        $lock_turn_normal = Order::cancelOrderChangeWafgstock(
                            $user_info,
                            $ware_type,
                            $request,
                            $find_old_order_goods,
                            $find_order
                        );
                        // 原来的仓库商品解除锁定
                        $edit_wagl_data['wagl_state'] = 2;
                        $edit_wagl_data['wagl_update_time'] = date('Y-m-d H:i:s');
                        $edit_wagl_res = DB::table('warehouse_goods_lock')
                            ->where('wagl_shop_id', $find_order->ord_shop_id)
                            ->where('wagl_ware_id', $request['ware_id'])
                            // ->where('wagl_original_correlation_id', $request['ord_id'])
                            ->where('wagl_original_id', $request['ord_id'])
                            ->where('wagl_original_number', $find_order->ord_order_number)
                            ->update($edit_wagl_data);
                        // 原来仓位商品解除锁定
                        $edit_wfgl_data['wfgl_state'] = 2;
                        $edit_wfgl_data['wfgl_update_time'] = date('Y-m-d H:i:s');
                        $edit_wfgl_res = DB::table('warehouse_freight_goods_lock')
                            ->where('wfgl_shop_id', $find_order->ord_shop_id)
                            ->where('wfgl_ware_id', $request['ware_id'])
                            ->where('wfgl_original_id', $request['ord_id'])
                            ->where('wfgl_original_number', $find_order->ord_order_number)
                            ->where('wfgl_type', 1)
                            ->update($edit_wfgl_data);

                        if ($edit_wfgl_res || $edit_wagl_res) {
                            $edit = true;
                        }
                        if ($lock_turn_normal['code'] == 500 || !$edit) {
                            DB::rollBack();
                            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'审核失败5']);
                        }
                    }
                }

                // 判断选择的仓库是否是固定仓库，固定仓库新的商品锁定数量增加，库存数量减少，移动仓库不更改
                $ware_type = DB::table('warehouse')
                    ->where('ware_id', $request['ware_id'])
                    ->value('ware_type');
                // ware_type 类型：1固定仓2移动仓
                if ($ware_type == 1) {
                    // 原来有发货单，生成新的发货单
                    if ($find_disp) {
                        $return_disp = $this->createNewDispatchBill(
                            $user_info,
                            $shop_id,
                            $find_wor_data,
                            $find_order->ord_client_id,
                            $dego_goo_data,
                            $goo_all_quantity,
                            $request->all()
                        );
                        if ($return_disp['code'] == 500) {
                            DB::rollBack();
                            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'审核失败6']);
                        }
                    }
                    // 商品正常库存转锁定库存
                    $order_data['data']['ord_id'] = $request['ord_id'];
                    $order_data['data']['ord_order_number'] = $find_order->ord_order_number;
                    $order_data['data']['shop_id'] = $user_info->adm_shop_id;
                    $order_data['data']['ord_type'] = $find_order->ord_type;
                    $order_data['data']['ord_client_id'] = $find_order->ord_client_id;
                    $neaten_goods_data = json_decode(json_encode($neaten_goods_data, true), true);
                    $normal_turn_lock = WarehouseLock::warehouseLockInventory(
                        $user_info,
                        $request->all(),
                        $order_data,
                        $neaten_goods_data
                    );
                    $wagl_key = 0;
                    foreach ($neaten_wagl_data as $wago_id => $goo_value) {
                        // 仓库商品锁定表
                        $wagl_data[$wagl_key]['wagl_shop_id'] = $find_order->ord_shop_id;
                        $wagl_data[$wagl_key]['wagl_ware_id'] = $request['ware_id'];
                        $wagl_data[$wagl_key]['wagl_wago_id'] = $wago_id;
                        $wagl_data[$wagl_key]['wagl_original_id'] = $request['ord_id'];
                        $wagl_data[$wagl_key]['wagl_original_number'] = $find_order->ord_order_number;
                        $wagl_data[$wagl_key]['wagl_original_correlation_id'] = $request['ord_id']; //关联id：订单id/发货单id/调拨单id
                        $wagl_data[$wagl_key]['wagl_correlation_type'] = 1; //关联类型：1订单2发货单3调拨单
                        $wagl_data[$wagl_key]['wagl_type'] = 1; //  原始单类型：1订单2调拨单
                        $wagl_data[$wagl_key]['wagl_state'] = 1; //锁定状态：1下单锁定2出库解锁
                        $wagl_data[$wagl_key]['wagl_lock_quantity'] = $goo_value['goo_quantity'];
                        $wagl_key++;
                    }
                    $wagl_res = DB::table('warehouse_goods_lock')->insert($wagl_data);
                    if ($normal_turn_lock['code'] == 500 || !$wagl_res) {
                        DB::rollBack();
                        return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'审核失败7']);
                    }
                }
            }

            $wged_del_res = DB::table('work_good_edit')
                ->where('wged_order_id', $request['ord_id'])
                ->delete();
        } else {
            $wged_del_res = true;
        }

        $lock_res = Common::publicOrderLock(2, 1, $request['ord_id']);

        if ($lock_res && $ord_client_res && $work_client_res && $wced_del_res && $wged_del_res) {
            orderLog($user_info, $find_order->ord_id, 0, '审核通过速电改单');
            if ($find_wor_data) {
                // 当前工单有技师，推送消息提醒
                if ($find_wor_data->wor_service_adm_id) {
                    $adm_phone =  DB::table('admin')
                        ->where('adm_id', $find_wor_data->wor_service_adm_id)
                        ->value('adm_phone');
                    $push_name['alias'][] = $adm_phone; //发送对象
                    $result_push = pushMessage($push_name, '工单：' . $find_wor_data->wor_number . ' 改单成功', 9);
                }
                orderLog($user_info, 0, $find_wor_data->wor_id, '审核通过速电改单');
            }
            Common::addLog($user_info, getRealIp($request), '订单列表', '审核改单', $find_order->ord_order_number . '速电改单审核通过成功');

            // 添加新增订单信息的提示
            $inhi_data['inhi_original_adm_id'] = 0; //原始单号创建人
            $inhi_data['inhi_original_id'] = $find_order->ord_id; //原始单id
            $inhi_data['inhi_original_number'] = $find_order->ord_order_number; //原始单号
            $inhi_data['inhi_original_state'] = $find_order->ord_order_state; //原始单状态
            $inhi_data['inhi_original_operation'] = '速电改单通过'; //操作
            $inhi_data['inhi_operation_state'] = 21; //操作状态：21速电改单通过
            addInformationHint($user_info, $inhi_data, 3);

            DB::commit();
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>'审核成功']);
        } else {
            DB::rollBack();
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'审核失败8']);
        }
    }

    /**
     * [createNewDispatchBill 生成发货单]
     * @param  [type] $user_info        [用户信息]
     * @param  [type] $shop_id          [总店id]
     * @param  [type] $find_wor_data    [工单信息]
     * @param  [type] $ord_client_id    [客户单位id]
     * @param  [type] $dego_goo_data    [发货单商品数据]
     * @param  [type] $goo_all_quantity [商品总数量]
     * @param  [type] $request          [提交数据]
     * @return [type]                   [description]
     */
    private function createNewDispatchBill(
        $user_info,
        $shop_id,
        $find_wor_data,
        $ord_client_id,
        $dego_goo_data,
        $goo_all_quantity,
        $request
    ) {
        // 2.生成新的发货单
        $dego_number = 'FH' . time() . rand(100, 999);
        $bill_data['dego_cid'] = $user_info->adm_cid; //公司id
        $bill_data['dego_shop_id'] = $user_info->adm_shop_id; //门店id
        $bill_data['dego_superior_shop_id'] = $shop_id; //所属总店id
        $bill_data['dego_number'] = $dego_number; //发货单号
        $bill_data['dego_order_type'] = 2; //类型：1.订单发货 2.工单发货
        $bill_data['dego_wor_id'] = $find_wor_data->wor_id; //发货单关联的工单id
        $bill_data['dego_original_number'] = $find_wor_data->wor_number; //原始单号,发货单的关联单号(工单号)
        $bill_data['dego_client_type'] = $find_wor_data->wor_type; //买家类型：1.会员零售2.客户单位3.速电派单4.第三方派单
        $bill_data['dego_client_id'] = $ord_client_id; //选择的客户id,会员id/单位id
        $bill_data['dego_count'] = $goo_all_quantity; //发货总数量
        $bill_data['dego_out_ware_id'] = $request['ware_id']; //出库仓库id
        $bill_data['dego_service_shop_id'] = $find_wor_data->wor_service_shop_id; //服务门店id
        $bill_data['dego_service_adm_id'] = $find_wor_data->wor_service_adm_id; //服务技师id
        $bill_data['dego_type'] = 1; //类型：1未出库2已出库
        $bill_data['dego_create_adm_id'] = $user_info->adm_id; //创建人id
        $bill_data['dego_remark'] = $find_wor_data->wor_remark; //备注
        $dispatch_bill = DB::table('dispatch_bill')->insertGetId($bill_data); // 发货单表添加数据

        foreach ($dego_goo_data as $key => $value) {
            $dego_goo_data[$key]['digo_dego_id'] = $dispatch_bill;
        }
        $dego_res = DB::table('dispatch_goods')->insert($dego_goo_data); // 发货单商品表添加数据
        if ($dispatch_bill && $dego_res) {
            return ['code'=>200, 'msg'=>'success', 'data'=>'生成发货单成功'];
        } else {
            return ['code'=>500, 'msg'=>'error', 'data'=>'生成发货单失败'];
        }
    }

    /**
     * [otherNormalTurnLock 正常库存转锁定库存，已废弃]
     * @param  [type] $user_info      [用户信息]
     * @param  [type] $ware_id        [仓库id]
     * @param  [type] $goo_id         [数组，商品id,数组]
     * @param  [type] $goo_quantity   [数组，商品id=>商品数量]
     * @param  [type] $goo_inventory  [数组，商品id=>库存扣除方式 1.良品 2.优先]
     * @param  [type] $goo_wago_class [数组，商品id=>仓库类别]
     * @return [type]                 [description]
     */
    private function otherNormalTurnLock(
        $user_info,
        $ware_id,
        $goo_id,
        $goo_quantity,
        $goo_inventory,
        $goo_wago_class
    ) {
        // 2.选中的固定仓减锁定库存
        $warehouse_goods = DB::table('warehouse_goods')
            ->where('wago_ware_id', $ware_id)
            ->whereIn('wago_class', $goo_wago_class)
            ->whereIn('wago_goo_id', $goo_id)
            ->get(['wago_id', 'wago_class', 'wago_goo_id', 'wago_stock_number', 'wago_priority_stock_number'])
            ->toArray();
        foreach ($warehouse_goods as $key => $value) {
            $warehouse_class_goods[$value->wago_class][$value->wago_goo_id] = (array)$value;
        }
        foreach ($goo_id as $key => $value) {
            $new_goo_arr['goo_id'] = $value;
            $new_goo_arr['goo_inventory'] = $goo_inventory[$value];
            $new_goo_arr['goo_quantity'] = $goo_quantity[$value];
            $wago_class_goods[$goo_wago_class[$value]][$value] = $new_goo_arr; //仓库类型对应的商品，进销存计算
            unset($new_goo_arr);
        }

        // 仓库商品表 减锁定库存数量 加原来的库存数量
        $sql = 'UPDATE `faster_warehouse_goods` SET ';
        $stock_number_sql = '';
        $lock_quantity_sql = '';
        $priority_stock_number_sql = '';
        $priority_lock_quantity_sql = '';
        $time_sql = '';
        $ids = '';
        $fine_total_quantity = 0; //良品总数量
        $priority_total_quantity = 0; //优先总数量
        $waon_class_fine_quantity = []; //仓库类别对应良品库存总数量
        $waon_class_priority_quantity = []; //仓库类别对应优先库存总数量

        foreach ($wago_class_goods as $waon_class => $class_goods_data) {
            foreach ($class_goods_data as $goo_id => $value) {
                // 商品出库类型，良品出库
                if ($value['goo_inventory'] == 1) {
                    // 良品剩余库存数量
                    $surplus_quantity = $warehouse_class_goods[$waon_class][$goo_id]['wago_stock_number'] - $value['goo_quantity'];
                    if ($surplus_quantity < 0) {
                        return ['code'=>500, 'msg'=>'error', 'data'=>'仓库内商品数量不足'];
                    }
                    // 库存数量增加
                    $stock_number_sql = $stock_number_sql . ' WHEN ' . $warehouse_class_goods[$waon_class][$goo_id]['wago_id'] . ' THEN `wago_stock_number` - ' . $value['goo_quantity'];
                    // 锁定数量减少
                    $lock_quantity_sql = $lock_quantity_sql . ' WHEN ' . $warehouse_class_goods[$waon_class][$goo_id]['wago_id'] . ' THEN `wago_lock_quantity` + ' . $value['goo_quantity'];

                    // 优先数量
                    $priority_stock_number_sql = $priority_stock_number_sql . ' WHEN ' . $warehouse_class_goods[$waon_class][$goo_id]['wago_id'] . ' THEN `wago_priority_stock_number` - 0';
                    $priority_lock_quantity_sql = $priority_lock_quantity_sql . ' WHEN ' . $warehouse_class_goods[$waon_class][$goo_id]['wago_id'] . ' THEN `wago_priority_lock_quantity` + 0';

                    $fine_total_quantity = $fine_total_quantity + $value['goo_quantity'];
                    if (isset($waon_class_fine_quantity[$waon_class])) {
                        $waon_class_fine_quantity[$waon_class] += $value['goo_quantity']; //仓库类别对应良品库存总数量
                    } else {
                        $waon_class_fine_quantity[$waon_class] = $value['goo_quantity']; //仓库类别对应良品库存总数量
                    }
                    // 商品出库类型，优先出库
                } else {
                    // 优先剩余库存数量
                    $surplus_quantity = $warehouse_class_goods[$waon_class][$goo_id]['wago_priority_stock_number'] - $value['goo_quantity'];
                    if ($surplus_quantity < 0) {
                        return ['code'=>500, 'msg'=>'error', 'data'=>'仓库内商品数量不足'];
                    }

                    // 库存数量增加
                    $stock_number_sql = $stock_number_sql . ' WHEN ' . $warehouse_class_goods[$waon_class][$goo_id]['wago_id'] . ' THEN `wago_stock_number` - 0';
                    // 锁定数量减少
                    $lock_quantity_sql = $lock_quantity_sql . ' WHEN ' . $warehouse_class_goods[$waon_class][$goo_id]['wago_id'] . ' THEN `wago_lock_quantity` + 0';

                    // 优先数量
                    $priority_stock_number_sql = $priority_stock_number_sql . ' WHEN ' . $warehouse_class_goods[$waon_class][$goo_id]['wago_id'] . ' THEN `wago_priority_stock_number` - ' . $value['goo_quantity'];
                    $priority_lock_quantity_sql = $priority_lock_quantity_sql . ' WHEN ' . $warehouse_class_goods[$waon_class][$goo_id]['wago_id'] . ' THEN `wago_priority_lock_quantity` + ' . $value['goo_quantity'];

                    $priority_total_quantity = $priority_total_quantity + $value['goo_quantity'];
                    if (isset($waon_class_priority_quantity[$waon_class])) {
                        $waon_class_priority_quantity[$waon_class] += $value['goo_quantity']; //仓库类别对应优先库存总数量
                    } else {
                        $waon_class_priority_quantity[$waon_class] = $value['goo_quantity']; //仓库类别对应优先库存总数量
                    }
                }

                $time_sql = $time_sql . ' WHEN ' . $warehouse_class_goods[$waon_class][$goo_id]['wago_id'] . ' THEN "' . date('Y-m-d H:i:s') . '"'; // 更改时间
                $ids = $ids . $warehouse_class_goods[$waon_class][$goo_id]['wago_id'] . ',';
            }
        }
        $sql = $sql . ' `wago_stock_number`=  CASE `wago_id` ' . $stock_number_sql . ' END,';
        $sql = $sql . ' `wago_lock_quantity`=  CASE `wago_id` ' . $lock_quantity_sql . ' END,';
        $sql = $sql . ' `wago_priority_stock_number`=  CASE `wago_id` ' . $priority_stock_number_sql . ' END,';
        $sql = $sql . ' `wago_priority_lock_quantity`=  CASE `wago_id` ' . $priority_lock_quantity_sql . ' END,';
        $sql = $sql . ' `wago_update_time`=  CASE `wago_id` ' . $time_sql . ' END';
        $sql = $sql . ' WHERE `wago_id` IN (' . trim($ids, ',') . ')';
        $update_wago_res = DB::update($sql);

        // 查询仓库总数量仓库的类别对应的id
        $goo_wago_class = array_unique($goo_wago_class);
        $find_waon_data = DB::table('warehouse_onhand')
            ->where('waon_ware_id', '=', $ware_id)
            ->whereIn('waon_class', $goo_wago_class)
            ->pluck('waon_id', 'waon_class')->toArray();

        // 良品库存总数量更改
        if ($waon_class_fine_quantity) {
            $sql = 'UPDATE `faster_warehouse_onhand` SET ';
            $stock_fine_sql = '';
            $lock_fine_sql = '';
            $time_sql = '';
            $ids = '';
            foreach ($waon_class_fine_quantity as $key => $value) {
                $stock_fine_sql = $stock_fine_sql . ' WHEN ' . $find_waon_data[$key] . ' THEN `waon_stock_fine_amount` - ' . $value;
                $lock_fine_sql = $lock_fine_sql . ' WHEN ' . $find_waon_data[$key] . ' THEN `waon_lock_fine_amount` + ' . $value;
                $time_sql = $time_sql . ' WHEN ' . $find_waon_data[$key] . ' THEN "' . date('Y-m-d H:i:s') . '"';

                $ids = $ids . $find_waon_data[$key] . ',';
            }
            $sql = $sql . ' `waon_stock_fine_amount`=  CASE `waon_id` ' . $stock_fine_sql . ' END,';
            $sql = $sql . ' `waon_lock_fine_amount`=  CASE `waon_id` ' . $lock_fine_sql . ' END,';
            $sql = $sql . ' `waon_update_time`=  CASE `waon_id` ' . $time_sql . ' END';
            $sql = $sql . ' WHERE `waon_id` IN (' . trim($ids, ',') . ')';
            $waon_fine_res = DB::update($sql);
        } else {
            $waon_fine_res = true;
        }

        // 优先库存总数量更改
        if ($waon_class_priority_quantity) {
            $sql = 'UPDATE `faster_warehouse_onhand` SET ';
            $stock_fine_sql = '';
            $lock_fine_sql = '';
            $time_sql = '';
            $ids = '';
            foreach ($waon_class_priority_quantity as $key => $value) {
                $stock_fine_sql = $stock_fine_sql . ' WHEN ' . $find_waon_data[$key] . ' THEN `waon_stock_priority_amount` - ' . $value;
                $lock_fine_sql = $lock_fine_sql . ' WHEN ' . $find_waon_data[$key] . ' THEN `waon_lock_priority_amount` + ' . $value;
                $time_sql = $time_sql . ' WHEN ' . $find_waon_data[$key] . ' THEN "' . date('Y-m-d H:i:s') . '"';

                $ids = $ids . $find_waon_data[$key] . ',';
            }
            $sql = $sql . ' `waon_stock_priority_amount`=  CASE `waon_id` ' . $stock_fine_sql . ' END,';
            $sql = $sql . ' `waon_lock_priority_amount`=  CASE `waon_id` ' . $lock_fine_sql . ' END,';
            $sql = $sql . ' `waon_update_time`=  CASE `waon_id` ' . $time_sql . ' END';
            $sql = $sql . ' WHERE `waon_id` IN (' . trim($ids, ',') . ')';
            $waon_priority_res = DB::update($sql);
        } else {
            $waon_priority_res = true;
        }

        if ($update_wago_res && $waon_fine_res && $waon_priority_res) {
            return ['code'=>200, 'msg'=>'success', 'data'=>'成功'];
        } else {
            return ['code'=>500, 'msg'=>'error', 'data'=>'失败'];
        }
    }

    /**
     * [otherLockTurnNormal 锁定库存转正常库存，已废弃]
     * @param  [type] $user_info      [用户信息]
     * @param  [type] $ware_id        [仓库id]
     * @param  [type] $goo_id         [数组，商品id,数组]
     * @param  [type] $goo_quantity   [数组，商品id=>商品数量]
     * @param  [type] $goo_inventory  [数组，商品id=>出库类型 1.良品 2.优先]
     * @param  [type] $goo_wago_class [数组，商品id=>仓库类别]
     * @return [type]                 [description]
     */
    private function otherLockTurnNormal(
        $user_info,
        $ware_id,
        $goo_id,
        $goo_quantity,
        $goo_inventory,
        $goo_wago_class
    ) {
        // 2.选中的固定仓减锁定库存
        $warehouse_goods = DB::table('warehouse_goods')
            ->where('wago_ware_id', $ware_id)
            ->whereIn('wago_class', $goo_wago_class)
            ->whereIn('wago_goo_id', $goo_id)
            ->get(['wago_id', 'wago_class', 'wago_goo_id', 'wago_lock_quantity', 'wago_priority_lock_quantity'])
            ->toArray();
        foreach ($warehouse_goods as $key => $value) {
            $warehouse_class_goods[$value->wago_class][$value->wago_goo_id] = (array)$value;
        }
        foreach ($goo_id as $key => $value) {
            $new_goo_arr['goo_id'] = $value;
            $new_goo_arr['goo_inventory'] = $goo_inventory[$value];
            $new_goo_arr['goo_quantity'] = $goo_quantity[$value];
            $wago_class_goods[$goo_wago_class[$value]][$value] = $new_goo_arr; //仓库类型对应的商品，进销存计算
            unset($new_goo_arr);
        }

        // 仓库商品表 减锁定库存数量 加原来的库存数量
        $sql = 'UPDATE `faster_warehouse_goods` SET ';
        $stock_number_sql = '';
        $lock_quantity_sql = '';
        $priority_stock_number_sql = '';
        $priority_lock_quantity_sql = '';
        $time_sql = '';
        $ids = '';
        $fine_total_quantity = 0; //良品总数量
        $priority_total_quantity = 0; //优先总数量
        $waon_class_fine_quantity = []; //仓库类别对应良品库存总数量
        $waon_class_priority_quantity = []; //仓库类别对应优先库存总数量

        foreach ($wago_class_goods as $waon_class => $class_goods_data) {
            foreach ($class_goods_data as $goo_id => $value) {
                // 商品出库类型，良品出库
                if ($value['goo_inventory'] == 1) {
                    // 良品剩余库存数量
                    $surplus_quantity = $warehouse_class_goods[$waon_class][$goo_id]['wago_lock_quantity'] - $value['goo_quantity'];
                    if ($surplus_quantity < 0) {
                        return ['code'=>500, 'msg'=>'error', 'data'=>'仓库内锁定商品数量不足'];
                    }
                    // 库存数量增加
                    $stock_number_sql = $stock_number_sql . ' WHEN ' . $warehouse_class_goods[$waon_class][$goo_id]['wago_id'] . ' THEN `wago_stock_number` + ' . $value['goo_quantity'];
                    // 锁定数量减少
                    $lock_quantity_sql = $lock_quantity_sql . ' WHEN ' . $warehouse_class_goods[$waon_class][$goo_id]['wago_id'] . ' THEN `wago_lock_quantity` - ' . $value['goo_quantity'];

                    // 优先数量
                    $priority_stock_number_sql = $priority_stock_number_sql . ' WHEN ' . $warehouse_class_goods[$waon_class][$goo_id]['wago_id'] . ' THEN `wago_priority_stock_number` + 0';
                    $priority_lock_quantity_sql = $priority_lock_quantity_sql . ' WHEN ' . $warehouse_class_goods[$waon_class][$goo_id]['wago_id'] . ' THEN `wago_priority_lock_quantity` - 0';

                    $fine_total_quantity = $fine_total_quantity + $value['goo_quantity'];
                    if (isset($waon_class_fine_quantity[$waon_class])) {
                        $waon_class_fine_quantity[$waon_class] += $value['goo_quantity']; //仓库类别对应良品库存总数量
                    } else {
                        $waon_class_fine_quantity[$waon_class] = $value['goo_quantity']; //仓库类别对应良品库存总数量
                    }
                    // 商品出库类型，优先出库
                } else {
                    // 优先剩余库存数量
                    $surplus_quantity = $warehouse_class_goods[$waon_class][$goo_id]['wago_priority_lock_quantity'] - $value['goo_quantity'];
                    if ($surplus_quantity < 0) {
                        return ['code'=>500, 'msg'=>'error', 'data'=>'仓库内锁定商品数量不足'];
                    }

                    // 库存数量增加
                    $stock_number_sql = $stock_number_sql . ' WHEN ' . $warehouse_class_goods[$waon_class][$goo_id]['wago_id'] . ' THEN `wago_stock_number` + 0';
                    // 锁定数量减少
                    $lock_quantity_sql = $lock_quantity_sql . ' WHEN ' . $warehouse_class_goods[$waon_class][$goo_id]['wago_id'] . ' THEN `wago_lock_quantity` - 0';

                    // 优先数量
                    $priority_stock_number_sql = $priority_stock_number_sql . ' WHEN ' . $warehouse_class_goods[$waon_class][$goo_id]['wago_id'] . ' THEN `wago_priority_stock_number` + ' . $value['goo_quantity'];
                    $priority_lock_quantity_sql = $priority_lock_quantity_sql . ' WHEN ' . $warehouse_class_goods[$waon_class][$goo_id]['wago_id'] . ' THEN `wago_priority_lock_quantity` - ' . $value['goo_quantity'];

                    $priority_total_quantity = $priority_total_quantity + $value['goo_quantity'];
                    if (isset($waon_class_priority_quantity[$waon_class])) {
                        $waon_class_priority_quantity[$waon_class] += $value['goo_quantity']; //仓库类别对应优先库存总数量
                    } else {
                        $waon_class_priority_quantity[$waon_class] = $value['goo_quantity']; //仓库类别对应优先库存总数量
                    }
                }

                $time_sql = $time_sql . ' WHEN ' . $warehouse_class_goods[$waon_class][$goo_id]['wago_id'] . ' THEN "' . date('Y-m-d H:i:s') . '"'; // 更改时间
                $ids = $ids . $warehouse_class_goods[$waon_class][$goo_id]['wago_id'] . ',';
            }
        }
        $sql = $sql . ' `wago_stock_number`=  CASE `wago_id` ' . $stock_number_sql . ' END,';
        $sql = $sql . ' `wago_lock_quantity`=  CASE `wago_id` ' . $lock_quantity_sql . ' END,';
        $sql = $sql . ' `wago_priority_stock_number`=  CASE `wago_id` ' . $priority_stock_number_sql . ' END,';
        $sql = $sql . ' `wago_priority_lock_quantity`=  CASE `wago_id` ' . $priority_lock_quantity_sql . ' END,';
        $sql = $sql . ' `wago_update_time`=  CASE `wago_id` ' . $time_sql . ' END';
        $sql = $sql . ' WHERE `wago_id` IN (' . trim($ids, ',') . ')';
        $update_wago_res = DB::update($sql);

        // 查询仓库总数量仓库的类别对应的id
        $goo_wago_class = array_unique($goo_wago_class);
        $find_waon_data = DB::table('warehouse_onhand')
            ->where('waon_ware_id', '=', $ware_id)
            ->whereIn('waon_class', $goo_wago_class)
            ->pluck('waon_id', 'waon_class')->toArray();

        // 良品库存总数量更改
        if ($waon_class_fine_quantity) {
            $sql = 'UPDATE `faster_warehouse_onhand` SET ';
            $stock_fine_sql = '';
            $lock_fine_sql = '';
            $time_sql = '';
            $ids = '';
            foreach ($waon_class_fine_quantity as $key => $value) {
                $stock_fine_sql = $stock_fine_sql . ' WHEN ' . $find_waon_data[$key] . ' THEN `waon_stock_fine_amount` + ' . $value;
                $lock_fine_sql = $lock_fine_sql . ' WHEN ' . $find_waon_data[$key] . ' THEN `waon_lock_fine_amount` - ' . $value;
                $time_sql = $time_sql . ' WHEN ' . $find_waon_data[$key] . ' THEN "' . date('Y-m-d H:i:s') . '"';

                $ids = $ids . $find_waon_data[$key] . ',';
            }
            $sql = $sql . ' `waon_stock_fine_amount`=  CASE `waon_id` ' . $stock_fine_sql . ' END,';
            $sql = $sql . ' `waon_lock_fine_amount`=  CASE `waon_id` ' . $lock_fine_sql . ' END,';
            $sql = $sql . ' `waon_update_time`=  CASE `waon_id` ' . $time_sql . ' END';
            $sql = $sql . ' WHERE `waon_id` IN (' . trim($ids, ',') . ')';
            $waon_fine_res = DB::update($sql);
        } else {
            $waon_fine_res = true;
        }

        // 优先库存总数量更改
        if ($waon_class_priority_quantity) {
            $sql = 'UPDATE `faster_warehouse_onhand` SET ';
            $stock_fine_sql = '';
            $lock_fine_sql = '';
            $time_sql = '';
            $ids = '';
            foreach ($waon_class_priority_quantity as $key => $value) {
                $stock_fine_sql = $stock_fine_sql . ' WHEN ' . $find_waon_data[$key] . ' THEN `waon_stock_priority_amount` + ' . $value;
                $lock_fine_sql = $lock_fine_sql . ' WHEN ' . $find_waon_data[$key] . ' THEN `waon_lock_priority_amount` - ' . $value;
                $time_sql = $time_sql . ' WHEN ' . $find_waon_data[$key] . ' THEN "' . date('Y-m-d H:i:s') . '"';

                $ids = $ids . $find_waon_data[$key] . ',';
            }
            $sql = $sql . ' `waon_stock_priority_amount`=  CASE `waon_id` ' . $stock_fine_sql . ' END,';
            $sql = $sql . ' `waon_lock_priority_amount`=  CASE `waon_id` ' . $lock_fine_sql . ' END,';
            $sql = $sql . ' `waon_update_time`=  CASE `waon_id` ' . $time_sql . ' END';
            $sql = $sql . ' WHERE `waon_id` IN (' . trim($ids, ',') . ')';
            $waon_priority_res = DB::update($sql);
        } else {
            $waon_priority_res = true;
        }

        if ($update_wago_res && $waon_fine_res && $waon_priority_res) {
            return ['code'=>200, 'msg'=>'success', 'data'=>'成功'];
        } else {
            return ['code'=>500, 'msg'=>'error', 'data'=>'失败'];
        }
    }

    // 催单
    public function sdReminder(Request $request)
    {
        // 接收数据流
        $request = file_get_contents("php://input");
        // 解析
        Common::write_log($request, 2, 'sdReminder');
        $request = json_decode($request, true);

        if (empty($request['ord_order_number']) || empty($request['type']) || empty($request['orre_id'])) {
            return response()->json(['code'=>202, 'msg'=>'参数错误']);
        }
        // 等于1订单催单，等于2售后单催单
        if ($request['type'] == 1) {
            $order_data = DB::table('order')
                ->where('ord_other_system_number', $request['ord_order_number'])
                ->where('ord_type', 3)
                ->first(['ord_order_number', 'ord_id', 'ord_cid', 'ord_superior_shop_id', 'ord_shop_id', 'ord_wor_state']);
            if (empty($order_data)) {
                return response()->json(['code'=>203, 'msg'=>'无此订单']);
            }
            DB::beginTransaction();
            $data['orre_cid'] = $order_data->ord_cid;
            $data['orre_superior_shop_id'] = $order_data->ord_superior_shop_id;
            $data['orre_shop_id'] = $order_data->ord_shop_id;
            $data['orre_order_id'] = $order_data->ord_id;
            $data['orre_order_number'] = $order_data->ord_order_number;
            $data['orre_sd_id'] = $request['orre_id'];
            $data['orre_remark'] = $request['remark'] ?: '';
            $res = DB::table('order_reminder')->insert($data);

            $order['orcl_reminder_state'] = 1;
            $order['orcl_update_time'] = date('Y-m-d H:i:s');

            $order_res = DB::table('order_client')
                ->where('orcl_ord_id', $order_data->ord_id)
                ->update($order);

            // 添加新增订单信息的提示
            $inhi_data['inhi_original_id'] = $order_data->ord_id; //原始单id
            $inhi_data['inhi_original_number'] = $order_data->ord_order_number; //原始单号
            $inhi_data['inhi_original_state'] = $order_data->ord_wor_state; //原始单状态
            $user_info['shop_superior_id'] = $order_data->ord_superior_shop_id;
            $user_info['adm_shop_id'] = $order_data->ord_shop_id;
            $user_info['adm_cid'] = $order_data->ord_cid;
            $user_info['adm_id'] = 0;
        } else {
            $order_data = DB::table('order_after')
                ->where('oraf_other_system_number', $request['ord_order_number'])
                ->where('oraf_type', 3)
                ->first(['oraf_order_number', 'oraf_id', 'oraf_cid', 'oraf_superior_shop_id', 'oraf_shop_id', 'oraf_wor_state']);
            if (empty($order_data)) {
                return response()->json(['code'=>203, 'msg'=>'无此订单']);
            }
            DB::beginTransaction();
            $data['oare_cid'] = $order_data->oraf_cid;
            $data['oare_superior_shop_id'] = $order_data->oraf_superior_shop_id;
            $data['oare_shop_id'] = $order_data->oraf_shop_id;
            $data['oare_order_id'] = $order_data->oraf_id;
            $data['oare_order_number'] = $order_data->oraf_order_number;
            $res = DB::table('order_after_reminder')->insert($data);

            $order['orac_reminder_state'] = 1;
            $order['orac_update_time'] = date('Y-m-d H:i:s');

            $order_res = DB::table('order_after_client')
                ->where('orac_oraf_id', $order_data->oraf_id)
                ->update($order);

            // 添加新增订单信息的提示
            $inhi_data['inhi_original_id'] = $order_data->oraf_id; //原始单id
            $inhi_data['inhi_original_number'] = $order_data->oraf_order_number; //原始单号
            $inhi_data['inhi_original_state'] = $order_data->oraf_wor_state; //原始单状态

            $user_info['shop_superior_id'] = $order_data->oraf_superior_shop_id;
            $user_info['adm_shop_id'] = $order_data->oraf_shop_id;
            $user_info['adm_cid'] = $order_data->oraf_cid;
            $user_info['adm_id'] = 0;
        }
        if ($res && $order_res) {
            sdOrderLog($order_data, $order_data->ord_id, 0, '速电催单');

            // 添加新增订单信息的提示
            $inhi_data['inhi_original_adm_id'] = 0; //原始单号创建人
            $inhi_data['inhi_original_operation'] = '速电催单'; //操作
            $inhi_data['inhi_operation_state'] = 22; //操作状态：22速电催单
            addInformationHint((object)$user_info, $inhi_data, 3);

            DB::commit();
            return response()->json(['code'=>200, 'msg'=>'催单成功']);
        } else {
            DB::rollBack();
            return response()->json(['code'=>203, 'msg'=>'催单失败']);
        }
    }

    // 速电退单
    public function recycleOrder(Request $request)
    {
        // 接收数据流
        $request = file_get_contents("php://input");
        // 解析
        Common::write_log($request, 2, 'recycleOrder');
        $request = json_decode($request, true);

        if (empty($request['type']) || !in_array($request['type'], [1, 2]) || empty($request['ord_order_number']) || !isset($request['orcl_consent_price']) || !is_numeric($request['orcl_consent_price']) || empty($request['remark'])) {
            return response()->json(['code'=>202, 'msg'=>'参数错误']);
        }
        $order_data = DB::table('order')
            ->where('ord_other_system_number', $request['ord_order_number'])
            ->where('ord_type', 3)
            ->first(['ord_order_number', 'ord_id', 'ord_cid', 'ord_superior_shop_id', 'ord_shop_id', 'ord_wor_state', 'ord_create_time']);
        if (empty($order_data)) {
            return response()->json(['code'=>203, 'msg'=>'无此订单']);
        }
        $user_info = (object)[];
        $user_info->adm_cid = $order_data->ord_cid;
        $user_info->adm_shop_id = $order_data->ord_shop_id;
        $user_info->shop_superior_id = $order_data->ord_superior_shop_id;
        $user_info->adm_id = 0;
        $msg = $request['type'] == 1 ? '撤销' : '回收';
        if ($order_data->ord_wor_state == 4) { //4已完成
            return response()->json(['code'=>203, 'msg'=>'此订单已完成不能' . $msg]);
        }
        DB::beginTransaction();
        $data['ord_update_time'] = date('Y-m-d H:i:s');
        $data['ord_remark'] = $request['remark'];
        // 速电退单，无论速电是撤销还是回收，在门店系统中都改成撤销回收
        $request['type'] = 2;
        // 撤销
        if ($request['type'] == 1) {
            $data['ord_order_price'] = $request['orcl_consent_price'] * 100;
            $data['orcl_consent_state'] = 1;
            $data['orcl_consent_type'] = 1;
            $data['ord_wor_state'] = 8;
            $order_res = DB::table('order as o')
                ->leftjoin('order_client as oc', 'o.ord_id', '=', 'oc.orcl_ord_id')
                ->where('ord_id', $order_data->ord_id)
                ->update($data);

            if ($request['orcl_consent_price'] > 0) {
                $sd_chan_info = config('apisystem.sd_chan_info');
                // 3.订单应收
                $ord_bill = ReceivableBill::create(
                    $user_info, //用户信息
                    3, //类型：1.销售订单 2.预收款 3.订单账单 4.工单账单 5.采购账单 6.销售账单
                    0, //应收账款id
                    $order_data->ord_id, //原始id(订单id)
                    $order_data->ord_order_number, //应收账款单号/原始号(订单编号)
                    6, //客户类型：1.门店零售 2.来往单位 6.速电派单
                    0, //派单门店id
                    $sd_chan_info['name'], //派单门店名称
                    $request['orcl_consent_price'] * 100, //结算金额(应收金额)
                    '', //结款时间
                    0, //会计科目id
                    $request['orcl_consent_price'] * 100, //实际金额(应收金额)
                    0, //抹零金额
                    1,  //状态：1.未核销 2.已核销
                    1,  //应收账单id是否是自己 1.不是 2.是
                    $data['ord_remark'],  //备注
                    0,  //已收金额
                    '', //截止时间
                    1, //金额正负1正   2负值
                    1, //显示类型：1订单收款
                    $order_data->ord_create_time,
                    1 //是否合并代收：1是2否
                );
            }

            $wor_data['wor_state'] = 12;
            $wor_data['wor_service_state'] = 10;
            $wor_data['wocl_consent_state'] = 1;
            $wor_data['wor_update_time'] = date('Y-m-d H:i:s');
        } else {
            $data['ord_wor_state'] = 9;
            $data['orcl_consent_state'] = 2;
            $order_res = DB::table('order as o')
                ->leftjoin('order_client as oc', 'o.ord_id', '=', 'oc.orcl_ord_id')
                ->where('ord_id', $order_data->ord_id)
                ->update($data);
            $wor_data['wor_service_state'] = 10; //10锁定
            $wor_data['wor_state'] = 12; //1.新订单 2未派单 3待接单/已派单 4.未出发/已接单 5.预约/已预约 6.出发/已出发  7.抵达/抵达 8.待审核/完成待审核 9驳回/完成已驳回 10完成/完成已通过 11终止 12锁定13.速电撤销回收14工单冲单
            // $wor_data['wor_state'] = 13;
            // $wor_data['wor_service_state'] = 11;
            $wor_data['wocl_consent_state'] = 2;
            $wor_data['wor_update_time'] = date('Y-m-d H:i:s');
        }

        $wor = DB::table('work_order')
            ->where('wor_order_id', $order_data->ord_id)
            ->where('wor_delete', 1)
            ->where('wor_state', '<>', 11)
            ->orderBy('wor_id', 'desc')
            ->first(['wor_id', 'wor_number', 'wor_service_adm_id']);
        // 如果已经生成工单
        if (!in_array($order_data->ord_wor_state, [1, 5])) {
            if ($wor) {
                $wor_res = DB::table('work_order as wo')
                    ->leftjoin('work_client as wc', 'wc.wocl_wor_id', '=', 'wo.wor_id')
                    ->where('wor_id', $wor->wor_id)
                    ->update($wor_data);
                // 2.1 查询当前工单的发货单的状态，已发货的发货单不需要更改
                $find_dego =  DB::table('dispatch_bill')
                    ->where('dego_order_type', 2) //类型：1.订单发货 2.工单发货
                    ->where('dego_type', 1) //类型：1未出库2已出库3作废4锁定
                    ->where('dego_wor_id', $wor->wor_id)
                    ->select('dego_id')
                    ->orderBy('dego_id', 'desc')
                    ->first();
                if (empty($find_dego)) {
                    $dego_res = true;
                } else {
                    // 2.2 把还未发货的发货单改成锁定状态
                    $dego_edit_data['dego_type'] = 4;
                    $dego_edit_data['dego_update_time'] = date('Y-m-d H:i:s');
                    $dego_res = DB::table('dispatch_bill')
                        ->where('dego_id', $find_dego->dego_id)
                        ->update($dego_edit_data);
                }
            } else {
                $wor_res = true;
                $dego_res = true;
            }
        } else {
            $wor_res = true;
            $dego_res = true;
        }
        if ($order_res && $wor_res && $dego_res) {
            sdOrderLog($order_data, $order_data->ord_id, 0, '速电' . $msg . '订单');
            // 当前工单有技师，推送消息提醒
            if (!empty($wor) && $wor->wor_service_adm_id) {
                $adm_phone =  DB::table('admin')
                    ->where('adm_id', $wor->wor_service_adm_id)
                    ->value('adm_phone');
                $push_name['alias'][] = $adm_phone; //发送对象
                $result_push = pushMessage($push_name, '工单：' . $wor->wor_number . ' 速电撤销', 10);
            }
            DB::commit();
            return response()->json(['code'=>200, 'msg'=>$msg . '成功']);
        } else {
            DB::rollBack();
            return response()->json(['code'=>203, 'msg'=>$msg . '失败']);
        }
    }

    // 撤销同意驳回
    public function undoOperation(Request $request)
    {
        // 使用验证器 验证数据
        $verify_data = new VerifyOtherSystemOrdersController;
        $error_message = $verify_data->undoOperationValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=>500, 'msg'=>$error_message, 'data'=>'{}']);
        }

        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);

        $order_data = DB::table('order')
            ->where('ord_id', $request['ord_id'])
            ->first(['ord_other_system_number', 'ord_type', 'ord_order_number', 'ord_wor_state']);
        if ($order_data->ord_wor_state != 8) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'此订单不是锁定回收状态']);
        }
        DB::beginTransaction();
        $data['orcl_consent_type'] = $request['type'];
        $data['ord_wor_state'] = 9;
        $data['orcl_update_time'] = date('Y-m-d H:i:s');
        $order_res = DB::table('order as o')
            ->leftjoin('order_client as oc', 'o.ord_id', '=', 'oc.orcl_ord_id')
            ->where('ord_id', $request['ord_id'])
            ->update($data);

        $wor = DB::table('work_order')
            ->where('wor_order_id', $request['ord_id'])
            ->first(['wor_id']);
        // 如果已经生成工单
        if (!in_array($order_data->ord_wor_state, [1, 5])) {
            $wor_data['wor_state'] = 13;
            $wor_data['wor_service_state'] = 11;
            $wor_data['wocl_consent_state'] = 1;
            $wor_data['wor_update_time'] = date('Y-m-d H:i:s');

            $wor_res = DB::table('work_order as wo')
                ->leftjoin('work_client as wc', 'wc.wocl_wor_id', '=', 'wo.wor_id')
                ->where('wor_id', $wor->wor_id)
                ->update($wor_data);
        } else {
            $wor_res = true;
        }

        $msg = $request['type'] == 1 ? '同意撤回' : '驳回撤回';
        if ($order_res && $wor_res) {
            orderLog($user_info, $request['ord_id'], 0, $msg);
            Common::addLog($user_info, getRealIp($request), '订单列表', '撤回', '审核速电撤回' . $order_data->ord_order_number . '成功:' . $msg);

            if (config('apisystem.SYNC_STATE') && $order_data->ord_type == 3) {
                $url = config('apisystem.sd_server_name') . '/index.php/sync_receipt_status';
                $param['serial_number'] = $order_data->ord_other_system_number; //第三方工单号
                $param['type'] = $request['type'];
                $param['time'] = date('Y-m-d H:i:s'); //收货时间
                $param['token'] = md5(md5($param['time'] . config('apisystem.sd_token'))); //token
                $doPost_res = Common::doPost($param, $url, 2);
                $doPost_res = json_decode($doPost_res);
                // if($doPost_res->code != 200){
                //     DB::rollBack();
                //     return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'失败']);
                // }
            }
            DB::commit();
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>'审核成功']);
        } else {
            DB::rollBack();
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'审核失败13']);
        }
    }

    // 催单反馈
    public function feedback(Request $request)
    {
        // 使用验证器 验证数据
        $verify_data = new VerifyOtherSystemOrdersController;
        $error_message = $verify_data->feedbackValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=>500, 'msg'=>$error_message, 'data'=>'{}']);
        }

        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);
        DB::beginTransaction();
        $order['orcl_reminder_state'] = 3;
        $order['orcl_update_time'] = date('Y-m-d H:i:s');

        $msg = $request['type'] == 1 ? '正常' : '申诉';
        $ord_data = DB::table('order')
            ->where('ord_id', $request['ord_id'])
            ->first(['ord_order_number', 'ord_type', 'ord_other_system_number']);

        $order_res = DB::table('order_client')
            ->where('orcl_ord_id', $request['ord_id'])
            ->update($order);
        if ($order_res) {
            orderLog($user_info, $request['ord_id'], 0, '催单反馈为' . $msg);
            Common::addLog($user_info, getRealIp($request), '订单列表', '催单反馈', '订单' . $ord_data->ord_order_number . '催单反馈成功:' . $msg);

            if (config('apisystem.SYNC_STATE') && $ord_data->ord_type == 3) {
                $url = config('apisystem.sd_server_name') . '/index.php/Supply/rushOrder';
                $param['serial_number'] = $ord_data->ord_other_system_number; //第三方工单号
                $param['type'] = $request['type'];
                $param['content'] = $request['remark'] ? $request['remark'] : '';
                $param['sin_bid'] = $request['label_id'];
                $param['ip'] = getRealIp($request);
                $param['sin_bcentent'] = $request['label_name'];
                $param['time'] = date('Y-m-d H:i:s'); //收货时间
                $param['token'] = md5(md5($param['time'] . config('apisystem.sd_token'))); //token
                $doPost_res = Common::doPost($param, $url, 2);
                $doPost_res = json_decode($doPost_res);
                if ($doPost_res->code != 200) {
                    DB::rollBack();
                    return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'失败']);
                }
            }
            DB::commit();
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>'反馈成功']);
        } else {
            DB::rollBack();
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'反馈失败']);
        }
    }

    // 速电审核通过驳回完成的订单
    public function opinionOrder(Request $request)
    {
        // 接收数据流
        $request = file_get_contents("php://input");
        // 解析
        Common::write_log($request, 2, 'opinionOrder');
        $request = json_decode($request, true);

        if (empty($request['type']) || !in_array($request['type'], [1, 2]) || empty($request['ord_order_number'])) {
            return response()->json(['code'=>202, 'msg'=>'参数错误']);
        }

        $order_data = DB::table('order as o')
            ->leftjoin('order_client as oc', 'oc.orcl_ord_id', '=', 'o.ord_id')
            ->where('ord_other_system_number', $request['ord_order_number'])
            ->where('ord_type', 3)
            ->first(['ord_order_number', 'ord_id', 'ord_cid', 'ord_superior_shop_id', 'ord_shop_id', 'ord_wor_state', 'orcl_client_id', 'orcl_channel_unit', 'ord_order_price', 'ord_create_time']);
        if (empty($order_data)) {
            return response()->json(['code'=>203, 'msg'=>'无此订单']);
        }
        $find_wor = DB::table('work_order as w')
            ->leftjoin('work_client as wc', 'wc.wocl_wor_id', '=', 'w.wor_id')
            ->where('wor_order_id', $order_data->ord_id)
            ->where('wor_delete', 1)
            ->where('wor_collection_bill', 1)
            ->first();
        if (empty($find_wor)) {
            return response()->json(['code'=>203, 'msg'=>'无工单']);
        }
        if ($find_wor->wor_service_state == 8) {
            return response()->json(['code'=>203, 'msg'=>'已审核']);
        }
        DB::beginTransaction();
        // 1是审核通过  2是不通过
        if ($request['type'] == 1) {
            $msg = '速电审核通过';
            $receivable['recr_cid'] = $order_data->ord_cid;
            $receivable['recr_shop_id'] = $order_data->ord_shop_id;
            $receivable['recr_shop_superior_id'] = $order_data->ord_superior_shop_id;
            $receivable['recr_type'] = 3; //类型：1.销售订单 2.预收款 3.订单账单 4.工单账单 5.采购账单 6.销售账单
            $receivable['recr_number_id'] = 0; //应收账单id
            $receivable['recr_original_id'] = $order_data->ord_id; //与类型所对应的id
            $receivable['recr_original_number'] = $order_data->ord_order_number; //与类型所对应的单号
            $receivable['recr_client_type'] = 6; //客户类型：1.会员零售 2.来往单位 3.加盟店 4会员零售(工单代收）
            $receivable['recr_client_id'] = $order_data->orcl_client_id; //会员id/来往单位id
            $receivable['recr_client_name'] = $order_data->orcl_channel_unit; //来往单位名称
            $receivable['recr_settle_price'] = $order_data->ord_order_price; //结算金额
            $receivable['recr_settle_time'] = date('Y-m-d H:i:s'); //结款时间
            $receivable['recr_settle_id'] = 0; //结款人
            $receivable['recr_acti_id'] = 0; //会计科目id
            $receivable['recr_actual_price'] = 0; //实际金额
            $receivable['recr_zero_price'] = 0; //抹零金额
            $receivable['recr_state'] = 1; //状态：1.未核销 2.已核销
            $receivable['recr_remark'] = ''; //备注
            $receivable['recr_yet_receipt'] = 0; //已收金额
            $receivable['recr_abort_time'] = ''; //截止时间
            $receivable['recr_order_time'] = $order_data->ord_create_time; //金额正负值
            $recr_res = DB::table('receivable_credit')->insert($receivable);
            $wor_res = DB::table('work_order')
                ->where('wor_id', $find_wor->wor_id)
                ->where('wor_delete', 1)
                ->where('wor_collection_bill', 1)
                ->update(['wor_pass' => 2, 'wor_update_time' => date('Y-m-d H:i:s'), 'wor_service_state' => 8]);

            // 是否为速电派到加盟店的工单1是 2否
            if ($find_wor->wocl_sd_virtual_type == 1) {
                $shop_info = DB::table('virtual_shop')
                    ->where('vish_id', $find_wor->wor_service_shop_id)
                    ->first(['vish_store_name as shop_store_name']);

                $receivable['recr_cid'] = $order_data->ord_cid;
                $receivable['recr_shop_id'] = $order_data->ord_shop_id;
                $receivable['recr_shop_superior_id'] = $order_data->ord_superior_shop_id;
                $receivable['recr_type'] = 4; //类型：1.销售订单 2.预收款 3.订单账单 4.工单账单 5.采购账单 6.销售账单
                $receivable['recr_original_id'] = $find_wor->wor_id; //与类型所对应的id
                $receivable['recr_original_number'] = $find_wor->wor_number; //与类型所对应的单号
                $receivable['recr_client_type'] = 7; //6速电派单7虚拟加盟店
                $receivable['recr_client_id'] = $find_wor->wor_service_shop_id; //会员id/来往单位id
                $receivable['recr_client_name'] = $shop_info->shop_store_name; //来往单位名称
                $receivable['recr_settle_price'] = $find_wor->wor_actual_price; //结算金额
                $receivable['recr_settle_time'] = ''; //结款时间
                $receivable['recr_settle_id'] = 0; //结款人
                $receivable['recr_acti_id'] = 0; //会计科目id
                $receivable['recr_actual_price'] = 0; //实际金额
                $receivable['recr_zero_price'] = 0; //抹零金额
                $receivable['recr_state'] = 1; //状态：1.未核销 2.已核销
                $receivable['recr_remark'] = ''; //备注
                $receivable['recr_plus_minus'] = $find_wor->wor_plus_minus; //备注
                $receivable['recr_yet_receipt'] = 0; //已收金额
                $receivable['recr_abort_time'] = ''; //截止时间
                $receivable['recr_create_time'] = date('Y-m-d H:i:s'); //截止时间
                $receivable['recr_order_time'] = $find_wor->wor_create_time; //金额正负值
                $recr_res = DB::table('receivable_credit')->insert($receivable);
            }
        } else {
            $msg = '速电审核驳回';
            $recr_res = true;
            $wor['wor_service_state'] = 6;
            $wor['wor_state'] = 8;
            $wor['wor_pass'] = 1;
            $wor['wor_remark'] = $request['remark'] ?? '';
            $wor['wor_update_time'] = date('Y-m-d H:i:s');
            $wor_res = DB::table('work_order')
                ->where('wor_order_id', $order_data->ord_id)
                ->update($wor);
            // 判断当前凭证号是否上传到U8
            $find_vore_data = DB::table('voucher_receipts')
                ->where('vore_cid', $order_data->ord_cid)
                ->where('vore_shop_id', $order_data->ord_shop_id)
                ->where('vore_wor_id', $find_wor->wor_id)
                ->where('vore_wor_number', $find_wor->wor_number)
                ->select('vore_state', 'vore_id', 'vore_ord_id', 'vore_ord_number')
                ->first();

            if (!empty($find_vore_data)) {
                if ($find_vore_data->vore_state == 1) {
                    // 删除凭证借贷表数据
                    $del_volo_data = DB::table('voucher_loan')
                        ->where('volo_shop_id', $order_data->ord_cid)
                        ->where('volo_vore_id', $find_vore_data->vore_id)
                        ->delete();
                    // 根据工单id,删除凭证表相关数据
                    $del_vore_data = DB::table('voucher_receipts')
                        ->where('vore_wor_id', $find_wor->wor_id)
                        ->where('vore_wor_number', $find_wor->wor_number)
                        ->where('vore_state', 1)
                        ->delete();
                    // 删除订单相关
                    $del_volo_data = DB::table('voucher_loan')
                        ->where('volo_shop_id', $order_data->ord_cid)
                        ->where('volo_vore_id', $find_vore_data->vore_id)
                        ->delete();
                    // 根据工单id,删除凭证表相关数据
                    $del_vore_data = DB::table('voucher_receipts')
                        ->where('vore_ord_id', $find_wor->wor_order_id)
                        ->where('vore_ord_number', $find_wor->wor_order_number)
                        ->where('vore_state', 1)
                        ->delete();
                } else {
                    DB::rollBack();
                    return response()->json(['code'=>203, 'msg'=>$msg . '失败']);
                }
            }
        }
        if ($recr_res && $wor_res) {
            sdOrderLog($order_data, $order_data->ord_id, 0, $msg);
            sdOrderLog($order_data, 0, $find_wor->wor_id, $msg);
            DB::commit();
            return response()->json(['code'=>200, 'msg'=>$msg . '成功']);
        } else {
            DB::rollBack();
            return response()->json(['code'=>203, 'msg'=>$msg . '失败']);
        }
    }

    // 同步售后单
    public function importAfterOrders(Request $request)
    {
        // 接收数据流
        $request = file_get_contents("php://input");
        // 解析
        Common::write_log($request, 2, 'importAfterOrders');
        $request = json_decode($request, true);

        // 验证数据
        $verify_data = new VerifyOtherSystemOrdersController;
        $error_message = $verify_data->importAfterOrdersValidator($request);
        if ($error_message) {
            return response()->json(['code'=>202, 'msg'=>$error_message]);
        }

        $oraf_number = 'S' . rand(100, 999) . date('mdHis') . rand(100000, 999999);

        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_data = DB::table('shop as s')
            ->leftjoin('shop_correlation as sc', 'sc.shco_shop_id', '=', 's.shop_id')
            ->where('sc.shco_system_shop_id', $request['ord_service_shop_id'])
            // ->where('shco_system_cid',1)
            ->first(['shop_id as adm_shop_id', 'shop_cid as adm_cid', 'shop_superior_id', 'shop_store_name']);
        if (empty($shop_data)) {
            return response()->json(['code'=>203, 'msg'=>'此门店未绑定']);
        }
        DB::beginTransaction();
        $system_orders_data['syor_system_cid'] = $shop_data->adm_cid;
        $system_orders_data['platform_number'] = $request['platform_number']; //速电平台单号
        $system_orders_data['order_number'] = $request['ord_order_number']; //速电平台单号
        $system_orders_data['ord_order_number'] = $oraf_number; //售后单号
        $system_orders_data['orcl_name'] = $request['orcl_name'];
        $system_orders_data['orcl_phone'] = $request['orcl_phone']; //客户电话
        $system_orders_data['orcl_province'] = $request['orcl_province']; //省
        $system_orders_data['orcl_city'] = $request['orcl_city']; //市
        $system_orders_data['oraf_remark'] = $request['remark'] ?? '';
        $system_orders_data['orcl_county'] = $request['orcl_county']; //区县
        $system_orders_data['orcl_address'] = $request['orcl_address']; //详细地址
        $system_orders_data['ord_service_shop_id'] = $request['ord_service_shop_id']; //速电指派门店id
        $system_orders_data['ord_service_type'] = $request['ord_service_type'];
        $system_orders_data['ord_client_id'] = $request['ord_client_id'];
        $system_orders_data['after_number'] = $request['after_number'];
        // $system_orders_data['goo_is_recycle'] = $request['goo_is_recycle'];
        $system_orders_res = DB::table('system_orders')->insert($system_orders_data);
        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $order_data = DB::table('order as o')
            ->leftjoin('order_client as oc', 'oc.orcl_ord_id', '=', 'o.ord_id')
            ->where('ord_other_system_number', $request['ord_order_number'])
            ->where('ord_type', 3)
            ->first(['ord_order_number', 'ord_id', 'ord_cid', 'ord_superior_shop_id', 'ord_shop_id', 'ord_wor_state', 'orcl_client_id', 'orcl_channel_unit', 'ord_order_price', 'ord_client_id', 'ord_service_type', 'orcl_name', 'orcl_phone', 'orcl_car_num']);
        if (empty($order_data)) {
            return response()->json(['code'=>203, 'msg'=>'无此订单']);
        }
        if ($order_data->ord_wor_state != 4) {
            return response()->json(['code'=>203, 'msg'=>'此订单未完成不能发起售后']);
        }
        $res = DB::table('order_after')
            ->where('oraf_other_system_number', $request['after_number'])
            ->value('oraf_id');
        if (!empty($res)) {
            return response()->json(['code'=>203, 'msg'=>'售后单已存在']);
        }
        // 生成售后
        $oraf_data['oraf_cid'] = $order_data->ord_cid;
        $oraf_data['oraf_shop_id'] = $order_data->ord_shop_id;
        $oraf_data['oraf_superior_shop_id'] = $order_data->ord_superior_shop_id;
        $oraf_data['oraf_create_id'] = 0;
        $oraf_data['oraf_number'] = $oraf_number; //售后单号
        $oraf_data['oraf_ord_id'] = $order_data->ord_id; //订单id
        $oraf_data['oraf_order_number'] = $order_data->ord_order_number; //订单号
        $oraf_data['oraf_type'] = 3; //买家类型：1门店零售2渠道单位3速电派单4第三方派单
        $oraf_data['oraf_client_id'] = $request['ord_client_id']; //选择的客户id,会员id/单位id
        $oraf_data['oraf_service_type'] = $request['ord_service_type']; //订单类型：1服务单 2销售单 3换货单 4退货单 5发货单 6结清单 7救援单
        $oraf_data['oraf_service_shop_id'] = $shop_data->adm_shop_id; //服务门店id
        $oraf_data['oraf_orla_id'] = 0; //售后标签id
        $oraf_data['oraf_payment_way'] = 1; //1账期2现结
        $oraf_data['oraf_other_system_number'] = $request['after_number']; //速电工单号（第三方系统单号
        $oraf_data['oraf_remark'] = $request['remark'] ?? '';
        $oraf_id = DB::table('order_after')->insertGetId($oraf_data);

        // 新增订单售后客户信息
        $orac_data['orac_oraf_id'] = $oraf_id; //售后id
        $orac_data['orac_client_id'] = $order_data->orcl_client_id; //选择的客户id,会员id/单位id
        $orac_data['orac_channel_unit'] = $order_data->orcl_channel_unit; //客户单位
        $orac_data['orac_name'] = $request['orcl_name']; //姓名
        $orac_data['orac_phone'] = $request['orcl_phone']; //联系电话
        $orac_data['orac_car_num'] = ''; //车牌号
        $orac_data['orac_province'] = $request['orcl_province']; //省
        $orac_data['orac_city'] = $request['orcl_city']; //市
        $orac_data['orac_county'] = $request['orcl_county']; //区县
        $orac_data['orac_address'] = $request['orcl_address']; //地址

        $orac_data['orac_order_type'] = 3; //1系统订单售后2外派订单售后
        $orac_id = DB::table('order_after_client')->insertGetId($orac_data);

        // 新增售后备注
        $oran_data['oran_oraf_id'] = $oraf_id; //售后id
        $oran_data['oran_afla_id'] = 0; //售后标签id
        $oran_data['oran_afla_name'] = $request['afla_name']; //售后标签名称
        $oran_data['oran_adm_id'] = 0; //备注人id
        $oran_data['oran_adm_name'] = '速电'; //备注人姓名
        $oran_data['oran_content'] = $request['remark'] ?? ''; //备注内容
        $oran_data['oran_update_time'] = date('Y-m-d H:i:s');
        $oran_id = DB::table('order_after_note')->insert($oran_data);

        // 查找半径与第三方商品绑定关联表关系(半径系统商品id)
        // $goco_goo_id = DB::table('goods_correlation')
        //     ->where('goco_cid',$shop_data->adm_cid)
        //     ->where('goco_shop_id',$shop_data->adm_shop_id)
        //     ->where('goco_system_goo_id',$request['goo_id'])
        //     ->value('goco_goo_id');
        // $goods_data = DB::table('goods')
        //     ->where('goo_id',$goco_goo_id)
        //     ->first(['goo_name','goo_goods_encode','goo_id']);
        // if(empty($goods_data)){
        //     return response()->json(['code'=>203, 'msg'=>'此订单商品未绑定']);
        // }

        // $orag_data['orag_oraf_id'] = $oraf_id;
        // $orag_data['orag_goo_id'] = $goods_data->goo_id;
        // $orag_data['orag_goo_name'] = $goods_data->goo_name;
        // $orag_data['orag_goo_goods_encode'] = $goods_data->goo_goods_encode;
        // $orag_data['orag_state'] = 1;
        // $orag_data['orag_goo_price'] = $request['goo_price'] * 100;
        // $orag_data['orag_collection_price'] = 0;
        // $orag_data['orag_goo_quantity'] = $request['goo_quantity'];
        // $orag_data['orag_goo_inventory'] = 0;
        // $orag_data['orag_goo_exchange'] = 1;
        // $orag_data['orag_remark'] = '';
        // $orag_data['orag_is_recycle'] = $request['goo_is_recycle'];//商品是否回收
        // $orag_res = DB::table('order_after_goods')->insert($orag_data);

        $orcl['oraf_orcl_id'] = $orac_id;
        $orcl['oraf_update_time'] = date('Y-m-d H:i:s');
        $orcl_res = DB::table('order_after')
            ->where('oraf_id', $oraf_id)
            ->update($orcl);
        if ($orac_id && $orcl_res && $oraf_id) {
            DB::commit();
            return response()->json(['code'=>200, 'msg'=>'回传成功']);
        } else {
            DB::rollBack();
            return response()->json(['code'=>201, 'msg'=>'回传失败']);
        }
    }

    // 速电审核通过驳回完成的售后订单
    public function opinionAfterOrder(Request $request)
    {
        // 接收数据流
        $request = file_get_contents("php://input");
        // 解析
        Common::write_log($request, 2, 'opinionAfterOrder');
        $request = json_decode($request, true);

        if (empty($request['type']) || !in_array($request['type'], [1, 2]) || empty($request['ord_order_number'])) {
            return response()->json(['code'=>202, 'msg'=>'参数错误']);
        }

        $order_data = DB::table('order_after as oraf')
            ->leftjoin('order_after_client as orac', 'orac.orac_oraf_id', '=', 'oraf.oraf_id')
            ->where('oraf_other_system_number', $request['ord_order_number'])
            ->where('oraf_type', 3)
            ->first(['oraf_order_number', 'oraf_id', 'oraf_cid as ord_cid', 'oraf_superior_shop_id as ord_superior_shop_id', 'oraf_shop_id as ord_shop_id', 'oraf_wor_state', 'oraf_client_id', 'orac_channel_unit', 'oraf_order_price']);
        if (empty($order_data)) {
            return response()->json(['code'=>203, 'msg'=>'无此订单']);
        }
        // 1是审核通过  2是不通过
        if ($request['type'] == 1) {
            $msg = '速电审核通过';
            $wor_res = DB::table('order_after')
                ->where('oraf_id', $order_data->oraf_id)
                ->update(['oraf_order_state' => 10, 'oraf_update_time' => date('Y-m-d H:i:s')]);
        } else {
            $msg = '速电审核驳回';
            $wor['oraf_order_state'] = 1;
            $wor['oraf_wor_state'] = 8;
            $wor['oraf_update_time'] = date('Y-m-d H:i:s');
            $wor_res = DB::table('order_after')
                ->where('oraf_id', $order_data->oraf_id)
                ->update($wor);
        }
        if ($wor_res) {
            sdOrderLog($order_data, $order_data->oraf_id, 0, $msg);
            DB::commit();
            return response()->json(['code'=>200, 'msg'=>$msg . '成功']);
        } else {
            DB::rollBack();
            return response()->json(['code'=>203, 'msg'=>$msg . '失败']);
        }
    }

    // 速电账单同步
    public function importBillOrders(Request $request)
    {
        // 接收数据流
        $request = file_get_contents("php://input");
        // 解析
        Common::write_log($request, 2, 'importBillOrders');
        $request = json_decode($request, true);

        if (empty($request['bill_bumber']) || empty($request['start_time']) || empty($request['end_time']) || empty($request['bill_price']) || empty($request['order_data']) || empty($request['ord_service_shop_id']) || empty($request['sdob_shop_name'])) {
            return response()->json(['code'=>202, 'msg'=>'参数错误']);
        }
        foreach ($request['order_data'] as $key => $value) {
            if (empty($value['ord_order_number']) || !is_numeric($value['actual_price']) || !is_numeric($value['relative_price']) || empty($value['details_price']) || empty($value['sobd_car_owner_name'])) {
                return response()->json(['code'=>202, 'msg'=>'参数错误']);
            }
        }
        $user_info = DB::table('shop as s')
            ->leftjoin('shop_correlation as sc', 'sc.shco_shop_id', '=', 's.shop_id')
            ->where('sc.shco_system_shop_id', $request['ord_service_shop_id'])
            ->first(['shop_id as adm_shop_id', 'shop_cid as adm_cid', 'shop_superior_id', 'shop_store_name']);
        if (empty($user_info)) {
            return response()->json(['code'=>203, 'msg'=>'此门店未绑定']);
        }
        $user_info->adm_id = 0;
        $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;

        DB::beginTransaction();
        $order_count = count($request['order_data']);
        $number = 'DZ' . time() . rand(10000000, 99999999);
        // 1.订单账单表新增一条数据
        $add_data['orbi_cid'] = $user_info->adm_cid;
        $add_data['orbi_shop_id'] = $user_info->adm_shop_id;
        $add_data['orbi_superior_shop_id'] = $shop_id;
        $add_data['orbi_number'] = $number;
        $add_data['orbi_order_amount'] = $order_count;
        $add_data['orbi_start_time'] = $request['start_time'];
        $add_data['orbi_end_time'] = $request['end_time'];
        $add_data['orbi_state'] = 3; //待审核
        $add_data['orbi_type'] = 3; //类型：1门店零售2渠道单位
        $add_data['orbi_create_type'] = 2; //账单生成类型1手动生成2速电同步生成
        $order_number = [];
        foreach ($request['order_data'] as $key => $value) {
            $order_number[] = $value['ord_order_number'];
        }

        $res = DB::table('sd_order_bill')
            ->where('sdob_sd_bill_bumber', $request['bill_bumber'])
            ->where('sdob_state', '!=', 2)
            ->value('sdob_id');
        if (!empty($res)) {
            return response()->json(['code'=>203, 'msg'=>'结算单号重复']);
        }

        $order_info = DB::table('order')
            ->whereIn('ord_other_system_number', $order_number)
            ->where('ord_delete', 1)
            ->where('ord_state', 1) //未结算
            ->whereIn('ord_wor_state', [4, 5, 8]) //无工单 已完成  撤销订单
            // ->whereBetween('ord_create_time', [$add_data['orbi_start_time'].' 00:00:00',$add_data['orbi_end_time'].' 23:59:59']) //无工单 已完成
            ->get([
                'ord_goods_quantity', 'ord_collection_price', 'ord_actual_price', 'ord_state',
                'ord_service_type', 'ord_plus_minus', 'ord_id', 'ord_other_system_number', 'ord_order_number'
            ]);
        $order_info = json_decode(json_encode($order_info), true);
        // if(count($order_info) != $order_count){
        //     return response()->json(['code'=>203, 'msg'=>'订单集合中有未派过的订单']);
        // }
        $add_data['orbi_collection_price'] = 0; //代收金额
        $add_data['orbi_goods_sum'] = 0; // 商品总量
        $original_id = []; //原始id，更改应收账款数据使用
        $ord_id = [];
        $sys_order_number = [];
        foreach ($order_info as $key => $value) {
            $ord_id[] = $value['ord_id'];
            $sys_order_number[] = $value['ord_other_system_number'];
            $add_data['orbi_collection_price'] += $value['ord_collection_price']; //代收金额
            $add_data['orbi_goods_sum'] += $value['ord_goods_quantity'];
            // if ($value['ord_state'] == 1) { //只相加未结算的订单结算金额
            //     // ord_service_type 订单类型：1服务单 2销售单 3换货单 4退货单 5发货单 6结清单
            //     if ($value['ord_service_type'] == 4) {
            //         $original_id[] = $value['ord_id'];
            //         $goods_price -= $value['ord_actual_price'];
            //     } elseif ($value['ord_plus_minus'] == 2 && $value['ord_service_type'] == 3) {
            //         $goods_price -= $value['ord_actual_price'];
            //     } else {
            //         $goods_price += $value['ord_actual_price'];
            //     }
            // }
            foreach ($request['order_data'] as $k => $v) {
                if ($value['ord_other_system_number'] == $v['ord_order_number']) {
                    $request['order_data'][$k]['order_number'] = $value['ord_order_number']; //本系统的订单单号
                    $request['order_data'][$k]['order_id'] = $value['ord_id']; //本系统的订单id
                }
            }
        }
        // 结算金额
        $goods_price = $request['bill_price'];
        // 如果是正数
        if ($goods_price >= 0) {
            $sys_goods_price = $goods_price;
            $plus_minus = 1;
            $goods_price = $request['bill_price'];
        } else {
            $goods_price = abs($goods_price);
            $sys_goods_price = $goods_price;
            $plus_minus = 2;
        }

        $add_data['orbi_collection_price'] = 0; //代收金额为0
        $add_data['orbi_plus_minus'] = $plus_minus; //正数
        $add_data['orbi_state'] = 1; //账单状态1.未结款2.已结款3.待审核4.已驳回5.部分结款
        $add_data['orbi_merge_state'] = 2; //1是2否
        $add_data['orbi_total_price'] = $goods_price; //合计金额（单位：分）订单的结算
        $add_data['orbi_bill_price'] = $goods_price; //结算金额（单位：分）订单结算金额：商品总金额-回收总金额
        $add_data['orbi_actual_price'] = $goods_price; //实收金额（单位：分）订单结算金额-代收金额，实际应收金额
        // $orbi_id = DB::table('order_bill')->insertGetId($add_data);

        /* if (!empty($order_info)) {
            // 2.修改订单表 账单id
            $sql = 'UPDATE `faster_order` SET ';
            $ord_orbi_id = ''; //账单id
            $ord_state = ''; //更改结算状态
            $update_time = ''; //调货时间
            $ord_id_str = "";
            foreach ($ord_id as $key => $value) {
                // 更改账单id
                $ord_orbi_id = $ord_orbi_id . ' WHEN ' .$value;
                $ord_orbi_id = $ord_orbi_id . ' THEN ' .$orbi_id;
                // 更改结算状态
                $ord_state = $ord_state . ' WHEN ' .$value;
                $ord_state = $ord_state . ' THEN 2';
                // 更改时间
                $update_time = $update_time . ' WHEN ' .$value;
                $update_time = $update_time . ' THEN "' .date('Y-m-d H:i:s').'"';
                //要更改的订单id
                $ord_id_str = $ord_id_str . $value.',';
            }
            $sql = $sql .' `ord_orbi_id`= CASE `ord_id` '.$ord_orbi_id.' END,';
            $sql = $sql .' `ord_state`= CASE `ord_id` '.$ord_state.' END,';
            $sql = $sql .' `ord_update_time`= CASE `ord_id` '.$update_time.' END';
            $sql = $sql .' WHERE `ord_id` IN ('.trim($ord_id_str, ',').')';
            $save_order = DB::update($sql);
        } else {
            $save_order = true;
        }
        // 3. 订单退款类型的生成账单之后，应收账款列表不再显示申请还款的按钮
        // 将应收账款的订单退款类型的收款状态改为 3还款待核对状态
        if (empty($original_id)) {
            $update_recr = true;
        } else {
            $recr_edit_data['recr_leisurely_type'] = 3;
            $recr_edit_data['recr_update_time'] = date('Y-m-d H:i:s');
            $update_recr = DB::table('receivable_credit')
                ->where('recr_cid', $user_info->adm_cid)
                ->where('recr_shop_superior_id', $shop_id)
                ->where('recr_type', 3)
                ->where('recr_account_type', 10)
                ->whereIn('recr_original_id', $original_id)
                ->update($recr_edit_data);
        } */

        //速电同步账单表
        $bill['sdob_cid'] = $user_info->adm_cid;
        $bill['sdob_shop_id'] = $user_info->adm_shop_id;
        $bill['sdob_superior_shop_id'] = $shop_id;
        $bill['sdob_sd_bill_bumber'] = $request['bill_bumber'];
        $bill['sdob_orbi_number'] = $number;
        // $bill['sdob_orbi_id'] = $orbi_id;
        $bill['sdob_start_time'] = $add_data['orbi_start_time'];
        $bill['sdob_end_time'] = $add_data['orbi_end_time'];
        $bill['sdob_sd_bill_price'] = $request['bill_price']; //速电账单金额
        $bill['sdob_bill_price'] = $sys_goods_price; //系统账单金额
        $bill['sdob_service_shop_id'] = $request['ord_service_shop_id'];
        $bill['sdob_create_time'] = date('Y-m-d H:i:s');
        $bill['sdob_shop_name'] = $request['sdob_shop_name']; //速电同步的门店名称

        $sdob_id = DB::table('sd_order_bill')->insertGetid($bill);
        foreach ($request['order_data'] as $key => $value) {
            $bill_details[$key]['sobd_sdob_id'] = $sdob_id;
            $bill_details[$key]['sobd_order_number'] = $value['ord_order_number'];
            $bill_details[$key]['sobd_ord_order_number'] = isset($value['order_number']) ? $value['order_number'] : '';
            $bill_details[$key]['sobd_ord_id'] = isset($value['order_id']) ? $value['order_id'] : '';
            $bill_details[$key]['sobd_actual_price'] = $value['actual_price'];
            $bill_details[$key]['sobd_relative_price'] = $value['relative_price'];
            $bill_details[$key]['sobd_details_price'] = json_encode($value['details_price']);
            $bill_details[$key]['sobd_car_owner_name'] = $value['sobd_car_owner_name']; //速电同步的车主姓名
            $bill_details[$key]['sobd_create_time'] = date('Y-m-d H:i:s'); //添加时间
            $bill_details[$key]['sobd_goods_name'] = $value['goods_name']??'';
        }
        $sobd_sdob_id = DB::table('sd_order_bill_details')->insert($bill_details);

        // 6. 生成应收账单
        /* $createBill = ReceivableBill::create(
            $user_info, //用户信息
            3, //类型：1.销售订单 2.预收款 3.订单账单 4.工单账单 5.采购账单 6.销售账单
            0, //应收账款id
            $orbi_id, //原始id(订单账单id)
            $number, //应收账款单号/原始号(订单账单编号)
            6, //客户类型：1.门店零售 2.来往单位
            0, //会员id/来往单位id
            '', //来往单位名称
            $goods_price, //实收金额
            date('Y-m-d H:i:s'), //结款时间
            0, //会计科目id
            0, //实际金额
            0, //抹零金额
            1, //状态：1.未核销 2.已核销
            2, //应收账单id是否是自己 1.不是 2.是
            '',  //备注
            0,  //已收金额
            '', //截止时间
            $plus_minus,//金额正负
            5,//显示类型：1订单收款 2受托代收（订单代收）3委托代收（工单代收）4工单费用（工单收款）5订单账单 6工单账单 7销售账单 8预收款
            date('Y-m-d H:i:s'),
            2//是否合并代收：1是2否
        );

        //账单下所有的订单为不统计状态
        $statistics_type_update = DB::table('receivable_credit')
            ->where('recr_cid', $user_info->adm_cid)
            ->where('recr_shop_superior_id', $shop_id)
            ->where('recr_type', 3)
            ->where('recr_belongs_id', $orbi_id)
            ->update(['recr_statistics_type'=>2,'recr_update_time'=>date('Y-m-d H:i:s')]);
        if ($statistics_type_update || $statistics_type_update===0) {
        } else {
            DB::rollBack();
            return response()->json(['code'=> 203, 'msg'=>'生成账单失败']);
        }

        //判断是否有本系统不存在的订单
        $diff_number = array_diff($order_number,$sys_order_number);

        if (!empty($diff_number)) {
            foreach ($diff_number as $key => $value) {
                $price  = 0;
                foreach ($request['order_data'] as $k => $v) {
                    if($v['ord_order_number'] == $value){
                        $price = $v['actual_price'];
                    }
                }
                $rece[$key]['recr_cid'] = $user_info->adm_cid;
                $rece[$key]['recr_shop_id'] = $user_info->adm_shop_id;
                $rece[$key]['recr_shop_superior_id'] = $shop_id;
                $rece[$key]['recr_type'] = 3; //类型：1.销售订单 2.预收款 3.订单账单 4.工单账单 5.采购账单 6.销售账单
                $rece[$key]['recr_account_type'] = 5;
                $rece[$key]['recr_number_id'] = $createBill; //应收账单id
                $rece[$key]['recr_belongs_id'] = $orbi_id; //应收账单id
                // $rece[$key]['recr_original_id'] = $recr_original_id; //与类型所对应的id
                $rece[$key]['recr_original_number'] = $value; //与类型所对应的单号
                $rece[$key]['recr_client_type'] = 6; //客户类型：1.门店零售 2.来往单位
                $rece[$key]['recr_client_id'] = 0; //会员id/来往单位id
                $rece[$key]['recr_client_name'] = config('apisystem.sd_chan_info')['name']; //来往单位名称
                $rece[$key]['recr_settle_price'] = $price; //结算金额
                $rece[$key]['recr_actual_price'] = $price; //实际金额
                $rece[$key]['recr_state'] = 1; //状态：1.未核销 2.已核销
                $rece[$key]['recr_plus_minus'] = 1; //金额正负值
                $rece[$key]['recr_bill_type'] = 2; //1系统单  2非系统单
            }
            $recr_res = DB::table('receivable_credit')->insert($rece);
        }else{
            $recr_res = true;
        } */

        // // 查询出 该订单下已结算的 订单id
        // $ord_id = DB::table('order')
        //         ->where('ord_state', 2)
        //         ->where('ord_orbi_id', $orbi_id)
        //         ->get(['ord_id']);
        // $ord_id = json_decode(json_encode($ord_id), true);
        // $ord_id = array_column($ord_id, 'ord_id');
        // if ($orbi_id && $save_order && $update_recr && $sdob_id && $sobd_sdob_id && $createBill && $recr_res) {
        if ($sdob_id && $sobd_sdob_id) {
            DB::commit();
            return response()->json(['code'=>200, 'msg'=>'生成账单成功']);
        } else {
            DB::rollBack();
            return response()->json(['code'=>203, 'msg'=>'生成账单失败']);
        }
    }

    // 获取速电标签
    public function getLabel(Request $request)
    {
        if (config('apisystem.SYNC_STATE')) {
            $url = config('apisystem.sd_server_name') . '/index.php/Supply/searchLable';
            $param['time'] = date('Y-m-d H:i:s');
            $param['token'] = md5(md5($param['time'] . config('apisystem.sd_token'))); //token
            $param['type'] = $request['type'];
            $doPost_res = Common::doPost($param, $url, 2);
            $doPost_res = json_decode($doPost_res);
            if ($doPost_res->code != 200) {
                return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'失败']);
            } else {
                return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$doPost_res->data]);
            }
        } else {
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>[]]);
        }
    }

    // 虚拟加盟店审核
    public function virtualUpdate(
        $user_info,
        $find_change_goods,
        $request,
        $find_wor_data,
        $find_order
    ) {
        $num = 0;
        $order_price = 0;
        $goo_all_quantity = 0;
        // 判断是否有更改商品信息
        if (!empty($find_change_goods) && $find_wor_data->wocl_before_wor_state != 10) {
            $request_new_good = json_decode($request['new_good'], true);
            $request_new_good = array_column($request_new_good, null, 'wged_id');

            if ($find_wor_data->wor_service_adm_id > 0) {
                return ['code'=>500, 'msg'=>'error', 'data'=>'请技师首先拒单,再进行审核'];
            }

            $orgo = [];
            $wogo = [];
            $order_price = 0;
            $num = 0;
            $goo_all_quantity = 0;
            foreach ($find_change_goods as $key => $value) {
                // 速电改单的商品
                if ($value->wged_wogo_id == 0) {
                    // 工单商品主键id为0的，说明是新添加的商品
                    $find_goods_data = DB::table('goods')
                        ->where('goo_id', $value->wged_goo_id)
                        ->first(['goo_ampere_hour']);
                    //订单商品数据
                    $add_orgo[$num]['orgo_ord_id'] = $request['ord_id'];
                    $add_orgo[$num]['orgo_ware_id'] = 0;
                    $add_orgo[$num]['orgo_goo_id'] = $value->wged_goo_id;
                    $add_orgo[$num]['orgo_is_recycle'] = $value->wged_is_recycle;
                    $add_orgo[$num]['orgo_goo_name'] = $value->wged_goo_name;
                    $add_orgo[$num]['orgo_goo_goods_encode'] = $value->wged_goo_goods_encode;
                    $add_orgo[$num]['orgo_goo_type'] = $value->wged_goo_type;
                    $add_orgo[$num]['orgo_state'] = $value->wged_state;
                    $add_orgo[$num]['orgo_goo_inventory'] = $value->wged_goo_inventory;
                    $add_orgo[$num]['orgo_recycle_quantity'] = $value->wged_recycle_quantity;
                    $add_orgo[$num]['orgo_goo_price'] = $value->wged_goo_price;
                    $add_orgo[$num]['orgo_goo_quantity'] = $value->wged_goo_amount;
                    $add_orgo[$num]['orgo_goo_ampere_hour'] = $find_goods_data->goo_ampere_hour;
                    $add_orgo[$num]['orgo_update_time'] = date('Y-m-d H:i:s');

                    // 工单商品数据
                    if ($find_wor_data) {
                        $add_wogo[$num]['wogo_wor_id'] = $find_wor_data->wor_id;
                    }
                    $add_wogo[$num]['wogo_ware_id'] = 0;
                    $add_wogo[$num]['wogo_goo_id'] = $value->wged_goo_id;
                    $add_wogo[$num]['wogo_is_recycle'] = $value->wged_is_recycle;
                    $add_wogo[$num]['wogo_goo_name'] = $value->wged_goo_name;
                    $add_wogo[$num]['wogo_goo_goods_encode'] = $value->wged_goo_goods_encode;
                    $add_wogo[$num]['wogo_goo_type'] = $value->wged_goo_type;
                    $add_wogo[$num]['wogo_state'] = $value->wged_state;
                    $add_wogo[$num]['wogo_goo_inventory'] = $value->wged_goo_inventory;
                    $add_wogo[$num]['wogo_recycle_quantity'] = $value->wged_recycle_quantity;
                    $add_wogo[$num]['wogo_goo_price'] = $value->wged_goo_price;
                    $add_wogo[$num]['wogo_goo_amount'] = $value->wged_goo_amount;
                    $add_wogo[$num]['wogo_update_time'] = date('Y-m-d H:i:s');

                    $num++;
                    $order_price += $value->wged_goo_price * $value->wged_goo_amount;
                    $goo_all_quantity += $value->wged_goo_amount;
                }
            }
            // 更改订单商品信息
            if ($add_orgo) {
                // 删除原来的速电订单商品，商品表里没有存订单商品id
                $orgo_del_res = DB::table('order_goods')
                    ->where('orgo_ord_id', $request['ord_id'])
                    ->where('orgo_state', 1)
                    ->delete();

                // 更改订单商品信息
                $orgo_add_res = DB::table('order_goods')->insert($add_orgo);

                // 更改订单信息
                $order_update['ord_order_state'] = 1; //订单锁定状态1正常2系统锁定3速电锁定4第三方系统锁定
                $order_update['ord_ware_id'] = $request['ware_id'];
                $order_update['ord_order_price'] = $order_price;
                $order_update['ord_actual_price'] = $order_price;
                $order_update['ord_update_time'] = date('Y-m-d H:i:s');
                $ord_update_res = DB::table('order')
                    ->where('ord_id', $request['ord_id'])
                    ->update($order_update);
                if (!$orgo_del_res || !$orgo_add_res || !$ord_update_res) {
                    DB::rollBack();
                    return ['code'=>500, 'msg'=>'error', 'data'=>'审核失败14'];
                }
            }

            // 更改工单商品信息
            if (!empty($find_wor_data) && $add_wogo) {
                // 删除之前的商品
                $wogo_del_res = DB::table('work_good')
                    ->where('wogo_wor_id', $find_wor_data->wor_id)
                    ->where('wogo_state', 1)
                    ->delete();
                // 新增速电换货的商品
                $wogo_add_res = DB::table('work_good')->insert($add_wogo);

                $wor_update['wor_actual_price'] = $order_price;
                $wor_update['wor_update_time'] = date('Y-m-d H:i:s');
                $wor_update_res = DB::table('work_order')
                    ->where('wor_id', $find_wor_data->wor_id)
                    ->update($wor_update);
                if (!$wogo_del_res || !$wogo_add_res || !$wor_update_res) {
                    DB::rollBack();
                    return ['code'=>500, 'msg'=>'error', 'data'=>'审核失败15'];
                }
            }

            $wged_del_res = DB::table('work_good_edit')
                ->where('wged_order_id', $request['ord_id'])
                ->delete();

            $lock_res = Common::publicOrderLock(2, 1, $request['ord_id']);
        } elseif (!empty($find_change_goods) && $find_wor_data->wocl_before_wor_state == 10) {
            $work_info = DB::table('work_order')
                ->where('wor_id', $find_wor_data->wor_id)
                ->first();
            $work_info = json_decode(json_encode($work_info), true);
            unset($work_info['wor_id']);
            $work_info_two = $work_info;
            if ($find_wor_data->wor_plus_minus == 1) {
                $plus_minus = 2;
            } else {
                $plus_minus = 1;
            }
            $work_info['wor_plus_minus'] = $plus_minus;
            $work_info['wor_service_state'] = 12;
            $work_info['wor_state'] = 14;
            // 6. 添加冲单数据
            $wor_order_number = Common::workRule($user_info);
            $work_info['wor_number'] = $wor_order_number;
            $work_info['wor_wobi_id'] = 0;
            $wor_id = DB::table('work_order')->insertGetid($work_info);

            // 应收应付
            $rece_info = DB::table('receivable_credit')
                ->where('recr_original_number', $work_info_two['wor_number'])
                ->where('recr_type', 4)
                ->where('recr_account_type', '!=', 3)
                ->first();
            $rece_info = json_decode(json_encode($rece_info), true);
            unset($rece_info['recr_id']);
            $rece_info['recr_original_number'] = $wor_order_number;
            $rece_info['recr_original_id'] = $wor_id;
            $rece_info['recr_plus_minus'] = $plus_minus;
            $rece_info['recr_belongs_id'] = 0;
            $rece_info['recr_statistics_type'] = 1;
            $rece_res = DB::table('receivable_credit')->insert($rece_info);

            // 删除订单应收应付
            $rece_del = DB::table('receivable_credit')
                ->where('recr_original_number', $find_order->ord_order_number)
                ->where('recr_original_id', $request['ord_id'])
                ->where('recr_account_type', '!=', 2)
                ->delete();

            // 原始工单客户数据
            $work_client_info = DB::table('work_client')
                ->where('wocl_wor_id', $find_wor_data->wor_id)
                ->first();
            $work_client_info = json_decode(json_encode($work_client_info), true);
            $work_client_info['wocl_wor_id'] = $wor_id;
            unset($work_client_info['wocl_id']);
            $work_client_info_res = DB::table('work_client')->insert($work_client_info);

            // 原始商品数据
            $work_good_info = DB::table('work_good')
                ->where('wogo_wor_id', $find_wor_data->wor_id)
                ->get();
            $work_good_info = json_decode(json_encode($work_good_info), true);
            foreach ($work_good_info as $key => $value) {
                $work_good_info[$key]['wogo_wor_id'] = $wor_id;
                unset($work_good_info[$key]['wogo_id']);
            }
            $work_good_res = DB::table('work_good')->insert($work_good_info);

            // 原来的工单数据
            $work_res = DB::table('work_order')
                ->where('wor_id', $find_wor_data->wor_id)
                ->update(['wor_service_state' => 12, 'wor_state' => 14, 'wor_update_time' => date('Y-m-d H:i:s')]);

            // 新的工单
            $wor_order_number = Common::workRule($user_info);
            $work_info_two['wor_number'] = $wor_order_number;

            $wor_id_two = DB::table('work_order')->insertGetid($work_info_two);
            $work_client_info['wocl_wor_id'] = $wor_id_two;
            $work_client_info_two = DB::table('work_client')->insert($work_client_info);

            foreach ($find_change_goods as $key => $value) {
                // 速电改单的商品
                if ($value->wged_wogo_id == 0) {
                    // 工单商品主键id为0的，说明是新添加的商品
                    $find_goods_data = DB::table('goods')
                        ->where('goo_id', $value->wged_goo_id)
                        ->first(['goo_ampere_hour']);
                    // 订单商品数据
                    $add_orgo[$num]['orgo_ord_id'] = $request['ord_id'];
                    $add_orgo[$num]['orgo_ware_id'] = 0;
                    $add_orgo[$num]['orgo_goo_id'] = $value->wged_goo_id;
                    $add_orgo[$num]['orgo_is_recycle'] = $value->wged_is_recycle;
                    $add_orgo[$num]['orgo_goo_name'] = $value->wged_goo_name;
                    $add_orgo[$num]['orgo_goo_goods_encode'] = $value->wged_goo_goods_encode;
                    $add_orgo[$num]['orgo_goo_type'] = $value->wged_goo_type;
                    $add_orgo[$num]['orgo_state'] = $value->wged_state;
                    $add_orgo[$num]['orgo_goo_inventory'] = $value->wged_goo_inventory;
                    $add_orgo[$num]['orgo_recycle_quantity'] = $value->wged_recycle_quantity;
                    $add_orgo[$num]['orgo_goo_price'] = $value->wged_goo_price;
                    $add_orgo[$num]['orgo_goo_quantity'] = $value->wged_goo_amount;
                    $add_orgo[$num]['orgo_goo_ampere_hour'] = $find_goods_data->goo_ampere_hour;
                    $add_orgo[$num]['orgo_update_time'] = date('Y-m-d H:i:s');

                    // 工单商品数据
                    if ($find_wor_data) {
                        $add_wogo[$num]['wogo_wor_id'] = $wor_id_two;
                    }
                    $add_wogo[$num]['wogo_ware_id'] = 0;
                    $add_wogo[$num]['wogo_goo_id'] = $value->wged_goo_id;
                    $add_wogo[$num]['wogo_is_recycle'] = $value->wged_is_recycle;
                    $add_wogo[$num]['wogo_goo_name'] = $value->wged_goo_name;
                    $add_wogo[$num]['wogo_goo_goods_encode'] = $value->wged_goo_goods_encode;
                    $add_wogo[$num]['wogo_goo_type'] = $value->wged_goo_type;
                    $add_wogo[$num]['wogo_state'] = $value->wged_state;
                    $add_wogo[$num]['wogo_goo_inventory'] = $value->wged_goo_inventory;
                    $add_wogo[$num]['wogo_recycle_quantity'] = $value->wged_recycle_quantity;
                    $add_wogo[$num]['wogo_goo_price'] = $value->wged_goo_price;
                    $add_wogo[$num]['wogo_goo_amount'] = $value->wged_goo_amount;
                    $add_wogo[$num]['wogo_update_time'] = date('Y-m-d H:i:s');

                    $num++;
                    $order_price += $value->wged_goo_price * $value->wged_goo_amount;
                    $goo_all_quantity += $value->wged_goo_amount;
                }
            }

            $wor_update['wor_actual_price'] = $order_price;
            $wor_update['wor_update_time'] = date('Y-m-d H:i:s');
            $wor_update_two_res = DB::table('work_order')
                ->where('wor_id', $wor_id_two)
                ->update($wor_update);

            // 删除原来的速电订单商品，商品表里没有存订单商品id
            $orgo_del_res = DB::table('order_goods')
                ->where('orgo_ord_id', $request['ord_id'])
                ->where('orgo_state', 1)
                ->delete();

            // 更改订单商品信息
            $orgo_add_res = DB::table('order_goods')->insert($add_orgo);

            // 更改订单信息
            $order_update['ord_order_state'] = 1; //订单锁定状态1正常2系统锁定3速电锁定4第三方系统锁定
            $order_update['ord_ware_id'] = $request['ware_id'];
            $order_update['ord_order_price'] = $order_price;
            $order_update['ord_actual_price'] = $order_price;
            $order_update['ord_update_time'] = date('Y-m-d H:i:s');
            $ord_update_res = DB::table('order')
                ->where('ord_id', $request['ord_id'])
                ->update($order_update);

            // 新增速电换货的商品
            $wogo_add_res = DB::table('work_good')->insert($add_wogo);

            $wor_update['wor_actual_price'] = $order_price;
            $wor_update['wor_update_time'] = date('Y-m-d H:i:s');
            $wor_update['wor_service_state'] = 6;
            $wor_update['wor_state'] = 8;
            $wor_update_res = DB::table('work_order')
                ->where('wor_id', $wor_id_two)
                ->update($wor_update);

            if (!$wor_update_res || !$work_client_info_two || !$wor_id_two || !$work_res || !$work_good_res || !$work_client_info_res || !$wor_id || !$ord_update_res || !$orgo_add_res || !$orgo_del_res || !$wor_update_two_res || !$wogo_add_res || !$rece_res || !$rece_del) {
                DB::rollBack();
                return ['code'=>500, 'msg'=>'error', 'data'=>'审核失败16'];
            }
            $wged_del_res = true;
            $lock_res = true;
        } else {
            $wged_del_res = true;
            $lock_res = true;
        }

        if ($lock_res &&  $wged_del_res) {
            orderLog($user_info, $find_order->ord_id, 0, '审核通过速电改单');
            if ($find_wor_data) {
                // 当前工单有技师，推送消息提醒
                if ($find_wor_data->wor_service_adm_id) {
                    $adm_phone =  DB::table('admin')
                        ->where('adm_id', $find_wor_data->wor_service_adm_id)
                        ->value('adm_phone');
                    $push_name['alias'][] = $adm_phone; //发送对象
                    $result_push = pushMessage($push_name, '工单：' . $find_wor_data->wor_number . ' 改单成功', 9);
                }
                orderLog($user_info, 0, $find_wor_data->wor_id, '审核通过速电改单');
            }
            Common::addLog($user_info, getRealIp($request), '订单列表', '审核改单', $find_order->ord_order_number . '速电改单审核通过成功');

            // 添加新增订单信息的提示
            $inhi_data['inhi_original_adm_id'] = 0; //原始单号创建人
            $inhi_data['inhi_original_id'] = $find_order->ord_id; //原始单id
            $inhi_data['inhi_original_number'] = $find_order->ord_order_number; //原始单号
            $inhi_data['inhi_original_state'] = $find_order->ord_order_state; //原始单状态
            $inhi_data['inhi_original_operation'] = '速电改单通过'; //操作
            $inhi_data['inhi_operation_state'] = 21; //操作状态：21速电改单通过
            addInformationHint($user_info, $inhi_data, 3);

            DB::commit();
            return ['code'=>200, 'msg'=>'success', 'data'=>'审核成功'];
        } else {
            DB::rollBack();
            return ['code'=>500, 'msg'=>'error', 'data'=>'审核失败17'];
        }
    }
}
