<?php
namespace App\Http\Controllers\Api\OtherSystemInterfaces\ERP;

use App\Services\ThreeApi\BaiDu\BaiDuService;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

// 速电对接 -- 商品信息
class DataApiController extends Controller
{
    public function dataApi ( Request $request ){
        $data = $request->all();
        $api=['getPartsCode','getAccessToken'];
        if(empty($data['time']) && empty($data['sign']) && empty($data['method'])){
            $json = file_get_contents("php://input");
            $data=json_decode($json,true);
        }
        if(empty($data['time']) || empty($data['sign']) || empty($data['method'])){
            return response()->json(['code' => 204, 'msg' => '缺少必要参数', 'data' => '']);
        }
        $sign = $data['time'].$data['method'];
        $sign = md5($sign).'ERP';
        $sign = md5($sign);
        if($data['sign'] != $sign){
            return response()->json(['code' => 205, 'msg' => '签名错误', 'data' => '']);
        }
        if(!in_array($data['method'],$api)){
            return response()->json(['code' => 201, 'msg' => '方法不存在', 'data' => '']);
        }else{
            if( $data['method'] == 'getPartsCode' ){
                if(empty($data['img']) || empty($data['img_type'])){
                    return response()->json(['code' => 204, 'msg' => '缺少必要参数', 'data' => '']);
                }
                if($data['img_type'] == 1){
                    $bodys = array(
                        'url'=>$data['img']
                    );
                    $data['img'] = file_get_contents($data['img']);
                    $data['img'] = base64_encode($data['img']);
                }else{
//                    $data['img'] = file_get_contents($data['img']);
//                    $data['img'] = base64_encode($data['img']);
                    $bodys = array(
                        'image'=>$data['img']
                    );
                }
                return $this->getPartsCode($bodys);
            }elseif( $data['method'] == 'getAccessToken' ){
                return $this->getAccessToken();
            }
        }
    }
    
    /**|---------------------------------------------------------------------------------
     * @name 获取备件条码
     * @param string $bodys 请求参数
     * @retrun \Illuminate\Http\JsonResponse
     * @author dou 2023/9/21 8:54
     * |---------------------------------------------------------------------------------
    */

    public function getPartsCode ( $bodys){
//        $bodys = array(
//            'image'=>$img
//        );
        $res = BaiDuService::getPicData($bodys, 4);
        if($res['code']==200) {
            $res = json_decode(json_encode($res['data']),true);
            $words = '';
            if (isset($res['words_result']) && !empty($res['words_result'])) {
                foreach ($res['words_result'] as $k => $v) {
                    if (strpos($v['words'], 'AS') && (strpos($v['words'], '备件条码') || strpos($v['words'], '备件') || strpos($v['words'], '条码') || strpos($v['words'], '件条'))) {
                        $words = 'AS' . explode('AS', $v['words'])[1];
                        return response()->json(['code' => 200, 'msg' => '操作成功', 'data' => $words]);
                    } elseif (strpos($v['words'], 'AS') && (strpos($v['words'], '备') || strpos($v['words'], '件') || strpos($v['words'], '码') || strpos($v['words'], '条'))) {
                        $words = $words = 'AS' . explode('AS', $v['words'])[1];
                    }
                }
            }
            if ($words != '') {
                return response()->json(['code' => 200, 'msg' => '操作成功', 'data' => $words]);
            } else {
                return response()->json(['code' => 202, 'msg' => '操作失败', 'data' => $words]);
            }
        }else{
            return $res;
        }
        	# code...
    }
    
    /**|---------------------------------------------------------------------------------
     * @name 获取授权token
     * @retrun \Illuminate\Http\JsonResponse
     * @author dou 2023/9/21 8:55
     * |---------------------------------------------------------------------------------
    */
    public function getAccessToken ( ){
        $res = BaiDuService::getAccessToken();
        return ['code'=>200, 'msg'=>'操作成功', 'data'=>$res];
    }
}
