<?php

namespace App\Http\Controllers\Api\OrderManage;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Controllers\Api\Verify\OrderManage\VerifyUploadImageController;
use Illuminate\Support\Facades\DB;
use App\Http\Models\Api\Common;

// 传图统计
class UploadImageController extends Controller
{
	// 列表每页显示数据个数
    protected $show_count = 10;

    // 列表
    public function index(Request $request)
	{
        // 验证数据
        $verify_data = new VerifyUploadImageController;
        $error_message = $verify_data->indexValidator($request->all());
        if ($error_message) {
            return response()->json(['code' => 500, 'msg' => 'error', 'data' => '参数错误', 'error_message' => $error_message]);
        }
        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);

        $search_data = $request->all();
        $list_data = DB::table('work_order as wo')
	            ->leftJoin('admin as a', 'a.adm_id', '=', 'wo.wor_service_adm_id')
                ->where('wor_cid', $user_info->adm_cid)
                ->where('wor_shop_id', $user_info->adm_shop_id)
                ->where('wor_state', 10)
                ->where('wor_delete', 1)
                ->where('wor_collection_bill', 1) //是否代收账单：1正常工单2代收账单
                ->where(function ($query) use ($search_data) {
                	// 技师id
                    if (!empty($search_data['wor_service_adm_id'])) {
                        $query->where('wor_service_adm_id', $search_data['wor_service_adm_id']);
                    }
                })
                ->where(function ($query) use ($search_data) {
                    //如果选择开始时间并且选择结束时间
                    if (!empty($search_data['create_time_start']) && !empty($search_data['create_time_end'])) {
                        $query->whereBetween('wor_create_time', [$search_data['create_time_start'], $search_data['create_time_end'] . ' 23:59:59']);
                    } else {
                        // 如果选择开始时间
                        if (!empty($search_data['create_time_start'])) {
                            $query->where('wor_create_time', '>=', $search_data['create_time_start']);
                        } else {
                            // 如果选择结束时间
                            if (!empty($search_data['create_time_end'])) {
                                $query->where('wor_create_time', '<=', $search_data['create_time_end'] . ' 23:59:59');
                            }
                        }
                    }
                })
            	->groupBy('wor_service_adm_id')
                ->select(DB::raw('adm_name,wor_service_adm_id,count(wor_id) as wor_service_count'))
                ->paginate($this->show_count);
        $list_items = $list_data->items();
        if ($list_items) {
            $wor_service_adm_id = array_unique(array_column($list_items, 'wor_service_adm_id'));
            // 传图不合格数量
            $image_pass_count = collect(DB::table('work_order as rc')
                ->where('wor_cid', $user_info->adm_cid)
                ->where('wor_shop_id', $user_info->adm_shop_id)
                ->where('wor_state', 10)
                ->where('wor_delete', 1)
                ->where('wor_image_pass_state', 2)//上传图片是否合格：1合格2不合格
                ->where('wor_collection_bill', 1) //是否代收账单：1正常工单2代收账单
                ->whereIn('wor_service_adm_id', $wor_service_adm_id)
                ->where(function ($query) use ($search_data) {
                    //如果选择开始时间并且选择结束时间
                    if (!empty($search_data['create_time_start']) && !empty($search_data['create_time_end'])) {
                        $query->whereBetween('wor_create_time', [$search_data['create_time_start'], $search_data['create_time_end'] . ' 23:59:59']);
                    } else {
                        // 如果选择开始时间
                        if (!empty($search_data['create_time_start'])) {
                            $query->where('wor_create_time', '>=', $search_data['create_time_start']);
                        } else {
                            // 如果选择结束时间
                            if (!empty($search_data['create_time_end'])) {
                                $query->where('wor_create_time', '<=', $search_data['create_time_end'] . ' 23:59:59');
                            }
                        }
                    }
                })
                ->select(DB::raw('count(wor_id) as no_image_pass_count, wor_service_adm_id'))
                ->groupBy('wor_service_adm_id')
                ->get())->keyBy('wor_service_adm_id')->toArray();
            foreach ($list_items as $key => $value) {
            	// 传图不合格数量
        		if (isset($image_pass_count[$value->wor_service_adm_id]->no_image_pass_count)) {
        			$list_items[$key]->no_image_pass_count = $image_pass_count[$value->wor_service_adm_id]->no_image_pass_count;
        		} else {
        			$list_items[$key]->no_image_pass_count = 0;
        		}
        		$list_items[$key]->image_pass_count = $value->wor_service_count - $list_items[$key]->no_image_pass_count;//传图合格数量

        		//传图合格率
        		if ($list_items[$key]->wor_service_count) {
        			$list_items[$key]->image_pass_percent = round($list_items[$key]->image_pass_count / $list_items[$key]->wor_service_count, 2)*100 .'%';
        		} else {
        			$list_items[$key]->image_pass_percent = '0%';
        		}
            }
        }

        $data_info['current_page'] = $list_data->currentPage();  //当前页面页码
        $data_info['last_page'] = $list_data->lastPage();        //表示最后一页的页码
        $data_info['total'] = $list_data->total();               //总数据个数
        $data_info['current_number'] = $this->show_count;        //一页显示多少个
        $data_info['data'] = $list_items;                        //返回数据

        // 获取当前列表下的按钮
        $list_button = getListButton($request['api_token'], $request['pri_id']);
        if ($list_data) {
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$data_info, 'list_button'=>$list_button]);
        } else {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'暂无数据']);
        }
	}

	// 传图审核
    public function imagePass(Request $request)
	{
		// 验证数据
        $verify_data = new VerifyUploadImageController;
        $error_message = $verify_data->imagePassValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }

        $wor_image_pass_state = DB::table('work_order')
                ->where('wor_id', $request['wor_id'])
                ->value('wor_image_pass_state');
        if ($wor_image_pass_state == $request['wor_image_pass_state']) {
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>'传图审核成功']);
        }

       	$wor_data['wor_image_pass_state'] = $request['wor_image_pass_state'];
		$wor_res = DB::table('work_order')
                ->where('wor_id', $request['wor_id'])
                ->update($wor_data);
        if ($wor_res) {
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>'传图审核成功']);
        } else {
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>'传图审核失败']);
        }
	}
}
