<?php
namespace App\Http\Controllers\Api;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Crypt;
use App\Http\Models\Api\Common;

class NotificationsController extends Controller
{
	// 仓库预警消息
    public function warning(Request $request)
    {
        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);
        $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;
        //设置预警值的仓库类别
        $data = DB::table('warehouse_onhand as wo')
                ->leftjoin('warehouse as wa','wa.ware_id','=','wo.waon_ware_id')
                ->leftjoin('warehouse_class as wc','wc.wacl_class_numerical','=','wo.waon_class')
                ->where('waon_warn_state',1)
                ->where('ware_shop_id',$user_info->adm_shop_id)
                ->whereIn('waon_class',[1,2])
                ->select('waon_ware_id','waon_class','wacl_class_name')
                ->get()->toArray();
        if (!empty($data)) {
            // 整理仓库id
            $ware_id = array_unique(array_column($data, 'waon_ware_id'));
            // 整理仓库id对应的仓库类别的名称
            foreach ($data as $key => $value) {
                $waon_class[$value->waon_ware_id][$value->waon_class] = $value->wacl_class_name;
            }
        }else{
            $ware_id = [];
        }

        if(!empty($ware_id)){
            //获取仓库名称
            $ware_data = DB::table('warehouse')
                ->whereIn('ware_id',$ware_id)
                ->pluck('ware_name', 'ware_id')->toArray();
            // 查询设置预警数量大于0的仓库商品
            $ware_goods = DB::table('warehouse_goods')
                ->whereIn('wago_ware_id', $ware_id)
                ->whereIn('wago_class', [1,2])
                ->where('wago_min_warn', '>', 0)
                ->select('wago_ware_id', 'wago_class', 'wago_goo_id', 'wago_priority_stock_number', 'wago_stock_number', 'wago_min_warn')
                ->get()->toArray();
            foreach ($ware_goods as $key => $value) {
                // 判断仓库类别是否开启预警设置
                if (isset($waon_class[$value->wago_ware_id][$value->wago_class])) {
                    //良品库存数量 + 优先库存数量
                    $num = $value->wago_priority_stock_number + $value->wago_stock_number;
                    //大于预警值不做预警提醒
                    if($num > $value->wago_min_warn){
                        unset($ware_goods[$key]);
                    }
                }else{
                    unset($ware_goods[$key]);
                }
            }
            if(!empty($ware_goods)){
                $goo_id = [];
                foreach ($ware_goods as $key => $value) {
                    $ware_goods[$key]->ware_name = $ware_data[$value->wago_ware_id];//仓库名称
                    $ware_goods[$key]->class_name = $waon_class[$value->wago_ware_id][$value->wago_class];//仓库类别名称
                    $goo_id[] = $value->wago_goo_id;
                }
                //商品数据
                $goods_data = DB::table('goods')
                    ->whereIn('goo_id',$goo_id)
                    ->pluck('goo_name','goo_id')->toArray();

                foreach ($ware_goods as $key => $value) {
                    if(isset($goods_data[$value->wago_goo_id])){
                        $ware_goods[$key]->goo_name = $goods_data[$value->wago_goo_id];//商品名称
                    }
                    unset($ware_goods[$key]->wago_ware_id);
                    unset($ware_goods[$key]->wago_goo_id);
                }
                if (!empty($ware_goods)) {
                    //添加推送记录
                    $noti['noti_content'] = json_encode($ware_goods);
                    $noti['noti_cid'] = $user_info->adm_cid;
                    $noti['noti_shop_id'] = $user_info->adm_shop_id;
                    $noti['noti_shop_superior_id'] = $shop_id;
                    $noti['noti_adm_id'] = $user_info->adm_id;
                    DB::table('notification')->insert($noti);
                }
                return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$ware_goods]); 
            }else{
                return response()->json(['code'=>200, 'msg'=>'success', 'data'=>[] ]); 
            }
        }else{
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>[] ]);
        }
    }
}
