<?php

namespace App\Http\Controllers\Api\MemberManage;

use App\Services\CommonService;
use Illuminate\Http\Request;
// use Illuminate\Support\Facades\Request;
use App\Http\Controllers\Controller;
use App\Http\Controllers\Api\Verify\MemberManage\VerifyMemberListController;
use Illuminate\Support\Facades\DB;
use App\Http\Models\Api\Common;
use App\Http\Models\Api\CashierDesk;
use App\Services\Business\WashOrderService;
use App\Services\Shop\ShopService;
use App\Services\Business\FestivalRemindService;

class FestivalRemindController extends Controller
{
    // 列表每页显示数据个数
    protected $show_count = 10;

    //列表
    public function index(Request $request){

        $request = $request->all();
        $data = FestivalRemindService::index($request);
        return response()->json($data);

    }

    /*
     * @name 获取所有用户可以选择的提醒
     * @retrun array
     * @author Ma 2023/9/4 14:07
     *
    */
    public function getList(Request $request){
        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);
        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;
        $list_data = DB::table('festival_remind')
            ->where('fest_cid', $user_info->adm_cid)
            ->where('fest_superior_shop_id', $shop_id)
            ->where('fest_status', 1)
            ->where('fest_content', '<>','')
            ->select('fest_id','fest_type','fest_name')
            ->orderBy('fest_id', 'desc')
            ->get()->toArray();
        $data['birthday'] = [];//生日
        $data['festival'] = [];//节日
        if($list_data){
            $birthday = [];
            $festival = [];
            foreach ($list_data as $key => $value){
                if($value->fest_type == 1){//节日提醒
                    $festival[] = $value;
                }elseif($value->fest_type == 2){//生日提醒
                    $birthday[] = $value;
                }
            }
            $data['birthday'] = $birthday;//生日
            $data['festival'] = $festival;//节日
        }
        return response()->json(['code' => 200, 'msg' => 'success', 'data' => $data]);
    }

    // 新增
    public function add(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyMemberListController;
        $error_message = $verify_data->addFestValidator($request->all());
        if ($error_message) {
            return response()->json(['code' => 500, 'msg' => $error_message, 'data' => '参数错误', 'error_message' => $error_message]);
        }

        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);
        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;

        $request = $request->all();
        $find_data = DB::table('festival_remind')
            ->where('fest_cid', $user_info->adm_cid)
            ->where('fest_shop_id', $shop_id)
            ->where('fest_name', $request['fest_name'])
            ->where('fest_status', 1)
            ->first();
        if($find_data && !empty($find_data)){
            return response()->json(['code' => 500, 'msg' => '该节日已存在', 'data' => '该节日已存在']);
        }
        $fest_add_data['fest_cid'] = $user_info->adm_cid;
        $fest_add_data['fest_shop_id'] = $user_info->adm_shop_id;
        $fest_add_data['fest_superior_shop_id'] = $shop_id;
        $fest_add_data['fest_type'] = $request['fest_type'];
        $fest_add_data['fest_name'] = $request['fest_name'];
        $fest_add_data['fest_start'] = $request['fest_start']??1;
        $fest_add_data['fest_is_send'] = $request['fest_is_send']??2;
        if(isset($request['fest_date'])){
            $fest_add_data['fest_date'] = $request['fest_date'];
        }
        $fest_add_data['fest_days'] = $request['fest_days']??0;
        $fest_add_data['fest_content'] = $request['fest_content'];
        $fest_add_data['fest_create_time'] = date('Y-m-d H:i:s');
        $fest_add_data['fest_create_name'] = $user_info->adm_name;
        $fest_add_data['fest_create_id'] = $user_info->adm_id;
        if(isset($request['fest_effective_start_date'])){
            $fest_add_data['fest_effective_start_date'] = $request['fest_effective_start_date'];
        }
        if(isset($request['fest_effective_end_date'])){
            $fest_add_data['fest_effective_end_date'] = $request['fest_effective_end_date'];
        }
        if(isset($request['fest_sex'])){
            $fest_add_data['fest_sex'] = $request['fest_sex'];
        }
        if(isset($request['fest_car_series'])){
            $fest_add_data['fest_car_series'] = $request['fest_car_series'];
        }
        if(isset($request['fest_label'])){
            $fest_add_data['fest_label'] = $request['fest_label'];
        }
        $fest_id =  DB::table('festival_remind')->insertGetId($fest_add_data);

        if ($fest_id) {
            return response()->json(['code' => 200, 'msg' => '新增节日成功', 'data' =>$fest_id]);
        } else {
            return response()->json(['code' => 500, 'msg' => '新增节日失败', 'data' => '新增节日失败']);
        }
    }

    // 编辑
    public function edit(Request $request){

        $request = $request->all();
        $data = FestivalRemindService::edit($request);
        return response()->json($data);

    }

    /*
     * @name 获取预计发送条数
     * @param string ju_ordernum 订单单号
     * @retrun array
     * @author Ma 2023/8/31 15:03
     *
    */
    public function getCount(Request $request){
        $request = $request->all();
        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);
        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;
        $count = DB::table('member')
            ->where('mem_cid', $user_info->adm_cid)
            ->where('mem_superior_shop_id', $shop_id)
            ->count();
        return response()->json(['code' => 200, 'msg' => '成功', 'data' => $count]);
    }

    /*
     * @name 发送短信列表
     * @param string ju_ordernum 订单单号
     * @retrun array
     * @author Ma 2023/9/1 15:47
     *
    */
    public function getMessageList(Request $request){
        // 验证数据
        /*$verify_data = new VerifyMemberListController;
        $error_message = $verify_data->indexValidator($request->all());
        if ($error_message) {
            return response()->json(['code' => 500, 'msg' => '参数错误', 'data' => '参数错误', 'error_message' => $error_message]);
        }*/

        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);
        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;

        $search_data = $request->all();
        $list_data = DB::table('festival_message')
            ->where('message_cid', $user_info->adm_cid)
            ->where('message_superior_shop_id', $shop_id)
            ->where('message_shop_id', $shop_id)
            //->where('message_status', '!=',3)
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['message_mem_id'])) {
                    $query->where('message_mem_id', $search_data['message_mem_id']);
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['message_type'])) {
                    $query->where('message_type', $search_data['message_type']);
                }
            })
            ->where(function ($query) use ($search_data) { //发送时间
                // 如果选择开始时间并且选择结束时间
                if (!empty($search_data['send_start_time']) && !empty($search_data['send_end_time'])) {
                    $query->whereBetween('message_send_time', [$search_data['send_start_time'], $search_data['send_end_time'] . ' 23:59:59']);
                } else {
                    // 如果选择开始时间
                    if (!empty($search_data['send_start_time'])) {
                        $query->where('message_send_time', '>=', $search_data['send_start_time']);
                    } else {
                        // 如果选择结束时间
                        if (!empty($search_data['send_end_time'])) {
                            $query->where('message_send_time', '<=', $search_data['send_end_time'] . ' 23:59:59');
                        }
                    }
                }
            })
            ->orderBy('message_id', 'desc')
            ->paginate($this->show_count);
        $list_items = $list_data->items();
        // 获取当前列表下的按钮
        $list_button = getListButton($search_data['api_token'], $search_data['pri_id']);//var_dump($list_button);die;
        if ($list_items) {
            foreach ($list_data as $key => $value) {
                //按钮
                $buttonData = [];
                if($value->message_status == 2){
                    $buttonData = ['sendMessage'];
                }
                $button = CommonService::getListButton($buttonData,$list_button);
                $list_items[$key]->button_one = $button['button_one']??[];
                $list_items[$key]->button_two = $button['button_two']??[];
                $list_items[$key]->button_three = $button['button_three']??[];
            }
        }
        $message_count = DB::table('festival_message')
            ->where('message_cid', $user_info->adm_cid)
            ->where('message_superior_shop_id', $shop_id)
            ->where('message_shop_id', $shop_id)
            ->sum('message_count');
        $data_info['current_page'] = $list_data->currentPage();  //当前页面页码
        $data_info['last_page'] = $list_data->lastPage();        //表示最后一页的页码
        $data_info['total'] = $list_data->total();               //总数据个数
        $data_info['current_number'] = $this->show_count;       //一页显示多少个
        $data_info['data'] = $list_items;                //返回数据
        $data_info['message_count'] = $message_count;
        if ($list_data) {
            return response()->json(['code' => 200, 'msg' => 'success', 'data' => $data_info]);
        } else {
            return response()->json(['code' => 500, 'msg' => '暂无数据', 'data' => '暂无数据']);
        }
    }

    /*
     * @name 重新发送短信
     * @retrun array
     * @author Ma 2023/9/4 11:10
     *
    */
    // public function sendMessage(Request $request){
    //     $search_data = $request->all();
    //     $data = DB::table('festival_message')
    //         ->where('message_id', $search_data['message_id'])
    //         ->first();
    //     $find_shop_data = DB::table('shop')
    //         ->where('shop_id', $data->message_shop_id)
    //         ->first();
    //     if ($find_shop_data->shop_message_num <= 0) {
    //         return ['code'=>500, 'msg'=>'短信余额不足，请充值', 'data'=>''];
    //     }
    //     $send_res = sendSmsCode($data->message_mem_phone, '【半径服务】'.$data->message_content);
    //     if ($send_res > 0) {
    //         $up_data['message_status']  = 1;//成功
    //     } else {
    //         $up_data['message_status']  = 2;//失败
    //     }
    //     $up_data['message_count']  = $data->message_count + 1;//发送条数
    //     $mess_id =  DB::table('festival_message')
    //         ->where('message_id', $search_data['message_id'])
    //         ->update($up_data);
    //     if($mess_id){
    //         if($up_data['message_status'] == 1){
    //             $ret = '发送成功';
    //         }elseif($up_data['message_status'] == 2){
    //             $ret = '发送失败';
    //         }
    //         return response()->json(['code' => 200, 'msg' => $ret, 'data' => $ret]);
    //     } else {
    //         return response()->json(['code' => 500, 'msg' => '处理失败', 'data' => '处理失败']);
    //     }
    // }

    /*
     * @name 短信标签
     * @param string ju_ordernum 订单单号
     * @retrun array
     * @author Ma 2023/9/4 15:15
     *
    */
    public function smsLabel(Request $request){
        $request = $request->all();
        $data =  DB::table('sms_label')
            ->where(function ($query) use ($request) {
                if (!empty($request['sms_label_type'])) {
                    $query->where('sms_label_type', $request['sms_label_type']);
                }
            })
            ->get()->toArray();
        if($data){
            foreach ($data as $key => $value){
                $data[$key]->text = $value->sms_label_text .'：'. $value->sms_label_illustrate;
            }
            return response()->json(['code' => 200, 'msg' => '成功', 'data' => $data]);
        } else {
            return response()->json(['code' => 500, 'msg' => '失败', 'data' => '失败']);
        }
    }

    //签名
    public function signature(Request $request){

        $request = $request->all();
        $data = FestivalRemindService::signatureEdit($request);
        return response()->json($data);

    }

    //测试发送短信
    public function sendContent(Request $request){

        $request = $request->all();
        $data = FestivalRemindService::sendContent($request);
        return response()->json($data);

    }

    //发送短信
    public function sendMes(Request $request){

        $request = $request->all();
        $data = FestivalRemindService::sendMes($request);
        return response()->json($data);

    }
}
