<?php
namespace App\Http\Controllers\Api\InventoryManage;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use App\Http\Models\Api\Common;
use App\Http\Models\Services\DataStatistical\GoodsInventory;

// 业务系统 -- 库存查询
class InventoryInquiryController extends Controller
{
    // 列表每页显示数据个数
    protected $show_count = 10;

    // 列表
    public function index(Request $request)
    {
        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);
        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;

        // 获取到该账号下勾选的仓库id
        $find_ware_id = DB::table('admin_set')
            ->where('adms_adm_id', $user_info->adm_id)
            ->where('adms_shop_id', $user_info->adm_shop_id)
            ->select('adms_ware_ids')
            ->first();
        if (empty($find_ware_id->adms_ware_ids)) {
            $ware_id = [];
        } else {
            $ware_id = $find_ware_id->adms_ware_ids;
            $ware_id = array_unique(explode(',', $ware_id));
        }

        $search_data = $request->all();

        if (!empty($search_data['goo_name']) || !empty($search_data['goo_bra_id']) || !empty($search_data['goo_cate_id']) || !empty($search_data['ware_id']) || !empty($search_data['wago_class'])) {
            $warehouse = DB::table('warehouse as ware')
                ->leftJoin('warehouse_goods as wago', 'wago.wago_ware_id', '=', 'ware.ware_id')
                ->leftJoin('goods as goo', 'goo.goo_id', '=', 'wago.wago_goo_id')
                ->where('ware_superior_shop_id', $shop_id)
                ->where('ware_id', $ware_id)
                ->where(function ($query) use ($user_info) {
                    $query->where('wago_stock_number', '>', 0)
                        ->orWhere('wago_priority_stock_number', '>', 0);
                })
                ->where('ware_type', '<>', 2)
                ->where(function ($query) use ($ware_id) {
                    if (!empty($ware_id)) {
                        $query->Orwhere('ware_type', 2)
                            ->OrwhereIn('ware_id', $ware_id);
                    } else {
                        $query->where('ware_type', 2);
                    }
                })
                ->where(function ($query) use ($search_data) {
                    if (!empty($search_data['goo_name'])) {
                        $query->where('goo_name', 'like', '%'.$search_data['goo_name'].'%')
                        ->orwhere('goo_goods_encode', 'like', '%'.$search_data['goo_name'].'%');
                    }
                })
                ->where(function ($query) use ($search_data) {
                    if (!empty($search_data['goo_bra_id'])) {
                        $query->where('goo_bra_id', $search_data['goo_bra_id']);
                    }
                }) //品牌
                ->where(function ($query) use ($search_data) {
                    if (!empty($search_data['goo_cate_id'])) {
                        $query->where('goo_cate_id', $search_data['goo_cate_id']);
                    }
                }) //品类
                ->where(function ($query) use ($search_data) {
                    if (!empty($search_data['ware_id'])) {
                        $query->where('ware_id', $search_data['ware_id']);
                    }
                }) //仓库id
                ->where(function ($query) use ($search_data) {
                    if (!empty($search_data['wago_class'])) {
                        $query->where('wago_class', $search_data['wago_class']);
                    }
                }) //仓库类别
                ->where(function ($query) use ($search_data) {
                    if (!empty($search_data['goo_brse_id'])) {
                        $query->where('goo_brse_id', $search_data['goo_brse_id']);
                    }
                })//品牌系列id
                ->select('ware_id', 'ware_name', 'wago_goo_id', 'wago_stock_number', 'wago_priority_stock_number', 'wago_class', 'goo_name', 'goo_goods_encode', 'goo_cate_name', 'goo_bra_name', 'goo_price', 'goo_wholesale_price', 'goo_brse_id', 'goo_class', 'goo_id', 'wago_freight_stock_number', 'wago_freight_priority_stock_number', 'wago_id')
                ->orderBy('wago_stock_number', 'desc')
                ->paginate($this->show_count);
            
            $data_info['current_page'] = $warehouse->currentPage();  //当前页面页码
            $data_info['last_page'] = $warehouse->lastPage();        //表示最后一页的页码
            $data_info['total'] = $warehouse->total();               //总数据个数
            $data_info['current_number'] = $this->show_count;       //一页显示多少个
            $data_info['warehouse'] = $warehouse->items();                //返回数据
            if ($data_info['warehouse']) {
                // 查询品牌系列数据
                $goo_brse_id = array_filter(array_unique(array_column($data_info['warehouse'], 'goo_brse_id')));
                $brse_data = DB::table('brand_serie')
                    ->whereIn('brse_id', $goo_brse_id)
                    ->pluck('brse_name', 'brse_id')
                    ->toArray();
                foreach ($data_info['warehouse'] as $key => $value) {
                    // 判断系列id,是否为空,不为空,将系列名称跟商品名称拼接在一起
                    if (!in_array($user_info->adm_shop_id, config('apisystem.NO_BRSND_SERIE_SHOP'))) {
                        if (!empty($value->goo_brse_id)) {
                            // 显示系列名称
                            if ($value->goo_class == 2) {
                                $data_info['warehouse'][$key]->goo_name = $brse_data[$value->goo_brse_id] . ' ' . $value->goo_name;
                            } else {
                                if (!in_array($user_info->adm_shop_id, config('apisystem.NO_SELF_GOODS_SHOP'))) {
                                    $data_info['warehouse'][$key]->goo_name = $brse_data[$value->goo_brse_id] . ' ' . $value->goo_name;
                                }
                            }
                        }
                    }
                    // 显示品牌名称
                    if (!in_array($user_info->adm_shop_id, config('apisystem.NO_BRAND_SHOP'))) {
                        if ($value->goo_class == 2) {
                            $data_info['warehouse'][$key]->goo_name = $value->goo_bra_name . ' ' . $value->goo_name;
                        } else {
                            if (!in_array($user_info->adm_shop_id, config('apisystem.NO_SELF_GOODS_SHOP'))) {
                                $data_info['warehouse'][$key]->goo_name = $value->goo_bra_name . ' ' . $value->goo_name;
                            }
                        }
                    }
                    $goods_data = DB::table('goods_system_affiliate')
                        ->where('gosa_shop_id', $user_info->adm_shop_id)
                        ->where('gosa_goo_id', $value->goo_id)
                        ->select('gosa_goo_id', 'gosa_price', 'gosa_wholesale_price')
                        ->first();
                    if ($goods_data) {
                        $data_info['warehouse'][$key]->goo_price = $goods_data->gosa_price;
                        $data_info['warehouse'][$key]->goo_wholesale_price = $goods_data->gosa_wholesale_price;
                    }
                    // 仓位良品库存数量或仓位优先库存数量 > 0, 查询对应的仓位表数据
                    $data_info['warehouse'][$key]->wafg_data = DB::table('warehouse_freight_goods as wafg')
                        ->leftjoin('warehouse_freight as wafr', 'wafg.wafg_wafr_id', '=', 'wafr.wafr_id')
                        ->where('wafg_ware_id', $value->ware_id)
                        ->where('wafg_wago_id', $value->wago_id)
                        ->where('wafg_class', $value->wago_class)
                        ->where('wafg_goo_id', $value->wago_goo_id)
                        ->where(function ($query) use ($user_info) {
                            $query->where('wafg_stock_number', '>', 0)
                                ->orWhere('wafg_priority_stock_number', '>', 0);
                        })
                        ->select('wafr_id', 'wafr_name', 'wafr_rank', 'wafg_stock_number', 'wafg_priority_stock_number')
                        ->get()->toArray();
                    unset($data_info['warehouse'][$key]->goo_brse_id);
                    unset($data_info['warehouse'][$key]->goo_bra_name);
                }
            }
        } else {
            $data_info['warehouse'] = [];
        }
        return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$data_info]);
    }
}
