<?php
namespace App\Http\Controllers\Api\InformationHint;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Controllers\Api\Verify\InformationHint\VerifyInformationHintController;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Crypt;
use App\Http\Models\Api\Common;

class InformationHintController extends Controller
{
    // 列表每页显示数据个数
    protected $show_count = 10;
    // inhi_operation_state 操作状态：1新订单2生成工单3拒单4终止5接单6预约7出发8抵达9完成10工单审核通过11订单结算12取消订单13工单改单14工单派单15工单审核通过16工单反审核17新速电网单18门店接单19门店拒单20速电申请改单21速电改单通过22速电催单23暂停24门店被锁单提醒25门店被催单提醒
    protected $popup_state = [1,2,3,17,21,22,24,25];//需要弹框信息提示状态
    // protected $popup_state = [];//需要弹框信息提示状态

    // 列表
    public function index(Request $request)
    {
        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);

        $list_data = DB::table('information_hint')
            ->where('inhi_cid', $user_info->adm_cid)
            ->where('inhi_shop_id', $user_info->adm_shop_id)
            ->whereNotIn('inhi_operation_state', $this->popup_state)
            ->where('inhi_state', 1)
            ->orderBy('inhi_id', 'desc')
            ->select('inhi_id', 'inhi_original_id', 'inhi_original_number', 'inhi_type', 'inhi_original_operation', 'inhi_operation_state', 'inhi_create_time')
            ->paginate($this->show_count);
        $data = $list_data->items();

        $data_info['current_page'] = $list_data->currentPage();  //当前页面页码
        $data_info['last_page'] = $list_data->lastPage();        //表示最后一页的页码
        $data_info['total'] = $list_data->total();               //总数据个数
        $data_info['current_number'] = $this->show_count;       //一页显示多少个
        $data_info['data'] = $data;                //返回数据
        if ($list_data) {
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$data_info]);
        } else {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'暂无数据']);
        }
    }

    // 更改状态
    public function changeState(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyInformationHintController;
        $error_message = $verify_data->changeStateValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }

        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);

        $data['inhi_state'] = 2;//状态1未查看2已查看
        $data['inhi_random_number'] = rand(100000,999999);//随机数
        $data['inhi_update_time'] = date('Y-m-d H:i:s');
        $inhi_res = DB::table('information_hint')
            ->where('inhi_cid', $user_info->adm_cid)
            ->where('inhi_shop_id', $user_info->adm_shop_id)
            ->whereIn('inhi_id', $request['inhi_id'])
            ->update($data);
        if ($inhi_res) {
            $inhi_original_number = implode(',', array_unique($request['inhi_original_number']));
            // Common::addLog($user_info, getRealIp($request), '信息提示', '不在提示', '单号：'.$inhi_original_number.'不在提示');
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>'成功']);
        } else {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'失败']);
        }
    }

    // 获取弹出提示信息
    public function getPopup(Request $request)
    {
        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);

        $list_data = DB::table('information_hint')
            ->where('inhi_cid', $user_info->adm_cid)
            ->where('inhi_shop_id', $user_info->adm_shop_id)
            ->whereIn('inhi_operation_state', $this->popup_state)
            ->where('inhi_state', 1)
            ->orderBy('inhi_id', 'desc')
            ->select('inhi_id', 'inhi_original_id', 'inhi_original_number', 'inhi_type', 'inhi_original_operation', 'inhi_operation_state', 'inhi_create_time')
            ->get();
        if ($list_data) {
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$list_data]);
        } else {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'暂无数据']);
        }
    }

    // 登录获取提示消息
    public function getHintMessage(Request $request)
    {
        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);

        $list_data = DB::table('information_hint')
            ->where('inhi_cid', $user_info->adm_cid)
            ->where('inhi_shop_id', $user_info->adm_shop_id)
            ->whereIn('inhi_operation_state', $this->popup_state)
            ->where('inhi_state', 1)
            ->orderBy('inhi_id', 'desc')
            ->select('inhi_id', 'inhi_original_id', 'inhi_original_number', 'inhi_type', 'inhi_original_operation', 'inhi_operation_state', 'inhi_create_time')
            ->paginate(30);
        $data = $list_data->items();
        $data_info['current_page'] = $list_data->currentPage();  //当前页面页码
        $data_info['last_page'] = $list_data->lastPage();        //表示最后一页的页码
        $data_info['total'] = $list_data->total();               //总数据个数
        $data_info['current_number'] = $this->show_count;       //一页显示多少个
        $data_info['data'] = $data;                //返回数据
        if ($list_data) {
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$data_info]);
        } else {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'暂无数据']);
        }
    }
}
