<?php

namespace App\Http\Controllers\Api\Files;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Models\Api\Export;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use \PhpOffice\PhpSpreadsheet\IOFactory;
use App\Services\Software\QrCodeService;
use Illuminate\Support\Facades\DB;
class FilesController extends Controller
{
	/**
     * 上传文件
     */
    public function upload(Request $request)
    {
        if (empty($request['shop_id'])) {
            return response()->json(['code'=>500, 'msg'=>'请选择门店', 'data'=>'']);
        }
        $free = '';
        if (isset($request['ord_order_number']) && !empty($request['ord_order_number'])) {//贴装的订单
            $find_order = DB::table('order')
                ->where('ord_order_number', $request['ord_order_number'])
                ->first();
            if ($find_order && $find_order->ord_source == 5) {
                $free = 'free';
            }
        }
        if ($request['shop_id'] == '[object Undefined]') {
            $request['shop_id'] = 2;
            $free = 'free';
        }
        if (empty($free)) {
            $shop_use_space = shopFoldSize($request['shop_id']);
            $find_shop = DB::table('shop')
                ->where('shop_id', $request['shop_id'])
                ->select('shop_free_space', 'shop_toll_space', 'shop_superior_id', 'shop_source_identify')
                ->first();
            $space = $find_shop->shop_free_space + $find_shop->shop_toll_space;
            if ($shop_use_space >= $space && $find_shop->shop_source_identify != 5) {
                if ($find_shop->shop_superior_id) {//分店
                    return response()->json(['code'=>501, 'msg'=>'空间不足，请联系总店购买空间后上传', 'data'=>'']);
                } else {//总店
                    return response()->json(['code'=>502, 'msg'=>'空间不足，请购买空间后上传'.$request['ord_order_number'], 'data'=>'']);
                }
            }
        }
        //在源生的php代码中是使用$_FILE来查看上传文件的属性
        //但是在laravel里面有更好的封装好的方法，就是下面这个
        $file_object = $request->file('file');
        if (empty($file_object)) {
			return response()->json(['code'=>500, 'msg'=>'上传文件过大！请重新上传文件', 'data'=>'']);
        }
        if ($file_object->isValid()) { //括号里面的是必须加
            //如果括号里面的不加上的话，下面的方法也无法调用的

            //获取文件的扩展名
            $ext = $file_object->getClientOriginalExtension();
            //获取文件的绝对路径
            $path = $file_object->getRealPath();
            // 获取php.ini允许上传的最大大小
            // $max_file_size = $file_object->getMaxFilesize();

            // 获取客户端上传文件类型 视频：video/mp4  图片：image/jpeg
            $client_file_type = $file_object->getClientMimeType();
            // 判断上传文件类型
            if (strpos($client_file_type, 'image/') !== false) {
                // 上传的是图片
                $path_type_name = 'image';//文件夹名
            } elseif (strpos($client_file_type, 'video/') !== false) {
                // 上传的是视频
                $path_type_name = 'video';//文件夹名
            } else {
			    return response()->json(['code'=>500, 'msg'=>'不支持的上传类型', 'data'=>'']);
            }
            
            //定义文件名
            $file_name = time() . rand(11, 99) .rand(111, 999).'.'.$ext;
            $original_file_name = 'original2'.$file_name;
            $shop_id = $request->input('shop_id', 0);
		    $folder = $shop_id.date('/Y/m/d/');
		    $path_name = storage_path() . '/app/public/'.$free.$path_type_name.'/'.$folder; //定义上传文件路径

            //获取上传文件大小，字节 kb
            $files_size = $file_object->getClientSize();
            $size = $files_size / 1024 / 1024;//换算为mb
            
            $size = sprintf( "%.2f", $size);//保留两位小数

            // 如果上传视频，限制上传视频文件大小
            if ($path_type_name == 'video' && $size > 20) {
			    return response()->json(['code'=>500, 'msg'=>'上传视频文件过大！', 'data'=>'']);
            }

		    // 判断文件夹是否存在，不存在创建文件夹
		    if (!file_exists($path_name)) {
		        mkdir($path_name, 0775, true);
		        chmod($path_name, 0775);
		    }
		    // laravel框架的上传文件方法，文件夹路径，文件名
            $move_return = $file_object->move($path_name, $file_name);
            // 复制原图
            // $copy = copy($path_name.$file_name, $path_name.$original_file_name);
            $copy = copyImage($path_name.$file_name, $path_name.$original_file_name);

            // 上传图片，图片大小超过1M，进行压缩图片
            if ($size > 1 && $path_type_name == 'image') {
                if ($size < 2) {
                    $percent = 0.6;//压缩比例
                } else if ($size < 4) {
                    $percent = 0.4;//压缩比例
                } else if ($size < 20) {
                    $percent = 0.3;//压缩比例
                } else {
                    // 上传十几M的图片在压缩的时候，压缩不了
			        return response()->json(['code'=>500, 'msg'=>'上传图片文件过大！', 'data'=>'{}']);
                }
                // 压缩图片
                $new_stream_file_name = $path_name.'2'.$file_name; //上传到服务器图片路径
                $stream_file_name = $path_name.$file_name;
                try {
                    imageCompress($stream_file_name, $percent, $new_stream_file_name);
                } catch (\Exception $e) {
			        return response()->json(['code'=>500, 'msg'=>'上传失败', 'data'=>'{}']);
                }
                // 删除原来的图片
                deleteImage([$stream_file_name]);
                $file_name = '2'.$file_name;
            }
        	$file_path = 'storage/'.$free.$path_type_name.'/'.$folder. $file_name;
        	$img_url = config('apisystem.server_name_https').'/'.$file_path;
            $return_data['img_url'] = $img_url;
            $return_data['img_path'] = $file_path;
            if (empty($free)) {
                $shop_use_space = shopFoldSize($request['shop_id']);
                $update_data['shop_use_space'] = number_format($shop_use_space, 2);
                $update_res = DB::table('shop')
                    ->where('shop_id', $request['shop_id'])
                    ->update($update_data);
            }
			return response()->json(['code'=>200, 'msg'=>'上传成功', 'data'=>$return_data]);
        } else {
			return response()->json(['code'=>500, 'msg'=>'未找到上传文件', 'data'=>'']);
        }
    }

    // 生成二维码
    public function qrCode(Request $request)
    {
        $QrCodeService = new QrCodeService();
        // $type = 1;//类型：1创建二维码不保存图片2创建二维码并保存图片

        $text = config('apisystem.server_name_https'). '/pc/index.html?type='.$request['type'].'&id='.$request['id'].'&uuid='.rand(100000000,99999999);//内容数据
        $res = $QrCodeService->qrCode(1, $text);
        return $res;
    }

    /**
     * 上传文件
     */
    public function basicUpload(Request $request)
    {
        if (empty($request['shop_id'])) {
            return response()->json(['code'=>500, 'msg'=>'请选择门店', 'data'=>'']);
        }
        $free = '';
        if (isset($request['ord_order_number']) && !empty($request['ord_order_number'])) {//贴装的订单
            $find_order = DB::table('order')
                ->where('ord_order_number', $request['ord_order_number'])
                ->first();
            if ($find_order && $find_order->ord_source == 5) {
                $free = 'free';
            }
        }
        if ($request['shop_id'] == '[object Undefined]') {
            $request['shop_id'] = 2;
            $free = 'free';
        }
        if (empty($free)) {
            $shop_use_space = shopFoldSize($request['shop_id']);
            $find_shop = DB::table('shop')
                ->where('shop_id', $request['shop_id'])
                ->select('shop_free_space', 'shop_toll_space', 'shop_superior_id', 'shop_source_identify')
                ->first();
            $space = $find_shop->shop_free_space + $find_shop->shop_toll_space;
            if ($shop_use_space >= $space && $find_shop->shop_source_identify != 5) {
                if ($find_shop->shop_superior_id) {//分店
                    return response()->json(['code'=>501, 'msg'=>'空间不足，请联系总店购买空间后上传', 'data'=>'']);
                } else {//总店
                    return response()->json(['code'=>502, 'msg'=>'空间不足，请购买空间后上传'.$request['ord_order_number'], 'data'=>'']);
                }
            }
        }
        //在源生的php代码中是使用$_FILE来查看上传文件的属性
        //但是在laravel里面有更好的封装好的方法，就是下面这个
        $file_object = $request->file('file');
        if (empty($file_object)) {
            return response()->json(['code'=>500, 'msg'=>'上传文件过大！请重新上传文件', 'data'=>'']);
        }
        if ($file_object->isValid()) { //括号里面的是必须加
            //如果括号里面的不加上的话，下面的方法也无法调用的

            //获取文件的扩展名
            $ext = $file_object->getClientOriginalExtension();
            //获取文件的绝对路径
            $path = $file_object->getRealPath();
            // 获取php.ini允许上传的最大大小
            // $max_file_size = $file_object->getMaxFilesize();

            // 获取客户端上传文件类型 视频：video/mp4  图片：image/jpeg
            $client_file_type = $file_object->getClientMimeType();
            // 判断上传文件类型
            if (strpos($client_file_type, 'image/') !== false) {
                // 上传的是图片
                $path_type_name = 'image';//文件夹名
            } elseif (strpos($client_file_type, 'video/') !== false) {
                // 上传的是视频
                $path_type_name = 'video';//文件夹名
            } else {
                return response()->json(['code'=>500, 'msg'=>'不支持的上传类型', 'data'=>'']);
            }
            
            //定义文件名
            $file_name = time() . rand(11, 99) .rand(111, 999).'.'.$ext;
            $original_file_name = 'original2'.$file_name;
            $shop_id = $request->input('shop_id', 0);
            $folder = $shop_id.'/basicImage'.date('/Y/m/d/');
            $path_name = storage_path() . '/app/public/'.$free.$path_type_name.'/'.$folder; //定义上传文件路径

            //获取上传文件大小，字节 kb
            $files_size = $file_object->getClientSize();
            $size = $files_size / 1024 / 1024;//换算为mb
            
            $size = sprintf( "%.2f", $size);//保留两位小数

            // 如果上传视频，限制上传视频文件大小
            if ($path_type_name == 'video' && $size > 20) {
                return response()->json(['code'=>500, 'msg'=>'上传视频文件过大！', 'data'=>'']);
            }

            // 判断文件夹是否存在，不存在创建文件夹
            if (!file_exists($path_name)) {
                mkdir($path_name, 0775, true);
                chmod($path_name, 0775);
            }
            // laravel框架的上传文件方法，文件夹路径，文件名
            $move_return = $file_object->move($path_name, $file_name);
            // 复制原图
            // $copy = copy($path_name.$file_name, $path_name.$original_file_name);
            $copy = copyImage($path_name.$file_name, $path_name.$original_file_name);

            // 上传图片，图片大小超过1M，进行压缩图片
            if ($size > 1 && $path_type_name == 'image') {
                if ($size < 2) {
                    $percent = 0.6;//压缩比例
                } else if ($size < 4) {
                    $percent = 0.4;//压缩比例
                } else if ($size < 20) {
                    $percent = 0.3;//压缩比例
                } else {
                    // 上传十几M的图片在压缩的时候，压缩不了
                    return response()->json(['code'=>500, 'msg'=>'上传图片文件过大！', 'data'=>'{}']);
                }
                // 压缩图片
                $new_stream_file_name = $path_name.'2'.$file_name; //上传到服务器图片路径
                $stream_file_name = $path_name.$file_name;
                try {
                    imageCompress($stream_file_name, $percent, $new_stream_file_name);
                } catch (\Exception $e) {
                    return response()->json(['code'=>500, 'msg'=>'上传失败', 'data'=>'{}']);
                }
                // 删除原来的图片
                deleteImage([$stream_file_name]);
                $file_name = '2'.$file_name;
            }
            $file_path = 'storage/'.$free.$path_type_name.'/'.$folder. $file_name;
            $img_url = config('apisystem.server_name_https').'/'.$file_path;
            $return_data['img_url'] = $img_url;
            $return_data['img_path'] = $file_path;
            if (empty($free)) {
                $shop_use_space = shopFoldSize($request['shop_id']);
                $update_data['shop_use_space'] = number_format($shop_use_space, 2);
                $update_res = DB::table('shop')
                    ->where('shop_id', $request['shop_id'])
                    ->update($update_data);
            }
            return response()->json(['code'=>200, 'msg'=>'上传成功', 'data'=>$return_data]);
        } else {
            return response()->json(['code'=>500, 'msg'=>'未找到上传文件', 'data'=>'']);
        }
    }
}
