<?php
namespace App\Http\Controllers\Api\ExcelInfo;

use App\Http\Controllers\Controller;
use App\Http\Models\Api\Common;
use App\Services\CommonService;
use Illuminate\Http\Request;
use DB;
use BlueCity\Core\Inc\ErrorInc;
use Chumper\Zipper\Zipper;
use App\Services\Business\ExceloutService;
use App\Services\Business\WashOrderService;
use App\Http\Enum\Business\OrderEnum;

/**
 * @name excel导出管理
 * Class ExceloutController
 * @package App\Http\Controllers\Excelout
 */
class ExceloutController extends Controller
{


    /**
     * @name 执行数据
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     * @throws \Exception
     * @author du
     * @date 2021/8/25
     */
	public function execExcelOut(Request $request){
        $request = $request->all();
		if(!isset($request['el_id'])){
            return response()->json(['code'=>205, 'msg'=>'参数错误', 'data'=>'']);
		}
        $user_info = Common::getUserInfo($request['api_token']);
		$id = intval($request['el_id']);
		$res = DB::table("excel_list")
				->where('el_id',$id)
				->where('el_state','1')
				->select("el_action","el_id","el_sql","el_path","el_item","el_adminid","el_template_id")
				->orderBy('el_id','ASC')->first();
        $res = CommonService::dataToArray($res);
		if($res){
			if (!file_exists($res['el_path'])) {
				// 创建文件夹
				mkdir($res['el_path'],0775,true);
				chmod($res['el_path'],0775);
			}
			$api_name = "perform".$res['el_action'];
			$api_name = (string)$api_name;
			return $this->$api_name($user_info,$res);
		}else{
		   	$path = DB::table('excel_list')->where('el_id',$id)->value('el_path');
		   	$zipper = new Zipper();
		   	$arr = glob(public_path($path));   //$public_path  被压缩的文件名
		   	$reduce_path = $path.'.zip';
		   	$zipper->make(public_path($reduce_path))->add($arr)->close();  //public_path($reduce_path)  压缩之后 */
		   	$zip = new \ZipArchive();
		   	$zipStatus = $zip->open($reduce_path);
		   	if ($zipStatus !== true) {
                return response()->json(['data' =>'', 'msg' => '压缩失败', 'code' => 205]);exit;
		   	}
		   	DB::table("excel_list")->where('el_id',$id)->update(['el_state'=>2]);
            //	 = $this->baseurl().$reduce_path;
            return response()->json(['code' => 222, 'msg' => '执行完毕', 'data' => '']);
		   	//return $this->success('执行完毕',$reduce_path);exit;
		}
	}

	//订单列表
    public function performWashOrderindex($user_info,$res,$con='WashOrderindex'){
        $detail = DB::table("excel_detail")->where("ed_elid",$res['el_id'])->where("ed_state",'1')->first();
        if($detail){
            $detail = CommonService::dataToArray($detail);
            $data = ExceloutService::getDatas($con, $res, $detail, $user_info);
            $db = $data['db'];
            $group = $data['group'];
            $file = $data['file'];
            if($db){
                $orcl_sales_adm_id = array_column($db, 'orcl_sales_adm_id');
                $admin = DB::table('admin')
                    ->whereIn('adm_id', $orcl_sales_adm_id)
                    ->pluck('adm_name', 'adm_id');
                $num1 = count($db);
                foreach( $db as $k => $v ){
                    $v = ExceloutService::replaceData($v);
                    foreach( $group as $kg => $vg ){
                        if ( $vg=='ord_source'){//订单来源
                            if ($v['ord_source'] == '1') {
                                $rs[$k][$kg] = 'pc端';
                            } elseif ($v['ord_source'] == '2') {
                                $rs[$k][$kg] = '车主端';
                            } elseif ($v['ord_source'] == '3') {
                                $rs[$k][$kg] = '技师端';
                            } elseif ($v['ord_source'] == '4') {
                                $rs[$k][$kg] = '合作商';
                            } elseif ($v['ord_source'] == '5') {
                                $rs[$k][$kg] = '智配贴装';
                            }else{
                                $rs[$k][$kg] = '';
                            }
                        }elseif($vg=='ord_wor_state'){//订单状态
                            if ($v['ord_wor_state'] == '1') {
                                $rs[$k][$kg] = '待派单';
                            } elseif ($v['ord_wor_state'] == '2') {
                                if($v['orcl_appoint_time'] == '0000-00-00 00:00:00'){
                                    $rs[$k][$kg] = '未预约';
                                }else{
                                    $rs[$k][$kg] = '服务中';
                                }
                            } elseif ($v['ord_wor_state'] == '4') {
                                $rs[$k][$kg] = '待评价';
                            } elseif ($v['ord_wor_state'] == '20') {
                                $rs[$k][$kg] = '已完成';
                            } elseif ($v['ord_wor_state'] == '11') {
                                $rs[$k][$kg] = '已取消';
                            } elseif ($v['ord_wor_state'] == '7') {
                                $rs[$k][$kg] = '待接单';
                            }else{
                                $rs[$k][$kg] = '1';
                            }
                        }elseif($vg=='ord_ware_id'){//仓库
                            if ($v['ord_ware_id'] == '0') {
                                $rs[$k][$kg] = '';
                            }else{
                                // 查找仓库id对应的仓库名称
                                $ware_name = DB::table('warehouse')
                                    ->where('ware_id', $v['ord_ware_id'])
                                    ->where('ware_shop_id', $user_info->adm_shop_id)
                                    ->value('ware_name');
                                $rs[$k][$kg] = $ware_name;
                            }
                        }elseif($vg=='ord_order_price'){//订单总额
                            $rs[$k][$kg] = $v['ord_order_price'] / 100;
                        }elseif($vg=='ord_actual_price'){//实付金额
                            $rs[$k][$kg] = $v['ord_actual_price'] / 100;
                        }elseif($vg=='ord_state'){//结算状态
                            if ($v['ord_state'] == '1') {
                                $rs[$k][$kg] = '未结算';
                            } elseif ($v['ord_state'] == '2') {
                                $rs[$k][$kg] = '已结算';
                            }elseif ($v['ord_state'] == '3') {
                                $rs[$k][$kg] = '部分结算';
                            }else{
                                $rs[$k][$kg] = '未定义';
                            }
                        }elseif($vg=='ord_payment_way'){//结算方式
                            if ($v['ord_payment_way'] == 0) {
                                $rs[$k][$kg] = '暂不结算';
                            } elseif ($v['ord_payment_way'] == 1) {
                                $rs[$k][$kg] = '现金';
                            } elseif ($v['ord_payment_way'] == 2) {
                                $rs[$k][$kg] = '支付宝';
                            } elseif ($v['ord_payment_way'] == 3) {
                                $rs[$k][$kg] = '微信';
                            } elseif ($v['ord_payment_way'] == 4) {
                                $rs[$k][$kg] = '银行卡';
                            } elseif ($v['ord_payment_way'] == 5) {
                                $rs[$k][$kg] = '会员卡';
                            } elseif ($v['ord_payment_way'] == 6) {
                                $rs[$k][$kg] = '余额';
                            } elseif ($v['ord_payment_way'] == 7) {
                                $rs[$k][$kg] = '他人代付';
                            } elseif ($v['ord_payment_way'] == 8) {
                                $rs[$k][$kg] = '账期';
                            } elseif ($v['ord_payment_way'] == 9) {
                                $rs[$k][$kg] = '部分结款';
                            } elseif ($v['ord_payment_way'] == 10) {
                                $rs[$k][$kg] = '签到领取';
                            } elseif ($v['ord_payment_way'] == 11) {
                                $rs[$k][$kg] = '积分兑换';
                            } elseif ($v['ord_payment_way'] == 12) {
                                $rs[$k][$kg] = '会员礼品';
                            }else{
                                $rs[$k][$kg] = '未定义';
                            }
                        }elseif($vg=='ord_settlement_time'){
                            if($v['ord_settlement_time'] == '0000-00-00 00:00:00'){
                                $rs[$k][$kg] = '';
                            }else{
                                $rs[$k][$kg] = $v['ord_settlement_time']."\t";
                            }
                        }elseif($vg=='ord_type'){
                            if ($v['ord_type'] == '1') {
                                $rs[$k][$kg] = '会员零售';
                            } elseif ($v['ord_type'] == '2') {
                                $rs[$k][$kg] = '客户单位';
                            } elseif ($v['ord_type'] == '3') {
                                $rs[$k][$kg] = '速电派单';
                            } elseif ($v['ord_type'] == '4') {
                                $rs[$k][$kg] = '第三方派单';
                            } elseif ($v['ord_type'] == '5') {
                                $rs[$k][$kg] = '运营中心给门店派单';
                            } else{
                                $rs[$k][$kg] = '';
                            }
                        }elseif($vg=='orcl_sales_adm_id'){//销售人
//                            $adm_name = DB::table('admin')
//                                ->where('adm_id', $v['orcl_sales_adm_id'] )
//                                ->value('adm_name');
//                            $rs[$k][$kg] = $adm_name;
                            $rs[$k][$kg] = $admin[$v['orcl_sales_adm_id']]??'';
                        }elseif($vg=='ord_create_id'){//录单人
//                            $adm_name = DB::table('admin')
//                                ->where('adm_id', $v['ord_create_id'] )
//                                ->value('adm_name');
//                            $rs[$k][$kg] = $adm_name;
                            $rs[$k][$kg] = $v['adm_name'];
                        }elseif($vg=='ord_shop_id'){
                            if($v['ord_address_type'] == 2){//1门店2企业客户
                                $service_project_client = DB::table('business_client')
                                    ->where('bucl_id', $v['ord_address_id'])
                                    ->select('bucl_name', 'bucl_id')
                                    ->first();
                                $ord_address_name = $service_project_client->bucl_name;
                            } elseif($v['ord_address_type'] == 1){
                                $service_project_shop = DB::table('shop')
                                    ->where('shop_id', $v['ord_address_id'])
                                    ->select('shop_store_name', 'shop_id')
                                    ->first();
                                $ord_address_name = $service_project_shop ? $service_project_shop->shop_store_name:'';
                            } else {
                                $ord_address_name = '';
                            }
//                            $shop_name = DB::table('shop')
//                                ->where('shop_id', $v['ord_shop_id'] )
//                                ->value('shop_store_name');
                            $rs[$k][$kg] = $ord_address_name;
                        } else{
                                $rs[$k][$kg] = "\t".$v[$vg];
                        }
                    }
                    $datas = $rs[$k];
                    $write = self::writeSvc($file, $datas);
                    unset($db[$k]);
                    unset($rs[$k]);
                }
                $el_item = $res['el_item']+$num1;
                DB::table("excel_list")->where('el_id',$res['el_id'])->update(['el_item'=>$el_item]);
                DB::table("excel_detail")->where("ed_id",$detail['ed_id'])->update(['ed_state'=>2]);
                return response()->json(['code' => 200, 'msg' => '操作成功1', 'data' => '']);
            }else{
                DB::table("excel_detail")->where("ed_id",$detail['ed_id'])->update(['ed_state'=>2]);
                return response()->json(['code' => 200, 'msg' => '操作成功2', 'data' => '']);
            }
        }else{
            DB::table("excel_list")->where('el_id',$res['el_id'])->update(['el_state'=>2]);
            return response()->json(['code' => 200, 'msg' => '操作成功3', 'data' => '']);
        }
    }

    /**
     * @name 调拨单
     * @param $res
     * @param $con 控制器
     * @return mixed
     * @author du
     * @date 2021/8/25
     */
    public function performTransferringOrdersindex($user_info,$res,$con='TransferringOrdersindex'){
        $detail = DB::table("excel_detail")->where("ed_elid",$res['el_id'])->where("ed_state",'1')->first();
        if($detail){
            $detail = CommonService::dataToArray($detail);
            $data = ExceloutService::getDatas($con, $res, $detail,$user_info);
            $db = $data['db'];
            $group = $data['group'];
            $file = $data['file'];
            if($db){
                $num1 = count($db);
                foreach( $db as $k => $v ){
                    $v = ExceloutService::replaceData($v);
                    foreach( $group as $kg => $vg ){
                        $num = array_search($vg,$group);
                        if ( $vg=='tror_out_ware_id'){//调出仓库
                            if($v['tror_out_ware_id']){
                                $ware_name = DB::table('warehouse')->where('ware_id',$v['tror_out_ware_id'])->value('ware_name');
                                $rs[$k][$kg] = $ware_name;
                            }else{
                                $rs[$k][$kg] = '';
                            }
                        }else if ( $vg=='tror_in_ware_id'){//调入仓库
                            if($v['tror_in_ware_id']){
                                $ware_name = DB::table('warehouse')->where('ware_id',$v['tror_in_ware_id'])->value('ware_name');
                                $rs[$k][$kg] = $ware_name;
                            }else{
                                $rs[$k][$kg] = '';
                            }
                        }else if ( $vg=='tror_create_id'){//创建人
                            if($v['tror_create_id']){
                                $adm_name = DB::table('admin')->where('adm_id',$v['tror_create_id'])->value('adm_name');
                                $rs[$k][$kg] = $adm_name;
                            }else{
                                $rs[$k][$kg] = '';
                            }
                        }else if ( $vg=='tror_service_adm_id'){//送货人
                            if($v['tror_service_adm_id']){
                                $adm_name = DB::table('admin')->where('adm_id',$v['tror_service_adm_id'])->value('adm_name');
                                $rs[$k][strtolower(chr(65+$num))] = $adm_name;
                            }else{
                                $rs[$k][strtolower(chr(65+$num))] = '';
                            }
                        }else if ( $vg=='tror_state'){//状态
                            if($v['tror_state'] == 1){
                                $rs[$k][$kg] = '待审核';
                            }else if($v['tror_state'] == 2){
                                $rs[$k][$kg] = '待出库';
                            }else if($v['tror_state'] == 3){
                                $rs[$k][$kg] = '待入库';
                            }else if($v['tror_state'] == 4){
                                $rs[$k][$kg] = '已入库';
                            }else if($v['tror_state'] == 5){
                                $rs[$k][$kg] = '驳回';
                            }else if($v['tror_state'] == 6){
                                $rs[$k][$kg] = '撤销';
                            }else{
                                $rs[$k][$kg] = '';
                            }
                        }else{
                            $rs[$k][$kg] = "\t".$v[$vg]."\t";
                        }
                    }
                    $datas = $rs[$k];
                    $write = self::writeSvc($file, $datas);
                    unset($db[$k]);
                    unset($rs[$k]);
                }
                $el_item = $res['el_item']+$num1;
                DB::table("excel_list")->where('el_id',$res['el_id'])->update(['el_item'=>$el_item]);
                DB::table("excel_detail")->where("ed_id",$detail['ed_id'])->update(['ed_state'=>2]);
                return response()->json(['code' => 200, 'msg' => '操作成功1', 'data' => '']);
            }else{
                DB::table("excel_detail")->where("ed_id",$detail['ed_id'])->update(['ed_state'=>2]);
                return response()->json(['code' => 200, 'msg' => '操作成功2', 'data' => '']);
            }
        }else{
            DB::table("excel_list")->where('el_id',$res['el_id'])->update(['el_state'=>2]);
            return response()->json(['code' => 200, 'msg' => '操作成功3', 'data' => '']);
        }
    }


    /**
     * @name 应收应付
     * @param $res
     * @param $con 控制器
     * @return mixed
     * @author du
     * @date 2021/8/25
     */
    public function performreceivablePayindex($user_info,$res,$con='receivablePayindex'){
        $detail = DB::table("excel_detail")->where("ed_elid",$res['el_id'])->where("ed_state",'1')->first();
        if($detail){
            $detail = CommonService::dataToArray($detail);
            $data = ExceloutService::getDatas($con, $res, $detail,$user_info);
            $db = $data['db'];
            $group = $data['group'];
            $file = $data['file'];
            if($db){
                $num1 = count($db);
                foreach( $db as $k => $v ){
                    $v = ExceloutService::replaceData($v);
                    foreach( $group as $kg => $vg ){
                        $num = array_search($vg,$group);
                        if ( $vg=='recpay_type'){
                            if($v['recpay_type'] == 1){
                                $rs[$k][$kg] = '订单收款';
                            }else if($v['recpay_type'] == 2){
                                $rs[$k][$kg] = '充值卡';
                            }else{
                                $rs[$k][$kg] = '';
                            }
                        }else if( $vg=='recpay_client_type') {
                            if($v['recpay_client_type'] == 0){
                                $rs[$k][$kg] = '散户';
                            }else if($v['recpay_client_type'] == 1){
                                $rs[$k][$kg] = '个人会员';
                            }else if($v['recpay_client_type'] == 2){
                                $rs[$k][$kg] = '企业会员';
                            }else{
                                $rs[$k][$kg] = '';
                            }
                        }/*else if( $vg=='recpay_source') {
                            if($v['recpay_source'] == 5){
                                $orcl_id = $v['recpay_orcl_id'];
                            }else if($v['recpay_source'] == 6){
                                $orcl_id = $v['ord_orcl_id'];
                            }
                            $cl_name = DB::table('order_client')
                                ->where('orcl_id', $orcl_id)
                                ->value('orcl_name');
                            $rs[$k][$kg] = $cl_name;
                        }*/else if( $vg=='recpay_receivable_price') {
                            $rs[$k][$kg] = $v['recpay_receivable_price'] / 100;
                        }else if( $vg=='recpay_arrears_price') {
                            $rs[$k][$kg] = $v['recpay_arrears_price'] / 100;
                        }else if( $vg=='recpay_actual_price') {
                            $rs[$k][$kg] = $v['recpay_actual_price'] / 100;
                        }else if( $vg=='recpay_cost_price') {
                            $rs[$k][$kg] = $v['recpay_cost_price'] / 100;
                        }else if( $vg=='recpay_receivable_pay') {
                            $rs[$k][$kg] = $v['recpay_receivable_pay'] / 100;
                        }else if( $vg=='recpay_zero_price') {
                            $rs[$k][$kg] = $v['recpay_zero_price'] / 100;
                        }else if( $vg=='recpay_profit') {
                            if($v['recpay_plus_minus'] == 2){
                                $rs[$k][$kg] = -($v['recpay_profit'] / 100);//盈利金额
                            }else{
                                $rs[$k][$kg] = $v['recpay_profit'] / 100;//盈利金额
                            }
                        }else if( $vg=='orcl_business_name') {
                            if($v['ord_address_type'] == 2){
                                $rs[$k][$kg] = $v['orcl_business_name'];//施工门店
                            }else{
                                $rs[$k][$kg] = '本店施工';//施工门店
                            }
                        }else if( $vg=='recpay_state') {
                            if($v['recpay_state'] == 1){
                                $rs[$k][$kg] = '未确认';
                            }else if($v['recpay_state'] == 2){
                                $rs[$k][$kg] = '已确认';
                            }else if($v['recpay_state'] == 3){
                                $rs[$k][$kg] = '已作废';
                            }else{
                                $rs[$k][$kg] = '';
                            }
                        }else{
                                $rs[$k][$kg] = "\t".$v[$vg]."\t";
                        }
                    }
                    $datas = $rs[$k];
                    $write = self::writeSvc($file, $datas);
                    unset($db[$k]);
                    unset($rs[$k]);
                }
                $el_item = $res['el_item']+$num1;
                DB::table("excel_list")->where('el_id',$res['el_id'])->update(['el_item'=>$el_item]);
                DB::table("excel_detail")->where("ed_id",$detail['ed_id'])->update(['ed_state'=>2]);
                return response()->json(['code' => 200, 'msg' => '操作成功1', 'data' => $group]);
            }else{
                DB::table("excel_detail")->where("ed_id",$detail['ed_id'])->update(['ed_state'=>2]);
                return response()->json(['code' => 200, 'msg' => '操作成功2', 'data' => '']);
            }
        }else{
            DB::table("excel_list")->where('el_id',$res['el_id'])->update(['el_state'=>2]);
            return response()->json(['code' => 200, 'msg' => '操作成功3', 'data' => '']);
        }
    }



    /**
     * @name 商品
     * @param $res
     * @param $con 控制器
     * @return mixed
     * @author du
     * @date 2021/8/25
     */
    public function performGoodsListindex($user_info,$res,$con='GoodsListindex'){
        $detail = DB::table("excel_detail")->where("ed_elid",$res['el_id'])->where("ed_state",'1')->first();
        if($detail){
            $detail = CommonService::dataToArray($detail);
            $data = ExceloutService::getDatas($con, $res, $detail,$user_info);
            $db = $data['db'];
            $group = $data['group'];
            $file = $data['file'];
            if($db){
                $num1 = count($db);
                foreach( $db as $k => $v ){
                    $v = ExceloutService::replaceData($v);
                    foreach( $group as $kg => $vg ){
                        $num = array_search($vg,$group);
                        if ( $vg=='goo_brse_id'){
                            $brse_name = DB::table('brand_serie')->where('brse_id', $v['goo_brse_id'])->value('brse_name');
                            $rs[$k][$kg] = $brse_name;
                        }else if ( $vg=='goo_price'){
                            $rs[$k][$kg] = $v['goo_price'] / 100;
                        }else if ( $vg=='goo_wholesale_price'){
                            $rs[$k][$kg] = $v['goo_wholesale_price'] / 100;
                        }else if ( $vg=='goo_purchase_price'){
                            $rs[$k][$kg] = $v['goo_purchase_price'] / 100;
                        }else if ( $vg=='goo_class'){
                            /*if( $v['goo_class'] == 2){
                                $gosa_data = DB::table('goods_system_affiliate')
                                    ->where('gosa_shop_id', $user_info->adm_shop_id)
                                    ->whereIn('gosa_goo_id', $v['goo_id'])
                                    ->select('gosa_another_name', 'gosa_price', 'gosa_wholesale_price', 'gosa_purchase_price', 'gosa_recycle_price', 'gosa_assign_price', 'gosa_direct_accounting_price', 'gosa_goo_id')
                                    ->get()->toArray();
                            }
                            $rs[$k][$kg] = $v['goo_assign_price'] / 100;*/
                        }else if ( $vg=='goo_attribute'){
                            if(!empty($v['goo_attribute'])){
                                $goo_attribute = json_decode($v['goo_attribute'], true);
                                $t = '';
                                foreach ($goo_attribute as $katt => $vatt) {
                                    $vatt = join("：", $vatt); // 可以用implode将一维数组转换为用逗号连接的字符串，join是别名
                                    $temp[] = $vatt;
                                }
                                foreach ($temp as $a) {
                                    $t .= $a . ", ";
                                }
                                $t = substr($t, 0, -1);
                                $rs[$k][$kg] = $t;
                                unset($temp);unset($t);
                            }else{
                                $rs[$k][$kg] = '';
                            }
                        }else {
                                $rs[$k][$kg] = "\t".$v[$vg]."\t";
                        }
                    }
                    $datas = $rs[$k];
                    $write = self::writeSvc($file, $datas);
                    unset($db[$k]);
                    unset($rs[$k]);
                }
                $el_item = $res['el_item']+$num1;
                DB::table("excel_list")->where('el_id',$res['el_id'])->update(['el_item'=>$el_item]);
                DB::table("excel_detail")->where("ed_id",$detail['ed_id'])->update(['ed_state'=>2]);
                return response()->json(['code' => 200, 'msg' => '操作成功1', 'data' => '']);
            }else{
                DB::table("excel_detail")->where("ed_id",$detail['ed_id'])->update(['ed_state'=>2]);
                return response()->json(['code' => 200, 'msg' => '操作成功2', 'data' => '']);
            }
        }else{
            DB::table("excel_list")->where('el_id',$res['el_id'])->update(['el_state'=>2]);
            return response()->json(['code' => 200, 'msg' => '操作成功3', 'data' => '']);
        }
    }




    /**
     * @name 采购管理
     * @param $res
     * @param $con 控制器
     * @return mixed
     * @author du
     * @date 2021/8/25
     */
    public function performPurchaseOrderindex($user_info,$res,$con='PurchaseOrderindex'){
        $detail = DB::table("excel_detail")->where("ed_elid",$res['el_id'])->where("ed_state",'1')->first();
        if($detail){
            $detail = CommonService::dataToArray($detail);
            $data = ExceloutService::getDatas($con, $res, $detail,$user_info);
            $db = $data['db'];
            $group = $data['group'];
            $file = $data['file'];
            if($db){
                $num1 = count($db);
                foreach( $db as $k => $v ){
                    $v = ExceloutService::replaceData($v);
                    foreach( $group as $kg => $vg ){
                        $num = array_search($vg,$group);
                        if ( $vg=='cg_state'){
                            if($v['cg_state'] == 1){
                                $rs[$k][$kg] = '审核中';
                            }else if($v['cg_state'] == 2){
                                $rs[$k][$kg] = '财审中';
                            }else if($v['cg_state'] == 3){
                                $rs[$k][$kg] = '待处理';
                            }else if($v['cg_state'] == 5){
                                $rs[$k][$kg] = '未入库';
                            }else if($v['cg_state'] == 6){
                                $rs[$k][$kg] = '未出库';
                            }else if($v['cg_state'] == 8){
                                $rs[$k][$kg] = '部分入库';
                            }else if($v['cg_state'] == 9){
                                $rs[$k][$kg] = '待结算';
                            }else if($v['cg_state'] == 10){
                                $rs[$k][$kg] = '待审核';
                            }else if($v['cg_state'] == 11){
                                $rs[$k][$kg] = '完成';
                            }else if($v['cg_state'] == 12){
                                $rs[$k][$kg] = '确认完成';
                            }else if($v['cg_state'] == 14){
                                $rs[$k][$kg] = '已封账';
                            }else if($v['cg_state'] == 17){
                                $rs[$k][$kg] = '终止';
                            }else{
                                $rs[$k][$kg] = '';
                            }
                        }else if ( $vg=='cg_paymentype'){
                            if($v['cg_paymentype'] == 1){
                                $rs[$k][$kg] = '现金';
                            }else if($v['cg_paymentype'] == 2){
                                $rs[$k][$kg] = '定期';
                            }else if($v['cg_paymentype'] == 3){
                                $rs[$k][$kg] = '款到发货';
                            }else if($v['cg_paymentype'] == 4){
                                $rs[$k][$kg] = '货到付款';
                            }else if($v['cg_paymentype'] == 5){
                                $rs[$k][$kg] = '月结15天';
                            }else if($v['cg_paymentype'] == 6){
                                $rs[$k][$kg] = '月结30天';
                            }else if($v['cg_paymentype'] == 7){
                                $rs[$k][$kg] = '月结60天';
                            }else if($v['cg_paymentype'] == 8){
                                $rs[$k][$kg] = '免费';
                            }else{
                                $rs[$k][$kg] = '';
                            }
                        }else if ( $vg=='business_type'){
                            if($v['business_type'] == 0){
                                $rs[$k][$kg] = '无';
                            }else if($v['business_type'] == 1){
                                $rs[$k][$kg] = '普通采购';
                            }else if($v['business_type'] == 2){
                                $rs[$k][$kg] = '样品采购';
                            }else if($v['business_type'] == 3){
                                $rs[$k][$kg] = '厂家返利';
                            }else{
                                $rs[$k][$kg] = '';
                            }
                        }/*else if ( $vg=='rk_state'){
                            if($v['rk_state'] == 1){
                                $rs[$k][$kg] = '待入库';
                            }else if($v['rk_state'] == 3){
                                $rs[$k][$kg] = '待审核';
                            }else if($v['rk_state'] == 4){
                                $rs[$k][$kg] = '驳回';
                            }else if($v['rk_state'] == 5){
                                $rs[$k][$kg] = '已完成';
                            }else if($v['rk_state'] == 8){
                                $rs[$k][$kg] = '作废';
                            }else{
                                $rs[$k][$kg] = '';
                            }
                        }*//*else if ( $vg=='rk_type'){
                            if($v['rk_type'] == 1){
                                $rs[$k][$kg] = '普通采购';
                            }else if($v['rk_type'] == 2){
                                $rs[$k][$kg] = '采购退货';
                            }else if($v['rk_type'] == 3){
                                $rs[$k][$kg] = '采购换货';
                            }else if($v['rk_type'] == 4){
                                $rs[$k][$kg] = '代发采购';
                            }else{
                                $rs[$k][$kg] = '';
                            }
                        }*//*else if ( $vg=='goods_name'){
                            $rs[$k][$kg] = $v['goods_name'];
                            if (!in_array($user_info->adm_shop_id, config('apisystem.NO_BRSND_SERIE_SHOP'))) {
                                $find_goo_data = DB::table('goods')
                                    ->where('goo_id', $v['goods_id'])
                                    ->select('goo_bra_name', 'goo_brse_id', 'goo_class', 'goo_id')
                                    ->first();
                                if (!empty($find_goo_data->goo_brse_id)) {
                                    // 显示系列名称
                                    if ($find_goo_data->goo_class == 2) {
                                        $brse_data = DB::table('brand_serie')
                                            ->where('brse_id', $find_goo_data->goo_brse_id)
                                            ->value('brse_name');
                                        $rs[$k][$kg] = $brse_data . ' ' . $v['goods_name'];
                                    } else {
                                        if (!in_array($user_info->adm_shop_id, config('apisystem.NO_SELF_GOODS_SHOP'))) {
                                            $brse_data = DB::table('brand_serie')
                                                ->where('brse_id', $find_goo_data->goo_brse_id)
                                                ->value('brse_name');
                                            $rs[$k][$kg] = $brse_data . ' ' . $v['goods_name'];
                                        }
                                    }
                                }
                            }
                        }*/else if ( $vg=='contract_number'){
                            $rs[$k][$kg] = "\t".$v['contract_number'];
                        }else if ( $vg=='cg_settlementype'){
                            if($v['cg_settlementype'] == 2){
                                $rs[$k][$kg] = '待结算';
                            }else if($v['cg_settlementype'] == 3){
                                $rs[$k][$kg] = '已结算';
                            }else if($v['cg_settlementype'] == 4){
                                $rs[$k][$kg] = '待审核';
                            }else if($v['cg_settlementype'] == 5){
                                $rs[$k][$kg] = '部分结算';
                            }else{
                                $rs[$k][$kg] = '';
                            }
                        }else if ( $vg=='cg_delivertype'){
                            if($v['cg_delivertype'] == 1){
                                $rs[$k][$kg] = '送货上门';
                            }else if($v['cg_delivertype'] == 2){
                                $rs[$k][$kg] = '自提';
                            }else{
                                $rs[$k][$kg] = '';
                            }
                        }else if ( $vg=='cg_invoicetype'){
                            if($v['cg_invoicetype'] == 1){
                                $rs[$k][$kg] = '普通发票';
                            }else if($v['cg_invoicetype'] == 2){
                                $rs[$k][$kg] = '专用发票';
                            }else{
                                $rs[$k][$kg] = '';
                            }
                        }else if ( $vg=='financial_user'){
                            $rs[$k][$kg] = '';
                            if($v['financial_user'] > 0){
                                $name = Db::table('admin')->where('adm_id', $v['financial_user'])->value('adm_name');
                                $rs[$k][$kg] = $name;
                            }
                        }else {
                            $rs[$k][$kg] = "\t".$v[$vg];
                        }
                    }
                    $datas = $rs[$k];
                    $write = self::writeSvc($file, $datas);
                    unset($db[$k]);
                    unset($rs[$k]);
                }
                $el_item = $res['el_item']+$num1;
                DB::table("excel_list")->where('el_id',$res['el_id'])->update(['el_item'=>$el_item]);
                DB::table("excel_detail")->where("ed_id",$detail['ed_id'])->update(['ed_state'=>2]);
                return response()->json(['code' => 200, 'msg' => '操作成功1', 'data' => '']);
            }else{
                DB::table("excel_detail")->where("ed_id",$detail['ed_id'])->update(['ed_state'=>2]);
                return response()->json(['code' => 200, 'msg' => '操作成功2', 'data' => '']);
            }
        }else{
            DB::table("excel_list")->where('el_id',$res['el_id'])->update(['el_state'=>2]);
            return response()->json(['code' => 200, 'msg' => '操作成功3', 'data' => '']);
        }
    }


    /**
     * @name 绩效管理
     * @param $res
     * @param $con 控制器
     * @return mixed
     * @author du
     * @date 2021/8/25
     */
    public function performOrderPerformance($user_info,$res,$con='OrderPerformance'){
        $detail = DB::table("excel_detail")->where("ed_elid",$res['el_id'])->where("ed_state",'1')->first();
        if($detail){
            $detail = CommonService::dataToArray($detail);
            $data = ExceloutService::getDatas($con, $res, $detail,$user_info);
            $db = $data['db'];
            $group = $data['group'];
            $file = $data['file'];
            if($db){
                $num1 = count($db);
                foreach( $db as $k => $v ){
                    $v = ExceloutService::replaceData($v);
                    foreach( $group as $kg => $vg ){
                        $num = array_search($vg,$group);
                        if ( $vg=='pewo_sepr_name'){
                            $sepr_data = DB::table('work_good as wogo')
                                ->leftJoin('service_project as sepr', 'sepr.sepr_id', '=', 'wogo.wogo_goo_id')
                                ->where('wogo_wor_id', $v['pewo_wor_id'])
                                ->where('wogo_goo_type', 2)
                                ->select('sepr_name', 'wogo_goo_amount', 'wogo_goo_unta_id', 'wogo_goo_unit')
                                ->get()->toArray();
                            $sepr_name = '';
                            if ($sepr_data) {
                                foreach ($sepr_data as $key1 => $value1) {
                                    if ($sepr_name) {
                                        $sepr_name = $sepr_name.','.$value1->sepr_name.'*'.$value1->wogo_goo_amount.$value1->wogo_goo_unit;
                                    } else {
                                        $sepr_name = $value1->sepr_name.'*'.$value1->wogo_goo_amount.$value1->wogo_goo_unit;
                                    }
                                }
                            }
                            $rs[$k][$kg] = $sepr_name;
                        }else if ( $vg=='pewo_goo_name'){
                            $goods_data = DB::table('goods as g')
                                ->leftJoin('work_good as wogo', 'wogo.wogo_goo_id', '=', 'g.goo_id')
                                ->where('wogo_wor_id', $v['pewo_wor_id'])
                                ->select('goo_name', 'wogo_new_goo_amount', 'wogo_goo_unta_id', 'wogo_goo_unit')
                                ->get()->toArray();
                            $goo_name = '';
                            if ($goods_data) {
                                foreach ($goods_data as $key1 => $value1) {
                                    if ($value1->wogo_goo_unta_id == 1) {
                                        $goo_unit = '米';
                                    } else {
                                        $goo_unit = $value1->wogo_goo_unit;
                                    }
                                    if ($goo_name) {
                                        $goo_name = $goo_name.','.$value1->goo_name.'*'.$value1->wogo_new_goo_amount.$goo_unit;
                                    } else {
                                        $goo_name = $value1->goo_name.'*'.$value1->wogo_new_goo_amount.$goo_unit;
                                    }
                                }
                            }
                            $rs[$k][$kg] = $goo_name;
                        }else if ( $vg=='pewo_performance_total_price'){
                            $new_data = DB::table('wash_performance_work')
                                ->where('pewo_wor_id', $v['pewo_wor_id'])
                                ->select('pewo_wor_id', 'pewo_performance_total_price')
                                ->get()->toArray();
                            $pewo_performance_total_price = 0;
                            if ($new_data) {
                                foreach ($new_data as $key2 => $value2) {
                                    $pewo_performance_total_price += $value2->pewo_performance_total_price;
                                }
                            }
                            $rs[$k][$kg] = $pewo_performance_total_price / 100;
                        }else if ( $vg=='pewo_service_adm_name'){
                            $wor_service_adm_id = DB::table('work_order')
                                ->where('wor_id', $v['pewo_wor_id'])
                                ->value('wor_service_adm_id');//组长id
                            $find_team_members = DB::table('wash_work_technician_part')
                                ->where('wotp_wor_id', $v['pewo_wor_id'])
                                ->select('wotp_service_adm_id', 'wotp_service_adm_name')
                                ->get()->toArray();
                            $team_members = '';
                            if ($find_team_members) {
                                foreach ($find_team_members as $key1 => $value1) {
                                    if ($team_members) {
                                        if ($wor_service_adm_id == $value1->wotp_service_adm_id) {
                                            $team_members = $team_members.','.$value1->wotp_service_adm_name.'(组长)';
                                        } else {
                                            $team_members = $team_members.','.$value1->wotp_service_adm_name;
                                        }
                                    } else {
                                        if ($wor_service_adm_id == $value1->wotp_service_adm_id) {
                                            $team_members = $value1->wotp_service_adm_name.'(组长)';
                                        } else {
                                            $team_members = $value1->wotp_service_adm_name;
                                        }
                                    }
                                }
                            }
                            $rs[$k][$kg] = $team_members;

                        }else if ( $vg=='goods_name'){
                            if (!in_array($user_info->adm_shop_id, config('apisystem.NO_BRSND_SERIE_SHOP'))) {
                                $find_goo_data = DB::table('goods')
                                    ->where('goo_id', $v['goods_id'])
                                    ->select('goo_bra_name', 'goo_brse_id', 'goo_class', 'goo_id')
                                    ->first();
                                if (!empty($find_goo_data->goo_brse_id)) {
                                    // 显示系列名称
                                    if ($find_goo_data->goo_class == 2) {
                                        $brse_data = DB::table('brand_serie')
                                            ->where('brse_id', $find_goo_data->goo_brse_id)
                                            ->value('brse_name');
                                        $rs[$k][$kg] = $brse_data . ' ' . $v['goods_name'];
                                    } else {
                                        if (!in_array($user_info->adm_shop_id, config('apisystem.NO_SELF_GOODS_SHOP'))) {
                                            $brse_data = DB::table('brand_serie')
                                                ->where('brse_id', $find_goo_data->goo_brse_id)
                                                ->value('brse_name');
                                            $rs[$k][$kg] = $brse_data . ' ' . $v['goods_name'];
                                        }
                                    }
                                }
                            }
                        }else if ( $vg=='ord_order_price'){
                            $rs[$k][$kg] = $v['ord_order_price'] / 100;
                        }else {
                                $rs[$k][$kg] = "\t".$v[$vg]."\t";
                        }
                    }
                    $datas = $rs[$k];
                    $write = self::writeSvc($file, $datas);
                    unset($db[$k]);
                    unset($rs[$k]);
                }
                $el_item = $res['el_item']+$num1;
                DB::table("excel_list")->where('el_id',$res['el_id'])->update(['el_item'=>$el_item]);
                DB::table("excel_detail")->where("ed_id",$detail['ed_id'])->update(['ed_state'=>2]);
                return response()->json(['code' => 200, 'msg' => '操作成功1', 'data' => '']);
            }else{
                DB::table("excel_detail")->where("ed_id",$detail['ed_id'])->update(['ed_state'=>2]);
                return response()->json(['code' => 200, 'msg' => '操作成功2', 'data' => '']);
            }
        }else{
            DB::table("excel_list")->where('el_id',$res['el_id'])->update(['el_state'=>2]);
            return response()->json(['code' => 200, 'msg' => '操作成功3', 'data' => '']);
        }
    }


    /**
     * @name 技师绩效管理
     * @param $res
     * @param $con 控制器
     * @return mixed
     * @author du
     * @date 2021/8/25
     */
    public function performTechnicianPerformance($user_info,$res,$con='TechnicianPerformance'){
        $detail = DB::table("excel_detail")->where("ed_elid",$res['el_id'])->where("ed_state",'1')->first();
        if($detail){
            $detail = CommonService::dataToArray($detail);
            $data = ExceloutService::getDatas($con, $res, $detail,$user_info);
            $db = $data['db'];
            $group = $data['group'];
            $file = $data['file'];
            if($db){
                $num1 = count($db);
                foreach( $db as $k => $v ){
                    $v = ExceloutService::replaceData($v);
                    foreach( $group as $kg => $vg ){
                        $num = array_search($vg,$group);
                        $find_adm = DB::table('admin as a')
                            ->leftJoin('wash_grade_level as b', 'b.grle_id', '=', 'a.adm_grle_id')
                            ->leftJoin('wash_grade_professional as c', 'b.grle_grpr_id', '=', 'c.grpr_id')
                            ->where('adm_id', $v['pewo_service_adm_id'])
                            ->select('adm_id', 'adm_name', 'adm_phone', 'grle_name', 'grpr_name')
                            ->first();
                        if ( $vg=='performance_total_price'){
                            $rs[$k][$kg] = $v['pewo_performance_total_price'] / 100;
                        }else if ( $vg=='grle_name'){

                            $rs[$k][$kg] = $find_adm->grpr_name.'-'.$find_adm->grle_name;
                        }else if ( $vg=='adm_phone'){

                            $rs[$k][$kg] = $find_adm->adm_phone;
                        }else if ( $vg=='work_quantity'){

                            $rs[$k][$kg] = 1;
                        }else {
                            $rs[$k][$kg] = "\t".$v[$vg]."\t";
                        }
                    }
                    $datas = $rs[$k];
                    $write = self::writeSvc($file, $datas);
                    unset($db[$k]);
                    unset($rs[$k]);
                }
                $el_item = $res['el_item']+$num1;
                DB::table("excel_list")->where('el_id',$res['el_id'])->update(['el_item'=>$el_item]);
                DB::table("excel_detail")->where("ed_id",$detail['ed_id'])->update(['ed_state'=>2]);
                return response()->json(['code' => 200, 'msg' => '操作成功1', 'data' => '']);
            }else{
                DB::table("excel_detail")->where("ed_id",$detail['ed_id'])->update(['ed_state'=>2]);
                return response()->json(['code' => 200, 'msg' => '操作成功2', 'data' => '']);
            }
        }else{
            DB::table("excel_list")->where('el_id',$res['el_id'])->update(['el_state'=>2]);
            return response()->json(['code' => 200, 'msg' => '操作成功3', 'data' => '']);
        }
    }


    /**
     * @name 详情绩效管理
     * @param $res
     * @param $con 控制器
     * @return mixed
     * @author du
     * @date 2021/8/25
     */
    public function performDetailPerformance($user_info,$res,$con='DetailPerformance'){
        $detail = DB::table("excel_detail")->where("ed_elid",$res['el_id'])->where("ed_state",'1')->first();
        if($detail){
            $detail = CommonService::dataToArray($detail);
            $data = ExceloutService::getDatas($con, $res, $detail,$user_info);
            $db = $data['db'];
            $group = $data['group'];
            $file = $data['file'];
            if($db){
                $num1 = count($db);
                foreach( $db as $k => $v ){
                    $v = ExceloutService::replaceData($v);
                    foreach( $group as $kg => $vg ){
                        $num = array_search($vg,$group);
                        if ( $vg=='service_adm_name'){
                            $name = Db::table('admin')->where('adm_id', $v['wor_service_adm_id'])->value('adm_name');

                            $rs[$k][$kg] = $name;
                        }else if ( $vg=='team_service_adm_name'){
//                            $adm_names = Db::table('wash_performance_work as pewo')
//                                ->leftJoin('admin as a', 'a.adm_id', '=', 'pewo.pewo_service_adm_id')
//                                ->where('pewo_service_adm_id','!=', $v['wor_service_adm_id'])
//                                ->where('pewo_wor_id', $v['pewo_wor_id'])
//                                ->select('adm_name')
//                                ->get()->toArray();
//                            if ($adm_names) {
//                                $team_adm_names = '';
//                                foreach ($adm_names as $key1 => $value1) {
//                                    if ($team_adm_names) {
//                                        $team_adm_names = $team_adm_names.','.$value1->adm_name;
//                                    } else {
//                                        $team_adm_names = $value1->adm_name;
//                                    }
//                                }
//                            } else {
//                                $team_adm_names = '无';
//                            }
//                            $rs[$k][$kg] = $team_adm_names;
                            $rs[$k][$kg] = $v['pewo_service_adm_name'];
                        }else if ( $vg=='pewo_sepr_name'){
                            $sepr_data = DB::table('work_good as wogo')
                                ->leftJoin('service_project as sepr', 'sepr.sepr_id', '=', 'wogo.wogo_goo_id')
                                ->where('wogo_wor_id', $v['pewo_wor_id'])
                                ->where('wogo_goo_type', 2)
                                ->select('sepr_name')
                                ->get()->toArray();
                            $sepr_name = '';
                            if ($sepr_data) {
                                foreach ($sepr_data as $key1 => $value1) {
                                    if ($sepr_name) {
                                        $sepr_name = $sepr_name.','.$value1->sepr_name;
                                    } else {
                                        $sepr_name = $value1->sepr_name;
                                    }
                                }
                            }
                            $rs[$k][$kg] = $sepr_name;
                        }else if ( $vg=='pewo_goo_name'){
                            $goods_data = DB::table('goods as g')
                                ->leftJoin('work_good as wogo', 'wogo.wogo_goo_id', '=', 'g.goo_id')
                                ->where('wogo_wor_id', $v['pewo_wor_id'])
                                ->select('goo_name', 'wogo_new_goo_amount', 'wogo_goo_unta_id', 'wogo_goo_unit', 'wogo_recycle_quantity')
                                ->get()->toArray();
                            $goo_name = '';
                            if ($goods_data) {
                                foreach ($goods_data as $key1 => $value1) {
                                    if ($value1->wogo_goo_unta_id == 1) {
                                        $goo_unit = '米';
                                    } else {
                                        $goo_unit = $value1->wogo_goo_unit;
                                    }
                                    if ($goo_name) {
                                        if ($value1->wogo_recycle_quantity > 0) {
                                            $goo_name = $goo_name.','.$value1->goo_name.' 数量：'.$value1->wogo_new_goo_amount.$goo_unit.',余料：'.$value1->wogo_recycle_quantity.$goo_unit;
                                        } else {
                                            $goo_name = $goo_name.','.$value1->goo_name.' 数量：'.$value1->wogo_new_goo_amount.$goo_unit;
                                        }
                                    } else {
                                        if ($value1->wogo_recycle_quantity > 0) {
                                            $goo_name = $value1->goo_name.' 数量：'.$value1->wogo_new_goo_amount.$goo_unit.',余料：'.$value1->wogo_recycle_quantity.$goo_unit;
                                        } else {
                                            $goo_name = $value1->goo_name.' 数量：'.$value1->wogo_new_goo_amount.$goo_unit;
                                        }
                                    }
                                    // if ($goo_name) {
                                    //     $goo_name = $goo_name.','.$value1->goo_name.'*'.$value1->wogo_new_goo_amount.$goo_unit;
                                    // } else {
                                    //     $goo_name = $value1->goo_name.'*'.$value1->wogo_new_goo_amount.$goo_unit;
                                    // }
                                }
                            }
                            $rs[$k][$kg] = $goo_name;
                        }else if ( $vg=='pewo_performance_total_price'){
                            $rs[$k][$kg] = $v['pewo_performance_total_price'] / 100;
                        } elseif ($vg=='consuming') {
                            $startTime = strtotime($v['wor_create_time']);
                            $endTime = strtotime($v['wor_achieve_time']);

                            // 计算时间差（秒数）
                            $timeDifference = $endTime - $startTime;

                            // 将秒数转换为小时、分钟和秒
                            $hours = floor($timeDifference / 3600);
                            $minutes = floor(($timeDifference % 3600) / 60);
                            $seconds = $timeDifference % 60;
                            if ($hours > 0) {
                                $rs[$k][$kg] = $hours.'小时';
                            } else {
                                $rs[$k][$kg] = '';
                            }
                            $rs[$k][$kg] =$rs[$k][$kg].$minutes.'分钟'.$seconds.'秒';
                        } elseif ($vg == 'afsi_goo_name') {
                            $find_wash_after_sale_items = DB::table('wash_after_sale_items')
                                ->leftJoin('wash_after_sale_list', 'afsl_id', '=', 'afsi_afsl_id')
                                ->where('afsl_ord_id', $v['wor_order_id'])
                                ->where('afsi_goo_id', '!=', '')
                                ->get()->toArray();
                            $afsi_goo_name = '';
                            if ($find_wash_after_sale_items) {
                                foreach ($find_wash_after_sale_items as $key_af => $value_af) {
                                    $afsi_goo_unit = $value_af->afsi_goo_unit;
                                    if ($afsi_goo_name) {
                                        $afsi_goo_name = $afsi_goo_name.','.$value_af->afsi_goo_name.'*'.$value_af->afsi_goo_quantity.$afsi_goo_unit;
                                    } else {
                                        $afsi_goo_name = $value_af->afsi_goo_name.'*'.$value_af->afsi_goo_quantity.$afsi_goo_unit;
                                    }
                                }
                            }
                            $rs[$k][$kg] = $afsi_goo_name;
                        } elseif ($vg == 'vaca_create_time') {
                            $wash_validate_car = DB::table('wash_validate_car')
                                ->where('vaca_ord_id', $v['wor_order_id'])
                                ->select('vaca_create_time')
                                ->orderBy('vaca_create_time', 'desc')
                                ->first();
                            if ($wash_validate_car) {
                                $rs[$k][$kg] = $wash_validate_car->vaca_create_time;
                            } else {
                                $rs[$k][$kg] = '';
                            }
                        }  elseif ($vg == 'wor_address_name') {
                            // 施工地址
                            if ($v['wor_address_type'] == 1) {//门店
                                $find_address = DB::table('shop')
                                    ->where('shop_id', $v['wor_address_id'])
                                    ->select('shop_id', 'shop_store_name', 'shop_province', 'shop_city', 'shop_address', 'shop_county')
                                    ->first();
                                if ($find_address) {
                                    $shop_store_name = $find_address->shop_store_name;
                                    $shop_wor_address = $find_address->shop_province.$find_address->shop_city.$find_address->shop_county.$find_address->shop_address;
                                } else {
                                    $shop_store_name = '';
                                    $shop_wor_address = '';
                                }
                            } elseif ($v['wor_address_type'] == 2) {//合作商
                                $find_address = DB::table('business_client')
                                    ->where('bucl_id', $v['wor_address_id'])
                                    ->select('bucl_id', 'bucl_name', 'bucl_province', 'bucl_city', 'bucl_address', 'bucl_county')
                                    ->first();
                                if ($find_address) {
                                    $shop_store_name = $find_address->bucl_name;
                                    $shop_wor_address = $find_address->bucl_province.$find_address->bucl_city.$find_address->bucl_county.$find_address->bucl_address;
                                } else {
                                    $shop_store_name = '';
                                    $shop_wor_address = '';
                                }
                            } else {
                                $find_address = DB::table('shop')
                                    ->where('shop_id', $v['wor_shop_id'])
                                    ->select('shop_id', 'shop_store_name', 'shop_province', 'shop_city', 'shop_address', 'shop_county')
                                    ->first();
                                if ($find_address) {
                                    $shop_store_name = $find_address->shop_store_name;
                                    $shop_wor_address = $find_address->shop_province.$find_address->shop_city.$find_address->shop_county.$find_address->shop_address;
                                } else {
                                    $shop_store_name = '';
                                    $shop_wor_address = '';
                                }
                            }
                            $rs[$k][$kg] = $shop_store_name;
                        } else {
                            $rs[$k][$kg] = "\t".$v[$vg]."\t";
                        }
                    }
                    $datas = $rs[$k];
                    $write = self::writeSvc($file, $datas);
                    unset($db[$k]);
                    unset($rs[$k]);
                }
                $el_item = $res['el_item']+$num1;
                DB::table("excel_list")->where('el_id',$res['el_id'])->update(['el_item'=>$el_item]);
                DB::table("excel_detail")->where("ed_id",$detail['ed_id'])->update(['ed_state'=>2]);
                return response()->json(['code' => 200, 'msg' => '操作成功1', 'data' => '']);
            }else{
                DB::table("excel_detail")->where("ed_id",$detail['ed_id'])->update(['ed_state'=>2]);
                return response()->json(['code' => 200, 'msg' => '操作成功2', 'data' => '']);
            }
        }else{
            DB::table("excel_list")->where('el_id',$res['el_id'])->update(['el_state'=>2]);
            return response()->json(['code' => 200, 'msg' => '操作成功3', 'data' => '']);
        }
    }
    /**
     * @name 会员管理
     * @param $res
     * @param $con 控制器
     * @return mixed
     * @author du
     * @date 2021/8/25
     */
    public function performMemberListindex($user_info,$res,$con='MemberListindex'){
        $detail = DB::table("excel_detail")->where("ed_elid",$res['el_id'])->where("ed_state",'1')->first();
        if($detail){
            $detail = CommonService::dataToArray($detail);
            $data = ExceloutService::getDatas($con, $res, $detail,$user_info);
            $db = $data['db'];
            $group = $data['group'];
            $file = $data['file'];
            if($db){
                $num1 = count($db);
                foreach( $db as $k => $v ){
                    $v = ExceloutService::replaceData($v);
                    foreach( $group as $kg => $vg ){
                        $num = array_search($vg,$group);
                        if ( $vg=='mem_sex'){
                            if ($v['mem_sex'] == 1) {
                                $rs[$k][$kg] = '男';
                            }else if($v['mem_sex'] == 2){
                                $rs[$k][$kg] = '女';
                            }else{
                                $rs[$k][$kg] = '未知';
                            }
                        }else if ( $vg=='mem_address'){
                            $rs[$k][$kg] = $v['mem_province'].$v['mem_city'].$v['mem_county'].$v['mem_address'];

                        }else if ( $vg=='mem_bership'){
                            if ($v['mem_bership'] == 1) {
                                $rs[$k][$kg] = '正式';
                            }else{
                                $rs[$k][$kg] = '临时';
                            }
                        }else if ( $vg=='mem_level'){
                            if ($v['mem_level'] == 0) {
                                $rs[$k][$kg] = '普通会员';
                            }else if ($v['mem_level'] == 1) {
                                $rs[$k][$kg] = '白银会员';
                            }else if($v['mem_level'] == 2){
                                $rs[$k][$kg] = '黄金会员';
                            }else if($v['mem_level'] == 3){
                                $rs[$k][$kg] = '铂金会员';
                            }else if($v['mem_level'] == 4){
                                $rs[$k][$kg] = '钻石会员';
                            }else if($v['mem_level'] == 5){
                                $rs[$k][$kg] = '黑钻会员';
                            }else{
                                $rs[$k][$kg] = '';
                            }
                        }else if ( $vg=='mem_arrears'){
                            $rs[$k][$kg] = intval($v['mem_arrears']) / 100;
                        }else if ( $vg=='mem_create_id'){
                            $name = DB::table('admin')
                                ->where('adm_id', $v['mem_create_id'])
                                ->value('adm_name');
                            $rs[$k][$kg] = $name;
                        }else if ( $vg=='mem_fid'){
                            $phone = DB::table('member')
                                ->where('mem_id', $v['mem_fid'])
                                ->value('mem_phone');

                            $rs[$k][$kg] = $phone;
                        }else {
                                $rs[$k][$kg] = "\t".$v[$vg]."\t";
                        }
                    }
                    $datas = $rs[$k];
                    $write = self::writeSvc($file, $datas);
                    unset($db[$k]);
                    unset($rs[$k]);
                }
                $el_item = $res['el_item']+$num1;
                DB::table("excel_list")->where('el_id',$res['el_id'])->update(['el_item'=>$el_item]);
                DB::table("excel_detail")->where("ed_id",$detail['ed_id'])->update(['ed_state'=>2]);
                return response()->json(['code' => 200, 'msg' => '操作成功1', 'data' => '']);
            }else{
                DB::table("excel_detail")->where("ed_id",$detail['ed_id'])->update(['ed_state'=>2]);
                return response()->json(['code' => 200, 'msg' => '操作成功2', 'data' => '']);
            }
        }else{
            DB::table("excel_list")->where('el_id',$res['el_id'])->update(['el_state'=>2]);
            return response()->json(['code' => 200, 'msg' => '操作成功3', 'data' => '']);
        }
    }

    /**
     * @name 绩效管理
     * @param $res
     * @param $con 控制器
     * @return mixed
     * @author du
     * @date 2021/8/25
     */
    public function performProPerformanceordersp($user_info,$res,$con='ProPerformanceordersp'){
        $detail = DB::table("excel_detail")->where("ed_elid",$res['el_id'])->where("ed_state",'1')->first();

        if($detail){
            $detail = CommonService::dataToArray($detail);
            $data = ExceloutService::getDatas($con, $res, $detail,$user_info);
            $db = $data['db'];
            $group = $data['group'];
            $file = $data['file'];
            if($db){
                $num1 = count($db);
                $typeName = WashOrderService::getPaymentWayName(true);//获取支付方式名称
                $object_enum = new OrderEnum();
                foreach( $db as $k => $v ){
                    $v = ExceloutService::replaceData($v);
                    foreach( $group as $kg => $vg ){
                        $num = array_search($vg,$group);
                        if ( $vg=='new_order_goods'){
                            $order_goods = DB::table('order_goods')
                                ->where('orgo_ord_id', $v['ord_id'])
                                ->select('orgo_goo_name', 'orgo_goo_price', 'orgo_sale_performance', 'orgo_goo_quantity','orgo_goo_return_quantity', 'orgo_goo_unit', 'orgo_goo_type')
                                ->get()->toArray();
                            $new_order_goods = '';
                            foreach ($order_goods as $kk => $vv) {
                                if ($vv->orgo_goo_type == 2) {//1商品2服务
                                    $vv->orgo_goo_unit = '次';
                                }
                                if (empty($new_order_goods)) {
                                    $new_order_goods = $vv->orgo_goo_name.'('.$vv->orgo_goo_unit.'):'. ($vv->orgo_sale_performance*($vv->orgo_goo_quantity-$vv->orgo_goo_return_quantity)/100).'元';
                                } else {
                                    $new_order_goods = $new_order_goods .','. $vv->orgo_goo_name.'('.$vv->orgo_goo_unit.'):'. ($vv->orgo_sale_performance*($vv->orgo_goo_quantity-$vv->orgo_goo_return_quantity)/100).'元';
                                }
                            }
                            $rs[$k][$kg] = $new_order_goods;
                        }else if ( $vg=='performance'){
                            if ($v['ord_saleman_performance']) {
                                if ($v['ord_saleman_type'] == 1) {
                                    $performance = $v['ord_order_price'] * $v['ord_saleman_performance'] /100;
                                } else {
                                    $ord_actual_price = DB::table('order_settlement_details')
                                        ->where('orsd_ord_id', $v['ord_id'])
                                        ->sum('orsd_pay_money');
                                    $performance = $ord_actual_price * $v['ord_saleman_performance'] /100;
                                }
                            } else {
                                $performance = 0;
                                $order_goods = DB::table('order_goods')
                                    ->where('orgo_ord_id', $v['ord_id'])
                                    ->select('orgo_goo_name', 'orgo_goo_price', 'orgo_sale_performance', 'orgo_goo_quantity', 'orgo_goo_return_quantity')
                                    ->get()->toArray();
                                foreach ($order_goods as $kgg => $vgg) {
                                    $performance += ($vgg->orgo_sale_performance*($vgg->orgo_goo_quantity-$vgg->orgo_goo_return_quantity));
                                }
                            }
                            $rs[$k][$kg] = $performance/100;
                        }else if ( $vg=='ord_pay_state_name'){
                            if ($v['ord_state'] == 1) {//结算状态1未结算2已结算3部分结算
                                $ord_pay_state_name = '未结算';
                            } elseif ($v['ord_state'] == 2) {
                                $ord_pay_state_name = '已结算';
                            } elseif ($v['ord_state'] == 3) {
                                $ord_pay_state_name = '部分结算';
                            } else {
                                $ord_pay_state_name = '未结算';
                            }
                            $rs[$k][$kg] = $ord_pay_state_name;
                        }else if ( $vg=='ord_wor_state_name'){
                            if ($v['ord_wor_state'] == 7) {//结算状态1未结算2已结算3部分结算
                                $ord_wor_state_name = '待接单';
                            } elseif ($v['ord_wor_state'] == 1) {
                                $ord_wor_state_name = '待派单';
                            } elseif ($v['ord_wor_state'] == 2) {
                                $ord_wor_state_name = '服务中';
                            } elseif ($v['ord_wor_state'] == 4) {
                                $ord_wor_state_name = '待评价';
                            } elseif ($v['ord_wor_state'] == 11) {
                                $ord_wor_state_name = '已取消';
                            } elseif ($v['ord_wor_state'] == 20) {
                                $ord_wor_state_name = '已完成';
                            } else {
                                $ord_wor_state_name = '服务中';
                            }
                            $rs[$k][$kg] = $ord_wor_state_name;
                        }else if ( $vg=='ord_source_name'){
                            $ord_source_enum = $object_enum->keyValueEnum($object_enum->ord_source_enum);
                            $rs[$k][$kg] = $ord_source_enum[$v['ord_source']];
                        }else if ( $vg=='ord_payment_name'){
                            $rs[$k][$kg] = WashOrderService::getTypeData($v['ord_payment_way'], $typeName);
                        }else if ( $vg=='ord_order_price'){
                            $ord_order_price = $v['ord_order_price']/100;
                            $rs[$k][$kg] = $ord_order_price;
                        }else if ( $vg=='ord_saleman_type'){
                            if ($v['ord_saleman_type'] == 1) {
                                $rs[$k][$kg] = '按订单金额';
                            } elseif ($v['ord_saleman_type'] == 2) {
                                $rs[$k][$kg] = '按结算金额';
                            } else {
                                $rs[$k][$kg] = '按商品/服务计算';
                            }
                        }else if ( $vg=='orcl_sales_adm_name'){
                            if (empty($v['orcl_sales_adm_name']) && $v['orcl_sales_adm_id']) {
                                $orcl_sales_adm_name = DB::table('admin')
                                    ->where('adm_id', $v['orcl_sales_adm_id'])
                                    ->value('adm_name');
                            } else {
                                $orcl_sales_adm_name = $v['orcl_sales_adm_name'];
                            }
                            $rs[$k][$kg] = $orcl_sales_adm_name;
                        }else {
                                $rs[$k][$kg] = "\t".$v[$vg]."\t";
                        }
                    }
                    $datas = $rs[$k];
                    $write = self::writeSvc($file, $datas);
                    unset($db[$k]);
                    unset($rs[$k]);
                }
                $el_item = $res['el_item']+$num1;
                DB::table("excel_list")->where('el_id',$res['el_id'])->update(['el_item'=>$el_item]);
                DB::table("excel_detail")->where("ed_id",$detail['ed_id'])->update(['ed_state'=>2]);
                return response()->json(['code' => 200, 'msg' => '操作成功1', 'data' => '']);
            }else{
                DB::table("excel_detail")->where("ed_id",$detail['ed_id'])->update(['ed_state'=>2]);
                return response()->json(['code' => 200, 'msg' => '操作成功2', 'data' => '']);
            }
        }else{
            DB::table("excel_list")->where('el_id',$res['el_id'])->update(['el_state'=>2]);
            return response()->json(['code' => 200, 'msg' => '操作成功3', 'data' => '']);
        }
    }
    //工单列表
    public function performWashWork($user_info,$res,$con='WashWork'){
        $detail = DB::table("excel_detail")->where("ed_elid",$res['el_id'])->where("ed_state",'1')->first();
        if($detail){
            $detail = CommonService::dataToArray($detail);
            $data = ExceloutService::getDatas($con, $res, $detail,$user_info);
            $db = $data['db'];
            $group = $data['group'];
            $file = $data['file'];
            $wor_id = array_column($db, 'wor_id'); //工单id
            // 获取该工单下的商品信息
            $goods_data = DB::table('work_good as wg')
                ->leftjoin('goods as g', 'g.goo_id', '=', 'wg.wogo_goo_id')
                ->whereIn('wogo_wor_id', $wor_id)
                ->select('wogo_id', 'wogo_wor_id', 'wogo_goo_id', 'wogo_goo_name', 'wogo_goo_goods_encode', 'wogo_goo_amount', 'wogo_goo_guarantee', 'wogo_goo_type', 'wogo_state', 'wogo_goo_unit', 'wogo_goo_unta_id', 'goo_unit_conversion')
                ->get()->toArray();
            $goods_data = CommonService::dataToArray($goods_data);
            $goods_data = CommonService::jointArrayKey($goods_data, 'wogo_wor_id',2);
            if($db){
                $num1 = count($db);
                foreach( $db as $k => $v ){
                    $v = ExceloutService::replaceData($v);
                    foreach( $group as $kg => $vg ){
                        $num = array_search($vg,$group);
                        if ( $vg=='shop_store_name'){
                            // 施工地址
                            if ($v['wor_address_type'] == 1) {//门店
                                $find_address = DB::table('shop')
                                    ->where('shop_id', $v['wor_address_id'])
                                    ->select('shop_id', 'shop_store_name', 'shop_province', 'shop_city', 'shop_address', 'shop_county')
                                    ->first();
                                if ($find_address) {
                                    $rs[$k][$kg] = $find_address->shop_store_name;
                                } else {
                                    $rs[$k][$kg] = '';
                                }
                            } elseif ($v['wor_address_type'] == 2) {//合作商
                                $find_address = DB::table('business_client')
                                    ->where('bucl_id', $v['wor_address_id'])
                                    ->select('bucl_id', 'bucl_name', 'bucl_province', 'bucl_city', 'bucl_address', 'bucl_county')
                                    ->first();
                                if ($find_address) {
                                    $rs[$k][$kg] = $find_address->bucl_name;
                                } else {
                                    $rs[$k][$kg] = '';
                                }
                            } else {
                                $find_address = DB::table('shop')
                                    ->where('shop_id', $v['wor_shop_id'])
                                    ->select('shop_id', 'shop_store_name', 'shop_province', 'shop_city', 'shop_address', 'shop_county')
                                    ->first();
                                if ($find_address) {
                                    $rs[$k][$kg] = $find_address->shop_store_name;
                                } else {
                                    $rs[$k][$kg] = '';
                                }
                            }
                        }else if ( $vg=='ord_new_type_name'){
                            $rs[$k][$kg] = DB::table('order_type')
                                ->where('orty_id', $v['ord_new_type'])
                                ->value('orty_name');

                        }else if ( $vg=='service_adm_name'){

                            $service_adm_name = DB::table('admin')
                                ->where('adm_id', $v['wor_service_adm_id'])
                                ->value('adm_name');
                            $find_team_members = DB::table('wash_work_technician_part')
                                ->where('wotp_wor_id', $v['wor_id'])
                                ->where('wotp_service_adm_id', '!=', $v['wor_service_adm_id'])
                                ->select('wotp_service_adm_id', 'wotp_service_adm_name')
                                ->get()->toArray();

                            $team_members = '';
                            if ($find_team_members) {
                                foreach ($find_team_members as $key1 => $value1) {
                                    if ($team_members) {
                                        $team_members = $team_members.','.$value1->wotp_service_adm_name;
                                    } else {
                                        $team_members = $value1->wotp_service_adm_name;
                                    }
                                }
                            }
                            $rs[$k][$kg] = '';
                            if ($service_adm_name) {
                                $rs[$k][$kg] = $service_adm_name.'(组长)'; 
                                if ($team_members) {
                                    $rs[$k][$kg] = $rs[$k][$kg].','.$team_members;
                                }
                            } else {
                                if ($team_members) {
                                    $rs[$k][$kg] = $team_members;
                                } else {
                                    $rs[$k][$kg] = '';
                                }
                            }
                        }else if ( $vg=='woek_good'){
                            $goods_datas = $goods_data[$v['wor_id']]??'';
                            if($goods_datas){
                                $wogo_goo_id = [];
                                foreach ($goods_datas as $key => $value) {
                                    // 商品信息
                                    if (!empty($value['wogo_goo_id'])) {
                                        $wogo_goo_id[] = $value['wogo_goo_name']."*".$value['wogo_goo_amount'].$value['wogo_goo_unit'];
                                    }
                                }
                                $rs[$k][$kg] = implode(';', $wogo_goo_id);
                            }else{
                                $rs[$k][$kg] = '';
                            }
                        }else if ( $vg=='mem_arrears'){
                            $rs[$k][$kg] = intval($v['mem_arrears']) / 100;
                        }else if ( $vg=='mem_create_id'){
                            $name = DB::table('admin')
                                ->where('adm_id', $v['mem_create_id'])
                                ->value('adm_name');
                            $rs[$k][$kg] = $name;
                        }else if ( $vg=='mem_fid'){
                            $phone = DB::table('member')
                                ->where('mem_id', $v['mem_fid'])
                                ->value('mem_phone');

                            $rs[$k][$kg] = $phone;
                        }else {
                            $rs[$k][$kg] = "\t".$v[$vg]."\t";
                        }
                    }
                    $datas = $rs[$k];
                    $write = self::writeSvc($file, $datas);
                    unset($db[$k]);
                    unset($rs[$k]);
                }
                $el_item = $res['el_item']+$num1;
                DB::table("excel_list")->where('el_id',$res['el_id'])->update(['el_item'=>$el_item]);
                DB::table("excel_detail")->where("ed_id",$detail['ed_id'])->update(['ed_state'=>2]);
                return response()->json(['code' => 200, 'msg' => '操作成功1', 'data' => '']);
            }else{
                DB::table("excel_detail")->where("ed_id",$detail['ed_id'])->update(['ed_state'=>2]);
                return response()->json(['code' => 200, 'msg' => '操作成功2', 'data' => '']);
            }
        }else{
            DB::table("excel_list")->where('el_id',$res['el_id'])->update(['el_state'=>2]);
            return response()->json(['code' => 200, 'msg' => '操作成功3', 'data' => '']);
        }
    }

    //售后列表
    public function performWashAfterSales($user_info,$res,$con='WashAfterSales'){
        $detail = DB::table("excel_detail")->where("ed_elid",$res['el_id'])->where("ed_state",'1')->first();
        if($detail){
            $detail = CommonService::dataToArray($detail);
            $data = ExceloutService::getDatas($con, $res, $detail,$user_info);
            $db = $data['db'];
            $group = $data['group'];
            $file = $data['file'];
            if($db){
                $num1 = count($db);
                foreach( $db as $k => $v ){
                    $v = ExceloutService::replaceData($v);
                    foreach( $group as $kg => $vg ){
                        $num = array_search($vg,$group);
                        if ( $vg=='wash_after_sale_items'){//订单项目
                            $order_goods = DB::table('wash_after_sale_items as w')
                                ->leftJoin('goods as g', 'g.goo_id', '=', 'w.afsi_goo_id')
                                ->where('afsi_afsl_id', $v['afsl_id'])
                                ->where('afsi_type', 1)
                                ->select('afsi_id', 'afsi_afsl_id', 'afsi_sepr_id', 'afsi_goo_name', 'afsi_goo_goods_encode', 'afsi_sepr_id', 'afsi_sepr_name', 'afsi_goo_warranty_time', 'afsi_part_state', 'afsi_goo_quantity', 'afsi_goo_price', 'afsi_service_price', 'afsi_goo_unit', 'afsi_goo_unta_id', 'goo_unit_conversion')
                                ->get()->toArray();
                            $order_goods = CommonService::dataToArray($order_goods);
                            $order_goods_name = '';
                            if ($order_goods) {
                                foreach($order_goods as $nk => $nv) {
                                    if (empty($order_goods_name)) {
                                        $order_goods_name = $nv['afsi_goo_name'].'('.$nv['afsi_goo_unit'].')*'.$nv['afsi_goo_quantity'];
                                    } else {
                                        $order_goods_name .= ','.$nv['afsi_goo_name'].'('.$nv['afsi_goo_unit'].')*'.$nv['afsi_goo_quantity'];
                                    }
                                }
                            }
                            $rs[$k][$kg] = $order_goods_name;
                        }else if ( $vg=='afsl_goods'){//耗材
                            $afsl_goods = DB::table('wash_after_sale_items as w')
                                ->leftJoin('goods as g', 'g.goo_id', '=', 'w.afsi_goo_id')
                                ->where('afsi_afsl_id', $v['afsl_id'])
                                ->where('afsi_type', 2)
                                ->select('afsi_id', 'afsi_afsl_id', 'afsi_sepr_id', 'afsi_goo_name', 'afsi_goo_goods_encode', 'afsi_sepr_id', 'afsi_sepr_name', 'afsi_goo_warranty_time', 'afsi_part_state', 'afsi_goo_quantity', 'afsi_goo_price', 'afsi_service_price', 'afsi_goo_unit', 'afsi_goo_unta_id', 'goo_unit_conversion')
                                ->get()->toArray();
                            $afsl_goods = CommonService::dataToArray($afsl_goods);
                            $afsl_goods_name = '';
                            if ($afsl_goods) {
                                foreach($afsl_goods as $nk => $nv) {
                                    if (empty($afsl_goods_name)) {
                                        $afsl_goods_name = $nv['afsi_goo_name'].'('.$nv['afsi_goo_unit'].')*'.$nv['afsi_goo_quantity'];
                                    } else {
                                        $afsl_goods_name .= ','.$nv['afsi_goo_name'].'('.$nv['afsi_goo_unit'].')*'.$nv['afsi_goo_quantity'];
                                    }
                                }
                            }
                            $rs[$k][$kg] = $afsl_goods_name;

                        } elseif($vg=='afsl_actual_price') {
                            $rs[$k][$kg] = $v['afsl_actual_price']/100;
                        } elseif($vg=='create_name') {
                            $rs[$k][$kg] = DB::table('admin')->where('adm_id', $v['afsl_create_id'])->value('adm_name');
                        } elseif($vg=='state_name') {
                            $state_data = [1=>'未处理',2=>'处理中',3=>'审核中', 4=>'已完成', 5=>'已撤销'];
                            $rs[$k][$kg] = isset($state_data[$v['afsl_state']]) ? $state_data[$v['afsl_state']] : '';
                        } elseif($vg=='afsl_parts') {
                            $afsl_parts = json_decode($v['afsl_parts'], true);
                            $parts_name = '';
                            if (!empty($afsl_parts)) {
                                foreach($afsl_parts as $kk1=> $vv1) {
                                    if (empty($parts_name)) {
                                        $parts_name = $vv1['name'];
                                    } else {
                                        $parts_name.=','.$vv1['name'];
                                    }
                                }
                            }
                            $rs[$k][$kg] = $parts_name;
                        }  elseif($vg=='return_adm_data') {
                            $return_adm_data = '';
                            $after_work_log = DB::table('after_work_log')
                                ->leftJoin('admin', 'adm_id', '=', 'awlo_adm_id')
                                ->where('awlo_afsl_id', $v['afsl_id'])
                                ->where('awlo_adm_del', 2)
                                ->orderBy('awlo_create_time', 'desc')
                                ->get()->toArray();
                            $work_adm_data = [];
                            foreach ($after_work_log as $key => $value) {
                                if (!in_array($value->awlo_adm_id, $work_adm_data) && $value->awlo_adm_type == 2 && $value->awlo_adm_del == 2) {//awlo_adm_type:1后台人员2指派技师
                                    $work_adm_data[] = $value->awlo_adm_id;
                                    if (empty($return_adm_data)) {
                                        $return_adm_data = $value->adm_name;
                                    } else {
                                        $return_adm_data .= ','.$value->adm_name;
                                    }
                                }
                            }
                            $rs[$k][$kg] = $return_adm_data;
                        }  else {
                            $rs[$k][$kg] = "\t".$v[$vg]."\t";
                        }
                    }
                    $datas = $rs[$k];
                    $write = self::writeSvc($file, $datas);
                    unset($db[$k]);
                    unset($rs[$k]);
                }
                $el_item = $res['el_item']+$num1;
                DB::table("excel_list")->where('el_id',$res['el_id'])->update(['el_item'=>$el_item]);
                DB::table("excel_detail")->where("ed_id",$detail['ed_id'])->update(['ed_state'=>2]);
                return response()->json(['code' => 200, 'msg' => '操作成功1', 'data' => '']);
            }else{
                DB::table("excel_detail")->where("ed_id",$detail['ed_id'])->update(['ed_state'=>2]);
                return response()->json(['code' => 200, 'msg' => '操作成功2', 'data' => '']);
            }
        }else{
            DB::table("excel_list")->where('el_id',$res['el_id'])->update(['el_state'=>2]);
            return response()->json(['code' => 200, 'msg' => '操作成功3', 'data' => '']);
        }
    }

    //罚单列表
    public function performWashViolation($user_info,$res,$con='WashViolation'){
        $detail = DB::table("excel_detail")->where("ed_elid",$res['el_id'])->where("ed_state",'1')->first();
        if($detail){
            $detail = CommonService::dataToArray($detail);
            $data = ExceloutService::getDatas($con, $res, $detail,$user_info);
            $db = $data['db'];
            $group = $data['group'];
            $file = $data['file'];
            if($db){
                $num1 = count($db);
                foreach( $db as $k => $v ){
                    $v = ExceloutService::replaceData($v);
                    foreach( $group as $kg => $vg ){
                        $num = array_search($vg,$group);
                        if ( $vg=='vtde_data'){//处罚信息
                            if (is_numeric($v['vtde_punish_money'])) {
                                $vtde_punish_money = $v['vtde_punish_money']/100;
                            } else {
                                $vtde_punish_money = 0;
                            }
                            $rs[$k][$kg] = '处罚人：'. $v['vtde_adm_name'].','.'处罚金额：￥'.$vtde_punish_money;
                        }else if ( $vg=='viti_state'){//耗材
                            if($v['viti_state'] == 1) {
                                $rs[$k][$kg] = '通过';
                            } else {
                                $rs[$k][$kg] = '驳回';
                            }
                        } elseif($vg=='afsl_actual_price') {
                            $rs[$k][$kg] = $v['afsl_actual_price']/100;
                        } else {
                            $rs[$k][$kg] = "\t".$v[$vg]."\t";
                        }
                    }
                    $datas = $rs[$k];
                    $write = self::writeSvc($file, $datas);
                    unset($db[$k]);
                    unset($rs[$k]);
                }
                $el_item = $res['el_item']+$num1;
                DB::table("excel_list")->where('el_id',$res['el_id'])->update(['el_item'=>$el_item]);
                DB::table("excel_detail")->where("ed_id",$detail['ed_id'])->update(['ed_state'=>2]);
                return response()->json(['code' => 200, 'msg' => '操作成功1', 'data' => '']);
            }else{
                DB::table("excel_detail")->where("ed_id",$detail['ed_id'])->update(['ed_state'=>2]);
                return response()->json(['code' => 200, 'msg' => '操作成功2', 'data' => '']);
            }
        }else{
            DB::table("excel_list")->where('el_id',$res['el_id'])->update(['el_state'=>2]);
            return response()->json(['code' => 200, 'msg' => '操作成功3', 'data' => '']);
        }
    }

    /**|---------------------------------------------------------------------------------
     * @name 写入数据到表格
     * @param string $file 表格文件路径
     * @param array $datas 待写入数据
     * @retrun /multitype:array
     * @author dou 2023/11/11 17:30
     * |---------------------------------------------------------------------------------
    */
    public function writeSvc ( $file , $datas ){
        $file = fopen($file, 'a');
        fputcsv($file, $datas);
        fclose($file);
        return true;
    }
}



