<?php

namespace App\Http\Controllers\Api\DistributorsManages;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Controllers\Api\Verify\DistributorsManages\VerifyReplenishmentsGoodsController;
use Illuminate\Support\Facades\DB;
use App\Http\Models\Api\Common;

class ReplenishmentsGoodsController extends Controller
{
    // 列表每页显示数据个数
    protected $show_count = 10;

    // 列表
    public function index(Request $request)
    {
        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);

        // // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;

        $search_data = $request->all();
        $list_data = DB::table('replenishment_goods_wd')
                        ->where('regw_cid', $user_info->adm_cid)
                        ->where('regw_shop_superior_id', $shop_id)
                        ->where(function($query) use($search_data) {
                            if (!empty($search_data['regw_goo_name'])) {
                                $query->where('regw_goo_name', $search_data['regw_goo_name']);
                            }
                        })
                        ->where(function($query) use($search_data) {
                            if (!empty($search_data['regw_goo_encode'])) {
                                $query->where('regw_goo_encode', $search_data['regw_goo_encode']);
                            }
                        })
                        ->where(function($query) use($search_data) {
                            if (!empty($search_data['regw_cate_name'])) {
                                $query->where('regw_cate_name', $search_data['regw_cate_name']);
                            }
                        })
                        ->where(function($query) use($search_data) {
                            if (!empty($search_data['regw_bra_name'])) {
                                $query->where('regw_bra_name', $search_data['regw_bra_name']);
                            }
                        })
                        ->where(function($query) use($search_data) {
                            if (!empty($search_data['regw_stock_type'])) {
                                $query->where('regw_stock_type', $search_data['regw_stock_type']);
                            }
                        })
                        ->select('regw_goo_name', 'regw_goo_encode', 'regw_cate_name', 'regw_bra_name', 'regw_stock_quantity','regw_stock_type','regw_enroute_amount','regw_delivery_amount')
                        ->orderBy('regw_id', 'desc')
                        ->paginate($this->show_count);
        $data_info['current_page'] = $list_data->currentPage();  //当前页面页码
        $data_info['last_page'] = $list_data->lastPage();        //表示最后一页的页码
        $data_info['total'] = $list_data->total();               //总数据个数
        $data_info['current_number'] = $this->show_count;       //一页显示多少个
        $data_info['data'] = $list_data->items();                //返回数据

        if($list_data) {
            return response()->json(['code'=> 200,'msg'=>'success','data'=>$data_info]);
        }else{
            return response()->json(['code'=> 500,'msg'=>'error','data'=>'暂无数据']);
        } 
    }
}
