<?php
namespace App\Http\Controllers\Api;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use App\Http\Models\Api\Export;
use App\Http\Models\Api\StockingSelling;
use App\Http\Models\Api\StockSellStorageGoods;
use App\Http\Models\Api\Common;
use App\Http\Controllers\Api\YongYou\YongYouController;
use Illuminate\Support\Facades\Crypt;

class ClearDatasController extends Controller
{
    // 初始密码
    protected $password = 123456;
    protected $now_time = '2021-03-12 22:09:16';

    // 测试方法
    public function test(Request $request)
    {
        // 导入商品数据
        // $this->enquirySystemGoods();
        // $this->importExcelData($request);
        $this->addData($request);
    }

    // 导入Excel数据
    public function importExcelData(Request $request)
    {
        $path = public_path('img/新建 XLS 工作表 (2).xls');
        if (is_file($path)) {
            $spreadsheet = \PhpOffice\PhpSpreadsheet\IOFactory::load($path);//如果文件存在则直接载入
            $sheet = $spreadsheet->getActiveSheet();//获取活动的工作sheet
            $highest_row = $sheet->getHighestRow(); // 取得总行数

            $n = 0;
            $exdc_data = [];
            $exdc_update_time = date('Y-m-d H:i:s');
            for ($row = 2; $row <= $highest_row; $row++) {
            // for ($row = 3; $row <= $highest_row; $row++) {
            // for ($row = 4; $row <= $highest_row; $row++) {
                // $excel_data['goo_name'] = trim($sheet->getCellByColumnAndRow(1, $row)->getValue());
                // $excel_data['goo_goods_encode'] = trim($sheet->getCellByColumnAndRow(2, $row)->getValue());
                // $excel_data['goo_cate_name'] = trim($sheet->getCellByColumnAndRow(3, $row)->getValue());
                // $excel_data['attr_guige'] = trim($sheet->getCellByColumnAndRow(4, $row)->getValue());
                // $excel_data['attr_danwei'] = trim($sheet->getCellByColumnAndRow(5, $row)->getValue());
                // $excel_data['goo_bra_name'] = '';
                // $excel_data['goo_purchase_price'] = 0;
                // $excel_data['goo_wholesale_price'] = 0;
                // $excel_data['goo_price'] = 0;
                // $excel_data['goo_goods_encode'] = trim($sheet->getCellByColumnAndRow(1, $row)->getValue());
                // $excel_data['goo_cate_name'] = trim($sheet->getCellByColumnAndRow(2, $row)->getValue());
                // $excel_data['goo_name'] = trim($sheet->getCellByColumnAndRow(3, $row)->getValue());
                // $excel_data['attr_guige'] = trim($sheet->getCellByColumnAndRow(4, $row)->getValue());
                // $excel_data['goo_bra_name'] = trim($sheet->getCellByColumnAndRow(5, $row)->getValue());
                // $excel_data['attr_gongyingshang'] = trim($sheet->getCellByColumnAndRow(6, $row)->getValue());
                // $excel_data['kucun'] = trim($sheet->getCellByColumnAndRow(7, $row)->getValue());
                // $excel_data['goo_purchase_price'] = trim($sheet->getCellByColumnAndRow(8, $row)->getValue());
                // $excel_data['goo_wholesale_price'] = trim($sheet->getCellByColumnAndRow(9, $row)->getValue());
                // $excel_data['goo_price'] = 0;
                // $excel_data['kuwei'] = 'A1';
                // $excel_data['waon_class'] = 3;

                // 杭州石总商品库存
                // $excel_data['goo_goods_encode'] = trim($sheet->getCellByColumnAndRow(2, $row)->getValue());
                // $excel_data['attr_chandi'] = trim($sheet->getCellByColumnAndRow(6, $row)->getValue());
                // $excel_data['goo_name'] = trim($sheet->getCellByColumnAndRow(7, $row)->getValue());
                // $excel_data['attr_xinghao'] = trim($sheet->getCellByColumnAndRow(8, $row)->getValue());
                // $excel_data['attr_danwei'] = trim($sheet->getCellByColumnAndRow(10, $row)->getValue());
                // $excel_data['goo_bra_name'] = trim($sheet->getCellByColumnAndRow(11, $row)->getValue());
                // $excel_data['goo_cate_name'] = trim($sheet->getCellByColumnAndRow(12, $row)->getValue());
                // $excel_data['kucun'] = trim($sheet->getCellByColumnAndRow(17, $row)->getValue());//可售数、库存

                // $excel_data['goo_purchase_price'] = trim($sheet->getCellByColumnAndRow(24, $row)->getValue());//采购价
                // $excel_data['goo_price'] = trim($sheet->getCellByColumnAndRow(25, $row)->getValue());//零售价
                // $excel_data['goo_wholesale_price'] = trim($sheet->getCellByColumnAndRow(26, $row)->getValue());//批发价
                // $excel_data['gongyingshangcode'] = trim($sheet->getCellByColumnAndRow(31, $row)->getValue());//供应商代码
                // $excel_data['gongyingshang'] = trim($sheet->getCellByColumnAndRow(32, $row)->getValue());//供应商名称
                // 杭州石总客户单位数据
                // $excel_data['chun_search_letter'] = trim($sheet->getCellByColumnAndRow(1, $row)->getValue());
                // $excel_data['chun_unit_name'] = trim($sheet->getCellByColumnAndRow(2, $row)->getValue());
                // $excel_data['chun_chty_id'] = trim($sheet->getCellByColumnAndRow(3, $row)->getValue());
                // $excel_data['chun_payment_way'] = trim($sheet->getCellByColumnAndRow(4, $row)->getValue());
                // $excel_data['chin_level'] = trim($sheet->getCellByColumnAndRow(5, $row)->getValue());
                // $excel_data['chun_adm_id'] = trim($sheet->getCellByColumnAndRow(6, $row)->getValue());
                // $excel_data['chun_name'] = trim($sheet->getCellByColumnAndRow(7, $row)->getValue());
                // $excel_data['chun_phone'] = trim($sheet->getCellByColumnAndRow(8, $row)->getValue());
                // $excel_data['chun_province'] = trim($sheet->getCellByColumnAndRow(9, $row)->getValue());
                // $excel_data['chun_city'] = trim($sheet->getCellByColumnAndRow(10, $row)->getValue());
                // $excel_data['chun_county'] = trim($sheet->getCellByColumnAndRow(11, $row)->getValue());
                // $excel_data['chun_address'] = trim($sheet->getCellByColumnAndRow(12, $row)->getValue());
                // dump($excel_data);die;

                // 力道店瓦尔塔价格
                // $excel_data['goo_name'] = trim($sheet->getCellByColumnAndRow(2, $row)->getValue());
                // $excel_data['goo_purchase_price'] = trim($sheet->getCellByColumnAndRow(4, $row)->getValue());

                // 速电网单商品
                // $excel_data['sygo_system_goo_id'] = trim($sheet->getCellByColumnAndRow(1, $row)->getValue());
                // $excel_data['sygo_cate_name'] = trim($sheet->getCellByColumnAndRow(2, $row)->getValue());
                // $excel_data['sygo_bra_name'] = trim($sheet->getCellByColumnAndRow(3, $row)->getValue());
                // $excel_data['sygo_brse_name'] = trim($sheet->getCellByColumnAndRow(4, $row)->getValue());
                // $excel_data['sygo_name'] = trim($sheet->getCellByColumnAndRow(5, $row)->getValue());
                // $excel_data['sygo_common_name'] = trim($sheet->getCellByColumnAndRow(6, $row)->getValue());
                // $excel_data['sygo_national_standard'] = trim($sheet->getCellByColumnAndRow(7, $row)->getValue());
                // $excel_data['sygo_goods_code'] = trim($sheet->getCellByColumnAndRow(8, $row)->getValue());
                // $excel_data['sygo_delete'] = trim($sheet->getCellByColumnAndRow(9, $row)->getValue());

                // 公司名 : 速电 / 力道二仓（王重庆）
                // $excel_data['goo_goods_encode'] = trim($sheet->getCellByColumnAndRow(1, $row)->getValue());
                // $excel_data['goo_name'] = trim($sheet->getCellByColumnAndRow(2, $row)->getValue());
                // $excel_data['kucun'] = trim($sheet->getCellByColumnAndRow(3, $row)->getValue());

                // 公司名 : 速电 / 力道三仓（江观亮）
                // $excel_data['goo_goods_encode'] = trim($sheet->getCellByColumnAndRow(1, $row)->getValue());
                // $excel_data['goo_name'] = trim($sheet->getCellByColumnAndRow(2, $row)->getValue());
                // $excel_data['kucun'] = trim($sheet->getCellByColumnAndRow(3, $row)->getValue());

                // 公司名 : 速电 / 力道店仓库（12.5日启用）
                // $excel_data['goo_goods_encode'] = trim($sheet->getCellByColumnAndRow(1, $row)->getValue());
                // $excel_data['goo_name'] = trim($sheet->getCellByColumnAndRow(2, $row)->getValue());
                // $excel_data['kucun'] = trim($sheet->getCellByColumnAndRow(3, $row)->getValue());

                // 公司名 : 速电 / 力道一仓（王浩楠）
                // $excel_data['goo_goods_encode'] = trim($sheet->getCellByColumnAndRow(1, $row)->getValue());
                // $excel_data['goo_name'] = trim($sheet->getCellByColumnAndRow(2, $row)->getValue());
                // $excel_data['kucun'] = trim($sheet->getCellByColumnAndRow(3, $row)->getValue());

                // 进销存(力道店瓦尔塔价格)
                // $excel_data['goo_price'] = trim($sheet->getCellByColumnAndRow(4, $row)->getValue());
                // $excel_data['goo_code'] = trim($sheet->getCellByColumnAndRow(5, $row)->getValue());
                
                // 系统商品
                // $excel_data['cate_name'] = trim($sheet->getCellByColumnAndRow(1, $row)->getValue());
                // $excel_data['cate_name_two'] = trim($sheet->getCellByColumnAndRow(2, $row)->getValue());
                // $excel_data['bra_name'] = trim($sheet->getCellByColumnAndRow(3, $row)->getValue());
                // $excel_data['brse_name'] = trim($sheet->getCellByColumnAndRow(4, $row)->getValue());
                // $excel_data['goo_goods_encode'] = trim($sheet->getCellByColumnAndRow(5, $row)->getValue());
                // $excel_data['goo_name'] = trim($sheet->getCellByColumnAndRow(6, $row)->getValue());
                // $excel_data['attr_guige'] = trim($sheet->getCellByColumnAndRow(7, $row)->getValue());
                // $excel_data['danwei'] = trim($sheet->getCellByColumnAndRow(8, $row)->getValue());
                // $excel_data['keyword'] = trim($sheet->getCellByColumnAndRow(9, $row)->getValue());
                // $excel_data['item_type'] = trim($sheet->getCellByColumnAndRow(10, $row)->getValue());

                // 厦门客户单位数据
                // $excel_data['chun_search_letter'] = trim($sheet->getCellByColumnAndRow(3, $row)->getValue());//检索字母
                // $excel_data['chun_unit_name'] = trim($sheet->getCellByColumnAndRow(4, $row)->getValue());//客户名称
                // $excel_data['chun_chty_id'] = trim($sheet->getCellByColumnAndRow(5, $row)->getValue());//单位类型
                // $chun_names = trim($sheet->getCellByColumnAndRow(6, $row)->getValue());//联系人
                // $chun_names = str_replace("\n",",",$chun_names);
                // $chun_name = explode(',', trim($chun_names));
                // $excel_data['chun_name'] = $chun_name[0];
                // if (isset($chun_name[1])) {
                //     $excel_data['chun_names'] = $chun_name[1];
                // }
                // $chun_phones = trim($sheet->getCellByColumnAndRow(7, $row)->getValue());//电话
                // $chun_phones = str_replace("\n",",",$chun_phones);
                // $chun_phone = explode(',', trim($chun_phones));
                // $excel_data['chun_phone'] = $chun_phone[0];
                // if (isset($chun_phone[1])) {
                //     $excel_data['chun_phones'] = $chun_phone[1];
                // }
                // if (isset($chun_phone[2])) {
                //     $excel_data['chun_phoness'] = $chun_phone[2];
                // }
                // $excel_data['chin_caution_day'] = trim($sheet->getCellByColumnAndRow(8, $row)->getValue());//警示天数
                // $excel_data['chin_owe_day'] = trim($sheet->getCellByColumnAndRow(9, $row)->getValue());//可欠天数
                // $excel_data['chin_level'] = trim($sheet->getCellByColumnAndRow(10, $row)->getValue());//客户等级
                // $excel_data['chun_payment_way'] = trim($sheet->getCellByColumnAndRow(11, $row)->getValue());//结算方式
                // $excel_data['chin_type'] = trim($sheet->getCellByColumnAndRow(12, $row)->getValue());//是否铺货
                // $excel_data['chin_type_money'] = trim($sheet->getCellByColumnAndRow(13, $row)->getValue());//铺货金额(元)
                // $excel_data['chun_adm_id'] = trim($sheet->getCellByColumnAndRow(14, $row)->getValue());//业务员
                // $excel_data['chun_adm_name'] = trim($sheet->getCellByColumnAndRow(15, $row)->getValue());//业务员电话
                // $excel_data['chun_zoning'] = trim($sheet->getCellByColumnAndRow(16, $row)->getValue());//业务划区
                // $excel_data['chun_province'] = trim($sheet->getCellByColumnAndRow(17, $row)->getValue());//所在地区
                // $excel_data['chun_city'] = trim($sheet->getCellByColumnAndRow(18, $row)->getValue());//市
                // $excel_data['chun_county'] = trim($sheet->getCellByColumnAndRow(19, $row)->getValue());//县
                // $excel_data['chun_address'] = trim($sheet->getCellByColumnAndRow(20, $row)->getValue());//详细地址
                // $excel_data['chin_remarks'] = trim($sheet->getCellByColumnAndRow(21, $row)->getValue());//备注

                // 厦门供应商信息
                // $excel_data['chun_search_letter'] = trim($sheet->getCellByColumnAndRow(3, $row)->getValue());//检索字母
                // $excel_data['chun_unit_name'] = trim($sheet->getCellByColumnAndRow(4, $row)->getValue());//供应商名称
                // $excel_data['chun_name'] = trim($sheet->getCellByColumnAndRow(5, $row)->getValue());//联系人
                // $excel_data['chun_phone'] = trim($sheet->getCellByColumnAndRow(6, $row)->getValue());//联系电话

                // 厦门商品数据
                // $excel_data['goo_cate_name'] = trim($sheet->getCellByColumnAndRow(2, $row)->getValue());//品类
                // $excel_data['goo_bra_name'] = trim($sheet->getCellByColumnAndRow(3, $row)->getValue());//品牌
                // $excel_data['goo_brse_name'] = trim($sheet->getCellByColumnAndRow(4, $row)->getValue());//系列
                // $excel_data['goo_goods_encode'] = trim($sheet->getCellByColumnAndRow(5, $row)->getValue());//鑫世进商品编码
                // $excel_data['goo_sd_goods_encode'] = trim($sheet->getCellByColumnAndRow(6, $row)->getValue());//速电快保商品编码
                // $excel_data['goo_name'] = trim($sheet->getCellByColumnAndRow(7, $row)->getValue());//商品名称
                // // $excel_data['goo_ampere_hour'] = trim($sheet->getCellByColumnAndRow(8, $row)->getValue());//安时数
                // $excel_data['guige'] = trim($sheet->getCellByColumnAndRow(8, $row)->getValue());//规格
                // $excel_data['danwei'] = trim($sheet->getCellByColumnAndRow(9, $row)->getValue());//单位
                // $excel_data['hwcl'] = trim($sheet->getCellByColumnAndRow(10, $row)->getValue());//货物仓良品
                // $excel_data['fhwcl'] = trim($sheet->getCellByColumnAndRow(11, $row)->getValue());//非货物仓良品
                // $excel_data['jhcl'] = trim($sheet->getCellByColumnAndRow(12, $row)->getValue());//旧货仓良品
                // $excel_data['jhcy'] = trim($sheet->getCellByColumnAndRow(13, $row)->getValue());//旧货仓优先
                // // $excel_data['lscdjc'] = trim($sheet->getCellByColumnAndRow(14, $row)->getValue());//库存
                // $excel_data['chengben'] = trim($sheet->getCellByColumnAndRow(14, $row)->getValue());//成本
                // $excel_data['goo_wholesale_price'] = trim($sheet->getCellByColumnAndRow(15, $row)->getValue());//批发价
                // $excel_data['goo_price'] = trim($sheet->getCellByColumnAndRow(16, $row)->getValue());//零售价
                // $excel_data['goo_remark'] = trim($sheet->getCellByColumnAndRow(17, $row)->getValue());//备注

                // 厦门会计科目数据
                // $excel_data['typeindex'] = trim($sheet->getCellByColumnAndRow(1, $row)->getValue());//类型
                // $excel_data['subjcode'] = trim($sheet->getCellByColumnAndRow(2, $row)->getValue());//科目代码
                // $excel_data['subjname'] = trim($sheet->getCellByColumnAndRow(3, $row)->getValue());//科目名称
                // $excel_data['balanorient'] = trim($sheet->getCellByColumnAndRow(4, $row)->getValue());//方向

                // 厦门超1年未合作且有欠款的客户
                // $excel_data['chun_search_letter'] = trim($sheet->getCellByColumnAndRow(2, $row)->getValue());//检索字母
                // $excel_data['chun_unit_name'] = trim($sheet->getCellByColumnAndRow(3, $row)->getValue());//客户名称
                // $excel_data['chun_chty_id'] = trim($sheet->getCellByColumnAndRow(4, $row)->getValue());//单位类型
                // $chun_names = trim($sheet->getCellByColumnAndRow(5, $row)->getValue());//联系人
                // $chun_names = str_replace("\n",",",$chun_names);
                // $chun_name = explode(',', trim($chun_names));
                // $excel_data['chun_name'] = $chun_name[0];
                // if (isset($chun_name[1])) {
                //     $excel_data['chun_names'] = $chun_name[1];
                // }
                // $chun_phones = trim($sheet->getCellByColumnAndRow(6, $row)->getValue());//电话
                // $chun_phones = str_replace("\n",",",$chun_phones);
                // $chun_phone = explode(',', trim($chun_phones));
                // $excel_data['chun_phone'] = $chun_phone[0];
                // if (isset($chun_phone[1])) {
                //     $excel_data['chun_phones'] = $chun_phone[1];
                // }
                // if (isset($chun_phone[2])) {
                //     $excel_data['chun_phoness'] = $chun_phone[2];
                // }
                // $excel_data['alowmost'] = trim($sheet->getCellByColumnAndRow(7, $row)->getValue());//近一年拿货量
                // $excel_data['chin_caution_day'] = trim($sheet->getCellByColumnAndRow(8, $row)->getValue());//警示天数
                // $excel_data['chin_owe_day'] = trim($sheet->getCellByColumnAndRow(9, $row)->getValue());//可欠天数
                // $excel_data['chin_level'] = trim($sheet->getCellByColumnAndRow(10, $row)->getValue());//客户等级
                // $excel_data['chun_payment_way'] = trim($sheet->getCellByColumnAndRow(11, $row)->getValue());//结算方式
                // $excel_data['chin_type'] = trim($sheet->getCellByColumnAndRow(12, $row)->getValue());//是否铺货
                // $excel_data['chin_type_money'] = trim($sheet->getCellByColumnAndRow(13, $row)->getValue());//铺货金额(元)
                // $excel_data['chun_adm_id'] = trim($sheet->getCellByColumnAndRow(14, $row)->getValue());//业务员
                // $excel_data['chun_adm_name'] = trim($sheet->getCellByColumnAndRow(15, $row)->getValue());//业务员电话
                // $excel_data['chun_zoning'] = trim($sheet->getCellByColumnAndRow(16, $row)->getValue());//业务划区
                // $excel_data['chun_province'] = trim($sheet->getCellByColumnAndRow(17, $row)->getValue());//省
                // $excel_data['chun_city'] = trim($sheet->getCellByColumnAndRow(18, $row)->getValue());//市
                // $excel_data['chun_county'] = trim($sheet->getCellByColumnAndRow(19, $row)->getValue());//县
                // $excel_data['chun_address'] = trim($sheet->getCellByColumnAndRow(20, $row)->getValue());//详细地址
                // $excel_data['chin_remarks'] = trim($sheet->getCellByColumnAndRow(21, $row)->getValue());//备注

                // 厦门商品数据 12
                // $excel_data['goo_goods_encode'] = trim($sheet->getCellByColumnAndRow(5, $row)->getValue());//鑫世进商品编码
                // $excel_data['hwcl'] = trim($sheet->getCellByColumnAndRow(10, $row)->getValue());//货物仓良品库存
                // $excel_data['feispcl'] = trim($sheet->getCellByColumnAndRow(11, $row)->getValue());//非商品仓良品库存
                // $excel_data['jhcl'] = trim($sheet->getCellByColumnAndRow(12, $row)->getValue());//旧货仓良品库存
                // $excel_data['jhcy'] = trim($sheet->getCellByColumnAndRow(13, $row)->getValue());//旧货仓优先库存
                // $excel_data['chengben'] = trim($sheet->getCellByColumnAndRow(14, $row)->getValue());//成本

                // 厦门同安店旧货库存.xlsx  13
                // $excel_data['goo_goods_encode'] = trim($sheet->getCellByColumnAndRow(5, $row)->getValue());//鑫世进商品编码
                // $excel_data['jhcl'] = trim($sheet->getCellByColumnAndRow(12, $row)->getValue());//旧货仓良品库存
                // $excel_data['jhcy'] = trim($sheet->getCellByColumnAndRow(13, $row)->getValue());//旧货仓优先库存
                // $excel_data['chengben'] = trim($sheet->getCellByColumnAndRow(14, $row)->getValue());//成本

                // 厦门前埔店库存（截止9.9日24：00）.xlsx  14
                // $excel_data['goo_goods_encode'] = trim($sheet->getCellByColumnAndRow(5, $row)->getValue());//鑫世进商品编码
                // $excel_data['hwcl'] = trim($sheet->getCellByColumnAndRow(11, $row)->getValue());//货物仓良品库存
                // $excel_data['feispcl'] = trim($sheet->getCellByColumnAndRow(12, $row)->getValue());//非商品仓良品库存
                // $excel_data['jhcl'] = trim($sheet->getCellByColumnAndRow(13, $row)->getValue());//旧货仓良品库存
                // $excel_data['jhcy'] = trim($sheet->getCellByColumnAndRow(14, $row)->getValue());//旧货仓优先库存
                // $excel_data['chengben'] = trim($sheet->getCellByColumnAndRow(15, $row)->getValue());//成本

                // 系统商品导入
                $excel_data['goo_bra_name'] = trim($sheet->getCellByColumnAndRow(1, $row)->getValue());//品牌
                $excel_data['goo_brse_name'] = trim($sheet->getCellByColumnAndRow(2, $row)->getValue());//系列
                $excel_data['xinghao'] = trim($sheet->getCellByColumnAndRow(3, $row)->getValue());//型号
                $excel_data['old_goods_code'] = trim($sheet->getCellByColumnAndRow(4, $row)->getValue());//编码(旧)
                $excel_data['new_goods_code'] = trim($sheet->getCellByColumnAndRow(5, $row)->getValue());//编码(新)

                dump($excel_data);
                die;

                $exdc_data[$n]['exdc_type'] = 8;
                $exdc_data[$n]['exdc_update_time'] = $exdc_update_time;
                $exdc_data[$n]['exdc_data'] = json_encode($excel_data);
                $n++;
                unset($excel_data);
            }
            // dump($exdc_data);
            // die;
            $res = DB::table('excel_data_cache')->insert($exdc_data);
            // dump($res);
            // die;
        }
        echo 999;
        die;
    }

    // 将读取到的Excel表格数据，添加到数据库
    public function addData(Request $request)
    {
        // 导入商品数据
        $data =DB::table('excel_data_cache')->where('exdc_type', 8)->get();
        $data = json_decode($data, true);
        $data_info =[];
        foreach ($data as $key => $value) {
            $data_info[] = json_decode($value['exdc_data'], true);
        }
        // dump($data_info);exit;
        // $this->importJxc($request->all(), $data_info);
        $this->systemImportGoods($request->all(), $data_info);//系统商品导入
    }

    // 系统商品导入
    public function systemImportGoods($submit_data, $data)
    {
        echo 99900;
        DB::beginTransaction();
        $cid = 1; //公司id
        $superior_shop_id = 1; //总店id
        $shop_id = 1; //门店id
        // $dates = date('Y-m-d H:i:s');
        $dates = $this->now_time;
        try {
            $api_token = Crypt::decrypt($submit_data['api_token']);
        } catch (\Exception $e) {
            return response()->json(["code" => 300, 'msg' => 'error', 'data' => '非法api_token']);
        }

        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($api_token);
        $adm_cid = 1;

        foreach ($data as $key => $value) {
            // dump($value);
            // exit;
            // 品牌
            $bra_id = DB::table('brand')
                ->where('bra_cid', 0)
                ->where('bra_shop_id', 0)
                ->where('bra_delete', 1)
                ->where('bra_name', $value['goo_bra_name'])
                ->value('bra_id');
            if (empty($bra_id)) {
                $bra_data['bra_cid'] = 0;
                $bra_data['bra_shop_id'] = 0;
                $bra_data['bra_superior_shop_id'] = 0;
                $bra_data['bra_name'] = $value['goo_bra_name'];
                $bra_data['bra_create_time'] = $dates;
                $bra_data['bra_goods_number'] = 2;
                $bra_data['bra_update_time'] = $dates;
                $bra_id = DB::table('brand')->insertGetId($bra_data);
            } else {
                DB::table('brand')->where('bra_id', $bra_id)->increment('bra_goods_number', 2);
            }
            // 品牌系列
            $brse_id = DB::table('brand_serie')
                ->where('brse_cid', 0)
                ->where('brse_shop_id', 0)
                ->where('brse_delete', 1)
                ->where('brse_name', $value['goo_brse_name'])
                ->value('brse_id');
            if (empty($brse_id)) {
                $brse_data['brse_cid'] = 0;
                $brse_data['brse_shop_id'] = 0;
                $brse_data['brse_superior_shop_id'] = 0;
                $brse_data['brse_bra_id'] = $bra_id; //品牌id
                $brse_data['brse_cate_id'] = 1499; //品类id
                $brse_data['brse_name'] = $value['goo_brse_name'];
                $brse_data['brse_create_time'] = $dates;
                $brse_data['brse_goods_number'] = 2;
                $brse_data['brse_update_time'] = $dates;
                $brse_id = DB::table('brand_serie')->insertGetId($brse_data);
            } else {
                DB::table('brand_serie')->where('brse_id', $brse_id)->increment('brse_goods_number', 2);
            }
            // 根据检索编码查询商品id
            $find_goo_id = DB::table('goods')
                ->where('goo_shop_id', 0)
                ->where('goo_type', 1)
                ->where('goo_delete', 1)
                ->where('goo_goods_encode', $value['new_goods_code'])
                ->select('goo_id', 'goo_goods_encode')
                ->first();
            // dump($find_goo_id);
            if (!empty($find_goo_id->goo_id)) {
                $goo_id = $find_goo_id->goo_id;
            } else {
                dump($value['new_goods_code']);
                // exit;
                $info['goo_cid'] = 0;
                $info['goo_superior_shop_id'] = 0;
                $info['goo_shop_id'] = 0;
                $info['goo_cate_name'] = '蓄电池';
                $info['goo_cate_id'] = 1499;
                $info['goo_bra_name'] = $value['goo_bra_name']; //品牌名称
                $info['goo_bra_id'] = $bra_id; //品牌id
                $info['goo_brse_id'] = $brse_id; //品牌系列id
                $info['goo_name'] = $value['xinghao'];
                $info['goo_goods_encode'] = $value['new_goods_code'];
                $info['goo_class'] = 2;
                $info['goo_update_time'] = $dates;
                if (!empty($value['new_goods_code'])) {
                    // 判断商品是否存在
                    $goo_id = DB::table('goods')
                        ->where('goo_cid', 0)
                        ->where('goo_shop_id', 0)
                        ->where('goo_type', 1)
                        ->where('goo_delete', 1)
                        ->where('goo_class', 1)
                        ->where('goo_goods_encode', $value['new_goods_code'])
                        ->value('goo_id');
                    dump($goo_id);
                    if (empty($goo_id)) {
                        $info['goo_type'] = 1; //商品类型 1正常商品2赠品商品3活动商品4旧货商品
                        $info['goo_fid'] = 0;
                        $info['goo_system_code'] = str_pad($cid, '4', '0', STR_PAD_RIGHT) . str_pad($shop_id, '5', '0', STR_PAD_RIGHT) . rand(10, 99) . rand(100000000, 999999999); //系统编码
                        $goo_id = DB::table('goods')->insertGetId($info);
                        // 添加旧货商品
                        $info['goo_type'] = 4; //1正常商品2赠品商品3活动商品4旧货商品
                        $info['goo_fid'] = $goo_id;
                        $info['goo_system_code'] = str_pad($cid, '4', '0', STR_PAD_RIGHT) . str_pad($shop_id, '5', '0', STR_PAD_RIGHT) . rand(10, 99) . rand(100000000, 999999999); //系统编码
                        $junk_res = DB::table('goods')->insertGetId($info);
                    } else {
                        // 商品数量
                        $num = 1;
                        $info['goo_type'] = 1;   //1正常商品2赠品商品3活动商品4旧货商品
                        $info['goo_update_time'] = $dates;
                        $res = DB::table('goods')
                            ->where('goo_type', 1)
                            ->where('goo_id', $goo_id)
                            ->update($info);
                        // 旧货商品
                        $junk_goo_id = DB::table('goods')
                            ->where('goo_fid', $goo_id)
                            ->where('goo_type', 4)
                            ->value('goo_id');
                        if (!empty($junk_goo_id)) {
                            $info['goo_type'] = 4;   //1正常商品2赠品商品3活动商品4旧货商品
                            $junk_res = DB::table('goods')
                                ->where('goo_id', $junk_goo_id)
                                ->update($info);
                        } else {
                            $num += 1;
                            $info['goo_type'] = 4; //1正常商品2赠品商品3活动商品4旧货商品
                            $info['goo_fid'] = $goo_id;
                            $info['goo_system_code'] = str_pad($cid, '4', '0', STR_PAD_RIGHT) . str_pad($shop_id, '5', '0', STR_PAD_RIGHT) . rand(10, 99) . rand(100000000, 999999999); //系统编码
                            $junk_res = DB::table('goods')->insertGetId($info);
                        }
                    }
                }
                // 品类
                $cate_id = DB::table('category')
                    ->where('cate_id', 1499)
                    ->value('cate_id');
                if (empty($cate_id)) {
                } else {
                    DB::table('category')->where('cate_id', $cate_id)->increment('cate_goods_number', 2);
                }
                unset($cate_id);
                unset($info);
            }
        }
        echo 333;
        DB::commit();
    }

    // 统计系统商品编码不等了6位的商品
    public function enquirySystemGoods()
    {
        $find_goo_data = DB::table('goods')
            ->where('goo_cid', 0)
            ->where('goo_shop_id', 0)
            ->where('goo_delete', 1)
            ->select('goo_id', 'goo_name', 'goo_goods_encode')
            ->get()->toArray();
        foreach ($find_goo_data as $key => $value) {
            $goo_goods_encode = $value->goo_goods_encode;
            // if (isset($goo_goods_encode{6})) {
            //     dump($goo_goods_encode);
            // }
            if (strlen($goo_goods_encode) != 6) {
                dump($value->goo_name . '===' . $goo_goods_encode);
            }
        }
        echo '123';
    }

    // 查询采购单数据
    public function purchase()
    {
        $cid = 1;//公司id
        $superior_shop_id = 1;//总店id
        $shop_id = 1;//门店id
        $find_wain = DB::table('ware_inorder as wain')
            ->leftjoin('storage_goods as stgo', 'stgo.relation_number', '=', 'wain.rk_number')
            ->where('company_id', $cid)
            ->where('rk_shop_id', $shop_id)
            ->get()->toArray();
    }

    // 厦门门店导入货物仓商品数据
    public function importJxc($submit_data, $data)
    {
        echo 99900;
        DB::beginTransaction();
        $cid = 1;//公司id
        $superior_shop_id = 1;//总店id
        $shop_id = 1;//门店id
        $defeated = [];
        $dates = date('Y-m-d H:i:s');
        // try {
        //     $api_token = Crypt::decrypt($submit_data['api_token']);
        // } catch (\Exception $e) {
        //     return response()->json(["code"=>300,'msg'=>'error','data'=>'非法api_token']);
        // }

        // 获取当前操作账号信息
        // $user_info = Common::getUserInfo($api_token);

        $user_info = Common::getUserInfo($submit_data['api_token']);
        $ware_id = 14;//仓库id
        $waon_class = 3;//仓库类别1.货物仓2.非货物仓3.旧货仓4.临时仓
        $goo_type = 4;
        foreach ($data as $key => $value) {
            // dump($value);exit;
            // 货物仓
            // if ($value['hwcl'] == '') {
            //     $value['hwcl'] = 0;
            // }
            // 非货物仓
            // if ($value['fhwcl'] == '') {
            //     $value['fhwcl'] = 0;
            // }
            // 旧货仓良品
            // if ($value['jhcl'] == '') {
            //     $value['jhcl'] = 0;
            // }
            // 旧货仓优先
            if ($value['jhcy'] == '') {
                $value['jhcy'] = 0;
            }
            $value['jhcy'] = trim($value['jhcy'], '=');
            if (stristr($value['jhcy'], '+')) {
                $jhcy = explode('+', $value['jhcy']);
                $value['jhcy'] = array_sum($jhcy);
                unset($jhcy);
            }
            // 根据检索编码查询商品id
            $find_goo_id = DB::table('goods')
                ->where('goo_cid', $cid)
                ->where('goo_shop_id', $shop_id)
                ->where('goo_superior_shop_id', $superior_shop_id)
                ->where('goo_type', $goo_type)
                ->where('goo_delete', 1)
                ->where('goo_goods_encode', $value['goo_goods_encode'])
                ->select('goo_id', 'goo_purchase_price', 'goo_goods_encode')
                ->first();
            $goo_id = $find_goo_id->goo_id;
                 
            // 添加进销存
            $goo_id_arr[] = $goo_id;
            // $purchase_goo_actual_count[$goo_id] = $value['hwcl'];//货物仓
            // $purchase_goo_actual_count[$goo_id] = $value['fhwcl'];//非货物仓
            // $purchase_goo_actual_count[$goo_id] = $value['jhcl'];//旧货仓良品
            $purchase_goo_actual_count[$goo_id] = $value['jhcy'];//旧货仓优先
            $purchase_goo_actual_price[$goo_id] = $value['chengben'];
            $purchase_return = StockSellStorageGoods::purchaseSalesImport(
                $user_info,//用户信息
                2,//进销存计算方式：1先进先出2移动加权平均法3无成本
                1,//类型：1采购，2销出，3调拨
                $ware_id,//仓库id
                $waon_class,//仓库类别
                $goo_id_arr,//数组，商品id
                $purchase_goo_actual_count,//数组，商品数量；[商品id=>商品数量]
                $purchase_goo_actual_price, //数组，商品金额，成本价(不乘以100)；[商品id=>商品金额]
                3 //进销存的移动加权平均法算法类型：1计算平均价2不计算平均价【退换回收时不计算平均价】
            );
            unset($goo_id);
            unset($goo_id_arr);
            unset($purchase_goo_actual_count);
            unset($purchase_goo_actual_price);
            unset($purchase_return);
            unset($find_goo_id);
        }
        echo 333;
        dump($defeated);
        DB::commit();
    }

    public function goodsidChange()
    {
        $ware_id = 9;
        $dates = '2020-09-10 18:02:20';
        $find_wago_data = DB::table('warehouse_goods')
            ->where('wago_ware_id', $ware_id)
            ->where('wago_class', 2)
            ->select('wago_goo_id', 'wago_id')
            ->get()->toArray();
        foreach ($find_wago_data as $key => $value) {
            $goo_id = DB::table('goods')
                ->where('goo_cid', 1)
                ->where('goo_shop_id', 1)
                ->where('goo_fid', $value->wago_goo_id)
                ->value('goo_id');
            if ($goo_id) {
                $edit_data['wago_goo_id'] = $goo_id;
                $edit_data['wago_update_time'] = $dates;
                $edit_res = DB::table('warehouse_goods')
                    ->where('wago_id', $value->wago_id)
                    ->update($edit_data);
                dump($edit_res);
                unset($edit_data);
                unset($edit_res);
            }
        }
    }

    // 销售统计
    public function sellStatistic()
    {
        // 业务划区下各品牌的销售数量（不包含铺货的）
        $list_data = DB::table('order_goods as og')
                ->leftJoin('order as o', 'o.ord_id', '=', 'og.orgo_ord_id')
                ->leftJoin('order_client as oc', 'o.ord_id', '=', 'oc.orcl_ord_id')
                ->leftJoin('channel_info as cu', 'cu.chin_chun_id', '=', 'o.ord_client_id')
                ->leftJoin('admin as a', 'a.adm_id', '=', 'o.ord_create_id')
                ->leftJoin('goods as g', 'g.goo_id', '=', 'og.orgo_goo_id')
                ->leftJoin('order_label as ol', 'ol.orla_id', '=', 'og.ord_orla_id')
                ->where('ord_cid', 1)
                ->where('ord_superior_shop_id', 1)
                ->where('ord_delete', 1)
                ->where('orcl_chin_type', 2)
                ->where('goo_cate_name', '启动电池')
                ->where('ord_collection_bill', 1) //是否代收账单：1正常订单2代收账单
                ->where('ord_service_type', '<>', 4)
                ->whereNotIn('orgo_state', [3,4])
                // ->select('ord_order_number33 as 订单编号', 'adm_name as 录单人', 'ord_type as 买家类型', 'orcl_channel_unit as 客户单位', 'chin_zoning as 业务划区', 'orcl_name as 客户名称', 'orcl_chin_type as 铺货类型', 'goo_bra_name as 品牌',  'orgo_state as 商品状态', 'orgo_goo_name as 商品名称', 'orgo_goo_goods_encode as 商品编码', 'orgo_goo_type as 商品类型', 'orgo_goo_price as 商品单价', 'orgo_goo_quantity as 商品数量')
                ->select('ord_order_number33', 'adm_name', 'ord_type', 'orcl_channel_unit', 'chin_zoning', 'orcl_name', 'orla_name as orcl_chin_type', 'goo_bra_name', 'orgo_state', 'orgo_goo_name', 'orgo_goo_goods_encode', 'orgo_goo_type', 'orgo_goo_price', 'orgo_goo_quantity')
                // ->groupBy()
                ->get();

        // dump($list_data);
        dump(count($list_data));
        die;
        // 只限货物仓出库的数量—退换货回来的量
    }

    // 编辑权限id
    public function editRole()
    {
        // 更改权限表权限id
        $list = DB::table('role')
        ->select('rol_id', 'rol_privilege')
        ->get();
        $edit_pri_id = [233,353];//要删除的权限id
        // 更改权限表权限id
        foreach ($list as $key => $value) {
            $rol_privilege = explode(',', $value->rol_privilege);
            // dump($rol_privilege);die;
            foreach ($edit_pri_id as $edit_key => $pri_id) {
                // 判断权限id是否在角色id数组中
                if (in_array($pri_id, $rol_privilege)) {
                    $rol_key = array_search($pri_id, $rol_privilege);
                    // 删除角色id数组中的权限id值
                    unset($rol_privilege[$rol_key]);
                }
            }
            // 更改新的权限
            $edit_data['rol_privilege'] = implode(',', $rol_privilege);
            $edit_data['rol_update_time'] = date('Y-m-d H:i:s');
            // if ($value->rol_id == 14) {
            //     dump($edit_data);
            //     die;
            // }
            $edit_res =  DB::table('role')
                ->where('rol_id', $value->rol_id)
                ->update($edit_data);
            dump($edit_res);
            unset($edit_data);
            unset($edit_res);
        }
    }

    // 测试方法
    public function tests(Request $request)
    {
        // $this->sellStatistic();
        // $this->warehousing($request->all());
        // $this->u8cloud();
        // $this->editRole();
        die;
        // 删除仓库商品表的数据
        // $wago_res = DB::table('warehouse_goods as b')
        //  ->leftjoin('warehouse as a', 'b.wago_ware_id', '=', 'a.ware_id')
        // ->where('ware_cid', 1)
        //  // ->where('ware_superior_shop_id', 1)
        // $wago_res = DB::table('warehouse_goods')
        //  ->where('wago_ware_id', 13)
        //  // ->delete();
        //  ->get();
        // dump($wago_res);
        // die;
        // echo 555;die;
        //
        // $wago_res = DB::table('goods')
        //  ->where('goo_shop_id', 1)
        //  ->where('goo_class', 1)
        //  ->where('goo_update_time', '<>', '2020-09-09 22:30:36')
        //  ->delete();
        //  // ->get();
        // dump($wago_res);
        // die;
        echo 555;
        die;
        $data =DB::table('excel_data_cache')->where('exdc_type', 10)->get();
        $data = json_decode($data, true);
        $data_info =[];
        foreach ($data as $key => $value) {
            $data_info[] = json_decode($value['exdc_data'], true);
        }
        // $this->addSubjects($request->all(), $data_info);//厦门导入会计科目数据
        // $this->addSubject($request->all(), $data_info);//厦门导入会计科目数据
        $this->himportGoods($request->all(), $data_info);//厦门导入会计科目数据
        // $this->nimportGoods($request->all(), $data_info);//厦门导入会计科目数据
        // $this->oldImportGoods($request->all(), $data_info);//厦门导入会计科目数据
        die;
        $this->oldImportGoods($request->all(), $data_info);
        die;
        $data =DB::table('excel_data_cache')->where('exdc_type', 2)->get();
        $data = json_decode($data, true);
        $data_info =[];
        foreach ($data as $key => $value) {
            $data_info[] = json_decode($value['exdc_data'], true);
        }
        $this->xmExcelChannel($request->all(), $data_info);
        die;
        $this->addChun();
        exit;
        $list_data = $this->sdOrderAchieveTime($request['order_number']);
        return response()->json(['data'=>$list_data]);

        // $shop_data =DB::table('shop')->get();
        // foreach ($shop_data as $key => $value) {
        //     // dump($value);
        //     if (!in_array($value->shop_id, [52]) && $value->shop_type == 3) {
        //         dump($value);
        //         $this->systemGoods($value->shop_cid, $value->shop_id, $value->shop_id, $value->shop_type);
        //     }
        // }
        die;
        // echo 111;die;
        // $this->u8cloud($request->all());
        // $this->systemGoods(1, 1);
        // die;
        // 导入商品数据
        $data =DB::table('excel_data_cache')->where('exdc_type', 20)->get();
        $data = json_decode($data, true);
        $data_info =[];
        foreach ($data as $key => $value) {
            $exdc_data = json_decode($value['exdc_data'], true);
            $data_info[] = $exdc_data;
        }
        // dump($data_info);
        // die;
        $this->xmGoodsStock($request->all(), $data_info);
        // $this->sdkbExcelGoods0814($request->all(), $data_info);
        die;

        // 杭州石总商品库存导入
        foreach ($data as $key => $value) {
            // 蓄电池商品导入
            if ($key > 223) {
                break;
            }
            // if ($key <= 223) {
            //     continue;
            // }
            if ($key == 637) {
                break;
            }
            
            $exdc_data = json_decode($value['exdc_data'], true);
            // if ($key == 632) {
            //     $exdc_data['goo_cate_name'] = '前刹';
            //     // dump($exdc_data);die;
            // }
            // $exdc_data['goo_cate_name'] = $exdc_data['goo_name'].$exdc_data['goo_cate_name'];
            $data_info[] = $exdc_data;
            unset($exdc_data);
        }
        dump($data_info);
        die;
        // $this->hzExcelGoods($request->all(), $data_info);
        die;
        echo 111;
        die;
        // 更改权限表权限id
        $list = DB::table('role')
        ->select('rol_id', 'rol_privilege')
        ->get();
        $edit_pri_id = [139,164,166,168,151,157,158,170,171];//要删除的权限id
        // 更改权限表权限id
        foreach ($list as $key => $value) {
            $rol_privilege = explode(',', $value->rol_privilege);
            foreach ($edit_pri_id as $edit_key => $pri_id) {
                // 判断权限id是否在角色id数组中
                if (in_array($pri_id, $rol_privilege)) {
                    $rol_key = array_search($pri_id, $rol_privilege);
                    // 删除角色id数组中的权限id值
                    unset($rol_privilege[$rol_key]);
                }
            }
            // 更改新的权限
            $edit_data['rol_privilege'] = implode(',', $rol_privilege);
            $edit_data['rol_update_time'] = date('Y-m-d H:i:s');
            // if ($value->rol_id == 14) {
            //     dump($edit_data);
            //     die;
            // }
            $edit_res =  DB::table('role')
                ->where('rol_id', $value->rol_id)
                ->update($edit_data);
            dump($edit_res);
            unset($edit_data);
            unset($edit_res);
        }
        die;
    }

    // 同步客户单位数据到用友系统
    public function u8cloud()
    {
        echo 888;
        // die;
        // 调用u8系统接口，将客商数据传到用友系统上
        $yongyou = new YongYouController;
        $error_data = [];

        $user_info['adm_cid'] = 1;
        $user_info['adm_shop_id'] = 2;//门店id
        // 查询客户单位数据
        $list_data = DB::table('channel_unit as u')
                ->where('u.chun_cid', $user_info['adm_cid'])
                ->where('u.chun_shop_id', $user_info['adm_shop_id'])
                ->where('u.chun_state', '<>', 3)
                // ->where('u.chun_id', '>=', 7939)
                // ->where('u.chun_id', '<', 8666)
                ->select('chun_id', 'chun_search_letter', 'chun_unit_name')
                ->get();
        // dump($list_data);
        // die;
        foreach ($list_data as $key => $value) {
            // 客商基本档案新增
            $u8cloud_data['cbdocvo'][0]['parentvo']['creator'] = config('apiu8cloud.pk_prepared');//否  创建人
            $u8cloud_data['cbdocvo'][0]['parentvo']['custcode'] = config('apiu8cloud.custcode.unit').$user_info['adm_shop_id'].'MK'.$value->chun_id;//是 客商编码
            $u8cloud_data['cbdocvo'][0]['parentvo']['custname'] =$value->chun_unit_name;//是 客商名称
            $u8cloud_data['cbdocvo'][0]['parentvo']['custprop'] ='0';//否 客商类型(0 - 外部单位,1 - 内部核算单位,2 - 内部法人单位,3 - 内部渠道成员)
            $u8cloud_data['cbdocvo'][0]['parentvo']['custshortname'] =$value->chun_unit_name;//是    客商简称
            $u8cloud_data['cbdocvo'][0]['parentvo']['pk_areacl'] =config('apiu8cloud.SHOP_BASIC_SETUP')[$user_info['adm_shop_id']]['areaclcode'];//否   所属地区(填写编码)
            $u8cloud_data['cbdocvo'][0]['parentvo']['mnecode'] =$value->chun_search_letter;//否 助记码
            // dump($u8cloud_data);die;
            // 调用u8系统接口
            $curl_return = $yongyou->u8cloudApi('客商基本档案新增', $u8cloud_data);
            // 判断用友接口返回的数据
            if ($curl_return['status'] != 'success') {
                $error_data[] = $value->chun_id;
                continue;
            }
            // 客户数据添加成功，分配客商到门店
            $curl_data = json_decode($curl_return['data'], true);
            $chin_add_data['pk_cubasdoc'] = $curl_data[0]['parentvo']['pk_cubasdoc'];//客商基本档案主键--添加门店系统
            $res = DB::table('channel_info')
                ->where('chin_chun_id', $value->chun_id)
                ->update($chin_add_data);
            dump($res);
            $custbasvo['custbasvo'][0]['pk_corp'] = config('apiu8cloud.SHOP_BASIC_SETUP')[$user_info['adm_shop_id']]['pk_corp'];//公司主键
            $custbasvo['custbasvo'][0]['pk_cubasdoc'] =$curl_data[0]['parentvo']['pk_cubasdoc'];//客商基本档案主键
            $curl_return = $yongyou->u8cloudApi('客商基本档案分配', $custbasvo);
            dump($curl_return);
            // die;
            unset($u8cloud_data);
            unset($chin_add_data);
            unset($curl_return);
        }
        die;

        // 加盟店数据同步用友系统
        $list_data = DB::table('shop')
                ->where('shop_cid', $user_info['adm_cid'])
                ->where('shop_superior_id', $user_info['adm_shop_id'])
                ->select('shop_id', 'shop_store_name')
                ->get();
        dump($list_data);
        foreach ($list_data as $key => $value) {
            // 客商基本档案新增
            $u8cloud_data['cbdocvo'][0]['parentvo']['creator'] = config('apiu8cloud.pk_prepared');//否  创建人
            $u8cloud_data['cbdocvo'][0]['parentvo']['custcode'] = config('apiu8cloud.custcode.assignment').$user_info['adm_shop_id'].'MK'.$value->shop_id;//是 客商编码
            $u8cloud_data['cbdocvo'][0]['parentvo']['custname'] =$value->shop_store_name;//是 客商名称
            $u8cloud_data['cbdocvo'][0]['parentvo']['custprop'] ='0';//否 客商类型(0 - 外部单位,1 - 内部核算单位,2 - 内部法人单位,3 - 内部渠道成员)
            $u8cloud_data['cbdocvo'][0]['parentvo']['custshortname'] =$value->shop_store_name;//是    客商简称
            $u8cloud_data['cbdocvo'][0]['parentvo']['pk_areacl'] =config('apiu8cloud.SHOP_BASIC_SETUP')[$user_info['adm_shop_id']]['areaclcode'];//否   所属地区(填写编码)
            // $u8cloud_data['cbdocvo'][0]['parentvo']['mnecode'] =$value->chun_search_letter;//否 助记码
            // dump($u8cloud_data);die;
            // 调用u8系统接口
            $curl_return = $yongyou->u8cloudApi('客商基本档案新增', $u8cloud_data);
            dump($curl_return);
            // 判断用友接口返回的数据
            if ($curl_return['status'] != 'success') {
                $error_data[] = $value->shop_id;
                continue;
            }
            // 客户数据添加成功，分配客商到门店
            $curl_data = json_decode($curl_return['data'], true);
            // $chin_add_data['pk_cubasdoc'] = $curl_data[0]['parentvo']['pk_cubasdoc'];//客商基本档案主键--添加门店系统
            // $res = DB::table('channel_info')
            //     ->where('chin_chun_id', $value->chun_id)
            //     ->update($chin_add_data);
            // dump($res);
            $custbasvo['custbasvo'][0]['pk_corp'] = config('apiu8cloud.SHOP_BASIC_SETUP')[$user_info['adm_shop_id']]['pk_corp'];//公司主键
            $custbasvo['custbasvo'][0]['pk_cubasdoc'] =$curl_data[0]['parentvo']['pk_cubasdoc'];//客商基本档案主键
            $curl_return = $yongyou->u8cloudApi('客商基本档案分配', $custbasvo);
            dump($curl_return);
            // die;
            unset($u8cloud_data);
            unset($chin_add_data);
            unset($curl_return);
        }
        die;
        // 零售会员、临时会员、车主
        $other_data[0]['type'] = 1;//临时会员
        $other_data[0]['chun_id'] = 0;//临时会员
        $other_data[0]['chun_unit_name'] = '临时会员';//临时会员
        $other_data[0]['chun_search_letter'] = '';//临时会员
        $other_data[1]['type'] = 2;//会员零售
        $other_data[1]['chun_id'] = 1;//会员零售
        $other_data[1]['chun_unit_name'] = '会员零售';//会员零售
        $other_data[1]['chun_search_letter'] = '';//会员零售
        $other_data[2]['type'] = 3;//车主
        $other_data[2]['chun_id'] = 0;//车主
        $other_data[2]['chun_unit_name'] = '车主';//车主
        $other_data[2]['chun_search_letter'] = '';//车主
        $other_data[3]['type'] = 4;//第三方平台
        $other_data[3]['chun_id'] = 1;//第三方平台
        $other_data[3]['chun_unit_name'] = '速电平台';//第三方平台
        $other_data[3]['chun_search_letter'] = '';//第三方平台
        dump($other_data);
        // foreach ($other_data as $key => $value) {
        //     // 客商基本档案新增
        //     $u8cloud_data['cbdocvo'][0]['parentvo']['creator'] = config('apiu8cloud.pk_prepared');//否  创建人
        //     if ($value['type'] == 1) {
        //         $u8cloud_data['cbdocvo'][0]['parentvo']['custcode'] = config('apiu8cloud.custcode.temporary').$user_info['adm_shop_id'].'MK'.$value['chun_id'];//是 客商编码
        //     } elseif ($value['type'] == 2) {
        //         $u8cloud_data['cbdocvo'][0]['parentvo']['custcode'] = config('apiu8cloud.custcode.member').$user_info['adm_shop_id'].'MK'.$value['chun_id'];//是 客商编码
        //     } elseif ($value['type'] == 3) {
        //         $u8cloud_data['cbdocvo'][0]['parentvo']['custcode'] = config('apiu8cloud.custcode.owner').$user_info['adm_shop_id'].'MK'.$value['chun_id'];//是 客商编码
        //     } elseif ($value['type'] == 4) {
        //         $u8cloud_data['cbdocvo'][0]['parentvo']['custcode'] = config('apiu8cloud.custcode.platform').$user_info['adm_shop_id'].'MK'.$value['chun_id'];//是 客商编码
        //     }

        //     $u8cloud_data['cbdocvo'][0]['parentvo']['custname'] =$value['chun_unit_name'].config('apiu8cloud.SHOP_BASIC_SETUP')[$user_info['adm_shop_id']]['unitcode'];//是 客商名称
        //     $u8cloud_data['cbdocvo'][0]['parentvo']['custprop'] ='0';//否 客商类型(0 - 外部单位,1 - 内部核算单位,2 - 内部法人单位,3 - 内部渠道成员)
        //     $u8cloud_data['cbdocvo'][0]['parentvo']['custshortname'] =$value['chun_unit_name'];//是    客商简称
        //     $u8cloud_data['cbdocvo'][0]['parentvo']['pk_areacl'] =config('apiu8cloud.SHOP_BASIC_SETUP')[$user_info['adm_shop_id']]['areaclcode'];//否   所属地区(填写编码)
        //     $u8cloud_data['cbdocvo'][0]['parentvo']['mnecode'] =$value['chun_search_letter'];//否 助记码
        //     dump($u8cloud_data);
        //     // 调用u8系统接口
        //     $curl_return = $yongyou->u8cloudApi('客商基本档案新增', $u8cloud_data);
        //     dump($curl_return);
        //     // die;
        //     // 判断用友接口返回的数据
        //     if ($curl_return['status'] != 'success') {
        //         $error_data[] = $value['chun_id'];
        //         continue;
        //     }
        //     // // 客户数据添加成功，分配客商到门店
        //     $curl_data = json_decode($curl_return['data'], true);
        //     $custbasvo['custbasvo'][0]['pk_corp'] = config('apiu8cloud.SHOP_BASIC_SETUP')[$user_info['adm_shop_id']]['pk_corp'];//公司主键
        //     $custbasvo['custbasvo'][0]['pk_cubasdoc'] =$curl_data[0]['parentvo']['pk_cubasdoc'];//客商基本档案主键
        //     $curl_return = $yongyou->u8cloudApi('客商基本档案分配', $custbasvo);
        //     dump($curl_return);
        //     // die;
        //     unset($u8cloud_data);
        //     unset($chin_add_data);
        //     unset($curl_return);
        // }
        dump($error_data);
        die;
    }

    // 把用友系统集团的会计科目同步到门店
    public function syncSubject()
    {
        echo 888;
        die;
        $user_info['adm_cid'] = 1;
        $user_info['adm_shop_id'] = 1;//门店id
        $user_info['shop_id'] = 1;//总店id
        // 查询客户单位数据
        $list_data = DB::table('account_subject_base')
                ->get();
        // dump($list_data);
        // die;
        foreach ($list_data as $key => $value) {
            $add_data['acsu_cid'] = $user_info['adm_cid'];//公司id
            $add_data['acsu_shop_id'] = $user_info['adm_shop_id'];//门店id
            $add_data['acsu_shop_superior_id'] = $user_info['shop_id'];//总店id
            $add_data['acsu_adm_id'] = 0;//创建人id
            // $add_data['pk_corp'] = config('apiu8cloud.SHOP_BASIC_SETUP')[$user_info['adm_shop_id']]['unitcode'];//公司编码---后台查询
            $add_data['pk_corp'] = '0001';//公司编码---后台查询
            $add_data['subjcode'] = $value->subjcode;//科目编码
            $add_data['subjname'] = $value->subjname;//科目名称
            $add_data['dispname'] = $value->subjname;//显示名称
            $add_data['engsubjname'] = $value->engsubjname;//英文名称
            $add_data['balanorient'] = $value->balanorient;//余额方向 1:借2:贷
            $add_data['sealflag'] = $value->sealflag;//封存标志:封存日期；数据库存的是日期，页面显示 Y N
            $add_data['incurflag'] = $value->incurflag;//发生额方向控制取值：Y：是/N：否
            $add_data['balanflag'] = $value->balanflag;//余额方向控制取值：Y：是/N：否
            $add_data['bothorient'] = $value->bothorient;//帐簿余额双向显示取值：Y：是/N：否
            $add_data['innersubj'] = $value->innersubj;//内部交易科目取值：Y：是/N：否
            $add_data['accremove'] = $value->accremove;//是否核销科目取值：Y：是/N：否
            $add_data['cashbankflag'] = $value->cashbankflag;//现金银行科目 0:其他1:现金科目2:银行科目3:现金等价物
            $add_data['unit'] = $value->unit;//计量单位
            $add_data['outflag'] = $value->outflag;//表外科目取值：Y：是/N：否
            $add_data['remcode'] = $value->remcode;//助记码
            $add_data['subjlev'] = $value->subjlev;//科目级次
            $add_data['endflag'] = $value->endflag;//末级标志取值：Y：是/N：否；这个是计算的，后台判断这个科目是否是末级
            $add_data['innerinfonull'] = $value->innerinfonull;//内部交易信息是否必录取值：Y：是/N：否

            $add_data['currency'] = $value->currency;//科目默认币种，可以不选择,不选择就是null
            $add_data['beginyear'] = '2020';//启用年度，年 2020 四位
            $add_data['beginperiod'] = '06';//启用期间，月 06 两位
            $add_data['stoped'] = $value->stoped;//停用标志取值：Y：是/N：否
            $add_data['createyear'] = '2020';//创建年度
            $add_data['createperiod'] = '06';//创建月份
            $add_data['sumprint_level'] = $value->sumprint_level;//汇总打印级次 0末级 最大数量是科目级次数量
            $add_data['pk_subjscheme'] = '0001F8100000000001T1';//科目方案
            $add_data['pk_glorgbook'] = '0001F810000000000330';//会计主体账簿
            $add_data['pk_create_glorgbook'] = '0001F810000000000330';//创建会计主体账簿
            $add_data['acsu_bdin_id'] = $value->acsu_bdin_id;
            if (empty($value->acsu_bdin_id)) {
                $bdin_id = [
                    0=>[
                        "bdin_id" => $value->acsu_bdin_id, //辅助核算项主键id
                        "print_type" => 1, //是否汇总打印 1否2是
                        "balance_type" => 1, //是否余额方向控制 1否2是
                    ]
                ];
                $acsb_data['acss_bdinfo'] = json_encode($bdin_id);//辅助核算项json数据
            } else {
                $acsb_data['acss_bdinfo'] = '';
            }
            // dump($add_data);die;
            // $acsu_id =  DB::table('account_subject')->insertGetId($add_data);
            // dump($acsu_id);
            $acsb_data['acss_acsu_id'] = $acsu_id;
            $acsb_data['typeindex'] = $value->typeindex;
            // $acsb_res = DB::table('account_subject_sublist')->insert($acsb_data);
            // dump($acsb_res);

            unset($add_data);
            unset($acsb_data);
            unset($acsu_id);
            unset($acsb_res);
        }
    }

    // 入库
    public function warehousing($request)
    {
        die;
        try {
            $api_token = Crypt::decrypt($request['api_token']);
        } catch (\Exception $e) {
            return response()->json(["code"=>300,'msg'=>'error','data'=>'非法api_token']);
        }
        // 获取当前操作账号信息
        $userinfo = Common::getUserInfo($api_token);

        // $relation_number = ['RK870912172335753935', 'RK340912172502677681'];
        $relation_number = ['RK340912172502677681'];
        $storage_goods = DB::table('storage_goods')
            ->whereIn('relation_number', $relation_number)
            ->select('goods_id', 'goods_number', 'goods_num', 'univalence', 'ruku_num', 'old_univalence')
            ->get();
        $storage_goods = json_decode(json_encode($storage_goods), true);//将对象转换为数组
        dump($storage_goods);
        dump($userinfo);
        // die;
        $storage_goods = array_column($storage_goods, null, 'goods_id');
        $goods_price = array_column($storage_goods, 'univalence', 'goods_id');//商品id对应的采购金额
        $goods_id = array_column($storage_goods, 'goods_id');

        DB::beginTransaction();

        $goods_name = '';
        $cw_amount =0;  //应收总额
        $ruku_goods = [];//入库商品数组
        $actual_count = 0;//实际入库总数量
        foreach ($storage_goods as $key => $val) {
            $goo_actual_count[$val['goods_id']] = $val['ruku_num'];//进销存-商品id对应的实际入库的数量
            // 进销存
            $purchase_goo_id[$val['goods_id']] = $val['goods_id'];//进销存-商品id
            $purchase_goo_actual_count[$val['goods_id']] = $val['ruku_num'];//进销存-商品id对应的实际入库的数量
            $purchase_goo_actual_price[$val['goods_id']] = $val['univalence'];//进销存-商品id对应的实际入库的金额
            
            $actual_count += $val['ruku_num'];//实际入库总数量
        }
        DB::connection()->enableQueryLog();
        $cg_data['cg_wareid'] = 9;
        $cg_data['cg_waon_class'] = 1;
        // 2. 查询仓库的库存数量
        $find_waon = DB::table('warehouse_onhand')
            ->where('waon_ware_id', $cg_data['cg_wareid'])
            ->where('waon_class', $cg_data['cg_waon_class'])
            ->select('waon_id', 'waon_all_amount', 'waon_stock_fine_amount', 'waon_lock_fine_amount', 'waon_stock_priority_amount', 'waon_lock_priority_amount', 'waon_stock_unchecked_amount')
            ->first();
        // 更改仓库库存总数量
        $waon_data['waon_all_amount'] = $find_waon->waon_all_amount + $actual_count; //商品总库存
        $waon_data['waon_stock_fine_amount'] = $find_waon->waon_stock_fine_amount + $actual_count; //良品总库存
        $waon_res = DB::table('warehouse_onhand')
            ->where('waon_id', $find_waon->waon_id)
            ->update($waon_data);

        // 4.2 查询仓库商品库存数量
        $warehouse_goods = DB::table('warehouse_goods')
            ->where('wago_ware_id', $cg_data['cg_wareid'])
            ->where('wago_class', $cg_data['cg_waon_class'])
            ->whereIn('wago_goo_id', $goods_id)
            ->get(['wago_id', 'wago_stock_number', 'wago_goo_id']);
        $warehouse_goods = json_decode(json_encode($warehouse_goods), true);
        // dump($warehouse_goods);exit;
        // 4.3 处理要入库的商品库存数量
        if (empty($warehouse_goods)) {
            $ware_edit_res = true;
        } else {
            // 4.4 仓库商品表中已存在的商品，更改库存数量，整理更改SQL语句
            $sql = 'UPDATE `faster_warehouse_goods` SET ';
            $stock_number_sql = '';
            $update_time_sql = '';
            $ids = '';
            foreach ($warehouse_goods as $key => $value) {
                // 要更改的商品库存数量
                $stock_number = $value['wago_stock_number'] + $goo_actual_count[$value['wago_goo_id']];
                // 更改商品库存数量
                $stock_number_sql = $stock_number_sql . ' WHEN ' . $value['wago_id'];
                $stock_number_sql = $stock_number_sql . ' THEN ' . $stock_number;
                // 更改时间
                $update_time_sql = $update_time_sql . ' WHEN ' . $value['wago_id'];
                $update_time_sql = $update_time_sql . ' THEN "' . date('Y-m-d H:i:s') . '"';

                $ids = $ids . $value['wago_id'] . ',';

                // 删除已更改的商品数据
                unset($goo_actual_count[$value['wago_goo_id']]);
                $purg_goods_data[$value['wago_goo_id']]['wago_id'] = $value['wago_id'];//良品库存数量
            }

            if (!empty($stock_number_sql)) {
                $sql = $sql . ' `wago_stock_number`=  CASE `wago_id` ' . $stock_number_sql . ' END,';
                $sql = $sql . ' `wago_update_time`=  CASE `wago_id` ' . $update_time_sql . ' END';
                $sql = $sql . ' WHERE `wago_id` IN (' . trim($ids, ',') . ')';
                $ware_edit_res = DB::update($sql);
            } else {
                $ware_edit_res = true;
            }
        }
        
        if (empty($goo_actual_count)) {
            $ware_add_res = true;
        } else {
            // 4.5 仓库商品表中没有的商品，新增仓库商品
            foreach ($goo_actual_count as $key => $value) {
                $ware_add_data['wago_ware_id'] = $cg_data['cg_wareid'];
                $ware_add_data['wago_class'] = $cg_data['cg_waon_class'];
                $ware_add_data['wago_goo_id'] = $key;
                $ware_add_data['wago_stock_number'] = $value;
                $ware_add_res = DB::table('warehouse_goods')->insertGetId($ware_add_data);
                $purg_goods_data[$key]['wago_id'] = $ware_add_res;//商品库存id
            }
        }

        // 5.进销存
        // 查询仓库类别的进销存计算方式
        $algorithm_type = DB::table('warehouse_class')
            ->where('wacl_cid', $userinfo->adm_cid)
            ->where('wacl_shop_id', $userinfo->adm_shop_id)
            ->where('wacl_class_numerical', $cg_data['cg_waon_class'])
            ->value('wacl_sssa_id');
        $purchase_return = StockSellStorageGoods::purchaseSales(
            $userinfo,//用户信息
            $algorithm_type,//进销存计算方式：1先进先出2移动加权平均法3无成本
            1,//类型：1采购，2销出，3调拨
            $cg_data['cg_wareid'],//仓库id
            $cg_data['cg_waon_class'],//仓库类别
            $purchase_goo_id,//数组，商品id
            $purchase_goo_actual_count,//数组，商品数量；[商品id=>商品数量]
            $purchase_goo_actual_price, //数组，商品金额，成本价(不乘以100)；[商品id=>商品金额]
            1 //进销存的移动加权平均法算法类型：1计算平均价2不计算平均价【退换回收时不计算平均价】
        );
        if ($purchase_return['code'] == 500) {
            return ['code'=>500, 'msg'=>'error', 'data'=>'入库失败'];
        }
        // echo 222;die;
        if ($waon_res && $ware_edit_res && $ware_add_res) {
            echo 9999;
            DB::commit();
        } else {
            echo 888;
            DB::rollBack();
        }
    }

    // 厦门门店导入货物仓商品数据
    public function importProduct($submit_data, $data)
    {
        echo 99900;
        DB::beginTransaction();
        $cid = 1;//公司id
        $superior_shop_id = 90;//总店id
        $shop_id = 90;//门店id
        $goods_data = [];
        $defeated = [];
        // $dates = date('Y-m-d H:i:s');
        $dates = '2020-09-09 22:30:36';
        // try {
        //     $api_token = Crypt::decrypt($submit_data['api_token']);
        // } catch (\Exception $e) {
        //     return response()->json(["code"=>300,'msg'=>'error','data'=>'非法api_token']);
        // }

        // 获取当前操作账号信息
        // $user_info = Common::getUserInfo($api_token);
        $user_info = Common::getUserInfo($submit_data['api_token']);
        foreach ($data as $key => $value) {
            // dump($value);
            // die;
            // 品牌
            $bra_id = DB::table('brand')
                ->where('bra_cid', $cid)
                ->where('bra_shop_id', $shop_id)
                ->where('bra_superior_shop_id', $superior_shop_id)
                ->where('bra_delete', 1)
                ->where('bra_name', $value['goo_bra_name'])
                ->value('bra_id');
            if (empty($bra_id)) {
                $bra_data['bra_cid'] = $cid;
                $bra_data['bra_shop_id'] = $shop_id;
                $bra_data['bra_superior_shop_id'] = $superior_shop_id;
                $bra_data['bra_name'] = $value['goo_bra_name'];
                $bra_data['bra_create_time'] = $dates;
                $bra_data['bra_goods_number'] = 3;
                $bra_data['bra_update_time'] = $dates;
                $bra_id = DB::table('brand')->insertGetId($bra_data);
            } else {
                DB::table('brand')->where('bra_id', $bra_id)->increment('bra_goods_number', 3);
            }
            // 品类
            $cate_id = DB::table('category')
                ->where('cate_cid', $cid)
                ->where('cate_shop_id', $shop_id)
                ->where('cate_superior_shop_id', $superior_shop_id)
                ->where('cate_rank', 1)
                ->where('cate_delete', 1)
                ->where('cate_name', $value['goo_cate_name'])
                ->value('cate_id');
            if (empty($cate_id)) {
                $chty_data['cate_cid'] = $cid;
                $chty_data['cate_shop_id'] = $shop_id;
                $chty_data['cate_superior_shop_id'] = $superior_shop_id;
                $chty_data['cate_name'] = $value['goo_cate_name'];
                $chty_data['cate_create_time'] = $dates;
                $chty_data['cate_goods_number'] = 3;
                $chty_data['cate_rank'] = 1;
                $chty_data['cate_update_time'] = $dates;
                $cate_id = DB::table('category')->insertGetId($chty_data);
            } else {
                DB::table('category')->where('cate_id', $cate_id)->increment('cate_goods_number', 3);
            }
            // 系列
            if ($bra_id) {
                $brse_id = DB::table('brand_serie')
                    ->where('brse_cid', $cid)
                    ->where('brse_shop_id', $shop_id)
                    ->where('brse_superior_shop_id', $superior_shop_id)
                    ->where('brse_bra_id', $bra_id)
                    ->where('brse_name', $value['goo_brse_name'])
                    ->value('brse_id');
                if (empty($brse_id)) {
                    $brse_data['brse_cid'] = $cid;
                    $brse_data['brse_superior_shop_id'] = $superior_shop_id;
                    $brse_data['brse_shop_id'] = $shop_id;
                    $brse_data['brse_bra_id'] = $bra_id;
                    $brse_data['brse_name'] = $value['goo_brse_name'];
                    $brse_data['brse_goods_number'] = 3;
                    $brse_data['brse_class'] = 1;//类型1自营系列2系统系列
                    $brse_data['brse_cate_id'] = $cate_id;//一级品类id
                    $brse_data['brse_update_time'] = $dates;
                    $brse_id = DB::table('brand_serie')->insertGetId($brse_data);
                } else {
                    DB::table('brand_serie')->where('brse_id', $brse_id)->increment('brse_goods_number', 3);
                }
            }

            $info['goo_cid'] = $cid;
            $info['goo_superior_shop_id'] = $superior_shop_id;
            $info['goo_shop_id'] = $shop_id;
            $info['goo_bra_name'] = $value['goo_bra_name'];//品牌名称
            $info['goo_bra_id'] = $bra_id;//品牌id
            $info['goo_brse_id'] = $brse_id;//品牌系列id
            $info['goo_cate_name'] = $value['goo_cate_name'];
            $info['goo_cate_id'] = $cate_id;
            $info['goo_name'] = $value['goo_name'];
            $info['goo_goods_encode'] = $value['goo_goods_encode'];
            $info['goo_ampere_hour'] = $value['goo_ampere_hour'];
            $goo_wholesale_price = $value['goo_wholesale_price'] ? $value['goo_wholesale_price'] : 0;
            $goo_price = $value['goo_price'] ? $value['goo_price'] : 0;
            $goo_purchase_price = $value['chengben'] ? round($value['chengben'], 2) : 0;
            $info['goo_price'] = $goo_price * 100;
            $info['goo_wholesale_price'] = $goo_wholesale_price * 100;
            $info['goo_purchase_price'] = $goo_purchase_price * 100;
            $info['goo_update_time'] = $dates;
            $supplier = [];
            if (!empty($value['attr_guige']) && $value['attr_guige'] != 'NULL') {
                $supplier[] = ['key'=>'规格','value'=>$value['attr_guige']];
            }
            if (!empty($value['danwei']) && $value['danwei'] != 'NULL') {
                $supplier[] = ['key'=>'单位','value'=>$value['danwei']];
            }
            if (!empty($supplier)) {
                $info['goo_attribute'] = json_encode($supplier);
            } else {
                $info['goo_attribute'] = '';
            }
            if (!empty($value['goo_name'])) {
                // 判断商品是否存在
                $goo_id = DB::table('goods')
                    ->where('goo_cid', $cid)
                    ->where('goo_shop_id', $shop_id)
                    ->where('goo_superior_shop_id', $superior_shop_id)
                    ->where('goo_type', 1)
                    ->where('goo_delete', 1)
                    ->where('goo_goods_encode', $value['goo_goods_encode'])
                    ->value('goo_id');
                dump($goo_id);
                if (empty($goo_id)) {
                    $info['goo_type'] = 1;//商品类型 1正常商品2赠品商品3活动商品4旧货商品
                    $info['goo_fid'] = 0;
                    $info['goo_system_code'] = str_pad($cid, '4', '0', STR_PAD_RIGHT) . str_pad($shop_id, '5', '0', STR_PAD_RIGHT) . rand(10, 99) . rand(100000000, 999999999); //系统编码
                    $goo_id = DB::table('goods')->insertGetId($info);
                    // 活动商品
                    $acgo_data['acgo_cid'] = $cid;
                    $acgo_data['acgo_superior_shop_id'] = $shop_id;
                    $acgo_data['acgo_shop_id'] = $shop_id;
                    $acgo_data['acgo_goo_id'] = $goo_id;
                    $acgo_data['acgo_update_time'] = date('Y-m-d H:i:s');
                    $acgo_res = DB::table('activity_goods')->insertGetId($acgo_data);
                    // 添加赠品商品
                    $info['goo_type'] = 2;//1正常商品2赠品商品3活动商品4旧货商品
                    $info['goo_fid'] = $goo_id;
                    $info['goo_system_code'] = str_pad($cid, '4', '0', STR_PAD_RIGHT) . str_pad($shop_id, '5', '0', STR_PAD_RIGHT) . rand(10, 99) . rand(100000000, 999999999); //系统编码
                    $goaf_res = DB::table('goods')->insertGetId($info);
                    // 添加旧货商品
                    $info['goo_type'] = 4;//1正常商品2赠品商品3活动商品4旧货商品
                    $info['goo_fid'] = $goo_id;
                    $info['goo_system_code'] = str_pad($cid, '4', '0', STR_PAD_RIGHT) . str_pad($shop_id, '5', '0', STR_PAD_RIGHT) . rand(10, 99) . rand(100000000, 999999999); //系统编码
                    $junk_res = DB::table('goods')->insertGetId($info);
                } else {
                    // 商品数量
                    $num = 1;
                    $info['goo_type'] = 1;   //1正常商品2赠品商品3活动商品4旧货商品
                    $info['goo_update_time'] = $dates;
                    $res = DB::table('goods')
                        ->where('goo_type', 1)
                        ->where('goo_id', $goo_id)
                        ->update($info);
                    // 赠品商品
                    $goaf_goo_id = DB::table('goods')
                        ->where('goo_fid', $goo_id)
                        ->where('goo_type', 2)
                        ->value('goo_id');
                    if (!empty($goaf_goo_id)) {
                        $info['goo_type'] = 2;   //1正常商品2赠品商品3活动商品4旧货商品
                        $goaf_res = DB::table('goods')
                            ->where('goo_id', $goaf_goo_id)
                            ->update($info);
                    } else {
                        $num += 1;
                        $info['goo_type'] = 2;//1正常商品2赠品商品3活动商品4旧货商品
                        $info['goo_fid'] = $goo_id;
                        $info['goo_system_code'] = str_pad($cid, '4', '0', STR_PAD_RIGHT) . str_pad($shop_id, '5', '0', STR_PAD_RIGHT) . rand(10, 99) . rand(100000000, 999999999); //系统编码
                        $goaf_res = DB::table('goods')->insertGetId($info);
                    }
                    // 旧货商品
                    $junk_goo_id = DB::table('goods')
                        ->where('goo_fid', $goo_id)
                        ->where('goo_type', 4)
                        ->value('goo_id');
                    if (!empty($junk_goo_id)) {
                        $info['goo_type'] = 4;   //1正常商品2赠品商品3活动商品4旧货商品
                        $junk_res = DB::table('goods')
                            ->where('goo_id', $junk_goo_id)
                            ->update($info);
                    } else {
                        $num += 1;
                        $info['goo_type'] = 4;//1正常商品2赠品商品3活动商品4旧货商品
                        $info['goo_fid'] = $goo_id;
                        $info['goo_system_code'] = str_pad($cid, '4', '0', STR_PAD_RIGHT) . str_pad($shop_id, '5', '0', STR_PAD_RIGHT) . rand(10, 99) . rand(100000000, 999999999); //系统编码
                        $junk_res = DB::table('goods')->insertGetId($info);
                    }
                    $acgo_res = true;
                }
                
                unset($goo_id);
                unset($acgo_res);
                unset($goaf_res);
                unset($junk_res);
                unset($goo_id_arr);
                unset($purchase_goo_actual_count);
                unset($purchase_goo_actual_price);
                unset($ware_id);
                unset($purchase_return);
            }
            unset($bra_data);
            unset($bra_id);
            unset($chty_data);
            unset($cate_id);
            unset($info);
            unset($supplier);
        }
        echo 333;
        dump($defeated);
        DB::commit();
    }

    // 厦门门店导入货物仓商品数据
    public function newImportGoods($submit_data, $data)
    {
        echo 99900;
        DB::beginTransaction();
        $cid = 1;//公司id
        $superior_shop_id = 1;//总店id
        $shop_id = 1;//门店id
        $goods_data = [];
        $defeated = [];
        // $dates = date('Y-m-d H:i:s');
        $dates = date('Y-m-d H:i:s');
        // try {
        //     $api_token = Crypt::decrypt($submit_data['api_token']);
        // } catch (\Exception $e) {
        //     return response()->json(["code"=>300,'msg'=>'error','data'=>'非法api_token']);
        // }

        // 获取当前操作账号信息
        // $user_info = Common::getUserInfo($api_token);

        $user_info = Common::getUserInfo($submit_data['api_token']);

        $ware_id = 14;//仓库id
        // 查询发货单数据
        $find_dibi_data = DB::table('dispatch_bill')
            ->where('dego_cid', $cid)
            ->where('dego_shop_id', $shop_id)
            ->where('dego_create_time', '>', '2020-09-10 00:00:00')
            ->where('dego_out_ware_id', $ware_id)
            ->where('dego_type', 2)
            ->get()->toArray();
        $dego_id = array_column($find_dibi_data, 'dego_id');
        // 查询发货单商品数据
        $find_digo_goo_id = DB::table('dispatch_goods')
            ->whereIn('digo_dego_id', $dego_id)
            ->whereNotIn('digo_state', [2,3])
            ->where('digo_wago_class', 1)
            ->get()->toArray();
        $subtract = [];
        foreach ($find_digo_goo_id as $kk => $vv) {
            $subtract[$vv->digo_goo_id] += $vv->digo_goo_quantity;//商品数量
        }

        foreach ($data as $key => $value) {
            // dump($value);exit;
            $info['goo_goods_encode'] = $value['goo_goods_encode'];
            // 根据检索编码查询商品id
            $find_goo_id = DB::table('goods')
                ->where('goo_cid', $cid)
                ->where('goo_shop_id', $shop_id)
                ->where('goo_superior_shop_id', $superior_shop_id)
                ->where('goo_type', 1)
                ->where('goo_delete', 1)
                ->where('goo_goods_encode', $value['goo_goods_encode'])
                ->select('goo_id', 'goo_purchase_price', 'goo_goods_encode')
                ->first();
            // dump($find_goo_id);
            if (!empty($find_goo_id->goo_id)) {
                $goo_id = $find_goo_id->goo_id;
            } else {
                dump($value['goo_goods_encode']);
            }
            
            // 添加商品库存，查询仓库id
            if (empty($ware_id)) {
            } else {
                $value['hwcl'] = $value['hwcl'] ? $value['hwcl'] : 0;//库存数量
                //判断仓库里是否有此商品
                if (isset($subtract[$goo_id])) {
                    $stock_numbers = $value['hwcl'] - $subtract[$goo_id];//良品库存
                } else {
                    $stock_numbers = $value['hwcl'];//良品库存
                }
                $res = DB::table('warehouse_onhand')
                    ->where('waon_ware_id', $ware_id)
                    ->where('waon_class', 1)
                    ->increment('waon_all_amount', $stock_numbers);
                $res = DB::table('warehouse_onhand')
                    ->where('waon_ware_id', $ware_id)
                    ->where('waon_class', 1)
                    ->increment('waon_stock_fine_amount', $stock_numbers);
                if (empty($res)) {
                    $value['yuanyin'] = '仓库库存添加失败';
                    array_push($defeated, $value);
                    continue;
                }
                $wago_id= DB::table('warehouse_goods')
                    ->where('wago_ware_id', $ware_id)
                    ->where('wago_goo_id', $goo_id)
                    ->where('wago_class', 1)
                    ->value('wago_id');
                
                if (empty($wago_id)) {
                    // 仓库内没有商品，添加商品
                    $warehouse_goods['wago_ware_id'] = $ware_id;//仓库
                    $warehouse_goods['wago_class'] = 1;
                    $warehouse_goods['wago_goo_id'] = $goo_id;//商品
                    $warehouse_goods['wago_stock_number'] = $stock_numbers;//良品库存
                    $warehouse_goods['wago_update_time'] = $dates;//更新时间
                    $wago_res = DB::table('warehouse_goods')->insert($warehouse_goods);
                    if (empty($wago_res)) {
                        $value['yuanyin'] = '添加仓库商品失败';
                        array_push($defeated, $value);
                        continue;
                    }
                    unset($warehouse_goods);
                } else {
                    // 仓库内已经有商品了，更改库存数量
                    $edit_data['wago_stock_number'] = $stock_numbers;
                    $edit_data['wago_update_time'] = $dates;
                    $res= DB::table('warehouse_goods')
                        ->where('wago_ware_id', $ware_id)
                        ->where('wago_goo_id', $goo_id)
                        ->where('wago_class', 1)
                        ->update($edit_data);
                    dump($res);
                    if (empty($res)) {
                        $value['yuanyin'] = '修改仓库商品失败库存失败';
                        array_push($defeated, $value);
                        continue;
                    }
                }
                // 添加进销存
                $goo_id_arr[] = $goo_id;
                $purchase_goo_actual_count[$goo_id] = $stock_numbers;
                $purchase_goo_actual_price[$goo_id] = $find_goo_id->goo_purchase_price;
                $purchase_return = StockSellStorageGoods::purchaseSalesImport(
                    $user_info,//用户信息
                    2,//进销存计算方式：1先进先出2移动加权平均法3无成本
                    1,//类型：1采购，2销出，3调拨
                    $ware_id,//仓库id
                    1,//仓库类别
                    $goo_id_arr,//数组，商品id
                    $purchase_goo_actual_count,//数组，商品数量；[商品id=>商品数量]
                    $purchase_goo_actual_price, //数组，商品金额，成本价(不乘以100)；[商品id=>商品金额]
                    1 //进销存的移动加权平均法算法类型：1计算平均价2不计算平均价【退换回收时不计算平均价】
                );
            }
            unset($goo_id);
            unset($goo_id_arr);
            unset($purchase_goo_actual_count);
            unset($purchase_goo_actual_price);
            unset($purchase_return);
            unset($find_goo_id);
            unset($find_dibi_data);
            unset($info);
        }
        echo 333;
        dump($defeated);
        DB::commit();
    }

    // 厦门门店导入非商品仓商品数据
    public function newImportGoods2($submit_data, $data)
    {
        echo 99900;
        DB::beginTransaction();
        $cid = 1;//公司id
        $superior_shop_id = 1;//总店id
        $shop_id = 1;//门店id
        $goods_data = [];
        $defeated = [];
        $dates = date('Y-m-d H:i:s');
        // try {
        //     $api_token = Crypt::decrypt($submit_data['api_token']);
        // } catch (\Exception $e) {
        //     return response()->json(["code"=>300,'msg'=>'error','data'=>'非法api_token']);
        // }

        // 获取当前操作账号信息
        // $user_info = Common::getUserInfo($api_token);

        $user_info = Common::getUserInfo($submit_data['api_token']);

        $ware_id = 14;//仓库id
        // 查询发货单数据
        $find_dibi_data = DB::table('dispatch_bill')
            ->where('dego_cid', $cid)
            ->where('dego_shop_id', $shop_id)
            ->where('dego_create_time', '>', '2020-09-10 00:00:00')
            ->where('dego_out_ware_id', $ware_id)
            ->where('dego_type', 2)
            ->get()->toArray();
        $dego_id = array_column($find_dibi_data, 'dego_id');
        // 查询发货单商品数据
        $find_digo_goo_id = DB::table('dispatch_goods')
            ->whereIn('digo_dego_id', $dego_id)
            ->whereNotIn('digo_state', [2,3])
            ->where('digo_wago_class', 2)
            ->get()->toArray();
        $subtract = [];
        foreach ($find_digo_goo_id as $kk => $vv) {
            $subtract[$vv->digo_goo_id] += $vv->digo_goo_quantity;//商品数量
        }

        foreach ($data as $key => $value) {
            // dump($value);exit;
            $info['goo_goods_encode'] = $value['goo_goods_encode'];
            // 根据检索编码查询商品id
            $find_goo_id = DB::table('goods')
                ->where('goo_cid', $cid)
                ->where('goo_shop_id', $shop_id)
                ->where('goo_superior_shop_id', $superior_shop_id)
                ->where('goo_type', 2)
                ->where('goo_delete', 1)
                ->where('goo_goods_encode', $value['goo_goods_encode'])
                ->select('goo_id', 'goo_purchase_price')
                ->first();
            if (!empty($find_goo_id->goo_id)) {
                $goo_id = $find_goo_id->goo_id;
            } else {
                dump($value['goo_goods_encode']);
            }
            
            // 添加商品库存，查询仓库id
            if (empty($ware_id)) {
            } else {
                $value['feispcl'] = $value['feispcl'] ? $value['feispcl'] : 0;//库存数量
                //判断仓库里是否有此商品
                if (isset($subtract[$goo_id])) {
                    $stock_numbers = $value['feispcl'] - $subtract[$goo_id];//良品库存
                } else {
                    $stock_numbers = $value['feispcl'];//良品库存
                }
                $vis_data['waon_update_time'] = $dates;
                $res = DB::table('warehouse_onhand')
                    ->where('waon_ware_id', $ware_id)
                    ->where('waon_class', 2)
                    ->increment('waon_all_amount', $stock_numbers, $vis_data);
                $res = DB::table('warehouse_onhand')
                    ->where('waon_ware_id', $ware_id)
                    ->where('waon_class', 2)
                    ->increment('waon_stock_fine_amount', $stock_numbers, $vis_data);
                if (empty($res)) {
                    $value['yuanyin'] = '仓库库存添加失败2';
                    array_push($defeated, $value);
                    continue;
                }
                $wago_id= DB::table('warehouse_goods')
                    ->where('wago_ware_id', $ware_id)
                    ->where('wago_goo_id', $goo_id)
                    ->where('wago_class', 2)
                    ->value('wago_id');
                
                if (empty($wago_id)) {
                    // 仓库内没有商品，添加商品
                    $warehouse_goods['wago_ware_id'] = $ware_id;//仓库
                    $warehouse_goods['wago_class'] = 2;
                    $warehouse_goods['wago_goo_id'] = $goo_id;//商品
                    $warehouse_goods['wago_stock_number'] = $stock_numbers;//良品库存
                    $warehouse_goods['wago_update_time'] = $dates;//更新时间
                    $wago_res = DB::table('warehouse_goods')->insert($warehouse_goods);
                    if (empty($wago_res)) {
                        $value['yuanyin'] = '添加仓库商品失败1';
                        array_push($defeated, $value);
                        continue;
                    }
                    unset($warehouse_goods);
                } else {
                    // 仓库内已经有商品了，更改库存数量
                    $edit_data['wago_stock_number'] = $stock_numbers;
                    $edit_data['wago_update_time'] = $dates;
                    $res= DB::table('warehouse_goods')
                        ->where('wago_ware_id', $ware_id)
                        ->where('wago_goo_id', $goo_id)
                        ->where('wago_class', 2)
                        ->update($edit_data);
                    if (empty($res)) {
                        $value['yuanyin'] = '修改仓库商品失败库存失败2';
                        array_push($defeated, $value);
                        continue;
                    }
                }
                // 添加进销存
                $goo_id_arr[] = $goo_id;
                $purchase_goo_actual_count[$goo_id] = $stock_numbers;
                $purchase_goo_actual_price[$goo_id] = $find_goo_id->goo_purchase_price;
                $purchase_return = StockSellStorageGoods::purchaseSalesImport(
                    $user_info,//用户信息
                    2,//进销存计算方式：1先进先出2移动加权平均法3无成本
                    1,//类型：1采购，2销出，3调拨
                    $ware_id,//仓库id
                    2,//仓库类别
                    $goo_id_arr,//数组，商品id
                    $purchase_goo_actual_count,//数组，商品数量；[商品id=>商品数量]
                    $purchase_goo_actual_price, //数组，商品金额，成本价(不乘以100)；[商品id=>商品金额]
                    1 //进销存的移动加权平均法算法类型：1计算平均价2不计算平均价【退换回收时不计算平均价】
                );
            }
            unset($goo_id);
            unset($goo_id_arr);
            unset($purchase_goo_actual_count);
            unset($purchase_goo_actual_price);
            unset($purchase_return);
            unset($find_goo_id);
            unset($find_dibi_data);
            unset($info);
        }
        echo 333;
        dump($defeated);
        DB::commit();
    }

    // 厦门门店导入旧货仓良品商品数据
    public function newImportGoods3($submit_data, $data)
    {
        echo 99900;
        DB::beginTransaction();
        $cid = 1;//公司id
        $superior_shop_id = 1;//总店id
        $shop_id = 1;//门店id
        $goods_data = [];
        $defeated = [];
        $dates = date('Y-m-d H:i:s');
        // try {
        //     $api_token = Crypt::decrypt($submit_data['api_token']);
        // } catch (\Exception $e) {
        //     return response()->json(["code"=>300,'msg'=>'error','data'=>'非法api_token']);
        // }

        // 获取当前操作账号信息
        // $user_info = Common::getUserInfo($api_token);

        $user_info = Common::getUserInfo($submit_data['api_token']);

        $ware_id = 14;//仓库id
        // 查询发货单数据
        $find_dibi_data = DB::table('dispatch_bill')
            ->where('dego_cid', $cid)
            ->where('dego_shop_id', $shop_id)
            ->where('dego_create_time', '>', '2020-09-10 00:00:00')
            ->where('dego_out_ware_id', $ware_id)
            ->where('dego_type', 2)
            ->get()->toArray();
        $dego_id = array_column($find_dibi_data, 'dego_id');
        // 查询发货单商品数据
        $find_digo_goo_id = DB::table('dispatch_goods')
            ->whereIn('digo_dego_id', $dego_id)
            ->whereNotIn('digo_state', [2,3])
            ->where('digo_wago_class', 3)
            ->get()->toArray();
        $subtract = [];
        foreach ($find_digo_goo_id as $kk => $vv) {
            $subtract[$vv->digo_goo_id] += $vv->digo_goo_quantity;//商品数量
        }

        foreach ($data as $key => $value) {
            // dump($value);exit;
            $info['goo_goods_encode'] = $value['goo_goods_encode'];
            // 根据检索编码查询商品id
            $find_goo_id = DB::table('goods')
                ->where('goo_cid', $cid)
                ->where('goo_shop_id', $shop_id)
                ->where('goo_superior_shop_id', $superior_shop_id)
                ->where('goo_type', 4)
                ->where('goo_delete', 1)
                ->where('goo_goods_encode', $value['goo_goods_encode'])
                ->select('goo_id', 'goo_purchase_price')
                ->first();
            if (!empty($find_goo_id->goo_id)) {
                $goo_id = $find_goo_id->goo_id;
            } else {
                dump($value['goo_goods_encode']);
            }
            
            // 添加商品库存，查询仓库id
            if (empty($ware_id)) {
            } else {
                $value['jhcl'] = $value['jhcl'] ? $value['jhcl'] : 0;//库存数量
                //判断仓库里是否有此商品
                if (isset($subtract[$goo_id])) {
                    $stock_numbers = $value['jhcl'] - $subtract[$goo_id];//良品库存
                } else {
                    $stock_numbers = $value['jhcl'];//良品库存
                }
                $waon['waon_update_time'] = $dates;
                $res1 = DB::table('warehouse_onhand')
                    ->where('waon_ware_id', $ware_id)
                    ->where('waon_class', 3)
                    ->increment('waon_all_amount', $stock_numbers, $waon);
                $res2 = DB::table('warehouse_onhand')
                    ->where('waon_ware_id', $ware_id)
                    ->where('waon_class', 3)
                    ->increment('waon_stock_fine_amount', $stock_numbers, $waon);
                if (empty($res1) || empty($res2)) {
                    $value['yuanyin'] = '仓库库存添加失败11';
                    array_push($defeated, $value);
                    continue;
                }
                $wago_id= DB::table('warehouse_goods')
                    ->where('wago_ware_id', $ware_id)
                    ->where('wago_goo_id', $goo_id)
                    ->where('wago_class', 3)
                    ->value('wago_id');
                
                if (empty($wago_id)) {
                    // 仓库内没有商品，添加商品
                    $warehouse_goods['wago_ware_id'] = $ware_id;//仓库
                    $warehouse_goods['wago_class'] = 3;
                    $warehouse_goods['wago_goo_id'] = $goo_id;//商品
                    $warehouse_goods['wago_stock_number'] = $stock_numbers;//良品库存
                    $warehouse_goods['wago_update_time'] = $dates;//更新时间
                    $wago_res = DB::table('warehouse_goods')->insert($warehouse_goods);
                    if (empty($wago_res)) {
                        $value['yuanyin'] = '添加仓库商品失败';
                        array_push($defeated, $value);
                        continue;
                    }
                    unset($warehouse_goods);
                } else {
                    // 仓库内已经有商品了，更改库存数量
                    $edit_data['wago_stock_number'] = $stock_numbers;
                    $edit_data['wago_update_time'] = $dates;
                    $res= DB::table('warehouse_goods')
                        ->where('wago_ware_id', $ware_id)
                        ->where('wago_goo_id', $goo_id)
                        ->where('wago_class', 3)
                        ->update($edit_data);
                    if (empty($res)) {
                        $value['yuanyin'] = '修改仓库商品失败库存失败';
                        array_push($defeated, $value);
                        continue;
                    }
                }
                // 添加进销存
                $goo_id_arr[] = $goo_id;
                $purchase_goo_actual_count[$goo_id] = $stock_numbers;
                $purchase_goo_actual_price[$goo_id] = $find_goo_id->goo_purchase_price;
                $purchase_return = StockSellStorageGoods::purchaseSalesImport(
                    $user_info,//用户信息
                    2,//进销存计算方式：1先进先出2移动加权平均法3无成本
                    1,//类型：1采购，2销出，3调拨
                    $ware_id,//仓库id
                    3,//仓库类别
                    $goo_id_arr,//数组，商品id
                    $purchase_goo_actual_count,//数组，商品数量；[商品id=>商品数量]
                    $purchase_goo_actual_price, //数组，商品金额，成本价(不乘以100)；[商品id=>商品金额]
                    1 //进销存的移动加权平均法算法类型：1计算平均价2不计算平均价【退换回收时不计算平均价】
                );
            }
            unset($goo_id);
            unset($goo_id_arr);
            unset($purchase_goo_actual_count);
            unset($purchase_goo_actual_price);
            unset($purchase_return);
            unset($find_goo_id);
            unset($find_dibi_data);
            unset($info);
        }
        echo 333;
        dump($defeated);
        DB::commit();
    }

    // 厦门门店导入旧货仓优先商品数据
    public function newImportGoods4($submit_data, $data)
    {
        echo 99900;
        DB::beginTransaction();
        $cid = 1;//公司id
        $superior_shop_id = 1;//总店id
        $shop_id = 1;//门店id
        $goods_data = [];
        $defeated = [];
        $dates = date('Y-m-d H:i:s');
        // try {
        //     $api_token = Crypt::decrypt($submit_data['api_token']);
        // } catch (\Exception $e) {
        //     return response()->json(["code"=>300,'msg'=>'error','data'=>'非法api_token']);
        // }

        // 获取当前操作账号信息
        // $user_info = Common::getUserInfo($api_token);

        $user_info = Common::getUserInfo($submit_data['api_token']);

        $ware_id = 14;//仓库id
        // 查询发货单数据
        $find_dibi_data = DB::table('dispatch_bill')
            ->where('dego_cid', $cid)
            ->where('dego_shop_id', $shop_id)
            ->where('dego_create_time', '>', '2020-09-10 00:00:00')
            ->where('dego_out_ware_id', $ware_id)
            ->where('dego_type', 2)
            ->get()->toArray();
        $dego_id = array_column($find_dibi_data, 'dego_id');
        // 查询发货单商品数据
        $find_digo_goo_id = DB::table('dispatch_goods')
            ->whereIn('digo_dego_id', $dego_id)
            ->whereNotIn('digo_state', [2,3])
            ->where('digo_wago_class', 3)
            ->get()->toArray();
        $subtract = [];
        foreach ($find_digo_goo_id as $kk => $vv) {
            $subtract[$vv->digo_goo_id] += $vv->digo_goo_quantity;//商品数量
        }

        foreach ($data as $key => $value) {
            dump($value);
            exit;
            $info['goo_goods_encode'] = $value['goo_goods_encode'];
            // 根据检索编码查询商品id
            $find_goo_id = DB::table('goods')
                ->where('goo_cid', $cid)
                ->where('goo_shop_id', $shop_id)
                ->where('goo_superior_shop_id', $superior_shop_id)
                ->where('goo_type', 4)
                ->where('goo_delete', 1)
                ->where('goo_goods_encode', $value['goo_goods_encode'])
                ->select('goo_id', 'goo_purchase_price')
                ->first();
            if (!empty($find_goo_id->goo_id)) {
                $goo_id = $find_goo_id->goo_id;
            } else {
                dump($value['goo_goods_encode']);
            }
            
            // 添加商品库存，查询仓库id
            if (empty($ware_id)) {
            } else {
                $value['jhcy'] = $value['jhcy'] ? $value['jhcy'] : 0;//库存数量
                //判断仓库里是否有此商品
                if (isset($subtract[$goo_id])) {
                    $stock_numbers = $value['jhcy'] - $subtract[$goo_id];//良品库存
                } else {
                    $stock_numbers = $value['jhcy'];//良品库存
                }
                $res = DB::table('warehouse_onhand')
                    ->where('waon_ware_id', $ware_id)
                    ->where('waon_class', 3)
                    ->increment('waon_all_amount', $stock_numbers);
                $res = DB::table('warehouse_onhand')
                    ->where('waon_ware_id', $ware_id)
                    ->where('waon_class', 3)
                    ->increment('waon_stock_priority_amount', $stock_numbers);
                if (empty($res)) {
                    $value['yuanyin'] = '仓库库存添加失败333';
                    array_push($defeated, $value);
                    continue;
                }
                $wago_id= DB::table('warehouse_goods')
                    ->where('wago_ware_id', $ware_id)
                    ->where('wago_goo_id', $goo_id)
                    ->where('wago_class', 3)
                    ->value('wago_id');
                
                if (empty($wago_id)) {
                    // 仓库内没有商品，添加商品
                    $warehouse_goods['wago_ware_id'] = $ware_id;//仓库
                    $warehouse_goods['wago_class'] = 3;
                    $warehouse_goods['wago_goo_id'] = $goo_id;//商品
                    $warehouse_goods['wago_stock_number'] = $stock_numbers;//良品库存
                    $warehouse_goods['wago_update_time'] = $dates;//更新时间
                    $wago_res = DB::table('warehouse_goods')->insert($warehouse_goods);
                    if (empty($wago_res)) {
                        $value['yuanyin'] = '添加仓库商品失败';
                        array_push($defeated, $value);
                        continue;
                    }
                    unset($warehouse_goods);
                } else {
                    // 仓库内已经有商品了，更改库存数量
                    $edit_data['wago_stock_number'] = $stock_numbers;
                    $edit_data['wago_update_time'] = $dates;
                    $res= DB::table('warehouse_goods')
                        ->where('wago_ware_id', $ware_id)
                        ->where('wago_goo_id', $goo_id)
                        ->where('wago_class', 3)
                        ->update($edit_data);
                    if (empty($res)) {
                        $value['yuanyin'] = '修改仓库商品失败库存失败';
                        array_push($defeated, $value);
                        continue;
                    }
                }
                // 添加进销存
                $goo_id_arr[] = $goo_id;
                $purchase_goo_actual_count[$goo_id] = $stock_numbers;
                $purchase_goo_actual_price[$goo_id] = $find_goo_id->goo_purchase_price;
                $purchase_return = StockSellStorageGoods::purchaseSalesImport(
                    $user_info,//用户信息
                    1,//进销存计算方式：1先进先出2移动加权平均法3无成本
                    1,//类型：1采购，2销出，3调拨
                    $ware_id,//仓库id
                    3,//仓库类别
                    $goo_id_arr,//数组，商品id
                    $purchase_goo_actual_count,//数组，商品数量；[商品id=>商品数量]
                    $purchase_goo_actual_price, //数组，商品金额，成本价(不乘以100)；[商品id=>商品金额]
                    1 //进销存的移动加权平均法算法类型：1计算平均价2不计算平均价【退换回收时不计算平均价】
                );
            }
            unset($goo_id);
            unset($goo_id_arr);
            unset($purchase_goo_actual_count);
            unset($purchase_goo_actual_price);
            unset($purchase_return);
            unset($find_goo_id);
            unset($find_dibi_data);
            unset($info);
        }
        echo 333;
        dump($defeated);
        DB::commit();
    }

    // 厦门客户单位数据导入
    public function xmExcelChannel($submit_data, $data)
    {
        DB::beginTransaction();
        $cid = 1;//公司id
        $superior_shop_id = 1;//总店id
        $shop_id = 1;//门店id
        $new_data = [];
        $edit_data = [];
        $dates = date('Y-m-d H:i:s');
        // 获取当前操作账号信息
        foreach ($data as $key => $value) {
            // 单位类型
            $chty_id = DB::table('channel_type')
                ->where('chty_cid', $cid)
                ->where('chty_shop_id', $shop_id)
                ->where('chty_name', $value['chun_chty_id'])
                ->where('chty_delete', 1)
                ->value('chty_id');
            if (empty($chty_id)) {
                $chty_data['chty_cid'] = $cid;
                $chty_data['chty_superior_shop_id'] = $shop_id;
                $chty_data['chty_shop_id'] = $shop_id;
                $chty_data['chty_name'] = $value['chun_chty_id'];
                $chty_data['chty_channel_number'] = 1;
                $chty_data['chty_create_time'] = $dates;
                $chty_data['chty_update_time'] = $dates;
                $chty_id = DB::table('channel_type')->insertGetId($chty_data);
            } else {
                DB::table('channel_type')->where('chty_id', $chty_id)->increment('chty_channel_number');
            }

            $chun_adm_id = DB::table('admin')
                ->where('adm_cid', $cid)
                ->where('adm_phone', $value['chun_adm_name'])
                ->value('adm_id');
            if (empty($chun_adm_id)) {
                if ($value['chun_adm_id'] == '公司' || $value['chun_adm_name'] == '0592-5910086') {
                    $chun_adm_id = 99999;
                } else {
                    $adm_data['adm_cid'] = $cid;
                    $adm_data['adm_superior_shop_id'] = $superior_shop_id;
                    $adm_data['adm_shop_id'] = $shop_id;
                    $adm_data['adm_leave'] = 4;//级别1店长2普通员工3技师4业务员5技师和业务员
                    $adm_data['adm_phone'] = $value['chun_adm_name'];//手机号
                    $adm_data['adm_account'] = 'os'.time().rand(000, 999);//用户名
                    $adm_data['adm_password'] = md5($this->password.'faster123456');//登录密码
                    $adm_data['adm_name'] = $value['chun_adm_id'];//姓名名称
                    $adm_data['adm_role'] = 0;//角色id
                    $adm_data['adm_role_app'] = 0;//app角色id
                    $adm_data['adm_update_time'] = $dates;//更新时间
                    $chun_adm_id = DB::table('admin')->insertGetId($adm_data);
                }
            } else {
                $chun_adm_id = $chun_adm_id;
            }
            
            $supplier = [];
            if (!empty($value['chun_phone'])) {
                if (empty($value['chun_name'])) {
                    $value['chun_name'] = '无数据';
                }
                $supplier[] = ['key'=>$value['chun_name'], 'value'=>$value['chun_phone'], 'default'=>1];
            }
            if (!empty($value['chun_phones'])) {
                if (isset($value['chun_names'])) {
                    $value['chun_name'] = $value['chun_names'];
                } else {
                    $value['chun_name'] = $value['chun_name'];
                }
                $supplier[] = ['key'=>$value['chun_name'], 'value'=>$value['chun_phones'], 'default'=>2];
            }
            if (!empty($value['chun_phoness'])) {
                $supplier[] = ['key'=>$value['chun_name'], 'value'=>$value['chun_phones'], 'default'=>2];
            }
            if (!empty($supplier)) {
                $chin_data['chin_data'] = json_encode($supplier);
            } else {
                $chin_data['chin_data'] = '';
            }

            $chun_id = DB::table('channel_unit')
                ->where('chun_cid', $cid)
                ->where('chun_superior_shop_id', $superior_shop_id)
                ->where('chun_search_letter', $value['chun_search_letter'])
                ->value('chun_id');
            $info['chun_cid'] = $cid;
            $info['chun_superior_shop_id'] = $superior_shop_id;
            $info['chun_shop_id'] = $shop_id;
            $info['chun_adm_id'] = $chun_adm_id;//业务员账号id
            $info['chun_search_letter'] = $value['chun_search_letter'];//检索字母
            $info['chun_unit_name'] = $value['chun_unit_name'];//客户单位名称
            $info['chun_name'] = $value['chun_name'];//联系人姓名
            $info['chun_phone'] = $value['chun_phone'];//联系人电话
            $info['chun_chty_id'] = $chty_id;//单位类型id
            if ($value['chun_payment_way'] == '挂账' || $value['chun_payment_way'] == '挂张') {
                $info['chun_payment_way'] = 1;//结算方式1账期2现结
            } else {
                $info['chun_payment_way'] = 2;//结算方式1账期2现结
            }
            $info['chun_province'] = $value['chun_province'];//省
            $info['chun_city'] = $value['chun_city'];//市
            $info['chun_county'] = $value['chun_county'];//区县
            $info['chun_address'] = $value['chun_address'];//详细地址
            $info['chun_create_time'] = $dates;
            $info['chun_update_time'] = $dates;
            // dump($info);die;
            if (empty($chun_id)) {
                $res = DB::table('channel_unit')->insertGetId($info);
                if ($value['chun_adm_id'] == '公司' || $value['chun_adm_name'] == '0592-5910086') {
                    $new_data['chuc_chun_name'] = $value['chun_adm_id'];//姓名名称;
                    $new_data['chuc_chun_phone'] = $value['chun_adm_name'];//手机号
                } else {
                    $new_data['chuc_chun_name'] = '';//姓名名称;
                    $new_data['chuc_chun_phone'] = '';//手机号
                }
                $new_data['chuc_chun_id'] = $res;
                $new_data['chuc_chun_unit_name'] = $value['chun_unit_name'];//客户单位名称
                $new_data['chuc_update_time'] = $dates;
                // dump($res);die;
                if ($res) {
                    // 根据业务划区名称判断有没有业务划区
                    $prec_id = DB::table('precincts')
                        ->where('prec_cid', $cid)
                        ->where('prec_superior_shop_id', $superior_shop_id)
                        ->where('prec_name', $value['chun_zoning'])
                        ->value('prec_id');
                    if (empty($prec_id)) {
                        $prec_data['prec_cid'] = $cid;//所属企业
                        $prec_data['prec_superior_shop_id'] = $superior_shop_id;//总店id
                        $prec_data['prec_shop_id'] = $cid;//门店id
                        $prec_data['prec_region'] = 3;//大区名称
                        $prec_data['prec_province'] = $value['chun_province'];//省
                        $prec_data['prec_city'] = $value['chun_city'];//市
                        $prec_data['prec_county'] = $value['chun_county'];//县/区
                        $prec_data['prec_name'] = $value['chun_zoning'];
                        $prec_data['prec_update_time'] = $dates;
                        $prec_id = DB::table('precincts')->insertGetId($prec_data);
                    } else {
                        $prec_id = $prec_id;
                    }
                    $chin_data['chin_chun_id'] = $res;//客户单位id
                    $chin_data['chin_level'] = $value['chin_level'];//客户等级
                    $chin_data['chin_type'] = $value['chin_type'] == '是' ? 1 : 2;//铺货类型1是铺货2不是铺货
                    $chin_data['chin_owe_day'] = $value['chin_owe_day'];//可欠天数
                    $chin_data['chin_caution_day'] = $value['chin_caution_day'];//警示天数
                    $chin_data['chin_prec_id'] =$prec_id;//业务划区id
                    $chin_data['chin_zoning'] = $value['chun_zoning'];//业务划区名称
                    $chin_data['chin_remarks'] = $value['chin_remarks'];//备注
                    $chin_data['chin_update_time'] = $dates;
                    $chin_res = DB::table('channel_info')->insertGetId($chin_data);
                }
                $chuc_res = DB::table('channel_unit_change')->insertGetId($new_data);
                unset($new_data);
            } else {
                $edit_data['chuc_chun_id'] = $chun_id;
                // 判断客户单位名称是否存在
                $chun_unit_name = DB::table('channel_unit')
                    ->where('chun_cid', $cid)
                    ->where('chun_superior_shop_id', $superior_shop_id)
                    ->where('chun_search_letter', $value['chun_search_letter'])
                    ->value('chun_unit_name');
                if ($value['chun_adm_id'] == '公司' || $value['chun_adm_name'] == '0592-5910086') {
                    $edit_data['chuc_chun_name'] = $value['chun_adm_id'];//姓名名称;
                    $edit_data['chuc_chun_phone'] = $value['chun_adm_name'];//手机号
                } else {
                    $edit_data['chuc_chun_name'] = '';//姓名名称;
                    $edit_data['chuc_chun_phone'] = '';//手机号
                }
                if ($chun_unit_name != $info['chun_unit_name']) {
                    $edit_data['chuc_old_chun_unit_name'] = $chun_unit_name;//客户单位名称
                    $edit_data['chuc_chun_unit_name'] = $info['chun_unit_name'];//客户单位名称
                    $edit_data['chuc_type'] = 2;
                    $edit_data['chuc_update_time'] = $dates;
                    $chuc_res = DB::table('channel_unit_change')->insertGetId($edit_data);
                }
                $res = DB::table('channel_unit')
                    ->where('chun_id', $chun_id)
                    ->update($info);
                // dump($res);die;
                if ($chun_id) {
                    // 根据业务划区名称判断有没有业务划区
                    $prec_id = DB::table('precincts')
                        ->where('prec_cid', $cid)
                        ->where('prec_superior_shop_id', $superior_shop_id)
                        ->where('prec_name', $value['chun_zoning'])
                        ->value('prec_id');
                    if (empty($prec_id)) {
                        $prec_data['prec_cid'] = $cid;//所属企业
                        $prec_data['prec_superior_shop_id'] = $superior_shop_id;//总店id
                        $prec_data['prec_shop_id'] = $cid;//门店id
                        $prec_data['prec_region'] = 3;//大区名称
                        $prec_data['prec_province'] = $value['chun_province'];//省
                        $prec_data['prec_city'] = $value['chun_city'];//市
                        $prec_data['prec_county'] = $value['chun_county'];//县/区
                        $prec_data['prec_name'] = $value['chun_zoning'];
                        $prec_data['prec_update_time'] = $dates;
                        $prec_id = DB::table('precincts')->insertGetId($prec_data);
                    } else {
                        $prec_id = $prec_id;
                    }
                    $chin_data['chin_chun_id'] = $chun_id;//客户单位id
                    $chin_data['chin_level'] = $value['chin_level'];//客户等级
                    $chin_data['chin_type'] = $value['chin_type'];//铺货类型1是铺货2不是铺货
                    $chin_data['chin_owe_day'] = $value['chin_owe_day'];//可欠天数
                    $chin_data['chin_caution_day'] = $value['chin_caution_day'];//警示天数
                    $chin_data['chin_prec_id'] =$prec_id;//业务划区id
                    $chin_data['chin_zoning'] = $value['chun_zoning'];//业务划区名称
                    $chin_data['chin_remarks'] = $value['chin_remarks'];//备注
                    $chin_data['chin_update_time'] = $dates;
                    $chin_res = DB::table('channel_info')
                        ->where('chin_chun_id', $chun_id)
                        ->update($chin_data);
                }
                unset($edit_data);
            }

            // dump($res);die;
            unset($res);
            unset($info);
            unset($supplier);
            unset($chin_data);
            unset($chin_res);
            unset($prec_data);
            unset($chuc_res);
        }
        echo 333;
        DB::commit();
    }

    // 厦门门店导入货物仓商品数据
    public function himportGoods($submit_data, $data)
    {
        echo 99900;
        DB::beginTransaction();
        $cid = 1;//公司id
        $superior_shop_id = 1;//总店id
        $shop_id = 1;//门店id
        $goods_data = [];
        $defeated = [];
        // $dates = date('Y-m-d H:i:s');
        $dates = '2020-09-09 22:30:36';
        try {
            $api_token = Crypt::decrypt($submit_data['api_token']);
        } catch (\Exception $e) {
            return response()->json(["code"=>300,'msg'=>'error','data'=>'非法api_token']);
        }

        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($api_token);
        foreach ($data as $key => $value) {
            // dump($value);
            // die;
            // 品牌
            $bra_id = DB::table('brand')
                ->where('bra_cid', $cid)
                ->where('bra_shop_id', $shop_id)
                ->where('bra_superior_shop_id', $superior_shop_id)
                ->where('bra_delete', 1)
                ->where('bra_name', $value['goo_bra_name'])
                ->value('bra_id');
            if (empty($bra_id)) {
                $bra_data['bra_cid'] = $cid;
                $bra_data['bra_shop_id'] = $shop_id;
                $bra_data['bra_superior_shop_id'] = $superior_shop_id;
                $bra_data['bra_name'] = $value['goo_bra_name'];
                $bra_data['bra_create_time'] = $dates;
                $bra_data['bra_goods_number'] = 3;
                $bra_data['bra_update_time'] = $dates;
                $bra_id = DB::table('brand')->insertGetId($bra_data);
            } else {
                // DB::table('brand')->where('bra_id', $bra_id)->increment('bra_goods_number', 3);
            }
            // 品类
            $cate_id = DB::table('category')
                ->where('cate_cid', $cid)
                ->where('cate_shop_id', $shop_id)
                ->where('cate_superior_shop_id', $superior_shop_id)
                ->where('cate_rank', 1)
                ->where('cate_delete', 1)
                ->where('cate_name', $value['goo_cate_name'])
                ->value('cate_id');
            if (empty($cate_id)) {
                $chty_data['cate_cid'] = $cid;
                $chty_data['cate_shop_id'] = $shop_id;
                $chty_data['cate_superior_shop_id'] = $superior_shop_id;
                $chty_data['cate_name'] = $value['goo_cate_name'];
                $chty_data['cate_create_time'] = $dates;
                $chty_data['cate_goods_number'] = 3;
                $chty_data['cate_rank'] = 1;
                $chty_data['cate_update_time'] = $dates;
                $cate_id = DB::table('category')->insertGetId($chty_data);
            } else {
                // DB::table('category')->where('cate_id', $cate_id)->increment('cate_goods_number', 3);
            }
            // 系列
            if ($bra_id) {
                $brse_id = DB::table('brand_serie')
                    ->where('brse_cid', $cid)
                    ->where('brse_shop_id', $shop_id)
                    ->where('brse_superior_shop_id', $superior_shop_id)
                    ->where('brse_bra_id', $bra_id)
                    ->where('brse_name', $value['goo_brse_name'])
                    ->value('brse_id');
                if (empty($brse_id)) {
                    $brse_data['brse_cid'] = $cid;
                    $brse_data['brse_superior_shop_id'] = $superior_shop_id;
                    $brse_data['brse_shop_id'] = $shop_id;
                    $brse_data['brse_bra_id'] = $bra_id;
                    $brse_data['brse_name'] = $value['goo_brse_name'];
                    $brse_data['brse_goods_number'] = 3;
                    $brse_data['brse_class'] = 1;//类型1自营系列2系统系列
                    $brse_data['brse_cate_id'] = $cate_id;//一级品类id
                    $brse_data['brse_update_time'] = $dates;
                    $brse_id = DB::table('brand_serie')->insertGetId($brse_data);
                } else {
                    // DB::table('brand_serie')->where('brse_id', $brse_id)->increment('brse_goods_number', 3);
                }
            }

            $info['goo_cid'] = $cid;
            $info['goo_superior_shop_id'] = $superior_shop_id;
            $info['goo_shop_id'] = $shop_id;
            $info['goo_bra_name'] = $value['goo_bra_name'];//品牌名称
            $info['goo_bra_id'] = $bra_id;//品牌id
            $info['goo_brse_id'] = $brse_id;//品牌系列id
            $info['goo_cate_name'] = $value['goo_cate_name'];
            $info['goo_cate_id'] = $cate_id;
            $info['goo_name'] = $value['goo_name'];
            $info['goo_goods_encode'] = $value['goo_goods_encode'];
            $info['goo_ampere_hour'] = $value['goo_ampere_hour'];
            $goo_wholesale_price = $value['goo_wholesale_price'] ? $value['goo_wholesale_price'] : 0;
            $goo_price = $value['goo_price'] ? $value['goo_price'] : 0;
            $goo_purchase_price = $value['chengben'] ? round($value['chengben'], 2) : 0;
            $info['goo_price'] = $goo_price * 100;
            $info['goo_wholesale_price'] = $goo_wholesale_price * 100;
            $info['goo_purchase_price'] = $goo_purchase_price * 100;
            $info['goo_update_time'] = $dates;
            $supplier = [];
            if (!empty($value['attr_guige']) && $value['attr_guige'] != 'NULL') {
                $supplier[] = ['key'=>'规格','value'=>$value['attr_guige']];
            }
            if (!empty($value['danwei']) && $value['danwei'] != 'NULL') {
                $supplier[] = ['key'=>'单位','value'=>$value['danwei']];
            }
            if (!empty($supplier)) {
                $info['goo_attribute'] = json_encode($supplier);
            } else {
                $info['goo_attribute'] = '';
            }
            if (!empty($value['goo_name'])) {
                // 判断商品是否存在
                $goo_id = DB::table('goods')
                    ->where('goo_cid', $cid)
                    ->where('goo_shop_id', $shop_id)
                    ->where('goo_superior_shop_id', $superior_shop_id)
                    ->where('goo_type', 1)
                    ->where('goo_delete', 1)
                    ->where('goo_goods_encode', $value['goo_goods_encode'])
                    ->value('goo_id');
                dump($goo_id);
                if (empty($goo_id)) {
                    $info['goo_type'] = 1;//商品类型 1正常商品2赠品商品3活动商品4旧货商品
                    $info['goo_fid'] = 0;
                    $info['goo_system_code'] = str_pad($cid, '4', '0', STR_PAD_RIGHT) . str_pad($shop_id, '5', '0', STR_PAD_RIGHT) . rand(10, 99) . rand(100000000, 999999999); //系统编码
                    $goo_id = DB::table('goods')->insertGetId($info);
                    // 活动商品
                    $acgo_data['acgo_cid'] = $cid;
                    $acgo_data['acgo_superior_shop_id'] = $shop_id;
                    $acgo_data['acgo_shop_id'] = $shop_id;
                    $acgo_data['acgo_goo_id'] = $goo_id;
                    $acgo_data['acgo_update_time'] = date('Y-m-d H:i:s');
                    $acgo_res = DB::table('activity_goods')->insertGetId($acgo_data);
                    // 添加赠品商品
                    $info['goo_type'] = 2;//1正常商品2赠品商品3活动商品4旧货商品
                    $info['goo_fid'] = $goo_id;
                    $info['goo_system_code'] = str_pad($cid, '4', '0', STR_PAD_RIGHT) . str_pad($shop_id, '5', '0', STR_PAD_RIGHT) . rand(10, 99) . rand(100000000, 999999999); //系统编码
                    $goaf_res = DB::table('goods')->insertGetId($info);
                    // 添加旧货商品
                    $info['goo_type'] = 4;//1正常商品2赠品商品3活动商品4旧货商品
                    $info['goo_fid'] = $goo_id;
                    $info['goo_system_code'] = str_pad($cid, '4', '0', STR_PAD_RIGHT) . str_pad($shop_id, '5', '0', STR_PAD_RIGHT) . rand(10, 99) . rand(100000000, 999999999); //系统编码
                    $junk_res = DB::table('goods')->insertGetId($info);
                } else {
                    // 商品数量
                    $num = 1;
                    $info['goo_type'] = 1;   //1正常商品2赠品商品3活动商品4旧货商品
                    $info['goo_update_time'] = $dates;
                    $res = DB::table('goods')
                        ->where('goo_type', 1)
                        ->where('goo_id', $goo_id)
                        ->update($info);
                    // 赠品商品
                    $goaf_goo_id = DB::table('goods')
                        ->where('goo_fid', $goo_id)
                        ->where('goo_type', 2)
                        ->value('goo_id');
                    if (!empty($goaf_goo_id)) {
                        $info['goo_type'] = 2;   //1正常商品2赠品商品3活动商品4旧货商品
                        $goaf_res = DB::table('goods')
                            ->where('goo_id', $goaf_goo_id)
                            ->update($info);
                    } else {
                        $num += 1;
                        $info['goo_type'] = 2;//1正常商品2赠品商品3活动商品4旧货商品
                        $info['goo_fid'] = $goo_id;
                        $info['goo_system_code'] = str_pad($cid, '4', '0', STR_PAD_RIGHT) . str_pad($shop_id, '5', '0', STR_PAD_RIGHT) . rand(10, 99) . rand(100000000, 999999999); //系统编码
                        $goaf_res = DB::table('goods')->insertGetId($info);
                    }
                    // 旧货商品
                    $junk_goo_id = DB::table('goods')
                        ->where('goo_fid', $goo_id)
                        ->where('goo_type', 4)
                        ->value('goo_id');
                    if (!empty($junk_goo_id)) {
                        $info['goo_type'] = 4;   //1正常商品2赠品商品3活动商品4旧货商品
                        $junk_res = DB::table('goods')
                            ->where('goo_id', $junk_goo_id)
                            ->update($info);
                    } else {
                        $num += 1;
                        $info['goo_type'] = 4;//1正常商品2赠品商品3活动商品4旧货商品
                        $info['goo_fid'] = $goo_id;
                        $info['goo_system_code'] = str_pad($cid, '4', '0', STR_PAD_RIGHT) . str_pad($shop_id, '5', '0', STR_PAD_RIGHT) . rand(10, 99) . rand(100000000, 999999999); //系统编码
                        $junk_res = DB::table('goods')->insertGetId($info);
                    }
                    $acgo_res = true;
                }
                // 添加商品库存，查询仓库id
                $ware_id = 14;
                $value['kucun'] = 1000;
                if (empty($ware_id)) {
                } else {
                    if ($value['huowucang'] == '货物仓') {
                        $value['huowucang'] = 1;
                        $res = DB::table('warehouse_onhand')
                            ->where('waon_ware_id', $ware_id)
                            ->where('waon_class', $value['huowucang'])
                            ->increment('waon_all_amount', $value['kucun']);
                        $res = DB::table('warehouse_onhand')
                            ->where('waon_ware_id', $ware_id)
                            ->where('waon_class', $value['huowucang'])
                            ->increment('waon_stock_fine_amount', $value['kucun']);
                        if (empty($res)) {
                            $value['yuanyin'] = '仓库库存添加失败';
                            array_push($defeated, $value);
                            continue;
                        }
                        $wago_id= DB::table('warehouse_goods')
                            ->where('wago_ware_id', $ware_id)
                            ->where('wago_goo_id', $goo_id)
                            ->where('wago_class', $value['huowucang'])
                            ->value('wago_id');
                        //判断仓库里是否有此商品
                        if (empty($wago_id)) {
                            // 仓库内没有商品，添加商品
                            $warehouse_goods['wago_ware_id'] = $ware_id;//仓库
                            $warehouse_goods['wago_class'] = $value['huowucang'];
                            $warehouse_goods['wago_goo_id'] = $goo_id;//商品
                            $warehouse_goods['wago_stock_number'] = $value['kucun'];//良品库存
                            $warehouse_goods['wago_update_time'] = $dates;//更新时间
                            $wago_res = DB::table('warehouse_goods')->insert($warehouse_goods);
                            if (empty($wago_res)) {
                                $value['yuanyin'] = '添加仓库商品失败';
                                array_push($defeated, $value);
                                continue;
                            }
                            unset($warehouse_goods);
                        } else {
                            // 仓库内已经有商品了，更改库存数量
                            $res= DB::table('warehouse_goods')
                                ->where('wago_ware_id', $ware_id)
                                ->where('wago_goo_id', $goo_id)
                                ->where('wago_class', $value['huowucang'])
                                ->update(['wago_stock_number'=>$value['kucun'],'wago_update_time'=>$dates]);
                            if (empty($res)) {
                                $value['yuanyin'] = '修改仓库商品失败库存失败';
                                array_push($defeated, $value);
                                continue;
                            }
                        }
                        // 添加进销存
                        $goo_id_arr[] = $goo_id;
                        $purchase_goo_actual_count[$goo_id] = $value['kucun'];
                        $purchase_goo_actual_price[$goo_id] = $value['chengben'];
                        $purchase_return = StockSellStorageGoods::purchaseSalesImport(
                            $user_info,//用户信息
                            2,//进销存计算方式：1先进先出2移动加权平均法3无成本
                            1,//类型：1采购，2销出，3调拨
                            $ware_id,//仓库id
                            $value['huowucang'],//仓库类别
                            $goo_id_arr,//数组，商品id
                            $purchase_goo_actual_count,//数组，商品数量；[商品id=>商品数量]
                            $purchase_goo_actual_price, //数组，商品金额，成本价(不乘以100)；[商品id=>商品金额]
                            1 //进销存的移动加权平均法算法类型：1计算平均价2不计算平均价【退换回收时不计算平均价】
                        );
                    }
                }
                unset($goo_id);
                unset($acgo_res);
                unset($goaf_res);
                unset($junk_res);
                unset($goo_id_arr);
                unset($purchase_goo_actual_count);
                unset($purchase_goo_actual_price);
                unset($ware_id);
                unset($purchase_return);
            }
            unset($bra_data);
            unset($bra_id);
            unset($chty_data);
            unset($cate_id);
            unset($info);
            unset($supplier);
        }
        echo 333;
        dump($defeated);
        DB::commit();
    }

    // 厦门门店导入非货物仓商品数据
    public function nimportGoods($submit_data, $data)
    {
        DB::beginTransaction();
        $cid = 1;//公司id
        $superior_shop_id = 1;//总店id
        $shop_id = 1;//门店id
        $goods_data = [];
        $defeated = [];
        $dates = '2020-09-09 22:30:36';
        try {
            $api_token = Crypt::decrypt($submit_data['api_token']);
        } catch (\Exception $e) {
            return response()->json(["code"=>300,'msg'=>'error','data'=>'非法api_token']);
        }

        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($api_token);
        foreach ($data as $key => $value) {
            // 品牌
            $bra_id = DB::table('brand')
                ->where('bra_cid', $cid)
                ->where('bra_shop_id', $shop_id)
                ->where('bra_superior_shop_id', $superior_shop_id)
                ->where('bra_delete', 1)
                ->where('bra_name', $value['goo_bra_name'])
                ->value('bra_id');
            if (empty($bra_id)) {
                $bra_data['bra_cid'] = $cid;
                $bra_data['bra_shop_id'] = $shop_id;
                $bra_data['bra_superior_shop_id'] = $superior_shop_id;
                $bra_data['bra_name'] = $value['goo_bra_name'];
                $bra_data['bra_create_time'] = $dates;
                $bra_data['bra_goods_number'] = 3;
                $bra_data['bra_update_time'] = $dates;
                $bra_id = DB::table('brand')->insertGetId($bra_data);
            } else {
                // DB::table('brand')->where('bra_id', $bra_id)->increment('bra_goods_number', 3);
            }
            // 品类
            $cate_id = DB::table('category')
                ->where('cate_cid', $cid)
                ->where('cate_shop_id', $shop_id)
                ->where('cate_superior_shop_id', $superior_shop_id)
                ->where('cate_rank', 1)
                ->where('cate_delete', 1)
                ->where('cate_name', $value['goo_cate_name'])
                ->value('cate_id');
            if (empty($cate_id)) {
                $chty_data['cate_cid'] = $cid;
                $chty_data['cate_shop_id'] = $shop_id;
                $chty_data['cate_superior_shop_id'] = $superior_shop_id;
                $chty_data['cate_name'] = $value['goo_cate_name'];
                $chty_data['cate_create_time'] = $dates;
                $chty_data['cate_goods_number'] = 3;
                $chty_data['cate_update_time'] = $dates;
                $cate_id = DB::table('category')->insertGetId($chty_data);
            } else {
                // DB::table('category')->where('cate_id', $cate_id)->increment('cate_goods_number', 3);
            }
            // 系列
            if ($bra_id) {
                $brse_id = DB::table('brand_serie')
                    ->where('brse_cid', $cid)
                    ->where('brse_shop_id', $shop_id)
                    ->where('brse_superior_shop_id', $superior_shop_id)
                    ->where('brse_bra_id', $bra_id)
                    ->where('brse_name', $value['goo_brse_name'])
                    ->value('brse_id');
                if (empty($brse_id)) {
                    $brse_data['brse_cid'] = $cid;
                    $brse_data['brse_superior_shop_id'] = $superior_shop_id;
                    $brse_data['brse_shop_id'] = $shop_id;
                    $brse_data['brse_bra_id'] = $bra_id;
                    $brse_data['brse_name'] = $value['goo_brse_name'];
                    $brse_data['brse_goods_number'] = 3;
                    $brse_data['brse_class'] = 1;//类型1自营系列2系统系列
                    $brse_data['brse_cate_id'] = $cate_id;//一级品类id
                    $brse_data['brse_update_time'] = $dates;//一级品类id
                    $brse_id = DB::table('brand_serie')->insertGetId($brse_data);
                } else {
                    // DB::table('brand_serie')->where('brse_id', $brse_id)->increment('brse_goods_number', 3);
                }
            }

            $info['goo_cid'] = $cid;
            $info['goo_superior_shop_id'] = $superior_shop_id;
            $info['goo_shop_id'] = $shop_id;
            $info['goo_bra_name'] = $value['goo_bra_name'];//品牌名称
            $info['goo_bra_id'] = $bra_id;//品牌id
            $info['goo_brse_id'] = $brse_id;//品牌系列id
            $info['goo_cate_name'] = $value['goo_cate_name'];
            $info['goo_cate_id'] = $cate_id;
            $info['goo_name'] = $value['goo_name'];
            $info['goo_goods_encode'] = $value['goo_goods_encode'];
            $info['goo_ampere_hour'] = $value['goo_ampere_hour'];
            $goo_wholesale_price = $value['goo_wholesale_price'] ? $value['goo_wholesale_price'] : 0;
            $goo_purchase_price = $value['chengben'] ? round($value['chengben'], 2) : 0;
            $goo_price = $value['goo_price'] ? $value['goo_price'] : 0;
            $info['goo_price'] = $goo_price * 100;
            $info['goo_wholesale_price'] = $goo_wholesale_price * 100;
            $info['goo_purchase_price'] = $goo_purchase_price * 100;
            $info['goo_update_time'] = $dates;
            $supplier = [];
            if (!empty($value['attr_guige']) && $value['attr_guige'] != 'NULL') {
                $supplier[] = ['key'=>'规格','value'=>$value['attr_guige']];
            }
            if (!empty($value['danwei']) && $value['danwei'] != 'NULL') {
                $supplier[] = ['key'=>'单位','value'=>$value['danwei']];
            }
            if (!empty($supplier)) {
                $info['goo_attribute'] = json_encode($supplier);
            } else {
                $info['goo_attribute'] = '';
            }
            // 判断商品是否存在
            $goo_id = DB::table('goods')
                ->where('goo_cid', $cid)
                ->where('goo_shop_id', $shop_id)
                ->where('goo_superior_shop_id', $superior_shop_id)
                ->where('goo_type', 1)
                ->where('goo_delete', 1)
                ->where('goo_goods_encode', $value['goo_goods_encode'])
                ->value('goo_id');
            if (empty($goo_id)) {
                $info['goo_type'] = 1;//商品类型 1正常商品2赠品商品3活动商品4旧货商品
                $info['goo_fid'] = 0;
                $info['goo_system_code'] = str_pad($cid, '4', '0', STR_PAD_RIGHT) . str_pad($shop_id, '5', '0', STR_PAD_RIGHT) . rand(10, 99) . rand(100000000, 999999999); //系统编码
                $goo_id = DB::table('goods')->insertGetId($info);
                // 活动商品
                $acgo_data['acgo_cid'] = $cid;
                $acgo_data['acgo_superior_shop_id'] = $shop_id;
                $acgo_data['acgo_shop_id'] = $shop_id;
                $acgo_data['acgo_goo_id'] = $goo_id;
                $acgo_res = DB::table('activity_goods')->insertGetId($acgo_data);
                // 添加赠品商品
                $info['goo_type'] = 2;//1正常商品2赠品商品3活动商品4旧货商品
                $info['goo_fid'] = $goo_id;
                $info['goo_system_code'] = str_pad($cid, '4', '0', STR_PAD_RIGHT) . str_pad($shop_id, '5', '0', STR_PAD_RIGHT) . rand(10, 99) . rand(100000000, 999999999); //系统编码
                $goaf_res = DB::table('goods')->insertGetId($info);
                // 添加旧货商品
                $info['goo_type'] = 4;//1正常商品2赠品商品3活动商品4旧货商品
                $info['goo_fid'] = $goo_id;
                $info['goo_system_code'] = str_pad($cid, '4', '0', STR_PAD_RIGHT) . str_pad($shop_id, '5', '0', STR_PAD_RIGHT) . rand(10, 99) . rand(100000000, 999999999); //系统编码
                $junk_res = DB::table('goods')->insertGetId($info);
            } else {
                // 商品数量
                $num = 1;
                $info['goo_type'] = 1;   //1正常商品2赠品商品3活动商品4旧货商品
                $info['goo_update_time'] = $dates;
                $res = DB::table('goods')
                    ->where('goo_type', 1)
                    ->where('goo_id', $goo_id)
                    ->update($info);
                // 赠品商品
                $goaf_goo_id = DB::table('goods')
                    ->where('goo_fid', $goo_id)
                    ->where('goo_type', 2)
                    ->value('goo_id');
                if (!empty($goaf_goo_id)) {
                    $info['goo_type'] = 2;   //1正常商品2赠品商品3活动商品4旧货商品
                    $goaf_res = DB::table('goods')
                        ->where('goo_id', $goaf_goo_id)
                        ->update($info);
                } else {
                    $num += 1;
                    $info['goo_type'] = 2;//1正常商品2赠品商品3活动商品4旧货商品
                    $info['goo_fid'] = $goo_id;
                    $info['goo_system_code'] = str_pad($cid, '4', '0', STR_PAD_RIGHT) . str_pad($shop_id, '5', '0', STR_PAD_RIGHT) . rand(10, 99) . rand(100000000, 999999999); //系统编码
                    $goaf_res = DB::table('goods')->insertGetId($info);
                }
                // 旧货商品
                $junk_goo_id = DB::table('goods')
                    ->where('goo_fid', $goo_id)
                    ->where('goo_type', 4)
                    ->value('goo_id');
                if (!empty($junk_goo_id)) {
                    $info['goo_type'] = 4;   //1正常商品2赠品商品3活动商品4旧货商品
                    $junk_res = DB::table('goods')
                        ->where('goo_id', $junk_goo_id)
                        ->update($info);
                } else {
                    $num += 1;
                    $info['goo_type'] = 4;//1正常商品2赠品商品3活动商品4旧货商品
                    $info['goo_fid'] = $goo_id;
                    $info['goo_system_code'] = str_pad($cid, '4', '0', STR_PAD_RIGHT) . str_pad($shop_id, '5', '0', STR_PAD_RIGHT) . rand(10, 99) . rand(100000000, 999999999); //系统编码
                    $junk_res = DB::table('goods')->insertGetId($info);
                }
                $acgo_res = true;
            }
            $ware_id = 14;
            $value['kucun'] = 1000;
            if (empty($ware_id)) {
            } else {
                if ($value['feihuowucang'] == '非商品仓') {
                    $value['feihuowucang'] = 2;
                    $res = DB::table('warehouse_onhand')
                        ->where('waon_ware_id', $ware_id)
                        ->where('waon_class', $value['feihuowucang'])
                        ->increment('waon_all_amount', $value['kucun']);
                    $res = DB::table('warehouse_onhand')
                        ->where('waon_ware_id', $ware_id)
                        ->where('waon_class', $value['feihuowucang'])
                        ->increment('waon_stock_fine_amount', $value['kucun']);
                    if (empty($res)) {
                        $value['yuanyin'] = '仓库库存添加失败';
                        array_push($defeated, $value);
                        continue;
                    }
                    $wago_id= DB::table('warehouse_goods')
                        ->where('wago_ware_id', $ware_id)
                        ->where('wago_goo_id', $goo_id)
                        ->where('wago_class', $value['feihuowucang'])
                        ->value('wago_id');
                    //判断仓库里是否有此商品
                    if (empty($wago_id)) {
                        // 仓库内没有商品，添加商品
                        $warehouse_goods['wago_ware_id'] = $ware_id;//仓库
                        $warehouse_goods['wago_class'] = $value['feihuowucang'];
                        $warehouse_goods['wago_goo_id'] = $goo_id;//商品
                        $warehouse_goods['wago_stock_number'] = $value['kucun'];//良品库存
                        $wago_res = DB::table('warehouse_goods')->insert($warehouse_goods);
                        if (empty($wago_res)) {
                            $value['yuanyin'] = '添加仓库商品失败';
                            array_push($defeated, $value);
                            continue;
                        }
                        unset($warehouse_goods);
                    } else {
                        // 仓库内已经有商品了，更改库存数量
                        $res= DB::table('warehouse_goods')
                            ->where('wago_ware_id', $ware_id)
                            ->where('wago_goo_id', $goo_id)
                            ->where('wago_class', $value['feihuowucang'])
                            ->update(['wago_stock_number'=>$value['kucun'],'wago_update_time'=>date('Y-m-d H:i:s')]);
                        if (empty($res)) {
                            $value['yuanyin'] = '修改仓库商品失败库存失败';
                            array_push($defeated, $value);
                            continue;
                        }
                    }
                    // 添加进销存
                    $goo_id_arr[] = $goo_id;
                    $purchase_goo_actual_count[$goo_id] = $value['kucun'];
                    $purchase_goo_actual_price[$goo_id] = $value['chengben'];
                }
            }
            // echo 444;die;
            unset($goo_id);
            unset($acgo_res);
            unset($goaf_res);
            unset($junk_res);
            unset($goo_id_arr);
            // unset($purchase_goo_actual_count);
            // unset($purchase_goo_actual_price);
            // unset($ware_id);

            unset($bra_data);
            unset($bra_id);
            unset($chty_data);
            unset($cate_id);
            unset($info);
            unset($supplier);
        }
        echo 333;
        dump($defeated);
        DB::commit();
    }

    // 厦门门店导入旧货仓商品数据
    public function oldImportGoods($submit_data, $data)
    {
        DB::beginTransaction();
        $cid = 1;//公司id
        $superior_shop_id = 1;//总店id
        $shop_id = 1;//门店id
        $goods_data = [];
        $defeated = [];
        $dates = '2020-09-09 22:30:36';
        try {
            $api_token = Crypt::decrypt($submit_data['api_token']);
        } catch (\Exception $e) {
            return response()->json(["code"=>300,'msg'=>'error','data'=>'非法api_token']);
        }

        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($api_token);
        foreach ($data as $key => $value) {
            // dump($value);
            // die;
            // 品牌
            $bra_id = DB::table('brand')
                ->where('bra_cid', $cid)
                ->where('bra_shop_id', $shop_id)
                ->where('bra_superior_shop_id', $superior_shop_id)
                ->where('bra_delete', 1)
                ->where('bra_name', $value['goo_bra_name'])
                ->value('bra_id');
            if (empty($bra_id)) {
                $bra_data['bra_cid'] = $cid;
                $bra_data['bra_shop_id'] = $shop_id;
                $bra_data['bra_superior_shop_id'] = $superior_shop_id;
                $bra_data['bra_name'] = $value['goo_bra_name'];
                $bra_data['bra_create_time'] = $dates;
                $bra_data['bra_goods_number'] = 3;
                $bra_data['bra_update_time'] = $dates;
                $bra_id = DB::table('brand')->insertGetId($bra_data);
            } else {
                // DB::table('brand')->where('bra_id', $bra_id)->increment('bra_goods_number', 3);
            }
            // 品类
            $cate_id = DB::table('category')
                ->where('cate_cid', $cid)
                ->where('cate_shop_id', $shop_id)
                ->where('cate_superior_shop_id', $superior_shop_id)
                ->where('cate_rank', 1)
                ->where('cate_delete', 1)
                ->where('cate_name', $value['goo_cate_name'])
                ->value('cate_id');
            if (empty($cate_id)) {
                $chty_data['cate_cid'] = $cid;
                $chty_data['cate_shop_id'] = $shop_id;
                $chty_data['cate_superior_shop_id'] = $superior_shop_id;
                $chty_data['cate_name'] = $value['goo_cate_name'];
                $chty_data['cate_create_time'] = $dates;
                $chty_data['cate_goods_number'] = 3;
                $chty_data['cate_update_time'] = $dates;
                $cate_id = DB::table('category')->insertGetId($chty_data);
            } else {
                // DB::table('category')->where('cate_id', $cate_id)->increment('cate_goods_number', 3);
            }
            // 系列
            if ($bra_id) {
                $brse_id = DB::table('brand_serie')
                    ->where('brse_cid', $cid)
                    ->where('brse_shop_id', $shop_id)
                    ->where('brse_superior_shop_id', $superior_shop_id)
                    ->where('brse_bra_id', $bra_id)
                    ->where('brse_name', $value['goo_brse_name'])
                    ->value('brse_id');
                if (empty($brse_id)) {
                    $brse_data['brse_cid'] = $cid;
                    $brse_data['brse_superior_shop_id'] = $superior_shop_id;
                    $brse_data['brse_shop_id'] = $shop_id;
                    $brse_data['brse_bra_id'] = $bra_id;
                    $brse_data['brse_name'] = $value['goo_brse_name'];
                    $brse_data['brse_goods_number'] = 3;
                    $brse_data['brse_class'] = 1;//类型1自营系列2系统系列
                    $brse_data['brse_cate_id'] = $cate_id;//一级品类id
                    $brse_data['brse_update_time'] = $dates;//一级品类id
                    $brse_id = DB::table('brand_serie')->insertGetId($brse_data);
                } else {
                    // DB::table('brand_serie')->where('brse_id', $brse_id)->increment('brse_goods_number', 3);
                }
            }

            $info['goo_cid'] = $cid;
            $info['goo_superior_shop_id'] = $superior_shop_id;
            $info['goo_shop_id'] = $shop_id;
            $info['goo_bra_name'] = $value['goo_bra_name'];//品牌名称
            $info['goo_bra_id'] = $bra_id;//品牌id
            $info['goo_brse_id'] = $brse_id;//品牌系列id
            $info['goo_cate_name'] = $value['goo_cate_name'];
            $info['goo_cate_id'] = $cate_id;
            $info['goo_name'] = $value['goo_name'];
            $info['goo_goods_encode'] = $value['goo_goods_encode'];
            $info['goo_ampere_hour'] = $value['goo_ampere_hour'];
            $goo_wholesale_price = $value['goo_wholesale_price'] ? $value['goo_wholesale_price'] : 0;
            $goo_purchase_price = $value['chengben'] ? round($value['chengben'], 2) : 0;
            $goo_price = $value['goo_price'] ? $value['goo_price'] : 0;
            $info['goo_price'] = $goo_price * 100;
            $info['goo_wholesale_price'] = $goo_wholesale_price * 100;
            $info['goo_purchase_price'] = $goo_purchase_price * 100;
            $info['goo_update_time'] = $dates;
            $supplier = [];
            if (!empty($value['attr_guige']) && $value['attr_guige'] != 'NULL') {
                $supplier[] = ['key'=>'规格','value'=>$value['attr_guige']];
            }
            if (!empty($value['danwei']) && $value['danwei'] != 'NULL') {
                $supplier[] = ['key'=>'单位','value'=>$value['danwei']];
            }
            if (!empty($supplier)) {
                $info['goo_attribute'] = json_encode($supplier);
            } else {
                $info['goo_attribute'] = '';
            }
            if (!empty($value['goo_name'])) {
                // 判断商品是否存在
                $goo_id = DB::table('goods')
                    ->where('goo_cid', $cid)
                    ->where('goo_shop_id', $shop_id)
                    ->where('goo_superior_shop_id', $superior_shop_id)
                    ->where('goo_type', 1)
                    ->where('goo_delete', 1)
                    ->where('goo_goods_encode', $value['goo_goods_encode'])
                    ->value('goo_id');
                if (empty($goo_id)) {
                    $info['goo_type'] = 1;//商品类型 1正常商品2赠品商品3活动商品4旧货商品
                    $info['goo_fid'] = 0;
                    $info['goo_system_code'] = str_pad($cid, '4', '0', STR_PAD_RIGHT) . str_pad($shop_id, '5', '0', STR_PAD_RIGHT) . rand(10, 99) . rand(100000000, 999999999); //系统编码
                    $goo_id = DB::table('goods')->insertGetId($info);
                    // 活动商品
                    $acgo_data['acgo_cid'] = $cid;
                    $acgo_data['acgo_superior_shop_id'] = $shop_id;
                    $acgo_data['acgo_shop_id'] = $shop_id;
                    $acgo_data['acgo_goo_id'] = $goo_id;
                    $acgo_res = DB::table('activity_goods')->insertGetId($acgo_data);
                    // 添加赠品商品
                    $info['goo_type'] = 2;//1正常商品2赠品商品3活动商品4旧货商品
                    $info['goo_fid'] = $goo_id;
                    $info['goo_system_code'] = str_pad($cid, '4', '0', STR_PAD_RIGHT) . str_pad($shop_id, '5', '0', STR_PAD_RIGHT) . rand(10, 99) . rand(100000000, 999999999); //系统编码
                    $goaf_res = DB::table('goods')->insertGetId($info);
                    // 添加旧货商品
                    $info['goo_type'] = 4;//1正常商品2赠品商品3活动商品4旧货商品
                    $info['goo_fid'] = $goo_id;
                    $info['goo_system_code'] = str_pad($cid, '4', '0', STR_PAD_RIGHT) . str_pad($shop_id, '5', '0', STR_PAD_RIGHT) . rand(10, 99) . rand(100000000, 999999999); //系统编码
                    $junk_res = DB::table('goods')->insertGetId($info);
                } else {
                    // 商品数量
                    $num = 1;
                    $info['goo_type'] = 1;   //1正常商品2赠品商品3活动商品4旧货商品
                    $info['goo_update_time'] = $dates;
                    $res = DB::table('goods')
                        ->where('goo_type', 1)
                        ->where('goo_id', $goo_id)
                        ->update($info);
                    // 赠品商品
                    $goaf_goo_id = DB::table('goods')
                        ->where('goo_fid', $goo_id)
                        ->where('goo_type', 2)
                        ->value('goo_id');
                    if (!empty($goaf_goo_id)) {
                        $info['goo_type'] = 2;   //1正常商品2赠品商品3活动商品4旧货商品
                        $goaf_res = DB::table('goods')
                            ->where('goo_id', $goaf_goo_id)
                            ->update($info);
                    } else {
                        $num += 1;
                        $info['goo_type'] = 2;//1正常商品2赠品商品3活动商品4旧货商品
                        $info['goo_fid'] = $goo_id;
                        $info['goo_system_code'] = str_pad($cid, '4', '0', STR_PAD_RIGHT) . str_pad($shop_id, '5', '0', STR_PAD_RIGHT) . rand(10, 99) . rand(100000000, 999999999); //系统编码
                        $goaf_res = DB::table('goods')->insertGetId($info);
                    }
                    // 旧货商品
                    $junk_goo_id = DB::table('goods')
                        ->where('goo_fid', $goo_id)
                        ->where('goo_type', 4)
                        ->value('goo_id');
                    if (!empty($junk_goo_id)) {
                        $info['goo_type'] = 4;   //1正常商品2赠品商品3活动商品4旧货商品
                        $junk_res = DB::table('goods')
                            ->where('goo_id', $junk_goo_id)
                            ->update($info);
                    } else {
                        $num += 1;
                        $info['goo_type'] = 4;//1正常商品2赠品商品3活动商品4旧货商品
                        $info['goo_fid'] = $goo_id;
                        $info['goo_system_code'] = str_pad($cid, '4', '0', STR_PAD_RIGHT) . str_pad($shop_id, '5', '0', STR_PAD_RIGHT) . rand(10, 99) . rand(100000000, 999999999); //系统编码
                        $junk_res = DB::table('goods')->insertGetId($info);
                    }
                    $acgo_res = true;
                }
                
                $ware_id = 14;
                $value['kucun'] = 1000;
                if (empty($ware_id)) {
                } else {
                    if ($value['jiuhuocang'] == '旧货仓') {
                        $value['jiuhuocang'] = 3;
                        $res = DB::table('warehouse_onhand')
                            ->where('waon_ware_id', $ware_id)
                            ->where('waon_class', $value['jiuhuocang'])
                            ->increment('waon_all_amount', $value['kucun']);
                        $res = DB::table('warehouse_onhand')
                            ->where('waon_ware_id', $ware_id)
                            ->where('waon_class', $value['jiuhuocang'])
                            ->increment('waon_stock_fine_amount', $value['kucun']);
                        if (empty($res)) {
                            $value['yuanyin'] = '仓库库存添加失败';
                            array_push($defeated, $value);
                            continue;
                        }
                        $wago_id= DB::table('warehouse_goods')
                            ->where('wago_ware_id', $ware_id)
                            ->where('wago_goo_id', $goo_id)
                            ->where('wago_class', $value['jiuhuocang'])
                            ->value('wago_id');
                        //判断仓库里是否有此商品
                        if (empty($wago_id)) {
                            // 仓库内没有商品，添加商品
                            $warehouse_goods['wago_ware_id'] = $ware_id;//仓库
                            $warehouse_goods['wago_class'] = $value['jiuhuocang'];
                            $warehouse_goods['wago_goo_id'] = $goo_id;//商品
                            $warehouse_goods['wago_stock_number'] = $value['kucun'];//良品库存
                            $wago_res = DB::table('warehouse_goods')->insert($warehouse_goods);
                            if (empty($wago_res)) {
                                $value['yuanyin'] = '添加仓库商品失败';
                                array_push($defeated, $value);
                                continue;
                            }
                            unset($warehouse_goods);
                        } else {
                            // 仓库内已经有商品了，更改库存数量
                            $res= DB::table('warehouse_goods')
                                ->where('wago_ware_id', $ware_id)
                                ->where('wago_goo_id', $goo_id)
                                ->where('wago_class', $value['jiuhuocang'])
                                ->update(['wago_stock_number'=>$value['kucun'],'wago_update_time'=>date('Y-m-d H:i:s')]);
                            if (empty($res)) {
                                $value['yuanyin'] = '修改仓库商品失败库存失败';
                                array_push($defeated, $value);
                                continue;
                            }
                        }
                        // dump($info);
                        // dump($value);
                        // 添加进销存
                        $goo_id_arr[] = $goo_id;
                        $purchase_goo_actual_count[$goo_id] = $value['kucun'];
                        $purchase_goo_actual_price[$goo_id] = $value['chengben'];
                        $purchase_return = StockSellStorageGoods::purchaseSalesImport(
                            $user_info,//用户信息
                            1,//进销存计算方式：1先进先出2移动加权平均法3无成本
                            1,//类型：1采购，2销出，3调拨
                            $ware_id,//仓库id
                            $value['jiuhuocang'],//仓库类别
                            $goo_id_arr,//数组，商品id
                            $purchase_goo_actual_count,//数组，商品数量；[商品id=>商品数量]
                            $purchase_goo_actual_price, //数组，商品金额，成本价(不乘以100)；[商品id=>商品金额]
                            1 //进销存的移动加权平均法算法类型：1计算平均价2不计算平均价【退换回收时不计算平均价】
                        );
                        // dump($purchase_return);die;
                    }
                }
                // echo 444;die;
                unset($goo_id);
                unset($acgo_res);
                unset($goaf_res);
                unset($junk_res);
                unset($goo_id_arr);
                unset($purchase_goo_actual_count);
                unset($purchase_goo_actual_price);
                unset($ware_id);
            }
            // echo 888;die;
            unset($bra_data);
            unset($bra_id);
            unset($chty_data);
            unset($cate_id);
            unset($info);
            unset($supplier);
        }
        echo 333;
        dump($defeated);
        DB::commit();
    }

    // 超1年未合作且有欠款的客户
    public function almostExcelChannel($submit_data, $data)
    {
        DB::beginTransaction();
        $cid = 1;//公司id
        $superior_shop_id = 1;//总店id
        $shop_id = 1;//门店id
        $new_data = [];
        $edit_data = [];
        // 获取当前操作账号信息
        foreach ($data as $key => $value) {
            // 单位类型
            $chty_id = DB::table('channel_type')
                ->where('chty_cid', $cid)
                ->where('chty_shop_id', $shop_id)
                ->where('chty_name', $value['chun_chty_id'])
                ->where('chty_delete', 1)
                ->value('chty_id');
            if (empty($chty_id)) {
                $chty_data['chty_cid'] = $cid;
                $chty_data['chty_superior_shop_id'] = $shop_id;
                $chty_data['chty_shop_id'] = $shop_id;
                $chty_data['chty_name'] = $value['chun_chty_id'];
                $chty_data['chty_channel_number'] = 1;
                $chty_data['chty_create_time'] = date('Y-m-d H:i:s');
                $chty_data['chty_update_time'] = date('Y-m-d H:i:s');
                $chty_id = DB::table('channel_type')->insertGetId($chty_data);
            } else {
                DB::table('channel_type')->where('chty_id', $chty_id)->increment('chty_channel_number');
            }

            $chun_adm_id = DB::table('admin')
                ->where('adm_cid', $cid)
                ->where('adm_phone', $value['chun_adm_name'])
                ->value('adm_id');
            if (empty($chun_adm_id)) {
                if ($value['chun_adm_id'] == '公司' || $value['chun_adm_name'] == '0592-5910086') {
                    $chun_adm_id = 99999;
                } else {
                    $adm_data['adm_cid'] = $cid;
                    $adm_data['adm_superior_shop_id'] = $superior_shop_id;
                    $adm_data['adm_shop_id'] = $shop_id;
                    $adm_data['adm_leave'] = 4;//级别1店长2普通员工3技师4业务员5技师和业务员
                    $adm_data['adm_phone'] = $value['chun_adm_name'];//手机号
                    $adm_data['adm_account'] = 'os'.time().rand(000, 999);//用户名
                    $adm_data['adm_password'] = md5($this->password.'faster123456');//登录密码
                    $adm_data['adm_name'] = $value['chun_adm_id'];//姓名名称
                    $adm_data['adm_role'] = 0;//角色id
                    $adm_data['adm_role_app'] = 0;//app角色id
                    $adm_data['adm_update_time'] = date('Y-m-d H:i:s');
                    $chun_adm_id = DB::table('admin')->insertGetId($adm_data);
                }
            } else {
                $chun_adm_id = $chun_adm_id;
            }
            
            $supplier = [];
            if (!empty($value['chun_phone'])) {
                if (empty($value['chun_name'])) {
                    $value['chun_name'] = '无数据';
                }
                $supplier[] = ['key'=>$value['chun_name'], 'value'=>$value['chun_phone'], 'default'=>1];
            }
            if (!empty($value['chun_phones'])) {
                if (isset($value['chun_names'])) {
                    $value['chun_name'] = $value['chun_names'];
                } else {
                    $value['chun_name'] = $value['chun_name'];
                }
                $supplier[] = ['key'=>$value['chun_name'], 'value'=>$value['chun_phones'], 'default'=>2];
            }
            if (!empty($value['chun_phoness'])) {
                $supplier[] = ['key'=>$value['chun_name'], 'value'=>$value['chun_phones'], 'default'=>2];
            }
            if (!empty($supplier)) {
                $chin_data['chin_data'] = json_encode($supplier);
            } else {
                $chin_data['chin_data'] = '';
            }

            $chun_id = DB::table('channel_unit')
                ->where('chun_cid', $cid)
                ->where('chun_superior_shop_id', $superior_shop_id)
                ->where('chun_search_letter', $value['chun_search_letter'])
                ->value('chun_id');
            $info['chun_cid'] = $cid;
            $info['chun_superior_shop_id'] = $superior_shop_id;
            $info['chun_shop_id'] = $shop_id;
            $info['chun_adm_id'] = $chun_adm_id;//业务员账号id
            $info['chun_search_letter'] = $value['chun_search_letter'];//检索字母
            $info['chun_unit_name'] = $value['chun_unit_name'];//客户单位名称
            $info['chun_name'] = $value['chun_name'];//联系人姓名
            $info['chun_phone'] = $value['chun_phone'];//联系人电话
            $info['chun_chty_id'] = $chty_id;//单位类型id
            if ($value['chun_payment_way'] == '挂账' || $value['chun_payment_way'] == '挂张') {
                $info['chun_payment_way'] = 1;//结算方式1账期2现结
            } else {
                $info['chun_payment_way'] = 2;//结算方式1账期2现结
            }
            $info['chun_province'] = $value['chun_province'];//省
            $info['chun_city'] = $value['chun_city'];//市
            $info['chun_county'] = $value['chun_county'];//区县
            $info['chun_address'] = $value['chun_address'];//详细地址
            $info['chun_create_time'] = date('Y-m-d H:i:s');
            // dump($info);die;
            if (empty($chun_id)) {
                $info['chun_update_time'] = date('Y-m-d H:i:s');
                $res = DB::table('channel_unit')->insertGetId($info);
                if ($value['chun_adm_id'] == '公司' || $value['chun_adm_name'] == '0592-5910086') {
                    $new_data['chuc_chun_name'] = $value['chun_adm_id'];//姓名名称;
                    $new_data['chuc_chun_phone'] = $value['chun_adm_name'];//手机号
                } else {
                    $new_data['chuc_chun_name'] = '';//姓名名称;
                    $new_data['chuc_chun_phone'] = '';//手机号
                }
                $new_data['chuc_chun_id'] = $res;
                $new_data['chuc_chun_unit_name'] = $value['chun_unit_name'];//客户单位名称
                $new_data['chuc_update_time'] = date('Y-m-d H:i:s');
                // dump($res);die;
                if ($res) {
                    // 根据业务划区名称判断有没有业务划区
                    $prec_id = DB::table('precincts')
                        ->where('prec_cid', $cid)
                        ->where('prec_superior_shop_id', $superior_shop_id)
                        ->where('prec_name', $value['chun_zoning'])
                        ->value('prec_id');
                    if (empty($prec_id)) {
                        $prec_data['prec_cid'] = $cid;//所属企业
                        $prec_data['prec_superior_shop_id'] = $superior_shop_id;//总店id
                        $prec_data['prec_shop_id'] = $cid;//门店id
                        $prec_data['prec_region'] = 3;//大区名称
                        $prec_data['prec_province'] = $value['chun_province'];//省
                        $prec_data['prec_city'] = $value['chun_city'];//市
                        $prec_data['prec_county'] = $value['chun_county'];//县/区
                        $prec_data['prec_name'] = $value['chun_zoning'];
                        $prec_data['prec_update_time'] = date('Y-m-d H:i:s');
                        $prec_id = DB::table('precincts')->insertGetId($prec_data);
                    } else {
                        $prec_id = $prec_id;
                    }
                    $chin_data['chin_chun_id'] = $res;//客户单位id
                    $chin_data['chin_level'] = $value['chin_level'];//客户等级
                    $chin_data['chin_type'] = $value['chin_type'] == '0' ? 2 : 1;//铺货类型1是铺货2不是铺货
                    $chin_data['chin_owe_day'] = $value['chin_owe_day'];//可欠天数
                    $chin_data['chin_caution_day'] = $value['chin_caution_day'];//警示天数
                    $chin_data['chin_prec_id'] =$prec_id;//业务划区id
                    $chin_data['chin_zoning'] = $value['chun_zoning'];//业务划区名称
                    $chin_data['chin_remarks'] = $value['chin_remarks'];//备注
                    $chin_data['chin_update_time'] = date('Y-m-d H:i:s');
                    $chin_res = DB::table('channel_info')->insertGetId($chin_data);
                }
                $chuc_res = DB::table('channel_unit_change')->insertGetId($new_data);
                unset($new_data);
            } else {
                $edit_data['chuc_chun_id'] = $chun_id;
                $edit_data['chun_update_time'] = date('Y-m-d H:i:s');
                // 判断客户单位名称是否存在
                $chun_unit_name = DB::table('channel_unit')
                    ->where('chun_cid', $cid)
                    ->where('chun_superior_shop_id', $superior_shop_id)
                    ->where('chun_search_letter', $value['chun_search_letter'])
                    ->value('chun_unit_name');
                if ($value['chun_adm_id'] == '公司' || $value['chun_adm_name'] == '0592-5910086') {
                    $edit_data['chuc_chun_name'] = $value['chun_adm_id'];//姓名名称;
                    $edit_data['chuc_chun_phone'] = $value['chun_adm_name'];//手机号
                } else {
                    $edit_data['chuc_chun_name'] = '';//姓名名称;
                    $edit_data['chuc_chun_phone'] = '';//手机号
                }
                if ($chun_unit_name != $info['chun_unit_name']) {
                    $edit_data['chuc_old_chun_unit_name'] = $chun_unit_name;//客户单位名称
                    $edit_data['chuc_chun_unit_name'] = $info['chun_unit_name'];//客户单位名称
                    $edit_data['chuc_type'] = 2;
                    $edit_data['chuc_update_time'] = date('Y-m-d H:i:s');
                    $chuc_res = DB::table('channel_unit_change')->insertGetId($edit_data);
                }
                $res = DB::table('channel_unit')
                    ->where('chun_id', $chun_id)
                    ->update($info);
                if ($chun_id) {
                    // 根据业务划区名称判断有没有业务划区
                    $prec_id = DB::table('precincts')
                        ->where('prec_cid', $cid)
                        ->where('prec_superior_shop_id', $superior_shop_id)
                        ->where('prec_name', $value['chun_zoning'])
                        ->value('prec_id');
                    if (empty($prec_id)) {
                        $prec_data['prec_cid'] = $cid;//所属企业
                        $prec_data['prec_superior_shop_id'] = $superior_shop_id;//总店id
                        $prec_data['prec_shop_id'] = $cid;//门店id
                        $prec_data['prec_region'] = 3;//大区名称
                        $prec_data['prec_province'] = $value['chun_province'];//省
                        $prec_data['prec_city'] = $value['chun_city'];//市
                        $prec_data['prec_county'] = $value['chun_county'];//县/区
                        $prec_data['prec_name'] = $value['chun_zoning'];
                        $prec_id = DB::table('precincts')->insertGetId($prec_data);
                    } else {
                        $prec_id = $prec_id;
                    }
                    $chin_data['chin_chun_id'] = $chun_id;//客户单位id
                    $chin_data['chin_level'] = $value['chin_level'];//客户等级
                    $chin_data['chin_type'] = $value['chin_type'];//铺货类型1是铺货2不是铺货
                    $chin_data['chin_owe_day'] = $value['chin_owe_day'];//可欠天数
                    $chin_data['chin_caution_day'] = $value['chin_caution_day'];//警示天数
                    $chin_data['chin_prec_id'] =$prec_id;//业务划区id
                    $chin_data['chin_zoning'] = $value['chun_zoning'];//业务划区名称
                    $chin_data['chin_remarks'] = $value['chin_remarks'];//备注
                    $chin_data['chin_update_time'] = date('Y-m-d H:i:s');
                    $chin_res = DB::table('channel_info')
                        ->where('chin_chun_id', $chun_id)
                        ->update($chin_data);
                }
                unset($edit_data);
            }
            unset($res);
            unset($info);
            unset($supplier);
            unset($chin_data);
            unset($chin_res);
            unset($prec_data);
            unset($chuc_res);
        }
        echo 333;
        DB::commit();
    }

    // 根据速电单号查询门店订单的APP提交时间
    public function sdOrderAchieveTime($order_number)
    {
        // 根据速电工单查询门店的订单、工单id
        $list_data = DB::table('order as o')
            ->leftjoin('work_order as wo', 'wo.wor_order_id', '=', 'o.ord_id')
            ->whereIn('ord_other_system_number', $order_number)
            ->select('ord_id', 'wor_id', 'ord_order_number', 'ord_other_system_number')
            ->get()->toArray();
        $wor_id = array_column($list_data, 'wor_id');
        // 根据工单id查询APP完成提交时间
        $orlo_data = DB::table('order_log')
            ->whereIn('orlo_wor_id', $wor_id)
            ->where('orlo_content', '完成')
            ->pluck('orlo_time', 'orlo_wor_id')->toArray();
        // 数据匹配
        foreach ($list_data as $key => $value) {
            if (isset($orlo_data[$value->wor_id])) {
                $list_data[$key]->orlo_time = $orlo_data[$value->wor_id];
            } else {
                $list_data[$key]->orlo_time = '';
            }
        }
        return $list_data;
    }

    // 绑定供应链商品id
    public function gylGoodsBinding()
    {
        // 绑定品牌系列
        $list_data = DB::table('brand_serie as bs')
            ->leftjoin('brand as b', 'b.bra_id', '=', 'bs.brse_bra_id')
            ->where('brse_class', 2)
            ->select('brse_id', 'brse_name', 'gyl_bra_id', 'gyl_brse_id')
            ->get();
        foreach ($list_data as $key => $value) {
            // 查询供应链商品表商品id
            $gyl_brse_id = DB::connection('mysql_scm')->table('brand_serie')
                ->where('brse_bra_id', $value->gyl_bra_id)
                ->where('brse_name', $value->brse_name)
                ->value('brse_id');
            // ->first();
            if ($gyl_brse_id) {
                // 绑定供应链商品id
                $edit_data['gyl_brse_id'] = $gyl_brse_id;
                $res = DB::table('brand_serie')
                    ->where('brse_id', $value->brse_id)
                    ->update($edit_data);
                dump($res);
                unset($edit_data);
            }
        }
        die;
        $list_data = DB::table('goods')
            ->where('goo_class', 2)
            ->where('goo_type', 1)
            ->select('goo_id', 'goo_goods_encode', 'gyl_goo_id')
            ->get();
        foreach ($list_data as $key => $value) {
            // 查询供应链商品表商品id
            $gyl_goo_id = DB::connection('mysql_scm')->table('goods')
                ->where('goo_goods_encode', $value->goo_goods_encode)
                ->value('goo_id');
            // ->first();
            if ($gyl_goo_id) {
                // 绑定供应链商品id
                $edit_data['gyl_goo_id'] = $gyl_goo_id;
                $res = DB::table('goods')
                    ->where('goo_id', $value->goo_id)
                    ->update($edit_data);
                dump($res);
                unset($edit_data);
            }
        }
        echo 555;
        die;
        dump($list_data);
    }

    // 同步供应链系统商品
    public function systemGoods($cid, $superior_shop_id, $shop_id, $shop_type)
    {
        $data = DB::table('excel_data_cache')->where('exdc_type', 20)->get();
        $data = json_decode($data, true);
        $data_info =[];
        foreach ($data as $key => $value) {
            $data_info[] = json_decode($value['exdc_data'], true);
        }
        // dump($data_info);
        // exit;
        DB::beginTransaction();
        // $cid = 1;//公司id
        // $superior_shop_id = 1;//总店id
        // $shop_id = 1;//门店id
        $defeated = [];
        foreach ($data_info as $kk => $vv) {
            // dump($vv);
            // exit;
            // 查询品类一级是否存在
            $cate_id = DB::table('category')
                ->where('cate_cid', $cid)
                ->where('cate_shop_id', $shop_id)
                ->where('cate_superior_shop_id', $superior_shop_id)
                ->where('cate_name', $vv['cate_name'])
                ->where('cate_rank', 1)
                ->value('cate_id');
            // dump($cate_id);die;
            if (empty($cate_id)) {
                $cate_data['cate_cid'] = $cid;
                $cate_data['cate_shop_id'] = $shop_id;
                $cate_data['cate_superior_shop_id'] = $superior_shop_id;
                $cate_data['cate_name'] = $vv['cate_name'];
                $cate_data['cate_create_time'] = date('Y-m-d H:i:s');
                $cate_data['cate_class'] = 2;//类型1自营品类2系统品类
                // // 查询供应链后台品牌id
                $gyl_cate_id = DB::connection('mysql_scm')->table('category')
                    ->where('cate_cid', 1)
                    ->where('cate_rank', 1)
                    ->where('cate_name', $vv['cate_name'])
                    ->value('cate_id');
                // dump($gyl_cate_id);die;
                $cate_data['gyl_cate_id'] = $gyl_cate_id;//供应链后台品牌id
                // dump($cate_data);die;
                $cate_id = DB::table('category')->insertGetId($cate_data);
            } else {
                $gyl_cate_id = DB::connection('mysql_scm')->table('category')
                    ->where('cate_cid', 1)
                    ->where('cate_rank', 1)
                    ->where('cate_name', $vv['cate_name'])
                    ->value('cate_id');
                // DB::table('category')->where('cate_id', $cate_id)->increment('cate_goods_number');
                $cate_id = $cate_id;
            }
            // 查询品类二级是否存在
            $cate_two_id = DB::table('category')
                ->where('cate_cid', $cid)
                ->where('cate_shop_id', $shop_id)
                ->where('cate_superior_shop_id', $superior_shop_id)
                ->where('cate_name', $vv['cate_name_two'])
                ->where('cate_parent_id', $cate_id)
                ->where('cate_rank', 2)
                ->value('cate_id');
            if (empty($cate_two_id)) {
                $cate_data['cate_cid'] = $cid;
                $cate_data['cate_shop_id'] = $shop_id;
                $cate_data['cate_superior_shop_id'] = $superior_shop_id;
                $cate_data['cate_name'] = $vv['cate_name_two'];
                $cate_data['cate_parent_id'] = $cate_id;
                $cate_data['cate_rank'] = 2;
                $cate_data['cate_create_time'] = date('Y-m-d H:i:s');
                $cate_data['cate_goods_number'] = 3;
                $cate_data['cate_class'] = 2;//类型1自营品类2系统品类

                $gyl_cate_id = DB::connection('mysql_scm')->table('category')
                    ->where('cate_cid', 1)
                    ->where('cate_rank', 2)
                    ->where('cate_parent_id', $gyl_cate_id)
                    ->where('cate_name', $vv['cate_name_two'])
                    ->value('cate_id');
                $cate_data['gyl_cate_id'] = $gyl_cate_id;//供应链后台品牌id
                $cate_two_id = DB::table('category')->insertGetId($cate_data);
            } else {
                DB::table('category')->where('cate_id', $cate_two_id)->increment('cate_goods_number', 3);
            }

            if (empty($vv['bra_name'])) {
                $bra_id = 0;
            } else {
                $bra_id = DB::table('brand')
                    ->where('bra_cid', $cid)
                    ->where('bra_shop_id', $shop_id)
                    ->where('bra_superior_shop_id', $superior_shop_id)
                    ->where('bra_name', $vv['bra_name'])
                    ->value('bra_id');
                if (empty($bra_id)) {
                    $bra_data['bra_cid'] = $cid;
                    $bra_data['bra_shop_id'] = $shop_id;
                    $bra_data['bra_superior_shop_id'] = $superior_shop_id;
                    $bra_data['bra_name'] = $vv['bra_name'];
                    $bra_data['bra_create_time'] = date('Y-m-d H:i:s');
                    $bra_data['bra_goods_number'] = 3;
                    $bra_data['bra_class'] = 2;//类型：1自营品牌2系统品牌
                    // // 查询供应链后台品牌id
                    $gyl_bra_id = DB::connection('mysql_scm')->table('brand')
                        ->where('bra_cid', 1)
                        ->where('bra_name', $vv['bra_name'])
                        ->value('bra_id');
                    $bra_data['gyl_bra_id'] = $gyl_bra_id;//供应链后台品牌id
                    $bra_id = DB::table('brand')->insertGetId($bra_data);
                } else {
                    // 查询供应链后台品牌id
                    $gyl_bra_id = DB::connection('mysql_scm')->table('brand')
                        ->where('bra_cid', 1)
                        ->where('bra_name', $vv['bra_name'])
                        ->value('bra_id');
                    $bra_data['gyl_bra_id'] = $gyl_bra_id;//供应链后台品牌id
                    DB::table('brand')->where('bra_id', $bra_id)->increment('bra_goods_number', 3);
                }
                if ($bra_id) {
                    $brse_id = DB::table('brand_serie')
                        ->where('brse_cid', $cid)
                        ->where('brse_shop_id', $shop_id)
                        ->where('brse_superior_shop_id', $superior_shop_id)
                        ->where('brse_bra_id', $bra_id)
                        ->where('brse_name', $vv['brse_name'])
                        ->value('brse_id');
                    if (empty($brse_id)) {
                        $brse_data['brse_cid'] = $cid;
                        $brse_data['brse_superior_shop_id'] = $superior_shop_id;
                        $brse_data['brse_shop_id'] = $shop_id;
                        $brse_data['brse_bra_id'] = $bra_id;
                        $brse_data['brse_name'] = $vv['brse_name'];
                        $brse_data['brse_goods_number'] = 3;
                        $brse_data['brse_class'] = 2;//类型1自营系列2系统系列
                        $brse_data['brse_cate_id'] = $cate_id;//一级品类id
                        $brse_data['brse_second_cate_id'] = $cate_two_id;//二级品类id
                        // // 查询供应链后台品牌系列id
                        $gyl_brse_id = DB::connection('mysql_scm')->table('brand_serie')
                            ->where('brse_cid', 1)
                            ->where('brse_bra_id', $gyl_bra_id)
                            ->where('brse_name', $vv['brse_name'])
                            ->value('brse_id');
                        $brse_data['gyl_brse_id'] = $gyl_brse_id;//供应链后台品牌id
                        $brse_id = DB::table('brand_serie')->insertGetId($brse_data);
                    } else {
                        DB::table('brand_serie')->where('brse_id', $brse_id)->increment('brse_goods_number', 3);
                    }
                }
            }

            $info['goo_cid'] = $cid;
            $info['goo_superior_shop_id'] = $superior_shop_id;
            $info['goo_shop_id'] = $shop_id;
            $info['goo_bra_name'] = $vv['bra_name'];//品牌名称
            $info['goo_bra_id'] = $bra_id;//品牌id
            $info['goo_brse_id'] = $brse_id;//品牌系列id
            $info['goo_cate_name'] = $vv['cate_name'];//品类名称
            $info['goo_cate_id'] = $cate_two_id;//品类id
            $info['goo_name'] = $vv['goo_name'];//商品名称
            $info['goo_goods_encode'] = $vv['goo_goods_encode'];//检索编码
            $info['goo_class'] = 2;//类型：1自营商品2系统商品
            // 查询供应链后台商品id
            $gyl_goo_id = DB::connection('mysql_scm')->table('goods')
                ->where('goo_cid', 1)
                ->where('goo_goods_encode', $vv['goo_goods_encode'])
                ->value('goo_id');
            $info['gyl_goo_id'] = $gyl_goo_id;//供应链后台商品id

            $supplier = [];
            if (!empty($vv['attr_guige']) && $vv['attr_guige'] != 'NULL') {
                $supplier[] = ['key'=>'规格','value'=>$vv['attr_guige']];
            }
            if (!empty($vv['danwei']) && $vv['danwei'] != 'NULL') {
                $supplier[] = ['key'=>'单位','value'=>$vv['danwei']];
            }
            if (!empty($supplier)) {
                $info['goo_attribute'] = json_encode($supplier);
            } else {
                $info['goo_attribute'] = '';
            }
            // dump($info);die;
            if (!empty($vv['goo_name'])) {
                $info['goo_type'] = 1;//1正常商品2赠品商品3活动商品4旧货商品
                $info['goo_system_code'] = str_pad($cid, '4', '0', STR_PAD_RIGHT) . str_pad($shop_id, '5', '0', STR_PAD_RIGHT) . rand(10, 99) . rand(100000000, 999999999); //系统编码
                // dump($info);die;
                // 添加商品数据
                $goo_id = DB::table('goods')->insertGetId($info);
                dump($goo_id);
                unset($info['gyl_goo_id']);

                $sygo_system_goo_id = DB::table('system_goods')
                ->where('sygo_goods_code', $vv['goo_goods_encode'])
                ->value('sygo_system_goo_id');
                if ($sygo_system_goo_id && $shop_type == 1) {
                    $sygo_data['goco_cid'] = $cid;
                    $sygo_data['goco_superior_shop_id'] = $superior_shop_id;
                    $sygo_data['goco_shop_id'] = $shop_id;
                    $sygo_data['goco_adm_id'] = $cid;
                    $sygo_data['goco_binding_time'] = date('Y-m-d H:i:s');
                    $sygo_data['goco_state'] = 2;
                    $sygo_data['goco_goo_id'] = $goo_id;
                    $sygo_data['goco_system_goo_id'] = $sygo_system_goo_id;
                    $sygo_res = DB::table('goods_correlation')->insertGetId($sygo_data);
                    // dump($info);
                    // dump($goo_id);
                    // dump($sygo_data);
                    // die;
                    unset($sygo_data);
                }

                // 活动商品
                $acgo_data['acgo_cid'] = $cid;
                $acgo_data['acgo_superior_shop_id'] = $superior_shop_id;
                $acgo_data['acgo_shop_id'] = $shop_id;
                $acgo_data['acgo_goo_id'] = $goo_id;
                $acgo_res = DB::table('activity_goods')->insertGetId($acgo_data);

                //添加赠品商品
                $info['goo_type'] = 2;//1正常商品2赠品商品3活动商品4旧货商品
                $info['goo_fid'] = $goo_id;
                $info['goo_system_code'] = str_pad($cid, '4', '0', STR_PAD_RIGHT) . str_pad($shop_id, '5', '0', STR_PAD_RIGHT) . rand(10, 99) . rand(100000000, 999999999); //系统编码
                // 新增商品
                $gift_goo_id = DB::table('goods')->insertGetId($info);

                //添加旧货商品
                $info['goo_type'] = 4;//1正常商品2赠品商品3活动商品4旧货商品
                $info['goo_fid'] = $goo_id;
                $info['goo_system_code'] = str_pad($cid, '4', '0', STR_PAD_RIGHT) . str_pad($shop_id, '5', '0', STR_PAD_RIGHT) . rand(10, 99) . rand(100000000, 999999999); //系统编码
                // 新增商品
                $junk_goo_id = DB::table('goods')->insertGetId($info);

                unset($goo_id);
                unset($acgo_res);
                unset($gift_goo_id);
                unset($junk_goo_id);
            }
            unset($bra_data);
            unset($bra_id);
            unset($cate_data);
            unset($cate_id);
            unset($info);
            unset($supplier);
            unset($acgo_data);
        }
        dump($defeated);
        // echo 333;die;
        DB::commit();
    }

    //接口访问
    public function request_post($url, $param)
    {
        $header = array(
            'Content-Type: application/json',
            'trantype: undefined',
            'system: gylu8',
            'usercode: test',
            'password: 59f2443a4317918ce29ad28a14e1bdb7',
        );
        dump($header);
        die;
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $header);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $param);
        $response = curl_exec($ch);
        curl_close($ch);
        return trim($response);
    }

    // 删除总店门店数据
    public function delete(Request $request)
    {
        echo 444;
        // die;
        // 更改进销存的数量
        // $list = DB::table('stock_sell_storage_goods')
        // ->get();
        // foreach ($list as $key => $value) {
        //     $sssg_edit_data['sssg_surplus_stock_calculate'] = $value->sssg_surplus_stock;
        //     $sssg_edit_data['sssg_surplus_cost_calculate'] = $value->sssg_surplus_cost;
        //     $res = DB::table('stock_sell_storage_goods')
        //         ->where('sssg_id', $value->sssg_id)
        //         ->update($sssg_edit_data);
        //     dump($res);
        // }
        // die;
        // dump($list);die;
        $cid = 1;
        $superior_shop_id = 1;
        // DB::beginTransaction();
        // 删除客户单位数据
        // $del_goaf_res = DB::table('channel_info as b')
        // ->leftjoin('channel_unit as a', 'b.chin_chun_id', '=', 'a.chun_id')
        // ->where('chun_cid', $cid)
        // ->where('chun_superior_shop_id', $superior_shop_id)
        // ->where('chun_create_time', '<', '2020-06-28')
        // ->delete();
        // // ->get();
        // dump($del_goaf_res);
        // // 再删除商品表的数据
        // $del_goo_res = DB::table('channel_unit')
        // ->where('chun_cid', $cid)//公司id
        // ->where('chun_superior_shop_id', $superior_shop_id)//总店id
        // ->where('chun_create_time', '<', '2020-06-28 00:00:00')
        // ->delete();
        // // ->get();
        // dump($del_goo_res);die;

        
        // 先删除商品附属表数据
        // DB::beginTransaction();
        // $del_goaf_res = DB::table('goods_affiliate as b')
        // ->leftjoin('goods as a', 'b.goaf_goo_id', '=', 'a.goo_id')
        // ->where('goo_cid', $cid)
        // ->where('goo_superior_shop_id', $superior_shop_id)
        // ->delete();
        // // 再删除商品表的数据
        // $del_goo_res = DB::table('goods')
        // ->where('goo_cid', $cid)//公司id
        // ->where('goo_superior_shop_id', $superior_shop_id)//总店id
        // ->delete();
        // dump($del_goaf_res);
        // dump($del_goo_res);

        // // 删除仓库商品表的数据
        // $wago_res = DB::table('warehouse_goods as b')
        //  ->leftjoin('warehouse as a', 'b.wago_ware_id', '=', 'a.ware_id')
        //  ->where('ware_cid', $cid)
        //  ->where('ware_superior_shop_id', $superior_shop_id)
        //  // ->delete();
        //  ->get();
        // dump($wago_res);
        // die;

        // $find_work_data = DB::table('work_order as wo')
        //     ->leftjoin('work_client as wc', 'wc.wocl_wor_id', '=', 'wo.wor_id')
        //     ->where('wor_cid', $cid)
        //     ->where('wor_superior_shop_id', $superior_shop_id)
        //     ->where('wocl_wor_type', '<>',3)
        //     ->get()->toArray();
        // $wor_number = array_column($find_work_data, 'wor_number');
        // dump($wor_number);

        // // 删除工单商品表数据
        // $wago_res = DB::table('work_good as b')
        //     ->leftjoin('work_order as a', 'a.wor_id', '=', 'b.wogo_wor_id')
        //     ->where('wor_cid', $cid)
        //     ->where('wor_superior_shop_id', $superior_shop_id)
        //     ->whereIn('wor_number', $wor_number)
        //     ->delete();
        // dump($wago_res);

        // // 删除工单客户表数据
        // $wago_res = DB::table('work_client as b')
        //     ->leftjoin('work_order as a', 'a.wor_id', '=', 'b.wocl_wor_id')
        //     ->where('wor_cid', $cid)
        //     ->where('wor_superior_shop_id', $superior_shop_id)
        //     ->whereIn('wor_number', $wor_number)
        //     ->delete();
        // dump($wago_res);
        // // 删除工单表数据
        // $wago_res = DB::table('work_order')
        //     ->where('wor_cid', $cid)
        //     ->where('wor_superior_shop_id', $superior_shop_id)
        //     ->whereIn('wor_number', $wor_number)
        //     ->delete();
        // dump($wago_res);

        // $find_order_data = DB::table('order')
        //     ->where('ord_cid', $cid)
        //     ->where('ord_superior_shop_id', $superior_shop_id)
        //     ->where('ord_type', '<>', 3)
        //     ->get()->toArray();
        // $ord_order_number = array_column($find_order_data, 'ord_order_number');
        // dump($ord_order_number);
            
        // // 删除订单商品表数据
        // $wago_res = DB::table('order_goods as b')
        //     ->leftjoin('order as a', 'a.ord_id', '=', 'b.orgo_ord_id')
        //     ->where('ord_cid', $cid)
        //     ->where('ord_superior_shop_id', $superior_shop_id)
        //     ->whereIn('ord_order_number', $ord_order_number)
        //     ->delete();
        // dump($wago_res);
        // // 删除订单客户表数据
        // $wago_res = DB::table('order_client as b')
        //     ->leftjoin('order as a', 'a.ord_id', '=', 'b.orcl_ord_id')
        //     ->where('ord_cid', $cid)
        //     ->where('ord_superior_shop_id', $superior_shop_id)
        //     ->whereIn('ord_order_number', $ord_order_number)
        //     ->delete();
        // dump($wago_res);
        // // 删除订单表数据
        // $wago_res = DB::table('order')
        //     ->where('ord_cid', $cid)
        //     ->where('ord_superior_shop_id', $superior_shop_id)
        //     ->whereIn('ord_order_number', $ord_order_number)
        //     ->delete();
        // dump($wago_res);

        // 删除盘库单商品表
        // $wago_res = DB::table('stocktake_goods as b')
        //     ->leftjoin('stocktake as a', 'a.stoc_id', '=', 'b.stgo_stoc_id')
        //     ->where('stoc_cid', $cid)
        //     ->where('stoc_superior_shop_id', $superior_shop_id)
        //     ->delete();
        // dump($wago_res);
        // // 删除盘库单表
        // $wago_res = DB::table('stocktake')
        //     ->where('stoc_cid', $cid)
        //     ->where('stoc_superior_shop_id', $superior_shop_id)
        //     ->delete();
        // dump($wago_res);
        
        // 删除出入库记录表
        // $wago_res = DB::table('outin_details as b')
        //     ->leftjoin('outin_record as a', 'a.oure_id', '=', 'b.oude_oure_id')
        //     ->where('oure_cid', $cid)
        //     ->where('oure_superior_shop_id', $superior_shop_id)
        //     ->delete();
        // dump($wago_res);
        // // 删除出入库记录表
        // $wago_res = DB::table('outin_record')
        //     ->where('oure_cid', $cid)
        //     ->where('oure_superior_shop_id', $superior_shop_id)
        //     ->delete();
        // dump($wago_res);

        // die;
        // 删除发货单商品表
        // $wago_res = DB::table('dispatch_goods as b')
        //     ->leftjoin('dispatch_bill as a', 'a.dego_id', '=', 'b.digo_dego_id')
        //     ->where('dego_cid', $cid)
        //     ->where('dego_superior_shop_id', $superior_shop_id)
        //     ->whereIn('dego_original_number', $wor_number)
        //     ->delete();
        // dump($wago_res);
        // // 删除发货单表
        // $wago_res = DB::table('dispatch_bill')
        //     ->where('dego_cid', $cid)
        //     ->where('dego_superior_shop_id', $superior_shop_id)
        //     ->whereIn('dego_original_number', $wor_number)
        //     ->delete();
        // dump($wago_res);

        $order_number = [
          0 => "D2020090908553100002",
          1 => "D2020090908575800003",
          2 => "D2020090909003800004",
          3 => "D2020090909040200005",
          4 => "D2020090909305100006",
          5 => "D2020090909370300007",
          6 => "D2020090909424600008",
          7 => "D2020090910192100010",
          8 => "D2020090916042100014",
          9 => "D2020090917120500015",
        ];
        dump($order_number);
        // die;
        // // 删除旧货回收商品表
        // $wago_res = DB::table('junk_goods as b')
        //     ->leftjoin('junk_recycle as a', 'a.jur_id', '=', 'b.jugo_jur_id')
        //     ->where('jur_cid', $cid)
        //     ->where('jur_superior_shop_id', $superior_shop_id)
        //     ->whereIn('jur_ord_order_number', $order_number)
        //     ->delete();
        // dump($wago_res);
        // // 删除旧货回收客户表
        // $wago_res = DB::table('junk_client as b')
        //     ->leftjoin('junk_recycle as a', 'a.jur_id', '=', 'b.jucl_jur_id')
        //     ->where('jur_cid', $cid)
        //     ->where('jur_superior_shop_id', $superior_shop_id)
        //     ->whereIn('jur_ord_order_number', $order_number)
        //     ->delete();
        // dump($wago_res);
        // // 删除旧货回收单表
        // $wago_res = DB::table('junk_recycle')
        //     ->where('jur_cid', $cid)
        //     ->where('jur_superior_shop_id', $superior_shop_id)
        //     ->whereIn('jur_ord_order_number', $order_number)
        //     ->delete();
        // dump($wago_res);

        // 删除退换回收商品表
        // $wago_res = DB::table('recede_goods as b')
        //     ->leftjoin('recede_recycle as a', 'a.rec_id', '=', 'b.rego_rec_id')
        //     ->where('rec_cid', $cid)
        //     ->where('rec_superior_shop_id', $superior_shop_id)
        //     ->delete();
        // dump($wago_res);
        // // 退换回收客户表
        // $wago_res = DB::table('recede_client as b')
        //     ->leftjoin('recede_recycle as a', 'a.rec_id', '=', 'b.recl_rec_id')
        //     ->where('rec_cid', $cid)
        //     ->where('rec_superior_shop_id', $superior_shop_id)
        //     ->delete();
        // dump($wago_res);
        // // 删除退换回收单表
        // $wago_res = DB::table('recede_recycle')
        //     ->where('rec_cid', $cid)
        //     ->where('rec_superior_shop_id', $superior_shop_id)
        //     ->delete();
        // dump($wago_res);
        // die;
        // // 删除结款明细表
        // $wago_res = DB::table('accounting_settlement')
        //     ->where('acset_adm_cid', $cid)
        //     ->where('acset_superior_shop_id', $superior_shop_id)
        //     ->delete();
        // dump($wago_res);

        // // // 删除应收账款表
        // $wago_res = DB::table('receivable_credit')
        //     ->where('recr_cid', $cid)
        //     ->where('recr_shop_superior_id', $superior_shop_id)
        //     ->delete();
        // dump($wago_res);

        // // 删除销售明细表
        // $wago_res = DB::table('sell_detail')
        //     ->where('sede_cid', $cid)
        //     ->where('sede_superior_shop_id', $superior_shop_id)
        //     ->delete();
        // dump($wago_res);

        // 删除销售出库商品表
        // $wago_res = DB::table('sell_goods as b')
        //     ->leftjoin('sell as a', 'a.sell_id', '=', 'b.sego_sell_id')
        //     ->where('sell_cid', $cid)
        //     ->where('sell_shop_id', $superior_shop_id)
        //     ->delete();
        // dump($wago_res);
        // // 销售出库客户表
        // $wago_res = DB::table('sell_client as b')
        //     ->leftjoin('sell as a', 'a.sell_id', '=', 'b.secl_sell_id')
        //     ->where('sell_cid', $cid)
        //     ->where('sell_shop_id', $superior_shop_id)
        //     ->delete();
        // dump($wago_res);
        // // 销售出库表
        // $wago_res = DB::table('sell')
        //     ->where('sell_cid', $cid)
        //     ->where('sell_shop_id', $superior_shop_id)
        //     ->delete();
        // dump($wago_res);

        // 调拨单商品表
        // $wago_res = DB::table('transferring_order_goods as b')
        //     ->leftjoin('transferring_order as a', 'a.tror_id', '=', 'b.trog_tror_id')
        //     ->where('tror_cid', $cid)
        //     ->where('tror_shop_id', $superior_shop_id)
        //     ->delete();
        // dump($wago_res);
        // // 调拨单详情表
        // $wago_res = DB::table('transferring_order_details as b')
        //     ->leftjoin('transferring_order as a', 'a.tror_id', '=', 'b.trod_tror_id')
        //     ->where('tror_cid', $cid)
        //     ->where('tror_shop_id', $superior_shop_id)
        //     ->delete();
        // dump($wago_res);
        // // 调拨单
        // $wago_res = DB::table('transferring_order')
        //     ->where('tror_cid', $cid)
        //     ->where('tror_shop_id', $superior_shop_id)
        //     ->delete();
        // dump($wago_res);

        // // 售后客户表
        // $wago_res = DB::table('order_after_client as b')
        //     ->leftjoin('order_after as a', 'a.oraf_id', '=', 'b.orac_oraf_id')
        //     ->where('oraf_cid', $cid)
        //     ->where('oraf_shop_id', $superior_shop_id)
        //     ->delete();
        // dump($wago_res);
        // // 售后商品表
        // $wago_res = DB::table('order_after_goods as b')
        //     ->leftjoin('order_after as a', 'a.oraf_id', '=', 'b.orag_oraf_id')
        //     ->where('oraf_cid', $cid)
        //     ->where('oraf_shop_id', $superior_shop_id)
        //     ->delete();
        // dump($wago_res);
        // // 订单售后备注表
        // $wago_res = DB::table('order_after_note as b')
        //     ->leftjoin('order_after as a', 'a.oraf_id', '=', 'b.oran_oraf_id')
        //     ->where('oraf_cid', $cid)
        //     ->where('oraf_shop_id', $superior_shop_id)
        //     ->delete();
        // dump($wago_res);
        // // 售后日常反馈表
        // $wago_res = DB::table('order_after_pic as b')
        //     ->leftjoin('order_after as a', 'a.oraf_id', '=', 'b.orap_oraf_id')
        //     ->where('oraf_cid', $cid)
        //     ->where('oraf_shop_id', $superior_shop_id)
        //     ->delete();
        // dump($wago_res);

        // // 订单售后操作记录
        // $wago_res = DB::table('order_after_log')
        //     ->where('oral_cid', $cid)
        //     ->where('oral_shop_id', $superior_shop_id)
        //     ->delete();
        // dump($wago_res);

        // $wago_res = DB::table('order_after')
        //     ->where('oraf_cid', $cid)
        //     ->where('oraf_shop_id', $superior_shop_id)
        //     ->delete();
        // dump($wago_res);

        // 采购单商品表
        // $wago_res = DB::table('storage_goods as b')
        //     ->leftjoin('purchase_order as a', 'a.cg_number', '=', 'b.relation_number')
        //     ->where('a.company_id', $cid)
        //     ->where('a.cg_shop_id', $superior_shop_id)
        // ->delete();
        // dump($wago_res);die;
        die;
    }

    // 厦门导入会计科目数据
    public function addSubject($submit_data, $data)
    {
        DB::beginTransaction();
        $cid = 1;//公司id
        $superior_shop_id = 1;//总店id
        $shop_id = 1;//门店id
        $defeated = [];
        foreach ($data as $key => $value) {
            $acsu_cid = DB::table('account_subject')
                ->where('acsu_cid', $cid)
                ->where('acsu_shop_id', $shop_id)
                ->where('subjname', $value['subjname'])
                ->value('acsu_cid');
            $acsu_cid = DB::table('account_subject')
                ->where('acsu_cid', $cid)
                ->where('acsu_shop_id', $shop_id)
                ->where('subjcode', $value['subjcode'])
                ->value('acsu_cid');
            // if (empty($acsu_cid) || empty($acsu_cid)) {
                $add_data['acsu_cid'] = $cid;//公司id
                $add_data['acsu_shop_id'] = $shop_id;//门店id
                $add_data['acsu_shop_superior_id'] = $superior_shop_id;//总店id
                $add_data['acsu_adm_id'] = 0;//创建人id
                $add_data['pk_corp'] = '0001';//公司编码---后台查询
                $add_data['subjcode'] = $value['subjcode'];//科目编码
                $add_data['subjname'] = $value['subjname'];//科目名称
                $add_data['dispname'] = $value['subjname'];//显示名称
                $add_data['engsubjname'] = '';//英文名称
                if ($value['balanorient'] == '借') {
                    $add_data['balanorient'] = 1;//余额方向 1:借2:贷
                } else {
                    $add_data['balanorient'] = 2;//余额方向 1:借2:贷
                }
            $add_data['sealflag'] = '';//封存标志:封存日期；数据库存的是日期，页面显示 Y N
                $add_data['incurflag'] = 'N';//发生额方向控制取值：Y：是/N：否
                $add_data['balanflag'] = 'N';//余额方向控制取值：Y：是/N：否
                $add_data['bothorient'] = 'Y';//帐簿余额双向显示取值：Y：是/N：否
                $add_data['innersubj'] = 'N';//内部交易科目取值：Y：是/N：否
                $add_data['accremove'] = 'N';//是否核销科目取值：Y：是/N：否
                $add_data['cashbankflag'] = 0;//现金银行科目 0:其他1:现金科目2:银行科目3:现金等价物
                $add_data['unit'] = '';//计量单位
                $add_data['outflag'] = 'N';//表外科目取值：Y：是/N：否
                $add_data['remcode'] = '';//助记码
                $subjlev_arr = [4=>1,6=>2,8=>3,10=>4];//科目级次 4-2-2-2
                $subjcode_strlen = strlen($value['subjcode']);//新增的科目编码的长度
                // 判断是不是一级科目
                if ($subjcode_strlen != 4) {
                    // 不是一级科目，将上一级的科目 末级标志取值 改为N：否
                    $superior_subjcode = substr($value['subjcode'], 0, -2);//上级科目编码
                    // 判断上级科目是否存在
                    $superior_acsu_id = DB::table('account_subject')
                        ->where('acsu_cid', $cid)
                        ->where('acsu_shop_id', $shop_id)
                        ->where('subjcode', $superior_subjcode)
                        ->value('acsu_id');
                    // dump($superior_acsu_id);exit;
                    if (!empty($superior_acsu_id)) {
                        // 将上一级的科目 末级标志取值 改为N：否
                        $superior_res = DB::table('account_subject')
                            ->where('acsu_id', $superior_acsu_id)
                            ->update(['endflag'=>'N', 'acsu_update_time'=>date('Y-m-d H:i:s')]);
                    }
                } else {
                    $superior_res = true;
                }
            $add_data['subjlev'] = $subjlev_arr[$subjcode_strlen];//科目级次
                $add_data['endflag'] = 'Y';//末级标志取值：Y：是/N：否；这个是计算的，后台判断这个科目是否是末级
                $add_data['innerinfonull'] = 'N';//内部交易信息是否必录取值：Y：是/N：否
    
                $add_data['currency'] = 'CNY';//科目默认币种，可以不选择,不选择就是null
                $add_data['beginyear'] = '2020';//启用年度，年 2020 四位
                $add_data['beginperiod'] = '09';//启用期间，月 06 两位
                $add_data['stoped'] = 'N';//停用标志取值：Y：是/N：否
                $add_data['createyear'] = '2020';//创建年度
                $add_data['createperiod'] = '09';//创建月份
                $add_data['sumprint_level'] = 0;//汇总打印级次 0末级 最大数量是科目级次数量
                $add_data['pk_subjscheme'] = '0001F8100000000001T1';//科目方案
                $add_data['pk_glorgbook'] = '0001F810000000000330';//会计主体账簿
                $add_data['pk_create_glorgbook'] = '0001F810000000000330';//创建会计主体账簿
    
                $add_data['acsu_bdin_id'] = '';
            $acsb_data['acss_bdinfo'] = '';
            $acsu_id =  DB::table('account_subject')->insertGetId($add_data);
    
            $acsb_data['acss_acsu_id'] = $acsu_id;
            $arrs = [
                    '资产类'=>1,
                    '负债类'=>2,
                    '共同'=>3,
                    '所有者权益类'=>4,
                    '成本'=>5,
                    '损益类'=>6,
                ];
            // $acsb_data['typeindex'] = $value['typeindex'];//科目类型
                $acsb_data['typeindex'] = $arrs[$value['typeindex']];//科目类型
                $acsb_res = DB::table('account_subject_sublist')->insert($acsb_data);
    
            unset($add_data);
            unset($superior_res);
            unset($acsb_res);
            unset($curl_return);
            unset($acsb_data);
        }
        echo 333;
        DB::commit();
    }
    // U8系统导入
    public function addSubjects($submit_data, $data)
    {
        DB::beginTransaction();
        $cid = 1;//公司id
        $superior_shop_id = 1;//总店id
        $shop_id = 1;//门店id
        $defeated = [];
        dump($data);
        die;
        foreach ($data as $key => $value) {
            dump($value);
            // die;
            $acsu_cid = DB::table('account_subject')
                ->where('acsu_cid', $cid)
                ->where('acsu_shop_id', $shop_id)
                ->where('subjname', $value['subjname'])
                ->value('acsu_cid');
            $acsu_cid = DB::table('account_subject')
                ->where('acsu_cid', $cid)
                ->where('acsu_shop_id', $shop_id)
                ->where('subjcode', $value['subjcode'])
                ->value('acsu_cid');
            $add_data['acsu_cid'] = $cid;//公司id
                $add_data['acsu_shop_id'] = $shop_id;//门店id
                $add_data['acsu_shop_superior_id'] = $superior_shop_id;//总店id
                $add_data['acsu_adm_id'] = 0;//创建人id
                $add_data['pk_corp'] = '0001';//公司编码---后台查询
                $add_data['subjcode'] = $value['subjcode'];//科目编码
                $add_data['subjname'] = $value['subjname'];//科目名称
                $add_data['dispname'] = $value['subjname'];//显示名称
                $add_data['engsubjname'] = '';//英文名称
                if ($value['balanorient'] == '借') {
                    $add_data['balanorient'] = 1;//余额方向 1:借2:贷
                } else {
                    $add_data['balanorient'] = 2;//余额方向 1:借2:贷
                }
            $add_data['sealflag'] = '';//封存标志:封存日期；数据库存的是日期，页面显示 Y N
                $add_data['incurflag'] = 'N';//发生额方向控制取值：Y：是/N：否
                $add_data['balanflag'] = 'N';//余额方向控制取值：Y：是/N：否
                $add_data['bothorient'] = 'Y';//帐簿余额双向显示取值：Y：是/N：否
                $add_data['innersubj'] = 'N';//内部交易科目取值：Y：是/N：否
                $add_data['accremove'] = 'N';//是否核销科目取值：Y：是/N：否
                $add_data['cashbankflag'] = 0;//现金银行科目 0:其他1:现金科目2:银行科目3:现金等价物
                $add_data['unit'] = '';//计量单位
                $add_data['outflag'] = 'N';//表外科目取值：Y：是/N：否
                $add_data['remcode'] = '';//助记码
                $subjlev_arr = [4=>1,6=>2,8=>3,10=>4];//科目级次 4-2-2-2
                $subjcode_strlen = strlen($value['subjcode']);//新增的科目编码的长度
                // 判断是不是一级科目
                if ($subjcode_strlen != 4) {
                    // 不是一级科目，将上一级的科目 末级标志取值 改为N：否
                    $superior_subjcode = substr($value['subjcode'], 0, -2);//上级科目编码
                    // 判断上级科目是否存在
                    $superior_acsu_id = DB::table('account_subject')
                        ->where('acsu_cid', $cid)
                        ->where('acsu_shop_id', $shop_id)
                        ->where('subjcode', $superior_subjcode)
                        ->value('acsu_id');
                    if (!empty($superior_acsu_id)) {
                        // 将上一级的科目 末级标志取值 改为N：否
                        $superior_res = DB::table('account_subject')
                            ->where('acsu_id', $superior_acsu_id)
                            ->update(['endflag'=>'N', 'acsu_update_time'=>date('Y-m-d H:i:s')]);
                    }
                } else {
                    $superior_res = true;
                }
            $add_data['subjlev'] = $subjlev_arr[$subjcode_strlen];//科目级次
                $add_data['endflag'] = 'Y';//末级标志取值：Y：是/N：否；这个是计算的，后台判断这个科目是否是末级
                $add_data['innerinfonull'] = 'N';//内部交易信息是否必录取值：Y：是/N：否
    
                $add_data['currency'] = 'CNY';//科目默认币种，可以不选择,不选择就是null
                $add_data['beginyear'] = '2020';//启用年度，年 2020 四位
                $add_data['beginperiod'] = '09';//启用期间，月 06 两位
                $add_data['stoped'] = 'N';//停用标志取值：Y：是/N：否
                $add_data['createyear'] = '2020';//创建年度
                $add_data['createperiod'] = '09';//创建月份
                $add_data['sumprint_level'] = 0;//汇总打印级次 0末级 最大数量是科目级次数量
                $add_data['pk_subjscheme'] = '0001F8100000000001T1';//科目方案
                $add_data['pk_glorgbook'] = '0001F810000000000330';//会计主体账簿
                $add_data['pk_create_glorgbook'] = '0001F810000000000330';//创建会计主体账簿
    
                $add_data['acsu_bdin_id'] = '';
            $acsb_data['acss_bdinfo'] = '';

            $arrs = [
                    '资产类'=>'资产',
                    '负债类'=>'负债',
                    '共同'=>3,
                    '所有者权益类'=>'所有者权益',
                    '成本'=>5,
                    '损益类'=>'损益',
                ];
    
            // 科目类型名称
                $add_data['subjtypename'] = $arrs[$value['typeindex']];//科目类型
    
                // 调用u8系统接口，将科目数据传到用友系统上
            $yongyou = new YongYouController;
            // 获取门店对应用友系统的配置数据
                $add_data['unitcode'] = config('apiu8cloud.SHOP_BASIC_SETUP')[$shop_id]['unitcode'];//用友-公司编码
                $add_data['subjschemecode']  = config('apiu8cloud.SHOP_BASIC_SETUP')[$shop_id]['subjschemecode'];//用友-科目方案编码
                $add_data['bdin_id_json']  = $acsb_data['acss_bdinfo'];//辅助核算项数据
                // 调用u8系统接口
                dump($add_data);
            $curl_return = $yongyou->u8cloudApi('会计科目从公司新增', $add_data);
            dump($curl_return);
            die;
            // 判断用友接口返回的数据
            // if ($curl_return['status'] != 'success') {
            //     DB::rollBack();
            //     return ['code'=> 500, 'msg'=>'error', 'data'=>'新增科目失败！科目编码已存在！'];
            // }
            unset($add_data);
            unset($superior_res);
            unset($acsb_res);
            unset($curl_return);
            unset($acsb_data);
            // }
        }
        echo 333;
        DB::commit();
    }

    // 厦门供应商数据导入
    public function gysExcelChannel($submit_data, $data)
    {
        DB::beginTransaction();
        $cid = 1;//公司id
        $superior_shop_id = 1;//总店id
        $shop_id = 1;//门店id
        $new_data = [];
        $edit_data = [];
        // 获取当前操作账号信息
        // dump($data);die;
        foreach ($data as $key => $value) {
            // 供应商
            $chty_id = DB::table('channel_type')
                ->where('chty_cid', $cid)
                ->where('chty_shop_id', $shop_id)
                ->where('chty_name', '供应商')
                ->where('chty_system_type', 1)
                ->where('chty_delete', 1)
                ->value('chty_id');
            
            DB::table('channel_type')->where('chty_id', $chty_id)->increment('chty_channel_number');
            
            $supplier = [];
            if (!empty($value['chun_phone'])) {
                $supplier[] = ['key'=>$value['chun_name'], 'value'=>$value['chun_phone'], 'default'=>1];
            }
            if (!empty($supplier)) {
                $chin_data['chin_data'] = json_encode($supplier);
            } else {
                $chin_data['chin_data'] = '';
            }

            $chun_id = DB::table('channel_unit')
                ->where('chun_cid', $cid)
                ->where('chun_superior_shop_id', $superior_shop_id)
                ->where('chun_search_letter', $value['chun_search_letter'])
                ->value('chun_id');
            $info['chun_cid'] = $cid;
            $info['chun_superior_shop_id'] = $superior_shop_id;
            $info['chun_shop_id'] = $shop_id;
            $info['chun_search_letter'] = $value['chun_search_letter'];//检索字母
            $info['chun_unit_name'] = $value['chun_unit_name'];//客户单位名称
            $info['chun_name'] = $value['chun_name'];//联系人姓名
            $info['chun_phone'] = $value['chun_phone'];//联系人电话
            $info['chun_chty_id'] = $chty_id;//单位类型id
            $info['chun_payment_way'] = 1;//结算方式1账期2现结
            // $info['chun_province'] = $value['chun_province'];//省
            // $info['chun_city'] = $value['chun_city'];//市
            // $info['chun_county'] = $value['chun_county'];//区县
            // $info['chun_address'] = $value['chun_address'];//详细地址
            $info['chun_create_time'] = date('Y-m-d H:i:s');
            // dump($info);die;
            if (empty($chun_id)) {
                $res = DB::table('channel_unit')->insertGetId($info);
                $new_data['chuc_chun_name'] = $value['chun_name'];//姓名名称;
                $new_data['chuc_chun_phone'] = $value['chun_phone'];//手机号
                $new_data['chuc_chun_id'] = $res;
                $new_data['chuc_chun_unit_name'] = $value['chun_unit_name'];//客户单位名称
                $new_data['chuc_update_time'] = date('Y-m-d H:i:s');
                // dump($res);die;
                if ($res) {
                    $chin_data['chin_chun_id'] = $res;//客户单位id
                    $chin_data['chin_level'] = 'A';//客户等级
                    $chin_data['chin_type'] = 2;//铺货类型1是铺货2不是铺货
                    $chin_data['chin_owe_day'] = 0;//可欠天数
                    $chin_data['chin_caution_day'] = 0;//警示天数
                    $chin_data['chin_update_time'] = date('Y-m-d H:i:s');
                    $chin_res = DB::table('channel_info')->insertGetId($chin_data);
                }
                $chuc_res = DB::table('channel_unit_change')->insertGetId($new_data);
                unset($new_data);
            } else {
                $edit_data['chuc_chun_id'] = $chun_id;
                // 判断客户单位名称是否存在
                $chun_unit_name = DB::table('channel_unit')
                    ->where('chun_cid', $cid)
                    ->where('chun_superior_shop_id', $superior_shop_id)
                    ->where('chun_search_letter', $value['chun_search_letter'])
                    ->value('chun_unit_name');
                $edit_data['chuc_chun_name'] = $value['chun_name'];//姓名名称;
                $edit_data['chuc_chun_phone'] = $value['chun_phone'];//手机号
                if ($chun_unit_name != $info['chun_unit_name']) {
                    $edit_data['chuc_old_chun_unit_name'] = $chun_unit_name;//客户单位名称
                    $edit_data['chuc_chun_unit_name'] = $info['chun_unit_name'];//客户单位名称
                    $edit_data['chuc_type'] = 2;
                    $edit_data['chuc_update_time'] = date('Y-m-d H:i:s');
                    $chuc_res = DB::table('channel_unit_change')->insertGetId($edit_data);
                }
                $res = DB::table('channel_unit')
                    ->where('chun_id', $chun_id)
                    ->update($info);
                // dump($res);die;
                if ($chun_id) {
                    $chin_data['chin_chun_id'] = $chun_id;//客户单位id
                    $chin_data['chin_level'] = 'A';//客户等级
                    $chin_data['chin_type'] = 2;//铺货类型1是铺货2不是铺货
                    $chin_data['chin_owe_day'] = 0;//可欠天数
                    $chin_data['chin_caution_day'] = 0;//警示天数
                    $chin_data['chin_update_time'] = date('Y-m-d H:i:s');
                    $chin_res = DB::table('channel_info')
                        ->where('chin_chun_id', $chun_id)
                        ->update($chin_data);
                }
                unset($edit_data);
            }
            // dump($res);die;
            unset($res);
            unset($info);
            unset($supplier);
            unset($chin_data);
            unset($chin_res);
            unset($chuc_res);
        }
        echo 333;
        DB::commit();
    }

    // 厦门门店导入商品数据
    public function excelGoods0508($submit_data, $data)
    {
        DB::beginTransaction();
        $cid = 1;//公司id
        $superior_shop_id = 1;//总店id
        $shop_id = 1;//门店id
        // $ware_freight_space = 'A1';//仓位名称
        $goods_data = [];
        $defeated = [];

        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($submit_data['api_token']);
        foreach ($data as $key => $value) {
            dump($value);
            die;
            if (empty($value['goo_bra_name'])) {
                $bra_id = 0;
            } else {
                $bra_id = DB::table('brand')
                            ->where('bra_cid', $cid)
                            ->where('bra_shop_id', $shop_id)
                            ->where('bra_superior_shop_id', $superior_shop_id)
                            ->where('bra_delete', 1)
                            ->where('bra_name', $value['goo_bra_name'])
                            ->value('bra_id');
                if (empty($bra_id)) {
                    $bra_data['bra_cid'] = $cid;
                    $bra_data['bra_shop_id'] = $shop_id;
                    $bra_data['bra_superior_shop_id'] = $superior_shop_id;
                    $bra_data['bra_name'] = $value['goo_bra_name'];
                    $bra_data['bra_create_time'] = date('Y-m-d H:i:s');
                    $bra_data['bra_goods_number'] = 1;
                    $bra_id = DB::table('brand')->insertGetId($bra_data);
                } else {
                    DB::table('brand')->where('bra_id', $bra_id)->increment('bra_goods_number');
                }
            }

            $cate_id = DB::table('category')
                        ->where('cate_cid', $cid)
                        ->where('cate_shop_id', $shop_id)
                        ->where('cate_superior_shop_id', $superior_shop_id)
                        ->where('cate_delete', 1)
                        ->where('cate_name', $value['goo_cate_name'])
                        ->value('cate_id');
            if (empty($cate_id)) {
                $chty_data['cate_cid'] = $cid;
                $chty_data['cate_shop_id'] = $shop_id;
                $chty_data['cate_superior_shop_id'] = $superior_shop_id;
                $chty_data['cate_name'] = $value['goo_cate_name'];
                $chty_data['cate_create_time'] = date('Y-m-d H:i:s');
                $chty_data['cate_goods_number'] = 1;
                $cate_id = DB::table('category')->insertGetId($chty_data);
            } else {
                DB::table('category')->where('cate_id', $cate_id)->increment('cate_goods_number');
            }

            $info['goo_cid'] = $cid;
            $info['goo_superior_shop_id'] = $superior_shop_id;
            $info['goo_shop_id'] = $shop_id;
            $info['goo_bra_name'] = $value['goo_bra_name'];
            $info['goo_bra_id'] = $bra_id;
            $info['goo_cate_name'] = $value['goo_cate_name'];
            $info['goo_cate_id'] = $cate_id;
            $info['goo_name'] = $value['goo_name'];
            $info['goo_goods_encode'] = $value['goo_goods_encode'];
            $goo_purchase_price = $value['goo_purchase_price'] ? round($value['goo_purchase_price'], 2) : 0;
            $goo_wholesale_price = $value['goo_wholesale_price'] ? round($value['goo_wholesale_price'], 2) : 0;
            $goo_price = $value['goo_price'] ? $value['goo_price'] : 0;
            $info['goo_purchase_price'] = $goo_purchase_price * 100;
            $info['goo_wholesale_price'] = $goo_wholesale_price * 100;
            $info['goo_price'] = $goo_price * 100;
            $info['goo_type'] = 4;//商品类型 1正常商品2赠品商品3活动商品4旧货商品

            $supplier = [];
            if (!empty($value['attr_guige']) && $value['attr_guige'] != 'NULL') {
                $supplier[] = ['key'=>'规格','value'=>$value['attr_guige']];
            }
            if (!empty($value['attr_gongyingshang']) && $value['attr_gongyingshang'] != 'NULL') {
                $supplier[] = ['key'=>'供应商','value'=>$value['attr_gongyingshang']];
            }
            if (!empty($supplier)) {
                $info['goo_attribute'] = json_encode($supplier);
            } else {
                $info['goo_attribute'] = '';
            }

            if (!empty($value['goo_name'])) {
                // 判断商品是否存在
                $goo_id = DB::table('goods')
                            ->where('goo_cid', $cid)
                            ->where('goo_shop_id', $shop_id)
                            ->where('goo_superior_shop_id', $superior_shop_id)
                            ->where('goo_type', 4)
                            ->where('goo_delete', 1)
                            ->where('goo_goods_encode', $value['goo_goods_encode'])
                            ->value('goo_id');
                if (empty($goo_id)) {
                    $goo_id = DB::table('goods')->insertGetId($info);
                }
                // 添加商品数据
                if (empty($value['kucun'])) {
                    // 没有库存的就不再添加库存数量
                    continue;
                }

                // 添加商品库存，查询仓库id
                $ware_id = DB::table('warehouse')
                    ->where('ware_cid', $cid)
                    ->where('ware_superior_shop_id', $superior_shop_id)
                    ->where('ware_freight_space', $value['kuwei'])//仓位名称
                    ->value('ware_id');
                // dump($ware_id);
                if (empty($ware_id)) {
                } else {
                    $res = DB::table('warehouse_onhand')
                        ->where('waon_ware_id', $ware_id)
                        ->where('waon_class', $value['waon_class'])
                        ->increment('waon_all_amount', $value['kucun']);
                    $res = DB::table('warehouse_onhand')
                        ->where('waon_ware_id', $ware_id)
                        ->where('waon_class', $value['waon_class'])
                        ->increment('waon_stock_fine_amount', $value['kucun']);
                    if (empty($res)) {
                        $value['yuanyin'] = '仓库库存添加失败';
                        array_push($defeated, $value);
                        continue;
                    }
                    $wago_id= DB::table('warehouse_goods')
                        ->where('wago_ware_id', $ware_id)
                        ->where('wago_goo_id', $goo_id)
                        ->where('wago_class', $value['waon_class'])
                        ->value('wago_id');
                    //判断仓库里是否有此商品
                    if (empty($wago_id)) {
                        // 仓库内没有商品，添加商品
                        $warehouse_goods['wago_ware_id'] = $ware_id;//仓库
                        $warehouse_goods['wago_class'] = $value['waon_class'];
                        $warehouse_goods['wago_goo_id'] = $goo_id;//商品
                        $warehouse_goods['wago_stock_number'] = $value['kucun'];//良品库存
                        $wago_res = DB::table('warehouse_goods')->insert($warehouse_goods);
                        if (empty($wago_res)) {
                            $value['yuanyin'] = '添加仓库商品失败';
                            array_push($defeated, $value);
                            continue;
                        }
                        unset($warehouse_goods);
                    } else {
                        // 仓库内已经有商品了，更改库存数量
                        $res= DB::table('warehouse_goods')
                            ->where('wago_ware_id', $ware_id)
                            ->where('wago_goo_id', $goo_id)
                            ->where('wago_class', $value['waon_class'])
                            ->update(['wago_stock_number'=>$value['kucun'],'wago_update_time',date('Y-m-d H:i:s')]);
                        if (empty($res)) {
                            $value['yuanyin'] = '修改仓库商品失败库存失败';
                            array_push($defeated, $value);
                            continue;
                        }
                    }
                    // dump($info);
                    // dump($value);
                    // 添加进销存
                    $goo_id_arr[] = $goo_id;
                    $purchase_goo_actual_count[$goo_id] = $value['kucun'];
                    $purchase_goo_actual_price[$goo_id] = $goo_purchase_price;
                    $purchase_return = StockSellStorageGoods::purchaseSalesImport(
                        $user_info,//用户信息
                        1,//进销存计算方式：1先进先出2移动加权平均法3无成本
                        1,//类型：1采购，2销出，3调拨
                        $ware_id,//仓库id
                        $value['waon_class'],//仓库类别
                        $goo_id_arr,//数组，商品id
                        $purchase_goo_actual_count,//数组，商品数量；[商品id=>商品数量]
                        $purchase_goo_actual_price, //数组，商品金额，成本价(不乘以100)；[商品id=>商品金额]
                        1 //进销存的移动加权平均法算法类型：1计算平均价2不计算平均价【退换回收时不计算平均价】
                    );
                    // dump($purchase_return);die;
                }
                // echo 444;die;
                unset($goo_id);
                unset($goo_id_arr);
                unset($purchase_goo_actual_count);
                unset($purchase_goo_actual_price);
                unset($ware_id);
            }
            // echo 888;die;
            unset($bra_data);
            unset($bra_id);
            unset($chty_data);
            unset($cate_id);
            unset($info);
            unset($supplier);
        }
        echo 333;
        dump($defeated);
        DB::commit();
    }

    // 厦门门店导入商品数据
    public function excelGoods($submit_data, $data)
    {
        DB::beginTransaction();
        $cid = 1;//公司id
        $superior_shop_id = 1;//总店id
        $shop_id = 1;//门店id
        $ware_freight_space = 'A1';//仓位名称
        $goods_data = [];
        $defeated = [];

        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($submit_data['api_token']);
        foreach ($data as $key => $value) {
            // dump($value);
            if (empty($value['goo_bra_name'])) {
                $bra_id = 0;
            } else {
                $bra_id = DB::table('brand')
                            ->where('bra_cid', $cid)
                            ->where('bra_shop_id', $shop_id)
                            ->where('bra_superior_shop_id', $superior_shop_id)
                            ->where('bra_name', $value['goo_bra_name'])
                            ->value('bra_id');
                if (empty($bra_id)) {
                    $bra_data['bra_cid'] = $cid;
                    $bra_data['bra_shop_id'] = $shop_id;
                    $bra_data['bra_superior_shop_id'] = $superior_shop_id;
                    $bra_data['bra_name'] = $value['goo_bra_name'];
                    $bra_data['bra_create_time'] = date('Y-m-d H:i:s');
                    $bra_data['bra_goods_number'] = 1;
                    $bra_id = DB::table('brand')->insertGetId($bra_data);
                } else {
                    DB::table('brand')->where('bra_id', $bra_id)->increment('bra_goods_number');
                }
            }

            $cate_id = DB::table('category')
                        ->where('cate_cid', $cid)
                        ->where('cate_shop_id', $shop_id)
                        ->where('cate_superior_shop_id', $superior_shop_id)
                        ->where('cate_name', $value['goo_cate_name'])
                        ->value('cate_id');
            if (empty($cate_id)) {
                $chty_data['cate_cid'] = $cid;
                $chty_data['cate_shop_id'] = $shop_id;
                $chty_data['cate_superior_shop_id'] = $superior_shop_id;
                $chty_data['cate_name'] = $value['goo_cate_name'];
                $chty_data['cate_create_time'] = date('Y-m-d H:i:s');
                $chty_data['cate_goods_number'] = 1;
                $cate_id = DB::table('category')->insertGetId($chty_data);
            } else {
                DB::table('category')->where('cate_id', $cate_id)->increment('cate_goods_number');
            }

            $info['goo_cid'] = $cid;
            $info['goo_superior_shop_id'] = $superior_shop_id;
            $info['goo_shop_id'] = $shop_id;
            $info['goo_bra_name'] = $value['goo_bra_name'];
            $info['goo_bra_id'] = $bra_id;
            $info['goo_cate_name'] = $value['goo_cate_name'];
            $info['goo_cate_id'] = $cate_id;
            $info['goo_name'] = $value['goo_name'];
            $info['goo_goods_encode'] = $value['goo_goods_encode'];
            $goo_purchase_price = $value['goo_purchase_price'] ? $value['goo_purchase_price'] : 0;
            $goo_wholesale_price = $value['goo_wholesale_price'] ? $value['goo_wholesale_price'] : 0;
            $goo_price = $value['goo_price'] ? $value['goo_price'] : 0;
            $info['goo_purchase_price'] = $goo_purchase_price * 100;
            $info['goo_wholesale_price'] = $goo_wholesale_price * 100;
            $info['goo_price'] = $goo_price * 100;

            $supplier = [];
            if (!empty($value['attr_guige']) && $value['attr_guige'] != 'NULL') {
                $supplier[] = ['key'=>'规格','value'=>$value['attr_guige']];
            }
            if (!empty($value['attr_gongyingshang']) && $value['attr_gongyingshang'] != 'NULL') {
                $supplier[] = ['key'=>'供应商','value'=>$value['attr_gongyingshang']];
            }
            if (!empty($supplier)) {
                $info['goo_attribute'] = json_encode($supplier);
            } else {
                $info['goo_attribute'] = '';
            }
            // dump($info);die;
            if (!empty($value['goo_name'])) {
                // 添加商品数据
                $goo_id = DB::table('goods')->insertGetId($info);
                if (empty($value['kucun'])) {
                    // 没有库存的就不再添加库存数量
                    continue;
                }

                // 添加商品库存，查询仓库id
                $ware_id = DB::table('warehouse')
                    ->where('ware_cid', $cid)
                    ->where('ware_superior_shop_id', $superior_shop_id)
                    ->where('ware_freight_space', $ware_freight_space)//仓位名称
                    ->value('ware_id');
                if (empty($ware_id)) {
                } else {
                    $res = DB::table('warehouse')
                    ->where('ware_id', $ware_id)
                    ->increment('ware_all_stock', $value['kucun']);
                    if (empty($res)) {
                        $value['yuanyin'] = '仓库库存添加失败';
                        array_push($defeated, $value);
                        continue;
                    }
                    $wago_id= DB::table('warehouse_goods')
                        ->where('wago_ware_id', $ware_id)
                        ->where('wago_goo_id', $goo_id)
                        ->value('wago_id');
                    //判断仓库里是否有此商品
                    if (empty($wago_id)) {
                        $warehouse_goods['wago_ware_id'] = $ware_id;//仓库
                        $warehouse_goods['wago_goo_id'] = $goo_id;//商品
                        $warehouse_goods['wago_stock_number'] = $value['kucun'];//良品库存
                        $wago_res = DB::table('warehouse_goods')->insert($warehouse_goods);
                        if (empty($wago_res)) {
                            $value['yuanyin'] = '添加仓库商品失败';
                            array_push($defeated, $value);
                            continue;
                        }
                        unset($warehouse_goods);
                    } else {
                        $res= DB::table('warehouse_goods')
                            ->where('wago_ware_id', $ware_id)
                            ->where('wago_goo_id', $goo_id)
                            ->update(['wago_stock_number'=>$value['kucun'],'wago_update_time',date('Y-m-d H:i:s')]);
                        if (empty($res)) {
                            $value['yuanyin'] = '修改仓库商品失败库存失败';
                            array_push($defeated, $value);
                            continue;
                        }
                    }
                    // dump($value);
                    // 添加进销存
                    $StockingSelling = StockingSelling::purchase2(
                        $user_info, //用户数据
                        [$goo_id], //商品id
                        [$value['kucun']], //数量
                        [$goo_purchase_price * 100], //采购金额
                        $ware_id, //仓库id
                        1 //1=采入   2=销出
                    );
                }
                unset($goo_id);
                unset($ware_id);
            }
            unset($bra_data);
            unset($bra_id);
            unset($chty_data);
            unset($cate_id);
            unset($info);
            unset($supplier);
        }
        dump($defeated);
        // echo 333;die;
        DB::commit();
    }

    // 厦门门店导入商品库存
    public function xmGoodsStock($submit_data, $data)
    {
        DB::beginTransaction();
        $cid = 1;//公司id
        $superior_shop_id = 1;//总店id
        $shop_id = 1;//门店id
        $goods_data = [];
        $defeated = [];
        $ware_id = 9;//仓库id
        $kucun = 1000;//库存数量

        // 获取当前操作账号信息
        foreach ($data as $key => $value) {
            dump($value);
            // die;
            $goo_id = DB::table('goods')
                ->where('goo_cid', $cid)
                ->where('goo_superior_shop_id', $superior_shop_id)
                ->where('goo_goods_encode', $value['goo_goods_encode'])
                ->where('goo_delete', 1)
                ->value('goo_id');
            // 没有的商品就跳过
            if (empty($goo_id)) {
                continue;
            }
            $value['kucun'] = 1000;
            $res = DB::table('warehouse_onhand')
                ->where('waon_ware_id', $ware_id)
                ->where('waon_class', 1)
                ->increment('waon_all_amount', $value['kucun']);
            $res2 = DB::table('warehouse_onhand')
                ->where('waon_ware_id', $ware_id)
                ->where('waon_class', 1)
                ->increment('waon_stock_fine_amount', $value['kucun']);

            if (empty($res) || empty($res2)) {
                $value['yuanyin'] = '仓库库存添加失败';
                array_push($defeated, $value);
                continue;
            }
            $wago_id= DB::table('warehouse_goods')
                ->where('wago_ware_id', $ware_id)
                ->where('wago_goo_id', $goo_id)
                ->where('wago_class', 1)
                ->value('wago_id');
            // dump($wago_id);
            //判断仓库里是否有此商品
            if (empty($wago_id)) {
                $warehouse_goods['wago_ware_id'] = $ware_id;//仓库
                $warehouse_goods['wago_class'] = 1;//仓库类别
                $warehouse_goods['wago_goo_id'] = $goo_id;//商品
                $warehouse_goods['wago_stock_number'] = $value['kucun'];//良品库存
                $wago_res = DB::table('warehouse_goods')->insert($warehouse_goods);
                // dump($wago_res);
                // die;
                if (empty($wago_res)) {
                    $value['yuanyin'] = '添加仓库商品失败';
                    array_push($defeated, $value);
                    continue;
                }
                unset($warehouse_goods);
            } else {
                dump($value);
                // $res= DB::table('warehouse_goods')
                //     ->where('wago_ware_id',$ware_id)
                //     ->where('wago_goo_id',$goo_id)
                //     ->where('wago_class',1)
                //     ->update(['wago_stock_number'=>$value['kucun'],'wago_update_time',date('Y-m-d H:i:s')]);
                // if(empty($res)){
                //     $value['yuanyin'] = '修改仓库商品失败库存失败';
                //     array_push($defeated,$value);
                //     continue;
                // }
            }
            unset($bra_data);
            unset($bra_id);
            unset($chty_data);
            unset($cate_id);
            unset($info);
            unset($supplier);
        }
        echo 333;
        DB::commit();
    }

    // 杭州石总商品库存导入
    public function hzExcelGoods($submit_data, $data)
    {
        DB::beginTransaction();
        $cid = 1;//公司id
        // $superior_shop_id = 47;//总店id
        $superior_shop_id = 42;//总店id
        $shop_id = 42;//门店id
        $goods_data = [];
        $defeated = [];
        // $ware_id = 62;//仓库id
        $ware_id = 52;//仓库id

        // 获取当前操作账号信息
        foreach ($data as $key => $value) {
            dump($value);
            die;
            $goo_id = DB::table('goods')
                ->where('goo_cid', $cid)
                ->where('goo_superior_shop_id', $superior_shop_id)
                ->where('goo_name', $value['goo_goods_encode'])
                ->where('goo_delete', 1)
                ->value('goo_id');
            // 已经有的商品就跳过
            if (!empty($goo_id)) {
                continue;
            }
            if (!isset($value['goo_bra_name'])) {
                $value['goo_bra_name'] = '';
            }
            if (empty($value['goo_bra_name'])) {
                $bra_id = 0;
            } else {
                $bra_id = DB::table('brand')
                            ->where('bra_cid', $cid)
                            ->where('bra_shop_id', $shop_id)
                            ->where('bra_superior_shop_id', $superior_shop_id)
                            ->where('bra_delete', 1)
                            ->where('bra_name', $value['goo_bra_name'])
                            ->value('bra_id');
                if (empty($bra_id)) {
                    $bra_data['bra_cid'] = $cid;
                    $bra_data['bra_shop_id'] = $shop_id;
                    $bra_data['bra_superior_shop_id'] = $superior_shop_id;
                    $bra_data['bra_name'] = $value['goo_bra_name'];
                    $bra_data['bra_create_time'] = date('Y-m-d H:i:s');
                    $bra_data['bra_goods_number'] = 1;
                    $bra_id = DB::table('brand')->insertGetId($bra_data);
                } else {
                    DB::table('brand')->where('bra_id', $bra_id)->increment('bra_goods_number');
                }
            }
            if (empty($value['goo_name'])) {
                $cate_id = 0;
            } else {
                $cate_id = DB::table('category')
                            ->where('cate_cid', $cid)
                            ->where('cate_shop_id', $shop_id)
                            ->where('cate_superior_shop_id', $superior_shop_id)
                            ->where('cate_delete', 1)
                            ->where('cate_name', $value['goo_name'])
                        ->value('cate_id');
                if (empty($cate_id)) {
                    $chty_data['cate_cid'] = $cid;
                    $chty_data['cate_shop_id'] = $shop_id;
                    $chty_data['cate_superior_shop_id'] = $superior_shop_id;
                    $chty_data['cate_name'] = $value['goo_name'];
                    $chty_data['cate_create_time'] = date('Y-m-d H:i:s');
                    $chty_data['cate_goods_number'] = 1;
                    $cate_id = DB::table('category')->insertGetId($chty_data);
                } else {
                    DB::table('category')->where('cate_id', $cate_id)->increment('cate_goods_number');
                }
            }

            $supplier = [];
            if (!empty($value['attr_chandi']) && $value['attr_chandi'] != 'NULL') {
                $supplier[] = ['key'=>'产地','value'=>$value['attr_chandi']];
            }
            if (!empty($value['attr_xinghao']) && $value['attr_xinghao'] != 'NULL') {
                $supplier[] = ['key'=>'型号','value'=>$value['attr_xinghao']];
            }
            if (!empty($value['attr_danwei']) && $value['attr_danwei'] != 'NULL') {
                $supplier[] = ['key'=>'单位','value'=>$value['attr_danwei']];
            }
            if (!empty($supplier)) {
                $info['goo_attribute'] = json_encode($supplier);
            } else {
                $info['goo_attribute'] = '';
            }

            $info['goo_cid'] = $cid;
            $info['goo_superior_shop_id'] = $superior_shop_id;
            $info['goo_shop_id'] = $shop_id;
            $info['goo_bra_name'] = $value['goo_bra_name'];
            $info['goo_bra_id'] = $bra_id;
            $info['goo_cate_name'] = $value['goo_name'];
            $info['goo_cate_id'] = $cate_id;
            $info['goo_name'] = $value['goo_goods_encode'];
            // $info['goo_goods_encode'] = $value['goo_goods_encode'];
            $goo_price = $value['goo_price'] ? $value['goo_price'] : 0;
            $goo_wholesale_price = $value['goo_wholesale_price'] ? $value['goo_wholesale_price'] : 0;
            $goo_purchase_price = $value['goo_purchase_price'] ? $value['goo_purchase_price'] : 0;
            $info['goo_purchase_price'] = $goo_purchase_price * 100;
            $info['goo_wholesale_price'] = $goo_wholesale_price * 100;
            $info['goo_price'] = $goo_price * 100;
            // dump($info);die;

            $res = $goo_id = DB::table('goods')->insertGetId($info);
            if ($goo_id && $value['kucun'] > 0) {
                $res = DB::table('warehouse_onhand')
                    ->where('waon_ware_id', $ware_id)
                    ->where('waon_class', 1)
                    ->increment('waon_all_amount', $value['kucun']);
                $res2 = DB::table('warehouse_onhand')
                    ->where('waon_ware_id', $ware_id)
                    ->where('waon_class', 1)
                    ->increment('waon_stock_fine_amount', $value['kucun']);

                if (empty($res) || empty($res2)) {
                    $value['yuanyin'] = '仓库库存添加失败';
                    array_push($defeated, $value);
                    continue;
                }

                $wago_id= DB::table('warehouse_goods')
                    ->where('wago_ware_id', $ware_id)
                    ->where('wago_goo_id', $goo_id)
                    ->where('wago_class', 1)
                    ->value('wago_id');
                dump($wago_id);
                //判断仓库里是否有此商品
                if (empty($wago_id)) {
                    $warehouse_goods['wago_ware_id'] = $ware_id;//仓库
                    $warehouse_goods['wago_class'] = 1;//仓库类别
                    $warehouse_goods['wago_goo_id'] = $goo_id;//商品
                    $warehouse_goods['wago_stock_number'] = $value['kucun'];//良品库存
                    // $warehouse_goods['wago_stock_sell_storage_quantity'] = $value['kucun'];//商品进销存数量
                    $wago_res = DB::table('warehouse_goods')->insert($warehouse_goods);
                    if (empty($wago_res)) {
                        $value['yuanyin'] = '添加仓库商品失败';
                        array_push($defeated, $value);
                        continue;
                    }
                    unset($warehouse_goods);
                } else {
                    dump($value);
                    // $res= DB::table('warehouse_goods')
                    //     ->where('wago_ware_id',$ware_id)
                    //     ->where('wago_goo_id',$goo_id)
                    //     ->where('wago_class',1)
                    //     ->update(['wago_stock_number'=>$value['kucun'],'wago_update_time',date('Y-m-d H:i:s')]);
                    // if(empty($res)){
                    //     $value['yuanyin'] = '修改仓库商品失败库存失败';
                    //     array_push($defeated,$value);
                    //     continue;
                    // }
                }
            }
            // dump($res);die;
            unset($bra_data);
            unset($bra_id);
            unset($chty_data);
            unset($cate_id);
            unset($info);
            unset($supplier);
        }
        echo 333;
        DB::commit();
    }

    // 杭州石总客户单位数据导入
    public function hzExcelChannel($submit_data, $data)
    {
        DB::beginTransaction();
        $cid = 1;//公司id
        // $superior_shop_id = 47;//总店id
        $superior_shop_id = 42;//总店id
        $shop_id = 42;//门店id

        // 获取当前操作账号信息
        foreach ($data as $key => $value) {
            dump($value);
            die;

            // 渠道类型
            $chty_id = DB::table('channel_type')
                ->where('chty_cid', $cid)
                ->where('chty_shop_id', $shop_id)
                ->where('chty_name', $value['chun_chty_id'])
                ->where('chty_delete', 1)
                ->value('chty_id');
            if (empty($chty_id)) {
                $chty_data['chty_cid'] = $cid;
                $chty_data['chty_superior_shop_id'] = $shop_id;
                $chty_data['chty_shop_id'] = $shop_id;
                $chty_data['chty_name'] = $value['chun_chty_id'];
                $chty_data['chty_channel_number'] = 1;
                $chty_data['chty_create_time'] = date('Y-m-d H:i:s');
                $chty_id = DB::table('channel_type')->insertGetId($chty_data);
            } else {
                DB::table('channel_type')->where('chty_id', $chty_id)->increment('chty_channel_number');
            }

            $chun_adm_id = DB::table('admin')
                            ->where('adm_cid', $cid)
                            ->where('adm_shop_id', $superior_shop_id)
                            ->where('adm_name', $value['chun_adm_id'])
                            ->value('adm_id');
            if (!$chun_adm_id) {
                $chun_adm_id = 0;
            }
            $supplier = [];
            if (!empty($value['chun_name'])) {
                $supplier[] = ['key'=>$value['chun_name'], 'value'=>$value['chun_phone'], 'default'=>1];
            }
            if (!empty($supplier)) {
                $chin_data['chin_data'] = json_encode($supplier);
            } else {
                $chin_data['chin_data'] = '';
            }

            $info['chun_cid'] = $cid;
            $info['chun_superior_shop_id'] = $superior_shop_id;
            $info['chun_shop_id'] = $shop_id;
            $info['chun_adm_id'] = $chun_adm_id;
            $info['chun_search_letter'] = $value['chun_search_letter'];
            $info['chun_unit_name'] = $value['chun_unit_name'];
            $info['chun_name'] = $value['chun_name'];
            $info['chun_phone'] = $value['chun_phone'];
            $info['chun_chty_id'] = $chty_id;
            $info['chun_payment_way'] = $value['chun_payment_way'];
            $info['chun_province'] = $value['chun_province'];
            $info['chun_city'] = $value['chun_city'];
            $info['chun_county'] = $value['chun_county'];
            $info['chun_address'] = $value['chun_address'];
            $info['chun_create_time'] = date('Y-m-d H:i:s');
            // dump($info);die;
            $res = DB::table('channel_unit')->insertGetId($info);
            // dump($res);die;
            if ($res) {
                $chin_data['chin_chun_id'] = $res;
                $chin_data['chin_level'] = $value['chin_level'];
                $chin_data['chin_update_time'] = date('Y-m-d H:i:s');
                $chin_res = DB::table('channel_info')->insertGetId($chin_data);
            }
            // dump($res);die;
            unset($res);
            unset($info);
            unset($supplier);
            unset($chin_data);
            unset($chin_res);
        }
        echo 333;
        DB::commit();
    }

    // 速电快保商品加个导入-0814
    public function sdkbExcelGoods0814($submit_data, $data)
    {
        DB::beginTransaction();
        $cid = 3;//公司id
        $superior_shop_id = 26;//总店id
        $shop_id = 26;//门店id
        $goods_data = [];
        $defeated = [];

        // 获取当前操作账号信息
        foreach ($data as $key => $value) {
            // dump($value);
            $goo_id = DB::table('goods')
                ->where('goo_cid', $cid)
                ->where('goo_superior_shop_id', $superior_shop_id)
                ->where('goo_name', $value['goo_name'])
                ->where('goo_delete', 1)
                ->value('goo_id');
            // 没有的商品就跳过
            if (empty($goo_id)) {
                continue;
            }

            $res = $goo_id = DB::table('goods')->insert($info);
        }
        echo 333;
        DB::commit();
    }

    // 速电快保商品数据导入
    public function sdkbExcelGoods2($submit_data, $data)
    {
        DB::beginTransaction();
        $cid = 3;//公司id
        $superior_shop_id = 26;//总店id
        $shop_id = 26;//门店id
        $goods_data = [];
        $defeated = [];

        // 获取当前操作账号信息
        foreach ($data as $key => $value) {
            // dump($value);
            $goo_id = DB::table('goods')
                ->where('goo_cid', $cid)
                ->where('goo_superior_shop_id', $superior_shop_id)
                ->where('goo_goods_encode', $value['goo_goods_encode'])
                ->where('goo_delete', 1)
                ->value('goo_id');
            // 已经有的商品就跳过
            if (!empty($goo_id)) {
                continue;
            }
            if (!isset($value['goo_bra_name'])) {
                $value['goo_bra_name'] = '';
            }
            if (empty($value['goo_bra_name'])) {
                $bra_id = 0;
            } else {
                $bra_id = DB::table('brand')
                            ->where('bra_cid', $cid)
                            ->where('bra_shop_id', $shop_id)
                            ->where('bra_superior_shop_id', $superior_shop_id)
                            ->where('bra_delete', 1)
                            ->where('bra_name', $value['goo_bra_name'])
                            ->value('bra_id');
                if (empty($bra_id)) {
                    $bra_data['bra_cid'] = $cid;
                    $bra_data['bra_shop_id'] = $shop_id;
                    $bra_data['bra_superior_shop_id'] = $superior_shop_id;
                    $bra_data['bra_name'] = $value['goo_bra_name'];
                    $bra_data['bra_create_time'] = date('Y-m-d H:i:s');
                    $bra_data['bra_goods_number'] = 1;
                    $bra_id = DB::table('brand')->insertGetId($bra_data);
                } else {
                    DB::table('brand')->where('bra_id', $bra_id)->increment('bra_goods_number');
                }
            }

            $cate_id = DB::table('category')
                        ->where('cate_cid', $cid)
                        ->where('cate_shop_id', $shop_id)
                        ->where('cate_superior_shop_id', $superior_shop_id)
                        ->where('cate_delete', 1)
                        ->where('cate_name', $value['goo_cate_name'])
                        ->value('cate_id');
            if (empty($cate_id)) {
                $chty_data['cate_cid'] = $cid;
                $chty_data['cate_shop_id'] = $shop_id;
                $chty_data['cate_superior_shop_id'] = $superior_shop_id;
                $chty_data['cate_name'] = $value['goo_cate_name'];
                $chty_data['cate_create_time'] = date('Y-m-d H:i:s');
                $chty_data['cate_goods_number'] = 1;
                $cate_id = DB::table('category')->insertGetId($chty_data);
            } else {
                DB::table('category')->where('cate_id', $cate_id)->increment('cate_goods_number');
            }

            $supplier = [];
            if (!empty($value['attr_guige']) && $value['attr_guige'] != 'NULL') {
                $supplier[] = ['key'=>'规格','value'=>$value['attr_guige']];
            }
            if (!empty($value['attr_danwei']) && $value['attr_danwei'] != 'NULL') {
                $supplier[] = ['key'=>'单位','value'=>$value['attr_danwei']];
            }
            if (!empty($supplier)) {
                $info['goo_attribute'] = json_encode($supplier);
            } else {
                $info['goo_attribute'] = '';
            }

            $info['goo_cid'] = $cid;
            $info['goo_superior_shop_id'] = $superior_shop_id;
            $info['goo_shop_id'] = $shop_id;
            $info['goo_bra_name'] = $value['goo_bra_name'];
            $info['goo_bra_id'] = $bra_id;
            $info['goo_cate_name'] = $value['goo_cate_name'];
            $info['goo_cate_id'] = $cate_id;
            $info['goo_name'] = $value['goo_name'];
            $info['goo_goods_encode'] = $value['goo_goods_encode'];
            $goo_price = $value['goo_price'] ? $value['goo_price'] : 0;
            $info['goo_purchase_price'] = 0;
            $info['goo_wholesale_price'] = 0;
            $info['goo_price'] = 0;
            // dump($info);die;

            $res = $goo_id = DB::table('goods')->insert($info);
            dump($res);
            unset($bra_data);
            unset($bra_id);
            unset($chty_data);
            unset($cate_id);
            unset($info);
            unset($supplier);
        }
        echo 333;
        DB::commit();
    }

    // 速电快保门店数据导入
    public function sdkbExcelGoods($submit_data, $data)
    {
        DB::beginTransaction();
        $cid = 3;//公司id
        $superior_shop_id = 26;//总店id
        $shop_id = 26;//门店id
        $ware_freight_space = 'D1';//仓位名称
        $goods_data = [];
        $defeated = [];
        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($submit_data['api_token']);
        foreach ($data as $key => $value) {
            // dump($value);die;

            $cate_id = 37;
            // DB::table('category')->where('cate_id',$cate_id)->increment('cate_goods_number');

            $info['goo_cid'] = $cid;
            $info['goo_superior_shop_id'] = $superior_shop_id;
            $info['goo_shop_id'] = $shop_id;
            $info['goo_bra_name'] = '';
            $info['goo_bra_id'] = 0;
            $info['goo_cate_name'] = '蓄电池';
            $info['goo_cate_id'] = $cate_id;
            $info['goo_name'] = $value['goo_name'];
            $info['goo_goods_encode'] = $value['goo_goods_encode'];
            $info['goo_purchase_price'] = 0;
            $info['goo_wholesale_price'] = 0;
            $info['goo_price'] = 0;

            $supplier = [];
            if (!empty($value['attr_guige']) && $value['attr_guige'] != 'NULL') {
                $supplier[] = ['key'=>'规格','value'=>$value['attr_guige']];
            }
            if (!empty($value['attr_gongyingshang']) && $value['attr_gongyingshang'] != 'NULL') {
                $supplier[] = ['key'=>'供应商','value'=>$value['attr_gongyingshang']];
            }
            if (!empty($supplier)) {
                $info['goo_attribute'] = json_encode($supplier);
            } else {
                $info['goo_attribute'] = '';
            }
            // dump($info);die;
            if (!empty($value['goo_goods_encode'])) {
                // 查询商品表是否已有商品
                $goo_id = DB::table('goods')
                ->where('goo_cid', $cid)
                ->where('goo_superior_shop_id', $superior_shop_id)
                ->where('goo_goods_encode', $value['goo_goods_encode'])
                ->value('goo_id');
                // dump($goo_id);die;
                if (empty($goo_id)) {
                    $value['yuanyin'] = '没有查询到商品';
                    array_push($defeated, $value);
                    continue;
                }

                // 添加商品数据
                // $goo_id = DB::table('goods')->insertGetId($info);
                if (empty($value['kucun'])) {
                    // 没有库存的就不再添加库存数量
                    continue;
                }

                // 添加商品库存，查询仓库id
                // $ware_id = DB::table('warehouse')
                //     ->where('ware_cid',$cid)
                //     ->where('ware_superior_shop_id',$superior_shop_id)
                //     ->where('ware_freight_space',$ware_freight_space)//仓位名称
                //     ->value('ware_id');
                $ware_id = 79;
                if (empty($ware_id)) {
                } else {
                    $res = DB::table('warehouse')
                    ->where('ware_id', $ware_id)
                    ->increment('ware_all_stock', $value['kucun']);
                    if (empty($res)) {
                        $value['yuanyin'] = '仓库库存添加失败';
                        array_push($defeated, $value);
                        continue;
                    }
                    $wago_id= DB::table('warehouse_goods')
                        ->where('wago_ware_id', $ware_id)
                        ->where('wago_goo_id', $goo_id)
                        ->value('wago_id');
                    //判断仓库里是否有此商品
                    if (empty($wago_id)) {
                        $warehouse_goods['wago_ware_id'] = $ware_id;//仓库
                        $warehouse_goods['wago_goo_id'] = $goo_id;//商品
                        $warehouse_goods['wago_stock_number'] = $value['kucun'];//良品库存
                        $wago_res = DB::table('warehouse_goods')->insert($warehouse_goods);
                        if (empty($wago_res)) {
                            $value['yuanyin'] = '添加仓库商品失败';
                            array_push($defeated, $value);
                            continue;
                        }
                        unset($warehouse_goods);
                    } else {
                        $res= DB::table('warehouse_goods')
                            ->where('wago_ware_id', $ware_id)
                            ->where('wago_goo_id', $goo_id)
                            ->update(['wago_stock_number'=>$value['kucun'],'wago_update_time',date('Y-m-d H:i:s')]);
                        if (empty($res)) {
                            $value['yuanyin'] = '修改仓库商品失败库存失败';
                            array_push($defeated, $value);
                            continue;
                        }
                    }
                    // dump($value);
                    // 添加进销存
                    $StockingSelling = StockingSelling::purchase2(
                        $user_info, //用户数据
                        [$goo_id], //商品id
                        [$value['kucun']], //数量
                        [0], //采购金额
                        $ware_id, //仓库id
                        1 //1=采入   2=销出
                    );
                }
                unset($goo_id);
                unset($ware_id);
            }
            unset($bra_data);
            unset($bra_id);
            unset($chty_data);
            unset($cate_id);
            unset($info);
            unset($supplier);
        }
        dump($defeated);
        // echo 333;die;
        DB::commit();
    }

    // 速电系统商品导入
    public function sdExcelGoods2($submit_data, $data)
    {
        DB::beginTransaction();
        $cid = 1;//公司id

        // 获取当前操作账号信息
        foreach ($data as $key => $value) {
            // dump($value);
            // exit;
            $sygo_system_goo_id = DB::table('system_goods')
                ->where('sygo_system_cid', $cid)
                ->where('sygo_system_goo_id', $value['sygo_system_goo_id'])
                ->where('sygo_delete', 1)
                ->value('sygo_id');
            // 已经有的商品修改品牌系列
            if (!empty($sygo_system_goo_id)) {
                continue;
            }
            $info['sygo_system_cid'] = $cid;
            $info['sygo_system_goo_id'] = $value['sygo_system_goo_id'];//第三方系统商品id
            $info['sygo_bra_name'] = $value['sygo_bra_name'];//品牌名称
            $info['sygo_cate_name'] = $value['sygo_cate_name'];//品类名称
            $info['sygo_name'] = $value['sygo_name'];//商品名称
            $info['sygo_goods_code'] = $value['sygo_goods_code'];//第三方商品编码
            $info['sygo_brse_name'] = $value['sygo_brse_name'];//品牌系列名称
            $info['sygo_delete'] = $value['sygo_delete'];//是否删除1正常2删除

            $res = $sygo_system_goo_id = DB::table('system_goods')->insert($info);
            dump($res);
            unset($info);
        }
        echo 333;
        DB::commit();
    }

    public function sdEditExcelGoods2($submit_data, $data)
    {
        DB::beginTransaction();
        $cid = 1;//公司id

        // 获取当前操作账号信息
        foreach ($data as $key => $value) {
            // dump($value);
            // exit;
            $sygo_system_goo_id = DB::table('system_goods')
                ->where('sygo_system_cid', $cid)
                ->where('sygo_system_goo_id', $value['sygo_system_goo_id'])
                ->where('sygo_delete', 1)
                ->value('sygo_id');
            
            // 已经有的商品修改品牌系列
            if (!empty($sygo_system_goo_id)) {
                // continue;
                $info['sygo_bra_name'] = $value['sygo_bra_name'];//品牌名称
                $info['sygo_cate_name'] = $value['sygo_cate_name'];//品类名称
                $info['sygo_name'] = $value['sygo_name'];//商品名称
                $info['sygo_goods_code'] = $value['sygo_goods_code'];//第三方商品编码
                $info['sygo_brse_name'] = $value['sygo_brse_name'];//品牌系列名称
                $info['sygo_update_time'] = date('Y-m-d H:i:s');
                $res = $sygo_system_goo_id = DB::table('system_goods')
                    ->where('sygo_system_goo_id', $value['sygo_system_goo_id'])
                    ->update($info);
                dump($res);
                unset($info);
                // exit;
            }
        }
        echo 333;
        DB::commit();
    }

    // 王重庆数据导入
    public function wcqExcelGoods($submit_data, $data)
    {
        DB::beginTransaction();
        $cid = 1;//公司id
        $superior_shop_id = 1;//总店id
        $shop_id = 1;//门店id
        $ware_freight_space = 'D1';//仓位名称
        $goods_data = [];
        $defeated = [];
        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($submit_data['api_token']);
        foreach ($data as $key => $value) {
            // dump($data);
            // exit;
            $info['goo_name'] = $value['goo_name'];
            $info['goo_goods_encode'] = $value['goo_goods_encode'];

            // dump($info);die;
            if (!empty($value['goo_goods_encode'])) {
                // 查询商品表是否已有商品
                $goo_id = DB::table('goods')
                    ->where('goo_cid', $cid)
                    ->where('goo_superior_shop_id', $superior_shop_id)
                    ->where('goo_goods_encode', $value['goo_goods_encode'])
                    ->value('goo_id');
                // dump($goo_id);die;
                if (empty($goo_id)) {
                    $value['yuanyin'] = '没有查询到商品';
                    array_push($defeated, $value);
                    continue;
                }

                if (empty($value['kucun'])) {
                    // 没有库存的就不再添加库存数量
                    continue;
                }

                $ware_id = 40;
                if (empty($ware_id)) {
                } else {
                    $res = DB::table('warehouse_onhand')
                        ->where('waon_ware_id', $ware_id)
                        ->where('waon_class', 1)
                        ->increment('waon_all_amount', $value['kucun']);
                    $rec = DB::table('warehouse_onhand')
                        ->where('waon_ware_id', $ware_id)
                        ->where('waon_class', 1)
                        ->increment('waon_stock_fine_amount', $value['kucun']);
                    if (empty($res) ||empty($rec)) {
                        $value['yuanyin'] = '仓库库存添加失败';
                        array_push($defeated, $value);
                        continue;
                    }
                    $wago_id= DB::table('warehouse_goods')
                        ->where('wago_ware_id', $ware_id)
                        ->where('wago_goo_id', $goo_id)
                        ->value('wago_id');
                    //判断仓库里是否有此商品
                    if (empty($wago_id)) {
                        $warehouse_goods['wago_ware_id'] = $ware_id;//仓库
                        $warehouse_goods['wago_goo_id'] = $goo_id;//商品
                        $warehouse_goods['wago_stock_number'] = $value['kucun'];//良品库存
                        $wago_res = DB::table('warehouse_goods')->insert($warehouse_goods);
                        if (empty($wago_res)) {
                            $value['yuanyin'] = '添加仓库商品失败';
                            array_push($defeated, $value);
                            continue;
                        }
                        unset($warehouse_goods);
                    } else {
                        $res= DB::table('warehouse_goods')
                            ->where('wago_ware_id', $ware_id)
                            ->where('wago_goo_id', $goo_id)
                            ->update(['wago_stock_number'=>$value['kucun'],'wago_update_time'=>date('Y-m-d H:i:s')]);
                        if (empty($res)) {
                            $value['yuanyin'] = '修改仓库商品失败库存失败';
                            array_push($defeated, $value);
                            continue;
                        }
                    }
                    // dump($value);
                }
                unset($goo_id);
                unset($ware_id);
            }
            unset($bra_data);
            unset($bra_id);
            unset($chty_data);
            unset($cate_id);
            unset($info);
            unset($supplier);
        }
        dump($defeated);
        // echo 333;die;
        DB::commit();
    }

    // 力道店瓦尔塔价格导入
    public function lddExcelGoods($submit_data, $data)
    {
        DB::beginTransaction();
        $cid = 1;//公司id
        $superior_shop_id = 1;//总店id
        $shop_id = 1;//门店id
        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($submit_data['api_token']);
        foreach ($data as $key => $value) {
            // dump($data);
            // exit;
            $info['goo_price'] = $value['goo_price'];
            $info['goo_code'] = $value['goo_code'];

            // dump($info);die;
            if (!empty($value['goo_code'])) {
                // 查询仓库表良品总库存
                $ware_id = 20;
                $waon_stock_fine_amount = DB::table('warehouse_onhand')
                    ->where('waon_ware_id', $ware_id)
                    ->where('waon_class', 1)
                    ->value('waon_stock_fine_amount');
                // 根据检索编码查询出商品id
                $goo_id= DB::table('goods')
                    ->where('goo_cid', $cid)
                    ->where('goo_superior_shop_id', $superior_shop_id)
                    ->where('goo_goods_encode', $value['goo_code'])
                    ->value('goo_id');
                // dump($goo_id);
                // exit;
                // 根据仓库id,仓库类别和商品id,查询当前商品库存数量
                $wago_stock_number = DB::table('warehouse_goods')
                    ->where('wago_ware_id', $ware_id)
                    ->where('wago_class', 1)
                    ->where('wago_goo_id', $goo_id)
                    ->value('wago_stock_number');
                // dump($wago_stock_number);
                // 判断进销存商品详情表是否存在该商品
                $sssg_id = DB::table('stock_sell_storage_goods')
                    ->where('sssg_cid', $cid)
                    ->where('sssg_superior_id', $superior_shop_id)
                    ->where('sssg_ware_id', $ware_id)
                    ->where('sssg_waon_class', 1)
                    ->where('sssg_goo_id', $goo_id)
                    ->where('sssg_year', date('Y'))
                    ->where('sssg_month', date('m'))
                    ->value('sssg_id');
                // dump($sssg_id);
                // exit;
                if (empty($sssg_id)) {
                    $sssg_data['sssg_cid'] = $cid;//所属企业id
                    $sssg_data['sssg_superior_id'] = $superior_shop_id;//所属总店id
                    $sssg_data['sssg_shop_id'] = $shop_id;//所属门店id
                    $sssg_data['sssg_ware_id'] = $ware_id;//仓库id
                    $sssg_data['sssg_waon_class'] = 1;//仓库类别
                    $sssg_data['sssg_goo_id'] = $goo_id;//商品id
                    $sssg_data['sssg_year'] = date('Y');//年份
                    $sssg_data['sssg_month'] = date('m');//月份
                    $sssg_data['sssg_initial_stock'] = $wago_stock_number;//期初库存,总库存数量
                    $sssg_data['sssg_initial_average_cost'] = $value['goo_price'] * 100;//期初平均价(单位:分)
                    $sssg_data['sssg_initial_cost'] = $value['goo_price'] * 100;//期初金额-成本（单位：分）,总的成本
                    $sssg_data['sssg_surplus_stock'] = $wago_stock_number;//结余库存,剩余总库存数量
                    $sssg_data['sssg_surplus_cost'] = $value['goo_price'] * 100;//结余成本(单位:分),剩余总得成本
                    $sssg_data['sssg_surplus_average_cost'] = $value['goo_price'] * 100;//结余成本(单位:分),剩余总得成本
                    $sssg_res = DB::table('stock_sell_storage_goods')->insert($sssg_data);
                    unset($sssg_data);
                } else {
                    $sssg_data['sssg_initial_stock'] = $wago_stock_number;//期初库存,总库存数量
                    $sssg_data['sssg_initial_average_cost'] = $value['goo_price'] * 100;//期初平均价(单位:分)
                    $sssg_data['sssg_initial_cost'] = $value['goo_price'] * 100;//期初金额-成本（单位：分）,总的成本
                    $sssg_data['sssg_surplus_stock'] = $wago_stock_number;//结余库存,剩余总库存数量
                    $sssg_data['sssg_surplus_cost'] = $value['goo_price'] * 100;//结余成本(单位:分),剩余总得成本
                    $sssg_data['sssg_surplus_average_cost'] = $value['goo_price'] * 100;//结余成本(单位:分),剩余总得成本
                    $sssg_res = DB::table('stock_sell_storage_goods')
                        ->where('sssg_cid', $cid)
                        ->where('sssg_superior_id', $superior_shop_id)
                        ->where('sssg_ware_id', $ware_id)
                        ->where('sssg_waon_class', 1)
                        ->where('sssg_goo_id', $goo_id)
                        ->where('sssg_year', date('Y'))
                        ->where('sssg_month', date('m'))
                        ->update($sssg_data);
                }
                // 判断进销存查询统计表
                $stss_id = DB::table('stock_sell_storage')
                    ->where('stss_cid', $cid)
                    ->where('stss_superior_id', $superior_shop_id)
                    ->where('stss_ware_id', $ware_id)
                    ->where('stss_waon_class', 1)
                    ->where('stss_year', date('Y'))
                    ->where('stss_month', date('m'))
                    ->value('stss_id');
                if (empty($stss_id)) {
                    $stss_data['stss_cid'] = $cid;//所属企业id
                    $stss_data['stss_superior_id'] = $superior_shop_id;//所属总店id
                    $stss_data['stss_shop_id'] = $shop_id;//所属门店id
                    $stss_data['stss_ware_id'] = $ware_id;//仓库id
                    $stss_data['stss_waon_class'] = 1;//仓库类别
                    $stss_data['stss_year'] = date('Y');//年份
                    $stss_data['stss_month'] = date('m');//月份
                    $stss_data['stss_initial_stock'] = $waon_stock_fine_amount;//期初库存,总库存数量
                    $stss_data['stss_surplus_stock'] = $waon_stock_fine_amount;//结余库存，剩余总库存数量
                    $stss_res = DB::table('stock_sell_storage')->insert($stss_data);
                    unset($stss_data);
                } else {
                    $stss_data['stss_initial_stock'] = $waon_stock_fine_amount;//期初库存,总库存数量
                    $stss_data['stss_surplus_stock'] = $waon_stock_fine_amount;//结余库存，剩余总库存数量
                    $stss_res = DB::table('stock_sell_storage')
                        ->where('stss_cid', $cid)
                        ->where('stss_superior_id', $superior_shop_id)
                        ->where('stss_ware_id', $ware_id)
                        ->where('stss_waon_class', 1)
                        ->where('stss_year', date('Y'))
                        ->where('stss_month', date('m'))
                        ->update($stss_data);
                }
                unset($goo_id);
                unset($ware_id);
                dump($sssg_res);
                dump($stss_res);
                // exit;
            }
            unset($bra_data);
            unset($bra_id);
            unset($chty_data);
            unset($cate_id);
            unset($info);
            unset($supplier);
        }
        // echo 333;die;
        DB::commit();
    }

    // 系统商品导入
    public function systemGoods99($submit_data, $data)
    {
        DB::beginTransaction();
        $cid = 1;//公司id
        $superior_shop_id = 1;//总店id
        $shop_id = 1;//门店id
        $defeated = [];
        foreach ($data as $key => $value) {
            // 查询品类一级是否存在
            $cate_id = DB::table('category')
                ->where('cate_cid', $cid)
                ->where('cate_shop_id', $shop_id)
                ->where('cate_superior_shop_id', $superior_shop_id)
                ->where('cate_name', $value['cate_name'])
                ->where('cate_rank', 1)
                ->value('cate_id');
            if (empty($cate_id)) {
                $cate_data['cate_cid'] = $cid;
                $cate_data['cate_shop_id'] = $shop_id;
                $cate_data['cate_superior_shop_id'] = $superior_shop_id;
                $cate_data['cate_name'] = $value['cate_name'];
                $cate_data['cate_create_time'] = date('Y-m-d H:i:s');
                $cate_data['cate_class'] = 2;//类型1自营品类2系统品类
                $cate_id = DB::table('category')->insertGetId($cate_data);
            } else {
                // DB::table('category')->where('cate_id', $cate_id)->increment('cate_goods_number');
                $cate_id = $cate_id;
            }
            // 查询品类二级是否存在
            $cate_two_id = DB::table('category')
                ->where('cate_cid', $cid)
                ->where('cate_shop_id', $shop_id)
                ->where('cate_superior_shop_id', $superior_shop_id)
                ->where('cate_name', $value['cate_name_two'])
                ->where('cate_parent_id', $cate_id)
                ->where('cate_rank', 2)
                ->value('cate_id');
            if (empty($cate_two_id)) {
                $cate_data['cate_cid'] = $cid;
                $cate_data['cate_shop_id'] = $shop_id;
                $cate_data['cate_superior_shop_id'] = $superior_shop_id;
                $cate_data['cate_name'] = $value['cate_name_two'];
                $cate_data['cate_parent_id'] = $cate_id;
                $cate_data['cate_rank'] = 2;
                $cate_data['cate_create_time'] = date('Y-m-d H:i:s');
                $cate_data['cate_goods_number'] = 3;
                $cate_data['cate_class'] = 2;//类型1自营品类2系统品类
                $cate_two_id = DB::table('category')->insertGetId($cate_data);
            } else {
                DB::table('category')->where('cate_id', $cate_two_id)->increment('cate_goods_number', 3);
            }

            if (empty($value['bra_name'])) {
                $bra_id = 0;
            } else {
                $bra_id = DB::table('brand')
                    ->where('bra_cid', $cid)
                    ->where('bra_shop_id', $shop_id)
                    ->where('bra_superior_shop_id', $superior_shop_id)
                    ->where('bra_name', $value['bra_name'])
                    ->value('bra_id');
                if (empty($bra_id)) {
                    $bra_data['bra_cid'] = $cid;
                    $bra_data['bra_shop_id'] = $shop_id;
                    $bra_data['bra_superior_shop_id'] = $superior_shop_id;
                    $bra_data['bra_name'] = $value['bra_name'];
                    $bra_data['bra_create_time'] = date('Y-m-d H:i:s');
                    $bra_data['bra_goods_number'] = 3;
                    $bra_data['bra_class'] = 2;//类型：1自营品牌2系统品牌
                    // 查询供应链后台品牌id
                    $gyl_bra_id = DB::connection('mysql_scm')->table('brand')
                        ->where('bra_cid', $cid)
                        ->where('bra_name', $value['bra_name'])
                        ->value('bra_id');
                    $bra_data['gyl_bra_id'] = $gyl_bra_id;//供应链后台品牌id
                    $bra_id = DB::table('brand')->insertGetId($bra_data);
                } else {
                    // 查询供应链后台品牌id
                    $gyl_bra_id = DB::connection('mysql_scm')->table('brand')
                        ->where('bra_cid', $cid)
                        ->where('bra_name', $value['bra_name'])
                        ->value('bra_id');
                    $bra_data['gyl_bra_id'] = $gyl_bra_id;//供应链后台品牌id
                    DB::table('brand')->where('bra_id', $bra_id)->increment('bra_goods_number', 3);
                }
                if ($bra_id) {
                    $brse_id = DB::table('brand_serie')
                        ->where('brse_cid', $cid)
                        ->where('brse_shop_id', $shop_id)
                        ->where('brse_superior_shop_id', $superior_shop_id)
                        ->where('brse_bra_id', $bra_id)
                        ->where('brse_name', $value['brse_name'])
                        ->value('brse_id');
                    if (empty($brse_id)) {
                        $brse_data['brse_cid'] = $cid;
                        $brse_data['brse_superior_shop_id'] = $superior_shop_id;
                        $brse_data['brse_shop_id'] = $shop_id;
                        $brse_data['brse_bra_id'] = $bra_id;
                        $brse_data['brse_name'] = $value['brse_name'];
                        $brse_data['brse_goods_number'] = 3;
                        $brse_data['brse_class'] = 2;//类型1自营系列2系统系列
                        $brse_data['brse_cate_id'] = $cate_id;//一级品类id
                        $brse_data['brse_second_cate_id'] = $cate_two_id;//二级品类id
                        // 查询供应链后台品牌系列id
                        $gyl_brse_id = DB::connection('mysql_scm')->table('brand_serie')
                            ->where('brse_cid', $cid)
                            ->where('brse_bra_id', $gyl_bra_id)
                            ->where('brse_name', $value['brse_name'])
                            ->value('brse_id');
                        $brse_data['gyl_brse_id'] = $gyl_brse_id;//供应链后台品牌id
                        $brse_id = DB::table('brand_serie')->insertGetId($brse_data);
                    } else {
                        DB::table('brand_serie')->where('brse_id', $brse_id)->increment('brse_goods_number', 3);
                    }
                }
            }

            $info['goo_cid'] = $cid;
            $info['goo_superior_shop_id'] = $superior_shop_id;
            $info['goo_shop_id'] = $shop_id;
            $info['goo_bra_name'] = $value['bra_name'];//品牌名称
            $info['goo_bra_id'] = $bra_id;//品牌id
            $info['goo_brse_id'] = $brse_id;//品牌系列id
            $info['goo_cate_name'] = $value['cate_name'];//品类名称
            $info['goo_cate_id'] = $cate_two_id;//品类id
            $info['goo_name'] = $value['goo_name'];//商品名称
            $info['goo_goods_encode'] = $value['goo_goods_encode'];//检索编码
            $info['goo_class'] = 2;//类型：1自营商品2系统商品
            // 查询供应链后台商品id
            $gyl_goo_id = DB::connection('mysql_scm')->table('goods')
                ->where('goo_cid', $cid)
                ->where('goo_name', $value['goo_name'])
                ->value('goo_id');
            $info['gyl_goo_id'] = $gyl_goo_id;//供应链后台商品id

            $supplier = [];
            if (!empty($value['attr_guige']) && $value['attr_guige'] != 'NULL') {
                $supplier[] = ['key'=>'规格','value'=>$value['attr_guige']];
            }
            if (!empty($value['danwei']) && $value['danwei'] != 'NULL') {
                $supplier[] = ['key'=>'单位','value'=>$value['danwei']];
            }
            if (!empty($supplier)) {
                $info['goo_attribute'] = json_encode($supplier);
            } else {
                $info['goo_attribute'] = '';
            }
            // dump($info);die;
            if (!empty($value['goo_name'])) {
                $info['goo_type'] = 1;//1正常商品2赠品商品3活动商品4旧货商品
                $info['goo_system_code'] = str_pad($cid, '4', '0', STR_PAD_RIGHT) . str_pad($shop_id, '5', '0', STR_PAD_RIGHT) . rand(10, 99) . rand(100000000, 999999999); //系统编码
                // 添加商品数据
                $goo_id = DB::table('goods')->insertGetId($info);

                // 活动商品
                $acgo_data['acgo_cid'] = $cid;
                $acgo_data['acgo_superior_shop_id'] = $superior_shop_id;
                $acgo_data['acgo_shop_id'] = $shop_id;
                $acgo_data['acgo_goo_id'] = $goo_id;
                $acgo_res = DB::table('activity_goods')->insertGetId($acgo_data);

                //添加赠品商品
                $info['goo_type'] = 2;//1正常商品2赠品商品3活动商品4旧货商品
                $info['goo_fid'] = $goo_id;
                $info['goo_system_code'] = str_pad($cid, '4', '0', STR_PAD_RIGHT) . str_pad($shop_id, '5', '0', STR_PAD_RIGHT) . rand(10, 99) . rand(100000000, 999999999); //系统编码
                // 新增商品
                $gift_goo_id =  DB::table('goods')->insertGetId($info);

                //添加旧货商品
                $info['goo_type'] = 4;//1正常商品2赠品商品3活动商品4旧货商品
                $info['goo_fid'] = $goo_id;
                $info['goo_system_code'] = str_pad($cid, '4', '0', STR_PAD_RIGHT) . str_pad($shop_id, '5', '0', STR_PAD_RIGHT) . rand(10, 99) . rand(100000000, 999999999); //系统编码
                // 新增商品
                $junk_goo_id =  DB::table('goods')->insertGetId($info);

                unset($goo_id);
                unset($acgo_res);
                unset($gift_goo_id);
                unset($junk_goo_id);
            }
            unset($bra_data);
            unset($bra_id);
            unset($cate_data);
            unset($cate_id);
            unset($info);
            unset($supplier);
            unset($acgo_data);
        }
        dump($defeated);
        // echo 333;die;
        DB::commit();
    }

    // 新增客户单位初始化数据,速电快保
    public function addChun()
    {
        DB::beginTransaction();
        $cid = 1;//公司id
        $superior_shop_id = 90;//总店id
        $shop_id = 90;//门店id
        $defeated = [];
        // 查询系统单位类型是否存在
        $chty_id = DB::table('channel_type')
            ->where('chty_cid', $cid)
            ->where('chty_superior_shop_id', $superior_shop_id)
            ->where('chty_shop_id', $shop_id)
            ->where('chty_name', '供应商')
            ->where('chty_system_type', 1)
            ->value('chty_id');
        if (empty($chty_id)) {
            $chty_data['chty_cid'] = $cid;
            $chty_data['chty_superior_shop_id'] = $superior_shop_id;
            $chty_data['chty_shop_id'] = $shop_id;
            $chty_data['chty_name'] = '供应商';//单位类型名称
            $chty_data['chty_channel_number'] = 1;
            $chty_data['chty_system_type'] = 1;//系统类型1系统2门店
            $chty_id = DB::table('channel_type')->insertGetId($chty_data);
        } else {
            DB::table('channel_type')->where('chty_id', $chty_id)->increment('chty_channel_number');
        }
        // 新增客户单位
        // 查询系统单位名称是否存在
        $find_chun_id = DB::table('channel_unit')
            ->where('chun_cid', $cid)
            ->where('chun_shop_id', $shop_id)
            ->where('chun_unit_name', '速电快保')
            ->value('chun_id');
        $chin_data[0]['key'] = '张国锋';//联系人
        $chin_data[0]['value'] = '18810207681';//联系电话
        $chin_data[0]['default'] = '1';
        if ($chin_data[0]['default'] == '1') {
            $chun_add_data['chun_name'] = $chin_data[0]['key'];
            $chun_add_data['chun_phone'] = $chin_data[0]['value'];
        }
        $chin_add_data['chin_data'] = json_encode($chin_data);
        $chun_add_data['chun_cid'] = $cid;
        $chun_add_data['chun_superior_shop_id'] = $superior_shop_id;
        $chun_add_data['chun_shop_id'] = $shop_id;
        $chun_add_data['chun_search_letter'] = 'SDKB';//检索字母
        $chun_add_data['chun_unit_name'] = '速电快保';//客户单位名称
        $chun_add_data['chun_chty_id'] = $chty_id;//渠道类型id
        $chun_add_data['chun_state'] = '1';//状态1.启用 2.停用3被合并/删除
        $chun_add_data['chun_payment_way'] = '1';//结算方式1.账期 2.现结
        $chun_add_data['chun_province'] = '北京市';//省
        $chun_add_data['chun_city'] = '市辖区';//市
        $chun_add_data['chun_county'] = '大兴区';//县
        $chun_add_data['chun_address'] = '亦庄经济技术开发区大族广场T3栋1205-09室';//经纬度
        $chun_add_data['chun_class'] = '2';//系统类型1自营2系统
        if (empty($find_chun_id)) {
            $chun_id = DB::table('channel_unit')->insertGetId($chun_add_data);
            // 新增客户单位信息表
            $chin_add_data['chin_chun_id'] = $chun_id;
            $chin_add_data['chin_level'] = 'A';//客户等级
            $chin_add_data['chin_type'] = '2';//铺货类型1是铺货2不是铺货
            $chin_add_data['chin_owe_day'] = '0';//可欠天数
            $chin_add_data['chin_owe_money'] = '0';//可欠金额
            $chin_add_data['chin_caution_day'] = '0';//警示天数
            $chin_add_data['chin_longitude'] = '116.513522';//经度
            $chin_add_data['chin_latitude'] = '39.791753';//维度
            $chin_id = DB::table('channel_info')->insert($chin_add_data);
        } else {
            $chun_add_data['chun_update_time'] = date('Y-m-d H:i:s');//维度
            $chun_id = DB::table('channel_unit')
                ->where('chun_id', $find_chun_id)
                ->update($chun_add_data);
            // 新增客户单位信息表
            $chin_add_data['chin_chun_id'] = $find_chun_id;
            $chin_add_data['chin_level'] = 'A';//客户等级
            $chin_add_data['chin_type'] = '2';//铺货类型1是铺货2不是铺货
            $chin_add_data['chin_owe_day'] = '0';//可欠天数
            $chin_add_data['chin_owe_money'] = '0';//可欠金额
            $chin_add_data['chin_caution_day'] = '0';//警示天数
            $chin_add_data['chin_longitude'] = '116.513522';//经度
            $chin_add_data['chin_latitude'] = '39.791753';//维度
            $chin_add_data['chin_update_time'] = date('Y-m-d H:i:s');
            $chin_id = DB::table('channel_info')
                ->where('chin_chun_id', $find_chun_id)
                ->update($chin_add_data);
        }
        unset($chin_data);
        unset($chin_add_data);
        unset($chun_add_data);
        unset($chun_id);
        unset($chin_id);
        dump($defeated);
        DB::commit();
    }
}
