<?php
namespace App\Http\Controllers\Api\ChannelManage;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Controllers\Api\Verify\ChannelManage\VerifyCompetingListsController;
use Illuminate\Support\Facades\DB;
use App\Http\Models\Api\Common;
use \PhpOffice\PhpSpreadsheet\IOFactory;

// 运营系统 -- 竞品展示
class CompetingListsController extends Controller
{
    // 列表每页显示数据个数
    protected $show_count = 12;

    // 列表
    public function index(Request $request)
    {
        // 验证数据
        $verify_data = new VerifyCompetingListsController;
        $error_message = $verify_data->indexValidator($request->all());
        if ($error_message) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        }

        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);
        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;

        $search_data = $request->all();
        $list_data = DB::table('competing_goods as cogo')
            ->leftjoin('channel_unit as chun', 'chun.chun_id', '=', 'cogo.cogo_chun_id')
            ->leftjoin('visit as vis', 'vis.vis_id', '=', 'cogo.cogo_vis_id')
            ->where('cogo.cogo_cid', $user_info->adm_cid)
            ->where('cogo.cogo_superior_shop_id', $shop_id)
            ->where('cogo_competing', 1)
            ->where(function ($query) use ($search_data) {
                //如果选择开始时间并且选择结束时间
                if (!empty($search_data['start_time']) && !empty($search_data['end_time'])) {
                    $query->whereBetween('cogo_create_time', [$search_data['start_time'],$search_data['end_time'].' 23:59:59']);
                } else {
                    // 如果选择开始时间
                    if (!empty($search_data['start_time'])) {
                        $query->where('cogo_create_time', '>=', $search_data['start_time']);
                    } else {
                        // 如果选择结束时间
                        if (!empty($search_data['end_time'])) {
                            $query->where('cogo_create_time', '<=', $search_data['end_time'].' 23:59:59');
                        }
                    }
                }
            }) //创建时间
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['chun_unit_name'])) {
                    $query->where('chun_unit_name', 'like', '%'.$search_data['chun_unit_name'].'%');
                }
            })//客户单位名称
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['vis_name'])) {
                    $query->where('vis_name', 'like', '%'.$search_data['vis_name'].'%');
                }
            })//拜访名称
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['vis_executor_adm_id'])) {
                    $query->where('vis_executor_adm_id', $search_data['vis_executor_adm_id']);
                }
            })//业务员
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['cogo_chun_id'])) {
                    $query->where('cogo_chun_id', $search_data['cogo_chun_id']);
                }
            })//客户单位id
            ->select('cogo_id', 'vis_id', 'vis_name', 'vis_executor_adm_id', 'cogo_chun_id', 'chun_unit_name', 'cogo_competing', 'cogo_img', 'cogo_create_id', 'cogo_create_time')
            ->orderBy('cogo_id', 'desc')
            ->paginate($this->show_count);
        $data = $list_data->items();
        if ($data) {
            // 获取创建人id
            $executor_adm_id = array_column($data, 'vis_executor_adm_id');//获取业务员id
            $create_id = array_column($data, 'vis_create_id');//获取创建人id
            $adm_id = array_unique(array_merge($executor_adm_id, $create_id));
            // 查询账号信息
            $find_admin = DB::table('admin')
                ->whereIn('adm_id', $adm_id)
                ->select('adm_id', 'adm_name')
                ->get();
            $data_info['admin'] = $find_admin;
            $data_info['executor_adm_id'] = $find_admin;
        }
        $data_info['current_page'] = $list_data->currentPage();  //当前页面页码
        $data_info['last_page'] = $list_data->lastPage();        //表示最后一页的页码
        $data_info['total'] = $list_data->total();               //总数据个数
        $data_info['current_number'] = $this->show_count;       //一页显示多少个
        $data_info['data'] = $data;                //返回数据
        
        // 获取当前列表下的按钮
        $list_button = getListButton($request['api_token'], $request['pri_id']);
        if ($list_data) {
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>$data_info, 'list_button'=>$list_button]);
        } else {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'暂无数据']);
        }
    }
}
