<?php

namespace App\Http\Controllers\Api\BackEnd;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use App\Http\Models\Api\Export;
use App\Http\Models\Api\StockingSelling;
use App\Http\Models\Api\StockSellStorageGoods;
use App\Http\Models\Api\Common;
use App\Http\Controllers\Api\YongYou\YongYouController;
use Illuminate\Support\Facades\Crypt;
use App\Services\Business\WashPayservice;
use App\Http\Models\Api\CashierDesk;

class SendMessageController extends Controller
{
    /*
     * @name 客户关怀消息发送
     * @author Ma 2023/9/1 11:25
     *
    */

    // 入口方法
    public function entrance(Request $request)
    {
        $this->sendMessaget();
        //$this->updateMemLastTime();
    }

    public function sendMessaget(){
        //待发送短信
        $mem_data = DB::table('festival_message')
            ->where('message_status', 3)
            ->get()->toArray();
        if($mem_data){
            foreach ($mem_data as $key => $value){
                echo $value->message_id.PHP_EOL;
                /*if(in_array($value->message_mem_phone,['16622922747','18514786434','18210120533','18233154732'])){
                    $send_res = sendSmsCode($value->message_mem_phone, '【半径服务】'.$value->message_content,false);
                }else{
                    $send_res = 155;
                }*/
                $use_count = ceil(mb_strlen($value->message_content) / 67) ;
                $find_shop_data = DB::table('shop')
                    ->where('shop_id', $value->message_shop_id)
                    ->first();


                if ($find_shop_data->shop_message_num < $use_count) {
                    $add_log['smlo_shop_id'] = $value->message_shop_id;
                    $add_log['smlo_mem_type'] = $value->message_mem_type;//1业务人员2会员
                    $add_log['smlo_mem_id'] = $value->message_mem_id;
                    $add_log['smlo_mem_name'] = $value->message_mem_name;
                    $add_log['smlo_mem_phone'] = $value->message_mem_phone;
                    $add_log['smlo_type'] = 2;
                    $add_log['smlo_create_time'] = date('Y-m-d H:i:s');
                    $add_log['smlo_msg_type'] = $value->message_type == 1 ? 2 : 3;
                    $add_log['smlo_num'] = $use_count;
                    $add_log['smlo_content'] = $value->message_content; //内容
                    $add_log['smlo_state'] = 2;
                    $add_log_res = DB::table('sms_log')->insertGetId($add_log);
                    $up_data['message_smlo_id']  = $add_log_res;
                    $up_data['message_count']  = 0;
                    $up_data['message_send_time'] = date('Y-m-d H:i:s');//发送时间
                    $mem_data_m = DB::table('festival_message')->where('message_id', $value->message_id)
                        ->update($up_data);
                } else {
                    $msg_remind_log = DB::table('msg_remind_log')
                        ->where('mrlo_shop_id', $value->message_shop_id)
                        ->where('mrlo_state', 2)
                        ->first();
                    if ($msg_remind_log) {//已提醒过
                        if ($find_shop_data->shop_message_num > $find_shop_data->shop_msg_remind) {
                            $update_remind['mrlo_state'] = 1;
                            $msg_remind_log = DB::table('msg_remind_log')
                                ->where('mrlo_shop_id', $value->message_shop_id)
                                ->where('mrlo_state', 2)
                                ->update($update_remind);
                        }
                    }
                    
                    $msg_remind_log = DB::table('msg_remind_log')
                        ->where('mrlo_shop_id', $value->message_shop_id)
                        ->where('mrlo_state', 2)
                        ->first();

                    if (($find_shop_data->shop_message_num-1) <= $find_shop_data->shop_msg_remind && empty($msg_remind_log) && $find_shop_data->shop_msg_adm_id) {
                        $adm_data = DB::table('admin')->where('adm_id', $find_shop_data->shop_msg_adm_id)->first();
                        // $wechat_msg['pushtype'] = 5; //短信预警
                        // $wechat_msg['adm_id'] = $find_shop_data->shop_msg_adm_id; //推送人
                        // $wechat_msg['user_data'] = $adm_data->adm_name; //姓名
                        // $wechat_msg['tittle'] = '剩余短信不足'.$find_shop_data->shop_msg_remind.'条，请及时充值'; //提醒消息
                        // $wechat_msg['remark'] = '短信不足预警';
                        // $CashierDesk = new CashierDesk;
                        // $wechat_msg_res = $CashierDesk->inforPush($wechat_msg);
                        $remind_phone = $adm_data->adm_phone;
                        $remind_content = '【半径服务】 您的门店短信余额不足'.$find_shop_data->shop_msg_remind.'条，请及时充值';
                        $remind_send_res = sendSmsCode($remind_phone, $remind_content);
                        if ($remind_send_res > 0) {
                            $send_state = 1;
                            $add_remind['mrlo_shop_id'] = $value->message_shop_id; //门店id
                            $add_remind['mrlo_state'] = 2;//未充值，
                            $add_remind['mrlo_adm_id'] = $find_shop_data->shop_msg_adm_id;
                            $add_remind['mrlo_num'] = $find_shop_data->shop_msg_remind;
                            $add_remind['mrlo_create_time'] = date('Y-m-d H:i:s');
                            $add_remind['mrlo_create_id'] = 0;
                            $reming_res = DB::table('msg_remind_log')->insertGetId($add_remind);
                        } else {
                            $send_state = 2;
                        }
                        // 短信模块日志
                        $seme_data['seme_cid'] = 1; //公司id
                        $seme_data['seme_shop_id'] = $value->message_shop_id; //门店id
                        $seme_data['seme_wor_id'] = 0; //订单id
                        $seme_data['seme_name'] = '短信不足预警'; //模板名称
                        $seme_data['seme_phone'] = $remind_phone; //手机号
                        $seme_data['seme_content'] = $remind_content; //内容
                        $seme_data['seme_row'] = 1; //条数
                        $seme_data['seme_status_code'] = $remind_send_res; //短信状态码
                        $seme_data['seme_state'] = $send_state; //状态：1成功2失败
                        $seme_data['seme_ip'] = ''; //ip地址
                        $seme_data['seme_adm_id'] = 0; //创建人id
                        $seme_id = DB::table('send_message')->insert($seme_data);
                    }
                    $send_res = sendSmsCode($value->message_mem_phone,$value->message_content);
                    if ($send_res > 0) {
                        $add_log['smlo_state'] = 1;
                        $up_data['message_status']  = 1;//成功
                        $update_shop = DB::table('shop')
                            ->where('shop_id', $value->message_shop_id)
                            ->update(['shop_message_num'=>$find_shop_data->shop_message_num - $use_count]);
                    } else {
                        $up_data['message_status']  = 2;//失败
                        $add_log['smlo_state'] = 2;
                    }
                    $add_log['smlo_shop_id'] = $value->message_shop_id;
                    $add_log['smlo_mem_type'] = $value->message_mem_type;//1业务人员2会员
                    $add_log['smlo_mem_id'] = $value->message_mem_id;
                    $add_log['smlo_mem_name'] = $value->message_mem_name;
                    $add_log['smlo_mem_phone'] = $value->message_mem_phone;
                    $add_log['smlo_type'] = 2;
                    $add_log['smlo_create_time'] = date('Y-m-d H:i:s');
                    $add_log['smlo_msg_type'] = $value->message_type == 1 ? 2 : 3;
                    $add_log['smlo_num'] = $use_count;
                    $add_log['smlo_content'] = $value->message_content; //内容
                    $add_log_res = DB::table('sms_log')->insertGetId($add_log);
                    echo $send_res.PHP_EOL;
                    $up_data['message_smlo_id']  = $add_log_res;
                    $up_data['message_count']  = $value->message_count + $use_count;
                    $up_data['message_send_time'] = date('Y-m-d H:i:s');//发送时间
                    $mem_data_m = DB::table('festival_message')->where('message_id', $value->message_id)
                        ->update($up_data);
                }
            }
        }

    }

    public function updateMemLastTime(){
        $mem_data = DB::table('member')
            ->where('mem_first_time', '0000-00-00 00:00:00')
            ->where('mem_last_time', '0000-00-00 00:00:00')
            ->get()->toArray();
        if($mem_data){
            foreach ($mem_data as $key => $value){
                $order_data = DB::table('order')
                    ->where('ord_service_type', 1)//订单类型：1服务单
                    ->where('ord_delete', 1)//是否删除：1正常订单2取消订单
                    ->where('ord_client_id', $value->mem_id)//客户
                    ->select('ord_create_time')
                    ->orderBy('ord_id', 'ASC')
                    ->first();
                if($order_data){
                    $update_data['mem_first_time'] = $order_data->ord_create_time;//首次下单时间
                    $order_last = DB::table('order')
                        ->where('ord_service_type', 1)//订单类型：1服务单
                        ->where('ord_delete', 1)//是否删除：1正常订单2取消订单
                        ->where('ord_client_id', $value->mem_id)//客户
                        ->select('ord_create_time')
                        ->orderBy('ord_id', 'DESC')
                        ->first();
                    if($order_last){
                        $update_data['mem_last_time'] = $order_data->ord_create_time;//最后下单时间
                    }
                    $ret = DB::table('member')->where('mem_id', $value->mem_id)->update($update_data);
                }

            }
        }
    }

}
