<?php

namespace App\Http\Controllers\Api\BackEnd;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use App\Http\Models\Api\Export;
use App\Http\Models\Api\StockingSelling;
use App\Http\Models\Api\StockSellStorageGoods;
use App\Http\Models\Api\Common;
use App\Http\Controllers\Api\YongYou\YongYouController;
use Illuminate\Support\Facades\Crypt;
use App\Services\Business\WashPayservice;
use App\Http\Models\Api\CashierDesk;
use BlueCity\Data\Service\DataCenter\AutoDataService;

class FestivalRemindSendMessageController extends Controller
{
    /*
     * @name 客户关怀消息发送
     * @author Ma 2023/9/1 11:25
     *
    */

    // 入口方法
    public function entrance(Request $request)
    {
        //$this->sendMessaget();//fest_start 创建用户自动发送对应的发送短信，20230901  |||   20231010停止只用这种方法
        $this->newSendMessaget();
    }

    public function newSendMessaget(){
        //查询需要发送的短信的节日
        $find_data = DB::table('festival_remind')
            ->where('fest_content', '!=','')//
            ->where('fest_is_send', 1)//是否发送：1是2否
            ->where('fest_status', 1)//状态：1正常2删除
            ->get()->toArray();
        if($find_data){
            //查询门店信息
            $shop_data = DB::table('shop')->get()->toArray();
            if($shop_data){
                foreach ($shop_data as $shop_key => $shop_value){
                    $shop[$shop_value->shop_id] = $shop_value;
                }
            }
            $label_data = DB::table('sms_label')
                ->get()->toArray();
            //查找签名
            $sign_data = DB::table('shop_sign')
                ->get()->toArray();
            if($sign_data){
                foreach ($sign_data as $s_key => $s_value){
                    $sign[$s_value->shopsign_shop_id] = $s_value->shopsign_name;
                }
            }
            $series_list = AutoDataService::getBrandByFirstLetter('', 1);
            if($series_list){
                foreach ($series_list['data'] as $s_key => $s_value){
                    $series_list_data[$s_value['carMasterBrandId']] = $s_value['carMasterBrandName'];
                }
            }
            foreach ($find_data as $key => $value){
                if($value->fest_type == 1){//节日提醒
                    $new_date = date('Y-m-d', strtotime($value->fest_date));//节日设置日期
                    $today_date = date('Y-m-d', time());//今天的日期
                    if(!empty($value->fest_date) && $new_date == $today_date){//当天是节日设置日期旧发送短信
                        //查找节日设置的提醒用户
                        $where = [];
                        if($value->fest_effective_start_date && $value->fest_effective_start_date != '0000-00-00'){
                            $where['start_time'] = $value->fest_effective_start_date;
                        }
                        if($value->fest_effective_end_date && $value->fest_effective_start_date != '0000-00-00'){
                            $where['end_time'] = $value->fest_effective_end_date;
                        }
                        if($value->fest_sex){
                            $where['sex'] = $value->fest_sex;
                        }
                        if($value->fest_car_series){
                            $where['fest_car_series_id'] = explode(",",$value->fest_car_series);
                            foreach ($where['fest_car_series_id'] as $f_key => $f_value){
                                $where['fest_car_series'][] = $series_list_data[$f_value];
                            }
                        }
                        //标签
                        if($value->fest_label){
                            $festlabel = explode(',',$value->fest_label);
                            $mem_label = DB::table('member_label')
                                ->where('melal_cid', $value->fest_cid)
                                ->where('melal_shop_id', $value->fest_shop_id)
                                ->whereIn('melal_label_id', $festlabel)//标签
                                ->groupBy('melal_mem_id')
                                ->get()->toArray();
                            if(!empty($mem_label)){
                                $label_member = array_column($mem_label,'melal_mem_id');
                                $where['label_mem'] = $label_member;
                            }
                        }
                        $mem_data_m = DB::table('member')
                            ->where('mem_cid', $value->fest_cid)
                            ->where('mem_superior_shop_id', $value->fest_superior_shop_id)
                            ->where('mem_shop_id', $value->fest_shop_id)
                            ->where(function ($query) use ($where) {
                                if (isset($where['sex']) && !empty($where['sex']) && $where['sex'] != 3) {
                                    $query->where('mem_sex', $where['sex']);
                                }
                            })
                            ->where(function ($query) use ($where) {
                                if (isset($where['start_time']) && !empty($where['start_time']) && $where['start_time'] != '0000-00-00') {
                                    $query->where('mem_create_time','>=', $where['start_time']);
                                }
                            })
                            ->where(function ($query) use ($where) {
                                if (isset($where['end_time']) && !empty($where['end_time']) && $where['end_time'] != '0000-00-00') {
                                    $query->where('mem_create_time','<=', $where['end_time']. ' 23:59:59');
                                }
                            })
                            ->where(function ($query) use ($where) {
                                if (isset($where['fest_car_series']) && !empty($where['fest_car_series'])) {
                                    foreach ($where['fest_car_series'] as $d_key => $d_value){
                                        if($d_key == 0){
                                            $query->where('mem_car_series', 'like', $d_value.'%');
                                        }else{
                                            $query->orwhere('mem_car_series', 'like', $d_value.'%');
                                        }
                                    }
                                }
                            })
                            ->where(function ($query) use ($where) {
                                if (isset($where['label_mem']) && !empty($where['label_mem'])) {
                                    $query->whereIn('mem_id', $where['label_mem']);
                                }
                            })
                            ->get()->toArray();
                        if($mem_data_m){
                            foreach ($mem_data_m as $j_key => $j_value){
                                $message = $this->content_replace($label_data,$value->fest_content,$j_value,$shop[$value->fest_shop_id]);
                                if(isset($sign[$value->fest_shop_id])){
                                    $signature = $sign[$value->fest_shop_id];
                                }else{
                                    $signature = '半径服务';
                                }
                                $this->send($j_value,'【'.$signature.'】'.$message,$value->fest_type);
                            }
                        }
                    }
                }elseif ($value->fest_type == 2){//生日提醒

                    $fest_id = $value->fest_id;//生日id
                    //提前几天提醒
                    $day = date('m-d',strtotime('+'.$value->fest_days.' day'));
                    //查找生日设置的提醒用户
                    $where = [];
                    if($value->fest_effective_start_date){
                        $where['start_time'] = $value->fest_effective_start_date;
                    }
                    if($value->fest_effective_end_date){
                        $where['end_time'] = $value->fest_effective_end_date;
                    }
                    if($value->fest_sex){
                        $where['sex'] = $value->fest_sex;
                    }
                    if($value->fest_car_series){
                        $where['fest_car_series_id'] = explode(",",$value->fest_car_series);
                        foreach ($where['fest_car_series_id'] as $f_key => $f_value){
                            $where['fest_car_series'][] = $series_list_data[$f_value];
                        }
                    }
                    //标签
                    if($value->fest_label){
                        $festlabel = explode(',',$value->fest_label);
                        $mem_label = DB::table('member_label')
                            ->where('melal_cid', $value->fest_cid)
                            ->where('melal_shop_id', $value->fest_shop_id)
                            ->whereIn('melal_label_id', $festlabel)//标签
                            ->groupBy('melal_mem_id')
                            ->get()->toArray();
                        if(!empty($mem_label)){
                            $label_member = array_column($mem_label,'melal_mem_id');
                            $where['label_mem'] = $label_member;
                        }
                    }
                    $mem_data_s = DB::table('member')
                        ->where('mem_cid', $value->fest_cid)
                        ->where('mem_superior_shop_id', $value->fest_superior_shop_id)
                        ->where('mem_shop_id', $value->fest_shop_id)
                        ->where('mem_birthday', $day)
                        ->where(function ($query) use ($where) {
                            if (isset($where['sex']) && !empty($where['sex']) && $where['sex'] != 3) {
                                $query->where('mem_sex', $where['sex']);
                            }
                        })
                        ->where(function ($query) use ($where) {
                            if (isset($where['start_time']) && !empty($where['start_time']) && $where['start_time'] != '0000-00-00') {
                                $query->where('mem_create_time','>=', $where['start_time']);
                            }
                        })
                        ->where(function ($query) use ($where) {
                            if (isset($where['end_time']) && !empty($where['end_time']) && $where['end_time'] != '0000-00-00') {
                                $query->where('mem_create_time','<=', $where['end_time']. ' 23:59:59');
                            }
                        })
                        ->where(function ($query) use ($where) {
                            if (isset($where['fest_car_series']) && !empty($where['fest_car_series'])) {
                                foreach ($where['fest_car_series'] as $f_key => $f_value){
                                    if($f_key == 0){
                                        $query->where('mem_car_series', 'like', $f_value.'%');
                                    }else{
                                        $query->orwhere('mem_car_series', 'like', $f_value.'%');
                                    }
                                }
                            }
                        })
                        ->where(function ($query) use ($where) {
                            if (isset($where['label_mem']) && !empty($where['label_mem'])) {
                                $query->whereIn('mem_id', $where['label_mem']);
                            }
                        })
                        ->get()->toArray();
                    if($mem_data_s){
                        foreach ($mem_data_s as $me_key => $me_value){
                            $message = $value->fest_content;//发送内容
                            $message = $this->content_replace($label_data,$message,$me_value,$shop[$value->fest_shop_id]);
                            if(isset($sign[$value->fest_shop_id])){
                                $signature = $sign[$value->fest_shop_id];
                            }else{
                                $signature = '半径服务';
                            }
                            //如果是生日如是是提醒业务员
                            if($value->fest_name == '客户生日提醒业务人员'){
                                if(!empty($me_value->mem_salesman_id) && $me_value->mem_salesman_id > 0){
                                    $admin_data = DB::table('admin')
                                        ->where('adm_id', $me_value->mem_salesman_id)
                                        ->first();
                                    $me_value->mem_id = $admin_data->adm_id;
                                    $me_value->mem_name = $admin_data->adm_name;
                                    $me_value->mem_phone = $admin_data->adm_phone;
                                    $this->send($me_value,'【'.$signature.'】'.$message,$value->fest_type,1);
                                }
                            }else{
                                $this->send($me_value,'【'.$signature.'】'.$message,$value->fest_type);
                            }

                        }
                    }
                }
                unset($where);
            }
        }
    }

    public function sendMessaget(){
        //查询需要发送的短信的节日
        $find_data = DB::table('festival_remind')
            ->where('fest_content', '!=','')//
            ->where('fest_status', 1)//状态：1正常2删除
            ->get()->toArray();
        if($find_data){
            //查询门店信息
            $shop_data = DB::table('shop')->get()->toArray();
            if($shop_data){
                foreach ($shop_data as $shop_key => $shop_value){
                    $shop[$shop_value->shop_id] = $shop_value;
                }
            }
            foreach ($find_data as $key => $value){
                if($value->fest_type == 1){//节日提醒
                    $new_date = date('Y-m-d', strtotime($value->fest_date));//节日设置日期
                    $today_date = date('Y-m-d', time());//今天的日期
                    if(!empty($value->fest_date) && $new_date == $today_date){
                        $mem_data = DB::table('member_festival')
                            ->where('mefe_cid', $value->fest_cid)
                            ->where('mefe_superior_shop_id', $value->fest_superior_shop_id)
                            ->where('mefe_shop_id', $value->fest_shop_id)
                            ->where('mefe_fest_id', $value->fest_id)
                            ->get()->toArray();
                        if($mem_data){
                            foreach ($mem_data as $m_key => $fest_value){
                                $mem_arr[] = $fest_value->mefe_mem_id;//客户id
                            }
                            if($mem_arr){
                                $mem_data_m = DB::table('member')
                                    ->where('mem_cid', $value->fest_cid)
                                    ->where('mem_superior_shop_id', $value->fest_superior_shop_id)
                                    ->where('mem_shop_id', $value->fest_shop_id)
                                    ->whereIN('mem_id', $mem_arr)
                                    ->get()->toArray();
                                if($mem_data_m){
                                    foreach ($mem_data_m as $j_key => $j_value){
                                        $message = $this->content_replace($value->fest_content,$j_value,$shop[$value->fest_shop_id]);
                                        $this->send($j_value,$message,$value->fest_type);
                                    }
                                }
                            }
                        }
                    }
                }elseif ($value->fest_type == 2){//生日提醒
                    $fest_id = $value->fest_id;//生日id
                    //提前几天提醒
                    $day = date('m-d',strtotime('+'.$value->fest_days.' day'));
                    //该店铺设置了生日提醒的客户
                    $mem_data_n = DB::table('member_festival')
                        ->where('mefe_cid', $value->fest_cid)
                        ->where('mefe_superior_shop_id', $value->fest_superior_shop_id)
                        ->where('mefe_shop_id', $value->fest_shop_id)
                        ->where('mefe_fest_type', 2)
                        ->where('mefe_fest_id', $value->fest_id)
                        ->get()->toArray();
                    if($mem_data_n){
                        foreach ($mem_data_n as $s_key => $s_value){
                            $mem_arr_s[] = $s_value->mefe_mem_id;//客户id
                        }
                        $mem_data_s = DB::table('member')
                            ->where('mem_cid', $value->fest_cid)
                            ->where('mem_superior_shop_id', $value->fest_superior_shop_id)
                            ->where('mem_shop_id', $value->fest_shop_id)
                            ->whereIN('mem_id', $mem_arr_s)
                            ->where('mem_birthday', $day)
                            ->get()->toArray();
                        if($mem_data_s){
                            foreach ($mem_data_s as $me_key => $me_value){
                                $message = $value->fest_content;//发送内容
                                $message = $this->content_replace($message,$me_value,$shop[$value->fest_shop_id]);
                                //如果是生日如是是提醒业务员
                                if($value->fest_name == '客户生日提醒业务人员'){
                                    if(!empty($me_value->mem_salesman_id)){
                                        $admin_data = DB::table('admin')
                                            ->where('adm_id', $me_value->mem_salesman_id)
                                            ->first();
                                        $me_value->mem_id = $admin_data->adm_id;
                                        $me_value->mem_name = $admin_data->adm_name;
                                        $me_value->mem_phone = $admin_data->adm_phone;;
                                    }
                                }
                                $this->send($me_value,$message,$value->fest_type);
                            }
                        }
                    }
                }
            }
        }
    }

    //发送短信
    public function send($me_value,$message,$type,$send_id = 2){
        //$send_res = sendSmsCode($me_value->mem_phone, $message);
        $add_data['message_cid'] = $me_value->mem_cid;
        $add_data['message_superior_shop_id'] = $me_value->mem_superior_shop_id;
        $add_data['message_shop_id'] = $me_value->mem_shop_id;
        $add_data['message_mem_id'] = $me_value->mem_id;//会员id
        $add_data['message_mem_name'] = $me_value->mem_name;//会员姓名
        $add_data['message_mem_phone'] = $me_value->mem_phone;//会员电话
        $add_data['message_type'] = $type;//1节日提醒2生日提醒
        //$add_data['message_send_time'] = date('Y-m-d H:i:s');//发送时间
        $add_data['message_count'] = 0;//发送条数
        $add_data['message_content'] = $message;//发送内容
        $add_data['message_status'] = 3;//1成功2失败3待发送
        $add_data['message_mem_type'] = $send_id;//1业务人员2会员
        $fest_id =  DB::table('festival_message')->insertGetId($add_data);

    }

    //替换标签
    public function content_replace($data,$message,$mem_info,$shop_info){

        if($data){
            foreach ($data as $key => $value){
                if($value->sms_label_name == '顾客姓名'){
                    $message = str_replace($value->sms_label_text,$mem_info->mem_name,$message);
                }
                if($value->sms_label_name == '顾客生日'){
                    $birthday = date("n月j日",strtotime("2023-".$mem_info->mem_birthday));
                    $message = str_replace($value->sms_label_text,$birthday,$message);
                }
                if($value->sms_label_name == '门店地址'){
                    $address = $shop_info->shop_province.$shop_info->shop_city.$shop_info->shop_county.$shop_info->shop_address;
                    $message = str_replace($value->sms_label_text,$address,$message);
                }
                if($value->sms_label_name == '门店名称'){
                    $message = str_replace($value->sms_label_text,$shop_info->shop_store_name,$message);
                }
            }
        }
        return $message;
    }
}
