<?php

namespace App\Http\Controllers\Api\BackEnd;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use App\Http\Models\Api\Export;
use App\Http\Models\Api\StockSellStorageGoods;
use App\Http\Models\Api\Common;
use App\Http\Controllers\Api\YongYou\YongYouController;
use Illuminate\Support\Facades\Crypt;
use App\Http\Models\Api\OutinRecord;
use App\Http\Models\Api\YongYou;
use App\Http\Models\Api\YongYous;
use App\Http\Models\BackEnd\BackEnd;

class BackEndController extends Controller
{
    // 初始密码
    protected $password = 123456;
    protected $now_time = '2021-06-01 15:30:16';
    protected $date = '2020-09';
    protected $show_count = 10;

    public function test(Request $request)
    {
        // $this->importExcelData($request);//导入Excel数据
        // $this->other($request);//将读取到的Excel表格数据，添加到数据库
        // $this->matching();//匹配库存商品成本价格
        // $this->editGoods();//厦门的商品数据调整
        // $this->selectGoods();//判断系统商品编码是否存在系统中
        // $this->selectCategory();//查询品类重复名称
        // $this->selectBrand();//查询品牌重复名称
        // $this->selectBrandSerie();//查询品牌系列重复名称
        // $this->kucun();//统计库存数量 00008
        // $this->repetitionWarehouseGoods();//查询仓库商品有重复商品id的数据 06
        // $this->statistics();// 统计品类品牌系列对应的商品数量
        // $this->editSystemGoods();//修改厦门系统商品的价格
        // $this->adjustRecedeVoucher();//修改退货单1-3月份未同步U8的凭证
        // $this->adjustVirtualFranchises();//查询虚拟加盟店凭证金额跟工单金额不一致的数据
        // $this->editGoodsId();//根据检索编码查询对应的商品id
        // $this->adjustRecedeVoucher2();//查询退货单类型凭证金额跟订单类型退货单金额不一致的数据
        // $this->bulkEditing($request);//原来仓库里的自营商品id，已经切换成系统商品id的，需要把自营商品id换成系统商品id,订单商品、工单商品、采购单、发货单、调拨单、盘库单、旧货回收、退换入库、仓库商品、出入库记录、进销存、销售统计
        // $this->selectWGoods();//查询温州门店自营商品检索编码是7位的
        // $this->disposeLock($request);//处理厦门锁定数据
        // $this->warehouseGoods($request);//统计仓库商品锁定表和仓库商品表库存数量不一致的数据
        // $this->searchSystemGoods();//统计商品表中有系统商品编码一样的数据
        // $this->StocktakeVoucher();// 修改盘库单凭证成
        // $this->selectSdGoods();//查询速电业务最终确定的蓄电池编码,系统有的,表格里没有的
        // $this->addSdGoods();// 查询速电业务最终确定的蓄电池编码并添加到系统商品表
        // $this->selectWago($request);// 统计系统有的表格里没有的数据在仓库商品表/商品流水记录表/进销存表是否存在
        // $this->selectWarehouse();// 统计仓库商品表的锁定数量跟仓库总表的锁定数量对比,看数量是否一致
        // $this->replaceGoods($request);// 替换新编码
        // $this->deleteGoods();// 删除系统商品
        // $this->selectWarehouseGoods($request);//统计仓库库存数量和进销存库存数量不一致的数据 07
        // $this->selectStocktake($request);//查询盘库单当时的商品成本
        // $this->selectOrderGoods($request);//查询仓库商品锁定表数据跟订单商品表,判断是否有商品
        // $this->addOldStocks($request);//新增盘库单，原来的仓库盘少
        // $this->selectOrders($request);//查询订单商品全部退回，销售统计商品还在的数据
        // $this->editWarehouseGoods($request);//待检测的库存转良品
        // $this->returnGoods();//查询有回收商品的订单商品,并新增
        // $this->orderPrice();//调整订单金额
        // $this->diffReceivableType();//调整订单金额
        // $this->selectOrderPrice();//查询订单金额为负数的11
        // $this->getfalsedata($request);//计算期末金额 与 平均价*库存不相等
        // $this->getdisffrensestate();//统计商品类型不一致的数据
        // $this->editReceOutinType($request);//修改出入库记录中 退货单类型存错值的
        // $this->enterssellssaves($request);//计算进销存 001
        // $this->selectDataStatistical($request);//查询销售统计-销售明细界面的成本为0,跟进销存成本对比,不一致的查询出来 002
        // $this->syncOrder($request);//查询凭证列表已同步U8成本和销售统计成本不一致的 003
        // $this->dataStatistics($request);//统计凭证列表成本和销售统计成本不一致的
        // $this->editDataStatistical();//修改销售统计表成本和订单商品表的成本 004（重复不运行）
        // $this->editVoucher();//根据销售统计成本修改凭证的成本 005
        // $this->editGoodsencode($request);//修改faster_enters_goods_price商品编码
        // $this->editDastService($request);//修改faster_data_statistical销售统计服务数据
        // $this->selectOrderBill();//查询账单列表的已结金额和结款金额一致，账单列表状态值为结款中的数据
        // $this->selectContrast();//查询应收应付已确认，账单列表状态为结款中的单号
        // $this->edit();//
    }

    public function edit($request) {
        $pri = '{"pc":"2,3,4,5,7,8,23,24,25,26,27,28,29,30,31,32,33,34,35,36,38,39,40,41,42,43,44,45,46,53,55,56,57,58,59,60,61,62,63,64,66,67,68,69,70,71,72,73,74,75,76,78,79,80,81,82,83,84,85,86,87,105,106,107,108,109,110,111,118,119,120,121,122,123,124,125,128,129,130,131,134,136,137,138,139,140,153,155,156,159,160,162,163,164,165,166,167,168,169,172,173,174,175,176,177,178,179,180,181,183,184,185,186,188,189,190,191,192,194,195,196,198,202,203,204,205,222,224,225,226,227,228,229,231,232,237,238,239,241,242,243,244,246,247,248,249,250,251,252,253,254,256,257,258,259,260,261,262,263,264,266,267,268,269,270,271,272,273,274,275,317,318,319,320,321,322,334,335,336,337,338,342,345,346,348,349,351,354,355,357,358,359,360,361,362,363,364,365,369,370,371,372,373,382,383,384,385,388,391,392,393,394,395,396,397,398,399,400,403,404,407,408,409,410,411,414,415,419,420,421,447,448,449,452,453,458,459,460,462,463,465,466,470,471,483,484,485,486,488,489,490,491,492,494,495,496,497,498,499,500,512,514,515,517,518,519,520,521,527,528,529,530,531,532,533,534,535,537,540,541,542,546,548,551,552,553,554,555,556,557,558,564,565,566,567,572,573,574,575,576,579,585,587,588,589,590,591,592,593,594,595,597,598,599,600,601,602,603,604,605,606,607,608,609,610,611,612,613,614,615,616,617,618,619,620,621,622,623,624,625,626,627,628,629,634,635,636,637,638,639,654,655,657,658,659,660,661,662,663,665,666,668,670,672,674,675,676,677,678,679,680,681,682,683,684,685,686,687,688,689,690,691,692,693,694,695,697,698,699,700,701,702,703,704,705,706,707,709,712,713,715,718,720,721,722,723,724,725,726,727,728,729,730,731,732,733,734,736,737,738,739,740,742,743,744,746,747,748,749,750,751,752,754,755,756,757,758,759,760,761,762,764,765,766,767,768,769,771,772,773,774,775,776,777,778,779,780,783,784,785,786,787,788,789,790,791,793,795,796,797,798,800,801,802,803,813,814,815,818,819,820,822,823,824,825,826,827,828,830,831,832,833,834,835,836,837,838,839","applet":"9,10,11,17,20,21,22,23,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,53,54,55,56,57,59,60,61,62,63,64,65,66,67,68,69,70,71,77,78,79,80,81"}';
        $pri = json_decode($pri, true);
        dump($pri);
        die;
    }

    // 查询应收应付已确认，账单列表状态为结款中的单号
    public function selectContrast()
    {
        ignore_user_abort();
        set_time_limit(0);

        $adm_cid = 1;
        $shop_id = 1;

        // 查询账单列表的数据
        $find_recr_data = DB::table('receivable_credit')
            ->where('recr_cid', $adm_cid)
            ->where('recr_shop_id', $shop_id)
            ->where('recr_state', 2)
            ->select('recr_original_id', 'recr_original_number')
            ->get()->toArray();
        foreach ($find_recr_data as $key => $value) {
            // 根据原始单id和原始单号查询账单的数据
            $find_orbi_data = DB::table('order_bill')
                ->where('orbi_id', $value->recr_original_id)
                ->where('orbi_number', $value->recr_original_number)
                ->where('orbi_state', 5)
                ->value('orbi_number');
            if ($find_orbi_data) {
                dump($value->recr_original_number);
            } else {
                echo '111';
            }
        }
        unset($find_recr_data);
        echo '成功';
    }

    // 查询账单列表的已结金额和结款金额一致，账单列表状态值为结款中的数据
    public function selectOrderBill()
    {
        ignore_user_abort();
        set_time_limit(0);

        $adm_cid = 1;
        $shop_id = 1;

        // 查询账单列表的数据
        $find_orbi_data = DB::table('order_bill')
            ->where('orbi_cid', $adm_cid)
            ->where('orbi_shop_id', $shop_id)
            ->select('orbi_number', 'orbi_bill_price', 'orbi_receive_price', 'orbi_state')
            ->get()->toArray();
        foreach ($find_orbi_data as $key => $value) {
            if ($value->orbi_bill_price == $value->orbi_receive_price && $value->orbi_state == 5) {
                dump($value->orbi_number);
            }
        }
        unset($find_orbi_data);
        echo '成功';
    }

    // 修改faster_data_statistical销售统计服务数据11
    public function editDastService()
    {
        ignore_user_abort();
        set_time_limit(0);

        // 查询销售统计表
        $find_dast_data = DB::table('data_statistical')
            ->where('dast_orgo_id', 0)
            ->select('dast_id')
            ->get()->toArray();
        foreach ($find_dast_data as $key => $value) {
            $edit_data['dast_service_project_type'] = 2;
            $edit_res = DB::table('data_statistical')
                ->where('dast_id', $value->dast_id)
                ->update($edit_data);
            unset($edit_data);
            unset($edit_res);
        }
        unset($find_dast_data);
        echo '修改成功';
    }

    // 修改出入库记录中 退货单类型存错值的
    public function editReceOutinType()
    {
        ignore_user_abort();
        set_time_limit(0);

        // 查询退货回收单表 类型退货单
        $find_recede_data = DB::table('recede_recycle')
            ->where('rec_source_type', 8)
            ->where('rec_create_time', '>', '2021-03-01 00:00:00')
            ->select('rec_number')
            ->get()->toArray();
        foreach ($find_recede_data as $key => $value) {
            $find_outin_data = DB::table('outin_record')
                ->where('oure_original_number', $value->rec_number)
                ->get()->toArray();
            $find_outin_data = json_decode(json_encode($find_outin_data, true), true);
            foreach ($find_outin_data as $keys => $values) {
                if ($values['oure_type'] != 13) {
                    // $add_data = $values;
                    // $add_data_res = DB::table('outin_record_test')->insert($add_data);
                    // echo '-----';
                    // echo $values['oure_original_number'];
                    $update_data['oure_type'] = 13;
                    $update_data_res = DB::table('outin_record')
                        ->where('oure_id', $values['oure_id'])
                        ->update($update_data);
                }
            }
        }
        echo '修改类型成功';
    }

    // 修改faster_enters_goods_price商品编码
    public function editGoodsencode()
    {
        ignore_user_abort();
        set_time_limit(0);

        // 查询enters_goods_price数据
        $find_data = DB::table('enters_goods_price')
            ->select('ense_goo_encode')
            ->get()->toArray();
        foreach ($find_data as $key => $value) {
            if (strlen($value->ense_goo_encode) == 7) {
                $update_data['ense_goo_encode'] = 'X'.$value->ense_goo_encode;
                $update_res = DB::table('enters_goods_price')
                    ->where('ense_goo_encode', $value->ense_goo_encode)
                    ->update($update_data);
            }
        }
        echo '修改成功';
    }

    // 计算期末金额 与 平均价*库存不相等
    public function getfalsedata($search_data)
    {
        ignore_user_abort();
        set_time_limit(0);
        // $delete_data = DB::table('enters_sells_savess')
        //     ->where('ense_id', '>=', 146126)
        //     ->delete();
        // echo 666;die;
        $enters_data = DB::table('enters_sells_saves')
            ->where(function ($query) use ($search_data) {
                // 如果选择开始时间并且选择结束时间
                if (!empty($search_data['create_time_start']) && !empty($search_data['create_time_end'])) {
                    $query->whereBetween('ense_time', [$search_data['create_time_start'], $search_data['create_time_end'] . ' 23:59:59']);
                } else {
                    // 如果选择开始时间
                    if (!empty($search_data['create_time_start'])) {
                        $query->where('ense_time', '>=', $search_data['create_time_start']);
                    } else {
                        // 如果选择结束时间
                        if (!empty($search_data['create_time_end'])) {
                            $query->where('ense_time', '<=', $search_data['create_time_end'] . ' 23:59:59');
                        }
                    }
                }
            }) //创建时间
            ->get()->toArray();
        $enters_data = json_decode(json_encode($enters_data, true), true);
        $i = 0;
        $j = 0;
        foreach ($enters_data as $key => $value) {
            $difference = $value['ense_end_amount'] - ($value['ense_end_price']*$value['ense_end_inventory']);
            if ($difference != 0) {
                $add_data[$i] = $value;
                $add_data[$i]['ense_difference'] = $difference;
                $add_data_res = DB::table('enters_sells_saves_back')->insert($add_data[$i]);
                $i++;
            }
            if ($value['ense_out_num'] < 0 && $value['ense_out_price'] == 0) {
                $add_datas[$j] = $value;
                $add_data_res1 = DB::table('enters_sells_saves_backs')->insert($add_datas[$j]);
                $j++;
            }
        }
        echo $i;
        echo '--------';
        echo $j;
        die;
    }

    //统计商品类型不一致的数据
    public function getdisffrensestate()
    {
        $find_data = DB::table('dispatch_bill as d')
            ->leftjoin('dispatch_goods as dg', 'd.dego_id', '=', 'dg.digo_dego_id')
            ->leftjoin('order_goods as o', 'o.orgo_id', '=', 'dg.digo_orgo_id')
            ->whereIn('dego_shop_id', [1,26])
            ->where('dego_type', 1)
            ->select('dego_id', 'orgo_id', 'digo_id', 'digo_goo_inventory', 'orgo_goo_inventory', 'digo_orgo_id')
            ->orderBy('dego_id', 'desc')
            ->get()->toArray();
        $new_data = [];
        foreach ($find_data as $key => $value) {
            if ($value->orgo_goo_inventory != $value->digo_goo_inventory) {
                $new_data[] = $value;
            }
        }
        dump($new_data);
        die;
    }

    // 计算进销存  【21.07.02】
    public function enterssellssaves($request)
    {
        ignore_user_abort();
        set_time_limit(0);

        $oure_shop_idarray[] = '1';
        $oure_shop_idarray[] = '2';
        $oure_shop_idarray[] = '26';
        // 厦门固定仓库
        $ware_id = array('5', '7', '9', '10', '11', '13', '14', '42', '53', '83', '91', '96', '121', '122', '129', '130', '131', '132', '133', '134', '135', '136', '137', '138', '139', '140', '141', '143', '150', '151', '152', '153', '154', '155', '156', '181', '189', '190', '191', '200', '201', '202', '203', '204', '205', '206', '209',
            '210', '212', '213', '214', '215');
        $a = "0";
        $id1 = $request['id1']; //3.1  106100
        $id2 = $request['id2']; //3.1  106100
        $unit = '';
        $result = DB::table('outin_record')
            ->whereIn('oure_shop_id', $oure_shop_idarray)
            ->where(function ($query) use ($id1) {
                $query->where('oure_id', '>=', $id1);
            })
            ->where(function ($query) use ($id2) {
                $query->where('oure_id', '<=', $id2);
            })
            ->select('oure_id', 'oure_shop_id', 'oure_original_correlation_number', 'oure_original_number', 'oure_in_ware_id', 'oure_out_ware_id', 'oure_type', 'oure_out_in_type', 'oure_waon_class', 'oure_create_time')
            ->orderBy('oure_create_time', 'asc')
            ->get()->toArray();
        $result = json_decode(json_encode($result), true);
        foreach ($result as $k => $v) {
            $goo_result = DB::table('outin_details')
                ->where('oude_oure_id', $v['oure_id'])
                ->select('oude_oure_id', 'oude_goo_id', 'oude_goo_number', 'oude_type')
                ->get()->toArray();
            $goo_result = json_decode(json_encode($goo_result), true);
            $oure_create_time = $v['oure_create_time'];
            $oure_shop_id = $v['oure_shop_id'];
            $oure_original_correlation_number = $v['oure_original_correlation_number'];
            $oure_in_ware_id = $v['oure_in_ware_id'];
            $oure_out_ware_id = $v['oure_out_ware_id'];
            $oure_type = $v['oure_type'];
            $oure_out_in_type = $v['oure_out_in_type'];
            $oure_waon_class = $v['oure_waon_class'];
            if ($oure_waon_class == '2') {
                $oure_waon_class = '1';
            }
            // 入库id-》高献昌
            if ($oure_out_in_type == '2') {
                $oure_ware_id = $oure_in_ware_id;
            } else { // 出库
                $oure_ware_id = $oure_out_ware_id;
            }
            if ($v['oure_original_correlation_number'] == '' && $v['oure_shop_id'] == '26') {
                // $enters_sellsarray['ense_goo_id']= $value;//商品id
                $enters_sellsarray['ense_goo_warehouse'] = $oure_ware_id; //所在仓库
                $enters_sellsarray['ense_order_number'] = $v['oure_original_correlation_number'];
                $enters_sellsarray['ense_shop_id'] = $oure_shop_id;
                $enters_sellsarray['ense_time'] = $oure_create_time;
                $enters_saves = DB::table('enters_sells_savesbak')->insertGetId($enters_sellsarray);
                continue;
            }

            foreach ($goo_result as $kk => $vv) {
                $value = $vv['oude_goo_id'];
                $goo_quantity = $vv['oude_goo_number'];
                $a = $a + 1;
                unset($enters_sellsarray);

                // 商品信息
                $goods = DB::table('goods')
                    ->where('goo_id', $value)
                    ->select('goo_name', 'goo_goods_encode', 'goo_ampere_hour', 'goo_attribute', 'goo_recycle_price')
                    ->first();

                // 当前成本价
                $datetime = date('Y-m-d H:i:s');
                $newprice = DB::table('enters_sells_savess')
                    ->where('ense_goo_id', $value)
                    ->where('ense_goo_warehouse', $oure_ware_id)
                    ->where('ense_goo_waretype', $oure_waon_class)
                    ->orderBy('ense_id', 'desc')
                    ->select('ense_end_price', 'ense_end_amount', 'ense_end_inventory')
                    ->first();
                if ($newprice) {
                    $new_nums = $newprice->ense_end_inventory;
                    if ($newprice->ense_end_price == 0) {
                        $ense_new_price = DB::table('enters_goods_price')
                            ->where('ense_goo_number', $goods->goo_goods_encode)
                            ->select('ense_new_price')
                            ->first();
                        if ($ense_new_price) {
                            if ($ense_new_price->ense_new_price == 0) {
                                $ense_new_price = DB::table('enters_goods_price')
                                    ->where('ense_goo_encode', $goods->goo_goods_encode)
                                    ->value('ense_new_price');
                                if ($ense_new_price) {
                                    $ense_end_price = $ense_new_price;
                                    // 当前总金额
                                    $ense_new_amount = $ense_new_price * $newprice->ense_end_inventory;
                                } else {
                                    $ense_new_price = DB::table('enters_goods_price')
                                        ->where('ense_goods_code', $goods->goo_goods_encode)
                                        ->value('ense_new_price');
                                    if ($ense_new_price) {
                                        $ense_end_price = $ense_new_price;
                                        // 当前总金额
                                        $ense_new_amount = $ense_new_price * $newprice->ense_end_inventory;
                                    } else {
                                        $ense_end_price = '0';
                                        $ense_new_amount = '0';
                                    }
                                }
                            } else {
                                $ense_end_price = $ense_new_price->ense_new_price;
                                // 当前总金额
                                $ense_new_amount = $ense_new_price->ense_new_price * $newprice->ense_end_inventory;
                            }
                        } else {
                            $ense_new_price = DB::table('enters_goods_price')
                                ->where('ense_goo_encode', $goods->goo_goods_encode)
                                ->value('ense_new_price');
                            if ($ense_new_price) {
                                $ense_end_price = $ense_new_price;
                                // 当前总金额
                                $ense_new_amount = $ense_new_price * $newprice->ense_end_inventory;
                            } else {
                                $ense_new_price = DB::table('enters_goods_price')
                                    ->where('ense_goods_code', $goods->goo_goods_encode)
                                    ->value('ense_new_price');
                                if ($ense_new_price) {
                                    $ense_end_price = $ense_new_price;
                                    // 当前总金额
                                    $ense_new_amount = $ense_new_price * $newprice->ense_end_inventory;
                                } else {
                                    $ense_end_price = '0';
                                    $ense_new_amount = '0';
                                }
                            }
                        }
                    } else {
                        $ense_end_price = $newprice->ense_end_price;
                        // 当前总金额
                        $ense_new_amount = $newprice->ense_end_amount;
                    }
                } else {
                    $new_nums = 0;
                    $ense_end_price = '0';
                    $ense_new_amount = '0';
                    if ($goods) {
                        $ense_new_price = DB::table('enters_goods_price')
                            ->where('ense_goo_number', $goods->goo_goods_encode)
                            ->select('ense_new_price')
                            ->first();
                        if ($ense_new_price) {
                            if ($ense_new_price->ense_new_price == 0) {
                                $ense_new_price = DB::table('enters_goods_price')
                                    ->where('ense_goo_encode', $goods->goo_goods_encode)
                                    ->value('ense_new_price');
                                if ($ense_new_price) {
                                    $ense_end_price = $ense_new_price;
                                    // 当前总金额
                                    $ense_new_amount = $ense_new_price * $new_nums;
                                } else {
                                    $ense_new_price = DB::table('enters_goods_price')
                                        ->where('ense_goods_code', $goods->goo_goods_encode)
                                        ->value('ense_new_price');
                                    if ($ense_new_price) {
                                        $ense_end_price = $ense_new_price;
                                        // 当前总金额
                                        $ense_new_amount = $ense_new_price * $new_nums;
                                    } else {
                                        $ense_end_price = '0';
                                        $ense_new_amount = '0';
                                    }
                                }
                            } else {
                                $ense_end_price = $ense_new_price->ense_new_price;
                                // 当前总金额
                                $ense_new_amount = $ense_new_price->ense_new_price * $new_nums;
                            }
                        } else {
                            $ense_new_price = DB::table('enters_goods_price')
                                ->where('ense_goo_encode', $goods->goo_goods_encode)
                                ->value('ense_new_price');
                            if ($ense_new_price) {
                                $ense_end_price = $ense_new_price;
                                // 当前总金额
                                $ense_new_amount = $ense_new_price * $new_nums;
                            } else {
                                $ense_new_price = DB::table('enters_goods_price')
                                    ->where('ense_goods_code', $goods->goo_goods_encode)
                                    ->value('ense_new_price');
                                if ($ense_new_price) {
                                    $ense_end_price = $ense_new_price;
                                    // 当前总金额
                                    $ense_new_amount = $ense_new_price * $new_nums;
                                } else {
                                    $ense_end_price = '0';
                                    $ense_new_amount = '0';
                                }
                            }
                        }
                    } else {
                        $new_nums = 0;
                        $ense_end_price = '0';
                        $ense_new_amount = '0';
                    }
                }
                if (!$goods) {
                    $enters_sellsarray['ense_goo_id'] = $value; //商品id
                    $enters_sellsarray['ense_goo_warehouse'] = $oure_ware_id; //所在仓库
                    $enters_sellsarray['ense_order_number'] = $v['oure_original_correlation_number'];
                    $enters_sellsarray['ense_shop_id'] = $oure_shop_id;
                    $enters_sellsarray['ense_time'] = $oure_create_time;
                    $enters_sellsarray['ense_goo_unit'] = $oure_create_time;
                    $enters_saves = DB::table('enters_sells_savesbak')->insertGetId($enters_sellsarray);
                    continue;
                }
                if ($goods->goo_attribute == '') {
                    $unit = "";
                } else {
                    $units = json_decode($goods->goo_attribute, true);
                    foreach ($units as $ks => $vs) {
                        if ($vs['key'] == '单位') {
                            $unit = $vs['value'];
                        }
                    }
                }
                $dh = substr($oure_original_correlation_number, 0, 2);
                if ($oure_type == '1' || $oure_type == '7') {
                    // 获取入库价
                    if ($dh == 'CG') {
                        $procurement_goodsres = DB::table('storage_goods')
                            ->where('relation_number', $oure_original_correlation_number)
                            ->where('goods_id', $value)
                            ->select('univalence')
                            ->first();
                        // 入库价
                        if ($procurement_goodsres) {
                            $goods_price = $procurement_goodsres->univalence;
                        } else {
                            $goods_price = 0;
                        }
                    } elseif ($dh == 'DB') {
                        $transferring_orderres = DB::table('transferring_order')
                            ->where('tror_number', $oure_original_correlation_number)
                            ->select('tror_id', 'tror_out_ware_id')
                            ->first();
                        $transferring_order_detailsres = DB::table('transferring_order_details')
                            ->where('trod_tror_id', $transferring_orderres->tror_id)
                            ->select('trod_export_time')
                            ->first();
                        $enters_sells_savessres = DB::table('enters_sells_savess')
                            ->where('ense_goo_id', $value)
                            ->where('ense_goo_warehouse', $transferring_orderres->tror_out_ware_id)
                            ->orderBy('ense_id', 'desc')
                            ->select('ense_end_price')
                            ->first();
                        // 入库价
                        if ($enters_sells_savessres) {
                            $goods_price = $enters_sells_savessres->ense_end_price;
                        } else {
                            $goods_price = '0';
                        }
                    }
                    if ($new_nums < 0) {
                        // 期末平均价
                        $price = $goods_price;
                        // 期末总价
                        $ense_end_amount = ($goo_quantity * $goods_price) + ($price * $new_nums);
                    } else {
                        // 期末总价
                        $ense_end_amount = $ense_new_amount + $goods_price * $goo_quantity;
                        // 期末平均价
                        if ($new_nums + $goo_quantity == '0') {
                            $price = 0;
                        } else {
                            $price = sprintf("%.4f", $ense_end_amount / ($new_nums + $goo_quantity));
                        }
                    }

                    // 添加信息
                    $enters_sellsarray['ense_goo_id'] = $value; //商品id
                    $enters_sellsarray['ense_goo_name'] = $goods->goo_name; //商品名称
                    $enters_sellsarray['ense_goo_number'] = $goods->goo_goods_encode; //商品编码
                    $enters_sellsarray['ense_goo_unit'] = $unit; //商品单位
                    $enters_sellsarray['ense_goo_specifications'] = $goods->goo_ampere_hour . "AH"; //商品规格
                    $enters_sellsarray['ense_goo_waretype'] = $oure_waon_class; //仓库类别
                    $enters_sellsarray['ense_goo_warehouse'] = $oure_ware_id; //所在仓库
                    $enters_sellsarray['ense_new_inventory'] = $new_nums; //当前库存
                    $enters_sellsarray['ense_new_price'] = $ense_end_price; //当前成本价
                    $enters_sellsarray['ense_new_amount'] = $ense_new_amount; //当前总金额
                    $enters_sellsarray['ense_end_inventory'] = $new_nums + $goo_quantity; //期末库存
                    $enters_sellsarray['ense_end_price'] = $price; //期末成本价
                    $enters_sellsarray['ense_end_amount'] = $ense_end_amount; //期末总金额
                    $enters_sellsarray['ense_in_num'] = $goo_quantity; //入库数量
                    $enters_sellsarray['ense_in_price'] = $goods_price; //入库单价
                    $enters_sellsarray['ense_in_amount'] = $goo_quantity * $goods_price; //入库总金额
                    $enters_sellsarray['ense_order_number'] = $oure_original_correlation_number; //
                    $enters_sellsarray['ense_out_in'] = $oure_out_in_type; //出入库类型：1出库，2入库
                    $enters_sellsarray['ense_type'] = $oure_type; //同出入库类型
                    $enters_sellsarray['ense_shop_id'] = $oure_shop_id;
                    $enters_sellsarray['ense_time'] = $oure_create_time;
                    $enters_saves = DB::table('enters_sells_savess')->insertGetId($enters_sellsarray);
                } elseif ($oure_type == '4') { //旧货回收
                    if ($oure_out_in_type == '2') {
                        // 获取回收金额
                        $recycleres = DB::table('junk_recycle')
                            ->where('jur_number', $v['oure_original_number'])
                            ->select('jur_id')
                            ->first();
                        if ($recycleres) {
                            $shop_setres = DB::table('junk_goods')
                                ->where('jugo_jur_id', $recycleres->jur_id)
                                ->select('jugo_goo_price')
                                ->first();
                            $goods_price = $shop_setres->jugo_goo_price / 100;
                        } else {
                            $goods_price = 0;
                        }
                        if ($new_nums < 0) {
                            // 期末平均价
                            $price = $goods_price;
                            // 期末总价
                            $ense_end_amount = ($goo_quantity * $goods_price) + ($price * $new_nums);
                        } else {
                            // 期末总价
                            $ense_end_amount = $ense_new_amount + $goods_price * $goo_quantity;
                            // 期末平均价
                            if ($new_nums + $goo_quantity == '0') {
                                $price = 0;
                            } else {
                                $price = sprintf("%.4f", $ense_end_amount / ($new_nums + $goo_quantity));
                            }
                        }
                        // 添加信息
                        $enters_sellsarray['ense_goo_id'] = $value; //商品id
                        $enters_sellsarray['ense_goo_name'] = $goods->goo_name; //商品名称
                        $enters_sellsarray['ense_goo_number'] = $goods->goo_goods_encode; //商品编码
                        $enters_sellsarray['ense_goo_unit'] = $unit; //商品单位
                        $enters_sellsarray['ense_goo_specifications'] = $goods->goo_ampere_hour . "AH"; //商品规格
                        $enters_sellsarray['ense_goo_waretype'] = $oure_waon_class; //仓库类别
                        $enters_sellsarray['ense_goo_warehouse'] = $oure_ware_id; //所在仓库
                        $enters_sellsarray['ense_new_inventory'] = $new_nums; //当前库存
                        $enters_sellsarray['ense_new_price'] = $ense_end_price; //当前成本价
                        $enters_sellsarray['ense_new_amount'] = $ense_new_amount; //当前总金额
                        $enters_sellsarray['ense_end_inventory'] = $new_nums + $goo_quantity; //期末库存
                        $enters_sellsarray['ense_end_price'] = $price; //期末成本价
                        $enters_sellsarray['ense_end_amount'] = $ense_end_amount; //期末总金额
                        $enters_sellsarray['ense_in_num'] = $goo_quantity; //入库数量
                        $enters_sellsarray['ense_in_price'] = $goods_price; //入库单价
                        $enters_sellsarray['ense_in_amount'] = $goo_quantity * $goods_price; //入库总金额
                        $enters_sellsarray['ense_order_number'] = $oure_original_correlation_number; //原始单号
                        $enters_sellsarray['ense_out_in'] = $oure_out_in_type; //出入库类型：1出库，2入库
                        $enters_sellsarray['ense_type'] = $oure_type; //同出入库类型
                        $enters_sellsarray['ense_shop_id'] = $oure_shop_id;
                        $enters_sellsarray['ense_time'] = $oure_create_time;
                    } else { //出库
                        // 添加信息
                        $enters_sellsarray['ense_goo_id'] = $value; //商品id
                        $enters_sellsarray['ense_goo_name'] = $goods->goo_name; //商品名称
                        $enters_sellsarray['ense_goo_number'] = $goods->goo_goods_encode; //商品编码
                        $enters_sellsarray['ense_goo_unit'] = $unit; //商品单位
                        $enters_sellsarray['ense_goo_specifications'] = $goods->goo_ampere_hour . "AH"; //商品规格
                        $enters_sellsarray['ense_goo_waretype'] = $oure_waon_class; //仓库类别
                        $enters_sellsarray['ense_goo_warehouse'] = $oure_ware_id; //所在仓库
                        $enters_sellsarray['ense_new_inventory'] = $new_nums; //当前库存
                        $enters_sellsarray['ense_new_price'] = $ense_end_price; //当前成本价
                        $enters_sellsarray['ense_new_amount'] = $ense_new_amount; //当前总金额
                        $enters_sellsarray['ense_end_inventory'] = $new_nums - $goo_quantity; //期末库存
                        $enters_sellsarray['ense_end_price'] = $ense_end_price; //期末成本价
                        $enters_sellsarray['ense_end_amount'] = $ense_new_amount - sprintf("%.4f", $goo_quantity * $ense_end_price); //期末总金额
                        $enters_sellsarray['ense_out_num'] = $goo_quantity; //出库数量
                        $enters_sellsarray['ense_out_price'] = $ense_end_price; //出库单价
                        $enters_sellsarray['ense_out_amount'] = sprintf("%.4f", $goo_quantity * $ense_end_price); //出库总金额
                        $enters_sellsarray['ense_order_number'] = $oure_original_correlation_number; //原始单号
                        $enters_sellsarray['ense_out_in'] = $oure_out_in_type; //出入库类型：1出库，2入库
                        $enters_sellsarray['ense_type'] = $oure_type; //同出入库类型
                        $enters_sellsarray['ense_shop_id'] = $oure_shop_id;
                        $enters_sellsarray['ense_time'] = $oure_create_time;
                    }
                    $enters_saves = DB::table('enters_sells_savess')->insertGetId($enters_sellsarray);
                } elseif ($oure_type == '5') {
                    $order_wareid = DB::table('order')
                        ->where('ord_order_number', $oure_original_correlation_number)
                        ->select('ord_ware_id')
                        ->first();
                    if ($order_wareid) {
                        if ($order_wareid->ord_ware_id == '0') {
                            $order_wareid = DB::table('recede_recycle')
                                ->where('rec_number', $v['oure_original_number'])
                                ->select('rec_ware_id')
                                ->first();
                            if (!$order_wareid) {
                                if (in_array($oure_ware_id, $ware_id)) {
                                    echo $v['oure_id'];
                                    exit;
                                } else {
                                    $enters_sellsarray['ense_goo_id'] = $value; //商品id
                                    $enters_sellsarray['ense_goo_warehouse'] = $oure_ware_id; //所在仓库
                                    $enters_sellsarray['ense_order_number'] = $v['oure_original_correlation_number'];
                                    $enters_sellsarray['ense_shop_id'] = $oure_shop_id;
                                    $enters_sellsarray['ense_time'] = $oure_create_time;
                                    $enters_saves = DB::table('enters_sells_savesbak')->insertGetId($enters_sellsarray);
                                    continue;
                                }
                            }
                            $ord_ware_id = $order_wareid->rec_ware_id;
                        } else {
                            $ord_ware_id = $order_wareid->ord_ware_id;
                        }
                    } else {
                        $order_wareid = DB::table('recede_recycle')
                            ->where('rec_number', $v['oure_original_number'])
                            ->select('rec_ware_id')
                            ->first();
                        if (!$order_wareid) {
                            if (in_array($oure_ware_id, $ware_id)) {
                                echo $v['oure_id'];
                                exit;
                            } else {
                                $enters_sellsarray['ense_goo_id'] = $value; //商品id
                                $enters_sellsarray['ense_goo_warehouse'] = $oure_ware_id; //所在仓库
                                $enters_sellsarray['ense_order_number'] = $v['oure_original_correlation_number'];
                                $enters_sellsarray['ense_shop_id'] = $oure_shop_id;
                                $enters_sellsarray['ense_time'] = $oure_create_time;
                                $enters_saves = DB::table('enters_sells_savesbak')->insertGetId($enters_sellsarray);
                                continue;
                            }
                        }
                        $ord_ware_id = $order_wareid->rec_ware_id;
                    }

                    $enters_sells_savessres = DB::table('enters_sells_savess')
                        ->where('ense_out_in', '1')
                        ->where('ense_type', '9')
                        ->where('ense_goo_id', $value)
                        ->where('ense_goo_warehouse', $ord_ware_id)
                        ->where('ense_order_number', $oure_original_correlation_number)
                        ->orderBy('ense_id', 'desc')
                        ->select('ense_end_price')
                        ->first();
                    // 入库金额
                    if ($enters_sells_savessres) {
                        $goods_price = $enters_sells_savessres->ense_end_price;
                    } else {
                        $goods_price = $ense_end_price;
                    }

                    // 期末总价
                    $ense_end_amount = $ense_new_amount + $goods_price * $goo_quantity;
                    $price = $ense_end_price;
                    // 添加信息
                    $enters_sellsarray['ense_goo_id'] = $value; //商品id
                    $enters_sellsarray['ense_goo_name'] = $goods->goo_name; //商品名称
                    $enters_sellsarray['ense_goo_number'] = $goods->goo_goods_encode; //商品编码
                    $enters_sellsarray['ense_goo_unit'] = $unit; //商品单位
                    $enters_sellsarray['ense_goo_specifications'] = $goods->goo_ampere_hour . "AH"; //商品规格
                    $enters_sellsarray['ense_goo_waretype'] = $oure_waon_class; //仓库类别
                    $enters_sellsarray['ense_goo_warehouse'] = $oure_ware_id; //所在仓库
                    $enters_sellsarray['ense_new_inventory'] = $new_nums; //当前库存
                    $enters_sellsarray['ense_new_price'] = $ense_end_price; //当前成本价
                    $enters_sellsarray['ense_new_amount'] = $ense_new_amount; //当前总金额
                    $enters_sellsarray['ense_end_inventory'] = $new_nums + $goo_quantity; //期末库存
                    $enters_sellsarray['ense_end_price'] = $price; //期末成本价
                    $enters_sellsarray['ense_end_amount'] = $ense_end_amount; //期末总金额
                    $enters_sellsarray['ense_out_num'] = "-" . $goo_quantity; //入库数量
                    $enters_sellsarray['ense_out_price'] = $goods_price; //入库单价
                    $enters_sellsarray['ense_out_amount'] = "-" . abs($goo_quantity * $goods_price); //入库总金额
                    $enters_sellsarray['ense_order_number'] = $oure_original_correlation_number; //原始单号
                    $enters_sellsarray['ense_out_in'] = $oure_out_in_type; //出入库类型：1出库，2入库
                    $enters_sellsarray['ense_type'] = $oure_type; //同出入库类型
                    $enters_sellsarray['ense_shop_id'] = $oure_shop_id;
                    $enters_sellsarray['ense_time'] = $oure_create_time;
                    $enters_saves = DB::table('enters_sells_savess')->insertGetId($enters_sellsarray);
                } elseif ($oure_type == '12' || $oure_type == '13') { //退货单
                    $goods_price = $ense_end_price;
                    $price = $ense_end_price;
                    $ense_end_amount = $ense_new_amount + $goo_quantity * $goods_price;
                    // 添加信息
                    $enters_sellsarray['ense_goo_id'] = $value; //商品id
                    $enters_sellsarray['ense_goo_name'] = $goods->goo_name; //商品名称
                    $enters_sellsarray['ense_goo_number'] = $goods->goo_goods_encode; //商品编码
                    $enters_sellsarray['ense_goo_unit'] = $unit; //商品单位
                    $enters_sellsarray['ense_goo_specifications'] = $goods->goo_ampere_hour . "AH"; //商品规格
                    $enters_sellsarray['ense_goo_waretype'] = $oure_waon_class; //仓库类别
                    $enters_sellsarray['ense_goo_warehouse'] = $oure_ware_id; //所在仓库
                    $enters_sellsarray['ense_new_inventory'] = $new_nums; //当前库存
                    $enters_sellsarray['ense_new_price'] = $ense_end_price; //当前成本价
                    $enters_sellsarray['ense_new_amount'] = $ense_new_amount; //当前总金额
                    $enters_sellsarray['ense_end_inventory'] = $new_nums + $goo_quantity; //期末库存
                    $enters_sellsarray['ense_end_price'] = $price; //期末成本价
                    $enters_sellsarray['ense_end_amount'] = $ense_end_amount; //期末总金额
                    $enters_sellsarray['ense_out_num'] = "-" . $goo_quantity; //入库数量
                    $enters_sellsarray['ense_out_price'] = $goods_price; //入库单价
                    $enters_sellsarray['ense_out_amount'] = "-" . abs($goo_quantity * $goods_price); //入库总金额
                    $enters_sellsarray['ense_order_number'] = $oure_original_correlation_number; //原始单号
                    $enters_sellsarray['ense_out_in'] = $oure_out_in_type; //出入库类型：1出库，2入库
                    $enters_sellsarray['ense_type'] = $oure_type; //同出入库类型
                    $enters_sellsarray['ense_shop_id'] = $oure_shop_id;
                    $enters_sellsarray['ense_time'] = $oure_create_time;
                    $enters_saves = DB::table('enters_sells_savess')->insertGetId($enters_sellsarray);
                } else {
                    // 采购退货单
                    if ($oure_type == '2' && $dh == 'TH') {
                        $procurement_goodsres = DB::table('storage_goods')
                            ->where('relation_number', $oure_original_correlation_number)
                            ->where('goods_id', $value)
                            ->select('univalence')
                            ->first();
                        // 入库价
                        if ($procurement_goodsres) {
                            $goods_price = $procurement_goodsres->univalence;
                        } else {
                            $goods_price = 0;
                        }

                        if ($new_nums < 0) {
                            // 期末平均价
                            $price = $goods_price;
                            // 期末总价
                            $ense_end_amount = ($price * $new_nums) - ($goo_quantity * $goods_price);
                        } else {
                            // 期末总价
                            $ense_end_amount = $ense_new_amount - $goods_price * $goo_quantity;
                            // 期末平均价
                            if ($new_nums + $goo_quantity == '0') {
                                $price = 0;
                            } else {
                                $price = sprintf("%.4f", $ense_end_amount / ($new_nums + $goo_quantity));
                            }
                        }
                        $enters_sellsarray['ense_goo_id'] = $value; //商品id
                        $enters_sellsarray['ense_goo_name'] = $goods->goo_name; //商品名称
                        $enters_sellsarray['ense_goo_number'] = $goods->goo_goods_encode; //商品编码
                        $enters_sellsarray['ense_goo_unit'] = $unit; //商品单位
                        $enters_sellsarray['ense_goo_specifications'] = $goods->goo_ampere_hour . "AH"; //商品规格
                        $enters_sellsarray['ense_goo_waretype'] = $oure_waon_class; //仓库类别
                        $enters_sellsarray['ense_goo_warehouse'] = $oure_ware_id; //所在仓库
                        $enters_sellsarray['ense_new_inventory'] = $new_nums; //当前库存
                        $enters_sellsarray['ense_new_price'] = $ense_end_price; //当前成本价
                        $enters_sellsarray['ense_new_amount'] = $ense_new_amount; //当前总金额
                        $enters_sellsarray['ense_end_inventory'] = $new_nums - $goo_quantity; //期末库存
                        $enters_sellsarray['ense_end_price'] = $price; //期末成本价
                        $enters_sellsarray['ense_end_amount'] = $ense_end_amount; //期末总金额
                        $enters_sellsarray['ense_in_num'] = "-" . $goo_quantity; //入库数量
                        $enters_sellsarray['ense_in_price'] = $goods_price; //入库单价
                        $enters_sellsarray['ense_in_amount'] = "-" . abs($goo_quantity * $goods_price); //入库总金额
                        $enters_sellsarray['ense_order_number'] = $oure_original_correlation_number; //原始单号
                        $enters_sellsarray['ense_out_in'] = $oure_out_in_type; //出入库类型：1出库，2入库
                        $enters_sellsarray['ense_type'] = $oure_type; //同出入库类型
                        $enters_sellsarray['ense_shop_id'] = $oure_shop_id;
                        $enters_sellsarray['ense_time'] = $oure_create_time;
                        $enters_saves = DB::table('enters_sells_savess')->insertGetId($enters_sellsarray);
                    } else {
                        if ($oure_type == '9' && $oure_out_in_type == '2') {
                            $order_wareid = DB::table('order')
                                ->where('ord_order_number', $oure_original_correlation_number)
                                ->select('ord_ware_id')
                                ->first();
                            if (!$order_wareid) {
                                if (in_array($oure_ware_id, $ware_id)) {
                                    echo $v['oure_id'];
                                    exit;
                                } else {
                                    $enters_sellsarray['ense_goo_id'] = $value; //商品id
                                    $enters_sellsarray['ense_goo_warehouse'] = $oure_ware_id; //所在仓库
                                    $enters_sellsarray['ense_order_number'] = $v['oure_original_correlation_number'];
                                    $enters_sellsarray['ense_shop_id'] = $oure_shop_id;
                                    $enters_sellsarray['ense_time'] = $oure_create_time;
                                    $enters_saves = DB::table('enters_sells_savesbak')->insertGetId($enters_sellsarray);
                                    continue;
                                }
                            }
                            $enters_sells_savessres = DB::table('enters_sells_savess')
                                ->where('ense_goo_id', $value)
                                ->where('ense_goo_warehouse', $order_wareid->ord_ware_id)
                                ->orderBy('ense_id', 'desc')
                                ->select('ense_end_price')
                                ->first();
                            if ($enters_sells_savessres) {
                                $goods_price = $enters_sells_savessres->ense_end_price;
                            } else {
                                $goods_price = '0';
                            }
                            if ($new_nums < 0) {
                                // 期末平均价
                                $price = $goods_price;
                                // 期末总价
                                $ense_end_amount = ($goo_quantity * $goods_price) + ($price * $new_nums);
                            } else {
                                // 期末总价
                                $ense_end_amount = $ense_new_amount + $goods_price * $goo_quantity;
                                // 期末平均价
                                if ($new_nums + $goo_quantity == '0') {
                                    $price = 0;
                                } else {
                                    $price = sprintf("%.4f", $ense_end_amount / ($new_nums + $goo_quantity));
                                }
                            }
                            // 添加信息
                            $enters_sellsarray['ense_goo_id'] = $value; //商品id
                            $enters_sellsarray['ense_goo_name'] = $goods->goo_name; //商品名称
                            $enters_sellsarray['ense_goo_number'] = $goods->goo_goods_encode; //商品编码
                            $enters_sellsarray['ense_goo_unit'] = $unit; //商品单位
                            $enters_sellsarray['ense_goo_specifications'] = $goods->goo_ampere_hour . "AH"; //商品规格
                            $enters_sellsarray['ense_goo_waretype'] = $oure_waon_class; //仓库类别
                            $enters_sellsarray['ense_goo_warehouse'] = $oure_ware_id; //所在仓库
                            $enters_sellsarray['ense_new_inventory'] = $new_nums; //当前库存
                            $enters_sellsarray['ense_new_price'] = $ense_end_price; //当前成本价
                            $enters_sellsarray['ense_new_amount'] = $ense_new_amount; //当前总金额
                            $enters_sellsarray['ense_end_inventory'] = $new_nums + $goo_quantity; //期末库存
                            $enters_sellsarray['ense_end_price'] = $price; //期末成本价
                            $enters_sellsarray['ense_end_amount'] = $ense_end_amount; //期末总金额
                            $enters_sellsarray['ense_out_num'] = "-" . $goo_quantity; //入库数量
                            $enters_sellsarray['ense_out_price'] = $goods_price; //入库单价
                            $enters_sellsarray['ense_out_amount'] = "-" . abs($goo_quantity * $goods_price); //入库总金额
                            $enters_sellsarray['ense_order_number'] = $oure_original_correlation_number; //原始单号
                            $enters_sellsarray['ense_out_in'] = $oure_out_in_type; //出入库类型：1出库，2入库
                            $enters_sellsarray['ense_type'] = $oure_type; //同出入库类型
                            $enters_sellsarray['ense_shop_id'] = $oure_shop_id;
                            $enters_sellsarray['ense_time'] = $oure_create_time;
                            $enters_saves = DB::table('enters_sells_savess')->insertGetId($enters_sellsarray);
                        } elseif ($oure_type == '15' && $oure_out_in_type == '2') {
                            if ($vv['oude_type'] != '3') {
                                if ($v['oure_original_correlation_number'] == 'P0103130704100120213' || $v['oure_original_correlation_number'] == 'P0103130703290126554' || $v['oure_original_correlation_number'] == 'P0103130702240199157' || $v['oure_original_correlation_number'] == 'P0103130656360187499' || $v['oure_original_correlation_number'] == 'P0103130551150119910') {
                                    $enters_sells_savesres = DB::table('enters_goods_price')
                                        ->where('ense_goo_number', $goods->goo_goods_encode)
                                        ->select('ense_new_price')
                                        ->first();
                                    if ($enters_sells_savesres) {
                                        if ($enters_sells_savesres->ense_new_price == 0) {
                                            $ense_new_price = DB::table('enters_goods_price')
                                                ->where('ense_goo_encode', $goods->goo_goods_encode)
                                                ->value('ense_new_price');
                                            if ($ense_new_price) {
                                                $goods_price = $ense_new_price;
                                            } else {
                                                $ense_new_price = DB::table('enters_goods_price')
                                                    ->where('ense_goods_code', $goods->goo_goods_encode)
                                                    ->value('ense_new_price');
                                                if ($ense_new_price) {
                                                    $goods_price = $ense_new_price;
                                                } else {
                                                    $goods_price = '0';
                                                }
                                            }
                                        } else {
                                            $goods_price = $enters_sells_savesres->ense_new_price;
                                        }
                                    } else {
                                        $enters_sells_savesres = DB::table('enters_goods_price')
                                            ->where('ense_goo_number', $goods->goo_goods_encode)
                                            ->select('ense_new_price')
                                            ->first();
                                        if ($enters_sells_savesres) {
                                            if ($enters_sells_savesres->ense_new_price == 0) {
                                                $ense_new_price = DB::table('enters_goods_price')
                                                    ->where('ense_goo_encode', $goods->goo_goods_encode)
                                                    ->value('ense_new_price');
                                                if ($ense_new_price) {
                                                    $goods_price = $ense_new_price;
                                                } else {
                                                    $ense_new_price = DB::table('enters_goods_price')
                                                        ->where('ense_goods_code', $goods->goo_goods_encode)
                                                        ->value('ense_new_price');
                                                    if ($ense_new_price) {
                                                        $goods_price = $ense_new_price;
                                                    } else {
                                                        $goods_price = '0';
                                                    }
                                                };
                                            } else {
                                                $goods_price = $enters_sells_savesres->ense_new_price;
                                            }
                                        } else {
                                            $ense_new_price = DB::table('enters_goods_price')
                                                ->where('ense_goo_encode', $goods->goo_goods_encode)
                                                ->value('ense_new_price');
                                            if ($ense_new_price) {
                                                $goods_price = $ense_new_price;
                                            } else {
                                                $ense_new_price = DB::table('enters_goods_price')
                                                    ->where('ense_goods_code', $goods->goo_goods_encode)
                                                    ->value('ense_new_price');
                                                if ($ense_new_price) {
                                                    $goods_price = $ense_new_price;
                                                } else {
                                                    $goods_price = '0';
                                                }
                                            };
                                        }
                                    }
                                    // 期末总价
                                    $ense_end_amount = $goods_price * $vv['oude_goo_number'];
                                    // 添加信息
                                    $enters_sellsarray['ense_goo_id'] = $value; //商品id
                                    $enters_sellsarray['ense_goo_name'] = $goods->goo_name; //商品名称
                                    $enters_sellsarray['ense_goo_number'] = $goods->goo_goods_encode; //商品编码
                                    $enters_sellsarray['ense_goo_unit'] = $unit; //商品单位
                                    $enters_sellsarray['ense_goo_specifications'] = $goods->goo_ampere_hour . "AH"; //商品规格
                                    $enters_sellsarray['ense_goo_waretype'] = $oure_waon_class; //仓库类别
                                    $enters_sellsarray['ense_goo_warehouse'] = $oure_ware_id; //所在仓库
                                    $enters_sellsarray['ense_new_inventory'] = $new_nums + $goo_quantity; //当前库存
                                    $enters_sellsarray['ense_new_price'] = $goods_price; //当前成本价
                                    $enters_sellsarray['ense_new_amount'] = $ense_end_amount; //当前总金额
                                    $enters_sellsarray['ense_end_inventory'] = $new_nums + $goo_quantity; //期末库存
                                    $enters_sellsarray['ense_end_price'] = $goods_price; //期末成本价
                                    $enters_sellsarray['ense_end_amount'] = $ense_end_amount; //期末总金额
                                    $enters_sellsarray['ense_in_num'] = $goo_quantity; //入库数量
                                    $enters_sellsarray['ense_in_price'] = $goods_price; //入库单价
                                    $enters_sellsarray['ense_in_amount'] = $goo_quantity * $goods_price; //入库总金额
                                    $enters_sellsarray['ense_order_number'] = $oure_original_correlation_number; //原始单号
                                    $enters_sellsarray['ense_out_in'] = $oure_out_in_type; //出入库类型：1出库，2入库
                                    $enters_sellsarray['ense_type'] = $oure_type; //同出入库类型
                                    $enters_sellsarray['ense_shop_id'] = $oure_shop_id;
                                    $enters_sellsarray['ense_time'] = $oure_create_time;
                                    $enters_saves = DB::table('enters_sells_savess')->insertGetId($enters_sellsarray);
                                } else {
                                    $enters_sells_savesres = DB::table('enters_sells_savess')
                                        ->where('ense_goo_id', $value)
                                        ->where('ense_goo_warehouse', $oure_ware_id)
                                        ->orderBy('ense_id', 'desc')
                                        ->select('ense_end_price')
                                        ->first();
                                    if ($enters_sells_savesres) {
                                        $goods_price = $enters_sells_savesres->ense_end_price;
                                    } else {
                                        $goods_price = '0';
                                    }
                                    // 期末总价
                                    $ense_end_amount = $ense_new_amount + $goods_price * $goo_quantity;
                                    if ($new_nums + $goo_quantity == '0') {
                                        $price = 0;
                                    } else {
                                        $price = sprintf("%.4f", $ense_end_amount / ($new_nums + $goo_quantity));
                                    }
                                    // 添加信息
                                    $enters_sellsarray['ense_goo_id'] = $value; //商品id
                                    $enters_sellsarray['ense_goo_name'] = $goods->goo_name; //商品名称
                                    $enters_sellsarray['ense_goo_number'] = $goods->goo_goods_encode; //商品编码
                                    $enters_sellsarray['ense_goo_unit'] = $unit; //商品单位
                                    $enters_sellsarray['ense_goo_specifications'] = $goods->goo_ampere_hour . "AH"; //商品规格
                                    $enters_sellsarray['ense_goo_waretype'] = $oure_waon_class; //仓库类别
                                    $enters_sellsarray['ense_goo_warehouse'] = $oure_ware_id; //所在仓库
                                    $enters_sellsarray['ense_new_inventory'] = $new_nums; //当前库存
                                    $enters_sellsarray['ense_new_price'] = $ense_end_price; //当前成本价
                                    $enters_sellsarray['ense_new_amount'] = $ense_new_amount; //当前总金额
                                    $enters_sellsarray['ense_end_inventory'] = $new_nums + $goo_quantity; //期末库存
                                    $enters_sellsarray['ense_end_price'] = $price; //期末成本价
                                    $enters_sellsarray['ense_end_amount'] = $ense_end_amount; //期末总金额
                                    $enters_sellsarray['ense_in_num'] = $goo_quantity; //入库数量
                                    $enters_sellsarray['ense_in_price'] = $goods_price; //入库单价
                                    $enters_sellsarray['ense_in_amount'] = $goo_quantity * $goods_price; //入库总金额
                                    $enters_sellsarray['ense_order_number'] = $oure_original_correlation_number; //原始单号
                                    $enters_sellsarray['ense_out_in'] = $oure_out_in_type; //出入库类型：1出库，2入库
                                    $enters_sellsarray['ense_type'] = $oure_type; //同出入库类型
                                    $enters_sellsarray['ense_shop_id'] = $oure_shop_id;
                                    $enters_sellsarray['ense_time'] = $oure_create_time;
                                    $enters_saves = DB::table('enters_sells_savess')->insertGetId($enters_sellsarray);
                                }
                            }
                        } else {
                            // 添加信息
                            $enters_sellsarray['ense_goo_id'] = $value; //商品id
                            $enters_sellsarray['ense_goo_name'] = $goods->goo_name; //商品名称
                            $enters_sellsarray['ense_goo_number'] = $goods->goo_goods_encode; //商品编码
                            $enters_sellsarray['ense_goo_unit'] = $unit; //商品单位
                            $enters_sellsarray['ense_goo_specifications'] = $goods->goo_ampere_hour . "AH"; //商品规格
                            $enters_sellsarray['ense_goo_waretype'] = $oure_waon_class; //仓库类别
                            $enters_sellsarray['ense_goo_warehouse'] = $oure_ware_id; //所在仓库
                            $enters_sellsarray['ense_new_inventory'] = $new_nums; //当前库存
                            $enters_sellsarray['ense_new_price'] = $ense_end_price; //当前成本价
                            $enters_sellsarray['ense_new_amount'] = $ense_new_amount; //当前总金额
                            $enters_sellsarray['ense_end_inventory'] = $new_nums - $goo_quantity; //期末库存
                            $enters_sellsarray['ense_end_price'] = $ense_end_price; //期末成本价
                            $enters_sellsarray['ense_end_amount'] = $ense_new_amount - sprintf("%.4f", $goo_quantity * $ense_end_price); //期末总金额
                            $enters_sellsarray['ense_out_num'] = $goo_quantity; //出库数量
                            $enters_sellsarray['ense_out_price'] = $ense_end_price; //出库单价
                            $enters_sellsarray['ense_out_amount'] = sprintf("%.4f", $goo_quantity * $ense_end_price); //出库总金额
                            $enters_sellsarray['ense_order_number'] = $oure_original_correlation_number; //原始单号
                            $enters_sellsarray['ense_out_in'] = $oure_out_in_type; //出入库类型：1出库，2入库
                            $enters_sellsarray['ense_type'] = $oure_type; //同出入库类型
                            $enters_sellsarray['ense_shop_id'] = $oure_shop_id;
                            $enters_sellsarray['ense_time'] = $oure_create_time;
                            $enters_saves = DB::table('enters_sells_savess')->insertGetId($enters_sellsarray);
                        }
                    }
                }
            }
        }
        echo $a;
        exit;
    }

    // 查询凭证列表已同步U8成本和销售统计成本不一致的 【21.07.02】
    public function syncOrder(Request $request)
    {
        ignore_user_abort();
        set_time_limit(0);

        $search_data = $request->all();
        // 查询销售统计表
        $find_dast_data = DB::table('data_statistical as dast')
            ->leftjoin('order as ord', 'ord.ord_id', '=', 'dast_ord_id')
            ->where('dast_cid', 1)
            ->where('dast_shop_id', 1)
            ->where('dast_superior_shop_id', 1)
            ->whereIn('dast_order_type', [1, 2])
            ->where('dast_goo_id', '!=', 0)
            ->where('dast_ord_delete', 1)
            ->where('dast_ord_form_type', 1)
            // ->where('dast_id', '>', 60000)
            // ->where('dast_id', '<=', 90000)
            ->where('dast_service_type', '!=', 4)
            // ->where('dast_waon_class', '=', 1)
            ->where(function ($query) use ($search_data) {
                // 如果选择开始时间并且选择结束时间
                if (!empty($search_data['create_time_start']) && !empty($search_data['create_time_end'])) {
                    $query->whereBetween('dast_create_time', [$search_data['create_time_start'], $search_data['create_time_end'] . ' 23:59:59']);
                } else {
                    // 如果选择开始时间
                    if (!empty($search_data['create_time_start'])) {
                        $query->where('dast_create_time', '>=', $search_data['create_time_start']);
                    } else {
                        // 如果选择结束时间
                        if (!empty($search_data['create_time_end'])) {
                            $query->where('dast_create_time', '<=', $search_data['create_time_end'] . ' 23:59:59');
                        }
                    }
                }
            }) //创建时间
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['dast_order_number'])) {
                    $query->where('dast_order_number', 'like', '%' . $search_data['dast_order_number'] . '%');
                }
            }) //单号
            ->select('dast_id', 'dast_ord_id', 'dast_order_number', 'dast_goo_quantity', 'dast_goo_cost', 'dast_goo_id', 'dast_orgo_id')
            ->get()->toArray();
        $dast_subtract = [];

        foreach ($find_dast_data as $kk => $vv) {
            if (!isset($dast_subtract[$vv->dast_ord_id])) {
                $dast_subtract[$vv->dast_ord_id] = 0;
            }
            $dast_subtract[$vv->dast_ord_id] += ($vv->dast_goo_quantity * $vv->dast_goo_cost); //商品数量
        }
        unset($find_dast_data);
        foreach ($dast_subtract as $key => $value) {
            // 查询凭证列表的数据
            $find_vore_data = DB::table('voucher_receipts')
                ->where('vore_cid', 1)
                ->where('vore_shop_id', 1)
                ->where('vore_superior_shop_id', 1)
                ->where('vore_ord_id', $key)
                ->where('vore_state', 2)
                ->where('vore_service_type', '!=', 3)
                ->select('vore_id', 'vore_ord_id', 'vore_ord_number', 'vore_early_costing', 'vore_create_time')
                ->first();
            if ($find_vore_data) {
                // 销售统计总成本
                $dast_goo_cost = abs($value) / 100;
                // 凭证列表总成本
                $find_volo_data = DB::table('voucher_loan')
                    ->where('volo_vore_id', $find_vore_data->vore_id)
                    ->get()->toArray();
                $find_volo_data = json_decode(json_encode($find_volo_data), true);
                $total_cost = $find_vore_data->vore_early_costing;
                // 凭证成本和销售统计成本差值
                $edits_cost = $dast_goo_cost - abs($find_volo_data[0]['volo_borrow_costing']);
                // 成本价差异小于10
                if ($dast_goo_cost != abs($find_volo_data[0]['volo_borrow_costing'])) {
                    // if ($dast_goo_cost != $find_volo_data[0]['volo_borrow_costing'] && abs($edits_cost) < 10 && abs($edits_cost) != 0) {
                    // 成本价差异大于10
                    // if ($dast_goo_cost != $find_volo_data[0]['volo_borrow_costing'] && abs($edits_cost) >= 10 && abs($edits_cost) != 0) {
                    // dump($edits_cost);
                    // continue;
                    // 根据商品id,查询对应的检索编码
                    $find_dats = DB::table("data_statistical as a")
                        ->leftJoin('goods as b', 'b.goo_id', '=', 'a.dast_goo_id')
                        ->leftjoin('order as ord', 'ord.ord_id', '=', 'a.dast_ord_id')
                        ->where('dast_ord_id', $key)
                        ->where('dast_cid', 1)
                        ->where('dast_shop_id', 1)
                        ->where('dast_superior_shop_id', 1)
                        ->whereIn('dast_order_type', [1, 2])
                        ->where('dast_goo_id', '!=', 0)
                        ->where('dast_ord_delete', 1)
                        ->where('dast_ord_form_type', 1)
                        // ->where('dast_id', '>', 60000)
                        // ->where('dast_id', '<=', 90000)
                        ->where('dast_service_type', '!=', 4)
                        // ->where('dast_waon_class', '=', 1)
                        ->select('goo_goods_encode', 'goo_id', 'dast_goo_cost', 'goo_name', 'dast_create_time', 'dast_id', 'dast_orgo_id')
                        ->get()->toArray();
                    // dump($find_dats);
                    // dump(count($find_dats));
                    $count_array = count($find_dats);

                    foreach ($find_dats as $kkk => $vvv) {
                        // 根据订单id,查询对应的商品id
                        $add_data['dast_cid'] = 1; //所属企业id
                        $add_data['dast_superior_shop_id'] = 1; //所属总店id
                        $add_data['dast_shop_id'] = 1; //所属门店id
                        $add_data['dast_ord_id'] = $find_vore_data->vore_ord_id; //订单id
                        $add_data['dast_order_number'] = $find_vore_data->vore_ord_number; //订单单号
                        $add_data['dast_service_type'] = 1;
                        $add_data['dast_goo_id'] = $vvv->goo_id; //商品id
                        $add_data['dast_goo_name'] = $vvv->goo_name; //商品名称
                        $add_data['dast_goo_encode'] = $vvv->goo_goods_encode; //检索编码
                        $add_data['dast_goo_cost'] = $vvv->dast_goo_cost / 100; //销售统计单个商品成本
                        $add_data['dast_goo_costs'] = $dast_goo_cost; //销售统计总成本
                        $add_data['dast_vour_costs'] = $find_volo_data[0]['volo_borrow_costing']; //凭证列表的成本
                        $add_data['dast_diff_cost'] = sprintf("%.2f", $edits_cost); //凭证列表的成本
                        $add_data['dast_add_time'] = $vvv->dast_create_time; //开单时间
                        $dast_id = DB::table('data_statistical_test')->insert($add_data);
                        unset($add_data);
                        unset($dast_id);
                        continue;
                        // 成本价小于10
                        if (($count_array - 1) == $kkk) {
                            // dump($kkk);
                            // dump($vvv);
                            // 修改销售统计列表的成本
                            $edits_cost =  sprintf("%.2f", $edits_cost);
                            $edit_dast_data['dast_goo_cost'] = ($vvv->dast_goo_cost / 100 + $edits_cost) * 100;
                            dump($edits_cost . '差异');
                            dump($vvv->dast_goo_cost / 100);
                            dump($edit_dast_data['dast_goo_cost'] . '修正后的');
                            // $edit_dast_res = DB::table("data_statistical")
                            //     ->where('dast_id', $vvv->dast_id)
                            //     ->update($edit_dast_data);
                            // 修改订单商品列表的成本
                            $edit_orgo_data['orgo_goo_cost'] = ($vvv->dast_goo_cost / 100 + $edits_cost) * 100;
                            // $edit_orgo_res = DB::table("order_goods")
                            //     ->where('orgo_id', $vvv->dast_orgo_id)
                            //     ->update($edit_orgo_data);
                        }
                        continue;
                        // 成本价大于10
                        // 修改销售统计列表的成本
                        // 多商品时,差值/总商品个数
                        $diff_cost = $edits_cost / $count_array;
                        $asss_cost = sprintf("%.2f", ($vvv->dast_goo_cost / 100 + $diff_cost));
                        $edit_dast_data['dast_goo_cost'] = $asss_cost * 100;
                        // dump($count_array . '**********');
                        // dump($edits_cost . '+_+_+_+_');
                        // dump($diff_cost . '!!!!!!');
                        // dump($asss_cost . '&&&&&&');
                        // dump($vvv->dast_goo_cost / 100 . '====');
                        // dump($edit_dast_data['dast_goo_cost'] . '````====````');
                        $edit_dast_res = DB::table("data_statistical")
                            ->where('dast_id', $vvv->dast_id)
                            ->update($edit_dast_data);
                        // 修改订单商品列表的成本
                        $edit_orgo_data['orgo_goo_cost'] = $asss_cost * 100;
                        $edit_orgo_res = DB::table("order_goods")
                            ->where('orgo_id', $vvv->dast_orgo_id)
                            ->update($edit_orgo_data);
                    }
                    unset($find_dats);
                }
            }
            unset($find_vore_data);
        }
        echo "string";
        exit;
    }

    // 查询销售统计-销售明细界面的成本为0,跟进销存成本对比,不一致的查询出来 【21.07.02】
    public function selectDataStatistical(Request $request)
    {
        ignore_user_abort();
        set_time_limit(0);

        $search_data = $request->all();

        $dast_service_type = 4;
        // 查询销售统计表
        $find_dast_data = DB::table('data_statistical as dast')
            ->leftJoin('goods as b', 'b.goo_id', '=', 'dast.dast_goo_id')
            ->where('dast_cid', 1)
            ->where('dast_shop_id', 1)
            ->where('dast_superior_shop_id', 1)
            ->whereIn('dast_order_type', [1, 2])//订单类型，1销售单2退款单3忽略
            ->where('dast_goo_id', '!=', 0)
            ->where('dast_ord_delete', 1)
            ->where('dast_ord_form_type', 1)//订单分类1普通订单2虚拟加盟店订单
            ->where('dast_service_project_type', 1)//类型：1商品2服务
            // ->where('dast_id', '>', 80000)
            // ->where('dast_id', '<=', 100000)
            // ->where('dast_goo_cost', 0)
            ->where('dast_service_type', '=', $dast_service_type)//订单类型：1服务单 2销售单 3换货单 4退货单 5发货单 6结清单 7救援单
            // ->where('dast_waon_class', '=', 3)
            // ->whereIn('dast_good_state', [1, 5, 8])//商品状态1.正常 2.删除3回收的商品4换货商品5赠品商品6备用电池7临时商品8旧货商品
            // ->where('dast_order_number', 'D2021030915335900082')
            ->where(function ($query) use ($search_data) {
                //如果选择开始时间并且选择结束时间
                if (!empty($search_data['create_time_start']) && !empty($search_data['create_time_end'])) {
                    $query->whereBetween('dast_create_time', [$search_data['create_time_start'], $search_data['create_time_end'] . ' 23:59:59']);
                } else {
                    // 如果选择开始时间
                    if (!empty($search_data['create_time_start'])) {
                        $query->where('dast_create_time', '>=', $search_data['create_time_start']);
                    } else {
                        // 如果选择结束时间
                        if (!empty($search_data['create_time_end'])) {
                            $query->where('dast_create_time', '<=', $search_data['create_time_end'] . ' 23:59:59');
                        }
                    }
                }
            }) //创建时间
            ->select('dast_id', 'dast_ord_id', 'dast_order_number', 'dast_goo_quantity', 'dast_goo_cost', 'dast_goo_id', 'dast_orgo_id', 'dast_ware_id', 'dast_waon_class', 'goo_goods_encode', 'goo_id', 'dast_goo_cost', 'goo_name', 'dast_create_time', 'dast_goo_price')
            ->get()->toArray();
        foreach ($find_dast_data as $key => $value) {
            // 查询进销存列表的数据
            $ense_end_price = DB::table('enters_sells_saves')
                ->where('ense_shop_id', 1)
                ->where('ense_goo_warehouse', $value->dast_ware_id)
                ->where('ense_goo_waretype', $value->dast_waon_class)
                ->where('ense_goo_id', $value->dast_goo_id)
                ->where('ense_order_number', $value->dast_order_number)
                ->where('ense_end_price', '!=', 0)
                ->value('ense_end_price');
            $add_data['dast_vour_costs'] = sprintf("%.2f", $ense_end_price);//进销存成本
            $add_data['dast_diff_cost'] = sprintf("%.2f", $ense_end_price) - $value->dast_goo_cost/100;//差额
            // if ($ense_end_price != $value->dast_goo_cost) {
            if ($add_data['dast_diff_cost'] != 0) {
                $find_vore_data = DB::table('voucher_receipts')
                    ->where('vore_cid', 1)
                    ->where('vore_shop_id', 1)
                    ->where('vore_superior_shop_id', 1)
                    ->where('vore_ord_id', $value->dast_ord_id)
                    ->where('vore_ord_number', $value->dast_order_number)
                    // ->where('vore_state', 1)
                    ->where('vore_service_type', '!=', 3)
                    ->select('vore_id', 'vore_state')
                    ->first();
                if (empty($find_vore_data)) {
                    $add_data['dast_wago_id'] = 0;
                } else {
                    $add_data['dast_wago_id'] = $find_vore_data->vore_state;//是否上传凭证，U8状态1.未同步2.已同步
                }

                // 根据订单id,查询对应的商品id
                $add_data['dast_cid'] = 1;//所属企业id
                $add_data['dast_superior_shop_id'] = 1;//所属总店id
                $add_data['dast_shop_id'] = 1;//所属门店id
                $add_data['dast_ord_id'] = $value->dast_ord_id;//订单id
                $add_data['dast_order_number'] = $value->dast_order_number;//订单单号
                $add_data['dast_service_type'] = $dast_service_type;
                $add_data['dast_goo_id'] = $value->goo_id;//商品id
                $add_data['dast_goo_name'] = $value->goo_name;//商品名称
                $add_data['dast_goo_encode'] = $value->goo_goods_encode;//检索编码
                $add_data['dast_goo_cost'] = $value->dast_goo_cost / 100;//销售统计单个商品成本
                $add_data['dast_goo_costs'] = $value->dast_goo_cost / 100;//销售统计总成本
                // $add_data['dast_vour_costs'] = sprintf("%.2f", $ense_end_price);//进销存成本
                // $add_data['dast_diff_cost'] = sprintf("%.2f", $ense_end_price) - $value->dast_goo_cost/100;//差额
                $add_data['dast_add_time'] = $value->dast_create_time;//开单时间
                $dast_id = DB::table('data_statistical_test')->insert($add_data);
                if ($add_data['dast_wago_id'] != 2) {
                    $ense_end_price = sprintf("%.2f", $ense_end_price);
                    // 修改订单商品表成本价
                    $edit_orgo_data['orgo_goo_cost'] = $ense_end_price * 100;
                    // $edit_orgo_data['orgo_goo_cost'] = 0;
                    $edit_orgo_res = DB::table('order_goods')
                        ->where('orgo_id', $value->dast_orgo_id)
                        ->update($edit_orgo_data);
                    // 修改销售统计表成本价
                    $edit_dast_data['dast_goo_cost'] = $ense_end_price * 100;
                    // $edit_dast_data['dast_goo_cost'] = 0;
                    $edit_dast_res = DB::table('data_statistical')
                        ->where('dast_id', $value->dast_id)
                        ->update($edit_dast_data);
                }
                unset($add_data);
                unset($dast_id);
                unset($find_vore_data);
            }
            if ($value->dast_goo_cost > abs($value->dast_goo_price)) {//成本价大于销售价
                // 根据订单id,查询对应的商品id
                // $add_data_dif['dast_cid'] = 1;//所属企业id
                // $add_data_dif['dast_superior_shop_id'] = 1;//所属总店id
                // $add_data_dif['dast_shop_id'] = 1;//所属门店id
                // $add_data_dif['dast_ord_id'] = $value->dast_ord_id;//订单id
                // $add_data_dif['dast_order_number'] = $value->dast_order_number;//订单单号
                // $add_data_dif['dast_service_type'] = 1;
                // $add_data_dif['dast_goo_id'] = $value->goo_id;//商品id
                // $add_data_dif['dast_goo_name'] = $value->goo_name;//商品名称
                // $add_data_dif['dast_goo_encode'] = $value->goo_goods_encode;//检索编码
                // $add_data_dif['dast_goo_price'] = $value->dast_goo_price / 100;//销售统计单个商品销售价
                // $add_data_dif['dast_goo_cost'] = $value->dast_goo_cost / 100;//销售统计单个商品成本
                // $add_data_dif['dast_goo_costs'] = $value->dast_goo_cost / 100;//销售统计总成本
                // $add_data_dif['dast_vour_costs'] = sprintf("%.2f", $ense_end_price);//凭证列表的成本
                // $add_data_dif['dast_diff_cost'] = sprintf("%.2f", $ense_end_price) - $value->dast_goo_cost/100;//凭证列表的成本
                // $add_data_dif['dast_add_time'] = $value->dast_create_time;//开单时间
                // $dast_ids = DB::table('data_statistical_test_dif')->insert($add_data_dif);
                // unset($add_data_dif);
                // unset($dast_ids);
            }
            unset($ense_end_price);
        }
        echo "success";
        exit;
    }

    // 根据销售统计成本修改凭证的成本 【21.07.02】 未同步u8的
    public function editVoucher()
    {
        ignore_user_abort();
        set_time_limit(0);

        // 查询销售统计表
        $find_dast_data = DB::table('data_statistical_test')
            // ->where('dast_vour_costs', 0)
            ->where('dast_wago_id', '2')
            ->where('dast_add_time', '>', '2021-07-01')
            ->where('dast_goo_encode', '03203')
            ->get()->toArray();
        dump($find_dast_data);
        die;
        $edit_dast = [];//已更改的订单
        foreach ($find_dast_data as $key => $value) {
            // 已同步U8的跳过
            // if ($value->dast_wago_id == 2) {
            //     continue;
            // }
            $find_dast_order_data = DB::table('data_statistical')
                ->where('dast_cid', 1)
                ->where('dast_shop_id', 1)
                ->where('dast_superior_shop_id', 1)
                ->whereIn('dast_order_type', [1, 2])//订单类型，1销售单2退款单3忽略
                ->where('dast_ord_delete', 1)
                ->where('dast_ord_form_type', 1)//订单分类1普通订单2虚拟加盟店订单
                ->where('dast_service_project_type', 1)//类型：1商品2服务
                ->where('dast_ord_id', $value->dast_ord_id)
                ->where('dast_order_number', $value->dast_order_number)
                ->where('dast_goo_id', $value->dast_goo_id)
                ->first();
            // dump($find_dast_order_data);
            $ense_end_price = $value->dast_vour_costs;
            // 修改订单商品表成本价
            $edit_orgo_data['orgo_goo_cost'] = $ense_end_price * 100;
            $edit_orgo_res = DB::table('order_goods')
                ->where('orgo_id', $find_dast_order_data->dast_orgo_id)
                ->update($edit_orgo_data);
            // 修改销售统计表成本价
            $edit_dast_data['dast_goo_cost'] = $ense_end_price * 100;
            $edit_dast_res = DB::table('data_statistical')
                ->where('dast_id', $find_dast_order_data->dast_id)
                ->update($edit_dast_data);
            unset($edit_dast_data);
            unset($edit_orgo_data);

            if (in_array($value->dast_order_number,$edit_dast)) {
                continue;
            }
            $edit_data[] = $value->dast_order_number;
            // 查询凭证列表的数据
            $find_vore_data = DB::table('voucher_receipts')
                ->where('vore_cid', 1)
                ->where('vore_shop_id', 1)
                ->where('vore_superior_shop_id', 1)
                ->where('vore_ord_id', $value->dast_ord_id)
                ->where('vore_ord_number', $value->dast_order_number)
                ->where('vore_state', 2)
                ->where('vore_service_type', '!=', 3)
                ->select('vore_id', 'vore_ord_id', 'vore_ord_number', 'vore_early_costing', 'vore_create_time')
                ->first();
            if ($find_vore_data) {
                // 凭证列表总成本
                $find_volo_data = DB::table('voucher_loan')
                    ->where('volo_vore_id', $find_vore_data->vore_id)
                    ->get()->toArray();
                $find_volo_data = json_decode(json_encode($find_volo_data), true);
                if ($find_volo_data) {
                    // 查询销售统计单子的总成本
                    $find_dast_order_data = DB::table('data_statistical')
                        ->where('dast_cid', 1)
                        ->where('dast_shop_id', 1)
                        ->where('dast_ord_id', $value->dast_ord_id)
                        ->where('dast_order_number', $value->dast_order_number)
                        ->where('dast_ord_delete', 1)
                        ->where('dast_order_type', 1)//订单类型，1销售单2退款单3忽略
                        ->where('dast_ord_form_type', 1)
                        ->select('dast_id', 'dast_ord_id', 'dast_order_number', 'dast_goo_cost', 'dast_goo_quantitys')
                        ->get()->toArray();
                    $dast_goo_costs = 0;
                    foreach ($find_dast_order_data as $key => $value) {
                        $cost = $value->dast_goo_quantitys * $value->dast_goo_cost;
                        $dast_goo_costs += $cost;
                    }
                    $dast_goo_costs = abs($dast_goo_costs / 100);
                    // dump($value);
                    // dump($dast_goo_costs);
                    // die;
                    foreach ($find_volo_data as $kkk => $vvv) {
                        // 修改凭证列表的成本
                        $volo_edit_data['volo_borrow_costing'] = $dast_goo_costs;
                        $volo_edit_data['volo_loan_costing'] = $dast_goo_costs;
                        $volo_edit_res = DB::table('voucher_loan')
                            ->where('volo_id', $vvv['volo_id'])
                            ->where('volo_vore_id', $find_vore_data->vore_id)
                            ->where('volo_loan_subject', '!=', 0)
                            ->update($volo_edit_data);
                        unset($volo_edit_data);
                        unset($volo_edit_res);
                    }
                }
                echo '2222==';
            }
            unset($find_vore_data);
        }
        echo "修改凭证成功";
        exit;
    }

    // 修改销售统计表成本和订单商品表的成本 【21.07.02】
    public function editDataStatistical()
    {
        ignore_user_abort();
        set_time_limit(0);

        // 查询销售统计表
        $find_dast_data = DB::table('data_statistical_test')
            ->where('dast_goo_costs', 0)
            ->get()->toArray();
        foreach ($find_dast_data as $key => $value) {
            // 查询销售统计的数据
            $find_vore_data = DB::table('data_statistical')
                ->where('dast_cid', 1)
                ->where('dast_shop_id', 1)
                ->where('dast_ord_id', $value->dast_ord_id)
                ->where('dast_order_number', $value->dast_order_number)
                ->where('dast_order_type', 1)
                ->where('dast_ord_form_type', 1)
                ->select('dast_id', 'dast_ord_id', 'dast_order_number', 'dast_ware_id', 'dast_waon_class', 'dast_goo_id', 'dast_orgo_id')
                ->first();
            if ($find_vore_data) {
                // 查询进销存成本
                $ense_end_price = DB::table('enters_sells_saves')
                    ->where('ense_goo_id', $find_vore_data->dast_goo_id)
                    ->where('ense_goo_warehouse', $find_vore_data->dast_ware_id)
                    ->where('ense_goo_waretype', $find_vore_data->dast_waon_class)
                    ->where('ense_order_number', $find_vore_data->dast_order_number)
                    ->value('ense_end_price');
                if ($ense_end_price) {
                    $ense_end_price = $ense_end_price * 100;
                } else {
                    $ense_end_price = 0;
                }
                // 修改销售统计成本
                $edit_dast_data['dast_goo_cost'] = $ense_end_price;
                $edit_dast_res = DB::table('data_statistical')
                    ->where('dast_id', $find_vore_data->dast_id)
                    ->update($edit_dast_data);
                // 修改订单商品成本
                $edit_orgo_data['orgo_goo_cost'] = $ense_end_price;
                $edit_orgo_res = DB::table('order_goods')
                    ->where('orgo_id', $find_vore_data->dast_orgo_id)
                    ->update($edit_orgo_data);
                unset($edit_dast_data);
                unset($edit_dast_res);
                unset($edit_orgo_data);
                unset($edit_orgo_res);
            }
            unset($find_vore_data);
        }
        echo "string";
        exit;
    }

    // 统计凭证列表成本和销售统计成本不一致的 【21.07.02】
    public function dataStatistics(Request $request)
    {
        ignore_user_abort();
        set_time_limit(0);

        $search_data = $request->all();

        // 查询销售统计表
        $find_dast_data = DB::table('data_statistical as dast')
            ->leftjoin('voucher_receipts as vore', 'vore.vore_ord_id', '=', 'dast_ord_id')
            ->where('dast_cid', 1)
            ->where('dast_shop_id', 1)
            ->whereIn('dast_order_type', [1, 2])
            ->where('dast_goo_id', '!=', 0)
            ->where('dast_ord_delete', 1)
            ->where('dast_ord_form_type', 1)
            ->where('vore_state', 1)
            ->where('vore_service_type', '!=', 3)
            ->where('dast_service_type', '!=', 4)
            // ->where('dast_waon_class', '=', 1)
            ->where(function ($query) use ($search_data) {
                //如果选择开始时间并且选择结束时间
                if (!empty($search_data['create_time_start']) && !empty($search_data['create_time_end'])) {
                    $query->whereBetween('dast_create_time', [$search_data['create_time_start'], $search_data['create_time_end'] . ' 23:59:59']);
                } else {
                    // 如果选择开始时间
                    if (!empty($search_data['create_time_start'])) {
                        $query->where('dast_create_time', '>=', $search_data['create_time_start']);
                    } else {
                        // 如果选择结束时间
                        if (!empty($search_data['create_time_end'])) {
                            $query->where('dast_create_time', '<=', $search_data['create_time_end'] . ' 23:59:59');
                        }
                    }
                }
            }) //创建时间
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['dast_order_number'])) {
                    $query->where('dast_order_number', 'like', '%' . $search_data['dast_order_number'] . '%');
                }
            }) //单号
            // ->where('dast_order_number', 'D2021031011133700040')
            ->select('dast_id', 'dast_ord_id', 'dast_order_number', 'dast_goo_quantity', 'dast_goo_cost', 'dast_goo_id', 'dast_orgo_id')
            ->get()->toArray();
        $dast_subtract = [];
        foreach ($find_dast_data as $kk => $vv) {
            if (!isset($dast_subtract[$vv->dast_ord_id])) {
                $dast_subtract[$vv->dast_ord_id] = 0;
            }
            $dast_subtract[$vv->dast_ord_id] += ($vv->dast_goo_quantity * $vv->dast_goo_cost); //商品数量
        }
        unset($find_dast_data);
        foreach ($dast_subtract as $key => $value) {
            // 查询凭证列表的数据
            $find_vore_data = DB::table('voucher_receipts')
                ->where('vore_cid', 1)
                ->where('vore_shop_id', 1)
                ->where('vore_superior_shop_id', 1)
                ->where('vore_ord_id', $key)
                ->where('vore_state', 1)
                ->where('vore_service_type', '!=', 3)
                ->select('vore_id', 'vore_ord_id', 'vore_ord_number', 'vore_early_costing', 'vore_create_time')
                ->first();
            if ($find_vore_data) {
                // 销售统计总成本
                $dast_goo_cost = abs($value) / 100;
                // 凭证列表总成本
                $find_volo_data = DB::table('voucher_loan')
                    ->where('volo_vore_id', $find_vore_data->vore_id)
                    ->get()->toArray();
                $find_volo_data = json_decode(json_encode($find_volo_data), true);
                $total_cost = abs($find_vore_data->vore_early_costing);
                if (abs($dast_goo_cost) != abs($find_volo_data[0]['volo_borrow_costing'])) {
                    // 根据商品id,查询对应的检索编码
                    $find_dats = DB::table("data_statistical as a")
                        ->leftJoin('goods as b', 'b.goo_id', '=', 'a.dast_actual_goo_id')
                        ->where('dast_ord_id', $key)
                        ->whereIn('dast_order_type', [1, 2])
                        ->where('dast_service_type', '!=', 4)
                        // ->where('dast_waon_class', '=', 1)
                        ->select('goo_goods_encode', 'goo_id', 'dast_goo_cost', 'goo_name', 'dast_create_time')
                        ->get()->toArray();
                    foreach ($find_dats as $kkk => $vvv) {
                        // 根据订单id,查询对应的商品id
                        $add_data['dast_cid'] = 1; //所属企业id
                        $add_data['dast_superior_shop_id'] = 1; //所属总店id
                        $add_data['dast_shop_id'] = 1; //所属门店id
                        $add_data['dast_ord_id'] = $find_vore_data->vore_ord_id; //订单id
                        $add_data['dast_order_number'] = $find_vore_data->vore_ord_number; //订单单号
                        $add_data['dast_service_type'] = 1;
                        $add_data['dast_goo_id'] = $vvv->goo_id; //商品id
                        $add_data['dast_goo_name'] = $vvv->goo_name; //商品名称
                        $add_data['dast_goo_encode'] = $vvv->goo_goods_encode; //检索编码
                        $add_data['dast_goo_cost'] = $vvv->dast_goo_cost / 100; //销售统计单个商品成本
                        $add_data['dast_goo_costs'] = $dast_goo_cost; //销售统计总成本
                        $add_data['dast_vour_costs'] = $total_cost; //凭证列表的成本
                        $add_data['dast_diff_cost'] = $dast_goo_cost - $total_cost; //凭证列表的成本
                        $add_data['dast_add_time'] = $vvv->dast_create_time; //开单时间
                        $dast_id = DB::table('data_statistical_test')->insert($add_data);
                        unset($add_data);
                        unset($dast_id);
                    }
                    unset($find_dats);
                }
            }
            unset($find_vore_data);
        }
        echo "string";
        exit;
    }

    // 查询订单金额 < 0 的数据
    public function selectOrderPrice()
    {
        ignore_user_abort();
        set_time_limit(0);

        $find_data = DB::table('order')
            ->where('ord_shop_id', 1)
            ->where('ord_collection_bill', 1)
            ->where('ord_delete', 1)
            ->whereIn('ord_service_type', [1, 5, 7])
            ->where('ord_actual_price', '<', 0)
            ->where('ord_create_time', '>', '2021-04-01')
            ->select('ord_id', 'ord_shop_id', 'ord_order_number', 'ord_type')
            ->get()->toArray();
        dump($find_data);
        exit;
    }

    // 应收应付类型问题数据
    public function diffReceivableType()
    {
        ignore_user_abort();
        set_time_limit(0);

        $find_data = DB::table('order')
            ->where('ord_shop_id', 1)
            ->where('ord_collection_bill', 1)
            ->where('ord_delete', 1)
            ->where('ord_type', 1)
            ->where('ord_create_time', '>', '2021-01-01')
            ->select('ord_id', 'ord_shop_id', 'ord_order_number', 'ord_type')
            ->get()->toArray();
        $diff_recr_data = []; // 查询应收应付数据
        foreach ($find_data as $key => $value) {
            // 查询应收应付数据
            $find_recr_data = DB::table('receivable_credit')
                ->where('recr_shop_id', $value->ord_shop_id)
                ->where('recr_original_id', $value->ord_id)
                ->where('recr_original_number', $value->ord_order_number)
                ->where('recr_client_type', '!=', 1)
                ->select('recr_client_type', 'recr_original_number', 'recr_id')
                ->first();
            if ($find_recr_data) {
                $temp_data['recr_id'] = $find_recr_data->recr_id;
                $temp_data['recr_original_number'] = $find_recr_data->recr_original_number;
                $temp_data['recr_client_type'] = $find_recr_data->recr_client_type;
                $diff_recr_data[] = $temp_data;
                unset($temp_data);
            }
        }
        dump($diff_recr_data);
    }

    // 查询有回收商品的订单商品,新增临时表
    public function returnGoods()
    {
        ignore_user_abort();
        set_time_limit(0);

        $find_order_data = DB::table('order as ord')
            ->leftjoin('order_goods as orgo', 'orgo.orgo_ord_id', '=', 'ord.ord_id')
            ->where('ord_cid', 1)
            ->where('ord_shop_id', 1)
            ->where('ord_delete', 1)
            ->where('orgo_state', 3)
            ->where('ord_state', 1)
            ->where('ord_collection_bill', 1)
            ->whereNotIn('ord_service_type', [3, 4])
            // ->where('ord_create_time', 'like', '%'.$this->date.'%')
            ->select('ord_id', 'ord_shop_id', 'ord_order_number', 'ord_type', 'ord_service_type', 'ord_ware_id', 'ord_state', 'ord_order_plus_minus', 'ord_order_price', 'ord_plus_minus', 'ord_actual_price', 'ord_zero_price', 'ord_wor_state', 'ord_wor_quantity', 'ord_delete', 'ord_create_time', 'ord_orbi_id', 'ord_collection_price', 'orgo_goo_price')
            ->orderBy('ord_id', 'desc')
            ->get()->toArray();
        // dump($find_order_data);die;
        $new_order = [];
        foreach ($find_order_data as $key => $value) {
            if ($value->ord_order_price == $value->ord_actual_price && $value->orgo_goo_price > '0' && $value->ord_order_price > '0' && $value->ord_actual_price > '0') {
                $find_goods = DB::table('order_goods')
                    ->where('orgo_ord_id', $value->ord_id)
                    ->where('orgo_state', '<>', 2)
                    ->get()->toArray();
                $orgo_sum_recycle_price = 0;
                $orgo_sum_goo_price = 0;
                $orgo_sum_goo_quantity = 0;
                $orgo_sum_collection_price = 0; //代收总金额
                // 查询订单商品数据
                foreach ($find_goods as $orgo_key => $orgo_value) {
                    $orgo_sum_collection_price += $orgo_value->orgo_collection_price;
                    $orgo_sum_goo_quantity += $orgo_value->orgo_goo_quantity;

                    if ($orgo_value->orgo_state == 1) {
                        $orgo_sum_goo_price += $orgo_value->orgo_goo_price * $orgo_value->orgo_goo_quantity;
                    } elseif ($orgo_value->orgo_state == 3) {
                        $orgo_sum_recycle_price += $orgo_value->orgo_goo_price * $orgo_value->orgo_goo_quantity;
                    } else {
                        continue;
                    }
                }
                // 查询订单客户数据
                $find_order_client = DB::table('order_client')
                    ->where('orcl_ord_id', $value->ord_id)
                    ->select('orcl_rescue_service_price', 'orcl_rescue_collection_price')
                    ->first();
                $orgo_sum_collection_price = $find_order_client->orcl_rescue_collection_price + $orgo_sum_collection_price;

                $add_data['ord_id'] = $value->ord_id;
                $add_data['ord_shop_id'] = $value->ord_shop_id;
                $add_data['ord_order_number'] = $value->ord_order_number;
                $add_data['ord_type'] = $value->ord_type;
                $add_data['ord_service_type'] = $value->ord_service_type;
                $add_data['ord_ware_id'] = $value->ord_ware_id;
                $add_data['ord_state'] = $value->ord_state;
                $add_data['ord_order_plus_minus'] = $value->ord_order_plus_minus;
                $add_data['ord_order_price'] = $value->ord_order_price / 100;
                $add_data['ord_plus_minus'] = $value->ord_plus_minus;
                if ($orgo_sum_goo_price + $find_order_client->orcl_rescue_service_price == $value->ord_order_price + $orgo_sum_recycle_price) {
                    $ord_new_order_price = $orgo_sum_goo_price + $find_order_client->orcl_rescue_service_price;
                    $add_data['ord_new_order_price'] = $ord_new_order_price / 100;
                } else {
                    $add_data['ord_new_order_price'] = 0;
                }

                $add_data['ord_actual_price'] = $value->ord_actual_price / 100;
                $add_data['orgo_sum_recycle_price'] = $orgo_sum_recycle_price / 100;
                $add_data['ord_zero_price'] = $value->ord_zero_price / 100;
                $add_data['ord_wor_state'] = $value->ord_wor_state;
                $add_data['ord_wor_quantity'] = $value->ord_wor_quantity;
                $add_data['ord_delete'] = $value->ord_delete;
                $add_data['ord_create_time'] = $value->ord_create_time;
                $add_data['ord_orbi_id'] = $value->ord_orbi_id;
                $add_data['ord_collection_price'] = $value->ord_collection_price / 100;
                $add_data['orcl_rescue_collection_price'] = $find_order_client->orcl_rescue_collection_price / 100;
                $add_data['orcl_rescue_service_price'] = $find_order_client->orcl_rescue_service_price / 100;
                $add_data['orgo_sum_collection_price'] = $orgo_sum_collection_price / 100;
                $add_data['orgo_sum_goo_quantity'] = $orgo_sum_goo_quantity;
                $add_data['orgo_goo_price'] = $value->orgo_goo_price / 100;
                $add_data['orgo_sum_goo_price'] = $orgo_sum_goo_price / 100;
                // dump($add_data);die;
                $res = DB::table('order_dispose_temporary')->insert($add_data);
                unset($add_data);
                unset($ord_new_order_price);
                dump($res);
            }
        }
        echo 88;
        die;
        dump($new_order);
        die;
    }

    // 调整订单金额
    public function orderPrice()
    {
        ignore_user_abort();
        set_time_limit(0);

        $find_data = DB::table('order_dispose_temporary')
            ->where('ord_shop_id', 1)
            ->select('ord_id', 'ord_shop_id', 'ord_order_number', 'ord_order_plus_minus', 'ord_order_price', 'ord_new_order_price', 'ord_plus_minus')
            ->get()->toArray();
        foreach ($find_data as $key => $value) {
            // dump($value);
            if ($value->ord_new_order_price != '0') {
                $ord_data['ord_order_price'] = $value->ord_new_order_price * 100;
                $ord_data['ord_order_plus_minus'] = $value->ord_order_plus_minus;
                $ord_res = DB::table('order')
                    ->where('ord_id', $value->ord_id)
                    ->where('ord_shop_id', $value->ord_shop_id)
                    ->where('ord_order_number', $value->ord_order_number)
                    ->update($ord_data);
                dump($ord_res);
                unset($ord_data);
                unset($ord_res);
            } else {
                $find_order_goods = DB::table('order_goods')
                    ->where('orgo_ord_id', $value->ord_id)
                    ->where('orgo_order_number', $value->ord_order_number)
                    ->whereIn('orgo_state', [1, 6])
                    ->select('orgo_order_number', 'orgo_goo_id', 'orgo_goo_name', 'orgo_goo_goods_encode', 'orgo_goo_price', 'orgo_goo_quantity')
                    ->get()->toArray();
                $amount = 0;
                foreach ($find_order_goods as $kk => $vv) {
                    dump($vv);
                    $amount += $vv->orgo_goo_price * $vv->orgo_goo_quantity;
                }
                $ord_data['ord_order_price'] = $amount;
                $ord_data['ord_order_plus_minus'] = 1;
                $ord_res = DB::table('order')
                    ->where('ord_id', $value->ord_id)
                    ->where('ord_shop_id', $value->ord_shop_id)
                    ->where('ord_order_number', $value->ord_order_number)
                    ->update($ord_data);
                dump($ord_res);
                unset($ord_data);
                unset($ord_res);
            }
        }
    }

    
    // 待检测的库存转良品
    public function editWarehouseGoods(Request $request)
    {
        $dates = $this->now_time;

        // 获取当前操作账号信息
        try {
            $api_token = Crypt::decrypt($request['api_token']);
        } catch (\Exception $e) {
            return response()->json(['code'=>300, 'msg'=>'error', 'data'=>'非法api_token']);
        }
        $user_info = Common::getUserInfo($api_token);

        // 查询仓库库存数量
        $find_wago_data = DB::table('warehouse_goods')
            ->where('wago_ware_id', $request['ware_id'])
            ->where('wago_class', $request['waon_class'])
            ->where(function ($query) use ($user_info) {
                $query->Where('wago_unchecked_stock_number', '>', 0);
            })
            ->select('wago_id', 'wago_ware_id', 'wago_class', 'wago_goo_id', 'wago_stock_number', 'wago_lock_quantity', 'wago_priority_stock_number', 'wago_priority_lock_quantity', 'wago_unchecked_stock_number')
            ->get()->toArray();
        // dump($find_wago_data);
        // exit;
        foreach ($find_wago_data as $key => $value) {
            // 良品库存数量增加
            $edit_res = DB::table('warehouse_goods')
                ->where('wago_id', $value->wago_id)
                ->increment('wago_priority_stock_number', $value->wago_unchecked_stock_number);
            $edit_res = DB::table('warehouse_goods')
                ->where('wago_id', $value->wago_id)
                ->increment('wago_priority_stock_amount', $value->wago_unchecked_stock_number);
            // 待检测库存数量减少
            $edit_update_res = DB::table('warehouse_goods')
                ->where('wago_id', $value->wago_id)
                ->decrement('wago_unchecked_stock_number', $value->wago_unchecked_stock_number);
            unset($edit_res);
            unset($edit_update_res);
        }

        echo 333;
    }

    // 查询订单商品全部退回，销售统计商品还在的数据
    public function selectOrders(Request $request)
    {
        ignore_user_abort();
        set_time_limit(0);

        $search_data = $request->all();

        $adm_cid = 1;
        $shop_id = 1;

        // 查询订单商品表的数据
        $find_orgo_data = DB::table('order_goods as orgo')
            ->leftjoin('order as ord', 'ord.ord_id', 'orgo.orgo_ord_id')
            ->where('ord_cid', $adm_cid)
            ->where('ord_shop_id', $shop_id)
            ->where('ord_superior_shop_id', $shop_id)
            ->where('ord_collection_bill', 1)
            ->where('orgo_state', 2)
            ->where(function ($query) use ($search_data) {
                //如果选择开始时间并且选择结束时间
                if (!empty($search_data['create_time_start']) && !empty($search_data['create_time_end'])) {
                    $query->whereBetween('ord_create_time', [$search_data['create_time_start'], $search_data['create_time_end'] . ' 23:59:59']);
                } else {
                    // 如果选择开始时间
                    if (!empty($search_data['create_time_start'])) {
                        $query->where('ord_create_time', '>=', $search_data['create_time_start']);
                    } else {
                        // 如果选择结束时间
                        if (!empty($search_data['create_time_end'])) {
                            $query->where('ord_create_time', '<=', $search_data['create_time_end'] . ' 23:59:59');
                        }
                    }
                }
            }) //创建时间
            ->select('ord_id', 'orgo_id', 'ord_order_number')
            ->get()->toArray();
        $find_orgo_data = json_decode(json_encode($find_orgo_data), true);
        foreach ($find_orgo_data as $key => $value) {
            // 查询销售统计的数据
            $find_dast_data = DB::table('data_statistical')
                ->where('dast_ord_id', $value['ord_id'])
                ->where('dast_order_number', $value['ord_order_number'])
                ->where('dast_orgo_id', $value['orgo_id'])
                // ->where('dast_order_type', '!=', 3)
                ->select('dast_orgo_id', 'dast_ord_id')
                ->first();
            if ($find_dast_data) {
                dump($value['ord_order_number']);
            } else {
            }
        }
        echo 'stringssss';
    }

    // 新增盘库单，原来的仓库盘少
    public function addOldStocks(Request $request)
    {
        $dates = $this->now_time;

        // 获取当前操作账号信息
        try {
            $api_token = Crypt::decrypt($request['api_token']);
        } catch (\Exception $e) {
            return response()->json(['code'=>300, 'msg'=>'error', 'data'=>'非法api_token']);
        }
        $user_info = Common::getUserInfo($api_token);

        // 查询仓库库存数量
        $find_wago_data = DB::table('warehouse_goods')
            ->where('wago_ware_id', $request['ware_id'])
            ->where('wago_class', $request['waon_class'])
            ->where(function ($query) use ($user_info) {
                $query->where('wago_stock_number', '>', 0)
                    ->orWhere('wago_lock_quantity', '>', 0)
                    ->orWhere('wago_priority_stock_number', '>', 0)
                    ->orWhere('wago_priority_lock_quantity', '>', 0)
                    ->orWhere('wago_unchecked_stock_number', '>', 0);
            })
            ->select('wago_id', 'wago_ware_id', 'wago_class', 'wago_goo_id', 'wago_stock_number', 'wago_lock_quantity', 'wago_priority_stock_number', 'wago_priority_lock_quantity', 'wago_unchecked_stock_number', 'wago_refuse_fine_stock', 'wago_refuse_fine_lock', 'wago_refuse_priority_stock', 'wago_refuse_priority_lock')
            ->get()->toArray();
        if (!empty($find_wago_data)) {
            $stocktake_number = 0; //良品盘点数量
            $priority_stocktake_number = 0; //优先盘点数量
            $unchecked_stocktake_number = 0; //待检测盘点数量
            foreach ($find_wago_data as $key => $value) {
                // 新增盘库商品表
                $stgo_data[$key]['stgo_goo_id'] = $value->wago_goo_id; //商品id
                $stgo_data[$key]['stgo_stock_number'] = $value->wago_stock_number;
                $stgo_data[$key]['stgo_lock_number'] = $value->wago_lock_quantity;
                $stgo_data[$key]['stgo_priority_stock_number'] = $value->wago_priority_stock_number;
                $stgo_data[$key]['stgo_priority_lock_number'] = $value->wago_priority_lock_quantity;
                $stgo_data[$key]['stgo_unchecked_stock_number'] = $value->wago_unchecked_stock_number;
                $stgo_data[$key]['stgo_stocktake_number'] = '-' . $value->wago_stock_number; //良品库存数量
                $stgo_data[$key]['stgo_priority_stocktake_number'] = '-' . $value->wago_priority_stock_number; //良品库存数量
                $stgo_data[$key]['stgo_unchecked_stocktake_number'] = '-' . $value->wago_unchecked_stock_number; //良品库存数量
                $stgo_data[$key]['stgo_update_time'] = $dates; //更新时间

                $stocktake_number += $value->wago_stock_number; //良品盘点数量
                $priority_stocktake_number += $value->wago_priority_stock_number; //优先盘点数量
                $unchecked_stocktake_number += $value->wago_unchecked_stock_number; //待检测盘点数量
            }

            $stoc_differ_number = $stocktake_number + $priority_stocktake_number + $unchecked_stocktake_number; //损益数量

            // 新增盘库单数据
            $stoc_data['stoc_cid'] = $user_info->adm_cid;
            $stoc_data['stoc_shop_id'] = $user_info->adm_shop_id;
            $stoc_data['stoc_superior_shop_id'] = $user_info->adm_shop_id;
            $stoc_data['stoc_adm_id'] = $user_info->adm_id;
            $stoc_data['stoc_storage_number'] = 'P' . truncateFill($user_info->adm_shop_id, 2) . date('mdHis') . truncateFill($user_info->adm_id, 2) . rand(10000, 99999); //盘库单号
            $stoc_data['stoc_type'] = 2; //类型：1盘盈2盘亏3盘平
            $stoc_data['stoc_differ_number'] = $stoc_differ_number; //损益数量
            $stoc_data['stoc_state'] = 2; //状态1保存/待提交2提交/待审核3通过4驳回
            $stoc_data['stoc_ware_id'] = $request['ware_id']; //仓库id
            $stoc_data['stoc_make_time'] = $dates;
            $stoc_data['stoc_waon_class'] = $request['waon_class']; //仓库类别
            $stoc_data['stoc_manner'] = 2; //盘库方式：1部分盘2通盘
            $stoc_data['stoc_create_time'] = $dates; //创建时间
            // 新增盘库单
            $stoc_res =  DB::table('stocktake')->insertGetId($stoc_data);
            foreach ($stgo_data as $key => $value) {
                $stgo_data[$key]['stgo_stoc_id'] = $stoc_res;
            }
            $stgo_res =  DB::table('stocktake_goods')->insert($stgo_data);
            unset($stgo_data);
            unset($stoc_data);
            unset($stgo_res);
            unset($stoc_res);
        }
        echo 333;
    }

    // 查询仓库商品锁定表数据跟订单商品表,判断是否有商品
    public function selectOrderGoods(Request $request)
    {
        ignore_user_abort();
        set_time_limit(0);

        $cid = 1;
        $shop_id = 1;

        $find_wagl_data = DB::table('warehouse_goods_lock')
            ->where('wagl_shop_id', $shop_id)
            ->where('wagl_type', 1)
            ->where('wagl_state', 1)
            ->select('wagl_id', 'wagl_original_id', 'wagl_original_number')
            ->get()->toArray();
        foreach ($find_wagl_data as $key => $value) {
            // 查询订单商品表数据
            $find_orgo_data = DB::table('order_goods')
                ->where('orgo_ord_id', $value->wagl_original_id)
                ->where('orgo_order_number', $value->wagl_original_number)
                ->value('orgo_order_number');
            if (empty($find_orgo_data)) {
            }
        }
    }

    // 查询盘库单当时的商品成本
    public function selectStocktake(Request $request)
    {
        ignore_user_abort();
        set_time_limit(0);

        $shop_id = 1;
        $find_ense_data = DB::table('enters_sells_saves')
            ->where('ense_shop_id', $shop_id)
            ->where('ense_type', 15)
            ->where('ense_order_number', $request['ense_order_number'])
            ->select('ense_id', 'ense_goo_id', 'ense_goo_number', 'ense_out_num', 'ense_out_price', 'ense_out_amount', 'ense_in_num', 'ense_in_price', 'ense_in_amount')
            ->get()->toArray();
        $goods_data = [];
        foreach ($find_ense_data as $key => $value) {
            if ($value->ense_out_price == 0) {
                $value->ense_out_num = $value->ense_in_num;
                $value->ense_out_price = $value->ense_in_price;
                $value->ense_out_amount = $value->ense_in_amount;
            }
            // 根据检索编码查询平均价
            $ense_new_price = DB::table('enters_goods_price')
                ->where('ense_goo_number', $value->ense_goo_number)
                ->value('ense_new_price');
            if ($ense_new_price != $value->ense_out_price) {
                $goods_data[$key]['ense_goo_number'] = $value->ense_goo_number;
                $goods_data[$key]['ense_out_price'] = $value->ense_out_price;
                $goods_data[$key]['ense_new_price'] = $ense_new_price;
                $fixed_price = $ense_new_price;
                $fixed_amount = $ense_new_price * $value->ense_out_num;
            } else {
                $fixed_price = $value->ense_out_price;
                $fixed_amount = $value->ense_out_price * $value->ense_out_num;
            }
            // 把盘库单的移动仓成本按之前技师库成本调整
            $edit_ense_res = DB::table('enters_sells_saves')
                ->where('ense_shop_id', $shop_id)
                ->where('ense_goo_number', $value->ense_goo_number)
                ->where('ense_order_number', $request['ense_order_numbers'])
                ->where('ense_type', 15)
                ->select('ense_id', 'ense_goo_id', 'ense_goo_number', 'ense_new_inventory', 'ense_new_price', 'ense_new_amount', 'ense_end_inventory', 'ense_end_price', 'ense_end_amount', 'ense_out_num', 'ense_out_price', 'ense_out_amount', 'ense_in_num', 'ense_in_price', 'ense_in_amount')
                ->first();
            $edit_ense_data['ense_end_price'] = $fixed_price; //期末平均价
            $edit_ense_data['ense_end_amount'] = $fixed_amount; //期末总额
            // $edit_ense_data['ense_in_price'] = $fixed_price;//入库单价[盘盈]
            // $edit_ense_data['ense_in_amount'] = $fixed_amount;//入库总金额[盘盈]
            $edit_ense_data['ense_out_price'] = $fixed_price; //入库单价[盘亏]
            $edit_ense_data['ense_out_amount'] = $fixed_amount; //入库总金额[盘亏]
            $edit_ense_res = DB::table('enters_sells_saves')
                ->where('ense_shop_id', $shop_id)
                // ->where('ense_goo_id', $value->ense_goo_id)
                ->where('ense_goo_number', $value->ense_goo_number)
                ->where('ense_order_number', $request['ense_order_numbers'])
                ->where('ense_type', 15)
                ->update($edit_ense_data);
            unset($edit_ense_data);
            unset($edit_ense_res);
        }
        dump($goods_data);
    }

    // 删除系统商品
    public function deleteGoods()
    {
        $goo_goods_encode = ['1513042', '1513043', '1513061', '1513053', '1513063', '1513007', '1513024', '1513020', '1513021', '1513001', '1513002', '1513003', '1513004', '1513012', '1513013', '1513014', '1513015', '1513051', '1513027', '1513016', '1513017', '1513029', '1513030', '1513018', '1513019', '1513005', '1513010', '1615085', '8813012', '1813031', '1011010', '1113028', '1313018', '1319063', '1319009', '1813032', '1814013', '1814027', '1814028', '1526028', '1526031', '1526032', '1617020', '1617021', '1615042', '1010013', '1010027', '1010028', '1010015', '1010014', '1010051', '1010024', '1010059', '1010042', '1010020', '1010021', '1010019', '1011052', '1011009', '1011031', '1011032', '1011061', '1012051', '1010018', '1010029', '1010030', '1012012', '1012030', '1012016', '1012017', '1010031', '1010032', '1015086', '1010052', '1010006', '1010008', '1012018', '1012019', '1012007', '1913064', '1913011', '1913047', '1913042', '1913006', '1913031', '1913032', '1913034', '1913030', '1913029', '1916091', '1916093', '1916089', '1915078', '1915080', '1915081', '1813064', '1813011', '1813033', '1813020', '1813021', '1813035', '1813047', '1813045', '1815086', '1813034', '1813029', '1813030', '1816090', '1816091', '1816092', '1816093', '1813010', '1813018', '1813019', '1816089', '1113011', '1113033', '1113047', '1113031', '1113032', '1115081', '1613063', '1613064', '1613007', '1613011', '1613033', '1613020', '1613021', '1613001', '1613002', '1613035', '1613004', '1613047', '1613042', '1613024', '1613012', '1613013', '1613061', '1613053', '1613031', '1613032', '1613027', '1613034', '1613016', '1613017', '1613029', '1613030', '1613005', '1613010', '8813064', '8813042', '8813013', '8813006', '8813031', '8813032', '8815086', '8815081', '6613014', '6613015', '6613053', '6613008', '6615005'];
        $new_goo_data = array_unique($goo_goods_encode);
        $find_data = DB::table('goods')
            ->where('goo_cid', 0)
            ->where('goo_shop_id', 0)
            ->whereIn('goo_goods_encode', $goo_goods_encode)
            ->delete();
        // ->get()->toArray();
        dump($find_data);
        die;
    }

    // 查询仓库商品有重复商品id的数据
    public function repetitionWarehouseGoods()
    {
        $find_ware_data = DB::table('warehouse')
            // ->whereIn('ware_shop_id', [1,26])
            // ->where('ware_type', 1)
            ->select('ware_id', 'ware_name')
            ->get()->toArray();
        $wago_goo_data = [];
        $repetition_data = [];
        foreach ($find_ware_data as $key => $value) {
            $find_wago_data = DB::table('warehouse_goods')
                ->where('wago_ware_id', $value->ware_id)
                ->where('wago_class', 1)
                ->select('wago_id', 'wago_ware_id', 'wago_class', 'wago_goo_id')
                ->get()->toArray();
            foreach ($find_wago_data as $wago_key => $wago_value) {
                if (isset($wago_goo_data[$wago_value->wago_goo_id])) {
                    $wago_goo_data[$wago_value->wago_goo_id]++;
                    $temp_data['wago_class'] = 1;
                    $temp_data['wago_goo_id'] = $wago_value->wago_goo_id;
                    $temp_data['wago_goo_count'] = $wago_goo_data[$wago_value->wago_goo_id];
                    $temp_data['ware_id'] = $value->ware_id;
                    $temp_data['ware_name'] = $value->ware_name;
                    $repetition_data[] = $temp_data;
                    unset($temp_data);
                } else {
                    $wago_goo_data[$wago_value->wago_goo_id] = 1;
                }
            }
            unset($wago_goo_data);

            $find_wago_data = DB::table('warehouse_goods')
                ->where('wago_ware_id', $value->ware_id)
                ->where('wago_class', 3)
                ->select('wago_id', 'wago_ware_id', 'wago_class', 'wago_goo_id')
                ->get()->toArray();
            foreach ($find_wago_data as $wago_key => $wago_value) {
                if (isset($wago_goo_data[$wago_value->wago_goo_id])) {
                    $wago_goo_data[$wago_value->wago_goo_id]++;
                    $temp_data['wago_class'] = 3;
                    $temp_data['wago_goo_id'] = $wago_value->wago_goo_id;
                    $temp_data['wago_goo_count'] = $wago_goo_data[$wago_value->wago_goo_id];
                    $temp_data['ware_id'] = $value->ware_id;
                    $temp_data['ware_name'] = $value->ware_name;
                    $repetition_data[] = $temp_data;
                    unset($temp_data);
                } else {
                    $wago_goo_data[$wago_value->wago_goo_id] = 1;
                }
            }
            unset($wago_goo_data);
        }
        dump($repetition_data);
        die;
    }

    // 替换新编码
    public function replaceGoods(Request $request)
    {
        ignore_user_abort();
        set_time_limit(0);

        $cid = 1;
        $shop_id = 1;

        // 根据检索编码查询对应的商品id
        $find_adgt_data = DB::table('adjust_goods_test')
            ->select('goo_system_goo_id', 'goo_goods_encode', 'goo_new_goods_encode', 'goo_id', 'goo_goods_id', 'goo_new_goo_name')
            ->get()->toArray();
        // 调整adjust_goods_test表的goo_goods_id
        /* foreach ($find_adgt_data as $key => $value) {
            // 根据商品id查询商品表的数据
            $find_goo_data = DB::table('goods')
                ->where('goo_goods_encode', $value->goo_new_goods_encode)
                ->where('goo_type', 1)
                ->where('goo_delete', 1)
                ->select('goo_id', 'goo_name')
                ->first();
            // 更改商品id
            $edit_data['goo_goods_id'] = $find_goo_data->goo_id;
            $edit_data['goo_new_goo_name'] = $find_goo_data->goo_name;
            $edit_res = DB::table('adjust_goods_test')
                ->where('goo_id', $value->goo_id)
                ->update($edit_data);
            unset($edit_res);
            unset($edit_data);
        }
        exit; */
        if ($request['type'] == 1) { //更改订单商品表的商品id
            foreach ($find_adgt_data as $key => $value) {
                $edit_orgo_data['orgo_actual_goo_id'] = $value->goo_goods_id; //实际出库商品id
                $edit_orgo_data['orgo_goo_id'] = $value->goo_goods_id; //商品id
                $edit_orgo_data['orgo_goo_name'] = $value->goo_new_goo_name; //商品名称
                $edit_orgo_data['orgo_goo_goods_encode'] = $value->goo_new_goods_encode; //检索编码
                $edit_orgo_res = DB::table('order_goods as orgo')
                    ->leftjoin('order as ord', 'ord.ord_id', '=', 'orgo.orgo_ord_id')
                    ->where('ord_cid', $cid)
                    ->where('ord_shop_id', $shop_id)
                    ->where('orgo_goo_id', $value->goo_system_goo_id)
                    ->update($edit_orgo_data);
                unset($edit_orgo_data);
                unset($edit_orgo_res);
            }
        } elseif ($request['type'] == 2) { //更改工单商品表的商品id
            foreach ($find_adgt_data as $key => $value) {
                $edit_wogo_data['wogo_actual_goo_id'] = $value->goo_goods_id; //实际出库商品id
                $edit_wogo_data['wogo_goo_id'] = $value->goo_goods_id; //商品id
                $edit_wogo_data['wogo_goo_name'] = $value->goo_new_goo_name; //商品名称
                $edit_wogo_data['wogo_goo_goods_encode'] = $value->goo_new_goods_encode; //检索编码
                $edit_wogo_res = DB::table('work_good as wogo')
                    ->leftjoin('work_order as wor', 'wor.wor_id', '=', 'wogo.wogo_wor_id')
                    ->where('wor_cid', $cid)
                    ->where('wor_shop_id', $shop_id)
                    ->where('wogo_goo_id', $value->goo_system_goo_id)
                    ->update($edit_wogo_data);
                unset($edit_wogo_data);
                unset($edit_wogo_res);
            }
        } elseif ($request['type'] == 3) { //更改采购管理商品表的商品id
            foreach ($find_adgt_data as $key => $value) {
                $edit_stgo_data['goods_id'] = $value->goo_goods_id; //商品id
                $edit_stgo_data['goods_number'] = $value->goo_new_goods_encode; //检索编码
                $edit_stgo_data['goods_name'] = $value->goo_new_goo_name; //商品名称
                $edit_stgo_res = DB::table('storage_goods')
                    ->where('company_id', $cid)
                    ->where('stgo_shop_id', $shop_id)
                    ->where('goods_id', $value->goo_system_goo_id)
                    ->update($edit_stgo_data);
                unset($edit_stgo_data);
                unset($edit_stgo_res);
            }
        } elseif ($request['type'] == 4) { //更改仓库商品表的商品id
            foreach ($find_adgt_data as $key => $value) {
                $edit_wago_data['wago_goo_id'] = $value->goo_goods_id; //商品id
                $edit_orgo_res = DB::table('warehouse_goods as wago')
                    ->leftjoin('warehouse as ware', 'ware.ware_id', '=', 'wago.wago_ware_id')
                    ->where('ware_cid', $cid)
                    ->where('ware_shop_id', $shop_id)
                    ->where('wago_goo_id', $value->goo_system_goo_id)
                    ->update($edit_wago_data);
                unset($edit_wago_data);
                unset($edit_orgo_res);
            }
        } elseif ($request['type'] == 5) { //更改发货商品表的商品id
            foreach ($find_adgt_data as $key => $value) {
                $edit_digo_data['digo_goo_id'] = $value->goo_goods_id; //商品id
                $edit_digo_data['digo_goo_name'] = $value->goo_new_goo_name; //商品名称
                $edit_digo_data['digo_goo_goods_encode'] = $value->goo_new_goods_encode; //检索编码
                $edit_digo_res = DB::table('dispatch_goods as digo')
                    ->leftjoin('dispatch_bill as dibi', 'dibi.dego_id', '=', 'digo.digo_dego_id')
                    ->where('dego_cid', $cid)
                    ->where('dego_shop_id', $shop_id)
                    ->where('digo_goo_id', $value->goo_system_goo_id)
                    ->update($edit_digo_data);
                unset($edit_digo_data);
                unset($edit_digo_res);
            }
        } elseif ($request['type'] == 6) { //更改调拨单商品表的商品id
            foreach ($find_adgt_data as $key => $value) {
                $edit_trog_data['trog_goo_id'] = $value->goo_goods_id; //商品id
                $edit_trog_res = DB::table('transferring_order_goods as trog')
                    ->leftjoin('transferring_order as tror', 'tror.tror_id', '=', 'trog.trog_tror_id')
                    ->where('tror_cid', $cid)
                    ->where('tror_shop_id', $shop_id)
                    ->where('trog_goo_id', $value->goo_system_goo_id)
                    ->update($edit_trog_data);
                unset($edit_trog_data);
                unset($edit_trog_res);
            }
        } elseif ($request['type'] == 7) { //更改盘库单商品表的商品id
            foreach ($find_adgt_data as $key => $value) {
                $edit_stgo_data['stgo_goo_id'] = $value->goo_goods_id; //商品id
                $edit_stgo_res = DB::table('stocktake_goods as stgo')
                    ->leftjoin('stocktake as stoc', 'stoc.stoc_id', '=', 'stgo.stgo_stoc_id')
                    ->where('stoc_cid', $cid)
                    ->where('stoc_shop_id', $shop_id)
                    ->where('stgo_goo_id', $value->goo_system_goo_id)
                    ->update($edit_stgo_data);
                unset($edit_stgo_data);
                unset($edit_stgo_res);
            }
        } elseif ($request['type'] == 8) { //更改旧货回收商品表的商品id
            foreach ($find_adgt_data as $key => $value) {
                $edit_jugo_data['jugo_goo_id'] = $value->goo_goods_id; //商品id
                $edit_jugo_data['jugo_goo_name'] = $value->goo_new_goo_name; //商品名称
                $edit_jugo_data['jugo_goo_goods_encode'] = $value->goo_new_goods_encode; //检索编码
                $edit_jugo_res = DB::table('junk_goods as jugo')
                    ->leftjoin('junk_recycle as jur', 'jur.jur_id', '=', 'jugo.jugo_jur_id')
                    ->where('jur_cid', $cid)
                    ->where('jur_shop_id', $shop_id)
                    ->where('jugo_goo_id', $value->goo_system_goo_id)
                    ->update($edit_jugo_data);
                unset($edit_jugo_data);
                unset($edit_jugo_res);
            }
        } elseif ($request['type'] == 9) { //更改退货入库商品表的商品id
            foreach ($find_adgt_data as $key => $value) {
                $edit_rego_data['rego_goo_id'] = $value->goo_goods_id; //商品id
                $edit_rego_data['rego_goo_name'] = $value->goo_new_goo_name; //商品名称
                $edit_rego_data['rego_goo_goods_encode'] = $value->goo_new_goods_encode; //检索编码
                $edit_rego_res = DB::table('recede_goods as rego')
                    ->leftjoin('recede_recycle as rec', 'rec.rec_id', '=', 'rego.rego_rec_id')
                    ->where('rec_cid', $cid)
                    ->where('rec_shop_id', $shop_id)
                    ->where('rego_goo_id', $value->goo_system_goo_id)
                    ->update($edit_rego_data);
                unset($edit_rego_data);
                unset($edit_rego_res);
            }
        } elseif ($request['type'] == 10) { //更改商品流水记录商品表的商品id
            foreach ($find_adgt_data as $key => $value) {
                $edit_oude_data['oude_goo_id'] = $value->goo_goods_id; //商品id
                $edit_oude_res = DB::table('outin_details as oude')
                    ->leftjoin('outin_record as oure', 'oure.oure_id', '=', 'oude.oude_oure_id')
                    ->where('oure_cid', $cid)
                    ->where('oure_shop_id', $shop_id)
                    ->where('oude_goo_id', $value->goo_system_goo_id)
                    ->update($edit_oude_data);
                unset($edit_oude_data);
                unset($edit_oude_res);
            }
        } elseif ($request['type'] == 11) { //更改销售统计商品表的商品id
            foreach ($find_adgt_data as $key => $value) {
                $edit_dast_data['dast_actual_goo_id'] = $value->goo_goods_id; //实际出库商品id
                $edit_dast_data['dast_goo_id'] = $value->goo_goods_id; //商品id
                $edit_dast_res = DB::table('data_statistical')
                    ->where('dast_cid', $cid)
                    ->where('dast_shop_id', $shop_id)
                    ->where('dast_goo_id', $value->goo_system_goo_id)
                    ->update($edit_dast_data);
                unset($edit_dast_data);
                unset($edit_dast_res);
            }
        } elseif ($request['type'] == 12) { //更改进销存查询商品表的商品id
            foreach ($find_adgt_data as $key => $value) {
                $edit_ense_data['ense_goo_id'] = $value->goo_goods_id; //商品id
                $edit_ense_data['ense_goo_name'] = $value->goo_new_goo_name; //商品名称
                $edit_ense_data['ense_goo_number'] = $value->goo_new_goods_encode; //检索编码
                $edit_ense_res = DB::table('enters_sells_saves')
                    ->where('ense_shop_id', $shop_id)
                    ->where('ense_goo_id', $value->goo_system_goo_id)
                    ->update($edit_ense_data);
                unset($edit_ense_data);
                unset($edit_ense_res);
            }
        }
        echo "string";
        exit;
    }

    // 统计仓库商品表的锁定数量跟仓库总表的锁定数量对比,看数量是否一致
    public function selectWarehouse()
    {
        ignore_user_abort();
        set_time_limit(0);
        $find_ware_data = DB::table('warehouse')
            ->whereIn('ware_shop_id', [1, 26])
            ->where('ware_type', 1)
            ->select('ware_id', 'ware_name')
            ->get()->toArray();
        $ware_id = array_column($find_ware_data, 'ware_id');
        $find_ware_name = array_column($find_ware_data, 'ware_name', 'ware_id');

        $find_wago_data = DB::table('warehouse_goods')
            ->whereIn('wago_ware_id', $ware_id)
            ->whereIn('wago_class', [1, 3])
            ->select('wago_id', 'wago_ware_id', 'wago_class', 'wago_goo_id', 'wago_stock_number', 'wago_lock_quantity', 'wago_priority_stock_number', 'wago_priority_lock_quantity', 'wago_freight_lock_quantity', 'wago_freight_priority_lock_quantity')
            ->get()->toArray();
        $wago_goo_count = [];
        foreach ($find_wago_data as $key => $value) {
            if (isset($wago_goo_count[$value->wago_ware_id][$value->wago_class])) {
                $wago_goo_count[$value->wago_ware_id][$value->wago_class]['stock_lock'] += $value->wago_lock_quantity;
                $wago_goo_count[$value->wago_ware_id][$value->wago_class]['priority_lock'] += $value->wago_priority_lock_quantity;
            } else {
                $wago_goo_count[$value->wago_ware_id][$value->wago_class]['stock_lock'] = $value->wago_lock_quantity; //良品锁定
                $wago_goo_count[$value->wago_ware_id][$value->wago_class]['priority_lock'] = $value->wago_priority_lock_quantity; //优先锁定
            }
        }
        unset($find_wago_data);

        // 查询仓库类别-总库存数量表
        $find_waon_data = DB::table('warehouse_onhand')
            ->whereIn('waon_ware_id', $ware_id)
            ->whereIn('waon_class', [1, 3])
            ->select('waon_id', 'waon_ware_id', 'waon_class', 'waon_stock_fine_amount', 'waon_lock_fine_amount', 'waon_stock_priority_amount', 'waon_lock_priority_amount')
            ->get()->toArray();
        $diff_waon_data = [];
        foreach ($find_waon_data as $key => $value) {
            if ($value->waon_class == 1) {
                if (isset($wago_goo_count[$value->waon_ware_id][$value->waon_class])) {
                    if ($value->waon_lock_fine_amount == $wago_goo_count[$value->waon_ware_id][$value->waon_class]['stock_lock']) {
                        unset($find_waon_data[$key]);
                    } else {
                        $temp_data['ware_name'] = $find_ware_name[$value->waon_ware_id];
                        $temp_data['waon_ware_id'] = $value->waon_ware_id;
                        $temp_data['waon_class'] = $value->waon_class;
                        $temp_data['waon_lock_fine_amount'] = $value->waon_lock_fine_amount;
                        $temp_data['stock_lock'] = $wago_goo_count[$value->waon_ware_id][$value->waon_class]['stock_lock'];
                        $temp_data['isset_state'] = true;
                        $diff_waon_data[] = $temp_data;
                        unset($temp_data);
                    }
                } else {
                    $temp_data['ware_name'] = $find_ware_name[$value->waon_ware_id];
                    $temp_data['waon_ware_id'] = $value->waon_ware_id;
                    $temp_data['waon_class'] = $value->waon_class;
                    $temp_data['waon_lock_fine_amount'] = $value->waon_lock_fine_amount;
                    $temp_data['stock_lock'] = 0;
                    $temp_data['isset_state'] = false;
                    $diff_waon_data[] = $temp_data;
                    unset($temp_data);
                }
            } else {
                if (isset($wago_goo_count[$value->waon_ware_id][$value->waon_class])) {
                    if ($value->waon_lock_priority_amount == $wago_goo_count[$value->waon_ware_id][$value->waon_class]['priority_lock']) {
                        unset($find_waon_data[$key]);
                    } else {
                        $temp_data['ware_name'] = $find_ware_name[$value->waon_ware_id];
                        $temp_data['waon_ware_id'] = $value->waon_ware_id;
                        $temp_data['waon_class'] = $value->waon_class;
                        $temp_data['waon_lock_priority_amount'] = $value->waon_lock_priority_amount;
                        $temp_data['priority_lock'] = $wago_goo_count[$value->waon_ware_id][$value->waon_class]['priority_lock'];
                        $temp_data['isset_state'] = true;
                        $diff_waon_data[] = $temp_data;
                        unset($temp_data);
                    }
                } else {
                    $temp_data['ware_name'] = $find_ware_name[$value->waon_ware_id];
                    $temp_data['waon_ware_id'] = $value->waon_ware_id;
                    $temp_data['waon_class'] = $value->waon_class;
                    $temp_data['waon_lock_priority_amount'] = $value->waon_lock_priority_amount;
                    $temp_data['priority_lock'] = 0;
                    $temp_data['isset_state'] = false;
                    $diff_waon_data[] = $temp_data;
                    unset($temp_data);
                }
            }
        }
        dump($diff_waon_data);
        echo "string";
        exit;
    }

    // 统计系统有的表格里没有的数据在仓库商品表/商品流水记录表/进销存表是否存在
    public function selectWago(Request $request)
    {
        ignore_user_abort();
        set_time_limit(0);

        $find_adgo_data = DB::table('adjust_goods')
            ->select('goo_id', 'goo_system_goo_id', 'goo_goods_encode', 'goo_name')
            ->get()->toArray();

        if ($request['type'] == 1) { //仓库商品表
            foreach ($find_adgo_data as $key => $value) {
                // 查询仓库商品表是否有该商品id
                $find_wago_data = DB::table('warehouse_goods as wago')
                    ->leftjoin('warehouse as ware', 'ware.ware_id', '=', 'wago.wago_ware_id')
                    ->leftjoin('shop', 'shop_id', '=', 'ware.ware_shop_id')
                    ->where('wago_goo_id', $value->goo_system_goo_id)
                    ->where('shop_versions', 2)
                    ->select('wago_id', 'wago_ware_id', 'wago_class', 'ware_shop_id', 'ware_name', 'ware_cid', 'shop_store_name', 'ware_type')
                    ->get()->toArray();
                foreach ($find_wago_data as $kk => $vv) {
                    $adgd_data['goo_cid'] = $vv->ware_cid;
                    $adgd_data['goo_shop_id'] = $vv->ware_shop_id;
                    $adgd_data['goo_system_goo_id'] = $value->goo_system_goo_id;
                    $adgd_data['goo_name'] = $value->goo_name;
                    $adgd_data['goo_goods_encode'] = $value->goo_goods_encode;
                    $adgd_data['goo_wago_id'] = $vv->wago_id;
                    $adgd_data['goo_wago_class'] = $vv->wago_class;
                    $adgd_data['goo_ware_type'] = $vv->ware_type;
                    $adgd_data['goo_ware_id'] = $vv->wago_ware_id;
                    $adgd_data['goo_ware_name'] = $vv->ware_name;
                    $adgd_data['goo_shop_name'] = $vv->shop_store_name;
                    $adgd_res = DB::table('adjust_goods_detail')->insert($adgd_data);
                    unset($adgd_data);
                    unset($adgd_res);
                }
            }
        } elseif ($request['type'] == 2) { //商品流水记录表
            foreach ($find_adgo_data as $key => $value) {
                // 查询商品流水表是否有该商品id
                $find_oude_data = DB::table('outin_details as oude')
                    ->leftjoin('outin_record as oure', 'oure.oure_id', '=', 'oude.oude_oure_id')
                    ->leftjoin('shop', 'shop_id', '=', 'oure.oure_shop_id')
                    ->where('oude_goo_id', $value->goo_system_goo_id)
                    ->where('shop_versions', 2)
                    ->select('oure_id', 'oure_shop_id', 'oude_id', 'oude_goo_id', 'oure_out_ware_id', 'oure_in_ware_id', 'oure_waon_class', 'oure_cid', 'oure_out_in_type', 'shop_store_name')
                    ->get()->toArray();
                foreach ($find_oude_data as $kk => $vv) {
                    $adgo_data['goo_cid'] = $vv->oure_cid;
                    $adgo_data['goo_shop_id'] = $vv->oure_shop_id;
                    $adgo_data['goo_system_goo_id'] = $value->goo_system_goo_id;
                    $adgo_data['goo_name'] = $value->goo_name;
                    $adgo_data['goo_goods_encode'] = $value->goo_goods_encode;
                    $adgo_data['goo_wago_id'] = $vv->oude_id;
                    $adgo_data['goo_wago_class'] = $vv->oure_waon_class;
                    if ($vv->oure_out_in_type == 2) { //出入库类型：1出库，2入库
                        $find_ware_data = DB::table('warehouse')
                            ->where('ware_id', $vv->oure_in_ware_id)
                            ->select('ware_id', 'ware_name', 'ware_type')
                            ->first();
                        if ($find_ware_data) {
                            $adgo_data['goo_ware_id'] = $find_ware_data->ware_id;
                            $adgo_data['goo_ware_name'] = $find_ware_data->ware_name;
                            $adgo_data['goo_ware_type'] = $find_ware_data->ware_type;
                        }
                    } else {
                        $find_ware_datas = DB::table('warehouse')
                            ->where('ware_id', $vv->oure_out_ware_id)
                            ->select('ware_id', 'ware_name', 'ware_type')
                            ->first();
                        if ($find_ware_datas) {
                            $adgo_data['goo_ware_id'] = $find_ware_datas->ware_id;
                            $adgo_data['goo_ware_name'] = $find_ware_datas->ware_name;
                            $adgo_data['goo_ware_type'] = $find_ware_datas->ware_type;
                        }
                    }
                    $adgo_data['goo_out_in_type'] = $vv->oure_out_in_type;
                    $adgo_data['goo_shop_name'] = $vv->shop_store_name;
                    $adgo_res = DB::table('adjust_goods_outin')->insert($adgo_data);
                    unset($adgo_data);
                    unset($adgo_res);
                }
            }
        } elseif ($request['type'] == 3) { //进销存表
            foreach ($find_adgo_data as $key => $value) {
                // 查询进销存表是否有该商品id
                $find_ense_data = DB::table('enters_sells_saves as ense')
                    ->leftjoin('warehouse as ware', 'ware.ware_id', '=', 'ense.ense_goo_warehouse')
                    ->leftjoin('shop', 'shop_id', '=', 'ense.ense_shop_id')
                    ->where('ense_goo_id', $value->goo_system_goo_id)
                    ->where('shop_versions', 2)
                    ->select('ense_id', 'ense_goo_id', 'ense_goo_name', 'ense_goo_number', 'ense_goo_waretype', 'ense_goo_warehouse', 'shop_store_name', 'ense_shop_id', 'ware_type', 'ware_name')
                    ->get()->toArray();
                foreach ($find_ense_data as $kk => $vv) {
                    $adge_data['goo_shop_id'] = $vv->ense_shop_id;
                    $adge_data['goo_system_goo_id'] = $vv->ense_goo_id;
                    $adge_data['goo_name'] = $vv->ense_goo_name;
                    $adge_data['goo_goods_encode'] = $vv->ense_goo_number;
                    $adge_data['goo_ense_id'] = $vv->ense_id;
                    $adge_data['goo_wago_class'] = $vv->ense_goo_waretype;
                    $adge_data['goo_ware_type'] = $vv->ware_type;
                    $adge_data['goo_ware_id'] = $vv->ense_goo_warehouse;
                    $adge_data['goo_ware_name'] = $vv->ware_name;
                    $adge_data['goo_shop_name'] = $vv->shop_store_name;
                    $adge_res = DB::table('adjust_goods_enters')->insert($adge_data);
                    unset($adge_data);
                    unset($adge_res);
                }
            }
        }
        echo "string";
        exit;
    }

    // 根据速电业务最终确定的蓄电池编码查询,表格有,系统没有的商品数据需新增
    public function addSdGoods()
    {
        ignore_user_abort();
        set_time_limit(0);

        // 查询速电业务最终确定的蓄电池编码数据
        $find_gote_data = DB::table('goods_test')
            ->where('goo_cid', 0)
            ->where('goo_shop_id', 0)
            ->where('goo_class', 2)
            ->where('goo_delete', 1)
            ->select('goo_id', 'goo_cid', 'goo_shop_id', 'goo_bra_name', 'goo_brse_name', 'goo_name', 'goo_goods_encode')
            ->get()->toArray();
        foreach ($find_gote_data as $key => $value) {
            // 根据检索编码查询系统商品数据
            $find_goods_data = DB::table('goods')
                ->where('goo_cid', 0)
                ->where('goo_shop_id', 0)
                ->where('goo_type', 1)
                ->where('goo_class', 2)
                ->where('goo_delete', 1)
                ->where('goo_goods_encode', $value->goo_goods_encode)
                ->select('goo_id', 'goo_name', 'goo_goods_encode')
                ->first();
            if ($find_goods_data) {
            } else { //不存在则添加
                $goo_add_data['goo_cid'] = 0; //所属企业id
                $goo_add_data['goo_superior_shop_id'] = 0; //所属总店id
                $goo_add_data['goo_shop_id'] = 0; //所属门店id
                $goo_add_data['goo_bra_name'] = $value->goo_bra_name; //品牌名称
                // 查询商品品牌是否存在
                $bra_id = DB::table('brand')
                    ->where('bra_cid', 0)
                    ->where('bra_shop_id', 0)
                    ->where('bra_name', $goo_add_data['goo_bra_name'])
                    ->where('bra_delete', 1)
                    ->where('bra_state', 1)
                    ->value('bra_id');
                if (empty($bra_id)) {
                } else {
                    $brand_addnum = DB::table('brand_correlation')
                        ->where('brco_bra_id', $bra_id)
                        ->increment('brco_goods_number', 2);
                }
                $goo_add_data['goo_bra_id'] = $bra_id;
                if ($goo_add_data['goo_bra_id']) {
                    // 品牌系列
                    $brse_id = DB::table('brand_serie')
                        ->where('brse_cid', 0)
                        ->where('brse_shop_id', 0)
                        ->where('brse_bra_id', $goo_add_data['goo_bra_id'])
                        ->where('brse_name', $value->goo_brse_name)
                        ->where('brse_delete', 1)
                        ->where('brse_state', 1)
                        ->value('brse_id');
                    if (empty($brse_id)) {
                    } else {
                        $brand_serie_addnum = DB::table('brand_serie_correlation')
                            ->where('brsc_brse_id', $brse_id)
                            ->increment('brsc_goods_number', 2);
                    }
                    $goo_add_data['goo_brse_id'] = $brse_id;
                }
                $goo_add_data['goo_cate_name'] = '蓄电池'; //品类名称
                $goo_add_data['goo_cate_id'] = 1499; //所属品类id
                $category_addnum = DB::table('category_correlation')
                    ->where('caco_cate_id', $goo_add_data['goo_cate_id'])
                    ->increment('caco_goods_number', 2);
                $goo_add_data['goo_name'] = $value->goo_name; //商品名称
                $goo_add_data['goo_goods_encode'] = $value->goo_goods_encode; //检索编码
                $goo_add_data['goo_type'] = 1; //商品类型 1正常商品2赠品商品3活动商品4旧货商品
                $goo_add_data['goo_class'] = 2; //类型：1自营商品2系统商品
                $goo_id = DB::table('goods')->insertGetId($goo_add_data);
                // 添加旧货商品
                $goo_add_data['goo_type'] = 4; //商品类型 1正常商品2赠品商品3活动商品4旧货商品
                $goo_add_data['goo_fid'] = $goo_id; //商品类型的父id ( 正常商品为0)
                $junk_goo_id = DB::table('goods')->insertGetId($goo_add_data);
                unset($goo_add_data);
                unset($brand_addnum);
                unset($brand_serie_addnum);
                unset($category_addnum);
                unset($goo_id);
                unset($junk_goo_id);
            }
            unset($find_goods_data);
        }
        unset($find_gote_data);
        echo "string";
        exit;
    }

    /**
     * 根据速电业务最终确定的蓄电池编码查询,表格里没有系统有的商品数据需删除
     * 需调整相关的表：订单商品表、工单商品表、采购管理、我的仓库商品表、发货商品表、调拨单商品表、盘库单商品表、旧货回收商品表、退回入库商品表、入库列表、商品流水记录、销售统计和商品表
     *
     */
    public function selectSdGoods()
    {
        ignore_user_abort();
        set_time_limit(0);

        // 查询系统商品数据
        $find_gote_data = DB::table('goods')
            ->where('goo_cid', 0)
            ->where('goo_shop_id', 0)
            ->whereIn('goo_type', [1, 4])
            ->where('goo_class', 2)
            ->where('goo_delete', 1)
            ->select('goo_id', 'goo_cid', 'goo_shop_id', 'goo_bra_id', 'goo_brse_id', 'goo_bra_name', 'goo_cate_name', 'goo_cate_id', 'goo_name', 'goo_goods_encode', 'goo_type', 'goo_fid')
            ->get()->toArray();
        foreach ($find_gote_data as $key => $value) {
            // 根据检索编码查询速电业务最终确定的蓄电池编码数据
            $find_goods_data = DB::table('goods_test')
                ->where('goo_cid', 0)
                ->where('goo_shop_id', 0)
                ->where('goo_type', 1)
                ->where('goo_class', 2)
                ->where('goo_delete', 1)
                ->where('goo_goods_encode', $value->goo_goods_encode)
                ->select('goo_id', 'goo_name', 'goo_goods_encode')
                ->first();
            if ($find_goods_data) {
                $adgo_data['goo_cid'] = $value->goo_cid;
                $adgo_data['goo_shop_id'] = $value->goo_shop_id;
                $adgo_data['goo_system_goo_id'] = $value->goo_id;
                $adgo_data['goo_bra_id'] = $value->goo_bra_id;
                $adgo_data['goo_bra_name'] = $value->goo_bra_name;
                $adgo_data['goo_brse_id'] = $value->goo_brse_id;
                $brse_name = DB::table('brand_serie')
                    ->where('brse_id', $value->goo_brse_id)
                    ->where('brse_delete', 1)
                    ->value('brse_name');
                if ($brse_name) {
                    $adgo_data['goo_brse_name'] = $brse_name;
                } else {
                    $adgo_data['goo_brse_name'] = '';
                }
                $adgo_data['goo_cate_name'] = $value->goo_cate_name;
                $adgo_data['goo_cate_id'] = $value->goo_cate_id;
                $adgo_data['goo_name'] = $value->goo_name;
                $adgo_data['goo_goods_encode'] = $value->goo_goods_encode;
                $adgo_data['goo_type'] = $value->goo_type;
                $adgo_data['goo_types'] = 1;
                $adgo_data['goo_fid'] = $value->goo_fid;
                $adgo_res = DB::table('adjust_goods')->insert($adgo_data);
                unset($adgo_data);
                unset($adgo_res);
            } else { //不存在则删除系统里的数据
                // 要删除的系统商品数据存放到adjust_goods
                $adgo_data['goo_cid'] = $value->goo_cid;
                $adgo_data['goo_shop_id'] = $value->goo_shop_id;
                $adgo_data['goo_system_goo_id'] = $value->goo_id;
                $adgo_data['goo_bra_id'] = $value->goo_bra_id;
                $adgo_data['goo_bra_name'] = $value->goo_bra_name;
                $adgo_data['goo_brse_id'] = $value->goo_brse_id;
                $brse_name = DB::table('brand_serie')
                    ->where('brse_id', $value->goo_brse_id)
                    ->where('brse_delete', 1)
                    ->value('brse_name');
                if ($brse_name) {
                    $adgo_data['goo_brse_name'] = $brse_name;
                } else {
                    $adgo_data['goo_brse_name'] = '';
                }
                $adgo_data['goo_cate_name'] = $value->goo_cate_name;
                $adgo_data['goo_cate_id'] = $value->goo_cate_id;
                $adgo_data['goo_name'] = $value->goo_name;
                $adgo_data['goo_goods_encode'] = $value->goo_goods_encode;
                $adgo_data['goo_type'] = $value->goo_type;
                $adgo_data['goo_types'] = 2;
                $adgo_data['goo_fid'] = $value->goo_fid;
                $adgo_res = DB::table('adjust_goods')->insert($adgo_data);
                unset($adgo_data);
                unset($adgo_res);
                /* // 品类数量减少
                $dec_cate_res = DB::table('category_correlation')
                    ->where('caco_cate_id', $value->goo_cate_id)
                    ->where('caco_goods_number', '!=', 0)
                    ->decrement('caco_goods_number', 1);
                // 品牌数量减少
                $dec_brco_res = DB::table('brand_correlation')
                    ->where('brco_bra_id', $value->goo_bra_id)
                    ->where('brco_goods_number', '!=', 0)
                    ->decrement('brco_goods_number', 1);
                // 系列数量减少
                $dec_brsc_res = DB::table('brand_serie_correlation')
                    ->where('brsc_brse_id', $value->goo_brse_id)
                    ->where('brsc_goods_number', '!=', 0)
                    ->decrement('brsc_goods_number', 1); */
                // unset($goo_res);
                // unset($dec_cate_res);
                // unset($dec_brco_res);
                // unset($dec_brsc_res);
            }
            unset($find_goods_data);
        }
        unset($find_gote_data);
        echo "string";
        exit;
    }

    // 修改盘库单凭证成本
    public function StocktakeVoucher()
    {
        ignore_user_abort();
        set_time_limit(0);

        $adm_cid = 1;
        $shop_id = 1;

        $stoc_storage_number = ['P0103130719450199761'];

        // 查询盘库单状态已通过的数据
        $find_wor_data = DB::table('stocktake')
            ->where('stoc_cid', $adm_cid)
            ->where('stoc_shop_id', $shop_id)
            ->where('stoc_state', 3)
            ->where('stoc_type', '!=', 3)
            ->whereIn('stoc_storage_number', $stoc_storage_number)
            ->select('stoc_id', 'stoc_cid', 'stoc_superior_shop_id', 'stoc_shop_id', 'stoc_adm_id', 'stoc_storage_number', 'stoc_type', 'stoc_differ_number', 'stoc_ware_id', 'stoc_waon_class', 'stoc_create_time')
            ->get()->toArray();
        $cost_price = 0;
        foreach ($find_wor_data as $key => $value) {
            // 根据盘库单id,查询商品数据
            $find_stgo_data = DB::table('stocktake_goods')
                ->where('stgo_stoc_id', $value->stoc_id)
                ->select('stgo_goo_id', 'stgo_stock_number', 'stgo_stocktake_number', 'stgo_priority_stock_number', 'stgo_priority_stocktake_number', 'stgo_unchecked_stock_number', 'stgo_unchecked_stocktake_number', 'stgo_goo_id')
                ->get()->toArray();
            if ($find_stgo_data) {
                $stocktake_cost_price = 0;
                $priority_cost_price = 0;
                $unchecked_cost_price = 0;
                foreach ($find_stgo_data as $kkkk => $vvvv) {
                    // 获取当前月份的成本价
                    $find_ense_end_price = DB::table('enters_sells_saves')
                        ->where('ense_goo_id', $vvvv->stgo_goo_id)
                        ->where('ense_goo_warehouse', $value->stoc_ware_id)
                        ->where('ense_goo_waretype', $value->stoc_waon_class)
                        ->where('ense_order_number', $value->stoc_storage_number)
                        ->orderBy('ense_id', 'desc')
                        ->value('ense_end_price');
                    if ($find_ense_end_price) {
                        $find_ense_end_price = sprintf('%.2f', $find_ense_end_price);
                    } else {
                        $find_ense_end_price = 0;
                    }
                    $stocktake_cost_price += $find_ense_end_price * $vvvv->stgo_stocktake_number;
                    $priority_cost_price += $find_ense_end_price * $vvvv->stgo_priority_stocktake_number;
                    $unchecked_cost_price += $find_ense_end_price * $vvvv->stgo_unchecked_stocktake_number;
                    $cost_price = $stocktake_cost_price + $priority_cost_price + $unchecked_cost_price;
                }
                // 凭证单据报表
                // 判断凭证单据是否存在
                /*$vore_id = DB::table('voucher_receipts')
                    ->where('vore_cid', $adm_cid)
                    ->where('vore_shop_id', $shop_id)
                    ->where('vore_ord_id', $value->stoc_id)
                    ->where('vore_ord_number', $value->stoc_storage_number)
                    ->where('vore_order_type', 6)
                    ->where('vore_state', 1)
                    ->select('vore_id', 'vore_wor_id', 'vore_wor_number')
                    ->first();
                // if (empty($vore_id)) {
                    $vore_data['vore_cid'] = $value->stoc_cid; //公司id
                    $vore_data['vore_superior_shop_id'] = $value->stoc_superior_shop_id; //总店id
                    $vore_data['vore_shop_id'] = $value->stoc_shop_id; //门店id
                    $vore_data['vore_create_id'] = $value->stoc_adm_id; //创建人
                    $vore_data['vore_order_type'] = 6; //单号类型1.订单2.工单3.采购单4.销售单5.采购退货单6.盘库单
                    $vore_data['vore_wor_id'] = ''; //工单id
                    $vore_data['vore_wor_number'] = ''; //工单单号
                    $vore_data['vore_ord_id'] = $value->stoc_id; //订单id
                    $vore_data['vore_ord_number'] = $value->stoc_storage_number; //订单单号
                    $vore_data['vore_plus_minus'] = 1; //金额正负1正值2负值
                    $vore_data['vore_actual_price'] = abs($cost_price); //结算金额
                    $vore_data['vore_collection_price'] = 0; //代收金额
                    $vore_data['vore_recycle_price'] = 0; //回收金额
                    $vore_data['vore_early_costing'] = 0; //成本
                    $vore_data['vore_type'] = ''; //单位类型1会员零售2客户单位3速电派单
                    $vore_data['vore_client_id'] = ''; //客户单位/客户id
                    $vore_data['vore_channel_unit'] = '';
                $vore_data['vore_create_time'] = $value->stoc_create_time;
                $vore_id = DB::table('voucher_receipts')->insertGetId($vore_data);
                // 凭证借贷表(结算金额)
                    if ($value->stoc_type == '1') { //盘盈
                        $volo_data[0]['volo_shop_id'] = $value->stoc_shop_id;
                        $volo_data[0]['volo_vore_id'] = $vore_id;
                        $volo_data[0]['volo_type'] = 1; //类型1借方2贷方
                        $volo_data[0]['volo_borrow_subject'] = '140501'; //借方科目
                        $volo_data[0]['volo_borrow_subject_name'] = '库存商品'; //借方科目名称
                        $volo_data[0]['volo_borrow_price'] = abs($cost_price); //借方金额
                        $volo_data[0]['volo_loan_subject'] = '190101'; //贷方科目
                        $volo_data[0]['volo_loan_subject_name'] = '待处理财产损溢'; //贷方科目名称
                        $volo_data[0]['volo_loan_price'] = abs($cost_price); //贷方金额
                    } elseif ($value->stoc_type == '2') { //盘亏
                        $volo_data[0]['volo_shop_id'] = $value->stoc_shop_id;
                        $volo_data[0]['volo_vore_id'] = $vore_id;
                        $volo_data[0]['volo_type'] = 1; //类型1借方2贷方
                        $volo_data[0]['volo_borrow_subject'] = '190101'; //借方科目
                        $volo_data[0]['volo_borrow_subject_name'] = '待处理财产损溢'; //借方科目名称
                        $volo_data[0]['volo_borrow_price'] = abs($cost_price); //借方金额
                        $volo_data[0]['volo_loan_subject'] = '140501'; //贷方科目
                        $volo_data[0]['volo_loan_subject_name'] = '库存商品'; //贷方科目名称
                        $volo_data[0]['volo_loan_price'] = abs($cost_price); //贷方金额
                    }
                $volo_data[0]['volo_update_time'] = $value->stoc_create_time; //更新时间
                $volo_id = DB::table('voucher_loan')->insert($volo_data);*/
                // } else {
                //     $vore_id = true;
                //     $volo_id = true;
                // }
            } else {
                $vore_id = true;
                $volo_id = true;
            }
        }
        dump($cost_price);
        echo '成功';
    }

    // 统计商品表中有系统商品编码一样的数据
    public function searchSystemGoods()
    {
        ignore_user_abort();
        set_time_limit(0);

        $find_goods = DB::table('goods')
            ->where('goo_cid', 0)
            ->where('goo_shop_id', 0)
            ->whereIn('goo_type', [1, 4])
            ->where('goo_class', 2)
            ->where('goo_delete', 1)
            ->groupBy('goo_goods_encode')
            ->having(DB::raw('count(goo_goods_encode)'), '<', 2)
            ->select('goo_id', 'goo_cid', 'goo_shop_id', 'goo_name', 'goo_goods_encode')
            ->get()->toArray();
        dump($find_goods);
        exit;
    }

    // 统计仓库商品锁定表和仓库商品表库存数量不一致的数据
    public function warehouseGoods(Request $request)
    {
        ignore_user_abort();
        set_time_limit(0);

        // 查询仓库商品锁定表的锁定库存数量
        $find_wagl_data = DB::table('warehouse_goods_lock')
            ->where('wagl_shop_id', 1)
            ->where('wagl_ware_id', $request['ware_id'])
            ->where('wagl_state', 1)
            ->select('wagl_id', 'wagl_ware_id', 'wagl_wago_id', 'wagl_lock_quantity')
            ->get()->toArray();
        $wagl_subtract = [];
        foreach ($find_wagl_data as $kk => $vv) {
            if (!isset($wagl_subtract[$vv->wagl_wago_id])) {
                $wagl_subtract[$vv->wagl_wago_id] = 0;
            }
            $wagl_subtract[$vv->wagl_wago_id] += $vv->wagl_lock_quantity; //商品数量
        }
        unset($find_dast_data);
        $goods_list = [];
        foreach ($wagl_subtract as $key => $value) {
            // 查询仓库商品表锁定库存数量
            $find_wago_data = DB::table('warehouse_goods as wago')
                ->leftjoin('goods as goo', 'goo.goo_id', '=', 'wago.wago_goo_id')
                ->where('wago_id', $key)
                ->select('wago_id', 'wago_lock_quantity', 'wago_priority_lock_quantity', 'goo_goods_encode')
                ->first();
            if ($find_wago_data) {
                if ($value != $find_wago_data->wago_lock_quantity) {
                    $goods_list[$key]['goo_goods_encode'] = $find_wago_data->goo_goods_encode;
                    $goods_list[$key]['wagl_lock_quantity'] = $value;
                    $goods_list[$key]['wago_lock_quantity'] = $find_wago_data->wago_lock_quantity;
                    dump($find_wago_data->goo_goods_encode . '===' . $find_wago_data->wago_id);
                }
            }
            unset($find_wago_data);
        }
        dump($goods_list);
        echo "string";
        exit;
    }

    // 处理厦门锁定数据
    public function disposeLock(Request $request)
    {
        ignore_user_abort();
        set_time_limit(0);

        $adm_cid = 1;
        $shop_id = 1;

        if ($request['type'] == 1) { //发货单
            $dispatch_return = BackEnd::dispatch(
                $adm_cid, //用户信息
                $shop_id
            );
            dump($dispatch_return);
        } elseif ($request['type'] == 2) { //订单
            $order_return = BackEnd::order(
                $adm_cid, //用户信息
                $shop_id
            );
            dump($order_return);
        } elseif ($request['type'] == 3) { //调拨单
            $transferring_return = BackEnd::transferringOrder(
                $adm_cid, //用户信息
                $shop_id
            );
            dump($transferring_return);
        }
        echo '成功';
    }

    // 查询温州门店自营商品检索编码是7位的
    public function selectWGoods()
    {
        ignore_user_abort();
        set_time_limit(0);

        $shop_id = 59;

        // 查询商品表
        $find_goo_data = DB::table('goods')
            ->where('goo_cid', 1)
            ->where('goo_shop_id', $shop_id)
            ->where('goo_class', 1)
            ->where('goo_delete', 1)
            ->where('goo_type', 1)
            ->select('goo_id', 'goo_goods_encode', 'goo_name', 'goo_ampere_hour')
            ->get()->toArray();
        foreach ($find_goo_data as $key => $value) {
            // 判断检索编码长度为7位的
            if (strlen($value->goo_goods_encode) == 7) {
                // 根据检索编码查询系统商品id
                $system_goo_id = DB::table('goods')
                    ->where('goo_shop_id', 0)
                    ->where('goo_goods_encode', $value->goo_goods_encode)
                    ->where('goo_type', 1)
                    ->where('goo_delete', 1)
                    ->select('goo_id', 'goo_name')
                    ->first();
                if ($system_goo_id) {
                    // 根据自营商品id,查询仓库商品表数据,并替换成系统商品id
                    $find_wago_id = DB::table('warehouse_goods')
                        ->where('wago_ware_id', 85)
                        ->where('wago_class', 1)
                        ->where('wago_goo_id', $value->goo_id)
                        ->value('wago_id');
                    if ($find_wago_id) {
                        // 修改仓库商品表的商品id
                        $wago_data['wago_goo_id'] = $system_goo_id->goo_id;
                        $wago_res = DB::table('warehouse_goods')
                            ->where('wago_id', $find_wago_id)
                            ->update($wago_data);
                        unset($wago_data);
                        unset($wago_res);
                    }
                    // 根据自营商品id,查询进销存商品表数据,并替换成系统商品id
                    $find_ense_id = DB::table('enters_sells_saves')
                        ->where('ense_shop_id', $shop_id)
                        ->where('ense_goo_warehouse', 85)
                        ->where('ense_goo_waretype', 1)
                        ->where('ense_goo_id', $value->goo_id)
                        ->value('ense_id');
                    if ($find_ense_id) {
                        // 修改仓库商品表的商品id
                        $ense_data['ense_goo_id'] = $system_goo_id->goo_id;
                        $ense_data['ense_goo_name'] = $system_goo_id->goo_name;
                        $ense_res = DB::table('enters_sells_saves')
                            ->where('ense_id', $find_ense_id)
                            ->update($ense_data);
                        unset($ense_data);
                        unset($ense_res);
                    }
                } else {
                    $goo_data['goo_cid'] = 0;
                    $goo_data['goo_shop_id'] = 0;
                    $goo_data['goo_superior_shop_id'] = 0;
                    $goo_data['goo_class'] = 2;
                    $goo_data['goo_update_time'] = date('Y-m-d H:i:s');
                    $goo_res = DB::table('goods')
                        ->where('goo_id', $value->goo_id)
                        ->where('goo_type', 1)
                        ->update($goo_data);
                    // 查询旧货商品
                    $junk_goo_id = DB::table('goods')
                        ->where('goo_type', 4)
                        ->where('goo_fid', $value->goo_id)
                        ->value('goo_id');
                    $junk_data['goo_cid'] = 0;
                    $junk_data['goo_shop_id'] = 0;
                    $junk_data['goo_superior_shop_id'] = 0;
                    $junk_data['goo_class'] = 2;
                    $junk_data['goo_update_time'] = date('Y-m-d H:i:s');
                    $junk_res = DB::table('goods')
                        ->where('goo_id', $junk_goo_id)
                        ->where('goo_type', 4)
                        ->update($goo_data);
                    unset($junk_data);
                    unset($junk_res);
                    unset($goo_data);
                    unset($goo_res);
                }
            }
        }
        unset($find_goo_data);
        echo "string";
        exit;
    }

    // 查询退货单类型凭证金额跟订单类型退货单金额不一致的数据
    public function adjustRecedeVoucher2()
    {
        ignore_user_abort();
        set_time_limit(0);

        $adm_cid = 1;
        $shop_id = 1;

        // 查询凭证未同步U8,单号类型为工单的数据
        $find_vore_data = DB::table('voucher_receipts')
            ->where('vore_cid', $adm_cid)
            ->where('vore_shop_id', $shop_id)
            ->where('vore_service_type', 4)
            ->where('vore_state', 1)
            ->select('vore_id', 'vore_ord_id', 'vore_ord_number')
            ->get()->toArray();
        foreach ($find_vore_data as $key => $value) {
            // 查询订单状态已完成的数据
            $find_wor_data = DB::table('order')
                ->where('ord_id', $value->vore_ord_id)
                ->where('ord_order_number', $value->vore_ord_number)
                ->where('ord_delete', 1)
                ->where('ord_collection_bill', 1)
                ->where('ord_service_type', 4)
                ->where('ord_wor_state', 4)
                ->select('ord_id', 'ord_order_number', 'ord_actual_price')
                ->first();
            if ($find_wor_data) {
                // 查询借贷表
                $find_volo_data = DB::table('voucher_loan')
                    ->where('volo_vore_id', $value->vore_id)
                    ->get()->toArray();
                $find_volo_data = json_decode(json_encode($find_volo_data), true);
                $ord_actual_price = $find_wor_data->ord_actual_price / 100;
                if (abs($ord_actual_price) != abs($find_volo_data[0]['volo_borrow_price'])) {
                    dump($value->vore_ord_number);
                }
            } else {
                echo 222;
            }
        }
        echo '成功';
    }

    // 原来仓库里的自营商品id，已经切换成系统商品id的，需要把自营商品id换成系统商品id,订单商品、工单商品、采购单、发货单、调拨单、盘库单、旧货回收、退换入库、仓库商品、出入库记录、进销存、销售统计
    // 根据检索编码查询对应的商品id
    public function bulkEditing(Request $request)
    {
        ignore_user_abort();
        set_time_limit(0);

        $adm_cid = 1;
        $adm_shop_id = 1;

        $find_data = DB::table('edit_system_goods')
            ->where('goo_cid', $adm_cid)
            ->where('goo_shop_id', $adm_shop_id)
            ->select('goo_id', 'goo_name', 'goo_normal_goods_id', 'goo_junk_goods_id', 'goo_goods_code', 'goo_system_goods_id', 'goo_system_goods_ids', 'goo_goods_encode', 'goo_system_goods_name')
            ->get()->toArray();
        foreach ($find_data as $key => $value) {
            // 修改订单商品表数据
            $find_orgo_data = DB::table('order_goods as orgo')
                ->leftjoin('order as ord', 'ord.ord_id', '=', 'orgo.orgo_ord_id')
                ->where('ord_cid', $adm_cid)
                ->where('ord_shop_id', $adm_shop_id)
                ->where('ord_collection_bill', 1) //是否代收账单：1正常订单2代收账单
                ->where('orgo_goo_id', $value->goo_normal_goods_id) //正常
                // ->where('orgo_goo_id', $value->goo_junk_goods_id)//旧货
                ->select('orgo_id', 'orgo_goo_id', 'orgo_goo_name', 'orgo_goo_goods_encode')
                ->get()->toArray();
            foreach ($find_orgo_data as $orgo_key => $orgo_value) {
                $orgo_edit_data['orgo_goo_id'] = $value->goo_system_goods_id; //正常系统商品id
                // $orgo_edit_data['orgo_goo_id'] = $value->goo_system_goods_ids;//旧货系统商品id
                $orgo_edit_data['orgo_goo_name'] = $value->goo_system_goods_name;
                $orgo_edit_data['orgo_goo_goods_encode'] = $value->goo_goods_encode;
                $orgo_edit_res = DB::table('order_goods')
                    ->where('orgo_id', $orgo_value->orgo_id)
                    ->update($orgo_edit_data);
                unset($orgo_edit_data);
                unset($orgo_edit_res);
            }
            unset($find_orgo_data);
            // 修改工单商品表
            $find_wogo_data = DB::table('work_good as wogo')
                ->leftjoin('work_order as wor', 'wor.wor_id', '=', 'wogo.wogo_wor_id')
                ->where('wor_cid', $adm_cid)
                ->where('wor_shop_id', $adm_shop_id)
                ->where('wor_collection_bill', 1) //是否代收账单：1正常订单2代收账单
                ->where('wogo_goo_id', $value->goo_normal_goods_id) //正常
                // ->where('wogo_goo_id', $value->goo_junk_goods_id)//旧货
                ->select('wogo_id', 'wogo_goo_id', 'wogo_goo_name', 'wogo_goo_goods_encode', 'wogo_goo_type')
                ->get()->toArray();
            foreach ($find_wogo_data as $wogo_key => $wogo_value) {
                $wogo_edit_data['wogo_goo_id'] = $value->goo_system_goods_id;
                // $wogo_edit_data['wogo_goo_id'] = $value->goo_system_goods_ids;//旧货系统商品id
                $wogo_edit_data['wogo_goo_name'] = $value->goo_system_goods_name;
                $wogo_edit_data['wogo_goo_goods_encode'] = $value->goo_goods_encode;
                $wogo_edit_res = DB::table('work_good')
                    ->where('wogo_id', $wogo_value->wogo_id)
                    ->update($wogo_edit_data);
                unset($wogo_edit_data);
                unset($wogo_edit_res);
            }
            unset($find_wogo_data);
            // 修改发货单商品表
            $find_digo_data = DB::table('dispatch_goods as digo')
                ->leftjoin('dispatch_bill as dibi', 'dibi.dego_id', '=', 'digo.digo_dego_id')
                ->where('dego_cid', $adm_cid)
                ->where('dego_shop_id', $adm_shop_id)
                ->where('digo_goo_id', $value->goo_junk_goods_id) //旧货
                ->select('digo_id', 'digo_goo_id', 'digo_goo_name', 'digo_goo_goods_encode')
                ->get()->toArray();
            foreach ($find_digo_data as $digo_key => $digo_value) {
                $digo_edit_data['digo_goo_id'] = $value->goo_system_goods_id;
                // $digo_edit_data['digo_goo_id'] = $value->goo_system_goods_ids;//旧货系统商品id
                $digo_edit_data['digo_goo_name'] = $value->goo_system_goods_name;
                $digo_edit_data['digo_goo_goods_encode'] = $value->goo_goods_encode;
                $digo_edit_res = DB::table('dispatch_goods')
                    ->where('digo_id', $digo_value->digo_id)
                    ->update($digo_edit_data);
                unset($digo_edit_data);
                unset($digo_edit_res);
            }
            unset($find_digo_data);
            // 修改采购单商品表
            $find_stgo_data = DB::table('storage_goods')
                ->where('company_id', $adm_cid)
                ->where('stgo_shop_id', $adm_shop_id)
                ->where('goods_id', $value->goo_normal_goods_id) //正常
                // ->where('goods_id', $value->goo_junk_goods_id)//旧货
                ->select('id', 'goods_id', 'goods_name', 'goods_number')
                ->get()->toArray();
            foreach ($find_stgo_data as $stgo_key => $stgo_value) {
                $stgo_edit_data['goods_id'] = $value->goo_system_goods_id;
                // $stgo_edit_data['goods_id'] = $value->goo_system_goods_ids;//旧货系统商品id
                $stgo_edit_data['goods_name'] = $value->goo_system_goods_name;
                $stgo_edit_data['goods_number'] = $value->goo_goods_encode;
                $stgo_edit_res = DB::table('storage_goods')
                    ->where('id', $stgo_value->id)
                    ->update($stgo_edit_data);
                unset($stgo_edit_data);
                unset($stgo_edit_res);
            }
            unset($find_stgo_data);
            // 修改盘库单商品表
            $find_stgo_data = DB::table('stocktake_goods as stgo')
                ->leftjoin('stocktake as stoc', 'stoc.stoc_id', '=', 'stgo.stgo_stoc_id')
                ->where('stoc_cid', $adm_cid)
                ->where('stoc_shop_id', $adm_shop_id)
                ->where('stgo_goo_id', $value->goo_normal_goods_id) //正常
                // ->where('stgo_goo_id', $value->goo_junk_goods_id)//旧货
                ->select('stgo_id', 'stgo_goo_id')
                ->get()->toArray();
            foreach ($find_stgo_data as $stgo_key => $stgo_value) {
                $stgo_edit_data['stgo_goo_id'] = $value->goo_system_goods_id;
                // $stgo_edit_data['stgo_goo_id'] = $value->goo_system_goods_ids;//旧货系统商品id
                $stgo_edit_res = DB::table('stocktake_goods')
                    ->where('stgo_id', $stgo_value->stgo_id)
                    ->update($stgo_edit_data);
                unset($stgo_edit_data);
                unset($stgo_edit_res);
            }
            unset($find_stgo_data);
            // 修改调拨单
            $find_trog_data = DB::table('transferring_order_goods as trog')
                ->leftjoin('transferring_order as tror', 'tror.tror_id', '=', 'trog.trog_tror_id')
                ->where('tror_cid', $adm_cid)
                ->where('tror_shop_id', $adm_shop_id)
                ->where('trog_goo_id', $value->goo_normal_goods_id) //正常
                // ->where('trog_goo_id', $value->goo_junk_goods_id)//旧货
                ->select('trog_id', 'trog_goo_id')
                ->get()->toArray();
            foreach ($find_trog_data as $trog_key => $trog_value) {
                $trog_edit_data['trog_goo_id'] = $value->goo_system_goods_id;
                // $trog_edit_data['trog_goo_id'] = $value->goo_system_goods_ids;//旧货系统商品id
                $trog_edit_res = DB::table('transferring_order_goods')
                    ->where('trog_id', $trog_value->trog_id)
                    ->update($trog_edit_data);
                unset($trog_edit_data);
                unset($trog_edit_res);
            }
            unset($find_trog_data);
            // 旧货回收单
            $find_junk_data = DB::table('junk_goods as junk')
                ->leftjoin('junk_recycle as jur', 'jur.jur_id', '=', 'junk.jugo_jur_id')
                ->where('jur_cid', $adm_cid)
                ->where('jur_shop_id', $adm_shop_id)
                ->where('jugo_goo_id', $value->goo_normal_goods_id) //正常
                // ->where('jugo_goo_id', $value->goo_junk_goods_id)//旧货
                ->select('jugo_id', 'jugo_jur_id', 'jugo_goo_name', 'jugo_goo_goods_encode')
                ->get()->toArray();
            foreach ($find_junk_data as $junk_key => $junk_value) {
                $junk_edit_data['jugo_goo_id'] = $value->goo_system_goods_id;
                // $junk_edit_data['jugo_goo_id'] = $value->goo_system_goods_ids;//旧货系统商品id
                $junk_edit_data['jugo_goo_name'] = $value->goo_system_goods_name;
                $junk_edit_data['jugo_goo_goods_encode'] = $value->goo_goods_encode;
                $junk_edit_res = DB::table('junk_goods')
                    ->where('jugo_id', $junk_value->jugo_id)
                    ->update($junk_edit_data);
                unset($junk_edit_data);
                unset($junk_edit_res);
            }
            unset($find_junk_data);
            // 退换入库单
            $find_rego_data = DB::table('recede_goods as rego')
                ->leftjoin('recede_recycle as rec', 'rec.rec_id', '=', 'rego.rego_rec_id')
                ->where('rec_cid', $adm_cid)
                ->where('rec_shop_id', $adm_shop_id)
                ->where('rego_goo_id', $value->goo_normal_goods_id) //正常
                // ->where('rego_goo_id', $value->goo_junk_goods_id)//旧货
                ->select('rego_id', 'rego_goo_id', 'rego_goo_name', 'rego_goo_goods_encode')
                ->get()->toArray();
            foreach ($find_rego_data as $rego_key => $rego_value) {
                $rego_edit_data['rego_goo_id'] = $value->goo_system_goods_id;
                // $rego_edit_data['rego_goo_id'] = $value->goo_system_goods_ids;//旧货系统商品id
                $rego_edit_data['rego_goo_name'] = $value->goo_system_goods_name;
                $rego_edit_data['rego_goo_goods_encode'] = $value->goo_goods_encode;
                $rego_edit_res = DB::table('recede_goods')
                    ->where('rego_id', $rego_value->rego_id)
                    ->update($rego_edit_data);
                unset($rego_edit_data);
                unset($rego_edit_res);
            }
            unset($find_rego_data);
            // 商品流水记录
            $find_oude_data = DB::table('outin_details as oude')
                ->leftjoin('outin_record as oure', 'oure.oure_id', '=', 'oude.oude_oure_id')
                ->where('oure_cid', $adm_cid)
                ->where('oure_shop_id', $adm_shop_id)
                ->where('oude_goo_id', $value->goo_normal_goods_id) //正常
                // ->where('oude_goo_id', $value->goo_junk_goods_id)//旧货
                ->select('oude_id', 'oude_goo_id')
                ->get()->toArray();
            foreach ($find_oude_data as $oude_key => $oude_value) {
                $oude_edit_data['oude_goo_id'] = $value->goo_system_goods_id;
                // $oude_edit_data['oude_goo_id'] = $value->goo_system_goods_ids;//旧货系统商品id
                $oude_edit_res = DB::table('outin_details')
                    ->where('oude_id', $oude_value->oude_id)
                    ->update($oude_edit_data);
                unset($oude_edit_data);
                unset($oude_edit_res);
            }
            unset($find_oude_data);
            // 仓库商品表
            $find_wago_data = DB::table('warehouse_goods as wago')
                ->leftjoin('warehouse as ware', 'ware.ware_cid', '=', 'wago.wago_ware_id')
                ->where('ware_cid', $adm_cid)
                ->where('ware_shop_id', $adm_shop_id)
                ->where('wago_goo_id', $value->goo_normal_goods_id) //正常
                // ->where('wago_goo_id', $value->goo_junk_goods_id)//旧货
                ->select('wago_id', 'wago_goo_id')
                ->get()->toArray();
            foreach ($find_wago_data as $wago_key => $wago_value) {
                $wago_edit_data['wago_goo_id'] = $value->goo_system_goods_id;
                // $wago_edit_data['wago_goo_id'] = $value->goo_system_goods_ids;//旧货系统商品id
                $wago_edit_res = DB::table('warehouse_goods')
                    ->where('wago_id', $wago_value->wago_id)
                    ->update($wago_edit_data);
                unset($wago_edit_data);
                unset($wago_edit_res);
            }
            unset($find_wago_data);
            // 销售统计
            $find_dast_data = DB::table('data_statistical')
                ->where('dast_cid', $adm_cid)
                ->where('dast_shop_id', $adm_shop_id)
                ->where('dast_goo_id', $value->goo_normal_goods_id) //正常
                // ->where('dast_goo_id', $value->goo_junk_goods_id)//旧货
                ->select('dast_id', 'dast_goo_id')
                ->get()->toArray();
            foreach ($find_dast_data as $dast_key => $dast_value) {
                $dast_edit_data['dast_goo_id'] = $value->goo_system_goods_id;
                // $dast_edit_data['dast_goo_id'] = $value->goo_system_goods_ids;//旧货系统商品id
                $dast_edit_res = DB::table('data_statistical')
                    ->where('dast_id', $dast_value->dast_id)
                    ->update($dast_edit_data);
                unset($dast_edit_data);
                unset($dast_edit_res);
            }
            unset($find_dast_data);
            // 进销存
            $find_ense_data = DB::table('enters_purchase')
                ->where('ense_shop_id', $adm_shop_id)
                ->where('ense_goo_id', $value->goo_normal_goods_id) //正常
                // ->where('ense_goo_id', $value->goo_junk_goods_id)//旧货
                ->select('ense_id', 'ense_goo_id')
                ->get()->toArray();
            foreach ($find_ense_data as $ense_key => $ense_value) {
                $ense_edit_data['ense_goo_id'] = $value->goo_system_goods_id;
                // $ense_edit_data['ense_goo_id'] = $value->goo_system_goods_ids;//旧货系统商品id
                $ense_edit_res = DB::table('enters_purchase')
                    ->where('ense_id', $ense_value->ense_id)
                    ->update($ense_edit_data);
                unset($ense_edit_data);
                unset($ense_edit_res);
            }
            unset($find_ense_data);
        }
        unset($find_data);
        echo '成功';
    }

    // 根据检索编码查询对应的商品id
    public function editGoodsId()
    {
        ignore_user_abort();
        set_time_limit(0);

        $find_data = DB::table('edit_system_goods')
            ->select('goo_id', 'goo_name', 'goo_goods_code', 'goo_goods_encode')
            ->get()->toArray();
        foreach ($find_data as $key => $value) {
            if (!empty($value->goo_goods_encode)) { //系统商品编码
                // 根据商品编码,查询系统编码(原)商品id
                $goo_normal_goods_id = DB::table('goods')
                    ->where('goo_cid', 1)
                    ->where('goo_shop_id', 1)
                    ->where('goo_type', 1)
                    ->where('goo_goods_encode', $value->goo_goods_code)
                    ->value('goo_id');
                if ($goo_normal_goods_id) {
                    // 修改正常商品
                    $edit_normal_data['goo_normal_goods_id'] = $goo_normal_goods_id;
                    $edit_normal_data['goo_update_time'] = date('Y-m-d H:i:s');
                    $edit_normal_res = DB::table('edit_system_goods')
                        ->where('goo_id', $value->goo_id)
                        ->update($edit_normal_data);
                    dump($edit_normal_res);
                    unset($edit_normal_data);
                    unset($edit_normal_res);
                }
                // 根据商品编码,查询系统编码(原)商品id
                $goo_junk_goods_id = DB::table('goods')
                    ->where('goo_cid', 1)
                    ->where('goo_shop_id', 1)
                    ->where('goo_type', 4)
                    ->where('goo_goods_encode', $value->goo_goods_code)
                    ->value('goo_id');
                if ($goo_junk_goods_id) {
                    // 修改旧货商品id
                    $edit_junk_data['goo_junk_goods_id'] = $goo_junk_goods_id;
                    $edit_junk_data['goo_update_time'] = date('Y-m-d H:i:s');
                    $edit_junk_res = DB::table('edit_system_goods')
                        ->where('goo_id', $value->goo_id)
                        ->update($edit_junk_data);
                    dump($edit_junk_res);
                    unset($edit_junk_data);
                    unset($edit_junk_res);
                }
                // 修改正常系统商品id
                $goo_system_goods_id = DB::table('goods')
                    ->where('goo_cid', 0)
                    ->where('goo_shop_id', 0)
                    ->where('goo_type', 1)
                    ->where('goo_goods_encode', $value->goo_goods_encode)
                    ->select('goo_id', 'goo_name')
                    ->first();
                $edit_system_data['goo_system_goods_id'] = $goo_system_goods_id->goo_id;
                $edit_system_data['goo_system_goods_name'] = $goo_system_goods_id->goo_name;
                $gosa_res = DB::table('edit_system_goods')
                    ->where('goo_id', $value->goo_id)
                    ->update($edit_system_data);
                dump($gosa_res);
                unset($edit_system_data);
                unset($gosa_res);
                // 修改旧货系统商品id
                $goo_system_goods_ids = DB::table('goods')
                    ->where('goo_cid', 0)
                    ->where('goo_shop_id', 0)
                    ->where('goo_type', 4)
                    ->where('goo_goods_encode', $value->goo_goods_encode)
                    ->select('goo_id', 'goo_name')
                    ->first();
                $edit_system_datas['goo_system_goods_ids'] = $goo_system_goods_ids->goo_id;
                $edit_system_datas['goo_system_goods_name'] = $goo_system_goods_ids->goo_name;
                $gosa_ress = DB::table('edit_system_goods')
                    ->where('goo_id', $value->goo_id)
                    ->update($edit_system_datas);
                dump($gosa_ress);
                unset($edit_system_datas);
                unset($gosa_ress);
            }
        }
        echo '成功';
    }

    // 查询虚拟加盟店凭证金额跟工单金额不一致的数据
    public function adjustVirtualFranchises()
    {
        ignore_user_abort();
        set_time_limit(0);

        $adm_cid = 1;
        $shop_id = 1;

        // 查询凭证未同步U8,单号类型为工单的数据
        $find_vore_data = DB::table('voucher_receipts as vore')
            ->where('vore_cid', $adm_cid)
            ->where('vore_shop_id', $shop_id)
            ->where('vore_order_type', 2)
            ->where('vore_state', 1)
            ->select('vore_id', 'vore_ord_id', 'vore_ord_number', 'vore_wor_id', 'vore_wor_number')
            ->get()->toArray();
        foreach ($find_vore_data as $key => $value) {
            // 查询工单类型为外派工单,门店类型为虚拟加盟店,完成已通过的数据
            $find_wor_data = DB::table('work_order as wor')
                ->leftjoin('work_client as wocl', 'wocl.wocl_wor_id', '=', 'wor.wor_id')
                ->where('wor_id', $value->vore_wor_id)
                ->where('wor_number', $value->vore_wor_number)
                ->where('wor_delete', 1)
                ->where('wor_collection_bill', 1)
                ->where('wor_state', 10)
                ->select('wor_id', 'wor_number', 'wor_actual_price')
                ->first();
            if ($find_wor_data) {
                // 查询借贷表
                $find_volo_data = DB::table('voucher_loan')
                    ->where('volo_vore_id', $value->vore_id)
                    ->get()->toArray();
                $find_volo_data = json_decode(json_encode($find_volo_data), true);
                $wor_actual_price = $find_wor_data->wor_actual_price / 100;
                if ($wor_actual_price != $find_volo_data[0]['volo_borrow_price']) {
                    dump($value->vore_ord_number);
                }
            } else {
                echo 222;
            }
        }
        echo '成功';
    }

    // 修改退货单1-3月份未同步U8的凭证
    public function adjustRecedeVoucher()
    {
        ignore_user_abort();
        set_time_limit(0);

        $adm_cid = 1;
        $shop_id = 1;

        // 查询凭证未同步U8,类型为退货单的数据
        $find_vore_data = DB::table('voucher_receipts as vore')
            ->leftjoin('recede_recycle as rec', 'rec.rec_ord_id', '=', 'vore.vore_ord_id')
            ->where('vore_cid', $adm_cid)
            ->where('vore_shop_id', $shop_id)
            ->where('vore_service_type', 4)
            ->where('vore_state', 1)
            ->where('rec_source_type', 8)
            ->where('rec_state', 2)
            ->select('vore_id', 'vore_ord_id', 'vore_ord_number', 'rec_id')
            ->get()->toArray();
        foreach ($find_vore_data as $key => $value) {
            // 查询退货单商品
            $find_rego_data = DB::table('recede_goods')
                ->where('rego_rec_id', $value->rec_id)
                ->select('rego_id', 'rego_ware_id', 'rego_waon_class')
                ->get();
            if ($find_rego_data) {
                foreach ($find_rego_data as $kk => $vv) {
                    // 查询借贷表
                    $find_volo_data = DB::table('voucher_loan')
                        ->where('volo_vore_id', $value->vore_id)
                        ->get()->toArray();
                    $find_volo_data = json_decode(json_encode($find_volo_data), true);
                    if ($vv->rego_waon_class == 1) { //货物仓
                        if ($find_volo_data[0]['volo_borrow_costing'] > 0 || $find_volo_data[0]['volo_loan_costing'] > 0) {
                            $edit_data['volo_borrow_costing'] = '-' . $find_volo_data[0]['volo_borrow_costing'];
                            $edit_data['volo_loan_costing'] = '-' . $find_volo_data[0]['volo_loan_costing'];
                            $edit_data['volo_update_time'] = date('Y-m-d H:i:s');
                            $edit_res = DB::table('voucher_loan')
                                ->where('volo_id', $find_volo_data[0]['volo_id'])
                                ->update($edit_data);
                            dump($edit_res);
                            unset($edit_data);
                            unset($edit_res);
                        }
                    } elseif ($vv->rego_waon_class == 3) { //旧货仓
                        $edit_data['volo_borrow_subject'] = '140501';
                        $edit_data['volo_borrow_subject_name'] = '库存商品';
                        $edit_data['volo_borrow_price'] = abs($find_volo_data[0]['volo_borrow_price']);
                        $edit_data['volo_borrow_costing'] = 0;
                        $edit_data['volo_borrow_costing_subject'] = '';
                        $edit_data['volo_borrow_costing_name'] = '';
                        $edit_data['volo_loan_subject'] = '1122';
                        $edit_data['volo_loan_subject_name'] = '应收账款';
                        $edit_data['volo_loan_price'] = abs($find_volo_data[0]['volo_loan_price']);
                        $edit_data['volo_loan_costing'] = 0;
                        $edit_data['volo_loan_costing_subject'] = '';
                        $edit_data['volo_loan_costing_name'] = '';
                        $edit_data['volo_update_time'] = date('Y-m-d H:i:s');
                        $edit_res = DB::table('voucher_loan')
                            ->where('volo_id', $find_volo_data[0]['volo_id'])
                            ->update($edit_data);
                        dump($edit_res);
                        unset($edit_data);
                        unset($edit_res);
                    }
                }
            } else {
                echo 222;
            }
        }
        echo '成功';
    }

    // 修改厦门系统商品的价格
    public function editSystemGoods()
    {
        ignore_user_abort();
        set_time_limit(0);

        $find_data = DB::table('edit_system_goods')
            ->select('goo_id', 'goo_name', 'goo_goods_code', 'goo_goods_encode')
            ->get()->toArray();
        foreach ($find_data as $key => $value) {
            if (!empty($value->goo_goods_encode)) { //系统商品编码
                // 根据商品编码,查询价格
                $find_goods = DB::table('goods')
                    ->where('goo_cid', 1)
                    ->where('goo_shop_id', 1)
                    ->where('goo_goods_encode', $value->goo_goods_code)
                    ->select('goo_price', 'goo_wholesale_price', 'goo_purchase_price', 'goo_recycle_price', 'goo_assign_price', 'goo_ampere_hour', 'goo_unit', 'goo_id')
                    ->first();
                if ($find_goods) {
                    /* // 修改系统商品的单位和安时数
                    $edit_data['goo_ampere_hour'] = $find_goods->goo_ampere_hour;
                    $edit_data['goo_unit'] = $find_goods->goo_unit;
                    $edit_res = DB::table('goods')
                        ->where('goo_shop_id', 0)
                        ->where('goo_goods_encode', $value->ense_new_amount)
                        ->update($edit_data);
                    unset($edit_data);
                    unset($edit_res); */
                    // 修改系统商品属性表
                    $gosa_data['gosa_price'] = $find_goods->goo_price;
                    $gosa_data['gosa_purchase_price'] = $find_goods->goo_purchase_price;
                    $gosa_data['gosa_recycle_price'] = $find_goods->goo_recycle_price;
                    $gosa_data['gosa_assign_price'] = $find_goods->goo_assign_price;
                    $gosa_data['gosa_wholesale_price'] = $find_goods->goo_wholesale_price;
                    $find_goo_id = DB::table('goods')
                        ->where('goo_cid', 0)
                        ->where('goo_shop_id', 0)
                        ->where('goo_goods_encode', $value->goo_goods_encode)
                        ->value('goo_id');
                    $gosa_res = DB::table('goods_system_affiliate')
                        ->where('gosa_shop_id', 1)
                        ->where('gosa_goo_id', $find_goo_id)
                        ->update($gosa_data);
                    unset($gosa_data);
                    unset($gosa_res);
                }
            }
        }
        echo '成功';
    }

    // 统计品类品牌系列对应的商品数量
    public function statistics()
    {
        ignore_user_abort();
        set_time_limit(0);

        $shop_id = 1;

        // 统计品类的商品数量
        $cate_res = DB::table('goods')
            ->where('goo_shop_id', $shop_id)
            ->groupBy('goo_cate_id')
            ->select('goo_cate_id', DB::raw('count(*) as num'))
            ->get();
        foreach ($cate_res as $cate_val) {
            $cate_data['caco_goods_number'] = $cate_val->num;
            $cate_data['caco_update_time'] = date('Y-m-d H:i:s');
            $cate_res = DB::table('category_correlation')
                ->where('caco_shop_id', $shop_id)
                ->where('caco_cate_id', $cate_val->goo_cate_id)
                ->update($cate_data);
            unset($cate_data);
            unset($cate_res);
        }

        // 统计品牌的商品数量
        $brand_res = DB::table('goods')
            ->where('goo_shop_id', $shop_id)
            ->groupBy('goo_bra_id')
            ->select('goo_bra_id', DB::raw('count(*) as num'))
            ->get();
        foreach ($brand_res as $bra_val) {
            $bra_data['brco_goods_number'] = $bra_val->num;
            $bra_data['brco_update_time'] = date('Y-m-d H:i:s');
            $brco_res = DB::table('brand_correlation')
                ->where('brco_shop_id', $shop_id)
                ->where('brco_bra_id', $bra_val->goo_bra_id)
                ->update($bra_data);
            unset($bra_data);
            unset($brco_res);
        }

        // 统计系列的商品数量
        $brse_res = DB::table('goods')
            ->where('goo_shop_id', $shop_id)
            ->groupBy('goo_brse_id')
            ->select('goo_brse_id', DB::raw('count(*) as num'))
            ->get();
        foreach ($brse_res as $brse_val) {
            $serie_data['brsc_goods_number'] = $brse_val->num;
            $serie_data['brsc_update_time'] = date('Y-m-d H:i:s');
            $serie_res = DB::table('brand_serie_correlation')
                ->where('brsc_shop_id', $shop_id)
                ->where('brsc_brse_id', $brse_val->goo_brse_id)
                ->update($serie_data);
            unset($serie_data);
            unset($serie_res);
        }
        echo '成功';
    }

    // 统计库存数量
    public function kucun()
    {
        ignore_user_abort();
        set_time_limit(0);

        $cid = 1;
        $shop_id = 1;
        $ware_id = DB::table('warehouse')
            ->select('ware_id', 'ware_type')
            ->get()->toArray();
        $ware_id = array_column($ware_id, null, 'ware_id');

        $wago_class = 4;
        foreach ($ware_id as $kk => $vv) {
            $wago_res = DB::table('warehouse_goods')
                ->where('wago_ware_id', $vv->ware_id)
                ->where('wago_class', $wago_class)
                ->select('wago_ware_id', 'wago_class', 'wago_stock_number', 'wago_lock_quantity', 'wago_priority_stock_number', 'wago_priority_lock_quantity', 'wago_unchecked_stock_number', 'wago_freight_stock_number', 'wago_freight_lock_quantity', 'wago_freight_priority_stock_number', 'wago_freight_priority_lock_quantity')
                ->get()->toArray();
            $wago_stock_number = 0; //良品库存数量
            $wago_lock_quantity = 0; //良品锁定数量
            $wago_priority_stock_number = 0; //优先库存数量
            $wago_priority_lock_quantity = 0; //优先锁定数量
            $wago_unchecked_stock_number = 0; //待检测数量
            $wago_freight_stock_number = 0; //仓位良品库存数量
            $wago_freight_lock_quantity = 0; //仓位良品锁定数量
            $wago_freight_priority_stock_number = 0; //仓位优先库存
            $wago_freight_priority_lock_quantity = 0; //仓位优先锁定数量
            foreach ($wago_res as $kkk => $vvv) {
                $wago_stock_number += $vvv->wago_stock_number;
                $wago_lock_quantity += $vvv->wago_lock_quantity;
                $wago_priority_stock_number += $vvv->wago_priority_stock_number;
                $wago_priority_lock_quantity += $vvv->wago_priority_lock_quantity;
                $wago_unchecked_stock_number += $vvv->wago_unchecked_stock_number;
                $wago_freight_stock_number += $vvv->wago_freight_stock_number;
                $wago_freight_lock_quantity += $vvv->wago_freight_lock_quantity;
                $wago_freight_priority_stock_number += $vvv->wago_freight_priority_stock_number;
                $wago_freight_priority_lock_quantity += $vvv->wago_freight_priority_lock_quantity;
            }
            dump($vv->ware_id . '-总量良品库存：' . $wago_stock_number);
            dump($vv->ware_id . '-总量良品锁定：' . $wago_lock_quantity);
            dump($vv->ware_id . '-总量优先库存：' . $wago_priority_stock_number);
            dump($vv->ware_id . '-总量优先锁定：' . $wago_priority_lock_quantity);
            dump($vv->ware_id . '-待检测：' . $wago_unchecked_stock_number);
            // dump($vv . '-仓位良品库存：' . $wago_freight_stock_number);
            // dump($vv . '-仓位良品锁定：' . $wago_freight_lock_quantity);
            // dump($vv . '-仓位优先库存：' . $wago_freight_priority_stock_number);
            // dump($vv . '-仓位优先锁定：' . $wago_freight_priority_lock_quantity);
            $updata_data['waon_stock_fine_amount'] = $wago_stock_number; //良品总库存数量
            $updata_data['waon_lock_fine_amount'] = $wago_lock_quantity; //良品锁定总数量
            $updata_data['waon_stock_priority_amount'] = $wago_priority_stock_number; //优先总库存
            $updata_data['waon_lock_priority_amount'] = $wago_priority_lock_quantity; //优先锁定数量
            $updata_data['waon_stock_unchecked_amount'] = $wago_unchecked_stock_number; //待检测总库存
            $waon_all_amount = $updata_data['waon_stock_fine_amount'] + $updata_data['waon_lock_fine_amount'] + $updata_data['waon_stock_priority_amount'] + $updata_data['waon_lock_priority_amount'] + $updata_data['waon_stock_unchecked_amount'];
            $updata_data['waon_all_amount'] = $waon_all_amount; //待检测总库存
            $updata_data['waon_update_time'] = date('Y-m-d H:i:s');
            $res = DB::table('warehouse_onhand')
                ->where('waon_ware_id', $vv->ware_id)
                ->where('waon_class', $wago_class)
                ->update($updata_data);
            unset($updata_data);
        }
    }

    // 查询品类重复名称
    public function selectCategory()
    {
        ignore_user_abort();
        set_time_limit(0);

        $adm_cid = 1;
        $shop_id = 1;
        // $shop_id = ['1','2','26','30','31','32','33','42','43','45','46','47','48','59','60','115','138'];
        // 1,2,26,30,31,42,43,45,47,48,59,115,138

        $find_category = DB::table('category')
            ->where(function ($query) use ($adm_cid) {
                $query->where('cate_cid', 0)
                    ->orwhere('cate_cid', $adm_cid);
            })
            ->where(function ($query) use ($shop_id) {
                $query->where('cate_shop_id', 0)
                    ->orwhere('cate_shop_id', $shop_id);
            })
            ->where('cate_class', 2)
            ->where('cate_delete', 1)
            ->groupBy('cate_name')
            ->having(DB::raw('count(cate_name)'), '>', 1)
            ->select('cate_id', 'cate_cid', 'cate_shop_id', 'cate_name')
            ->get()->toArray();
        dump($find_category);
        exit;
        foreach ($find_category as $key => $value) {
            // 查询商品表里是否有该品类,没有直接删除品类数据
            $find_goo_id = DB::table('goods')
                ->where('goo_cid', $value->cate_cid)
                ->where('goo_shop_id', $value->cate_shop_id)
                ->where('goo_delete', 1)
                ->where('goo_cate_id', $value->cate_id)
                ->select('goo_id', 'goo_cate_id', 'goo_cate_name', 'goo_name', 'goo_goods_encode')
                ->first();
            if (empty($find_goo_id)) {
                $del_edit_data['cate_delete'] = 2;
            // $del_edit_res = DB::table('category')
                //     ->where('cate_id', $value->cate_id)
                //     ->update($del_edit_data);
            } else {
                $find_cate_id = DB::table('category')
                    ->where('cate_cid', 0)
                    ->where('cate_shop_id', 0)
                    ->where('cate_name', $value->cate_name)
                    ->value('cate_id');
                // 修改商品表的品类id
                $edit_goo_data['goo_cate_id'] = $find_cate_id;
                $edit_goo_res = DB::table('goods')
                    ->where('goo_cid', $value->cate_cid)
                    ->where('goo_shop_id', $value->cate_shop_id)
                    ->where('goo_delete', 1)
                    ->where('goo_cate_id', $value->cate_id)
                    ->update($edit_goo_data);
                unset($edit_goo_data);
                unset($edit_goo_res);
                // 修改品牌系列的品类id
                $edit_brse_data['brse_cate_id'] = $find_cate_id;
                $edit_brse_res = DB::table('brand_serie')
                    ->where('brse_cid', $value->cate_cid)
                    ->where('brse_shop_id', $value->cate_shop_id)
                    ->where('brse_cate_id', $value->cate_id)
                    ->update($edit_brse_data);
                unset($edit_brse_data);
                unset($edit_brse_res);
            }
        }
        echo 'string1';
    }

    // 查询品牌重复名称
    public function selectBrand()
    {
        ignore_user_abort();
        set_time_limit(0);

        $adm_cid = 1;
        $shop_id = 1;
        // $shop_id = ['1','2','26','30','31','32','33','35','36','37','38','39','40','41','42','43','45','46','47','48','52','53','56','59','60','115','138'];
        // $shop_id = ['1','2','26','30','31','32','33','42','43','45','46','47','48','59','60','115','138'];

        $find_brand = DB::table('brand')
            ->where(function ($query) use ($adm_cid) {
                $query->where('bra_cid', 0)
                    ->orwhere('bra_cid', $adm_cid);
            })
            ->where(function ($query) use ($shop_id) {
                $query->where('bra_shop_id', 0)
                    ->orwhere('bra_shop_id', $shop_id);
            })
            ->where('bra_class', 2)
            ->where('bra_delete', 1)
            ->groupBy('bra_name')
            ->having(DB::raw('count(bra_name)'), '>', 1)
            ->select('bra_id', 'bra_cid', 'bra_shop_id', 'bra_name', 'bra_sequence', 'bra_goods_number')
            ->get()->toArray();
        dump($find_brand);
        exit;
        foreach ($find_brand as $key => $value) {
            // 查询商品表里是否有该品牌,没有直接删除品牌数据
            $find_goo_id = DB::table('goods')
                ->where('goo_cid', $value->bra_cid)
                ->where('goo_shop_id', $value->bra_shop_id)
                ->where('goo_delete', 1)
                ->where('goo_bra_id', $value->bra_id)
                ->select('goo_id', 'goo_bra_id', 'goo_bra_name', 'goo_name', 'goo_goods_encode')
                ->first();
            // dump($find_goo_id);
            if (empty($find_goo_id)) {
                $del_edit_data['bra_delete'] = 2;
            // $del_edit_res = DB::table('brand')
                //     ->where('bra_id', $value->bra_id)
                //     ->update($del_edit_data);
            } else {
                $find_bra_id = DB::table('brand')
                    ->where('bra_cid', 0)
                    ->where('bra_shop_id', 0)
                    ->where('bra_name', $value->bra_name)
                    ->value('bra_id');
                $edit_goo_data['goo_bra_id'] = $find_bra_id;
                $edit_goo_res = DB::table('goods')
                    ->where('goo_cid', $value->bra_cid)
                    ->where('goo_shop_id', $value->bra_shop_id)
                    ->where('goo_delete', 1)
                    ->where('goo_bra_id', $value->bra_id)
                    ->update($edit_goo_data);
                unset($edit_goo_data);
                unset($edit_goo_res);
                // 修改品牌系列的品牌id
                $edit_brse_data['brse_bra_id'] = $find_bra_id;
                $edit_brse_res = DB::table('brand_serie')
                    ->where('brse_cid', $value->bra_cid)
                    ->where('brse_shop_id', $value->bra_shop_id)
                    ->where('brse_bra_id', $value->bra_id)
                    ->update($edit_brse_data);
                unset($edit_brse_data);
                unset($edit_brse_res);
            }
        }
        echo 'string2';
    }

    // 查询品牌系列重复名称
    public function selectBrandSerie()
    {
        ignore_user_abort();
        set_time_limit(0);

        $adm_cid = 1;
        $shop_id = 1;
        // $shop_id = ['1','2','26','30','31','32','33','42','43','45','46','47','48','59','60','115','138'];

        $find_brand_serie = DB::table('brand_serie')
            ->where(function ($query) use ($adm_cid) {
                $query->where('brse_cid', 0)
                    ->orwhere('brse_cid', $adm_cid);
            })
            ->where(function ($query) use ($shop_id) {
                $query->where('brse_shop_id', 0)
                    ->orwhere('brse_shop_id', $shop_id);
            })
            ->where('brse_class', 2)
            ->where('brse_delete', 1)
            ->groupBy('brse_name')
            ->having(DB::raw('count(brse_name)'), '>', 1)
            ->select('brse_id', 'brse_cid', 'brse_shop_id', 'brse_name')
            ->get()->toArray();
        dump($find_brand_serie);
        exit;
        foreach ($find_brand_serie as $key => $value) {
            // echo "string";
            // exit;
            // 查询商品表里是否有该品牌,没有直接删除品牌数据
            $find_goo_id = DB::table('goods')
                ->where('goo_cid', $value->brse_cid)
                ->where('goo_shop_id', $value->brse_shop_id)
                ->where('goo_delete', 1)
                ->where('goo_brse_id', $value->brse_id)
                ->select('goo_id', 'goo_brse_id', 'goo_name', 'goo_goods_encode')
                ->first();
            if (empty($find_goo_id)) {
                $del_edit_data['brse_delete'] = 2;
            // $del_edit_res = DB::table('brand_serie')
                //     ->where('brse_id', $value->brse_id)
                //     ->update($del_edit_data);
            } else {
                $find_brse_id = DB::table('brand_serie')
                    ->where('brse_cid', 0)
                    ->where('brse_shop_id', 0)
                    ->where('brse_name', $value->brse_name)
                    ->value('brse_id');
                $edit_goo_data['goo_brse_id'] = $find_brse_id;
                $edit_goo_res = DB::table('goods')
                    ->where('goo_cid', $value->brse_cid)
                    ->where('goo_shop_id', $value->brse_shop_id)
                    ->where('goo_delete', 1)
                    ->where('goo_brse_id', $value->brse_id)
                    ->update($edit_goo_data);
                unset($edit_goo_data);
                unset($edit_goo_res);
            }
        }
        echo 'string3';
    }

    // 判断系统商品编码是否存在系统中
    public function selectGoods()
    {
        ignore_user_abort();
        set_time_limit(0);

        $find_data = DB::table('enters_sells_saves_price_total')
            ->get()->toArray();
        foreach ($find_data as $key => $value) {
            // dump($value);
            // exit;
            if (!empty($value->ense_new_amount)) {
                // 根据商品编码,查询价格、单位和安时
                $find_goods = DB::table('goods')
                    ->where('goo_cid', 0)
                    ->where('goo_shop_id', 0)
                    ->where('goo_goods_encode', $value->ense_new_amount)
                    ->select('goo_price', 'goo_wholesale_price', 'goo_purchase_price', 'goo_recycle_price', 'goo_assign_price', 'goo_ampere_hour', 'goo_unit', 'goo_id')
                    ->first();
                if ($find_goods) {
                    echo '111';
                } else {
                    dump($value->ense_new_amount);
                }
            }
        }
        echo '成功';
    }

    // 匹配库存商品成本价格
    public function matching()
    {
        ignore_user_abort();
        set_time_limit(0);

        $find_data = DB::table('enters_sells_saves_price_total')
            ->get()->toArray();
        foreach ($find_data as $key => $value) {
            if (!empty($value->ense_out_price)) {
                $edit_data['ense_new_price'] = $value->ense_out_price;
            } else {
                if ($value->ense_new_price != $value->ense_end_price) {
                    $edit_data['ense_new_price'] = $value->ense_end_price;
                } else {
                    $edit_data['ense_new_price'] = $value->ense_new_price;
                }
            }
            $edit_res = DB::table('enters_sells_saves_price_total')
                ->where('ense_goo_number', $value->ense_goo_number)
                ->update($edit_data);
            unset($edit_data);
            unset($edit_res);
        }
        echo '成功';
    }

    // 导入Excel数据
    public function importExcelData(Request $request)
    {
        $path = public_path('img/冠军数据信息表.xls');
        if (is_file($path)) {
            $spreadsheet = \PhpOffice\PhpSpreadsheet\IOFactory::load($path); //如果文件存在则直接载入
            $sheet = $spreadsheet->getActiveSheet(); //获取活动的工作sheet
            $highest_row = $sheet->getHighestRow(); // 取得总行数

            $n = 0;
            $exdc_data = [];
            $exdc_update_time = date('Y-m-d H:i:s');
            for ($row = 2; $row <= $highest_row; $row++) {
                // for ($row = 3; $row <= $highest_row; $row++) {
                // for ($row = 4; $row <= $highest_row; $row++) {

                // 库存商品成本单价和系统编码导入
                // $excel_data['ense_goo_number'] = trim($sheet->getCellByColumnAndRow(1, $row)->getValue()); //检索编码
                // $excel_data['ense_goo_name'] = trim($sheet->getCellByColumnAndRow(2, $row)->getValue()); //商品名称
                // $excel_data['new_end_price'] = trim($sheet->getCellByColumnAndRow(3, $row)->getValue()); //成本价
                // $excel_data['ense_system_number'] = trim($sheet->getCellByColumnAndRow(5, $row)->getValue()); //系统编码

                // X7同安仓库存导入
                // $excel_data['wago_goo_id'] = trim($sheet->getCellByColumnAndRow(1, $row)->getValue()); //商品id
                // $excel_data['wago_goo_name'] = trim($sheet->getCellByColumnAndRow(2, $row)->getValue()); //商品名称
                // $excel_data['wago_goo_number'] = trim($sheet->getCellByColumnAndRow(3, $row)->getValue()); //检索编码
                // $excel_data['wago_stock_number'] = trim($sheet->getCellByColumnAndRow(4, $row)->getValue()); //良品库存数量
                // $excel_data['wago_lock_quantity'] = trim($sheet->getCellByColumnAndRow(5, $row)->getValue()); //良品锁定数量
                // $excel_data['wago_actual_stock_number'] = trim($sheet->getCellByColumnAndRow(6, $row)->getValue()); //实际库存数量

                // 成本价调整
                // $excel_data['ense_goo_number'] = trim($sheet->getCellByColumnAndRow(1, $row)->getValue()); //检索编码
                // $excel_data['ense_goo_name'] = trim($sheet->getCellByColumnAndRow(2, $row)->getValue()); //商品名称
                // $excel_data['ense_new_price'] = trim($sheet->getCellByColumnAndRow(3, $row)->getValue()); //平均价
                // $excel_data['ense_out_price'] = trim($sheet->getCellByColumnAndRow(4, $row)->getValue()); //修正后单价
                // $excel_data['ense_new_amount'] = trim($sheet->getCellByColumnAndRow(5, $row)->getValue()); //系统编码

                $excel_data['number'] = trim($sheet->getCellByColumnAndRow(1, $row)->getValue()); //系统编码
                $excel_data['goo_bra_name'] = trim($sheet->getCellByColumnAndRow(2, $row)->getValue()); //品牌
                $excel_data['goo_brse_name'] = trim($sheet->getCellByColumnAndRow(3, $row)->getValue()); //系列
                $excel_data['goo_name'] = trim($sheet->getCellByColumnAndRow(4, $row)->getValue()); //商品名称
                $excel_data['tongyong'] = trim($sheet->getCellByColumnAndRow(5, $row)->getValue()); //通用名称
                $excel_data['goo_goods_encode'] = trim($sheet->getCellByColumnAndRow(6, $row)->getValue()); //检索编码

                dump($excel_data);
                die;

                $exdc_data[$n]['exdc_type'] = 1;
                $exdc_data[$n]['exdc_update_time'] = $exdc_update_time;
                $exdc_data[$n]['exdc_data'] = json_encode($excel_data);
                $n++;
                unset($excel_data);
            }
            // dump($exdc_data);
            // die;
            $res = DB::table('excel_data_cache')->insert($exdc_data);
            // dump($res);
            // die;
        }
        echo 999;
        die;
    }

    // 将读取到的Excel表格数据，添加到数据库
    public function other(Request $request)
    {
        ignore_user_abort();
        set_time_limit(0);
        // 导入商品数据
        $data = DB::table('excel_data_cache')->where('exdc_type', 2)->get();
        $data = json_decode($data, true);
        $data_info = [];
        foreach ($data as $key => $value) {
            // if ($key <= 400) {
            //     continue;
            // }
            $exdc_data = json_decode($value['exdc_data'], true);
            $data_info[] = $exdc_data;
            // if ($key > 400) {
            //     break;
            // }
        }
        // dump($data_info);
        // die;
        // $this->excelGoods($request->all(), $data_info); //导入系统商品
        // $this->systemImportGoods($request->all(), $data_info); //库存商品成本单价和系统编码导入
        // $this->addStock($request->all(), $data_info); //库存商品成本单价和系统编码导入
        $this->addOldStock($request->all(), $data_info); //新增盘库单，原来的仓库盘少
        // $this->updateGoods($request->all(), $data_info); //修正库存商品成本单价20210228+系统编码
    }

    public function excelGoods($submit_data, $data)
    {
        echo 333;
        // dump($data);
        $cid = 0;
        $shop_id = 0;
        DB::beginTransaction();

        foreach ($data as $key => $value) {
            // dump($value);
            $goo_add['goo_cid'] = $cid; //所属企业id
            $goo_add['goo_shop_id'] = $shop_id; //所属门店id
            $goo_add['goo_superior_shop_id'] = $shop_id; //所属门店id
            $goo_add['goo_name'] =$value['goo_bra_name'].' '. $value['goo_goods_encode'].$value['goo_cate_name'].'-'.$value['location'];
            $goo_add['goo_goods_encode'] = $value['goo_goods_encode'];
            $goo_add['goo_goods_code'] = $value['goo_goods_code'];
            $goo_add['goo_cate_name'] = $value['goo_cate_name'];
            $goo_add['goo_bra_name'] = $value['goo_bra_name'];
            $goo_add['goo_brse_name'] = $value['goo_brse_name'];
            // $goo_add['goo_unit'] = '台';
            // dump($goo_add);
            // die;
            // 根据检索编号判断商品是否存在,不存在就新增
            $goo_goods_encode = DB::table('goods')
                ->where('goo_cid', $cid)
                ->where('goo_shop_id', $shop_id)
                ->where('goo_goods_encode', $goo_add['goo_goods_encode'])
                ->where('goo_type', 1)
                // ->where('goo_delete', 1)
                ->select('goo_goods_encode', 'goo_id', 'goo_class')
                ->orderBy('goo_id', 'desc')
                ->first();
            // 已存在的就跳过
            if ($goo_goods_encode) {
                continue;
            }
            // 查询商品品类是否存在
            $cate_id = DB::table('category')
                ->where('cate_cid', $cid)
                ->where('cate_shop_id', $shop_id)
                ->where('cate_name', $goo_add['goo_cate_name'])
                // ->where('cate_delete', 1)
                // ->where('cate_state', 1)
                ->value('cate_id');
            if (empty($cate_id)) {
                $cate_data['cate_cid'] = $cid;
                $cate_data['cate_shop_id'] = $shop_id;
                $cate_data['cate_superior_shop_id'] = $shop_id;
                $cate_data['cate_name'] = $goo_add['goo_cate_name'];
                $cate_data['cate_create_time'] = date('Y-m-d H:i:s');
                $cate_data['cate_goods_number'] = 2;
                $cate_data['cate_class'] = 2;
                $cate_id = DB::table('category')->insertGetId($cate_data);
                if (!$cate_id) {
                    DB::rollBack();
                    return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'品类添加失败']);
                }
                unset($cate_data);
            } else {
                $category_addnum = DB::table('category')
                    ->where('cate_shop_id', $shop_id)
                    ->where('cate_id', $cate_id)
                    ->increment('cate_goods_number', 2);
                if (!$category_addnum) {
                    DB::rollBack();
                    return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'品类数量更新失败']);
                }
            }
            $goo_add['goo_cate_id'] = $cate_id;

            // 查询商品品牌是否存在
            $bra_id = DB::table('brand')
                ->where('bra_cid', $cid)
                ->where('bra_shop_id', $shop_id)
                ->where('bra_name', $goo_add['goo_bra_name'])
                // ->where('bra_delete', 1)
                // ->where('bra_state', 1)
                ->value('bra_id');
            if (empty($bra_id)) {
                $bra_data['bra_cid'] = $cid;
                $bra_data['bra_shop_id'] = $shop_id;
                $bra_data['bra_superior_shop_id'] = $shop_id;
                $bra_data['bra_name'] = $goo_add['goo_bra_name'];
                $bra_data['bra_create_time'] = date('Y-m-d H:i:s');
                $bra_data['bra_goods_number'] = 2;
                $bra_data['bra_class'] = 2;
                $bra_data['bra_encode'] = substr($goo_add['goo_goods_encode'], 1, 2);
                $bra_id = DB::table('brand')->insertGetId($bra_data);
                if (!$bra_id) {
                    DB::rollBack();
                    return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'新品牌添加失败']);
                }
                unset($bra_data);
            } else {
                $brand_addnum = DB::table('brand')
                    ->where('bra_shop_id', $shop_id)
                    ->where('bra_id', $bra_id)
                    ->increment('bra_goods_number', 2);
                if (!$brand_addnum) {
                    DB::rollBack();
                    return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'品牌数量更新失败']);
                }
            }
            $goo_add['goo_bra_id'] = $bra_id;
            if ($goo_add['goo_bra_id']) {
                // 品牌系列
                if (!empty($goo_add['goo_brse_name'])) {
                    $brse_id = DB::table('brand_serie')
                        ->where('brse_cid', $cid)
                        ->where('brse_shop_id', $shop_id)
                        ->where('brse_bra_id', $goo_add['goo_bra_id'])
                        ->where('brse_name', $goo_add['goo_brse_name'])
                        // ->where('brse_delete', 1)
                        // ->where('brse_state', 1)
                        ->value('brse_id');
                    if (empty($brse_id)) {
                        $brse_data['brse_cid'] = $cid;
                        $brse_data['brse_shop_id'] = $shop_id;
                        $brse_data['brse_superior_shop_id'] = $shop_id;
                        $brse_data['brse_bra_id'] = $goo_add['goo_bra_id'];
                        $brse_data['brse_cate_id'] = $cate_id;
                        $brse_data['brse_name'] = $goo_add['goo_brse_name'];
                        $brse_data['brse_create_time'] = date('Y-m-d H:i:s');
                        $brse_data['brse_goods_number'] = 2;
                        $brse_data['brse_class'] = 2;
                        $brse_data['brse_encode'] = substr($goo_add['goo_goods_encode'], 3, 2);
                        $brse_id = DB::table('brand_serie')->insertGetId($brse_data);
                        if (!$brse_id) {
                            DB::rollBack();
                            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'系列添加失败']);
                        }
                        unset($brse_data);
                    } else {
                        $brand_serie_addnum = DB::table('brand_serie')
                            ->where('brse_shop_id', $shop_id)
                            ->where('brse_id', $brse_id)
                            ->increment('brse_goods_number', 2);
                        if (!$brand_serie_addnum) {
                            DB::rollBack();
                            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'系列数量更新失败']);
                        }
                    }
                    $goo_add['goo_brse_id'] = $brse_id;
                } else {
                    $goo_add['goo_brse_id'] = 0; //品牌系列id
                }
            } else {
                DB::rollBack();
                return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'请选择所属品牌']);
            }

            $goo_add['goo_class'] = 2;
            $goo_add['goo_type'] = 1;   //1正常商品2赠品商品3活动商品4旧货商品
            $goo_add['goo_fid'] = 0;
            $goo_add['goo_system_code'] = str_pad($cid, '4', '0', STR_PAD_RIGHT) . str_pad($shop_id, '5', '0', STR_PAD_RIGHT) . rand(10, 99) . rand(100000000, 999999999); //系统编码
            unset($goo_add['goo_brse_name']);
            $goo_id = DB::table('goods')->insertGetId($goo_add);
            // 添加旧货商品
            $goo_add['goo_type'] = 4; //1正常商品2赠品商品3活动商品4旧货商品
            $goo_add['goo_fid'] = $goo_id;
            $goo_add['goo_system_code'] = str_pad($cid, '4', '0', STR_PAD_RIGHT) . str_pad($shop_id, '5', '0', STR_PAD_RIGHT) . rand(10, 99) . rand(100000000, 999999999); //系统编码
            $junk_res = DB::table('goods')->insertGetId($goo_add);
            if (!$goo_id || !$junk_res) {
                DB::rollBack();
                return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'上传失败']);
            }
            unset($goo_add);
        }
        echo "success";
        DB::commit();
    }

    // 修正库存商品成本单价20210228+系统编码
    public function updateGoods($submit_data, $data)
    {
        // echo 99900;
        DB::beginTransaction();
        $cid = 1; //公司id
        $superior_shop_id = 1; //总店id
        $shop_id = 1; //门店id

        $dates = $this->now_time;

        try {
            $api_token = Crypt::decrypt($submit_data['api_token']);
        } catch (\Exception $e) {
            return response()->json(["code"=>300, 'msg'=>'error', 'data'=>'非法api_token']);
        }

        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($api_token);
        $adm_cid = 1;

        foreach ($data as $key => $value) {
            $edit_data['ense_new_price'] = $value['ense_new_price'];
            if (!empty($value['ense_out_price'])) {
                $edit_data['ense_out_price'] = $value['ense_out_price'];
            } else {
                $edit_data['ense_out_price'] = 0;
            }
            if (!empty($value['ense_new_amount'])) {
                $edit_data['ense_new_amount'] = $value['ense_new_amount'];
            } else {
                $edit_data['ense_new_amount'] = '';
            }
            $edit_res = DB::table('enters_sells_saves_price_total')
                ->where('ense_goo_number', $value['ense_goo_number'])
                ->update($edit_data);
            unset($edit_data);
            unset($edit_res);
        }
        echo 333;
        DB::commit();
    }

    // 新增盘库单
    public function addStock($submit_data, $data)
    {
        // echo 99900;
        DB::beginTransaction();
        $cid = 1; //公司id
        $superior_shop_id = 1; //总店id
        $shop_id = 1; //门店id
        // $ware_id = 151;//X1总部仓
        // $ware_id = 152;//X2仙岳仓
        // $ware_id = 153;//X3前埔仓
        $ware_id = 154; //X6灌口仓
        // $ware_id = 155;//X7同安仓
        $waon_class = 1; //货物仓

        $dates = $this->now_time;

        try {
            $api_token = Crypt::decrypt($submit_data['api_token']);
        } catch (\Exception $e) {
            return response()->json(["code"=>300, 'msg'=>'error', 'data'=>'非法api_token']);
        }

        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($api_token);
        $adm_cid = 1;

        $stocktake_number = 0;  //良品盘点数量
        foreach ($data as $key => $value) {
            // if (empty($value['wago_actual_stock_number'])) {
            //     continue;
            // }
            // 查询商品检索编码是否有对应的系统编码
            $goo_goods_encode = DB::table('enters_sells_saves_price_total')
                ->where('ense_goo_number', $value['wago_goo_number'])
                ->value('ense_new_amount');
            if (!empty($goo_goods_encode)) {
                // 根据系统编码查询对应的商品id
                $goo_id = DB::table('goods')
                    ->where('goo_cid', 0)
                    ->where('goo_shop_id', 0)
                    ->where('goo_type', 1)
                    ->where('goo_delete', 1)
                    ->where('goo_goods_encode', $goo_goods_encode)
                    ->value('goo_id');
            } else {
                $goo_id = DB::table('goods')
                    ->where('goo_cid', 1)
                    ->where('goo_shop_id', 1)
                    ->where('goo_type', 1)
                    ->where('goo_delete', 1)
                    ->where('goo_goods_encode', $value['wago_goo_number'])
                    ->value('goo_id');
            }
            // 新增盘库商品表
            $stgo_data[$key]['stgo_goo_id'] = $goo_id; //商品id
            $stgo_data[$key]['stgo_stocktake_number'] = $value['wago_actual_stock_number']; //良品库存数量
            $stgo_data[$key]['stgo_update_time'] = $dates; //更新时间
            if (!empty($value['wago_actual_stock_number'])) {
                $stocktake_number += $value['wago_actual_stock_number'];
            }
        }
        // 新增盘库单数据
        $stoc_data['stoc_cid'] = $user_info->adm_cid;
        $stoc_data['stoc_shop_id'] = $user_info->adm_shop_id;
        $stoc_data['stoc_superior_shop_id'] = $shop_id;
        $stoc_data['stoc_adm_id'] = $user_info->adm_id;
        $stoc_data['stoc_storage_number'] = 'P' . truncateFill($user_info->adm_shop_id, 2) . date('mdHis') . truncateFill($user_info->adm_id, 2) . rand(10000, 99999); //盘库单号
        $stoc_data['stoc_type'] = 1; //类型：1盘盈2盘亏3盘平
        $stoc_data['stoc_differ_number'] = $stocktake_number; //损益数量
        $stoc_data['stoc_state'] = 2; //状态1保存/待提交2提交/待审核3通过4驳回
        $stoc_data['stoc_ware_id'] = $ware_id; //仓库id
        $stoc_data['stoc_make_time'] = $dates;
        $stoc_data['stoc_waon_class'] = $waon_class; //仓库类别
        $stoc_data['stoc_manner'] = 2; //盘库方式：1部分盘2通盘
        $stoc_data['stoc_create_time'] = $dates; //创建时间
        // 新增盘库单
        $stoc_res =  DB::table('stocktake')->insertGetId($stoc_data);
        foreach ($stgo_data as $key => $value) {
            $stgo_data[$key]['stgo_stoc_id'] = $stoc_res;
        }
        $stgo_res =  DB::table('stocktake_goods')->insert($stgo_data);
        unset($stgo_data);
        unset($stoc_data);
        echo 333;
        DB::commit();
    }

    // 新增盘库单，原来的仓库盘少
    public function addOldStock($submit_data, $data)
    {
        DB::beginTransaction();
        $cid = 1; //公司id
        $superior_shop_id = 1; //总店id
        $shop_id = 147; //门店id
        $ware_id = 256; //主仓库
        // $ware_id = 14; //A7同安仓
        // $ware_id = 13;//A6灌口仓
        // $ware_id = 11;//A3前埔仓
        // $ware_id = 10;//A2仙岳仓
        // $ware_id = 9;//A1总部仓
        $waon_class = 1; //货物仓

        $dates = $this->now_time;

        try {
            $api_token = Crypt::decrypt($submit_data['api_token']);
        } catch (\Exception $e) {
            return response()->json(["code"=>300, 'msg'=>'error', 'data'=>'非法api_token']);
        }
        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($api_token);
        $adm_cid = 1;

        $stocktake_number = 0;  //良品盘点数量
        foreach ($data as $key => $value) {
            if(empty($value['goo_goods_encode'])){
                dump($value);
                continue;
            }
            // 查询商品检索编码是否有对应的系统编码
            $goo_id = DB::table('goods')
                // ->where('goo_cid', 1)
                // ->where('goo_shop_id', $shop_id)
                ->where('goo_shop_id', 0)
                ->where('goo_type', 1)
                ->where('goo_delete', 1)
                ->where('goo_goods_encode', $value['goo_goods_encode'])
                // ->where('goo_name', $value['goo_name'])
                ->value('goo_id');
            $add['ense_new_amount'] = $value['goo_goods_encode'];
            $add['ense_new_price'] = $value['goo_price'];
            $add_data_res = DB::table('enters_sells_saves_price_total')->insert($add);
            unset($add);
            // 查询仓库商品数量
            $find_wago_data = DB::table('warehouse_goods')
                ->where('wago_ware_id', $ware_id)
                ->where('wago_class', 1)
                ->where('wago_goo_id', $goo_id)
                ->select('wago_stock_number', 'wago_lock_quantity', 'wago_priority_stock_number', 'wago_priority_lock_quantity', 'wago_unchecked_stock_number')
                ->first();
                
            if (empty($find_wago_data)) {
                $add_data['wago_ware_id'] = $ware_id;
                $add_data['wago_class'] = $waon_class;
                $add_data['wago_goo_id'] = $goo_id;
                $wago_id = DB::table('warehouse_goods')->insert($add_data);
                unset($add_data);
                $find_wago_data = DB::table('warehouse_goods')
                    ->where('wago_ware_id', $ware_id)
                    ->where('wago_class', 1)
                    ->where('wago_goo_id', $goo_id)
                    ->select('wago_stock_number', 'wago_lock_quantity', 'wago_priority_stock_number', 'wago_priority_lock_quantity', 'wago_unchecked_stock_number')
                    ->first();
            }
            
            $wago_stock_number = $find_wago_data->wago_stock_number;
            // if ($wago_stock_number < $value['wago_actual_stock_number']) {
            //     $value['wago_actual_stock_number'] = $wago_stock_number;
            // }
            // 新增盘库商品表
            $stgo_data[$key]['stgo_goo_id'] = $goo_id; //商品id
            $stgo_data[$key]['stgo_stock_number'] = $find_wago_data->wago_stock_number;
            $stgo_data[$key]['stgo_lock_number'] = $find_wago_data->wago_lock_quantity;
            $stgo_data[$key]['stgo_priority_stock_number'] = $find_wago_data->wago_priority_stock_number;
            $stgo_data[$key]['stgo_priority_lock_number'] = $find_wago_data->wago_priority_lock_quantity;
            $stgo_data[$key]['stgo_unchecked_stock_number'] = $find_wago_data->wago_unchecked_stock_number;
            $stgo_data[$key]['stgo_stocktake_number'] =  $value['wago_stock_number']; //良品库存数量
            $stgo_data[$key]['stgo_update_time'] = $dates; //更新时间
            if (!empty($value['wago_stock_number'])) {
                $stocktake_number += $value['wago_stock_number'];
            }
        }
        // 新增盘库单数据
        $stoc_data['stoc_cid'] = $user_info->adm_cid;
        $stoc_data['stoc_shop_id'] = $user_info->adm_shop_id;
        $stoc_data['stoc_superior_shop_id'] = $shop_id;
        $stoc_data['stoc_adm_id'] = $user_info->adm_id;
        $stoc_data['stoc_storage_number'] = 'P' . truncateFill($user_info->adm_shop_id, 2) . date('mdHis') . truncateFill($user_info->adm_id, 2) . rand(10000, 99999); //盘库单号
        $stoc_data['stoc_type'] = 2; //类型：1盘盈2盘亏3盘平
        $stoc_data['stoc_differ_number'] = $stocktake_number; //损益数量
        $stoc_data['stoc_state'] = 2; //状态1保存/待提交2提交/待审核3通过4驳回
        $stoc_data['stoc_ware_id'] = $ware_id; //仓库id
        $stoc_data['stoc_make_time'] = $dates;
        $stoc_data['stoc_waon_class'] = $waon_class; //仓库类别
        $stoc_data['stoc_manner'] = 2; //盘库方式：1部分盘2通盘
        $stoc_data['stoc_create_time'] = $dates; //创建时间
        // 新增盘库单
        $stoc_res =  DB::table('stocktake')->insertGetId($stoc_data);
        foreach ($stgo_data as $key => $value) {
            $stgo_data[$key]['stgo_stoc_id'] = $stoc_res;
        }
        $stgo_res =  DB::table('stocktake_goods')->insert($stgo_data);
        unset($stgo_data);
        unset($stoc_data);
        echo 333;
        DB::commit();
    }

    // 库存商品成本单价和系统编码导入
    public function systemImportGoods($submit_data, $data)
    {
        echo 99900;
        DB::beginTransaction();
        $cid = 1; //公司id
        $superior_shop_id = 1; //总店id
        $shop_id = 1; //门店id

        $dates = $this->now_time;

        try {
            $api_token = Crypt::decrypt($submit_data['api_token']);
        } catch (\Exception $e) {
            return response()->json(["code"=>300, 'msg'=>'error', 'data'=>'非法api_token']);
        }

        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($api_token);
        $adm_cid = 1;

        foreach ($data as $key => $value) {
            $info['ense_shop_id'] = $shop_id;
            $info['ense_goo_name'] = $value['ense_goo_name'];
            $info['ense_goo_number'] = $value['ense_goo_number'];
            $info['ense_system_number'] = $value['ense_system_number'];
            $info['new_end_price'] = $value['new_end_price'];
            $info['ense_time'] = $dates;
            $res = DB::table('enters_sells_saves_price_total')->insert($info);
            unset($info);
            unset($res);
        }
        echo 333;
        DB::commit();
    }

    // 将系统商品绑定门店
    public function SysGoodsToShop(Request $request)
    {
        ignore_user_abort();
        set_time_limit(0);
        //查询所有门店
        $where['shop_id'] = 2;
        $where['shop_state'] = 1;
        $shop_id = DB::table('shop')->where($where)->select('shop_id')->get()->map(function ($value) {
            return (array)$value;
        })->toArray();
        DB::beginTransaction();
        //查询所有系统商品
        $sys_goo = DB::table('goods')->where('goo_shop_id', 0)->select('goo_id')->get()->toArray();
        foreach ($shop_id as $v) {
            $gosa_add = [];
            foreach ($sys_goo as $goo_v) {
                //查询是否存在
                $goo_aff['gosa_goo_id'] = $goo_v->goo_id;
                $goo_aff['gosa_shop_id'] =  $v['shop_id'];
                $goaf_res = DB::table('goods_system_affiliate')->where($goo_aff)->select('gosa_id')->first();
                if (!$goaf_res) {
                    $gosa_add[] = $goo_aff;
                }
            }
            $add_res = DB::table('goods_system_affiliate')->insert($gosa_add);
            if (!$add_res) {
                DB::rollback();
                echo '绑定失败';
            }
        }
        DB::commit();
        echo '绑定完成';
    }

    // 测试方法
    public function testssss(Request $request)
    {
        // $this->kucun();
        // exit;
        // 更改权限表权限id
        // $list = DB::table('role')
        // // ->where('rol_shop_id', 1)
        // ->select('rol_id', 'rol_privilege')
        // ->get();
        // // dump($list);
        // // die;
        // $edit_pri_id = [151, 467];//要删除的权限id
        // // 更改权限表权限id
        // foreach ($list as $key => $value) {
        //     $rol_privilege = explode(',', $value->rol_privilege);
        //     // dump($rol_privilege);die;
        //     foreach ($edit_pri_id as $edit_key => $pri_id) {
        //         // 判断权限id是否在角色id数组中
        //         if (in_array($pri_id, $rol_privilege)) {
        //             $rol_key = array_search($pri_id, $rol_privilege);
        //             // 删除角色id数组中的权限id值
        //             unset($rol_privilege[$rol_key]);
        //         }
        //     }
        //     // 更改新的权限
        //     $edit_data['rol_privilege'] = implode(',', $rol_privilege);
        //     $edit_data['rol_update_time'] = date('Y-m-d H:i:s');
        //     // if ($value->rol_id == 14) {
        //     //     dump($edit_data);
        //     //     die;
        //     // }
        //     $edit_res =  DB::table('role')
        //         ->where('rol_id', $value->rol_id)
        //         ->update($edit_data);
        //     dump($edit_res);
        //     unset($edit_data);
        //     unset($edit_res);
        // }
        // die;
        // $this->editChannelData($request->all());
        // die;
        // $this->order();//调用订单
        // $this->workOrder();//调用工单
        // $this->purchase();//调用采购
        // $this->orders();//调用订单
        // $this->admin();
        // $this->songhuo();//送货
        // $this->shaz();//送货+安装
        // $this->paigong();//外出救援
        // $this->heji();//合计
        // $this->exports();//导出
        // $this->zhengchang();
        // $this->tuihuo();
        // $this->sellStatistic();
        // $this->sellStatistics();
        // $this->exports2();
        // $this->fahuodan();
        // $this->normal();//正常商品导入
        // $this->salesReturn();//退/换货商品导入
        // $this->lockGoodsOrder($request->all());//查询锁定库存商品对应的订单
        // $this->searchService();//查询救援单订单服务项目有金额,工单没有金额
        // $this->recycleOrder();//查询救援单订单服务项目有金额,工单没有金额
        // $this->recedeRecycle();
        // $this->workOrders();//调整订单金额
        // $this->recycle();//查询旧货回收
        // $this->outins();
        // $this->receivable();//查询应收应付数据,调整开单时间
        // $this->searchClient();// 查询订单数据,调整结款明细客户单位id
        // $this->receivable2();//查询应收应付状态为已确认,欠收金额>0的数据
        // $this->accounting();//结款明细已确认,应收应付显示未确认
        // $this->workOrderVoucher();//结款明细生成凭证
        // $this->transferringExport($request);//调拨单导出
        // $this->orders2($request);//调拨单导出
        // $this->order3();//订单/工单客户表,更改业务员id
        // $this->receivable3();//修改应收应付客户单位id
        // $this->order4();//调整订单表仓库id
        // $this->order5();//调整订单商品表仓库id
        // $this->orderBill();//查询订单账单的数据
        // $this->order6();//查询订单账单的数据
        // $this->purchase2();//查询采购单流水
        // $this->changeGoods();//查询调拨单流水
        // $this->diaobodan();//查询调拨单数据
        // $this->thrkd();//查询退换入库单数据
        // $this->fhd();//查询发货单数据
        // $this->dingdan();//查询订单为发货单,是否有发货记录
        // $this->gongdan();//查询工单,是否有发货记录
        // $this->addDiaobo($request);//调拨单出库
        // $this->addDiaobo2($request);//调拨单入库
        // $this->delFhuodan();//删除发货单的数据
        // $this->shipments($request);//根据发货单,生成对应的出入库记录
        // $this->receivable4();//查询账单列表已结款,没有应收应付和结款明细的单据
        // $this->works();//查询工单审核通过,订单服务中的数据
        // $this->order7();//有订单没有工单的数据
        // $this->outins3();//查询流水记录数据主表和子表数量是否一致
        // $this->delTrans();// 撤销删除调拨单流水
        // $this->order8();// 查询订单已完成的数据,没有应收应付
        // $this->purchase3();// 查询采购单已完成,没有生成凭证的单号
        // $this->kucun();//库存调整
        // $this->orderVoucher($request);//订单类型为退货单的生成凭证
        // $this->returnVoucher2();// 工单列表退货单生成凭证
        // $this->sync($request);//结款明细同步U8
        // $this->syncVoucher($request);//业务凭证同步U8
        // $this->order9($request);// 查询1月4-1月11日之间的订单类型为退货单,并且已完成的数据
        // $this->order11();// 查询销售统计的单子买家类型为速电网单
        // $this->order10();// 调整销售统计
        // $this->order13();//速电单子仓库id同步
        // $this->accounting2();// 查询结款明细已确认,应收应付未确认的单子
        // $this->order14();// 查询订单表金额为负的单子
        // $this->work_order();// 查询工单表金额为负的单子
        // $this->voucher();
        // $this->order15();
        // $this->order17($request);// 退货单的应收应付金额为0的数据调整
        // $this->order18();//导出数据
        // $this->order19();
        // $this->order20($request);
        // $this->order21();
        // $this->enters($request);// 统计进销存
        // $this->enters2();// 修正商品流水记录数据
        // $this->workOrderVouchers();//虚拟加盟店生成凭证
        // $this->order22();// 查询凭证列表未同步U8的数据,根据进销存的成本,修正订单商品表成本
        // $this->order25($request);// 查询凭证列表未同步U8的数据,不在销售统计的订单需要同步销售统计
        // $this->work_order4();// 查询速电工单的单据的仓库id
        // $this->order27();// 订单、工单、应收应付这三个地方的客户单位不一致的数据统计调整
        // $this->order28($request);
        // $this->order29($request);
        // $this->order24();// 查询凭证列表未同步U8的数据,不在销售统计的订单需要同步销售统计
        // $this->order30();//已取消的订单在应收应付的列表数据
        // $this->order23();// 查询凭证列表未同步U8的数据,根据进销存的成本,修正销售统计成本
        // $this->order16($request);// 查询凭证列表成本和销售统计成本不一致的
        // $this->order31($request);// 查询凭证列表成本和销售统计成本不一致的
        // $this->warehouse($request);//统计仓库库存数量和进销存库存数量不一致的数据
        // $this->order33();// 订单已取消,销售统计列表还存在的数据
        // $this->daststest($request);// 查询销售统计-销售明细界面的成本为0,跟进销存成本对比,不一致的查询出来
        // $this->goods();// 查询系统商品名称和表格不一致的数据
        // $this->goods2();// 查询系统商品数据,复制旧货商品
        // $this->order26();// 订单金额是正数,应收应付金额是负数的数据统计调整
        // $this->order34();// 统计凭证列表已同步U8的,主表总金额为0,子表金额不为0
        // $this->datas();// 统计销售统计商品id和实际商品id不一致的单子
        // $this->order35();// 统计销售统计商品id和订单商品id不一致的单子
        // $this->order36();// 统计订单为代收账单
        // $this->order12();//查询虚拟加盟店的单子,调整销售统计的数据
        // $this->enters3();// 更改进销存的商品id
        // $this->u8clouds();// 同步客户单位数据到用友系统
        // $this->kucun();//统计库存数量
        // $this->receivables();// 统计账单已结款,应收应付状态是未确认的
        // $this->receivables2();// 统计账单数量和应收应付不一致的数据
        // $this->selectBrandSerie();// 查询品牌系列重复名称
        // $this->selectBrand();// 查询品牌重复名称
        // $this->selectCategory();// 查询品类重复名称
        // $this->importExcelData($request);//导入Excel数据
        // $this->other($request);// 将读取到的Excel表格数据，添加到数据库
        // $this->brandSerie();// 同步品类、品牌和系列关联表
        // $this->shops();// 各个门店同步品类、品牌和系列关联表
        // $this->duiWarehouse(); // 对比两个表格库存的数量
    }

    // 各个门店同步品类、品牌和系列关联表
    public function shops()
    {
        echo "22222";
        // exit;
        ignore_user_abort();
        set_time_limit(0);

        // 查询门店表
        $shop = DB::table('shop')
            ->select('shop_id')
            ->get()->toArray();
        foreach ($shop as $key => $value) {
            // 查询品类数据
            $cate = DB::table('category')
                ->where('cate_shop_id', 0)
                ->select('cate_shop_id', 'cate_goods_number', 'cate_id')
                ->get();
            foreach ($cate as $kk => $vv) {
                $ca['caco_shop_id'] = $value->shop_id;
                $ca['caco_cate_id'] = $vv->cate_id;
                $ca['caco_goods_number'] = $vv->cate_goods_number;
                $caco_id = DB::table('category_correlation')
                    ->where('caco_shop_id', $value->shop_id)
                    ->where('caco_cate_id', $vv->cate_id)
                    ->value('caco_id');
                if (empty($caco_id)) {
                    $res = DB::table('category_correlation')->insert($ca);
                }
            }

            $brand = DB::table('brand')
                ->where('bra_shop_id', 0)
                ->select('bra_id', 'bra_shop_id', 'bra_sequence', 'bra_goods_number')
                ->get();

            foreach ($brand as $kk => $vv) {
                $bra['brco_shop_id'] = $value->shop_id;
                $bra['brco_bra_id'] = $vv->bra_id;
                $bra['brco_goods_number'] = $vv->bra_goods_number;
                $bra['brco_sequence'] = $vv->bra_sequence;
                $brco_id = DB::table('brand_correlation')
                    ->where('brco_shop_id', $value->shop_id)
                    ->where('brco_bra_id', $vv->bra_id)
                    ->value('brco_id');
                if (empty($brco_id)) {
                    $data = DB::table('brand_correlation')->insert($bra);
                }
            }
            $brand_serie = DB::table('brand_serie')
                ->where('brse_shop_id', 0)
                ->select('brse_id', 'brse_shop_id', 'brse_goods_number', 'brse_sequence')
                ->get();

            foreach ($brand_serie as $kk => $vv) {
                $bra_ser['brsc_shop_id'] = $value->shop_id;
                $bra_ser['brsc_brse_id'] = $vv->brse_id;
                $bra_ser['brsc_goods_number'] = $vv->brse_goods_number;
                $bra_ser['brsc_sequence'] = $vv->brse_sequence;
                $brsc_id = DB::table('brand_serie_correlation')
                    ->where('brsc_shop_id', $value->shop_id)
                    ->where('brsc_brse_id', $vv->brse_id)
                    ->value('brsc_id');
                if (empty($brsc_id)) {
                    $brsc_id = DB::table('brand_serie_correlation')->insert($bra_ser);
                }
            }
        }

        // DB::commit();
        echo 'string';
    }

    // 同步品类、品牌和系列关联表
    public function brandSerie()
    {
        echo "22222";
        // exit;
        ignore_user_abort();
        set_time_limit(0);
        // DB::beginTransaction();
        $shop_id = 42;

        $cate = DB::table('categorys')
            ->where(function ($query) use ($shop_id) {
                $query->where('cate_shop_id', 0);
                // ->orwhere('cate_shop_id', $shop_id);
            })
            ->select('cate_shop_id', 'cate_goods_number', 'cate_id', 'cate_shop_id')
            ->get();
        dump($cate);
        exit;
        foreach ($cate as $key => $value) {
            $ca['caco_shop_id'] = $value->cate_shop_id;
            $ca['caco_cate_id'] = $value->cate_id;
            $ca['caco_goods_number'] = $value->cate_goods_number;
            $caco_id = DB::table('category_correlation')
                ->where('caco_shop_id', $value->cate_shop_id)
                ->where('caco_cate_id', $value->cate_id)
                ->value('caco_id');
            if (empty($caco_id)) {
                $res = DB::table('category_correlation')->insert($ca);
            }
        }


        $brand = DB::table('brand')
            ->where(function ($query) use ($shop_id) {
                $query->where('bra_shop_id', 0)
                    ->orwhere('bra_shop_id', $shop_id);
            })
            ->select('bra_id', 'bra_shop_id', 'bra_sequence', 'bra_goods_number')
            ->get();

        foreach ($brand as $key => $value) {
            $bra['brco_shop_id'] = $value->bra_shop_id;
            $bra['brco_bra_id'] = $value->bra_id;
            $bra['brco_goods_number'] = $value->bra_goods_number;
            $bra['brco_sequence'] = $value->bra_sequence;
            $brco_id = DB::table('brand_correlation')
                ->where('brco_shop_id', $value->bra_shop_id)
                ->where('brco_bra_id', $value->bra_id)
                ->value('brco_id');
            if (empty($brco_id)) {
                $data = DB::table('brand_correlation')->insert($bra);
            }
        }
        $brand_serie = DB::table('brand_serie')
            ->where(function ($query) use ($shop_id) {
                $query->where('brse_shop_id', 0)
                    ->orwhere('brse_shop_id', $shop_id);
            })
            ->select('brse_id', 'brse_shop_id', 'brse_goods_number', 'brse_sequence')
            ->get();

        foreach ($brand_serie as $key => $value) {
            $bra_ser['brsc_shop_id'] = $value->brse_shop_id;
            $bra_ser['brsc_brse_id'] = $value->brse_id;
            $bra_ser['brsc_goods_number'] = $value->brse_goods_number;
            $bra_ser['brsc_sequence'] = $value->brse_sequence;
            $brsc_id = DB::table('brand_serie_correlation')
                ->where('brsc_shop_id', $value->brse_shop_id)
                ->where('brsc_brse_id', $value->brse_id)
                ->value('brsc_id');
            if (empty($brsc_id)) {
                $brsc_id = DB::table('brand_serie_correlation')->insert($bra_ser);
            }
        }

        // DB::commit();
        echo 'string';
    }

    // 对比两个表格库存的数量
    public function duiWarehouse()
    {
        ignore_user_abort();
        set_time_limit(0);
        // 导入商品数据
        $data = DB::table('excel_data_cache')->whereIn('exdc_type', [4, 8])->get();
        $data = json_decode($data, true);
        // dump($data);
        // die;
        $data_info = [];
        $luojiazhuang = [];
        $chengxi = [];
        foreach ($data as $key => $value) {
            // dump($value);
            // exit;
            $exdc_data = json_decode($value['exdc_data'], true);
            // dump($exdc_data);
            // exit;
            $data_info[] = $exdc_data;
            if ($value['exdc_type'] == 4) {
                if (isset($luojiazhuang[$exdc_data['goo_goods_encode']])) {
                    $luojiazhuang[$exdc_data['goo_goods_encode']] += $exdc_data['kucunshu'];
                } else {
                    $luojiazhuang[$exdc_data['goo_goods_encode']] = $exdc_data['kucunshu'];
                }
            } elseif ($value['exdc_type'] == 8) {
                if (isset($chengxi[$exdc_data['goo_goods_encode']])) {
                    $chengxi[$exdc_data['goo_goods_encode']] += $exdc_data['kucunshu'];
                } else {
                    $chengxi[$exdc_data['goo_goods_encode']] = $exdc_data['kucunshu'];
                }
            }
        }
        foreach ($luojiazhuang as $kk => $vv) {
            if ($chengxi[$kk] != $vv) {
                dump($kk);
            }
        }
        // dump($luojiazhuang);
        // dump($chengxi);
        echo 99900;
    }

    // 杭州门店导入商品数据
    public function editImportGoods($submit_data, $data)
    {
        echo 99900;
        DB::beginTransaction();
        $cid = 1; //公司id
        $superior_shop_id = 42; //总店id
        $shop_id = 42; //门店id
        $goods_data = [];
        $defeated = [];
        $dates = $this->now_time;
        try {
            $api_token = Crypt::decrypt($submit_data['api_token']);
        } catch (\Exception $e) {
            return response()->json(["code"=>300, 'msg'=>'error', 'data'=>'非法api_token']);
        }

        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($api_token);
        $adm_cid = 1;

        foreach ($data as $key => $value) {
            // dump($value);
            // exit;
            // 根据检索编码查询商品id
            $find_goo_id = DB::table('goods')
                // ->where(function ($query) use ($adm_cid) {
                //     $query->where('goo_cid', 0)
                //         ->orwhere('goo_cid', $adm_cid);
                // })
                // ->where(function ($query) use ($shop_id) {
                //     $query->where('goo_shop_id', 0)
                //         ->orwhere('goo_shop_id', $shop_id);
                // })
                ->where('goo_cid', $adm_cid)
                ->where('goo_shop_id', $shop_id)
                ->where('goo_type', 1)
                ->where('goo_delete', 1)
                ->where('goo_goods_encode', $value['goo_goods_encode'])
                ->select('goo_id', 'goo_goods_encode')
                ->first();
            // dump($find_goo_id);
            if (!empty($value['goo_goods_encode'])) {
                // 判断商品是否存在
                $goo_id = DB::table('goods')
                    // ->where(function ($query) use ($adm_cid) {
                    //     $query->where('goo_cid', 0)
                    //         ->orwhere('goo_cid', $adm_cid);
                    // })
                    // ->where(function ($query) use ($shop_id) {
                    //     $query->where('goo_shop_id', 0)
                    //         ->orwhere('goo_shop_id', $shop_id);
                    // })
                    ->where('goo_cid', $adm_cid)
                    ->where('goo_shop_id', $shop_id)
                    ->where('goo_type', 1)
                    ->where('goo_delete', 1)
                    ->where('goo_class', 1)
                    ->where('goo_goods_encode', $value['goo_goods_encode'])
                    ->value('goo_id');
                // dump($goo_id);
                if (empty($goo_id)) {
                } else {
                    // 修改商品名称
                    $edit_data['goo_name'] = $value['goo_name'];
                    $res = DB::table('goods')
                        ->where('goo_type', 1)
                        ->where('goo_id', $goo_id)
                        ->update($edit_data);
                    // 旧货商品
                    $junk_goo_id = DB::table('goods')
                        ->where('goo_fid', $goo_id)
                        ->where('goo_type', 4)
                        ->value('goo_id');
                    if (!empty($junk_goo_id)) {
                        $edit_data['goo_name'] = $value['goo_name'];
                        $junk_res = DB::table('goods')
                            ->where('goo_id', $junk_goo_id)
                            ->update($edit_data);
                    }
                }
            }
        }
        echo 333;
        dump($defeated);
        DB::commit();
    }

    // 杭州门店导入商品数据
    public function hzImportGoods($submit_data, $data)
    {
        echo 99900;
        DB::beginTransaction();
        $cid = 1; //公司id
        $superior_shop_id = 42; //总店id
        $shop_id = 42; //门店id
        $goods_data = [];
        $defeated = [];
        // $dates = date('Y-m-d H:i:s');
        $dates = $this->now_time;
        try {
            $api_token = Crypt::decrypt($submit_data['api_token']);
        } catch (\Exception $e) {
            return response()->json(["code"=>300, 'msg'=>'error', 'data'=>'非法api_token']);
        }

        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($api_token);
        $adm_cid = 1;

        // $user_info = Common::getUserInfo($submit_data['api_token']);
        // dump($user_info);die;
        foreach ($data as $key => $value) {
            // dump($value);
            // exit;
            // 品牌
            $bra_id = DB::table('brand')
                ->where(function ($query) use ($adm_cid) {
                    $query->where('bra_cid', 0)
                        ->orwhere('bra_cid', $adm_cid);
                })
                ->where(function ($query) use ($shop_id) {
                    $query->where('bra_shop_id', 0)
                        ->orwhere('bra_shop_id', $shop_id);
                })
                ->where('bra_delete', 1)
                ->where('bra_name', $value['brand_name'])
                ->value('bra_id');
            if (empty($bra_id)) {
                $bra_data['bra_cid'] = $cid;
                $bra_data['bra_shop_id'] = $shop_id;
                $bra_data['bra_superior_shop_id'] = $superior_shop_id;
                $bra_data['bra_name'] = $value['brand_name'];
                $bra_data['bra_create_time'] = $dates;
                $bra_data['bra_goods_number'] = 2;
                $bra_data['bra_update_time'] = $dates;
                $bra_id = DB::table('brand')->insertGetId($bra_data);
            } else {
                DB::table('brand')->where('bra_id', $bra_id)->increment('bra_goods_number', 2);
            }
            // 品牌系列
            $brse_id = DB::table('brand_serie')
                ->where(function ($query) use ($adm_cid) {
                    $query->where('brse_cid', 0)
                        ->orwhere('brse_cid', $adm_cid);
                })
                ->where(function ($query) use ($shop_id) {
                    $query->where('brse_shop_id', 0)
                        ->orwhere('brse_shop_id', $shop_id);
                })
                ->where('brse_delete', 1)
                ->where('brse_name', $value['brse_name'])
                ->value('brse_id');
            if (empty($brse_id)) {
                $brse_data['brse_cid'] = $cid;
                $brse_data['brse_shop_id'] = $shop_id;
                $brse_data['brse_superior_shop_id'] = $superior_shop_id;
                $brse_data['brse_bra_id'] = $bra_id; //品牌id
                $brse_data['brse_cate_id'] = 1499; //品类id
                $brse_data['brse_name'] = $value['brse_name'];
                $brse_data['brse_create_time'] = $dates;
                $brse_data['brse_goods_number'] = 2;
                $brse_data['brse_update_time'] = $dates;
                $brse_id = DB::table('brand_serie')->insertGetId($brse_data);
            } else {
                DB::table('brand_serie')->where('brse_id', $brse_id)->increment('brse_goods_number', 2);
            }
            // 根据检索编码查询商品id
            $find_goo_id = DB::table('goods')
                ->where(function ($query) use ($adm_cid) {
                    $query->where('goo_cid', 0)
                        ->orwhere('goo_cid', $adm_cid);
                })
                ->where(function ($query) use ($shop_id) {
                    $query->where('goo_shop_id', 0)
                        ->orwhere('goo_shop_id', $shop_id);
                })
                ->where('goo_type', 1)
                ->where('goo_delete', 1)
                ->where('goo_goods_encode', $value['goo_goods_encode'])
                ->select('goo_id', 'goo_goods_encode')
                ->first();
            // dump($find_goo_id);
            if (!empty($find_goo_id->goo_id)) {
                $goo_id = $find_goo_id->goo_id;
            } else {
                // dump($value['goo_goods_encode']);
                // exit;
                $info['goo_cid'] = $cid;
                $info['goo_superior_shop_id'] = $superior_shop_id;
                $info['goo_shop_id'] = $shop_id;
                $info['goo_cate_name'] = '蓄电池';
                $info['goo_cate_id'] = 1499;
                $info['goo_bra_name'] = $value['brand_name']; //品牌名称
                $info['goo_bra_id'] = $bra_id; //品牌id
                $info['goo_brse_id'] = $brse_id; //品牌系列id
                $info['goo_name'] = $value['goo_name'];
                $info['goo_goods_encode'] = $value['goo_goods_encode'];
                $info['goo_unit'] = $value['danwei'];
                $info['goo_price'] = $value['goo_price'];
                $info['goo_wholesale_price'] = $value['goo_wholesale_price'];
                $info['goo_update_time'] = $dates;
                if (!empty($value['goo_goods_encode'])) {
                    // 判断商品是否存在
                    $goo_id = DB::table('goods')
                        ->where(function ($query) use ($adm_cid) {
                            $query->where('goo_cid', 0)
                                ->orwhere('goo_cid', $adm_cid);
                        })
                        ->where(function ($query) use ($shop_id) {
                            $query->where('goo_shop_id', 0)
                                ->orwhere('goo_shop_id', $shop_id);
                        })
                        ->where('goo_type', 1)
                        ->where('goo_delete', 1)
                        ->where('goo_class', 1)
                        ->where('goo_goods_encode', $value['goo_goods_encode'])
                        ->value('goo_id');
                    // dump($goo_id);
                    if (empty($goo_id)) {
                        $info['goo_type'] = 1; //商品类型 1正常商品2赠品商品3活动商品4旧货商品
                        $info['goo_fid'] = 0;
                        $info['goo_system_code'] = str_pad($cid, '4', '0', STR_PAD_RIGHT) . str_pad($shop_id, '5', '0', STR_PAD_RIGHT) . rand(10, 99) . rand(100000000, 999999999); //系统编码
                        $goo_id = DB::table('goods')->insertGetId($info);
                        // 添加旧货商品
                        $info['goo_type'] = 4; //1正常商品2赠品商品3活动商品4旧货商品
                        $info['goo_fid'] = $goo_id;
                        $info['goo_system_code'] = str_pad($cid, '4', '0', STR_PAD_RIGHT) . str_pad($shop_id, '5', '0', STR_PAD_RIGHT) . rand(10, 99) . rand(100000000, 999999999); //系统编码
                        $junk_res = DB::table('goods')->insertGetId($info);
                    } else {
                        // 商品数量
                        $num = 1;
                        $info['goo_type'] = 1;   //1正常商品2赠品商品3活动商品4旧货商品
                        $info['goo_update_time'] = $dates;
                        $res = DB::table('goods')
                            ->where('goo_type', 1)
                            ->where('goo_id', $goo_id)
                            ->update($info);
                        // 旧货商品
                        $junk_goo_id = DB::table('goods')
                            ->where('goo_fid', $goo_id)
                            ->where('goo_type', 4)
                            ->value('goo_id');
                        if (!empty($junk_goo_id)) {
                            $info['goo_type'] = 4;   //1正常商品2赠品商品3活动商品4旧货商品
                            $junk_res = DB::table('goods')
                                ->where('goo_id', $junk_goo_id)
                                ->update($info);
                        } else {
                            $num += 1;
                            $info['goo_type'] = 4; //1正常商品2赠品商品3活动商品4旧货商品
                            $info['goo_fid'] = $goo_id;
                            $info['goo_system_code'] = str_pad($cid, '4', '0', STR_PAD_RIGHT) . str_pad($shop_id, '5', '0', STR_PAD_RIGHT) . rand(10, 99) . rand(100000000, 999999999); //系统编码
                            $junk_res = DB::table('goods')->insertGetId($info);
                        }
                    }
                }
                // 品类
                /* $cate_id = DB::table('category')
                    // ->where('cate_cid', $cid)
                    // ->where('cate_shop_id', $shop_id)
                    // ->where('cate_superior_shop_id', $superior_shop_id)
                    // ->where('cate_rank', 1)
                    // ->where('cate_delete', 1)
                    ->where('cate_id', 1275)
                    ->value('cate_id');
                if (empty($cate_id)) {
                } else {
                    DB::table('category')->where('cate_id', $cate_id)->increment('cate_goods_number', 2);
                } */
                unset($cate_id);
                unset($info);
            }
        }
        echo 333;
        dump($defeated);
        DB::commit();
    }

    // 杭州门店导入仓库数据
    public function hzImportWarehouse($submit_data, $data)
    {
        echo 99900;
        DB::beginTransaction();
        $cid = 1; //公司id
        $superior_shop_id = 42; //总店id
        $shop_id = 42; //门店id
        $goods_data = [];
        $defeated = [];
        $dates = $this->now_time;
        try {
            $api_token = Crypt::decrypt($submit_data['api_token']);
        } catch (\Exception $e) {
            return response()->json(["code"=>300, 'msg'=>'error', 'data'=>'非法api_token']);
        }

        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($api_token);
        $adm_cid = 1;

        // $user_info = Common::getUserInfo($submit_data['api_token']);
        // dump($user_info);die;
        $ware_id = 119; //仓库id
        foreach ($data as $key => $value) {
            // dump($value);
            // exit;
            // 根据检索编码查询商品id
            $find_goo_id = DB::table('goods')
                ->where(function ($query) use ($adm_cid) {
                    $query->where('goo_cid', 0)
                        ->orwhere('goo_cid', $adm_cid);
                })
                ->where(function ($query) use ($shop_id) {
                    $query->where('goo_shop_id', 0)
                        ->orwhere('goo_shop_id', $shop_id);
                })
                ->where('goo_type', 1)
                ->where('goo_delete', 1)
                ->where('goo_goods_encode', $value['goo_goods_encode'])
                ->select('goo_id', 'goo_goods_encode')
                ->first();
            // dump($find_goo_id);
            if (!empty($find_goo_id->goo_id)) {
                $goo_id = $find_goo_id->goo_id;
                // 添加商品库存，查询仓库id
                if (empty($ware_id)) {
                } else {
                    $value['kucunshu'] = $value['kucunshu'] ? $value['kucunshu'] : 0; //库存数量
                    //判断仓库里是否有此商品
                    $stock_numbers = $value['kucunshu']; //良品库存
                    $res = DB::table('warehouse_onhand')
                        ->where('waon_ware_id', $ware_id)
                        ->where('waon_class', 1)
                        ->increment('waon_all_amount', $stock_numbers);
                    $res = DB::table('warehouse_onhand')
                        ->where('waon_ware_id', $ware_id)
                        ->where('waon_class', 1)
                        ->increment('waon_stock_fine_amount', $stock_numbers);
                    if (empty($res)) {
                        $value['yuanyin'] = '仓库库存添加失败';
                        array_push($defeated, $value);
                        continue;
                    }
                    $wago_id = DB::table('warehouse_goods')
                        ->where('wago_ware_id', $ware_id)
                        ->where('wago_goo_id', $goo_id)
                        ->where('wago_class', 1)
                        ->value('wago_id');

                    if (empty($wago_id)) {
                        // dump($wago_id.'----');
                        // 仓库内没有商品，添加商品
                        $warehouse_goods['wago_ware_id'] = $ware_id; //仓库
                        $warehouse_goods['wago_class'] = 1;
                        $warehouse_goods['wago_goo_id'] = $goo_id; //商品
                        $warehouse_goods['wago_stock_number'] = $stock_numbers; //良品库存
                        $warehouse_goods['wago_update_time'] = $dates; //更新时间
                        $wago_res = DB::table('warehouse_goods')->insert($warehouse_goods);
                        if (empty($wago_res)) {
                            $value['yuanyin'] = '添加仓库商品失败';
                            array_push($defeated, $value);
                            continue;
                        }
                        unset($warehouse_goods);
                    } else {
                        // dump($wago_id.'====');
                        // 仓库内已经有商品了，更改库存数量
                        $edit_data['wago_stock_number'] = $stock_numbers;
                        $edit_data['wago_update_time'] = $dates;
                        $res = DB::table('warehouse_goods')
                            ->where('wago_ware_id', $ware_id)
                            ->where('wago_goo_id', $goo_id)
                            ->where('wago_class', 1)
                            ->update($edit_data);
                        dump($res);
                        if (empty($res)) {
                            $value['yuanyin'] = '修改仓库商品失败库存失败';
                            array_push($defeated, $value);
                            continue;
                        }
                    }
                }
                unset($goo_id);
                unset($find_goo_id);
            }
        }
        echo 333;
        dump($defeated);
        DB::commit();
    }

    // 统计账单数量和应收应付不一致的数据
    public function receivables2()
    {
        ignore_user_abort();
        set_time_limit(0);

        // 查询账单已结款的
        $find_orbi_data = DB::table('order_bill')
            ->where('orbi_cid', 1)
            ->where('orbi_superior_shop_id', 1)
            ->where('orbi_shop_id', 1)
            ->where('orbi_state', 2)
            ->select('orbi_id', 'orbi_number', 'orbi_order_amount')
            ->get()->toArray();
        foreach ($find_orbi_data as $key => $value) {
            $find_recr_data = DB::table('receivable_credit')
                ->where('recr_cid', 1)
                ->where('recr_shop_id', 1)
                ->where('recr_shop_superior_id', 1)
                ->where('recr_type', 3)
                ->where('recr_account_type', 5)
                ->where('recr_state', 2)
                ->where('recr_original_id', $value->orbi_id)
                ->where('recr_original_number', $value->orbi_number)
                ->select('recr_id', 'recr_original_id', 'recr_original_number')
                ->get()->toArray();
            // dump($find_recr_data);
            // exit;
            $count_array = count($find_recr_data);

            if ($value != $count_array) {
                dump($value->orbi_number);
            }
            unset($find_recr_data);
        }
        echo "string";
        exit;
    }

    // 统计账单已结款,应收应付状态是未确认的
    public function receivables()
    {
        ignore_user_abort();
        set_time_limit(0);

        // 查询账单状态为已结款的
        $find_orbi_data = DB::table('order_bill')
            ->where('orbi_cid', 1)
            ->where('orbi_superior_shop_id', 1)
            ->where('orbi_shop_id', 1)
            ->where('orbi_state', 2)
            ->select('orbi_id', 'orbi_cid', 'orbi_superior_shop_id', 'orbi_shop_id', 'orbi_number')
            ->get()->toArray();
        foreach ($find_orbi_data as $key => $value) {
            $find_recr_data = DB::table('receivable_credit')
                ->where('recr_cid', $value->orbi_cid)
                ->where('recr_shop_id', $value->orbi_shop_id)
                ->where('recr_original_id', $value->orbi_id)
                ->where('recr_original_number', $value->orbi_number)
                ->where('recr_state', 1)
                ->select('recr_original_id', 'recr_original_number', 'recr_settle_price')
                ->first();
            if ($find_recr_data) {
                dump($find_recr_data->recr_original_number);
            }
        }
        echo '12';
    }

    // 同步客户单位数据到用友系统
    public function u8cloud()
    {
        ignore_user_abort();
        set_time_limit(0);
        // echo 888;
        // die;
        // 调用u8系统接口，将客商数据传到用友系统上
        $yongyou = new YongYouController;
        $error_data = [];

        $user_info['adm_cid'] = 1;
        $user_info['adm_shop_id'] = 1; //门店id
        // 查询客户单位数据
        $list_data = DB::table('channel_unit as u')
            ->where('u.chun_cid', $user_info['adm_cid'])
            ->where('u.chun_shop_id', $user_info['adm_shop_id'])
            ->where('u.chun_state', '<>', 3)
            // ->where('u.chun_id', '>=', 6801)
            // ->where('u.chun_id', '<', 8789)
            ->select('chun_id', 'chun_search_letter', 'chun_unit_name')
            ->get();

        // 1. 通过用友的查询接口，查询用友系统这个科目是否已经存在
        $yongyou = new YongYouController;

        foreach ($list_data as $key => $value) {
            $u8cloud_data['cbdocvo'][0]['parentvo']['custname'] = $value->chun_unit_name; //是 客商名称
            $u8cloud_data['cbdocvo'][0]['parentvo']['mnecode'] = $value->chun_search_letter; //否 助记码
            // 调用u8系统接口
            $curl_return = $yongyou->u8cloudApi('客商基本档案查询', $u8cloud_data);
            // dump($curl_return);
            $success_data = json_decode($curl_return['data'], true);
            // dump($success_data['datas']);
            if (isset($success_data)) {
                foreach ($success_data['datas'] as $kk => $vv) {
                    dump($vv['parentvo']['custcode']); //编码,截取前几位,符合前几位的判断
                    $initial = substr($vv['parentvo']['custcode'], 0, 4);
                    // dump($initial);
                    // if ($initial == 'ZKH1') {
                    $isset_res = DB::table('channel_unit_edit')
                        ->where('chun_search_letter', $vv['parentvo']['custcode'])
                        ->where('chun_search_letter', $vv['parentvo']['custcode'])
                        ->first(['chun_id']);
                    if (empty($isset_res)) {
                        $add_data['chun_cid'] = 1;
                        $add_data['chun_superior_shop_id'] = 1;
                        $add_data['chun_shop_id'] = 1;
                        $add_data['chun_search_letter'] = $vv['parentvo']['custcode'];
                        $add_data['chun_unit_name'] = $vv['parentvo']['custname'];
                        $add_id = DB::table('channel_unit_edit')->insert($add_data);
                        dump($add_id);
                        unset($add_data);
                    }
                    // }
                    // dump($vv['parentvo']['custname']);
                }
                // die;
                unset($u8cloud_data);
                unset($curl_return);
            }
        }
    }

    // 更改进销存的商品id
    public function enters3()
    {
        ignore_user_abort();
        set_time_limit(0);

        $adm_cid = 1;
        $shop_id = 42;

        $find_ense_data = DB::table('enters_sells_saves')
            ->where('ense_shop_id', 42)
            ->where('ense_goo_id', 0)
            ->select('ense_id', 'ense_goo_number', 'ense_shop_id')
            ->get()->toArray();
        foreach ($find_ense_data as $key => $value) {
            // 查询商品表的数据
            $goo_id = DB::table('goods')
                ->where(function ($query) use ($adm_cid) {
                    $query->where('goo_cid', 0)
                        ->orwhere('goo_cid', $adm_cid);
                })
                ->where(function ($query) use ($shop_id) {
                    $query->where('goo_shop_id', 0)
                        ->orwhere('goo_shop_id', $shop_id);
                })
                ->where('goo_goods_encode', $value->ense_goo_number)
                ->where('goo_type', 1)
                ->select('goo_id', 'goo_name', 'goo_unit')
                ->first();
            if ($goo_id) {
                $edit_data['ense_goo_id'] = $goo_id->goo_id;
                $edit_data['ense_goo_name'] = $goo_id->goo_name;
                $edit_data['ense_goo_unit'] = $goo_id->goo_name;
                $edit_res = Db::table('enters_sells_saves')
                    ->where('ense_id', $value->ense_id)
                    ->update($edit_data);
                dump($edit_res);
                unset($edit_data);
                unset($edit_res);
            }
        }
        echo "string";
    }

    // 速电系统商品导入
    public function sdImportGoods($submit_data, $data)
    {
        echo 99900;
        DB::beginTransaction();
        $sygo_system_cid = 1; //公司id
        $goods_data = [];
        // $dates = date('Y-m-d H:i:s');
        $dates = $this->now_time;
        foreach ($data as $key => $value) {
            // dump($value);
            // exit;
            // 根据系统商品id判断系统是否存在
            $sygo_id = DB::table('system_goods')
                ->where('sygo_system_cid', $sygo_system_cid)
                ->where('sygo_system_goo_id', $value['sygo_system_goo_id'])
                ->where('sygo_delete', 1)
                ->select('sygo_id', 'sygo_system_goo_id', 'sygo_name')
                ->first();
            // dump($find_goo_id);
            if (!empty($sygo_id->sygo_system_goo_id)) {
                // if ($sygo_id->sygo_name != $value['standard_name']) {
                if ($sygo_id->sygo_name != $value['sygo_name']) {
                    $goods_data[$key]['sygo_system_goo_id'] = $sygo_id->sygo_system_goo_id;
                    $goods_data[$key]['sygo_name'] = $sygo_id->sygo_name;
                    $goods_data[$key]['biaoge_system_goo_id'] = $value['sygo_system_goo_id'];
                    // $goods_data[$key]['biaoge_sygo_names'] = $value['standard_name'];
                    $goods_data[$key]['biaoge_sygo_names'] = $value['sygo_name'];
                }
                // 修改第三方商品编号
                if ($value['unified_code'] == '无') {
                    continue;
                }
                $edit_data['sygo_goods_code'] = $value['unified_code'];
                $edit_res = DB::table('system_goods')
                    ->where('sygo_id', $sygo_id->sygo_id)
                    ->update($edit_data);
                unset($edit_data);
                unset($edit_res);
            } else {
                $info['sygo_system_cid'] = $sygo_system_cid; //公司id
                $info['sygo_system_goo_id'] = $value['sygo_system_goo_id']; //第三方系统商品id
                $info['sygo_bra_name'] = $value['sygo_bra_name']; //品牌名称
                $info['sygo_brse_name'] = $value['sygo_brse_name']; //品牌系列名称
                $info['sygo_name'] = $value['sygo_name']; //商品名称
                $info['sygo_goods_code'] = $value['unified_code']; //第三方商品编码
                if (empty($value['sygo_system_goo_id'])) {
                    // dump($value['sygo_system_goo_id']);
                    $sygo_id = DB::table('system_goods')->insert($info);
                    unset($sygo_id);
                }
                unset($info);
            }
        }
        echo 333;
        // dump($goods_data);
        DB::commit();
    }

    // 查询虚拟加盟店的单子,调整销售统计的数据
    public function order12()
    {
        ignore_user_abort();
        set_time_limit(0);

        $find_data = DB::table('data_statistical')
            ->where('dast_orcl_shipment_party', 4)
            ->where('dast_ord_form_type', 2)
            ->select('dast_id', 'dast_ord_id', 'dast_order_number', 'dast_goo_id', 'dast_goo_type', 'dast_waon_class')
            ->get()->toArray();
        foreach ($find_data as $key => $value) {
            // 根据id和单号查询对应的数据
            $find_ord_data = DB::table('work_good as wogo')
                ->leftjoin('work_order as wor', 'wor.wor_id', '=', 'wogo.wogo_wor_id')
                ->where('wor_order_id', $value->dast_ord_id)
                ->where('wor_order_number', $value->dast_order_number)
                ->where('wor_delete', 1)
                ->where('wor_collection_bill', 1)
                ->where('wogo_waon_class', $value->dast_waon_class)
                ->where('wogo_goo_id', $value->dast_goo_id)
                ->where('wogo_goo_type', $value->dast_goo_type)
                ->where('wor_state', '!=', 11)
                ->select('wogo_goo_price')
                ->first();
            if ($find_ord_data) {
                $edit_data['dast_goo_cost'] = $find_ord_data->wogo_goo_price;
                $edit_res = DB::table('data_statistical')
                    ->where('dast_id', $value->dast_id)
                    ->update($edit_data);
                dump($edit_res);
                unset($edit_data);
                unset($find_ord_data);
            }
        }
        unset($find_data);
        echo 'string';
    }

    // 统计订单为代收账单
    public function order36()
    {
        ignore_user_abort();
        set_time_limit(0);

        // 查询订单表
        $find_ord_data = DB::table('order')
            ->where('ord_cid', 1)
            ->where('ord_superior_shop_id', 1)
            ->where('ord_shop_id', 1)
            ->where('ord_delete', 1)
            ->where('ord_collection_bill', 2)
            ->select('ord_id', 'ord_order_number')
            ->get()->toArray();
        dump($find_ord_data);
        exit;
        foreach ($find_ord_data as $key => $value) {
            // 查询凭证列表的数据
            $find_vore_data = DB::table('data_statistical')
                ->where('dast_ord_id', $value->ord_id)
                ->select('dast_ord_id', 'dast_order_number')
                ->first();
            if ($find_vore_data) {
                dump($value->ord_order_number);
            }
            unset($find_vore_data);
        }
        echo "string";
        exit;
    }

    // 统计销售统计商品id和订单商品id不一致的单子
    public function order35()
    {
        ignore_user_abort();
        set_time_limit(0);

        // 查询销售统计表
        $find_dast_data = DB::table('data_statistical')
            ->where('dast_cid', 1)
            ->where('dast_shop_id', 1)
            ->where('dast_superior_shop_id', 1)
            ->where('dast_order_type', 1)
            ->where('dast_goo_id', '!=', 0)
            ->where('dast_ord_delete', 1)
            ->where('dast_type', '!=', 3)
            // ->where('dast_id', '>', 0)
            // ->where('dast_id', '<=', 20000)
            ->select('dast_id', 'dast_ord_id', 'dast_order_number', 'dast_goo_id', 'dast_actual_goo_id', 'dast_orgo_id')
            ->get()->toArray();
        // dump($find_dast_data);
        // exit;
        $goods = [];
        foreach ($find_dast_data as $key => $value) {
            // 查询订单商品表的数据
            $orgo_goo_id = DB::table('order_goods')
                ->where('orgo_id', $value->dast_orgo_id)
                ->where('orgo_ord_id', $value->dast_ord_id)
                ->where('orgo_order_number', $value->dast_order_number)
                ->value('orgo_goo_id');
            if ($value->dast_goo_id != $orgo_goo_id) {
                $goods[$key]['dast_order_number'] = $value->dast_order_number;
                $goods[$key]['dast_goo_id'] = $value->dast_goo_id;
                $goods[$key]['orgo_goo_id'] = $orgo_goo_id;
            }
        }
        dump($goods);
    }

    // 统计销售统计商品id和实际商品id不一致的单子
    public function datas()
    {
        ignore_user_abort();
        set_time_limit(0);

        // 查询销售统计表
        $find_dast_data = DB::table('data_statistical as dast')
            // ->leftjoin('order as ord', 'ord.ord_id', '=', 'dast_ord_id')
            ->where('dast_cid', 1)
            ->where('dast_shop_id', 1)
            ->where('dast_superior_shop_id', 1)
            ->where('dast_order_type', 1)
            ->where('dast_goo_id', '!=', 0)
            ->where('dast_ord_delete', 1)
            // ->where('dast_ord_form_type', 1)
            ->where('dast_type', '!=', 3)
            // ->where('dast_id', '>', 0)
            // ->where('dast_id', '<=', 20000)
            ->select('dast_id', 'dast_ord_id', 'dast_order_number', 'dast_goo_id', 'dast_actual_goo_id', 'dast_orgo_id')
            ->get()->toArray();
        // dump($find_dast_data);
        // exit;
        $goods = [];
        foreach ($find_dast_data as $key => $value) {
            if ($value->dast_goo_id != $value->dast_actual_goo_id) {
                // if ($value->dast_actual_goo_id != 0) {
                // dump($value->dast_goo_id);
                // dump($value->dast_actual_goo_id);
                // dump($value->dast_order_number);
                $goods[$key]['dast_order_number'] = $value->dast_order_number;
                $goods[$key]['dast_goo_id'] = $value->dast_goo_id;
                $goods[$key]['dast_actual_goo_id'] = $value->dast_actual_goo_id;
                // }
            }
        }
        dump($goods);
    }

    // 统计凭证列表已同步U8的,主表总金额为0,子表金额不为0
    public function order34()
    {
        ignore_user_abort();
        set_time_limit(0);

        // 查询订单表
        $find_ord_data = DB::table('order as a')
            ->leftJoin('order_client as b', 'b.orcl_ord_id', '=', 'a.ord_id')
            ->leftJoin('voucher_receipts as c', 'c.vore_ord_id', '=', 'a.ord_id')
            ->where('ord_cid', 1)
            ->where('ord_superior_shop_id', 1)
            ->where('ord_shop_id', 1)
            ->where('ord_delete', 1)
            ->where('ord_collection_bill', 1)
            ->where('ord_id', '<', 27253)
            ->where('vore_state', 2)
            ->where('ord_actual_price', 0)
            ->select('ord_id', 'ord_order_number', 'vore_ord_number', 'vore_wor_number', 'vore_actual_price', 'vore_id')
            ->get()->toArray();
        // dump($find_ord_data);
        // exit;
        foreach ($find_ord_data as $key => $value) {
            // 查询凭证列表的数据
            $find_vore_data = DB::table('voucher_loan')
                ->where('volo_shop_id', 1)
                ->where('volo_vore_id', $value->vore_id)
                ->select('volo_id', 'volo_borrow_price')
                ->get()->toArray();
            foreach ($find_vore_data as $kkk => $vvv) {
                if ($vvv->volo_borrow_price != 0) {
                    dump($value->vore_ord_number . '---' . $value->vore_wor_number);
                }
            }
            unset($find_vore_data);
        }
        echo "string";
        exit;
    }

    // 订单金额是正数,应收应付金额是负数的数据统计调整
    public function order26()
    {
        ignore_user_abort();
        set_time_limit(0);

        // 查询订单已完成,金额是正数的数据
        $find_ord_data = DB::table('order')
            ->where('ord_cid', 1)
            ->where('ord_superior_shop_id', 1)
            ->where('ord_shop_id', 1)
            ->where('ord_wor_state', 4)
            ->where('ord_delete', 1)
            ->where('ord_collection_bill', 1)
            ->where('ord_actual_price', '>', 0)
            ->select('ord_id', 'ord_cid', 'ord_superior_shop_id', 'ord_shop_id', 'ord_order_number')
            ->get()->toArray();
        foreach ($find_ord_data as $key => $value) {
            $find_recr_data = DB::table('receivable_credit')
                ->where('recr_cid', $value->ord_cid)
                ->where('recr_shop_id', $value->ord_shop_id)
                ->where('recr_original_id', $value->ord_id)
                ->where('recr_original_number', $value->ord_order_number)
                ->where('recr_number_id', 0)
                ->where('recr_plus_minus', 2)
                ->where('recr_account_type', 1)
                // ->where('recr_settle_price', '!=', 0)
                ->select('recr_original_id', 'recr_original_number', 'recr_settle_price')
                ->first();
            if ($find_recr_data) {
                dump($find_recr_data->recr_original_number);
            }
        }
        echo '12';
    }

    // 查询系统商品数据,复制旧货商品
    public function goods2()
    {
        ignore_user_abort();
        set_time_limit(0);

        // 查询销售统计表
        $find_goo_test = DB::table('goods')
            ->where('goo_cid', 0)
            ->where('goo_superior_shop_id', 0)
            ->where('goo_shop_id', 0)
            ->get()->toArray();
        $find_goo_test = json_decode(json_encode($find_goo_test), true);
        foreach ($find_goo_test as $key => $value) {
            $add_data['goo_cid'] = $value['goo_cid'];
            $add_data['goo_superior_shop_id'] = $value['goo_superior_shop_id'];
            $add_data['goo_shop_id'] = $value['goo_shop_id'];
            $add_data['goo_bra_name'] = $value['goo_bra_name'];
            $add_data['goo_bra_id'] = $value['goo_bra_id'];
            $add_data['goo_brse_id'] = $value['goo_brse_id'];
            $add_data['goo_cate_name'] = $value['goo_cate_name'];
            $add_data['goo_cate_id'] = $value['goo_cate_id'];
            $add_data['goo_name'] = $value['goo_name'];
            $add_data['goo_goods_encode'] = $value['goo_goods_encode'];
            $add_data['goo_type'] = 4;
            $add_data['goo_fid'] = $value['goo_id'];
            $add_res = DB::table('goods')->insert($add_data);
            // 商品所属品类数量更改
            $res_cate = DB::table('category_correlation')
                ->where('caco_cate_id', $value['goo_cate_id'])
                ->increment('caco_goods_number', 1);
            // 商品所属品类数量更改
            $res_cates = DB::table('category')
                ->where('cate_id', $value['goo_cate_id'])
                ->increment('cate_goods_number', 1);
            // 商品所属品牌数量修正
            $res_brands = DB::table('brand')
                ->where('bra_id', $value['goo_bra_id'])
                ->increment('bra_goods_number', 1);
            // 商品所属品牌数量修正
            $res_brand = DB::table('brand_correlation')
                ->where('brco_bra_id', $value['goo_bra_id'])
                ->increment('brco_goods_number', 1);

            // 商品所属品牌系列数量更改
            $res_brand_serie = DB::table('brand_serie_correlation')
                ->where('brsc_brse_id', $value['goo_brse_id'])
                ->increment('brsc_goods_number', 1);
            // 商品所属品牌系列数量更改
            $res_brand_series = DB::table('brand_serie')
                ->where('brse_id', $value['goo_brse_id'])
                ->increment('brse_goods_number', 1);
            unset($add_data);
            unset($add_res);
            unset($res_cate);
            unset($res_brand);
            unset($res_brand_serie);
            unset($res_cates);
            unset($res_brands);
            unset($res_brand_series);
        }
        echo "string";
        exit;
    }

    // 查询系统商品名称和表格不一致的数据
    public function goods()
    {
        ignore_user_abort();
        set_time_limit(0);

        // 查询销售统计表
        $find_goo_test = DB::table('goods_test')
            ->where('goo_cid', 0)
            ->where('goo_superior_shop_id', 0)
            ->where('goo_shop_id', 0)
            ->select('goo_id', 'goo_name', 'goo_goods_encode')
            ->get()->toArray();
        // dump($find_dast_data);
        // exit;
        $goods = [];
        foreach ($find_goo_test as $key => $value) {
            // 查询商品表的数据
            $goo_name = DB::table('goods')
                ->where('goo_cid', 0)
                ->where('goo_superior_shop_id', 0)
                ->where('goo_shop_id', 0)
                ->where('goo_goods_encode', $value->goo_goods_encode)
                ->value('goo_name');
            if ($goo_name != $value->goo_name) {
                $goods[$key]['goo_name'] = $value->goo_name;
                $goods[$key]['goo_goods_encode'] = $value->goo_goods_encode;
                // 修改商品表名称
                $edit_goo_data['goo_name'] = $value->goo_name;
                $edit_orgo_res = DB::table('goods')
                    ->where('goo_cid', 0)
                    ->where('goo_superior_shop_id', 0)
                    ->where('goo_shop_id', 0)
                    ->where('goo_goods_encode', $value->goo_goods_encode)
                    ->update($edit_goo_data);
                dump($edit_orgo_res);
                unset($edit_goo_data);
                unset($edit_orgo_res);
            }
            unset($goo_name);
        }
        // dump($goods);
        // echo "string";
        // exit;
    }

    public function hzImportGoodssss($submit_data, $data)
    {
        echo 99900;
        DB::beginTransaction();
        $cid = 1; //公司id
        $superior_shop_id = 42; //总店id
        $shop_id = 42; //门店id
        $goods_data = [];
        $defeated = [];
        // $dates = date('Y-m-d H:i:s');
        $dates = $this->now_time;
        try {
            $api_token = Crypt::decrypt($submit_data['api_token']);
        } catch (\Exception $e) {
            return response()->json(["code"=>300, 'msg'=>'error', 'data'=>'非法api_token']);
        }

        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($api_token);

        // $user_info = Common::getUserInfo($submit_data['api_token']);
        // dump($user_info);die;
        $ware_id = 52; //仓库id
        $good_encode = []; //xitongbianma
        $good_encode_two = [];
        /*foreach ($data as $key => $value) {
            // dump($value);
            // die;
            $info['goo_goods_encode'] = $value['goo_goods_encode'];
            if (in_array($value['goo_goods_encode'], $good_encode)) {
                $good_encode_two[] = $value['goo_goods_encode'];
            } else {
                $good_encode[] = $value['goo_goods_encode'];
            }
        }*/
        $goods_encodes_twos = [];
        $find_goods_two = [];
        foreach ($data as $key => $value) {
            /*if (in_array($value['goo_goods_encode'], $good_encode_two) {
                if (isset($find_goods_two[$good_encode_two])) {
                    $find_goods_two[$good_encode_two]['kcu'] = $find_goods_two[$good_encode_two]['kucunshu'] + $value['kucunshu'];
                    $find_goods_two[$good_encode_two]['jine'] = $find_goods_two[$good_encode_two]['jine'] + $value['jine'];
                    $find_goods_two[$good_encode_two] = $find_goods_two[$good_encode_two]['jine'] + $value['jine'];
                } else {
                    $find_goods_two[$good_encode_two] = $value;
                }
            } else {
                $goods_encodes_twos[] = $value
            }*/
            // 根据检索编码查询商品id
            $find_goo_id = DB::table('goods')
                ->where('goo_cid', 0)
                ->where('goo_shop_id', 0)
                ->where('goo_superior_shop_id', 0)
                ->where('goo_type', 1)
                ->where('goo_delete', 1)
                ->where('goo_goods_encode', $value['goo_goods_encode'])
                ->select('goo_id', 'goo_purchase_price', 'goo_goods_encode')
                ->first();
            // dump($find_goo_id);
            if (!empty($find_goo_id->goo_id)) {
                $goo_id = $find_goo_id->goo_id;
            } else {
                dump($value['goo_goods_encode']);
                echo "string";
            }

            // 添加商品库存，查询仓库id
            if (empty($ware_id)) {
            } else {
                $value['kucunshu'] = $value['kucunshu'] ? $value['kucunshu'] : 0; //库存数量
                //判断仓库里是否有此商品
                $stock_numbers = $value['kucunshu']; //良品库存
                $res = DB::table('warehouse_onhand')
                    ->where('waon_ware_id', $ware_id)
                    ->where('waon_class', 1)
                    ->increment('waon_all_amount', $stock_numbers);
                $res = DB::table('warehouse_onhand')
                    ->where('waon_ware_id', $ware_id)
                    ->where('waon_class', 1)
                    ->increment('waon_stock_fine_amount', $stock_numbers);
                if (empty($res)) {
                    $value['yuanyin'] = '仓库库存添加失败';
                    array_push($defeated, $value);
                    continue;
                }
                $wago_id = DB::table('warehouse_goods')
                    ->where('wago_ware_id', $ware_id)
                    ->where('wago_goo_id', $goo_id)
                    ->where('wago_class', 1)
                    ->value('wago_id');

                if (empty($wago_id)) {
                    // 仓库内没有商品，添加商品
                    $warehouse_goods['wago_ware_id'] = $ware_id; //仓库
                    $warehouse_goods['wago_class'] = 1;
                    $warehouse_goods['wago_goo_id'] = $goo_id; //商品
                    $warehouse_goods['wago_stock_number'] = $stock_numbers; //良品库存
                    $warehouse_goods['wago_update_time'] = $dates; //更新时间
                    $wago_res = DB::table('warehouse_goods')->insert($warehouse_goods);
                    if (empty($wago_res)) {
                        $value['yuanyin'] = '添加仓库商品失败';
                        array_push($defeated, $value);
                        continue;
                    }
                    unset($warehouse_goods);
                } else {
                    // 仓库内已经有商品了，更改库存数量
                    $edit_data['wago_stock_number'] = $stock_numbers;
                    $edit_data['wago_update_time'] = $dates;
                    $res = DB::table('warehouse_goods')
                        ->where('wago_ware_id', $ware_id)
                        ->where('wago_goo_id', $goo_id)
                        ->where('wago_class', 1)
                        ->update($edit_data);
                    dump($res);
                    if (empty($res)) {
                        $value['yuanyin'] = '修改仓库商品失败库存失败';
                        array_push($defeated, $value);
                        continue;
                    }
                }
            }
            unset($goo_id);
            unset($goo_id_arr);
            unset($purchase_goo_actual_count);
            unset($purchase_goo_actual_price);
            unset($purchase_return);
            unset($find_goo_id);
            unset($find_dibi_data);
            unset($info);
        }
        echo 333;
        dump($defeated);
        DB::commit();
    }

    // 订单已取消,销售统计列表还存在的数据
    public function order33()
    {
        ignore_user_abort();
        set_time_limit(0);

        $adm_cid = 1;
        $shop_id = 1;

        // 查询订单已取消的数据
        $find_del_order = DB::table('order')
            ->where('ord_cid', $adm_cid)
            ->where('ord_superior_shop_id', $shop_id)
            ->where('ord_shop_id', $shop_id)
            ->where('ord_delete', 2)
            ->select('ord_id', 'ord_order_number')
            ->get()->toArray();
        foreach ($find_del_order as $key => $value) {
            // 查询销售统计数据
            $find_dast_data = DB::table('data_statistical')
                ->where('dast_ord_id', $value->ord_id)
                ->where('dast_order_number', $value->ord_order_number)
                ->where('dast_ord_delete', 1)
                ->select('dast_id', 'dast_ord_id', 'dast_order_number')
                ->first();
            if ($find_dast_data) {
                dump($find_dast_data);
            }
        }
        unset($find_del_order);
    }

    // 统计仓库库存数量和进销存库存数量不一致的数据
    public function selectWarehouseGoods(Request $request)
    {
        ignore_user_abort();
        set_time_limit(0);

        $adm_cid = 1;
        $shop_id = 1;

        $search_data = $request->all();
        $list_data = DB::table('enters_sells_saves')
            ->where('ense_shop_id', $shop_id)
            ->where('ense_goo_warehouse', $request['sssg_ware_id'])
            ->where('ense_goo_waretype', $request['sssg_waon_class'])
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['goo_name'])) {
                    $query->where('ense_goo_name', 'like', '%' . $search_data['goo_name'] . '%');
                }
            }) //商品名称
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['goo_goods_encode'])) {
                    $query->where('ense_goo_number', 'like', '%' . $search_data['goo_goods_encode'] . '%');
                }
            }) //商品编码
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['ense_time_start'])) {
                    $query->where('ense_time', '>=', $search_data['ense_time_start'] . " 00:00:00");
                }
            }) //起始时间
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['ense_time_end'])) {
                    $query->where('ense_time', '<=', $search_data['ense_time_end'] . " 23:59:59");
                }
            }) //结束时间
            ->select('ense_goo_id')
            ->orderBy('ense_id', 'asc')
            ->groupBy('ense_goo_id')
            ->get()->toArray();
        $list_items = $list_data;
        $ids = array();

        foreach ($list_items as $k => $v) {
            foreach ($v as $kk => $vv) {
                $ids[] = $vv;
            }
        }
        $list = DB::table('enters_sells_saves')
            ->where('ense_shop_id', $shop_id)
            ->where('ense_goo_warehouse', $request['sssg_ware_id'])
            ->where('ense_goo_waretype', $request['sssg_waon_class'])
            ->whereIn('ense_goo_id', $ids)
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['goo_name'])) {
                    $query->where('ense_goo_name', 'like', '%' . $search_data['goo_name'] . '%');
                }
            }) //商品名称
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['goo_goods_encode'])) {
                    $query->where('ense_goo_number', 'like', '%' . $search_data['goo_goods_encode'] . '%');
                }
            }) //商品编码
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['ense_time_start'])) {
                    $query->where('ense_time', '>=', $search_data['ense_time_start'] . " 00:00:00");
                }
            }) //起始时间
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['ense_time_end'])) {
                    $query->where('ense_time', '<=', $search_data['ense_time_end'] . " 23:59:59");
                }
            }) //结束时间
            ->select('ense_id', 'ense_goo_id', 'ense_goo_name', 'ense_goo_number', 'ense_goo_waretype', 'ense_goo_warehouse', 'ense_new_inventory', 'ense_end_inventory')
            ->orderBy('ense_id', 'asc')
            ->get()
            ->toArray();
        $dataayyar = array();
        if ($list) {
            // 查询仓库数据
            $warehouse_data = DB::table('warehouse')
                ->where('ware_id', $request['sssg_ware_id'])
                ->select('ware_id', 'ware_name')
                ->first();
            // 查询仓库类别数据
            $warehouse_class = DB::table('warehouse_class')
                ->where('wacl_cid', $adm_cid)
                ->where('wacl_superior_shop_id', $shop_id)
                ->where('wacl_class_numerical', $request['sssg_waon_class'])
                ->select('wacl_class_numerical', 'wacl_class_name')
                ->first();
            $warehouse_data = $warehouse_data->ware_id;
            $warehouse_class = $warehouse_class->wacl_class_numerical;
            $listarray = array();
            $list = json_decode(json_encode($list), true);
            foreach ($list as $k => $v) {
                if (isset($listarray[$v['ense_goo_id']])) {
                    $listarray[$v['ense_goo_id']]['ense_goo_waretype'] = $warehouse_class;
                    $listarray[$v['ense_goo_id']]['ense_goo_warehouse'] = $warehouse_data;
                    $listarray[$v['ense_goo_id']]['ense_end_inventory'] = $v['ense_end_inventory'];
                } else {
                    $v['ense_goo_waretype'] = $warehouse_class;
                    $v['ense_goo_warehouse'] = $warehouse_data;
                    $listarray[$v['ense_goo_id']] = $v;
                }
            }
            $i = "0";
            foreach ($listarray as $k => $v) {
                $dataayyar[$i] = $v;
                $i = $i + 1;
            }
        }

        // dump($dataayyar);
        // exit;
        $stocks_numbers = [];
        foreach ($dataayyar as $k1 => $v1) {
            // dump($v1);
            // dump($v1['ense_goo_warehouse']);
            // 根据仓库id,仓库类别,查询仓库商品表的数量
            $find_wago_data = DB::table('warehouse_goods')
                ->where('wago_ware_id', $v1['ense_goo_warehouse'])
                ->where('wago_class', $v1['ense_goo_waretype'])
                ->where('wago_goo_id', $v1['ense_goo_id'])
                ->select('wago_id', 'wago_stock_number', 'wago_lock_quantity', 'wago_priority_stock_number', 'wago_priority_lock_quantity', 'wago_unchecked_stock_number')
                ->first();
            if ($find_wago_data) {
                // 货物仓
                // $stock_amount = $find_wago_data->wago_stock_number + $find_wago_data->wago_lock_quantity;
                // 旧货仓
                $stock_amount = $find_wago_data->wago_stock_number + $find_wago_data->wago_lock_quantity + $find_wago_data->wago_priority_stock_number + $find_wago_data->wago_priority_lock_quantity + $find_wago_data->wago_unchecked_stock_number;
                // dump($v1['ense_end_inventory']);
                // dump($stock_amount);
                // if ($v1['ense_end_inventory'] != $stock_amount && $v1['ense_end_inventory'] >= 0) {
                if ($v1['ense_end_inventory'] != $stock_amount) {
                    // dump($find_wago_data->wago_id);
                    $stocks_numbers[$k1]['wago_id'] = $find_wago_data->wago_id;
                    $stocks_numbers[$k1]['ense_goo_number'] = $v1['ense_goo_number'];
                    $stocks_numbers[$k1]['ense_end_inventory'] = $v1['ense_end_inventory'];
                    $stocks_numbers[$k1]['stock_amount'] = $stock_amount;
                    // if ($find_wago_data->wago_lock_quantity == 0) {
                    if ($find_wago_data->wago_lock_quantity == 0 && $find_wago_data->wago_priority_lock_quantity == 0) {
                        // 货物仓
                        $edit_wago_data['wago_stock_number'] = $v1['ense_end_inventory']; //良品库存数量
                        // 旧货仓
                        // $edit_wago_data['wago_unchecked_stock_number'] = $v1['ense_end_inventory'] - $find_wago_data->wago_stock_number - $find_wago_data->wago_priority_stock_number; //待检测库存数量
                    } else {
                        // 货物仓
                        $edit_wago_data['wago_stock_number'] = $v1['ense_end_inventory'] - $find_wago_data->wago_lock_quantity; //良品库存数量
                        // 旧货仓
                        // $edit_wago_data['wago_unchecked_stock_number'] = $v1['ense_end_inventory'] - $find_wago_data->wago_stock_number - $find_wago_data->wago_lock_quantity - $find_wago_data->wago_priority_stock_number - $find_wago_data->wago_priority_lock_quantity; //待检测库存数量
                    }
                    // $edit_wago_res = DB::table('warehouse_goods')
                    //     ->where('wago_id', $find_wago_data->wago_id)
                    //     ->update($edit_wago_data);
                    // unset($edit_wago_data);
                    // unset($edit_wago_res);
                }
            }
        }
        dump($stocks_numbers);
        echo 'string';
    }

    // 查询凭证列表成本和销售统计成本不一致的
    public function order31(Request $request)
    {
        echo "123232";
        exit;
        ignore_user_abort();
        set_time_limit(0);

        $search_data = $request->all();

        // 查询销售统计表
        $find_dast_data = DB::table('data_statistical as dast')
            ->leftjoin('voucher_receipts as vore', 'vore.vore_ord_id', '=', 'dast_ord_id')
            ->where('dast_cid', 1)
            ->where('dast_shop_id', 1)
            ->where('dast_superior_shop_id', 1)
            ->where('dast_order_type', '!=', 3)
            ->where('dast_goo_id', '!=', 0)
            ->where('dast_ord_delete', 1)
            ->where('dast_ord_form_type', 1)
            // ->whereIn('dast_good_state', [3, 6])
            // ->where('dast_goo_quantity', '=', 1)
            // ->where('dast_id', '>=', 1186)
            // ->where('dast_id', '<', 2186)
            ->where('dast_id', '>=', 30000)
            // ->where('dast_waon_class', '=', 3)
            ->where('vore_state', 1)
            ->where('vore_service_type', '!=', 3)
            ->where(function ($query) use ($search_data) {
                //如果选择开始时间并且选择结束时间
                if (!empty($search_data['create_time_start']) && !empty($search_data['create_time_end'])) {
                    $query->whereBetween('dast_create_time', [$search_data['create_time_start'], $search_data['create_time_end'] . ' 23:59:59']);
                } else {
                    // 如果选择开始时间
                    if (!empty($search_data['create_time_start'])) {
                        $query->where('dast_create_time', '>=', $search_data['create_time_start']);
                    } else {
                        // 如果选择结束时间
                        if (!empty($search_data['create_time_end'])) {
                            $query->where('dast_create_time', '<=', $search_data['create_time_end'] . ' 23:59:59');
                        }
                    }
                }
            }) //创建时间
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['dast_order_number'])) {
                    $query->where('dast_order_number', 'like', '%' . $search_data['dast_order_number'] . '%');
                }
            }) //单号
            ->select('dast_id', 'dast_ord_id', 'dast_order_number', 'dast_goo_quantity', 'dast_goo_cost', 'dast_goo_id', 'dast_orgo_id')
            ->get()->toArray();
        dump($find_dast_data);
        // exit;
        $dast_subtract = [];
        foreach ($find_dast_data as $kk => $vv) {
            if (!isset($dast_subtract[$vv->dast_ord_id])) {
                $dast_subtract[$vv->dast_ord_id] = 0;
            }
            $dast_subtract[$vv->dast_ord_id] += ($vv->dast_goo_quantity * $vv->dast_goo_cost); //商品数量
            /*// 订单商品状态为3或6的，成本为0
            $edit_ord_data['orgo_goo_cost'] = 0;
            $edit_ord_res = DB::table('order_goods')
                ->where('orgo_id', $vv->dast_orgo_id)
                ->whereIn('orgo_state', [3, 6])
                ->update($edit_ord_data);

            // 订单商品状态为3或6的，成本为0
            $edit_dast_data['dast_goo_cost'] = 0;
            $edit_dast_res = DB::table('data_statistical')
                ->where('dast_id', $vv->dast_id)
                ->whereIn('dast_good_state', [3, 6])
                ->update($edit_dast_data);*/
        }
        unset($find_dast_data);
        // echo "string";
        // exit;
        foreach ($dast_subtract as $key => $value) {
            // 查询凭证列表的数据
            $find_vore_data = DB::table('voucher_receipts')
                ->where('vore_cid', 1)
                ->where('vore_shop_id', 1)
                ->where('vore_superior_shop_id', 1)
                ->where('vore_ord_id', $key)
                ->where('vore_state', 1)
                ->where('vore_service_type', '!=', 3)
                ->select('vore_id', 'vore_ord_id', 'vore_ord_number', 'vore_early_costing', 'vore_create_time')
                ->first();
            if ($find_vore_data) {
                dump($find_vore_data);
                /*echo '111';
                $volo_edit_res = DB::table('voucher_loan')
                    ->where('volo_vore_id', $find_vore_data->vore_id)
                    ->select('volo_id', 'volo_vore_id', 'volo_borrow_subject', 'volo_loan_costing_subject')
                    ->where('volo_borrow_costing', '!=', 0)
                    ->get()->toArray();
                dump($volo_edit_res);
                foreach ($volo_edit_res as $kkk => $vvv) {
                    if ($vvv->volo_borrow_subject == '640101' || $vvv->volo_loan_costing_subject == '140501') {
                        // 修改凭证列表的成本
                        $volo_edit_data['volo_borrow_costing'] = 0;
                        $volo_edit_data['volo_loan_costing'] = 0;
                        $volo_edit_res = DB::table('voucher_loan')
                            ->where('volo_id', $vvv->volo_id)
                            ->where('volo_vore_id', $find_vore_data->vore_id)
                            ->update($volo_edit_data);
                        unset($volo_edit_data);
                        unset($volo_edit_res);
                    }
                    $vore_edit_data['vore_early_costing'] = 0;
                    $vore_edit_res = DB::table('voucher_receipts')
                        ->where('vore_id', $find_vore_data->vore_id)
                        ->where('vore_cid', 1)
                        ->where('vore_shop_id', 1)
                        ->where('vore_superior_shop_id', 1)
                        ->where('vore_state', 1)
                        ->where('vore_ord_id', $key)
                        ->where('vore_service_type', '!=', 3)
                        ->update($vore_edit_data);
                }
                echo '2222';*/
                // 销售统计总成本
                $dast_goo_cost = abs($value) / 100;
                // 凭证列表总成本
                $find_volo_data = DB::table('voucher_loan')
                    ->where('volo_vore_id', $find_vore_data->vore_id)
                    ->get()->toArray();
                $find_volo_data = json_decode(json_encode($find_volo_data), true);
                $total_cost = $find_vore_data->vore_early_costing;
                // if ($dast_goo_cost != $total_cost) {
                if ($dast_goo_cost != $find_volo_data[0]['volo_borrow_costing']) {
                    // 根据商品id,查询对应的检索编码
                    /*$find_dats = DB::table("data_statistical as a")
                        ->leftJoin('goods as b', 'b.goo_id', '=', 'a.dast_actual_goo_id')
                        ->where('dast_ord_id', $key)
                        ->select('goo_goods_encode', 'goo_id', 'dast_goo_cost', 'goo_name', 'dast_create_time')
                        ->get();
                    foreach ($find_dats as $kkk => $vvv) {
                        // 根据订单id,查询对应的商品id
                        $add_data['dast_cid'] = 1;//所属企业id
                        $add_data['dast_superior_shop_id'] = 1;//所属总店id
                        $add_data['dast_shop_id'] = 1;//所属门店id
                        $add_data['dast_ord_id'] = $find_vore_data->vore_ord_id;//订单id
                        $add_data['dast_order_number'] = $find_vore_data->vore_ord_number;//订单单号
                        $add_data['dast_service_type'] = 1;
                        $add_data['dast_goo_id'] = $vvv->goo_id;//商品id
                        $add_data['dast_goo_name'] = $vvv->goo_name;//商品名称
                        $add_data['dast_goo_encode'] = $vvv->goo_goods_encode;//检索编码
                        $add_data['dast_goo_cost'] = $vvv->dast_goo_cost / 100;//销售统计单个商品成本
                        $add_data['dast_goo_costs'] = $dast_goo_cost;//销售统计总成本
                        $add_data['dast_vour_costs'] = $total_cost;//凭证列表的成本
                        $add_data['dast_add_time'] = $vvv->dast_create_time;//开单时间
                        $dast_id = DB::table('data_statisticals')->insert($add_data);
                        unset($add_data);
                        unset($dast_id);
                    }
                    unset($find_dats);*/
                    foreach ($find_volo_data as $kkk => $vvv) {
                        if ($vvv['volo_borrow_costing_subject'] == '640101' || $vvv['volo_loan_costing_subject'] == '140501') {
                            // 修改凭证列表的成本
                            $volo_edit_data['volo_borrow_costing'] = $dast_goo_cost;
                            $volo_edit_data['volo_loan_costing'] = $dast_goo_cost;
                            $volo_edit_res = DB::table('voucher_loan')
                                ->where('volo_id', $vvv['volo_id'])
                                ->where('volo_vore_id', $find_vore_data->vore_id)
                                ->update($volo_edit_data);
                            unset($volo_edit_data);
                            unset($volo_edit_res);
                        }
                        $vore_edit_data['vore_early_costing'] = $dast_goo_cost;
                        $vore_edit_res = DB::table('voucher_receipts')
                            ->where('vore_id', $find_vore_data->vore_id)
                            ->where('vore_cid', 1)
                            ->where('vore_shop_id', 1)
                            ->where('vore_superior_shop_id', 1)
                            ->where('vore_state', 1)
                            ->where('vore_ord_id', $key)
                            ->where('vore_service_type', '!=', 3)
                            ->update($vore_edit_data);
                    }
                }
            }
            unset($find_vore_data);
        }
        echo "string";
        exit;
    }

    // 查询凭证列表成本和销售统计成本不一致的
    public function order16(Request $request)
    {
        ignore_user_abort();
        set_time_limit(0);

        $search_data = $request->all();

        // 查询销售统计表
        $find_dast_data = DB::table('data_statistical')
            ->where('dast_cid', 1)
            ->where('dast_shop_id', 1)
            ->where('dast_superior_shop_id', 1)
            ->where('dast_order_type', '!=', 3)
            ->where('dast_goo_id', '!=', 0)
            ->where('dast_ord_delete', 1)
            ->where('dast_ord_form_type', 1)
            // ->whereIn('dast_good_state', [3, 6])
            // ->where('dast_goo_quantity', '=', 1)
            // ->where('dast_id', '>=', 1186)
            // ->where('dast_id', '<', 2186)
            ->where('dast_id', '<', 30000)
            // ->where('dast_service_type', '=', 4)
            // ->where('dast_waon_class', '=', 3)
            ->where(function ($query) use ($search_data) {
                //如果选择开始时间并且选择结束时间
                if (!empty($search_data['create_time_start']) && !empty($search_data['create_time_end'])) {
                    $query->whereBetween('dast_create_time', [$search_data['create_time_start'], $search_data['create_time_end'] . ' 23:59:59']);
                } else {
                    // 如果选择开始时间
                    if (!empty($search_data['create_time_start'])) {
                        $query->where('dast_create_time', '>=', $search_data['create_time_start']);
                    } else {
                        // 如果选择结束时间
                        if (!empty($search_data['create_time_end'])) {
                            $query->where('dast_create_time', '<=', $search_data['create_time_end'] . ' 23:59:59');
                        }
                    }
                }
            }) //创建时间
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['dast_order_number'])) {
                    $query->where('dast_order_number', 'like', '%' . $search_data['dast_order_number'] . '%');
                }
            }) //单号
            ->select('dast_id', 'dast_ord_id', 'dast_order_number', 'dast_goo_quantity', 'dast_goo_cost', 'dast_goo_id', 'dast_orgo_id')
            ->get()->toArray();
        // dump($find_dast_data);
        // exit;
        $dast_subtract = [];
        foreach ($find_dast_data as $kk => $vv) {
            if (!isset($dast_subtract[$vv->dast_ord_id])) {
                $dast_subtract[$vv->dast_ord_id] = 0;
            }
            $dast_subtract[$vv->dast_ord_id] += ($vv->dast_goo_quantity * $vv->dast_goo_cost); //商品数量
            // 订单商品状态为3或6的，成本为0
            /*$edit_ord_data['orgo_goo_cost'] = 0;
            $edit_ord_res = DB::table('order_goods')
                ->where('orgo_id', $vv->dast_orgo_id)
                ->where('orgo_waon_class', 3)
                ->update($edit_ord_data);

            // 订单商品状态为3或6的，成本为0
            $edit_dast_data['dast_goo_cost'] = 0;
            $edit_dast_res = DB::table('data_statistical')
                ->where('dast_id', $vv->dast_id)
                ->where('dast_waon_class', 3)
                ->update($edit_dast_data);*/
        }
        unset($find_dast_data);
        // echo "string";
        // exit;
        foreach ($dast_subtract as $key => $value) {
            // 查询凭证列表的数据
            $find_vore_data = DB::table('voucher_receipts')
                ->where('vore_cid', 1)
                ->where('vore_shop_id', 1)
                ->where('vore_superior_shop_id', 1)
                ->where('vore_ord_id', $key)
                ->where('vore_state', 2)
                ->where('vore_service_type', '!=', 3)
                ->select('vore_id', 'vore_ord_id', 'vore_ord_number', 'vore_early_costing', 'vore_create_time')
                ->first();
            if ($find_vore_data) {
                dump($find_vore_data);
                /*echo '111';
                $volo_edit_res = DB::table('voucher_loan')
                    ->where('volo_vore_id', $find_vore_data->vore_id)
                    ->select('volo_id', 'volo_vore_id', 'volo_borrow_subject', 'volo_loan_costing_subject')
                    ->where('volo_borrow_costing', '!=', 0)
                    ->get()->toArray();
                dump($volo_edit_res);
                foreach ($volo_edit_res as $kkk => $vvv) {
                    if ($vvv->volo_borrow_subject == '640101' || $vvv->volo_loan_costing_subject == '140501') {
                        // 修改凭证列表的成本
                        $volo_edit_data['volo_borrow_costing'] = 0;
                        $volo_edit_data['volo_loan_costing'] = 0;
                        $volo_edit_res = DB::table('voucher_loan')
                            ->where('volo_id', $vvv->volo_id)
                            ->where('volo_vore_id', $find_vore_data->vore_id)
                            ->update($volo_edit_data);
                        unset($volo_edit_data);
                        unset($volo_edit_res);
                    }
                    $vore_edit_data['vore_early_costing'] = 0;
                    $vore_edit_res = DB::table('voucher_receipts')
                        ->where('vore_id', $find_vore_data->vore_id)
                        ->where('vore_cid', 1)
                        ->where('vore_shop_id', 1)
                        ->where('vore_superior_shop_id', 1)
                        ->where('vore_state', 1)
                        ->where('vore_ord_id', $key)
                        ->where('vore_service_type', '!=', 3)
                        ->update($vore_edit_data);
                }
                echo '2222';*/
                // 销售统计总成本
                $dast_goo_cost = abs($value) / 100;
                // 凭证列表总成本
                $find_volo_data = DB::table('voucher_loan')
                    ->where('volo_vore_id', $find_vore_data->vore_id)
                    ->get()->toArray();
                $find_volo_data = json_decode(json_encode($find_volo_data), true);
                $total_cost = $find_vore_data->vore_early_costing;
                // if ($dast_goo_cost != $total_cost) {
                if ($dast_goo_cost != $find_volo_data[0]['volo_borrow_costing']) {
                    // 根据商品id,查询对应的检索编码
                    $find_dats = DB::table("data_statistical as a")
                        ->leftJoin('goods as b', 'b.goo_id', '=', 'a.dast_actual_goo_id')
                        ->where('dast_ord_id', $key)
                        ->select('goo_goods_encode', 'goo_id', 'dast_goo_cost', 'goo_name', 'dast_create_time')
                        ->get();
                    foreach ($find_dats as $kkk => $vvv) {
                        // 根据订单id,查询对应的商品id
                        $add_data['dast_cid'] = 1; //所属企业id
                        $add_data['dast_superior_shop_id'] = 1; //所属总店id
                        $add_data['dast_shop_id'] = 1; //所属门店id
                        $add_data['dast_ord_id'] = $find_vore_data->vore_ord_id; //订单id
                        $add_data['dast_order_number'] = $find_vore_data->vore_ord_number; //订单单号
                        $add_data['dast_service_type'] = 1;
                        $add_data['dast_goo_id'] = $vvv->goo_id; //商品id
                        $add_data['dast_goo_name'] = $vvv->goo_name; //商品名称
                        $add_data['dast_goo_encode'] = $vvv->goo_goods_encode; //检索编码
                        $add_data['dast_goo_cost'] = $vvv->dast_goo_cost / 100; //销售统计单个商品成本
                        $add_data['dast_goo_costs'] = $dast_goo_cost; //销售统计总成本
                        $add_data['dast_vour_costs'] = $total_cost; //凭证列表的成本
                        $add_data['dast_add_time'] = $vvv->dast_create_time; //开单时间
                        $dast_id = DB::table('data_statisticals')->insert($add_data);
                        unset($add_data);
                        unset($dast_id);
                    }
                    unset($find_dats);
                    /*foreach ($find_volo_data as $kkk => $vvv) {
                        if ($vvv['volo_borrow_costing_subject'] == '640101' || $vvv['volo_loan_costing_subject'] == '140501') {
                            // 修改凭证列表的成本
                            $volo_edit_data['volo_borrow_costing'] = $dast_goo_cost;
                            $volo_edit_data['volo_loan_costing'] = $dast_goo_cost;
                            $volo_edit_res = DB::table('voucher_loan')
                                ->where('volo_id', $vvv['volo_id'])
                                ->where('volo_vore_id', $find_vore_data->vore_id)
                                ->update($volo_edit_data);
                            unset($volo_edit_data);
                            unset($volo_edit_res);
                        }
                        $vore_edit_data['vore_early_costing'] = $dast_goo_cost;
                        $vore_edit_res = DB::table('voucher_receipts')
                            ->where('vore_id', $find_vore_data->vore_id)
                            ->where('vore_cid', 1)
                            ->where('vore_shop_id', 1)
                            ->where('vore_superior_shop_id', 1)
                            ->where('vore_state', 1)
                            ->where('vore_ord_id', $key)
                            ->where('vore_service_type', '!=', 3)
                            ->update($vore_edit_data);
                    }*/
                }
            }
            unset($find_vore_data);
        }
        echo "string";
        exit;
    }

    // 查询凭证列表未同步U8的数据,根据进销存的成本,修正销售统计成本
    public function order23()
    {
        ignore_user_abort();
        set_time_limit(0);

        $adm_cid = 1;
        $shop_id = 1;

        $find_data = DB::table('voucher_receipts as vore')
            ->leftjoin('data_statistical as dast', 'dast.dast_ord_id', '=', 'vore.vore_ord_id')
            ->where('dast_cid', $adm_cid)
            ->where('dast_shop_id', $shop_id)
            ->where('dast_superior_shop_id', $shop_id)
            ->where('dast_ord_form_type', 1)
            ->where('dast_ord_delete', 1)
            ->where('dast_order_type', '!=', 3)
            // 54000，,56000
            ->where('dast_id', '>=', 58000)
            ->where('dast_id', '<', 60000)
            ->whereIn('vore_order_type', [1, 2])
            ->where('vore_state', 2)
            ->select('dast_id', 'dast_order_number', 'dast_ware_id', 'dast_waon_class', 'dast_goo_id', 'dast_orgo_id', 'dast_ord_id')
            ->get()->toArray();
        // dump($find_data);
        // exit;
        foreach ($find_data as $key => $value) {
            // dump($value);
            $cost_price = 0; //总成本金额
            // 获取成本价
            $ense_end_price = DB::table('enters_sells_saves')
                ->where('ense_goo_id', $value->dast_goo_id)
                ->where('ense_goo_warehouse', $value->dast_ware_id)
                ->where('ense_goo_waretype', $value->dast_waon_class)
                ->where('ense_order_number', $value->dast_order_number)
                ->value('ense_end_price');
            // 修改销售统计商品成本
            $edit_data['dast_goo_cost'] = $ense_end_price * 100;
            $edit_res = DB::table('data_statistical')
                ->where('dast_ord_id', $value->dast_ord_id)
                ->where('dast_order_number', $value->dast_order_number)
                ->where('dast_orgo_id', $value->dast_orgo_id)
                ->update($edit_data);
            // dump($edit_res);
            unset($edit_data);
            unset($edit_res);
            // exit;
        }
        unset($find_data);
        echo "成功";
    }

    // 已取消的订单在应收应付的列表数据
    public function order30()
    {
        ignore_user_abort();
        set_time_limit(0);

        // 查询订单已完成,金额是正数的数据
        $find_ord_data = DB::table('order')
            ->where('ord_cid', 1)
            ->where('ord_superior_shop_id', 1)
            ->where('ord_shop_id', 1)
            ->where('ord_delete', 2)
            // ->where('ord_collection_bill', 1)
            // ->where('ord_actual_price', '>', 0)
            ->select('ord_id', 'ord_cid', 'ord_superior_shop_id', 'ord_shop_id', 'ord_order_number')
            ->get()->toArray();
        foreach ($find_ord_data as $key => $value) {
            $find_recr_data = DB::table('receivable_credit')
                ->where('recr_cid', $value->ord_cid)
                ->where('recr_shop_id', $value->ord_shop_id)
                ->where('recr_original_id', $value->ord_id)
                ->where('recr_original_number', $value->ord_order_number)
                // ->where('recr_number_id', 0)
                // ->where('recr_plus_minus', 2)
                // ->where('recr_settle_price', '!=', 0)
                ->select('recr_original_id', 'recr_original_number', 'recr_settle_price')
                ->first();
            if ($find_recr_data) {
                dump($find_recr_data->recr_original_number);
            }
        }
        echo '12';
    }

    // 查询凭证列表未同步U8的数据,不在销售统计的订单需要同步销售统计
    public function order24()
    {
        ignore_user_abort();
        set_time_limit(0);

        $adm_cid = 1;
        $shop_id = 2;

        $find_data = DB::table('voucher_receipts as vore')
            ->leftjoin('order as ord', 'ord.ord_id', '=', 'vore.vore_ord_id')
            ->leftjoin('order_client as orcl', 'orcl.orcl_ord_id', '=', 'ord.ord_id')
            ->where('ord_cid', $adm_cid)
            ->where('ord_shop_id', $shop_id)
            ->where('ord_superior_shop_id', $shop_id)
            ->where('ord_id', '>=', 25600)
            ->where('ord_id', '<', 26000)
            ->whereIn('vore_order_type', [1, 2])
            // ->where('vore_state', 1)
            // ->whereIn('ord_order_number', ['D2020103009381700026'])
            ->select('ord_id', 'ord_cid', 'ord_superior_shop_id', 'ord_shop_id', 'ord_order_number', 'ord_create_id', 'ord_orcl_id', 'ord_client_id', 'ord_type', 'ord_service_type', 'ord_service_sepr_id', 'ord_service_adm_id', 'ord_service_shop_id', 'ord_orla_id', 'ord_ware_id', 'ord_payment_way', 'ord_state', 'ord_create_time', 'ord_update_time', 'ord_delete', 'ord_order_price', 'orcl_shipment_party', 'ord_form_type', 'orcl_adm_id', 'orcl_chin_type')
            ->get()->toArray();
        // dump($find_data);
        // exit;
        foreach ($find_data as $key => $value) {
            // 查询销售统计的数据是否存在,不存在增加
            $find_dast_id = DB::table('data_statistical')
                ->where('dast_cid', $value->ord_cid)
                ->where('dast_superior_shop_id', $value->ord_superior_shop_id)
                ->where('dast_shop_id', $value->ord_shop_id)
                ->where('dast_ord_id', $value->ord_id)
                ->where('dast_order_number', $value->ord_order_number)
                ->select('dast_id')
                ->first();
            // dump($find_dast_id);
            // exit;
            // if (empty($find_dast_id->dast_id)) {
            //     dump($value->ord_order_number);
            // }
            if (empty($find_dast_id->dast_id)) {
                $find_goods_data = DB::table('order_goods')
                    ->where('orgo_ord_id', $value->ord_id)
                    ->where('orgo_state', '!=', 2)
                    ->select('orgo_id', 'orgo_ord_id', 'orgo_actual_goo_id', 'orgo_wago_id', 'orgo_goo_id', 'orgo_goo_type', 'orgo_goo_price', 'orgo_state', 'orgo_goo_quantity', 'orgo_waon_class', 'orgo_goo_cost', 'orgo_assign_price')
                    ->get()->toArray();
                foreach ($find_goods_data as $kk => $vv) {
                    dump($value->ord_order_number);
                    $dast_add_data['dast_ord_id'] = $value->ord_id; //订单id
                    $dast_add_data['dast_cid'] = $value->ord_cid; //所属企业id
                    $dast_add_data['dast_superior_shop_id'] = $value->ord_superior_shop_id; //所属总店id
                    $dast_add_data['dast_shop_id'] = $value->ord_shop_id; //所属门店id
                    $dast_add_data['dast_order_number'] = $value->ord_order_number; //订单id
                    $dast_add_data['dast_create_id'] = $value->ord_create_id; //创建人id
                    // 查询创建人姓名
                    if (!empty($value->ord_create_id)) {
                        $adm_create_name = DB::table('admin')
                            ->where('adm_id', $value->ord_create_id)
                            ->value('adm_name');
                    } else {
                        $adm_create_name = '';
                    }
                    $dast_add_data['dast_creacor'] = $adm_create_name; //创建人姓名
                    $dast_add_data['dast_orcl_id'] = $value->ord_orcl_id; //订单客户id
                    $dast_add_data['dast_client_id'] = $value->ord_client_id; //往来单位id
                    $dast_add_data['dast_client_ids'] = $value->ord_client_id; //往来单位id
                    $dast_add_data['dast_adm_id'] = $value->orcl_adm_id; //业务员账号id
                    // 业务员名称
                    if (!empty($value->orcl_adm_id)) {
                        $adm_orcl_name = DB::table('admin')
                            ->where('adm_id', $value->orcl_adm_id)
                            ->value('adm_name');
                    } else {
                        $adm_orcl_name = '';
                    }
                    $dast_add_data['dast_adm_name'] = $adm_orcl_name; //业务员姓名
                    // 查询单位类型id
                    $channel_unit = DB::table("channel_unit as chun")
                        ->leftjoin('channel_type as chty', 'chty.chty_id', '=', 'chun.chun_chty_id')
                        ->where("chun_id", $value->ord_client_id)
                        ->select("chun_id", "chun_adm_id", "chun_unit_name", "chun_chty_id", 'chty_name')
                        ->first();
                    if (isset($channel_unit->chun_id)) {
                        $dast_add_data['dast_chty_id'] = $channel_unit->chun_chty_id; //渠道类型id
                    } else {
                        $dast_add_data['dast_chty_id'] = 0;
                    }
                    $dast_add_data['dast_type'] = $value->ord_type; //买家类型：1门店零售2渠道单位3速电派单4第三方派单
                    $dast_add_data['dast_service_type'] = $value->ord_service_type; //订单类型：1服务单 2销售单 3换货单 4退货单 5发货单 6结清单 7救援单
                    $dast_add_data['dast_service_sepr_id'] = $value->ord_service_sepr_id; //服务项目id
                    $dast_add_data['dast_service_adm_id'] = $value->ord_service_adm_id; //服务技师id
                    // 技师名称
                    if (!empty($value->ord_service_adm_id)) {
                        $service_adm_name = DB::table('admin')
                            ->where('adm_id', $value->ord_service_adm_id)
                            ->value('adm_name');
                    } else {
                        $service_adm_name = '';
                    }
                    $dast_add_data['dast_service_admor'] = $service_adm_name; //技师名称
                    $dast_add_data['dast_service_shop_id'] = $value->ord_service_shop_id; //服务门店id
                    $dast_add_data['dast_orla_id'] = $value->ord_orla_id; //订单标签id
                    $dast_add_data['dast_ware_id'] = $value->ord_ware_id; //仓库id
                    $dast_add_data['dast_waon_class'] = $vv->orgo_waon_class; //仓库类别
                    $dast_add_data['dast_payment_way'] = $value->ord_payment_way; //结算方式1.账期 2.现结 3微信 4支付宝
                    $dast_add_data['dast_state'] = $value->ord_state; //结算状态1未结算2已结算3已核销4已还款
                    $dast_add_data['dast_create_time'] = $value->ord_create_time; //添加时间
                    $dast_add_data['dast_actual_goo_id'] = $vv->orgo_actual_goo_id; //实际出库商品id
                    $dast_add_data['dast_wago_id'] = $vv->orgo_wago_id; //仓库商品id
                    $dast_add_data['dast_goo_id'] = $vv->orgo_goo_id; //商品id
                    $dast_add_data['dast_goo_type'] = $vv->orgo_goo_type; //商品类型 1正常商品2赠品商品3活动商品4旧货商品
                    if ($vv->orgo_state == 3) {
                        $dast_add_data['dast_order_type'] = 3;
                        $dast_add_data['dast_goo_price'] = $vv->orgo_goo_price;
                        $dast_add_data['dast_goo_quantity'] = $vv->orgo_goo_quantity;
                    } elseif ($vv->orgo_state == 2) {
                        $dast_add_data['dast_order_type'] = 3;
                        $dast_add_data['dast_goo_price'] = $vv->orgo_goo_price; //商品售价（单位：分）
                        $dast_add_data['dast_goo_quantity'] = $vv->orgo_goo_quantity; //订单商品展示数量
                    } elseif ($vv->orgo_state == 4) {
                        $dast_add_data['dast_order_type'] = 2;
                        $dast_add_data['dast_goo_price'] = "-" . $vv->orgo_goo_price; //商品售价（单位：分）
                        $dast_add_data['dast_goo_quantity'] = "-" . $vv->orgo_goo_quantity; //订单商品展示数量
                    } elseif ($value->ord_service_type == 4) {
                        $dast_add_data['dast_order_type'] = 2;
                        $dast_add_data['dast_goo_price'] = "-" . $vv->orgo_goo_price; //商品售价（单位：分）
                        $dast_add_data['dast_goo_quantity'] = "-" . $vv->orgo_goo_quantity; //订单商品展示数量
                    } else {
                        $dast_add_data['dast_order_type'] = 1;
                        $dast_add_data['dast_goo_price'] = $vv->orgo_goo_price; //商品售价（单位：分）
                        $dast_add_data['dast_goo_quantity'] = $vv->orgo_goo_quantity; //订单商品展示数量
                    }
                    $dast_add_data['dast_good_state'] = $vv->orgo_state; //商品状态 1正常 2删除 3回收商品4换货商品
                    $dast_add_data['dast_goo_quantitys'] = $vv->orgo_goo_quantity; //订单商品计算数量
                    $dast_add_data['dast_updata_time'] = $value->ord_update_time; //更新时间
                    $dast_add_data['dast_ord_delete'] = $value->ord_delete; //是否删除：1正常订单2取消订单
                    $dast_add_data['dast_add_time'] = date("Y-m-d H:i:s"); //添加时间
                    $dast_add_data['dast_orgo_id'] = $vv->orgo_id; //订单商品表id
                    if ($value->orcl_shipment_party == 4) {
                        $wogo_goo_price = DB::table('work_good as wogo')
                            ->leftjoin('work_order as wor', 'wor.wor_id', '=', 'wogo.wogo_wor_id')
                            ->where('wor_order_id', $value->ord_id)
                            ->where('wor_order_number', $value->ord_order_number)
                            ->where('wor_delete', 1)
                            ->where('wor_collection_bill', 1)
                            ->where('wogo_waon_class', $vv->orgo_waon_class)
                            ->where('wogo_goo_id', $vv->orgo_goo_id)
                            ->where('wogo_goo_type', $vv->orgo_goo_type)
                            ->where('wor_state', '!=', 11)
                            ->value('wogo_goo_price');
                        $dast_add_data['dast_goo_cost'] = $wogo_goo_price;
                    } else {
                        $dast_add_data['dast_goo_cost'] = $vv->orgo_goo_cost; //成本
                    }
                    $dast_add_data['dast_orcl_shipment_party'] = $value->orcl_shipment_party; //出库方1仓库2直营店3加盟店4虚拟加盟店
                    $dast_add_data['dast_ord_form_type'] = $value->ord_form_type; //订单分类1普通订单2虚拟加盟店订单
                    $dast_add_data['dast_orcl_chin_type'] = $value->orcl_chin_type; //铺货类型1是铺货2不是铺货
                    // dump($dast_add_data);
                    // exit;
                    $dast_add_res = DB::table('data_statistical')->insert($dast_add_data);
                    // dump($dast_add_res);
                    unset($dast_add_data);
                    unset($dast_add_res);
                    unset($wogo_goo_price);
                }
                unset($find_goods_data);
            }
            unset($find_dast_id);
        }
        unset($find_data);
        echo "成功";
    }

    // 修正凭证列表的成本
    public function order29(Request $request)
    {
        ignore_user_abort();
        set_time_limit(0);

        $search_data = $request->all();

        $adm_cid = 1;
        $shop_id = 1;

        $find_data = DB::table('voucher_receipts as vore')
            ->where('vore_cid', $adm_cid)
            ->where('vore_shop_id', $shop_id)
            ->where('vore_superior_shop_id', $shop_id)
            // ->where('ord_id', '>=', 20000)
            // ->where('ord_id', '<', 26000)
            ->whereIn('vore_order_type', [1, 2])
            // ->where('vore_state', 1)
            ->where(function ($query) use ($search_data) {
                //如果选择开始时间并且选择结束时间
                if (!empty($search_data['create_time_start']) && !empty($search_data['create_time_end'])) {
                    $query->whereBetween('ord_create_time', [$search_data['create_time_start'], $search_data['create_time_end'] . ' 23:59:59']);
                } else {
                    // 如果选择开始时间
                    if (!empty($search_data['create_time_start'])) {
                        $query->where('ord_create_time', '>=', $search_data['create_time_start']);
                    } else {
                        // 如果选择结束时间
                        if (!empty($search_data['create_time_end'])) {
                            $query->where('ord_create_time', '<=', $search_data['create_time_end'] . ' 23:59:59');
                        }
                    }
                }
            }) //创建时间
            // ->whereIn('ord_order_number', ['D2020122810110400044'])
            ->select('vore_id', 'vore_early_costing')
            ->get()->toArray();
        // dump($find_data);
        // exit;
        foreach ($find_data as $key => $value) {
            $volo_edit_res = DB::table('voucher_loan')
                ->where('volo_vore_id', $value->vore_id)
                ->select('volo_id', 'volo_vore_id', 'volo_borrow_subject', 'volo_borrow_costing')
                ->get()->toArray();
            foreach ($volo_edit_res as $kkk => $vvv) {
                if ($vvv->volo_borrow_subject == '1122' || $vvv->volo_borrow_subject == '600101') {
                    if ($vvv->volo_borrow_costing == '106.79') {
                        // dump($value->vore_id);
                        // 修改凭证列表的成本
                        $volo_edit_data['volo_borrow_costing'] = $value->vore_early_costing;
                        $volo_edit_data['volo_loan_costing'] = $value->vore_early_costing;
                        $volo_edit_res = DB::table('voucher_loan')
                            ->where('volo_id', $vvv->volo_id)
                            ->where('volo_vore_id', $value->vore_id)
                            ->update($volo_edit_data);
                        unset($volo_edit_data);
                        unset($volo_edit_res);
                    }
                }
            }
        }
        unset($find_data);
        echo "成功";
    }

    public function order28(Request $request)
    {
        ignore_user_abort();
        set_time_limit(0);

        $search_data = $request->all();

        // 查询销售统计表
        $find_dast_data = DB::table('data_statisticals')
            ->where('dast_cid', 1)
            ->where('dast_shop_id', 1)
            ->where('dast_superior_shop_id', 1)
            ->where(function ($query) use ($search_data) {
                //如果选择开始时间并且选择结束时间
                if (!empty($search_data['create_time_start']) && !empty($search_data['create_time_end'])) {
                    $query->whereBetween('dast_create_time', [$search_data['create_time_start'], $search_data['create_time_end'] . ' 23:59:59']);
                } else {
                    // 如果选择开始时间
                    if (!empty($search_data['create_time_start'])) {
                        $query->where('dast_create_time', '>=', $search_data['create_time_start']);
                    } else {
                        // 如果选择结束时间
                        if (!empty($search_data['create_time_end'])) {
                            $query->where('dast_create_time', '<=', $search_data['create_time_end'] . ' 23:59:59');
                        }
                    }
                }
            }) //创建时间
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['dast_order_number'])) {
                    $query->where('dast_order_number', 'like', '%' . $search_data['dast_order_number'] . '%');
                }
            }) //单号
            ->select('dast_id', 'dast_ord_id', 'dast_order_number', 'dast_goo_costs', 'dast_vour_costs')
            ->get()->toArray();
        $costs = [];
        foreach ($find_dast_data as $key => $value) {
            $dast_goo_costs = abs($value->dast_goo_costs);
            $dast_vour_costs = abs($value->dast_vour_costs);
            $diff_cost = $dast_goo_costs - $dast_vour_costs;
            if ($dast_goo_costs != $dast_vour_costs && abs($diff_cost) > '0.1') {
                // $costs[$key]['dast_order_number'] = $value->dast_order_number;
                // $costs[$key]['dast_goo_costs'] = $dast_goo_costs;
                // $costs[$key]['dast_vour_costs'] = $dast_vour_costs;
                // 查询订单
                $ord_order_number = DB::table('order')
                    ->where('ord_id', $value->dast_ord_id)
                    ->where('ord_order_number', $value->dast_order_number)
                    // ->where('ord_goods_quantity', 1)
                    // ->where('ord_actual_price', 0)
                    ->value('ord_order_number');
                if ($ord_order_number) {
                    $costs[$key]['ord_order_number'] = $ord_order_number;
                    $costs[$key]['dast_goo_costs'] = $dast_goo_costs;
                    $costs[$key]['dast_vour_costs'] = $dast_vour_costs;
                }
            }
        }
        dump($costs);
        unset($find_dast_data);
        echo "string";
        exit;
    }

    // 订单、工单、应收应付这三个地方的客户单位不一致的数据统计调整
    public function order27()
    {
        ignore_user_abort();
        set_time_limit(0);

        // 查询订单已完成,金额是正数的数据
        $find_recr_data = DB::table('receivable_credit')
            ->where('recr_cid', 1)
            ->where('recr_shop_id', 1)
            ->where('recr_number_id', 0)
            ->where('recr_client_type', 2)
            ->select('recr_original_id', 'recr_original_number', 'recr_client_id')
            ->get()->toArray();
        foreach ($find_recr_data as $key => $value) {
            $find_ord_data = DB::table('work_order as wor')
                ->leftjoin('work_client as wocl', 'wocl.wocl_wor_id', 'wor.wor_id')
                ->where('wor_id', $value->recr_original_id)
                ->where('wor_number', $value->recr_original_number)
                ->where('wor_type', 2)
                ->select('wor_id', 'wor_number', 'wocl_client_id')
                ->first();
            if ($find_ord_data) {
                if ($value->recr_client_id != $find_ord_data->wocl_client_id) {
                    dump($value->recr_original_number);
                }
            }
        }
        echo '3434';
    }

    // 查询速电工单的单据的仓库id
    public function work_order4()
    {
        $cid = 3; //公司id
        $superior_shop_id = 26; //总店id
        $shop_id = 26; //门店id
        $find_wain = DB::table('work_order')
            ->where('wor_cid', $cid)
            ->where('wor_superior_shop_id', $superior_shop_id)
            ->where('wor_shop_id', $shop_id)
            ->where('wor_collection_bill', 1)
            ->where('wor_delete', 1)
            // ->where('wor_id', '>', 27980)
            ->select('wor_id', 'wor_ware_id')
            ->get()->toArray();
        foreach ($find_wain as $key => $value) {
            $wogo_edit_data['wogo_ware_id'] = $value->wor_ware_id;
            $wogo_edit_res = Db::table('work_good')
                ->where('wogo_wor_id', $value->wor_id)
                ->update($wogo_edit_data);
            unset($wogo_edit_data);
            unset($wogo_edit_res);
        }
        echo '成功';
    }

    // 查询凭证列表未同步U8的数据,修正相关成本
    public function order25(Request $request)
    {
        ignore_user_abort();
        set_time_limit(0);

        $search_data = $request->all();

        $adm_cid = 1;
        $shop_id = 1;

        $find_data = DB::table('voucher_receipts as vore')
            ->leftjoin('order as ord', 'ord.ord_id', '=', 'vore.vore_ord_id')
            ->where('ord_cid', $adm_cid)
            ->where('ord_shop_id', $shop_id)
            ->where('ord_superior_shop_id', $shop_id)
            // ->where('ord_id', '>=', 20000)
            // ->where('ord_id', '<', 26000)
            ->whereIn('vore_order_type', [1, 2])
            ->where('vore_state', 1)
            ->where('ord_form_type', 1)
            ->where(function ($query) use ($search_data) {
                //如果选择开始时间并且选择结束时间
                if (!empty($search_data['create_time_start']) && !empty($search_data['create_time_end'])) {
                    $query->whereBetween('ord_create_time', [$search_data['create_time_start'], $search_data['create_time_end'] . ' 23:59:59']);
                } else {
                    // 如果选择开始时间
                    if (!empty($search_data['create_time_start'])) {
                        $query->where('ord_create_time', '>=', $search_data['create_time_start']);
                    } else {
                        // 如果选择结束时间
                        if (!empty($search_data['create_time_end'])) {
                            $query->where('ord_create_time', '<=', $search_data['create_time_end'] . ' 23:59:59');
                        }
                    }
                }
            }) //创建时间
            // ->whereIn('ord_order_number', ['D2020122810110400044'])
            ->select('ord_id', 'ord_cid', 'ord_superior_shop_id', 'ord_shop_id', 'ord_order_number', 'ord_order_price', 'vore_id')
            ->get()->toArray();
        // dump($find_data);
        // exit;
        foreach ($find_data as $key => $value) {
            // 更新订单商品表的商品成本，根据订单id,查询商品
            $find_orgo_data = DB::table('order_goods')
                ->where('orgo_ord_id', $value->ord_id)
                ->where('orgo_state', '!=', 2)
                ->select('orgo_id', 'orgo_state', 'orgo_ord_id', 'orgo_ware_id', 'orgo_waon_class', 'orgo_goo_id', 'orgo_goo_price', 'orgo_goo_quantity')
                ->get()->toArray();
            $cost_price = 0; //总成本金额
            $recycle_amount = 0; //回收商品总成本
            $now_date = date('Y-m-d H:i:s'); //当前时间
            foreach ($find_orgo_data as $kkkk => $vvvv) {
                // 获取当前月份商品成本价
                $find_ense_end_price = DB::table('enters_sells_saves')
                    ->where('ense_goo_id', $vvvv->orgo_goo_id)
                    ->where('ense_goo_warehouse', $vvvv->orgo_ware_id)
                    ->where('ense_goo_waretype', $vvvv->orgo_waon_class)
                    ->where('ense_order_number', $value->ord_order_number)
                    ->orderBy('ense_id', 'desc')
                    ->value('ense_end_price');
                $cost_price += $find_ense_end_price * $vvvv->orgo_goo_quantity; //总成本金额

                if ($vvvv->orgo_state == 3) {
                    $recycle_amount += $vvvv->orgo_goo_price * $vvvv->orgo_goo_quantity; //回收商品成本金额
                }
                $volo_edit_res = DB::table('voucher_loan')
                    ->where('volo_vore_id', $value->vore_id)
                    ->select('volo_id', 'volo_vore_id', 'volo_borrow_subject')
                    ->get()->toArray();
                foreach ($volo_edit_res as $kkk => $vvv) {
                    if ($vvv->volo_borrow_subject == '1122' || $vvv->volo_borrow_subject == '600101') {
                        // 修改凭证列表的成本
                        $volo_edit_data['volo_borrow_costing'] = $cost_price;
                        $volo_edit_data['volo_loan_costing'] = $cost_price;
                        $volo_edit_res = DB::table('voucher_loan')
                            ->where('volo_id', $vvv->volo_id)
                            ->where('volo_vore_id', $value->vore_id)
                            ->update($volo_edit_data);
                        unset($volo_edit_data);
                        unset($volo_edit_res);
                    }
                }
            }
        }
        unset($find_data);
        echo "成功";
    }

    // 查询凭证列表未同步U8的数据,根据进销存的成本,修正订单商品表成本
    public function order22()
    {
        ignore_user_abort();
        set_time_limit(0);

        $adm_cid = 1;
        $shop_id = 1;

        $find_data = DB::table('voucher_receipts as vore')
            ->leftjoin('order as ord', 'ord.ord_id', '=', 'vore.vore_ord_id')
            ->leftjoin('order_client as orcl', 'orcl.orcl_ord_id', '=', 'ord.ord_id')
            ->where('ord_cid', $adm_cid)
            ->where('ord_shop_id', $shop_id)
            ->where('ord_form_type', 1)
            ->where('ord_delete', 1)
            ->where('ord_collection_bill', 1)
            // ->where('ord_id', '>=', 6988)
            // ->where('ord_id', '<', 7305)
            ->whereIn('vore_order_type', [1, 2])
            ->where('vore_state', 1)
            ->select('ord_id', 'ord_cid', 'ord_superior_shop_id', 'ord_shop_id', 'ord_order_number', 'ord_ware_id')
            ->get()->toArray();
        // dump($find_data);
        // exit;
        foreach ($find_data as $key => $value) {
            // 更新订单商品表的商品成本，根据订单id,查询商品
            $find_orgo_data = DB::table('order_goods')
                ->where('orgo_ord_id', $value->ord_id)
                ->where('orgo_state', '!=', 2)
                ->select('orgo_id', 'orgo_state', 'orgo_ord_id', 'orgo_ware_id', 'orgo_waon_class', 'orgo_goo_id', 'orgo_goo_price', 'orgo_goo_quantity')
                ->get()->toArray();
            $cost_price = 0; //总成本金额
            $now_date = date('Y-m-d H:i:s'); //当前时间
            if ($find_orgo_data) {
                foreach ($find_orgo_data as $kkkk => $vvvv) {
                    // 获取成本价
                    if ($vvvv->orgo_ware_id == '0') {
                        $vvvv->orgo_ware_id = $value->ord_ware_id;
                    } else {
                        $vvvv->orgo_ware_id = $vvvv->orgo_ware_id;
                    }
                    $ense_end_price = DB::table('enters_sells_saves')
                        ->where('ense_goo_id', $vvvv->orgo_goo_id)
                        ->where('ense_goo_warehouse', $vvvv->orgo_ware_id)
                        ->where('ense_goo_waretype', $vvvv->orgo_waon_class)
                        ->where('ense_order_number', $value->ord_order_number)
                        ->value('ense_end_price');
                    // 修改订单商品成本
                    $edit_data['orgo_goo_cost'] = $ense_end_price * 100;
                    $edit_data['orgo_update_time'] = $now_date;
                    $edit_res = DB::table('order_goods')
                        ->where('orgo_ord_id', $value->ord_id)
                        ->where('orgo_order_number', $value->ord_order_number)
                        ->where('orgo_id', $vvvv->orgo_id)
                        ->update($edit_data);
                    // dump($edit_res);
                    unset($edit_data);
                    unset($edit_res);
                }
                unset($find_orgo_data);
            }
        }
        unset($find_data);
        echo "成功";
    }

    // 修正商品流水记录数据
    public function enters2()
    {
        ignore_user_abort();
        set_time_limit(0);

        $find_ense_data = DB::table('enters_purchase')
            ->orderBy('ense_id', 'asc')
            ->get()->toArray();
        $find_ense_data = json_decode(json_encode($find_ense_data), true);
        $out_data = []; //第一次出库的数据
        $in_data = []; //第一次入库的数据
        $out_num = 0; //出库
        $in_num = 0; //入库

        $oure_numbers = true;
        $third_id = 1; //出入库记录的转换id
        $update_date = date('Y-m-d H:i:s');
        foreach ($find_ense_data as $key => $value) {
            if ($value['ense_goo_waretype'] != 1) {
                continue;
            }
            if (!isset($out_data[$value['ense_goo_warehouse']][$value['ense_goo_waretype']][$value['ense_goo_id']])) {
                $out_data[$value['ense_goo_warehouse']][$value['ense_goo_waretype']][$value['ense_goo_id']] = $value;
            } else {
                continue;
            }
            // dump($value);
            // 查询商品流水记录数据(出库)
            $find_out_data = DB::table('outin_details as a')
                ->leftJoin('outin_record as b', 'b.oure_id', '=', 'a.oude_oure_id')
                ->where('oure_shop_id', $value['ense_shop_id'])
                ->where('oure_out_ware_id', $value['ense_goo_warehouse'])
                ->where('oure_waon_class', $value['ense_goo_waretype'])
                ->where('oude_goo_id', $value['ense_goo_id'])
                ->select('oure_id', 'oure_number', 'oure_original_correlation_number', 'oure_create_time')
                ->orderBy('oure_create_time', 'asc')
                ->first();
            // dump($find_out_data);
            // 查询商品流水记录数据(入库)
            $find_in_data = DB::table('outin_details as a')
                ->leftJoin('outin_record as b', 'b.oure_id', '=', 'a.oude_oure_id')
                ->where('oure_shop_id', $value['ense_shop_id'])
                ->where('oure_in_ware_id', $value['ense_goo_warehouse'])
                ->where('oure_waon_class', $value['ense_goo_waretype'])
                ->where('oude_goo_id', $value['ense_goo_id'])
                ->where('oure_out_in_type', 2)
                ->where(function ($query) use ($oure_numbers) {
                    $query->where('oure_original_correlation_number', 'like', 'CG' . '%')
                        ->orwhere('oure_original_correlation_number', 'like', 'DB' . '%')
                        ->orwhere('oure_original_correlation_number', 'like', 'P' . '%');
                }) //仓库id
                ->select('oure_id', 'oure_number', 'oure_original_correlation_number', 'oure_create_time')
                ->orderBy('oure_create_time', 'asc')
                ->first();
            // dump($find_in_data);
            if (isset($find_out_data->oure_id) && isset($find_in_data->oure_id)) {
                if ($value['ense_goo_warehouse'] == 13) {
                    dump($value);
                    dump($find_out_data);
                    dump($find_in_data);
                }
                // 出库的主键id和创建时间调整(主表)
                $edit_out_data['oure_id'] = $third_id; //更改后主键id
                $edit_out_data['oure_create_time'] = $find_in_data->oure_create_time; //更改时间
                $edit_out_data['oure_update_time'] = $update_date;
                $edit_out_res = DB::table('outin_record')
                    ->where('oure_id', $find_out_data->oure_id)
                    ->update($edit_out_data);
                // 流水记录详情表(子表)
                $edit_oude_out_data['oude_oure_id'] = $third_id; //更改后主键id
                $edit_oude_out_data['oude_update_time'] = $update_date;
                $edit_oude_out_res = DB::table('outin_details')
                    ->where('oude_oure_id', $find_out_data->oure_id)
                    ->update($edit_oude_out_data);
                // dump($edit_out_res);
                unset($edit_out_data);
                unset($edit_out_res);
                unset($edit_oude_out_data);
                unset($edit_oude_out_res);
                // 入库的主键id和创建时间调整
                $edit_in_data['oure_id'] = $find_out_data->oure_id; //更改主键id
                $edit_in_data['oure_create_time'] = $find_out_data->oure_create_time; //更改时间
                $edit_out_data['oure_update_time'] = $update_date;
                $edit_in_res = DB::table('outin_record')
                    ->where('oure_id', $find_in_data->oure_id)
                    ->update($edit_in_data);
                // 流水记录详情表(子表)
                $edit_oude_in_data['oude_oure_id'] = $find_out_data->oure_id; //更改后主键id
                $edit_oude_in_data['oude_update_time'] = $update_date;
                $edit_oude_in_res = DB::table('outin_details')
                    ->where('oude_oure_id', $find_in_data->oure_id)
                    ->update($edit_oude_in_data);
                // dump($edit_in_res);
                unset($edit_in_data);
                unset($edit_in_res);
                unset($edit_oude_in_data);
                unset($edit_oude_in_res);
                // 修改出库的主键id
                $edit_out_data['oure_id'] = $find_in_data->oure_id; //更改后主键id
                $edit_out_data['oure_update_time'] = $update_date;
                $edit_out_res = DB::table('outin_record')
                    ->where('oure_id', $third_id)
                    ->update($edit_out_data);
                // 流水记录详情表(子表)
                $edit_oude_out_data['oude_oure_id'] = $find_in_data->oure_id; //更改后主键id
                $edit_oude_out_data['oude_update_time'] = $update_date;
                $edit_oude_out_res = DB::table('outin_details')
                    ->where('oude_oure_id', $third_id)
                    ->update($edit_oude_out_data);
                // dump($edit_out_res);
                unset($edit_out_data);
                unset($edit_out_res);
                unset($edit_oude_out_data);
                unset($edit_oude_out_res);
                $third_id = 1;
                $edit_enter_data['ense_in_amount'] = 159;
                $edit_enter_res = DB::table('enters_purchase')
                    ->where('ense_id', $value['ense_id'])
                    ->update($edit_enter_data);
                // dump($edit_enter_res);
                unset($edit_enter_data);
                unset($edit_enter_res);
                $update_edit_data[] = $value;
            } else {
                $new_out_data[] = $value;
            }
            unset($find_out_data);
            unset($find_in_data);
        }
        // dump($update_edit_data);
        // dump($new_out_data);
        echo '成功';
    }

    // 统计进销存
    public function enters(Request $request)
    {
        ignore_user_abort();
        set_time_limit(0);

        $search_data = $request->all();
        $ware_id = [9, 10, 11, 13, 14, 30, 37, 32, 33, 35, 40, 34, 36];

        $find_ense_data = DB::table('enters_sells_saves')
            ->where('ense_shop_id', 1)
            ->whereIn('ense_goo_warehouse', $ware_id)
            ->where(function ($query) use ($search_data) {
                //如果选择开始时间并且选择结束时间
                if (!empty($search_data['start_time']) && !empty($search_data['end_time'])) {
                    $query->whereBetween('ense_time', [$search_data['start_time'], $search_data['end_time'] . ' 23:59:59']);
                } else {
                    // 如果选择开始时间
                    if (!empty($search_data['start_time'])) {
                        $query->where('ense_time', '>=', $search_data['start_time']);
                    } else {
                        // 如果选择结束时间
                        if (!empty($search_data['end_time'])) {
                            $query->where('ense_time', '<=', $search_data['end_time'] . ' 23:59:59');
                        }
                    }
                }
            }) //创建时间
            ->orderBy('ense_id', 'asc')
            ->get()->toArray();
        $find_ense_data = json_decode(json_encode($find_ense_data), true);
        $out_data = []; //第一次出库的数据
        $in_data = []; //第一次入库的数据
        $out_num = 0; //出库
        $in_num = 0; //入库
        foreach ($find_ense_data as $key => $value) {
            // 出库
            if ($value['ense_end_inventory'] < 0 && $value['ense_end_price'] == 0 && $value['ense_out_in'] == 2) {
                if (!isset($out_data[$value['ense_goo_warehouse']][$value['ense_goo_waretype']][$value['ense_goo_id']])) {
                    // echo '12334';

                    $out_data[$value['ense_goo_warehouse']][$value['ense_goo_waretype']][$value['ense_goo_id']] = $value;
                    // dump($value);
                    // dump($out_data);
                    // exit;
                    $out_num++;
                    unset($value['ense_id']);
                    DB::table('enters_purchase')->insert($value);
                }
            }
            // 入库
            if ($value['ense_end_inventory'] < 0 && $value['ense_end_price'] == 0 && $value['ense_out_in'] == 1) {
                if (!isset($in_data[$value['ense_goo_warehouse']][$value['ense_goo_waretype']][$value['ense_goo_id']])) {
                    // echo '12334';
                    $in_data[$value['ense_goo_warehouse']][$value['ense_goo_waretype']][$value['ense_goo_id']] = $value;
                    // dump($value);
                    // dump($in_data);
                    // exit;
                    $in_num++;
                    unset($value['ense_id']);
                    DB::table('enters_purchase')->insert($value);
                }
            }
        }
        dump($out_num);
        dump($in_num);
        dump($out_data);
        // dump($in_data);
    }

    // 虚拟加盟店生成凭证
    public function workOrderVouchers()
    {
        $adm_cid = 1;
        $adm_shop_id = 1;

        ignore_user_abort();
        set_time_limit(0);
        // 查询工单表,完成已通过的数据
        $find_wor_data = DB::table('work_order as wor')
            ->leftjoin('work_client as wocl', 'wocl.wocl_wor_id', '=', 'wor.wor_id')
            ->where('wor_cid', $adm_cid)
            ->where('wor_shop_id', $adm_shop_id)
            ->where('wor_state', 10)
            ->where('wocl_wor_type', 4)
            // ->where('wor_id', '>=', 12019)
            // ->where('wor_id', '<', 15019)
            // ->where('wor_order_number', 'D2020111618331200209')
            ->select('wor_id', 'wor_cid', 'wor_superior_shop_id', 'wor_shop_id', 'wor_number', 'wor_order_id', 'wor_order_number', 'wor_create_id', 'wor_actual_price', 'wor_plus_minus', 'wor_recycle_price', 'wor_type', 'wor_collection_price', 'wor_update_time', 'wocl_client_id', 'wocl_channel_unit', 'wocl_name', 'wor_create_time', 'wor_service_shop_id')
            ->get()->toArray();
        DB::beginTransaction();
        $cost_price = 0;
        foreach ($find_wor_data as $key => $value) {
            // 凭证单据报表
            // 根据订单id和商品状态,查询出回收的商品
            $find_goods_data = DB::table('work_good')
                ->where('wogo_wor_id', $value->wor_id)
                ->where('wogo_state', 3)
                ->select('wogo_id', 'wogo_wor_id', 'wogo_ware_id', 'wogo_waon_class', 'wogo_goo_id', 'wogo_goo_price', 'wogo_goo_amount', 'wogo_recycle_price')
                ->get()->toArray();
            $goo_recycle_price = [];
            foreach ($find_goods_data as $kk => $vv) {
                if (!isset($goo_recycle_price[$vv->wogo_goo_id])) {
                    $goo_recycle_price[$vv->wogo_goo_id] = 0;
                }
                $goo_recycle_price[$vv->wogo_goo_id] += $vv->wogo_goo_price * $vv->wogo_goo_amount; //商品数量
            }
            $recycle_amount = 0;
            foreach ($goo_recycle_price as $kkk => $vvv) {
                $recycle_amount += $vvv;
            }
            // 根据订单id,查询商品
            $find_wogo_data = DB::table('work_good')
                ->where('wogo_wor_id', $value->wor_id)
                ->where('wogo_state', '!=', 2)
                ->select('wogo_id', 'wogo_wor_id', 'wogo_ware_id', 'wogo_waon_class', 'wogo_goo_id', 'wogo_goo_price', 'wogo_goo_amount', 'wogo_recycle_price', 'wogo_state')
                ->get()->toArray();
            // 根据订单id和单号,查询金额
            $find_order_price = DB::table('order')
                ->where('ord_cid', $adm_cid)
                ->where('ord_shop_id', $adm_shop_id)
                ->where('ord_id', $value->wor_order_id)
                ->where('ord_order_number', $value->wor_order_number)
                ->select('ord_actual_price', 'ord_plus_minus', 'ord_collection_price')
                ->first();
            if ($find_wogo_data) {
                // 判断凭证单据是否存在
                /* $vore_wor_id = DB::table('voucher_receipts')
                    ->where('vore_cid', $adm_cid)
                    ->where('vore_shop_id', $adm_shop_id)
                    ->where('vore_wor_id', $value->wor_id)
                    ->where('vore_wor_number', $value->wor_number)
                    ->where('vore_order_type', 2)
                    ->where('vore_state', 1)
                    ->select('vore_id', 'vore_wor_id', 'vore_wor_number')
                    ->first();
                // 判断凭证单据是否存在
                $vore_ord_id = DB::table('voucher_receipts')
                    ->where('vore_cid', $adm_cid)
                    ->where('vore_shop_id', $adm_shop_id)
                    ->where('vore_wor_id', $value->wor_id)
                    ->where('vore_wor_number', $value->wor_number)
                    ->where('vore_order_type', 1)
                    ->where('vore_state', 1)
                    ->select('vore_id', 'vore_wor_id', 'vore_wor_number')
                    ->first();
                if (empty($vore_wor_id) || empty($vore_ord_id)) {
                    // 订单生成凭证
                    $vore_data['vore_cid'] = $value->wor_cid;//公司id
                    $vore_data['vore_superior_shop_id'] = $value->wor_superior_shop_id;//总店id
                    $vore_data['vore_shop_id'] = $value->wor_shop_id;//门店id
                    $vore_data['vore_create_id'] = $value->wor_create_id;//创建人
                    $vore_data['vore_order_type'] = 1;//单号类型1.订单2.工单3.采购单4.销售单
                    $vore_data['vore_wor_id'] = $value->wor_id;//订单id
                    $vore_data['vore_wor_number'] = $value->wor_number;//订单单号
                    $vore_data['vore_ord_id'] = $value->wor_order_id;//订单id
                    $vore_data['vore_ord_number'] = $value->wor_order_number;//订单单号
                    $vore_data['vore_plus_minus'] = $find_order_price->ord_plus_minus;//金额正负1正值2负值
                    $vore_data['vore_actual_price'] = $find_order_price->ord_actual_price / 100;//结算金额
                    $vore_data['vore_collection_price'] = $value->wor_collection_price / 100;//代收金额
                    $vore_data['vore_recycle_price'] = $recycle_amount / 100;//回收金额
                    $vore_data['vore_early_costing'] = $cost_price;//成本
                    $vore_data['vore_type'] = $value->wor_type;//单位类型1会员零售2客户单位3速电派单
                    // 查询虚拟加盟店门店名称
                    $virtual_shop = DB::table('virtual_shop')
                        ->where('vish_id', $value->wor_service_shop_id)
                        ->select('vish_id', 'vish_store_name')
                        ->first();
                    if ($value->wor_type == 1) {//1.会员零售
                        $vore_data['vore_client_id'] = $value->wocl_client_id;//客户单位/客户id
                        $vore_data['vore_channel_unit'] = $value->wocl_name;
                    } elseif ($value->wor_type == 2) {//2.客户单位
                        $vore_data['vore_client_id'] = $value->wocl_client_id;//客户单位/客户id
                        $vore_data['vore_channel_unit'] = $value->wocl_name;
                    } elseif ($value->wor_type == 3) {//3.速电派单
                        $vore_data['vore_client_id'] = $value->wocl_client_id;//客户单位/客户id
                        $vore_data['vore_channel_unit'] = $value->wocl_channel_unit;
                    }
                    $vore_data['vore_create_time'] = $value->wor_create_time;
                    $vore_id = DB::table('voucher_receipts')->insertGetId($vore_data);
                    // 凭证借贷表(结算金额)
                    $volo_data[0]['volo_shop_id'] = $value->wor_shop_id;
                    $volo_data[0]['volo_vore_id'] = $vore_id;
                    $volo_data[0]['volo_type'] = 1;//类型1借方2贷方
                    $volo_data[0]['volo_borrow_subject'] = '1122';//借方科目
                    $volo_data[0]['volo_borrow_subject_name'] = '应收账款';//借方科目名称
                    $volo_data[0]['volo_loan_subject'] = '600101';//贷方科目
                    $volo_data[0]['volo_loan_subject_name'] = '主营业务收入';//贷方科目名称
                    $volo_data[0]['volo_update_time'] = $value->wor_create_time;//更新时间

                    if ($find_order_price->ord_plus_minus == 2) {
                        $volo_data[0]['volo_borrow_price'] = '-' . $find_order_price->ord_actual_price / 100;//借方金额
                        $volo_data[0]['volo_loan_price'] = '-' . $find_order_price->ord_actual_price / 100;//贷方金额
                    } else {
                        $volo_data[0]['volo_borrow_price'] = $find_order_price->ord_actual_price / 100;//借方金额
                        $volo_data[0]['volo_loan_price'] = $find_order_price->ord_actual_price / 100;//贷方金额
                    }

                    $volo_id = DB::table('voucher_loan')->insert($volo_data);
                    // 工单生成凭证
                    $vore_data['vore_cid'] = $value->wor_cid;//公司id
                    $vore_data['vore_superior_shop_id'] = $value->wor_superior_shop_id;//总店id
                    $vore_data['vore_shop_id'] = $value->wor_shop_id;//门店id
                    $vore_data['vore_create_id'] = $value->wor_create_id;//创建人
                    $vore_data['vore_order_type'] = 2;//单号类型1.订单2.工单3.采购单4.销售单
                    $vore_data['vore_wor_id'] = $value->wor_id;//订单id
                    $vore_data['vore_wor_number'] = $value->wor_number;//订单单号
                    $vore_data['vore_ord_id'] = $value->wor_order_id;//订单id
                    $vore_data['vore_ord_number'] = $value->wor_order_number;//订单单号
                    $vore_data['vore_plus_minus'] = $value->wor_plus_minus;//金额正负1正值2负值
                    $vore_data['vore_actual_price'] = $value->wor_actual_price / 100;//结算金额
                    $vore_data['vore_collection_price'] = $value->wor_collection_price / 100;//代收金额
                    $vore_data['vore_recycle_price'] = $recycle_amount / 100;//回收金额
                    $vore_data['vore_early_costing'] = $cost_price;//成本
                    $vore_data['vore_type'] = $value->wor_type;//单位类型1会员零售2客户单位3速电派单
                    // 查询虚拟加盟店门店名称
                    $virtual_shop = DB::table('virtual_shop')
                        ->where('vish_id', $value->wor_service_shop_id)
                        ->select('vish_id', 'vish_store_name')
                        ->first();
                    if ($value->wor_type == 1) {//1.会员零售
                        $vore_data['vore_client_id'] = $value->wocl_client_id;//客户单位/客户id
                        $vore_data['vore_channel_unit'] = $value->wocl_name;
                    } elseif ($value->wor_type == 2) {//2.客户单位
                        $vore_data['vore_client_id'] = $virtual_shop->vish_id;//客户单位/客户id
                        $vore_data['vore_channel_unit'] = $virtual_shop->vish_store_name;
                    } elseif ($value->wor_type == 3) {//3.速电派单
                        $vore_data['vore_client_id'] = $value->wocl_client_id;//客户单位/客户id
                        $vore_data['vore_channel_unit'] = $value->wocl_channel_unit;
                    }
                    $vore_data['vore_create_time'] = $value->wor_create_time;
                    $vore_id = DB::table('voucher_receipts')->insertGetId($vore_data);
                    // 凭证借贷表(结算金额)
                    $volo_data[0]['volo_shop_id'] = $value->wor_shop_id;
                    $volo_data[0]['volo_vore_id'] = $vore_id;
                    $volo_data[0]['volo_type'] = 1;//类型1借方2贷方
                    $volo_data[0]['volo_borrow_subject'] = '1122';//借方科目
                    $volo_data[0]['volo_borrow_subject_name'] = '应收账款';//借方科目名称
                    $volo_data[0]['volo_loan_subject'] = '600101';//贷方科目
                    $volo_data[0]['volo_loan_subject_name'] = '主营业务收入';//贷方科目名称
                    $volo_data[0]['volo_update_time'] = $value->wor_create_time;//更新时间

                    if ($value->wor_plus_minus == 2) {
                        $volo_data[0]['volo_borrow_price'] = '-' . $value->wor_actual_price / 100;//借方金额
                        $volo_data[0]['volo_loan_price'] = '-' . $value->wor_actual_price / 100;//贷方金额
                    } else {
                        $volo_data[0]['volo_borrow_price'] = $value->wor_actual_price / 100;//借方金额
                        $volo_data[0]['volo_loan_price'] = $value->wor_actual_price / 100;//贷方金额
                    }

                    $volo_id = DB::table('voucher_loan')->insert($volo_data);
                } else {
                    $vore_id = true;
                    $volo_id = true;
                } */
            } else {
                // 判断凭证单据是否存在
                $vore_wor_id = DB::table('voucher_receipts')
                    ->where('vore_cid', $adm_cid)
                    ->where('vore_shop_id', $adm_shop_id)
                    ->where('vore_wor_id', $value->wor_id)
                    ->where('vore_wor_number', $value->wor_number)
                    ->where('vore_order_type', 2)
                    ->where('vore_state', 1)
                    ->select('vore_id', 'vore_wor_id', 'vore_wor_number')
                    ->first();
                // 判断凭证单据是否存在
                $vore_ord_id = DB::table('voucher_receipts')
                    ->where('vore_cid', $adm_cid)
                    ->where('vore_shop_id', $adm_shop_id)
                    ->where('vore_wor_id', $value->wor_id)
                    ->where('vore_wor_number', $value->wor_number)
                    ->where('vore_order_type', 1)
                    ->where('vore_state', 1)
                    ->select('vore_id', 'vore_wor_id', 'vore_wor_number')
                    ->first();
                if (empty($vore_wor_id) || empty($vore_ord_id)) {
                    // 订单生成凭证
                    $vore_data['vore_cid'] = $value->wor_cid; //公司id
                    $vore_data['vore_superior_shop_id'] = $value->wor_superior_shop_id; //总店id
                    $vore_data['vore_shop_id'] = $value->wor_shop_id; //门店id
                    $vore_data['vore_create_id'] = $value->wor_create_id; //创建人
                    $vore_data['vore_order_type'] = 1; //单号类型1.订单2.工单3.采购单4.销售单
                    $vore_data['vore_wor_id'] = $value->wor_id; //订单id
                    $vore_data['vore_wor_number'] = $value->wor_number; //订单单号
                    $vore_data['vore_ord_id'] = $value->wor_order_id; //订单id
                    $vore_data['vore_ord_number'] = $value->wor_order_number; //订单单号
                    $vore_data['vore_plus_minus'] = $find_order_price->ord_plus_minus; //金额正负1正值2负值
                    $vore_data['vore_actual_price'] = $find_order_price->ord_actual_price / 100; //结算金额
                    $vore_data['vore_collection_price'] = $value->wor_collection_price / 100; //代收金额
                    $vore_data['vore_recycle_price'] = $recycle_amount / 100; //回收金额
                    $vore_data['vore_early_costing'] = $cost_price; //成本
                    $vore_data['vore_type'] = $value->wor_type; //单位类型1会员零售2客户单位3速电派单
                    // 查询虚拟加盟店门店名称
                    $virtual_shop = DB::table('virtual_shop')
                        ->where('vish_id', $value->wor_service_shop_id)
                        ->select('vish_id', 'vish_store_name')
                        ->first();
                    if ($value->wor_type == 1) { //1.会员零售
                        $vore_data['vore_client_id'] = $value->wocl_client_id; //客户单位/客户id
                        $vore_data['vore_channel_unit'] = $value->wocl_name;
                    } elseif ($value->wor_type == 2) { //2.客户单位
                        $vore_data['vore_client_id'] = $value->wocl_client_id; //客户单位/客户id
                        $vore_data['vore_channel_unit'] = $value->wocl_name;
                    } elseif ($value->wor_type == 3) { //3.速电派单
                        $vore_data['vore_client_id'] = $value->wocl_client_id; //客户单位/客户id
                        $vore_data['vore_channel_unit'] = $value->wocl_channel_unit;
                    }
                    $vore_data['vore_create_time'] = $value->wor_create_time;
                    $vore_id = DB::table('voucher_receipts')->insertGetId($vore_data);
                    // 凭证借贷表(结算金额)
                    $volo_data[0]['volo_shop_id'] = $value->wor_shop_id;
                    $volo_data[0]['volo_vore_id'] = $vore_id;
                    $volo_data[0]['volo_type'] = 1; //类型1借方2贷方
                    $volo_data[0]['volo_borrow_subject'] = '1122'; //借方科目
                    $volo_data[0]['volo_borrow_subject_name'] = '应收账款'; //借方科目名称
                    $volo_data[0]['volo_loan_subject'] = '600101'; //贷方科目
                    $volo_data[0]['volo_loan_subject_name'] = '主营业务收入'; //贷方科目名称
                    $volo_data[0]['volo_update_time'] = $value->wor_create_time; //更新时间

                    if ($find_order_price->ord_actual_price < 0) {
                        $volo_data[0]['volo_borrow_price'] = '-' . $find_order_price->ord_actual_price / 100; //借方金额
                        $volo_data[0]['volo_loan_price'] = '-' . $find_order_price->ord_actual_price / 100; //贷方金额
                    } else {
                        $volo_data[0]['volo_borrow_price'] = $find_order_price->ord_actual_price / 100; //借方金额
                        $volo_data[0]['volo_loan_price'] = $find_order_price->ord_actual_price / 100; //贷方金额
                    }

                    $volo_id = DB::table('voucher_loan')->insert($volo_data);
                    // 工单生成凭证
                    $vore_data['vore_cid'] = $value->wor_cid; //公司id
                    $vore_data['vore_superior_shop_id'] = $value->wor_superior_shop_id; //总店id
                    $vore_data['vore_shop_id'] = $value->wor_shop_id; //门店id
                    $vore_data['vore_create_id'] = $value->wor_create_id; //创建人
                    $vore_data['vore_order_type'] = 2; //单号类型1.订单2.工单3.采购单4.销售单
                    $vore_data['vore_wor_id'] = $value->wor_id; //订单id
                    $vore_data['vore_wor_number'] = $value->wor_number; //订单单号
                    $vore_data['vore_ord_id'] = $value->wor_order_id; //订单id
                    $vore_data['vore_ord_number'] = $value->wor_order_number; //订单单号
                    $vore_data['vore_plus_minus'] = $value->wor_plus_minus; //金额正负1正值2负值
                    $vore_data['vore_actual_price'] = $value->wor_actual_price / 100; //结算金额
                    $vore_data['vore_collection_price'] = $value->wor_collection_price / 100; //代收金额
                    $vore_data['vore_recycle_price'] = $recycle_amount / 100; //回收金额
                    $vore_data['vore_early_costing'] = $cost_price; //成本
                    $vore_data['vore_type'] = $value->wor_type; //单位类型1会员零售2客户单位3速电派单
                    // 查询虚拟加盟店门店名称
                    $virtual_shop = DB::table('virtual_shop')
                        ->where('vish_id', $value->wor_service_shop_id)
                        ->select('vish_id', 'vish_store_name')
                        ->first();
                    if ($value->wor_type == 1) { //1.会员零售
                        $vore_data['vore_client_id'] = $value->wocl_client_id; //客户单位/客户id
                        $vore_data['vore_channel_unit'] = $value->wocl_name;
                    } elseif ($value->wor_type == 2) { //2.客户单位
                        $vore_data['vore_client_id'] = $virtual_shop->vish_id; //客户单位/客户id
                        $vore_data['vore_channel_unit'] = $virtual_shop->vish_store_name;
                    } elseif ($value->wor_type == 3) { //3.速电派单
                        $vore_data['vore_client_id'] = $value->wocl_client_id; //客户单位/客户id
                        $vore_data['vore_channel_unit'] = $value->wocl_channel_unit;
                    }
                    $vore_data['vore_create_time'] = $value->wor_create_time;
                    $vore_id = DB::table('voucher_receipts')->insertGetId($vore_data);
                    // 凭证借贷表(结算金额)
                    $volo_data[0]['volo_shop_id'] = $value->wor_shop_id;
                    $volo_data[0]['volo_vore_id'] = $vore_id;
                    $volo_data[0]['volo_type'] = 1; //类型1借方2贷方
                    $volo_data[0]['volo_borrow_subject'] = '1122'; //借方科目
                    $volo_data[0]['volo_borrow_subject_name'] = '应收账款'; //借方科目名称
                    $volo_data[0]['volo_loan_subject'] = '600101'; //贷方科目
                    $volo_data[0]['volo_loan_subject_name'] = '主营业务收入'; //贷方科目名称
                    $volo_data[0]['volo_update_time'] = $value->wor_create_time; //更新时间

                    if ($value->wor_actual_price < 0) {
                        $volo_data[0]['volo_borrow_price'] = '-' . $value->wor_actual_price / 100; //借方金额
                        $volo_data[0]['volo_loan_price'] = '-' . $value->wor_actual_price / 100; //贷方金额
                    } else {
                        $volo_data[0]['volo_borrow_price'] = $value->wor_actual_price / 100; //借方金额
                        $volo_data[0]['volo_loan_price'] = $value->wor_actual_price / 100; //贷方金额
                    }

                    $volo_id = DB::table('voucher_loan')->insert($volo_data);
                } else {
                    $vore_id = true;
                    $volo_id = true;
                }
            }
        }
        echo '9090';
        if ($vore_id && $volo_id) {
            DB::commit();
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>'生成凭证成功']);
        } else {
            DB::rollBack();
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'生成凭证失败']);
        }
    }
    /* public function workOrderVouchers()
    {
        $adm_cid = 1;
        $adm_shop_id = 1;

        ignore_user_abort();
        set_time_limit(0);
        // 查询工单表,完成已通过的数据
        $find_wor_data = DB::table('work_order as wor')
            ->leftjoin('work_client as wocl', 'wocl.wocl_wor_id', '=', 'wor.wor_id')
            ->where('wor_cid', $adm_cid)
            ->where('wor_shop_id', $adm_shop_id)
            ->where('wor_state', 10)
            ->where('wocl_wor_type', 4)
            // ->where('wor_id', '>=', 12019)
            // ->where('wor_id', '<', 15019)
            ->select('wor_id', 'wor_cid', 'wor_superior_shop_id', 'wor_shop_id', 'wor_number', 'wor_order_id', 'wor_order_number', 'wor_create_id', 'wor_actual_price', 'wor_plus_minus', 'wor_recycle_price', 'wor_type', 'wor_collection_price', 'wor_update_time', 'wocl_client_id', 'wocl_channel_unit', 'wocl_name', 'wor_create_time', 'wor_service_shop_id')
            ->get()->toArray();
        DB::beginTransaction();
        $cost_price = 0;
        foreach ($find_wor_data as $key => $value) {
            // 凭证单据报表
            // 根据订单id和商品状态,查询出回收的商品
            $find_goods_data = DB::table('work_good')
                ->where('wogo_wor_id', $value->wor_id)
                ->where('wogo_state', 3)
                ->select('wogo_id', 'wogo_wor_id', 'wogo_ware_id', 'wogo_waon_class', 'wogo_goo_id', 'wogo_goo_price', 'wogo_goo_amount', 'wogo_recycle_price')
                ->get()->toArray();
            $goo_recycle_price = [];
            foreach ($find_goods_data as $kk => $vv) {
                if (!isset($goo_recycle_price[$vv->wogo_goo_id])) {
                    $goo_recycle_price[$vv->wogo_goo_id] = 0;
                }
                $goo_recycle_price[$vv->wogo_goo_id] += $vv->wogo_goo_price * $vv->wogo_goo_amount;//商品数量
            }
            $recycle_amount = 0;
            foreach ($goo_recycle_price as $kkk => $vvv) {
                $recycle_amount += $vvv;
            }
            // 根据订单id,查询商品
            $find_wogo_data = DB::table('work_good')
                ->where('wogo_wor_id', $value->wor_id)
                ->where('wogo_state', '!=', 2)
                ->select('wogo_id', 'wogo_wor_id', 'wogo_ware_id', 'wogo_waon_class', 'wogo_goo_id', 'wogo_goo_price', 'wogo_goo_amount', 'wogo_recycle_price', 'wogo_state')
                ->get()->toArray();
            // 根据订单id和单号,查询金额
            $find_order_price = DB::table('order')
                ->where('ord_cid', $adm_cid)
                ->where('ord_shop_id', $adm_shop_id)
                ->where('ord_id', $value->wor_order_id)
                ->where('ord_order_number', $value->wor_order_number)
                ->select('ord_actual_price', 'ord_plus_minus', 'ord_collection_price')
                ->first();
            if ($find_wogo_data) {
                // 判断凭证单据是否存在
                $vore_wor_id = DB::table('voucher_receipts')
                    ->where('vore_cid', $adm_cid)
                    ->where('vore_shop_id', $adm_shop_id)
                    ->where('vore_wor_id', $value->wor_id)
                    ->where('vore_wor_number', $value->wor_number)
                    ->where('vore_order_type', 2)
                    ->where('vore_state', 1)
                    ->select('vore_id', 'vore_wor_id', 'vore_wor_number')
                    ->first();
                // 判断凭证单据是否存在
                $vore_ord_id = DB::table('voucher_receipts')
                    ->where('vore_cid', $adm_cid)
                    ->where('vore_shop_id', $adm_shop_id)
                    ->where('vore_wor_id', $value->wor_id)
                    ->where('vore_wor_number', $value->wor_number)
                    ->where('vore_order_type', 1)
                    ->where('vore_state', 1)
                    ->select('vore_id', 'vore_wor_id', 'vore_wor_number')
                    ->first();
                if (empty($vore_wor_id) || empty($vore_ord_id)) {
                    // 订单生成凭证
                    $vore_data['vore_cid'] = $value->wor_cid;//公司id
                    $vore_data['vore_superior_shop_id'] = $value->wor_superior_shop_id;//总店id
                    $vore_data['vore_shop_id'] = $value->wor_shop_id;//门店id
                    $vore_data['vore_create_id'] = $value->wor_create_id;//创建人
                    $vore_data['vore_order_type'] = 1;//单号类型1.订单2.工单3.采购单4.销售单
                    $vore_data['vore_wor_id'] = $value->wor_id;//订单id
                    $vore_data['vore_wor_number'] = $value->wor_number;//订单单号
                    $vore_data['vore_ord_id'] = $value->wor_order_id;//订单id
                    $vore_data['vore_ord_number'] = $value->wor_order_number;//订单单号
                    $vore_data['vore_plus_minus'] = $find_order_price->ord_plus_minus;//金额正负1正值2负值
                    $vore_data['vore_actual_price'] = $find_order_price->ord_actual_price / 100;//结算金额
                    $vore_data['vore_collection_price'] = $value->wor_collection_price / 100;//代收金额
                    $vore_data['vore_recycle_price'] = $recycle_amount / 100;//回收金额
                    $vore_data['vore_early_costing'] = $cost_price;//成本
                    $vore_data['vore_type'] = $value->wor_type;//单位类型1会员零售2客户单位3速电派单
                    // 查询虚拟加盟店门店名称
                    $virtual_shop = DB::table('virtual_shop')
                        ->where('vish_id', $value->wor_service_shop_id)
                        ->select('vish_id', 'vish_store_name')
                        ->first();
                    if ($value->wor_type == 1) {//1.会员零售
                        $vore_data['vore_client_id'] = $value->wocl_client_id;//客户单位/客户id
                        $vore_data['vore_channel_unit'] = $value->wocl_name;
                    } elseif ($value->wor_type == 2) {//2.客户单位
                        $vore_data['vore_client_id'] = $value->wocl_client_id;//客户单位/客户id
                        $vore_data['vore_channel_unit'] = $value->wocl_name;
                    } elseif ($value->wor_type == 3) {//3.速电派单
                        $vore_data['vore_client_id'] = $value->wocl_client_id;//客户单位/客户id
                        $vore_data['vore_channel_unit'] = $value->wocl_channel_unit;
                    }
                    $vore_data['vore_create_time'] = $value->wor_create_time;
                    $vore_id = DB::table('voucher_receipts')->insertGetId($vore_data);
                    // 凭证借贷表(结算金额)
                    $volo_data[0]['volo_shop_id'] = $value->wor_shop_id;
                    $volo_data[0]['volo_vore_id'] = $vore_id;
                    $volo_data[0]['volo_type'] = 1;//类型1借方2贷方
                    $volo_data[0]['volo_borrow_subject'] = '1122';//借方科目
                    $volo_data[0]['volo_borrow_subject_name'] = '应收账款';//借方科目名称
                    $volo_data[0]['volo_loan_subject'] = '600101';//贷方科目
                    $volo_data[0]['volo_loan_subject_name'] = '主营业务收入';//贷方科目名称
                    $volo_data[0]['volo_update_time'] = $value->wor_create_time;//更新时间

                    if ($find_order_price->ord_plus_minus == 2) {
                        $volo_data[0]['volo_borrow_price'] = '-' . $find_order_price->ord_actual_price / 100;//借方金额
                        $volo_data[0]['volo_loan_price'] = '-' . $find_order_price->ord_actual_price / 100;//贷方金额
                    } else {
                        $volo_data[0]['volo_borrow_price'] = $find_order_price->ord_actual_price / 100;//借方金额
                        $volo_data[0]['volo_loan_price'] = $find_order_price->ord_actual_price / 100;//贷方金额
                    }

                    $volo_id = DB::table('voucher_loan')->insert($volo_data);
                    // 工单生成凭证
                    $vore_data['vore_cid'] = $value->wor_cid;//公司id
                    $vore_data['vore_superior_shop_id'] = $value->wor_superior_shop_id;//总店id
                    $vore_data['vore_shop_id'] = $value->wor_shop_id;//门店id
                    $vore_data['vore_create_id'] = $value->wor_create_id;//创建人
                    $vore_data['vore_order_type'] = 2;//单号类型1.订单2.工单3.采购单4.销售单
                    $vore_data['vore_wor_id'] = $value->wor_id;//订单id
                    $vore_data['vore_wor_number'] = $value->wor_number;//订单单号
                    $vore_data['vore_ord_id'] = $value->wor_order_id;//订单id
                    $vore_data['vore_ord_number'] = $value->wor_order_number;//订单单号
                    $vore_data['vore_plus_minus'] = $value->wor_plus_minus;//金额正负1正值2负值
                    $vore_data['vore_actual_price'] = $value->wor_actual_price / 100;//结算金额
                    $vore_data['vore_collection_price'] = $value->wor_collection_price / 100;//代收金额
                    $vore_data['vore_recycle_price'] = $recycle_amount / 100;//回收金额
                    $vore_data['vore_early_costing'] = $cost_price;//成本
                    $vore_data['vore_type'] = $value->wor_type;//单位类型1会员零售2客户单位3速电派单
                    // 查询虚拟加盟店门店名称
                    $virtual_shop = DB::table('virtual_shop')
                        ->where('vish_id', $value->wor_service_shop_id)
                        ->select('vish_id', 'vish_store_name')
                        ->first();
                    if ($value->wor_type == 1) {//1.会员零售
                        $vore_data['vore_client_id'] = $value->wocl_client_id;//客户单位/客户id
                        $vore_data['vore_channel_unit'] = $value->wocl_name;
                    } elseif ($value->wor_type == 2) {//2.客户单位
                        $vore_data['vore_client_id'] = $virtual_shop->vish_id;//客户单位/客户id
                        $vore_data['vore_channel_unit'] = $virtual_shop->vish_store_name;
                    } elseif ($value->wor_type == 3) {//3.速电派单
                        $vore_data['vore_client_id'] = $value->wocl_client_id;//客户单位/客户id
                        $vore_data['vore_channel_unit'] = $value->wocl_channel_unit;
                    }
                    $vore_data['vore_create_time'] = $value->wor_create_time;
                    $vore_id = DB::table('voucher_receipts')->insertGetId($vore_data);
                    // 凭证借贷表(结算金额)
                    $volo_data[0]['volo_shop_id'] = $value->wor_shop_id;
                    $volo_data[0]['volo_vore_id'] = $vore_id;
                    $volo_data[0]['volo_type'] = 1;//类型1借方2贷方
                    $volo_data[0]['volo_borrow_subject'] = '1122';//借方科目
                    $volo_data[0]['volo_borrow_subject_name'] = '应收账款';//借方科目名称
                    $volo_data[0]['volo_loan_subject'] = '600101';//贷方科目
                    $volo_data[0]['volo_loan_subject_name'] = '主营业务收入';//贷方科目名称
                    $volo_data[0]['volo_update_time'] = $value->wor_create_time;//更新时间

                    if ($value->wor_plus_minus == 2) {
                        $volo_data[0]['volo_borrow_price'] = '-' . $value->wor_actual_price / 100;//借方金额
                        $volo_data[0]['volo_loan_price'] = '-' . $value->wor_actual_price / 100;//贷方金额
                    } else {
                        $volo_data[0]['volo_borrow_price'] = $value->wor_actual_price / 100;//借方金额
                        $volo_data[0]['volo_loan_price'] = $value->wor_actual_price / 100;//贷方金额
                    }

                    $volo_id = DB::table('voucher_loan')->insert($volo_data);
                } else {
                    $vore_id = true;
                    $volo_id = true;
                }
            } else {
                $vore_id = true;
                $volo_id = true;
            }
        }
        echo '9090';
        if ($vore_id && $volo_id) {
            DB::commit();
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>'生成凭证成功']);
        } else {
            DB::rollBack();
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'生成凭证失败']);
        }
    } */

    // 查询工单已完成，没有流水记录的数据
    public function order21()
    {
        ignore_user_abort();
        set_time_limit(0);

        $find_data = DB::table('work_good as wogo')
            ->leftjoin('work_order as wor', 'wogo.wogo_wor_id', '=', 'wor.wor_id')
            ->leftjoin('work_client as wocl', 'wocl.wocl_wor_id', '=', 'wor.wor_id')
            ->leftjoin('warehouse as ware', 'ware.ware_id', '=', 'wor.wor_service_adm_id')
            ->where('wor_cid', 1)
            ->where('wor_superior_shop_id', 1)
            ->where('wor_shop_id', 1)
            ->whereIn('wor_state', [8, 10])
            ->where('wor_delete', 1)
            ->where('wor_collection_bill', 1)
            ->where('wocl_wor_type', 1)
            // ->where('wor_id', '>', 25396)
            ->where('wor_id', '<', 28748)
            ->where('wor_goo_amount', '>=', 1)
            ->where('wor_achieve_time', '>', '2021-01-20 00:00:00')
            ->select('wor_id', 'wor_number', 'wor_order_id', 'wor_order_number', 'wor_type', 'wocl_client_id', 'wogo_goo_id', 'wogo_goo_amount', 'wogo_goo_inventory', 'wor_service_adm_id', 'ware_name', 'wor_create_time', 'wogo_waon_class', 'wor_achieve_time', 'wogo_state')
            ->get()->toArray();
        // dump($find_data);
        foreach ($find_data as $key => $value) {
            if ($value->wogo_state == 2 || $value->wogo_state == 3) {
                continue;
            }
            // 根据技师id去仓库表查询
            $ware_id = DB::table('warehouse')
                ->where('ware_leader_id', $value->wor_service_adm_id)
                ->where('ware_type', 2)
                ->value('ware_id');
            $value->ware_id = $ware_id;
            // 查询流水记录
            $find_oure_data = DB::table('outin_record')
                ->where('oure_original_number', $value->wor_number)
                ->where('oure_out_ware_id', $value->ware_id)
                ->where('oure_out_in_type', 1)
                ->where('oure_type', 10)
                ->select('oure_id', 'oure_number', 'oure_original_number')
                ->first();
            if (empty($find_oure_data->oure_original_number)) {
                if (isset($work_wago_class_goods[$value->wor_id][$value->wogo_waon_class][$value->wogo_goo_id])) {
                    $work_wago_class_goods[$value->wor_id][$value->wogo_waon_class][$value->wogo_goo_id]['wogo_goo_amount'] = $work_wago_class_goods[$value->wor_id][$value->wogo_waon_class][$value->wogo_goo_id]['wogo_goo_amount'] + $value->wogo_goo_amount; //仓库类型对应的商品，出入库记录
                } else {
                    $work_wago_class_goods[$value->wor_id][$value->wogo_waon_class][$value->wogo_goo_id] = (array)$value; //仓库类型对应的商品，出入库记录
                }
            } else {
                // dump($find_oure_data);
                // $new_data[$find_oure_data->oure_id] = $find_oure_data;
                // $oure_res = DB::table('outin_record')
                //     ->where('oure_id', $find_oure_data->oure_id)
                //     ->delete();

                // $oude_res = DB::table('outin_details')
                //     ->where('oude_oure_id', $find_oure_data->oure_id)
                //     ->delete();
            }
        }
        // echo "2324";
        // dump($work_wago_class_goods);
        // dump($work_wago_class_goods);
        // exit;
        // dump($new_data);
        // exit;
        // 操作日志
        // $data['request_all'] = $work_wago_class_goods;
        // logRecord($data, 'work_wago_class_goodsshuj', 2);
        // exit;
        // 遍历仓库类型数据，处理固定仓库对应仓库类型的出入库记录
        $oure_total = 0;
        foreach ($work_wago_class_goods as $key => $wago_class_goods) {
            foreach ($wago_class_goods as $waon_class_key => $class_goods_data) {
                // dump($class_goods_data);
                // exit;
                // 查询仓库类别的进销存计算方式
                $goo_all_amount = 0;
                foreach ($class_goods_data as $goo_id_key => $value) {
                    // dump($value);
                    // exit;
                    // 出入库记录需要的的商品数组
                    $oure_goods_dataarray[$waon_class_key][$goo_id_key]['goo_quantity'] = $value['wogo_goo_amount']; //出入库商品数量
                    $oure_goods_dataarray[$waon_class_key][$goo_id_key]['goo_inventory'] = 1; //出入库商品类型，类型1良品2优先，页面没有用到这个，暂定1
                    $goo_all_amount += $value['wogo_goo_amount'];

                    // 出入库记录需要
                    $oure_goods_id[$goo_id_key] = $value['wogo_goo_id']; //出入库商品id
                    $oure_goods_quantity[$goo_id_key] = $value['wogo_goo_amount']; //出入库商品数量
                    $oure_goods_inventory[$goo_id_key] = $value['wogo_goo_inventory']; //出入库商品类型，类型1良品2优先，页面没有用到这个，暂定1
                }
                // $oure_total++;
                // 根据技师id去仓库表查询
                $adm_id = $value['wor_service_adm_id'];
                $wor_order_id = $value['wor_order_id'];
                $wor_order_number = $value['wor_order_number'];
                $wor_type = $value['wor_type'];
                $wocl_client_id = $value['wocl_client_id'];
                $wor_number = $value['wor_number'];
                $wor_achieve_time = $value['wor_achieve_time'];
                $ware_id = $value['ware_id'];
                $find_ware = DB::table('warehouse_onhand')
                    ->where('waon_ware_id', $ware_id)
                    ->where('waon_class', $waon_class_key)
                    ->select('waon_stock_fine_amount', 'waon_lock_fine_amount', 'waon_stock_unchecked_amount', 'waon_stock_priority_amount', 'waon_lock_priority_amount')
                    ->first();
                $oure_goods_data = $oure_goods_dataarray[$waon_class_key];
                $oure_class_goo_id = array_keys($oure_goods_data);

                // dump($adm_id);
                // dump($wor_order_id);
                // dump($wor_order_number);
                // dump($wor_type);
                // dump($wocl_client_id);
                // dump($wor_number);
                // dump($ware_id);
                // dump($waon_class_key);
                // dump($oure_goods_id);
                // dump($oure_goods_quantity);
                // dump($oure_goods_inventory);
                // dump($oure_class_goo_id);
                // echo '======<br/>';
                // if ($oure_total > 100) {
                //     exit;
                // }
                // exit;
                $oure_res = $this->additions(
                    $adm_id, //用户信息
                    $wor_order_id, //原始单的关联id
                    $wor_order_number, //原始单的关联单号
                    1, //原始单的关联类型1.订单2.调拨单3.采购单4.销售单5.旧货回收6.退货入库7.售后
                    $wor_type, //买家类型：1.会员零售2.客户单位3.速电派单4.第三方派单
                    $wocl_client_id, //选择的客户id,会员id/单位id
                    $wor_number, //原始单号
                    0, //入库仓库id
                    $ware_id, //出库仓库id
                    $goo_all_amount, //出库的商品总数量
                    10, //类型 5.退换回收单 9发货单 11换货出库12换货入库13退货入库14退货出库
                    2, //操作类型：1锁定库存2出库3入库4调货5发货
                    $find_ware->waon_stock_fine_amount, //良品总库存
                    $find_ware->waon_lock_fine_amount, //良品锁定数量
                    $find_ware->waon_stock_priority_amount, //优先总库存
                    $find_ware->waon_lock_priority_amount, //优先锁定数量
                    $find_ware->waon_stock_unchecked_amount, //待检测总库存
                    $wor_achieve_time, //待检测总库存
                    1, //出入库类型：1出库，2入库
                    $waon_class_key, //仓库类别
                    $oure_goods_id, //商品id
                    $oure_goods_quantity, //商品数量
                    $oure_goods_inventory, //出库类型1良品2优先
                    $oure_class_goo_id //仓库类别下的商品id
                );
                unset($adm_id);
                unset($wor_order_id);
                unset($wor_order_number);
                unset($wor_type);
                unset($wocl_client_id);
                unset($wor_number);
                unset($ware_id);
                unset($goo_all_amount);
                unset($find_ware);
                unset($wor_achieve_time);
                unset($waon_class_key);
                unset($oure_goods_id);
                unset($oure_goods_quantity);
                unset($oure_goods_inventory);
                unset($oure_class_goo_id);
                unset($oure_goods_dataarray);
            }
        }
        echo "成功";
    }

    /**
     * [addition 添加出入库记录]
     * @param  [type] $user_info                        [用户信息]
     * @param  [type] $adm_id                           [操作人id]
     * @param  [type] $oure_original_correlation_id     [原始单的关联id]
     * @param  [type] $oure_original_correlation_number [原始单的关联单号]
     * @param  [type] $oure_original_correlation_type   [原始单的关联类型1.订单2.调拨单3.采购单4.销售单5.旧货回收6.退货入库7.售后]
     * @param  [type] $oure_client_type                 [买家类型：1.会员零售2.客户单位3.速电派单4.第三方派单]
     * @param  [type] $oure_client_id                   [选择的客户id,会员id/单位id]
     * @param  [type] $oure_original_number             [原始单号]
     * @param  [type] $oure_in_ware_id                  [入库仓库id]
     * @param  [type] $oure_out_ware_id                 [出库仓库id]
     * @param  [type] $oure_waon_class                  [仓库类别]
     * @param  [type] $oure_count                       [出库的商品总量]
     * @param  [type] $oure_type                        [类型1.入库单 2.出库单 3.调货单 4.旧货回收单 5.退换回收单 6.订单出库 7.部分入库 8.部分出库 9.发货单]
     * @param  [type] $goods_data                       [数组，商品数据，['商品id'=>['商品出库数量','出库类型']]]
     * @param  [type] $oure_operation_type              [操作类型：1锁定库存2出库3入库4调货5发货]
     * @param  [type] $oure_all_stock                   [良品总库存]
     * @param  [type] $oure_lock_quantity               [良品锁定数量]
     * @param  [type] $oure_priority_all_stock          [优先总库存]
     * @param  [type] $oure_priority_lock_quantity      [优先锁定数量]
     * @param  [type] $oure_unchecked_all_stock         [待检测总库存]
     * @param  [type] $times                            [创建时间]
     * @param  [type] $oure_out_in_type                 [出入库类型：1出库，2入库]
     * @return [type]                                   [description]
     */
    public static function additions(
        $adm_id,
        $oure_original_correlation_id,
        $oure_original_correlation_number,
        $oure_original_correlation_type,
        $oure_client_type,
        $oure_client_id,
        $oure_original_number,
        $oure_in_ware_id,
        $oure_out_ware_id,
        $oure_count,
        $oure_type,
        $oure_operation_type,
        $oure_all_stock,
        $oure_lock_quantity,
        $oure_priority_all_stock,
        $oure_priority_lock_quantity,
        $oure_unchecked_all_stock,
        $times,
        $oure_out_in_type,
        $oure_waon_class,
        $goo_id,
        $goo_quantity,
        $goo_inventory,
        $oure_class_goo_id = []
    ) {
        // 生成出入库记录
        $number = time() . rand(10000, 99999); //共15位
        // 出入库记录表新增数据
        $record['oure_cid'] = 1; //公司id
        $record['oure_shop_id'] = 1; //门店id
        $record['oure_superior_shop_id'] = 1; //门店id
        $record['oure_adm_id'] = $adm_id; //操作人
        $record['oure_number'] = $number; //单号
        $record['oure_original_correlation_id'] = $oure_original_correlation_id; //原始单的关联id
        $record['oure_original_correlation_number'] = $oure_original_correlation_number; //原始单的关联单号
        $record['oure_original_correlation_type'] = $oure_original_correlation_type; //原始单的关联类型1.订单2.调拨单3.采购单4.销售单5.旧货回收6.退货入库7.售后
        $record['oure_client_type'] = $oure_client_type; //买家类型：1.会员零售2.客户单位3.速电派单4.第三方派单
        $record['oure_client_id'] = $oure_client_id; //选择的客户id,会员id/单位id
        $record['oure_original_number'] = $oure_original_number; //原始单号
        $record['oure_in_ware_id'] = $oure_in_ware_id; //入库仓库id
        $record['oure_out_ware_id'] = $oure_out_ware_id; //出库仓库id
        $record['oure_count'] = $oure_count; //出库的商品总量
        $record['oure_type'] = $oure_type; //类型1.入库单 2.出库单 3.调货单 4.旧货回收单 5.退换回收单 6.订单出库 7.部分入库 8.部分出库
        $record['oure_operation_type'] = $oure_operation_type; //操作类型：1锁定库存2出库3入库4调货5发货
        $record['oure_all_stock'] = $oure_all_stock; //良品总库存
        $record['oure_lock_quantity'] = $oure_lock_quantity; //良品锁定数量
        $record['oure_priority_all_stock'] = $oure_priority_all_stock; //优先总库存
        $record['oure_priority_lock_quantity'] = $oure_priority_lock_quantity; //优先锁定数量
        $record['oure_unchecked_all_stock'] = $oure_unchecked_all_stock; //待检测总库存
        $record['oure_create_time'] = $times;
        $record['oure_out_in_type'] = $oure_out_in_type; //出入库类型：1出库，2入库
        $record['oure_waon_class'] = $oure_waon_class; //仓库类别
        $record_add = DB::table('outin_record')->insertGetId($record);

        $n = 0;
        if ($oure_waon_class == '2') {
            $oure_waon_class = '1';
        }
        foreach ($goo_id as $key => $value) {
            if (!empty($oure_class_goo_id) && !in_array($value, $oure_class_goo_id)) {
                continue;
            }
            //入库id-》高献昌
            if ($oure_out_in_type == '2') {
                $oure_ware_id = $oure_in_ware_id;
            //出库
            } else {
                $oure_ware_id = $oure_out_ware_id;
            }
            //当前成本价
            $datetime = date('Y-m-d H:i:s');
            $newprice = DB::table('enters_sells_saves')
                ->where('ense_goo_id', $value)
                ->where('ense_goo_warehouse', $oure_ware_id)
                ->where('ense_goo_waretype', $oure_waon_class)
                ->where(function ($query) use ($datetime) {
                    $query->where('ense_time', '<', $datetime);
                })
                ->orderBy('ense_id', 'desc')
                ->select('ense_end_price', 'ense_end_amount', 'ense_end_inventory')
                ->first();
            if ($newprice) {
                $new_nums = $newprice->ense_end_inventory;
                $ense_end_price = $newprice->ense_end_price;
                //当前总金额
                $ense_new_amount = $newprice->ense_end_amount;
            } else {
                $new_nums = 0;
                $ense_end_price = '0';
                $ense_new_amount = '0';
            }
            //商品信息
            $goods = DB::table('goods')
                ->where('goo_id', $value)
                ->select('goo_name', 'goo_goods_encode', 'goo_ampere_hour', 'goo_attribute', 'goo_recycle_price')
                ->first();
            if ($goods->goo_attribute == '') {
                $unit = "";
            } else {
                $units = json_decode($goods->goo_attribute, true);
                foreach ($units as $k => $v) {
                    if ($v['key'] == '单位') {
                        $unit = $v['value'];
                    } else {
                        $unit = '';
                    }
                }
            }
            $dh = substr($oure_original_correlation_number, 0, 2);
            if ($oure_type == '1' || $oure_type == '7') {
                //获取入库价
                if ($dh == 'CG') {
                    $procurement_goodsres = DB::table('storage_goods')
                        ->where('relation_number', $oure_original_correlation_number)
                        ->where('goods_id', $value)
                        ->select('univalence')
                        ->first();
                    //入库价
                    $goods_price = $procurement_goodsres->univalence;
                } elseif ($dh == 'DB') {
                    $transferring_orderres = DB::table('transferring_order')
                        ->where('tror_number', $oure_original_correlation_number)
                        ->select('tror_id', 'tror_out_ware_id')
                        ->first();
                    $transferring_order_detailsres = DB::table('transferring_order_details')
                        ->where('trod_tror_id', $transferring_orderres->tror_id)
                        ->select('trod_export_time')
                        ->first();
                    $enters_sells_savesres = DB::table('enters_sells_saves')
                        ->where('ense_goo_id', $value)
                        ->where('ense_goo_warehouse', $transferring_orderres->tror_out_ware_id)
                        ->where(function ($query) use ($transferring_order_detailsres) {
                            $query->where('ense_time', '<', $transferring_order_detailsres->trod_export_time);
                        })
                        ->orderBy('ense_id', 'desc')
                        ->select('ense_end_price')
                        ->first();
                    //入库价
                    if ($enters_sells_savesres) {
                        $goods_price = $enters_sells_savesres->ense_end_price;
                    } else {
                        $goods_price = '0';
                    }
                }

                //期末总价
                $ense_end_amount = $ense_new_amount + $goods_price * $goo_quantity[$key];
                //期末平均价
                if ($new_nums + $goo_quantity[$key] == '0') {
                    $price = 0;
                } else {
                    $price = sprintf("%.4f", $ense_end_amount / ($new_nums + $goo_quantity[$key]));
                }
                //添加信息
                $enters_sellsarray['ense_goo_id'] = $value; //商品id
                $enters_sellsarray['ense_goo_name'] = $goods->goo_name; //商品名称
                $enters_sellsarray['ense_goo_number'] = $goods->goo_goods_encode; //商品编码
                $enters_sellsarray['ense_goo_unit'] = $unit; //商品单位
                $enters_sellsarray['ense_goo_specifications'] = $goods->goo_ampere_hour . "AH"; //商品规格
                $enters_sellsarray['ense_goo_waretype'] = $oure_waon_class; //仓库类别
                $enters_sellsarray['ense_goo_warehouse'] = $oure_ware_id; //所在仓库
                $enters_sellsarray['ense_new_inventory'] = $new_nums; //当前库存
                $enters_sellsarray['ense_new_price'] = $ense_end_price; //当前成本价
                $enters_sellsarray['ense_new_amount'] = $ense_new_amount; //当前总金额
                $enters_sellsarray['ense_end_inventory'] = $new_nums + $goo_quantity[$key]; //期末库存
                $enters_sellsarray['ense_end_price'] = $price; //期末成本价
                $enters_sellsarray['ense_end_amount'] = $ense_end_amount; //期末总金额
                $enters_sellsarray['ense_in_num'] = $goo_quantity[$key]; //入库数量
                $enters_sellsarray['ense_in_price'] = $goods_price; //入库单价
                $enters_sellsarray['ense_in_amount'] = $goo_quantity[$key] * $goods_price; //入库总金额
                $enters_sellsarray['ense_order_number'] = $oure_original_correlation_number; //
                $enters_sellsarray['ense_out_in'] = $oure_out_in_type; //出入库类型：1出库，2入库
                $enters_sellsarray['ense_type'] = $oure_type; //同出入库类型
                $enters_sellsarray['ense_shop_id'] = $user_info->adm_shop_id;
                $enters_saves = DB::table('enters_sells_saves')->insertGetId($enters_sellsarray);
            //旧货回收
            } elseif ($oure_type == '4') {
                //获取回收金额
                $shop_setres = DB::table('shop_set')
                    ->where('shse_shop_id', $user_info->adm_shop_id)
                    ->select('shse_recycle_type', 'shse_ampere_hour_price')
                    ->first();
                if ($shop_setres->shse_recycle_type == '1') {
                    $goods_price = $shop_setres->shse_ampere_hour_price * $goods->goo_ampere_hour / 100;
                } else {
                    $goods_price = $goods->goo_recycle_price / 100;
                }
                //同步工单商品表
                $workgoodprice['wogo_goo_price'] = $goods_price * 100;

                $workid = DB::table('work_order')
                    ->where('wor_order_number', $oure_original_correlation_number)
                    ->select('wor_id')
                    ->orderBy('wor_id', 'desc')
                    ->first();
                $workgood = DB::table('work_good')
                    ->where('wogo_wor_id', $workid->wor_id)
                    ->where('wogo_goo_id', $value)
                    ->update($workgoodprice);
                //期末总价
                $ense_end_amount = $ense_new_amount + $goods_price * $goo_quantity[$key];
                if ($new_nums + $goo_quantity[$key] == '0') {
                    $price = 0;
                } else {
                    $price = sprintf("%.4f", $ense_end_amount / ($new_nums + $goo_quantity[$key]));
                }
                //添加信息
                $enters_sellsarray['ense_goo_id'] = $value; //商品id
                $enters_sellsarray['ense_goo_name'] = $goods->goo_name; //商品名称
                $enters_sellsarray['ense_goo_number'] = $goods->goo_goods_encode; //商品编码
                $enters_sellsarray['ense_goo_unit'] = $unit; //商品单位
                $enters_sellsarray['ense_goo_specifications'] = $goods->goo_ampere_hour . "AH"; //商品规格
                $enters_sellsarray['ense_goo_waretype'] = $oure_waon_class; //仓库类别
                $enters_sellsarray['ense_goo_warehouse'] = $oure_ware_id; //所在仓库
                $enters_sellsarray['ense_new_inventory'] = $new_nums; //当前库存
                $enters_sellsarray['ense_new_price'] = $ense_end_price; //当前成本价
                $enters_sellsarray['ense_new_amount'] = $ense_new_amount; //当前总金额
                $enters_sellsarray['ense_end_inventory'] = $new_nums + $goo_quantity[$key]; //期末库存
                $enters_sellsarray['ense_end_price'] = $price; //期末成本价
                $enters_sellsarray['ense_end_amount'] = $ense_end_amount; //期末总金额
                $enters_sellsarray['ense_in_num'] = $goo_quantity[$key]; //入库数量
                $enters_sellsarray['ense_in_price'] = $goods_price; //入库单价
                $enters_sellsarray['ense_in_amount'] = $goo_quantity[$key] * $goods_price; //入库总金额
                $enters_sellsarray['ense_order_number'] = $oure_original_correlation_number; //原始单号
                $enters_sellsarray['ense_out_in'] = $oure_out_in_type; //出入库类型：1出库，2入库
                $enters_sellsarray['ense_type'] = $oure_type; //同出入库类型
                $enters_sellsarray['ense_shop_id'] = $user_info->adm_shop_id;
                $enters_saves = DB::table('enters_sells_saves')->insertGetId($enters_sellsarray);
            } elseif ($oure_type == '5') {
                $order_wareid = DB::table('order')
                    ->where('ord_order_number', $oure_original_correlation_number)
                    ->select('ord_ware_id')
                    ->first();
                if ($order_wareid->ord_ware_id == '0') {
                    $order_wareid = DB::table('recede_recycle')
                        ->where('rec_number', $oure_original_number)
                        ->select('rec_ware_id')
                        ->first();
                    $ord_ware_id = $order_wareid->rec_ware_id;
                } else {
                    $ord_ware_id = $order_wareid->ord_ware_id;
                }
                $enters_sells_savesres = DB::table('enters_sells_saves')
                    ->where('ense_out_in', '1')
                    ->where('ense_type', '9')
                    ->where('ense_goo_id', $value)
                    ->where('ense_goo_warehouse', $ord_ware_id)
                    ->where('ense_order_number', $oure_original_correlation_number)
                    ->where(function ($query) use ($datetime) {
                        $query->where('ense_time', '<=', $datetime);
                    })
                    ->orderBy('ense_id', 'desc')
                    ->select('ense_end_price')
                    ->first();
                //入库金额
                $goods_price = $enters_sells_savesres->ense_end_price;
                //期末总价
                $ense_end_amount = $ense_new_amount + $goods_price * $goo_quantity[$key];
                $price = $ense_end_price;
                //添加信息
                $enters_sellsarray['ense_goo_id'] = $value; //商品id
                $enters_sellsarray['ense_goo_name'] = $goods->goo_name; //商品名称
                $enters_sellsarray['ense_goo_number'] = $goods->goo_goods_encode; //商品编码
                $enters_sellsarray['ense_goo_unit'] = $unit; //商品单位
                $enters_sellsarray['ense_goo_specifications'] = $goods->goo_ampere_hour . "AH"; //商品规格
                $enters_sellsarray['ense_goo_waretype'] = $oure_waon_class; //仓库类别
                $enters_sellsarray['ense_goo_warehouse'] = $oure_ware_id; //所在仓库
                $enters_sellsarray['ense_new_inventory'] = $new_nums; //当前库存
                $enters_sellsarray['ense_new_price'] = $ense_end_price; //当前成本价
                $enters_sellsarray['ense_new_amount'] = $ense_new_amount; //当前总金额
                $enters_sellsarray['ense_end_inventory'] = $new_nums + $goo_quantity[$key]; //期末库存
                $enters_sellsarray['ense_end_price'] = $price; //期末成本价
                $enters_sellsarray['ense_end_amount'] = $ense_end_amount; //期末总金额
                $enters_sellsarray['ense_out_num'] = "-" . $goo_quantity[$key]; //入库数量
                $enters_sellsarray['ense_out_price'] = "-" . $goods_price; //入库单价
                $enters_sellsarray['ense_out_amount'] = "-" . $goo_quantity[$key] * $goods_price; //入库总金额
                $enters_sellsarray['ense_order_number'] = $oure_original_correlation_number; //原始单号
                $enters_sellsarray['ense_out_in'] = $oure_out_in_type; //出入库类型：1出库，2入库
                $enters_sellsarray['ense_type'] = $oure_type; //同出入库类型
                $enters_sellsarray['ense_shop_id'] = $user_info->adm_shop_id;
                $enters_saves = DB::table('enters_sells_saves')->insertGetId($enters_sellsarray);
            //退货单
            } elseif ($oure_type == '12' || $oure_type == '13') {
                $goods_price = $ense_end_price;
                $price = $ense_end_price;
                $ense_end_amount = $ense_new_amount + $goo_quantity[$key] * $goods_price;
                //添加信息
                $enters_sellsarray['ense_goo_id'] = $value; //商品id
                $enters_sellsarray['ense_goo_name'] = $goods->goo_name; //商品名称
                $enters_sellsarray['ense_goo_number'] = $goods->goo_goods_encode; //商品编码
                $enters_sellsarray['ense_goo_unit'] = $unit; //商品单位
                $enters_sellsarray['ense_goo_specifications'] = $goods->goo_ampere_hour . "AH"; //商品规格
                $enters_sellsarray['ense_goo_waretype'] = $oure_waon_class; //仓库类别
                $enters_sellsarray['ense_goo_warehouse'] = $oure_ware_id; //所在仓库
                $enters_sellsarray['ense_new_inventory'] = $new_nums; //当前库存
                $enters_sellsarray['ense_new_price'] = $ense_end_price; //当前成本价
                $enters_sellsarray['ense_new_amount'] = $ense_new_amount; //当前总金额
                $enters_sellsarray['ense_end_inventory'] = $new_nums + $goo_quantity[$key]; //期末库存
                $enters_sellsarray['ense_end_price'] = $price; //期末成本价
                $enters_sellsarray['ense_end_amount'] = $ense_end_amount; //期末总金额
                $enters_sellsarray['ense_out_num'] = "-" . $goo_quantity[$key]; //入库数量
                $enters_sellsarray['ense_out_price'] = "-" . $goods_price; //入库单价
                $enters_sellsarray['ense_out_amount'] = "-" . $goo_quantity[$key] * $goods_price; //入库总金额
                $enters_sellsarray['ense_order_number'] = $oure_original_correlation_number; //原始单号
                $enters_sellsarray['ense_out_in'] = $oure_out_in_type; //出入库类型：1出库，2入库
                $enters_sellsarray['ense_type'] = $oure_type; //同出入库类型
                $enters_sellsarray['ense_shop_id'] = $user_info->adm_shop_id;
                $enters_saves = DB::table('enters_sells_saves')->insertGetId($enters_sellsarray);
            } else {
                //采购退货单
                if ($oure_type == '2' && $dh == 'TH') {
                    $procurement_goodsres = DB::table('storage_goods')
                        ->where('relation_number', $oure_original_correlation_number)
                        ->where('goods_id', $value)
                        ->select('univalence')
                        ->first();
                    //入库价
                    $goods_price = $procurement_goodsres->univalence;
                    $ense_end_amount = $ense_new_amount - $goods_price * $goo_quantity[$key];
                    if ($new_nums - $goo_quantity[$key] == '0') {
                        $price = 0;
                    } else {
                        $price = sprintf("%.4f", $ense_end_amount / ($new_nums - $goo_quantity[$key]));
                    }

                    //添加信息
                    $enters_sellsarray['ense_goo_id'] = $value; //商品id
                    $enters_sellsarray['ense_goo_name'] = $goods->goo_name; //商品名称
                    $enters_sellsarray['ense_goo_number'] = $goods->goo_goods_encode; //商品编码
                    $enters_sellsarray['ense_goo_unit'] = $unit; //商品单位
                    $enters_sellsarray['ense_goo_specifications'] = $goods->goo_ampere_hour . "AH"; //商品规格
                    $enters_sellsarray['ense_goo_waretype'] = $oure_waon_class; //仓库类别
                    $enters_sellsarray['ense_goo_warehouse'] = $oure_ware_id; //所在仓库
                    $enters_sellsarray['ense_new_inventory'] = $new_nums; //当前库存
                    $enters_sellsarray['ense_new_price'] = $ense_end_price; //当前成本价
                    $enters_sellsarray['ense_new_amount'] = $ense_new_amount; //当前总金额
                    $enters_sellsarray['ense_end_inventory'] = $new_nums - $goo_quantity[$key]; //期末库存
                    $enters_sellsarray['ense_end_price'] = $price; //期末成本价
                    $enters_sellsarray['ense_end_amount'] = $ense_end_amount; //期末总金额
                    $enters_sellsarray['ense_in_num'] = "-" . $goo_quantity[$key]; //入库数量
                    $enters_sellsarray['ense_in_price'] = $goods_price; //入库单价
                    $enters_sellsarray['ense_in_amount'] = "-" . $goo_quantity[$key] * $goods_price; //入库总金额
                    $enters_sellsarray['ense_order_number'] = $oure_original_correlation_number; //原始单号
                    $enters_sellsarray['ense_out_in'] = $oure_out_in_type; //出入库类型：1出库，2入库
                    $enters_sellsarray['ense_type'] = $oure_type; //同出入库类型
                    $enters_sellsarray['ense_shop_id'] = $user_info->adm_shop_id;
                    $enters_saves = DB::table('enters_sells_saves')->insertGetId($enters_sellsarray);
                } else {
                    if ($oure_type == '9' && $oure_out_in_type == '2') {
                        $order_wareid = DB::table('order')
                            ->where('ord_order_number', $oure_original_correlation_number)
                            ->select('ord_ware_id')
                            ->first();
                        $enters_sells_savesres = DB::table('enters_sells_saves')
                            ->where('ense_goo_id', $value)
                            ->where('ense_goo_warehouse', $order_wareid->ord_ware_id)
                            ->where(function ($query) use ($datetime) {
                                $query->where('ense_time', '<=', $datetime);
                            })
                            ->orderBy('ense_id', 'desc')
                            ->select('ense_end_price')
                            ->first();
                        if ($enters_sells_savesres) {
                            $goods_price = $enters_sells_savesres->ense_end_price;
                        } else {
                            $goods_price = '0';
                        }
                        //期末总价
                        $ense_end_amount = $ense_new_amount + $goods_price * $goo_quantity[$key];
                        if ($new_nums + $goo_quantity[$key] == '0') {
                            $price = 0;
                        } else {
                            $price = sprintf("%.4f", $ense_end_amount / ($new_nums + $goo_quantity[$key]));
                        }
                        //添加信息
                        $enters_sellsarray['ense_goo_id'] = $value; //商品id
                        $enters_sellsarray['ense_goo_name'] = $goods->goo_name; //商品名称
                        $enters_sellsarray['ense_goo_number'] = $goods->goo_goods_encode; //商品编码
                        $enters_sellsarray['ense_goo_unit'] = $unit; //商品单位
                        $enters_sellsarray['ense_goo_specifications'] = $goods->goo_ampere_hour . "AH"; //商品规格
                        $enters_sellsarray['ense_goo_waretype'] = $oure_waon_class; //仓库类别
                        $enters_sellsarray['ense_goo_warehouse'] = $oure_ware_id; //所在仓库
                        $enters_sellsarray['ense_new_inventory'] = $new_nums; //当前库存
                        $enters_sellsarray['ense_new_price'] = $ense_end_price; //当前成本价
                        $enters_sellsarray['ense_new_amount'] = $ense_new_amount; //当前总金额
                        $enters_sellsarray['ense_end_inventory'] = $new_nums + $goo_quantity[$key]; //期末库存
                        $enters_sellsarray['ense_end_price'] = $price; //期末成本价
                        $enters_sellsarray['ense_end_amount'] = $ense_end_amount; //期末总金额
                        $enters_sellsarray['ense_in_num'] = $goo_quantity[$key]; //入库数量
                        $enters_sellsarray['ense_in_price'] = $goods_price; //入库单价
                        $enters_sellsarray['ense_in_amount'] = $goo_quantity[$key] * $goods_price; //入库总金额
                        $enters_sellsarray['ense_order_number'] = $oure_original_correlation_number; //原始单号
                        $enters_sellsarray['ense_out_in'] = $oure_out_in_type; //出入库类型：1出库，2入库
                        $enters_sellsarray['ense_type'] = $oure_type; //同出入库类型
                        $enters_sellsarray['ense_shop_id'] = $user_info->adm_shop_id;
                        $enters_saves = DB::table('enters_sells_saves')->insertGetId($enters_sellsarray);
                    } else {
                        //添加信息
                        $enters_sellsarray['ense_goo_id'] = $value; //商品id
                        $enters_sellsarray['ense_goo_name'] = $goods->goo_name; //商品名称
                        $enters_sellsarray['ense_goo_number'] = $goods->goo_goods_encode; //商品编码
                        $enters_sellsarray['ense_goo_unit'] = $unit; //商品单位
                        $enters_sellsarray['ense_goo_specifications'] = $goods->goo_ampere_hour . "AH"; //商品规格
                        $enters_sellsarray['ense_goo_waretype'] = $oure_waon_class; //仓库类别
                        $enters_sellsarray['ense_goo_warehouse'] = $oure_ware_id; //所在仓库
                        $enters_sellsarray['ense_new_inventory'] = $new_nums; //当前库存
                        $enters_sellsarray['ense_new_price'] = $ense_end_price; //当前成本价
                        $enters_sellsarray['ense_new_amount'] = $ense_new_amount; //当前总金额
                        $enters_sellsarray['ense_end_inventory'] = $new_nums - $goo_quantity[$key]; //期末库存
                        $enters_sellsarray['ense_end_price'] = $ense_end_price; //期末成本价
                        $enters_sellsarray['ense_end_amount'] = $ense_new_amount - sprintf("%.4f", $goo_quantity[$key] * $ense_end_price); //期末总金额
                        $enters_sellsarray['ense_out_num'] = $goo_quantity[$key]; //出库数量
                        $enters_sellsarray['ense_out_price'] = $ense_end_price; //出库单价
                        $enters_sellsarray['ense_out_amount'] = sprintf("%.4f", $goo_quantity[$key] * $ense_end_price); //出库总金额
                        $enters_sellsarray['ense_order_number'] = $oure_original_correlation_number; //原始单号
                        $enters_sellsarray['ense_out_in'] = $oure_out_in_type; //出入库类型：1出库，2入库
                        $enters_sellsarray['ense_type'] = $oure_type; //同出入库类型
                        $enters_sellsarray['ense_shop_id'] = 1;
                        $enters_saves = DB::table('enters_sells_saves')->insertGetId($enters_sellsarray);
                    }
                }
            }
            $oude_datas[$n]['oude_oure_id'] = $record_add;
            $oude_datas[$n]['oude_update_time'] = $times;
            $oude_datas[$n]['oude_goo_id'] = $value;
            $oude_datas[$n]['oude_goo_number'] = $goo_quantity[$key]; //实际出入库数量
            $oude_datas[$n]['oude_type'] = $goo_inventory[$key]; //类型1良品2优先
            $n++;
        }
        // dump($oude_datas);
        // exit;
        $record_details_add = DB::table('outin_details')->insert($oude_datas);
        // dump($record_details_add);
        // dump($record_add);
        // exit;
        if ($record_details_add && $record_add) {
            return true;
        } else {
            return false;
        }
    }

    // 进销存导出
    public function export5(Request $request)
    {
        $adm_cid = 1;
        $shop_id = 1;

        $search_data = $request->all();
        $list_data = DB::table('enters_sells_saves')
            ->where('ense_shop_id', $shop_id)
            ->where('ense_goo_warehouse', $request['sssg_ware_id'])
            ->where('ense_goo_waretype', $request['sssg_waon_class'])
            ->select('ense_goo_id')
            ->orderBy('ense_id', 'asc')
            ->groupBy('ense_goo_id')
            ->get()->toArray();
        $list_items = $list_data;
        $ids = array();

        foreach ($list_items as $k => $v) {
            foreach ($v as $kk => $vv) {
                $ids[] = $vv;
            }
        }
        $list = DB::table('enters_sells_saves')
            ->where('ense_shop_id', $shop_id)
            ->whereIn('ense_goo_id', $ids)
            ->where('ense_goo_warehouse', $request['sssg_ware_id'])
            ->where('ense_goo_waretype', $request['sssg_waon_class'])
            ->select('ense_id', 'ense_goo_id', 'ense_goo_name', 'ense_goo_number', 'ense_goo_waretype', 'ense_goo_warehouse', 'ense_new_inventory', 'ense_new_price', 'ense_new_amount', 'ense_order_number')
            ->orderBy('ense_id', 'asc')
            ->get()
            ->toArray();
        $dataayyar = array();
        if ($list) {
            // 查询仓库数据
            $warehouse_data = DB::table('warehouse')
                ->where('ware_id', $request['sssg_ware_id'])
                ->select('ware_id', 'ware_name')
                ->first();
            // 查询仓库类别数据
            $warehouse_class = DB::table('warehouse_class')
                ->where('wacl_cid', $adm_cid)
                ->where('wacl_superior_shop_id', $shop_id)
                ->where('wacl_class_numerical', $request['sssg_waon_class'])
                ->select('wacl_class_numerical', 'wacl_class_name')
                ->first();
            $warehouse_data = $warehouse_data->ware_name;
            $warehouse_class = $warehouse_class->wacl_class_name;
            $listarray = array();
            $list = json_decode(json_encode($list), true);
            foreach ($list as $k => $v) {
                if (isset($listarray[$v['ense_goo_id']])) {
                    $listarray[$v['ense_goo_id']]['ense_goo_waretype'] = $warehouse_class;
                    $listarray[$v['ense_goo_id']]['ense_goo_warehouse'] = $warehouse_data;
                    if (substr($v['ense_order_number'], 0, 2) == 'DB') {
                        // $listarray[$v['ense_goo_id']]['mouthnums']=$listarray[$v['ense_goo_id']]['mouthnums']+$v['ense_in_num']-$v['ense_out_num'];
                        // $listarray[$v['ense_goo_id']]['mouthprice']=sprintf("%.4f",$listarray[$v['ense_goo_id']]['mouthprice']+$v['ense_in_amount']-$v['ense_out_amount']);
                    } else {
                        // $listarray[$v['ense_goo_id']]['ense_out_num']=$v['ense_out_num']+$listarray[$v['ense_goo_id']]['ense_out_num'];
                        // $listarray[$v['ense_goo_id']]['ense_out_amount']=sprintf("%.4f",$v['ense_out_amount']+$listarray[$v['ense_goo_id']]['ense_out_amount']);
                        // $listarray[$v['ense_goo_id']]['ense_in_num']=$v['ense_in_num']+$listarray[$v['ense_goo_id']]['ense_in_num'];
                        // $listarray[$v['ense_goo_id']]['ense_in_amount']=sprintf("%.4f",$v['ense_in_amount']+$listarray[$v['ense_goo_id']]['ense_in_amount']);
                    }
                } else {
                    if (substr($v['ense_order_number'], 0, 2) == 'DB') {
                        // $v['mouthnums']=$v['ense_in_num']-$v['ense_out_num'];
                        // $v['mouthprice']=sprintf("%.4f",$v['ense_in_amount']-$v['ense_out_amount']);
                        // $v['ense_out_num']=0;
                        // $v['ense_out_amount']=0;
                        // $v['ense_in_num']=0;
                        // $v['ense_in_amount']=0;
                    } else {
                        // $v['mouthnums']=0;
                        // $v['mouthprice']=0;
                    }

                    $v['ense_goo_waretype'] = $warehouse_class;
                    $v['ense_goo_warehouse'] = $warehouse_data;
                    $listarray[$v['ense_goo_id']] = $v;
                }
            }
            $i = "0";
            foreach ($listarray as $k => $v) {
                $dataayyar[$i] = $v;
                // $ce=sprintf("%.0f",$v['ense_end_price']-$v['ense_new_price']);
                // $dataayyar[$i]['new_end_price']=$ce;
                // if($v['ense_out_num']=='0'){
                //     $dataayyar[$i]['ense_out_price']='0';
                // }else{
                //     $dataayyar[$i]['ense_out_price']=sprintf("%.4f",$v['ense_out_amount']/$v['ense_out_num']);
                // }
                // if($v['ense_in_num']=='0'){
                //     $dataayyar[$i]['ense_in_price']='0';
                // }else{
                //     $dataayyar[$i]['ense_in_price']=sprintf("%.4f",$v['ense_in_amount']/$v['ense_in_num']);
                // }
                $i = $i + 1;
                // unset($dataayyar[$i]['ense_end_inventory']);
                // unset($dataayyar[$i]['ense_end_price']);
                // unset($dataayyar[$i]['ense_end_amount']);
                // unset($dataayyar[$i]['ense_out_num']);
                // unset($dataayyar[$i]['ense_out_price']);
                // unset($dataayyar[$i]['ense_out_amount']);
                // unset($dataayyar[$i]['ense_in_num']);
                // unset($dataayyar[$i]['ense_in_price']);
                // unset($dataayyar[$i]['ense_in_amount']);
                // unset($dataayyar[$i]['ense_out_in']);
                // unset($dataayyar[$i]['mouthnums']);
                // unset($dataayyar[$i]['mouthprice']);
            }
            // dump($dataayyar);
            // exit;
            $pathName = storage_path() . "/app/public/excel"; //获取上传excel路径
            // 创建文件夹
            if (!file_exists($pathName)) {
                mkdir($pathName, 0775, true);
                chmod($pathName, 0775);
            }

            $streamFileRand = time() . rand(10000, 99999) . '期初金额.xls'; //
            // 产生一个随机文件名（因为你base64上来肯定没有文件名，这里你可以自己设置一个也行）
            $streamFilename = $pathName . '/' . $streamFileRand;

            $where['action_name'] = '期初金额';
            $where['field_name'] = ['主键id', '商品id', '商品名称', '检索编码', '仓库类别', '仓库名称', '当前库存', '当前平均价', '当前总金额', '单号'];
            // 调用导出的公共方法
            export::publicExport(
                $streamFilename, //路径
                $where,    //sheet名及其每一行的标题
                $dataayyar      //导出数据
            );

            // 判断文件是否存在 存在则成功  不存在则失败
            if (file_exists($pathName)) {
                return response()->json(['code'=>200, 'msg'=>'success', 'data'=>'storage/excel/' . $streamFileRand]);
            } else {
                return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'导出失败']);
            }
        }
    }

    // 查询工单的旧货商品金额跟订单不一致的数据
    public function order20(Request $request)
    {
        ignore_user_abort();
        set_time_limit(0);

        $find_wor_data = DB::table('work_good as wogo')
            ->leftjoin('work_order as wor', 'wogo.wogo_wor_id', '=', 'wor.wor_id')
            ->leftjoin('work_client as wocl', 'wocl.wocl_wor_id', '=', 'wor.wor_id')
            ->leftjoin('voucher_receipts as vore', 'vore.vore_wor_id', '=', 'wor.wor_id')
            ->where('wor_cid', 1)
            ->where('wor_shop_id', 1)
            ->where('wor_state', 10)
            ->where('wor_delete', 1)
            ->where('wor_collection_bill', 1)
            ->where('wocl_wor_type', 1)
            ->where('wogo_state', 3)
            ->where('vore_state', 1)
            ->select('wor_order_id', 'wor_order_number', 'wor_actual_price', 'wogo_goo_price', 'wogo_goo_id')
            ->get()->toArray();
        foreach ($find_wor_data as $key => $value) {
            // 查询订单商品表
            $find_orgo_data = DB::table('order_goods')
                ->where('orgo_ord_id', $value->wor_order_id)
                ->where('orgo_order_number', $value->wor_order_number)
                ->where('orgo_goo_id', $value->wogo_goo_id)
                ->where('orgo_state', 3)
                ->select('orgo_goo_price')
                ->first();
            if ($value->wogo_goo_price != $find_orgo_data->orgo_goo_price) {
                dump($value->wor_order_number);
            }
        }
    }

    // 查询应收应付的金额和订单结算金额不一致的单子
    public function order19()
    {
        ignore_user_abort();
        set_time_limit(0);

        // $search_data = $request->all();

        /* // 查询应收应付数据
        $find_recr_data = DB::table('receivable_credit')
            ->where('recr_cid', 1)
            ->where('recr_shop_id', 1)
            ->where('recr_number_id', 0)
            ->where('recr_plus_minus', 2)
            ->where('recr_settle_price', '!=', 0)
            ->where('recr_account_type', 1)
            ->select('recr_original_id', 'recr_original_number', 'recr_settle_price')
            ->get()->toArray();
        foreach($find_recr_data as $key => $value) {
            $ord_actual = DB::table('order')
                ->where('ord_cid', 1)
                ->where('ord_shop_id', 1)
                ->where('ord_id', $value->recr_original_id)
                ->where('ord_order_number', $value->recr_original_number)
                ->select('ord_id', 'ord_order_number', 'ord_actual_price', 'ord_cid', 'ord_shop_id')
                ->select('ord_actual_price')
                ->first();
            $ord_actual_price = abs($ord_actual->ord_actual_price);
            dump($ord_actual_price);
            dump($value->recr_settle_price);
            if ($ord_actual_price != $value->recr_settle_price) {
                dump($value->recr_original_number);
            }
        } */
        // 查询工单表数据
        $find_recr_data = DB::table('work_order as wor')
            ->leftjoin('work_client as wocl', 'wocl.wocl_wor_id', '=', 'wor.wor_id')
            ->where('wor_cid', 1)
            ->where('wor_shop_id', 1)
            ->where('wor_state', 10)
            ->where('wor_delete', 1)
            ->where('wor_collection_bill', 1)
            ->where('wocl_wor_type', 1)
            ->select('wor_order_id', 'wor_order_number', 'wor_actual_price')
            ->get()->toArray();
        foreach ($find_recr_data as $key => $value) {
            $ord_actual = DB::table('order')
                ->where('ord_cid', 1)
                ->where('ord_shop_id', 1)
                ->where('ord_id', $value->wor_order_id)
                ->where('ord_order_number', $value->wor_order_number)
                ->select('ord_id', 'ord_order_number', 'ord_actual_price', 'ord_cid', 'ord_shop_id')
                ->select('ord_actual_price')
                ->first();
            $ord_actual_price = $ord_actual->ord_actual_price;
            // dump($ord_actual_price);
            // dump($value->wor_actual_price);
            if ($ord_actual_price != $value->wor_actual_price) {
                dump($value->wor_order_number);
            }
        }
    }

    // 导出数据
    public function order18()
    {
        $data = DB::table('data_statisticals')
            ->select('dast_id', 'dast_ord_id', 'dast_goo_id', 'dast_order_number', 'dast_goo_name', 'dast_goo_encode', 'dast_goo_cost', 'dast_goo_costs', 'dast_vour_costs', 'dast_add_time')
            ->orderBy('dast_add_time', 'desc')
            ->get()->toArray();
        if (!empty($data)) {
            // 将对象转化为数组
            $data = json_decode(json_encode($data), true);
        } else {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'没有符合条件的数据']);
        }

        $pathName = storage_path() . "/app/public/excel"; //获取上传excel路径
        // 创建文件夹
        if (!file_exists($pathName)) {
            mkdir($pathName, 0775, true);
            chmod($pathName, 0775);
        }

        $streamFileRand = time() . rand(10000, 99999) . '9.10-12.31销售统计成本和凭证列表成本不一致的单据.xls'; //
        // 产生一个随机文件名（因为你base64上来肯定没有文件名，这里你可以自己设置一个也行）
        $streamFilename = $pathName . '/' . $streamFileRand;

        $where['action_name'] = '9.10-12.31销售统计成本和凭证列表成本不一致的单据';
        $where['field_name'] = ['主键id', '订单id', '商品id', '订单单号', '商品名称', '检索编码', '销售统计单商品成本', '销售统计总成本', '凭证列表总成本', '创建时间'];
        // 调用导出的公共方法
        export::publicExport(
            $streamFilename, //路径
            $where,    //sheet名及其每一行的标题
            $data      //导出数据
        );

        // 判断文件是否存在 存在则成功  不存在则失败
        if (file_exists($pathName)) {
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>'storage/excel/' . $streamFileRand]);
        } else {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'导出失败']);
        }
    }

    // 退货单的应收应付金额为0的数据调整
    public function order17(Request $request)
    {
        ignore_user_abort();
        set_time_limit(0);

        $search_data = $request->all();

        // 查询应收应付数据
        $find_recr_data = DB::table('receivable_credit')
            ->where('recr_cid', 1)
            ->where('recr_shop_id', 1)
            ->where('recr_account_type', 10)
            ->where('recr_number_id', 0)
            ->select('recr_original_id', 'recr_original_number', 'recr_settle_price')
            ->get()->toArray();
        foreach ($find_recr_data as $key => $value) {
            $ord_actual_price = DB::table('order')
                ->where('ord_cid', 1)
                ->where('ord_shop_id', 1)
                ->where('ord_id', $value->recr_original_id)
                ->where('ord_order_number', $value->recr_original_number)
                ->select('ord_id', 'ord_order_number', 'ord_actual_price', 'ord_cid', 'ord_shop_id')
                ->value('ord_actual_price');
            $ord_actual_price = abs($ord_actual_price);
            if ($ord_actual_price != $value->recr_settle_price) {
                dump($value->recr_original_number);
            }
        }

        /* $find_ord_data = DB::table('order')
            ->where('ord_cid', 1)
            ->where('ord_shop_id', 1)
            ->where('ord_delete', 1)
            ->where('ord_collection_bill', 1) //是否代收账单：1正常订单2代收账单
            ->where('ord_wor_state', 4)
            ->where('ord_service_type', 4)
            ->where(function ($query) use ($search_data) {
                //如果选择开始时间并且选择结束时间
                if (!empty($search_data['create_time_start']) && !empty($search_data['create_time_end'])) {
                    $query->whereBetween('ord_create_time', [$search_data['create_time_start'], $search_data['create_time_end'].' 23:59:59']);
                } else {
                    // 如果选择开始时间
                    if (!empty($search_data['create_time_start'])) {
                        $query->where('ord_create_time', '>=', $search_data['create_time_start']);
                    } else {
                        // 如果选择结束时间
                        if (!empty($search_data['create_time_end'])) {
                            $query->where('ord_create_time', '<=', $search_data['create_time_end'].' 23:59:59');
                        }
                    }
                }
            }) //创建时间
            ->select('ord_id', 'ord_order_number', 'ord_actual_price', 'ord_cid', 'ord_shop_id')
            ->orderBy('ord_id', 'desc')
            ->get()->toArray();
        foreach ($find_ord_data as $key => $value) {
            // 查询应收应付数据
            $find_recr_data = DB::table('receivable_credit')
                ->where('recr_cid', $value->ord_cid)
                ->where('recr_shop_id', $value->ord_shop_id)
                ->where('recr_original_id', $value->ord_id)
                ->where('recr_original_number', $value->ord_order_number)
                ->where('recr_state', 1)
                ->where('recr_statistics_type', 1)
                ->value('recr_settle_price');
            if ($find_recr_data) {
                $ord_actual_price = abs($value->ord_actual_price);
                if ($find_recr_data != $ord_actual_price) {
                    dump($value->ord_order_number);
                }
            }
        } */
    }

    // 查询订单数据,并修正
    public function order15()
    {
        ignore_user_abort();
        set_time_limit(0);

        // 查询订单表备份的数据,同步到现在的表
        $find_ord_data = DB::table('order')
            ->where('ord_service_type', 4)
            // ->where('ord_actual_price', 0)
            ->where('ord_order_price', 0)
            ->select('ord_id', 'ord_order_number')
            ->get()->toArray();
        foreach ($find_ord_data as $key => $value) {
            $find_ord_copy = DB::table('order_21012802')
                ->where('ord_id', $value->ord_id)
                ->where('ord_order_number', $value->ord_order_number)
                ->select('ord_order_price', 'ord_actual_price')
                ->first();
            $edit_data['ord_order_price'] = '-' . abs($find_ord_copy->ord_order_price);
            // $edit_data['ord_actual_price'] = '-'.$find_ord_copy->ord_actual_price;
            $edit_res = DB::table('order')
                ->where('ord_id', $value->ord_id)
                ->where('ord_order_number', $value->ord_order_number)
                ->update($edit_data);
            dump($edit_res);
            unset($edit_data);
            unset($edit_res);
        }
        unset($find_ord_copy);
        unset($find_ord_data);
    }

    // 凭证列表新增订单类型字段
    public function voucher()
    {
        ignore_user_abort();
        set_time_limit(0);

        // 查询凭证列表的数据
        $find_vore_data = DB::table('voucher_receipts')
            ->whereIn('vore_order_type', [1, 2])
            ->where('vore_service_type', 0)
            ->select('vore_id', 'vore_ord_id', 'vore_ord_number')
            ->get()->toArray();
        // dump($find_vore_data);
        foreach ($find_vore_data as $key => $value) {
            // 查询订单数据
            $find_ord_data = DB::table('order')
                ->where('ord_id', $value->vore_ord_id)
                ->where('ord_order_number', $value->vore_ord_number)
                ->select('ord_id', 'ord_order_number', 'ord_service_type')
                ->first();
            // dump($find_ord_data);
            if ($find_ord_data) {
                $vore_data['vore_service_type'] = $find_ord_data->ord_service_type;
                $vore_res = DB::table('voucher_receipts')
                    ->where('vore_id', $value->vore_id)
                    ->where('vore_ord_id', $find_ord_data->ord_id)
                    ->where('vore_ord_number', $find_ord_data->ord_order_number)
                    ->update($vore_data);
                dump($vore_res);
                unset($vore_data);
                unset($vore_res);
            }
        }
        unset($find_vore_data);
        unset($find_ord_data);
        echo 'string';
    }

    // 查询工单表金额为负的单子
    public function work_order()
    {
        ignore_user_abort();
        set_time_limit(0);

        $find_data = DB::table('work_order')
            ->where('wor_plus_minus', 2)
            ->where('wor_actual_price', '>', 0)
            ->select('wor_id', 'wor_cid', 'wor_shop_id', 'wor_number', 'wor_actual_price')
            ->get()->toArray();
        dump($find_data);
        foreach ($find_data as $key => $value) {
            // 修改订单数据
            $edit_data['wor_actual_price'] = '-' . $value->wor_actual_price;
            $edit_res = DB::table('work_order')
                ->where('wor_id', $value->wor_id)
                ->where('wor_cid', $value->wor_cid)
                ->where('wor_shop_id', $value->wor_shop_id)
                ->where('wor_number', $value->wor_number)
                ->update($edit_data);
            dump($edit_res);
            unset($edit_res);
        }
        unset($find_data);
        echo "string";
    }

    // 查询订单表金额为负的单子
    public function order14()
    {
        ignore_user_abort();
        set_time_limit(0);

        $find_data = DB::table('order')
            // ->where('ord_plus_minus', 2)
            ->where('ord_order_plus_minus', 2)
            ->select('ord_id', 'ord_cid', 'ord_shop_id', 'ord_order_number', 'ord_actual_price', 'ord_order_price')
            ->get()->toArray();
        // dump($find_data);
        foreach ($find_data as $key => $value) {
            // 修改订单数据
            // $edit_data['ord_actual_price'] = '-'.$value->ord_actual_price;
            $edit_data['ord_order_price'] = '-' . $value->ord_order_price;
            $edit_res = DB::table('order')
                ->where('ord_id', $value->ord_id)
                ->where('ord_cid', $value->ord_cid)
                ->where('ord_shop_id', $value->ord_shop_id)
                ->where('ord_order_number', $value->ord_order_number)
                ->update($edit_data);
            dump($edit_res);
            unset($edit_res);
        }
        unset($find_data);
        echo "string";
    }

    // 查询结款明细已确认,应收应付未确认的单子
    public function accounting2()
    {
        ignore_user_abort();
        set_time_limit(0);

        $find_data = DB::table('accounting_settlement')
            ->whereIn('acset_state', [2, 3])
            ->where('acset_type', 26)
            ->where('acset_adm_cid', 1)
            ->where('acset_shop_id', 1)
            ->select('acset_id', 'acset_adm_cid', 'acset_shop_id', 'acset_original_id', 'acset_original_number')
            ->get()->toArray();
        foreach ($find_data as $key => $value) {
            $find_recr_data = DB::table('receivable_credit')
                ->where('recr_cid', $value->acset_adm_cid)
                ->where('recr_shop_id', $value->acset_shop_id)
                ->where('recr_original_id', $value->acset_original_id)
                ->where('recr_original_number', $value->acset_original_number)
                ->where('recr_state', 1)
                ->where('recr_statistics_type', 1)
                ->select('recr_id', 'recr_cid', 'recr_shop_id', 'recr_original_id', 'recr_original_number')
                ->first();
            if ($find_recr_data) {
                dump($find_recr_data);
            }
        }
        unset($find_recr_data);
        unset($find_data);
        echo '999';
    }

    // 查询销售统计的单子买家类型为速电网单
    public function order13()
    {
        ignore_user_abort();
        set_time_limit(0);

        $find_data = DB::table('work_order')
            ->where('wor_type', 3)
            ->select('wor_order_id', 'wor_order_number', 'wor_ware_id')
            ->get()->toArray();
        // dump($find_data);
        foreach ($find_data as $key => $value) {
            // 查询订单数据
            $find_ord_data = DB::table('order')
                ->where('ord_id', $value->wor_order_id)
                ->where('ord_order_number', $value->wor_order_number)
                ->select('ord_id', 'ord_order_number')
                ->first();
            if ($find_ord_data) {
                $edit_data['ord_ware_id'] = $value->wor_ware_id;
                $edit_res = DB::table('order')
                    ->where('ord_id', $value->wor_order_id)
                    ->where('ord_order_number', $value->wor_order_number)
                    ->update($edit_data);
                dump($edit_res);
                unset($edit_res);
            }
        }
        unset($find_data);
        echo "string";
    }

    // 查询销售统计的单子买家类型为速电网单
    public function order11()
    {
        ignore_user_abort();
        set_time_limit(0);

        $cid = 1;
        $shop_id = 1;

        $find_data = DB::table('data_statistical')
            ->where('dast_cid', $cid)
            ->where('dast_superior_shop_id', $shop_id)
            ->where('dast_shop_id', $shop_id)
            // ->where('dast_type', 3)
            // ->where('dast_order_type', 3)
            // ->where('dast_ware_id', 0)
            ->where('dast_id', '>=', '1100')
            ->where('dast_id', '<=', '4000')
            ->select('dast_id', 'dast_ord_id', 'dast_order_number', 'dast_goo_id', 'dast_ware_id', 'dast_waon_class', 'dast_goo_quantitys', 'dast_goo_cost')
            ->get()->toArray();
        // dump($find_data);
        $cost_price = 0;
        foreach ($find_data as $key => $value) {
            // 查询工单的仓库id
            // $find_wor_data = DB::table('work_order')
            //     ->where('wor_cid', $cid)
            //     ->where('wor_superior_shop_id', $shop_id)
            //     ->where('wor_shop_id', $shop_id)
            //     ->where('wor_order_id', $value->dast_ord_id)
            //     ->where('wor_order_number', $value->dast_order_number)
            //     ->where('wor_delete', 1)
            //     ->where('wor_collection_bill', 1)
            //     ->select('wor_ware_id', 'wor_order_id', 'wor_order_number')
            //     ->first();
            // dump($find_wor_data);
            // if ($find_wor_data) {
            /*$edit_data['dast_ware_id'] = $find_wor_data->wor_ware_id;
            $edit_res = DB::table('data_statistical')
                ->where('dast_cid', $cid)
                ->where('dast_superior_shop_id', $shop_id)
                ->where('dast_shop_id', $shop_id)
                ->where('dast_id', $value->dast_id)
                ->where('dast_ord_id', $find_wor_data->wor_order_id)
                ->where('dast_order_number', $find_wor_data->wor_order_number)
                ->update($edit_data);
            dump($edit_res.'=='.$value->dast_order_number);
            unset($edit_res);*/
            $find_cost_price = DB::table('enters_sells_saves')
                ->where('ense_shop_id', $shop_id)
                ->where('ense_goo_warehouse', $value->dast_ware_id)
                ->where('ense_goo_waretype', $value->dast_waon_class)
                ->where('ense_goo_id', $value->dast_goo_id)
                ->where('ense_order_number', $value->dast_order_number)
                ->select('ense_end_price')
                ->orderBy('ense_id', 'asc')
                ->first();
            if ($find_cost_price) {
                $cost_price = $find_cost_price->ense_end_price * 100;
            } else {
                $cost_price = 0;
            }
            // 查询速电订单的成本
            /* $list_items = DB::table('enters_sells_saves')
                ->where('ense_goo_id', $value->dast_goo_id)
                ->where('ense_goo_warehouse', $value->dast_ware_id)
                ->where('ense_goo_waretype', $value->dast_waon_class)
                ->where('ense_order_number', $value->dast_order_number)
                ->select('ense_goo_id')
                ->groupBy('ense_goo_id')
                ->get()->toArray();
            $ids = array();
            foreach ($list_items as $kone=>$vone) {
                foreach ($vone as $kkone => $vvone) {
                    $ids[] = $vvone;
                }
            }
            $cost_price = 0;
            $list = DB::table('enters_sells_saves')
                ->where('ense_shop_id', $shop_id)
                ->where('ense_goo_warehouse', $value->dast_ware_id)
                ->where('ense_goo_waretype', $value->dast_waon_class)
                ->whereIn('ense_goo_id', $ids)
                ->where('ense_order_number', $value->dast_order_number)
                ->select('ense_id', 'ense_goo_id', 'ense_end_price')
                ->orderBy('ense_id', 'asc')
                ->get()
                ->toArray();
            $dataayyar=array();
            if ($list) {
                $listarray=array();
                $list=json_decode(json_encode($list), true);
                foreach ($list as $ktwo=>$vtwo) {
                    if (isset($listarray[$vtwo['ense_goo_id']])) {
                        $listarray[$vtwo['ense_goo_id']]['ense_end_price'] = $vtwo['ense_end_price'];
                    } else {
                        $listarray[$vtwo['ense_goo_id']] = $vtwo;
                    }
                }
                $i = "0";
                foreach ($listarray as $kthree=>$vthree) {
                    $dataayyar[$i] = $vthree;
                    $i = $i+1;
                }
            }
            if ($dataayyar) {
                foreach ($dataayyar as $k3 => $v3) {
                    $cost_price += $v3['ense_end_price'] * $value->dast_goo_quantitys;
                }
            } else {
                $cost_price = 0;
            } */
            $edit_data['dast_goo_cost'] = $cost_price;
            $edit_res = DB::table('data_statistical')
                ->where('dast_cid', $cid)
                ->where('dast_superior_shop_id', $shop_id)
                ->where('dast_shop_id', $shop_id)
                ->where('dast_id', $value->dast_id)
                ->update($edit_data);
            dump($edit_res);
            unset($edit_res);
            unset($dataayyar);
            unset($list);
            unset($list_items);
            // }
        }
        unset($find_data);
        unset($cost_price);
        unset($ids);
        unset($find_cost_price);
        echo "string";
    }

    // 调整销售统计
    public function order10()
    {
        ignore_user_abort();
        set_time_limit(0);

        // $cid = 1;
        // $shop_id = 1;

        $find_data = DB::table('data_statistical')
            // ->where('dast_cid', $cid)
            // ->where('dast_superior_shop_id', $shop_id)
            // ->where('dast_shop_id', $shop_id)
            ->where('dast_ord_form_type', 0)
            // ->where('dast_orcl_shipment_party', 0)
            ->select('dast_id', 'dast_ord_id', 'dast_order_number')
            ->get()->toArray();
        foreach ($find_data as $key => $value) {
            // 根据id和单号查询对应的数据
            $find_ord_data = DB::table('order as ord')
                ->leftjoin('order_client as orcl', 'orcl.orcl_ord_id', 'ord.ord_id')
                // ->where('ord_cid', $cid)
                // ->where('ord_superior_shop_id', $shop_id)
                // ->where('ord_shop_id', $shop_id)
                ->where('ord_id', $value->dast_ord_id)
                ->where('ord_order_number', $value->dast_order_number)
                ->select('ord_form_type', 'orcl_shipment_party')
                ->first();
            if ($find_ord_data) {
                $edit_data['dast_orcl_shipment_party'] = $find_ord_data->orcl_shipment_party;
                $edit_data['dast_ord_form_type'] = $find_ord_data->ord_form_type;
                $edit_res = DB::table('data_statistical')
                    ->where('dast_id', $value->dast_id)
                    // ->where('dast_cid', $cid)
                    // ->where('dast_superior_shop_id', $shop_id)
                    // ->where('dast_shop_id', $shop_id)
                    ->update($edit_data);
                dump($edit_res);
                unset($edit_data);
                unset($find_ord_data);
            }
        }
        unset($find_data);
        echo 'string';
    }

    // 查询1月4-1月11日之间的订单类型为退货单,并且已完成的数据
    public function order9(Request $request)
    {
        ignore_user_abort();
        set_time_limit(0);

        $cid = 1;
        $shop_id = 1;

        $search_data = $request->all();

        $number = ["D2021010413463900100", "D2021010416182800176", "D2021010417181300195", "D2021010419145200214", "D2021010419181400215", "D2021010509004900010", "D2021010511320200047", "D2021010511493600053", "D2021010511574600055", "D2021010515142000099", "D2021010516161900113", "D2021010516390300124", "D2021010609572900027", "D2021010610020900030", "D2021010610205200035", "D2021010610263800038", "D2021010610340800042", "D2021010611531900064", "D2021010612091500071", "D2021010614130900102", "D2021010618562100169", "D2021010619010200170", "D2021010619051700171", "D2021010710251800041", "D2021010710324300044", "D2021010710533900054", "D2021010714274100080", "D2021010714335200083", "D2021010716312300118", "D2021010718462800147", "D2021010718520100148", "D2021010718543200151", "D2021010719071400155", "D2021010809113600014", "D2021010809492000031", "D2021010810482600053", "D2021010810542100056", "D2021010812092000084", "D2021010812571700093", "D2021010813492700106", "D2021010814244400121", "D2021010814585900128", "D2021010815115000134", "D2021010816400100163", "D2021010817070300172", "D2021010817105400176", "D2021010817411500179", "D2021010909050200005", "D2021010911123400060", "D2021010912580300088", "D2021010913452800097", "D2021010913453700099", "D2021010914265900111", "D2021010915000200131", "D2021010916173100160", "D2021010916335900168", "D2021010916343600169", "D2021010917403600188", "D2021010919404600221", "D2021011010093200018", "D2021011012390500047", "D2021011016281400130", "D2021011016282100131", "D2021011018492200176", "D2021011019424800184", "D2021011019452700186", "D2021011019483000189", "D2021011019584900191", "D2021011109312500011", "D2021011110002800019", "D2021011112330400074", "D2021011114295400109", "D2021011114341000112", "D2021011116515600160"];
        // $number = ["D2021010413463900100"];

        $find_data = DB::table('order as ord')
            ->leftjoin('voucher_receipts as vore', 'vore.vore_ord_id', '=', 'ord.ord_id')
            ->where('ord_cid', $cid)
            ->where('ord_superior_shop_id', $shop_id)
            ->where('ord_shop_id', $shop_id)
            ->where('ord_service_type', 4)
            ->where('ord_wor_state', 4)
            ->where('ord_collection_bill', 1)
            ->where('vore_order_type', 1)
            ->where(function ($query) use ($search_data) {
                //如果选择开始时间并且选择结束时间
                if (!empty($search_data['create_time_start']) && !empty($search_data['create_time_end'])) {
                    $query->whereBetween('ord_create_time', [$search_data['create_time_start'], $search_data['create_time_end'] . ' 23:59:59']);
                } else {
                    // 如果选择开始时间
                    if (!empty($search_data['create_time_start'])) {
                        $query->where('ord_create_time', '>=', $search_data['create_time_start']);
                    } else {
                        // 如果选择结束时间
                        if (!empty($search_data['create_time_end'])) {
                            $query->where('ord_create_time', '<=', $search_data['create_time_end'] . ' 23:59:59');
                        }
                    }
                }
            }) //创建时间
            ->whereIn('vore_ord_number', $number)
            ->select('vore_id', 'vore_ord_id', 'vore_ord_number')
            ->get()->toArray();
        // dump($find_data);
        // exit;
        foreach ($find_data as $key => $value) {
            $find_volo_data = DB::table('voucher_loan')
                ->where('volo_shop_id', $shop_id)
                ->where('volo_vore_id', $value->vore_id)
                ->where('volo_borrow_subject_name', '应收账款')
                ->first();
            if ($find_volo_data) {
                // dump($find_volo_data);
                // dump($value->vore_ord_number);
                $update_data['volo_borrow_subject'] = '600101';
                $update_data['volo_borrow_subject_name'] = '主营业务收入';
                $update_data['volo_borrow_costing_subject'] = '140501';
                $update_data['volo_borrow_costing_name'] = '库存商品';
                $update_data['volo_loan_subject'] = '1122';
                $update_data['volo_loan_subject_name'] = '应收账款';
                $update_data['volo_loan_costing_subject'] = '640101';
                $update_data['volo_loan_costing_name'] = '主营业务成本';
                $update_res = DB::table('voucher_loan')
                    ->where('volo_shop_id', $shop_id)
                    ->where('volo_vore_id', $value->vore_id)
                    ->update($update_data);
                dump($update_res);
                unset($update_data);
                unset($update_res);
            }
        }
    }

    // 查询客商数据
    public function u8clouds()
    {
        ignore_user_abort();
        set_time_limit(0);
        // echo 888;
        // die;
        // 调用u8系统接口，将客商数据传到用友系统上
        $yongyou = new YongYouController;
        $error_data = [];

        $user_info['adm_cid'] = 1;
        $user_info['adm_shop_id'] = 1; //门店id
        // 查询客户单位数据
        $list_data = DB::table('channel_unit')
            ->where('chun_cid', $user_info['adm_cid'])
            ->where('chun_shop_id', $user_info['adm_shop_id'])
            // ->where('u.chun_state', '<>', 3)
            // ->where('u.chun_id', '>=', 6801)
            // ->where('u.chun_id', '<', 8789)
            ->select('chun_id', 'chun_search_letter', 'chun_unit_name')
            ->get()->toArray();

        foreach ($list_data as $key => $value) {
            $letters = 'ZKH1MK' . $value->chun_id;
            $find_chun_data = DB::table('channel_unit_copy')
                ->where('chun_cid', $user_info['adm_cid'])
                ->where('chun_shop_id', $user_info['adm_shop_id'])
                ->where('chun_search_letter', $letters)
                ->where('chun_unit_name', $value->chun_unit_name)
                ->select('chun_unit_name')
                ->first();
            if (empty($find_chun_data)) {
                dump($value->chun_unit_name);
                // // 客商基本档案新增
                // $u8cloud_data['cbdocvo'][0]['parentvo']['creator'] = config('apiu8cloud.pk_prepared');//否  创建人
                // $u8cloud_data['cbdocvo'][0]['parentvo']['custcode'] = config('apiu8cloud.custcode.unit').$user_info['adm_shop_id'].'MK'.$value->chun_id;//是 客商编码
                // $u8cloud_data['cbdocvo'][0]['parentvo']['custname'] =$value->chun_unit_name;//是 客商名称
                // $u8cloud_data['cbdocvo'][0]['parentvo']['custprop'] ='0';//否 客商类型(0 - 外部单位,1 - 内部核算单位,2 - 内部法人单位,3 - 内部渠道成员)
                // $u8cloud_data['cbdocvo'][0]['parentvo']['custshortname'] =$value->chun_unit_name;//是    客商简称
                // $u8cloud_data['cbdocvo'][0]['parentvo']['pk_areacl'] =config('apiu8cloud.SHOP_BASIC_SETUP')[$user_info['adm_shop_id']]['areaclcode'];//否   所属地区(填写编码)
                // $u8cloud_data['cbdocvo'][0]['parentvo']['mnecode'] =$value->chun_search_letter;//否 助记码
                // // dump($u8cloud_data);die;
                // // 调用u8系统接口
                // $curl_return = $yongyou->u8cloudApi('客商基本档案新增', $u8cloud_data);
                // // 判断用友接口返回的数据
                // if ($curl_return['status'] != 'success') {
                //     $error_data[] = $value->chun_id;
                //     continue;
                // }
                // // 客户数据添加成功，分配客商到门店
                // $curl_data = json_decode($curl_return['data'], true);
                // $chin_add_data['pk_cubasdoc'] = $curl_data[0]['parentvo']['pk_cubasdoc'];//客商基本档案主键--添加门店系统
                // $res = DB::table('channel_info')
                //     ->where('chin_chun_id', $value->chun_id)
                //     ->update($chin_add_data);
                // dump($res);
                // $custbasvo['custbasvo'][0]['pk_corp'] = config('apiu8cloud.SHOP_BASIC_SETUP')[$user_info['adm_shop_id']]['pk_corp'];//公司主键
                // $custbasvo['custbasvo'][0]['pk_cubasdoc'] =$curl_data[0]['parentvo']['pk_cubasdoc'];//客商基本档案主键
                // $curl_return = $yongyou->u8cloudApi('客商基本档案分配', $custbasvo);
                // dump($curl_return);
                // // die;
                // unset($u8cloud_data);
                // unset($chin_add_data);
                // unset($curl_return);
            }
        }
    }

    // 业务凭证同步U8
    public function syncVoucher(Request $request)
    {
        // 验证数据
        // $verify_data = new VerifyAccountingSettlementController;
        // $error_message = $verify_data->checkValidator($request->all());
        // if ($error_message) {
        //     return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        // }

        // 判断当前业务凭证是否存在
        $vore_data = DB::table('voucher_receipts')
            ->where('vore_id', $request['vore_id'])
            // ->where('vore_state', 1)
            ->first(['vore_id', 'vore_order_type', 'vore_wor_id', 'vore_wor_number', 'vore_ord_id', 'vore_ord_number', 'vore_type', 'vore_client_id', 'vore_channel_unit', 'vore_actual_price', 'vore_early_costing', 'vore_plus_minus', 'vore_recycle_price']);
        if (empty($vore_data)) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'当前业务凭证不存在']);
        }

        // 获取当前操作账号信息
        try {
            $api_token = Crypt::decrypt($request['api_token']);
        } catch (\Exception $e) {
            return response()->json(["code"=>300, 'msg'=>'error', 'data'=>'非法api_token']);
        }

        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($api_token);

        $vore_edit_data['vore_state'] = 2;
        $vore_edit_data['vore_update_time'] = date('Y-m-d H:i:s');
        $vore_res = DB::table('voucher_receipts')
            ->where('vore_id', $request['vore_id'])
            ->update($vore_edit_data);

        // 根据凭证id查询对应的借贷关系
        $find_volo_data = DB::table('voucher_loan')
            ->where('volo_shop_id', $user_info->adm_shop_id)
            ->where('volo_vore_id', $request['vore_id'])
            ->get()->toArray();
        $find_volo_data = json_decode(json_encode($find_volo_data), true);
        // dump($find_volo_data);
        // exit;

        // if (config('apiu8cloud.CODE_START') && in_array($user_info->adm_shop_id, config('apiu8cloud.u8cloud_shop'))) {
        $request_voucher['wor_actual_price'] = abs($find_volo_data[0]['volo_borrow_price']) / 100;
        $request_voucher['subjcode'] = $find_volo_data[0]['volo_borrow_subject']; //会计科目
        $request_voucher['wor_id'] = $vore_data->vore_wor_id;
        $request_voucher['ord_client_id'] = $vore_data->vore_client_id;
        $request_voucher['voucher_cost'] = $find_volo_data[0]['volo_borrow_price']; //销售成本总额，换货单换新商品成本总额
        $vore_data->vore_id = $request['vore_id'];
        $u8_return = YongYous::apiWorkOrder($user_info, (array)$vore_data, $request_voucher, $find_volo_data); //调用u8接口
        if ($u8_return['code'] == 500) {
            DB::rollBack();
            if ($u8_return['vou_data']) {
                // 如果凭证添加失败，凭证号自动加1
                YongYous::insertVoucher($user_info, $u8_return['vou_data'], 1);
            }
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'U8财务系统凭证上传失败2！']);
        }
        // }
    }

    // 结款明细同步
    public function sync(Request $request)
    {
        // 验证数据
        // $verify_data = new VerifyAccountingSettlementController;
        // $error_message = $verify_data->checkValidator($request->all());
        // if ($error_message) {
        //     return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'参数错误', 'error_message'=>$error_message]);
        // }

        // 判断当前结款明细是否存在
        $settlement_data = DB::table('accounting_settlement')
            ->where('acset_id', $request['acset_id'])
            // ->where('acset_sync_state', 1)
            ->first(['acset_id', 'acset_original_number', 'acset_type', 'acset_state', 'acset_original_id', 'acset_inex_type', 'acset_actual_price', 'acset_zero_price', 'acset_acti_id', 'acset_payment_type', 'acset_merge_type', 'acset_price', 'acset_number', 'acset_zero_plus_minus', 'acset_price', 'acset_sync_state']);
        if (empty($settlement_data)) {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'当前结款明细不存在']);
        }
        // if ($settlement_data->acset_state == 2) {
        //     return response()->json(['code'=> 500, 'msg'=>'error', 'data'=>'当前结款明细已核对']);
        // }

        // 获取当前操作账号信息
        try {
            $api_token = Crypt::decrypt($request['api_token']);
        } catch (\Exception $e) {
            return response()->json(["code"=>300, 'msg'=>'error', 'data'=>'非法api_token']);
        }

        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($api_token);

        DB::beginTransaction();

        $acset_data['acset_sync_state'] = 2;
        $acset_data['acset_update_time'] = date('Y-m-d H:i:s');
        $acset_res = DB::table('accounting_settlement')
            ->where('acset_id', $request['acset_id'])
            ->update($acset_data);

        // dump($settlement_data);
        // exit;
        // if (config('apiu8cloud.CODE_START') && in_array($user_info->adm_shop_id, config('apiu8cloud.u8cloud_shop'))) {
        $request_voucher['recr_acti_id'] = $settlement_data->acset_acti_id; //银行账号id
        if (isset($request['recr_yet_receipt']) && !empty($request['recr_yet_receipt'])) {
            // 分多次付款
            $request_voucher['voucher_price'] = $request['recr_yet_receipt']; //确认金额
        } else {
            $request_voucher['voucher_price'] = $settlement_data->acset_actual_price / 100; //结款明细金额
        }
        // dump($request_voucher);
        // exit;
        $settlement_data->acset_id = $request['acset_id'];
        $u8_return = YongYous::apiAccountVerify($user_info, (array)$settlement_data, $request_voucher); //调用u8接口
        // dump($u8_return);
        // exit;
        if ($u8_return['code'] == 500) {
            DB::rollBack();
            if ($u8_return['vou_data']) {
                // 如果凭证添加失败，凭证号自动加1
                YongYous::insertVoucher($user_info, $u8_return['vou_data'], 1);
            }
            return ['code'=>500, 'msg'=>'error', 'data'=>'U8财务系统凭证上传失败2！'];
            echo 44;
        } else {
            echo 333;
        }
        // }
        if ($acset_res) {
            DB::commit();
            echo 11;
        // return ['code'=>200, 'msg'=>'success', 'data'=>'U8财务系统凭证上传成功！'];
        } else {
            DB::rollBack();
            echo 22;
            // return ['code'=>500, 'msg'=>'error', 'data'=>'U8财务系统凭证上传失败啦！'];
        }
    }

    // 订单类型为退货单的生成凭证
    public function orderVoucher(Request $request)
    {
        $adm_cid = 1;
        $shop_id = 1;

        ignore_user_abort();
        set_time_limit(0);

        // 查询类型为退货单,并且已经入库的数据
        $find_ord_data = DB::table('recede_recycle as rec')
            ->leftjoin('recede_client as recl', 'recl.recl_rec_id', '=', 'rec.rec_id')
            ->where('rec_cid', $adm_cid)
            ->where('rec_shop_id', $shop_id)
            ->whereIn('rec_source_type', [8])
            ->where('rec_state', 2)
            ->select('rec_id', 'rec_cid', 'rec_superior_shop_id', 'rec_shop_id', 'rec_ord_id', 'rec_ord_order_number', 'rec_type', 'recl_client_id', 'recl_channel_unit', 'rec_create_adm_id', 'rec_create_time', 'rec_ware_id', 'rec_waon_class')
            ->get()->toArray();
        $cost_price = 0;
        foreach ($find_ord_data as $key => $value) {
            // 根据订单id和单号查询出结算金额,代收金额,旧货回收金额
            $find_order_data = DB::table('order as ord')
                ->leftjoin('order_client as orcl', 'orcl.orcl_ord_id', '=', 'ord.ord_id')
                ->where('ord_id', $value->rec_ord_id)
                ->where('ord_cid', $value->rec_cid)
                ->where('ord_superior_shop_id', $value->rec_superior_shop_id)
                ->where('ord_shop_id', $value->rec_shop_id)
                ->where('ord_order_number', $value->rec_ord_order_number)
                ->where('ord_service_type', 4)
                ->select('ord_order_price', 'ord_actual_price', 'ord_collection_price', 'ord_plus_minus', 'ord_order_plus_minus', 'orcl_channel_unit', 'orcl_name', 'ord_create_time', 'ord_ware_id', 'ord_service_type')
                ->first();
            if ($find_order_data) {
                // 根据订单id和商品状态,查询出回收的商品
                $find_goods_data = DB::table('order_goods')
                    ->where('orgo_ord_id', $value->rec_ord_id)
                    ->where('orgo_state', 3)
                    ->select('orgo_id', 'orgo_ord_id', 'orgo_goo_id', 'orgo_goo_price', 'orgo_goo_quantity')
                    ->get()->toArray();
                $goo_recycle_price = [];
                foreach ($find_goods_data as $kk => $vv) {
                    if (!isset($goo_recycle_price[$vv->orgo_goo_id])) {
                        $goo_recycle_price[$vv->orgo_goo_id] = 0;
                    }
                    $goo_recycle_price[$vv->orgo_goo_id] += $vv->orgo_goo_price * $vv->orgo_goo_quantity; //商品数量
                }
                $recycle_amount = 0;
                foreach ($goo_recycle_price as $kkk => $vvv) {
                    $recycle_amount += $vvv;
                }
                // 根据订单id,查询商品
                $find_orgo_data = DB::table('order_goods')
                    ->where('orgo_ord_id', $value->rec_ord_id)
                    ->where('orgo_order_number', $value->rec_ord_order_number)
                    ->where('orgo_state', '!=', 2)
                    ->select('orgo_id', 'orgo_ord_id', 'orgo_ware_id', 'orgo_waon_class', 'orgo_goo_id', 'orgo_goo_price', 'orgo_goo_quantity', 'orgo_state')
                    ->get()->toArray();
                if ($find_orgo_data) {
                    $cost_price = 0;
                    foreach ($find_orgo_data as $kkkk => $vvvv) {
                        // 获取当前月份商品成本价
                        if ($vvvv->orgo_ware_id == '0') {
                            $vvvv->orgo_ware_id = $value->ord_ware_id;
                        } else {
                            $vvvv->orgo_ware_id = $vvvv->orgo_ware_id;
                        }
                        if ($vvvv->orgo_state != 3 && $vvvv->orgo_state != 7) {
                            $list_items = DB::table('enters_sells_saves')
                                ->where('ense_goo_id', $vvvv->orgo_goo_id)
                                ->where('ense_goo_warehouse', $vvvv->orgo_ware_id)
                                ->where('ense_goo_waretype', $vvvv->orgo_waon_class)
                                ->where('ense_order_number', $value->rec_ord_order_number)
                                ->select('ense_goo_id')
                                ->groupBy('ense_goo_id')
                                ->get()->toArray();
                            $ids = array();
                            foreach ($list_items as $kone => $vone) {
                                foreach ($vone as $kkone => $vvone) {
                                    $ids[] = $vvone;
                                }
                            }
                            $list = DB::table('enters_sells_saves')
                                ->where('ense_goo_warehouse', $vvvv->orgo_ware_id)
                                ->where('ense_goo_waretype', $vvvv->orgo_waon_class)
                                ->whereIn('ense_goo_id', $ids)
                                ->where('ense_order_number', $value->rec_ord_order_number)
                                ->select('ense_id', 'ense_goo_id', 'ense_end_price')
                                ->orderBy('ense_id', 'asc')
                                ->get()
                                ->toArray();
                            $dataayyar = array();
                            if ($list) {
                                $listarray = array();
                                $list = json_decode(json_encode($list), true);
                                foreach ($list as $ktwo => $vtwo) {
                                    if (isset($listarray[$vtwo['ense_goo_id']])) {
                                        $listarray[$vtwo['ense_goo_id']]['ense_end_price'] = $vtwo['ense_end_price'];
                                    } else {
                                        $listarray[$vtwo['ense_goo_id']] = $vtwo;
                                    }
                                }
                                $i = "0";
                                foreach ($listarray as $kthree => $vthree) {
                                    $dataayyar[$i] = $vthree;
                                    $i = $i + 1;
                                }
                            }
                            if ($dataayyar) {
                                foreach ($dataayyar as $k3 => $v3) {
                                    $cost_price += $v3['ense_end_price'] * $vvvv->orgo_goo_quantity;
                                }
                            } else {
                                $cost_price = 0;
                            }
                        }
                    }
                    // 判断凭证单据是否存在
                    $vore_id = DB::table('voucher_receipts')
                        ->where('vore_cid', $adm_cid)
                        ->where('vore_shop_id', $shop_id)
                        ->where('vore_ord_id', $value->rec_ord_id)
                        ->where('vore_ord_number', $value->rec_ord_order_number)
                        ->where('vore_order_type', 1)
                        ->where('vore_state', 1)
                        ->select('vore_ord_id', 'vore_ord_number')
                        ->first();
                    if (empty($vore_id)) {
                        // 凭证单据报表
                        $vore_data['vore_cid'] = $adm_cid; //公司id
                        $vore_data['vore_superior_shop_id'] = $shop_id; //总店id
                        $vore_data['vore_shop_id'] = $shop_id; //门店id
                        $vore_data['vore_create_id'] = $value->rec_create_adm_id; //创建人
                        $vore_data['vore_order_type'] = 1; //单号类型1.订单2.工单3.采购单4.销售单
                        $vore_data['vore_ord_id'] = $value->rec_ord_id; //订单id
                        $vore_data['vore_ord_number'] = $value->rec_ord_order_number; //订单单号
                        $vore_data['vore_plus_minus'] = $find_order_data->ord_plus_minus; //金额正负1正值2负值
                        $vore_data['vore_actual_price'] = $find_order_data->ord_actual_price / 100; //结算金额
                        $vore_data['vore_recycle_price'] = $recycle_amount / 100; //回收金额
                        $vore_data['vore_early_costing'] = $cost_price; //成本
                        $vore_data['vore_type'] = $value->rec_type; //单位类型1会员零售2客户单位3速电派单
                        $vore_data['vore_client_id'] = $value->recl_client_id; //客户单位/客户id
                        if ($value->rec_type == 1) { //会员零售
                            $vore_data['vore_channel_unit'] = $find_order_data->orcl_name;
                        } elseif ($value->rec_type == 2) { //客户单位
                            $vore_data['vore_channel_unit'] = $find_order_data->orcl_channel_unit;
                        } elseif ($value->rec_type == 3) { //速电派单
                            $vore_data['vore_channel_unit'] = $find_order_data->orcl_channel_unit;
                        }
                        $vore_data['vore_create_time'] = $find_order_data->ord_create_time;
                        $vore_id = DB::table('voucher_receipts')->insertGetId($vore_data);
                        // 凭证借贷表(结算金额)
                        $volo_data[0]['volo_shop_id'] = $shop_id;
                        $volo_data[0]['volo_vore_id'] = $vore_id;
                        $volo_data[0]['volo_type'] = 1; //类型1借方2贷方
                        if ($value->rec_waon_class == '1') {
                            $volo_data[0]['volo_borrow_subject'] = '600101'; //借方科目
                            $volo_data[0]['volo_borrow_subject_name'] = '主营业务收入'; //借方科目名称
                            $volo_data[0]['volo_loan_subject'] = '1122'; //贷方科目
                            $volo_data[0]['volo_loan_subject_name'] = '应收账款'; //贷方科目名称

                            $volo_data[0]['volo_borrow_costing_subject'] = '140501'; //借方成本科目
                            $volo_data[0]['volo_borrow_costing_name'] = '库存商品'; //借方成本名称
                            $volo_data[0]['volo_borrow_costing'] = $cost_price; //借方成本
                            $volo_data[0]['volo_loan_costing_subject'] = '640101'; //贷方成本科目
                            $volo_data[0]['volo_loan_costing_name'] = '主营业务成本'; //贷方成本名称
                            $volo_data[0]['volo_loan_costing'] = $cost_price; //贷方成本
                        } elseif ($value->rec_waon_class == '3') {
                            $volo_data[0]['volo_borrow_subject'] = '140501'; //借方科目
                            $volo_data[0]['volo_borrow_subject_name'] = '库存商品'; //借方科目名称
                            $volo_data[0]['volo_loan_subject'] = '1122'; //贷方科目
                            $volo_data[0]['volo_loan_subject_name'] = '应收账款'; //贷方科目名称

                            // $volo_data[0]['volo_borrow_costing_subject'] = '6401';//借方成本科目
                            // $volo_data[0]['volo_borrow_costing_name'] = '主营业务成本';//借方成本名称
                            // $volo_data[0]['volo_borrow_costing'] = $cost_price;//借方成本
                            // $volo_data[0]['volo_loan_costing_subject'] = '1406';//贷方成本科目
                            // $volo_data[0]['volo_loan_costing_name'] = '库存商品';//贷方成本名称
                            // $volo_data[0]['volo_loan_costing'] = $cost_price;//贷方成本
                        }
                        $volo_data[0]['volo_update_time'] = $find_order_data->ord_create_time; //更新时间
                        $volo_data[0]['volo_loan_price'] = $find_order_data->ord_actual_price / 100 + $recycle_amount / 100; //贷方金额
                        $volo_data[0]['volo_borrow_price'] = $find_order_data->ord_actual_price / 100; //借方金额
                        if (!empty($find_goods_data)) {
                            $volo_id = DB::table('voucher_loan')->insert($volo_data);
                        } else {
                            $volo_id = DB::table('voucher_loan')->insert($volo_data[0]);
                        }
                    } else {
                        $vore_id = true;
                        $volo_id = true;
                    }
                } else {
                    $vore_id = true;
                    $volo_id = true;
                }
            } else {
                $vore_id = true;
                $volo_id = true;
            }
            dump($vore_id);
            dump($volo_id);
            unset($vore_id);
            unset($volo_id);
        }
        echo '80808';
    }

    // 工单列表退货单生成凭证
    public function returnVoucher2()
    {
        echo '90';
        $adm_cid = 1;
        $shop_id = 1;

        ignore_user_abort();
        set_time_limit(0);
        // 查询类型为工单退货单,并且已经入库的数据
        $find_ord_data = DB::table('recede_recycle as rec')
            ->leftjoin('recede_client as recl', 'recl.recl_rec_id', '=', 'rec.rec_id')
            ->where('rec_cid', $adm_cid)
            ->where('rec_shop_id', $shop_id)
            ->whereIn('rec_source_type', [4])
            ->where('rec_state', 2)
            ->select('rec_id', 'rec_cid', 'rec_superior_shop_id', 'rec_shop_id', 'rec_ord_id', 'rec_ord_order_number', 'rec_type', 'recl_client_id', 'recl_channel_unit', 'rec_create_adm_id', 'rec_create_time', 'rec_ware_id', 'rec_waon_class')
            ->get()->toArray();
        $cost_price = 0;
        foreach ($find_ord_data as $key => $value) {
            // 根据工单id和单号查询出结算金额,代收金额,旧货回收金额
            $find_order_data = DB::table('work_order as wor')
                ->leftjoin('work_client as wocl', 'wocl.wocl_wor_id', '=', 'wor.wor_id')
                ->where('wor_id', $value->rec_ord_id)
                ->where('wor_cid', $value->rec_cid)
                ->where('wor_superior_shop_id', $value->rec_superior_shop_id)
                ->where('wor_shop_id', $value->rec_shop_id)
                ->where('wor_number', $value->rec_ord_order_number)
                ->where('wor_service_type', 4)
                ->select('wor_actual_price', 'wor_collection_price', 'wor_plus_minus', 'wocl_channel_unit', 'wocl_name', 'wor_create_time', 'wor_ware_id', 'wor_service_type', 'wor_order_id', 'wor_order_number')
                ->first();
            // dump($find_order_data);
            if ($find_order_data) {
                // 根据工单id和商品状态,查询出回收的商品
                $find_goods_data = DB::table('work_good')
                    ->where('wogo_wor_id', $value->rec_ord_id)
                    ->where('wogo_state', 3)
                    ->select('wogo_id', 'wogo_wor_id', 'wogo_goo_id', 'wogo_goo_price', 'wogo_goo_amount')
                    ->get()->toArray();
                $goo_recycle_price = [];
                foreach ($find_goods_data as $kk => $vv) {
                    if (!isset($goo_recycle_price[$vv->wogo_goo_id])) {
                        $goo_recycle_price[$vv->wogo_goo_id] = 0;
                    }
                    $goo_recycle_price[$vv->wogo_goo_id] += $vv->wogo_goo_price * $vv->wogo_goo_amount; //商品数量
                }
                $recycle_amount = 0;
                foreach ($goo_recycle_price as $kkk => $vvv) {
                    $recycle_amount += $vvv;
                }
                // 根据工单id,查询商品
                $find_orgo_data = DB::table('work_good')
                    ->where('wogo_wor_id', $value->rec_ord_id)
                    ->where('wogo_state', '!=', 2)
                    ->select('wogo_id', 'wogo_wor_id', 'wogo_ware_id', 'wogo_waon_class', 'wogo_goo_id', 'wogo_goo_price', 'wogo_goo_amount', 'wogo_state')
                    ->get()->toArray();
                if ($find_orgo_data) {
                    $cost_price = 0;
                    foreach ($find_orgo_data as $kkkk => $vvvv) {
                        // 获取当前月份商品成本价
                        if ($vvvv->wogo_ware_id == '0') {
                            $vvvv->wogo_ware_id = $value->ord_ware_id;
                        } else {
                            $vvvv->wogo_ware_id = $vvvv->wogo_ware_id;
                        }
                        if ($vvvv->wogo_state != 3 && $vvvv->wogo_state != 7) {
                            $list_items = DB::table('enters_sells_saves')
                                ->where('ense_goo_id', $vvvv->wogo_goo_id)
                                ->where('ense_goo_warehouse', $vvvv->wogo_ware_id)
                                ->where('ense_goo_waretype', $vvvv->wogo_waon_class)
                                ->where('ense_order_number', $find_order_data->wor_order_number)
                                ->select('ense_goo_id')
                                ->groupBy('ense_goo_id')
                                ->get()->toArray();
                            $ids = array();
                            foreach ($list_items as $kone => $vone) {
                                foreach ($vone as $kkone => $vvone) {
                                    $ids[] = $vvone;
                                }
                            }
                            $list = DB::table('enters_sells_saves')
                                ->where('ense_goo_warehouse', $vvvv->wogo_ware_id)
                                ->where('ense_goo_waretype', $vvvv->wogo_waon_class)
                                ->whereIn('ense_goo_id', $ids)
                                ->where('ense_order_number', $find_order_data->wor_order_number)
                                ->select('ense_id', 'ense_goo_id', 'ense_end_price')
                                ->orderBy('ense_id', 'asc')
                                ->get()
                                ->toArray();
                            $dataayyar = array();
                            if ($list) {
                                $listarray = array();
                                $list = json_decode(json_encode($list), true);
                                foreach ($list as $ktwo => $vtwo) {
                                    if (isset($listarray[$vtwo['ense_goo_id']])) {
                                        $listarray[$vtwo['ense_goo_id']]['ense_end_price'] = $vtwo['ense_end_price'];
                                    } else {
                                        $listarray[$vtwo['ense_goo_id']] = $vtwo;
                                    }
                                }
                                $i = "0";
                                foreach ($listarray as $kthree => $vthree) {
                                    $dataayyar[$i] = $vthree;
                                    $i = $i + 1;
                                }
                            }
                            if ($dataayyar) {
                                foreach ($dataayyar as $k3 => $v3) {
                                    $cost_price += $v3['ense_end_price'] * $vvvv->wogo_goo_amount;
                                }
                            } else {
                                $cost_price = 0;
                            }
                        }
                    }
                    // 判断凭证单据是否存在
                    $vore_id = DB::table('voucher_receipts')
                        ->where('vore_cid', $adm_cid)
                        ->where('vore_shop_id', $shop_id)
                        ->where('vore_ord_id', $value->rec_ord_id)
                        ->where('vore_ord_number', $value->rec_ord_order_number)
                        ->where('vore_order_type', 2)
                        ->where('vore_state', 1)
                        ->select('vore_ord_id', 'vore_ord_number')
                        ->first();
                    if (empty($vore_id)) {
                        // 凭证单据报表
                        $vore_data['vore_cid'] = $adm_cid; //公司id
                        $vore_data['vore_superior_shop_id'] = $shop_id; //总店id
                        $vore_data['vore_shop_id'] = $shop_id; //门店id
                        $vore_data['vore_create_id'] = $value->rec_create_adm_id; //创建人
                        $vore_data['vore_order_type'] = 2; //单号类型1.订单2.工单3.采购单4.销售单
                        $vore_data['vore_wor_id'] = $value->rec_ord_id; //工单id
                        $vore_data['vore_wor_number'] = $value->rec_ord_order_number; //工单单号
                        $vore_data['vore_ord_id'] = $find_order_data->wor_order_id; //订单id
                        $vore_data['vore_ord_number'] = $find_order_data->wor_order_number; //订单单号
                        $vore_data['vore_plus_minus'] = $find_order_data->wor_plus_minus; //金额正负1正值2负值
                        $vore_data['vore_actual_price'] = $find_order_data->wor_actual_price / 100; //结算金额
                        $vore_data['vore_recycle_price'] = $recycle_amount / 100; //回收金额
                        $vore_data['vore_early_costing'] = $cost_price; //成本
                        $vore_data['vore_type'] = $value->rec_type; //单位类型1会员零售2客户单位3速电派单
                        $vore_data['vore_client_id'] = $value->recl_client_id; //客户单位/客户id
                        if ($value->rec_type == 1) { //会员零售
                            $vore_data['vore_channel_unit'] = $find_order_data->wocl_name;
                        } elseif ($value->rec_type == 2) { //客户单位
                            $vore_data['vore_channel_unit'] = $find_order_data->wocl_channel_unit;
                        } elseif ($value->rec_type == 3) { //速电派单
                            $vore_data['vore_channel_unit'] = $find_order_data->wocl_channel_unit;
                        }
                        $vore_data['vore_create_time'] = $find_order_data->wor_create_time;
                        $vore_id = DB::table('voucher_receipts')->insertGetId($vore_data);
                        // 凭证借贷表(结算金额)
                        $volo_data[0]['volo_shop_id'] = $shop_id;
                        $volo_data[0]['volo_vore_id'] = $vore_id;
                        $volo_data[0]['volo_type'] = 1; //类型1借方2贷方
                        if ($value->rec_waon_class == '1') {
                            $volo_data[0]['volo_borrow_subject'] = '600101'; //借方科目
                            $volo_data[0]['volo_borrow_subject_name'] = '主营业务收入'; //借方科目名称
                            $volo_data[0]['volo_loan_subject'] = '1122'; //贷方科目
                            $volo_data[0]['volo_loan_subject_name'] = '应收账款'; //贷方科目名称

                            $volo_data[0]['volo_borrow_costing_subject'] = '140501'; //借方成本科目
                            $volo_data[0]['volo_borrow_costing_name'] = '库存商品'; //借方成本名称
                            $volo_data[0]['volo_borrow_costing'] = $cost_price; //借方成本
                            $volo_data[0]['volo_loan_costing_subject'] = '640101'; //贷方成本科目
                            $volo_data[0]['volo_loan_costing_name'] = '主营业务成本'; //贷方成本名称
                            $volo_data[0]['volo_loan_costing'] = $cost_price; //贷方成本
                        } elseif ($value->rec_waon_class == '3') {
                            $volo_data[0]['volo_borrow_subject'] = '140501'; //借方科目
                            $volo_data[0]['volo_borrow_subject_name'] = '库存商品'; //借方科目名称
                            $volo_data[0]['volo_loan_subject'] = '1122'; //贷方科目
                            $volo_data[0]['volo_loan_subject_name'] = '应收账款'; //贷方科目名称
                        }
                        $volo_data[0]['volo_update_time'] = $find_order_data->wor_create_time; //更新时间
                        $volo_data[0]['volo_loan_price'] = $find_order_data->wor_actual_price / 100 + $recycle_amount / 100; //贷方金额
                        $volo_data[0]['volo_borrow_price'] = $find_order_data->wor_actual_price / 100; //借方金额
                        if (!empty($find_goods_data)) {
                            $volo_id = DB::table('voucher_loan')->insert($volo_data);
                        } else {
                            $volo_id = DB::table('voucher_loan')->insert($volo_data[0]);
                        }
                    } else {
                        $vore_id = true;
                        $volo_id = true;
                    }
                } else {
                    $vore_id = true;
                    $volo_id = true;
                }
            } else {
                $vore_id = true;
                $volo_id = true;
            }
            dump($vore_id);
            dump($volo_id);
            unset($vore_id);
            unset($volo_id);
        }
        echo '80808';
    }

    // 查询采购单已完成,没有生成凭证的单号
    public function purchase3()
    {
        ignore_user_abort();
        set_time_limit(0);

        $cid = 1;
        $shop_id = 1;

        // 查询已经入库的采购单凭证
        $find_wain_data = DB::table('ware_inorder as wain')
            ->leftjoin('purchase_order as puor', 'puor.cg_number', '=', 'wain.cg_number')
            ->where('wain.company_id', $cid)
            ->where('wain.rk_superior_shop_id', $shop_id)
            ->where('is_del', 1)
            ->whereIn('cg_state', [8, 11, 12])
            ->where('cg_paymentype', '!=', 3)
            ->select('puor.cg_id', 'puor.cg_number', 'rk_id', 'wain.company_id', 'wain.rk_superior_shop_id', 'wain.rk_shop_id', 'rk_number', 'cg_state', 'cg_supplyunit', 'cg_creator', 'contact_name', 'contact_phone', 'rk_type', 'rk_amount', 'rk_creator', 'wain.create_time', 'puor.cg_amount')
            ->get()->toArray();

        foreach ($find_wain_data as $key => $value) {
            if ($value->rk_amount != $value->cg_amount) {
                dump($value->cg_number);
            }
        }

        /* $find_puor_data = DB::table('purchase_order')
            ->where('company_id', $cid)
            ->where('cg_superior_shop_id', $shop_id)
            ->where('cg_shop_id', $shop_id)
            ->whereIn('cg_state', [11, 12])
            ->where('cg_paymentype', '!=', 1)
            ->select('cg_id', 'cg_number')
            ->get()->toArray();
        foreach ($find_puor_data as $key => $value) {
            // 根据采购单id和单号查询对应的凭证
            $find_vore_data = DB::table('voucher_receipts')
                ->where('vore_cid', $cid)
                ->where('vore_superior_shop_id', $shop_id)
                ->where('vore_shop_id', $shop_id)
                ->whereIn('vore_order_type', [3, 5])
                ->where('vore_ord_id', $value->cg_id)
                ->where('vore_ord_number', $value->cg_number)
                ->select('vore_id', 'vore_ord_id', 'vore_ord_number')
                ->first();
            if ($value->cg_number != isset($find_vore_data->vore_ord_number)) {
                dump($value->cg_number);
            }
        } */
    }

    // 查询订单已完成的数据,没有应收应付
    public function order8()
    {
        ignore_user_abort();
        set_time_limit(0);

        $cid = 1;
        $shop_id = 1;
        $find_ord_data = DB::table('order')
            ->where('ord_cid', $cid)
            ->where('ord_superior_shop_id', $shop_id)
            ->where('ord_shop_id', $shop_id)
            // ->where('ord_type', '!=', 3)
            ->where('ord_wor_state', 4)
            ->where('ord_delete', 1)
            ->where('ord_collection_bill', 1)
            ->select('ord_id', 'ord_order_number')
            ->get()->toArray();
        foreach ($find_ord_data as $key => $value) {
            // 根据账单查询应收应付
            $find_recr_data = DB::table('receivable_credit')
                ->where('recr_cid', $cid)
                ->where('recr_shop_id', $shop_id)
                ->where('recr_shop_superior_id', $shop_id)
                // ->where('recr_type', 3)
                // ->where('recr_account_type', 5)
                ->where('recr_original_id', $value->ord_id)
                ->where('recr_original_number', $value->ord_order_number)
                ->select('recr_id', 'recr_original_id', 'recr_original_number')
                ->first();
            if (empty($find_recr_data->recr_original_number)) {
                dump($value->ord_order_number);
            }
        }
    }

    // 删除调拨单流水记录
    public function delTrans()
    {
        ignore_user_abort();
        set_time_limit(0);

        $cid = 1;
        $shop_id = 1;
        $find_tror_data = DB::table('transferring_order')
            ->where('tror_cid', $cid)
            ->where('tror_superior_shop_id', $shop_id)
            ->where('tror_shop_id', $shop_id)
            ->where('tror_state', 6)
            ->select('tror_id', 'tror_number')
            ->get()->toArray();
        // dump($find_outin_data);
        foreach ($find_tror_data as $key => $value) {
            $find_outin_data = DB::table('outin_record')
                ->where('oure_cid', $cid)
                ->where('oure_superior_shop_id', $shop_id)
                ->where('oure_shop_id', $shop_id)
                ->where('oure_original_correlation_id', $value->tror_id)
                ->where('oure_original_correlation_number', $value->tror_number)
                ->where('oure_original_correlation_type', 2)
                ->select('oure_id', 'oure_original_correlation_id', 'oure_original_correlation_number', 'oure_original_number')
                ->first();
            dump($find_outin_data);
            $del_oude_id = DB::table('outin_details as oude')
                ->leftjoin('outin_record as oure', 'oure.oure_id', '=', 'oude.oude_oure_id')
                ->where('oure_cid', $cid)
                ->where('oure_superior_shop_id', $shop_id)
                ->where('oure_shop_id', $shop_id)
                ->where('oure_original_correlation_id', $value->tror_id)
                ->where('oure_original_correlation_number', $value->tror_number)
                ->where('oure_original_correlation_type', 2)
                ->select('oure_id', 'oure_original_correlation_id', 'oure_original_correlation_number', 'oure_original_number')
                ->delete();
            $del_oure_id = DB::table('outin_record')
                ->where('oure_cid', $cid)
                ->where('oure_superior_shop_id', $shop_id)
                ->where('oure_shop_id', $shop_id)
                ->where('oure_original_correlation_id', $value->tror_id)
                ->where('oure_original_correlation_number', $value->tror_number)
                ->where('oure_original_correlation_type', 2)
                ->select('oure_id', 'oure_original_correlation_id', 'oure_original_correlation_number', 'oure_original_number')
                ->delete();
            dump($del_oude_id);
            dump($del_oure_id);
            unset($del_oude_id);
            unset($del_oure_id);
        }
        echo '9090';
    }

    // 查询流水记录数据主表和子表数量是否一致
    public function outins3()
    {
        ignore_user_abort();
        set_time_limit(0);

        $cid = 1;
        $shop_id = 1;

        $find_oure_data = DB::table('outin_details as oude')
            ->leftjoin('outin_record as oure', 'oure.oure_id', '=', 'oude.oude_oure_id')
            ->where('oure_cid', $cid)
            ->where('oure_superior_shop_id', $shop_id)
            ->where('oure_shop_id', $shop_id)
            ->select('oure_id', 'oure_number', 'oure_count', 'oude_goo_number')
            ->get()->toArray();
        $goods_nums = 0;
        $ware_class_type_goo = [];
        foreach ($find_oure_data as $key => $value) {
            // $find_oude_data = DB::table('outin_details')
            //     ->where('oude_oure_id', $value->oure_id)
            //     ->select('oude_goo_number', 'oude_oure_id')
            //     ->first();
            if (isset($ware_class_type_goo[$value->oure_id])) {
                $ware_class_type_goo[$value->oure_id] += $value->oude_goo_number;
            } else {
                $ware_class_type_goo[$value->oure_id] = $value->oude_goo_number;
            }
            // dump($ware_class_type_goo);
            // exit;
            // $goods_nums += $value->oude_goo_number[$value->oure_id];
            // dump($value->oure_count . '======' . $value->oure_number . '-=-=-=' . $value->oure_id);
            // dump($goods_nums . '----------' . $value->oure_id);
            // if ($value->oure_count != $goods_nums) {
            //     dump($value->oure_number);
            // }
        }
        foreach ($ware_class_type_goo as $kk => $vv) {
            // dump($kk);
            $find_oure = DB::table('outin_record')
                ->where('oure_id', $kk)
                ->select('oure_id', 'oure_number', 'oure_count')
                ->first();
            if ($vv != $find_oure->oure_count) {
                dump($find_oure->oure_number);
            }
        }
    }

    // 有订单没有工单的数据
    public function order7()
    {
        ignore_user_abort();
        set_time_limit(0);

        $cid = 1;
        $shop_id = 1;
        $find_ord_data = DB::table('order as ord')
            ->leftjoin('order_client as orcl', 'orcl.orcl_ord_id', '=', 'ord.ord_id')
            ->where('ord_cid', $cid)
            ->where('ord_superior_shop_id', $shop_id)
            ->where('ord_shop_id', $shop_id)
            ->whereIn('ord_wor_state', [2, 9, 8, 4])
            ->whereIn('ord_service_type', [1, 3, 7])
            ->where('ord_collection_bill', 1)
            ->select('ord_id', 'ord_order_number')
            ->get()->toArray();
        // dump($find_ord_data);
        foreach ($find_ord_data as $key => $value) {
            $find_wor_data = DB::table('work_order')
                ->where('wor_cid', $cid)
                ->where('wor_superior_shop_id', $shop_id)
                ->where('wor_shop_id', $shop_id)
                ->where('wor_order_id', $value->ord_id)
                ->where('wor_order_number', $value->ord_order_number)
                ->where('wor_collection_bill', 1)
                ->select('wor_id', 'wor_number', 'wor_order_id', 'wor_order_number')
                ->first();
            // dump($find_wor_data);
            if ($value->ord_order_number != isset($find_wor_data->wor_order_number)) {
                dump($value->ord_order_number);
            }
        }
        echo '9090';
    }

    // 查询工单审核通过,订单服务中的数据
    public function works()
    {
        $adm_cid = 1;
        $shop_id = 1;

        ignore_user_abort();
        set_time_limit(0);

        $find_work_data = DB::table('work_order')
            ->where('wor_cid', $adm_cid)
            ->where('wor_superior_shop_id', $shop_id)
            ->where('wor_shop_id', $shop_id)
            ->where('wor_delete', 1)
            ->where('wor_state', 10)
            ->where('wor_collection_bill', 1)
            ->select('wor_id', 'wor_number', 'wor_order_id', 'wor_order_number')
            ->get()->toArray();
        foreach ($find_work_data as $key => $value) {
            $find_ord_data = DB::table('order')
                ->where('ord_id', $value->wor_order_id)
                ->where('ord_cid', $adm_cid)
                ->where('ord_superior_shop_id', $shop_id)
                ->where('ord_shop_id', $shop_id)
                ->where('ord_order_number', $value->wor_order_number)
                ->where('ord_delete', 1)
                ->where('ord_collection_bill', 1)
                ->where('ord_collection_bill', 1)
                ->where('ord_wor_state', 2)
                ->select('ord_id', 'ord_order_number')
                ->first();
            if (!empty($find_ord_data)) {
                dump($find_ord_data);
            }
        }
    }

    // 查询账单列表已结款,没有应收应付和结款明细的单据
    public function receivable4()
    {
        $adm_cid = 1;
        $shop_id = 1;

        ignore_user_abort();
        set_time_limit(0);

        $find_orbi_data = DB::table('order_bill')
            ->where('orbi_cid', $adm_cid)
            ->where('orbi_superior_shop_id', $shop_id)
            ->where('orbi_shop_id', $shop_id)
            ->whereIn('orbi_state', [2, 5])
            ->where('orbi_create_type', 1)
            ->select('orbi_id', 'orbi_number')
            ->get()->toArray();
        foreach ($find_orbi_data as $key => $value) {
            // 根据账单查询应收应付
            $find_recr_data = DB::table('receivable_credit')
                ->where('recr_cid', $adm_cid)
                ->where('recr_shop_id', $shop_id)
                ->where('recr_shop_superior_id', $shop_id)
                ->where('recr_type', 3)
                ->where('recr_account_type', 5)
                ->where('recr_original_id', $value->orbi_id)
                ->where('recr_original_number', $value->orbi_number)
                ->select('recr_id', 'recr_original_id', 'recr_original_number')
                ->first();
            if (empty($find_recr_data->recr_original_number)) {
                dump($value->orbi_number);
            }
            // 根据账单查询结款明细
            $find_recr_datas = DB::table('accounting_settlement')
                ->where('acset_adm_cid', $adm_cid)
                ->where('acset_shop_id', $shop_id)
                ->where('acset_superior_shop_id', $shop_id)
                ->where('acset_type', 2)
                ->where('acset_state', 2)
                ->where('acset_original_id', $value->orbi_id)
                ->where('acset_original_number', $value->orbi_number)
                ->select('acset_id', 'acset_original_id', 'acset_original_number')
                ->first();
            if (empty($find_recr_datas->acset_original_number)) {
                dump($value->orbi_number);
            }
        }
        echo 'string';
    }

    // 根据发货单,生成对应的出入库记录
    public function shipments(Request $request)
    {
        // 获取当前操作账号信息
        try {
            $api_token = Crypt::decrypt($request['api_token']);
        } catch (\Exception $e) {
            return response()->json(["code"=>300, 'msg'=>'error', 'data'=>'非法api_token']);
        }

        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($api_token);

        // 验证已经发货的不能再次发货
        $dis_data = DB::table('dispatch_bill')
            // ->where('dego_number', 'FH1598159556776')
            // ->where('dego_number', 'FH1598159901295')
            // ->where('dego_number', 'FH1598594877169')
            ->where('dego_number', 'FH1598662015169')
            ->select('dego_id', 'dego_type', 'dego_cid', 'dego_shop_id', 'dego_out_ware_id', 'dego_service_adm_id', 'dego_number', 'dego_order_type', 'dego_wor_id', 'dego_original_number', 'dego_service_shop_id', 'dego_count', 'dego_create_adm_id')
            ->first();

        if ($dis_data->dego_order_type == 2) {
            // 工单发货验证 技师是否绑定了移动仓
            $service_ware_id = DB::table('warehouse')
                ->where('ware_type', 2) //类型：1固定仓2移动仓
                ->where('ware_leader_id', $dis_data->dego_service_adm_id)
                ->value('ware_id');
            if (empty($service_ware_id)) {
                return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'当前技师未绑定移动仓,请先绑定移动仓']);
            }
            // 查询当前工单技师的服务状态
            $wor_service_state = DB::table('work_order')
                ->where('wor_id', $dis_data->dego_wor_id)
                ->value('wor_service_state');
            // 如果技师尚未接单，不允许发货
            // 服务状态：1待接单2已接单3预约4出发5抵达6完成待审核7完成已驳回8完成通过9终止10锁定11速电撤销回收
            if ($wor_service_state < 2) {
                return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'当前技师尚未接单！']);
            }
        }

        $goods_data = json_decode($request['goodsDataList'], true); //获取发货商品数据信息

        // 查询出该发货单的商品
        $goods_data = DB::table('dispatch_goods')
            ->where('digo_dego_id', $dis_data->dego_id)
            ->get(['digo_goo_id', 'digo_wago_class', 'digo_goo_quantity', 'digo_goo_inventory'])
            ->toArray();

        $goo_all_fine = 0; //良品总数量
        $goo_all_priority = 0; //优先总数量
        foreach ($goods_data as $key => $value) {
            $goo_id[$key] = $value->digo_goo_id; //出库的商品id
            $digo_goo_id[$key] = $value->digo_goo_id; //出库的商品id
            $goo_price[$key] = 0; //商品金额
            $number[$key] = $value->digo_goo_quantity;

            // 每个商品对应的出库数量
            $subtract[$value->digo_goo_id] = $value->digo_goo_quantity;
            // 每个商品对应的出库方式
            $goo_inventory_type[$value->digo_goo_id] = $value->digo_goo_inventory; //商品的出库类型
            $digo_goo_inventory[$key] = $value->digo_goo_inventory;
            $wago_goo_inventory[$value->digo_goo_id] = $value->digo_goo_inventory; //仓库id使用

            if ($value->digo_goo_inventory == 1) {
                $goo_all_fine += $value->digo_goo_quantity; //1.良品总数量
            } else {
                $goo_all_priority += $value->digo_goo_quantity; //2.优先总数量
            }

            $wago_class[] = $value->digo_wago_class; //仓库类型
            if (isset($wago_class_goods[$value->digo_wago_class][$value->digo_goo_id])) {
                $wago_class_goods[$value->digo_wago_class][$value->digo_goo_id]['digo_goo_quantity'] = $wago_class_goods[$value->digo_wago_class][$value->digo_goo_id]['digo_goo_quantity'] + $value->digo_goo_quantity; //仓库类型对应的商品，进销存计算
            } else {
                $wago_class_goods[$value->digo_wago_class][$value->digo_goo_id] = (array)$value; //仓库类型对应的商品，进销存计算
            }
        }
        $wago_class = array_unique($wago_class);
        // 2.选中的固定仓减锁定库存
        $warehouse_goods = DB::table('warehouse_goods')
            ->where('wago_ware_id', $dis_data->dego_out_ware_id)
            ->whereIn('wago_class', $wago_class)
            ->whereIn('wago_goo_id', $digo_goo_id)
            ->get(['wago_id', 'wago_class', 'wago_goo_id', 'wago_lock_quantity', 'wago_priority_lock_quantity'])
            ->toArray();
        foreach ($warehouse_goods as $key => $value) {
            $warehouse_class_goods[$value->wago_class][$value->wago_goo_id] = (array)$value;
        }

        if ($dis_data->dego_order_type == '1') { //类型1订单发货
            $find_order_data = DB::table('order as ord')
                ->leftjoin('order_client as orcl', 'orcl.orcl_ord_id', '=', 'ord.ord_id')
                ->where('ord_id', $dis_data->dego_wor_id)
                ->select('ord_type', 'ord_client_id')
                ->first();
            $oure_original_correlation_id = $dis_data->dego_wor_id;
            $oure_original_correlation_number = $dis_data->dego_original_number;
            $oure_original_correlation_type = 1;
            $oure_client_type = $find_order_data->ord_type;
            $oure_client_id = $find_order_data->ord_client_id;
        } elseif ($dis_data->dego_order_type == '2') { //2工单发货
            $find_order_data = DB::table('work_order as wor')
                ->leftjoin('work_client as wocl', 'wocl.wocl_wor_id', '=', 'wor.wor_id')
                ->where('wor_id', $dis_data->dego_wor_id)
                ->select('wor_type', 'wocl_client_id', 'wor_order_id', 'wor_order_number')
                ->first();
            $oure_original_correlation_id = $find_order_data->wor_order_id;
            $oure_original_correlation_number = $find_order_data->wor_order_number;
            $oure_client_type = $find_order_data->wor_type;
            $oure_client_id = $find_order_data->wocl_client_id;
        }
        // 遍历仓库类型数据，处理固定仓库对应仓库类型的进销存
        foreach ($wago_class_goods as $waon_class_key => $class_goods_data) {
            // 进销存，固定仓库，进销存库存数量减少
            // 查询仓库类别的进销存计算方式
            $goo_all_amount = 0;
            foreach ($class_goods_data as $goo_id_key => $value) {
                $purchase_goo_id[] = $goo_id_key;
                $purchase_goo_actual_count[$goo_id_key] = $value['digo_goo_quantity']; //进销存商品数量
                $purchase_goo_actual_price[$goo_id_key] = $value['digo_goo_quantity']; //进销存销出不需要价格，这个方法需要传入这个参数

                // 出入库记录需要的的商品数组
                $oure_goods_dataarray[$waon_class_key][$goo_id_key]['goo_quantity'] = $value['digo_goo_quantity']; //出入库商品数量
                $oure_goods_dataarray[$waon_class_key][$goo_id_key]['goo_inventory'] = 1; //出入库商品类型，类型1良品2优先，页面没有用到这个，暂定1
                $goo_all_amount += $value['digo_goo_quantity'];

                // 出入库记录需要
                $oure_goods_id[$goo_id_key] = $value['digo_goo_id']; //出入库商品id
                $oure_goods_quantity[$goo_id_key] = $value['digo_goo_quantity']; //出入库商品数量
                $oure_goods_inventory[$goo_id_key] = $value['digo_goo_inventory']; //出入库商品类型，类型1良品2优先，页面没有用到这个，暂定1
            }

            $find_ware = DB::table('warehouse_onhand')
                ->where('waon_ware_id', '=', $dis_data->dego_out_ware_id)
                ->where('waon_class', $waon_class_key)
                ->select('waon_stock_fine_amount', 'waon_lock_fine_amount', 'waon_stock_unchecked_amount', 'waon_stock_priority_amount', 'waon_lock_priority_amount')
                ->first();
            $oure_goods_data = $oure_goods_dataarray[$waon_class_key];
            $oure_class_goo_id = array_keys($oure_goods_data);
            // 新增一条入库记录
            $oure_res = OutinRecord::addition(
                $user_info, //用户信息
                $oure_original_correlation_id, //原始单的关联id
                $oure_original_correlation_number, //原始单的关联单号
                1, //原始单的关联类型1.订单2.调拨单3.采购单4.销售单5.旧货回收6.退货入库7.售后
                $oure_client_type, //买家类型：1.会员零售2.客户单位3.速电派单4.第三方派单
                $oure_client_id, //选择的客户id,会员id/单位id
                $dis_data->dego_number, //原始单号，旧货回收单单号
                0, //入库仓库id
                $dis_data->dego_out_ware_id, //出库仓库id
                $goo_all_amount, //出库的商品总数量
                9, //类型 5.退换回收单 9发货单 11换货出库12换货入库13退货入库14退货出库
                2, //操作类型：1锁定库存2出库3入库4调货5发货
                $find_ware->waon_stock_fine_amount, //良品总库存
                $find_ware->waon_lock_fine_amount, //良品锁定数量
                $find_ware->waon_stock_priority_amount, //优先总库存
                $find_ware->waon_lock_priority_amount, //优先锁定数量
                $find_ware->waon_stock_unchecked_amount, //待检测总库存
                1, //出入库类型：1出库，2入库
                $waon_class_key, //仓库类别
                $oure_goods_id, //商品id
                $oure_goods_quantity, //商品数量
                $oure_goods_inventory, //出库类型1良品2优先
                $oure_class_goo_id //仓库类别下的商品id
            );
        }
        // 4. 工单生成的发货单 加移动仓库存
        if ($dis_data->dego_order_type == 2) {
            // 遍历仓库类型数据，处理移动仓库对应的出入库记录
            foreach ($wago_class_goods as $waon_class_key => $class_goods_data) {
                // 进销存，固定仓库，进销存库存数量减少
                // 查询仓库类别的进销存计算方式
                $goo_all_amount = 0;
                foreach ($class_goods_data as $goo_id_key => $value) {
                    // 出入库记录需要的的商品数组
                    $oure_goods_dataarray[$waon_class_key][$goo_id_key]['goo_quantity'] = $value['digo_goo_quantity']; //出入库商品数量
                    $oure_goods_dataarray[$waon_class_key][$goo_id_key]['goo_inventory'] = 1; //出入库商品类型，类型1良品2优先，页面没有用到这个，暂定1
                    $goo_all_amount += $value['digo_goo_quantity'];

                    // 出入库记录需要
                    $oure_goods_id[$goo_id_key] = $value['digo_goo_id']; //出入库商品id
                    $oure_goods_quantity[$goo_id_key] = $value['digo_goo_quantity']; //出入库商品数量
                    $oure_goods_inventory[$goo_id_key] = $value['digo_goo_inventory']; //出入库商品类型，类型1良品2优先，页面没有用到这个，暂定1
                }

                $find_ware = DB::table('warehouse_onhand')
                    ->where('waon_ware_id', '=', $dis_data->dego_out_ware_id)
                    ->where('waon_class', $waon_class_key)
                    ->select('waon_stock_fine_amount', 'waon_lock_fine_amount', 'waon_stock_unchecked_amount', 'waon_stock_priority_amount', 'waon_lock_priority_amount')
                    ->first();
                $oure_goods_data = $oure_goods_dataarray[$waon_class_key];
                $oure_class_goo_id = array_keys($oure_goods_data);

                $find_wor_data = DB::table('work_order')
                    ->where('wor_id', $dis_data->dego_wor_id)
                    ->select('wor_order_id', 'wor_order_number')
                    ->first();
                $dego_wor_id = $find_wor_data->wor_order_id;
                $dego_original_number = $find_wor_data->wor_order_number;
                // 新增一条入库记录
                $oure_res = OutinRecord::addition(
                    $user_info, //用户信息
                    $oure_original_correlation_id, //原始单的关联id
                    $oure_original_correlation_number, //原始单的关联单号
                    1, //原始单的关联类型1.订单2.调拨单3.采购单4.销售单5.旧货回收6.退货入库7.售后
                    $oure_client_type, //买家类型：1.会员零售2.客户单位3.速电派单4.第三方派单
                    $oure_client_id, //选择的客户id,会员id/单位id
                    $dis_data->dego_number, //原始单号，旧货回收单单号
                    $service_ware_id, //入库仓库id
                    0, //出库仓库id
                    $goo_all_amount, //出库的商品总数量
                    9, //类型 5.退换回收单 9发货单 11换货出库12换货入库13退货入库14退货出库
                    3, //操作类型：1锁定库存2出库3入库4调货5发货
                    $find_ware->waon_stock_fine_amount, //良品总库存
                    $find_ware->waon_lock_fine_amount, //良品锁定数量
                    $find_ware->waon_stock_priority_amount, //优先总库存
                    $find_ware->waon_lock_priority_amount, //优先锁定数量
                    $find_ware->waon_stock_unchecked_amount, //待检测总库存
                    2, //出入库类型：1出库，2入库
                    $waon_class_key, //仓库类别
                    $oure_goods_id, //商品id
                    $oure_goods_quantity, //商品数量
                    $oure_goods_inventory, //出库类型1良品2优先
                    $oure_class_goo_id //仓库类别下的商品id
                );
                dump($oure_res);
                unset($oure_res);
            }
        }
    }

    // 删除发货单的数据
    public function delFhuodan()
    {
        $cid = 1;
        $superior_shop_id = 1;

        $ord_id = ['FH1597807120448', 'FH1597815515352', 'FH1597815695852', 'FH1597815865435', 'FH1597822154785', 'FH1597829015582', 'FH1597887898883', 'FH1597888150532', 'FH1597888809936', 'FH1597890311523', 'FH1597890368726', 'FH1597890871593', 'FH1597895725364', 'FH1597908746487', 'FH1597908978651', 'FH1597909401181', 'FH1597911434261', 'FH1597921253628', 'FH1597922336151', 'FH1597922666677', 'FH1597923449186', 'FH1597971372512', 'FH1597971494594', 'FH1597978087149', 'FH1597979932104', 'FH1597979985975', 'FH1597981041969', 'FH1597993864525', 'FH1598158715973', 'FH1598163787140', 'FH1598165773472', 'FH1598167649928', 'FH1598232658117', 'FH1598240041320', 'FH1598244368220', 'FH1598249943227', 'FH1598252951427', 'FH1598253124790', 'FH1598254529569', 'FH1598254850610', 'FH1598258736852', 'FH1598259342225', 'FH1598259486940', 'FH1598259821487', 'FH1598315910104', 'FH1598317038809', 'FH1598317470904', 'FH1598322270469', 'FH1598325300715', 'FH1598326727611', 'FH1598327670630', 'FH1598329392335', 'FH1598331290247', 'FH1598331375339', 'FH1598333275634', 'FH1598334080880', 'FH1598341226151', 'FH1598341531189', 'FH1598341771649', 'FH1598345518927', 'FH1598402037568', 'FH1598402339181', 'FH1598404319162', 'FH1598404570943', 'FH1598405453230', 'FH1598408008705', 'FH1598409003857', 'FH1598439700750', 'FH1598440035129', 'FH1598492371306', 'FH1598496382205', 'FH1598499287257', 'FH1598507813939', 'FH1598508002704', 'FH1598508902645', 'FH1598513049128', 'FH1598513816368', 'FH1598515854522', 'FH1598515993270', 'FH1598580136748', 'FH1598580163991', 'FH1598584952871', 'FH1598602284956', 'FH1598833539483', 'FH1598836825744', 'FH1598843252432', 'FH1598860530963', 'FH1598928259348', 'FH1598947993117', 'FH1599006623341', 'FH1599016018777', 'FH1599030571791', 'FH1599097375711', 'FH1599116104333', 'FH1599180447957', 'FH1599187169246', 'FH1599212219561', 'FH1599213508553', 'FH1599266035378', 'FH1599272923238', 'FH1599282819510', 'FH1599283121207', 'FH1599287393202', 'FH1599288857681', 'FH1599296637143', 'FH1599300696563', 'FH1599355766270', 'FH1599362696498', 'FH1599376886734', 'FH1599450850926', 'FH1599451362383', 'FH1599459595807', 'FH1599464693425', 'FH1599469204192', 'FH1599469223959', 'FH1599530892626', 'FH1599534371148', 'FH1599536231426', 'FH1599551067601', 'FH1599615707509', 'FH1599617797523', 'FH1599710199858', 'FH1604983853497', 'FH1606382311833'];
        dump($ord_id);

        // 删除发货单商品表
        $wago_res = DB::table('dispatch_goods as b')
            ->leftjoin('dispatch_bill as a', 'a.dego_id', '=', 'b.digo_dego_id')
            ->where('dego_cid', $cid)
            // ->where('dego_superior_shop_id', $superior_shop_id)
            ->where('dego_shop_id', $superior_shop_id)
            ->whereIn('dego_number', $ord_id)
            ->delete();
        dump($wago_res);
        // 删除发货单表
        $wago_res = DB::table('dispatch_bill')
            ->where('dego_cid', $cid)
            // ->where('dego_superior_shop_id', $superior_shop_id)
            ->where('dego_shop_id', $superior_shop_id)
            ->whereIn('dego_number', $ord_id)
            ->delete();
        dump($wago_res);


        die;
    }

    // 调整调拨单数据[新增入库]
    public function addDiaobo2(Request $request)
    {
        ignore_user_abort();
        set_time_limit(0);

        // 获取当前操作账号信息
        try {
            $api_token = Crypt::decrypt($request['api_token']);
        } catch (\Exception $e) {
            return response()->json(["code"=>300, 'msg'=>'error', 'data'=>'非法api_token']);
        }

        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($api_token);

        // 查询信息
        $find_tror = DB::table('transferring_order')
            ->where('tror_number', 'DB341202143730775584')
            // ->where('tror_number', 'DB711202163915453748')
            // ->where('tror_number', 'DB741202164725460268')
            // ->where('tror_number', 'DB161209195513827822')
            // ->where('tror_number', 'DB361210105322466084')
            // ->where('tror_number', 'DB801212121615670615')
            // ->where('tror_number', 'DB171213170509588082')
            // ->where('tror_number', 'DB441213222722157831')
            // ->where('tror_number', 'DB301216101512730143')
            // ->where('tror_number', 'DB571216102854686640')
            ->select('tror_id', 'tror_state', 'tror_number', 'tror_out_waon_class', 'tror_in_waon_id', 'tror_in_ware_id', 'tror_goo_fine_amount', 'tror_goo_priority_amount', 'tror_type', 'tror_create_id', 'tror_create_time')
            ->first();

        // 根据调拨单id，查询调拨单商品信息
        $find_trog_data = DB::table('transferring_order_goods')
            ->where('trog_tror_id', $find_tror->tror_id)
            ->select('trog_wago_id', 'trog_goo_id', 'trog_waon_class', 'trog_stock_number', 'trog_priority_stock_number')
            ->get()->toArray();

        // 查询要入库的移动仓库商品表的商品数据
        $trog_goo_id = array_column($find_trog_data, 'trog_goo_id'); //调货单要调货的商品id
        $find_wago_data = DB::table('warehouse_goods')
            ->where('wago_ware_id', $find_tror->tror_in_ware_id)
            ->where('wago_class', $find_tror->tror_out_waon_class)
            ->whereIn('wago_goo_id', $trog_goo_id)
            ->select('wago_id', 'wago_ware_id', 'wago_class', 'wago_goo_id', 'wago_stock_number', 'wago_priority_stock_number')
            ->get()->toArray();

        $waon_class_fine_quantity = 0; //仓库类别对应良品库存总数量
        $waon_class_priority_quantity = 0; //仓库类别对应优先库存总数量
        $goo_key = 0;
        $goo_amount = 0; //入库商品总数量
        $wago_goo_id_data = array_column($find_wago_data, null, 'wago_goo_id');
        foreach ($find_trog_data as $key => $value) {
            // 判断移动仓库内是否有入库商品id，有商品id就更改库存数量
            if (isset($wago_goo_id_data[$value->trog_goo_id])) {
                // 良品库存
                if ($value->trog_stock_number > 0) {
                    // 出入库记录用到的数组
                    $goo_id[$goo_key] = $value->trog_goo_id; //商品id
                    $goo_quantity[$goo_key] = $value->trog_stock_number; //商品数量
                    $goo_price[$goo_key] = $value->trog_stock_number; //价格
                    $goo_inventory[$goo_key] = 1; //出库类型1良品2优先

                    $goo_key++;

                    $waon_class_fine_quantity += $value->trog_stock_number; //仓库类别对应良品库存总数量
                }

                // 优先
                if ($value->trog_priority_stock_number > 0) {
                    // 出入库记录用到的数组
                    $goo_id[$goo_key] = $value->trog_goo_id; //商品id
                    $goo_quantity[$goo_key] = $value->trog_priority_stock_number; //商品数量
                    $goo_price[$goo_key] = $value->trog_stock_number; //价格
                    $goo_inventory[$goo_key] = 2; //出库类型1良品2优先

                    $goo_key++;

                    $waon_class_priority_quantity += $value->trog_priority_stock_number; //仓库类别对应优先库存总数量
                }
                // 没有入库商品id，就在移动仓库中新增商品数据
            } else {
                // 良品库存
                if ($value->trog_stock_number > 0) {
                    // 出入库记录用到的数组
                    $goo_id[$goo_key] = $value->trog_goo_id; //商品id
                    $goo_quantity[$goo_key] = $value->trog_stock_number; //商品数量
                    $goo_price[$goo_key] = $value->trog_stock_number; //价格
                    $goo_inventory[$goo_key] = 1; //出库类型1良品2优先

                    $goo_key++;

                    $waon_class_fine_quantity += $value->trog_stock_number; //仓库类别对应良品库存总数量
                }

                // 优先
                if ($value->trog_priority_stock_number > 0) {
                    // 出入库记录用到的数组
                    $goo_id[$goo_key] = $value->trog_goo_id; //商品id
                    $goo_quantity[$goo_key] = $value->trog_priority_stock_number; //商品数量
                    $goo_price[$goo_key] = $value->trog_stock_number; //价格
                    $goo_inventory[$goo_key] = 2; //出库类型1良品2优先

                    $goo_key++;

                    $waon_class_priority_quantity += $value->trog_priority_stock_number; //仓库类别对应优先库存总数量
                }
            }
            $goo_amount = $goo_amount + $value->trog_stock_number;
            $goo_amount = $goo_amount + $value->trog_priority_stock_number;
        }

        // 查询库存数量
        $amount = DB::table('warehouse_onhand')
            ->where('waon_id', $find_tror->tror_in_waon_id)
            ->select('waon_all_amount', 'waon_stock_fine_amount', 'waon_lock_fine_amount', 'waon_stock_priority_amount', 'waon_lock_priority_amount', 'waon_stock_unchecked_amount')
            ->first();
        // 3.生成出库记录
        $oure_res = $this->addition(
            $user_info, //用户信息
            $find_tror->tror_create_id, // 操作人
            $find_tror->tror_id, //原始单的关联id
            $find_tror->tror_number, //原始单的关联单号
            2, //原始单的关联类型1.订单2.调拨单3.采购单4.销售单5.旧货回收6.退货入库7.售后
            0, //买家类型：1.会员零售2.客户单位3.速电派单4.第三方派单
            0, //选择的客户id,会员id/单位id
            $find_tror->tror_number, //调拨单号
            $find_tror->tror_in_ware_id, //入库仓库id
            0, //出库仓库id
            $waon_class_fine_quantity, //入库商品总量
            1, //类型1.入库单 2.出库单 3.调货单 4.旧货回收单 5.退换回收单 6.订单出库 7.部分入库 8.部分出库 9.发货单
            3, //操作类型：1锁定库存2出库3入库4调货5发货
            $amount->waon_stock_fine_amount, //良品总库存
            $amount->waon_lock_fine_amount, //良品锁定数量
            $amount->waon_stock_priority_amount, //优先总库存
            $amount->waon_lock_priority_amount, //优先锁定数量
            $amount->waon_stock_unchecked_amount, //待检测总库存
            $find_tror->tror_create_time, //时间
            2, //出入库类型：1出库，2入库
            $find_tror->tror_out_waon_class, //仓库类别
            $goo_id, //商品id
            $goo_quantity, //商品数量
            $goo_inventory //出库类型1良品2优先
        );
        dump($oure_res);
        unset($oure_res);
    }

    // 调整调拨单数据[新增出库]
    public function addDiaobo(Request $request)
    {
        ignore_user_abort();
        set_time_limit(0);

        // 获取当前操作账号信息
        try {
            $api_token = Crypt::decrypt($request['api_token']);
        } catch (\Exception $e) {
            return response()->json(["code"=>300, 'msg'=>'error', 'data'=>'非法api_token']);
        }

        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($api_token);

        // 查询信息
        $find_tror = DB::table('transferring_order')
            ->where('tror_number', 'DB341202143730775584')
            // ->where('tror_number', 'DB711202163915453748')
            // ->where('tror_number', 'DB741202164725460268')
            // ->where('tror_number', 'DB161209195513827822')
            // ->where('tror_number', 'DB801212121615670615')
            // ->where('tror_number', 'DB171213170509588082')
            // ->where('tror_number', 'DB441213222722157831')
            // ->where('tror_number', 'DB301216101512730143')
            // ->where('tror_number', 'DB571216102854686640')
            ->select('tror_id', 'tror_state', 'tror_number', 'tror_out_waon_id', 'tror_out_ware_id', 'tror_goo_fine_amount', 'tror_goo_priority_amount', 'tror_out_waon_class', 'tror_create_id', 'tror_create_time')
            ->first();

        // 根据调拨单id，查询调拨单商品信息
        $trog_id = DB::table('transferring_order_goods')
            ->where('trog_tror_id', $find_tror->tror_id)
            ->select('trog_wago_id', 'trog_goo_id', 'trog_waon_class', 'trog_stock_number', 'trog_priority_stock_number')
            ->get();

        $waon_class_fine_quantity = 0; //仓库类别对应良品库存总数量
        $waon_class_priority_quantity = 0; //仓库类别对应优先库存总数量
        $goo_key = 0;
        // 调拨单要出库的商品
        foreach ($trog_id as $key => $value) {
            // 良品
            if ($value->trog_stock_number > 0) {
                $goo_id[$goo_key] = $value->trog_goo_id; //商品id
                $goo_quantity[$goo_key] = $value->trog_stock_number; //商品数量
                $goo_price[$goo_key] = $value->trog_stock_number; //价格
                $goo_inventory[$goo_key] = 1; //出库类型1良品2优先

                $goo_key++;

                $waon_class_fine_quantity += $value->trog_stock_number; //仓库类别对应良品库存总数量
            }

            // 优先
            if ($value->trog_priority_stock_number > 0) {
                $goo_id[$goo_key] = $value->trog_goo_id; //商品id
                $goo_quantity[$goo_key] = $value->trog_priority_stock_number; //商品数量
                $goo_price[$goo_key] = $value->trog_priority_stock_number; //价格
                $goo_inventory[$goo_key] = 2; //出库类型1良品2优先

                $goo_key++;

                $waon_class_priority_quantity += $value->trog_priority_stock_number; //仓库类别对应优先库存总数量
            }
        }

        // 查询调出仓库类别的id
        $tror_out_waon_id = DB::table('transferring_order')
            ->where('tror_id', $find_tror->tror_id)
            ->value('tror_out_waon_id');

        // 查询库存数量
        $amount = DB::table('warehouse_onhand')
            ->where('waon_id', $tror_out_waon_id)
            ->select('waon_all_amount', 'waon_stock_fine_amount', 'waon_lock_fine_amount', 'waon_stock_priority_amount', 'waon_lock_priority_amount', 'waon_stock_unchecked_amount')
            ->first();
        // 3.生成出库记录
        $oure_res = $this->addition(
            $user_info, //用户信息
            $find_tror->tror_create_id, // 操作人
            $find_tror->tror_id, //原始单的关联id
            $find_tror->tror_number, //原始单的关联单号
            2, //原始单的关联类型1.订单2.调拨单3.采购单4.销售单5.旧货回收6.退货入库7.售后
            0, //买家类型：1.会员零售2.客户单位3.速电派单4.第三方派单
            0, //选择的客户id,会员id/单位id
            $find_tror->tror_number, //调拨单号
            0, //入库仓库id
            $find_tror->tror_out_ware_id, //出库仓库id
            $waon_class_fine_quantity, //出库商品总量
            2, //类型1.入库单 2.出库单 3.调货单 4.旧货回收单 5.退换回收单 6.订单出库 7.部分入库 8.部分出库 9.发货单
            2, //操作类型：1锁定库存2出库3入库4调货5发货
            $amount->waon_stock_fine_amount, //良品总库存
            $amount->waon_lock_fine_amount, //良品锁定数量
            $amount->waon_stock_priority_amount, //优先总库存
            $amount->waon_lock_priority_amount, //优先锁定数量
            $amount->waon_stock_unchecked_amount, //待检测总库存
            $find_tror->tror_create_time, //时间
            1, //出入库类型：1出库，2入库
            $find_tror->tror_out_waon_class, //仓库类别
            $goo_id, //商品id
            $goo_quantity, //商品数量
            $goo_inventory //出库类型1良品2优先
        );
        dump($oure_res);
        unset($oure_res);
    }

    /**
     * [addition 添加出入库记录]
     * @param  [type] $user_info                        [用户信息]
     * @param  [type] $adm_id                           [操作人id]
     * @param  [type] $oure_original_correlation_id     [原始单的关联id]
     * @param  [type] $oure_original_correlation_number [原始单的关联单号]
     * @param  [type] $oure_original_correlation_type   [原始单的关联类型1.订单2.调拨单3.采购单4.销售单5.旧货回收6.退货入库7.售后]
     * @param  [type] $oure_client_type                 [买家类型：1.会员零售2.客户单位3.速电派单4.第三方派单]
     * @param  [type] $oure_client_id                   [选择的客户id,会员id/单位id]
     * @param  [type] $oure_original_number             [原始单号]
     * @param  [type] $oure_in_ware_id                  [入库仓库id]
     * @param  [type] $oure_out_ware_id                 [出库仓库id]
     * @param  [type] $oure_waon_class                  [仓库类别]
     * @param  [type] $oure_count                       [出库的商品总量]
     * @param  [type] $oure_type                        [类型1.入库单 2.出库单 3.调货单 4.旧货回收单 5.退换回收单 6.订单出库 7.部分入库 8.部分出库 9.发货单]
     * @param  [type] $goods_data                       [数组，商品数据，['商品id'=>['商品出库数量','出库类型']]]
     * @param  [type] $oure_operation_type              [操作类型：1锁定库存2出库3入库4调货5发货]
     * @param  [type] $oure_all_stock                   [良品总库存]
     * @param  [type] $oure_lock_quantity               [良品锁定数量]
     * @param  [type] $oure_priority_all_stock          [优先总库存]
     * @param  [type] $oure_priority_lock_quantity      [优先锁定数量]
     * @param  [type] $oure_unchecked_all_stock         [待检测总库存]
     * @param  [type] $times                            [创建时间]
     * @param  [type] $oure_out_in_type                 [出入库类型：1出库，2入库]
     * @return [type]                                   [description]
     */
    public static function addition(
        $user_info,
        $adm_id,
        $oure_original_correlation_id,
        $oure_original_correlation_number,
        $oure_original_correlation_type,
        $oure_client_type,
        $oure_client_id,
        $oure_original_number,
        $oure_in_ware_id,
        $oure_out_ware_id,
        $oure_count,
        $oure_type,
        $oure_operation_type,
        $oure_all_stock,
        $oure_lock_quantity,
        $oure_priority_all_stock,
        $oure_priority_lock_quantity,
        $oure_unchecked_all_stock,
        $times,
        $oure_out_in_type,
        $oure_waon_class,
        $goo_id,
        $goo_quantity,
        $goo_inventory,
        $oure_class_goo_id = []
    ) {
        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;

        // 生成出入库记录
        $number = time() . rand(10000, 99999); //共15位
        // 出入库记录表新增数据
        $record['oure_cid'] = $user_info->adm_cid; //公司id
        $record['oure_shop_id'] = $user_info->adm_shop_id; //门店id
        $record['oure_superior_shop_id'] = $shop_id; //门店id
        $record['oure_adm_id'] = $adm_id; //操作人
        $record['oure_number'] = $number; //单号
        $record['oure_original_correlation_id'] = $oure_original_correlation_id; //原始单的关联id
        $record['oure_original_correlation_number'] = $oure_original_correlation_number; //原始单的关联单号
        $record['oure_original_correlation_type'] = $oure_original_correlation_type; //原始单的关联类型1.订单2.调拨单3.采购单4.销售单5.旧货回收6.退货入库7.售后
        $record['oure_client_type'] = $oure_client_type; //买家类型：1.会员零售2.客户单位3.速电派单4.第三方派单
        $record['oure_client_id'] = $oure_client_id; //选择的客户id,会员id/单位id
        $record['oure_original_number'] = $oure_original_number; //原始单号
        $record['oure_in_ware_id'] = $oure_in_ware_id; //入库仓库id
        $record['oure_out_ware_id'] = $oure_out_ware_id; //出库仓库id
        $record['oure_count'] = $oure_count; //出库的商品总量
        $record['oure_type'] = $oure_type; //类型1.入库单 2.出库单 3.调货单 4.旧货回收单 5.退换回收单 6.订单出库 7.部分入库 8.部分出库
        $record['oure_operation_type'] = $oure_operation_type; //操作类型：1锁定库存2出库3入库4调货5发货
        $record['oure_all_stock'] = $oure_all_stock; //良品总库存
        $record['oure_lock_quantity'] = $oure_lock_quantity; //良品锁定数量
        $record['oure_priority_all_stock'] = $oure_priority_all_stock; //优先总库存
        $record['oure_priority_lock_quantity'] = $oure_priority_lock_quantity; //优先锁定数量
        $record['oure_unchecked_all_stock'] = $oure_unchecked_all_stock; //待检测总库存
        $record['oure_create_time'] = $times;
        $record['oure_out_in_type'] = $oure_out_in_type; //出入库类型：1出库，2入库
        $record['oure_waon_class'] = $oure_waon_class; //仓库类别
        $record_add = DB::table('outin_record')->insertGetId($record);

        $n = 0;
        if ($oure_waon_class == '2') {
            $oure_waon_class = '1';
        }
        foreach ($goo_id as $key => $value) {
            if (!empty($oure_class_goo_id) && !in_array($value, $oure_class_goo_id)) {
                continue;
            }
            //入库id-》高献昌
            if ($oure_out_in_type == '2') {
                $oure_ware_id = $oure_in_ware_id;
            //出库
            } else {
                $oure_ware_id = $oure_out_ware_id;
            }
            //当前成本价
            $datetime = date('Y-m-d H:i:s');
            $newprice = DB::table('enters_sells_saves')
                ->where('ense_goo_id', $value)
                ->where('ense_goo_warehouse', $oure_ware_id)
                ->where('ense_goo_waretype', $oure_waon_class)
                ->where(function ($query) use ($datetime) {
                    $query->where('ense_time', '<', $datetime);
                })
                ->orderBy('ense_id', 'desc')
                ->select('ense_end_price', 'ense_end_amount', 'ense_end_inventory')
                ->first();
            if ($newprice) {
                $new_nums = $newprice->ense_end_inventory;
                $ense_end_price = $newprice->ense_end_price;
                //当前总金额
                $ense_new_amount = $newprice->ense_end_amount;
            } else {
                $new_nums = 0;
                $ense_end_price = '0';
                $ense_new_amount = '0';
            }
            //商品信息
            $goods = DB::table('goods')
                ->where('goo_id', $value)
                ->select('goo_name', 'goo_goods_encode', 'goo_ampere_hour', 'goo_attribute', 'goo_recycle_price')
                ->first();
            if ($goods->goo_attribute == '') {
                $unit = "";
            } else {
                $units = json_decode($goods->goo_attribute, true);
                foreach ($units as $k => $v) {
                    if ($v['key'] == '单位') {
                        $unit = $v['value'];
                    } else {
                        $unit = '';
                    }
                }
            }
            $dh = substr($oure_original_correlation_number, 0, 2);
            if ($oure_type == '1' || $oure_type == '7') {
                //获取入库价
                if ($dh == 'CG') {
                    $procurement_goodsres = DB::table('storage_goods')
                        ->where('relation_number', $oure_original_correlation_number)
                        ->where('goods_id', $value)
                        ->select('univalence')
                        ->first();
                    //入库价
                    $goods_price = $procurement_goodsres->univalence;
                } elseif ($dh == 'DB') {
                    $transferring_orderres = DB::table('transferring_order')
                        ->where('tror_number', $oure_original_correlation_number)
                        ->select('tror_id', 'tror_out_ware_id')
                        ->first();
                    $transferring_order_detailsres = DB::table('transferring_order_details')
                        ->where('trod_tror_id', $transferring_orderres->tror_id)
                        ->select('trod_export_time')
                        ->first();
                    $enters_sells_savesres = DB::table('enters_sells_saves')
                        ->where('ense_goo_id', $value)
                        ->where('ense_goo_warehouse', $transferring_orderres->tror_out_ware_id)
                        ->where(function ($query) use ($transferring_order_detailsres) {
                            $query->where('ense_time', '<', $transferring_order_detailsres->trod_export_time);
                        })
                        ->orderBy('ense_id', 'desc')
                        ->select('ense_end_price')
                        ->first();
                    //入库价
                    if ($enters_sells_savesres) {
                        $goods_price = $enters_sells_savesres->ense_end_price;
                    } else {
                        $goods_price = '0';
                    }
                }

                //期末总价
                $ense_end_amount = $ense_new_amount + $goods_price * $goo_quantity[$key];
                //期末平均价
                if ($new_nums + $goo_quantity[$key] == '0') {
                    $price = 0;
                } else {
                    $price = sprintf("%.4f", $ense_end_amount / ($new_nums + $goo_quantity[$key]));
                }
                //添加信息
                $enters_sellsarray['ense_goo_id'] = $value; //商品id
                $enters_sellsarray['ense_goo_name'] = $goods->goo_name; //商品名称
                $enters_sellsarray['ense_goo_number'] = $goods->goo_goods_encode; //商品编码
                $enters_sellsarray['ense_goo_unit'] = $unit; //商品单位
                $enters_sellsarray['ense_goo_specifications'] = $goods->goo_ampere_hour . "AH"; //商品规格
                $enters_sellsarray['ense_goo_waretype'] = $oure_waon_class; //仓库类别
                $enters_sellsarray['ense_goo_warehouse'] = $oure_ware_id; //所在仓库
                $enters_sellsarray['ense_new_inventory'] = $new_nums; //当前库存
                $enters_sellsarray['ense_new_price'] = $ense_end_price; //当前成本价
                $enters_sellsarray['ense_new_amount'] = $ense_new_amount; //当前总金额
                $enters_sellsarray['ense_end_inventory'] = $new_nums + $goo_quantity[$key]; //期末库存
                $enters_sellsarray['ense_end_price'] = $price; //期末成本价
                $enters_sellsarray['ense_end_amount'] = $ense_end_amount; //期末总金额
                $enters_sellsarray['ense_in_num'] = $goo_quantity[$key]; //入库数量
                $enters_sellsarray['ense_in_price'] = $goods_price; //入库单价
                $enters_sellsarray['ense_in_amount'] = $goo_quantity[$key] * $goods_price; //入库总金额
                $enters_sellsarray['ense_order_number'] = $oure_original_correlation_number; //
                $enters_sellsarray['ense_out_in'] = $oure_out_in_type; //出入库类型：1出库，2入库
                $enters_sellsarray['ense_type'] = $oure_type; //同出入库类型
                $enters_sellsarray['ense_shop_id'] = $user_info->adm_shop_id;
                $enters_saves = DB::table('enters_sells_saves')->insertGetId($enters_sellsarray);
            //旧货回收
            } elseif ($oure_type == '4') {
                //获取回收金额
                $shop_setres = DB::table('shop_set')
                    ->where('shse_shop_id', $user_info->adm_shop_id)
                    ->select('shse_recycle_type', 'shse_ampere_hour_price')
                    ->first();
                if ($shop_setres->shse_recycle_type == '1') {
                    $goods_price = $shop_setres->shse_ampere_hour_price * $goods->goo_ampere_hour / 100;
                } else {
                    $goods_price = $goods->goo_recycle_price / 100;
                }
                //同步工单商品表
                $workgoodprice['wogo_goo_price'] = $goods_price * 100;

                $workid = DB::table('work_order')
                    ->where('wor_order_number', $oure_original_correlation_number)
                    ->select('wor_id')
                    ->orderBy('wor_id', 'desc')
                    ->first();
                $workgood = DB::table('work_good')
                    ->where('wogo_wor_id', $workid->wor_id)
                    ->where('wogo_goo_id', $value)
                    ->update($workgoodprice);
                //期末总价
                $ense_end_amount = $ense_new_amount + $goods_price * $goo_quantity[$key];
                if ($new_nums + $goo_quantity[$key] == '0') {
                    $price = 0;
                } else {
                    $price = sprintf("%.4f", $ense_end_amount / ($new_nums + $goo_quantity[$key]));
                }
                //添加信息
                $enters_sellsarray['ense_goo_id'] = $value; //商品id
                $enters_sellsarray['ense_goo_name'] = $goods->goo_name; //商品名称
                $enters_sellsarray['ense_goo_number'] = $goods->goo_goods_encode; //商品编码
                $enters_sellsarray['ense_goo_unit'] = $unit; //商品单位
                $enters_sellsarray['ense_goo_specifications'] = $goods->goo_ampere_hour . "AH"; //商品规格
                $enters_sellsarray['ense_goo_waretype'] = $oure_waon_class; //仓库类别
                $enters_sellsarray['ense_goo_warehouse'] = $oure_ware_id; //所在仓库
                $enters_sellsarray['ense_new_inventory'] = $new_nums; //当前库存
                $enters_sellsarray['ense_new_price'] = $ense_end_price; //当前成本价
                $enters_sellsarray['ense_new_amount'] = $ense_new_amount; //当前总金额
                $enters_sellsarray['ense_end_inventory'] = $new_nums + $goo_quantity[$key]; //期末库存
                $enters_sellsarray['ense_end_price'] = $price; //期末成本价
                $enters_sellsarray['ense_end_amount'] = $ense_end_amount; //期末总金额
                $enters_sellsarray['ense_in_num'] = $goo_quantity[$key]; //入库数量
                $enters_sellsarray['ense_in_price'] = $goods_price; //入库单价
                $enters_sellsarray['ense_in_amount'] = $goo_quantity[$key] * $goods_price; //入库总金额
                $enters_sellsarray['ense_order_number'] = $oure_original_correlation_number; //原始单号
                $enters_sellsarray['ense_out_in'] = $oure_out_in_type; //出入库类型：1出库，2入库
                $enters_sellsarray['ense_type'] = $oure_type; //同出入库类型
                $enters_sellsarray['ense_shop_id'] = $user_info->adm_shop_id;
                $enters_saves = DB::table('enters_sells_saves')->insertGetId($enters_sellsarray);
            } elseif ($oure_type == '5') {
                $order_wareid = DB::table('order')
                    ->where('ord_order_number', $oure_original_correlation_number)
                    ->select('ord_ware_id')
                    ->first();
                if ($order_wareid->ord_ware_id == '0') {
                    $order_wareid = DB::table('recede_recycle')
                        ->where('rec_number', $oure_original_number)
                        ->select('rec_ware_id')
                        ->first();
                    $ord_ware_id = $order_wareid->rec_ware_id;
                } else {
                    $ord_ware_id = $order_wareid->ord_ware_id;
                }
                $enters_sells_savesres = DB::table('enters_sells_saves')
                    ->where('ense_out_in', '1')
                    ->where('ense_type', '9')
                    ->where('ense_goo_id', $value)
                    ->where('ense_goo_warehouse', $ord_ware_id)
                    ->where('ense_order_number', $oure_original_correlation_number)
                    ->where(function ($query) use ($datetime) {
                        $query->where('ense_time', '<=', $datetime);
                    })
                    ->orderBy('ense_id', 'desc')
                    ->select('ense_end_price')
                    ->first();
                //入库金额
                $goods_price = $enters_sells_savesres->ense_end_price;
                //期末总价
                $ense_end_amount = $ense_new_amount + $goods_price * $goo_quantity[$key];
                $price = $ense_end_price;
                //添加信息
                $enters_sellsarray['ense_goo_id'] = $value; //商品id
                $enters_sellsarray['ense_goo_name'] = $goods->goo_name; //商品名称
                $enters_sellsarray['ense_goo_number'] = $goods->goo_goods_encode; //商品编码
                $enters_sellsarray['ense_goo_unit'] = $unit; //商品单位
                $enters_sellsarray['ense_goo_specifications'] = $goods->goo_ampere_hour . "AH"; //商品规格
                $enters_sellsarray['ense_goo_waretype'] = $oure_waon_class; //仓库类别
                $enters_sellsarray['ense_goo_warehouse'] = $oure_ware_id; //所在仓库
                $enters_sellsarray['ense_new_inventory'] = $new_nums; //当前库存
                $enters_sellsarray['ense_new_price'] = $ense_end_price; //当前成本价
                $enters_sellsarray['ense_new_amount'] = $ense_new_amount; //当前总金额
                $enters_sellsarray['ense_end_inventory'] = $new_nums + $goo_quantity[$key]; //期末库存
                $enters_sellsarray['ense_end_price'] = $price; //期末成本价
                $enters_sellsarray['ense_end_amount'] = $ense_end_amount; //期末总金额
                $enters_sellsarray['ense_out_num'] = "-" . $goo_quantity[$key]; //入库数量
                $enters_sellsarray['ense_out_price'] = "-" . $goods_price; //入库单价
                $enters_sellsarray['ense_out_amount'] = "-" . $goo_quantity[$key] * $goods_price; //入库总金额
                $enters_sellsarray['ense_order_number'] = $oure_original_correlation_number; //原始单号
                $enters_sellsarray['ense_out_in'] = $oure_out_in_type; //出入库类型：1出库，2入库
                $enters_sellsarray['ense_type'] = $oure_type; //同出入库类型
                $enters_sellsarray['ense_shop_id'] = $user_info->adm_shop_id;
                $enters_saves = DB::table('enters_sells_saves')->insertGetId($enters_sellsarray);
            //退货单
            } elseif ($oure_type == '12' || $oure_type == '13') {
                $goods_price = $ense_end_price;
                $price = $ense_end_price;
                $ense_end_amount = $ense_new_amount + $goo_quantity[$key] * $goods_price;
                //添加信息
                $enters_sellsarray['ense_goo_id'] = $value; //商品id
                $enters_sellsarray['ense_goo_name'] = $goods->goo_name; //商品名称
                $enters_sellsarray['ense_goo_number'] = $goods->goo_goods_encode; //商品编码
                $enters_sellsarray['ense_goo_unit'] = $unit; //商品单位
                $enters_sellsarray['ense_goo_specifications'] = $goods->goo_ampere_hour . "AH"; //商品规格
                $enters_sellsarray['ense_goo_waretype'] = $oure_waon_class; //仓库类别
                $enters_sellsarray['ense_goo_warehouse'] = $oure_ware_id; //所在仓库
                $enters_sellsarray['ense_new_inventory'] = $new_nums; //当前库存
                $enters_sellsarray['ense_new_price'] = $ense_end_price; //当前成本价
                $enters_sellsarray['ense_new_amount'] = $ense_new_amount; //当前总金额
                $enters_sellsarray['ense_end_inventory'] = $new_nums + $goo_quantity[$key]; //期末库存
                $enters_sellsarray['ense_end_price'] = $price; //期末成本价
                $enters_sellsarray['ense_end_amount'] = $ense_end_amount; //期末总金额
                $enters_sellsarray['ense_out_num'] = "-" . $goo_quantity[$key]; //入库数量
                $enters_sellsarray['ense_out_price'] = "-" . $goods_price; //入库单价
                $enters_sellsarray['ense_out_amount'] = "-" . $goo_quantity[$key] * $goods_price; //入库总金额
                $enters_sellsarray['ense_order_number'] = $oure_original_correlation_number; //原始单号
                $enters_sellsarray['ense_out_in'] = $oure_out_in_type; //出入库类型：1出库，2入库
                $enters_sellsarray['ense_type'] = $oure_type; //同出入库类型
                $enters_sellsarray['ense_shop_id'] = $user_info->adm_shop_id;
                $enters_saves = DB::table('enters_sells_saves')->insertGetId($enters_sellsarray);
            } else {
                //采购退货单
                if ($oure_type == '2' && $dh == 'TH') {
                    $procurement_goodsres = DB::table('storage_goods')
                        ->where('relation_number', $oure_original_correlation_number)
                        ->where('goods_id', $value)
                        ->select('univalence')
                        ->first();
                    //入库价
                    $goods_price = $procurement_goodsres->univalence;
                    $ense_end_amount = $ense_new_amount - $goods_price * $goo_quantity[$key];
                    if ($new_nums - $goo_quantity[$key] == '0') {
                        $price = 0;
                    } else {
                        $price = sprintf("%.4f", $ense_end_amount / ($new_nums - $goo_quantity[$key]));
                    }

                    //添加信息
                    $enters_sellsarray['ense_goo_id'] = $value; //商品id
                    $enters_sellsarray['ense_goo_name'] = $goods->goo_name; //商品名称
                    $enters_sellsarray['ense_goo_number'] = $goods->goo_goods_encode; //商品编码
                    $enters_sellsarray['ense_goo_unit'] = $unit; //商品单位
                    $enters_sellsarray['ense_goo_specifications'] = $goods->goo_ampere_hour . "AH"; //商品规格
                    $enters_sellsarray['ense_goo_waretype'] = $oure_waon_class; //仓库类别
                    $enters_sellsarray['ense_goo_warehouse'] = $oure_ware_id; //所在仓库
                    $enters_sellsarray['ense_new_inventory'] = $new_nums; //当前库存
                    $enters_sellsarray['ense_new_price'] = $ense_end_price; //当前成本价
                    $enters_sellsarray['ense_new_amount'] = $ense_new_amount; //当前总金额
                    $enters_sellsarray['ense_end_inventory'] = $new_nums - $goo_quantity[$key]; //期末库存
                    $enters_sellsarray['ense_end_price'] = $price; //期末成本价
                    $enters_sellsarray['ense_end_amount'] = $ense_end_amount; //期末总金额
                    $enters_sellsarray['ense_in_num'] = "-" . $goo_quantity[$key]; //入库数量
                    $enters_sellsarray['ense_in_price'] = $goods_price; //入库单价
                    $enters_sellsarray['ense_in_amount'] = "-" . $goo_quantity[$key] * $goods_price; //入库总金额
                    $enters_sellsarray['ense_order_number'] = $oure_original_correlation_number; //原始单号
                    $enters_sellsarray['ense_out_in'] = $oure_out_in_type; //出入库类型：1出库，2入库
                    $enters_sellsarray['ense_type'] = $oure_type; //同出入库类型
                    $enters_sellsarray['ense_shop_id'] = $user_info->adm_shop_id;
                    $enters_saves = DB::table('enters_sells_saves')->insertGetId($enters_sellsarray);
                } else {
                    if ($oure_type == '9' && $oure_out_in_type == '2') {
                        $order_wareid = DB::table('order')
                            ->where('ord_order_number', $oure_original_correlation_number)
                            ->select('ord_ware_id')
                            ->first();
                        $enters_sells_savesres = DB::table('enters_sells_saves')
                            ->where('ense_goo_id', $value)
                            ->where('ense_goo_warehouse', $order_wareid->ord_ware_id)
                            ->where(function ($query) use ($datetime) {
                                $query->where('ense_time', '<=', $datetime);
                            })
                            ->orderBy('ense_id', 'desc')
                            ->select('ense_end_price')
                            ->first();
                        if ($enters_sells_savesres) {
                            $goods_price = $enters_sells_savesres->ense_end_price;
                        } else {
                            $goods_price = '0';
                        }
                        //期末总价
                        $ense_end_amount = $ense_new_amount + $goods_price * $goo_quantity[$key];
                        if ($new_nums + $goo_quantity[$key] == '0') {
                            $price = 0;
                        } else {
                            $price = sprintf("%.4f", $ense_end_amount / ($new_nums + $goo_quantity[$key]));
                        }
                        //添加信息
                        $enters_sellsarray['ense_goo_id'] = $value; //商品id
                        $enters_sellsarray['ense_goo_name'] = $goods->goo_name; //商品名称
                        $enters_sellsarray['ense_goo_number'] = $goods->goo_goods_encode; //商品编码
                        $enters_sellsarray['ense_goo_unit'] = $unit; //商品单位
                        $enters_sellsarray['ense_goo_specifications'] = $goods->goo_ampere_hour . "AH"; //商品规格
                        $enters_sellsarray['ense_goo_waretype'] = $oure_waon_class; //仓库类别
                        $enters_sellsarray['ense_goo_warehouse'] = $oure_ware_id; //所在仓库
                        $enters_sellsarray['ense_new_inventory'] = $new_nums; //当前库存
                        $enters_sellsarray['ense_new_price'] = $ense_end_price; //当前成本价
                        $enters_sellsarray['ense_new_amount'] = $ense_new_amount; //当前总金额
                        $enters_sellsarray['ense_end_inventory'] = $new_nums + $goo_quantity[$key]; //期末库存
                        $enters_sellsarray['ense_end_price'] = $price; //期末成本价
                        $enters_sellsarray['ense_end_amount'] = $ense_end_amount; //期末总金额
                        $enters_sellsarray['ense_in_num'] = $goo_quantity[$key]; //入库数量
                        $enters_sellsarray['ense_in_price'] = $goods_price; //入库单价
                        $enters_sellsarray['ense_in_amount'] = $goo_quantity[$key] * $goods_price; //入库总金额
                        $enters_sellsarray['ense_order_number'] = $oure_original_correlation_number; //原始单号
                        $enters_sellsarray['ense_out_in'] = $oure_out_in_type; //出入库类型：1出库，2入库
                        $enters_sellsarray['ense_type'] = $oure_type; //同出入库类型
                        $enters_sellsarray['ense_shop_id'] = $user_info->adm_shop_id;
                        $enters_saves = DB::table('enters_sells_saves')->insertGetId($enters_sellsarray);
                    } else {
                        //添加信息
                        $enters_sellsarray['ense_goo_id'] = $value; //商品id
                        $enters_sellsarray['ense_goo_name'] = $goods->goo_name; //商品名称
                        $enters_sellsarray['ense_goo_number'] = $goods->goo_goods_encode; //商品编码
                        $enters_sellsarray['ense_goo_unit'] = $unit; //商品单位
                        $enters_sellsarray['ense_goo_specifications'] = $goods->goo_ampere_hour . "AH"; //商品规格
                        $enters_sellsarray['ense_goo_waretype'] = $oure_waon_class; //仓库类别
                        $enters_sellsarray['ense_goo_warehouse'] = $oure_ware_id; //所在仓库
                        $enters_sellsarray['ense_new_inventory'] = $new_nums; //当前库存
                        $enters_sellsarray['ense_new_price'] = $ense_end_price; //当前成本价
                        $enters_sellsarray['ense_new_amount'] = $ense_new_amount; //当前总金额
                        $enters_sellsarray['ense_end_inventory'] = $new_nums - $goo_quantity[$key]; //期末库存
                        $enters_sellsarray['ense_end_price'] = $ense_end_price; //期末成本价
                        $enters_sellsarray['ense_end_amount'] = $ense_new_amount - sprintf("%.4f", $goo_quantity[$key] * $ense_end_price); //期末总金额
                        $enters_sellsarray['ense_out_num'] = $goo_quantity[$key]; //出库数量
                        $enters_sellsarray['ense_out_price'] = $ense_end_price; //出库单价
                        $enters_sellsarray['ense_out_amount'] = sprintf("%.4f", $goo_quantity[$key] * $ense_end_price); //出库总金额
                        $enters_sellsarray['ense_order_number'] = $oure_original_correlation_number; //原始单号
                        $enters_sellsarray['ense_out_in'] = $oure_out_in_type; //出入库类型：1出库，2入库
                        $enters_sellsarray['ense_type'] = $oure_type; //同出入库类型
                        $enters_sellsarray['ense_shop_id'] = $user_info->adm_shop_id;
                        $enters_saves = DB::table('enters_sells_saves')->insertGetId($enters_sellsarray);
                    }
                }
            }
            $oude_data[$n]['oude_oure_id'] = $record_add;
            $oude_data[$n]['oude_update_time'] = date('Y-m-d H:i:s');
            $oude_data[$n]['oude_goo_id'] = $value;
            $oude_data[$n]['oude_goo_oldnum'] = $enters_sellsarray['ense_new_inventory']; //期初数量
            $oude_data[$n]['oude_goo_number'] = $goo_quantity[$key]; //实际出入库数量
            $oude_data[$n]['oude_goo_newnum'] = $enters_sellsarray['ense_end_inventory']; //结存数量
            $oude_data[$n]['oude_type'] = $goo_inventory[$key]; //类型1良品2优先
            $n++;
        }
        $record_details_add = DB::table('outin_details')->insert($oude_data);
        if ($record_details_add && $record_add) {
            return true;
        } else {
            return false;
        }
    }

    // 查询工单为发货单,是否有发货记录
    public function gongdan()
    {
        ignore_user_abort();
        set_time_limit(0);

        $cid = 1;
        $shop_id = 1;
        $find_ord_data = DB::table('work_order as wor')
            ->leftjoin('work_client as wocl', 'wocl.wocl_wor_id', '=', 'wor.wor_id')
            ->where('wor_cid', $cid)
            ->where('wor_superior_shop_id', $shop_id)
            ->where('wor_shop_id', $shop_id)
            ->where('wocl_wor_type', '!=', 4)
            ->whereIn('wor_state', [8, 10])
            // ->where('wor_service_type', 7)
            ->whereNotIn('wor_service_type', [4, 7])
            ->where('wor_delete', 1)
            ->where('wor_collection_bill', 1)
            ->whereIn('wor_ware_id', [9, 10, 11, 13, 14])
            ->select('wor_id', 'wor_number', 'wor_create_time', 'wor_service_type')
            ->get()->toArray();
        // dump($find_ord_data);
        foreach ($find_ord_data as $key => $value) {
            // 判断有没有商品
            // $wogo_data = DB::table('work_good')
            //     ->where('wogo_wor_id', $value->wor_id)
            //     ->get()->toArray();
            // if ($wogo_data) {
            $find_outin_data = DB::table('dispatch_bill')
                ->where('dego_cid', $cid)
                ->where('dego_superior_shop_id', $shop_id)
                ->where('dego_shop_id', $shop_id)
                ->where('dego_order_type', 2)
                ->where('dego_original_number', $value->wor_number)
                ->select('dego_id', 'dego_order_type', 'dego_original_number', 'dego_wor_id')
                ->first();
            // dump($find_outin_data);
            if ($value->wor_number != isset($find_outin_data->dego_original_number)) {
                dump($value->wor_number);
                // dump($value->wor_create_time);
            }
            // }
        }
        echo '9090';
    }

    // 查询订单为发货单,是否有发货记录
    public function dingdan()
    {
        ignore_user_abort();
        set_time_limit(0);

        $cid = 1;
        $shop_id = 1;
        $find_ord_data = DB::table('order')
            ->where('ord_cid', $cid)
            ->where('ord_superior_shop_id', $shop_id)
            ->where('ord_shop_id', $shop_id)
            ->where('ord_wor_state', 4)
            ->where('ord_service_type', 5)
            ->select('ord_id', 'ord_order_number')
            ->get()->toArray();
        // dump($find_ord_data);
        foreach ($find_ord_data as $key => $value) {
            $find_outin_data = DB::table('dispatch_bill')
                ->where('dego_cid', $cid)
                ->where('dego_superior_shop_id', $shop_id)
                ->where('dego_shop_id', $shop_id)
                ->where('dego_order_type', 1)
                ->where('dego_original_number', $value->ord_order_number)
                ->select('dego_id', 'dego_order_type', 'dego_original_number', 'dego_wor_id')
                ->first();
            // dump($find_outin_data);
            if ($value->ord_order_number != isset($find_outin_data->dego_original_number)) {
                dump($value->ord_order_number);
            }
        }
        echo '9090';
    }

    // 查询发货单数据
    public function fhd()
    {
        ignore_user_abort();
        set_time_limit(0);

        $cid = 1;
        $shop_id = 1;
        $find_dibi_data = DB::table('dispatch_bill')
            ->where('dego_cid', $cid)
            ->where('dego_superior_shop_id', $shop_id)
            ->where('dego_shop_id', $shop_id)
            ->where('dego_type', 2)
            ->select('dego_id', 'dego_number')
            ->get()->toArray();
        // dump($find_dibi_data);
        foreach ($find_dibi_data as $key => $value) {
            $find_outin_data = DB::table('outin_record')
                ->where('oure_cid', $cid)
                ->where('oure_superior_shop_id', $shop_id)
                ->where('oure_shop_id', $shop_id)
                ->where('oure_original_number', $value->dego_number)
                ->select('oure_id', 'oure_original_correlation_id', 'oure_original_correlation_number', 'oure_original_number')
                ->first();
            // dump($find_outin_data);
            if ($value->dego_number != isset($find_outin_data->oure_original_number)) {
                dump($value->dego_number);
            }
        }
        echo '9090';
    }

    // 查询旧货回收单数据
    public function jhhsd()
    {
        ignore_user_abort();
        set_time_limit(0);

        $cid = 1;
        $shop_id = 1;
        $find_junk_data = DB::table('junk_recycle')
            ->where('jur_cid', $cid)
            ->where('jur_superior_shop_id', $shop_id)
            ->where('jur_shop_id', $shop_id)
            ->where('jur_state', 2)
            ->select('jur_id', 'jur_number')
            ->get()->toArray();
        // dump($find_junk_data);
        foreach ($find_junk_data as $key => $value) {
            $find_outin_data = DB::table('outin_record')
                ->where('oure_cid', $cid)
                ->where('oure_superior_shop_id', $shop_id)
                ->where('oure_shop_id', $shop_id)
                ->where('oure_original_number', $value->jur_number)
                ->select('oure_id', 'oure_original_correlation_id', 'oure_original_correlation_number', 'oure_original_number')
                ->first();
            // dump($find_outin_data);
            if ($value->jur_number != isset($find_outin_data->oure_original_number)) {
                dump($value->jur_number);
            }
        }
        echo '9090';
    }

    // 查询退换入库单数据
    public function thrkd()
    {
        ignore_user_abort();
        set_time_limit(0);

        $cid = 1;
        $shop_id = 1;
        $find_rec_data = DB::table('recede_recycle')
            ->where('rec_cid', $cid)
            ->where('rec_superior_shop_id', $shop_id)
            ->where('rec_shop_id', $shop_id)
            ->where('rec_state', 2)
            ->select('rec_id', 'rec_number')
            ->get()->toArray();
        // dump($find_rec_data);
        foreach ($find_rec_data as $key => $value) {
            $find_outin_data = DB::table('outin_record')
                ->where('oure_cid', $cid)
                ->where('oure_superior_shop_id', $shop_id)
                ->where('oure_shop_id', $shop_id)
                ->where('oure_original_number', $value->rec_number)
                ->select('oure_id', 'oure_original_correlation_id', 'oure_original_correlation_number', 'oure_original_number')
                ->first();
            // dump($find_outin_data);
            if ($value->rec_number != isset($find_outin_data->oure_original_number)) {
                dump($value->rec_number);
            }
        }
        echo '9090';
    }

    // 查询调拨单数据
    public function diaobodan()
    {
        ignore_user_abort();
        set_time_limit(0);

        $cid = 1;
        $shop_id = 1;
        $find_tror_data = DB::table('transferring_order')
            ->where('tror_cid', $cid)
            ->where('tror_superior_shop_id', $shop_id)
            ->where('tror_shop_id', $shop_id)
            ->where('tror_state', 4)
            ->select('tror_id', 'tror_number')
            ->get()->toArray();
        // dump($find_tror_data);
        foreach ($find_tror_data as $key => $value) {
            $find_outin_data = DB::table('outin_record')
                ->where('oure_cid', $cid)
                ->where('oure_superior_shop_id', $shop_id)
                ->where('oure_shop_id', $shop_id)
                ->where('oure_original_number', $value->tror_number)
                ->where('oure_original_correlation_type', 2)
                ->select('oure_id', 'oure_original_correlation_id', 'oure_original_correlation_number')
                ->first();
            // dump($find_outin_data);
            if ($value->tror_number != isset($find_outin_data->oure_original_correlation_number)) {
                dump($value->tror_number);
            }
        }
        echo '9090';
    }

    // 调整流水货物仓的其他类别的数据
    public function changeGoods()
    {
        ignore_user_abort();
        set_time_limit(0);

        $cid = 1;
        $shop_id = 1;

        $oure_data['oure_waon_class'] = 3;
        $res = DB::table('outin_record')
            ->where('oure_cid', $cid)
            ->where('oure_superior_shop_id', $shop_id)
            ->where('oure_shop_id', $shop_id)
            // ->whereIn('oure_id', ['8866','8866','9018','9018','10292','10292','12530','12967','13273','13273','13508','13510','13520','14253','14720','14721','15219','16483','16546','16623','17012','18641','21088','21372','21372','21372','21372','23906','24061','24110','24240','24471','24765','25382','25837','25838','25841','26087','27294','27304','27699','27980','28013','28014','29669','29673','29965','29965','29965','30223','30484','30712','30889','31456','31586','34264','34264','34546','34686','35787','35787','35812','37239','37616','37747','39541','39543','40137','40430','40431','40432','40432','42029', '6076', '6405', '6887', '7791', '7945', '8403'])
            // ->whereIn('oure_id', ['6075','6406','6886','6886','7751','8822','8991','8991','10778','10778','12020','12024','18599','21367','21367','21367','21367','22718','25381','25385','27170','27178','30169','31258','31487','34238','34238','34592','39982'])
            // ->whereIn('oure_id', ['8715','8715','8721','8764','10828','10828','10830','10830','12564','15664','16479','22719','25233','25234','25759','25831','25840','26409','27979','28418','29373','29373','29373','30755','31919','32651','32653','32657','32861','34255','34549','35246','35333','35333','37133','39384','39385','42007'])
            // ->whereIn('oure_id', ['17427','36974','40400','40402','40402','40403'])
            // ->whereIn('oure_id', ['17536'])
            // ->whereIn('oure_id', ['34550','34554','37646'])//白文革 29
            // ->whereIn('oure_id', ['8765','8803','8949','35247','35266'])//黄行渊(0PY17) 30
            // ->whereIn('oure_id', ['13739','14500','14610','24111','24153'])//王木荣（闽D5SG76）33
            // ->whereIn('oure_id', ['12715','34326'])//吴文祥（闽DP1K79）34
            // ->whereIn('oure_id', ['24062','24097'])//周志鹏（闽D8RR07）35
            // ->whereIn('oure_id', ['6464','8961','18749'])//黄行顺（闽DP1M08）36
            // ->whereIn('oure_id', ['8823','8828','13897'])//杨阳（闽D2TP95）37
            ->whereIn('oure_id', ['9252', '14867', '21089', '21202', '28419', '28420']) //林土水（闽DN3K50）40
            ->update($oure_data);
        dump($res);
        unset($oure_data);
        unset($res);
    }

    // 查询采购单数据
    public function purchase2()
    {
        ignore_user_abort();
        set_time_limit(0);

        $cid = 1;
        $shop_id = 1;
        $find_pur_data = DB::table('purchase_order')
            ->where('company_id', $cid)
            ->where('cg_superior_shop_id', $shop_id)
            ->where('cg_shop_id', $shop_id)
            ->whereIn('cg_state', [8, 11, 12])
            ->select('cg_id', 'cg_number')
            ->get()->toArray();
        foreach ($find_pur_data as $key => $value) {
            $find_outin_data = DB::table('outin_record')
                ->where('oure_cid', $cid)
                ->where('oure_superior_shop_id', $shop_id)
                ->where('oure_shop_id', $shop_id)
                ->where('oure_original_correlation_id', $value->cg_id)
                ->where('oure_original_correlation_number', $value->cg_number)
                ->where('oure_original_correlation_type', 3)
                ->select('oure_id', 'oure_original_correlation_id', 'oure_original_correlation_number', 'oure_original_number')
                ->first();
            if ($value->cg_number != isset($find_outin_data->oure_original_correlation_number)) {
                dump($value->cg_number);
            }
        }
        // $find_outin_data = DB::table('outin_record')
        //     ->where('oure_cid', $cid)
        //     ->where('oure_superior_shop_id', $shop_id)
        //     ->where('oure_shop_id', $shop_id)
        //     ->where('oure_original_correlation_type', 3)
        //     ->select('oure_id', 'oure_original_correlation_id', 'oure_original_correlation_number')
        //     ->get()->toArray();
        // foreach ($find_outin_data as $key => $value) {
        //     $find_pur_data = DB::table('purchase_order')
        //         ->where('company_id', $cid)
        //         ->where('cg_superior_shop_id', $shop_id)
        //         ->where('cg_shop_id', $shop_id)
        //         ->where('cg_id', $value->oure_original_correlation_id)
        //         ->where('cg_number', $value->oure_original_correlation_number)
        //         ->select('cg_number')
        //         ->first();
        //     if (empty($find_pur_data)) {
        //         dump($value);
        //     }
        // }
        echo '9090';
    }

    // 根据订单,生成对应的工单,发货单,出入库记录D2020092017411200164
    public function order6()
    {
        ignore_user_abort();
        set_time_limit(0);

        $cid = 1;
        $shop_id = 1;
        // 查询订单表数据
        $find_order_data = DB::table('order as ord')
            ->leftjoin('order_client as orcl', 'orcl.orcl_ord_id', '=', 'ord.ord_id')
            ->where('ord_cid', $cid)
            ->where('ord_shop_id', $shop_id)
            ->where('ord_order_number', 'D2020092017411200164')
            ->first();
        // 生成工单
        $wor_data['wor_cid'] = $cid; //所属企业
        $wor_data['wor_superior_shop_id'] = $shop_id; //所属企业
        $wor_data['wor_shop_id'] = $shop_id; //所属企业
        $wor_data['wor_create_id'] = $find_order_data->ord_create_id; //派单人
        $wor_data['wor_number'] = 'G2020092017411200164'; //工单号
        $wor_data['wor_order_id'] = $find_order_data->ord_id; //订单id
        $wor_data['wor_order_number'] = $find_order_data->ord_order_number; //订单单号
        $wor_data['wor_service_shop_id'] = $find_order_data->ord_service_shop_id; //服务门店id
        $wor_data['wor_service_sepr_id'] = $find_order_data->ord_service_sepr_id; //服务项目id
        $wor_data['wor_service_adm_id'] = $find_order_data->ord_service_adm_id; //服务技师id
        $wor_data['wor_service_type'] = $find_order_data->ord_service_type; //订单类型：1服务单 2销售单 3换货单 4退货单 5发货单 6结清单 7救援单
        $wor_data['wor_service_state'] = 8; //服务状态：1待接单2已接单3预约4出发5抵达6完成待审核7完成已驳回8完成通过9终止10锁定11速电撤销回收12工单冲单
        $wor_data['wor_orla_id'] = $find_order_data->ord_orla_id; //订单标签id
        $wor_data['wor_ware_id'] = $find_order_data->ord_ware_id; //供货仓库id
        $wor_data['wor_state'] = 10; //1.新订单 2未派单 3待接单/已派单 4.未出发/已接单 5.预约/已预约 6.出发/已出发 7.抵达/抵达 8.待审核/完成待审核 9驳回/完成已驳回 10完成/完成已通过 11终止 12锁定13.速电撤销回收14工单冲单
        $wor_data['wor_pass'] = 2; //审核：1.待审核 2.合格 3.不合格 4系统锁定 5速电锁定6第三方锁定7速电待审核8等待加盟店审核9等待总店待审核10审核改单11等待速电审核
        $wor_data['wor_type'] = $find_order_data->ord_type; //订单类型：1门店零售2渠道单位3速电派单
        $wor_data['wor_appoint_time'] = ''; //预约时间
        $wor_data['wor_achieve_time'] = ''; //完成时间
        $wor_data['wor_recycle_number'] = 0; //工单计划总的旧货回收数量
        $wor_data['wor_actual_recycle_number'] = 0; //工单实际的总旧货回收数量
        $wor_data['wor_actual_price'] = $find_order_data->ord_actual_price; //工单结算金额（单位：分）
        $wor_data['wor_collection_price'] = $find_order_data->ord_collection_price; //代收金额（单位：分）
        $wor_data['wor_is_recycle'] = 2; //1.回收2.不回收
        $wor_data['wor_goo_amount'] = $find_order_data->ord_goods_quantity; //总的商品数量
        $wor_data['wor_remark'] = $find_order_data->ord_remark; //工单备注
        $wor_data['wor_code'] = ''; //商品条形码
        $wor_data['wor_create_time'] = $find_order_data->ord_create_time; //创建时间
        $wor_data['wor_update_time'] = $find_order_data->ord_update_time; //更新时间
        $wor_data['wor_delete'] = 1; //是否删除 1.正常工单 2.取消工单
        $wor_data['wor_plus_minus'] = $find_order_data->ord_plus_minus; //工单总金额正负：1正值2负值
        $wor_data['wor_recycle_price'] = 0; //总的回收金额（单位：分）
        $wor_data['wor_account_state'] = $find_order_data->ord_state; //所属企业
        $wor_id = DB::table('work_order')->insertGetId($wor_data);
        dump($wor_id);
        // 生成工单客户表
        $wocl_data['wocl_wor_id'] = $wor_id;
        $wocl_data['wocl_client_id'] = $find_order_data->orcl_client_id;
        $wocl_data['wocl_adm_id'] = $find_order_data->orcl_adm_id;
        $wocl_data['wocl_channel_unit'] = $find_order_data->orcl_channel_unit;
        $wocl_data['wocl_name'] = $find_order_data->orcl_name;
        $wocl_data['wocl_phone'] = $find_order_data->orcl_phone;
        $wocl_data['wocl_car_num'] = $find_order_data->orcl_car_num;
        $wocl_data['wocl_car_vehicle_type'] = $find_order_data->orcl_car_vehicle_type;
        $wocl_data['wocl_province'] = $find_order_data->orcl_province;
        $wocl_data['wocl_city'] = $find_order_data->orcl_city;
        $wocl_data['wocl_county'] = $find_order_data->orcl_county;
        $wocl_data['wocl_address'] = $find_order_data->orcl_address;
        $wocl_data['wocl_chin_type'] = $find_order_data->orcl_chin_type;
        $wocl_data['wocl_collect_state'] = $find_order_data->orcl_collect_state;
        $wocl_data['wocl_acti_id'] = $find_order_data->orcl_acc_subject_id;
        $wocl_data['wocl_rescue_service_price'] = $find_order_data->orcl_rescue_service_price;
        $wocl_data['wocl_rescue_collection_price'] = $find_order_data->orcl_rescue_collection_price;
        $wocl_data['wocl_update_time'] = $find_order_data->orcl_update_time;
        $wocl_data['wocl_before_wor_state'] = $find_order_data->orcl_before_wor_state;
        $wocl_data['wocl_wor_type'] = $find_order_data->orcl_order_type;
        $wocl_data['wocl_standby_battery_type'] = $find_order_data->orcl_standby_battery_type;
        $wocl_data['wocl_join_wor_id'] = $find_order_data->orcl_join_wor_id;
        $wocl_data['wocl_join_audit'] = $find_order_data->orcl_order_type;
        $wocl_data['wocl_assign_price'] = 0;
        $wocl_data['wocl_plus_minus'] = 1;
        $wocl_data['wocl_junk_type'] = 2;
        $wocl_data['wocl_whether_app'] = 1;
        $wocl_id = DB::table('work_client')->insert($wocl_data);
        dump($wocl_id);
        // 发货单表添加数据
        $dego_number = 'FH' . time() . rand(100, 999);

        $bill_data['dego_cid'] = $cid; //公司id
        $bill_data['dego_shop_id'] = $shop_id; //门店id
        $bill_data['dego_superior_shop_id'] = $shop_id; //所属总店id
        $bill_data['dego_number'] = $dego_number; //发货单号
        $bill_data['dego_wor_id'] = $wor_id; //发货单关联的工单id
        $bill_data['dego_original_number'] = 'G2020092017411200164'; //原始单号,发货单的关联单号(工单号)
        $bill_data['dego_client_type'] = $find_order_data->ord_type; //买家类型：1.会员零售2.客户单位3.速电派单4.第三方派单
        $bill_data['dego_client_id'] = $find_order_data->orcl_client_id; //选择的客户id,会员id/单位id
        $bill_data['dego_count'] = $find_order_data->ord_goods_quantity; //发货总数量
        $bill_data['dego_out_ware_id'] = $find_order_data->ord_ware_id; //出库仓库id
        $bill_data['dego_service_shop_id'] = $find_order_data->ord_service_shop_id; //服务门店id
        $bill_data['dego_service_adm_id'] = $find_order_data->ord_service_adm_id; //服务技师id
        $bill_data['dego_type'] = 2; //类型：1未出库2已出库
        $bill_data['dego_order_type'] = 2; //类型：1.订单发货 2.工单发货
        $bill_data['dego_create_adm_id'] = $find_order_data->ord_create_id; //创建人id
        $bill_data['dego_remark'] = $find_order_data->ord_remark; //备注
        $dego_id = DB::table('dispatch_bill')->insertGetId($bill_data);
        // 查询订单商品表数据
        $find_orgo_data = DB::table('order_goods')
            ->where('orgo_ord_id', $find_order_data->ord_id)
            ->get()->toArray();
        foreach ($find_orgo_data as $key => $value) {
            $wogo_data[$key]['wogo_wor_id'] = $wor_id; //工单id
            $wogo_data[$key]['wogo_ware_id'] = $value->orgo_ware_id; //仓库id
            $wogo_data[$key]['wogo_waon_class'] = $value->orgo_waon_class; //仓库类别
            $wogo_data[$key]['wogo_actual_goo_id'] = $value->orgo_actual_goo_id; //实际出库商品id
            $wogo_data[$key]['wogo_wago_id'] = $value->orgo_wago_id; //仓库商品id
            $wogo_data[$key]['wogo_goo_id'] = $value->orgo_goo_id; //商品id
            $wogo_data[$key]['wogo_is_recycle'] = $value->orgo_is_recycle; //是否回收1回收2不回收
            $wogo_data[$key]['wogo_state'] = $value->orgo_state; //商品状态1.正常 2.删除3回收的商品4换货商品5赠品商品6备用电池7临时商品8旧货商品
            $wogo_data[$key]['wogo_goo_name'] = $value->orgo_goo_name; //商品名称
            $wogo_data[$key]['wogo_tem_goo_name'] = $value->orgo_tem_goo_name; //临时商品名称
            $wogo_data[$key]['wogo_goo_goods_encode'] = $value->orgo_goo_goods_encode; //检索编码
            $wogo_data[$key]['wogo_goo_type'] = $value->orgo_goo_type; //商品类型1正常商品2赠品商品3活动商品4旧货商品
            $wogo_data[$key]['wogo_goo_price'] = $value->orgo_goo_price; //商品售价（单位：分）
            $wogo_data[$key]['wogo_collection_price'] = $value->orgo_collection_price; //代收金额（单位：分）
            $wogo_data[$key]['wogo_recycle_price'] = $value->orgo_recycle_price; //回收金额（单位：分）
            $wogo_data[$key]['wogo_goo_amount'] = $value->orgo_goo_quantity; //可派单商品数量
            $wogo_data[$key]['wogo_goo_inventory'] = $value->orgo_goo_inventory; //库存扣除方式1良品2优先
            $wogo_data[$key]['wogo_goo_exchange'] = $value->orgo_goo_exchange; //商品是否换货：1订单商品2换货商品3旧货回收商品
            $wogo_data[$key]['wogo_recycle_quantity'] = $value->orgo_recycle_quantity; //回收数量
            $wogo_data[$key]['wogo_actual_recycle_number'] = $value->orgo_recycle_quantity; //实际回收数量
            $wogo_data[$key]['wogo_remark'] = ''; //备注
            $wogo_data[$key]['wogo_update_time'] = $value->orgo_update_time; //更新时间
            $wogo_data[$key]['wogo_assign_price'] = $value->orgo_assign_price; //派单金额

            // 发货商品表数据
            $digo_data[$key]['digo_dego_id'] = $dego_id;
            $digo_data[$key]['digo_wago_class'] = $value->orgo_waon_class;
            $digo_data[$key]['digo_goo_id'] = $value->orgo_goo_id;
            $digo_data[$key]['digo_goo_type'] = $value->orgo_goo_type;
            $digo_data[$key]['digo_goo_price'] = $value->orgo_goo_price;
            $digo_data[$key]['digo_goo_quantity'] = $value->orgo_goo_quantity;
            $digo_data[$key]['digo_is_recycle'] = $value->orgo_is_recycle;
            $digo_data[$key]['digo_goo_inventory'] = $value->orgo_goo_inventory;
            $digo_data[$key]['digo_tem_goo_name'] = $value->orgo_tem_goo_name;
            $digo_data[$key]['digo_goo_goods_encode'] = $value->orgo_goo_goods_encode;
            $digo_data[$key]['digo_state'] = $value->orgo_state;
        }
        $wogo_id = DB::table('work_good')->insert($wogo_data);
        dump($wogo_id);
        $dispatch_goods = DB::table('dispatch_goods')->insert($digo_data);
        dump($dispatch_goods);
        unset($wor_data);
        unset($wor_id);
        unset($wocl_data);
        unset($wocl_id);
        unset($wogo_data);
        unset($dego_id);
        unset($digo_data);
        unset($wogo_id);
        unset($dispatch_goods);
    }

    // 查询订单账单的数据
    public function orderBill()
    {
        ignore_user_abort();
        set_time_limit(0);

        $cid = 1;
        $shop_id = 1;

        // 查询订单账单的数据
        $find_orbi_data = DB::table('order_bill')
            ->where('orbi_cid', $cid)
            ->where('orbi_superior_shop_id', $shop_id)
            ->where('orbi_shop_id', $shop_id)
            ->where('orbi_state', 2)
            ->where('orbi_state', '!=', 5)
            ->select('orbi_id', 'orbi_number', 'orbi_total_price', 'orbi_bill_price', 'orbi_actual_price', 'orbi_receive_price', 'orbi_zero_price')
            ->get()->toArray();
        foreach ($find_orbi_data as $key => $value) {
            // dump($value);
            // 查询结款明细类型为订单账单的数据
            $find_acset_data = DB::table('accounting_settlement')
                ->where('acset_adm_cid', $cid)
                ->where('acset_shop_id', $shop_id)
                ->where('acset_superior_shop_id', $shop_id)
                ->where('acset_type', 2)
                ->where('acset_state', 2)
                ->where('acset_original_id', $value->orbi_id)
                ->where('acset_original_number', $value->orbi_number)
                ->select('acset_id', 'acset_number', 'acset_original_id', 'acset_original_number', 'acset_price')
                ->first();
            if ($find_acset_data) {
                if ($find_acset_data->acset_price != $value->orbi_actual_price) {
                    dump($find_acset_data);
                }
            }
            // if ($find_orgo_data) {
            //     $orgo_data['orgo_ware_id'] = $value->ord_ware_id;
            //     $ord_res = DB::table('order_goods')
            //         ->where('orgo_ord_id', $value->ord_id)
            //         ->where('orgo_order_number', $value->ord_order_number)
            //         ->update($orgo_data);
            //     dump($ord_res);
            //     unset($orgo_data);
            //     unset($ord_res);
            // }
        }
    }

    // 调整订单商品表的仓库id
    public function order5()
    {
        ignore_user_abort();
        set_time_limit(0);

        $cid = 1;
        $shop_id = 1;

        // 查询订单表的仓库id
        $find_order_data = DB::table('order')
            ->where('ord_cid', $cid)
            ->where('ord_superior_shop_id', $shop_id)
            ->where('ord_shop_id', $shop_id)
            ->where('ord_ware_id', '!=', 0)
            ->select('ord_id', 'ord_order_number', 'ord_ware_id')
            ->get()->toArray();
        foreach ($find_order_data as $key => $value) {
            // dump($value);
            // 查询订单商品没有仓库id
            $find_orgo_data = DB::table('order_goods')
                ->where('orgo_ord_id', $value->ord_id)
                ->where('orgo_order_number', $value->ord_order_number)
                ->where('orgo_ware_id', 0)
                ->select('orgo_id')
                ->first();
            dump($find_orgo_data);
            if ($find_orgo_data) {
                $orgo_data['orgo_ware_id'] = $value->ord_ware_id;
                $ord_res = DB::table('order_goods')
                    ->where('orgo_ord_id', $value->ord_id)
                    ->where('orgo_order_number', $value->ord_order_number)
                    ->update($orgo_data);
                dump($ord_res);
                unset($orgo_data);
                unset($ord_res);
            }
        }
    }

    // 调整订单表的仓库id
    public function order4()
    {
        ignore_user_abort();
        set_time_limit(0);

        $cid = 1;
        $shop_id = 1;

        // 查询工单表的仓库id
        $find_work_data = DB::table('work_order as wor')
            ->leftjoin('work_client as wocl', 'wocl.wocl_wor_id', '=', 'wor.wor_id')
            ->where('wor_cid', $cid)
            ->where('wor_superior_shop_id', $shop_id)
            ->where('wor_shop_id', $shop_id)
            ->where('wocl_wor_type', '!=', 4)
            // ->where('wor_delete', 1)
            ->select('wor_id', 'wor_number', 'wor_order_id', 'wor_order_number', 'wor_ware_id')
            ->get()->toArray();
        foreach ($find_work_data as $key => $value) {
            // dump($value);
            // 查询订单没有仓库id
            $find_order = DB::table('order as ord')
                ->leftjoin('order_client as orcl', 'orcl.orcl_ord_id', '=', 'ord.ord_id')
                ->where('ord_id', $value->wor_order_id)
                ->where('ord_cid', 1)
                ->where('ord_superior_shop_id', 1)
                ->where('ord_shop_id', 1)
                ->where('ord_order_number', $value->wor_order_number)
                ->where('ord_ware_id', 0)
                ->where('orcl_shipment_party', '!=', 4)
                ->select('ord_id', 'ord_order_number')
                ->first();
            dump($find_order);
            if ($find_order) {
                $ord_data['ord_ware_id'] = $value->wor_ware_id;
                $ord_res = DB::table('order')
                    ->where('ord_id', $value->wor_order_id)
                    ->where('ord_order_number', $value->wor_order_number)
                    ->update($ord_data);
                dump($ord_res);
                unset($ord_data);
                unset($ord_res);
            }
        }
    }

    // 修改应收应付客户单位id
    public function receivable3()
    {
        ignore_user_abort();
        set_time_limit(0);

        // 应收应付表
        $find_data = DB::table('receivable_credit')
            ->where('recr_cid', 1)
            ->where('recr_shop_id', 1)
            ->where('recr_client_type', 2)
            ->where('recr_client_id', 0)
            ->where('recr_type', 3)
            ->select('recr_id', 'recr_original_id', 'recr_original_number')
            ->get()->toArray();
        foreach ($find_data as $key => $value) {
            // 根据id和单号在订单表查询
            $find_order = DB::table('order')
                ->where('ord_id', $value->recr_original_id)
                ->where('ord_order_number', $value->recr_original_number)
                ->select('ord_client_id')
                ->first();
            $recr_data['recr_client_id'] = $find_order->ord_client_id; //客户id
            $update_res = DB::table('receivable_credit')
                ->where('recr_id', $value->recr_id)
                ->update($recr_data);
            dump($update_res);
            unset($recr_data);
            unset($update_res);
        }
        echo '雪无忧';
    }

    // 订单/工单客户表,更改业务员id
    public function order3()
    {
        ignore_user_abort();
        set_time_limit(0);

        // 订单表
        $find_order_data = DB::table('order as ord')
            ->leftjoin('order_client as orcl', 'orcl.orcl_ord_id', '=', 'ord.ord_id')
            // ->where('ord_delete', 1)
            ->where('ord_collection_bill', 1)
            ->where('ord_type', 2)
            ->where('orcl_adm_id', 0)
            ->select('ord_id', 'ord_cid', 'ord_shop_id', 'ord_order_number', 'ord_client_id')
            ->get()->toArray();
        foreach ($find_order_data as $key => $value) {
            $chun_adm_id = DB::table('channel_unit')
                ->where('chun_id', $value->ord_client_id)
                ->value('chun_adm_id');
            $update_data['orcl_adm_id'] = $chun_adm_id;
            $update_res = DB::table('order_client')
                ->where('orcl_ord_id', $value->ord_id)
                ->update($update_data);
            dump($update_res);
            unset($update_data);
            unset($update_res);
        }
        // 工单表
        $find_order_data = DB::table('work_order as wor')
            ->leftjoin('work_client as wocl', 'wocl.wocl_wor_id', '=', 'wor.wor_id')
            // ->where('wor_delete', 1)
            ->where('wor_collection_bill', 1)
            ->where('wor_type', 2)
            ->where('wocl_adm_id', 0)
            ->select('wor_id', 'wor_number', 'wocl_client_id')
            ->get()->toArray();
        foreach ($find_order_data as $key => $value) {
            $chun_adm_id = DB::table('channel_unit')
                ->where('chun_id', $value->wocl_client_id)
                ->value('chun_adm_id');
            $wocl_update_data['wocl_adm_id'] = $chun_adm_id;
            $wocl_update_res = DB::table('work_client')
                ->where('wocl_wor_id', $value->wor_id)
                ->update($wocl_update_data);
            dump($wocl_update_res);
            unset($wocl_update_data);
            unset($wocl_update_res);
        }
        echo '雪无忧';
    }

    // 查询订单金额和应收应付金额
    public function orders2(Request $request)
    {
        ignore_user_abort();
        set_time_limit(0);

        $search_data = $request->all();

        $find_order = DB::table('order')
            ->where('ord_cid', 1)
            ->where('ord_shop_id', 1)
            ->where('ord_delete', 1)
            ->where('ord_collection_bill', 1)
            ->where('ord_delete', 1)
            ->where(function ($query) use ($search_data) {
                //如果选择开始时间并且选择结束时间
                if (!empty($search_data['create_time_start']) && !empty($search_data['create_time_end'])) {
                    $query->whereBetween('ord_create_time', [$search_data['create_time_start'], $search_data['create_time_end'] . ' 23:59:59']);
                } else {
                    // 如果选择开始时间
                    if (!empty($search_data['create_time_start'])) {
                        $query->where('ord_create_time', '>=', $search_data['create_time_start']);
                    } else {
                        // 如果选择结束时间
                        if (!empty($search_data['create_time_end'])) {
                            $query->where('ord_create_time', '<=', $search_data['create_time_end'] . ' 23:59:59');
                        }
                    }
                }
            }) //创建时间
            ->where('ord_actual_price', '!=', 0)
            ->select('ord_id', 'ord_cid', 'ord_shop_id', 'ord_order_number', 'ord_actual_price', 'ord_plus_minus')
            ->get()->toArray();
        foreach ($find_order as $key => $value) {
            // dump($value);
            // 查询应收应付的数据
            $find_recr_data = DB::table('receivable_credit')
                ->where('recr_cid', $value->ord_cid)
                ->where('recr_shop_id', $value->ord_shop_id)
                ->where('recr_original_id', $value->ord_id)
                ->where('recr_original_number', $value->ord_order_number)
                ->whereNotIn('recr_account_type', [2, 3])
                ->select('recr_original_number', 'recr_plus_minus', 'recr_account_type')
                ->first();
            if ($find_recr_data) {
                if ($find_recr_data->recr_plus_minus != $value->ord_plus_minus) {
                    dump($find_recr_data->recr_plus_minus . '------' . $find_recr_data->recr_original_number);
                    dump($value->ord_plus_minus . '------' . $value->ord_order_number);
                    $recr_data['recr_cid'] = $value->ord_cid;
                    $recr_data['recr_shop_id'] = $value->ord_shop_id;
                    $recr_data['recr_original_id'] = $value->ord_id;
                    $recr_data['recr_original_number'] = $value->ord_order_number;
                    $recr_res = DB::table('receivable_credit_order')->insert($recr_data);
                    dump($recr_res);
                    unset($recr_data);
                    unset($recr_res);
                }
            }
        }
    }

    // 调拨单导出
    public function transferringExport(Request $request)
    {
        $cid = 1;
        $shop_id = 1;

        $search_data = $request->all();

        $data = DB::table('transferring_order_goods as trog')
            ->leftjoin('transferring_order as tror', 'tror.tror_id', '=', 'trog.trog_tror_id')
            ->leftjoin('goods as goo', 'goo.goo_id', '=', 'trog.trog_goo_id')
            ->leftjoin('admin as adm', 'adm.adm_id', '=', 'tror.tror_create_id')
            ->leftjoin('warehouse as ware', 'ware.ware_id', '=', 'tror.tror_in_ware_id')
            ->where('tror_cid', $cid)
            ->where('tror_shop_id', $shop_id)
            ->where('tror_delete', 1)
            ->where('tror_out_ware_id', 9)
            ->whereIn('tror_in_ware_id', [10, 11, 13, 14])
            ->where(function ($query) use ($search_data) {
                //如果选择开始时间并且选择结束时间
                if (!empty($search_data['start_time']) && !empty($search_data['end_time'])) {
                    $query->whereBetween('tror_create_time', [$search_data['start_time'], $search_data['end_time'] . ' 23:59:59']);
                } else {
                    // 如果选择开始时间
                    if (!empty($search_data['start_time'])) {
                        $query->where('tror_create_time', '>=', $search_data['start_time']);
                    } else {
                        // 如果选择结束时间
                        if (!empty($search_data['end_time'])) {
                            $query->where('tror_create_time', '<=', $search_data['end_time'] . ' 23:59:59');
                        }
                    }
                }
            }) //时间
            ->select('tror_number', 'ware_name', 'goo_name', 'goo_goods_encode', 'goo_cate_name', 'trog_stock_number', 'trog_priority_stock_number', 'adm_name', 'tror_create_time')
            ->get()->toArray();
        // dump($data);exit;
        if (!empty($data)) {
            // 将对象转化为数组
            $data = json_decode(json_encode($data), true);
            foreach ($data as $key => $value) {
                //商品编号
                $data[$key]['goo_goods_encode'] = empty("\t" . $value['goo_goods_encode']) ? '' : "\t" . $value['goo_goods_encode'];
                $data[$key]['goo_name'] = empty($value['goo_name']) ? '' : $value['goo_name'];
                $data[$key]['adm_name'] = empty($value['adm_name']) ? '' : $value['adm_name'];
            }
        } else {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'没有符合条件的数据']);
        }
        $pathName = storage_path() . "/app/public/excel"; //获取上传excel路径
        // 创建文件夹
        if (!file_exists($pathName)) {
            mkdir($pathName, 0775, true);
            chmod($pathName, 0775);
        }

        // $streamFileRand = time() . rand(10000, 99999).'9.27-9.30调拨单数据.xls';
        $streamFileRand = time() . rand(10000, 99999) . '10.1-10.31调拨单数据.xls';
        // 产生一个随机文件名（因为你base64上来肯定没有文件名，这里你可以自己设置一个也行）
        $streamFilename = $pathName . '/' . $streamFileRand;

        $where['action_name'] = '调拨单';
        $where['field_name'] = ['单号', '仓库名称', '商品名称', '检索编码', '商品类型', '良品数量', '优先数量', '创建人', '创建时间'];
        // 调用导出的公共方法
        export::publicExport(
            $streamFilename, //路径
            $where,    //sheet名及其每一行的标题
            $data      //导出数据
        );

        // 判断文件是否存在 存在则成功  不存在则失败
        if (file_exists($streamFilename)) {
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>'storage/excel/' . $streamFileRand]);
        } else {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'导出失败']);
        }
    }

    // 结款明细生成凭证
    public function workOrderVoucher()
    {
        ignore_user_abort();
        set_time_limit(0);

        $cid = 1;
        $shop_id = 1;

        // 查询结款明细表,状态为已确认,U8状态未同步的数据
        $find_acset_data = DB::table('accounting_settlement')
            ->where('acset_adm_cid', $cid)
            ->where('acset_shop_id', $shop_id)
            ->where('acset_state', 1)
            ->where('acset_sync_state', 1)
            ->where('acset_type', 22)
            ->select('acset_id', 'acset_shop_id', 'acset_with_time', 'acset_affirm_time', 'acset_actual_price', 'acset_price', 'acset_owe_price', 'acset_zero_price', 'acset_zero_plus_minus', 'acset_type', 'acset_inex_type', 'acset_acti_id', 'acset_payment_type')
            ->get()->toArray();
        foreach ($find_acset_data as $key => $value) {
            // 凭证借贷表(结算金额)
            $volo_data[0]['acsl_shop_id'] = $value->acset_shop_id; //所属门店id
            $volo_data[0]['acsl_acset_id'] = $value->acset_id;
            $volo_data[0]['acsl_type'] = 1; //类型1借方2贷方
            $volo_data[1]['acsl_shop_id'] = $value->acset_shop_id; //所属门店id
            $volo_data[1]['acsl_acset_id'] = $value->acset_id;
            $volo_data[1]['acsl_type'] = 1; //类型1借方2贷方
            // 根据银行账号id,查询出对应的名称
            $find_acti_data = DB::table('account_title')
                ->where('acti_id', $value->acset_acti_id)
                ->where('acti_shop_id', $shop_id)
                ->select('acti_subject_code', 'acti_course_title')
                ->first();
            if ($value->acset_type == 1) { //订单结算,收款；借：库存现金或银行存款 贷：应收账款
                // 若有抹零头的情况，抹零金额做冲减营业收入（例如应收505元，实际收500元，抹零5元，借：库存现金或银行存款500，贷：应收账款505，贷：主营业务收入-5）
                if ($value->acset_zero_price == '0') {
                    $volo_data[0]['acsl_borrow_subject'] = $find_acti_data->acti_subject_code; //借方科目
                    $volo_data[0]['acsl_borrow_subject_name'] = $find_acti_data->acti_course_title; //借方科目名称
                    $volo_data[0]['acsl_borrow_price'] = $value->acset_actual_price / 100; //借方金额
                    $volo_data[0]['acsl_loan_subject'] = '1122'; //贷方科目
                    $volo_data[0]['acsl_loan_subject_name'] = '应收账款'; //贷方科目名称
                    $volo_data[0]['acsl_loan_price'] = $value->acset_actual_price / 100; //贷方金额
                    $volo_data[1]['acsl_borrow_subject'] = ''; //借方科目
                    $volo_data[1]['acsl_borrow_subject_name'] = ''; //借方科目名称
                    $volo_data[1]['acsl_borrow_price'] = 0; //借方金额
                    $volo_data[1]['acsl_loan_subject'] = ''; //贷方科目
                    $volo_data[1]['acsl_loan_subject_name'] = ''; //贷方科目名称
                    $volo_data[1]['acsl_loan_price'] = 0; //贷方金额
                } else {
                    $volo_data[0]['acsl_borrow_subject'] = $find_acti_data->acti_subject_code; //借方科目
                    $volo_data[0]['acsl_borrow_subject_name'] = $find_acti_data->acti_course_title; //借方科目名称
                    $volo_data[0]['acsl_borrow_price'] = $value->acset_actual_price / 100; //借方金额
                    $volo_data[0]['acsl_loan_subject'] = ''; //贷方科目
                    $volo_data[0]['acsl_loan_subject_name'] = '应收金额'; //贷方科目名称
                    $volo_data[0]['acsl_loan_price'] = $value->acset_actual_price / 100; //贷方金额
                    $volo_data[1]['acsl_borrow_subject'] = ''; //借方科目
                    $volo_data[1]['acsl_borrow_subject_name'] = ''; //借方科目名称
                    $volo_data[1]['acsl_borrow_price'] = 0; //借方金额
                    $volo_data[1]['acsl_loan_subject'] = '6001'; //贷方科目
                    $volo_data[1]['acsl_loan_subject_name'] = '主营业务收入'; //贷方科目名称
                    $volo_data[1]['acsl_loan_price'] = '-' . $value->acset_zero_price / 100; //贷方金额
                }
            } elseif ($value->acset_type == 2) { //订单账单
                // 若有抹零头的情况，抹零金额做冲减营业收入（例如应收505元，实际收500元，抹零5元，借：库存现金或银行存款500，贷：应收账款505，贷：主营业务收入-5）
                if (!empty($find_acti_data)) {
                    if ($value->acset_zero_price == '0') {
                        $volo_data[0]['acsl_borrow_subject'] = $find_acti_data->acti_subject_code; //借方科目
                        $volo_data[0]['acsl_borrow_subject_name'] = $find_acti_data->acti_course_title; //借方科目名称
                        $volo_data[0]['acsl_borrow_price'] = $value->acset_actual_price / 100; //借方金额
                        $volo_data[0]['acsl_loan_subject'] = '1122'; //贷方科目
                        $volo_data[0]['acsl_loan_subject_name'] = '应收账款'; //贷方科目名称
                        $volo_data[0]['acsl_loan_price'] = $value->acset_actual_price / 100; //贷方金额
                        $volo_data[1]['acsl_borrow_subject'] = ''; //借方科目
                        $volo_data[1]['acsl_borrow_subject_name'] = ''; //借方科目名称
                        $volo_data[1]['acsl_borrow_price'] = 0; //借方金额
                        $volo_data[1]['acsl_loan_subject'] = ''; //贷方科目
                        $volo_data[1]['acsl_loan_subject_name'] = ''; //贷方科目名称
                        $volo_data[1]['acsl_loan_price'] = 0; //贷方金额
                    } else {
                        $volo_data[0]['acsl_borrow_subject'] = $find_acti_data->acti_subject_code; //借方科目
                        $volo_data[0]['acsl_borrow_subject_name'] = $find_acti_data->acti_course_title; //借方科目名称
                        $volo_data[0]['acsl_borrow_price'] = $value->acset_actual_price / 100; //借方金额
                        $volo_data[0]['acsl_loan_subject'] = ''; //贷方科目
                        $volo_data[0]['acsl_loan_subject_name'] = '应收金额'; //贷方科目名称
                        $volo_data[0]['acsl_loan_price'] = $value->acset_actual_price / 100; //贷方金额
                        $volo_data[1]['acsl_borrow_subject'] = ''; //借方科目
                        $volo_data[1]['acsl_borrow_subject_name'] = ''; //借方科目名称
                        $volo_data[1]['acsl_borrow_price'] = 0; //借方金额
                        $volo_data[1]['acsl_loan_subject'] = '6001'; //贷方科目
                        $volo_data[1]['acsl_loan_subject_name'] = '主营业务收入'; //贷方科目名称
                        $volo_data[1]['acsl_loan_price'] = '-' . $value->acset_zero_price / 100; //贷方金额
                    }
                } else {
                    $volo_data[0]['acsl_borrow_subject'] = ''; //借方科目
                    $volo_data[0]['acsl_borrow_subject_name'] = ''; //借方科目名称
                    $volo_data[0]['acsl_borrow_price'] = 0; //借方金额
                    $volo_data[0]['acsl_loan_subject'] = ''; //贷方科目
                    $volo_data[0]['acsl_loan_subject_name'] = ''; //贷方科目名称
                    $volo_data[0]['acsl_loan_price'] = ''; //贷方金额
                    $volo_data[1]['acsl_borrow_subject'] = ''; //借方科目
                    $volo_data[1]['acsl_borrow_subject_name'] = ''; //借方科目名称
                    $volo_data[1]['acsl_borrow_price'] = 0; //借方金额
                    $volo_data[1]['acsl_loan_subject'] = ''; //贷方科目
                    $volo_data[1]['acsl_loan_subject_name'] = ''; //贷方科目名称
                    $volo_data[1]['acsl_loan_price'] = 0; //贷方金额
                }
            } elseif ($value->acset_type == 3) { //工单账单
                // 若有抹零头的情况，抹零金额做冲减营业收入（例如应收505元，实际收500元，抹零5元，借：库存现金或银行存款500，贷：应收账款505，贷：主营业务收入-5）
                if (!empty($find_acti_data)) {
                    if ($value->acset_zero_price == '0') {
                        $volo_data[0]['acsl_borrow_subject'] = $find_acti_data->acti_subject_code; //借方科目
                        $volo_data[0]['acsl_borrow_subject_name'] = $find_acti_data->acti_course_title; //借方科目名称
                        $volo_data[0]['acsl_borrow_price'] = $value->acset_actual_price / 100; //借方金额
                        $volo_data[0]['acsl_loan_subject'] = '1122'; //贷方科目
                        $volo_data[0]['acsl_loan_subject_name'] = '应收账款'; //贷方科目名称
                        $volo_data[0]['acsl_loan_price'] = $value->acset_actual_price / 100; //贷方金额
                        $volo_data[1]['acsl_borrow_subject'] = ''; //借方科目
                        $volo_data[1]['acsl_borrow_subject_name'] = ''; //借方科目名称
                        $volo_data[1]['acsl_borrow_price'] = 0; //借方金额
                        $volo_data[1]['acsl_loan_subject'] = ''; //贷方科目
                        $volo_data[1]['acsl_loan_subject_name'] = ''; //贷方科目名称
                        $volo_data[1]['acsl_loan_price'] = 0; //贷方金额
                    } else {
                        $volo_data[0]['acsl_borrow_subject'] = $find_acti_data->acti_subject_code; //借方科目
                        $volo_data[0]['acsl_borrow_subject_name'] = $find_acti_data->acti_course_title; //借方科目名称
                        $volo_data[0]['acsl_borrow_price'] = $value->acset_actual_price / 100; //借方金额
                        $volo_data[0]['acsl_loan_subject'] = ''; //贷方科目
                        $volo_data[0]['acsl_loan_subject_name'] = '应收金额'; //贷方科目名称
                        $volo_data[0]['acsl_loan_price'] = $value->acset_actual_price / 100; //贷方金额
                        $volo_data[1]['acsl_borrow_subject'] = ''; //借方科目
                        $volo_data[1]['acsl_borrow_subject_name'] = ''; //借方科目名称
                        $volo_data[1]['acsl_borrow_price'] = 0; //借方金额
                        $volo_data[1]['acsl_loan_subject'] = '6001'; //贷方科目
                        $volo_data[1]['acsl_loan_subject_name'] = '主营业务收入'; //贷方科目名称
                        $volo_data[1]['acsl_loan_price'] = '-' . $value->acset_zero_price / 100; //贷方金额
                    }
                } else {
                    $volo_data[0]['acsl_borrow_subject'] = ''; //借方科目
                    $volo_data[0]['acsl_borrow_subject_name'] = ''; //借方科目名称
                    $volo_data[0]['acsl_borrow_price'] = 0; //借方金额
                    $volo_data[0]['acsl_loan_subject'] = ''; //贷方科目
                    $volo_data[0]['acsl_loan_subject_name'] = ''; //贷方科目名称
                    $volo_data[0]['acsl_loan_price'] = ''; //贷方金额
                    $volo_data[1]['acsl_borrow_subject'] = ''; //借方科目
                    $volo_data[1]['acsl_borrow_subject_name'] = ''; //借方科目名称
                    $volo_data[1]['acsl_borrow_price'] = 0; //借方金额
                    $volo_data[1]['acsl_loan_subject'] = ''; //贷方科目
                    $volo_data[1]['acsl_loan_subject_name'] = ''; //贷方科目名称
                    $volo_data[1]['acsl_loan_price'] = 0; //贷方金额
                }
            } elseif ($value->acset_type == 6) { //6预收款,收款；借：银行存款    贷：应收账款
                // 若有抹零头的情况，抹零金额做冲减营业收入（例如应收505元，实际收500元，抹零5元，借：库存现金或银行存款500，贷：应收账款505，贷：主营业务收入-5）
                if ($value->acset_zero_price == '0') {
                    $volo_data[0]['acsl_borrow_subject'] = $find_acti_data->acti_subject_code; //借方科目
                    $volo_data[0]['acsl_borrow_subject_name'] = $find_acti_data->acti_course_title; //借方科目名称
                    $volo_data[0]['acsl_borrow_price'] = $value->acset_actual_price / 100; //借方金额
                    $volo_data[0]['acsl_loan_subject'] = '1122'; //贷方科目
                    $volo_data[0]['acsl_loan_subject_name'] = '应收账款'; //贷方科目名称
                    $volo_data[0]['acsl_loan_price'] = $value->acset_actual_price / 100; //贷方金额
                    $volo_data[1]['acsl_borrow_subject'] = ''; //借方科目
                    $volo_data[1]['acsl_borrow_subject_name'] = ''; //借方科目名称
                    $volo_data[1]['acsl_borrow_price'] = 0; //借方金额
                    $volo_data[1]['acsl_loan_subject'] = ''; //贷方科目
                    $volo_data[1]['acsl_loan_subject_name'] = ''; //贷方科目名称
                    $volo_data[1]['acsl_loan_price'] = 0; //贷方金额
                } else {
                    $volo_data[0]['acsl_borrow_subject'] = $find_acti_data->acti_subject_code; //借方科目
                    $volo_data[0]['acsl_borrow_subject_name'] = $find_acti_data->acti_course_title; //借方科目名称
                    $volo_data[0]['acsl_borrow_price'] = $value->acset_actual_price / 100; //借方金额
                    $volo_data[0]['acsl_loan_subject'] = ''; //贷方科目
                    $volo_data[0]['acsl_loan_subject_name'] = '应收金额'; //贷方科目名称
                    $volo_data[0]['acsl_loan_price'] = $value->acset_actual_price / 100; //贷方金额
                    $volo_data[1]['acsl_borrow_subject'] = ''; //借方科目
                    $volo_data[1]['acsl_borrow_subject_name'] = ''; //借方科目名称
                    $volo_data[1]['acsl_borrow_price'] = 0; //借方金额
                    $volo_data[1]['acsl_loan_subject'] = '6001'; //贷方科目
                    $volo_data[1]['acsl_loan_subject_name'] = '主营业务收入'; //贷方科目名称
                    $volo_data[1]['acsl_loan_price'] = '-' . $value->acset_zero_price / 100; //贷方金额
                }
            } elseif ($value->acset_type == 9) { //9订单代收
                // 若有抹零头的情况，抹零金额做冲减营业收入（例如应收505元，实际收500元，抹零5元，借：库存现金或银行存款500，贷：应收账款505，贷：主营业务收入-5）
                if ($value->acset_zero_price == '0') {
                    $volo_data[0]['acsl_borrow_subject'] = $find_acti_data->acti_subject_code; //借方科目
                    $volo_data[0]['acsl_borrow_subject_name'] = $find_acti_data->acti_course_title; //借方科目名称
                    $volo_data[0]['acsl_borrow_price'] = $value->acset_actual_price / 100; //借方金额
                    $volo_data[0]['acsl_loan_subject'] = '1122'; //贷方科目
                    $volo_data[0]['acsl_loan_subject_name'] = '应收账款'; //贷方科目名称
                    $volo_data[0]['acsl_loan_price'] = $value->acset_actual_price / 100; //贷方金额
                    $volo_data[1]['acsl_borrow_subject'] = ''; //借方科目
                    $volo_data[1]['acsl_borrow_subject_name'] = ''; //借方科目名称
                    $volo_data[1]['acsl_borrow_price'] = 0; //借方金额
                    $volo_data[1]['acsl_loan_subject'] = ''; //贷方科目
                    $volo_data[1]['acsl_loan_subject_name'] = ''; //贷方科目名称
                    $volo_data[1]['acsl_loan_price'] = 0; //贷方金额
                } else {
                    $volo_data[0]['acsl_borrow_subject'] = $find_acti_data->acti_subject_code; //借方科目
                    $volo_data[0]['acsl_borrow_subject_name'] = $find_acti_data->acti_course_title; //借方科目名称
                    $volo_data[0]['acsl_borrow_price'] = $value->acset_actual_price / 100; //借方金额
                    $volo_data[0]['acsl_loan_subject'] = ''; //贷方科目
                    $volo_data[0]['acsl_loan_subject_name'] = '应收金额'; //贷方科目名称
                    $volo_data[0]['acsl_loan_price'] = $value->acset_actual_price / 100; //贷方金额
                    $volo_data[1]['acsl_borrow_subject'] = ''; //借方科目
                    $volo_data[1]['acsl_borrow_subject_name'] = ''; //借方科目名称
                    $volo_data[1]['acsl_borrow_price'] = 0; //借方金额
                    $volo_data[1]['acsl_loan_subject'] = '6001'; //贷方科目
                    $volo_data[1]['acsl_loan_subject_name'] = '主营业务收入'; //贷方科目名称
                    $volo_data[1]['acsl_loan_price'] = '-' . $value->acset_zero_price / 100; //贷方金额
                }
            } elseif ($value->acset_type == 11) { //11.订单退款:借应收账款,贷:库存现金或银行存款
                $volo_data[0]['acsl_borrow_subject'] = '1122'; //借方科目
                $volo_data[0]['acsl_borrow_subject_name'] = '应收账款'; //借方科目名称
                $volo_data[0]['acsl_borrow_price'] = $value->acset_actual_price / 100; //借方金额
                $volo_data[0]['acsl_loan_subject'] = '1001/100201'; //贷方科目
                $volo_data[0]['acsl_loan_subject_name'] = '库存现金或银行存款'; //贷方科目名称
                $volo_data[0]['acsl_loan_price'] = $value->acset_actual_price / 100; //贷方金额
                $volo_data[1]['acsl_borrow_subject'] = ''; //借方科目
                $volo_data[1]['acsl_borrow_subject_name'] = ''; //借方科目名称
                $volo_data[1]['acsl_borrow_price'] = 0; //借方金额
                $volo_data[1]['acsl_loan_subject'] = ''; //贷方科目
                $volo_data[1]['acsl_loan_subject_name'] = ''; //贷方科目名称
                $volo_data[1]['acsl_loan_price'] = 0; //贷方金额
            } elseif ($value->acset_type == 12) { //12工单代收,收款；借：库存现金或银行存款  贷：应收账款
                if ($value->acset_zero_price == '0') {
                    $volo_data[0]['acsl_borrow_subject'] = $find_acti_data->acti_subject_code; //借方科目
                    $volo_data[0]['acsl_borrow_subject_name'] = $find_acti_data->acti_course_title; //借方科目名称
                    $volo_data[0]['acsl_borrow_price'] = $value->acset_actual_price / 100; //借方金额
                    $volo_data[0]['acsl_loan_subject'] = '1122'; //贷方科目
                    $volo_data[0]['acsl_loan_subject_name'] = '应收账款'; //贷方科目名称
                    $volo_data[0]['acsl_loan_price'] = $value->acset_actual_price / 100; //贷方金额
                    $volo_data[1]['acsl_borrow_subject'] = ''; //借方科目
                    $volo_data[1]['acsl_borrow_subject_name'] = ''; //借方科目名称
                    $volo_data[1]['acsl_borrow_price'] = 0; //借方金额
                    $volo_data[1]['acsl_loan_subject'] = ''; //贷方科目
                    $volo_data[1]['acsl_loan_subject_name'] = ''; //贷方科目名称
                    $volo_data[1]['acsl_loan_price'] = 0; //贷方金额
                } else {
                    $volo_data[0]['acsl_borrow_subject'] = $find_acti_data->acti_subject_code; //借方科目
                    $volo_data[0]['acsl_borrow_subject_name'] = $find_acti_data->acti_course_title; //借方科目名称
                    $volo_data[0]['acsl_borrow_price'] = $value->acset_actual_price / 100; //借方金额
                    $volo_data[0]['acsl_loan_subject'] = ''; //贷方科目
                    $volo_data[0]['acsl_loan_subject_name'] = '应收金额'; //贷方科目名称
                    $volo_data[0]['acsl_loan_price'] = $value->acset_actual_price / 100; //贷方金额
                    $volo_data[1]['acsl_borrow_subject'] = ''; //借方科目
                    $volo_data[1]['acsl_borrow_subject_name'] = ''; //借方科目名称
                    $volo_data[1]['acsl_borrow_price'] = 0; //借方金额
                    $volo_data[1]['acsl_loan_subject'] = '6001'; //贷方科目
                    $volo_data[1]['acsl_loan_subject_name'] = '主营业务收入'; //贷方科目名称
                    $volo_data[1]['acsl_loan_price'] = '-' . $value->acset_zero_price / 100; //贷方金额
                }
            } elseif ($value->acset_type == 13) { //13订单完成后结算,收款；借：库存现金或银行退款 贷：应收账款
                if ($value->acset_zero_price == '0') {
                    $volo_data[0]['acsl_borrow_subject'] = $find_acti_data->acti_subject_code; //借方科目
                    $volo_data[0]['acsl_borrow_subject_name'] = $find_acti_data->acti_course_title; //借方科目名称
                    $volo_data[0]['acsl_borrow_price'] = $value->acset_actual_price / 100; //借方金额
                    $volo_data[0]['acsl_loan_subject'] = '1122'; //贷方科目
                    $volo_data[0]['acsl_loan_subject_name'] = '应收账款'; //贷方科目名称
                    $volo_data[0]['acsl_loan_price'] = $value->acset_actual_price / 100; //贷方金额
                    $volo_data[1]['acsl_borrow_subject'] = ''; //借方科目
                    $volo_data[1]['acsl_borrow_subject_name'] = ''; //借方科目名称
                    $volo_data[1]['acsl_borrow_price'] = 0; //借方金额
                    $volo_data[1]['acsl_loan_subject'] = ''; //贷方科目
                    $volo_data[1]['acsl_loan_subject_name'] = ''; //贷方科目名称
                    $volo_data[1]['acsl_loan_price'] = 0; //贷方金额
                } else {
                    $volo_data[0]['acsl_borrow_subject'] = $find_acti_data->acti_subject_code; //借方科目
                    $volo_data[0]['acsl_borrow_subject_name'] = $find_acti_data->acti_course_title; //借方科目名称
                    $volo_data[0]['acsl_borrow_price'] = $value->acset_actual_price / 100; //借方金额
                    $volo_data[0]['acsl_loan_subject'] = ''; //贷方科目
                    $volo_data[0]['acsl_loan_subject_name'] = '应收金额'; //贷方科目名称
                    $volo_data[0]['acsl_loan_price'] = $value->acset_actual_price / 100; //贷方金额
                    $volo_data[1]['acsl_borrow_subject'] = ''; //借方科目
                    $volo_data[1]['acsl_borrow_subject_name'] = ''; //借方科目名称
                    $volo_data[1]['acsl_borrow_price'] = 0; //借方金额
                    $volo_data[1]['acsl_loan_subject'] = '6001'; //贷方科目
                    $volo_data[1]['acsl_loan_subject_name'] = '主营业务收入'; //贷方科目名称
                    $volo_data[1]['acsl_loan_price'] = '-' . $value->acset_zero_price / 100; //贷方金额
                }
            } elseif ($value->acset_type == 16) { //16.加盟店订单收款,借:库存现金或银行存款,贷:应收账款(加盟店)
                $volo_data[0]['acsl_borrow_subject'] = $find_acti_data->acti_subject_code; //借方科目
                $volo_data[0]['acsl_borrow_subject_name'] = $find_acti_data->acti_course_title; //借方科目名称
                $volo_data[0]['acsl_borrow_price'] = $value->acset_actual_price / 100; //借方金额
                $volo_data[0]['acsl_loan_subject'] = '1122'; //贷方科目
                $volo_data[0]['acsl_loan_subject_name'] = '应收账款'; //贷方科目名称
                $volo_data[0]['acsl_loan_price'] = $value->acset_actual_price / 100; //贷方金额
                $volo_data[1]['acsl_borrow_subject'] = ''; //借方科目
                $volo_data[1]['acsl_borrow_subject_name'] = ''; //借方科目名称
                $volo_data[1]['acsl_borrow_price'] = 0; //借方金额
                $volo_data[1]['acsl_loan_subject'] = ''; //贷方科目
                $volo_data[1]['acsl_loan_subject_name'] = ''; //贷方科目名称
                $volo_data[1]['acsl_loan_price'] = 0; //贷方金额
            } elseif ($value->acset_type == 17) { //17.加盟店订单代收,借:应收账款（加盟店）,贷:应收账款（委托方）
                // 收到加盟店转来代收款时，借：库存现金或银行存款  贷：应收账款（加盟店）
                $volo_data[0]['acsl_borrow_subject'] = '1122'; //借方科目
                $volo_data[0]['acsl_borrow_subject_name'] = '应收账款'; //借方科目名称
                $volo_data[0]['acsl_borrow_price'] = $value->acset_actual_price / 100; //借方金额
                $volo_data[0]['acsl_loan_subject'] = '1122'; //贷方科目
                $volo_data[0]['acsl_loan_subject_name'] = '应收账款'; //贷方科目名称
                $volo_data[0]['acsl_loan_price'] = $value->acset_actual_price / 100; //贷方金额
                $volo_data[1]['acsl_borrow_subject'] = ''; //借方科目
                $volo_data[1]['acsl_borrow_subject_name'] = ''; //借方科目名称
                $volo_data[1]['acsl_borrow_price'] = 0; //借方金额
                $volo_data[1]['acsl_loan_subject'] = ''; //贷方科目
                $volo_data[1]['acsl_loan_subject_name'] = ''; //贷方科目名称
                $volo_data[1]['acsl_loan_price'] = 0; //贷方金额
            } elseif ($value->acset_type == 18) { //18工单结算-工单费用, 付款；借：库存现金或银行存款 贷：应收账款(加盟店)
                $volo_data[0]['acsl_borrow_subject'] = $find_acti_data->acti_subject_code; //借方科目
                $volo_data[0]['acsl_borrow_subject_name'] = $find_acti_data->acti_course_title; //借方科目名称
                $volo_data[0]['acsl_borrow_price'] = $value->acset_actual_price / 100; //借方金额
                $volo_data[0]['acsl_loan_subject'] = '1122'; //贷方科目
                $volo_data[0]['acsl_loan_subject_name'] = '应收账款'; //贷方科目名称
                $volo_data[0]['acsl_loan_price'] = $value->acset_actual_price / 100; //贷方金额
                $volo_data[1]['acsl_borrow_subject'] = ''; //借方科目
                $volo_data[1]['acsl_borrow_subject_name'] = ''; //借方科目名称
                $volo_data[1]['acsl_borrow_price'] = 0; //借方金额
                $volo_data[1]['acsl_loan_subject'] = ''; //贷方科目
                $volo_data[1]['acsl_loan_subject_name'] = ''; //贷方科目名称
                $volo_data[1]['acsl_loan_price'] = 0; //贷方金额
            } elseif ($value->acset_type == 19) { //19.旧货回收,借:库存商品,贷:应收账款
                $volo_data[0]['acsl_borrow_subject'] = '1405'; //借方科目
                $volo_data[0]['acsl_borrow_subject_name'] = '库存商品'; //借方科目名称
                $volo_data[0]['acsl_borrow_price'] = $value->acset_actual_price / 100; //借方金额
                $volo_data[0]['acsl_loan_subject'] = '1122'; //贷方科目
                $volo_data[0]['acsl_loan_subject_name'] = '应收账款'; //贷方科目名称
                $volo_data[0]['acsl_loan_price'] = $value->acset_actual_price / 100; //贷方金额
                $volo_data[1]['acsl_borrow_subject'] = ''; //借方科目
                $volo_data[1]['acsl_borrow_subject_name'] = ''; //借方科目名称
                $volo_data[1]['acsl_borrow_price'] = 0; //借方金额
                $volo_data[1]['acsl_loan_subject'] = ''; //贷方科目
                $volo_data[1]['acsl_loan_subject_name'] = ''; //贷方科目名称
                $volo_data[1]['acsl_loan_price'] = 0; //贷方金额
            } elseif ($value->acset_type == 20) { //20.售后单结算,借:库存现金或银行存款,贷:应收账款
                // 若有抹零头的情况，抹零金额做冲减营业收入（例如应收505元，实际收500元，抹零5元，借：库存现金或银行存款500，贷：应收账款505，贷：主营业务收入-5）
                if ($value->acset_zero_price == '0') {
                    $volo_data[0]['acsl_borrow_subject'] = $find_acti_data->acti_subject_code; //借方科目
                    $volo_data[0]['acsl_borrow_subject_name'] = $find_acti_data->acti_course_title; //借方科目名称
                    $volo_data[0]['acsl_borrow_price'] = $value->acset_actual_price / 100; //借方金额
                    $volo_data[0]['acsl_loan_subject'] = '1122'; //贷方科目
                    $volo_data[0]['acsl_loan_subject_name'] = '应收账款'; //贷方科目名称
                    $volo_data[0]['acsl_loan_price'] = $value->acset_actual_price / 100; //贷方金额
                    $volo_data[1]['acsl_borrow_subject'] = ''; //借方科目
                    $volo_data[1]['acsl_borrow_subject_name'] = ''; //借方科目名称
                    $volo_data[1]['acsl_borrow_price'] = 0; //借方金额
                    $volo_data[1]['acsl_loan_subject'] = ''; //贷方科目
                    $volo_data[1]['acsl_loan_subject_name'] = ''; //贷方科目名称
                    $volo_data[1]['acsl_loan_price'] = 0; //贷方金额
                } else {
                    $volo_data[0]['acsl_borrow_subject'] = $find_acti_data->acti_subject_code; //借方科目
                    $volo_data[0]['acsl_borrow_subject_name'] = $find_acti_data->acti_course_title; //借方科目名称
                    $volo_data[0]['acsl_borrow_price'] = $value->acset_actual_price / 100; //借方金额
                    $volo_data[0]['acsl_loan_subject'] = ''; //贷方科目
                    $volo_data[0]['acsl_loan_subject_name'] = '应收金额'; //贷方科目名称
                    $volo_data[0]['acsl_loan_price'] = $value->acset_actual_price / 100; //贷方金额
                    $volo_data[1]['acsl_borrow_subject'] = ''; //借方科目
                    $volo_data[1]['acsl_borrow_subject_name'] = ''; //借方科目名称
                    $volo_data[1]['acsl_borrow_price'] = 0; //借方金额
                    $volo_data[1]['acsl_loan_subject'] = '6001'; //贷方科目
                    $volo_data[1]['acsl_loan_subject_name'] = '主营业务收入'; //贷方科目名称
                    $volo_data[1]['acsl_loan_price'] = '-' . $value->acset_zero_price / 100; //贷方金额
                }
            } elseif ($value->acset_type == 22) { //22.采购单,借：库存商品,贷：应付账款
                $volo_data[0]['acsl_borrow_subject'] = '1405'; //借方科目
                $volo_data[0]['acsl_borrow_subject_name'] = '库存商品'; //借方科目名称
                $volo_data[0]['acsl_borrow_price'] = $value->acset_actual_price / 100; //借方金额
                $volo_data[0]['acsl_loan_subject'] = '220202'; //贷方科目
                $volo_data[0]['acsl_loan_subject_name'] = '应付账款'; //贷方科目名称
                $volo_data[0]['acsl_loan_price'] = $value->acset_actual_price / 100; //贷方金额
                $volo_data[1]['acsl_borrow_subject'] = ''; //借方科目
                $volo_data[1]['acsl_borrow_subject_name'] = ''; //借方科目名称
                $volo_data[1]['acsl_borrow_price'] = 0; //借方金额
                $volo_data[1]['acsl_loan_subject'] = ''; //贷方科目
                $volo_data[1]['acsl_loan_subject_name'] = ''; //贷方科目名称
                $volo_data[1]['acsl_loan_price'] = 0; //贷方金额
            } elseif ($value->acset_type == 23) { //23.采购退货单,付款；借：应付账款 贷：银行存款
                $volo_data[0]['acsl_borrow_subject'] = '220202'; //借方科目
                $volo_data[0]['acsl_borrow_subject_name'] = '应付账款'; //借方科目名称
                $volo_data[0]['acsl_borrow_price'] = $value->acset_actual_price / 100; //借方金额
                $volo_data[0]['acsl_loan_subject'] = '1405'; //贷方科目
                $volo_data[0]['acsl_loan_subject_name'] = '库存商品'; //贷方科目名称
                $volo_data[0]['acsl_loan_price'] = $value->acset_actual_price / 100; //贷方金额
                $volo_data[1]['acsl_borrow_subject'] = ''; //借方科目
                $volo_data[1]['acsl_borrow_subject_name'] = ''; //借方科目名称
                $volo_data[1]['acsl_borrow_price'] = 0; //借方金额
                $volo_data[1]['acsl_loan_subject'] = ''; //贷方科目
                $volo_data[1]['acsl_loan_subject_name'] = ''; //贷方科目名称
                $volo_data[1]['acsl_loan_price'] = 0; //贷方金额
            } elseif ($value->acset_type == 25) { //批量结算,借:库存商品或银行存款,贷:应收账款
                // 若有抹零头的情况，抹零金额做冲减营业收入（例如应收505元，实际收500元，抹零5元，借：库存现金或银行存款500，贷：应收账款505，贷：主营业务收入-5）
                if ($value->acset_zero_price == '0') {
                    $volo_data[0]['acsl_borrow_subject'] = $find_acti_data->acti_subject_code; //借方科目
                    $volo_data[0]['acsl_borrow_subject_name'] = $find_acti_data->acti_course_title; //借方科目名称
                    $volo_data[0]['acsl_borrow_price'] = $value->acset_actual_price / 100; //借方金额
                    $volo_data[0]['acsl_loan_subject'] = '1122'; //贷方科目
                    $volo_data[0]['acsl_loan_subject_name'] = '应收账款'; //贷方科目名称
                    $volo_data[0]['acsl_loan_price'] = $value->acset_actual_price / 100; //贷方金额
                    $volo_data[1]['acsl_borrow_subject'] = ''; //借方科目
                    $volo_data[1]['acsl_borrow_subject_name'] = ''; //借方科目名称
                    $volo_data[1]['acsl_borrow_price'] = 0; //借方金额
                    $volo_data[1]['acsl_loan_subject'] = ''; //贷方科目
                    $volo_data[1]['acsl_loan_subject_name'] = ''; //贷方科目名称
                    $volo_data[1]['acsl_loan_price'] = 0; //贷方金额
                } else {
                    $volo_data[0]['acsl_borrow_subject'] = $find_acti_data->acti_subject_code; //借方科目
                    $volo_data[0]['acsl_borrow_subject_name'] = $find_acti_data->acti_course_title; //借方科目名称
                    $volo_data[0]['acsl_borrow_price'] = $value->acset_actual_price / 100; //借方金额
                    $volo_data[0]['acsl_loan_subject'] = ''; //贷方科目
                    $volo_data[0]['acsl_loan_subject_name'] = '应收金额'; //贷方科目名称
                    $volo_data[0]['acsl_loan_price'] = $value->acset_actual_price / 100; //贷方金额
                    $volo_data[1]['acsl_borrow_subject'] = ''; //借方科目
                    $volo_data[1]['acsl_borrow_subject_name'] = ''; //借方科目名称
                    $volo_data[1]['acsl_borrow_price'] = 0; //借方金额
                    $volo_data[1]['acsl_loan_subject'] = '6001'; //贷方科目
                    $volo_data[1]['acsl_loan_subject_name'] = '主营业务收入'; //贷方科目名称
                    $volo_data[1]['acsl_loan_price'] = '-' . $value->acset_zero_price / 100; //贷方金额
                }
            }

            $volo_data[0]['acsl_update_time'] = $value->acset_affirm_time; //更新时间
            $volo_data[1]['acsl_update_time'] = $value->acset_affirm_time; //更新时间
            $volo_id = DB::table('accounting_settlement_loan')->insert($volo_data);
            dump($volo_id);
            unset($volo_data);
            unset($volo_id);
        }
    }

    // 结款明细已确认,应收应付显示未确认
    public function accounting()
    {
        echo 55555;
        ignore_user_abort();
        set_time_limit(0);

        $find_acser_data = DB::table('accounting_settlement')
            ->where('acset_adm_cid', 1)
            ->where('acset_shop_id', 1)
            ->where('acset_state', 2)
            // ->whereIn('acset_type', [9, 12])//订单代收,工单代收
            // ->where('acset_type', 2)//订单账单
            ->where('acset_type', 5) //订单账单
            ->select('acset_adm_cid', 'acset_shop_id', 'acset_original_id', 'acset_original_number', 'acset_state')
            ->get()->toArray();
        foreach ($find_acser_data as $key => $value) {
            $find_recr_data = DB::table('receivable_credit')
                ->where('recr_cid', $value->acset_adm_cid)
                ->where('recr_shop_id', $value->acset_shop_id)
                ->where('recr_belongs_id', 0)
                ->where('recr_state', 1)
                ->where('recr_original_id', $value->acset_original_id)
                ->where('recr_original_number', $value->acset_original_number)
                // ->whereIn('recr_account_type', [2, 3])
                ->select('recr_original_id', 'recr_original_number')
                ->first();
            if ($find_recr_data) {
                dump($find_recr_data);
            }
        }
    }

    // 查询应收应付状态为已确认,欠收金额>0的数据
    public function receivable2()
    {
        ignore_user_abort();
        set_time_limit(0);

        $find_recr_data = DB::table('receivable_credit')
            ->where('recr_cid', 1)
            ->where('recr_shop_id', 1)
            ->where('recr_state', 2)
            ->where('recr_belongs_id', 0)
            ->whereIn('recr_account_type', [2, 3])
            ->where('recr_yet_receipt', 0)
            // ->where('recr_original_number', 'G2020102612443500074')
            ->select('recr_id', 'recr_cid', 'recr_shop_id', 'recr_type', 'recr_settle_price', 'recr_original_id', 'recr_original_number')
            ->get()->toArray();
        dump($find_recr_data);
        foreach ($find_recr_data as $key => $value) {
            dump($value);
            // 根据原始单id和单号,在结款明细表,查询出对应的单据的结款时间
            $acset_with_time = DB::table('accounting_settlement')
                ->where('acset_adm_cid', $value->recr_cid)
                ->where('acset_shop_id', $value->recr_shop_id)
                ->where('acset_state', 2)
                ->where('acset_original_id', $value->recr_original_id)
                ->where('acset_original_number', $value->recr_original_number)
                ->value('acset_with_time');
            $update_data['recr_yet_receipt'] = $value->recr_settle_price; //已收金额
            $update_data['recr_settle_time'] = $acset_with_time; //结款时间
            $update_res = DB::table('receivable_credit')
                ->where('recr_id', $value->recr_id)
                ->where('recr_belongs_id', 0)
                ->whereIn('recr_account_type', [2, 3])
                ->where('recr_yet_receipt', 0)
                ->update($update_data);
            dump($update_res);
            unset($update_data);
            unset($update_res);
        }
    }

    // 查询订单数据,调整结款明细客户单位id
    public function searchClient()
    {
        ignore_user_abort();
        set_time_limit(0);

        $date = date('Y-m-d H:i:s');

        $find_order_data = DB::table('order as ord')
            ->leftjoin('order_client as orcl', 'orcl.orcl_ord_id', '=', 'ord.ord_id')
            ->where('ord_cid', 1)
            ->where('ord_shop_id', 1)
            ->where('ord_delete', 1)
            ->select('ord_id', 'ord_order_number', 'ord_client_id', 'ord_type', 'orcl_channel_unit', 'orcl_name')
            ->get()->toArray();
        foreach ($find_order_data as $key => $value) {
            $find_acset_data = DB::table('accounting_settlement')
                ->where('acset_adm_cid', 1)
                ->where('acset_shop_id', 1)
                ->where('acset_original_id', $value->ord_id)
                ->where('acset_original_number', $value->ord_order_number)
                ->select('acset_client_type', 'acset_client_id')
                ->first();
            if ($find_acset_data) {
                // if ($find_acset_data->acset_client_id != $value->ord_client_id) {
                dump($value);
                $acset_data['acset_client_type'] = $value->ord_type;
                $acset_data['acset_client_id'] = $value->ord_client_id;
                // 根据id,查询单位名称
                if ($value->ord_type == 1) {
                    $acset_data['acset_client_name'] = $value->orcl_name;
                } elseif ($value->ord_type == 2) {
                    $chun_unit_name = DB::table('channel_unit')
                        ->where('chun_id', $value->ord_client_id)
                        ->where('chun_cid', 1)
                        ->where('chun_shop_id', 1)
                        ->where('chun_state', '!=', 3)
                        ->value('chun_unit_name');
                    $acset_data['acset_client_name'] = $chun_unit_name;
                } elseif ($value->ord_type == 3) {
                    $acset_data['acset_client_name'] = $value->orcl_channel_unit;
                }
                // $acset_data['acset_times'] = $date;
                $find_acset_data = DB::table('accounting_settlement')
                    ->where('acset_adm_cid', 1)
                    ->where('acset_shop_id', 1)
                    ->where('acset_original_id', $value->ord_id)
                    ->where('acset_original_number', $value->ord_order_number)
                    ->update($acset_data);
                dump($find_acset_data);
                unset($acset_data);
                unset($find_acset_data);
                // }
            }
        }
    }

    // 查询应收应付数据,调整开单时间
    public function receivable()
    {
        ignore_user_abort();
        set_time_limit(0);

        $find_recr_data = DB::table('receivable_credit')
            // ->where('recr_order_time', '0000-00-00 00:00:00')
            ->select('recr_id', 'recr_cid', 'recr_shop_id', 'recr_type', 'recr_original_id', 'recr_original_number')
            ->get()->toArray();
        foreach ($find_recr_data as $key => $value) {
            // dump($value);
            $initial = substr($value->recr_original_number, 0, 2);
            // dump($initial);
            if ($initial == 'D2') {
                // 根据原始id,和单号查询数据
                $ord_create_time = DB::table('order')
                    ->where('ord_id', $value->recr_original_id)
                    ->where('ord_order_number', $value->recr_original_number)
                    ->value('ord_create_time');
                $recr_data['recr_order_time'] = $ord_create_time;
                $recr_res = DB::table('receivable_credit')
                    ->where('recr_id', $value->recr_id)
                    ->update($recr_data);
                dump($recr_res);
                unset($recr_data);
                unset($recr_res);
            } elseif ($initial == 'G2') {
                // 根据原始id,和单号查询数据
                $ord_create_time = DB::table('work_order as wor')
                    ->leftjoin('order as ord', 'ord.ord_id', 'wor.wor_order_id')
                    ->where('wor_id', $value->recr_original_id)
                    ->where('wor_number', $value->recr_original_number)
                    ->value('ord_create_time');
                $recr_data['recr_order_time'] = $ord_create_time;
                $recr_res = DB::table('receivable_credit')
                    ->where('recr_id', $value->recr_id)
                    ->update($recr_data);
                dump($recr_res);
                unset($recr_data);
                unset($recr_res);
            } elseif ($initial == '31') {
                // 根据原始id,和单号查询数据
                $ord_create_time = DB::table('sell')
                    ->where('sell_id', $value->recr_original_id)
                    ->where('sell_number', $value->recr_original_number)
                    ->value('sell_create_time');
                $recr_data['recr_order_time'] = $ord_create_time;
                $recr_res = DB::table('receivable_credit')
                    ->where('recr_id', $value->recr_id)
                    ->update($recr_data);
                dump($recr_res);
                unset($recr_data);
                unset($recr_res);
            } elseif ($initial == 'JH') {
                // 根据原始单号,查询调拨单id
                $find_tror = DB::table('junk_recycle')
                    ->where('jur_id', $value->recr_original_id)
                    ->where('jur_number', $value->recr_original_number)
                    ->select('jur_id', 'jur_number', 'jur_wor_id', 'jur_wor_number', 'jur_ord_id', 'jur_ord_order_number', 'jur_type', 'jur_create_time')
                    ->first();
                if (!empty($find_tror)) {
                    if (!empty($find_tror->jur_wor_id)) {
                        $find_order = DB::table('work_order')
                            ->where('wor_id', $find_tror->jur_wor_id)
                            ->where('wor_number', $find_tror->jur_wor_number)
                            ->select('wor_order_id', 'wor_order_number', 'wor_type', 'wor_create_time')
                            ->first();
                        if (!empty($find_order)) {
                            $recr_data['recr_order_time'] = $find_order->wor_create_time;
                            $recr_res = DB::table('receivable_credit')
                                ->where('recr_id', $value->recr_id)
                                ->update($recr_data);
                            dump($recr_res);
                            unset($recr_data);
                            unset($recr_res);
                        }
                    } elseif (!empty($find_tror->jur_ord_id) && empty($find_tror->jur_wor_id)) {
                        $find_order = DB::table('order')
                            ->where('ord_id', $find_tror->jur_ord_id)
                            ->where('ord_order_number', $find_tror->jur_ord_order_number)
                            ->select('ord_id', 'ord_order_number', 'ord_type', 'ord_create_time')
                            ->first();
                        $recr_data['recr_order_time'] = $find_order->ord_create_time;
                        $recr_res = DB::table('receivable_credit')
                            ->where('recr_id', $value->recr_id)
                            ->update($recr_data);
                        dump($recr_res);
                        unset($recr_data);
                        unset($recr_res);
                    } else {
                        $recr_data['recr_order_time'] = $find_tror->jur_create_time;
                        $recr_res = DB::table('receivable_credit')
                            ->where('recr_id', $value->recr_id)
                            ->update($recr_data);
                        dump($recr_res);
                        unset($recr_data);
                        unset($recr_res);
                    }
                }
            } elseif ($initial == 'TH') {
                // 根据原始单号,查询调拨单id
                $find_tror = DB::table('recede_recycle')
                    ->where('rec_number', $value->recr_original_number)
                    ->select('rec_id', 'rec_number', 'rec_type', 'rec_ord_id', 'rec_ord_order_number', 'rec_create_time')
                    ->first();
                if (!empty($find_tror)) {
                    if (!empty($find_tror->rec_ord_id)) {
                        $find_order = DB::table('work_order as wor')
                            ->leftjoin('order as ord', 'ord.ord_id', '=', 'wor.wor_order_id')
                            ->where('wor_id', $find_tror->rec_ord_id)
                            ->where('wor_number', $find_tror->rec_ord_order_number)
                            ->select('wor_order_id', 'wor_order_number', 'ord_create_time')
                            ->first();
                        if (!empty($find_order)) {
                            $recr_data['recr_order_time'] = $find_order->ord_create_time;
                            $recr_res = DB::table('receivable_credit')
                                ->where('recr_id', $value->recr_id)
                                ->update($recr_data);
                            dump($recr_res);
                            unset($recr_data);
                            unset($recr_res);
                        }
                    } else {
                        $recr_data['recr_order_time'] = $find_tror->rec_create_time;
                        $recr_res = DB::table('receivable_credit')
                            ->where('recr_id', $value->recr_id)
                            ->update($recr_data);
                        dump($recr_res);
                        unset($recr_data);
                        unset($recr_res);
                    }
                }
            } elseif ($initial == 'RK') {
                // 根据原始单号,查询调拨单id
                $find_order = DB::table('ware_inorder')
                    ->where('rk_number', $value->recr_original_number)
                    ->select('cg_number')
                    ->first();
                if (!empty($find_order)) {
                    $find_pur = DB::table('purchase_order')
                        ->where('cg_number', $find_order->cg_number)
                        ->select('cg_id', 'cg_number', 'create_time')
                        ->first();
                    if (!empty($find_pur)) {
                        $recr_data['recr_order_time'] = $find_pur->create_time;
                        $recr_res = DB::table('receivable_credit')
                            ->where('recr_id', $value->recr_id)
                            ->update($recr_data);
                        dump($recr_res);
                        unset($recr_data);
                        unset($recr_res);
                    }
                }
            } elseif ($initial == 'DZ') {
                // 根据原始单号,查询调拨单id
                $orbi_create_time = DB::table('order_bill')
                    ->where('orbi_id', $value->recr_original_id)
                    ->where('orbi_number', $value->recr_original_number)
                    ->value('orbi_create_time');

                $recr_data['recr_order_time'] = $orbi_create_time;
                $recr_res = DB::table('receivable_credit')
                    ->where('recr_id', $value->recr_id)
                    ->update($recr_data);
                dump($recr_res);
                unset($recr_data);
                unset($recr_res);
            } elseif ($initial == 'GZ') {
                // 根据原始单号,查询调拨单id
                $orbi_create_time = DB::table('order_bill')
                    ->where('orbi_id', $value->recr_original_id)
                    ->where('orbi_number', $value->recr_original_number)
                    ->value('orbi_create_time');

                $recr_data['recr_order_time'] = $orbi_create_time;
                $recr_res = DB::table('receivable_credit')
                    ->where('recr_id', $value->recr_id)
                    ->update($recr_data);
                dump($recr_res);
                unset($recr_data);
                unset($recr_res);
            }
        }
    }

    // 查询旧货回收
    public function recycle()
    {
        ignore_user_abort();
        set_time_limit(0);
        $find_junk_recycle = DB::table('junk_recycle as jur')
            ->leftjoin('junk_client as jucl', 'jucl.jucl_jur_id', 'jur.jur_id')
            ->where('jur_cid', 1)
            ->where('jur_shop_id', 1)
            ->where('jur_wor_id', 0)
            ->where('jur_ord_id', 0)
            ->where('jur_ord_order_number', '')
            ->where('jur_add_type', 3)
            ->select('jur_id', 'jur_number', 'jur_wor_id', 'jur_wor_number', 'jur_ord_id', 'jur_ord_order_number', 'jur_create_time', 'jucl_client_id', 'jur_type', 'jucl_channel_unit', 'jucl_name', 'jur_price', 'jur_create_adm_id', 'jur_remark')
            ->get()->toArray();
        // dump($find_junk_recycle);
        foreach ($find_junk_recycle as $key => $value) {
            // dump($value);
            // 根据旧货id和单号查询,是否有对应的应收应付和结款明细
            $find_recr_data = DB::table('receivable_credit')
                ->where('recr_cid', 1)
                ->where('recr_shop_id', 1)
                ->where('recr_original_id', $value->jur_id)
                ->where('recr_original_number', $value->jur_number)
                ->first();
            // dump($find_recr_data);
            if (empty($find_recr_data)) {
                // dump($value);
                $recr_data['recr_cid'] = 1;
                $recr_data['recr_shop_id'] = 1;
                $recr_data['recr_shop_superior_id'] = 1;
                $recr_data['recr_type'] = 13;
                $recr_data['recr_account_type'] = 16;
                $recr_data['recr_number_id'] = 0;
                $recr_data['recr_original_id'] = $value->jur_id;
                $recr_data['recr_original_number'] = $value->jur_number;
                $recr_data['recr_client_type'] = $value->jur_type;
                $recr_data['recr_client_id'] = $value->jucl_client_id;
                if ($value->jur_type == 1) {
                    $recr_data['recr_client_type'] = $value->jucl_name;
                } elseif ($value->jur_type == 2) {
                    $recr_data['recr_client_type'] = $value->jucl_channel_unit;
                }
                $recr_data['recr_settle_price'] = $value->jur_price;
                $recr_data['recr_settle_time'] = 1;
                $recr_data['recr_settle_id'] = $value->jur_create_adm_id; //结款人
                $recr_data['recr_acti_id'] = 0;
                $recr_data['recr_actual_price'] = $value->jur_price;
                $recr_data['recr_zero_price'] = 0;
                $recr_data['recr_yet_receipt'] = $value->jur_price;
                $recr_data['recr_plus_minus'] = 2;
                $recr_data['recr_belongs_id'] = 0;
                $recr_data['recr_state'] = 1;
                $recr_data['recr_statistics_type'] = 1;
                $recr_data['recr_leisurely_type'] = 0;
                $recr_data['recr_remark'] = $value->jur_remark;
                $recr_data['recr_create_time'] = $value->jur_create_time;
            }
            if ($find_recr_data) {
                dump($value);
                echo 1;
                $find_acset_data = DB::table('accounting_settlement')
                    ->where('acset_adm_cid', 1)
                    ->where('acset_shop_id', 1)
                    ->where('acset_original_id', $value->jur_id)
                    ->where('acset_original_number', $value->jur_number)
                    ->select('acset_id')
                    ->first();
                dump($find_acset_data);
                if (empty($find_acset_data)) {
                    echo 2;
                    $acset_data['acset_adm_cid'] = 1;
                    $acset_data['acset_shop_id'] = 1;
                    $acset_data['acset_superior_shop_id'] = 1;
                    $acset_data['acset_number'] = 'JK' . rand(100, 999) . time() . rand(10000, 99999);
                    $acset_data['acset_type'] = 19;
                    $acset_data['acset_payment_type'] = 0;
                    $acset_data['acset_state'] = $find_recr_data->recr_state;
                    $acset_data['acset_original_id'] = $value->jur_id;
                    $acset_data['acset_original_number'] = $value->jur_number;
                    $acset_data['acset_client_type'] = $value->jur_type;
                    $acset_data['acset_client_id'] = $value->jucl_client_id;
                    if ($value->jur_type == 1) {
                        $acset_data['acset_client_name'] = $value->jucl_name;
                    } elseif ($value->jur_type == 2) {
                        $acset_data['acset_client_name'] = $value->jucl_channel_unit;
                    }
                    $acset_data['acset_with_time'] = $find_recr_data->recr_create_time;
                    $acset_data['acset_adm_id'] = $value->jur_create_adm_id;
                    $acset_data['acset_acti_id'] = $find_recr_data->recr_acti_id;
                    $acset_data['acset_inex_type'] = 2;
                    $acset_data['acset_actual_price'] = $value->jur_price;
                    $acset_data['acset_price'] = $value->jur_price;
                    $acset_data['acset_owe_price'] = 0;
                    $acset_data['acset_zero_price'] = 0;
                    $acset_data['acset_remark'] = $value->jur_remark;
                    $acset_data['acset_remit_time'] = $find_recr_data->recr_abort_time;
                    $acset_data['acset_create_time'] = $find_recr_data->recr_create_time;
                    $acset_data['acset_update_time'] = $find_recr_data->recr_update_time;
                    $acset_data['acset_merge_type'] = 1;
                    $acset_data['acset_affirm_time'] = $find_recr_data->recr_update_time;
                    $acset_data['acset_zero_plus_minus'] = 2;
                    // $acset_id = DB::table('accounting_settlement')->insert($acset_data);
                    // dump($acset_id);
                    // unset($acset_data);
                    // unset($acset_id);
                }
            }
        }
    }

    // 出入库记录关联单的单号相关字段更新
    public function outins()
    {
        echo 00;
        ignore_user_abort();
        set_time_limit(0);
        $find_data = DB::table('outin_record')
            ->where('oure_original_correlation_id', 0)
            // ->where('oure_original_correlation_type', 6)
            ->select('oure_id', 'oure_number', 'oure_original_number', 'oure_type', 'oure_cid', 'oure_shop_id')
            ->get()->toArray();
        foreach ($find_data as $key => $value) {
            $date = date('Y-m-d H:i:s');
            $initial = substr($value->oure_original_number, 0, 2);
            // dump($initial);
            // exit;
            if ($initial == 'FH') {
                // 根据原始单号,查询调拨单id
                $find_tror = DB::table('dispatch_bill')
                    ->where('dego_number', $value->oure_original_number)
                    ->select('dego_id', 'dego_order_type', 'dego_original_number', 'dego_wor_id', 'dego_client_type', 'dego_client_id')
                    ->first();
                if (!empty($find_tror)) {
                    if ($find_tror->dego_order_type == 1) { //订单发货
                        $find_order = DB::table('order')
                            ->where('ord_id', $find_tror->dego_wor_id)
                            ->where('ord_order_number', $find_tror->dego_original_number)
                            ->select('ord_id', 'ord_order_number', 'ord_type', 'ord_client_id')
                            ->first();
                        if (!empty($find_order)) {
                            $oure_data['oure_original_correlation_id'] = $find_order->ord_id;
                            $oure_data['oure_original_correlation_number'] = $find_order->ord_order_number;
                            $oure_data['oure_original_correlation_type'] = 1;
                            $oure_data['oure_client_type'] = $find_order->ord_type;
                            $oure_data['oure_client_id'] = $find_order->ord_client_id;
                            $oure_data['oure_times'] = $date;
                            $oure_res = DB::table('outin_record')
                                ->where('oure_id', $value->oure_id)
                                ->update($oure_data);
                            dump($oure_res);
                            unset($oure_data);
                        }
                    } elseif ($find_tror->dego_order_type == 2) { //工单发货
                        $find_order = DB::table('work_order as wor')
                            ->leftjoin('work_client as wocl', 'wocl.wocl_wor_id', '=', 'wor.wor_id')
                            ->where('wor_id', $find_tror->dego_wor_id)
                            ->where('wor_number', $find_tror->dego_original_number)
                            ->select('wor_order_id', 'wor_order_number', 'wor_type', 'wocl_client_id')
                            ->first();
                        if (!empty($find_order)) {
                            $oure_data['oure_original_correlation_id'] = $find_order->wor_order_id;
                            $oure_data['oure_original_correlation_number'] = $find_order->wor_order_number;
                            $oure_data['oure_original_correlation_type'] = 1;
                            $oure_data['oure_client_type'] = $find_order->wor_type;
                            $oure_data['oure_client_id'] = $find_order->wocl_client_id;
                            $oure_data['oure_times'] = $date;
                            $oure_res = DB::table('outin_record')
                                ->where('oure_id', $value->oure_id)
                                ->update($oure_data);
                            dump($oure_res);
                            unset($oure_data);
                        }
                    }
                }
            } elseif ($initial == 'DB') {
                // 根据原始单号,查询调拨单id
                $find_tror = DB::table('transferring_order')
                    ->where('tror_number', $value->oure_original_number)
                    ->select('tror_id', 'tror_number')
                    ->first();
                if (!empty($find_tror)) {
                    $oure_data['oure_original_correlation_id'] = $find_tror->tror_id;
                    $oure_data['oure_original_correlation_number'] = $find_tror->tror_number;
                    $oure_data['oure_original_correlation_type'] = 2;
                    $oure_data['oure_client_type'] = 0;
                    $oure_data['oure_client_id'] = 0;
                    $oure_data['oure_times'] = $date;
                    $oure_res = DB::table('outin_record')
                        ->where('oure_id', $value->oure_id)
                        ->update($oure_data);
                    dump($oure_res);
                    unset($oure_data);
                }
            } elseif ($initial == 'CG') {
                $find_pur = DB::table('purchase_order')
                    ->where('cg_number', $value->oure_original_number)
                    ->select('cg_id', 'cg_number', 'cg_supplyunit')
                    ->first();
                if (!empty($find_pur)) {
                    $oure_data['oure_original_correlation_id'] = $find_pur->cg_id;
                    $oure_data['oure_original_correlation_number'] = $find_pur->cg_number;
                    $oure_data['oure_original_correlation_type'] = 3;
                    $oure_data['oure_client_type'] = 3;
                    $oure_data['oure_client_id'] = $find_pur->cg_supplyunit;
                    $oure_data['oure_times'] = $date;
                    $oure_res = DB::table('outin_record')
                        ->where('oure_id', $value->oure_id)
                        ->update($oure_data);
                    dump($oure_res);
                    unset($oure_data);
                }
            } elseif ($initial == '31') {
                // 根据原始单号,查询调拨单id
                $find_tror = DB::table('sell')
                    ->where('sell_number', $value->oure_original_number)
                    ->select('sell_id', 'sell_number', 'sell_chun_id')
                    ->first();
                if (!empty($find_tror)) {
                    $oure_data['oure_original_correlation_id'] = $find_tror->sell_id;
                    $oure_data['oure_original_correlation_number'] = $find_tror->sell_number;
                    $oure_data['oure_original_correlation_type'] = 4;
                    $oure_data['oure_client_type'] = 2;
                    $oure_data['oure_client_id'] = $find_tror->sell_chun_id;
                    $oure_data['oure_times'] = $date;
                    $oure_res = DB::table('outin_record')
                        ->where('oure_id', $value->oure_id)
                        ->update($oure_data);
                    dump($oure_res);
                    unset($oure_data);
                }
            } elseif ($initial == 'JH') {
                // 根据原始单号,查询调拨单id
                $find_tror = DB::table('junk_recycle as jur')
                    ->leftjoin('junk_client as jucl', 'jucl.jucl_jur_id', '=', 'jur.jur_id')
                    ->where('jur_number', $value->oure_original_number)
                    ->select('jur_id', 'jur_number', 'jur_wor_id', 'jur_wor_number', 'jur_ord_id', 'jur_ord_order_number', 'jur_type', 'jucl_client_id')
                    ->first();
                if (!empty($find_tror)) {
                    if (!empty($find_tror->jur_wor_id)) {
                        $find_order = DB::table('work_order as wor')
                            ->leftjoin('work_client as wocl', 'wocl.wocl_wor_id', '=', 'wor.wor_id')
                            ->where('wor_id', $find_tror->jur_wor_id)
                            ->where('wor_number', $find_tror->jur_wor_number)
                            ->select('wor_order_id', 'wor_order_number', 'wor_type', 'wocl_client_id')
                            ->first();
                        if (!empty($find_order)) {
                            $oure_data['oure_original_correlation_id'] = $find_order->wor_order_id;
                            $oure_data['oure_original_correlation_number'] = $find_order->wor_order_number;
                            $oure_data['oure_original_correlation_type'] = 1;
                            $oure_data['oure_client_type'] = $find_order->wor_type;
                            $oure_data['oure_client_id'] = $find_order->wocl_client_id;
                            $oure_data['oure_times'] = $date;
                            $oure_res = DB::table('outin_record')
                                ->where('oure_id', $value->oure_id)
                                ->update($oure_data);
                            dump($oure_res);
                            unset($oure_data);
                        }
                    } elseif (!empty($find_tror->jur_ord_id) && empty($find_tror->jur_wor_id)) {
                        $find_order = DB::table('order')
                            ->where('ord_id', $find_tror->jur_ord_id)
                            ->where('ord_order_number', $find_tror->jur_ord_order_number)
                            ->select('ord_id', 'ord_order_number', 'ord_type', 'ord_client_id')
                            ->first();
                        $oure_data['oure_original_correlation_id'] = $find_order->ord_id;
                        $oure_data['oure_original_correlation_number'] = $find_order->ord_order_number;
                        $oure_data['oure_original_correlation_type'] = 1;
                        $oure_data['oure_client_type'] = $find_order->ord_type;
                        $oure_data['oure_client_id'] = $find_order->ord_client_id;
                        $oure_data['oure_times'] = $date;
                        $oure_res = DB::table('outin_record')
                            ->where('oure_id', $value->oure_id)
                            ->update($oure_data);
                        dump($oure_res);
                        unset($oure_data);
                    } else {
                        $oure_data['oure_original_correlation_id'] = $find_tror->jur_id;
                        $oure_data['oure_original_correlation_number'] = $find_tror->jur_number;
                        $oure_data['oure_original_correlation_type'] = 5;
                        $oure_data['oure_client_type'] = $find_tror->jur_type;
                        $oure_data['oure_client_id'] = $find_tror->jucl_client_id;
                        $oure_data['oure_times'] = $date;
                        $oure_res = DB::table('outin_record')
                            ->where('oure_id', $value->oure_id)
                            ->update($oure_data);
                        dump($oure_res);
                        unset($oure_data);
                    }
                }
            } elseif ($initial == 'TH') {
                // 根据原始单号,查询调拨单id
                $find_tror = DB::table('recede_recycle as rec')
                    ->leftjoin('recede_client as recl', 'recl.recl_rec_id', 'rec.rec_id')
                    ->where('rec_number', $value->oure_original_number)
                    ->select('rec_id', 'rec_number', 'rec_type', 'recl_client_id', 'rec_ord_id', 'rec_ord_order_number')
                    ->first();
                if (!empty($find_tror)) {
                    if (!empty($find_tror->rec_ord_id)) {
                        $find_order = DB::table('work_order as wor')
                            ->leftjoin('work_client as wocl', 'wocl.wocl_wor_id', '=', 'wor.wor_id')
                            ->where('wor_id', $find_tror->rec_ord_id)
                            ->where('wor_number', $find_tror->rec_ord_order_number)
                            ->select('wor_order_id', 'wor_order_number', 'wor_type', 'wocl_client_id')
                            ->first();
                        if (!empty($find_order)) {
                            $oure_data['oure_original_correlation_id'] = $find_order->wor_order_id;
                            $oure_data['oure_original_correlation_number'] = $find_order->wor_order_number;
                            $oure_data['oure_original_correlation_type'] = 1;
                            $oure_data['oure_client_type'] = $find_order->wor_type;
                            $oure_data['oure_client_id'] = $find_order->wocl_client_id;
                            $oure_data['oure_times'] = $date;
                            $oure_res = DB::table('outin_record')
                                ->where('oure_id', $value->oure_id)
                                ->update($oure_data);
                            dump($oure_res);
                            unset($oure_data);
                        }
                    } else {
                        $oure_data['oure_original_correlation_id'] = $find_tror->rec_id;
                        $oure_data['oure_original_correlation_number'] = $find_tror->rec_number;
                        $oure_data['oure_original_correlation_type'] = 6;
                        $oure_data['oure_client_type'] = $find_tror->rec_type;
                        $oure_data['oure_client_id'] = $find_tror->recl_client_id;
                        $oure_data['oure_times'] = $date;
                        $oure_res = DB::table('outin_record')
                            ->where('oure_id', $value->oure_id)
                            ->update($oure_data);
                        dump($oure_res);
                        unset($oure_data);
                    }
                }
            } elseif ($initial == 'G2') {
                // 根据原始单号,查询调拨单id
                $find_order = DB::table('work_order as wor')
                    ->leftjoin('work_client as wocl', 'wocl.wocl_wor_id', '=', 'wor.wor_id')
                    ->where('wor_number', $value->oure_original_number)
                    ->select('wor_order_id', 'wor_order_number', 'wor_type', 'wocl_client_id')
                    ->first();
                if (!empty($find_order)) {
                    $oure_data['oure_original_correlation_id'] = $find_order->wor_order_id;
                    $oure_data['oure_original_correlation_number'] = $find_order->wor_order_number;
                    $oure_data['oure_original_correlation_type'] = 1;
                    $oure_data['oure_client_type'] = $find_order->wor_type;
                    $oure_data['oure_client_id'] = $find_order->wocl_client_id;
                    $oure_data['oure_times'] = $date;
                    $oure_res = DB::table('outin_record')
                        ->where('oure_id', $value->oure_id)
                        ->update($oure_data);
                    dump($oure_res);
                    unset($oure_data);
                }
            } elseif ($initial == 'RK') {
                // 根据原始单号,查询调拨单id
                $find_order = DB::table('ware_inorder')
                    ->where('rk_number', $value->oure_original_number)
                    ->select('cg_number')
                    ->first();
                if (!empty($find_order)) {
                    $find_pur = DB::table('purchase_order')
                        ->where('cg_number', $find_order->cg_number)
                        ->select('cg_id', 'cg_number', 'cg_supplyunit')
                        ->first();
                    if (!empty($find_pur)) {
                        $oure_data['oure_original_correlation_id'] = $find_pur->cg_id;
                        $oure_data['oure_original_correlation_number'] = $find_pur->cg_number;
                        $oure_data['oure_original_correlation_type'] = 3;
                        $oure_data['oure_client_type'] = 3;
                        $oure_data['oure_client_id'] = $find_pur->cg_supplyunit;
                        $oure_data['oure_times'] = $date;
                        $oure_res = DB::table('outin_record')
                            ->where('oure_id', $value->oure_id)
                            ->update($oure_data);
                        dump($oure_res);
                        unset($oure_data);
                    }
                }
            }
        }
        echo 888888;
    }

    // 查询工单完成已通过的单子
    public function workOrders()
    {
        ignore_user_abort();
        set_time_limit(0);

        // 查询应收应付,已确认的单子
        $find_data = DB::table('receivable_credit')
            ->where('recr_cid', 1)
            ->where('recr_shop_id', 1)
            ->where('recr_state', 2)
            ->where('recr_statistics_type', 1)
            ->where('recr_settle_price', '!=', 0)
            ->select('recr_id', 'recr_original_number', 'recr_settle_price', 'recr_actual_price', 'recr_yet_receipt')
            ->get()->toArray();
        foreach ($find_data as $key => $value) {
            if ($value->recr_yet_receipt == 0) {
                dump($value);
                $update_data['recr_yet_receipt'] = $value->recr_settle_price;
                $res = DB::table('receivable_credit')
                    ->where('recr_id', $value->recr_id)
                    ->update($update_data);
                dump($res);
                unset($update_data);
                unset($res);
            }
        }

        // 查询救援单,服务项目金额不为0
        /* $find_data = DB::table('order as ord')
            ->leftjoin('order_client as orcl', 'orcl.orcl_ord_id', '=', 'ord.ord_id')
            ->where('ord_cid', 1)
            ->where('ord_superior_shop_id', 1)
            ->where('ord_shop_id', 1)
            ->where('ord_service_type', 7)
            ->where('ord_delete', 1)
            ->where('ord_collection_bill', 1)
            ->where('orcl_rescue_service_price', '!=', 0)
            ->select('ord_id', 'ord_order_number', 'ord_order_price', 'ord_actual_price', 'orcl_rescue_service_price')
            ->get()->toArray();
        foreach ($find_data as $key => $value) {
            if ($value->ord_actual_price == '0') {
                dump($value);
            }
        } */

        /* $find_data = DB::table('work_order')
            ->where('wor_cid', 1)
            ->where('wor_shop_id', 1)
            ->where('wor_state', 10)
            ->where('wor_delete', 1)
            ->where('wor_collection_bill', 1)
            ->select('wor_id', 'wor_number', 'wor_order_id', 'wor_order_number')
            ->get()->toArray();
        foreach ($find_data as $key => $value) {
            $find_order_data = DB::table('order')
                ->where('ord_id', $value->wor_order_id)
                ->where('ord_order_number', $value->wor_order_number)
                ->where('ord_wor_state', 2)
                ->value('ord_order_number');
            dump($find_order_data);
        } */
    }

    // 查询退货单商品
    public function recedeRecycle()
    {
        $find_data = DB::table('recede_goods as rego')
            ->leftjoin('recede_recycle as rec', 'rec.rec_id', '=', 'rego.rego_rec_id')
            ->where('rec_cid', 1)
            ->where('rec_shop_id', 1)
            ->where('rec_number', 'TH958091114093549112')
            ->select('rego_ware_id', 'rego_waon_class', 'rego_wago_id', 'rego_goo_id', 'rego_goo_name', 'rego_goo_goods_encode', 'rego_goo_price', 'rego_recycle_number', 'rego_goo_inventory', 'rego_fine_quantity', 'rec_ord_id', 'rec_ord_order_number', 'rec_amount', 'rego_create_time', 'rego_update_time', 'rec_ware_id', 'rec_waon_class')
            ->get()->toArray();
        foreach ($find_data as $key => $value) {
            dump($value);
            $wogo_data['wogo_wor_id'] = $value->rec_ord_id; //工单id
            $wogo_data['wogo_ware_id'] = $value->rec_ware_id; //仓库id
            $wogo_data['wogo_waon_class'] = $value->rec_waon_class; //仓库类别
            $wogo_data['wogo_goo_id'] = $value->rego_goo_id; //商品id
            $wogo_data['wogo_is_recycle'] = 2; //1回收2不回收
            $wogo_data['wogo_goo_name'] = $value->rego_goo_name; //商品名称
            $wogo_data['wogo_goo_goods_encode'] = $value->rego_goo_goods_encode; //商品编号
            $wogo_data['wogo_goo_price'] = $value->rego_goo_price; //商品售价（单位：分）
            $wogo_data['wogo_goo_amount'] = $value->rego_recycle_number; //可派单商品数量
            $wogo_data['wogo_goo_inventory'] = $value->rego_goo_inventory; //库存扣除方式1.良品 2.优先
            $wogo_data['wogo_update_time'] = $value->rego_create_time; //更新时间
            dump($wogo_data);
            $wogo_id = DB::table('work_good')->insert($wogo_data);
            // 根据工单id,查询对应的订单id和订单编号
            $find_order_data = DB::table('work_order')
                ->where('wor_id', $value->rec_ord_id)
                ->select('wor_order_id', 'wor_order_number')
                ->first();
            $orgo_data['orgo_ord_id'] = $find_order_data->wor_order_id;
            $orgo_data['orgo_order_number'] = $find_order_data->wor_order_number;
            $orgo_data['orgo_ware_id'] = $value->rec_ware_id; //仓库id
            $orgo_data['orgo_waon_class'] = $value->rec_waon_class; //仓库类别
            $orgo_data['orgo_goo_id'] = $value->rego_goo_id; //商品id
            $orgo_data['orgo_goo_name'] = $value->rego_goo_name; //商品名称
            $orgo_data['orgo_goo_goods_encode'] = $value->rego_goo_goods_encode; //商品编号
            $orgo_data['orgo_goo_price'] = $value->rego_goo_price; //商品售价（单位：分）
            $orgo_data['orgo_goo_quantity'] = $value->rego_recycle_number; //订单商品数量
            $orgo_data['orgo_goo_inventory'] = $value->rego_goo_inventory; //订单商品数量
            $orgo_data['orgo_is_recycle'] = 2; //订单商品数量
            $orgo_data['orgo_update_time'] = $value->rego_create_time; //订单商品数量
            dump($orgo_data);
            $orgo_id = DB::table('order_goods')->insert($orgo_data);
            unset($wogo_data);
            unset($wogo_id);
            unset($orgo_data);
            unset($orgo_id);
        }

        $oure_data['oure_cid'] = 1;
        $oure_data['oure_superior_shop_id'] = 1;
        $oure_data['oure_shop_id'] = 1;
        $oure_data['oure_number'] = '159982493381749';
        $oure_data['oure_original_correlation_id'] = 131;
        $oure_data['oure_original_correlation_number'] = 'TH958091114093549112';
        $oure_data['oure_original_correlation_type'] = 6;
        $oure_data['oure_client_type'] = 2;
        $oure_data['oure_client_id'] = 8411;
        $oure_data['oure_original_number'] = 'TH958091114093549112';
        $oure_data['oure_type'] = 13;
        $oure_data['oure_count'] = 1;
        $oure_data['oure_all_stock'] = 1;
        $oure_data['oure_lock_quantity'] = 0;
        $oure_data['oure_priority_all_stock'] = 0;
        $oure_data['oure_priority_lock_quantity'] = 0;
        $oure_data['oure_unchecked_all_stock'] = 0;
        $oure_data['oure_out_ware_id'] = 25;
        $oure_data['oure_in_ware_id'] = 0;
        $oure_data['oure_waon_class'] = 1;
        $oure_data['oure_adm_id'] = 126;
        $oure_data['oure_out_in_type'] = 1;
        $oure_data['oure_create_time'] = '2020-09-11 19:48:53';
        $oure_data['oure_update_time'] = '2020-09-11 19:48:53';
        $oure_data['oure_operation_type'] = 3;
        $oure_id = DB::table('outin_record')->insertGetId($oure_data);
        $oude_data['oude_oure_id'] = $oure_id;
        $oude_data['oude_goo_id'] = 3269;
        $oude_data['oude_goo_number'] = '03215';
        $oude_data['oude_type'] = 1;
        $oude_data['oude_update_time'] = '2020-09-11 19:48:53';
        $oude_id = DB::table('outin_details')->insert($oude_data);
        unset($oure_data);
        unset($oure_id);
        unset($oude_data);
        unset($oude_id);
    }

    // 查询旧货回收绑定订单的
    public function recycleOrder()
    {
        ignore_user_abort();
        set_time_limit(0);
        $find_junk_recycle = DB::table('junk_goods as jugo')
            ->leftjoin('junk_recycle as jur', 'jugo.jugo_jur_id', '=', 'jur.jur_id')
            ->select('jur_id', 'jur_number', 'jur_wor_id', 'jur_wor_number', 'jur_ord_id', 'jur_ord_order_number', 'jugo_jur_id', 'jugo_goo_id', 'jugo_orgo_id', 'jugo_wogo_id')
            ->get()->toArray();
        foreach ($find_junk_recycle as $key => $value) {
            dump($value);
            // 根据订单id,查询订单商品主键id
            $orgo_id = DB::table('order_goods')
                ->where('orgo_ord_id', $value->jur_ord_id)
                ->where('orgo_state', 3)
                ->where('orgo_goo_id', $value->jugo_goo_id)
                ->value('orgo_id');
            dump($orgo_id);
            $wogo_id = DB::table('work_good')
                ->where('wogo_wor_id', $value->jur_wor_id)
                ->where('wogo_state', 3)
                ->where('wogo_goo_id', $value->jugo_goo_id)
                ->value('wogo_id');
            dump($orgo_id);
            $date = date('Y-m-d H:i:s');
            $junk_data['jugo_orgo_id'] = $orgo_id;
            $junk_data['jugo_wogo_id'] = $wogo_id;
            $junk_data['jugo_update_time'] = $date;
            $res = DB::table('junk_goods')
                ->where('jugo_jur_id', $value->jur_id)
                ->update($junk_data);
            dump($res);
            unset($junk_data);
        }
    }

    // 查询救援单订单服务项目有金额,工单没有金额
    public function searchService()
    {
        $find_order_data = DB::table('order as ord')
            ->leftjoin('order_client as orcl', 'orcl.orcl_ord_id', '=', 'ord.ord_id')
            ->leftjoin('work_order as wor', 'wor.wor_order_id', '=', 'ord.ord_id')
            ->leftjoin('work_client as wocl', 'wocl.wocl_wor_id', '=', 'wor.wor_id')
            ->where('ord_cid', 1)
            ->where('ord_superior_shop_id', 1)
            ->where('ord_shop_id', 1)
            ->where('ord_service_type', 7)
            ->where('ord_delete', 1)
            ->where('ord_collection_bill', 1) //是否代收账单：1正常订单2代收账单
            ->where('wor_delete', 1)
            ->where('wor_state', '!=', 11)
            ->select('ord_id', 'ord_order_number', 'orcl_rescue_service_price', 'wor_id', 'wor_number', 'wocl_rescue_service_price')
            ->get()->toArray();
        foreach ($find_order_data as $key => $value) {
            if ($value->orcl_rescue_service_price != '0' && $value->wocl_rescue_service_price == '0') {
                dump($value);
            }
        }
    }

    // 查询锁定库存商品对应的订单
    public function lockGoodsOrder($request)
    {
        // 仓库id，商品id
        dump($request);
        $find_order_data = DB::table('order_goods as og')
            ->leftjoin('order as o', 'o.ord_id', '=', 'og.orgo_ord_id')
            // ->leftjoin('warehouse_goods as wg', 'o.ord_id', '=', 'og.orgo_ord_id')
            ->where('ord_cid', 1)
            ->where('ord_shop_id', 1)
            ->whereIn('ord_wor_state', [2, 5])
            ->where('ord_delete', 1)
            ->where('ord_ware_id', $request['ware_id'])
            ->where('orgo_goo_id', $request['goo_id'])
            ->select(
                'ord_order_number',
                'ord_wor_state',
                'ord_service_type',
                'ord_type',
                'orgo_goo_name',
                'orgo_goo_goods_encode',
                'orgo_goo_quantity',
                'orgo_state',
                'orgo_goo_type'
            )
            ->get()->toArray();
        dump($find_order_data);
    }

    // 正常商品导入
    public function normal()
    {
        ignore_user_abort();
        set_time_limit(0);

        // 业务划区下各品牌的销售数量（不包含铺货的）
        $list_data = DB::table('order_goods as og')
            ->leftJoin('order as o', 'o.ord_id', '=', 'og.orgo_ord_id')
            ->leftJoin('order_client as oc', 'o.ord_id', '=', 'oc.orcl_ord_id')
            ->leftJoin('channel_info as cu', 'cu.chin_chun_id', '=', 'o.ord_client_id')
            ->leftJoin('admin as a', 'a.adm_id', '=', 'o.ord_create_id')
            ->leftJoin('goods as g', 'g.goo_id', '=', 'og.orgo_goo_id')
            ->leftJoin('order_label as ol', 'ol.orla_id', '=', 'o.ord_orla_id')
            ->where('ord_cid', 1)
            ->where('ord_superior_shop_id', 1)
            ->where('ord_delete', 1)
            ->where('goo_cate_name', '启动电池')
            ->where('ord_collection_bill', 1) //是否代收账单：1正常订单2代收账单
            ->where('ord_service_type', '<>', 4)
            ->whereNotIn('orgo_state', [3, 4])
            ->where('ord_create_time', 'like', '%' . $this->date . '%')
            ->select('ord_order_number', 'adm_name', 'ord_type', 'orcl_channel_unit', 'chin_zoning', 'orcl_name', 'orla_name as orcl_chin_type', 'goo_bra_name', 'orgo_state', 'orgo_goo_name', 'orgo_goo_goods_encode', 'orgo_goo_type', 'orgo_goo_price', 'orgo_goo_quantity')
            ->get();
        foreach ($list_data as $key => $value) {
            dump($value);
            $sedt_data['ord_order_number'] = $value->ord_order_number; //订单号
            $sedt_data['adm_name'] = $value->adm_name; //录单人
            $sedt_data['ord_type'] = $value->ord_type; //买家类型：1门店零售2渠道单位3速电派单4第三方派单
            $sedt_data['orcl_channel_unit'] = $value->orcl_channel_unit; //客户单位
            $sedt_data['chin_zoning'] = $value->chin_zoning; //业务划区
            $sedt_data['orcl_name'] = $value->orcl_name; //姓名
            $sedt_data['orcl_chin_type'] = $value->orcl_chin_type; //铺货类型：1是铺货 2不是铺货
            $sedt_data['goo_bra_name'] = $value->goo_bra_name; //品牌名称
            $sedt_data['orgo_state'] = $value->orgo_state; //商品状态1.正常 2.删除3回收的商品4换货商品5赠品商品6备用电池7临时商品8旧货商品
            $sedt_data['orgo_goo_name'] = $value->orgo_goo_name; //商品名称
            $sedt_data['orgo_goo_goods_encode'] = $value->orgo_goo_goods_encode; //商品编号
            $sedt_data['orgo_goo_type'] = $value->orgo_goo_type; //商品类型 1正常商品2赠品商品3活动商品4旧货商品
            $sedt_data['orgo_goo_price'] = $value->orgo_goo_price; //商品售价（单位：分）
            $sedt_data['orgo_goo_quantity'] = $value->orgo_goo_quantity; //订单商品数量
            $sedo_res = DB::table('sell_detail_test')->insert($sedt_data);
            dump($sedo_res);
        }
    }

    // 退货商品导入
    public function salesReturn()
    {
        ignore_user_abort();
        set_time_limit(0);

        // 业务划区下各品牌的销售数量（不包含铺货的）
        $list_data = DB::table('order_goods as og')
            ->leftJoin('order as o', 'o.ord_id', '=', 'og.orgo_ord_id')
            ->leftJoin('order_client as oc', 'o.ord_id', '=', 'oc.orcl_ord_id')
            ->leftJoin('channel_info as cu', 'cu.chin_chun_id', '=', 'o.ord_client_id')
            ->leftJoin('admin as a', 'a.adm_id', '=', 'o.ord_create_id')
            ->leftJoin('goods as g', 'g.goo_id', '=', 'og.orgo_goo_id')
            ->leftJoin('order_label as ol', 'ol.orla_id', '=', 'o.ord_orla_id')
            ->where('ord_cid', 1)
            ->where('ord_superior_shop_id', 1)
            ->where('ord_delete', 1)
            ->where('goo_cate_name', '启动电池')
            ->where('ord_collection_bill', 1) //是否代收账单：1正常订单2代收账单
            // ->where('ord_service_type', 4)
            // ->where('orgo_state', 4)
            ->where('ord_create_time', 'like', '%' . $this->date . '%')
            ->select('ord_order_number', 'adm_name', 'ord_type', 'orcl_channel_unit', 'chin_zoning', 'orcl_name', 'orla_name as orcl_chin_type', 'goo_bra_name', 'orgo_state', 'orgo_goo_name', 'orgo_goo_goods_encode', 'orgo_goo_type', 'orgo_goo_price', 'orgo_goo_quantity')
            ->get();
        foreach ($list_data as $key => $value) {
            dump($value);
            $sedt_data['ord_order_number'] = $value->ord_order_number; //订单号
            $sedt_data['adm_name'] = $value->adm_name; //录单人
            $sedt_data['ord_type'] = $value->ord_type; //买家类型：1门店零售2渠道单位3速电派单4第三方派单
            $sedt_data['orcl_channel_unit'] = $value->orcl_channel_unit; //客户单位
            $sedt_data['chin_zoning'] = $value->chin_zoning; //业务划区
            $sedt_data['orcl_name'] = $value->orcl_name; //姓名
            $sedt_data['orcl_chin_type'] = $value->orcl_chin_type; //铺货类型：1是铺货 2不是铺货
            $sedt_data['goo_bra_name'] = $value->goo_bra_name; //品牌名称
            $sedt_data['orgo_state'] = $value->orgo_state; //商品状态1.正常 2.删除3回收的商品4换货商品5赠品商品6备用电池7临时商品8旧货商品
            $sedt_data['orgo_goo_name'] = $value->orgo_goo_name; //商品名称
            $sedt_data['orgo_goo_goods_encode'] = $value->orgo_goo_goods_encode; //商品编号
            $sedt_data['orgo_goo_type'] = $value->orgo_goo_type; //商品类型 1正常商品2赠品商品3活动商品4旧货商品
            $sedt_data['orgo_goo_price'] = $value->orgo_goo_price; //商品售价（单位：分）
            $sedt_data['orgo_goo_quantity'] = $value->orgo_goo_quantity; //订单商品数量
            $sedo_res = DB::table('sell_detail_test')->insert($sedt_data);
            dump($sedo_res);
        }
    }

    // 导出
    public function exports2()
    {
        $data = DB::table('sell_detail_temporary')
            ->select('sedt_adm_name', 'sedt_goo_quantity', 'sedt_goo_price', 'sedt_biaoneng_amount', 'sedt_xiulichang', 'sedt_luntaikuaixiu', 'sedt_zhongduanchezhu', 'sedt_puhuoxiaoshou', 'sedt_xiulichangs', 'sedt_luntaikuaixius', 'sedt_zhongduanchezhus', 'sedt_puhuoxiaoshous', 'sedt_biaoneng_amounts')
            ->get()->toArray();
        if (!empty($data)) {
            // 将对象转化为数组
            $data = json_decode(json_encode($data), true);
            foreach ($data as $key => $value) {
                $data[$key]['sedt_goo_price'] = $value['sedt_goo_price'] / 100; //送货提成
                $data[$key]['sedt_biaoneng_amount'] = $value['sedt_biaoneng_amount'] / 100; //送货+安装提成
                $data[$key]['sedt_xiulichang'] = $value['sedt_xiulichang'] / 100; //合计提成

                $data[$key]['sedt_luntaikuaixiu'] = $value['sedt_luntaikuaixiu'] / 100; //送货提成
                $data[$key]['sedt_zhongduanchezhu'] = $value['sedt_zhongduanchezhu'] / 100; //送货+安装提成
                $data[$key]['sedt_puhuoxiaoshou'] = $value['sedt_puhuoxiaoshou'] / 100; //派工安装提成
                $data[$key]['sedt_xiulichangs'] = $value['sedt_xiulichangs'] / 100; //合计提成

                $data[$key]['sedt_luntaikuaixius'] = $value['sedt_luntaikuaixius'] / 100; //送货提成
                $data[$key]['sedt_zhongduanchezhus'] = $value['sedt_zhongduanchezhus'] / 100; //送货+安装提成
                $data[$key]['sedt_puhuoxiaoshous'] = $value['sedt_puhuoxiaoshous'] / 100; //派工安装提成
                $data[$key]['sedt_biaoneng_amounts'] = $value['sedt_biaoneng_amounts'] / 100; //合计提成
            }
        } else {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'没有符合条件的数据']);
        }

        $pathName = storage_path() . "/app/public/excel"; //获取上传excel路径
        // 创建文件夹
        if (!file_exists($pathName)) {
            mkdir($pathName, 0775, true);
            chmod($pathName, 0775);
        }

        $streamFileRand = time() . rand(10000, 99999) . '10月业绩提成.xls'; //
        // 产生一个随机文件名（因为你base64上来肯定没有文件名，这里你可以自己设置一个也行）
        $streamFilename = $pathName . '/' . $streamFileRand;

        $where['action_name'] = '10月业绩提成金额';
        $where['field_name'] = ['姓名', '总订单数量', '销售额合计', '飚能销售总额', '飚能修理厂', '飚能轮胎快修', '飚能终端车主', '飚能铺货销售', '飚能PLUSx修理厂', '飚能PLUS轮胎快修', '飚能PLUS终端车主修理厂', '飚能PLUS铺货销售', '飚能PLUS总金额'];
        // 调用导出的公共方法
        export::publicExport(
            $streamFilename, //路径
            $where,    //sheet名及其每一行的标题
            $data      //导出数据
        );

        // 判断文件是否存在 存在则成功  不存在则失败
        if (file_exists($pathName)) {
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>'storage/excel/' . $streamFileRand]);
        } else {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'导出失败']);
        }
    }

    // 统计开单人员[飚能]
    public function sellStatistic()
    {
        ignore_user_abort();
        set_time_limit(0);

        $adm_id = [0, 1, 7, 9, 12, 13, 15, 16, 20, 21, 22, 30, 31, 36, 37, 38, 39, 40, 42, 44, 45, 46, 47, 63, 64, 65, 67, 69, 70, 71, 73, 74, 75, 77, 78, 79, 80, 81, 82, 83, 92, 99, 102, 121, 122, 126, 231, 232, 234, 244, 245, 246, 247, 249, 250, 251];
        foreach ($adm_id as $kk => $vv) {
            dump($vv);
            // 正常商品
            $list_data = DB::table('sell_detail_order')
                // ->where('goo_bra_name', '飚能PLUS')
                ->where('goo_bra_name', '飚能')
                // ->where('orcl_chin_type', '!=', '铺货')
                ->where('orcl_chin_type', '铺货')
                ->where('adm_id', $vv)
                ->select('adm_id', 'adm_name', 'orgo_goo_price', 'orgo_goo_quantity', 'chin_zoning')
                ->get()->toArray();
            $amount = 0; //计算总金额
            $xlcamount = 0; //修理厂金额
            $ltkxamount = 0; //轮胎快修金额
            $zdczamount = 0; //终端车主金额
            foreach ($list_data as $key => $value) {
                dump($value);
                $goo_price = $value->orgo_goo_price * $value->orgo_goo_quantity;
                // if ($value->chin_zoning == '维修厂') {
                //     $xlcamount += $goo_price;
                // } elseif ($value->chin_zoning == '轮胎快修') {
                //     $ltkxamount += $goo_price;
                // }  elseif ($value->chin_zoning == '终端车主') {
                //     $zdczamount += $goo_price;
                // }
                $amount += $goo_price;
            }
            // dump($xlcamount);
            // dump($ltkxamount);
            // dump($zdczamount);
            // dump($amount);
            if (!empty($list_data)) {
                // 在技师绩效临时表插入数据
                $sedt_data['sedt_adm_id'] = $vv; //技师id
                // $sedt_data['sedt_xiulichangs'] = $xlcamount;//修理厂
                // $sedt_data['sedt_luntaikuaixius'] = $ltkxamount;//轮胎快修
                // $sedt_data['sedt_zhongduanchezhus'] = $zdczamount;//终端车主
                // $sedt_data['sedt_biaoneng_amounts'] = $amount;//飚能业绩提成
                $sedt_data['sedt_puhuoxiaoshou'] = $amount; //飚能业绩提成
                DB::table('sell_detail_temporary')
                    ->where('sedt_adm_id', $vv)
                    ->update($sedt_data);
                unset($sedt_data);
            }
        }
    }
    // 统计开单人员总商品数量,销售额合计
    public function sellStatistics()
    {
        ignore_user_abort();
        set_time_limit(0);

        // $adm_id = [0, 12, 13, 46, 64, 67, 69, 73, 82, 102, 126, 231, 232];
        $adm_id = [0, 1, 7, 9, 12, 13, 15, 16, 20, 21, 22, 30, 31, 36, 37, 38, 39, 40, 42, 44, 45, 46, 47, 63, 64, 65, 67, 69, 70, 71, 73, 74, 75, 77, 78, 79, 80, 81, 82, 83, 92, 99, 102, 121, 122, 126, 231, 232, 234, 244, 245, 246, 247, 249, 250, 251];
        foreach ($adm_id as $kk => $vv) {
            dump($vv);
            $list_data = DB::table('sell_detail_order')
                ->where('adm_id', $vv)
                ->where('orcl_chin_type', '!=', '铺货')
                ->select('adm_id', 'adm_name', 'orgo_goo_price', 'orgo_goo_quantity', 'ord_order_number')
                ->get()->toArray();
            $ord_number = count(array_unique(array_column($list_data, 'ord_order_number')));
            $quantity = 0; //商品总数量
            $amount = 0; //计算总金额
            foreach ($list_data as $key => $value) {
                dump($value);
                $quantity += $value->orgo_goo_quantity;
                $goo_price = $value->orgo_goo_price * $value->orgo_goo_quantity;
                $amount += $goo_price;
            }
            // dump($amount);
            if (!empty($list_data)) {
                // 在技师绩效临时表插入数据
                $sedt_data['sedt_adm_id'] = $vv; //技师id
                $sedt_data['sedt_adm_name'] = $value->adm_name; //技师姓名
                $sedt_data['sedt_goo_quantity'] = $ord_number; //总商品数量
                $sedt_data['sedt_goo_price'] = $amount; //销售额合计(单位:分)
                DB::table('sell_detail_temporary')->insert($sedt_data);
                unset($sedt_data);
            }
        }
    }
    // 正常商品
    public function zhengchang()
    {
        ignore_user_abort();
        set_time_limit(0);

        // 业务划区下各品牌的销售数量（不包含铺货的）
        $list_data = DB::table('order_goods as og')
            ->leftJoin('order as o', 'o.ord_id', '=', 'og.orgo_ord_id')
            ->leftJoin('order_client as oc', 'o.ord_id', '=', 'oc.orcl_ord_id')
            ->leftJoin('channel_unit as cu', 'cu.chun_id', '=', 'o.ord_client_id')
            ->leftJoin('channel_type as chty', 'chty.chty_id', '=', 'cu.chun_chty_id')
            ->leftJoin('admin as a', 'a.adm_id', '=', 'o.ord_create_id')
            ->leftJoin('goods as g', 'g.goo_id', '=', 'og.orgo_goo_id')
            ->leftJoin('order_label as ol', 'ol.orla_id', '=', 'o.ord_orla_id')
            ->where('ord_cid', 1)
            ->where('ord_superior_shop_id', 1)
            ->where('ord_delete', 1)
            ->where('goo_cate_name', '启动电池')
            ->where('ord_collection_bill', 1) //是否代收账单：1正常订单2代收账单
            ->where('ord_service_type', '<>', 4)
            ->whereNotIn('orgo_state', [3, 4])
            ->where('ord_create_time', 'like', '%' . $this->date . '%')
            ->select('ord_order_number', 'ord_create_id', 'adm_name', 'ord_type', 'orcl_channel_unit', 'orcl_name', 'orla_name as orcl_chin_type', 'goo_bra_name', 'orgo_state', 'orgo_goo_name', 'orgo_goo_goods_encode', 'orgo_goo_type', 'orgo_goo_price', 'orgo_goo_quantity', 'chty_name')
            ->get();
        // dump($list_data);exit;
        // dump(count($list_data));
        foreach ($list_data as $key => $value) {
            dump($value);
            $sedo_data['ord_order_number'] = $value->ord_order_number; //订单号
            $sedo_data['adm_id'] = $value->ord_create_id; //开单员id
            $sedo_data['adm_name'] = $value->adm_name; //开单员姓名
            $sedo_data['ord_type'] = $value->ord_type; //买家类型
            $sedo_data['orcl_channel_unit'] = $value->orcl_channel_unit; //客户单位
            $sedo_data['chin_zoning'] = $value->chty_name; //单位类型名称
            $sedo_data['orcl_name'] = $value->orcl_name; //姓名
            $sedo_data['orcl_chin_type'] = $value->orcl_chin_type; //铺货类型：1是铺货 2不是铺货
            $sedo_data['goo_bra_name'] = $value->goo_bra_name; //品牌名称
            $sedo_data['orgo_state'] = $value->orgo_state; //商品状态1.正常 2.删除3回收的商品4换货商品5赠品商品6备用电池7临时商品8旧货商品
            $sedo_data['orgo_goo_name'] = $value->orgo_goo_name; //商品名称
            $sedo_data['orgo_goo_goods_encode'] = $value->orgo_goo_goods_encode; //商品编号
            $sedo_data['orgo_goo_type'] = $value->orgo_goo_type; //商品类型 1正常商品2赠品商品3活动商品4旧货商品
            $sedo_data['orgo_goo_price'] = $value->orgo_goo_price; //商品售价（单位：分）
            $sedo_data['orgo_goo_quantity'] = $value->orgo_goo_quantity; //订单商品数量
            $sedo_res = DB::table('sell_detail_order')->insert($sedo_data);
            dump($sedo_res);
        }
    }
    // 退货商品
    public function tuihuo()
    {
        ignore_user_abort();
        set_time_limit(0);

        // 业务划区下各品牌的销售数量（不包含铺货的）
        $list_data = DB::table('order_goods as og')
            ->leftJoin('order as o', 'o.ord_id', '=', 'og.orgo_ord_id')
            ->leftJoin('order_client as oc', 'o.ord_id', '=', 'oc.orcl_ord_id')
            ->leftJoin('channel_unit as cu', 'cu.chun_id', '=', 'o.ord_client_id')
            ->leftJoin('channel_type as chty', 'chty.chty_id', '=', 'cu.chun_chty_id')
            ->leftJoin('admin as a', 'a.adm_id', '=', 'o.ord_create_id')
            ->leftJoin('goods as g', 'g.goo_id', '=', 'og.orgo_goo_id')
            ->leftJoin('order_label as ol', 'ol.orla_id', '=', 'o.ord_orla_id')
            ->where('ord_cid', 1)
            ->where('ord_superior_shop_id', 1)
            ->where('ord_delete', 1)
            ->where('goo_cate_name', '启动电池')
            ->where('ord_collection_bill', 1) //是否代收账单：1正常订单2代收账单
            // ->where('ord_service_type', 4)
            ->where('orgo_state', 4)
            ->where('ord_create_time', 'like', '%' . $this->date . '%')
            ->select('ord_order_number', 'ord_create_id', 'adm_name', 'ord_type', 'orcl_channel_unit', 'orcl_name', 'orla_name as orcl_chin_type', 'goo_bra_name', 'orgo_state', 'orgo_goo_name', 'orgo_goo_goods_encode', 'orgo_goo_type', 'orgo_goo_price', 'orgo_goo_quantity', 'chty_name')
            ->get();

        // dump($list_data);
        // dump(count($list_data));
        foreach ($list_data as $key => $value) {
            dump($value);
            $sedo_data['ord_order_number'] = $value->ord_order_number; //订单号
            $sedo_data['adm_id'] = $value->ord_create_id; //开单员id
            $sedo_data['adm_name'] = $value->adm_name; //开单员姓名
            $sedo_data['ord_type'] = $value->ord_type; //买家类型
            $sedo_data['orcl_channel_unit'] = $value->orcl_channel_unit; //客户单位
            $sedo_data['chin_zoning'] = $value->chty_name; //单位类型名称
            $sedo_data['orcl_name'] = $value->orcl_name; //姓名
            $sedo_data['orcl_chin_type'] = $value->orcl_chin_type; //铺货类型：1是铺货 2不是铺货
            $sedo_data['goo_bra_name'] = $value->goo_bra_name; //品牌名称
            $sedo_data['orgo_state'] = $value->orgo_state; //商品状态1.正常 2.删除3回收的商品4换货商品5赠品商品6备用电池7临时商品8旧货商品
            $sedo_data['orgo_goo_name'] = $value->orgo_goo_name; //商品名称
            $sedo_data['orgo_goo_goods_encode'] = $value->orgo_goo_goods_encode; //商品编号
            $sedo_data['orgo_goo_type'] = $value->orgo_goo_type; //商品类型 1正常商品2赠品商品3活动商品4旧货商品
            $sedo_data['orgo_goo_price'] = '-' . $value->orgo_goo_price; //商品售价（单位：分）
            $sedo_data['orgo_goo_quantity'] = $value->orgo_goo_quantity; //订单商品数量
            $sedo_res = DB::table('sell_detail_order')->insert($sedo_data);
            dump($sedo_res);
        }
    }

    // 发货单数据调整
    public function fahuodan()
    {
        $cid = 1;
        $shop_id = 1;
        $find_order_data = DB::table('order as ord')
            ->leftjoin('order_goods as orgo', 'orgo.orgo_ord_id', '=', 'ord.ord_id')
            ->where('ord_cid', $cid)
            ->where('ord_shop_id', $shop_id)
            ->where('ord_service_type', 5)
            ->where('ord_delete', 1)
            ->where('ord_payment_way', 1)
            ->get()->toArray();
        foreach ($find_order_data as $key => $value) {
            $dibi_data = DB::table('dispatch_bill')
                ->where('dego_cid', $value->ord_cid)
                ->where('dego_shop_id', $value->ord_shop_id)
                ->where('dego_wor_id', $value->ord_id)
                ->where('dego_original_number', $value->ord_order_number)
                ->select('dego_id', 'dego_number', 'dego_wor_id', 'dego_original_number')
                ->first();
            if (empty($dibi_data)) {
                // dump($value->ord_id);
                // dump($value->ord_order_number);
                dump($value);
                $dego_data['dego_cid'] = $value->ord_cid;
                $dego_data['dego_superior_shop_id'] = $value->ord_superior_shop_id;
                $dego_data['dego_shop_id'] = $value->ord_shop_id;
                $dego_data['dego_number'] = 'FH' . time() . rand(100, 999);
                $dego_data['dego_order_type'] = 1;
                $dego_data['dego_original_number'] = $value->ord_order_number;
                $dego_data['dego_wor_id'] = $value->ord_id;
                $dego_data['dego_client_type'] = $value->ord_type;
                $dego_data['dego_client_id'] = $value->ord_client_id;
                $dego_data['dego_count'] = $value->ord_goods_quantity;
                $dego_data['dego_service_shop_id'] = $value->ord_service_shop_id;
                $dego_data['dego_out_ware_id'] = $value->ord_ware_id;
                $dego_data['dego_service_adm_id'] = $value->ord_service_adm_id;
                $dego_data['dego_type'] = 1;
                $dego_data['dego_create_adm_id'] = $value->ord_create_id;
                $dego_data['dego_create_time'] = $value->orgo_update_time;
                $dego_id = DB::table('dispatch_bill')->insertGetId($dego_data);
                $digo_data['digo_dego_id'] = $dego_id;
                $digo_data['digo_wago_class'] = $value->orgo_waon_class;
                $digo_data['digo_goo_id'] = $value->orgo_goo_id;
                $digo_data['digo_goo_type'] = $value->orgo_goo_type;
                $digo_data['digo_tem_goo_name'] = $value->orgo_tem_goo_name;
                $digo_data['digo_goo_name'] = $value->orgo_goo_name;
                $digo_data['digo_goo_goods_encode'] = $value->orgo_goo_goods_encode;
                $digo_data['digo_goo_price'] = $value->orgo_goo_price;
                $digo_data['digo_goo_quantity'] = $value->orgo_goo_quantity;
                $digo_data['digo_is_recycle'] = $value->orgo_is_recycle;
                $digo_data['digo_goo_inventory'] = $value->orgo_goo_inventory;
                $digo_data['digo_state'] = $value->orgo_state;
                $digo_id = DB::table('dispatch_goods')->insert($digo_data);
            }
        }
    }

    // 更改客户单位数据
    public function editChannelData($request)
    {
        $cid = 1;
        $shop_id = 1;
        // 查询客户单位id、名称
        $find_chun_data = DB::table('channel_unit')
            ->where('chun_cid', $cid)
            ->where('chun_shop_id', $shop_id)
            ->where('chun_search_letter', $request['chun_search_letter'])
            ->select('chun_id', 'chun_unit_name')
            ->first();
        // 更改工单表客户单位数据
        $find_wor_data = DB::table('work_order')
            ->where('wor_cid', $cid)
            ->where('wor_shop_id', $shop_id)
            ->where('wor_number', $request['wor_number'])
            ->select('wor_id', 'wor_number', 'wor_order_number')
            ->first();
        $edit_data['wocl_client_id'] = $find_chun_data->chun_id;
        $edit_data['wocl_channel_unit'] = $find_chun_data->chun_unit_name;
        $res = DB::table('work_client')
            ->where('wocl_wor_id', $find_wor_data->wor_id)
            ->update($edit_data);
        dump($res);
        unset($edit_data);

        // 更改订单客户单位数据
        $find_ord_data = DB::table('order')
            ->where('ord_cid', $cid)
            ->where('ord_shop_id', $shop_id)
            ->where('ord_order_number', $find_wor_data->wor_order_number)
            ->select('ord_id', 'ord_order_number')
            ->first();
        $edit_data['ord_client_id'] = $find_chun_data->chun_id;
        $res = DB::table('order')
            ->where('ord_id', $find_ord_data->ord_id)
            ->update($edit_data);
        dump($res);
        unset($edit_data);
        $edit_data['orcl_client_id'] = $find_chun_data->chun_id;
        $edit_data['orcl_channel_unit'] = $find_chun_data->chun_unit_name;
        $res = DB::table('order_client')
            ->where('orcl_ord_id', $find_ord_data->ord_id)
            ->update($edit_data);
        dump($res);
        unset($edit_data);

        // 更改就会收回客户单位数据
        $find_data = DB::table('junk_recycle')
            ->where('jur_cid', $cid)
            ->where('jur_shop_id', $shop_id)
            ->where('jur_ord_order_number', $find_wor_data->wor_order_number)
            ->select('jur_id', 'jur_number')
            ->first();
        $edit_data['jucl_client_id'] = $find_chun_data->chun_id;
        $edit_data['jucl_channel_unit'] = $find_chun_data->chun_unit_name;
        if ($find_data) {
            $res = DB::table('junk_client')
                ->where('jucl_jur_id', $find_data->jur_id)
                ->update($edit_data);
            dump($res);
        }
        unset($edit_data);

        // 更改发货单
        $find_data = DB::table('dispatch_bill')
            ->where('dego_cid', $cid)
            ->where('dego_shop_id', $shop_id)
            ->where('dego_original_number', $find_wor_data->wor_number)
            ->select('dego_id', 'dego_number')
            ->first();
        $edit_data['dego_client_id'] = $find_chun_data->chun_id;
        // $edit_data['jucl_channel_unit'] = $find_chun_data->chun_unit_name;
        $res = DB::table('dispatch_bill')
            ->where('dego_id', $find_data->dego_id)
            ->update($edit_data);
        dump($res);
        unset($edit_data);

        // 更改应收账款
        $find_data = DB::table('receivable_credit')
            ->where('recr_cid', $cid)
            ->where('recr_shop_id', $shop_id)
            ->where('recr_original_number', $find_wor_data->wor_order_number)
            ->select('recr_id')
            ->first();
        $edit_data['recr_client_id'] = $find_chun_data->chun_id;
        $edit_data['recr_client_name'] = $find_chun_data->chun_unit_name;
        $res = DB::table('receivable_credit')
            ->where('recr_id', $find_data->recr_id)
            ->update($edit_data);
        dump($res);
        unset($edit_data);
    }

    // 查询工单表的技师id
    public function admin()
    {
        ignore_user_abort();
        set_time_limit(0);

        $cid = 1; //公司id
        $shop_id = 1; //门店id
        $list_data = DB::table('work_order as wor')
            ->leftjoin('admin as adm', 'adm.adm_id', '=', 'wor.wor_service_adm_id')
            ->where('wor_cid', $cid)
            ->where('wor_shop_id', $shop_id)
            ->where('wor_delete', 1)
            ->select('wor_service_adm_id', 'adm_name')
            ->groupBy('wor_service_adm_id')
            ->get();
        dump($list_data);
    }

    // 统计服务技师送货单量和业绩绩效
    public function songhuo()
    {
        ignore_user_abort();
        set_time_limit(0);

        $cid = 1; //公司id
        $shop_id = 1; //门店id
        $service_adm_id = [9, 12, 13, 15, 16, 20, 21, 22, 38, 42, 44, 45, 47, 65, 70, 71, 73, 74, 75, 77, 81, 82, 83, 99, 121, 234, 250];
        foreach ($service_adm_id as $kk => $vv) {
            dump($vv);
            $list_data = DB::table('work_order as wor')
                ->leftjoin('service_project as sepr', 'sepr.sepr_id', '=', 'wor.wor_service_sepr_id')
                ->leftjoin('admin as adm', 'adm.adm_id', '=', 'wor.wor_service_adm_id')
                ->leftjoin('work_client as wocl', 'wocl.wocl_wor_id', '=', 'wor.wor_id')
                ->where('wor_cid', $cid)
                ->where('wor_shop_id', $shop_id)
                ->where('wor_service_adm_id', $vv)
                ->where('sepr_name', '送货')
                ->where('wor_delete', 1)
                ->where('sepr_delete', 1)
                // ->where('wor_service_type', '!=', 7)
                // ->where('wor_service_type', 7)
                ->where('wor_create_time', 'like', '%' . $this->date . '%')
                ->select('wor_service_adm_id', 'adm_name', 'sepr_money', 'wocl_rescue_service_price')
                ->get()->toArray();
            // dump($list_data);exit;
            $amount = 0; //计算总金额
            foreach ($list_data as $key => $value) {
                dump($value);
                $amount += $value->sepr_money;
                // $amount += $value->wocl_rescue_service_price;
            }
            dump($amount);
            if (!empty($list_data)) {
                // 在技师绩效临时表插入数据
                $wott_data['wott_adm_id'] = $vv; //技师id
                $wott_data['wott_name'] = $value->adm_name; //技师姓名
                $wott_data['wott_songhuo'] = $amount; //送货提成
                DB::table('work_technician_temporary')->insert($wott_data);
                // 查询金额
                // $songhuo = DB::table('work_technician_temporary')
                //     ->where('wott_adm_id', $vv)
                //     ->value('wott_songhuo');
                // $wott_data['wott_songhuo'] = $songhuo + $amount;
                // $wott_data['wott_update_time'] = date('Y-m-d H:i:s');
                // DB::table('work_technician_temporary')
                //     ->where('wott_adm_id', $vv)
                //     ->update($wott_data);
                // unset($wott_data);
            }
        }
    }

    // 统计服务技师送货单量和业绩绩效
    public function shaz()
    {
        ignore_user_abort();
        set_time_limit(0);

        $cid = 1; //公司id
        $shop_id = 1; //门店id
        $superior_shop_id = 1; //总店id
        $service_adm_id = [9, 12, 13, 15, 16, 20, 21, 22, 38, 42, 44, 45, 47, 65, 70, 71, 73, 74, 75, 77, 81, 82, 83, 99, 121, 234, 250];

        foreach ($service_adm_id as $kk => $vv) {
            $list_data = DB::table('work_order as wor')
                ->leftjoin('service_project as sepr', 'sepr.sepr_id', '=', 'wor.wor_service_sepr_id')
                ->leftjoin('admin as adm', 'adm.adm_id', '=', 'wor.wor_service_adm_id')
                ->leftjoin('work_client as wocl', 'wocl.wocl_wor_id', '=', 'wor.wor_id')
                ->where('wor_cid', $cid)
                ->where('wor_shop_id', $shop_id)
                ->where('wor_service_adm_id', $vv)
                ->where('sepr_name', '送货+安装')
                ->where('wor_delete', 1)
                ->where('sepr_delete', 1)
                // ->where('wor_service_type', '!=', 7)
                // ->where('wor_service_type', 7)
                ->where('wor_create_time', 'like', '%' . $this->date . '%')
                ->select('wor_service_adm_id', 'adm_name', 'sepr_money', 'wocl_rescue_service_price')
                ->get()->toArray();
            // dump($list_data);exit;
            $amount = 0; //计算总金额
            foreach ($list_data as $key => $value) {
                dump($value);
                $amount += $value->sepr_money;
                // $amount += $value->wocl_rescue_service_price;
            }
            dump($amount);
            if (!empty($list_data)) {
                // 在技师绩效临时表插入数据
                $wott_data['wott_adm_id'] = $vv; //技师id
                $wott_data['wott_shaz'] = $amount; //送货+安装提成
                DB::table('work_technician_temporary')
                    ->where('wott_adm_id', $vv)
                    ->update($wott_data);
                // 查询金额
                // $songhuo = DB::table('work_technician_temporary')
                //     ->where('wott_adm_id', $vv)
                //     ->value('wott_songhuo');
                // $wott_data['wott_songhuo'] = $songhuo + $amount;
                // $wott_data['wott_update_time'] = date('Y-m-d H:i:s');
                // DB::table('work_technician_temporary')
                //     ->where('wott_adm_id', $vv)
                //     ->update($wott_data);
                unset($wott_data);
            }
        }
    }

    // 统计服务技师送货单量和业绩绩效
    public function paigong()
    {
        ignore_user_abort();
        set_time_limit(0);

        $cid = 1; //公司id
        $shop_id = 1; //门店id
        $superior_shop_id = 1; //总店id
        $service_adm_id = [9, 12, 13, 15, 16, 20, 21, 22, 38, 42, 44, 45, 47, 65, 70, 71, 73, 74, 75, 77, 81, 82, 83, 99, 121, 234, 250];
        foreach ($service_adm_id as $kk => $vv) {
            $list_data = DB::table('work_order as wor')
                ->leftjoin('service_project as sepr', 'sepr.sepr_id', '=', 'wor.wor_service_sepr_id')
                ->leftjoin('admin as adm', 'adm.adm_id', '=', 'wor.wor_service_adm_id')
                ->leftjoin('work_client as wocl', 'wocl.wocl_wor_id', '=', 'wor.wor_id')
                ->where('wor_cid', $cid)
                ->where('wor_shop_id', $shop_id)
                ->where('wor_service_adm_id', $vv)
                ->whereNotIn('sepr_name', ['送货', '送货+安装'])
                ->where('wor_delete', 1)
                ->where('sepr_delete', 1)
                // ->where('wor_service_type', '!=', 7)
                // ->where('wor_service_type', 7)
                ->where('wor_create_time', 'like', '%' . $this->date . '%')
                ->select('wor_service_adm_id', 'adm_name', 'sepr_money', 'wocl_rescue_service_price')
                ->get()->toArray();
            // dump($list_data);exit;
            $amount = 0; //计算总金额
            foreach ($list_data as $key => $value) {
                dump($value);
                $amount += $value->sepr_money;
            }
            dump($amount);
            if (!empty($list_data)) {
                // 在技师绩效临时表插入数据
                $wott_data['wott_adm_id'] = $vv; //技师id
                $wott_data['wott_paigong'] = $amount; //送货+安装提成
                // dump($wott_data);
                DB::table('work_technician_temporary')
                    ->where('wott_adm_id', $vv)
                    ->update($wott_data);
                unset($wott_data);
            }
        }
    }

    // 统计服务技师送货单量和业绩绩效
    public function heji()
    {
        ignore_user_abort();
        set_time_limit(0);

        $service_adm_id = [9, 12, 13, 15, 16, 20, 21, 22, 38, 42, 44, 45, 47, 65, 70, 71, 73, 74, 75, 77, 81, 82, 83, 99, 121, 234, 250];
        foreach ($service_adm_id as $kk => $vv) {
            $list_data = DB::table('work_technician_temporary')
                ->where('wott_adm_id', $vv)
                ->select('wott_adm_id', 'wott_name', 'wott_songhuo', 'wott_shaz', 'wott_paigong')
                ->get()->toArray();
            // dump($list_data);
            if (!empty($list_data)) {
                foreach ($list_data as $key => $value) {
                    dump($value);
                    // 在技师绩效临时表插入数据
                    $wott_data['wott_heji'] = $value->wott_songhuo + $value->wott_shaz + $value->wott_paigong; //送货+安装提成
                    $wott_data['wott_update_time'] = date('Y-m-d H:i:s');
                    dump($wott_data['wott_heji']);
                    DB::table('work_technician_temporary')
                        ->where('wott_adm_id', $vv)
                        ->update($wott_data);
                    unset($wott_data);
                }
            }
        }
    }

    // 导出
    public function exports()
    {
        $data = DB::table('work_technician_temporary')
            ->select('wott_name', 'wott_songhuo', 'wott_shaz', 'wott_paigong', 'wott_heji')
            ->get()->toArray();
        if (!empty($data)) {
            // 将对象转化为数组
            $data = json_decode(json_encode($data), true);

            foreach ($data as $key => $value) {
                $data[$key]['wott_songhuo'] = $value['wott_songhuo'] / 100; //送货提成
                $data[$key]['wott_shaz'] = $value['wott_shaz'] / 100; //送货+安装提成
                $data[$key]['wott_paigong'] = $value['wott_paigong'] / 100; //派工安装提成
                $data[$key]['wott_heji'] = $value['wott_heji'] / 100; //合计提成
            }
        } else {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'没有符合条件的数据']);
        }

        $pathName = storage_path() . "/app/public/excel"; //获取上传excel路径
        // 创建文件夹
        if (!file_exists($pathName)) {
            mkdir($pathName, 0775, true);
            chmod($pathName, 0775);
        }

        $streamFileRand = time() . rand(10000, 99999) . '.xls'; //
        // 产生一个随机文件名（因为你base64上来肯定没有文件名，这里你可以自己设置一个也行）
        $streamFilename = $pathName . '/' . $streamFileRand;

        $where['action_name'] = '9月业绩提成金额';
        $where['field_name'] = ['姓名', '送货提成', '送货+安装提成', '派工安装提成', '合计提成'];
        // 调用导出的公共方法
        export::publicExport(
            $streamFilename, //路径
            $where,    //sheet名及其每一行的标题
            $data      //导出数据
        );

        // 判断文件是否存在 存在则成功  不存在则失败
        if (file_exists($pathName)) {
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>'storage/excel/' . $streamFileRand]);
        } else {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'导出失败']);
        }
    }

    // 发货单表类型为订单发货的数据同步到凭证列表
    public function order()
    {
        DB::beginTransaction();
        // 查询类型为发货单,并且已经出库的数据
        $find_ord_data = DB::table('dispatch_bill')
            ->where('dego_order_type', 1)
            ->where('dego_type', 2)
            ->select('dego_wor_id', 'dego_cid', 'dego_superior_shop_id', 'dego_shop_id', 'dego_original_number', 'dego_client_type', 'dego_client_id', 'dego_create_adm_id')
            ->get()->toArray();
        foreach ($find_ord_data as $key => $value) {
            dump($value);
            // exit;
            // 根据订单id和单号查询出结算金额,代收金额,旧货回收金额
            $find_order_data = DB::table('order')
                ->where('ord_id', $value->dego_wor_id)
                ->where('ord_cid', $value->dego_cid)
                ->where('ord_superior_shop_id', $value->dego_superior_shop_id)
                ->where('ord_shop_id', $value->dego_shop_id)
                ->where('ord_order_number', $value->dego_original_number)
                ->select('ord_order_price', 'ord_actual_price', 'ord_collection_price', 'ord_plus_minus', 'ord_order_plus_minus')
                ->first();
            // dump($find_order_data);
            // 根据订单id和商品状态,查询出回收的商品
            $find_goods_data = DB::table('order_goods')
                ->where('orgo_ord_id', $value->dego_wor_id)
                ->where('orgo_state', 3)
                ->select('orgo_id', 'orgo_ord_id', 'orgo_goo_id', 'orgo_goo_price', 'orgo_goo_quantity')
                ->get()->toArray();
            // dump($find_goods_data);
            $goo_recycle_price = [];
            foreach ($find_goods_data as $kk => $vv) {
                if (!isset($goo_recycle_price[$vv->orgo_goo_id])) {
                    $goo_recycle_price[$vv->orgo_goo_id] = 0;
                }
                $goo_recycle_price[$vv->orgo_goo_id] += $vv->orgo_goo_price * $vv->orgo_goo_quantity; //商品数量
            }
            $recycle_amount = 0;
            foreach ($goo_recycle_price as $kkk => $vvv) {
                $recycle_amount = $vvv;
            }
            // 凭证单据报表
            $vore_data['vore_cid'] = $value->dego_cid; //公司id
            $vore_data['vore_superior_shop_id'] = $value->dego_superior_shop_id; //总店id
            $vore_data['vore_shop_id'] = $value->dego_shop_id; //门店id
            $vore_data['vore_create_id'] = $value->dego_create_adm_id; //创建人
            $vore_data['vore_order_type'] = 1; //单号类型1.订单2.工单3.采购单4.销售单
            $vore_data['vore_ord_id'] = $value->dego_wor_id; //订单id
            $vore_data['vore_ord_number'] = $value->dego_original_number; //订单单号
            $vore_data['vore_plus_minus'] = $find_order_data->ord_plus_minus; //金额正负1正值2负值
            $vore_data['vore_actual_price'] = $find_order_data->ord_actual_price / 100; //结算金额
            $vore_data['vore_recycle_price'] = $recycle_amount / 100; //回收金额
            $vore_data['vore_type'] = $value->dego_client_type; //单位类型1会员零售2客户单位3速电派单
            $vore_data['vore_client_id'] = $value->dego_client_id; //客户单位/客户id
            // 根据客户单位id,查找客户名称
            $channel_unit = DB::table('channel_unit')
                ->where('chun_id', $value->dego_client_id)
                ->value('chun_unit_name');
            $vore_data['vore_channel_unit'] = $channel_unit ? $channel_unit : '';
            $vore_id = DB::table('voucher_receipts')->insertGetId($vore_data);
            dump($vore_id);
            // 凭证借贷表(结算金额)
            $volo_data[0]['volo_shop_id'] = $value->dego_shop_id;
            $volo_data[0]['volo_vore_id'] = $vore_id;
            $volo_data[0]['volo_type'] = 1; //类型1借方2贷方
            $volo_data[0]['volo_borrow_subject'] = '1012'; //借方科目
            $volo_data[0]['volo_borrow_subject_name'] = '其他货币资金'; //借方科目名称
            $volo_data[0]['volo_borrow_price'] = $find_order_data->ord_actual_price / 100; //借方金额
            $volo_data[0]['volo_loan_subject'] = '1231'; //贷方科目
            $volo_data[0]['volo_loan_subject_name'] = '坏账准备'; //贷方科目名称
            $volo_data[0]['volo_loan_price'] = $find_order_data->ord_actual_price / 100; //贷方金额
            $volo_data[0]['volo_update_time'] = date('Y-m-d H:i:s'); //更新时间
            // 凭证借贷表(回收金额)
            $volo_data[1]['volo_shop_id'] = $value->dego_shop_id;
            $volo_data[1]['volo_vore_id'] = $vore_id;
            $volo_data[1]['volo_type'] = 1; //类型1借方2贷方
            $volo_data[1]['volo_borrow_subject'] = '1012'; //借方科目
            $volo_data[1]['volo_borrow_subject_name'] = '其他货币资金'; //借方科目名称
            $volo_data[1]['volo_borrow_price'] = $recycle_amount / 100; //借方金额
            $volo_data[1]['volo_loan_subject'] = '1231'; //贷方科目
            $volo_data[1]['volo_loan_subject_name'] = '坏账准备'; //贷方科目名称
            $volo_data[1]['volo_loan_price'] = $recycle_amount / 100; //贷方金额
            $volo_data[1]['volo_update_time'] = date('Y-m-d H:i:s'); //更新时间
            $volo_id_two = DB::table('voucher_loan')->insert($volo_data);
            dump($volo_id_two);
            unset($vore_data);
            unset($volo_data);
        }
        DB::commit();
    }

    // 工单列表,完成已通过数据同步到凭证列表
    public function workOrder()
    {
        DB::beginTransaction();
        ignore_user_abort();
        set_time_limit(0);
        // 查询工单表,完成已通过的数据
        $find_wor_data = DB::table('work_order')
            ->where('wor_state', 10)
            ->select('wor_id', 'wor_cid', 'wor_superior_shop_id', 'wor_shop_id', 'wor_number', 'wor_order_id', 'wor_order_number', 'wor_create_id', 'wor_actual_price', 'wor_plus_minus', 'wor_recycle_price', 'wor_type')
            ->get()->toArray();
        foreach ($find_wor_data as $key => $value) {
            dump($value);
            // 凭证单据报表
            $vore_data['vore_cid'] = $value->wor_cid; //公司id
            $vore_data['vore_superior_shop_id'] = $value->wor_superior_shop_id; //总店id
            $vore_data['vore_shop_id'] = $value->wor_shop_id; //门店id
            $vore_data['vore_create_id'] = $value->wor_create_id; //创建人
            $vore_data['vore_order_type'] = 2; //单号类型1.订单2.工单3.采购单4.销售单
            $vore_data['vore_wor_id'] = $value->wor_id; //订单id
            $vore_data['vore_wor_number'] = $value->wor_number; //订单单号
            $vore_data['vore_ord_id'] = $value->wor_order_id; //订单id
            $vore_data['vore_ord_number'] = $value->wor_order_number; //订单单号
            $vore_data['vore_plus_minus'] = $value->wor_plus_minus; //金额正负1正值2负值
            $vore_data['vore_actual_price'] = $value->wor_actual_price / 100; //结算金额
            $vore_data['vore_recycle_price'] = $value->wor_recycle_price / 100; //回收金额
            $vore_data['vore_type'] = $value->wor_type; //单位类型1会员零售2客户单位3速电派单
            // 根据工单id,查询工单客户信息
            $find_wocl_data = DB::table('work_client')
                ->where('wocl_wor_id', $value->wor_id)
                ->select('wocl_client_id', 'wocl_channel_unit')
                ->first();
            $vore_data['vore_client_id'] = $find_wocl_data->wocl_client_id; //客户单位/客户id
            $vore_data['vore_channel_unit'] = $find_wocl_data->wocl_channel_unit ? $find_wocl_data->wocl_channel_unit : '';
            $vore_id = DB::table('voucher_receipts')->insertGetId($vore_data);
            dump($vore_id);
            // 凭证借贷表(结算金额)
            $volo_data[0]['volo_shop_id'] = $value->wor_shop_id;
            $volo_data[0]['volo_vore_id'] = $vore_id;
            $volo_data[0]['volo_type'] = 1; //类型1借方2贷方
            $volo_data[0]['volo_borrow_subject'] = '1012'; //借方科目
            $volo_data[0]['volo_borrow_subject_name'] = '其他货币资金'; //借方科目名称
            $volo_data[0]['volo_borrow_price'] = $value->wor_actual_price / 100; //借方金额
            $volo_data[0]['volo_loan_subject'] = '1231'; //贷方科目
            $volo_data[0]['volo_loan_subject_name'] = '坏账准备'; //贷方科目名称
            $volo_data[0]['volo_loan_price'] = $value->wor_actual_price / 100; //贷方金额
            $volo_data[0]['volo_update_time'] = date('Y-m-d H:i:s'); //更新时间
            // 凭证借贷表(回收金额)
            $volo_data[1]['volo_shop_id'] = $value->wor_shop_id;
            $volo_data[1]['volo_vore_id'] = $vore_id;
            $volo_data[1]['volo_type'] = 1; //类型1借方2贷方
            $volo_data[1]['volo_borrow_subject'] = '1012'; //借方科目
            $volo_data[1]['volo_borrow_subject_name'] = '其他货币资金'; //借方科目名称
            $volo_data[1]['volo_borrow_price'] = $value->wor_recycle_price / 100; //借方金额
            $volo_data[1]['volo_loan_subject'] = '1231'; //贷方科目
            $volo_data[1]['volo_loan_subject_name'] = '坏账准备'; //贷方科目名称
            $volo_data[1]['volo_loan_price'] = $value->wor_recycle_price / 100; //贷方金额
            $volo_data[1]['volo_update_time'] = date('Y-m-d H:i:s'); //更新时间
            $volo_id_two = DB::table('voucher_loan')->insert($volo_data);
            dump($volo_id_two);
            unset($vore_data);
            unset($volo_data);
        }
        DB::commit();
    }

    // 采购管理,已确认完成数据同步到凭证列表
    public function purchase()
    {
        DB::beginTransaction();
        // 查询状态为确认完成的采购单数据
        $find_puor_data = DB::table('purchase_order')
            ->where('cg_state', 12)
            ->where('is_del', 1)
            ->select('cg_id', 'company_id', 'cg_superior_shop_id', 'cg_shop_id', 'cg_number', 'cg_original_number', 'auditor_user', 'cg_supplyunit', 'cg_amount')
            ->get()->toArray();
        foreach ($find_puor_data as $key => $value) {
            dump($value);
            // exit;
            // 凭证单据报表
            $vore_data['vore_cid'] = $value->company_id; //公司id
            $vore_data['vore_superior_shop_id'] = $value->cg_superior_shop_id; //总店id
            $vore_data['vore_shop_id'] = $value->cg_shop_id; //门店id
            $vore_data['vore_create_id'] = $value->auditor_user; //创建人
            $vore_data['vore_order_type'] = 3; //单号类型1.订单2.工单3.采购单4.销售单
            $vore_data['vore_ord_id'] = $value->cg_id; //采购id
            $vore_data['vore_ord_number'] = $value->cg_number; //采购单号
            if ($value->cg_amount < 0) {
                $vore_data['vore_plus_minus'] = 2; //金额正负1正值2负值
            } else {
                $vore_data['vore_plus_minus'] = 1; //金额正负1正值2负值
            }
            $vore_data['vore_actual_price'] = abs($value->cg_amount); //结算金额
            $vore_data['vore_type'] = 2; //单位类型1会员零售2客户单位3速电派单
            $vore_data['vore_client_id'] = $value->cg_supplyunit; //客户单位/客户id
            // 根据客户单位id,查找客户名称
            $channel_unit = DB::table('channel_unit')
                ->where('chun_id', $value->cg_supplyunit)
                ->value('chun_unit_name');
            $vore_data['vore_channel_unit'] = $channel_unit ? $channel_unit : '';
            $vore_id = DB::table('voucher_receipts')->insertGetId($vore_data);
            dump($vore_id);
            // 凭证借贷表
            $volo_data['volo_shop_id'] = $value->cg_shop_id;
            $volo_data['volo_vore_id'] = $vore_id;
            $volo_data['volo_type'] = 1; //类型1借方2贷方
            $volo_data['volo_borrow_subject'] = '1012'; //借方科目
            $volo_data['volo_borrow_subject_name'] = '其他货币资金'; //借方科目名称
            $volo_data['volo_borrow_price'] = abs($value->cg_amount); //借方金额
            $volo_data['volo_loan_subject'] = '1231'; //贷方科目
            $volo_data['volo_loan_subject_name'] = '坏账准备'; //贷方科目名称
            $volo_data['volo_loan_price'] = abs($value->cg_amount); //贷方金额
            $volo_data['volo_update_time'] = date('Y-m-d H:i:s'); //更新时间
            $volo_id = DB::table('voucher_loan')->insert($volo_data);
            dump($volo_id);
            unset($vore_data);
            unset($volo_data);
        }
        DB::commit();
    }

    // 查询订单数据,更新调整
    public function orders()
    {
        $find_order = DB::table('order')
            ->where('ord_delete', 1)
            ->whereIn('ord_service_type', [3, 4])
            ->select('ord_plus_minus')
            ->get()->toArray();
        foreach ($find_order as $key => $value) {
            dump($value);
            $update_data['ord_order_plus_minus'] = $value->ord_plus_minus;
            $update_data['ord_update_time'] = date('Y-m-d H:i:s');
            $res = DB::table('order')
                ->where('ord_delete', 1)
                ->whereIn('ord_service_type', [3, 4])
                ->update($update_data);
            unset($update_data);
            dump($res);
        }
    }

    public function testss(Request $request)
    {
        ignore_user_abort();
        set_time_limit(0);
        $cid = 1; //公司id
        $superior_shop_id = 1; //总店id
        $shop_id = 1; //门店id
        $time = date('Y-m-d H:i:s');
        $data = DB::table('order')
            ->where('ord_delete', 1)
            ->where('ord_ware_id', '!=', 0)
            ->select('ord_id', 'ord_ware_id')
            ->get()->toArray();
        foreach ($data as $key => $value) {
            // dump($value);
            // exit;
            $update_data['orgo_ware_id'] = $value->ord_ware_id;
            $update_data['orgo_update_time'] = $time;
            $res = DB::table('order_goods')
                ->where('orgo_ord_id', $value->ord_id)
                ->update($update_data);
            unset($update_data);
        }
    }

    public function test1(Request $request)
    {
        ignore_user_abort();
        set_time_limit(0);
        $ware_id = 9; //总部仓库存
        $waon_class = 3; //仓库类别:1.货物仓2.非货物仓3.旧货仓4.临时仓
        $goo_type = 4; //商品类型:1.正常商品2.赠品商品3.活动商品4.旧货商品
        $cid = 1; //公司id
        $superior_shop_id = 1; //总店id
        $shop_id = 1; //门店id
        $search_data = $request->all();
        $find_out_data = DB::table('outin_details as a')
            ->leftJoin('outin_record as b', 'b.oure_id', '=', 'a.oude_oure_id')
            ->leftJoin('goods as d', 'd.goo_id', '=', 'a.oude_goo_id')
            ->where('oure_cid', 1)
            ->where('oure_shop_id', 1)
            ->where('oure_out_ware_id', $ware_id)
            ->select('oure_number', 'oure_original_number', 'goo_name', 'goo_goods_encode', 'goo_id', 'oude_goo_number', 'goo_type', 'oure_waon_class', 'oude_type', 'oure_create_time')
            ->get()->toArray();
        $find_in_data = DB::table('outin_details as a')
            ->leftJoin('outin_record as b', 'b.oure_id', '=', 'a.oude_oure_id')
            ->leftJoin('goods as d', 'd.goo_id', '=', 'a.oude_goo_id')
            ->where('oure_cid', 1)
            ->where('oure_shop_id', 1)
            ->where('oure_in_ware_id', $ware_id)
            ->select('oure_number', 'oure_original_number', 'goo_name', 'goo_goods_encode', 'goo_id', 'oude_goo_number', 'goo_type', 'oure_waon_class', 'oude_type', 'oure_create_time')
            ->get()->toArray();
        // $goo_number_out_amount = [];
        // $goo_number_in_amount = [];
        // $goo_number_amount = [];
        // // 出库数量统计
        // foreach ($find_out_data as $key => $value) {
        //     if (isset($goo_number_out_amount[$value->goo_id])) {
        //         $goo_number_out_amount[$value->goo_id] += $value->oude_goo_number;
        //     }else{
        //         $goo_number_out_amount[$value->goo_id] = $value->oude_goo_number;
        //     }
        // }
        // // 入库数量统计
        // foreach ($find_in_data as $key => $value) {
        //     if (isset($goo_number_in_amount[$value->goo_id])) {
        //         $goo_number_in_amount[$value->goo_id] += $value->oude_goo_number;
        //     }else{
        //         $goo_number_in_amount[$value->goo_id] = $value->oude_goo_number;
        //     }
        // }
        // $goo_number_amount = $goo_number_in_amount;//先赋值入库数量
        // // 计算剩余库存数量，入库数量减去出库数量=剩余库存数量
        // foreach ($goo_number_out_amount as $key => $value) {
        //     if (isset($goo_number_in_amount[$key])) {
        //         $goo_number_amount[$key] = $goo_number_in_amount[$key] - $value;
        //     } else {
        //         $goo_number_amount[$key] = - $value;
        //     }
        // }
        // $goo_number_amount = array_filter($goo_number_amount);
        // // 查询导入的商品数据
        // // $data =DB::table('excel_data_cache0912移动仓数据')->where('exdc_type', 3)->get();
        // $data =DB::table('excel_data_cache')->where('exdc_type', 1)->get();
        // $data = json_decode($data, true);
        // $data_info =[];
        // $cid =1;
        // $shop_id =1;
        // $superior_shop_id =1;
        // foreach ($data as $key => $value) {
        //     $exdc_data = json_decode($value['exdc_data'], true);
        //     // dump($exdc_data);
        //     $find_goo_id = DB::table('goods')
        //         ->where('goo_cid', $cid)
        //         ->where('goo_shop_id', $shop_id)
        //         ->where('goo_superior_shop_id', $superior_shop_id)
        //         ->where('goo_type', $goo_type)
        //         ->where('goo_delete', 1)
        //         ->where('goo_goods_encode', $exdc_data['goo_goods_encode'])
        //         ->select('goo_id')
        //         ->first();
        //     $exdc_data['goo_id'] = $find_goo_id->goo_id;
        //     $data_info[] = $exdc_data;
        // }
        // // exit;
        // $excel_goo_data = array_column($data_info, null, 'goo_id');
        // $excel_goo_data = json_decode(json_encode($excel_goo_data), true);
        // // dump($excel_goo_data);exit;
        // $excel_goo_goods_encode = array_column($data_info, 'goo_goods_encode');

        // $excel_goo_amount = [];//最后剩余数量
        // // 计算仓库最终的库存数量
        // // dump($goo_number_amount);exit;
        // foreach ($goo_number_amount as $key => $value) {
        //     if (isset($excel_goo_amount[$key])) {
        //         $excel_goo_amount[$key] += $excel_goo_data[$key]['jhcy'] + $value;//固定仓
        //         unset($excel_goo_data[$key]);
        //     } else {
        //         // 固定仓
        //         if (isset($excel_goo_data[$key]['jhcy'])) {
        //             if (!empty($excel_goo_data[$key]['jhcy'])) {
        //                 $excel_goo_amount[$key] = $excel_goo_data[$key]['jhcy'] + $value;//固定仓
        //                 unset($excel_goo_data[$key]);
        //             } else {
        //                 $excel_goo_amount[$key] = $value;//固定仓
        //             }
        //         } else {
        //             $excel_goo_amount[$key] = $value;
        //         }
        //         if ($excel_goo_amount[$key] < 0) {
        //             $excel_goods_fu[$key] = $excel_goo_amount[$key];//固定仓
        //         } else {
        //             $excel_goods_zheng[$key] = $excel_goo_amount[$key];//固定仓
        //         }
        //     }
        // }
        // // dump($excel_goods_fu);
        // // dump($excel_goods_zheng);
        // // dump($excel_goo_amount);
        // // exit;
        // if (!empty($excel_goo_data)) {
        //     $ids = array_column($excel_goo_data, 'jhcy', 'goo_id');
        //     // dump($ids);
        //     // $arr = array_combine($ids, $excel_goods_zheng);
        //     $arr = $ids + $excel_goods_zheng;
        //     $excel_goods_zheng = $arr;
        // }
        // // 读取负值
        // if (isset($excel_goods_fu)) {
        //     foreach ($excel_goods_fu as $goo_id => $value) {
        //         $wagk_data['wagk_ware_id'] = $ware_id;
        //         $wagk_data['wagk_class'] = $waon_class;
        //         $wagk_data['wagk_goo_id'] = $key;
        //         $wagk_data['wagk_stock_number'] = $value;
        //         $wagk_data['wagk_update_time'] = $this->now_time;
        //         $wagk_res = DB::table('warehouse_goods_kucun')->insert($wagk_data);
        //     }
        // }
        // // foreach ($excel_goo_amount as $goo_id => $value) {
        // foreach ($excel_goods_zheng as $goo_id => $value) {
        //     // dump($value);exit;
        //     $wago_id= DB::table('warehouse_goods')
        //         ->where('wago_ware_id', $ware_id)
        //         ->where('wago_goo_id', $goo_id)
        //         ->where('wago_class', $waon_class)
        //         ->value('wago_id');
        //     dump($wago_id);
        //     if (empty($wago_id)) {
        //         // 仓库内没有商品，添加商品
        //         $warehouse_goods['wago_ware_id'] = $ware_id;//仓库
        //         $warehouse_goods['wago_class'] = $waon_class;
        //         $warehouse_goods['wago_goo_id'] = $goo_id;//商品
        //         // $warehouse_goods['wago_stock_number'] = $value;//良品库存
        //         $warehouse_goods['wago_priority_stock_number'] = $value;//优先库存
        //         $warehouse_goods['wago_update_time'] = $this->now_time;//更新时间
        //         $wago_res = DB::table('warehouse_goods')->insert($warehouse_goods);
        //         dump($wago_res);
        //     } else {
        //         // 仓库内已经有商品了，更改库存数量
        //         // $edit_data['wago_stock_number'] = $value;//良品库存
        //         $edit_data['wago_priority_stock_number'] = $value;//优先库存
        //         $edit_data['wago_update_time'] = $this->now_time;
        //         dump($edit_data);
        //         $res= DB::table('warehouse_goods')
        //             ->where('wago_ware_id', $ware_id)
        //             ->where('wago_goo_id', $goo_id)
        //             ->where('wago_class', $waon_class)
        //             ->update($edit_data);
        //         dump($res);
        //     }
        // }
        // $find_waon_data = DB::table('warehouse_onhand')
        //     ->where('waon_ware_id', $ware_id)
        //     ->where('waon_class', $waon_class)
        //     ->first();
        // $waon_edit['waon_all_amount'] = $find_waon_data->waon_all_amount + array_sum($excel_goods_zheng);
        // // $waon_edit['waon_stock_fine_amount'] = $find_waon_data->waon_stock_fine_amount + array_sum($excel_goods_zheng);//良品库存
        // $waon_edit['waon_stock_fine_amount'] = $find_waon_data->waon_stock_fine_amount + array_sum($excel_goods_zheng);//优先库存
        // $waon_edit['waon_update_time'] = $this->now_time;
        // $res = DB::table('warehouse_onhand')
        //     ->where('waon_ware_id', $ware_id)
        //     ->where('waon_class', $waon_class)
        //     ->update($waon_edit);
        // dump($res);
        // die;
        // dump($excel_goods_zheng);exit;
        // $data = $find_out_data;//出库
        $data = $find_in_data; //入库
        if (!empty($data)) {
            // 将对象转化为数组
            $data = json_decode(json_encode($data), true);
            foreach ($data as $key => $value) {
                // 结算方式
                if ($value['goo_type'] == 1) {
                    $data[$key]['goo_type'] = '正常';
                }
                if ($value['goo_type'] == 2) {
                    $data[$key]['goo_type'] = '赠品';
                }
                if ($value['goo_type'] == 4) {
                    $data[$key]['goo_type'] = '旧货';
                }

                if ($value['oure_waon_class'] == 1) {
                    $data[$key]['oure_waon_class'] = '货物仓';
                }
                if ($value['oure_waon_class'] == 2) {
                    $data[$key]['oure_waon_class'] = '非商品仓';
                }
                if ($value['oure_waon_class'] == 3) {
                    $data[$key]['oure_waon_class'] = '旧货仓';
                }
                if ($value['oure_waon_class'] == 4) {
                    $data[$key]['oure_waon_class'] = '临时仓';
                }
                if ($value['oude_type'] == 1) {
                    $data[$key]['oude_type'] = '良品';
                } else {
                    $data[$key]['oude_type'] = '优先';
                }
                //商品编号
                // $data[$key]['goo_goods_encode'] = "\t".empty($value['goo_goods_encode']) ? '' : $value['goo_goods_encode'];
                $data[$key]['goo_name'] = empty($value['goo_name']) ? '' : $value['goo_name'];
            }
        } else {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'没有符合条件的数据']);
        }
        $pathName = storage_path() . "/app/public/excel"; //获取上传excel路径
        // 创建文件夹
        if (!file_exists($pathName)) {
            mkdir($pathName, 0775, true);
            chmod($pathName, 0775);
        }

        // $streamFileRand = time() . rand(10000, 99999).'A1总仓出库记录.xls';
        $streamFileRand = time() . rand(10000, 99999) . 'A1总仓入库记录.xls';
        // 产生一个随机文件名（因为你base64上来肯定没有文件名，这里你可以自己设置一个也行）
        $streamFilename = $pathName . '/' . $streamFileRand;

        $where['action_name'] = '出入库记录'; //
        $where['field_name'] = ['单号', '原始单号', '商品名称', '商品编号', '商品id', '数量', '商品类型', '仓库类别', '出入库类型', '操作时间'];
        // 调用导出的公共方法
        export::publicExport(
            $streamFilename, //路径
            $where,    //sheet名及其每一行的标题
            $data      //导出数据
        );

        // 判断文件是否存在 存在则成功  不存在则失败
        if (file_exists($streamFilename)) {
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>'http://mk.bluearp.com/storage/excel/' . $streamFileRand]);
        } else {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'导出失败']);
        }
    }

    // 发货单客户单位调整
    public function tests(Request $request)
    {
        ignore_user_abort();
        set_time_limit(0);
        $cid = 1; //公司id
        $superior_shop_id = 1; //总店id
        $shop_id = 1; //门店id
        $time = date('Y-m-d H:i:s');
        $data = DB::table('dispatch_bill')
            ->where('dego_client_id', '=', 0)
            ->select('dego_wor_id', 'dego_order_type')
            ->get()->toArray();
        foreach ($data as $key => $value) {
            dump($value);
            if ($value->dego_order_type == 1) { //类型：1.订单发货
                // 根据订单id,查询出买家类型和客户id
                $find_order = DB::table('order as ord')
                    ->leftjoin('order_client as orcl', 'orcl.orcl_ord_id', '=', 'ord.ord_id')
                    ->where('ord_id', $value->dego_wor_id)
                    ->where('ord_delete', 1)
                    ->select('ord_type', 'ord_client_id', 'ord_id')
                    ->first();
                if (empty($find_order)) {
                    continue;
                }
                $update_data['dego_client_type'] = $find_order->ord_type;
                $update_data['dego_client_id'] = $find_order->ord_client_id;
                $update_data['dego_update_time'] = $time;
                $res = DB::table('dispatch_bill')
                    ->where('dego_wor_id', $find_order->ord_id)
                    ->where('dego_order_type', 1)
                    ->update($update_data);
                unset($update_data);
            } elseif ($value->dego_order_type == 2) { //类型：2.工单发货
                // 根据工单id,查询出买家类型和客户id
                $find_work_order = DB::table('work_order as wor')
                    ->leftjoin('work_client as wocl', 'wocl.wocl_wor_id', '=', 'wor.wor_id')
                    ->where('wor_id', $value->dego_wor_id)
                    ->select('wor_type', 'wocl_client_id', 'wor_id')
                    ->first();
                if (empty($find_work_order)) {
                    continue;
                }
                $update_data['dego_client_type'] = $find_work_order->wor_type;
                $update_data['dego_client_id'] = $find_work_order->wocl_client_id;
                $update_data['dego_update_time'] = $time;
                $res = DB::table('dispatch_bill')
                    ->where('dego_wor_id', $find_work_order->wor_id)
                    ->where('dego_order_type', 2)
                    ->update($update_data);
                unset($update_data);
            } elseif ($value->dego_order_type == 3) { //类型：3售后单发货
                // 根据订单id,查询出买家类型和客户id
                $find_order_after = DB::table('order_after as oraf')
                    ->where('oraf_id', $value->dego_wor_id)
                    ->select('oraf_type', 'oraf_client_id', 'oraf_id')
                    ->first();
                if (empty($find_order_after)) {
                    continue;
                }
                $update_data['dego_client_type'] = $find_order_after->oraf_type;
                $update_data['dego_client_id'] = $find_order_after->oraf_client_id;
                $update_data['dego_update_time'] = $time;
                $res = DB::table('dispatch_bill')
                    ->where('dego_wor_id', $find_order_after->oraf_id)
                    ->where('dego_order_type', 3)
                    ->update($update_data);
                unset($update_data);
            }
        }
    }

    // 导出数据
    public function downExcelData(Request $request)
    {
        ignore_user_abort();
        set_time_limit(0);
        // $ware_id = 30;//黄行渊
        $ware_id = $request['ware_id']; //黄行渊
        $waon_class = 1; //仓库类别1货物仓2非货物仓3旧货仓4临时仓
        $goo_type = 1; //商品类型1正常商品2临时商品3活动商品4旧货商品
        $cid = 1; //公司id
        $superior_shop_id = 1; //总店id
        $shop_id = 1; //门店id
        // return response()->json(['code'=> 200, 'msg'=>'success', 'data'=>'http://mk.bluearp.com/storage/excel/移动仓库']);

        $ware_name = [
            '9' => 'A1总部仓',
            '10' => 'A2仙岳仓',
            '11' => 'A3前埔仓',
            '13' => 'A6灌口仓',
            '14' => 'A7同安仓',
            '15' => '杨总',
            '16' => '杨少英',
            '17' => '苏远仁',
            '18' => '刘启睿（闽D9C386）',
            '19' => '接单账号',
            '20' => '朱靖轩',
            '21' => '王文泉',
            '22' => '杨家辉',
            '24' => '周贤林',
            '25' => '贾琳',
            '26' => '黄行敏',
            '27' => '蒋文华',
            '28' => '张武军',
            '29' => '白文革',
            '30' => '黄行渊',
            '31' => '王德志',
            '32' => '林观书',
            '33' => '王木荣（闽DP1M08）',
            '34' => '吴文祥（闽D937Q7）',
            '35' => '周志鹏（闽DP1K79）',
            '36' => '黄行顺（闽DG8U13）',
            '37' => '杨阳（闽DN3K50）',
            '38' => '何官国',
            '39' => '陈德围',
            '40' => '林土水（闽DC923T）',
            '41' => '吴凤玉',
            '45' => '宁山',
            '115' => '高庆国',
        ];
        $search_data = $request->all();
        $find_out_data = DB::table('outin_details as a')
            ->leftJoin('outin_record as b', 'b.oure_id', '=', 'a.oude_oure_id')
            ->leftJoin('goods as d', 'd.goo_id', '=', 'a.oude_goo_id')
            ->where('oure_cid', 1)
            ->where('oure_shop_id', 1)
            ->where('oure_out_ware_id', $ware_id)
            ->select('oure_number', 'oure_original_number', 'goo_name', 'goo_goods_encode', 'goo_id', 'oude_goo_number', 'goo_type', 'oure_waon_class', 'oure_create_time')
            ->get()->toArray();
        $find_in_data = DB::table('outin_details as a')
            ->leftJoin('outin_record as b', 'b.oure_id', '=', 'a.oude_oure_id')
            ->leftJoin('goods as d', 'd.goo_id', '=', 'a.oude_goo_id')
            ->where('oure_cid', 1)
            ->where('oure_shop_id', 1)
            ->where('oure_in_ware_id', $ware_id)
            ->select('oure_number', 'oure_original_number', 'goo_name', 'goo_goods_encode', 'goo_id', 'oude_goo_number', 'goo_type', 'oure_waon_class', 'oure_create_time')
            ->get()->toArray();
        if ($request['type'] == 1) {
            $data = $find_in_data; //入库
            $file_name = $ware_name[$ware_id] . '入库记录';
        } else {
            $data = $find_out_data; //出库
            $file_name = $ware_name[$ware_id] . '出库记录';
        }
        if (!empty($data)) {
            // 将对象转化为数组
            $data = json_decode(json_encode($data), true);
            foreach ($data as $key => $value) {
                // 结算方式
                if ($value['goo_type'] == 1) {
                    $data[$key]['goo_type'] = '正常';
                }
                if ($value['goo_type'] == 2) {
                    $data[$key]['goo_type'] = '赠品';
                }
                if ($value['goo_type'] == 4) {
                    $data[$key]['goo_type'] = '旧货';
                }

                if ($value['oure_waon_class'] == 1) {
                    $data[$key]['oure_waon_class'] = '货物仓';
                }
                if ($value['oure_waon_class'] == 2) {
                    $data[$key]['oure_waon_class'] = '非商品仓';
                }
                if ($value['oure_waon_class'] == 3) {
                    $data[$key]['oure_waon_class'] = '旧货仓';
                }
                if ($value['oure_waon_class'] == 4) {
                    $data[$key]['oure_waon_class'] = '临时仓';
                }
                //商品编号
                // $data[$key]['goo_goods_encode'] = "\t".empty($value['goo_goods_encode']) ? '' : $value['goo_goods_encode'];
                $data[$key]['goo_name'] = empty($value['goo_name']) ? '' : $value['goo_name'];
            }
        } else {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'没有符合条件的数据']);
        }
        $pathName = storage_path() . "/app/public/excel"; //获取上传excel路径
        // 创建文件夹
        if (!file_exists($pathName)) {
            mkdir($pathName, 0775, true);
            chmod($pathName, 0775);
        }
        $streamFileRand = time() . rand(10000, 99999) . $file_name . '.xls'; //
        // 产生一个随机文件名（因为你base64上来肯定没有文件名，这里你可以自己设置一个也行）
        $streamFilename = $pathName . '/' . $streamFileRand;

        $where['action_name'] = '出入库记录'; //
        $where['field_name'] = ['单号', '原始单号', '商品名称', '商品编号', '商品id', '数量', '类型', '仓库类别', '操作时间'];
        // 调用导出的公共方法
        export::publicExport(
            $streamFilename, //路径
            $where,    //sheet名及其每一行的标题
            $data      //导出数据
        );

        // 判断文件是否存在 存在则成功  不存在则失败
        if (file_exists($streamFilename)) {
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>'http://mk.bluearp.com/storage/excel/' . $streamFileRand]);
        } else {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'导出失败']);
        }
    }

    // A2仙岳仓库存操作
    public function test2(Request $request)
    {
        ignore_user_abort();
        set_time_limit(0);
        $ware_id = 10; //仙岳仓库存
        $waon_class = 3; //仓库类别1货物仓2非货物仓3旧货仓4临时仓
        $goo_type = 4; //商品类型
        $cid = 1; //公司id
        $superior_shop_id = 1; //总店id
        $shop_id = 1; //门店id
        $search_data = $request->all();
        $find_out_data = DB::table('outin_details as a')
            ->leftJoin('outin_record as b', 'b.oure_id', '=', 'a.oude_oure_id')
            ->leftJoin('goods as d', 'd.goo_id', '=', 'a.oude_goo_id')
            ->where('oure_cid', 1)
            ->where('oure_shop_id', 1)
            ->where('oure_out_ware_id', $ware_id)
            ->select('oure_number', 'oure_original_number', 'goo_name', 'goo_goods_encode', 'goo_id', 'oude_goo_number', 'goo_type', 'oure_waon_class', 'oude_type', 'oure_create_time')
            ->get()->toArray();
        $find_in_data = DB::table('outin_details as a')
            ->leftJoin('outin_record as b', 'b.oure_id', '=', 'a.oude_oure_id')
            ->leftJoin('goods as d', 'd.goo_id', '=', 'a.oude_goo_id')
            ->where('oure_cid', 1)
            ->where('oure_shop_id', 1)
            ->where('oure_in_ware_id', $ware_id)
            ->select('oure_number', 'oure_original_number', 'goo_name', 'goo_goods_encode', 'goo_id', 'oude_goo_number', 'goo_type', 'oure_waon_class', 'oude_type', 'oure_create_time')
            ->get()->toArray();
        // $goo_number_out_amount = [];
        // $goo_number_in_amount = [];
        // $goo_number_amount = [];
        // // 出库数量统计
        // foreach ($find_out_data as $key => $value) {
        //     if (isset($goo_number_out_amount[$value->goo_id])) {
        //         $goo_number_out_amount[$value->goo_id] += $value->oude_goo_number;
        //     }else{
        //         $goo_number_out_amount[$value->goo_id] = $value->oude_goo_number;
        //     }
        // }
        // // 入库数量统计
        // foreach ($find_in_data as $key => $value) {
        //     if (isset($goo_number_in_amount[$value->goo_id])) {
        //         $goo_number_in_amount[$value->goo_id] += $value->oude_goo_number;
        //     }else{
        //         $goo_number_in_amount[$value->goo_id] = $value->oude_goo_number;
        //     }
        // }
        // $goo_number_amount = $goo_number_in_amount;//先赋值入库数量
        // // 计算剩余库存数量，入库数量减去出库数量=剩余库存数量
        // foreach ($goo_number_out_amount as $key => $value) {
        //     if (isset($goo_number_in_amount[$key])) {
        //         $goo_number_amount[$key] = $goo_number_in_amount[$key] - $value;
        //     } else {
        //         $goo_number_amount[$key] = - $value;
        //     }
        // }
        // $goo_number_amount = array_filter($goo_number_amount);
        // // 查询导入的商品数据
        // $data =DB::table('excel_data_cache')->where('exdc_type', 2)->get();
        // $data = json_decode($data, true);
        // $data_info =[];
        // $cid =1;
        // $shop_id =1;
        // $superior_shop_id =1;
        // foreach ($data as $key => $value) {
        //     $exdc_data = json_decode($value['exdc_data'], true);
        //     // dump($exdc_data);
        //     $find_goo_id = DB::table('goods')
        //         ->where('goo_cid', $cid)
        //         ->where('goo_shop_id', $shop_id)
        //         ->where('goo_superior_shop_id', $superior_shop_id)
        //         ->where('goo_type', $goo_type)
        //         ->where('goo_delete', 1)
        //         ->where('goo_goods_encode', $exdc_data['goo_goods_encode'])
        //         ->select('goo_id')
        //         ->first();
        //     $exdc_data['goo_id'] = $find_goo_id->goo_id;
        //     $data_info[] = $exdc_data;
        // }
        // // exit;
        // $excel_goo_data = array_column($data_info, null, 'goo_id');
        // $excel_goo_data = json_decode(json_encode($excel_goo_data), true);
        // // dump($excel_goo_data);exit;
        // $excel_goo_goods_encode = array_column($data_info, 'goo_goods_encode');

        // $excel_goo_amount = [];//最后剩余数量
        // // 计算仓库最终的库存数量
        // // dump($goo_number_amount);exit;
        // foreach ($goo_number_amount as $key => $value) {
        //     if (isset($excel_goo_amount[$key])) {
        //         $excel_goo_amount[$key] += $excel_goo_data[$key]['jhcy'] + $value;//固定仓
        //         unset($excel_goo_data[$key]);
        //     } else {
        //         // 固定仓
        //         if (isset($excel_goo_data[$key]['jhcy'])) {
        //             if (!empty($excel_goo_data[$key]['jhcy'])) {
        //                 $excel_goo_amount[$key] = $excel_goo_data[$key]['jhcy'] + $value;//固定仓
        //                 unset($excel_goo_data[$key]);
        //             } else {
        //                 $excel_goo_amount[$key] = $value;//固定仓
        //             }
        //         } else {
        //             $excel_goo_amount[$key] = $value;
        //         }
        //         if ($excel_goo_amount[$key] < 0) {
        //             $excel_goods_fu[$key] = $excel_goo_amount[$key];//固定仓
        //         } else {
        //             $excel_goods_zheng[$key] = $excel_goo_amount[$key];//固定仓
        //         }
        //     }
        // }
        // // dump($excel_goods_fu);
        // // dump($excel_goods_zheng);
        // // dump($excel_goo_amount);
        // // exit;
        // if (!empty($excel_goo_data)) {
        //     $ids = array_column($excel_goo_data, 'jhcy', 'goo_id');
        //     // dump($ids);
        //     // $arr = array_combine($ids, $excel_goods_zheng);
        //     $arr = $ids + $excel_goods_zheng;
        //     $excel_goods_zheng = $arr;
        // }
        // // 读取负值
        // if (isset($excel_goods_fu)) {
        //     foreach ($excel_goods_fu as $goo_id => $value) {
        //         $wagk_data['wagk_ware_id'] = $ware_id;
        //         $wagk_data['wagk_class'] = $waon_class;
        //         $wagk_data['wagk_goo_id'] = $key;
        //         $wagk_data['wagk_stock_number'] = $value;
        //         $wagk_data['wagk_update_time'] = $this->now_time;
        //         $wagk_res = DB::table('warehouse_goods_kucun')->insert($wagk_data);
        //     }
        // }
        // foreach ($excel_goods_zheng as $goo_id => $value) {
        //     // dump($value);exit;
        //     $wago_id= DB::table('warehouse_goods')
        //         ->where('wago_ware_id', $ware_id)
        //         ->where('wago_goo_id', $goo_id)
        //         ->where('wago_class', $waon_class)
        //         ->value('wago_id');
        //     dump($wago_id);
        //     if (empty($wago_id)) {
        //         // 仓库内没有商品，添加商品
        //         $warehouse_goods['wago_ware_id'] = $ware_id;//仓库
        //         $warehouse_goods['wago_class'] = $waon_class;
        //         $warehouse_goods['wago_goo_id'] = $goo_id;//商品
        //         // $warehouse_goods['wago_stock_number'] = $value;//良品库存
        //         $warehouse_goods['wago_priority_stock_number'] = $value;//优先库存
        //         $warehouse_goods['wago_update_time'] = $this->now_time;//更新时间
        //         $wago_res = DB::table('warehouse_goods')->insert($warehouse_goods);
        //         dump($wago_res);
        //         // unset($warehouse_goods);
        //     } else {
        //         // 仓库内已经有商品了，更改库存数量
        //         // $edit_data['wago_stock_number'] = $value;//良品库存
        //         $edit_data['wago_priority_stock_number'] = $value;//优先库存
        //         $edit_data['wago_update_time'] = $this->now_time;
        //         dump($edit_data);
        //         $res= DB::table('warehouse_goods')
        //             ->where('wago_ware_id', $ware_id)
        //             ->where('wago_goo_id', $goo_id)
        //             ->where('wago_class', $waon_class)
        //             ->update($edit_data);
        //         dump($res);
        //     }
        // }
        // $find_waon_data = DB::table('warehouse_onhand')
        //     ->where('waon_ware_id', $ware_id)
        //     ->where('waon_class', $waon_class)
        //     ->first();
        // $waon_edit['waon_all_amount'] = $find_waon_data->waon_all_amount + array_sum($excel_goods_zheng);
        // // $waon_edit['waon_stock_fine_amount'] = $find_waon_data->waon_stock_fine_amount + array_sum($excel_goods_zheng);//良品库存
        // $waon_edit['waon_stock_priority_amount'] = $find_waon_data->waon_stock_priority_amount + array_sum($excel_goods_zheng);//优先库存
        // $waon_edit['waon_update_time'] = $this->now_time;
        // $res = DB::table('warehouse_onhand')
        //     ->where('waon_ware_id', $ware_id)
        //     ->where('waon_class', $waon_class)
        //     ->update($waon_edit);
        // dump($res);
        // die;
        // dump($excel_goods_zheng);exit;
        // $data = $find_out_data;//出库
        $data = $find_in_data; //入库
        if (!empty($data)) {
            // 将对象转化为数组
            $data = json_decode(json_encode($data), true);
            foreach ($data as $key => $value) {
                // 结算方式
                if ($value['goo_type'] == 1) {
                    $data[$key]['goo_type'] = '正常';
                }
                if ($value['goo_type'] == 2) {
                    $data[$key]['goo_type'] = '赠品';
                }
                if ($value['goo_type'] == 4) {
                    $data[$key]['goo_type'] = '旧货';
                }

                if ($value['oure_waon_class'] == 1) {
                    $data[$key]['oure_waon_class'] = '货物仓';
                }
                if ($value['oure_waon_class'] == 2) {
                    $data[$key]['oure_waon_class'] = '非商品仓';
                }
                if ($value['oure_waon_class'] == 3) {
                    $data[$key]['oure_waon_class'] = '旧货仓';
                }
                if ($value['oure_waon_class'] == 4) {
                    $data[$key]['oure_waon_class'] = '临时仓';
                }
                if ($value['oude_type'] == 1) {
                    $data[$key]['oude_type'] = '良品';
                } else {
                    $data[$key]['oude_type'] = '优先';
                }
                //商品编号
                // $data[$key]['goo_goods_encode'] = "\t".empty($value['goo_goods_encode']) ? '' : $value['goo_goods_encode'];
                $data[$key]['goo_name'] = empty($value['goo_name']) ? '' : $value['goo_name'];
            }
        } else {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'没有符合条件的数据']);
        }
        $pathName = storage_path() . "/app/public/excel"; //获取上传excel路径
        // 创建文件夹
        if (!file_exists($pathName)) {
            mkdir($pathName, 0775, true);
            chmod($pathName, 0775);
        }

        // $streamFileRand = time() . rand(10000, 99999).'A2仙岳仓库存出库记录.xls';//
        $streamFileRand = time() . rand(10000, 99999) . 'A2仙岳仓库存入库记录.xls'; //
        // 产生一个随机文件名（因为你base64上来肯定没有文件名，这里你可以自己设置一个也行）
        $streamFilename = $pathName . '/' . $streamFileRand;

        $where['action_name'] = '出入库记录'; //
        $where['field_name'] = ['单号', '原始单号', '商品名称', '商品编号', '商品id', '数量', '商品类型', '仓库类别', '出入库类型', '操作时间'];
        // 调用导出的公共方法
        export::publicExport(
            $streamFilename, //路径
            $where,    //sheet名及其每一行的标题
            $data      //导出数据
        );

        // 判断文件是否存在 存在则成功  不存在则失败
        if (file_exists($streamFilename)) {
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>'http://mk.bluearp.com/storage/excel/' . $streamFileRand]);
        } else {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'导出失败']);
        }
    }

    // A3前埔仓库存操作
    public function test3(Request $request)
    {
        ignore_user_abort();
        set_time_limit(0);
        $ware_id = 11; //前埔店库存
        $waon_class = 3; //仓库类别:1.货物仓2.非货物仓3.旧货仓4.临时仓
        $goo_type = 4; //商品类型:1.正常商品2.赠品商品3.活动商品4.旧货商品
        $cid = 1; //公司id
        $superior_shop_id = 1; //总店id
        $shop_id = 1; //门店id
        $search_data = $request->all();
        $find_out_data = DB::table('outin_details as a')
            ->leftJoin('outin_record as b', 'b.oure_id', '=', 'a.oude_oure_id')
            ->leftJoin('goods as d', 'd.goo_id', '=', 'a.oude_goo_id')
            ->where('oure_cid', 1)
            ->where('oure_shop_id', 1)
            ->where('oure_out_ware_id', $ware_id)
            // ->where('oure_waon_class', $waon_class)
            // ->where('oure_create_time', '<', '2020-09-16 14:30:00')
            ->select('oure_number', 'oure_original_number', 'goo_name', 'goo_goods_encode', 'goo_id', 'oude_goo_number', 'goo_type', 'oure_waon_class', 'oude_type', 'oure_create_time')
            ->get()->toArray();
        $find_in_data = DB::table('outin_details as a')
            ->leftJoin('outin_record as b', 'b.oure_id', '=', 'a.oude_oure_id')
            ->leftJoin('goods as d', 'd.goo_id', '=', 'a.oude_goo_id')
            ->where('oure_cid', 1)
            ->where('oure_shop_id', 1)
            ->where('oure_in_ware_id', $ware_id)
            // ->where('oure_waon_class', $waon_class)
            // ->where('oure_create_time', '<', '2020-09-16 14:30:00')
            ->select('oure_number', 'oure_original_number', 'goo_name', 'goo_goods_encode', 'goo_id', 'oude_goo_number', 'goo_type', 'oure_waon_class', 'oude_type', 'oure_create_time')
            ->get()->toArray();
        // $goo_number_out_amount = [];
        // $goo_number_in_amount = [];
        // $goo_number_amount = [];
        // // 出库数量统计
        // foreach ($find_out_data as $key => $value) {
        //     if (isset($goo_number_out_amount[$value->goo_id])) {
        //         $goo_number_out_amount[$value->goo_id] += $value->oude_goo_number;
        //     }else{
        //         $goo_number_out_amount[$value->goo_id] = $value->oude_goo_number;
        //     }
        // }
        // // 入库数量统计
        // foreach ($find_in_data as $key => $value) {
        //     if (isset($goo_number_in_amount[$value->goo_id])) {
        //         $goo_number_in_amount[$value->goo_id] += $value->oude_goo_number;
        //     }else{
        //         $goo_number_in_amount[$value->goo_id] = $value->oude_goo_number;
        //     }
        // }
        // $goo_number_amount = $goo_number_in_amount;//先赋值入库数量
        // // 计算剩余库存数量，入库数量减去出库数量=剩余库存数量
        // foreach ($goo_number_out_amount as $key => $value) {
        //     if (isset($goo_number_in_amount[$key])) {
        //         $goo_number_amount[$key] = $goo_number_in_amount[$key] - $value;
        //     } else {
        //         $goo_number_amount[$key] = - $value;
        //     }
        // }
        // $goo_number_amount = array_filter($goo_number_amount);
        // // 查询导入的商品数据
        // $data =DB::table('excel_data_cache')->where('exdc_type', 3)->get();
        // $data = json_decode($data, true);
        // $data_info =[];
        // $cid =1;
        // $shop_id =1;
        // $superior_shop_id =1;
        // foreach ($data as $key => $value) {
        //     $exdc_data = json_decode($value['exdc_data'], true);
        //     // dump($exdc_data);
        //     $find_goo_id = DB::table('goods')
        //         ->where('goo_cid', $cid)
        //         ->where('goo_shop_id', $shop_id)
        //         ->where('goo_superior_shop_id', $superior_shop_id)
        //         ->where('goo_type', $goo_type)
        //         ->where('goo_delete', 1)
        //         ->where('goo_goods_encode', $exdc_data['goo_goods_encode'])
        //         ->select('goo_id')
        //         ->first();
        //     $exdc_data['goo_id'] = $find_goo_id->goo_id;
        //     $data_info[] = $exdc_data;
        // }
        // // exit;
        // $excel_goo_data = array_column($data_info, null, 'goo_id');
        // $excel_goo_data = json_decode(json_encode($excel_goo_data), true);
        // $excel_goo_goods_encode = array_column($data_info, 'goo_goods_encode');

        // $excel_goo_amount = [];//最后剩余数量
        // // 计算仓库最终的库存数量
        // foreach ($goo_number_amount as $key => $value) {
        //     if (isset($excel_goo_amount[$key])) {
        //         $excel_goo_amount[$key] += $excel_goo_data[$key]['jhcy'] + $value;//固定仓
        //         unset($excel_goo_data[$key]);
        //     } else {
        //         // 固定仓
        //         if (isset($excel_goo_data[$key]['jhcy'])) {
        //             if (!empty($excel_goo_data[$key]['jhcy'])) {
        //                 $excel_goo_amount[$key] = $excel_goo_data[$key]['jhcy'] + $value;//固定仓
        //                 unset($excel_goo_data[$key]);
        //             } else {
        //                 $excel_goo_amount[$key] = $value;//固定仓
        //             }
        //         } else {
        //             $excel_goo_amount[$key] = $value;
        //         }
        //         if ($excel_goo_amount[$key] < 0) {
        //             $excel_goods_fu[$key] = $excel_goo_amount[$key];//固定仓
        //         } else {
        //             $excel_goods_zheng[$key] = $excel_goo_amount[$key];//固定仓
        //         }
        //     }
        // }
        // // dump($excel_goo_amount);
        // // dump($excel_goods_fu);
        // // dump($excel_goods_zheng);
        // // dump($excel_goo_amount);
        // // exit;
        // if (!empty($excel_goo_data)) {
        //     $ids = array_column($excel_goo_data, 'jhcy', 'goo_id');
        //     $arr = $ids + $excel_goods_zheng;
        //     $excel_goods_zheng = $arr;
        // }
        // // dump($ids);
        // // dump($excel_goods_zheng);
        // // exit;
        // // 读取负值
        // if (isset($excel_goods_fu)) {
        //     foreach ($excel_goods_fu as $goo_id => $value) {
        //         $wagk_data['wagk_ware_id'] = $ware_id;
        //         $wagk_data['wagk_class'] = $waon_class;
        //         $wagk_data['wagk_goo_id'] = $key;
        //         $wagk_data['wagk_stock_number'] = $value;
        //         $wagk_data['wagk_update_time'] = $this->now_time;
        //         $wagk_res = DB::table('warehouse_goods_kucun')->insert($wagk_data);
        //     }
        // }
        // foreach ($excel_goods_zheng as $goo_id => $value) {
        //     // dump($value);exit;
        //     $wago_id= DB::table('warehouse_goods')
        //         ->where('wago_ware_id', $ware_id)
        //         ->where('wago_goo_id', $goo_id)
        //         ->where('wago_class', $waon_class)
        //         ->value('wago_id');
        //     dump($wago_id);
        //     if (empty($wago_id)) {
        //         // 仓库内没有商品，添加商品
        //         $warehouse_goods['wago_ware_id'] = $ware_id;//仓库
        //         $warehouse_goods['wago_class'] = $waon_class;
        //         $warehouse_goods['wago_goo_id'] = $goo_id;//商品
        //         // $warehouse_goods['wago_stock_number'] = $value;//良品库存
        //         $warehouse_goods['wago_priority_stock_number'] = $value;//优先库存
        //         // $warehouse_goods['wago_unchecked_stock_number'] = $value;//待检测库存数量
        //         $warehouse_goods['wago_update_time'] = $this->now_time;//更新时间
        //         $wago_res = DB::table('warehouse_goods')->insert($warehouse_goods);
        //         dump($wago_res);
        //         // unset($warehouse_goods);
        //     } else {
        //         // 仓库内已经有商品了，更改库存数量
        //         // $edit_data['wago_stock_number'] = $value;//良品库存数量
        //         $edit_data['wago_priority_stock_number'] = $value;//优先库存数量
        //         // $edit_data['wago_unchecked_stock_number'] = $value;//待检测库存数量
        //         $edit_data['wago_update_time'] = $this->now_time;
        //         dump($edit_data);
        //         $res= DB::table('warehouse_goods')
        //             ->where('wago_ware_id', $ware_id)
        //             ->where('wago_goo_id', $goo_id)
        //             ->where('wago_class', $waon_class)
        //             ->update($edit_data);
        //         dump($res);
        //     }
        // }
        // $find_waon_data = DB::table('warehouse_onhand')
        //     ->where('waon_ware_id', $ware_id)
        //     ->where('waon_class', $waon_class)
        //     ->first();
        // $waon_edit['waon_all_amount'] = $find_waon_data->waon_all_amount + array_sum($excel_goods_zheng);
        // // $waon_edit['waon_stock_fine_amount'] = $find_waon_data->waon_stock_fine_amount + array_sum($excel_goods_zheng);//良品总库存
        // $waon_edit['waon_stock_priority_amount'] = $find_waon_data->waon_stock_priority_amount + array_sum($excel_goods_zheng);//优先总库存
        // // $waon_edit['waon_stock_unchecked_amount'] = $find_waon_data->waon_stock_unchecked_amount + array_sum($excel_goods_zheng);//待检测总库存
        // $waon_edit['waon_update_time'] = $this->now_time;
        // $res = DB::table('warehouse_onhand')
        //     ->where('waon_ware_id', $ware_id)
        //     ->where('waon_class', $waon_class)
        //     ->update($waon_edit);
        // dump($res);
        // die;
        // dump($excel_goods_zheng);exit;
        // $data = $find_out_data;//出库
        $data = $find_in_data; //入库
        if (!empty($data)) {
            // 将对象转化为数组
            $data = json_decode(json_encode($data), true);
            foreach ($data as $key => $value) {
                // 结算方式
                if ($value['goo_type'] == 1) {
                    $data[$key]['goo_type'] = '正常';
                }
                if ($value['goo_type'] == 2) {
                    $data[$key]['goo_type'] = '赠品';
                }
                if ($value['goo_type'] == 4) {
                    $data[$key]['goo_type'] = '旧货';
                }

                if ($value['oure_waon_class'] == 1) {
                    $data[$key]['oure_waon_class'] = '货物仓';
                }
                if ($value['oure_waon_class'] == 2) {
                    $data[$key]['oure_waon_class'] = '非商品仓';
                }
                if ($value['oure_waon_class'] == 3) {
                    $data[$key]['oure_waon_class'] = '旧货仓';
                }
                if ($value['oure_waon_class'] == 4) {
                    $data[$key]['oure_waon_class'] = '临时仓';
                }
                if ($value['oude_type'] == 1) {
                    $data[$key]['oude_type'] = '良品';
                } else {
                    $data[$key]['oude_type'] = '优先';
                }
                //商品编号
                // $data[$key]['goo_goods_encode'] = "\t".empty($value['goo_goods_encode']) ? '' : $value['goo_goods_encode'];
                $data[$key]['goo_name'] = empty($value['goo_name']) ? '' : $value['goo_name'];
            }
        } else {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'没有符合条件的数据']);
        }
        $pathName = storage_path() . "/app/public/excel"; //获取上传excel路径
        // 创建文件夹
        if (!file_exists($pathName)) {
            mkdir($pathName, 0775, true);
            chmod($pathName, 0775);
        }

        // $streamFileRand = time() . rand(10000, 99999).'A3前埔仓库存出库记录.xls';//
        $streamFileRand = time() . rand(10000, 99999) . 'A3前埔仓库存入库记录.xls'; //
        // 产生一个随机文件名（因为你base64上来肯定没有文件名，这里你可以自己设置一个也行）
        $streamFilename = $pathName . '/' . $streamFileRand;

        $where['action_name'] = '出入库记录'; //
        $where['field_name'] = ['单号', '原始单号', '商品名称', '商品编号', '商品id', '数量', '商品类型', '仓库类别', '出入库类型', '操作时间'];
        // 调用导出的公共方法
        export::publicExport(
            $streamFilename, //路径
            $where,    //sheet名及其每一行的标题
            $data      //导出数据
        );

        // 判断文件是否存在 存在则成功  不存在则失败
        if (file_exists($streamFilename)) {
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>'http://mk.bluearp.com/storage/excel/' . $streamFileRand]);
        } else {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'导出失败']);
        }
    }

    // A7同安仓库存操作
    public function test4(Request $request)
    {
        ignore_user_abort();
        set_time_limit(0);
        $ware_id = 14; //同安店库存
        $waon_class = 3;
        $goo_type = 4;
        $cid = 1; //公司id
        $superior_shop_id = 1; //总店id
        $shop_id = 1; //门店id
        $search_data = $request->all();
        $find_out_data = DB::table('outin_details as a')
            ->leftJoin('outin_record as b', 'b.oure_id', '=', 'a.oude_oure_id')
            ->leftJoin('goods as d', 'd.goo_id', '=', 'a.oude_goo_id')
            ->where('oure_cid', 1)
            ->where('oure_shop_id', 1)
            ->where('oure_out_ware_id', $ware_id)
            ->select('oure_number', 'oure_original_number', 'goo_name', 'goo_goods_encode', 'goo_id', 'oude_goo_number', 'goo_type', 'oure_waon_class', 'oude_type', 'oure_create_time')
            ->get()->toArray();
        $find_in_data = DB::table('outin_details as a')
            ->leftJoin('outin_record as b', 'b.oure_id', '=', 'a.oude_oure_id')
            ->leftJoin('goods as d', 'd.goo_id', '=', 'a.oude_goo_id')
            ->where('oure_cid', 1)
            ->where('oure_shop_id', 1)
            ->where('oure_in_ware_id', $ware_id)
            ->select('oure_number', 'oure_original_number', 'goo_name', 'goo_goods_encode', 'goo_id', 'oude_goo_number', 'goo_type', 'oure_waon_class', 'oude_type', 'oure_create_time')
            ->get()->toArray();
        // $goo_number_out_amount = [];
        // $goo_number_in_amount = [];
        // $goo_number_amount = [];
        // // 出库数量统计
        // foreach ($find_out_data as $key => $value) {
        //     if (isset($goo_number_out_amount[$value->goo_id])) {
        //         $goo_number_out_amount[$value->goo_id] += $value->oude_goo_number;
        //     }else{
        //         $goo_number_out_amount[$value->goo_id] = $value->oude_goo_number;
        //     }
        // }
        // // 入库数量统计
        // foreach ($find_in_data as $key => $value) {
        //     if (isset($goo_number_in_amount[$value->goo_id])) {
        //         $goo_number_in_amount[$value->goo_id] += $value->oude_goo_number;
        //     }else{
        //         $goo_number_in_amount[$value->goo_id] = $value->oude_goo_number;
        //     }
        // }
        // $goo_number_amount = $goo_number_in_amount;//先赋值入库数量
        // // 计算剩余库存数量，入库数量减去出库数量=剩余库存数量
        // foreach ($goo_number_out_amount as $key => $value) {
        //     if (isset($goo_number_in_amount[$key])) {
        //         $goo_number_amount[$key] = $goo_number_in_amount[$key] - $value;
        //     } else {
        //         $goo_number_amount[$key] = - $value;
        //     }
        // }
        // $goo_number_amount = array_filter($goo_number_amount);
        // // 查询导入的商品数据
        // $data =DB::table('excel_data_cache')->where('exdc_type', 4)->get();
        // $data = json_decode($data, true);
        // $data_info =[];
        // $cid =1;
        // $shop_id =1;
        // $superior_shop_id =1;
        // foreach ($data as $key => $value) {
        //     $exdc_data = json_decode($value['exdc_data'], true);
        //     // dump($exdc_data);
        //     $find_goo_id = DB::table('goods')
        //         ->where('goo_cid', $cid)
        //         ->where('goo_shop_id', $shop_id)
        //         ->where('goo_superior_shop_id', $superior_shop_id)
        //         ->where('goo_type', $goo_type)
        //         ->where('goo_delete', 1)
        //         ->where('goo_goods_encode', $exdc_data['goo_goods_encode'])
        //         ->select('goo_id')
        //         ->first();
        //     $exdc_data['goo_id'] = $find_goo_id->goo_id;
        //     $data_info[] = $exdc_data;
        // }
        // // exit;
        // $excel_goo_data = array_column($data_info, null, 'goo_id');
        // $excel_goo_data = json_decode(json_encode($excel_goo_data), true);
        // // dump($excel_goo_data);exit;
        // $excel_goo_goods_encode = array_column($data_info, 'goo_goods_encode');

        // $excel_goo_amount = [];//最后剩余数量
        // // 计算仓库最终的库存数量
        // // dump($goo_number_amount);exit;
        // // dump($excel_goo_data);exit;
        // foreach ($goo_number_amount as $key => $value) {
        //     if (isset($excel_goo_amount[$key])) {
        //         if (!empty($excel_goo_data[$key]['jhcy'])) {
        //             $excel_goo_amount[$key] += $excel_goo_data[$key]['jhcy'] + $value;//固定仓
        //         } else {
        //             $excel_goo_amount[$key] = $value;
        //         }
        //         unset($excel_goo_data[$key]);
        //     } else {
        //         // 固定仓
        //         if (isset($excel_goo_data[$key]['jhcy'])) {

        //             if (!empty($excel_goo_data[$key]['jhcy'])) {
        //                 $excel_goo_data[$key]['jhcy'] = trim($excel_goo_data[$key]['jhcy'], '=');
        //                 if (stristr($excel_goo_data[$key]['jhcy'], '+')) {
        //                     $jhcy = explode('+', $excel_goo_data[$key]['jhcy']);
        //                     $excel_goo_data[$key]['jhcy'] = array_sum($jhcy);
        //                     unset($jhcy);
        //                 }

        //                 $excel_goo_amount[$key] = $excel_goo_data[$key]['jhcy'] + $value;//固定仓
        //                 unset($excel_goo_data[$key]);
        //             } else {
        //                 $excel_goo_amount[$key] = $value;//固定仓
        //             }
        //         } else {
        //             $excel_goo_amount[$key] = $value;
        //         }
        //         if ($excel_goo_amount[$key] < 0) {
        //             $excel_goods_fu[$key] = $excel_goo_amount[$key];//固定仓
        //         } else {
        //             $excel_goods_zheng[$key] = $excel_goo_amount[$key];//固定仓
        //         }
        //     }
        // }
        // // dump($excel_goods_fu);
        // // dump($excel_goods_zheng);
        // // dump($excel_goo_amount);
        // // exit;
        // if (!empty($excel_goo_data)) {
        //     $ids = array_column($excel_goo_data, 'jhcy', 'goo_id');
        //     // dump($ids);
        //     // $arr = array_combine($ids, $excel_goods_zheng);
        //     $arr = $ids + $excel_goods_zheng;
        //     $excel_goods_zheng = $arr;
        // }
        // // 读取负值
        // if (isset($excel_goods_fu)) {
        //     foreach ($excel_goods_fu as $goo_id => $value) {
        //         $wagk_data['wagk_ware_id'] = $ware_id;
        //         $wagk_data['wagk_class'] = $waon_class;
        //         $wagk_data['wagk_goo_id'] = $key;
        //         $wagk_data['wagk_stock_number'] = $value;
        //         $wagk_data['wagk_update_time'] = $this->now_time;
        //         $wagk_res = DB::table('warehouse_goods_kucun')->insert($wagk_data);
        //     }
        // }
        // foreach ($excel_goods_zheng as $goo_id => $value) {
        //     // dump($value);exit;
        //     $wago_id= DB::table('warehouse_goods')
        //         ->where('wago_ware_id', $ware_id)
        //         ->where('wago_goo_id', $goo_id)
        //         ->where('wago_class', $waon_class)
        //         ->value('wago_id');
        //     dump($wago_id);
        //     if (empty($wago_id)) {
        //         // 仓库内没有商品，添加商品
        //         $warehouse_goods['wago_ware_id'] = $ware_id;//仓库
        //         $warehouse_goods['wago_class'] = $waon_class;
        //         $warehouse_goods['wago_goo_id'] = $goo_id;//商品
        //         // $warehouse_goods['wago_stock_number'] = $value;//良品库存
        //         $warehouse_goods['wago_priority_stock_number'] = $value;//优先库存
        //         $warehouse_goods['wago_update_time'] = $this->now_time;//更新时间
        //         $wago_res = DB::table('warehouse_goods')->insert($warehouse_goods);
        //         dump($wago_res);
        //         // unset($warehouse_goods);
        //     } else {
        //         // 仓库内已经有商品了，更改库存数量
        //         // $edit_data['wago_stock_number'] = $value;//良品库存
        //         $edit_data['wago_priority_stock_number'] = $value;//优先库存
        //         $edit_data['wago_update_time'] = $this->now_time;
        //         dump($edit_data);
        //         $res= DB::table('warehouse_goods')
        //             ->where('wago_ware_id', $ware_id)
        //             ->where('wago_goo_id', $goo_id)
        //             ->where('wago_class', $waon_class)
        //             ->update($edit_data);
        //         dump($res);
        //     }
        // }
        // $find_waon_data = DB::table('warehouse_onhand')
        //     ->where('waon_ware_id', $ware_id)
        //     ->where('waon_class', $waon_class)
        //     ->first();
        // $waon_edit['waon_all_amount'] = $find_waon_data->waon_all_amount + array_sum($excel_goods_zheng);
        // // $waon_edit['waon_stock_fine_amount'] = $find_waon_data->waon_stock_fine_amount + array_sum($excel_goods_zheng);//良品
        // $waon_edit['waon_stock_priority_amount'] = $find_waon_data->waon_stock_priority_amount + array_sum($excel_goods_zheng);//优先
        // $waon_edit['waon_update_time'] = $this->now_time;
        // $res = DB::table('warehouse_onhand')
        //     ->where('waon_ware_id', $ware_id)
        //     ->where('waon_class', $waon_class)
        //     ->update($waon_edit);
        // dump($res);
        // die;
        // dump($excel_goods_zheng);exit;
        // $data = $find_out_data;//出库
        $data = $find_in_data; //入库
        if (!empty($data)) {
            // 将对象转化为数组
            $data = json_decode(json_encode($data), true);
            foreach ($data as $key => $value) {
                // 结算方式
                if ($value['goo_type'] == 1) {
                    $data[$key]['goo_type'] = '正常';
                }
                if ($value['goo_type'] == 2) {
                    $data[$key]['goo_type'] = '赠品';
                }
                if ($value['goo_type'] == 4) {
                    $data[$key]['goo_type'] = '旧货';
                }

                if ($value['oure_waon_class'] == 1) {
                    $data[$key]['oure_waon_class'] = '货物仓';
                }
                if ($value['oure_waon_class'] == 2) {
                    $data[$key]['oure_waon_class'] = '非商品仓';
                }
                if ($value['oure_waon_class'] == 3) {
                    $data[$key]['oure_waon_class'] = '旧货仓';
                }
                if ($value['oure_waon_class'] == 4) {
                    $data[$key]['oure_waon_class'] = '临时仓';
                }
                if ($value['oude_type'] == 1) {
                    $data[$key]['oude_type'] = '良品';
                } else {
                    $data[$key]['oude_type'] = '优先';
                }
                //商品编号
                // $data[$key]['goo_goods_encode'] = "\t".empty($value['goo_goods_encode']) ? '' : $value['goo_goods_encode'];
                $data[$key]['goo_name'] = empty($value['goo_name']) ? '' : $value['goo_name'];
            }
        } else {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'没有符合条件的数据']);
        }
        $pathName = storage_path() . "/app/public/excel"; //获取上传excel路径
        // 创建文件夹
        if (!file_exists($pathName)) {
            mkdir($pathName, 0775, true);
            chmod($pathName, 0775);
        }

        // $streamFileRand = time() . rand(10000, 99999).'A7同安仓库存出库记录.xls';//
        $streamFileRand = time() . rand(10000, 99999) . 'A7同安仓库存入库记录.xls'; //
        // 产生一个随机文件名（因为你base64上来肯定没有文件名，这里你可以自己设置一个也行）
        $streamFilename = $pathName . '/' . $streamFileRand;

        $where['action_name'] = '出入库记录'; //
        $where['field_name'] = ['单号', '原始单号', '商品名称', '商品编号', '商品id', '数量', '商品类型', '仓库类别', '出入库类型', '操作时间'];
        // 调用导出的公共方法
        export::publicExport(
            $streamFilename, //路径
            $where,    //sheet名及其每一行的标题
            $data      //导出数据
        );

        // 判断文件是否存在 存在则成功  不存在则失败
        if (file_exists($streamFilename)) {
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>'http://mk.bluearp.com/storage/excel/' . $streamFileRand]);
        } else {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'导出失败']);
        }
    }

    // A6灌口仓操作
    public function test5(Request $request)
    {
        ignore_user_abort();
        set_time_limit(0);
        $ware_id = 13; //A6灌口仓
        $waon_class = 3; //仓库类别:1.货物仓2.非货物仓3.旧货仓4.临时仓
        $goo_type = 4; //商品类型:1.正常商品2.赠品商品3.活动商品4.旧货商品
        $cid = 1; //公司id
        $superior_shop_id = 1; //总店id
        $shop_id = 1; //门店id
        $search_data = $request->all();
        $find_out_data = DB::table('outin_details as a')
            ->leftJoin('outin_record as b', 'b.oure_id', '=', 'a.oude_oure_id')
            ->leftJoin('goods as d', 'd.goo_id', '=', 'a.oude_goo_id')
            ->where('oure_cid', 1)
            ->where('oure_shop_id', 1)
            ->where('oure_out_ware_id', $ware_id)
            ->select('oure_number', 'oure_original_number', 'goo_name', 'goo_goods_encode', 'goo_id', 'oude_goo_number', 'goo_type', 'oure_waon_class', 'oude_type', 'oure_create_time')
            ->get()->toArray();
        $find_in_data = DB::table('outin_details as a')
            ->leftJoin('outin_record as b', 'b.oure_id', '=', 'a.oude_oure_id')
            ->leftJoin('goods as d', 'd.goo_id', '=', 'a.oude_goo_id')
            ->where('oure_cid', 1)
            ->where('oure_shop_id', 1)
            ->where('oure_in_ware_id', $ware_id)
            ->select('oure_number', 'oure_original_number', 'goo_name', 'goo_goods_encode', 'goo_id', 'oude_goo_number', 'goo_type', 'oure_waon_class', 'oude_type', 'oure_create_time')
            ->get()->toArray();
        // $goo_number_out_amount = [];
        // $goo_number_in_amount = [];
        // $goo_number_amount = [];
        // // 出库数量统计
        // foreach ($find_out_data as $key => $value) {
        //     if (isset($goo_number_out_amount[$value->goo_id])) {
        //         $goo_number_out_amount[$value->goo_id] += $value->oude_goo_number;
        //     }else{
        //         $goo_number_out_amount[$value->goo_id] = $value->oude_goo_number;
        //     }
        // }
        // // 入库数量统计
        // foreach ($find_in_data as $key => $value) {
        //     if (isset($goo_number_in_amount[$value->goo_id])) {
        //         $goo_number_in_amount[$value->goo_id] += $value->oude_goo_number;
        //     }else{
        //         $goo_number_in_amount[$value->goo_id] = $value->oude_goo_number;
        //     }
        // }
        // $goo_number_amount = $goo_number_in_amount;//先赋值入库数量
        // // 计算剩余库存数量，入库数量减去出库数量=剩余库存数量
        // foreach ($goo_number_out_amount as $key => $value) {
        //     if (isset($goo_number_in_amount[$key])) {
        //         $goo_number_amount[$key] = $goo_number_in_amount[$key] - $value;
        //     } else {
        //         $goo_number_amount[$key] = - $value;
        //     }
        // }
        // $goo_number_amount = array_filter($goo_number_amount);
        // // 查询导入的商品数据
        // $data =DB::table('excel_data_cache')->where('exdc_type', 13)->get();
        // $data = json_decode($data, true);
        // $data_info =[];
        // $cid =1;
        // $shop_id =1;
        // $superior_shop_id =1;
        // foreach ($data as $key => $value) {
        //     $exdc_data = json_decode($value['exdc_data'], true);
        //     // dump($exdc_data);
        //     $find_goo_id = DB::table('goods')
        //         ->where('goo_cid', $cid)
        //         ->where('goo_shop_id', $shop_id)
        //         ->where('goo_superior_shop_id', $superior_shop_id)
        //         ->where('goo_type', $goo_type)
        //         ->where('goo_delete', 1)
        //         ->where('goo_goods_encode', $exdc_data['goo_goods_encode'])
        //         ->select('goo_id')
        //         ->first();
        //     $exdc_data['goo_id'] = $find_goo_id->goo_id;
        //     $data_info[] = $exdc_data;
        // }
        // // exit;
        // $excel_goo_data = array_column($data_info, null, 'goo_id');
        // $excel_goo_data = json_decode(json_encode($excel_goo_data), true);
        // // dump($excel_goo_data);exit;
        // $excel_goo_goods_encode = array_column($data_info, 'goo_goods_encode');

        // $excel_goo_amount = [];//最后剩余数量
        // // 计算仓库最终的库存数量
        // // dump($goo_number_amount);exit;
        // foreach ($goo_number_amount as $key => $value) {
        //     if (isset($excel_goo_amount[$key])) {
        //         $excel_goo_amount[$key] += $excel_goo_data[$key]['jhcy'] + $value;//固定仓
        //         unset($excel_goo_data[$key]);
        //     } else {
        //         // 固定仓
        //         if (isset($excel_goo_data[$key]['jhcy'])) {
        //             if (!empty($excel_goo_data[$key]['jhcy'])) {
        //                 $excel_goo_amount[$key] = $excel_goo_data[$key]['jhcy'] + $value;//固定仓
        //                 unset($excel_goo_data[$key]);
        //             } else {
        //                 $excel_goo_amount[$key] = $value;//固定仓
        //             }
        //         } else {
        //             $excel_goo_amount[$key] = $value;
        //         }
        //         if ($excel_goo_amount[$key] < 0) {
        //             $excel_goods_fu[$key] = $excel_goo_amount[$key];//固定仓
        //         } else {
        //             $excel_goods_zheng[$key] = $excel_goo_amount[$key];//固定仓
        //         }
        //     }
        // }
        // // dump($excel_goods_fu);
        // // dump($excel_goods_zheng);
        // // dump($excel_goo_amount);
        // // exit;
        // if (!empty($excel_goo_data)) {
        //     $ids = array_column($excel_goo_data, 'jhcy', 'goo_id');
        //     // dump($ids);
        //     // $arr = array_combine($ids, $excel_goods_zheng);
        //     $arr = $ids + $excel_goods_zheng;
        //     $excel_goods_zheng = $arr;
        // }
        // // 读取负值
        // if (isset($excel_goods_fu)) {
        //     foreach ($excel_goods_fu as $goo_id => $value) {
        //         $wagk_data['wagk_ware_id'] = $ware_id;
        //         $wagk_data['wagk_class'] = $waon_class;
        //         $wagk_data['wagk_goo_id'] = $key;
        //         $wagk_data['wagk_stock_number'] = $value;
        //         $wagk_data['wagk_update_time'] = $this->now_time;
        //         $wagk_res = DB::table('warehouse_goods_kucun')->insert($wagk_data);
        //     }
        // }
        // foreach ($excel_goods_zheng as $goo_id => $value) {
        //     $wago_id= DB::table('warehouse_goods')
        //         ->where('wago_ware_id', $ware_id)
        //         ->where('wago_goo_id', $goo_id)
        //         ->where('wago_class', $waon_class)
        //         ->value('wago_id');
        //     dump($wago_id);
        //     if (empty($wago_id)) {
        //         // 仓库内没有商品，添加商品
        //         $warehouse_goods['wago_ware_id'] = $ware_id;//仓库
        //         $warehouse_goods['wago_class'] = $waon_class;
        //         $warehouse_goods['wago_goo_id'] = $goo_id;//商品
        //         // $warehouse_goods['wago_stock_number'] = $value;//良品库存
        //         $warehouse_goods['wago_priority_stock_number'] = $value;//优先库存
        //         $warehouse_goods['wago_update_time'] = $this->now_time;//更新时间
        //         $wago_res = DB::table('warehouse_goods')->insert($warehouse_goods);
        //         dump($wago_res);
        //         // unset($warehouse_goods);
        //     } else {
        //         // 仓库内已经有商品了，更改库存数量
        //         // $edit_data['wago_stock_number'] = $value;//良品库存
        //         $edit_data['wago_priority_stock_number'] = $value;//优先库存
        //         $edit_data['wago_update_time'] = $this->now_time;
        //         dump($edit_data);
        //         $res= DB::table('warehouse_goods')
        //             ->where('wago_ware_id', $ware_id)
        //             ->where('wago_goo_id', $goo_id)
        //             ->where('wago_class', $waon_class)
        //             ->update($edit_data);
        //         dump($res);
        //     }
        // }
        // $find_waon_data = DB::table('warehouse_onhand')
        //     ->where('waon_ware_id', $ware_id)
        //     ->where('waon_class', $waon_class)
        //     ->first();
        // $waon_edit['waon_all_amount'] = $find_waon_data->waon_all_amount + array_sum($excel_goods_zheng);
        // // $waon_edit['waon_stock_fine_amount'] = $find_waon_data->waon_stock_fine_amount + array_sum($excel_goods_zheng);//良品
        // $waon_edit['waon_stock_priority_amount'] = $find_waon_data->waon_stock_priority_amount + array_sum($excel_goods_zheng);//良品
        // $waon_edit['waon_update_time'] = $this->now_time;
        // $res = DB::table('warehouse_onhand')
        //     ->where('waon_ware_id', $ware_id)
        //     ->where('waon_class', $waon_class)
        //     ->update($waon_edit);
        // dump($res);
        // die;
        // dump($excel_goods_zheng);exit;
        // $data = $find_out_data;//出库
        $data = $find_in_data; //入库
        if (!empty($data)) {
            // 将对象转化为数组
            $data = json_decode(json_encode($data), true);
            foreach ($data as $key => $value) {
                // 结算方式
                if ($value['goo_type'] == 1) {
                    $data[$key]['goo_type'] = '正常';
                }
                if ($value['goo_type'] == 2) {
                    $data[$key]['goo_type'] = '赠品';
                }
                if ($value['goo_type'] == 4) {
                    $data[$key]['goo_type'] = '旧货';
                }

                if ($value['oure_waon_class'] == 1) {
                    $data[$key]['oure_waon_class'] = '货物仓';
                }
                if ($value['oure_waon_class'] == 2) {
                    $data[$key]['oure_waon_class'] = '非商品仓';
                }
                if ($value['oure_waon_class'] == 3) {
                    $data[$key]['oure_waon_class'] = '旧货仓';
                }
                if ($value['oure_waon_class'] == 4) {
                    $data[$key]['oure_waon_class'] = '临时仓';
                }
                if ($value['oude_type'] == 1) {
                    $data[$key]['oude_type'] = '良品';
                } else {
                    $data[$key]['oude_type'] = '优先';
                }
                //商品编号
                // $data[$key]['goo_goods_encode'] = "\t".empty($value['goo_goods_encode']) ? '' : $value['goo_goods_encode'];
                $data[$key]['goo_name'] = empty($value['goo_name']) ? '' : $value['goo_name'];
            }
        } else {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'没有符合条件的数据']);
        }
        $pathName = storage_path() . "/app/public/excel"; //获取上传excel路径
        // 创建文件夹
        if (!file_exists($pathName)) {
            mkdir($pathName, 0775, true);
            chmod($pathName, 0775);
        }

        // $streamFileRand = time() . rand(10000, 99999).'A6灌口仓出库记录.xls';//
        $streamFileRand = time() . rand(10000, 99999) . 'A6灌口仓入库记录.xls'; //
        // 产生一个随机文件名（因为你base64上来肯定没有文件名，这里你可以自己设置一个也行）
        $streamFilename = $pathName . '/' . $streamFileRand;

        $where['action_name'] = '出入库记录'; //
        $where['field_name'] = ['单号', '原始单号', '商品名称', '商品编号', '商品id', '数量', '商品类型', '仓库类别', '出入库类型', '操作时间'];
        // 调用导出的公共方法
        export::publicExport(
            $streamFilename, //路径
            $where,    //sheet名及其每一行的标题
            $data      //导出数据
        );

        // 判断文件是否存在 存在则成功  不存在则失败
        if (file_exists($streamFilename)) {
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>'http://mk.bluearp.com/storage/excel/' . $streamFileRand]);
        } else {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'导出失败']);
        }
    }

    // 闽D2CF72黄行渊移动仓库存（截止9.11日8：30前）
    public function hxytest(Request $request)
    {
        ignore_user_abort();
        set_time_limit(0);
        $ware_id = 30; //黄行渊
        // $ware_id = 28;//林观书
        $waon_class = 1; //仓库类别1货物仓2非货物仓3旧货仓4临时仓
        $goo_type = 1; //商品类型1正常商品2临时商品3活动商品4旧货商品
        $cid = 1; //公司id
        $superior_shop_id = 1; //总店id
        $shop_id = 1; //门店id
        $search_data = $request->all();
        $find_out_data = DB::table('outin_details as a')
            ->leftJoin('outin_record as b', 'b.oure_id', '=', 'a.oude_oure_id')
            ->leftJoin('goods as d', 'd.goo_id', '=', 'a.oude_goo_id')
            ->where('oure_cid', 1)
            ->where('oure_shop_id', 1)
            ->where('oure_out_ware_id', $ware_id)
            ->select('oure_number', 'oure_original_number', 'goo_name', 'goo_goods_encode', 'goo_id', 'oude_goo_number', 'goo_type', 'oure_waon_class', 'oure_create_time')
            ->get()->toArray();
        $find_in_data = DB::table('outin_details as a')
            ->leftJoin('outin_record as b', 'b.oure_id', '=', 'a.oude_oure_id')
            ->leftJoin('goods as d', 'd.goo_id', '=', 'a.oude_goo_id')
            ->where('oure_cid', 1)
            ->where('oure_shop_id', 1)
            ->where('oure_in_ware_id', $ware_id)
            ->select('oure_number', 'oure_original_number', 'goo_name', 'goo_goods_encode', 'goo_id', 'oude_goo_number', 'goo_type', 'oure_waon_class', 'oure_create_time')
            ->get()->toArray();
        // $goo_number_out_amount = [];
        // $goo_number_in_amount = [];
        // $goo_number_amount = [];
        // // 出库数量统计
        // foreach ($find_out_data as $key => $value) {
        //     if (isset($goo_number_out_amount[$value->goo_id])) {
        //         $goo_number_out_amount[$value->goo_id] += $value->oude_goo_number;
        //     }else{
        //         $goo_number_out_amount[$value->goo_id] = $value->oude_goo_number;
        //     }
        // }
        // // 入库数量统计
        // foreach ($find_in_data as $key => $value) {
        //     if (isset($goo_number_in_amount[$value->goo_id])) {
        //         $goo_number_in_amount[$value->goo_id] += $value->oude_goo_number;
        //     }else{
        //         $goo_number_in_amount[$value->goo_id] = $value->oude_goo_number;
        //     }
        // }
        // $goo_number_amount = $goo_number_in_amount;//先赋值入库数量
        // // 计算剩余库存数量，入库数量减去出库数量=剩余库存数量
        // foreach ($goo_number_out_amount as $key => $value) {
        //     if (isset($goo_number_in_amount[$key])) {
        //         $goo_number_amount[$key] = $goo_number_in_amount[$key] - $value;
        //     } else {
        //         $goo_number_amount[$key] = - $value;
        //     }
        // }
        // $goo_number_amount = array_filter($goo_number_amount);
        // // 查询导入的商品数据
        // $data =DB::table('excel_data_cache')->where('exdc_type', 5)->get();
        // $data = json_decode($data, true);
        // $data_info =[];
        // $cid =1;
        // $shop_id =1;
        // $superior_shop_id =1;
        // foreach ($data as $key => $value) {
        //     $exdc_data = json_decode($value['exdc_data'], true);
        //     // dump($exdc_data);
        //     $find_goo_id = DB::table('goods')
        //         ->where('goo_cid', $cid)
        //         ->where('goo_shop_id', $shop_id)
        //         ->where('goo_superior_shop_id', $superior_shop_id)
        //         ->where('goo_type', $goo_type)
        //         ->where('goo_delete', 1)
        //         ->where('goo_goods_encode', $exdc_data['goo_goods_encode'])
        //         ->select('goo_id')
        //         ->first();
        //     $exdc_data['goo_id'] = $find_goo_id->goo_id;
        //     $data_info[] = $exdc_data;
        // }
        // // exit;
        // $excel_goo_data = array_column($data_info, null, 'goo_id');
        // $excel_goo_data = json_decode(json_encode($excel_goo_data), true);
        // // dump($excel_goo_data);exit;
        // $excel_goo_goods_encode = array_column($data_info, 'goo_goods_encode');

        // $excel_goo_amount = [];//最后剩余数量
        // // 计算仓库最终的库存数量
        // // dump($goo_number_amount);exit;
        // foreach ($goo_number_amount as $key => $value) {
        //     if (isset($excel_goo_amount[$key])) {
        //         $excel_goo_amount[$key] += $excel_goo_data[$key]['hwcl'] + $value;//固定仓
        //     } else {
        //         if (isset($excel_goo_data[$key]['hwcl'])) {
        //             if (!empty($excel_goo_data[$key]['hwcl'])) {
        //                 $excel_goo_amount[$key] = $excel_goo_data[$key]['hwcl'] + $value;//固定仓
        //             } else {
        //                 $excel_goo_amount[$key] = $value;//固定仓
        //             }
        //         } else {
        //             $excel_goo_amount[$key] = $value;
        //         }
        //         if ($excel_goo_amount[$key] < 0) {
        //             $excel_goods_fu[$key] = $excel_goo_amount[$key];//固定仓
        //         } else {
        //             $excel_goods_zheng[$key] = $excel_goo_amount[$key];//固定仓
        //         }
        //     }
        // }
        // // dump($excel_goods_fu);
        // // dump($excel_goods_zheng);
        // // dump($goo_number_amount);
        // // exit;
        // if (!empty($excel_goo_data)) {
        //     $ids = array_column($excel_goo_data, 'hwcl', 'goo_id');
        //     // dump($ids);
        //     // $arr = array_combine($ids, $excel_goods_zheng);
        //     $arr = $ids + $excel_goods_zheng;
        //     $excel_goods_zheng = $arr;
        // }
        // // 读取负值
        // if (isset($excel_goods_fu)) {
        //     foreach ($excel_goods_fu as $goo_id => $value) {
        //         $wagk_data['wagk_ware_id'] = $ware_id;
        //         $wagk_data['wagk_class'] = $waon_class;
        //         $wagk_data['wagk_goo_id'] = $key;
        //         $wagk_data['wagk_stock_number'] = $value;
        //         $wagk_data['wagk_update_time'] = $this->now_time;
        //         $wagk_res = DB::table('warehouse_goods_kucun')->insert($wagk_data);
        //     }
        // }
        // // exit;
        // // foreach ($excel_goo_amount as $goo_id => $value) {
        // foreach ($excel_goods_zheng as $goo_id => $value) {
        //     // dump($value);exit;
        //     $wago_id= DB::table('warehouse_goods')
        //         ->where('wago_ware_id', $ware_id)
        //         ->where('wago_goo_id', $goo_id)
        //         ->where('wago_class', $waon_class)
        //         ->value('wago_id');
        //     dump($wago_id);
        //     if (empty($wago_id)) {
        //         // 仓库内没有商品，添加商品
        //         $warehouse_goods['wago_ware_id'] = $ware_id;//仓库
        //         $warehouse_goods['wago_class'] = $waon_class;
        //         $warehouse_goods['wago_goo_id'] = $goo_id;//商品
        //         $warehouse_goods['wago_stock_number'] = $value;//良品库存
        //         $warehouse_goods['wago_update_time'] = $this->now_time;//更新时间
        //         $wago_res = DB::table('warehouse_goods')->insert($warehouse_goods);
        //         dump($wago_res);
        //         // unset($warehouse_goods);
        //     } else {
        //         // 仓库内已经有商品了，更改库存数量
        //         $edit_data['wago_stock_number'] = $value;
        //         $edit_data['wago_update_time'] = $this->now_time;
        //         dump($edit_data);
        //         $res= DB::table('warehouse_goods')
        //             ->where('wago_ware_id', $ware_id)
        //             ->where('wago_goo_id', $goo_id)
        //             ->where('wago_class', $waon_class)
        //             ->update($edit_data);
        //         dump($res);
        //     }
        // }
        // $find_waon_data = DB::table('warehouse_onhand')
        //     ->where('waon_ware_id', $ware_id)
        //     ->where('waon_class', $waon_class)
        //     ->first();
        // $waon_edit['waon_all_amount'] = $find_waon_data->waon_all_amount + array_sum($excel_goods_zheng);
        // $waon_edit['waon_stock_fine_amount'] = $find_waon_data->waon_stock_fine_amount + array_sum($excel_goods_zheng);
        // $waon_edit['waon_update_time'] = $this->now_time;
        // $res = DB::table('warehouse_onhand')
        //     ->where('waon_ware_id', $ware_id)
        //     ->where('waon_class', $waon_class)
        //     ->update($waon_edit);
        // dump($res);
        // die;
        // dump($excel_goods_zheng);exit;
        // $data = $find_out_data;//出库
        $data = $find_in_data; //入库
        if ($request['type'] == 1) {
            $data = $find_in_data; //入库
            $file_name = '黄行渊移动仓入库记录';
        } else {
            $data = $find_out_data; //出库
            $file_name = '黄行渊移动仓出库记录';
        }
        if (!empty($data)) {
            // 将对象转化为数组
            $data = json_decode(json_encode($data), true);
            foreach ($data as $key => $value) {
                // 结算方式
                if ($value['goo_type'] == 1) {
                    $data[$key]['goo_type'] = '正常';
                }
                if ($value['goo_type'] == 2) {
                    $data[$key]['goo_type'] = '赠品';
                }
                if ($value['goo_type'] == 4) {
                    $data[$key]['goo_type'] = '旧货';
                }

                if ($value['oure_waon_class'] == 1) {
                    $data[$key]['oure_waon_class'] = '货物仓';
                }
                if ($value['oure_waon_class'] == 2) {
                    $data[$key]['oure_waon_class'] = '非商品仓';
                }
                if ($value['oure_waon_class'] == 3) {
                    $data[$key]['oure_waon_class'] = '旧货仓';
                }
                if ($value['oure_waon_class'] == 4) {
                    $data[$key]['oure_waon_class'] = '临时仓';
                }
                //商品编号
                // $data[$key]['goo_goods_encode'] = "\t".empty($value['goo_goods_encode']) ? '' : $value['goo_goods_encode'];
                $data[$key]['goo_name'] = empty($value['goo_name']) ? '' : $value['goo_name'];
            }
        } else {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'没有符合条件的数据']);
        }
        $pathName = storage_path() . "/app/public/excel"; //获取上传excel路径
        // 创建文件夹
        if (!file_exists($pathName)) {
            mkdir($pathName, 0775, true);
            chmod($pathName, 0775);
        }

        // $streamFileRand = time() . rand(10000, 99999).'林观书出库记录.xls';//
        // $streamFileRand = time() . rand(10000, 99999).'张武军入库记录.xls';//
        $streamFileRand = time() . rand(10000, 99999) . $file_name . '.xls'; //
        // 产生一个随机文件名（因为你base64上来肯定没有文件名，这里你可以自己设置一个也行）
        $streamFilename = $pathName . '/' . $streamFileRand;

        $where['action_name'] = '出入库记录'; //
        $where['field_name'] = ['单号', '原始单号', '商品名称', '商品编号', '商品id', '数量', '类型', '仓库类别', '操作时间'];
        // 调用导出的公共方法
        export::publicExport(
            $streamFilename, //路径
            $where,    //sheet名及其每一行的标题
            $data      //导出数据
        );

        // 判断文件是否存在 存在则成功  不存在则失败
        if (file_exists($streamFilename)) {
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>'http://mk.bluearp.com/storage/excel/' . $streamFileRand]);
        } else {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'导出失败']);
        }
    }

    // 闽D9C386刘启睿移动仓库存（截止9.11日8：30前）
    public function lqrtest(Request $request)
    {
        ignore_user_abort();
        set_time_limit(0);
        $ware_id = 18; //刘启睿库存
        $waon_class = 1; //仓库类别1货物仓2非货物仓3旧货仓4临时仓
        $goo_type = 1; //商品类型1正常商品2临时商品3活动商品4旧货商品
        $cid = 1; //公司id
        $superior_shop_id = 1; //总店id
        $shop_id = 1; //门店id
        $search_data = $request->all();
        $find_out_data = DB::table('outin_details as a')
            ->leftJoin('outin_record as b', 'b.oure_id', '=', 'a.oude_oure_id')
            ->leftJoin('goods as d', 'd.goo_id', '=', 'a.oude_goo_id')
            ->where('oure_cid', 1)
            ->where('oure_shop_id', 1)
            ->where('oure_out_ware_id', $ware_id)
            ->select('oure_number', 'oure_original_number', 'goo_name', 'goo_goods_encode', 'goo_id', 'oude_goo_number', 'goo_type', 'oure_waon_class', 'oure_create_time')
            ->get()->toArray();
        $find_in_data = DB::table('outin_details as a')
            ->leftJoin('outin_record as b', 'b.oure_id', '=', 'a.oude_oure_id')
            ->leftJoin('goods as d', 'd.goo_id', '=', 'a.oude_goo_id')
            ->where('oure_cid', 1)
            ->where('oure_shop_id', 1)
            ->where('oure_in_ware_id', $ware_id)
            ->select('oure_number', 'oure_original_number', 'goo_name', 'goo_goods_encode', 'goo_id', 'oude_goo_number', 'goo_type', 'oure_waon_class', 'oure_create_time')
            ->get()->toArray();
        // $goo_number_out_amount = [];
        // $goo_number_in_amount = [];
        // $goo_number_amount = [];
        // // 出库数量统计
        // foreach ($find_out_data as $key => $value) {
        //     if (isset($goo_number_out_amount[$value->goo_id])) {
        //         $goo_number_out_amount[$value->goo_id] += $value->oude_goo_number;
        //     }else{
        //         $goo_number_out_amount[$value->goo_id] = $value->oude_goo_number;
        //     }
        // }
        // // 入库数量统计
        // foreach ($find_in_data as $key => $value) {
        //     if (isset($goo_number_in_amount[$value->goo_id])) {
        //         $goo_number_in_amount[$value->goo_id] += $value->oude_goo_number;
        //     }else{
        //         $goo_number_in_amount[$value->goo_id] = $value->oude_goo_number;
        //     }
        // }
        // $goo_number_amount = $goo_number_in_amount;//先赋值入库数量
        // // 计算剩余库存数量，入库数量减去出库数量=剩余库存数量
        // foreach ($goo_number_out_amount as $key => $value) {
        //     if (isset($goo_number_in_amount[$key])) {
        //         $goo_number_amount[$key] = $goo_number_in_amount[$key] - $value;
        //     } else {
        //         $goo_number_amount[$key] = - $value;
        //     }
        // }
        // $goo_number_amount = array_filter($goo_number_amount);
        // // 查询导入的商品数据
        // $data =DB::table('excel_data_cache')->where('exdc_type', 6)->get();
        // $data = json_decode($data, true);
        // $data_info =[];
        // $cid =1;
        // $shop_id =1;
        // $superior_shop_id =1;
        // foreach ($data as $key => $value) {
        //     $exdc_data = json_decode($value['exdc_data'], true);
        //     // dump($exdc_data);
        //     $find_goo_id = DB::table('goods')
        //         ->where('goo_cid', $cid)
        //         ->where('goo_shop_id', $shop_id)
        //         ->where('goo_superior_shop_id', $superior_shop_id)
        //         ->where('goo_type', $goo_type)
        //         ->where('goo_delete', 1)
        //         ->where('goo_goods_encode', $exdc_data['goo_goods_encode'])
        //         ->select('goo_id')
        //         ->first();
        //     $exdc_data['goo_id'] = $find_goo_id->goo_id;
        //     $data_info[] = $exdc_data;
        // }
        // // exit;
        // $excel_goo_data = array_column($data_info, null, 'goo_id');
        // $excel_goo_data = json_decode(json_encode($excel_goo_data), true);
        // // dump($excel_goo_data);exit;
        // $excel_goo_goods_encode = array_column($data_info, 'goo_goods_encode');

        // $excel_goo_amount = [];//最后剩余数量
        // // 计算仓库最终的库存数量
        // // dump($goo_number_amount);exit;
        // foreach ($goo_number_amount as $key => $value) {
        //     if (isset($excel_goo_amount[$key])) {
        //         $excel_goo_amount[$key] += $excel_goo_data[$key]['hwcl'] + $value;//固定仓
        //     } else {
        //         if (isset($excel_goo_data[$key]['hwcl'])) {
        //             if (!empty($excel_goo_data[$key]['hwcl'])) {
        //                 $excel_goo_amount[$key] = $excel_goo_data[$key]['hwcl'] + $value;//固定仓
        //             } else {
        //                 $excel_goo_amount[$key] = $value;//固定仓
        //             }
        //         } else {
        //             $excel_goo_amount[$key] = $value;
        //         }
        //         if ($excel_goo_amount[$key] < 0) {
        //             $excel_goods_fu[$key] = $excel_goo_amount[$key];//固定仓
        //         } else {
        //             $excel_goods_zheng[$key] = $excel_goo_amount[$key];//固定仓
        //         }
        //     }
        // }
        // // dump($excel_goods_fu);
        // // dump($excel_goods_zheng);
        // // dump($excel_goo_amount);
        // // exit;
        // if (!empty($excel_goo_data)) {
        //     $ids = array_column($excel_goo_data, 'hwcl', 'goo_id');
        //     // dump($ids);
        //     // $arr = array_combine($ids, $excel_goods_zheng);
        //     $arr = $ids + $excel_goods_zheng;
        //     $excel_goods_zheng = $arr;
        // }
        // // 读取负值
        // if (isset($excel_goods_fu)) {
        //     foreach ($excel_goods_fu as $goo_id => $value) {
        //         $wagk_data['wagk_ware_id'] = $ware_id;
        //         $wagk_data['wagk_class'] = $waon_class;
        //         $wagk_data['wagk_goo_id'] = $key;
        //         $wagk_data['wagk_stock_number'] = $value;
        //         $wagk_data['wagk_update_time'] = $this->now_time;
        //         $wagk_res = DB::table('warehouse_goods_kucun')->insert($wagk_data);
        //     }
        // }
        // // foreach ($excel_goo_amount as $goo_id => $value) {
        // foreach ($excel_goods_zheng as $goo_id => $value) {
        //     // dump($value);exit;
        //     $wago_id= DB::table('warehouse_goods')
        //         ->where('wago_ware_id', $ware_id)
        //         ->where('wago_goo_id', $goo_id)
        //         ->where('wago_class', $waon_class)
        //         ->value('wago_id');
        //     dump($wago_id);
        //     if (empty($wago_id)) {
        //         // 仓库内没有商品，添加商品
        //         $warehouse_goods['wago_ware_id'] = $ware_id;//仓库
        //         $warehouse_goods['wago_class'] = $waon_class;
        //         $warehouse_goods['wago_goo_id'] = $goo_id;//商品
        //         $warehouse_goods['wago_stock_number'] = $value;//良品库存
        //         $warehouse_goods['wago_update_time'] = $this->now_time;//更新时间
        //         $wago_res = DB::table('warehouse_goods')->insert($warehouse_goods);
        //         dump($wago_res);
        //         // unset($warehouse_goods);
        //     } else {
        //         // 仓库内已经有商品了，更改库存数量
        //         $edit_data['wago_stock_number'] = $value;
        //         $edit_data['wago_update_time'] = $this->now_time;
        //         dump($edit_data);
        //         $res= DB::table('warehouse_goods')
        //             ->where('wago_ware_id', $ware_id)
        //             ->where('wago_goo_id', $goo_id)
        //             ->where('wago_class', $waon_class)
        //             ->update($edit_data);
        //         dump($res);
        //     }
        // }
        // $find_waon_data = DB::table('warehouse_onhand')
        //     ->where('waon_ware_id', $ware_id)
        //     ->where('waon_class', $waon_class)
        //     ->first();
        // $waon_edit['waon_all_amount'] = $find_waon_data->waon_all_amount + array_sum($excel_goods_zheng);
        // $waon_edit['waon_stock_fine_amount'] = $find_waon_data->waon_stock_fine_amount + array_sum($excel_goods_zheng);
        // $waon_edit['waon_update_time'] = $this->now_time;
        // $res = DB::table('warehouse_onhand')
        //     ->where('waon_ware_id', $ware_id)
        //     ->where('waon_class', $waon_class)
        //     ->update($waon_edit);
        // dump($res);
        // die;
        // dump($excel_goods_zheng);exit;
        // $data = $find_out_data;//出库
        $data = $find_in_data; //入库
        if (!empty($data)) {
            // 将对象转化为数组
            $data = json_decode(json_encode($data), true);
            foreach ($data as $key => $value) {
                // 结算方式
                if ($value['goo_type'] == 1) {
                    $data[$key]['goo_type'] = '正常';
                }
                if ($value['goo_type'] == 2) {
                    $data[$key]['goo_type'] = '赠品';
                }
                if ($value['goo_type'] == 4) {
                    $data[$key]['goo_type'] = '旧货';
                }

                if ($value['oure_waon_class'] == 1) {
                    $data[$key]['oure_waon_class'] = '货物仓';
                }
                if ($value['oure_waon_class'] == 2) {
                    $data[$key]['oure_waon_class'] = '非商品仓';
                }
                if ($value['oure_waon_class'] == 3) {
                    $data[$key]['oure_waon_class'] = '旧货仓';
                }
                if ($value['oure_waon_class'] == 4) {
                    $data[$key]['oure_waon_class'] = '临时仓';
                }
                //商品编号
                // $data[$key]['goo_goods_encode'] = "\t".empty($value['goo_goods_encode']) ? '' : $value['goo_goods_encode'];
                $data[$key]['goo_name'] = empty($value['goo_name']) ? '' : $value['goo_name'];
            }
        } else {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'没有符合条件的数据']);
        }
        $pathName = storage_path() . "/app/public/excel"; //获取上传excel路径
        // 创建文件夹
        if (!file_exists($pathName)) {
            mkdir($pathName, 0775, true);
            chmod($pathName, 0775);
        }

        // $streamFileRand = time() . rand(10000, 99999).'闽D9C386刘启睿移动仓出库记录.xls';//
        $streamFileRand = time() . rand(10000, 99999) . '闽D9C386刘启睿移动仓入库记录.xls'; //
        // 产生一个随机文件名（因为你base64上来肯定没有文件名，这里你可以自己设置一个也行）
        $streamFilename = $pathName . '/' . $streamFileRand;

        $where['action_name'] = '出入库记录'; //
        $where['field_name'] = ['单号', '原始单号', '商品名称', '商品编号', '商品id', '数量', '类型', '仓库类别', '操作时间'];
        // 调用导出的公共方法
        export::publicExport(
            $streamFilename, //路径
            $where,    //sheet名及其每一行的标题
            $data      //导出数据
        );

        // 判断文件是否存在 存在则成功  不存在则失败
        if (file_exists($streamFilename)) {
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>'http://mk.bluearp.com/storage/excel/' . $streamFileRand]);
        } else {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'导出失败']);
        }
    }

    // 闽D937Q7吴文祥移动仓库存（截止9.11日8：30前）
    public function wwxtest(Request $request)
    {
        ignore_user_abort();
        set_time_limit(0);
        $ware_id = 34; //吴文祥
        $waon_class = 1; //仓库类别1货物仓2非货物仓3旧货仓4临时仓
        $goo_type = 1; //商品类型1正常商品2临时商品3活动商品4旧货商品
        $cid = 1; //公司id
        $superior_shop_id = 1; //总店id
        $shop_id = 1; //门店id
        $search_data = $request->all();
        $find_out_data = DB::table('outin_details as a')
            ->leftJoin('outin_record as b', 'b.oure_id', '=', 'a.oude_oure_id')
            ->leftJoin('goods as d', 'd.goo_id', '=', 'a.oude_goo_id')
            ->where('oure_cid', 1)
            ->where('oure_shop_id', 1)
            ->where('oure_out_ware_id', $ware_id)
            ->select('oure_number', 'oure_original_number', 'goo_name', 'goo_goods_encode', 'goo_id', 'oude_goo_number', 'goo_type', 'oure_waon_class', 'oure_create_time')
            ->get()->toArray();
        $find_in_data = DB::table('outin_details as a')
            ->leftJoin('outin_record as b', 'b.oure_id', '=', 'a.oude_oure_id')
            ->leftJoin('goods as d', 'd.goo_id', '=', 'a.oude_goo_id')
            ->where('oure_cid', 1)
            ->where('oure_shop_id', 1)
            ->where('oure_in_ware_id', $ware_id)
            ->select('oure_number', 'oure_original_number', 'goo_name', 'goo_goods_encode', 'goo_id', 'oude_goo_number', 'goo_type', 'oure_waon_class', 'oure_create_time')
            ->get()->toArray();
        // $goo_number_out_amount = [];
        // $goo_number_in_amount = [];
        // $goo_number_amount = [];
        // // 出库数量统计
        // foreach ($find_out_data as $key => $value) {
        //     if (isset($goo_number_out_amount[$value->goo_id])) {
        //         $goo_number_out_amount[$value->goo_id] += $value->oude_goo_number;
        //     }else{
        //         $goo_number_out_amount[$value->goo_id] = $value->oude_goo_number;
        //     }
        // }
        // // 入库数量统计
        // foreach ($find_in_data as $key => $value) {
        //     if (isset($goo_number_in_amount[$value->goo_id])) {
        //         $goo_number_in_amount[$value->goo_id] += $value->oude_goo_number;
        //     }else{
        //         $goo_number_in_amount[$value->goo_id] = $value->oude_goo_number;
        //     }
        // }
        // $goo_number_amount = $goo_number_in_amount;//先赋值入库数量
        // // 计算剩余库存数量，入库数量减去出库数量=剩余库存数量
        // foreach ($goo_number_out_amount as $key => $value) {
        //     if (isset($goo_number_in_amount[$key])) {
        //         $goo_number_amount[$key] = $goo_number_in_amount[$key] - $value;
        //     } else {
        //         $goo_number_amount[$key] = - $value;
        //     }
        // }
        // $goo_number_amount = array_filter($goo_number_amount);
        // // 查询导入的商品数据
        // $data =DB::table('excel_data_cache')->where('exdc_type', 7)->get();
        // $data = json_decode($data, true);
        // $data_info =[];
        // $cid =1;
        // $shop_id =1;
        // $superior_shop_id =1;
        // foreach ($data as $key => $value) {
        //     $exdc_data = json_decode($value['exdc_data'], true);
        //     // dump($exdc_data);
        //     $find_goo_id = DB::table('goods')
        //         ->where('goo_cid', $cid)
        //         ->where('goo_shop_id', $shop_id)
        //         ->where('goo_superior_shop_id', $superior_shop_id)
        //         ->where('goo_type', $goo_type)
        //         ->where('goo_delete', 1)
        //         ->where('goo_goods_encode', $exdc_data['goo_goods_encode'])
        //         ->select('goo_id')
        //         ->first();
        //     $exdc_data['goo_id'] = $find_goo_id->goo_id;
        //     $data_info[] = $exdc_data;
        // }
        // // dump($data_info);exit;
        // // exit;
        // $excel_goo_data = array_column($data_info, null, 'goo_id');
        // $excel_goo_data = json_decode(json_encode($excel_goo_data), true);
        // // dump($excel_goo_data);
        // // exit;
        // $excel_goo_goods_encode = array_column($data_info, 'goo_goods_encode');

        // $excel_goo_amount = [];//最后剩余数量
        // // 计算仓库最终的库存数量
        // // dump($goo_number_amount);exit;
        // foreach ($goo_number_amount as $key => $value) {
        //     if (isset($excel_goo_amount[$key])) {
        //         $excel_goo_amount[$key] += $excel_goo_data[$key]['hwcl'] + $value;//固定仓
        //         unset($excel_goo_data[$key]);
        //     } else {
        //         // 固定仓
        //         if (isset($excel_goo_data[$key]['hwcl'])) {
        //             if (!empty($excel_goo_data[$key]['hwcl'])) {
        //                 $excel_goo_amount[$key] = $excel_goo_data[$key]['hwcl'] + $value;//固定仓
        //                 unset($excel_goo_data[$key]);
        //             } else {
        //                 $excel_goo_amount[$key] = $value;//固定仓
        //             }
        //         } else {
        //             $excel_goo_amount[$key] = $value;
        //         }
        //         if ($excel_goo_amount[$key] < 0) {
        //             $excel_goods_fu[$key] = $excel_goo_amount[$key];//固定仓
        //         } else {
        //             $excel_goods_zheng[$key] = $excel_goo_amount[$key];//固定仓
        //         }
        //     }
        // }
        // // dump($excel_goods_fu);
        // // dump($excel_goods_zheng);
        // // dump($excel_goo_data);
        // // dump($excel_goo_amount);
        // if (!empty($excel_goo_data)) {
        //     $ids = array_column($excel_goo_data, 'hwcl', 'goo_id');
        //     // dump($ids);
        //     // $arr = array_combine($ids, $excel_goods_zheng);
        //     $arr = $ids + $excel_goods_zheng;
        //     $excel_goods_zheng = $arr;
        // }
        // // dump($excel_goods_zheng);
        // // exit;
        // // 读取负值
        // if (isset($excel_goods_fu)) {
        //     foreach ($excel_goods_fu as $goo_id => $value) {
        //         $wagk_data['wagk_ware_id'] = $ware_id;
        //         $wagk_data['wagk_class'] = $waon_class;
        //         $wagk_data['wagk_goo_id'] = $key;
        //         $wagk_data['wagk_stock_number'] = $value;
        //         $wagk_data['wagk_update_time'] = $this->now_time;
        //         $wagk_res = DB::table('warehouse_goods_kucun')->insert($wagk_data);
        //     }
        // }
        // // foreach ($excel_goo_amount as $goo_id => $value) {
        // foreach ($excel_goods_zheng as $goo_id => $value) {
        //     // dump($value);exit;
        //     $wago_id= DB::table('warehouse_goods')
        //         ->where('wago_ware_id', $ware_id)
        //         ->where('wago_goo_id', $goo_id)
        //         ->where('wago_class', $waon_class)
        //         ->value('wago_id');
        //     dump($wago_id);
        //     if (empty($wago_id)) {
        //         // 仓库内没有商品，添加商品
        //         $warehouse_goods['wago_ware_id'] = $ware_id;//仓库
        //         $warehouse_goods['wago_class'] = $waon_class;
        //         $warehouse_goods['wago_goo_id'] = $goo_id;//商品
        //         $warehouse_goods['wago_stock_number'] = $value;//良品库存
        //         $warehouse_goods['wago_update_time'] = $this->now_time;//更新时间
        //         $wago_res = DB::table('warehouse_goods')->insert($warehouse_goods);
        //         dump($wago_res);
        //         // unset($warehouse_goods);
        //     } else {
        //         // 仓库内已经有商品了，更改库存数量
        //         $edit_data['wago_stock_number'] = $value;
        //         $edit_data['wago_update_time'] = $this->now_time;
        //         dump($edit_data);
        //         $res= DB::table('warehouse_goods')
        //             ->where('wago_ware_id', $ware_id)
        //             ->where('wago_goo_id', $goo_id)
        //             ->where('wago_class', $waon_class)
        //             ->update($edit_data);
        //         dump($res);
        //     }
        // }
        // $find_waon_data = DB::table('warehouse_onhand')
        //     ->where('waon_ware_id', $ware_id)
        //     ->where('waon_class', $waon_class)
        //     ->first();
        // $waon_edit['waon_all_amount'] = $find_waon_data->waon_all_amount + array_sum($excel_goods_zheng);
        // $waon_edit['waon_stock_fine_amount'] = $find_waon_data->waon_stock_fine_amount + array_sum($excel_goods_zheng);
        // $waon_edit['waon_update_time'] = $this->now_time;
        // $res = DB::table('warehouse_onhand')
        //     ->where('waon_ware_id', $ware_id)
        //     ->where('waon_class', $waon_class)
        //     ->update($waon_edit);
        // dump($res);
        // die;
        // dump($excel_goods_zheng);exit;
        // $data = $find_out_data;//出库
        if ($request['type'] == 1) {
            $data = $find_in_data; //入库
            $file_name = '闽D937Q7吴文祥移动仓入库记录';
        } else {
            $data = $find_out_data; //出库
            $file_name = '闽D937Q7吴文祥移动仓出库记录';
        }
        if (!empty($data)) {
            // 将对象转化为数组
            $data = json_decode(json_encode($data), true);
            foreach ($data as $key => $value) {
                // 结算方式
                if ($value['goo_type'] == 1) {
                    $data[$key]['goo_type'] = '正常';
                }
                if ($value['goo_type'] == 2) {
                    $data[$key]['goo_type'] = '赠品';
                }
                if ($value['goo_type'] == 4) {
                    $data[$key]['goo_type'] = '旧货';
                }

                if ($value['oure_waon_class'] == 1) {
                    $data[$key]['oure_waon_class'] = '货物仓';
                }
                if ($value['oure_waon_class'] == 2) {
                    $data[$key]['oure_waon_class'] = '非商品仓';
                }
                if ($value['oure_waon_class'] == 3) {
                    $data[$key]['oure_waon_class'] = '旧货仓';
                }
                if ($value['oure_waon_class'] == 4) {
                    $data[$key]['oure_waon_class'] = '临时仓';
                }
                //商品编号
                // $data[$key]['goo_goods_encode'] = "\t".empty($value['goo_goods_encode']) ? '' : $value['goo_goods_encode'];
                $data[$key]['goo_name'] = empty($value['goo_name']) ? '' : $value['goo_name'];
            }
        } else {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'没有符合条件的数据']);
        }
        $pathName = storage_path() . "/app/public/excel"; //获取上传excel路径
        // 创建文件夹
        if (!file_exists($pathName)) {
            mkdir($pathName, 0775, true);
            chmod($pathName, 0775);
        }

        // $streamFileRand = time() . rand(10000, 99999).'闽D937Q7吴文祥移动仓出库记录.xls';//
        $streamFileRand = time() . rand(10000, 99999) . $file_name . '.xls'; //
        // 产生一个随机文件名（因为你base64上来肯定没有文件名，这里你可以自己设置一个也行）
        $streamFilename = $pathName . '/' . $streamFileRand;

        $where['action_name'] = '出入库记录'; //
        $where['field_name'] = ['单号', '原始单号', '商品名称', '商品编号', '商品id', '数量', '类型', '仓库类别', '操作时间'];
        // 调用导出的公共方法
        export::publicExport(
            $streamFilename, //路径
            $where,    //sheet名及其每一行的标题
            $data      //导出数据
        );

        // 判断文件是否存在 存在则成功  不存在则失败
        if (file_exists($streamFilename)) {
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>'http://mk.bluearp.com/storage/excel/' . $streamFileRand]);
        } else {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'导出失败']);
        }
    }

    // 闽DC923T林土水移动仓库存（截止9.11日8：30前）
    public function ltstest(Request $request)
    {
        ignore_user_abort();
        set_time_limit(0);
        $ware_id = 40; //林土水库存
        $waon_class = 1; //仓库类别1货物仓2非货物仓3旧货仓4临时仓
        $goo_type = 1; //商品类型1正常商品2临时商品3活动商品4旧货商品
        $cid = 1; //公司id
        $superior_shop_id = 1; //总店id
        $shop_id = 1; //门店id
        $search_data = $request->all();
        $find_out_data = DB::table('outin_details as a')
            ->leftJoin('outin_record as b', 'b.oure_id', '=', 'a.oude_oure_id')
            ->leftJoin('goods as d', 'd.goo_id', '=', 'a.oude_goo_id')
            ->where('oure_cid', 1)
            ->where('oure_shop_id', 1)
            ->where('oure_out_ware_id', $ware_id)
            ->select('oure_number', 'oure_original_number', 'goo_name', 'goo_goods_encode', 'goo_id', 'oude_goo_number', 'goo_type', 'oure_waon_class', 'oure_create_time')
            ->get()->toArray();
        $find_in_data = DB::table('outin_details as a')
            ->leftJoin('outin_record as b', 'b.oure_id', '=', 'a.oude_oure_id')
            ->leftJoin('goods as d', 'd.goo_id', '=', 'a.oude_goo_id')
            ->where('oure_cid', 1)
            ->where('oure_shop_id', 1)
            ->where('oure_in_ware_id', $ware_id)
            ->select('oure_number', 'oure_original_number', 'goo_name', 'goo_goods_encode', 'goo_id', 'oude_goo_number', 'goo_type', 'oure_waon_class', 'oure_create_time')
            ->get()->toArray();
        $goo_number_out_amount = [];
        $goo_number_in_amount = [];
        $goo_number_amount = [];
        // 出库数量统计
        foreach ($find_out_data as $key => $value) {
            if (isset($goo_number_out_amount[$value->goo_id])) {
                $goo_number_out_amount[$value->goo_id] += $value->oude_goo_number;
            } else {
                $goo_number_out_amount[$value->goo_id] = $value->oude_goo_number;
            }
        }
        // 入库数量统计
        foreach ($find_in_data as $key => $value) {
            if (isset($goo_number_in_amount[$value->goo_id])) {
                $goo_number_in_amount[$value->goo_id] += $value->oude_goo_number;
            } else {
                $goo_number_in_amount[$value->goo_id] = $value->oude_goo_number;
            }
        }
        $goo_number_amount = $goo_number_in_amount; //先赋值入库数量
        // 计算剩余库存数量，入库数量减去出库数量=剩余库存数量
        foreach ($goo_number_out_amount as $key => $value) {
            if (isset($goo_number_in_amount[$key])) {
                $goo_number_amount[$key] = $goo_number_in_amount[$key] - $value;
            } else {
                $goo_number_amount[$key] = -$value;
            }
        }
        $goo_number_amount = array_filter($goo_number_amount);
        // 查询导入的商品数据
        $data = DB::table('excel_data_cache')->where('exdc_type', 8)->get();
        $data = json_decode($data, true);
        $data_info = [];
        $cid = 1;
        $shop_id = 1;
        $superior_shop_id = 1;
        foreach ($data as $key => $value) {
            $exdc_data = json_decode($value['exdc_data'], true);
            // dump($exdc_data);
            $find_goo_id = DB::table('goods')
                ->where('goo_cid', $cid)
                ->where('goo_shop_id', $shop_id)
                ->where('goo_superior_shop_id', $superior_shop_id)
                ->where('goo_type', $goo_type)
                ->where('goo_delete', 1)
                ->where('goo_goods_encode', $exdc_data['goo_goods_encode'])
                ->select('goo_id')
                ->first();
            $exdc_data['goo_id'] = $find_goo_id->goo_id;
            $data_info[] = $exdc_data;
        }
        // exit;
        // $excel_goo_data = array_column($data_info, null, 'goo_id');
        // $excel_goo_data = json_decode(json_encode($excel_goo_data), true);
        // // dump($excel_goo_data);exit;
        // $excel_goo_goods_encode = array_column($data_info, 'goo_goods_encode');

        // $excel_goo_amount = [];//最后剩余数量
        // // 计算仓库最终的库存数量
        // // dump($goo_number_amount);exit;
        // foreach ($goo_number_amount as $key => $value) {
        //     if (isset($excel_goo_amount[$key])) {
        //         $excel_goo_amount[$key] += $excel_goo_data[$key]['hwcl'] + $value;//固定仓
        //     } else {
        //         // 固定仓
        //         if (isset($excel_goo_data[$key]['hwcl'])) {
        //             if (!empty($excel_goo_data[$key]['hwcl'])) {
        //                 $excel_goo_amount[$key] = $excel_goo_data[$key]['hwcl'] + $value;//固定仓
        //             } else {
        //                 $excel_goo_amount[$key] = $value;//固定仓
        //             }
        //         } else {
        //             $excel_goo_amount[$key] = $value;
        //         }
        //         if ($excel_goo_amount[$key] < 0) {
        //             $excel_goods_fu[$key] = $excel_goo_amount[$key];//固定仓
        //         } else {
        //             $excel_goods_zheng[$key] = $excel_goo_amount[$key];//固定仓
        //         }
        //     }
        // }
        // // dump($excel_goods_fu);
        // // dump($excel_goods_zheng);
        // // dump($excel_goo_amount);
        // // exit;
        // if (!empty($excel_goo_data)) {
        //     $ids = array_column($excel_goo_data, 'hwcl', 'goo_id');
        //     // dump($ids);
        //     // $arr = array_combine($ids, $excel_goods_zheng);
        //     $arr = $ids + $excel_goods_zheng;
        //     $excel_goods_zheng = $arr;
        // }
        // // 读取负值
        // if (isset($excel_goods_fu)) {
        //     foreach ($excel_goods_fu as $goo_id => $value) {
        //         $wagk_data['wagk_ware_id'] = $ware_id;
        //         $wagk_data['wagk_class'] = $waon_class;
        //         $wagk_data['wagk_goo_id'] = $key;
        //         $wagk_data['wagk_stock_number'] = $value;
        //         $wagk_data['wagk_update_time'] = $this->now_time;
        //         $wagk_res = DB::table('warehouse_goods_kucun')->insert($wagk_data);
        //     }
        // }
        // // foreach ($excel_goo_amount as $goo_id => $value) {
        // foreach ($excel_goods_zheng as $goo_id => $value) {
        //     // dump($value);exit;
        //     $wago_id= DB::table('warehouse_goods')
        //         ->where('wago_ware_id', $ware_id)
        //         ->where('wago_goo_id', $goo_id)
        //         ->where('wago_class', $waon_class)
        //         ->value('wago_id');
        //     dump($wago_id);
        //     if (empty($wago_id)) {
        //         // 仓库内没有商品，添加商品
        //         $warehouse_goods['wago_ware_id'] = $ware_id;//仓库
        //         $warehouse_goods['wago_class'] = $waon_class;
        //         $warehouse_goods['wago_goo_id'] = $goo_id;//商品
        //         $warehouse_goods['wago_stock_number'] = $value;//良品库存
        //         $warehouse_goods['wago_update_time'] = $this->now_time;//更新时间
        //         $wago_res = DB::table('warehouse_goods')->insert($warehouse_goods);
        //         dump($wago_res);
        //         // unset($warehouse_goods);
        //     } else {
        //         // 仓库内已经有商品了，更改库存数量
        //         $edit_data['wago_stock_number'] = $value;
        //         $edit_data['wago_update_time'] = $this->now_time;
        //         dump($edit_data);
        //         $res= DB::table('warehouse_goods')
        //             ->where('wago_ware_id', $ware_id)
        //             ->where('wago_goo_id', $goo_id)
        //             ->where('wago_class', $waon_class)
        //             ->update($edit_data);
        //         dump($res);
        //     }
        // }
        // $find_waon_data = DB::table('warehouse_onhand')
        //     ->where('waon_ware_id', $ware_id)
        //     ->where('waon_class', $waon_class)
        //     ->first();
        // $waon_edit['waon_all_amount'] = $find_waon_data->waon_all_amount + array_sum($excel_goods_zheng);
        // $waon_edit['waon_stock_fine_amount'] = $find_waon_data->waon_stock_fine_amount + array_sum($excel_goods_zheng);
        // $waon_edit['waon_update_time'] = $this->now_time;
        // $res = DB::table('warehouse_onhand')
        //     ->where('waon_ware_id', $ware_id)
        //     ->where('waon_class', $waon_class)
        //     ->update($waon_edit);
        // dump($res);
        // die;
        // dump($excel_goods_zheng);exit;
        // $data = $find_out_data;//出库
        $data = $find_in_data; //入库
        if (!empty($data)) {
            // 将对象转化为数组
            $data = json_decode(json_encode($data), true);
            foreach ($data as $key => $value) {
                // 结算方式
                if ($value['goo_type'] == 1) {
                    $data[$key]['goo_type'] = '正常';
                }
                if ($value['goo_type'] == 2) {
                    $data[$key]['goo_type'] = '赠品';
                }
                if ($value['goo_type'] == 4) {
                    $data[$key]['goo_type'] = '旧货';
                }

                if ($value['oure_waon_class'] == 1) {
                    $data[$key]['oure_waon_class'] = '货物仓';
                }
                if ($value['oure_waon_class'] == 2) {
                    $data[$key]['oure_waon_class'] = '非商品仓';
                }
                if ($value['oure_waon_class'] == 3) {
                    $data[$key]['oure_waon_class'] = '旧货仓';
                }
                if ($value['oure_waon_class'] == 4) {
                    $data[$key]['oure_waon_class'] = '临时仓';
                }
                //商品编号
                // $data[$key]['goo_goods_encode'] = "\t".empty($value['goo_goods_encode']) ? '' : $value['goo_goods_encode'];
                $data[$key]['goo_name'] = empty($value['goo_name']) ? '' : $value['goo_name'];
            }
        } else {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'没有符合条件的数据']);
        }
        $pathName = storage_path() . "/app/public/excel"; //获取上传excel路径
        // 创建文件夹
        if (!file_exists($pathName)) {
            mkdir($pathName, 0775, true);
            chmod($pathName, 0775);
        }

        // $streamFileRand = time() . rand(10000, 99999).'闽DC923T林土水移动仓出库记录.xls';//出库
        $streamFileRand = time() . rand(10000, 99999) . '闽DC923T林土水移动仓入库记录.xls'; //出库
        // 产生一个随机文件名（因为你base64上来肯定没有文件名，这里你可以自己设置一个也行）
        $streamFilename = $pathName . '/' . $streamFileRand;

        $where['action_name'] = '出入库记录'; //
        $where['field_name'] = ['单号', '原始单号', '商品名称', '商品编号', '商品id', '数量', '类型', '仓库类别', '操作时间'];
        // 调用导出的公共方法
        export::publicExport(
            $streamFilename, //路径
            $where,    //sheet名及其每一行的标题
            $data      //导出数据
        );

        // 判断文件是否存在 存在则成功  不存在则失败
        if (file_exists($streamFilename)) {
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>'http://mk.bluearp.com/storage/excel/' . $streamFileRand]);
        } else {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'导出失败']);
        }
    }

    // 闽DG8U13黄行顺移动仓库存（截止9.11日8：30前）
    public function hxstest(Request $request)
    {
        ignore_user_abort();
        set_time_limit(0);
        $ware_id = 36; //黄行顺库存
        $waon_class = 1; //仓库类别1货物仓2非货物仓3旧货仓4临时仓
        $goo_type = 1; //商品类型1正常商品2临时商品3活动商品4旧货商品
        $cid = 1; //公司id
        $superior_shop_id = 1; //总店id
        $shop_id = 1; //门店id
        $search_data = $request->all();
        $find_out_data = DB::table('outin_details as a')
            ->leftJoin('outin_record as b', 'b.oure_id', '=', 'a.oude_oure_id')
            ->leftJoin('goods as d', 'd.goo_id', '=', 'a.oude_goo_id')
            ->where('oure_cid', 1)
            ->where('oure_shop_id', 1)
            ->where('oure_out_ware_id', $ware_id)
            ->select('oure_number', 'oure_original_number', 'goo_name', 'goo_goods_encode', 'goo_id', 'oude_goo_number', 'goo_type', 'oure_waon_class', 'oure_create_time')
            ->get()->toArray();
        $find_in_data = DB::table('outin_details as a')
            ->leftJoin('outin_record as b', 'b.oure_id', '=', 'a.oude_oure_id')
            ->leftJoin('goods as d', 'd.goo_id', '=', 'a.oude_goo_id')
            ->where('oure_cid', 1)
            ->where('oure_shop_id', 1)
            ->where('oure_in_ware_id', $ware_id)
            ->select('oure_number', 'oure_original_number', 'goo_name', 'goo_goods_encode', 'goo_id', 'oude_goo_number', 'goo_type', 'oure_waon_class', 'oure_create_time')
            ->get()->toArray();
        // $goo_number_out_amount = [];
        // $goo_number_in_amount = [];
        // $goo_number_amount = [];
        // // 出库数量统计
        // foreach ($find_out_data as $key => $value) {
        //     if (isset($goo_number_out_amount[$value->goo_id])) {
        //         $goo_number_out_amount[$value->goo_id] += $value->oude_goo_number;
        //     }else{
        //         $goo_number_out_amount[$value->goo_id] = $value->oude_goo_number;
        //     }
        // }
        // // 入库数量统计
        // foreach ($find_in_data as $key => $value) {
        //     if (isset($goo_number_in_amount[$value->goo_id])) {
        //         $goo_number_in_amount[$value->goo_id] += $value->oude_goo_number;
        //     }else{
        //         $goo_number_in_amount[$value->goo_id] = $value->oude_goo_number;
        //     }
        // }
        // $goo_number_amount = $goo_number_in_amount;//先赋值入库数量
        // // 计算剩余库存数量，入库数量减去出库数量=剩余库存数量
        // foreach ($goo_number_out_amount as $key => $value) {
        //     if (isset($goo_number_in_amount[$key])) {
        //         $goo_number_amount[$key] = $goo_number_in_amount[$key] - $value;
        //     } else {
        //         $goo_number_amount[$key] = - $value;
        //     }
        // }
        // $goo_number_amount = array_filter($goo_number_amount);
        // // 查询导入的商品数据
        // $data =DB::table('excel_data_cache')->where('exdc_type', 9)->get();
        // $data = json_decode($data, true);
        // $data_info =[];
        // $cid =1;
        // $shop_id =1;
        // $superior_shop_id =1;
        // foreach ($data as $key => $value) {
        //     $exdc_data = json_decode($value['exdc_data'], true);
        //     // dump($exdc_data);
        //     $find_goo_id = DB::table('goods')
        //         ->where('goo_cid', $cid)
        //         ->where('goo_shop_id', $shop_id)
        //         ->where('goo_superior_shop_id', $superior_shop_id)
        //         ->where('goo_type', $goo_type)
        //         ->where('goo_delete', 1)
        //         ->where('goo_goods_encode', $exdc_data['goo_goods_encode'])
        //         ->select('goo_id')
        //         ->first();
        //     $exdc_data['goo_id'] = $find_goo_id->goo_id;
        //     $data_info[] = $exdc_data;
        // }
        // // exit;
        // $excel_goo_data = array_column($data_info, null, 'goo_id');
        // $excel_goo_data = json_decode(json_encode($excel_goo_data), true);
        // // dump($excel_goo_data);exit;
        // $excel_goo_goods_encode = array_column($data_info, 'goo_goods_encode');

        // $excel_goo_amount = [];//最后剩余数量
        // // 计算仓库最终的库存数量
        // // dump($goo_number_amount);exit;
        // foreach ($goo_number_amount as $key => $value) {
        //     if (isset($excel_goo_amount[$key])) {
        //         $excel_goo_amount[$key] += $excel_goo_data[$key]['hwcl'] + $value;//固定仓
        //     } else {
        //         // 固定仓
        //         if (isset($excel_goo_data[$key]['hwcl'])) {
        //             if (!empty($excel_goo_data[$key]['hwcl'])) {
        //                 $excel_goo_amount[$key] = $excel_goo_data[$key]['hwcl'] + $value;//固定仓
        //             } else {
        //                 $excel_goo_amount[$key] = $value;//固定仓
        //             }
        //         } else {
        //             $excel_goo_amount[$key] = $value;
        //         }
        //         if ($excel_goo_amount[$key] < 0) {
        //             $excel_goods_fu[$key] = $excel_goo_amount[$key];//固定仓
        //         } else {
        //             $excel_goods_zheng[$key] = $excel_goo_amount[$key];//固定仓
        //         }
        //     }
        // }
        // // dump($excel_goods_fu);
        // // dump($excel_goods_zheng);
        // // dump($excel_goo_amount);
        // // exit;
        // if (!empty($excel_goo_data)) {
        //     $ids = array_column($excel_goo_data, 'hwcl', 'goo_id');
        //     // dump($ids);
        //     // $arr = array_combine($ids, $excel_goods_zheng);
        //     $arr = $ids + $excel_goods_zheng;
        //     $excel_goods_zheng = $arr;
        // }
        // // 读取负值
        // if (isset($excel_goods_fu)) {
        //     foreach ($excel_goods_fu as $goo_id => $value) {
        //         $wagk_data['wagk_ware_id'] = $ware_id;
        //         $wagk_data['wagk_class'] = $waon_class;
        //         $wagk_data['wagk_goo_id'] = $key;
        //         $wagk_data['wagk_stock_number'] = $value;
        //         $wagk_data['wagk_update_time'] = $this->now_time;
        //         $wagk_res = DB::table('warehouse_goods_kucun')->insert($wagk_data);
        //     }
        // }
        // // foreach ($excel_goo_amount as $goo_id => $value) {
        // foreach ($excel_goods_zheng as $goo_id => $value) {
        //     // dump($value);exit;
        //     $wago_id= DB::table('warehouse_goods')
        //         ->where('wago_ware_id', $ware_id)
        //         ->where('wago_goo_id', $goo_id)
        //         ->where('wago_class', $waon_class)
        //         ->value('wago_id');
        //     dump($wago_id);
        //     if (empty($wago_id)) {
        //         // 仓库内没有商品，添加商品
        //         $warehouse_goods['wago_ware_id'] = $ware_id;//仓库
        //         $warehouse_goods['wago_class'] = $waon_class;
        //         $warehouse_goods['wago_goo_id'] = $goo_id;//商品
        //         $warehouse_goods['wago_stock_number'] = $value;//良品库存
        //         $warehouse_goods['wago_update_time'] = $this->now_time;//更新时间
        //         $wago_res = DB::table('warehouse_goods')->insert($warehouse_goods);
        //         dump($wago_res);
        //         // unset($warehouse_goods);
        //     } else {
        //         // 仓库内已经有商品了，更改库存数量
        //         $edit_data['wago_stock_number'] = $value;
        //         $edit_data['wago_update_time'] = $this->now_time;
        //         dump($edit_data);
        //         $res= DB::table('warehouse_goods')
        //             ->where('wago_ware_id', $ware_id)
        //             ->where('wago_goo_id', $goo_id)
        //             ->where('wago_class', $waon_class)
        //             ->update($edit_data);
        //         dump($res);
        //     }
        // }
        // $find_waon_data = DB::table('warehouse_onhand')
        //     ->where('waon_ware_id', $ware_id)
        //     ->where('waon_class', $waon_class)
        //     ->first();
        // $waon_edit['waon_all_amount'] = $find_waon_data->waon_all_amount + array_sum($excel_goods_zheng);
        // $waon_edit['waon_stock_fine_amount'] = $find_waon_data->waon_stock_fine_amount + array_sum($excel_goods_zheng);
        // $waon_edit['waon_update_time'] = $this->now_time;
        // $res = DB::table('warehouse_onhand')
        //     ->where('waon_ware_id', $ware_id)
        //     ->where('waon_class', $waon_class)
        //     ->update($waon_edit);
        // dump($res);
        // die;
        // dump($excel_goods_zheng);exit;
        // $data = $find_out_data;//出库
        $data = $find_in_data; //入库
        if (!empty($data)) {
            // 将对象转化为数组
            $data = json_decode(json_encode($data), true);
            foreach ($data as $key => $value) {
                // 结算方式
                if ($value['goo_type'] == 1) {
                    $data[$key]['goo_type'] = '正常';
                }
                if ($value['goo_type'] == 2) {
                    $data[$key]['goo_type'] = '赠品';
                }
                if ($value['goo_type'] == 4) {
                    $data[$key]['goo_type'] = '旧货';
                }

                if ($value['oure_waon_class'] == 1) {
                    $data[$key]['oure_waon_class'] = '货物仓';
                }
                if ($value['oure_waon_class'] == 2) {
                    $data[$key]['oure_waon_class'] = '非商品仓';
                }
                if ($value['oure_waon_class'] == 3) {
                    $data[$key]['oure_waon_class'] = '旧货仓';
                }
                if ($value['oure_waon_class'] == 4) {
                    $data[$key]['oure_waon_class'] = '临时仓';
                }
                //商品编号
                // $data[$key]['goo_goods_encode'] = "\t".empty($value['goo_goods_encode']) ? '' : $value['goo_goods_encode'];
                $data[$key]['goo_name'] = empty($value['goo_name']) ? '' : $value['goo_name'];
            }
        } else {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'没有符合条件的数据']);
        }
        $pathName = storage_path() . "/app/public/excel"; //获取上传excel路径
        // 创建文件夹
        if (!file_exists($pathName)) {
            mkdir($pathName, 0775, true);
            chmod($pathName, 0775);
        }

        // $streamFileRand = time() . rand(10000, 99999).'黄行顺移动仓出库记录.xls';//出库
        $streamFileRand = time() . rand(10000, 99999) . '黄行顺移动仓入库记录.xls'; //入库
        // 产生一个随机文件名（因为你base64上来肯定没有文件名，这里你可以自己设置一个也行）
        $streamFilename = $pathName . '/' . $streamFileRand;

        $where['action_name'] = '出入库记录'; //
        $where['field_name'] = ['单号', '原始单号', '商品名称', '商品编号', '商品id', '数量', '类型', '仓库类别', '操作时间'];
        // 调用导出的公共方法
        export::publicExport(
            $streamFilename, //路径
            $where,    //sheet名及其每一行的标题
            $data      //导出数据
        );

        // 判断文件是否存在 存在则成功  不存在则失败
        if (file_exists($streamFilename)) {
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>'http://mk.bluearp.com/storage/excel/' . $streamFileRand]);
        } else {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'导出失败']);
        }
    }

    // 闽DN3K50杨阳移动仓库存（截止9.11日8：30前）
    public function yytest(Request $request)
    {
        ignore_user_abort();
        set_time_limit(0);
        $ware_id = 37; //杨阳
        $waon_class = 1; //仓库类别1货物仓2非货物仓3旧货仓4临时仓
        $goo_type = 1; //商品类型1正常商品2临时商品3活动商品4旧货商品
        $cid = 1; //公司id
        $superior_shop_id = 1; //总店id
        $shop_id = 1; //门店id
        $search_data = $request->all();
        $find_out_data = DB::table('outin_details as a')
            ->leftJoin('outin_record as b', 'b.oure_id', '=', 'a.oude_oure_id')
            ->leftJoin('goods as d', 'd.goo_id', '=', 'a.oude_goo_id')
            ->where('oure_cid', 1)
            ->where('oure_shop_id', 1)
            ->where('oure_out_ware_id', $ware_id)
            ->select('oure_number', 'oure_original_number', 'goo_name', 'goo_goods_encode', 'goo_id', 'oude_goo_number', 'goo_type', 'oure_waon_class', 'oure_create_time')
            ->get()->toArray();
        $find_in_data = DB::table('outin_details as a')
            ->leftJoin('outin_record as b', 'b.oure_id', '=', 'a.oude_oure_id')
            ->leftJoin('goods as d', 'd.goo_id', '=', 'a.oude_goo_id')
            ->where('oure_cid', 1)
            ->where('oure_shop_id', 1)
            ->where('oure_in_ware_id', $ware_id)
            ->select('oure_number', 'oure_original_number', 'goo_name', 'goo_goods_encode', 'goo_id', 'oude_goo_number', 'goo_type', 'oure_waon_class', 'oure_create_time')
            ->get()->toArray();
        // $goo_number_out_amount = [];
        // $goo_number_in_amount = [];
        // $goo_number_amount = [];
        // // 出库数量统计
        // foreach ($find_out_data as $key => $value) {
        //     if (isset($goo_number_out_amount[$value->goo_id])) {
        //         $goo_number_out_amount[$value->goo_id] += $value->oude_goo_number;
        //     }else{
        //         $goo_number_out_amount[$value->goo_id] = $value->oude_goo_number;
        //     }
        // }
        // // 入库数量统计
        // foreach ($find_in_data as $key => $value) {
        //     if (isset($goo_number_in_amount[$value->goo_id])) {
        //         $goo_number_in_amount[$value->goo_id] += $value->oude_goo_number;
        //     }else{
        //         $goo_number_in_amount[$value->goo_id] = $value->oude_goo_number;
        //     }
        // }
        // $goo_number_amount = $goo_number_in_amount;//先赋值入库数量
        // // 计算剩余库存数量，入库数量减去出库数量=剩余库存数量
        // foreach ($goo_number_out_amount as $key => $value) {
        //     if (isset($goo_number_in_amount[$key])) {
        //         $goo_number_amount[$key] = $goo_number_in_amount[$key] - $value;
        //     } else {
        //         $goo_number_amount[$key] = - $value;
        //     }
        // }
        // $goo_number_amount = array_filter($goo_number_amount);
        // // 查询导入的商品数据
        // $data =DB::table('excel_data_cache')->where('exdc_type', 10)->get();
        // $data = json_decode($data, true);
        // $data_info =[];
        // $cid =1;
        // $shop_id =1;
        // $superior_shop_id =1;
        // foreach ($data as $key => $value) {
        //     $exdc_data = json_decode($value['exdc_data'], true);
        //     // dump($exdc_data);
        //     $find_goo_id = DB::table('goods')
        //         ->where('goo_cid', $cid)
        //         ->where('goo_shop_id', $shop_id)
        //         ->where('goo_superior_shop_id', $superior_shop_id)
        //         ->where('goo_type', $goo_type)
        //         ->where('goo_delete', 1)
        //         ->where('goo_goods_encode', $exdc_data['goo_goods_encode'])
        //         ->select('goo_id')
        //         ->first();
        //     $exdc_data['goo_id'] = $find_goo_id->goo_id;
        //     $data_info[] = $exdc_data;
        // }
        // // exit;
        // $excel_goo_data = array_column($data_info, null, 'goo_id');
        // $excel_goo_data = json_decode(json_encode($excel_goo_data), true);
        // // dump($excel_goo_data);exit;
        // $excel_goo_goods_encode = array_column($data_info, 'goo_goods_encode');

        // $excel_goo_amount = [];//最后剩余数量
        // // 计算仓库最终的库存数量
        // // dump($goo_number_amount);exit;
        // foreach ($goo_number_amount as $key => $value) {
        //     if (isset($excel_goo_amount[$key])) {
        //         $excel_goo_amount[$key] += $excel_goo_data[$key]['hwcl'] + $value;//固定仓
        //     } else {
        //         // 固定仓
        //         if (isset($excel_goo_data[$key]['hwcl'])) {
        //             if (!empty($excel_goo_data[$key]['hwcl'])) {
        //                 $excel_goo_amount[$key] = $excel_goo_data[$key]['hwcl'] + $value;//固定仓
        //             } else {
        //                 $excel_goo_amount[$key] = $value;//固定仓
        //             }
        //         } else {
        //             $excel_goo_amount[$key] = $value;
        //         }
        //         if ($excel_goo_amount[$key] < 0) {
        //             $excel_goods_fu[$key] = $excel_goo_amount[$key];//固定仓
        //         } else {
        //             $excel_goods_zheng[$key] = $excel_goo_amount[$key];//固定仓
        //         }
        //     }
        // }
        // // dump($excel_goods_fu);
        // // dump($excel_goods_zheng);
        // // dump($excel_goo_amount);
        // // exit;
        // if (!empty($excel_goo_data)) {
        //     $ids = array_column($excel_goo_data, 'hwcl', 'goo_id');
        //     // dump($ids);
        //     // $arr = array_combine($ids, $excel_goods_zheng);
        //     $arr = $ids + $excel_goods_zheng;
        //     $excel_goods_zheng = $arr;
        // }
        // // 读取负值
        // if (isset($excel_goods_fu)) {
        //     foreach ($excel_goods_fu as $goo_id => $value) {
        //         $wagk_data['wagk_ware_id'] = $ware_id;
        //         $wagk_data['wagk_class'] = $waon_class;
        //         $wagk_data['wagk_goo_id'] = $key;
        //         $wagk_data['wagk_stock_number'] = $value;
        //         $wagk_data['wagk_update_time'] = $this->now_time;
        //         $wagk_res = DB::table('warehouse_goods_kucun')->insert($wagk_data);
        //     }
        // }
        // // foreach ($excel_goo_amount as $goo_id => $value) {
        // foreach ($excel_goods_zheng as $goo_id => $value) {
        //     // dump($value);exit;
        //     $wago_id= DB::table('warehouse_goods')
        //         ->where('wago_ware_id', $ware_id)
        //         ->where('wago_goo_id', $goo_id)
        //         ->where('wago_class', $waon_class)
        //         ->value('wago_id');
        //     dump($wago_id);
        //     if (empty($wago_id)) {
        //         // 仓库内没有商品，添加商品
        //         $warehouse_goods['wago_ware_id'] = $ware_id;//仓库
        //         $warehouse_goods['wago_class'] = $waon_class;
        //         $warehouse_goods['wago_goo_id'] = $goo_id;//商品
        //         $warehouse_goods['wago_stock_number'] = $value;//良品库存
        //         $warehouse_goods['wago_update_time'] = $this->now_time;//更新时间
        //         $wago_res = DB::table('warehouse_goods')->insert($warehouse_goods);
        //         dump($wago_res);
        //         // unset($warehouse_goods);
        //     } else {
        //         // 仓库内已经有商品了，更改库存数量
        //         $edit_data['wago_stock_number'] = $value;
        //         $edit_data['wago_update_time'] = $this->now_time;
        //         dump($edit_data);
        //         $res= DB::table('warehouse_goods')
        //             ->where('wago_ware_id', $ware_id)
        //             ->where('wago_goo_id', $goo_id)
        //             ->where('wago_class', $waon_class)
        //             ->update($edit_data);
        //         dump($res);
        //     }
        // }
        // $find_waon_data = DB::table('warehouse_onhand')
        //     ->where('waon_ware_id', $ware_id)
        //     ->where('waon_class', $waon_class)
        //     ->first();
        // $waon_edit['waon_all_amount'] = $find_waon_data->waon_all_amount + array_sum($excel_goods_zheng);
        // $waon_edit['waon_stock_fine_amount'] = $find_waon_data->waon_stock_fine_amount + array_sum($excel_goods_zheng);
        // $waon_edit['waon_update_time'] = $this->now_time;
        // $res = DB::table('warehouse_onhand')
        //     ->where('waon_ware_id', $ware_id)
        //     ->where('waon_class', $waon_class)
        //     ->update($waon_edit);
        // dump($res);
        // die;
        // dump($excel_goods_zheng);exit;
        // $data = $find_out_data;//出库
        $data = $find_in_data; //入库
        if (!empty($data)) {
            // 将对象转化为数组
            $data = json_decode(json_encode($data), true);
            foreach ($data as $key => $value) {
                // 结算方式
                if ($value['goo_type'] == 1) {
                    $data[$key]['goo_type'] = '正常';
                }
                if ($value['goo_type'] == 2) {
                    $data[$key]['goo_type'] = '赠品';
                }
                if ($value['goo_type'] == 4) {
                    $data[$key]['goo_type'] = '旧货';
                }

                if ($value['oure_waon_class'] == 1) {
                    $data[$key]['oure_waon_class'] = '货物仓';
                }
                if ($value['oure_waon_class'] == 2) {
                    $data[$key]['oure_waon_class'] = '非商品仓';
                }
                if ($value['oure_waon_class'] == 3) {
                    $data[$key]['oure_waon_class'] = '旧货仓';
                }
                if ($value['oure_waon_class'] == 4) {
                    $data[$key]['oure_waon_class'] = '临时仓';
                }
                //商品编号
                // $data[$key]['goo_goods_encode'] = "\t".empty($value['goo_goods_encode']) ? '' : $value['goo_goods_encode'];
                $data[$key]['goo_name'] = empty($value['goo_name']) ? '' : $value['goo_name'];
            }
        } else {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'没有符合条件的数据']);
        }
        $pathName = storage_path() . "/app/public/excel"; //获取上传excel路径
        // 创建文件夹
        if (!file_exists($pathName)) {
            mkdir($pathName, 0775, true);
            chmod($pathName, 0775);
        }

        // $streamFileRand = time() . rand(10000, 99999).'移动仓杨阳出库记录.xls';//出库
        $streamFileRand = time() . rand(10000, 99999) . '移动仓杨阳入库记录.xls'; //入库
        // 产生一个随机文件名（因为你base64上来肯定没有文件名，这里你可以自己设置一个也行）
        $streamFilename = $pathName . '/' . $streamFileRand;

        $where['action_name'] = '出入库记录'; //
        $where['field_name'] = ['单号', '原始单号', '商品名称', '商品编号', '商品id', '数量', '类型', '仓库类别', '操作时间'];
        // 调用导出的公共方法
        export::publicExport(
            $streamFilename, //路径
            $where,    //sheet名及其每一行的标题
            $data      //导出数据
        );

        // 判断文件是否存在 存在则成功  不存在则失败
        if (file_exists($streamFilename)) {
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>'http://mk.bluearp.com/storage/excel/' . $streamFileRand]);
        } else {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'导出失败']);
        }
    }

    // 闽DP1K79周志鹏移动仓库存（截止9.11日8：30前）
    public function zhptest(Request $request)
    {
        ignore_user_abort();
        set_time_limit(0);
        $ware_id = 35; //周志鹏库存
        $waon_class = 1; //仓库类别1货物仓2非货物仓3旧货仓4临时仓
        $goo_type = 1; //商品类型1正常商品2临时商品3活动商品4旧货商品
        $cid = 1; //公司id
        $superior_shop_id = 1; //总店id
        $shop_id = 1; //门店id
        $search_data = $request->all();
        $find_out_data = DB::table('outin_details as a')
            ->leftJoin('outin_record as b', 'b.oure_id', '=', 'a.oude_oure_id')
            ->leftJoin('goods as d', 'd.goo_id', '=', 'a.oude_goo_id')
            ->where('oure_cid', 1)
            ->where('oure_shop_id', 1)
            ->where('oure_out_ware_id', $ware_id)
            ->select('oure_number', 'oure_original_number', 'goo_name', 'goo_goods_encode', 'goo_id', 'oude_goo_number', 'goo_type', 'oure_waon_class', 'oure_create_time')
            ->get()->toArray();
        $find_in_data = DB::table('outin_details as a')
            ->leftJoin('outin_record as b', 'b.oure_id', '=', 'a.oude_oure_id')
            ->leftJoin('goods as d', 'd.goo_id', '=', 'a.oude_goo_id')
            ->where('oure_cid', 1)
            ->where('oure_shop_id', 1)
            ->where('oure_in_ware_id', $ware_id)
            ->select('oure_number', 'oure_original_number', 'goo_name', 'goo_goods_encode', 'goo_id', 'oude_goo_number', 'goo_type', 'oure_waon_class', 'oure_create_time')
            ->get()->toArray();
        // $goo_number_out_amount = [];
        // $goo_number_in_amount = [];
        // $goo_number_amount = [];
        // // 出库数量统计
        // foreach ($find_out_data as $key => $value) {
        //     if (isset($goo_number_out_amount[$value->goo_id])) {
        //         $goo_number_out_amount[$value->goo_id] += $value->oude_goo_number;
        //     }else{
        //         $goo_number_out_amount[$value->goo_id] = $value->oude_goo_number;
        //     }
        // }
        // // 入库数量统计
        // foreach ($find_in_data as $key => $value) {
        //     if (isset($goo_number_in_amount[$value->goo_id])) {
        //         $goo_number_in_amount[$value->goo_id] += $value->oude_goo_number;
        //     }else{
        //         $goo_number_in_amount[$value->goo_id] = $value->oude_goo_number;
        //     }
        // }
        // $goo_number_amount = $goo_number_in_amount;//先赋值入库数量
        // // 计算剩余库存数量，入库数量减去出库数量=剩余库存数量
        // foreach ($goo_number_out_amount as $key => $value) {
        //     if (isset($goo_number_in_amount[$key])) {
        //         $goo_number_amount[$key] = $goo_number_in_amount[$key] - $value;
        //     } else {
        //         $goo_number_amount[$key] = - $value;
        //     }
        // }
        // $goo_number_amount = array_filter($goo_number_amount);
        // // 查询导入的商品数据
        // // $data =DB::table('excel_data_cache0912移动仓数据')->where('exdc_type', 3)->get();
        // $data =DB::table('excel_data_cache')->where('exdc_type', 11)->get();
        // $data = json_decode($data, true);
        // $data_info =[];
        // $cid =1;
        // $shop_id =1;
        // $superior_shop_id =1;
        // foreach ($data as $key => $value) {
        //     $exdc_data = json_decode($value['exdc_data'], true);
        //     // dump($exdc_data);
        //     $find_goo_id = DB::table('goods')
        //         ->where('goo_cid', $cid)
        //         ->where('goo_shop_id', $shop_id)
        //         ->where('goo_superior_shop_id', $superior_shop_id)
        //         ->where('goo_type', $goo_type)
        //         ->where('goo_delete', 1)
        //         ->where('goo_goods_encode', $exdc_data['goo_goods_encode'])
        //         ->select('goo_id')
        //         ->first();
        //     $exdc_data['goo_id'] = $find_goo_id->goo_id;
        //     $data_info[] = $exdc_data;
        // }
        // // exit;
        // $excel_goo_data = array_column($data_info, null, 'goo_id');
        // $excel_goo_data = json_decode(json_encode($excel_goo_data), true);
        // // dump($excel_goo_data);exit;
        // $excel_goo_goods_encode = array_column($data_info, 'goo_goods_encode');

        // $excel_goo_amount = [];//最后剩余数量
        // // 计算仓库最终的库存数量
        // // dump($goo_number_amount);exit;
        // foreach ($goo_number_amount as $key => $value) {
        //     if (isset($excel_goo_amount[$key])) {
        //         $excel_goo_amount[$key] += $excel_goo_data[$key]['hwcl'] + $value;//固定仓
        //     } else {
        //         // 固定仓
        //         if (isset($excel_goo_data[$key]['hwcl'])) {
        //             if (!empty($excel_goo_data[$key]['hwcl'])) {
        //                 $excel_goo_amount[$key] = $excel_goo_data[$key]['hwcl'] + $value;//固定仓
        //             } else {
        //                 $excel_goo_amount[$key] = $value;//固定仓
        //             }
        //         } else {
        //             $excel_goo_amount[$key] = $value;
        //         }
        //         if ($excel_goo_amount[$key] < 0) {
        //             $excel_goods_fu[$key] = $excel_goo_amount[$key];//固定仓
        //         } else {
        //             $excel_goods_zheng[$key] = $excel_goo_amount[$key];//固定仓
        //         }
        //     }
        // }
        // // dump($excel_goods_fu);
        // // dump($excel_goods_zheng);
        // // dump($excel_goo_amount);
        // // exit;
        // if (!empty($excel_goo_data)) {
        //     $ids = array_column($excel_goo_data, 'hwcl', 'goo_id');
        //     // dump($ids);
        //     // $arr = array_combine($ids, $excel_goods_zheng);
        //     $arr = $ids + $excel_goods_zheng;
        //     $excel_goods_zheng = $arr;
        // }
        // // 读取负值
        // if (isset($excel_goods_fu)) {
        //     foreach ($excel_goods_fu as $goo_id => $value) {
        //         $wagk_data['wagk_ware_id'] = $ware_id;
        //         $wagk_data['wagk_class'] = $waon_class;
        //         $wagk_data['wagk_goo_id'] = $key;
        //         $wagk_data['wagk_stock_number'] = $value;
        //         $wagk_data['wagk_update_time'] = $this->now_time;
        //         $wagk_res = DB::table('warehouse_goods_kucun')->insert($wagk_data);
        //     }
        // }
        // // foreach ($excel_goo_amount as $goo_id => $value) {
        // foreach ($excel_goods_zheng as $goo_id => $value) {
        //     // dump($value);exit;
        //     $wago_id= DB::table('warehouse_goods')
        //         ->where('wago_ware_id', $ware_id)
        //         ->where('wago_goo_id', $goo_id)
        //         ->where('wago_class', $waon_class)
        //         ->value('wago_id');
        //     dump($wago_id);
        //     if (empty($wago_id)) {
        //         // 仓库内没有商品，添加商品
        //         $warehouse_goods['wago_ware_id'] = $ware_id;//仓库
        //         $warehouse_goods['wago_class'] = $waon_class;
        //         $warehouse_goods['wago_goo_id'] = $goo_id;//商品
        //         $warehouse_goods['wago_stock_number'] = $value;//良品库存
        //         $warehouse_goods['wago_update_time'] = $this->now_time;//更新时间
        //         $wago_res = DB::table('warehouse_goods')->insert($warehouse_goods);
        //         dump($wago_res);
        //         // unset($warehouse_goods);
        //     } else {
        //         // 仓库内已经有商品了，更改库存数量
        //         $edit_data['wago_stock_number'] = $value;
        //         $edit_data['wago_update_time'] = $this->now_time;
        //         dump($edit_data);
        //         $res= DB::table('warehouse_goods')
        //             ->where('wago_ware_id', $ware_id)
        //             ->where('wago_goo_id', $goo_id)
        //             ->where('wago_class', $waon_class)
        //             ->update($edit_data);
        //         dump($res);
        //     }
        // }
        // $find_waon_data = DB::table('warehouse_onhand')
        //     ->where('waon_ware_id', $ware_id)
        //     ->where('waon_class', $waon_class)
        //     ->first();
        // $waon_edit['waon_all_amount'] = $find_waon_data->waon_all_amount + array_sum($excel_goods_zheng);
        // $waon_edit['waon_stock_fine_amount'] = $find_waon_data->waon_stock_fine_amount + array_sum($excel_goods_zheng);
        // $waon_edit['waon_update_time'] = $this->now_time;
        // $res = DB::table('warehouse_onhand')
        //     ->where('waon_ware_id', $ware_id)
        //     ->where('waon_class', $waon_class)
        //     ->update($waon_edit);
        // dump($res);
        // die;
        // dump($excel_goods_zheng);exit;
        // $data = $find_out_data;//出库
        $data = $find_in_data; //入库
        if (!empty($data)) {
            // 将对象转化为数组
            $data = json_decode(json_encode($data), true);
            foreach ($data as $key => $value) {
                // 结算方式
                if ($value['goo_type'] == 1) {
                    $data[$key]['goo_type'] = '正常';
                }
                if ($value['goo_type'] == 2) {
                    $data[$key]['goo_type'] = '赠品';
                }
                if ($value['goo_type'] == 4) {
                    $data[$key]['goo_type'] = '旧货';
                }

                if ($value['oure_waon_class'] == 1) {
                    $data[$key]['oure_waon_class'] = '货物仓';
                }
                if ($value['oure_waon_class'] == 2) {
                    $data[$key]['oure_waon_class'] = '非商品仓';
                }
                if ($value['oure_waon_class'] == 3) {
                    $data[$key]['oure_waon_class'] = '旧货仓';
                }
                if ($value['oure_waon_class'] == 4) {
                    $data[$key]['oure_waon_class'] = '临时仓';
                }
                //商品编号
                // $data[$key]['goo_goods_encode'] = "\t".empty($value['goo_goods_encode']) ? '' : $value['goo_goods_encode'];
                $data[$key]['goo_name'] = empty($value['goo_name']) ? '' : $value['goo_name'];
            }
        } else {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'没有符合条件的数据']);
        }
        $pathName = storage_path() . "/app/public/excel"; //获取上传excel路径
        // 创建文件夹
        if (!file_exists($pathName)) {
            mkdir($pathName, 0775, true);
            chmod($pathName, 0775);
        }

        // $streamFileRand = time() . rand(10000, 99999).'闽DP1K79周志鹏出库记录.xls';//出库
        $streamFileRand = time() . rand(10000, 99999) . '闽DP1K79周志鹏入库记录.xls'; //入库
        // 产生一个随机文件名（因为你base64上来肯定没有文件名，这里你可以自己设置一个也行）
        $streamFilename = $pathName . '/' . $streamFileRand;

        $where['action_name'] = '出入库记录'; //
        $where['field_name'] = ['单号', '原始单号', '商品名称', '商品编号', '商品id', '数量', '类型', '仓库类别', '操作时间'];
        // 调用导出的公共方法
        export::publicExport(
            $streamFilename, //路径
            $where,    //sheet名及其每一行的标题
            $data      //导出数据
        );

        // 判断文件是否存在 存在则成功  不存在则失败
        if (file_exists($streamFilename)) {
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>'http://mk.bluearp.com/storage/excel/' . $streamFileRand]);
        } else {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'导出失败']);
        }
    }

    // 闽DP1M08王木荣移动仓库存（截止9.11日8：30前）
    public function wmrtest(Request $request)
    {
        ignore_user_abort();
        set_time_limit(0);
        $ware_id = 33; //王木荣库存
        $waon_class = 1; //仓库类别1货物仓2非货物仓3旧货仓4临时仓
        $goo_type = 1; //商品类型1正常商品2临时商品3活动商品4旧货商品
        $cid = 1; //公司id
        $superior_shop_id = 1; //总店id
        $shop_id = 1; //门店id
        $search_data = $request->all();
        $find_out_data = DB::table('outin_details as a')
            ->leftJoin('outin_record as b', 'b.oure_id', '=', 'a.oude_oure_id')
            ->leftJoin('goods as d', 'd.goo_id', '=', 'a.oude_goo_id')
            ->where('oure_cid', 1)
            ->where('oure_shop_id', 1)
            ->where('oure_out_ware_id', $ware_id)
            ->select('oure_number', 'oure_original_number', 'goo_name', 'goo_goods_encode', 'goo_id', 'oude_goo_number', 'goo_type', 'oure_waon_class', 'oure_create_time')
            ->get()->toArray();
        $find_in_data = DB::table('outin_details as a')
            ->leftJoin('outin_record as b', 'b.oure_id', '=', 'a.oude_oure_id')
            ->leftJoin('goods as d', 'd.goo_id', '=', 'a.oude_goo_id')
            ->where('oure_cid', 1)
            ->where('oure_shop_id', 1)
            ->where('oure_in_ware_id', $ware_id)
            ->select('oure_number', 'oure_original_number', 'goo_name', 'goo_goods_encode', 'goo_id', 'oude_goo_number', 'goo_type', 'oure_waon_class', 'oure_create_time')
            ->get()->toArray();
        $goo_number_out_amount = [];
        $goo_number_in_amount = [];
        $goo_number_amount = [];
        // 出库数量统计
        foreach ($find_out_data as $key => $value) {
            if (isset($goo_number_out_amount[$value->goo_id])) {
                $goo_number_out_amount[$value->goo_id] += $value->oude_goo_number;
            } else {
                $goo_number_out_amount[$value->goo_id] = $value->oude_goo_number;
            }
        }
        // 入库数量统计
        foreach ($find_in_data as $key => $value) {
            if (isset($goo_number_in_amount[$value->goo_id])) {
                $goo_number_in_amount[$value->goo_id] += $value->oude_goo_number;
            } else {
                $goo_number_in_amount[$value->goo_id] = $value->oude_goo_number;
            }
        }
        $goo_number_amount = $goo_number_in_amount; //先赋值入库数量
        // 计算剩余库存数量，入库数量减去出库数量=剩余库存数量
        foreach ($goo_number_out_amount as $key => $value) {
            if (isset($goo_number_in_amount[$key])) {
                $goo_number_amount[$key] = $goo_number_in_amount[$key] - $value;
            } else {
                $goo_number_amount[$key] = -$value;
            }
        }
        $goo_number_amount = array_filter($goo_number_amount);
        // 查询导入的商品数据
        // $data =DB::table('excel_data_cache0912移动仓数据')->where('exdc_type', 3)->get();
        $data = DB::table('excel_data_cache')->where('exdc_type', 12)->get();
        $data = json_decode($data, true);
        $data_info = [];
        $cid = 1;
        $shop_id = 1;
        $superior_shop_id = 1;
        foreach ($data as $key => $value) {
            $exdc_data = json_decode($value['exdc_data'], true);
            // dump($exdc_data);
            $find_goo_id = DB::table('goods')
                ->where('goo_cid', $cid)
                ->where('goo_shop_id', $shop_id)
                ->where('goo_superior_shop_id', $superior_shop_id)
                ->where('goo_type', $goo_type)
                ->where('goo_delete', 1)
                ->where('goo_goods_encode', $exdc_data['goo_goods_encode'])
                ->select('goo_id')
                ->first();
            $exdc_data['goo_id'] = $find_goo_id->goo_id;
            $data_info[] = $exdc_data;
        }
        // exit;
        // $excel_goo_data = array_column($data_info, null, 'goo_id');
        // $excel_goo_data = json_decode(json_encode($excel_goo_data), true);
        // // dump($excel_goo_data);exit;
        // $excel_goo_goods_encode = array_column($data_info, 'goo_goods_encode');

        // $excel_goo_amount = [];//最后剩余数量
        // // 计算仓库最终的库存数量
        // // dump($goo_number_amount);exit;
        // foreach ($goo_number_amount as $key => $value) {
        //     if (isset($excel_goo_amount[$key])) {
        //         $excel_goo_amount[$key] += $excel_goo_data[$key]['hwcl'] + $value;//固定仓
        //     } else {
        //         // 固定仓
        //         if (isset($excel_goo_data[$key]['hwcl'])) {
        //             if (!empty($excel_goo_data[$key]['hwcl'])) {
        //                 $excel_goo_amount[$key] = $excel_goo_data[$key]['hwcl'] + $value;//固定仓
        //             } else {
        //                 $excel_goo_amount[$key] = $value;//固定仓
        //             }
        //         } else {
        //             $excel_goo_amount[$key] = $value;
        //         }
        //         if ($excel_goo_amount[$key] < 0) {
        //             $excel_goods_fu[$key] = $excel_goo_amount[$key];//固定仓
        //         } else {
        //             $excel_goods_zheng[$key] = $excel_goo_amount[$key];//固定仓
        //         }
        //     }
        // }
        // // dump($excel_goods_fu);
        // // dump($excel_goods_zheng);
        // dump($excel_goo_amount);
        // exit;
        // if (!empty($excel_goo_data)) {
        //     $ids = array_column($excel_goo_data, 'hwcl', 'goo_id');
        //     // dump($ids);
        //     // $arr = array_combine($ids, $excel_goods_zheng);
        //     $arr = $ids + $excel_goods_zheng;
        //     $excel_goods_zheng = $arr;
        // }
        // // 读取负值
        // if (isset($excel_goods_fu)) {
        //     foreach ($excel_goods_fu as $goo_id => $value) {
        //         $wagk_data['wagk_ware_id'] = $ware_id;
        //         $wagk_data['wagk_class'] = $waon_class;
        //         $wagk_data['wagk_goo_id'] = $key;
        //         $wagk_data['wagk_stock_number'] = $value;
        //         $wagk_data['wagk_update_time'] = $this->now_time;
        //         $wagk_res = DB::table('warehouse_goods_kucun')->insert($wagk_data);
        //     }
        // }
        // // foreach ($excel_goo_amount as $goo_id => $value) {
        // foreach ($excel_goods_zheng as $goo_id => $value) {
        //     // dump($value);exit;
        //     $wago_id= DB::table('warehouse_goods')
        //         ->where('wago_ware_id', $ware_id)
        //         ->where('wago_goo_id', $goo_id)
        //         ->where('wago_class', $waon_class)
        //         ->value('wago_id');
        //     dump($wago_id);
        //     if (empty($wago_id)) {
        //         // 仓库内没有商品，添加商品
        //         $warehouse_goods['wago_ware_id'] = $ware_id;//仓库
        //         $warehouse_goods['wago_class'] = $waon_class;
        //         $warehouse_goods['wago_goo_id'] = $goo_id;//商品
        //         $warehouse_goods['wago_stock_number'] = $value;//良品库存
        //         $warehouse_goods['wago_update_time'] = $this->now_time;//更新时间
        //         $wago_res = DB::table('warehouse_goods')->insert($warehouse_goods);
        //         dump($wago_res);
        //         // unset($warehouse_goods);
        //     } else {
        //         // 仓库内已经有商品了，更改库存数量
        //         $edit_data['wago_stock_number'] = $value;
        //         $edit_data['wago_update_time'] = $this->now_time;
        //         dump($edit_data);
        //         $res= DB::table('warehouse_goods')
        //             ->where('wago_ware_id', $ware_id)
        //             ->where('wago_goo_id', $goo_id)
        //             ->where('wago_class', $waon_class)
        //             ->update($edit_data);
        //         dump($res);
        //     }
        // }
        // $find_waon_data = DB::table('warehouse_onhand')
        //     ->where('waon_ware_id', $ware_id)
        //     ->where('waon_class', $waon_class)
        //     ->first();
        // $waon_edit['waon_all_amount'] = $find_waon_data->waon_all_amount + array_sum($excel_goods_zheng);
        // $waon_edit['waon_stock_fine_amount'] = $find_waon_data->waon_stock_fine_amount + array_sum($excel_goods_zheng);
        // $waon_edit['waon_update_time'] = $this->now_time;
        // $res = DB::table('warehouse_onhand')
        //     ->where('waon_ware_id', $ware_id)
        //     ->where('waon_class', $waon_class)
        //     ->update($waon_edit);
        // dump($res);
        // die;
        // dump($excel_goods_zheng);exit;
        $data = $find_out_data; //出库
        // $data = $find_in_data;//入库
        if (!empty($data)) {
            // 将对象转化为数组
            $data = json_decode(json_encode($data), true);
            foreach ($data as $key => $value) {
                // 结算方式
                if ($value['goo_type'] == 1) {
                    $data[$key]['goo_type'] = '正常';
                }
                if ($value['goo_type'] == 2) {
                    $data[$key]['goo_type'] = '赠品';
                }
                if ($value['goo_type'] == 4) {
                    $data[$key]['goo_type'] = '旧货';
                }

                if ($value['oure_waon_class'] == 1) {
                    $data[$key]['oure_waon_class'] = '货物仓';
                }
                if ($value['oure_waon_class'] == 2) {
                    $data[$key]['oure_waon_class'] = '非商品仓';
                }
                if ($value['oure_waon_class'] == 3) {
                    $data[$key]['oure_waon_class'] = '旧货仓';
                }
                if ($value['oure_waon_class'] == 4) {
                    $data[$key]['oure_waon_class'] = '临时仓';
                }
                //商品编号
                // $data[$key]['goo_goods_encode'] = "\t".empty($value['goo_goods_encode']) ? '' : $value['goo_goods_encode'];
                $data[$key]['goo_name'] = empty($value['goo_name']) ? '' : $value['goo_name'];
            }
        } else {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'没有符合条件的数据']);
        }
        $pathName = storage_path() . "/app/public/excel"; //获取上传excel路径
        // 创建文件夹
        if (!file_exists($pathName)) {
            mkdir($pathName, 0775, true);
            chmod($pathName, 0775);
        }

        $streamFileRand = time() . rand(10000, 99999) . '移动仓王木荣出库记录.xls'; //出库
        // $streamFileRand = time() . rand(10000, 99999).'移动仓王木荣入库记录.xls';//入库
        // 产生一个随机文件名（因为你base64上来肯定没有文件名，这里你可以自己设置一个也行）
        $streamFilename = $pathName . '/' . $streamFileRand;

        $where['action_name'] = '出入库记录'; //
        $where['field_name'] = ['单号', '原始单号', '商品名称', '商品编号', '商品id', '数量', '类型', '仓库类别', '操作时间'];
        // 调用导出的公共方法
        export::publicExport(
            $streamFilename, //路径
            $where,    //sheet名及其每一行的标题
            $data      //导出数据
        );

        // 判断文件是否存在 存在则成功  不存在则失败
        if (file_exists($streamFilename)) {
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>'http://mk.bluearp.com/storage/excel/' . $streamFileRand]);
        } else {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'导出失败']);
        }
    }

    public function export(Request $request)
    {
        $search_data = $request->all();
        $data = DB::table('order as a')
            ->leftJoin('order_client as b', 'b.orcl_ord_id', '=', 'a.ord_id')
            ->leftJoin('order_goods as d', 'd.orgo_ord_id', '=', 'a.ord_id')
            ->leftJoin('admin as c', 'c.adm_id', '=', 'a.ord_create_id')
            ->where('ord_cid', $user_info->adm_cid)
            ->where('ord_superior_shop_id', $shop_id)
            ->where('ord_delete', 1)
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['adm_name'])) {
                    $query->where('c.adm_name', 'like', '%' . $search_data['adm_name'] . '%');
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['ord_order_number'])) {
                    $query->where('ord_order_number', 'like', '%' . $search_data['ord_order_number'] . '%');
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['orcl_channel_unit'])) {
                    $query->where('orcl_channel_unit', 'like', '%' . $search_data['orcl_channel_unit'] . '%');
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['orcl_name'])) {
                    $query->where('orcl_name', 'like', '%' . $search_data['orcl_name'] . '%');
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['orcl_phone'])) {
                    $query->where('orcl_phone', 'like', '%' . $search_data['orcl_phone'] . '%');
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['orcl_car_num'])) {
                    $query->where('orcl_car_num', 'like', '%' . $search_data['orcl_car_num'] . '%');
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['ord_type'])) {
                    $query->where('ord_type', $search_data['ord_type']);
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['ord_service_type'])) {
                    $query->where('ord_service_type', $search_data['ord_service_type']);
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['ord_create_id'])) {
                    $query->where('a.ord_create_id', $search_data['ord_create_id']);
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['ord_state'])) {
                    $query->where('ord_state', $search_data['ord_state']);
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['ord_wor_state'])) {
                    $query->where('ord_wor_state', $search_data['ord_wor_state']);
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['ord_payment_way'])) {
                    $query->where('ord_payment_way', $search_data['ord_payment_way']);
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['ord_remark'])) {
                    $query->where('ord_remark', 'like', '%' . $search_data['ord_remark'] . '%');
                }
            }) //备注
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['ord_orla_id'])) {
                    $query->where('ord_orla_id', $search_data['ord_orla_id']);
                }
            }) //订单标签
            ->where(function ($query) use ($search_data) {
                //如果选择开始时间并且选择结束时间
                if (!empty($search_data['create_time_start']) && !empty($search_data['create_time_end'])) {
                    $query->whereBetween('ord_create_time', [$search_data['create_time_start'], $search_data['create_time_end'] . ' 23:59:59']);
                } else {
                    // 如果选择开始时间
                    if (!empty($search_data['create_time_start'])) {
                        $query->where('ord_create_time', '>=', $search_data['create_time_start']);
                    } else {
                        // 如果选择结束时间
                        if (!empty($search_data['create_time_end'])) {
                            $query->where('ord_create_time', '<=', $search_data['create_time_end'] . ' 23:59:59');
                        }
                    }
                }
            }) //创建时间
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['orcl_order_type'])) {
                    $query->where('orcl_order_type', $search_data['orcl_order_type']);
                }
            })
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['orcl_order_type'])) {
                    $query->where('orcl_order_type', $search_data['orcl_order_type']);
                }
            })
            ->select('ord_order_number', 'adm_name', 'orgo_goo_name', 'orgo_goo_goods_encode', 'orgo_goo_price', 'ord_goods_quantity', 'ord_actual_price', 'ord_payment_way', 'ord_state', 'ord_wor_state', 'ord_wor_quantity', 'ord_type', 'ord_service_type', 'orcl_channel_unit', 'orcl_name', 'orcl_phone', 'orcl_car_num', 'orcl_address', 'ord_remark', 'ord_create_time', 'ord_order_price')
            ->orderBy('ord_id', 'desc')
            ->get()->toArray();
        if (!empty($data)) {
            // 将对象转化为数组
            $data = json_decode(json_encode($data), true);
            foreach ($data as $key => $value) {
                $data[$key]['orgo_goo_price'] = $value['orgo_goo_price'] / 100;
                $data[$key]['ord_actual_price'] = $value['ord_actual_price'] / 100;
                $data[$key]['ord_order_price'] = $value['ord_order_price'] / 100;
                // 结算方式
                if ($value['ord_payment_way'] == 1) {
                    $data[$key]['ord_payment_way'] = '账期';
                }
                if ($value['ord_payment_way'] == 2) {
                    $data[$key]['ord_payment_way'] = '现结';
                }
                if ($value['ord_payment_way'] == 3) {
                    $data[$key]['ord_payment_way'] = '微信';
                }
                if ($value['ord_payment_way'] == 4) {
                    $data[$key]['ord_payment_way'] = '支付宝';
                }
                // 结算状态
                if ($value['ord_state'] == '1') {
                    $data[$key]['ord_state'] = '未结算';
                }
                if ($value['ord_state'] == '2') {
                    $data[$key]['ord_state'] = '已结算';
                }
                if ($value['ord_state'] == '3') {
                    $data[$key]['ord_state'] = '已核销';
                }
                if ($value['ord_state'] == '4') {
                    $data[$key]['ord_state'] = '已还款';
                }
                // 订单的工单状态
                if ($value['ord_wor_state'] == '1') {
                    $data[$key]['ord_wor_state'] = '未派工单';
                }
                if ($value['ord_wor_state'] == '2') {
                    $data[$key]['ord_wor_state'] = '服务中';
                }
                if ($value['ord_wor_state'] == '3') {
                    $data[$key]['ord_wor_state'] = '售后中';
                }
                if ($value['ord_wor_state'] == '4') {
                    $data[$key]['ord_wor_state'] = '已完成';
                }
                if ($value['ord_wor_state'] == '5') {
                    $data[$key]['ord_wor_state'] = '无工单';
                }
                if ($value['ord_wor_state'] == '6') {
                    $data[$key]['ord_wor_state'] = '审核活动';
                }
                if ($value['ord_wor_state'] == '7') {
                    $data[$key]['ord_wor_state'] = '待接单';
                }
                if ($value['ord_wor_state'] == '8') {
                    $data[$key]['ord_wor_state'] = '锁定';
                }
                if ($value['ord_wor_state'] == '9') {
                    $data[$key]['ord_wor_state'] = '撤销';
                }
                // 订单类型
                if ($value['ord_type'] == '1') {
                    $data[$key]['ord_type'] = '门店零售';
                }
                if ($value['ord_type'] == '2') {
                    $data[$key]['ord_type'] = '客户单位';
                }
                if ($value['ord_type'] == '3') {
                    $data[$key]['ord_type'] = '速电派单';
                }
                // 服务类型
                if ($value['ord_service_type'] == '1') {
                    $data[$key]['ord_service_type'] = '服务单';
                }
                if ($value['ord_service_type'] == '2') {
                    $data[$key]['ord_service_type'] = '销售单';
                }
                if ($value['ord_service_type'] == '3') {
                    $data[$key]['ord_service_type'] = '换货单';
                }
                if ($value['ord_service_type'] == '4') {
                    $data[$key]['ord_service_type'] = '退货单';
                }
                if ($value['ord_service_type'] == '5') {
                    $data[$key]['ord_service_type'] = '发货单';
                }
                if ($value['ord_service_type'] == '6') {
                    $data[$key]['ord_service_type'] = '结清单';
                }
                if ($value['ord_service_type'] == '7') {
                    $data[$key]['ord_service_type'] = '救援单';
                }
                //商品编号
                $data[$key]['orgo_goo_goods_encode'] = "\t" . empty($value['orgo_goo_goods_encode']) ? '' : $value['orgo_goo_goods_encode'];
                $data[$key]['orgo_goo_name'] = empty($value['orgo_goo_name']) ? '' : $value['orgo_goo_name'];
                $data[$key]['adm_name'] = empty($value['adm_name']) ? '' : $value['adm_name'];
            }
        } else {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'没有符合条件的数据']);
        }
        $pathName = storage_path() . "/app/public/excel"; //获取上传excel路径
        // 创建文件夹
        if (!file_exists($pathName)) {
            mkdir($pathName, 0775, true);
            chmod($pathName, 0775);
        }

        $streamFileRand = time() . rand(10000, 99999) . '.xls'; //
        // 产生一个随机文件名（因为你base64上来肯定没有文件名，这里你可以自己设置一个也行）
        $streamFilename = $pathName . '/' . $streamFileRand;

        $where['action_name'] = '出入库记录'; //
        $where['field_name'] = ['单号', '原始单号', '商品名称', '商品编号', '数量', '类型', '仓库类别']; //
        // 调用导出的公共方法
        export::publicExport(
            $streamFilename, //路径
            $where,    //sheet名及其每一行的标题
            $data      //导出数据
        );

        // 判断文件是否存在 存在则成功  不存在则失败
        if (file_exists($streamFilename)) {
            return response()->json(['code'=>200, 'msg'=>'success', 'data'=>'storage/excel/' . $streamFileRand]);
        } else {
            return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'导出失败']);
        }
    }

    // 厦门门店导入临时仓待检测商品数据
    public function lscGoods($submit_data, $data)
    {
        echo 99900;
        DB::beginTransaction();
        $cid = 1; //公司id
        $superior_shop_id = 1; //总店id
        $shop_id = 1; //门店id
        $goods_data = [];
        $defeated = [];
        // $dates = date('Y-m-d H:i:s');
        $dates = $this->now_time;

        $ware_id = 11; //仓库id

        foreach ($data as $key => $value) {
            // dump($value);exit;
            $info['goo_goods_encode'] = $value['goo_goods_encode'];
            // 根据检索编码查询商品id
            $find_goo_id = DB::table('goods')
                ->where('goo_cid', $cid)
                ->where('goo_shop_id', $shop_id)
                ->where('goo_superior_shop_id', $superior_shop_id)
                ->where('goo_delete', 1)
                ->where('goo_goods_encode', $value['goo_goods_encode'])
                ->select('goo_id', 'goo_purchase_price', 'goo_goods_encode')
                ->first();
            // dump($find_goo_id);
            if (!empty($find_goo_id->goo_id)) {
                $goo_id = $find_goo_id->goo_id;
            } else {
                dump($value['goo_goods_encode']);
            }

            // 添加商品库存，查询仓库id
            if (empty($ware_id)) {
            } else {
                $value['lscdjc'] = $value['lscdjc'] ? $value['lscdjc'] : 0; //库存数量
                $stock_numbers = $value['lscdjc']; //临时仓库存

                $res = DB::table('warehouse_onhand')
                    ->where('waon_ware_id', $ware_id)
                    ->where('waon_class', 4)
                    ->increment('waon_all_amount', $stock_numbers);
                $res = DB::table('warehouse_onhand')
                    ->where('waon_ware_id', $ware_id)
                    ->where('waon_class', 4)
                    ->increment('waon_stock_unchecked_amount', $stock_numbers);
                if (empty($res)) {
                    $value['yuanyin'] = '仓库库存添加失败';
                    array_push($defeated, $value);
                    continue;
                }
                $wago_id = DB::table('warehouse_goods')
                    ->where('wago_ware_id', $ware_id)
                    ->where('wago_goo_id', $goo_id)
                    ->where('wago_class', 4)
                    ->value('wago_id');

                if (empty($wago_id)) {
                    // 仓库内没有商品，添加商品
                    $warehouse_goods['wago_ware_id'] = $ware_id; //仓库
                    $warehouse_goods['wago_class'] = 4;
                    $warehouse_goods['wago_goo_id'] = $goo_id; //商品
                    $warehouse_goods['wago_unchecked_stock_number'] = $stock_numbers; //良品库存
                    $warehouse_goods['wago_update_time'] = $dates; //更新时间
                    $wago_res = DB::table('warehouse_goods')->insert($warehouse_goods);
                    if (empty($wago_res)) {
                        $value['yuanyin'] = '添加仓库商品失败';
                        array_push($defeated, $value);
                        continue;
                    }
                    unset($warehouse_goods);
                } else {
                    // 仓库内已经有商品了，更改库存数量
                    $edit_data['wago_unchecked_stock_number'] = $stock_numbers;
                    $edit_data['wago_update_time'] = $dates;
                    $res = DB::table('warehouse_goods')
                        ->where('wago_ware_id', $ware_id)
                        ->where('wago_goo_id', $goo_id)
                        ->where('wago_class', 4)
                        ->update($edit_data);
                    dump($res);
                    if (empty($res)) {
                        $value['yuanyin'] = '修改仓库商品失败库存失败';
                        array_push($defeated, $value);
                        continue;
                    }
                }
            }
            unset($goo_id);
            unset($find_goo_id);
            unset($find_dibi_data);
            unset($info);
        }
        echo 333;
        dump($defeated);
        DB::commit();
    }

    // 厦门门店导入非货物仓商品数据
    public function nonCommercialWarehouse()
    {
        echo 99900;
        DB::beginTransaction();
        $cid = 1; //公司id
        $superior_shop_id = 1; //总店id
        $shop_id = 1; //门店id
        $goods_data = [];
        $defeated = [];
        $dates = date('Y-m-d H:i:s');

        $ware_id = 14; //仓库id
        $goo_type = 4;
        $waon_class = 3;

        // 查询该门店赠品商品数据
        $find_goods = DB::table('goods')
            ->where('goo_cid', $cid)
            ->where('goo_shop_id', $shop_id)
            ->where('goo_superior_shop_id', $superior_shop_id)
            ->where('goo_type', $goo_type)
            ->where('goo_delete', 1)
            ->where('goo_class', 1)
            ->select('goo_id')
            ->get()->toArray();
        // dump($find_goods);die;
        foreach ($find_goods as $key => $value) {
            dump($value);

            // 添加商品库存，查询仓库id
            if (empty($ware_id)) {
            } else {
                $wago_id = DB::table('warehouse_goods')
                    ->where('wago_ware_id', $ware_id)
                    ->where('wago_goo_id', $value->goo_id)
                    ->where('wago_class', $waon_class)
                    ->value('wago_id');
                dump($wago_id);
                if (empty($wago_id)) {
                    // 仓库内没有商品，添加商品
                    $warehouse_goods['wago_ware_id'] = $ware_id; //仓库
                    $warehouse_goods['wago_class'] = $waon_class;
                    $warehouse_goods['wago_goo_id'] = $value->goo_id; //商品
                    $warehouse_goods['wago_update_time'] = $dates; //更新时间
                    $wago_res = DB::table('warehouse_goods')->insert($warehouse_goods);
                    if (empty($wago_res)) {
                        $value['yuanyin'] = '添加仓库商品失败';
                        array_push($defeated, $value);
                        continue;
                    }
                    unset($warehouse_goods);
                }
            }
            unset($goo_id);
            unset($goo_id_arr);
            unset($purchase_goo_actual_count);
            unset($purchase_goo_actual_price);
            unset($purchase_return);
            unset($find_goo_id);
            unset($find_dibi_data);
            unset($info);
        }
        echo 333;
        dump($defeated);
        DB::commit();
    }

    // 厦门门店导入货物仓商品数据
    public function importGoodsNew($submit_data, $data)
    {
        echo 99900;
        DB::beginTransaction();
        $cid = 1; //公司id
        $superior_shop_id = 1; //总店id
        $shop_id = 1; //门店id
        $goods_data = [];
        $defeated = [];
        $dates = date('Y-m-d H:i:s');

        // $user_info = Common::getUserInfo($submit_data['api_token']);
        // dump($user_info);die;
        $ware_id = 9; //仓库id
        $goo_type = 2;
        $waon_class = 2;
        foreach ($data as $key => $value) {
            // dump($value);
            // exit;
            $info['goo_goods_encode'] = $value['goo_goods_encode'];
            // 根据检索编码查询商品id
            $find_goo_id = DB::table('goods')
                ->where('goo_cid', $cid)
                ->where('goo_shop_id', $shop_id)
                ->where('goo_superior_shop_id', $superior_shop_id)
                ->where('goo_type', $goo_type)
                ->where('goo_delete', 1)
                ->where('goo_goods_encode', $value['goo_goods_encode'])
                ->select('goo_id', 'goo_purchase_price', 'goo_goods_encode')
                ->first();
            // dump($find_goo_id);
            if (!empty($find_goo_id->goo_id)) {
                $goo_id = $find_goo_id->goo_id;
            } else {
                dump($value['goo_goods_encode']);
            }

            // 添加商品库存，查询仓库id

            $wago_id = DB::table('warehouse_goods')
                ->where('wago_ware_id', $ware_id)
                ->where('wago_goo_id', $goo_id)
                ->where('wago_class', $waon_class)
                ->value('wago_id');

            if (empty($wago_id)) {
                // 仓库内没有商品，添加商品
                $warehouse_goods['wago_ware_id'] = $ware_id; //仓库
                $warehouse_goods['wago_class'] = $waon_class;
                $warehouse_goods['wago_goo_id'] = $goo_id; //商品
                $warehouse_goods['wago_update_time'] = $dates; //更新时间
                $wago_res = DB::table('warehouse_goods')->insert($warehouse_goods);
                if (empty($wago_res)) {
                    $value['yuanyin'] = '添加仓库商品失败';
                    array_push($defeated, $value);
                    continue;
                }
                unset($warehouse_goods);
            } else {
                // 仓库内已经有商品了，更改库存数量
                $edit_data['wago_stock_number'] = 0;
                $edit_data['wago_update_time'] = $dates;
                $res = DB::table('warehouse_goods')
                    ->where('wago_ware_id', $ware_id)
                    ->where('wago_goo_id', $goo_id)
                    ->where('wago_class', $waon_class)
                    ->update($edit_data);
                dump($res);
                if (empty($res)) {
                    $value['yuanyin'] = '修改仓库商品失败库存失败';
                    array_push($defeated, $value);
                    continue;
                }
            }

            unset($goo_id);
            unset($goo_id_arr);
            unset($purchase_return);
            unset($find_goo_id);
            unset($find_dibi_data);
            unset($info);
        }
        echo 333;
        dump($defeated);
        DB::commit();
    }

    // 厦门门店导入移动仓商品数据
    public function appImportGoods($submit_data, $data)
    {
        // echo 99900;die;
        DB::beginTransaction();
        $cid = 1; //公司id
        $superior_shop_id = 1; //总店id
        $shop_id = 1; //门店id
        $goods_data = [];
        $defeated = [];
        // $dates = date('Y-m-d H:i:s');
        $dates = $this->now_time;
        try {
            $api_token = Crypt::decrypt($submit_data['api_token']);
        } catch (\Exception $e) {
            return response()->json(["code"=>300, 'msg'=>'error', 'data'=>'非法api_token']);
        }

        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($api_token);

        // $user_info = Common::getUserInfo($submit_data['api_token']);

        $ware_id = 40; //仓库id
        // 查询出入库记录表出库数据
        $find_out_oure_data = DB::table('outin_record')
            ->where('oure_cid', $cid)
            ->where('oure_shop_id', $shop_id)
            ->where('oure_out_ware_id', $ware_id)
            ->where('oure_waon_class', 1)
            ->where('oure_out_in_type', 1)
            // ->where('oure_create_time', '>', '2020-09-11 08:30:00')
            ->get()->toArray();
        $out_oure_id = array_column($find_out_oure_data, 'oure_id');
        // 查询出入库记录详情表
        $find_out_oude_goo_id = DB::table('outin_details')
            ->whereIn('oude_oure_id', $out_oure_id)
            ->where('oude_type', 1)
            ->get()->toArray();
        $out_subtract = [];
        foreach ($find_out_oude_goo_id as $kk => $vv) {
            if (!isset($out_subtract[$vv->oude_goo_id])) {
                $out_subtract[$vv->oude_goo_id] = 0;
            }
            $out_subtract[$vv->oude_goo_id] += $vv->oude_goo_number; //商品数量
        }
        // 查询出入库记录表入库数据
        $find_in_oure_data = DB::table('outin_record')
            ->where('oure_cid', $cid)
            ->where('oure_shop_id', $shop_id)
            ->where('oure_out_ware_id', $ware_id)
            ->where('oure_waon_class', 1)
            ->where('oure_out_in_type', 2)
            // ->where('oure_create_time', '>', '2020-09-11 08:30:00')
            ->get()->toArray();
        $in_oure_id = array_column($find_in_oure_data, 'oure_id');
        // 查询出入库记录详情表
        $find_in_oude_goo_id = DB::table('outin_details')
            ->whereIn('oude_oure_id', $in_oure_id)
            ->where('oude_type', 1)
            ->get()->toArray();
        $in_subtract = [];
        foreach ($find_in_oude_goo_id as $kk => $vv) {
            if (!isset($in_subtract[$vv->oude_goo_id])) {
                $in_subtract[$vv->oude_goo_id] = 0;
            }
            $in_subtract[$vv->oude_goo_id] += $vv->oude_goo_number; //商品数量
        }
        dump($out_subtract);
        dump($in_subtract);
        foreach ($data as $key => $value) {
            // dump($value);exit;
            $info['goo_goods_encode'] = $value['goo_goods_encode'];
            // 根据检索编码查询商品id
            $find_goo_id = DB::table('goods')
                ->where('goo_cid', $cid)
                ->where('goo_shop_id', $shop_id)
                ->where('goo_superior_shop_id', $superior_shop_id)
                ->where('goo_type', 1)
                ->where('goo_delete', 1)
                ->where('goo_goods_encode', $value['goo_goods_encode'])
                ->select('goo_id', 'goo_name', 'goo_purchase_price', 'goo_goods_encode')
                ->first();
            // dump($find_goo_id);
            if (!empty($find_goo_id->goo_id)) {
                $goo_id = $find_goo_id->goo_id;
            } else {
                dump($value['goo_goods_encode']);
            }

            // 添加商品库存，查询仓库id
            if (empty($ware_id)) {
            } else {
                $value['huowucang'] = $value['huowucang'] ? $value['huowucang'] : 0; //库存数量
                //判断仓库里是否有此商品
                if (isset($out_subtract[$goo_id])) {
                    $out_subtract_sum = $out_subtract[$goo_id];
                } else {
                    $out_subtract_sum = 0;
                }
                //判断仓库里是否有此商品
                if (isset($in_subtract[$goo_id])) {
                    $in_subject_sum = $in_subtract[$goo_id];
                } else {
                    $in_subject_sum = 0;
                }
                $stock_numbers = $value['huowucang'] + $in_subject_sum - $out_subtract_sum; //良品库存 + 入库数量 - 出库数量
                $out_in_stock_data[$key]['in_subject_sum'] = $in_subject_sum;
                $out_in_stock_data[$key]['out_subtract_sum'] = $out_subtract_sum;
                $out_in_stock_data[$key]['huowucang'] = $value['huowucang'];
                $out_in_stock_data[$key]['stock_numbers'] = $stock_numbers;
                $out_in_stock_data[$key]['goo_name'] = $find_goo_id->goo_name;
                continue;
                if ($stock_numbers < 0) {
                    $stock_numbers = 0;
                }
                $find_waon_data = DB::table('warehouse_onhand')
                    ->where('waon_ware_id', $ware_id)
                    ->where('waon_class', 1)
                    ->first();
                $waon_edit['waon_all_amount'] = $find_waon_data->waon_all_amount + $stock_numbers;
                $waon_edit['waon_stock_fine_amount'] = $find_waon_data->waon_stock_fine_amount + $stock_numbers;
                $waon_edit['waon_update_time'] = $dates;
                $res = DB::table('warehouse_onhand')
                    ->where('waon_ware_id', $ware_id)
                    ->where('waon_class', 1)
                    ->update($waon_edit);
                if (empty($res)) {
                    $value['yuanyin'] = '仓库库存添加失败';
                    array_push($defeated, $value);
                    continue;
                }
                $wago_id = DB::table('warehouse_goods')
                    ->where('wago_ware_id', $ware_id)
                    ->where('wago_goo_id', $goo_id)
                    ->where('wago_class', 1)
                    ->value('wago_id');

                if (empty($wago_id)) {
                    // 仓库内没有商品，添加商品
                    $warehouse_goods['wago_ware_id'] = $ware_id; //仓库
                    $warehouse_goods['wago_class'] = 1;
                    $warehouse_goods['wago_goo_id'] = $goo_id; //商品
                    $warehouse_goods['wago_stock_number'] = $stock_numbers; //良品库存
                    $warehouse_goods['wago_update_time'] = $dates; //更新时间
                    $wago_res = DB::table('warehouse_goods')->insert($warehouse_goods);
                    if (empty($wago_res)) {
                        $value['yuanyin'] = '添加仓库商品失败';
                        array_push($defeated, $value);
                        continue;
                    }
                    unset($warehouse_goods);
                } else {
                    // 仓库内已经有商品了，更改库存数量
                    $edit_data['wago_stock_number'] = $stock_numbers;
                    $edit_data['wago_update_time'] = $dates;
                    $res = DB::table('warehouse_goods')
                        ->where('wago_ware_id', $ware_id)
                        ->where('wago_goo_id', $goo_id)
                        ->where('wago_class', 1)
                        ->update($edit_data);
                    dump($res);
                    if (empty($res)) {
                        $value['yuanyin'] = '修改仓库商品失败库存失败';
                        array_push($defeated, $value);
                        continue;
                    }
                }
            }
            unset($goo_id);
            unset($find_goo_id);
            unset($find_dibi_data);
            unset($info);
        }
        echo 333;
        // dump($defeated);
        dump($out_in_stock_data);
        DB::commit();
    }

    // 厦门加盟店导入商品数据
    public function importProducts($submit_data, $data)
    {
        echo 99900;
        DB::beginTransaction();
        $cid = 1; //公司id
        $superior_shop_id = 35; //总店id
        $shop_id = 35; //门店id
        $goods_data = [];
        $defeated = [];
        // $dates = date('Y-m-d H:i:s');
        $dates = $this->now_time;
        // try {
        //     $api_token = Crypt::decrypt($submit_data['api_token']);
        // } catch (\Exception $e) {
        //     return response()->json(["code"=>300,'msg'=>'error','data'=>'非法api_token']);
        // }

        // 获取当前操作账号信息
        // $user_info = Common::getUserInfo($api_token);
        // $user_info = Common::getUserInfo($submit_data['api_token']);
        foreach ($data as $key => $value) {
            // dump($value);
            // die;
            // 品牌
            $bra_id = DB::table('brand')
                ->where('bra_cid', $cid)
                ->where('bra_shop_id', $shop_id)
                ->where('bra_superior_shop_id', $superior_shop_id)
                ->where('bra_delete', 1)
                ->where('bra_name', $value['goo_bra_name'])
                ->value('bra_id');
            if (empty($bra_id)) {
                $bra_data['bra_cid'] = $cid;
                $bra_data['bra_shop_id'] = $shop_id;
                $bra_data['bra_superior_shop_id'] = $superior_shop_id;
                $bra_data['bra_name'] = $value['goo_bra_name'];
                $bra_data['bra_create_time'] = $dates;
                $bra_data['bra_goods_number'] = 3;
                $bra_data['bra_update_time'] = $dates;
                $bra_id = DB::table('brand')->insertGetId($bra_data);
            } else {
                DB::table('brand')->where('bra_id', $bra_id)->increment('bra_goods_number', 3);
            }
            // 品类
            $cate_id = DB::table('category')
                ->where('cate_cid', $cid)
                ->where('cate_shop_id', $shop_id)
                ->where('cate_superior_shop_id', $superior_shop_id)
                ->where('cate_rank', 1)
                ->where('cate_delete', 1)
                ->where('cate_name', $value['goo_cate_name'])
                ->value('cate_id');
            if (empty($cate_id)) {
                $chty_data['cate_cid'] = $cid;
                $chty_data['cate_shop_id'] = $shop_id;
                $chty_data['cate_superior_shop_id'] = $superior_shop_id;
                $chty_data['cate_name'] = $value['goo_cate_name'];
                $chty_data['cate_create_time'] = $dates;
                $chty_data['cate_goods_number'] = 3;
                $chty_data['cate_rank'] = 1;
                $chty_data['cate_update_time'] = $dates;
                $cate_id = DB::table('category')->insertGetId($chty_data);
            } else {
                DB::table('category')->where('cate_id', $cate_id)->increment('cate_goods_number', 3);
            }
            // 系列
            if ($bra_id) {
                $brse_id = DB::table('brand_serie')
                    ->where('brse_cid', $cid)
                    ->where('brse_shop_id', $shop_id)
                    ->where('brse_superior_shop_id', $superior_shop_id)
                    ->where('brse_bra_id', $bra_id)
                    ->where('brse_name', $value['goo_brse_name'])
                    ->value('brse_id');
                if (empty($brse_id)) {
                    $brse_data['brse_cid'] = $cid;
                    $brse_data['brse_superior_shop_id'] = $superior_shop_id;
                    $brse_data['brse_shop_id'] = $shop_id;
                    $brse_data['brse_bra_id'] = $bra_id;
                    $brse_data['brse_name'] = $value['goo_brse_name'];
                    $brse_data['brse_goods_number'] = 3;
                    $brse_data['brse_class'] = 1; //类型1自营系列2系统系列
                    $brse_data['brse_cate_id'] = $cate_id; //一级品类id
                    $brse_data['brse_update_time'] = $dates;
                    $brse_id = DB::table('brand_serie')->insertGetId($brse_data);
                } else {
                    DB::table('brand_serie')->where('brse_id', $brse_id)->increment('brse_goods_number', 3);
                }
            }

            $info['goo_cid'] = $cid;
            $info['goo_superior_shop_id'] = $superior_shop_id;
            $info['goo_shop_id'] = $shop_id;
            $info['goo_bra_name'] = $value['goo_bra_name']; //品牌名称
            $info['goo_bra_id'] = $bra_id; //品牌id
            $info['goo_brse_id'] = $brse_id; //品牌系列id
            $info['goo_cate_name'] = $value['goo_cate_name'];
            $info['goo_cate_id'] = $cate_id;
            $info['goo_name'] = $value['goo_name'];
            $info['goo_goods_encode'] = $value['goo_goods_encode'];
            $goo_wholesale_price = $value['goo_wholesale_price'] ? $value['goo_wholesale_price'] : 0;
            $goo_price = $value['goo_price'] ? $value['goo_price'] : 0;
            $goo_purchase_price = $value['chengben'] ? round($value['chengben'], 2) : 0;
            $info['goo_price'] = $goo_price * 100;
            $info['goo_wholesale_price'] = $goo_wholesale_price * 100;
            $info['goo_purchase_price'] = $goo_purchase_price * 100;
            $info['goo_update_time'] = $dates;
            $supplier = [];
            if (!empty($value['attr_guige']) && $value['attr_guige'] != 'NULL') {
                $supplier[] = ['key' => '规格', 'value' => $value['attr_guige']];
            }
            if (!empty($value['danwei']) && $value['danwei'] != 'NULL') {
                $supplier[] = ['key' => '单位', 'value' => $value['danwei']];
            }
            if (!empty($supplier)) {
                $info['goo_attribute'] = json_encode($supplier);
            } else {
                $info['goo_attribute'] = '';
            }
            if (!empty($value['goo_name'])) {
                // 判断商品是否存在
                $goo_id = DB::table('goods')
                    ->where('goo_cid', $cid)
                    ->where('goo_shop_id', $shop_id)
                    ->where('goo_superior_shop_id', $superior_shop_id)
                    ->where('goo_type', 1)
                    ->where('goo_delete', 1)
                    ->where('goo_goods_encode', $value['goo_goods_encode'])
                    ->value('goo_id');
                dump($goo_id);
                if (empty($goo_id)) {
                    $info['goo_type'] = 1; //商品类型 1正常商品2赠品商品3活动商品4旧货商品
                    $info['goo_fid'] = 0;
                    $info['goo_system_code'] = str_pad($cid, '4', '0', STR_PAD_RIGHT) . str_pad($shop_id, '5', '0', STR_PAD_RIGHT) . rand(10, 99) . rand(100000000, 999999999); //系统编码
                    $goo_id = DB::table('goods')->insertGetId($info);
                    // 活动商品
                    $acgo_data['acgo_cid'] = $cid;
                    $acgo_data['acgo_superior_shop_id'] = $shop_id;
                    $acgo_data['acgo_shop_id'] = $shop_id;
                    $acgo_data['acgo_goo_id'] = $goo_id;
                    $acgo_data['acgo_update_time'] = date('Y-m-d H:i:s');
                    $acgo_res = DB::table('activity_goods')->insertGetId($acgo_data);
                    // 添加赠品商品
                    $info['goo_type'] = 2; //1正常商品2赠品商品3活动商品4旧货商品
                    $info['goo_fid'] = $goo_id;
                    $info['goo_system_code'] = str_pad($cid, '4', '0', STR_PAD_RIGHT) . str_pad($shop_id, '5', '0', STR_PAD_RIGHT) . rand(10, 99) . rand(100000000, 999999999); //系统编码
                    $goaf_res = DB::table('goods')->insertGetId($info);
                    // 添加旧货商品
                    $info['goo_type'] = 4; //1正常商品2赠品商品3活动商品4旧货商品
                    $info['goo_fid'] = $goo_id;
                    $info['goo_system_code'] = str_pad($cid, '4', '0', STR_PAD_RIGHT) . str_pad($shop_id, '5', '0', STR_PAD_RIGHT) . rand(10, 99) . rand(100000000, 999999999); //系统编码
                    $junk_res = DB::table('goods')->insertGetId($info);
                } else {
                    unset($info);
                    $info['goo_purchase_price'] = $goo_purchase_price * 100;
                    $info['goo_update_time'] = $dates;
                    // 商品数量
                    $num = 1;
                    $info['goo_type'] = 1;   //1正常商品2赠品商品3活动商品4旧货商品
                    $info['goo_update_time'] = $dates;
                    $res = DB::table('goods')
                        ->where('goo_type', 1)
                        ->where('goo_id', $goo_id)
                        ->update($info);
                    // 赠品商品
                    $goaf_goo_id = DB::table('goods')
                        ->where('goo_fid', $goo_id)
                        ->where('goo_type', 2)
                        ->value('goo_id');
                    if (!empty($goaf_goo_id)) {
                        $info['goo_type'] = 2;   //1正常商品2赠品商品3活动商品4旧货商品
                        $goaf_res = DB::table('goods')
                            ->where('goo_id', $goaf_goo_id)
                            ->update($info);
                    } else {
                        $num += 1;
                        $info['goo_type'] = 2; //1正常商品2赠品商品3活动商品4旧货商品
                        $info['goo_fid'] = $goo_id;
                        $info['goo_system_code'] = str_pad($cid, '4', '0', STR_PAD_RIGHT) . str_pad($shop_id, '5', '0', STR_PAD_RIGHT) . rand(10, 99) . rand(100000000, 999999999); //系统编码
                        $goaf_res = DB::table('goods')->insertGetId($info);
                    }
                    // 旧货商品
                    $junk_goo_id = DB::table('goods')
                        ->where('goo_fid', $goo_id)
                        ->where('goo_type', 4)
                        ->value('goo_id');
                    if (!empty($junk_goo_id)) {
                        $info['goo_type'] = 4;   //1正常商品2赠品商品3活动商品4旧货商品
                        $junk_res = DB::table('goods')
                            ->where('goo_id', $junk_goo_id)
                            ->update($info);
                    } else {
                        $num += 1;
                        $info['goo_type'] = 4; //1正常商品2赠品商品3活动商品4旧货商品
                        $info['goo_fid'] = $goo_id;
                        $info['goo_system_code'] = str_pad($cid, '4', '0', STR_PAD_RIGHT) . str_pad($shop_id, '5', '0', STR_PAD_RIGHT) . rand(10, 99) . rand(100000000, 999999999); //系统编码
                        $junk_res = DB::table('goods')->insertGetId($info);
                    }
                    $acgo_res = true;
                }

                unset($goo_id);
                unset($acgo_res);
                unset($goaf_res);
                unset($junk_res);
                unset($goo_id_arr);
                unset($purchase_goo_actual_count);
                unset($purchase_goo_actual_price);
                unset($ware_id);
                unset($purchase_return);
            }
            unset($bra_data);
            unset($bra_id);
            unset($chty_data);
            unset($cate_id);
            unset($info);
            unset($supplier);
        }
        echo 333;
        dump($defeated);
        DB::commit();
    }

    // 厦门加盟店导入商品数据
    public function importProduct($submit_data, $data)
    {
        echo 99900;
        DB::beginTransaction();
        $cid = 1; //公司id
        $superior_shop_id = 41; //总店id
        $shop_id = 41; //门店id
        $goods_data = [];
        $defeated = [];
        // $dates = date('Y-m-d H:i:s');
        // $dates = '2020-09-12 22:40:36';
        $dates = $this->now_time;
        // try {
        //     $api_token = Crypt::decrypt($submit_data['api_token']);
        // } catch (\Exception $e) {
        //     return response()->json(["code"=>300,'msg'=>'error','data'=>'非法api_token']);
        // }

        // 获取当前操作账号信息
        // $user_info = Common::getUserInfo($api_token);
        // $user_info = Common::getUserInfo($submit_data['api_token']);
        foreach ($data as $key => $value) {
            // dump($value);
            // die;
            // 品牌
            $bra_id = DB::table('brand')
                ->where('bra_cid', $cid)
                ->where('bra_shop_id', $shop_id)
                ->where('bra_superior_shop_id', $superior_shop_id)
                ->where('bra_delete', 1)
                ->where('bra_name', $value['goo_bra_name'])
                ->value('bra_id');
            if (empty($bra_id)) {
                $bra_data['bra_cid'] = $cid;
                $bra_data['bra_shop_id'] = $shop_id;
                $bra_data['bra_superior_shop_id'] = $superior_shop_id;
                $bra_data['bra_name'] = $value['goo_bra_name'];
                $bra_data['bra_create_time'] = $dates;
                $bra_data['bra_goods_number'] = 3;
                $bra_data['bra_update_time'] = $dates;
                $bra_id = DB::table('brand')->insertGetId($bra_data);
            } else {
                DB::table('brand')->where('bra_id', $bra_id)->increment('bra_goods_number', 3);
            }
            // 品类
            $cate_id = DB::table('category')
                ->where('cate_cid', $cid)
                ->where('cate_shop_id', $shop_id)
                ->where('cate_superior_shop_id', $superior_shop_id)
                ->where('cate_rank', 1)
                ->where('cate_delete', 1)
                ->where('cate_name', $value['goo_cate_name'])
                ->value('cate_id');
            if (empty($cate_id)) {
                $chty_data['cate_cid'] = $cid;
                $chty_data['cate_shop_id'] = $shop_id;
                $chty_data['cate_superior_shop_id'] = $superior_shop_id;
                $chty_data['cate_name'] = $value['goo_cate_name'];
                $chty_data['cate_create_time'] = $dates;
                $chty_data['cate_goods_number'] = 3;
                $chty_data['cate_rank'] = 1;
                $chty_data['cate_update_time'] = $dates;
                $cate_id = DB::table('category')->insertGetId($chty_data);
            } else {
                DB::table('category')->where('cate_id', $cate_id)->increment('cate_goods_number', 3);
            }
            // 系列
            if ($bra_id) {
                $brse_id = DB::table('brand_serie')
                    ->where('brse_cid', $cid)
                    ->where('brse_shop_id', $shop_id)
                    ->where('brse_superior_shop_id', $superior_shop_id)
                    ->where('brse_bra_id', $bra_id)
                    ->where('brse_name', $value['goo_brse_name'])
                    ->value('brse_id');
                if (empty($brse_id)) {
                    $brse_data['brse_cid'] = $cid;
                    $brse_data['brse_superior_shop_id'] = $superior_shop_id;
                    $brse_data['brse_shop_id'] = $shop_id;
                    $brse_data['brse_bra_id'] = $bra_id;
                    $brse_data['brse_name'] = $value['goo_brse_name'];
                    $brse_data['brse_goods_number'] = 3;
                    $brse_data['brse_class'] = 1; //类型1自营系列2系统系列
                    $brse_data['brse_cate_id'] = $cate_id; //一级品类id
                    $brse_data['brse_update_time'] = $dates;
                    $brse_id = DB::table('brand_serie')->insertGetId($brse_data);
                } else {
                    DB::table('brand_serie')->where('brse_id', $brse_id)->increment('brse_goods_number', 3);
                }
            }

            $info['goo_cid'] = $cid;
            $info['goo_superior_shop_id'] = $superior_shop_id;
            $info['goo_shop_id'] = $shop_id;
            $info['goo_bra_name'] = $value['goo_bra_name']; //品牌名称
            $info['goo_bra_id'] = $bra_id; //品牌id
            $info['goo_brse_id'] = $brse_id; //品牌系列id
            $info['goo_cate_name'] = $value['goo_cate_name'];
            $info['goo_cate_id'] = $cate_id;
            $info['goo_name'] = $value['goo_name'];
            $info['goo_goods_encode'] = $value['goo_goods_encode'];
            $info['goo_ampere_hour'] = $value['goo_ampere_hour'];
            $goo_wholesale_price = $value['goo_wholesale_price'] ? $value['goo_wholesale_price'] : 0;
            $goo_price = $value['goo_price'] ? $value['goo_price'] : 0;
            $goo_purchase_price = $value['chengben'] ? round($value['chengben'], 2) : 0;
            $info['goo_price'] = $goo_price * 100;
            $info['goo_wholesale_price'] = $goo_wholesale_price * 100;
            $info['goo_purchase_price'] = $goo_purchase_price * 100;
            $info['goo_assign_state'] = 2;
            $info['goo_update_time'] = $dates;
            $supplier = [];
            if (!empty($value['attr_guige']) && $value['attr_guige'] != 'NULL') {
                $supplier[] = ['key' => '规格', 'value' => $value['attr_guige']];
            }
            if (!empty($value['danwei']) && $value['danwei'] != 'NULL') {
                $supplier[] = ['key' => '单位', 'value' => $value['danwei']];
            }
            if (!empty($supplier)) {
                $info['goo_attribute'] = json_encode($supplier);
            } else {
                $info['goo_attribute'] = '';
            }
            if (!empty($value['goo_name'])) {
                // 判断商品是否存在
                $goo_id = DB::table('goods')
                    ->where('goo_cid', $cid)
                    ->where('goo_shop_id', $shop_id)
                    ->where('goo_superior_shop_id', $superior_shop_id)
                    ->where('goo_type', 1)
                    ->where('goo_delete', 1)
                    ->where('goo_goods_encode', $value['goo_goods_encode'])
                    ->value('goo_id');
                dump($goo_id);
                if (empty($goo_id)) {
                    $info['goo_type'] = 1; //商品类型 1正常商品2赠品商品3活动商品4旧货商品
                    $info['goo_fid'] = 0;
                    $info['goo_system_code'] = str_pad($cid, '4', '0', STR_PAD_RIGHT) . str_pad($shop_id, '5', '0', STR_PAD_RIGHT) . rand(10, 99) . rand(100000000, 999999999); //系统编码
                    $goo_id = DB::table('goods')->insertGetId($info);
                    // 活动商品
                    $acgo_data['acgo_cid'] = $cid;
                    $acgo_data['acgo_superior_shop_id'] = $shop_id;
                    $acgo_data['acgo_shop_id'] = $shop_id;
                    $acgo_data['acgo_goo_id'] = $goo_id;
                    $acgo_data['acgo_update_time'] = date('Y-m-d H:i:s');
                    $acgo_res = DB::table('activity_goods')->insertGetId($acgo_data);
                    // 添加赠品商品
                    $info['goo_type'] = 2; //1正常商品2赠品商品3活动商品4旧货商品
                    $info['goo_fid'] = $goo_id;
                    $info['goo_system_code'] = str_pad($cid, '4', '0', STR_PAD_RIGHT) . str_pad($shop_id, '5', '0', STR_PAD_RIGHT) . rand(10, 99) . rand(100000000, 999999999); //系统编码
                    $goaf_res = DB::table('goods')->insertGetId($info);
                    // 添加旧货商品
                    $info['goo_type'] = 4; //1正常商品2赠品商品3活动商品4旧货商品
                    $info['goo_fid'] = $goo_id;
                    $info['goo_system_code'] = str_pad($cid, '4', '0', STR_PAD_RIGHT) . str_pad($shop_id, '5', '0', STR_PAD_RIGHT) . rand(10, 99) . rand(100000000, 999999999); //系统编码
                    $junk_res = DB::table('goods')->insertGetId($info);
                } else {
                    unset($info);
                    $info['goo_purchase_price'] = $goo_purchase_price * 100;
                    $info['goo_assign_state'] = 2;
                    $info['goo_update_time'] = $dates;
                    // 商品数量
                    $num = 1;
                    $info['goo_type'] = 1;   //1正常商品2赠品商品3活动商品4旧货商品
                    $info['goo_update_time'] = $dates;
                    $res = DB::table('goods')
                        ->where('goo_type', 1)
                        ->where('goo_id', $goo_id)
                        ->update($info);
                    // 赠品商品
                    $goaf_goo_id = DB::table('goods')
                        ->where('goo_fid', $goo_id)
                        ->where('goo_type', 2)
                        ->value('goo_id');
                    if (!empty($goaf_goo_id)) {
                        $info['goo_type'] = 2;   //1正常商品2赠品商品3活动商品4旧货商品
                        $goaf_res = DB::table('goods')
                            ->where('goo_id', $goaf_goo_id)
                            ->update($info);
                    } else {
                        $num += 1;
                        $info['goo_type'] = 2; //1正常商品2赠品商品3活动商品4旧货商品
                        $info['goo_fid'] = $goo_id;
                        $info['goo_system_code'] = str_pad($cid, '4', '0', STR_PAD_RIGHT) . str_pad($shop_id, '5', '0', STR_PAD_RIGHT) . rand(10, 99) . rand(100000000, 999999999); //系统编码
                        $goaf_res = DB::table('goods')->insertGetId($info);
                    }
                    // 旧货商品
                    $junk_goo_id = DB::table('goods')
                        ->where('goo_fid', $goo_id)
                        ->where('goo_type', 4)
                        ->value('goo_id');
                    if (!empty($junk_goo_id)) {
                        $info['goo_type'] = 4;   //1正常商品2赠品商品3活动商品4旧货商品
                        $junk_res = DB::table('goods')
                            ->where('goo_id', $junk_goo_id)
                            ->update($info);
                    } else {
                        $num += 1;
                        $info['goo_type'] = 4; //1正常商品2赠品商品3活动商品4旧货商品
                        $info['goo_fid'] = $goo_id;
                        $info['goo_system_code'] = str_pad($cid, '4', '0', STR_PAD_RIGHT) . str_pad($shop_id, '5', '0', STR_PAD_RIGHT) . rand(10, 99) . rand(100000000, 999999999); //系统编码
                        $junk_res = DB::table('goods')->insertGetId($info);
                    }
                    $acgo_res = true;
                }
                ob_flush();
                flush();
                unset($goo_id);
                unset($acgo_res);
                unset($goaf_res);
                unset($junk_res);
                unset($goo_id_arr);
                unset($purchase_goo_actual_count);
                unset($purchase_goo_actual_price);
                unset($ware_id);
                unset($purchase_return);
            }
            unset($bra_data);
            unset($bra_id);
            unset($chty_data);
            unset($cate_id);
            unset($info);
            unset($supplier);
        }
        echo 333;
        dump($defeated);
        DB::commit();
    }

    // 厦门门店导入货物仓商品数据
    public function newImportGoods($submit_data, $data)
    {
        echo 99900;
        DB::beginTransaction();
        $cid = 1; //公司id
        $superior_shop_id = 1; //总店id
        $shop_id = 1; //门店id
        $goods_data = [];
        $defeated = [];
        // $dates = date('Y-m-d H:i:s');
        $dates = $this->now_time;
        try {
            $api_token = Crypt::decrypt($submit_data['api_token']);
        } catch (\Exception $e) {
            return response()->json(["code"=>300, 'msg'=>'error', 'data'=>'非法api_token']);
        }

        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($api_token);

        // $user_info = Common::getUserInfo($submit_data['api_token']);
        // dump($user_info);die;
        $ware_id = 11; //仓库id
        // 查询出入库记录表出库数据
        $find_out_oure_data = DB::table('outin_record')
            ->where('oure_cid', $cid)
            ->where('oure_shop_id', $shop_id)
            ->where('oure_out_ware_id', $ware_id)
            ->where('oure_waon_class', 1)
            ->where('oure_out_in_type', 1)
            ->where('oure_create_time', '>', '2020-09-10 00:00:00')
            ->get()->toArray();
        $out_oure_id = array_column($find_out_oure_data, 'oure_id');
        // 查询出入库记录详情表
        $find_out_oude_goo_id = DB::table('outin_details')
            ->whereIn('oude_oure_id', $out_oure_id)
            ->where('oude_type', 1)
            ->get()->toArray();
        $out_subtract = [];
        foreach ($find_out_oude_goo_id as $kk => $vv) {
            if (!isset($out_subtract[$vv->oude_goo_id])) {
                $out_subtract[$vv->oude_goo_id] = 0;
            }
            $out_subtract[$vv->oude_goo_id] += $vv->oude_goo_number; //商品数量
        }
        // 查询出入库记录表入库数据
        $find_in_oure_data = DB::table('outin_record')
            ->where('oure_cid', $cid)
            ->where('oure_shop_id', $shop_id)
            ->where('oure_out_ware_id', $ware_id)
            ->where('oure_waon_class', 1)
            ->where('oure_out_in_type', 2)
            ->where('oure_create_time', '>', '2020-09-11 08:30:00')
            ->get()->toArray();
        $in_oure_id = array_column($find_in_oure_data, 'oure_id');
        // 查询出入库记录详情表
        $find_in_oude_goo_id = DB::table('outin_details')
            ->whereIn('oude_oure_id', $in_oure_id)
            ->where('oude_type', 1)
            ->get()->toArray();
        $in_subtract = [];
        foreach ($find_in_oude_goo_id as $kk => $vv) {
            if (!isset($in_subtract[$vv->oude_goo_id])) {
                $in_subtract[$vv->oude_goo_id] = 0;
            }
            $in_subtract[$vv->oude_goo_id] += $vv->oude_goo_number; //商品数量
        }
        foreach ($data as $key => $value) {
            // dump($value);
            // exit;
            $info['goo_goods_encode'] = $value['goo_goods_encode'];
            // 根据检索编码查询商品id
            $find_goo_id = DB::table('goods')
                ->where('goo_cid', $cid)
                ->where('goo_shop_id', $shop_id)
                ->where('goo_superior_shop_id', $superior_shop_id)
                ->where('goo_type', 1)
                ->where('goo_delete', 1)
                ->where('goo_goods_encode', $value['goo_goods_encode'])
                ->select('goo_id', 'goo_purchase_price', 'goo_goods_encode')
                ->first();
            // dump($find_goo_id);
            if (!empty($find_goo_id->goo_id)) {
                $goo_id = $find_goo_id->goo_id;
            } else {
                dump($value['goo_goods_encode']);
            }

            // 添加商品库存，查询仓库id
            if (empty($ware_id)) {
            } else {
                $value['hwcl'] = $value['hwcl'] ? $value['hwcl'] : 0; //库存数量
                //判断仓库里是否有此商品
                if (isset($out_subtract[$goo_id])) {
                    $out_subtract_sum = $out_subtract[$goo_id];
                } else {
                    $out_subtract_sum = 0;
                }
                //判断仓库里是否有此商品
                if (isset($in_subtract[$goo_id])) {
                    $in_subject_sum = $in_subtract[$goo_id];
                } else {
                    $in_subject_sum = 0;
                }
                $stock_numbers = $value['hwcl'] + $in_subject_sum - $out_subtract_sum; //良品库存 + 入库数量 - 出库数量
                dump($stock_numbers);

                $res = DB::table('warehouse_onhand')
                    ->where('waon_ware_id', $ware_id)
                    ->where('waon_class', 1)
                    ->increment('waon_all_amount', $stock_numbers);
                $res = DB::table('warehouse_onhand')
                    ->where('waon_ware_id', $ware_id)
                    ->where('waon_class', 1)
                    ->increment('waon_stock_fine_amount', $stock_numbers);
                if (empty($res)) {
                    $value['yuanyin'] = '仓库库存添加失败';
                    array_push($defeated, $value);
                    continue;
                }
                $wago_id = DB::table('warehouse_goods')
                    ->where('wago_ware_id', $ware_id)
                    ->where('wago_goo_id', $goo_id)
                    ->where('wago_class', 1)
                    ->value('wago_id');

                if (empty($wago_id)) {
                    // 仓库内没有商品，添加商品
                    $warehouse_goods['wago_ware_id'] = $ware_id; //仓库
                    $warehouse_goods['wago_class'] = 1;
                    $warehouse_goods['wago_goo_id'] = $goo_id; //商品
                    $warehouse_goods['wago_stock_number'] = $stock_numbers; //良品库存
                    $warehouse_goods['wago_update_time'] = $dates; //更新时间
                    $wago_res = DB::table('warehouse_goods')->insert($warehouse_goods);
                    if (empty($wago_res)) {
                        $value['yuanyin'] = '添加仓库商品失败';
                        array_push($defeated, $value);
                        continue;
                    }
                    unset($warehouse_goods);
                } else {
                    // 仓库内已经有商品了，更改库存数量
                    $edit_data['wago_stock_number'] = $stock_numbers;
                    $edit_data['wago_update_time'] = $dates;
                    $res = DB::table('warehouse_goods')
                        ->where('wago_ware_id', $ware_id)
                        ->where('wago_goo_id', $goo_id)
                        ->where('wago_class', 1)
                        ->update($edit_data);
                    dump($res);
                    if (empty($res)) {
                        $value['yuanyin'] = '修改仓库商品失败库存失败';
                        array_push($defeated, $value);
                        continue;
                    }
                }
                // 添加进销存
                $goo_id_arr[] = $goo_id;
                $purchase_goo_actual_count[$goo_id] = $stock_numbers;
                $purchase_goo_actual_price[$goo_id] = $find_goo_id->goo_purchase_price / 100;
                $purchase_return = StockSellStorageGoods::purchaseSalesImport(
                    $user_info, //用户信息
                    2, //进销存计算方式：1先进先出2移动加权平均法3无成本
                    1, //类型：1采购，2销出，3调拨
                    $ware_id, //仓库id
                    1, //仓库类别
                    $goo_id_arr, //数组，商品id
                    $purchase_goo_actual_count, //数组，商品数量；[商品id=>商品数量]
                    $purchase_goo_actual_price, //数组，商品金额，成本价(不乘以100)；[商品id=>商品金额]
                    1 //进销存的移动加权平均法算法类型：1计算平均价2不计算平均价【退换回收时不计算平均价】
                );
            }
            unset($goo_id);
            unset($goo_id_arr);
            unset($purchase_goo_actual_count);
            unset($purchase_goo_actual_price);
            unset($purchase_return);
            unset($find_goo_id);
            unset($find_dibi_data);
            unset($info);
        }
        echo 333;
        dump($defeated);
        DB::commit();
    }

    // 厦门门店导入非商品仓商品数据
    public function newImportGoods2($submit_data, $data)
    {
        // echo 99900;die;
        DB::beginTransaction();
        $cid = 1; //公司id
        $superior_shop_id = 1; //总店id
        $shop_id = 1; //门店id
        $goods_data = [];
        $defeated = [];
        // $dates = date('Y-m-d H:i:s');
        $dates = $this->now_time;
        try {
            $api_token = Crypt::decrypt($submit_data['api_token']);
        } catch (\Exception $e) {
            return response()->json(["code"=>300, 'msg'=>'error', 'data'=>'非法api_token']);
        }

        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($api_token);
        // $user_info = Common::getUserInfo($submit_data['api_token']);

        $ware_id = 11; //仓库id
        // 查询出入库记录表出库数据
        $find_out_oure_data = DB::table('outin_record')
            ->where('oure_cid', $cid)
            ->where('oure_shop_id', $shop_id)
            ->where('oure_out_ware_id', $ware_id)
            ->where('oure_waon_class', 2)
            ->where('oure_out_in_type', 1)
            ->where('oure_create_time', '>', '2020-09-10 00:00:00')
            ->get()->toArray();
        $out_oure_id = array_column($find_out_oure_data, 'oure_id');
        // 查询出入库记录详情表
        $find_out_oude_goo_id = DB::table('outin_details')
            ->whereIn('oude_oure_id', $out_oure_id)
            ->where('oude_type', 1)
            ->get()->toArray();
        $out_subtract = [];
        foreach ($find_out_oude_goo_id as $kk => $vv) {
            if (!isset($out_subtract[$vv->oude_goo_id])) {
                $out_subtract[$vv->oude_goo_id] = 0;
            }
            $out_subtract[$vv->oude_goo_id] += $vv->oude_goo_number; //商品数量
        }
        // 查询出入库记录表入库数据
        $find_in_oure_data = DB::table('outin_record')
            ->where('oure_cid', $cid)
            ->where('oure_shop_id', $shop_id)
            ->where('oure_out_ware_id', $ware_id)
            ->where('oure_waon_class', 2)
            ->where('oure_out_in_type', 2)
            ->where('oure_create_time', '>', '2020-09-11 08:30:00')
            ->get()->toArray();
        $in_oure_id = array_column($find_in_oure_data, 'oure_id');
        // 查询出入库记录详情表
        $find_in_oude_goo_id = DB::table('outin_details')
            ->whereIn('oude_oure_id', $in_oure_id)
            ->where('oude_type', 1)
            ->get()->toArray();
        $in_subtract = [];
        foreach ($find_in_oude_goo_id as $kk => $vv) {
            if (!isset($in_subtract[$vv->oude_goo_id])) {
                $in_subtract[$vv->oude_goo_id] = 0;
            }
            $in_subtract[$vv->oude_goo_id] += $vv->oude_goo_number; //商品数量
        }

        foreach ($data as $key => $value) {
            // dump($value);exit;
            $info['goo_goods_encode'] = $value['goo_goods_encode'];
            // 根据检索编码查询商品id
            $find_goo_id = DB::table('goods')
                ->where('goo_cid', $cid)
                ->where('goo_shop_id', $shop_id)
                ->where('goo_superior_shop_id', $superior_shop_id)
                ->where('goo_type', 2)
                ->where('goo_delete', 1)
                ->where('goo_goods_encode', $value['goo_goods_encode'])
                ->select('goo_id', 'goo_purchase_price', 'goo_goods_encode')
                ->first();
            // dump($find_goo_id);
            if (!empty($find_goo_id->goo_id)) {
                $goo_id = $find_goo_id->goo_id;
            } else {
                dump($value['goo_goods_encode']);
            }

            // 添加商品库存，查询仓库id
            if (empty($ware_id)) {
            } else {
                $value['fspcl'] = $value['fspcl'] ? $value['fspcl'] : 0; //库存数量
                //判断仓库里是否有此商品
                if (isset($out_subtract[$goo_id])) {
                    $out_subtract_sum = $out_subtract[$goo_id];
                } else {
                    $out_subtract_sum = 0;
                }
                //判断仓库里是否有此商品
                if (isset($in_subtract[$goo_id])) {
                    $in_subject_sum = $in_subtract[$goo_id];
                } else {
                    $in_subject_sum = 0;
                }
                $stock_numbers = $value['fspcl'] + $in_subject_sum - $out_subtract_sum; //良品库存 + 入库数量 - 出库数量
                if ($stock_numbers < 0) {
                    $stock_numbers = 0;
                }
                $res = DB::table('warehouse_onhand')
                    ->where('waon_ware_id', $ware_id)
                    ->where('waon_class', 2)
                    ->increment('waon_all_amount', $stock_numbers);
                $res = DB::table('warehouse_onhand')
                    ->where('waon_ware_id', $ware_id)
                    ->where('waon_class', 2)
                    ->increment('waon_stock_fine_amount', $stock_numbers);
                if (empty($res)) {
                    $value['yuanyin'] = '仓库库存添加失败';
                    array_push($defeated, $value);
                    continue;
                }
                $wago_id = DB::table('warehouse_goods')
                    ->where('wago_ware_id', $ware_id)
                    ->where('wago_goo_id', $goo_id)
                    ->where('wago_class', 2)
                    ->value('wago_id');

                if (empty($wago_id)) {
                    // 仓库内没有商品，添加商品
                    $warehouse_goods['wago_ware_id'] = $ware_id; //仓库
                    $warehouse_goods['wago_class'] = 2;
                    $warehouse_goods['wago_goo_id'] = $goo_id; //商品
                    $warehouse_goods['wago_stock_number'] = $stock_numbers; //良品库存
                    $warehouse_goods['wago_update_time'] = $dates; //更新时间
                    $wago_res = DB::table('warehouse_goods')->insert($warehouse_goods);
                    if (empty($wago_res)) {
                        $value['yuanyin'] = '添加仓库商品失败';
                        array_push($defeated, $value);
                        continue;
                    }
                    unset($warehouse_goods);
                } else {
                    // 仓库内已经有商品了，更改库存数量
                    $edit_data['wago_stock_number'] = $stock_numbers;
                    $edit_data['wago_update_time'] = $dates;
                    $res = DB::table('warehouse_goods')
                        ->where('wago_ware_id', $ware_id)
                        ->where('wago_goo_id', $goo_id)
                        ->where('wago_class', 2)
                        ->update($edit_data);
                    dump($res);
                    if (empty($res)) {
                        $value['yuanyin'] = '修改仓库商品失败库存失败';
                        array_push($defeated, $value);
                        continue;
                    }
                }
            }
            unset($goo_id);
            unset($find_goo_id);
            unset($find_dibi_data);
            unset($info);
        }
        echo 333;
        dump($defeated);
        DB::commit();
    }

    // 厦门门店导入旧货仓良品商品数据
    public function newImportGoods3($submit_data, $data)
    {
        echo 99900;
        DB::beginTransaction();
        $cid = 1; //公司id
        $superior_shop_id = 1; //总店id
        $shop_id = 1; //门店id
        $goods_data = [];
        $defeated = [];
        // $dates = date('Y-m-d H:i:s');
        $dates = $this->now_time;
        try {
            $api_token = Crypt::decrypt($submit_data['api_token']);
        } catch (\Exception $e) {
            return response()->json(["code"=>300, 'msg'=>'error', 'data'=>'非法api_token']);
        }

        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($api_token);

        // $user_info = Common::getUserInfo($submit_data['api_token']);

        $ware_id = 11; //仓库id
        // 查询出入库记录表出库数据
        $find_out_oure_data = DB::table('outin_record')
            ->where('oure_cid', $cid)
            ->where('oure_shop_id', $shop_id)
            ->where('oure_out_ware_id', $ware_id)
            ->where('oure_waon_class', 3)
            ->where('oure_out_in_type', 1)
            ->where('oure_create_time', '>', '2020-09-10 00:00:00')
            ->get()->toArray();
        $out_oure_id = array_column($find_out_oure_data, 'oure_id');
        // 查询出入库记录详情表
        $find_out_oude_goo_id = DB::table('outin_details')
            ->whereIn('oude_oure_id', $out_oure_id)
            ->where('oude_type', 1)
            ->get()->toArray();
        $out_subtract = [];
        foreach ($find_out_oude_goo_id as $kk => $vv) {
            if (!isset($out_subtract[$vv->oude_goo_id])) {
                $out_subtract[$vv->oude_goo_id] = 0;
            }
            $out_subtract[$vv->oude_goo_id] += $vv->oude_goo_number; //商品数量
        }
        // 查询出入库记录表入库数据
        $find_in_oure_data = DB::table('outin_record')
            ->where('oure_cid', $cid)
            ->where('oure_shop_id', $shop_id)
            ->where('oure_out_ware_id', $ware_id)
            ->where('oure_waon_class', 3)
            ->where('oure_out_in_type', 2)
            ->where('oure_create_time', '>', '2020-09-11 08:30:00')
            ->get()->toArray();
        $in_oure_id = array_column($find_in_oure_data, 'oure_id');
        // 查询出入库记录详情表
        $find_in_oude_goo_id = DB::table('outin_details')
            ->whereIn('oude_oure_id', $in_oure_id)
            ->where('oude_type', 1)
            ->get()->toArray();
        $in_subtract = [];
        foreach ($find_in_oude_goo_id as $kk => $vv) {
            if (!isset($in_subtract[$vv->oude_goo_id])) {
                $in_subtract[$vv->oude_goo_id] = 0;
            }
            $in_subtract[$vv->oude_goo_id] += $vv->oude_goo_number; //商品数量
        }

        foreach ($data as $key => $value) {
            // dump($value);exit;
            $info['goo_goods_encode'] = $value['goo_goods_encode'];
            // 根据检索编码查询商品id
            $find_goo_id = DB::table('goods')
                ->where('goo_cid', $cid)
                ->where('goo_shop_id', $shop_id)
                ->where('goo_superior_shop_id', $superior_shop_id)
                ->where('goo_type', 4)
                ->where('goo_delete', 1)
                ->where('goo_goods_encode', $value['goo_goods_encode'])
                ->select('goo_id', 'goo_purchase_price', 'goo_goods_encode')
                ->first();
            // dump($find_goo_id);
            if (!empty($find_goo_id->goo_id)) {
                $goo_id = $find_goo_id->goo_id;
            } else {
                dump($value['goo_goods_encode']);
            }

            // 添加商品库存，查询仓库id
            if (empty($ware_id)) {
            } else {
                $value['jhcl'] = $value['jhcl'] ? $value['jhcl'] : 0; //库存数量
                //判断仓库里是否有此商品
                if (isset($out_subtract[$goo_id])) {
                    $out_subtract_sum = $out_subtract[$goo_id];
                } else {
                    $out_subtract_sum = 0;
                }
                //判断仓库里是否有此商品
                if (isset($in_subtract[$goo_id])) {
                    $in_subject_sum = $in_subtract[$goo_id];
                } else {
                    $in_subject_sum = 0;
                }
                $stock_numbers = $value['jhcl'] + $in_subject_sum - $out_subtract_sum; //良品库存 + 入库数量 - 出库数量

                $res = DB::table('warehouse_onhand')
                    ->where('waon_ware_id', $ware_id)
                    ->where('waon_class', 3)
                    ->increment('waon_all_amount', $stock_numbers);
                $res = DB::table('warehouse_onhand')
                    ->where('waon_ware_id', $ware_id)
                    ->where('waon_class', 3)
                    ->increment('waon_stock_fine_amount', $stock_numbers);
                if (empty($res)) {
                    $value['yuanyin'] = '仓库库存添加失败';
                    array_push($defeated, $value);
                    continue;
                }
                $wago_id = DB::table('warehouse_goods')
                    ->where('wago_ware_id', $ware_id)
                    ->where('wago_goo_id', $goo_id)
                    ->where('wago_class', 3)
                    ->value('wago_id');

                if (empty($wago_id)) {
                    // 仓库内没有商品，添加商品
                    $warehouse_goods['wago_ware_id'] = $ware_id; //仓库
                    $warehouse_goods['wago_class'] = 3;
                    $warehouse_goods['wago_goo_id'] = $goo_id; //商品
                    $warehouse_goods['wago_stock_number'] = $stock_numbers; //良品库存
                    $warehouse_goods['wago_update_time'] = $dates; //更新时间
                    $wago_res = DB::table('warehouse_goods')->insert($warehouse_goods);
                    if (empty($wago_res)) {
                        $value['yuanyin'] = '添加仓库商品失败';
                        array_push($defeated, $value);
                        continue;
                    }
                    unset($warehouse_goods);
                } else {
                    // 仓库内已经有商品了，更改库存数量
                    $edit_data['wago_stock_number'] = $stock_numbers;
                    $edit_data['wago_update_time'] = $dates;
                    $res = DB::table('warehouse_goods')
                        ->where('wago_ware_id', $ware_id)
                        ->where('wago_goo_id', $goo_id)
                        ->where('wago_class', 3)
                        ->update($edit_data);
                    dump($res);
                    if (empty($res)) {
                        $value['yuanyin'] = '修改仓库商品失败库存失败';
                        array_push($defeated, $value);
                        continue;
                    }
                }
                // 添加进销存
                $goo_id_arr[] = $goo_id;
                $purchase_goo_actual_count[$goo_id] = $stock_numbers;
                $purchase_goo_actual_price[$goo_id] = $find_goo_id->goo_purchase_price / 100;
                $purchase_return = StockSellStorageGoods::purchaseSalesImport(
                    $user_info, //用户信息
                    1, //进销存计算方式：1先进先出2移动加权平均法3无成本
                    1, //类型：1采购，2销出，3调拨
                    $ware_id, //仓库id
                    3, //仓库类别
                    $goo_id_arr, //数组，商品id
                    $purchase_goo_actual_count, //数组，商品数量；[商品id=>商品数量]
                    $purchase_goo_actual_price, //数组，商品金额，成本价(不乘以100)；[商品id=>商品金额]
                    1 //进销存的移动加权平均法算法类型：1计算平均价2不计算平均价【退换回收时不计算平均价】
                );
            }
            unset($goo_id);
            unset($goo_id_arr);
            unset($purchase_goo_actual_count);
            unset($purchase_goo_actual_price);
            unset($purchase_return);
            unset($find_goo_id);
            unset($find_dibi_data);
            unset($info);
        }
        echo 333;
        dump($defeated);
        DB::commit();
    }

    // 厦门门店导入旧货仓优先商品数据
    public function newImportGoods4($submit_data, $data)
    {
        echo 99900;
        DB::beginTransaction();
        $cid = 1; //公司id
        $superior_shop_id = 1; //总店id
        $shop_id = 1; //门店id
        $goods_data = [];
        $defeated = [];
        // $dates = date('Y-m-d H:i:s');
        $dates = $this->now_time;
        try {
            $api_token = Crypt::decrypt($submit_data['api_token']);
        } catch (\Exception $e) {
            return response()->json(["code"=>300, 'msg'=>'error', 'data'=>'非法api_token']);
        }

        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($api_token);

        // $user_info = Common::getUserInfo($submit_data['api_token']);

        $ware_id = 11; //仓库id
        // 查询出入库记录表出库数据
        $find_out_oure_data = DB::table('outin_record')
            ->where('oure_cid', $cid)
            ->where('oure_shop_id', $shop_id)
            ->where('oure_out_ware_id', $ware_id)
            ->where('oure_waon_class', 3)
            ->where('oure_out_in_type', 1)
            ->where('oure_create_time', '>', '2020-09-10 00:00:00')
            ->get()->toArray();
        $out_oure_id = array_column($find_out_oure_data, 'oure_id');
        // 查询出入库记录详情表
        $find_out_oude_goo_id = DB::table('outin_details')
            ->whereIn('oude_oure_id', $out_oure_id)
            ->where('oude_type', 1)
            ->get()->toArray();
        $out_subtract = [];
        foreach ($find_out_oude_goo_id as $kk => $vv) {
            if (!isset($out_subtract[$vv->oude_goo_id])) {
                $out_subtract[$vv->oude_goo_id] = 0;
            }
            $out_subtract[$vv->oude_goo_id] += $vv->oude_goo_number; //商品数量
        }
        // 查询出入库记录表入库数据
        $find_in_oure_data = DB::table('outin_record')
            ->where('oure_cid', $cid)
            ->where('oure_shop_id', $shop_id)
            ->where('oure_out_ware_id', $ware_id)
            ->where('oure_waon_class', 3)
            ->where('oure_out_in_type', 2)
            ->where('oure_create_time', '>', '2020-09-11 08:30:00')
            ->get()->toArray();
        $in_oure_id = array_column($find_in_oure_data, 'oure_id');
        // 查询出入库记录详情表
        $find_in_oude_goo_id = DB::table('outin_details')
            ->whereIn('oude_oure_id', $in_oure_id)
            ->where('oude_type', 1)
            ->get()->toArray();
        $in_subtract = [];
        foreach ($find_in_oude_goo_id as $kk => $vv) {
            if (!isset($in_subtract[$vv->oude_goo_id])) {
                $in_subtract[$vv->oude_goo_id] = 0;
            }
            $in_subtract[$vv->oude_goo_id] += $vv->oude_goo_number; //商品数量
        }

        foreach ($data as $key => $value) {
            // dump($value);exit;
            $info['goo_goods_encode'] = $value['goo_goods_encode'];
            // 根据检索编码查询商品id
            $find_goo_id = DB::table('goods')
                ->where('goo_cid', $cid)
                ->where('goo_shop_id', $shop_id)
                ->where('goo_superior_shop_id', $superior_shop_id)
                ->where('goo_type', 4)
                ->where('goo_delete', 1)
                ->where('goo_goods_encode', $value['goo_goods_encode'])
                ->select('goo_id', 'goo_purchase_price', 'goo_goods_encode')
                ->first();
            // dump($find_goo_id);
            if (!empty($find_goo_id->goo_id)) {
                $goo_id = $find_goo_id->goo_id;
            } else {
                dump($value['goo_goods_encode']);
            }

            // 添加商品库存，查询仓库id
            if (empty($ware_id)) {
            } else {
                $value['jhcy'] = trim($value['jhcy'], '=');
                if (stristr($value['jhcy'], '+')) {
                    $jhcy = explode('+', $value['jhcy']);
                    $value['jhcy'] = array_sum($jhcy);
                    unset($jhcy);
                }
                $value['jhcy'] = $value['jhcy'] ? $value['jhcy'] : 0; //库存数量
                //判断仓库里是否有此商品
                if (isset($out_subtract[$goo_id])) {
                    $out_subtract_sum = $out_subtract[$goo_id];
                } else {
                    $out_subtract_sum = 0;
                }
                //判断仓库里是否有此商品
                if (isset($in_subtract[$goo_id])) {
                    $in_subject_sum = $in_subtract[$goo_id];
                } else {
                    $in_subject_sum = 0;
                }
                $stock_numbers = $value['jhcy'] + $in_subject_sum - $out_subtract_sum; //良品库存 + 入库数量 - 出库数量
                // die;
                // $res = $value['goo_goods_encode'].'--'.$value['jhcy'].'--'. $in_subject_sum .'--'.$out_subtract_sum;
                // dump($res);
                // continue;
                $res = DB::table('warehouse_onhand')
                    ->where('waon_ware_id', $ware_id)
                    ->where('waon_class', 3)
                    ->increment('waon_all_amount', $stock_numbers);
                $res = DB::table('warehouse_onhand')
                    ->where('waon_ware_id', $ware_id)
                    ->where('waon_class', 3)
                    ->increment('waon_stock_priority_amount', $stock_numbers);
                if (empty($res)) {
                    $value['yuanyin'] = '仓库库存添加失败';
                    array_push($defeated, $value);
                    continue;
                }
                $wago_id = DB::table('warehouse_goods')
                    ->where('wago_ware_id', $ware_id)
                    ->where('wago_goo_id', $goo_id)
                    ->where('wago_class', 3)
                    ->value('wago_id');

                if (empty($wago_id)) {
                    // 仓库内没有商品，添加商品
                    $warehouse_goods['wago_ware_id'] = $ware_id; //仓库
                    $warehouse_goods['wago_class'] = 3;
                    $warehouse_goods['wago_goo_id'] = $goo_id; //商品
                    $warehouse_goods['wago_stock_number'] = $stock_numbers; //良品库存
                    $warehouse_goods['wago_update_time'] = $dates; //更新时间
                    $wago_res = DB::table('warehouse_goods')->insert($warehouse_goods);
                    if (empty($wago_res)) {
                        $value['yuanyin'] = '添加仓库商品失败';
                        array_push($defeated, $value);
                        continue;
                    }
                    unset($warehouse_goods);
                } else {
                    // 仓库内已经有商品了，更改库存数量
                    $edit_data['wago_stock_number'] = $stock_numbers;
                    $edit_data['wago_update_time'] = $dates;
                    $res = DB::table('warehouse_goods')
                        ->where('wago_ware_id', $ware_id)
                        ->where('wago_goo_id', $goo_id)
                        ->where('wago_class', 3)
                        ->update($edit_data);
                    dump($res);
                    if (empty($res)) {
                        $value['yuanyin'] = '修改仓库商品失败库存失败';
                        array_push($defeated, $value);
                        continue;
                    }
                }
                // 添加进销存
                $goo_id_arr[] = $goo_id;
                $purchase_goo_actual_count[$goo_id] = $stock_numbers;
                $purchase_goo_actual_price[$goo_id] = $find_goo_id->goo_purchase_price / 100;
                $purchase_return = StockSellStorageGoods::purchaseSalesImport(
                    $user_info, //用户信息
                    1, //进销存计算方式：1先进先出2移动加权平均法3无成本
                    1, //类型：1采购，2销出，3调拨
                    $ware_id, //仓库id
                    1, //仓库类别
                    $goo_id_arr, //数组，商品id
                    $purchase_goo_actual_count, //数组，商品数量；[商品id=>商品数量]
                    $purchase_goo_actual_price, //数组，商品金额，成本价(不乘以100)；[商品id=>商品金额]
                    1 //进销存的移动加权平均法算法类型：1计算平均价2不计算平均价【退换回收时不计算平均价】
                );
            }
            unset($goo_id);
            unset($goo_id_arr);
            unset($purchase_goo_actual_count);
            unset($purchase_goo_actual_price);
            unset($purchase_return);
            unset($find_goo_id);
            unset($find_dibi_data);
            unset($info);
        }
        echo 333;
        dump($defeated);
        DB::commit();
    }

    // 厦门门店导入临时仓待检测商品数据
    public function newImportGoods5($submit_data, $data)
    {
        echo 99900;
        DB::beginTransaction();
        $cid = 1; //公司id
        $superior_shop_id = 1; //总店id
        $shop_id = 1; //门店id
        $goods_data = [];
        $defeated = [];
        // $dates = date('Y-m-d H:i:s');
        $dates = $this->now_time;
        // try {
        //     $api_token = Crypt::decrypt($submit_data['api_token']);
        // } catch (\Exception $e) {
        //     return response()->json(["code"=>300,'msg'=>'error','data'=>'非法api_token']);
        // }

        // // 获取当前操作账号信息
        // $user_info = Common::getUserInfo($api_token);

        // $user_info = Common::getUserInfo($submit_data['api_token']);

        $ware_id = 11; //仓库id
        // 查询出入库记录表出库数据
        $find_out_oure_data = DB::table('outin_record')
            ->where('oure_cid', $cid)
            ->where('oure_shop_id', $shop_id)
            ->where('oure_out_ware_id', $ware_id)
            ->where('oure_waon_class', 4)
            ->where('oure_out_in_type', 1)
            ->where('oure_create_time', '>', '2020-09-10 00:00:00')
            ->get()->toArray();
        $out_oure_id = array_column($find_out_oure_data, 'oure_id');
        // 查询出入库记录详情表
        $find_out_oude_goo_id = DB::table('outin_details')
            ->whereIn('oude_oure_id', $out_oure_id)
            ->where('oude_type', 1)
            ->get()->toArray();
        $out_subtract = [];
        foreach ($find_out_oude_goo_id as $kk => $vv) {
            if (!isset($out_subtract[$vv->oude_goo_id])) {
                $out_subtract[$vv->oude_goo_id] = 0;
            }
            $out_subtract[$vv->oude_goo_id] += $vv->oude_goo_number; //商品数量
        }
        // 查询出入库记录表入库数据
        $find_in_oure_data = DB::table('outin_record')
            ->where('oure_cid', $cid)
            ->where('oure_shop_id', $shop_id)
            ->where('oure_out_ware_id', $ware_id)
            ->where('oure_waon_class', 4)
            ->where('oure_out_in_type', 2)
            ->where('oure_create_time', '>', '2020-09-11 08:30:00')
            ->get()->toArray();
        $in_oure_id = array_column($find_in_oure_data, 'oure_id');
        // 查询出入库记录详情表
        $find_in_oude_goo_id = DB::table('outin_details')
            ->whereIn('oude_oure_id', $in_oure_id)
            ->where('oude_type', 1)
            ->get()->toArray();
        $in_subtract = [];
        foreach ($find_in_oude_goo_id as $kk => $vv) {
            if (!isset($out_subtract[$vv->oude_goo_id])) {
                $out_subtract[$vv->oude_goo_id] = 0;
            }
            $in_subtract[$vv->oude_goo_id] += $vv->oude_goo_number; //商品数量
        }

        foreach ($data as $key => $value) {
            // dump($value);exit;
            $info['goo_goods_encode'] = $value['goo_goods_encode'];
            // 根据检索编码查询商品id
            $find_goo_id = DB::table('goods')
                ->where('goo_cid', $cid)
                ->where('goo_shop_id', $shop_id)
                ->where('goo_superior_shop_id', $superior_shop_id)
                ->where('goo_delete', 1)
                ->where('goo_goods_encode', $value['goo_goods_encode'])
                ->select('goo_id', 'goo_purchase_price', 'goo_goods_encode')
                ->first();
            // dump($find_goo_id);
            if (!empty($find_goo_id->goo_id)) {
                $goo_id = $find_goo_id->goo_id;
            } else {
                dump($value['goo_goods_encode']);
            }

            // 添加商品库存，查询仓库id
            if (empty($ware_id)) {
            } else {
                $value['lscdjc'] = $value['lscdjc'] ? $value['lscdjc'] : 0; //库存数量
                //判断仓库里是否有此商品
                if (isset($out_subtract[$goo_id])) {
                    $out_subtract_sum = $out_subtract[$goo_id];
                } else {
                    $out_subtract_sum = 0;
                }
                //判断仓库里是否有此商品
                if (isset($in_subtract[$goo_id])) {
                    $in_subject_sum = $in_subtract[$goo_id];
                } else {
                    $in_subject_sum = 0;
                }
                $stock_numbers = $value['lscdjc'] + $in_subject_sum - $out_subtract_sum; //良品库存 + 入库数量 - 出库数量

                $res = DB::table('warehouse_onhand')
                    ->where('waon_ware_id', $ware_id)
                    ->where('waon_class', 4)
                    ->increment('waon_all_amount', $stock_numbers);
                $res = DB::table('warehouse_onhand')
                    ->where('waon_ware_id', $ware_id)
                    ->where('waon_class', 4)
                    ->increment('waon_stock_unchecked_amount', $stock_numbers);
                if (empty($res)) {
                    $value['yuanyin'] = '仓库库存添加失败';
                    array_push($defeated, $value);
                    continue;
                }
                $wago_id = DB::table('warehouse_goods')
                    ->where('wago_ware_id', $ware_id)
                    ->where('wago_goo_id', $goo_id)
                    ->where('wago_class', 4)
                    ->value('wago_id');

                if (empty($wago_id)) {
                    // 仓库内没有商品，添加商品
                    $warehouse_goods['wago_ware_id'] = $ware_id; //仓库
                    $warehouse_goods['wago_class'] = 4;
                    $warehouse_goods['wago_goo_id'] = $goo_id; //商品
                    $warehouse_goods['wago_unchecked_stock_number'] = $stock_numbers; //良品库存
                    $warehouse_goods['wago_update_time'] = $dates; //更新时间
                    $wago_res = DB::table('warehouse_goods')->insert($warehouse_goods);
                    if (empty($wago_res)) {
                        $value['yuanyin'] = '添加仓库商品失败';
                        array_push($defeated, $value);
                        continue;
                    }
                    unset($warehouse_goods);
                } else {
                    // 仓库内已经有商品了，更改库存数量
                    $edit_data['wago_unchecked_stock_number'] = $stock_numbers;
                    $edit_data['wago_update_time'] = $dates;
                    $res = DB::table('warehouse_goods')
                        ->where('wago_ware_id', $ware_id)
                        ->where('wago_goo_id', $goo_id)
                        ->where('wago_class', 4)
                        ->update($edit_data);
                    dump($res);
                    if (empty($res)) {
                        $value['yuanyin'] = '修改仓库商品失败库存失败';
                        array_push($defeated, $value);
                        continue;
                    }
                }
            }
            unset($goo_id);
            unset($find_goo_id);
            unset($find_dibi_data);
            unset($info);
        }
        echo 333;
        dump($defeated);
        DB::commit();
    }
}
