<?php

namespace App\Http\Controllers\Api\BackEnd;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Crypt;
use App\Http\Models\Api\Export;

// 调整数据控制器，用来调整各种问题数据
class AdjustDataController extends Controller
{
    protected $show_count = 10;

    // 入口方法
    public function entrance(Request $request)
    {
        // 同步仓库中赠品商品数据
        // $this->synchronizeWarehouseGift();
        // 同步产品商品属性单位
        // $this->synchronizationGoodsUnit();
        // $this->totalChannelType();
        // $this->updateChannleExcelData();
        // $this->importChannleExcelData();
        // $this->otherOrderImage();
        // $this->workImageAdjust();
        // $this->stocktakeGoodsRecord();
        // $this->changeBoundGoods();

        // echo 111;die;
        // 1.计算商品流水库存
        // $this->computeWaterInventory();
        // 2.导入Excel期初库存数据
        // $this->importExcelData();
        // 2.1 处理导入的Excel期初库存数据
        // $this->importInitial();
        // 3.统计计算后的库存数量，计算流水和期初
        // $this->totalInventory();
        // 4.统计锁定商品库存,可以单独运行，汲起航运行过他的锁定代码可以不再运行
        // $this->lockGoodsOrder2();
        // 5.将计算后的库存数量与数据库现有的库存比较
        // $this->updateWareInventory();
        // $this->updateWareData();

        // 比较数据表字段注释
        // $this->comparisonFieldComment();
        // 将数据中的数据表及字段查询出来，并导出markdown语法格式
        // $this->databaseFieldComment();
        // 查询一个订单有多个发货单的
        // $this->selectOrderDispatch();
        // $this->selectBill();
        // 删除权限
        // $this->deleteRole();
        // $pathName = storage_path() . '/app/public/image/1'.date('/Y/m/d/'); //获取上传图片路径
        // dump($pathName);
        // die;
        // $this->inquireWarehouseRepeatGoods();
        // $this->technicianBackGoods();
        // $this->addWarehouseGoods();
        // $this->delteteData();
        // 订单、工单结算金额不一致数据统计
        // $this->diffOrderWorkPirce();
        // 订单的结算金额与订单商品金额计算不一致数据统计
        // $this->diffOrderGoodsPirce();
        // $this->diffOrderPirceReceivable();//统计订单结算金额与应收应付不一致的数据
        // 统计仓库商品进销存金额
        // $this->entersPirce($request->all());
        // 统计所有仓库的商品进销存价格
        // $this->entersWarehousePirce($request->all());
        // $this->exportWarehousePirce($request->all());
        // $this->enterPirceDiff($request->all());
        // 比较销售统计的数据
        // $this->diffDataStatistical($request->all());
        // 销售统计商品成本与订单商品成本不一致
        // $this->diffOrderStatistical($request->all());
        // $this->noOrderNumber($request->all());
        // $this->goodsCodeDiff();
        // $this->systemGoodsEncode();
        // 查询仓库的锁定商品，以及对应锁定的单子
        // $this->wareGoodsLock($request->all());
        // 应收应付中订单时间为0的，同步订单时间
        // $this->receivableOrderTime($request->all());
        //新增默认仓位
        // $this->addFreight($request->all());
        // $this->goodsEncodeData($request->all());
        // $this->orderUniqueString();
        // $this->stock();// 更改库存
        // $this->diffOrderReceivable();// 统计订单结算金额与应收应付金额不一致的数据01
        // $this->diffReceivableState();//应收应付状态问题数据02
        // $this->diffwarehouseFreight();//统计仓库总量与仓库+仓位数量不一致03
        // $this->getState();//统计账单已结款，结款明细已确认，应收应付未确认的04
        // $this->freightGoodsKucun();//仓位商品数量统计000005
        // $this->randomLongitudeLatitude();//随机生成经纬度
        // $this->selectGoods();//查询系统商品编码是否都存在
        // $this->deleteOldGoods();//删除原来的新增的系统商品
        // $this->newOldGoods();//新旧编码商品数据
        // $this->newOldGoodsSearch();//新旧编码商品数据
        // $this->newOldGoodsDispose();//新旧编码商品数据处理
        // $this->newOldGoodsReplace();//新旧编码商品数据替换
        // $this->goodsCount();//商品品牌、系列、品类数量统计
        // $this->getdelGoods();//仓库删除商品数量统计
        // $this->systemGoodsReplace();//系统商品编码替换
        // $this->goodstongbu();//同步商品数据到供应链
        // $this->entersBeginning();//统计调整进销存盘库单有期初金额有入库金额的数据
        // $this->adjustBillPortion();//账单列表部分结款的数据处理
        // $this->outboundDataStatistics();//销售统计出库方式数据调整
        // $this->diffTotalDataStatistics();//销售统计总利润查询差异
        // $this->diffTotalCompareDataStatistics();//销售统计总利润查询差异对比
        // $this->diffAllocateEnters();//进销存调拨单，调入调出成本不一样数据
        // $this->entersCostCalculate();//进销存成本计算
        // $this->entersTotalCompareCalculate();//进销存总金额与单价*库存比较
        // $this->entersCostPriceCalculate();//进销存成本单价计算比较
        // $this->clearWarehouseStock();//清除仓库库存数据
        
    }

    
    // 清除仓库库存数据
    public function clearWarehouseStock()
    {
        $ware_id = [9,10,11,13,14,96,121];//仓库id
        $edit_data['wago_stock_number'] = 0;
        $edit_data['wago_lock_quantity'] = 0;
        $edit_data['wago_priority_stock_number'] = 0;
        $edit_data['wago_priority_lock_quantity'] = 0;
        $edit_data['wago_unchecked_stock_number'] = 0;
        $edit_data['wago_stock_amount'] = 0;
        $edit_data['wago_lock_amount'] = 0;
        $edit_data['wago_priority_stock_amount'] = 0;
        $edit_data['wago_priority_lock_amount'] = 0;
        $edit_data['wago_unchecked_stock_amount'] = 0;
        $edit_data['wago_freight_stock_number'] = 0;
        $edit_data['wago_freight_lock_quantity'] = 0;
        $edit_data['wago_freight_priority_stock_number'] = 0;
        $edit_data['wago_freight_priority_lock_quantity'] = 0;
        $edit_data['wago_freight_unchecked_stock_number'] = 0;
        $edit_data['wago_refuse_fine_stock'] = 0;
        $edit_data['wago_refuse_fine_lock'] = 0;
        $edit_data['wago_refuse_priority_stock'] = 0;
        $edit_data['wago_refuse_priority_lock'] = 0;
        $ware_res = DB::table('warehouse_goods')
                ->whereIn('wago_ware_id', $ware_id)
                ->update($edit_data);
        dump($ware_res);

        $waon_edit_data['waon_all_amount'] = 0;
        $waon_edit_data['waon_stock_fine_amount'] = 0;
        $waon_edit_data['waon_lock_fine_amount'] = 0;
        $waon_edit_data['waon_stock_priority_amount'] = 0;
        $waon_edit_data['waon_lock_priority_amount'] = 0;
        $waon_edit_data['waon_stock_unchecked_amount'] = 0;
        $ware_res = DB::table('warehouse_onhand')
                ->whereIn('waon_ware_id', $ware_id)
                ->update($waon_edit_data);
        dump($ware_res);

        $wafg_edit_data['wafg_stock_number'] = 0;
        $wafg_edit_data['wafg_lock_quantity'] = 0;
        $wafg_edit_data['wafg_priority_stock_number'] = 0;
        $wafg_edit_data['wafg_priority_lock_quantity'] = 0;
        $wafg_edit_data['wafg_unchecked_stock_number'] = 0;
        $ware_res = DB::table('warehouse_freight_goods')
                ->whereIn('wafg_ware_id', $ware_id)
                ->update($wafg_edit_data);
        dump($ware_res);

        $wafr_edit_data['wafr_all_stock'] = 0;
        $wafr_edit_data['wafr_lock_quantity'] = 0;
        $wafr_edit_data['wafr_priority_all_stock'] = 0;
        $wafr_edit_data['wafr_priority_lock_quantity'] = 0;
        $wafr_edit_data['wafr_unchecked_all_stock'] = 0;
        $ware_res = DB::table('warehouse_freight')
                ->whereIn('wafr_ware_id', $ware_id)
                ->update($wafr_edit_data);
        dump($ware_res);
    }

    // 进销存成本单价计算比较
    public function entersCostPriceCalculate()
    {
        ignore_user_abort();
        set_time_limit(0);
        $find_data = DB::table('enters_sells_saves')
                ->where('ense_shop_id', 1)
                ->where('ense_time', '>=', '2021-03-13')
                ->where('ense_order_number', 'like', 'CG%')
                ->where('ense_out_in', 2)
                ->select('ense_id', 'ense_order_number', 'ense_end_inventory', 'ense_end_price', 'ense_in_price', 'ense_goo_warehouse', 'ense_goo_waretype', 'ense_goo_number', 'ense_time')
                // ->offset(0)->limit(800)
                // ->offset(800)->limit(800)
                // ->offset(1600)->limit(800)
                // ->offset(2400)->limit(800)
                // ->offset(3200)->limit(800)
                // ->offset(4000)->limit(800)
                // ->offset(4800)->limit(800)
                // ->offset(5600)->limit(800)
                ->offset(6400)->limit(800)
                ->get()->toArray();
        dump($find_data);
        die;
        $diff_data = [];
        foreach ($find_data as $key => $value) {
            $last_data = DB::table('enters_sells_saves')
                ->where('ense_shop_id', 1)
                ->where('ense_time', '>=', '2021-03-13')
                ->where('ense_goo_number', $value->ense_goo_number)
                ->where('ense_goo_warehouse', $value->ense_goo_warehouse)
                ->where('ense_goo_waretype', $value->ense_goo_waretype)
                ->where('ense_id', '<', $value->ense_id)
                ->orderBy('ense_id', 'desc')
                ->select('ense_id', 'ense_order_number', 'ense_end_inventory', 'ense_end_price', 'ense_in_price', 'ense_goo_warehouse', 'ense_goo_waretype', 'ense_goo_number', 'ense_time')
                ->first();
            if (!empty($last_data)) {
                // 判断当前进销存结余成本金额与上一次进销存结余成本比较，这次的成本金额大于上次的成本金额
                // 当前的采购成本是否大于上次的进销存结余成本
                if ($value->ense_in_price > $last_data->ense_end_price) {
                    // 当前进销存结余成本应该不大于采购成本，将大于采购成本的数据筛选出来
                    if ($value->ense_end_price > $value->ense_in_price) {
                        $diff_data[] = $value;
                    }
                } else {
                    // 当前采购成本小于上次的进销存结余成本，当前的结余成本应该小于上次的结余成本，将大于上次的结余成本的数据筛选出来
                    if ($value->ense_end_price > $last_data->ense_end_price) {
                        $diff_data[] = $value;
                    }
                }
                // dump($value);
                // dump($last_data);
                // die;
            }
            unset($value);
            unset($last_data);
        }
        dump($diff_data);
        echo "success";
    }

    // 进销存总金额与单价*库存比较
    public function entersTotalCompareCalculate()
    {
        $find_data = DB::table('enters_sells_saves')
                ->where('ense_shop_id', 1)
                ->where('ense_time', '>=', '2021-03-13')
                ->select('ense_id', 'ense_order_number', 'ense_end_inventory', 'ense_end_price', 'ense_end_amount', 'ense_goo_warehouse', 'ense_goo_waretype', 'ense_goo_number', 'ense_time')
                ->get()->toArray();
        // dump($find_data);

        foreach ($find_data as $key => $value) {
            if ($value->ense_end_price) {
                $total_price = $value->ense_end_inventory * $value->ense_end_price;
            } else {
                $total_price = 0;
            }
            if (empty($value->ense_end_amount)) {
                $value->ense_end_amount = 0;
            }
            $diff_price = $value->ense_end_amount - $total_price;
            if (abs($diff_price) > 1) {
                // dump($value);die;
                $temp_data = (array)$value;
                $temp_data['ense_in_price'] = $diff_price;
                DB::table('enters_sells_saves_price')->insert($temp_data);
                unset($temp_data);
            }
        }
        echo "success";
    }

    // 进销存成本计算
    public function entersCostCalculate()
    {
        $find_data = DB::table('enters_sells_saves')
                ->where('ense_shop_id', 1)
                ->where('ense_goo_waretype', 1)
                ->where('ense_goo_warehouse', 150)
                ->where('ense_goo_number', '03203')
                // ->where('ense_id', '>=', 247687)
                ->where('ense_id', '>=', 223143)
                ->get()->toArray();
        foreach ($find_data as $key => $value) {
            if ($key == 0) {
                continue;
            }
            // $last_data = $find_data[$key-1];//上一次的数据
            $last_data = DB::table('enters_sells_saves')
                ->where('ense_id', $find_data[$key-1]->ense_id)
                ->first();

            $edit_data['ense_new_price'] = $last_data->ense_end_price;
            $edit_data['ense_new_amount'] = $last_data->ense_end_amount;

            // 调拨入库，入库类型，入库数量
            if ($value->ense_out_in == 2) {
                if ($value->ense_in_num > 0) {
                    // 期末总额 = 上一次的期末总额 + 调入总金额
                    $edit_data['ense_end_amount'] = $last_data->ense_end_amount + $value->ense_in_amount;
                    // 期末平均价 = 期末总额 / 期末总库存
                    $edit_data['ense_end_price'] = sprintf("%.4f", $edit_data['ense_end_amount'] / $value->ense_end_inventory);
                } elseif ($value->ense_out_num < 0) {
                    // 退货入库，出库数量为负数
                    // 出库金额 = 上一次的期末平均价
                    $edit_data['ense_out_price'] = $last_data->ense_end_price;
                    // 出库总额 = 出库金额* 出库数量
                    $edit_data['ense_out_amount'] = $last_data->ense_end_price * $value->ense_out_num;

                    // 期末总额 = 上一次的期末总额 + 本次出库总额
                    $edit_data['ense_end_amount'] = $last_data->ense_end_amount + abs($edit_data['ense_out_amount']);
                    // 期末平均价 = 上一次的期末平均价
                    $edit_data['ense_end_price'] = $last_data->ense_end_price;
                }
            } elseif ($value->ense_out_in == 1) {
                // 出库类型
                if ($value->ense_out_num > 0) {
                    // 正常出库
                    // 出库金额 = 上一次的期末平均价
                    $edit_data['ense_out_price'] = $last_data->ense_end_price;
                    // 出库总额 = 出库金额* 出库数量
                    $edit_data['ense_out_amount'] = $last_data->ense_end_price * $value->ense_out_num;

                    // 期末总额 = 上一次的期末总额 - 本次出库总额
                    $edit_data['ense_end_amount'] = $last_data->ense_end_amount - $edit_data['ense_out_amount'];
                    // 期末平均价 = 上一次的期末平均价
                    $edit_data['ense_end_price'] = $last_data->ense_end_price;
                } elseif ($value->ense_in_num < 0) {
                    // 采购单，申请退货，退货出库类型，入库数量是负数，入库总金额是负数
                    // 期末总额 = 上一次的期末总额 - 本次出库总额
                    $edit_data['ense_end_amount'] = $last_data->ense_end_amount - abs($value->ense_in_amount);
                    // 期末平均价 = 期末总额 / 期末总库存
                    $edit_data['ense_end_price'] = sprintf("%.4f", $edit_data['ense_end_amount'] / $value->ense_end_inventory);
                }
            }
            // dump($value->ense_id);
            // dump($edit_data);
            // die;
            // 更改进销存数据
            $res = DB::table('enters_sells_saves')
                ->where('ense_id', $value->ense_id)
                ->update($edit_data);
            unset($edit_data);
            unset($last_data);
        }
        echo "success";
        dump($find_data);
    }

    // 进销存调拨单，调入调出成本不一样数据
    public function diffAllocateEnters()
    {
        // echo "1111";die;
        $find_out_data = DB::table('enters_sells_saves')
                ->where('ense_shop_id', 1)
                ->where('ense_out_in', 1)//1出库2入库
                ->whereNotIn('ense_goo_warehouse', [9,10,11,13,14,15,16,17,18,19,20,21,22,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,96,115,118,120,121])
                ->where('ense_order_number', 'like', 'DB%')
                ->select('ense_id', 'ense_order_number', 'ense_out_in', 'ense_goo_waretype', 'ense_goo_number', 'ense_goo_warehouse', 'ense_out_num', 'ense_out_price', 'ense_out_amount', 'ense_time')
                ->get()->toArray();
        // $out_order_data = array_column($find_data, null, 'ense_order_number');
        // dump($find_out_data);
        $find_in_data = DB::table('enters_sells_saves')
                ->where('ense_shop_id', 1)
                ->where('ense_out_in', 2)//1出库2入库
                ->whereNotIn('ense_goo_warehouse', [9,10,11,13,14,15,16,17,18,19,20,21,22,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,96,115,118,120,121])
                ->where('ense_order_number', 'like', 'DB%')
                ->select('ense_id', 'ense_order_number', 'ense_out_in', 'ense_goo_waretype', 'ense_goo_number', 'ense_goo_warehouse', 'ense_in_num', 'ense_in_price', 'ense_in_amount', 'ense_time')
                ->get()->toArray();
        foreach ($find_out_data as $key => $value) {
            $out_order_data[$value->ense_order_number][$value->ense_goo_number] = (array)$value;
        }
        foreach ($find_in_data as $key => $value) {
            $in_order_data[$value->ense_order_number][$value->ense_goo_number] = (array)$value;
        }

        $diff_data = [];
        foreach ($out_order_data as $ense_order_number => $order_value) {
            // dump($order_value);die;
            foreach ($order_value as $ense_goo_number => $value) {
                // dump($value);die;
                if (isset($in_order_data[$ense_order_number])) {
                    if ($value['ense_out_price'] != $in_order_data[$ense_order_number][$ense_goo_number]['ense_in_price']) {
                        $diff_price = $value['ense_out_price'] - $in_order_data[$ense_order_number][$ense_goo_number]['ense_in_price'];
                        if (abs($diff_price) < 1) {
                            continue;
                        }
                        DB::table('enters_sells_saves_price')->insert($value);
                        DB::table('enters_sells_saves_price')->insert($in_order_data[$ense_order_number][$ense_goo_number]);
                        $diff_data[$ense_order_number][] = $value;
                        $diff_data[$ense_order_number][] = $in_order_data[$ense_order_number][$ense_goo_number];
                    }
                } else {
                    // DB::table('enters_sells_saves_price')->insert($value);
                    $value['diff_state'] = 1;
                    $diff_data[$ense_order_number][] = $value;
                }
            }
        }
        echo "success";
        dump($diff_data);
        die;
        // dump($out_order_data['DB860910105828929499']);
    }

    // 销售统计总利润查询差异对比
    public function diffTotalCompareDataStatistics()
    {
        $find_data = DB::table('data_statistical_ziying')
            ->select('dast_id')
            ->get()->toArray();
        foreach ($find_data as $key => $value) {
            $find_dast_id = DB::table('data_statistical_kucun')
                ->where('dast_id', $value->dast_id)
                ->value('dast_id');
            if (empty($find_dast_id)) {
                dump($value);
                $data = (array)$value;
                DB::table('data_statistical_compare')->insert($data);
            }
        }
        echo "success";
    }

    // 销售统计总利润查询差异
    public function diffTotalDataStatistics()
    {
        ignore_user_abort();
        set_time_limit(0);
        // 品牌查询-自营仓库
        $find_data = DB::select(
            "SELECT
                faster_dast.*
            FROM
                `faster_data_statistical` AS `faster_dast`
                LEFT JOIN `faster_goods` AS `faster_goo` ON `faster_goo`.`goo_id` = `faster_dast`.`dast_goo_id`
                LEFT JOIN `faster_warehouse` AS `faster_ware` ON `faster_ware`.`ware_id` = `faster_dast`.`dast_ware_id` 
            WHERE
                `dast_cid` = 1 
                AND `dast_superior_shop_id` = 1 
                AND `dast_order_type` != 3 
                AND `dast_ord_delete` = 1 
                AND ( `dast_orcl_shipment_party` = 1 ) 
                AND ( `dast_create_time` BETWEEN '2021-03-01' AND '2021-04-01' ) 
                AND `dast_goo_id` > 0 
                AND `dast_service_project_type` = 1 "
        );

        foreach ($find_data as $key => $value) {
            $data = (array)$value;
            DB::table('data_statistical_ziying')->insert($data);
        }
        echo "success";
        die;
        // 品牌查询-移动仓
        $find_data = DB::select(
            "SELECT
                faster_dast.*
            FROM
                `faster_data_statistical` AS `faster_dast`
                LEFT JOIN `faster_goods` AS `faster_goo` ON `faster_goo`.`goo_id` = `faster_dast`.`dast_goo_id`
                LEFT JOIN `faster_warehouse` AS `faster_ware` ON `faster_ware`.`ware_id` = `faster_dast`.`dast_ware_id` 
            WHERE
                `dast_cid` = 1 
                AND `dast_superior_shop_id` = 1 
                AND `dast_order_type` != 3 
                AND `dast_ord_delete` = 1 
                AND ( `ware_type` = 3 ) 
                AND ( `dast_create_time` BETWEEN '2021-03-01' AND '2021-04-01' ) 
                AND `dast_goo_id` > 0 
                AND `dast_service_project_type` = 1"
        );
        foreach ($find_data as $key => $value) {
            $data = (array)$value;
            DB::table('data_statistical_kucun')->insert($data);
        }
        // dump($find_data);
        unset($find_data);
        // 品牌查询-固定仓
        $find_data = DB::select(
            "SELECT
                faster_dast.*
            FROM
                `faster_data_statistical` AS `faster_dast`
                LEFT JOIN `faster_goods` AS `faster_goo` ON `faster_goo`.`goo_id` = `faster_dast`.`dast_goo_id`
                LEFT JOIN `faster_warehouse` AS `faster_ware` ON `faster_ware`.`ware_id` = `faster_dast`.`dast_ware_id` 
            WHERE
                `dast_cid` = 1 
                AND `dast_superior_shop_id` = 1 
                AND `dast_order_type` != 3 
                AND `dast_ord_delete` = 1 
                AND ( `ware_type` = 1 ) 
                AND ( `dast_create_time` BETWEEN '2021-03-01' AND '2021-04-01' ) 
                AND `dast_goo_id` > 0 
                AND `dast_service_project_type` = 1 "
        );
        foreach ($find_data as $key => $value) {
            $data = (array)$value;
            DB::table('data_statistical_kucun')->insert($data);
        }
        echo "success";
    }

    //统计订单结算金额与应收应付不一致的数据
    public function diffOrderPirceReceivable()
    {
        $find_data = DB::table('order as o')
            ->leftjoin('receivable_credit as rc', 'o.ord_order_number', '=', 'rc.recr_original_number')
            ->where('ord_superior_shop_id', 1)
            ->where('ord_shop_id', 1)
            ->where('ord_delete', 1)
            ->where('ord_collection_bill', 1)
            ->where('ord_actual_price', '>', 0)
            ->where('recr_plus_minus', 2)
            ->where('recr_state', 1)
            ->where('recr_type', 1)
            ->select('ord_id', 'ord_order_number')
            ->get()->toArray();
        dump($find_data);
    }

    //销售统计出库方式数据调整
    public function outboundDataStatistics()
    {
        ignore_user_abort();
        set_time_limit(0);
        $time = '2021-01-01';
        $find_data = DB::table('data_statistical')
            ->where('dast_shop_id', 1)
            ->where('dast_create_time', '>=', $time)
            ->where('dast_service_type', 4)
            ->where('dast_waon_class', 3)
            ->where('dast_ord_delete', 1)
            ->where('dast_order_type', '<>', 3)
            ->select('dast_id', 'dast_ord_id', 'dast_order_number')
            ->get()->toArray();
        // dump($find_data);
        $edit_data['dast_order_type'] = 3;
        // 退货单类型，旧货仓商品数据调整
        $res1 = DB::table('data_statistical')
            ->where('dast_shop_id', 1)
            ->where('dast_create_time', '>=', $time)
            ->where('dast_service_type', 4)
            ->where('dast_waon_class', 3)
            ->where('dast_ord_delete', 1)
            ->where('dast_order_type', '<>', 3)
            ->update($edit_data);
        dump($res1);

        // 临时仓数据调整
        $find_data = DB::table('data_statistical')
            ->where('dast_shop_id', 1)
            ->where('dast_create_time', '>=', $time)
            ->where('dast_waon_class', 4)
            ->where('dast_ord_delete', 1)
            ->where('dast_order_type', '<>', 3)
            ->select('dast_id', 'dast_ord_id', 'dast_order_number')
            ->get()->toArray();
        // dump($find_data);
        $res2 = DB::table('data_statistical')
            ->where('dast_shop_id', 1)
            ->where('dast_create_time', '>=', $time)
            ->where('dast_waon_class', 4)
            ->where('dast_ord_delete', 1)
            ->where('dast_order_type', '<>', 3)
            ->update($edit_data);
        dump($res2);

        // 出库类型为0的数据调整
        $find_data = DB::table('data_statistical')
            ->where('dast_shop_id', 1)
            ->where('dast_create_time', '>=', $time)
            ->where('dast_orcl_shipment_party', 0)
            ->where('dast_ord_delete', 1)
            ->where('dast_order_type', '<>', 3)
            ->select('dast_id', 'dast_ord_id', 'dast_order_number', 'dast_type')
            ->get()->toArray();
        // dump($find_data);
        $res3 = DB::table('data_statistical')
            ->where('dast_shop_id', 1)
            ->where('dast_create_time', '>=', $time)
            ->where('dast_orcl_shipment_party', 0)
            ->where('dast_ord_delete', 1)
            ->where('dast_order_type', '<>', 3)
            ->where('dast_type', 3)
            ->update(['dast_orcl_shipment_party'=>1]);
        dump($res3);

        // 有代收订单的数据调整
        $find_data = DB::table('data_statistical as ds')
            ->leftjoin('order as o', 'o.ord_id', '=', 'ds.dast_ord_id')
            ->where('dast_shop_id', 1)
            ->where('dast_create_time', '>=', $time)
            ->where('dast_ord_delete', 1)
            ->where('dast_order_type', '<>', 3)
            ->where('ord_collection_bill', 2)
            ->select('dast_id', 'dast_ord_id', 'dast_order_number', 'dast_type')
            ->get()->toArray();
        // dump($find_data);
        $res4 = DB::table('data_statistical as ds')
            ->leftjoin('order as o', 'o.ord_id', '=', 'ds.dast_ord_id')
            ->where('dast_shop_id', 1)
            ->where('dast_create_time', '>=', $time)
            ->where('dast_ord_delete', 1)
            ->where('dast_order_type', '<>', 3)
            ->where('ord_collection_bill', 2)
            ->update($edit_data);
        dump($res4);

        // 不是退货单，选择旧货仓类型商品，商品订单金额为0的不统计成本利润，其他情况统计
        $find_data = DB::table('data_statistical')
            ->where('dast_shop_id', 1)
            ->where('dast_create_time', '>=', $time)
            ->where('dast_service_type', '<>', 4)
            ->where('dast_waon_class', 3)
            ->where('dast_ord_delete', 1)
            ->where('dast_goo_price', 0)
            ->where('dast_order_type', '<>', 3)
            ->select('dast_id', 'dast_ord_id', 'dast_order_number', 'dast_type')
            ->get()->toArray();
        // dump($find_data);
        $res5 = DB::table('data_statistical')
            ->where('dast_shop_id', 1)
            ->where('dast_create_time', '>=', $time)
            ->where('dast_service_type', '<>', 4)
            ->where('dast_waon_class', 3)
            ->where('dast_ord_delete', 1)
            ->where('dast_goo_price', 0)
            ->where('dast_order_type', '<>', 3)
            ->update($edit_data);
        dump($res5);
    }

    //账单列表部分结款的数据处理
    public function adjustBillPortion()
    {
        $find_data = DB::table('order_bill')
            ->where('orbi_shop_id', 1)
            ->whereIn('orbi_state', [1,5])
            ->where('orbi_receive_price', '>', 0)
            ->select('orbi_id', 'orbi_number', 'orbi_create_type', 'orbi_actual_price', 'orbi_receive_price')
            ->get()->toArray();
        $more_data = [];
        $not_more_data = [];
        foreach ($find_data as $key => $value) {
            $find_more_data = DB::table('money_record as mr')
                ->leftjoin('accounting_settlement as ac', 'mr.more_acset_id', '=', 'ac.acset_id')
                ->where('more_orbi_id', $value->orbi_id)
                ->select('more_orbi_id', 'more_acset_id', 'more_this_settle_price', 'more_zero_price', 'acset_number', 'acset_adm_id', 'acset_type')
                ->get()->toArray();
            if ($find_more_data) {
                $temp_data = [];
                foreach ($find_more_data as $more_key => $more_value) {
                    $temp_more_data = (array)$more_value;
                    $temp_more_data['orbi'] = (array)$value;
                    $temp_data[] = $temp_more_data;
                    unset($temp_more_data);
                }
                $more_data[] = $temp_data;
                unset($temp_data);
            } else {
                $not_more_data[] = (array)$value;
            }
        }

        // 没有批量结款的账单数据
        foreach ($not_more_data as $key => $value) {
            $find_acset_data = DB::table('accounting_settlement')
                ->where('acset_original_id', $value['orbi_id'])
                ->where('acset_original_number', $value['orbi_number'])
                ->select('acset_id', 'acset_number', 'acset_adm_id', 'acset_type')
                ->first();

            // 新增账单确认金额数据
            $sere_data['sere_adm_cid'] = 1;
            $sere_data['sere_shop_id'] = 1;
            $sere_data['sere_adm_id'] = $find_acset_data->acset_adm_id;
            $sere_data['sere_acset_id'] = $find_acset_data->acset_id;
            $sere_data['sere_acset_number'] = $find_acset_data->acset_number;
            $sere_data['sere_acset_type'] = $find_acset_data->acset_type;
            $sere_data['sere_original_id'] = $value['orbi_id'];
            $sere_data['sere_original_number'] = $value['orbi_number'];
            $sere_data['sere_actual_settle_price'] = $value['orbi_receive_price'];//当前确认已结金额
            $sere_res = DB::table('settlement_receivable')->insert($sere_data);
            unset($sere_data);
        }

        // 批量结款的账单数据
        foreach ($more_data as $more_key => $more_value) {
            foreach ($more_value as $key => $value) {
                // dump($value);
                if ($value['acset_type'] == 25) {
                    // orbi_create_type 账单生成类型1订单账单2速电同步生成3工单账单4期初账单5采购账单
                    if ($value['orbi']['orbi_create_type'] == 1 || $value['orbi']['orbi_create_type'] == 2) {
                        $acset_type = 2;//订单账单
                    } elseif ($value['orbi']['orbi_create_type'] == 3) {
                        $acset_type = 3;//工单账单
                    } elseif ($value['orbi']['orbi_create_type'] == 4) {
                        $acset_type = 26;//期初账单
                    } elseif ($value['orbi']['orbi_create_type'] == 5) {
                        $acset_type = 4;//采购账单
                    }
                } else {
                    $acset_type = $value['acset_type'];
                }
                // 新增账单确认金额数据
                $sere_data['sere_adm_cid'] = 1;
                $sere_data['sere_shop_id'] = 1;
                $sere_data['sere_adm_id'] = $value['acset_adm_id'];
                $sere_data['sere_acset_id'] = $value['more_acset_id'];
                $sere_data['sere_acset_number'] = $value['acset_number'];
                $sere_data['sere_acset_type'] = $acset_type;
                $sere_data['sere_original_id'] = $value['orbi']['orbi_id'];
                $sere_data['sere_original_number'] = $value['orbi']['orbi_number'];
                $sere_data['sere_actual_settle_price'] = $value['more_this_settle_price'];//当前确认已结金额
                // dump($sere_data);
                $sere_res = DB::table('settlement_receivable')->insert($sere_data);
                unset($sere_data);
            }
        }
        echo 'success';
        die;
    }

    //统计调整进销存盘库单有期初金额有入库金额的数据
    public function entersBeginning()
    {
        ignore_user_abort();
        set_time_limit(0);
        $ware_id = [150,151,152,153,154,155,156];
        $find_data = DB::table('enters_sells_saves')
                ->where('ense_shop_id', 1)
                // ->whereIn('ense_goo_warehouse', $ware_id)
                ->whereRaw('`ense_new_inventory` = `ense_in_num`')
                ->where('ense_new_inventory', '>', 0)
                ->where('ense_in_num', '>', 0)
                ->where('ense_order_number', 'like', 'P%')
                ->select('ense_id', 'ense_goo_id', 'ense_goo_name', 'ense_goo_number', 'ense_goo_warehouse', 'ense_goo_waretype', 'ense_order_number', 'ense_new_inventory', 'ense_in_num')
                // ->groupBy('ense_order_number')
                ->get()->toArray();
        $ense_data = [];
        $initial_ense_data = [];//期初盘库数据
        $ense_order_number = [];
        foreach ($find_data as $key => $value) {
            // 判断是否是期初盘库
            $find_ense_id = DB::table('enters_sells_saves')
                ->where('ense_shop_id', 1)
                ->where('ense_goo_warehouse', $value->ense_goo_warehouse)
                ->where('ense_goo_waretype', $value->ense_goo_waretype)
                ->where('ense_goo_number', $value->ense_goo_number)
                ->where('ense_goo_id', $value->ense_goo_id)
                ->where('ense_id', '<', $value->ense_id)
                ->value('ense_id');
            if (!empty($find_ense_id)) {
                $ense_data[] = $value;
            } else {
                $ense_order_number[] = $value->ense_order_number;

                // $update_data['ense_in_num'] = 0;
                // $update_data['ense_in_price'] = 0;
                // $update_data['ense_in_amount'] = 0;
                // $res = DB::table('enters_sells_saves')
                //     ->where('ense_id', $value->ense_id)
                //     ->update($update_data);
                // unset($update_data);
                $initial_ense_data[] = $value;
            }
        }
        $ense_order_number = array_unique($ense_order_number);
        dump($ense_order_number);
        dump($ense_data);
        dump($initial_ense_data);
        // dump($find_data);
        die;
    }

    // 同步商品数据到供应链
    public function goodstongbu()
    {
        ignore_user_abort();
        set_time_limit(0);
        $goods_data = DB::table('goods')
            ->where('goo_type', 1)
            ->where('goo_class', 2)
            ->where('goo_delete', 1)
            ->get()->toArray();
        $goods_data = json_decode(json_encode($goods_data, true), true);
        foreach ($goods_data as $key => $value) {
            $add_data['goo_cid'] = 1;
            $add_data['goo_ditc_id'] = 0;
            $scm_goo_bra_name = DB::connection('mysql_scm')->table('brand')
                ->where('bra_name', $value['goo_bra_name'])
                ->select('bra_id', 'bra_name')
                ->first();
            $goo_brse_name = DB::table('brand_serie')
                ->where('brse_id', $value['goo_brse_id'])
                ->select('brse_id', 'brse_name')
                ->first();
            if (empty($goo_brse_name)) {
                continue;
            }
            if ($scm_goo_bra_name) {
                $add_data['goo_bra_name'] = $value['goo_bra_name'];
                $add_data['goo_bra_id'] = $scm_goo_bra_name->bra_id;
                if (empty($goo_brse_name->brse_name)) {
                    $scm_goo_brse_name->brse_name = 0;
                } else {
                    $scm_goo_brse_name = DB::connection('mysql_scm')->table('brand_serie')
                        ->where('brse_name', $goo_brse_name->brse_name)
                        ->where('brse_bra_id', $scm_goo_bra_name->bra_id)
                        ->select('brse_id', 'brse_name')
                        ->first();
                }
                if ($scm_goo_brse_name) {
                    $add_data['goo_brse_id'] = $scm_goo_brse_name->brse_id;
                    $add_data['goo_brse_name'] = $scm_goo_brse_name->brse_name;
                } else {
                    $add_brse_data['brse_cid'] = 1;
                    $add_brse_data['brse_bra_id'] = $scm_goo_bra_name->bra_id;
                    $add_brse_data['brse_name'] = $goo_brse_name->brse_name;
                    $add_brse_data['brse_goods_number'] = 0;
                    $add_brse_data['brse_state'] = 1;
                    $add_brse_data['brse_delete'] = 1;
                    $add_brse_data['brse_class'] = 2;
                    $brse_res = DB::connection('mysql_scm')->table('brand_serie')->insertGetId($add_brse_data);
                    $add_data['goo_brse_id'] = $brse_res;
                    $add_data['goo_brse_name'] = $goo_brse_name->brse_name;
                }
            } else {
                $add_bra_data['bra_cid'] = 1;
                $add_bra_data['bra_name'] = $value['goo_bra_name'];
                $add_bra_data['bra_goods_quantity'] = 0;
                $add_bra_data['bra_state'] = 1;
                $add_bra_data['bra_delete'] = 1;
                $add_bra_data['bra_class'] = 2;
                $add_bra_res = DB::connection('mysql_scm')->table('brand')->insertGetId($add_bra_data);
                if (empty($goo_brse_name->brse_name)) {
                    $scm_goo_brse_name->brse_name = 0;
                }
                $add_data['goo_bra_name'] = $value['goo_bra_name'];
                $add_data['goo_bra_id'] = $add_bra_res;
                $add_brse_data['brse_cid'] = 1;
                $add_brse_data['brse_bra_id'] = $add_bra_res;
                $add_brse_data['brse_name'] = $goo_brse_name->brse_name;
                $add_brse_data['brse_goods_number'] = 0;
                $add_brse_data['brse_state'] = 1;
                $add_brse_data['brse_delete'] = 1;
                $add_brse_data['brse_class'] = 2;
                $brse_res = DB::connection('mysql_scm')->table('brand_serie')->insertGetId($add_brse_data);

                $add_data['goo_brse_id'] = $brse_res;
                $add_data['goo_brse_name'] = $goo_brse_name->brse_name;
            }
            $scm_goo_cate_name = DB::connection('mysql_scm')->table('category')
                ->where('cate_name', $value['goo_cate_name'])
                ->select('cate_name', 'cate_id')
                ->first();
            $goo_cate_name = DB::table('category')
                ->where('cate_id', $value['goo_cate_id'])
                ->select('cate_name', 'cate_id', 'cate_rank')
                ->first();
            if ($scm_goo_cate_name) {
                $add_data['goo_cate_id'] = $scm_goo_cate_name->cate_id;
                $add_data['goo_cate_name'] =  $scm_goo_cate_name->cate_name;
            } else {
                $add_cate_data['cate_cid'] = 1;
                $add_cate_data['cate_rank'] = $goo_cate_name->cate_rank;
                $add_cate_data['cate_name'] = $value['goo_cate_name'];
                $add_cate_data['cate_goods_quantity'] = 0;
                $add_cate_data['cate_state'] = 1;
                $cate_res = DB::connection('mysql_scm')->table('category')->insertGetId($add_cate_data);
                $add_data['goo_cate_id'] = $cate_res;
                $add_data['goo_cate_name'] =  $value['goo_cate_name'];
            }
            // 查询供应链有没有该商品，有就跳过，没有新增
            $find_goods_data = DB::connection('mysql_scm')->table('goods')
                ->where('goo_goods_encode', $value['goo_goods_encode'])
                ->first();
            if (isset($find_goods_data)) {
                continue;
            } else {
                $add_data['goo_second_cate_id'] = 0;
                $add_data['goo_second_cate_name'] = 0;
                $add_data['goo_name'] = $value['goo_name'];
                $add_data['goo_goods_encode'] = $value['goo_goods_encode'];
                $add_data['goo_purchase_price'] = $value['goo_purchase_price'];
                $add_data['goo_wholesale_price'] = $value['goo_wholesale_price'];
                $add_data['goo_replenishment'] = 1;
                $add_data['goo_shipping_fee'] = 0;
                $add_data['goo_install_fee'] = 0;
                $add_data['goo_warranty_fee'] = 0;
                $add_data['goo_state'] = $value['goo_state'];
                $add_data['goo_class'] = $value['goo_class'];
                $add_data['goo_type'] = $value['goo_type'];
                $add_res = DB::connection('mysql_scm')->table('goods')->insert($add_data);
            }
        }
        echo 999666;
    }

    //统计账单已结款，结款明细已确认，应收应付未确认的
    public function getState()
    {
        ignore_user_abort();
        set_time_limit(0);
        $list_data = DB::table('order_bill')
                ->where('orbi_shop_id', 1)
                ->where('orbi_state', 2)
                ->select('orbi_id', 'orbi_number', 'orbi_payment_time', 'orbi_create_time')
                ->get()->toArray();
        $orbi_number = array_column($list_data, 'orbi_number');
        $data = DB::table('receivable_credit')
            ->where('recr_shop_id', 1)
            ->whereIn('recr_original_number', $orbi_number)
            ->where('recr_state', 1)
            ->get()->toArray();
        dump($data);
    }

    // 系统商品编码替换
    private function systemGoodsReplace()
    {
        ignore_user_abort();
        set_time_limit(0);
        $find_goods_data = DB::table('goods')
            ->where('goo_cid', 0)
            ->where('goo_shop_id', 0)
            ->select('goo_id', 'goo_goods_encode')
            ->get()->toArray();
        foreach ($find_goods_data as $key => $value) {
            // 商品表，检索编码调整
            // $update_data['goo_goods_encode'] = 'X'.$value->goo_goods_encode;
            // $res = DB::table('goods')
            //     ->where('goo_id', $value->goo_id)
            //     ->update($update_data);
            // unset($update_data);

            // 订单商品表，检索编码调整
            // $update_data['orgo_goo_goods_encode'] = 'X'.$value->goo_goods_encode;
            // $res = DB::table('order_goods')
            //     ->where('orgo_goo_id', $value->goo_id)
            //     ->update($update_data);
            // unset($update_data);

            // // 工单商品表，检索编码调整
            // $update_data['wogo_goo_goods_encode'] = 'X'.$value->goo_goods_encode;
            // $res = DB::table('work_good')
            //     ->where('wogo_goo_id', $value->goo_id)
            //     ->update($update_data);
            // unset($update_data);

            // // 发货单商品表，检索编码调整
            // $update_data['digo_goo_goods_encode'] = 'X'.$value->goo_goods_encode;
            // $res = DB::table('dispatch_goods')
            //     ->where('digo_goo_id', $value->goo_id)
            //     ->update($update_data);
            // unset($update_data);

            // // 进销存，检索编码调整
            // $update_data['ense_goo_number'] = 'X'.$value->goo_goods_encode;
            // $res = DB::table('enters_sells_saves')
            //     ->where('ense_goo_id', $value->goo_id)
            //     ->update($update_data);
            // unset($update_data);

            // // 旧货回收商品表，检索编码调整
            // $update_data['jugo_goo_goods_encode'] = 'X'.$value->goo_goods_encode;
            // $res = DB::table('junk_goods')
            //     ->where('jugo_goo_id', $value->goo_id)
            //     ->update($update_data);
            // unset($update_data);

            // // 退换入库商品表，检索编码调整
            // $update_data['rego_goo_goods_encode'] = 'X'.$value->goo_goods_encode;
            // $res = DB::table('recede_goods')
            //     ->where('rego_goo_id', $value->goo_id)
            //     ->update($update_data);
            // unset($update_data);

            // // 采购入库商品表，检索编码调整
            // $update_data['goods_number'] = 'X'.$value->goo_goods_encode;
            // $res = DB::table('storage_goods')
            //     ->where('goods_id', $value->goo_id)
            //     ->update($update_data);
            // unset($update_data);
        }
        echo 'success';
    }

    // 订单的结算金额与订单商品金额计算不一致数据统计
    private function diffOrderGoodsPirce()
    {
        set_time_limit(0);
        $find_order_data = DB::table('order as o')
            ->leftjoin('order_client as oc', 'oc.orcl_ord_id', '=', 'o.ord_id')
            ->where('ord_superior_shop_id', 1)
            ->where('ord_shop_id', 1)
            ->where('ord_delete', 1)
            ->where('ord_collection_bill', 1)
            ->where('ord_create_time', '>', '2021-01-01')
            // ->whereIn('ord_service_type', [1,7])
            ->select('ord_id', 'ord_order_number', 'ord_goods_quantity', 'ord_shop_id', 'ord_type', 'ord_actual_price', 'ord_order_price', 'ord_collection_price', 'orcl_shipment_party', 'orcl_rescue_service_price', 'ord_service_type')
            ->get()->toArray();
        $diff_order = [];
        $diff_key = 0;
        foreach ($find_order_data as $key => $value) {
            if ($value->orcl_shipment_party == 4) {
                continue;
            }
            // 查询订单商品数据
            $find_goods_data = DB::table('order_goods')
                ->where('orgo_ord_id', $value->ord_id)
                ->where('orgo_state', '<>', 2)
                ->select('orgo_goo_id', 'orgo_goo_goods_encode', 'orgo_state', 'orgo_goo_price', 'orgo_goo_quantity')
                ->get()->toArray();
            $goo_all_price = 0;
            if ($find_order_data) {
                $find_goods_data = json_decode(json_encode($find_goods_data, true), true);
                foreach ($find_goods_data as $orgo_key => $orgo_value) {
                    // orgo_state 商品状态1.正常 2.删除3.回收的商品4.换货商品5.赠品商品6.备用电池7.临时商品8.旧货商品
                    // 换货商品金额处理
                    if ($orgo_value['orgo_state'] == 1 || $orgo_value['orgo_state'] == 5) {
                        // 订单商品
                        $goo_all_price += $orgo_value['orgo_goo_price'] * $orgo_value['orgo_goo_quantity'];
                    // $goo_assign_all_price += $orgo_value['goo_assign_price'] * $orgo_value['goo_quantity'];

                        // $goo_all_quantity += $orgo_value['goo_quantity']; //商品总数量
                        // $goo_collection_price += $orgo_value['goo_collection_price'];
                    } elseif ($orgo_value['orgo_state'] == 3) {//回收商品
                        $goo_all_price -= $orgo_value['orgo_goo_price'] * $orgo_value['orgo_goo_quantity'];
                    } elseif ($orgo_value['orgo_state'] == 4) {//换货商品
                        // return ['code'=>500, 'msg'=>'success', 'data'=>'换货单生成订单失败'];
                    } elseif ($orgo_value['orgo_state'] == 6) {//备用电池
                        // if ($orgo_value['goo_inventory'] != '1' && $request['ord_service_type'] != 4) {
                        //     return ['code'=>500, 'msg'=>'success', 'data'=>'备用电池请选择备用品！'];
                        // }
                        // $goo_all_quantity += $orgo_value['goo_quantity']; //商品总数量
                        $goo_all_price += $orgo_value['orgo_goo_price'] * $orgo_value['orgo_goo_quantity'];
                    // $goo_collection_price += $orgo_value['goo_collection_price'];
                    } elseif ($orgo_value['orgo_state'] == 7) {//临时商品
                        $goo_all_price += $orgo_value['orgo_goo_price'] * $orgo_value['orgo_goo_quantity'];
                    // $goo_all_quantity += $orgo_value['orgo_goo_quantity']; //商品总数量
                    } elseif ($orgo_value['orgo_state'] == 8) {//旧货商品
                        $goo_all_price += $orgo_value['orgo_goo_price'] * $orgo_value['orgo_goo_quantity'];
                        // $goo_assign_all_price += $orgo_value['goo_assign_price'] * $orgo_value['orgo_goo_quantity'];
                        // $goo_all_quantity += $orgo_value['orgo_goo_quantity']; //商品总数量
                        // $goo_collection_price += $orgo_value['goo_collection_price'];//商品代收总金额
                    }
                }
            }
            $goo_all_price += $value->orcl_rescue_service_price;
            if ($value->ord_service_type == 4) {
                $goo_all_price = '-'.$goo_all_price;
            }
            // 订单金额计算金额不一致的
            if ($goo_all_price != $value->ord_actual_price) {
                $diff_order[$diff_key]['order'] = (array)$value;
                $diff_order[$diff_key]['goo_all_price'] = $goo_all_price;
                // $diff_order[$diff_key]['work'] = $find_wor_data;
                $diff_key++;
                // dump($diff_order);die;
            }
            unset($value);
            unset($find_goods_data);
        }
        dump($diff_order);
    }

    //获取仓库中已经删除的商品
    public function getdelGoods()
    {
        ignore_user_abort();
        set_time_limit(0);
        $ware_id = DB::table('warehouse')
            ->whereIn('ware_shop_id', [1,2])
            ->where('ware_type', '<>', 2)
            ->select('ware_id', 'ware_shop_id', 'ware_type', 'ware_name')
            // ->offset(0)
            // ->limit(1)
            ->get()->toArray();
        $ware_id = array_column($ware_id, null, 'ware_id');
        $all_goods = 0;
        foreach ($ware_id as $kk => $vv) {
            $find_data = DB::table('warehouse_goods as w')
                ->leftjoin('goods as g', 'w.wago_goo_id', '=', 'g.goo_id')
                ->where('wago_ware_id', $vv->ware_id)
                ->where('goo_delete', 2)
                ->where(function ($query) {
                    $query->where('wago_stock_number', '>', 0)
                        ->orWhere('wago_lock_quantity', '>', 0)
                        ->orWhere('wago_priority_stock_number', '>', 0)
                        ->orWhere('wago_priority_lock_quantity', '>', 0)
                        ->orWhere('wago_unchecked_stock_number', '>', 0);
                })
                ->select('wago_id', 'wago_class', 'goo_id', 'wago_stock_number', 'wago_lock_quantity', 'wago_priority_stock_number', 'wago_priority_lock_quantity', 'wago_unchecked_stock_number', 'goo_name', 'goo_goods_encode', 'goo_delete')
                ->get()->toArray();
            if ($find_data) {
                foreach ($find_data as $wago_key => $wago_value) {
                    $test_data['wago_stock_number'] = $wago_value->wago_stock_number;
                    $test_data['wago_lock_quantity'] = $wago_value->wago_lock_quantity;
                    $test_data['wago_priority_stock_number'] = $wago_value->wago_priority_stock_number;
                    $test_data['wago_priority_lock_quantity'] = $wago_value->wago_priority_lock_quantity;
                    $test_data['wago_unchecked_stock_number'] = $wago_value->wago_unchecked_stock_number;
                    $test_data['wago_id'] = $wago_value->wago_id;
                    $test_data['wago_class'] = $wago_value->wago_class;
                    $test_data['wago_goo_id'] = $wago_value->goo_id;
                    $test_data['wago_goo_encode'] = $wago_value->goo_goods_encode;
                    $test_data['wago_goo_name'] = $wago_value->goo_name;
                    $test_data['wago_ware_id'] = $vv->ware_id;
                    $test_data['wago_ware_name'] = $vv->ware_name;
                    $test_data['wago_shop_id'] = $vv->ware_shop_id;
                    // dump($test_data);
                    $res = DB::table('warehouse_goods_delete_test')->insert($test_data);
                    unset($test_data);
                }
                dump($find_data);
            }
        }
        echo 'succes';
    }
    
    // 统计库存数量
    public function freightGoodsKucun()
    {
        ignore_user_abort();
        set_time_limit(0);
        $ware_id = DB::table('warehouse')
            ->where('ware_type', 1)
            ->select('ware_id', 'ware_type')
            // ->offset(0)
            // ->limit(1)
            ->get()->toArray();
        $ware_id = array_column($ware_id, null, 'ware_id');

        foreach ($ware_id as $kk => $vv) {
            $wafr_data = DB::table('warehouse_freight')
                ->where('wafr_ware_id', $vv->ware_id)
                ->where('wafr_delete', 1)
                ->select('wafr_id', 'wafr_name')
                ->get()->toArray();
            foreach ($wafr_data as $key => $value) {
                $find_wafg_data = DB::table('warehouse_freight_goods')
                    ->where('wafg_wafr_id', $value->wafr_id)
                    ->select('wafg_wafr_id', 'wafg_class', 'wafg_stock_number', 'wafg_lock_quantity', 'wafg_priority_stock_number', 'wafg_priority_lock_quantity', 'wafg_unchecked_stock_number')
                    ->get()->toArray();
                $wafg_stock_number = 0; //良品库存数量
                $wafg_lock_quantity = 0; //良品锁定数量
                $wafg_priority_stock_number = 0; //优先库存数量
                $wafg_priority_lock_quantity = 0; //优先锁定数量
                $wafg_unchecked_stock_number = 0; //待检测数量
                foreach ($find_wafg_data as $kkk => $vvv) {
                    $wafg_stock_number += $vvv->wafg_stock_number;
                    $wafg_lock_quantity += $vvv->wafg_lock_quantity;
                    $wafg_priority_stock_number += $vvv->wafg_priority_stock_number;
                    $wafg_priority_lock_quantity += $vvv->wafg_priority_lock_quantity;
                    $wafg_unchecked_stock_number += $vvv->wafg_unchecked_stock_number;
                }
                unset($find_wafg_data);
                dump($value->wafr_id . '-总量良品库存：' . $wafg_stock_number);
                dump($value->wafr_id . '-总量良品锁定：' . $wafg_lock_quantity);
                dump($value->wafr_id . '-总量优先库存：' . $wafg_priority_stock_number);
                dump($value->wafr_id . '-总量优先锁定：' . $wafg_priority_lock_quantity);
                dump($value->wafr_id . '-待检测：' . $wafg_unchecked_stock_number);
                $updata_data['wafr_all_stock'] = $wafg_stock_number; //良品总库存数量
                $updata_data['wafr_lock_quantity'] = $wafg_lock_quantity; //良品锁定总数量
                $updata_data['wafr_priority_all_stock'] = $wafg_priority_stock_number; //优先总库存
                $updata_data['wafr_priority_lock_quantity'] = $wafg_priority_lock_quantity; //优先锁定数量
                $updata_data['wafr_unchecked_all_stock'] = $wafg_unchecked_stock_number; //待检测总库存
                $updata_data['wafr_update_time'] = date('Y-m-d H:i:s');

                $res = DB::table('warehouse_freight')
                    ->where('wafr_id', $value->wafr_id)
                    ->update($updata_data);
                unset($updata_data);
            }
            unset($wafr_data);
        }
        echo 'success';
    }

    public function goodsCount()
    {
        ignore_user_abort();
        set_time_limit(0);
        $shop_id = [1,2,26,42];
        foreach ($shop_id as $key => $value) {
            $this->goodsBrandCount($value);
        }
        echo 'success';
    }

    // 商品品牌、系列、品类数量统计
    public function goodsBrandCount($shop_id)
    {
        // $shop_id = 42;
        $find_bra_data = DB::table('goods')
            ->where('goo_shop_id', $shop_id)
            // ->select('goo_shop_id', 'goo_bra_id',)
            // ->select(DB::raw('sum(sepr_money) as sepr_money,count(wor_id) as achieve_amount'))
            ->select(DB::raw('goo_bra_id,goo_shop_id,count(goo_bra_id) as count'))
            ->groupBy('goo_bra_id')
            ->get()->toArray();
        foreach ($find_bra_data as $key => $value) {
            $find_brco_id = DB::table('brand_correlation')
                ->where('brco_shop_id', $value->goo_shop_id)
                ->where('brco_bra_id', $value->goo_bra_id)
                ->value('brco_id');
            if ($find_brco_id) {
                $updata_data['brco_goods_number'] = $value->count;
                $res = DB::table('brand_correlation')
                    ->where('brco_shop_id', $value->goo_shop_id)
                    ->where('brco_id', $find_brco_id)
                    ->update($updata_data);
                unset($updata_data);
            }
        }
        // dump($find_bra_data);

        $find_bra_data = DB::table('goods')
            ->where('goo_shop_id', $shop_id)
            ->select(DB::raw('goo_brse_id,goo_shop_id,count(goo_brse_id) as count'))
            ->groupBy('goo_brse_id')
            ->get()->toArray();
        foreach ($find_bra_data as $key => $value) {
            $find_brco_id = DB::table('brand_serie_correlation')
                ->where('brsc_shop_id', $value->goo_shop_id)
                ->where('brsc_brse_id', $value->goo_brse_id)
                ->value('brsc_id');
            if ($find_brco_id) {
                $updata_data['brsc_goods_number'] = $value->count;
                $res = DB::table('brand_serie_correlation')
                    ->where('brsc_shop_id', $value->goo_shop_id)
                    ->where('brsc_brse_id', $find_brco_id)
                    ->update($updata_data);
                unset($updata_data);
            }
        }

        $find_bra_data = DB::table('goods')
            ->where('goo_shop_id', $shop_id)
            ->select(DB::raw('goo_cate_id,goo_shop_id,count(goo_cate_id) as count'))
            ->groupBy('goo_cate_id')
            ->get()->toArray();
        foreach ($find_bra_data as $key => $value) {
            $find_brco_id = DB::table('category_correlation')
                ->where('caco_shop_id', $value->goo_shop_id)
                ->where('caco_cate_id', $value->goo_cate_id)
                ->value('caco_id');
            if ($find_brco_id) {
                $updata_data['caco_goods_number'] = $value->count;
                $res = DB::table('category_correlation')
                    ->where('caco_shop_id', $value->goo_shop_id)
                    ->where('caco_cate_id', $find_brco_id)
                    ->update($updata_data);
                unset($updata_data);
            }
        }
        dump($shop_id);
    }

    // 新旧编码商品数据处理
    public function newOldGoodsDispose()
    {
        ignore_user_abort();
        set_time_limit(0);
        /*
            1、仓库里有旧编码数据，没有对应的新编码数据的可以直接把旧编码改成新编码
            2、仓库里有旧编码数据，有对应的新编码数据不能直接改
            2.1、判断旧编码是否有库存，旧编码在仓库内没有库存的可以直接把旧编码从仓库内删除
            2.2、旧编码在仓库内有库存的需要用盘库单盘库
         */
        $find_data = DB::table('warehouse_goods_old_new_test')
            ->select('id', 'wago_ware_id', 'wago_ware_name', 'wago_class', 'wago_id', 'wago_goo_id', 'wago_goo_name', 'wago_goo_encode', 'new_wago_id', 'new_wago_goo_id', 'new_wago_goo_name', 'new_wago_goo_encode', 'new_state')
            ->get()->toArray();
        $shop_id = 1;
        // dump($find_data);die;
        $diff_stock_data = [];
        $delete_data = [];
        foreach ($find_data as $key => $value) {
            // 1、仓库里有旧编码数据，没有对应的新编码数据的可以直接把旧编码改成新编码
            if ($value->new_state == 1) {
                // 1.1仓库商品表旧编码替换为新编码
                $update_data['wago_goo_id'] = $value->new_wago_goo_id;//新编码的商品id
                $res = DB::table('warehouse_goods')
                    ->where('wago_ware_id', $value->wago_ware_id)
                    ->where('wago_id', $value->wago_id)
                    ->update($update_data);
                unset($update_data);

                // 1.2仓位商品表旧编码替换为新编码
                $update_data['wafg_goo_id'] = $value->new_wago_goo_id;//新编码的商品id
                $res = DB::table('warehouse_freight_goods')
                    ->where('wafg_ware_id', $value->wago_ware_id)
                    ->where('wafg_wago_id', $value->wago_id)
                    ->update($update_data);
                unset($update_data);

                $update_data['new_deal_state'] = 1;//处理状态:0未处理1替换为新编码2有库存有新编码3无库存删除
                $res = DB::table('warehouse_goods_old_new_test')
                    ->where('id', $value->id)
                    ->update($update_data);
                unset($update_data);
            } else {
                // 2.1 判断旧编码是否有库存，旧编码在仓库内没有库存的可以直接把旧编码从仓库内删除
                $find_data = DB::table('warehouse_goods')
                    ->where('wago_ware_id', $value->wago_ware_id)
                    ->where('wago_id', $value->wago_id)
                    ->select('wago_stock_number', 'wago_lock_quantity', 'wago_priority_stock_number', 'wago_priority_lock_quantity', 'wago_unchecked_stock_number')
                    ->first();
                if ($find_data->wago_stock_number > 0 || $find_data->wago_lock_quantity > 0 || $find_data->wago_priority_lock_quantity > 0 || $find_data->wago_unchecked_stock_number > 0) {
                    // 旧编码有库存
                    $diff_stock_data[] = $value->wago_goo_encode;

                    $update_data['new_deal_state'] = 2;
                    $res = DB::table('warehouse_goods_old_new_test')
                        ->where('id', $value->id)
                        ->update($update_data);
                    unset($update_data);
                } else {
                    $res = DB::table('warehouse_goods')
                        ->where('wago_ware_id', $value->wago_ware_id)
                        ->where('wago_id', $value->wago_id)
                        ->delete();
                    $delete_data[] = $value->wago_goo_encode;

                    $update_data['new_deal_state'] = 3;
                    $res = DB::table('warehouse_goods_old_new_test')
                        ->where('id', $value->id)
                        ->update($update_data);
                    unset($update_data);
                }
            }
        }
        echo '有库存数量';
        dump($diff_stock_data);
        echo '删除的商品';
        dump($delete_data);
        echo '===========';
        die;
        echo 'success';
    }

    // 新旧编码商品数据替换
    public function newOldGoodsReplace()
    {
        ignore_user_abort();
        set_time_limit(0);
        $find_data = DB::table('warehouse_goods_old_new_test')
            ->where('new_deal_state', 1)
            ->select('wago_ware_id', 'wago_ware_name', 'wago_class', 'wago_id', 'wago_goo_id', 'wago_goo_name', 'wago_goo_encode', 'new_wago_id', 'new_wago_goo_id', 'new_wago_goo_name', 'new_wago_goo_encode')
            ->get()->toArray();
        $cid = 1;
        $shop_id = 1;
        $replace_data = [];
        $replace_goods = [];
        foreach ($find_data as $key => $value) {
            if (!in_array($value->wago_goo_encode, $replace_goods)) {
                $replace_data[] = $value;
                $replace_goods[] = $value->wago_goo_encode;
            }
        }
        dump($replace_data);
        foreach ($replace_data as $key => $value) {
            // 更改进销存查询商品表的商品id
            $edit_ense_data['ense_goo_id'] = $value->new_wago_goo_id;//商品id
            $edit_ense_data['ense_goo_name'] = $value->new_wago_goo_name;//商品名称
            $edit_ense_data['ense_goo_number'] = $value->new_wago_goo_encode;//检索编码
            $edit_ense_res = DB::table('enters_sells_saves')
                ->where('ense_shop_id', $shop_id)
                ->where('ense_goo_id', $value->wago_goo_id)
                ->update($edit_ense_data);
            unset($edit_ense_data);
            unset($edit_ense_res);

            // 更改商品流水记录商品表的商品id
            $edit_oude_data['oude_goo_id'] = $value->new_wago_goo_id;//商品id
            $edit_oude_res = DB::table('outin_details as oude')
                ->leftjoin('outin_record as oure', 'oure.oure_id', '=', 'oude.oude_oure_id')
                ->where('oure_cid', $cid)
                ->where('oure_shop_id', $shop_id)
                ->where('oude_goo_id', $value->wago_goo_id)
                ->update($edit_oude_data);
            unset($edit_oude_data);
            unset($edit_oude_res);

            // 更改销售统计商品表的商品id
            $edit_dast_data['dast_actual_goo_id'] = $value->new_wago_goo_id;//实际出库商品id
            $edit_dast_data['dast_goo_id'] = $value->new_wago_goo_id;//商品id
            $edit_dast_res = DB::table('data_statistical')
                ->where('dast_cid', $cid)
                ->where('dast_shop_id', $shop_id)
                ->where('dast_goo_id', $value->wago_goo_id)
                ->update($edit_dast_data);
            unset($edit_dast_data);
            unset($edit_dast_res);

            // 更改发货商品表的商品id
            $edit_digo_data['digo_goo_id'] = $value->new_wago_goo_id;//商品id
            $edit_digo_data['digo_goo_name'] = $value->new_wago_goo_name;//商品名称
            $edit_digo_data['digo_goo_goods_encode'] = $value->new_wago_goo_encode;//检索编码
            $edit_digo_res = DB::table('dispatch_goods as digo')
                ->leftjoin('dispatch_bill as dibi', 'dibi.dego_id', '=', 'digo.digo_dego_id')
                ->where('dego_cid', $cid)
                ->where('dego_shop_id', $shop_id)
                ->where('digo_goo_id', $value->wago_goo_id)
                ->update($edit_digo_data);
            unset($edit_digo_data);
            unset($edit_digo_res);

            // 更改调拨单商品表的商品id
            $edit_trog_data['trog_goo_id'] = $value->new_wago_goo_id;//商品id
            $edit_trog_res = DB::table('transferring_order_goods as trog')
                ->leftjoin('transferring_order as tror', 'tror.tror_id', '=', 'trog.trog_tror_id')
                ->where('tror_cid', $cid)
                ->where('tror_shop_id', $shop_id)
                ->where('trog_goo_id', $value->wago_goo_id)
                ->update($edit_trog_data);
            unset($edit_trog_data);
            unset($edit_trog_res);

            // 更改盘库单商品表的商品id
            $edit_stgo_data['stgo_goo_id'] = $value->new_wago_goo_id;//商品id
            $edit_stgo_res = DB::table('stocktake_goods as stgo')
                ->leftjoin('stocktake as stoc', 'stoc.stoc_id', '=', 'stgo.stgo_stoc_id')
                ->where('stoc_cid', $cid)
                ->where('stoc_shop_id', $shop_id)
                ->where('stgo_goo_id', $value->wago_goo_id)
                ->update($edit_stgo_data);
            unset($edit_stgo_data);
            unset($edit_stgo_res);

            // 更改旧货回收商品表的商品id
            $edit_jugo_data['jugo_goo_id'] = $value->new_wago_goo_id;//商品id
            $edit_jugo_data['jugo_goo_name'] = $value->new_wago_goo_name;//商品名称
            $edit_jugo_data['jugo_goo_goods_encode'] = $value->new_wago_goo_encode;//检索编码
            $edit_jugo_res = DB::table('junk_goods as jugo')
                ->leftjoin('junk_recycle as jur', 'jur.jur_id', '=', 'jugo.jugo_jur_id')
                ->where('jur_cid', $cid)
                ->where('jur_shop_id', $shop_id)
                ->where('jugo_goo_id', $value->wago_goo_id)
                ->update($edit_jugo_data);
            unset($edit_jugo_data);
            unset($edit_jugo_res);

            // 更改退货入库商品表的商品id
            $edit_rego_data['rego_goo_id'] = $value->new_wago_goo_id;//商品id
            $edit_rego_data['rego_goo_name'] = $value->new_wago_goo_name;//商品名称
            $edit_rego_data['rego_goo_goods_encode'] = $value->new_wago_goo_encode;//检索编码
            $edit_rego_res = DB::table('recede_goods as rego')
                ->leftjoin('recede_recycle as rec', 'rec.rec_id', '=', 'rego.rego_rec_id')
                ->where('rec_cid', $cid)
                ->where('rec_shop_id', $shop_id)
                ->where('rego_goo_id', $value->wago_goo_id)
                ->update($edit_rego_data);
            unset($edit_rego_data);
            unset($edit_rego_res);

            $edit_stgo_data['goods_id'] = $value->new_wago_goo_id;//商品id
            $edit_stgo_data['goods_number'] = $value->new_wago_goo_encode;//检索编码
            $edit_stgo_data['goods_name'] = $value->new_wago_goo_name;//商品名称
            $edit_stgo_res = DB::table('storage_goods')
                ->where('company_id', $cid)
                ->where('stgo_shop_id', $shop_id)
                ->where('goods_id', $value->wago_goo_id)
                ->update($edit_stgo_data);
            unset($edit_stgo_data);
            unset($edit_stgo_res);

            // 更改工单商品表的商品id
            $edit_wogo_data['wogo_actual_goo_id'] = $value->new_wago_goo_id;//实际出库商品id
            $edit_wogo_data['wogo_goo_id'] = $value->new_wago_goo_id;//商品id
            // $edit_wogo_data['wogo_wago_id'] = $value->new_wago_id;//仓库商品id
            $edit_wogo_data['wogo_goo_name'] = $value->new_wago_goo_name;//商品名称
            $edit_wogo_data['wogo_goo_goods_encode'] = $value->new_wago_goo_encode;//检索编码
            $edit_wogo_res = DB::table('work_good as wogo')
                ->leftjoin('work_order as wor', 'wor.wor_id', '=', 'wogo.wogo_wor_id')
                ->where('wor_cid', $cid)
                ->where('wor_shop_id', $shop_id)
                // ->where('wogo_ware_id', $value->wago_ware_id)
                ->where('wogo_goo_id', $value->wago_goo_id)
                ->update($edit_wogo_data);
            unset($edit_wogo_data);
            unset($edit_wogo_res);

            // 更改订单商品表的商品id
            $edit_orgo_data['orgo_actual_goo_id'] = $value->new_wago_goo_id;//实际出库商品id
            $edit_orgo_data['orgo_goo_id'] = $value->new_wago_goo_id;//商品id
            $edit_orgo_data['orgo_goo_name'] = $value->new_wago_goo_name;//商品名称
            $edit_orgo_data['orgo_goo_goods_encode'] = $value->new_wago_goo_encode;//检索编码
            $edit_orgo_res = DB::table('order_goods as orgo')
                ->leftjoin('order as ord', 'ord.ord_id', '=', 'orgo.orgo_ord_id')
                ->where('ord_cid', $cid)
                ->where('ord_shop_id', $shop_id)
                // ->where('orgo_ware_id', $value->wago_ware_id)
                ->where('orgo_goo_id', $value->wago_goo_id)
                ->update($edit_orgo_data);
            unset($edit_orgo_data);
            unset($edit_orgo_res);
        }
        echo 'success';
        die;
    }

    // 替换新编码
    public function replaceGoods(Request $request)
    {
        ignore_user_abort();
        set_time_limit(0);
        $find_adgt_data = DB::table('warehouse_goods_old_new_test')
            ->select('wago_ware_id', 'wago_ware_name', 'wago_class', 'wago_id', 'wago_goo_id', 'wago_goo_name', 'wago_goo_encode', 'new_wago_id', 'new_wago_goo_id', 'new_wago_goo_name', 'new_wago_goo_encode')
            ->get()->toArray();
        $cid = 1;
        $shop_id = 1;
        if ($request['type'] == 1) {//更改订单商品表的商品id
            foreach ($find_adgt_data as $key => $value) {
                if ($value->new_wago_id) {
                    // 有新编码的仓库商品id的先跳过
                    // $edit_orgo_data['orgo_wago_id'] = $value->new_wago_id;//仓库商品id
                    continue;
                }
                $edit_orgo_data['orgo_actual_goo_id'] = $value->new_wago_goo_id;//实际出库商品id
                $edit_orgo_data['orgo_goo_id'] = $value->new_wago_goo_id;//商品id
                $edit_orgo_data['orgo_goo_name'] = $value->new_wago_goo_name;//商品名称
                $edit_orgo_data['orgo_goo_goods_encode'] = $value->new_wago_goo_encode;//检索编码
                $edit_orgo_res = DB::table('order_goods as orgo')
                    ->leftjoin('order as ord', 'ord.ord_id', '=', 'orgo.orgo_ord_id')
                    ->where('ord_cid', $cid)
                    ->where('ord_shop_id', $shop_id)
                    ->where('orgo_ware_id', $value->wago_ware_id)
                    ->where('orgo_goo_id', $value->wago_goo_id)
                    ->update($edit_orgo_data);
                unset($edit_orgo_data);
                unset($edit_orgo_res);
            }
        } elseif ($request['type'] == 2) {//更改工单商品表的商品id
            foreach ($find_adgt_data as $key => $value) {
                $edit_wogo_data['wogo_actual_goo_id'] = $value->new_wago_goo_id;//实际出库商品id
                $edit_wogo_data['wogo_goo_id'] = $value->new_wago_goo_id;//商品id
                $edit_wogo_data['wogo_wago_id'] = $value->new_wago_id;//仓库商品id
                $edit_wogo_data['wogo_goo_name'] = $value->new_wago_goo_name;//商品名称
                $edit_wogo_data['wogo_goo_goods_encode'] = $value->new_wago_goo_encode;//检索编码
                $edit_wogo_res = DB::table('work_good as wogo')
                    ->leftjoin('work_order as wor', 'wor.wor_id', '=', 'wogo.wogo_wor_id')
                    ->where('wor_cid', $cid)
                    ->where('wor_shop_id', $shop_id)
                    ->where('wogo_ware_id', $value->wago_ware_id)
                    ->where('wogo_goo_id', $value->wago_goo_id)
                    ->update($edit_wogo_data);
                unset($edit_wogo_data);
                unset($edit_wogo_res);
            }
        } elseif ($request['type'] == 3) {//更改采购管理商品表的商品id
            foreach ($find_adgt_data as $key => $value) {
                $edit_stgo_data['goods_id'] = $value->new_wago_goo_id;//商品id
                $edit_stgo_data['goods_number'] = $value->new_wago_goo_encode;//检索编码
                $edit_stgo_data['goods_name'] = $value->new_wago_goo_name;//商品名称
                $edit_stgo_res = DB::table('storage_goods')
                    ->where('company_id', $cid)
                    ->where('stgo_shop_id', $shop_id)
                    ->where('goods_id', $value->wago_goo_id)
                    ->update($edit_stgo_data);
                unset($edit_stgo_data);
                unset($edit_stgo_res);
            }
        } elseif ($request['type'] == 4) {//更改仓库商品表的商品id
            foreach ($find_adgt_data as $key => $value) {
                $edit_wago_data['wago_goo_id'] = $value->goo_goods_id;//商品id
                $edit_orgo_res = DB::table('warehouse_goods as wago')
                    ->leftjoin('warehouse as ware', 'ware.ware_id', '=', 'wago.wago_ware_id')
                    ->where('ware_cid', $cid)
                    ->where('ware_shop_id', $shop_id)
                    ->where('wago_goo_id', $value->wago_goo_id)
                    ->update($edit_wago_data);
                unset($edit_wago_data);
                unset($edit_orgo_res);
            }
        } elseif ($request['type'] == 5) {//更改发货商品表的商品id
            foreach ($find_adgt_data as $key => $value) {
                $edit_digo_data['digo_goo_id'] = $value->goo_goods_id;//商品id
                $edit_digo_data['digo_goo_name'] = $value->goo_new_goo_name;//商品名称
                $edit_digo_data['digo_goo_goods_encode'] = $value->goo_new_goods_encode;//检索编码
                $edit_digo_res = DB::table('dispatch_goods as digo')
                    ->leftjoin('dispatch_bill as dibi', 'dibi.dego_id', '=', 'digo.digo_dego_id')
                    ->where('dego_cid', $cid)
                    ->where('dego_shop_id', $shop_id)
                    ->where('digo_goo_id', $value->wago_goo_id)
                    ->update($edit_digo_data);
                unset($edit_digo_data);
                unset($edit_digo_res);
            }
        } elseif ($request['type'] == 6) {//更改调拨单商品表的商品id
            foreach ($find_adgt_data as $key => $value) {
                $edit_trog_data['trog_goo_id'] = $value->goo_goods_id;//商品id
                $edit_trog_res = DB::table('transferring_order_goods as trog')
                    ->leftjoin('transferring_order as tror', 'tror.tror_id', '=', 'trog.trog_tror_id')
                    ->where('tror_cid', $cid)
                    ->where('tror_shop_id', $shop_id)
                    ->where('trog_goo_id', $value->wago_goo_id)
                    ->update($edit_trog_data);
                unset($edit_trog_data);
                unset($edit_trog_res);
            }
        } elseif ($request['type'] == 7) {//更改盘库单商品表的商品id
            foreach ($find_adgt_data as $key => $value) {
                $edit_stgo_data['stgo_goo_id'] = $value->goo_goods_id;//商品id
                $edit_stgo_res = DB::table('stocktake_goods as stgo')
                    ->leftjoin('stocktake as stoc', 'stoc.stoc_id', '=', 'stgo.stgo_stoc_id')
                    ->where('stoc_cid', $cid)
                    ->where('stoc_shop_id', $shop_id)
                    ->where('stgo_goo_id', $value->wago_goo_id)
                    ->update($edit_stgo_data);
                unset($edit_stgo_data);
                unset($edit_stgo_res);
            }
        } elseif ($request['type'] == 8) {//更改旧货回收商品表的商品id
            foreach ($find_adgt_data as $key => $value) {
                $edit_jugo_data['jugo_goo_id'] = $value->goo_goods_id;//商品id
                $edit_jugo_data['jugo_goo_name'] = $value->goo_new_goo_name;//商品名称
                $edit_jugo_data['jugo_goo_goods_encode'] = $value->goo_new_goods_encode;//检索编码
                $edit_jugo_res = DB::table('junk_goods as jugo')
                    ->leftjoin('junk_recycle as jur', 'jur.jur_id', '=', 'jugo.jugo_jur_id')
                    ->where('jur_cid', $cid)
                    ->where('jur_shop_id', $shop_id)
                    ->where('jugo_goo_id', $value->wago_goo_id)
                    ->update($edit_jugo_data);
                unset($edit_jugo_data);
                unset($edit_jugo_res);
            }
        } elseif ($request['type'] == 9) {//更改退货入库商品表的商品id
            foreach ($find_adgt_data as $key => $value) {
                $edit_rego_data['rego_goo_id'] = $value->goo_goods_id;//商品id
                $edit_rego_data['rego_goo_name'] = $value->goo_new_goo_name;//商品名称
                $edit_rego_data['rego_goo_goods_encode'] = $value->goo_new_goods_encode;//检索编码
                $edit_rego_res = DB::table('recede_goods as rego')
                    ->leftjoin('recede_recycle as rec', 'rec.rec_id', '=', 'rego.rego_rec_id')
                    ->where('rec_cid', $cid)
                    ->where('rec_shop_id', $shop_id)
                    ->where('rego_goo_id', $value->wago_goo_id)
                    ->update($edit_rego_data);
                unset($edit_rego_data);
                unset($edit_rego_res);
            }
        } elseif ($request['type'] == 10) {//更改商品流水记录商品表的商品id
            foreach ($find_adgt_data as $key => $value) {
                $edit_oude_data['oude_goo_id'] = $value->goo_goods_id;//商品id
                $edit_oude_res = DB::table('outin_details as oude')
                    ->leftjoin('outin_record as oure', 'oure.oure_id', '=', 'oude.oude_oure_id')
                    ->where('oure_cid', $cid)
                    ->where('oure_shop_id', $shop_id)
                    ->where('oude_goo_id', $value->wago_goo_id)
                    ->update($edit_oude_data);
                unset($edit_oude_data);
                unset($edit_oude_res);
            }
        } elseif ($request['type'] == 11) {//更改销售统计商品表的商品id
            foreach ($find_adgt_data as $key => $value) {
                $edit_dast_data['dast_actual_goo_id'] = $value->goo_goods_id;//实际出库商品id
                $edit_dast_data['dast_goo_id'] = $value->goo_goods_id;//商品id
                $edit_dast_res = DB::table('data_statistical')
                    ->where('dast_cid', $cid)
                    ->where('dast_shop_id', $shop_id)
                    ->where('dast_goo_id', $value->wago_goo_id)
                    ->update($edit_dast_data);
                unset($edit_dast_data);
                unset($edit_dast_res);
            }
        } elseif ($request['type'] == 12) {//更改进销存查询商品表的商品id
            foreach ($find_adgt_data as $key => $value) {
                $edit_ense_data['ense_goo_id'] = $value->goo_goods_id;//商品id
                $edit_ense_data['ense_goo_name'] = $value->goo_new_goo_name;//商品名称
                $edit_ense_data['ense_goo_number'] = $value->goo_new_goods_encode;//检索编码
                $edit_ense_res = DB::table('enters_sells_saves')
                    ->where('ense_shop_id', $shop_id)
                    ->where('ense_goo_id', $value->wago_goo_id)
                    ->update($edit_ense_data);
                unset($edit_ense_data);
                unset($edit_ense_res);
            }
        }
        echo "string";
        exit;
    }

    // 新旧编码商品数据
    public function newOldGoods()
    {
        $find_data = DB::table('goods_old_new')
        ->get()->toArray();
        $diff_data = [];
        foreach ($find_data as $key => $value) {
            $find_old_goods_data = DB::table('goods')
                ->where('goo_shop_id', 1)
                ->where('goo_delete', 1)
                ->where('goo_type', 1)
                ->where('goo_goods_encode', $value->goo_old_encode)
                ->select('goo_id', 'goo_goods_encode', 'goo_name')
                ->first();

            // 判断新旧编码是否相同
            if ($value->goo_old_encode == $value->goo_new_encode) {
                $edit_data['goo_same_state'] = 2;

                $edit_data['goo_new_id'] = $find_old_goods_data->goo_id;
                $edit_data['goo_new_name'] = $find_old_goods_data->goo_name;
            } else {
                $find_new_goods_data = DB::table('goods')
                    ->where('goo_shop_id', 0)
                    ->where('goo_delete', 1)
                    ->where('goo_type', 1)
                    ->where('goo_goods_encode', $value->goo_new_encode)
                    ->select('goo_id', 'goo_goods_encode', 'goo_name')
                    ->first();
                if (empty($find_new_goods_data)) {
                    $diff_data['goo_new_encode'] = $value->goo_new_encode;
                } else {
                    $edit_data['goo_new_id'] = $find_new_goods_data->goo_id;
                    $edit_data['goo_new_name'] = $find_new_goods_data->goo_name;
                }
            }

            $edit_data['goo_old_id'] = $find_old_goods_data->goo_id;
            $edit_data['goo_name'] = $find_old_goods_data->goo_name;
            $res = DB::table('goods_old_new')
                ->where('id', $value->id)
                ->update($edit_data);
            unset($edit_data);
            unset($find_old_goods_data);
        }
        dump($diff_data);
        echo 'success';
    }

    // 新旧编码商品数据搜素
    public function newOldGoodsSearch()
    {
        ignore_user_abort();
        set_time_limit(0);
        // 查询新旧编码数据
        $find_goods_data = DB::table('goods_old_new')
            ->where('goo_same_state', 1)
            ->get()->toArray();
        $old_goods_data = [];//旧编码数据
        $old_goo_id = [];//旧编码id
        $new_goods_data = [];//新编码数据
        $new_goo_id = [];//新编码id
        $old_new_goo_id = [];//旧编码对应新编码的id
        foreach ($find_goods_data as $key => $value) {
            $old_goo_id[] = $value->goo_old_id;
            $old_temp['goo_id'] = $value->goo_old_id;
            $old_temp['goo_goods_encode'] = $value->goo_old_encode;
            $old_temp['goo_name'] = $value->goo_name;
            $old_goods_data[$old_temp['goo_id']] = $old_temp;

            $old_new_goo_id[$value->goo_old_id] = $value->goo_new_id;

            $new_goo_id[] = $value->goo_new_id;
            $new_temp['goo_id'] = $value->goo_new_id;
            $new_temp['goo_goods_encode'] = $value->goo_new_encode;
            $new_temp['goo_name'] = $value->goo_new_name;
            $new_goods_data[$new_temp['goo_id']] = $new_temp;
            unset($old_temp);
            unset($new_temp);
        }

        $find_data = DB::table('warehouse')
            ->where('ware_shop_id', 1)
            ->whereIn('ware_type', [1,3])
            ->whereNotIn('ware_id', [9,10,11,13,14,96,121])
            ->select('ware_id', 'ware_name')
            ->get()->toArray();
        dump($find_data);
        foreach ($find_data as $key => $value) {
            // 查询仓库内旧编码数据
            $find_old_ware = DB::table('warehouse_goods')
                ->where('wago_ware_id', $value->ware_id)
                ->whereIn('wago_goo_id', $old_goo_id)
                ->select('wago_id', 'wago_class', 'wago_goo_id')
                ->get()->toArray();
            // 查存仓库内新编码数据
            $find_new_ware = DB::table('warehouse_goods')
                ->where('wago_ware_id', $value->ware_id)
                ->whereIn('wago_goo_id', $new_goo_id)
                ->select('wago_id', 'wago_class', 'wago_goo_id')
                ->get()->toArray();
            $find_new_goo_id = array_column($find_new_ware, 'wago_goo_id');
            $find_new_ware_data = array_column($find_new_ware, null, 'wago_goo_id');
            // dump($find_new_ware_data);
            if ($find_old_ware) {
                // 旧编码商品数据
                foreach ($find_old_ware as $old_key => $old_value) {
                    $add_old_new['wago_ware_id'] = $value->ware_id;
                    $add_old_new['wago_ware_name'] = $value->ware_name;
                    $add_old_new['wago_class'] = $old_value->wago_class;
                    $add_old_new['wago_id'] = $old_value->wago_id;
                    $add_old_new['wago_goo_id'] = $old_value->wago_goo_id;
                    $add_old_new['wago_goo_name'] = $old_goods_data[$old_value->wago_goo_id]['goo_name'];
                    $add_old_new['wago_goo_encode'] = $old_goods_data[$old_value->wago_goo_id]['goo_goods_encode'];
                    // 旧编码商品所在仓库内有新编码的数据
                    if (!empty($find_new_ware)) {
                        if (count($find_new_ware_data) != count($find_new_ware)) {
                            dump($find_new_ware);
                            dump($find_new_ware_data);
                        }

                        // 旧编码对应的新编码商品id
                        $temp_new_goo_id = $old_new_goo_id[$old_value->wago_goo_id];
                        // 判断新编码的商品id是否在仓库中已存在
                        if (in_array($temp_new_goo_id, $find_new_goo_id)) {
                            // 在仓库中已存在的旧编码对应新编码的库存数据
                            $add_old_new['new_wago_id'] = $find_new_ware_data[$temp_new_goo_id]->wago_id;
                            $add_old_new['new_wago_goo_id'] = $temp_new_goo_id;
                            $add_old_new['new_wago_goo_name'] = $new_goods_data[$temp_new_goo_id]['goo_name'];
                            $add_old_new['new_wago_goo_encode'] = $new_goods_data[$temp_new_goo_id]['goo_goods_encode'];
                            $add_old_new['new_state'] = 2;
                        } else {
                            // 在仓库中旧编码没有对应新编码的库存数据
                            $add_old_new['new_wago_goo_id'] = $temp_new_goo_id;
                            $add_old_new['new_wago_goo_name'] = $new_goods_data[$temp_new_goo_id]['goo_name'];
                            $add_old_new['new_wago_goo_encode'] = $new_goods_data[$temp_new_goo_id]['goo_goods_encode'];
                            $add_old_new['new_state'] = 1;
                        }
                    } else {
                        // 旧编码对应的新编码商品id
                        $temp_new_goo_id = $old_new_goo_id[$old_value->wago_goo_id];
                        // 在仓库中旧编码没有对应新编码的库存数据
                        $add_old_new['new_wago_goo_id'] = $temp_new_goo_id;
                        $add_old_new['new_wago_goo_name'] = $new_goods_data[$temp_new_goo_id]['goo_name'];
                        $add_old_new['new_wago_goo_encode'] = $new_goods_data[$temp_new_goo_id]['goo_goods_encode'];
                        $add_old_new['new_state'] = 1;
                    }
                    // 添加到数据表
                    $res = DB::table('warehouse_goods_old_new_test')->insert($add_old_new);
                    unset($add_old_new);
                }
            }
        }
        echo 'success';
    }

    // 删除原来的新增的系统商品
    public function deleteOldGoods()
    {
        ignore_user_abort();
        set_time_limit(0);
        // “博世”品牌，旧检索编码（12BS开头的）的商品建议删除
        $find_data = DB::table('goods')
            // ->where('goo_bra_id', 570)
            ->where('goo_delete', 1)
            // ->where('goo_shop_id', 26)
            // ->where('goo_goods_encode', 'like', '12BS%')
            // ->where('goo_goods_encode', 'like', 'WARTA%')
            // ->where('goo_goods_encode', 'like', 'EFB0%')
            // ->where('goo_goods_encode', 'like', '24YB0%')
            // ->where('goo_goods_encode', 'like', '24AGM%')
            // ->where('goo_goods_encode', 'like', '18YB%')
            // ->where('goo_goods_encode', 'like', '18LB0%')
            // ->where('goo_goods_encode', 'like', '18L0%')
            // ->where('goo_goods_encode', 'like', '12HB0%')
            // ->where('goo_goods_encode', 'like', 'FFQM%')
            // ->where('goo_goods_encode', 'like', 'BN0%')
            ->where('goo_goods_encode', 'like', 'FLL0%')
            ->select('goo_id', 'goo_shop_id', 'goo_goods_encode')
            ->get()->toArray();
        // dump($find_data);die;
        foreach ($find_data as $key => $value) {
            $update_data['goo_delete'] = 2;
            $res = DB::table('goods')
            ->where('goo_id', $value->goo_id)
            ->update($update_data);
        }
        dump(count($find_data));
        echo 'aaa';
    }

    // 查询系统商品编码是否都存在
    public function selectGoods()
    {
        // 速电整理的系统商品
        $goo_goods_encode = ['8813047','8813061','8813053','8813063','8813007','8813011','8813024','8813059','8813033','8813020','8813021','8813001','8813002','8813035','8813004','8813053','8813044','8813027','8813034','8813016','8813017','8813029','8813030','8813018','8813019','8813005','8813010','8815083','8815084','8815087','8815077','8815078','8815079','8815080','8816089','8816090','8816091','8816092','8816093','1010001','1010002','1010003','1010004','1010012','1010016','1010017','1010005','1011042','1011006','1011007','1011024','1011008','1011033','1011020','1011021','1011001','1011002','1011035','1011003','1011004','1011012','1011013','1011014','1011015','1011051','1011027','1011028','1011034','1011016','1011017','1011029','1011030','1011018','1011019','1011005','1012061','1012060','1012071','1012072','1012063','1012064','1012062','1012059','1012001','1012002','1012035','1012003','1012004','1012013','1012065','1012066','1012029','1012067','1012068','1012069','1012070','1012005','1015083','1015084','1015077','1015078','1015079','1015080','1016093','1016089','1016090','1016091','1016092','1113050','1113042','1113052','1113006','1113061','1113053','1113063','1113064','1113007','1113024','1113059','1113020','1113021','1113001','1113002','1113035','1113003','1113004','1113012','1113013','1113014','1113015','1113051','1113027','1113034','1113016','1113017','1113029','1113030','1113018','1113019','1113005','1113010','1113025','1113026','1115083','1115084','1115086','1115087','1115077','1115078','1115079','1115080','1116089','1116090','1116091','1116092','1116093','1223020','1223021','1223001','1223002','1223003','1223004','1223053','1223005','1223030','1223029','1223012','1223013','1223027','1223028','1223014','1223015','1223016','1223017','1223018','1223019','1223054','1223055','1224020','1224021','1224001','1224002','1224003','1224004','1224047','1224053','1224051','1224042','1224024','1224030','1224029','1224012','1224013','1224027','1224028','1224014','1224015','1224016','1224017','1224034','1224059','1224007','1224061','1224018','1224019','1224009','1224046','1224063','1224064','1224054','1224055','1215077','1215078','1215079','1215080','1215086','1215083','1215084','1216089','1216090','1216091','1216092','1216093','1318020','1318021','1318001','1318003','1318002','1318053','1318052','1318042','1318013','1318012','1318026','1318025','1318005','1318019','1318018','1319021','1319020','1319038','1319047','1319004','1319002','1319003','1319001','1319004','1319002','1319048','1319049','1319040','1319039','1319053','1319030','1319029','1319051','1319024','1319013','1319012','1319015','1319014','1319010','1319033','1319042','1319034','1319006','1319052','1319006','1319028','1319027','1319005','1319010','1319005','1319017','1319016','1319019','1319018','1319007','1319011','1319019','1319018','1319061','1320016','1320034','1320007','1320061','1320063','1320064','1321004','1321002','1321035','1321001','1321006','1321012','1321016','1321060','1321069','1321007','1321072','1321071','1321063','1321064','1315083','1315077','1315084','1315079','1315080','1315086','1315087','1316089','1316090','1316091','1316092','1316093','2016021','2016020','2016003','2016001','2016004','2016002','2016035','2016053','2016051','2016042','2016029','2016030','2016024','2016005','2016010','2016013','2016012','2016015','2016014','2016034','2016028','2016027','2016033','2016006','2016017','2016016','2016007','2016011','2016044','2016019','2016018','2016061','2016063','2016064','2013083','2013084','2013087','2013086','2013077','2013079','2013080','2013081','2014089','2014090','2014091','2014092','2014093','1526042','1526043','1526061','1526053','1526063','1526007','1526061','1526024','1526020','1526021','1526001','1526002','1526003','1526004','1526012','1526013','1526014','1526015','1526051','1526027','1526016','1526017','1526029','1526030','1526018','1526019','1526005','1526010','1515083','1515084','1515087','1515077','1515078','1515079','1515080','1617042','1617006','1617061','1617053','1617063','1617007','1617024','1617059','1617008','1617033','1617022','1617023','1617001','1617002','1617003','1617004','1617012','1617013','1617014','1617015','1617051','1617027','1617028','1617034','1617016','1617017','1617030','1617018','1617019','1617005','1615083','1615084','1615086','1615087','1615088','1615073','1615074','1615075','1615076','1615077','1615078','1615079','1615080','1615081','1615082','1616093','1616089','1616090','1616091','1616092','1713020','1713021','1713001','1713002','1713003','1713004','1713012','1713013','1713027','1713028','1713014','1713015','1713031','1713016','1713018','1713019','1713042','1713053','1713029','1713030','1713034','1713046','1713047','1713048','1713095','1713051','1713005','1713010','1713024','1713007','1713059','1713061','1713006','1713009','1713063','1715073','1715077','1715083','1715084','1715084','1813042','1813006','1813061','1813053','1813071','1813072','1813063','1813007','1813061','1813024','1813001','1813002','1813003','1813004','1813012','1813013','1813014','1813015','1813027','1813028','1813067','1813068','1813005','1813036','1813037','1814021','1814022','1814023','1814001','1814002','1814003','1814004','1814012','1815083','1815084','1815073','1815077','1815078','1815079','1815080','1815081','6613006','6613061','6613063','6613007','6613024','6613033','6613020','6613021','6613001','6613002','6613035','6613003','6613004','6613012','6613013','6613027','6613028','6613034','6613016','6613017','6613029','6613030','6613018','6613019','6613005','6615083','6615084','6615077','6615078','6615079','6615080','6616089','6616090','6616091','6616092','6616093','1913020','1913021','1913001','1913002','1913003','1913004','1913035','1913053','1913051','1913052','1913005','1913010','1913024','1913012','1913013','1913027','1913014','1913015','1913016','1913017','1913059','1913007','1913018','1913019','1913061','1913046','1913063','1913054','1913096','1913097','1913056','1913098','1913057','1913058','1913094','1915083','1915084','1915087','1915086','1915073','1915077','1915079','1916090','1916092','2015083','2015084','2015077','2015078','2015079','2015080','2016089','2016090','2016091','2016092','2016093'];

        $diff_data = [];
        foreach ($goo_goods_encode as $key => $value) {
            $find_goo_id = DB::table('goods')
                ->where('goo_cid', 0)
                ->where('goo_shop_id', 0)
                ->where('goo_type', 3)
                ->where('goo_goods_encode', $value)
                ->value('goo_id');
            if (empty($find_goo_id)) {
                $find_goo_id[] = $value;
            }
        }
        dump($diff_data);
    }

    // 统计仓库总量与仓库+仓位数量不一致
    public function diffwarehouseFreight()
    {
        $find_ware = DB::table('warehouse')
            ->where('ware_shop_id', 1)
            ->where('ware_type', 1)
            // ->whereIn('ware_id', ['150', '151', '152', '153', '154', '155', '156'])
            ->select('ware_id', 'ware_name', 'ware_shop_id', 'ware_state')
            ->get()->toArray();
        $find_ware = array_column($find_ware, null, 'ware_id');
        $diff_data = [];
        $diff_lock_data = [];
        foreach ($find_ware as $key => $value) {
            $find_wago_data = DB::table('warehouse_goods')
                ->where('wago_ware_id', $value->ware_id)
                ->select('wago_id', 'wago_ware_id', 'wago_goo_id', 'wago_class', 'wago_stock_number', 'wago_lock_quantity', 'wago_priority_stock_number', 'wago_priority_lock_quantity', 'wago_unchecked_stock_number', 'wago_freight_stock_number', 'wago_freight_lock_quantity', 'wago_freight_priority_stock_number', 'wago_freight_priority_lock_quantity', 'wago_freight_unchecked_stock_number', 'wago_stock_amount', 'wago_lock_amount', 'wago_priority_stock_amount', 'wago_priority_lock_amount', 'wago_unchecked_stock_amount')
                ->get()->toArray();
            foreach ($find_wago_data as $wago_key => $wago_value) {
                // 良品库存
                $stock_amount = $wago_value->wago_freight_stock_number +  $wago_value->wago_stock_amount;//仓位+仓库的库存
                $stock_lock_amount = $wago_value->wago_freight_lock_quantity +  $wago_value->wago_lock_amount;//仓位+仓库的锁定
                // 优先库存
                $priority_amount = $wago_value->wago_freight_priority_stock_number +  $wago_value->wago_priority_stock_amount;//仓位+仓库的库存
                $priority_lock_amount = $wago_value->wago_freight_priority_lock_quantity +  $wago_value->wago_priority_lock_amount;//仓位+仓库的库存
                if ($wago_value->wago_stock_number != $stock_amount|| $wago_value->wago_priority_stock_number != $priority_amount) {
                    // $temp_data = (array)$wago_value;
                    $temp_data['wago_id'] = $wago_value->wago_id;
                    $temp_data['wago_stock_number'] = $wago_value->wago_stock_number;
                    $temp_data['stock_amount'] = $stock_amount;
                    // $temp_data['wago_lock_quantity'] = $wago_value->wago_lock_quantity;
                    // $temp_data['stock_lock_amount'] = $stock_lock_amount;

                    $temp_data['wago_priority_stock_number'] = $wago_value->wago_priority_stock_number;
                    $temp_data['priority_amount'] = $priority_amount;
                    // $temp_data['wago_priority_lock_quantity'] = $wago_value->wago_priority_lock_quantity;
                    // $temp_data['priority_lock_amount'] = $priority_lock_amount;

                    $temp_data['goo_goods_encode'] = DB::table('goods')
                        ->where('goo_id', $wago_value->wago_goo_id)->value('goo_goods_encode');
                        
                    $temp_data['ware_name'] = $find_ware[$wago_value->wago_ware_id]->ware_name;
                    $temp_data['ware_shop_id'] = $find_ware[$wago_value->wago_ware_id]->ware_shop_id;
                    $temp_data['ware_state'] = $find_ware[$wago_value->wago_ware_id]->ware_state;
                    $diff_data[] = $temp_data;
                    unset($temp_data);
                }

                if ($wago_value->wago_lock_quantity != $stock_lock_amount || $wago_value->wago_priority_lock_quantity != $priority_lock_amount) {
                    $temp_data['wago_id'] = $wago_value->wago_id;
                    // $temp_data['wago_stock_number'] = $wago_value->wago_stock_number;
                    // $temp_data['stock_amount'] = $stock_amount;
                    $temp_data['wago_lock_quantity'] = $wago_value->wago_lock_quantity;
                    $temp_data['stock_lock_amount'] = $stock_lock_amount;

                    // $temp_data['wago_priority_stock_number'] = $wago_value->wago_priority_stock_number;
                    // $temp_data['priority_amount'] = $priority_amount;
                    $temp_data['wago_priority_lock_quantity'] = $wago_value->wago_priority_lock_quantity;
                    $temp_data['priority_lock_amount'] = $priority_lock_amount;

                    $temp_data['goo_goods_encode'] = DB::table('goods')
                        ->where('goo_id', $wago_value->wago_goo_id)->value('goo_goods_encode');

                    $temp_data['ware_name'] = $find_ware[$wago_value->wago_ware_id]->ware_name;
                    $temp_data['ware_shop_id'] = $find_ware[$wago_value->wago_ware_id]->ware_shop_id;
                    $temp_data['ware_state'] = $find_ware[$wago_value->wago_ware_id]->ware_state;
                    $diff_lock_data[] = $temp_data;
                    unset($temp_data);
                }
            }
        }
        dump($diff_data);
        dump($diff_lock_data);
    }

    // 应收应付状态问题数据
    public function diffReceivableState()
    {
        $find_data = DB::table('receivable_credit')
            ->where('recr_shop_id', 1)
            ->where('recr_belongs_id', 0)
            ->where('recr_state', 2)
            ->whereRaw('`recr_settle_price` <> `recr_yet_receipt`')
            ->select('recr_id', 'recr_original_number', 'recr_settle_price', 'recr_yet_receipt', 'recr_zero_price', 'recr_zero_plus_minus')
            ->orderBy('recr_id', 'desc')
            ->get()->toArray();
        $diff_data = [];
        foreach ($find_data as $key => $value) {
            if ($value->recr_zero_plus_minus == 1) {
                $diff_price = $value->recr_yet_receipt + $value->recr_zero_price;
            } else {
                $diff_price = $value->recr_yet_receipt - $value->recr_zero_price;
            }
            if ($value->recr_settle_price != $diff_price) {
                $number = substr($value->recr_original_number, 0, 2);
                if ($number == 'DZ') {
                    $orbi_state = DB::table('order_bill')
                        ->where('orbi_shop_id', 1)
                        ->where('orbi_number', $value->recr_original_number)
                        ->value('orbi_state');
                    if ($orbi_state != 2) {
                        $diff_data[] = (array)$value;
                    }
                } else {
                    $diff_data[] = (array)$value;
                }
            }
        }
        // dump($find_data);
        dump($diff_data);
    }

    // 随机生成经纬度
    public function randomLongitudeLatitude()
    {
        // 获取中国主要省市的经纬度
        $location = config('location.LOCATION');
        $new_location = explode(',', $location[$location_key]);
        // dump($new_location);
        $find_data = DB::table('lat_admin')
            ->select('lat_id')
            ->get()->toArray();
        foreach ($find_data as $key => $value) {
            $location_key = array_rand($location, 1);//随机抽取一个城市经纬度
            $new_location = explode(',', $location[$location_key]);
            $latitude = $new_location[0];//纬度
            $longitude = $new_location[1];//经度

            // 生成新的经纬度
            $new_latitude = explode('.', $latitude);
            $latitude = $new_latitude[0].'.'.mt_rand($new_latitude[1], mt_rand($new_latitude[1], 999999));
            $new_longitude = explode('.', $longitude);
            $longitude = $new_longitude[0].'.'.mt_rand($new_longitude[1], mt_rand($new_longitude[1], 999999));
            $update_data['lat_lat'] = $latitude;//纬度
            $update_data['lat_lon'] = $longitude;//经度
            $update_data['lat_ord_state'] = mt_rand(1, 4);//状态
            DB::table('lat_admin')->where('lat_id', $value->lat_id)->update($update_data);
        }
        echo 555;
        die;

        // 41.165988 - 22.517236
        $latitude = mt_rand(21, 41).'.'.mt_rand(010320, 999999);//纬度
        // 113.010320 - 120.990930
        $longitude = mt_rand(113, 120).'.'.mt_rand(010320, 990930);//经度
    }

    // 统计订单结算金额与应收应付金额不一致的数据
    public function diffOrderReceivable()
    {
        ignore_user_abort();
        set_time_limit(0);

        $find_data = DB::table('order')
            ->where('ord_shop_id', 1)
            ->where('ord_collection_bill', 1)
            ->where('ord_delete', 1)
            // ->where('ord_create_time', '<', '2021-12-01')
            ->where('ord_create_time', '>', '2021-04-01')
            ->select('ord_actual_price', 'ord_id', 'ord_shop_id', 'ord_order_number')
            ->get()->toArray();
        // dump($find_goods);
        $diff_data = [];
        foreach ($find_data as $key => $value) {
            // 查询应收应付数据
            $find_recr_data = DB::table('receivable_credit')
                ->where('recr_shop_id', $value->ord_shop_id)
                ->where('recr_original_id', $value->ord_id)
                ->where('recr_original_number', $value->ord_order_number)
                ->where('recr_account_type', 1)
                ->select('recr_settle_price', 'recr_original_number', 'recr_id', 'recr_plus_minus')
                ->first();
            if (empty($find_recr_data)) {
                continue;
            }
            if ($find_recr_data->recr_plus_minus == 2) {
                // 负数
                $recr_settle_price = '-'.$find_recr_data->recr_settle_price;
                if ($recr_settle_price != $value->ord_actual_price) {
                    $temp_data['recr_id'] = $find_recr_data->recr_id;
                    $temp_data['recr_original_number'] = $find_recr_data->recr_original_number;
                    $temp_data['recr_settle_price'] = $find_recr_data->recr_settle_price;
                    $temp_data['recr_plus_minus'] = $find_recr_data->recr_plus_minus;
                    $temp_data['ord_actual_price'] = $value->ord_actual_price;
                    $diff_data[] = $temp_data;
                    unset($temp_data);
                }
            } else {
                if ($find_recr_data->recr_settle_price != $value->ord_actual_price) {
                    $temp_data['recr_id'] = $find_recr_data->recr_id;
                    $temp_data['recr_original_number'] = $find_recr_data->recr_original_number;
                    $temp_data['recr_settle_price'] = $find_recr_data->recr_settle_price;
                    $temp_data['recr_plus_minus'] = $find_recr_data->recr_plus_minus;
                    $temp_data['ord_actual_price'] = $value->ord_actual_price;
                    $diff_data[] = $temp_data;
                    unset($temp_data);
                }
            }
        }
        dump($diff_data);
        // foreach ($diff_data as $key => $value) {
        //     $edit_data['recr_plus_minus'] = 1;
        //     $recr_res = DB::table('receivable_credit')
        //         ->where('recr_id', $value['recr_id'])
        //         ->update($edit_data);
        //     dump($recr_res);
        // }
        exit;
    }

    public function stock()
    {
        set_time_limit(0);

        $find_wago_data = DB::table('warehouse_goods')
            ->select('wago_id', 'wago_stock_number', 'wago_stock_amount', 'wago_lock_quantity', 'wago_priority_stock_number', 'wago_priority_lock_quantity', 'wago_unchecked_stock_number', 'wago_freight_stock_number', 'wago_freight_lock_quantity', 'wago_freight_priority_stock_number', 'wago_freight_priority_lock_quantity', 'wago_freight_unchecked_stock_number', 'wago_lock_amount', 'wago_priority_stock_amount', 'wago_priority_lock_amount', 'wago_unchecked_stock_amount')
            ->offset(65000)
            ->limit(5000)
            ->get()->toArray();
        foreach ($find_wago_data as $key => $value) {
            $update_data['wago_stock_number'] = $value->wago_stock_number + $value->wago_freight_stock_number;//仓位+仓库 良品库存
            $update_data['wago_stock_amount'] = $value->wago_stock_number;//仓库良品库存
            $update_data['wago_priority_stock_number'] = $value->wago_priority_stock_number +$value->wago_freight_priority_stock_number;//仓位+仓库 优先库存
            $update_data['wago_priority_stock_amount'] = $value->wago_priority_stock_number;//仓库优先库存

            $update_data['wago_lock_quantity'] = $value->wago_lock_quantity + $value->wago_freight_lock_quantity;//仓位+仓库 良品锁定库存

            $update_data['wago_lock_amount'] = $value->wago_lock_quantity;//仓库良品锁定库存

            $update_data['wago_priority_lock_quantity'] = $value->wago_priority_lock_quantity + $value->wago_freight_priority_stock_number;//仓位+仓库 优先锁定库存

            $update_data['wago_priority_lock_amount'] = $value->wago_priority_lock_quantity;//仓库优先锁定库存
            $update_res = DB::table('warehouse_goods')
                ->where('wago_id', $value->wago_id)
                ->update($update_data);
        }
        dump(65000);
        echo '999';
        die;
    }

    // 生成订单的唯一标识
    public function orderUniqueString()
    {
        set_time_limit(0);

        $find_data =  DB::table('order')
            ->where('ord_unique_string', '')
            ->select('ord_id', 'ord_create_id', 'ord_shop_id', 'ord_create_time')
            ->get()->toArray();
        foreach ($find_data as $key => $value) {
            // 获取唯一字符串标识
            $ord_unique_string = md5(md5($value->ord_id.$value->ord_create_id.$value->ord_shop_id.$value->ord_create_time.rand(1000, 9999)).rand(10000, 9999));
            $ord_data['ord_unique_string'] = $ord_unique_string;
            $res = DB::table('order')
                ->where('ord_id', $value->ord_id)
                ->update($ord_data);
            unset($ord_unique_string);
        }
        echo 11111111111;
        die;
    }
    
    // 商品编码数据处理
    public function goodsEncodeData()
    {
        set_time_limit(0);
        // $find_data = DB::table('excel_data_cache')
        //     ->where('exdc_type', 5)
        //     ->get()->toArray();
        /*foreach ($find_data as $key => $value) {
            $exdc_data = json_decode($value->exdc_data, true);
            dump($value);
            // 查询厦门自营商品id
            $goo_id = DB::table('goods')
                ->where('goo_shop_id', 1)
                ->where('goo_delete', 1)
                ->where('goo_class', 1)
                ->where('goo_type', 1)
                ->where('goo_goods_encode', $exdc_data['goo_goods_encode'])
                ->value('goo_id');
            $stgo_data['stgo_goo_id'] = $goo_id;
            $stgo_data['stgo_goo_name'] = $exdc_data['goo_name'];
            $stgo_data['stgo_goo_encode'] = $exdc_data['goo_goods_encode'];
            $stgo_data['stgo_system_goo_encode'] = $exdc_data['goo_system_goods_encode'];
            // 查询系统商品
            $sys_goo_id = DB::table('goods')
                ->where('goo_shop_id', 0)
                ->where('goo_delete', 1)
                ->where('goo_class', 2)
                ->where('goo_type', 1)
                ->where('goo_goods_encode', $exdc_data['goo_system_goods_encode'])
                ->value('goo_id');
            $stgo_data['stgo_system_goo_id'] = $sys_goo_id;

            $res = DB::table('stocktake_goods_encode')->insert($stgo_data);
            dump($res);
            unset($stgo_data);
            unset($exdc_data);
        }*/
        /*$find_data = DB::table('excel_data_cache')
            ->where('exdc_type', 4)
            ->get()->toArray();
        foreach ($find_data as $key => $value) {
            $exdc_data = json_decode($value->exdc_data, true);
            // dump($exdc_data);
            if ($exdc_data['goo_id']) {
                $stgo_id = DB::table('stocktake_goods_encode')
                    ->where('stgo_goo_id', $exdc_data['goo_id'])
                    ->value('stgo_id');
                if ($stgo_id) {
                    $stgo_data['stgo_kucun'] = $exdc_data['kucun'];
                    $stgo_res = DB::table('stocktake_goods_encode')
                        ->where('stgo_id', $stgo_id)
                        ->update($stgo_data);
                }else{
                    $stgo_data['stgo_goo_id'] = $exdc_data['goo_id'];
                    $stgo_data['stgo_goo_name'] = $exdc_data['goo_name'];
                    $stgo_data['stgo_goo_encode'] = $exdc_data['goo_goods_encode'];
                    $stgo_data['stgo_kucun'] = $exdc_data['kucun'];
                    $stgo_res = DB::table('stocktake_goods_encode')->insert($stgo_data);
                }
                unset($stgo_data);
            } else {
                // 查询厦门自营商品id
                $goo_id = DB::table('goods')
                    ->where('goo_shop_id', 1)
                    ->where('goo_delete', 1)
                    ->where('goo_class', 1)
                    ->where('goo_type', 1)
                    ->where('goo_goods_encode', $exdc_data['goo_goods_encode'])
                    ->value('goo_id');
                if (empty($goo_id)) {
                    continue;
                }
                $stgo_id = DB::table('stocktake_goods_encode')
                    ->where('stgo_goo_id', $goo_id)
                    ->value('stgo_id');
                if ($stgo_id) {
                    $stgo_data['stgo_kucun'] = $exdc_data['kucun'];
                    $stgo_res = DB::table('stocktake_goods_encode')
                        ->where('stgo_id', $stgo_id)
                        ->update($stgo_data);
                }else{
                    $stgo_data['stgo_goo_id'] = $goo_id;
                    $stgo_data['stgo_goo_name'] = $exdc_data['goo_name'];
                    $stgo_data['stgo_goo_encode'] = $exdc_data['goo_goods_encode'];
                    $stgo_data['stgo_kucun'] = $exdc_data['kucun'];
                    $stgo_res = DB::table('stocktake_goods_encode')->insert($stgo_data);
                }
            }
        }*/
        // 查询盘库单商品id
        $find_data = DB::table('stocktake_goods')
            ->where('stgo_stoc_id', 159)
            ->get()->toArray();
        foreach ($find_data as $key => $value) {
            // $stgo_id = DB::table('stocktake_goods_encode')
            //         ->where('stgo_goo_id', $value->stgo_goo_id)
            //         ->value('stgo_id');
            // if ($stgo_id) {
            //     $stgo_data['stgo_num'] = $value->stgo_stocktake_number;
            //     $stgo_res = DB::table('stocktake_goods_encode')
            //         ->where('stgo_id', $stgo_id)
            //         ->update($stgo_data);
            // }
            // 系统商品id
            $stgo_id = DB::table('stocktake_goods_encode')
                    ->where('stgo_system_goo_id', $value->stgo_goo_id)
                    ->value('stgo_id');
            if ($stgo_id) {
                $stgo_data['stgo_num'] = $value->stgo_stocktake_number;
                $stgo_res = DB::table('stocktake_goods_encode')
                    ->where('stgo_id', $stgo_id)
                    ->update($stgo_data);
            }
        }
        echo 666;
        die;
    }

    // 应收应付中订单时间为0的，同步订单时间
    public function receivableOrderTime($request)
    {
        ignore_user_abort();
        set_time_limit(0);
        $find_ware_data = DB::table('receivable_credit')
            ->where('recr_order_time', '0000-00-00 00:00:00')
            ->where('recr_original_number', 'like', 'D%')
            ->select('recr_id', 'recr_shop_id', 'recr_original_number', 'recr_original_id', 'recr_account_type', 'recr_order_time')
            ->get()->toArray();
        foreach ($find_ware_data as $key => $value) {
            $ord_create_time = DB::table('order')
                    ->where('ord_order_number', $value->recr_original_number)
                    ->select('ord_create_time')
                    ->value('ord_create_time');
            if ($ord_create_time) {
                DB::table('receivable_credit')
                ->where('recr_id', $value->recr_id)
                ->update(['recr_order_time'=>$ord_create_time]);
            } else {
                dump($value);
            }
        }
        echo 999;
        die;
    }

    //新增默认仓位
    public function addFreight()
    {
        $find_ware_id = DB::table('warehouse')
        ->where('ware_type', 1)
        ->select('ware_id', 'ware_shop_id')
        ->get()->toArray();
        foreach ($find_ware_id as $key => $value) {
            $find_wafr = DB::table('warehouse_freight')
            ->where('wafr_ware_id', $value->ware_id)
            ->where('wafr_delete', 1)
            ->value('wafr_id');
            if (empty($find_wafr)) {
                //新增默认仓位
                $data['wafr_shop_id'] = $value->ware_shop_id;//仓位隶属门店id
                $data['wafr_ware_id'] = $value->ware_id;//仓位隶属仓库id
                $data['wafr_parent_id'] = 0;//仓位隶属上级id
                $data['wafr_rank'] = 1;//仓位级别，第几级
                $data['wafr_name'] = '默认仓位';//仓位名称
                $data['wafr_delete'] = 1;//是否删除1否2是
                $data['wafr_first_parent_id'] = 0;//仓位所属一级id
                $wafr_id = DB::table('warehouse_freight')->insertGetId($data);
            }
        }
        echo 111;
        die;
    }
    // 查询仓库的锁定商品，以及对应锁定的单子
    public function wareGoodsLock($request)
    {
        $wago_type = true;
        $find_ware_data = DB::table('warehouse_goods as wg')
            ->leftJoin('goods as g', 'g.goo_id', '=', 'wg.wago_goo_id')
            // ->whereIn('wago_ware_id', [9,10,11,13,14])
            ->where('wago_ware_id', $request['ware_id'])
            ->where('wago_class', 1)
            ->where(function ($query) use ($wago_type) {
                $query->where('wago_lock_quantity', '>', 0)
                    ->orWhere('wago_priority_lock_quantity', '>', 0);
            })
            ->select('goo_name', 'goo_goods_encode', 'goo_bra_name', 'goo_cate_name', 'wago_stock_number', 'wago_lock_quantity', 'wago_priority_lock_quantity', 'wago_goo_id', 'wago_id')
            ->get()->toArray();
        dump($find_ware_data);
        die;
    }

    // 匹配系统商品id
    public function systemGoodsEncode()
    {
        ignore_user_abort();
        set_time_limit(0);

        $find_data = DB::table('enters_sells_saves_price_total')
            ->where('ense_new_amount', '<>', '')
            ->select('ense_goo_number', 'ense_new_amount')
            ->get()->toArray();
        // dump($find_data);
        $goo_goods_encode = array_column($find_data, null, 'ense_goo_number');
        // dump($goo_goods_encode);
        // die;
        $goods_system_orginal = [];
        foreach ($goo_goods_encode as $key => $value) {
            $find_goo_id = DB::table('goods')
                ->where('goo_shop_id', 1)
                ->where('goo_goods_encode', $value->ense_goo_number)
                ->value('goo_id');
            $find_system_goo_id = DB::table('goods')
                ->where('goo_shop_id', 0)
                ->where('goo_goods_encode', $value->ense_new_amount)
                ->value('goo_id');
            $goods_system_orginal[$find_goo_id] = $find_system_goo_id;
        }
        // dump($goods_system_orginal);
        // die;

        $shop_id = 1; //门店id
        // $ware_id = 151;//X1总部仓
        // $ware_id = 152;//X2仙岳仓
        // $ware_id = 153;//X3前埔仓
        $ware_id = 154;//X6灌口仓
        // $ware_id = 155;//X7同安仓
        $waon_class = 1;//货物仓

        // 出入库记录id
        $oure_id = 110696;//X6灌口仓
        // $oure_id = 110695;//X1
        // $oure_id = 110696;//X7
        // $oure_id = 110698;//X2
        // $oure_id = 110699;//X3

        // 进销存记录单号
        $ense_order_number = 'P0103130704100120213';//X6灌口仓
        // $ense_order_number = 'P0103130551150119910';//X1灌口仓
        // $ense_order_number = 'P0103130656360187499';//X7
        // $ense_order_number = 'P0103130702240199157';//X2
        // $ense_order_number = 'P0103130703290126554';//X3

        // 盘库单
        $stoc_id = 167;//X6灌口仓
        // $stoc_id = 159;//X1
        // $stoc_id = 163;//X7
        // $stoc_id = 165;//X2
        // $stoc_id = 166;//X3

        foreach ($goods_system_orginal as $goo_id => $system_goo_id) {
            // dump($goo_id);
            // dump($system_goo_id);
            // die;
            // 更换仓库商品表id
            $find_wago_id = DB::table('warehouse_goods')
                ->where('wago_ware_id', $ware_id)
                ->where('wago_class', $waon_class)
                ->where('wago_goo_id', $goo_id)
                ->value('wago_id');
            $wago_update['wago_goo_id'] = $system_goo_id;
            $res = DB::table('warehouse_goods')
                ->where('wago_id', $find_wago_id)
                ->update($wago_update);
            unset($wago_update);

            // 更换出入库记录商品id
            $find_oude_id = DB::table('outin_details')
                ->where('oude_oure_id', $oure_id)
                ->where('oude_goo_id', $goo_id)
                ->value('oude_id');
            $wago_update['oude_goo_id'] = $system_goo_id;
            $res = DB::table('outin_details')
                ->where('oude_id', $find_oude_id)
                ->update($wago_update);
            unset($wago_update);

            // 更换进销存商品id
            $find_ense_id = DB::table('enters_sells_saves')
                ->where('ense_order_number', $ense_order_number)
                ->where('ense_goo_warehouse', $ware_id)
                ->where('ense_goo_waretype', $waon_class)
                ->where('ense_goo_id', $goo_id)
                ->value('ense_id');
            $find_sys_goo = DB::table('goods')
                ->where('goo_id', $system_goo_id)
                ->select('goo_name', 'goo_goods_encode')
                ->first();
            $wago_update['ense_goo_id'] = $system_goo_id;
            $wago_update['ense_goo_name'] = $find_sys_goo->goo_name;
            $wago_update['ense_goo_number'] = $find_sys_goo->goo_goods_encode;
            $res = DB::table('enters_sells_saves')
                ->where('ense_id', $find_ense_id)
                ->update($wago_update);
            unset($wago_update);

            // 更换盘库单商品id
            $find_stgo_id = DB::table('stocktake_goods')
                ->where('stgo_stoc_id', $stoc_id)
                ->where('stgo_goo_id', $goo_id)
                ->value('stgo_id');
            $wago_update['stgo_goo_id'] = $system_goo_id;
            $res = DB::table('stocktake_goods')
                ->where('stgo_id', $find_stgo_id)
                ->update($wago_update);
            dump($res);
            unset($wago_update);
        }
        echo 999;
        die;
    }

    // 速电系统商品编码与标准商品编码不一致数据
    public function goodsCodeDiff()
    {
        $goo_sd_goods_encode = [
                '161720',
                '161721',
                '161742',
                '161724',
                '161706',
                '161707',
                '161701',
                '161702',
                '161703',
                '161704',
                '161712',
                '161713',
                '161714',
                '161715',
                '161727',
                '161728',
                '161716',
                '161717',
                '161730',
                '161718',
                '161719',
                '161705',
                '111324',
                '111352',
                '111359',
                '111361',
                '111363',
                '111320',
                '111321',
                '111301',
                '111302',
                '111303',
                '111304',
                '111312',
                '111313',
                '111314',
                '111315',
                '111353',
                '111342',
                '111330',
                '111312',
                '111307',
                '111327',
                '111328',
                '111334',
                '111316',
                '111317',
                '111318',
                '111319',
                '201642',
                '201624',
                '201606',
                '201607',
                '201661',
                '201663',
                '201633',
                '201620',
                '201621',
                '201601',
                '201603',
                '201613',
                '201612',
                '201614',
                '201615',
                '201611',
                '201661',
                '201627',
                '201628',
                '201634',
                '201616',
                '201617',
                '201630',
                '201618',
                '201619',
                '201605',
                '131938',
                '131942',
                '131924',
                '131952',
                '13197',
                '131963',
                '131929',
                '131920',
                '131921',
                '131902',
                '131902',
                '131904',
                '131904',
                '131912',
                '131913',
                '131914',
                '131915',
                '131953',
                '131909',
                '131927',
                '131928',
                '131918',
                '131921',
                '131910',
                '131910',
                '131961',
                '131934',
                '131916',
                '131917',
                '181577',
                '181342',
                '181324',
                '181305',
                '181306',
                '181307',
                '181361',
                '181361',
                '181301',
                '181302',
                '181303',
                '181304',
                '181312',
                '181313',
                '181331',
                '181332',
                '181327',
                '181328',
                '181367',
                '181368',
                '181371',
                '181372',
                '181336',
                '181422',
                '181421',
                '181401',
                '181402',
                '181403',
                '181404',
                '181412',
                '181413',
                '181427',
                '181428',
                '152642',
                '152624',
                '152605',
                '152643',
                '152607',
                '151361',
                '152620',
                '152621',
                '152601',
                '152602',
                '152603',
                '152604',
                '152612',
                '152613',
                '151314',
                '151315',
                '152663',
                '152627',
                '152628',
                '152616',
                '152617',
                '152618',
                '152619',
                '101142',
                '101152',
                '101106',
                '101124',
                '101107',
                '101108',
                '101109',
                '101133',
                '101120',
                '101121',
                '101101',
                '101102',
                '101103',
                '101104',
                '101101',
                '101102',
                '101103',
                '101104',
                '101112',
                '101113',
                '101131',
                '101132',
                '101127',
                '101128',
                '101134',
                '101116',
                '101117',
                '101130',
                '101118',
                '101119',
                '101105',
                '101261',
                '101259',
                '101260',
                '101263',
                '101264',
                '101201',
                '101202',
                '101203',
                '101204',
                '101267',
                '101268',
                '101269',
                '101270',
                '101205',
                '101691',
                '101692',
                '101693',
                '161707',
                '161733',
                '181331',
                '201604',
                '181331',
                '131318',
                '111313',
                '101161',
                '201653',
                '101262',
                '181579',
                '161734',
                '101690',
                '151343',
                '181337',
                '131951',
                '131919',
                '111335',
                '101114',
                '161724',
                '101115',
                '101689',
                '101265',
                '181573',
                '131906',
                '101120',
                '101121',
                '152631',
                '101271',
                '101271',
                '131921',
                '111351',
                '152607',
                '152630',
                '151353',
                '151583',
                '151577',
                '151584',
                '151579',
                '101129',
                '131940',
                '152653',
                '13197',
                '111584',
                '181580',
                '131921',
                '131921',
                '181342',
                '131921',
                '201629',
                '152651',
                '131921',
                '181353',
                '152628',
                '152628',
                '101266',
                '131948',
                '111691',
                '181578',
                '101261',
                '111689',
                '111690',
                '111692',
                '111693',
                '111584',
                '111350',
                '181353',
                '181342',
                '131921',
                '201602',
                '111583',
                '111587',
                '111586',
                '201624',
                '131577',
                '131921',
                '201377',
                '201379',
                '201383',
                '201384',
                '201489',
                '201490',
                '201491',
                '201492',
                '201493',
                '131921',
                '101005',
                '111329',
                '111364',
                '101272',
                '101577',
                '101578',
                '101579',
                '101580',
                '101583',
                '101584',
                '101001',
                '101001',
                '101001',
                '101001',
                '101001',
                '101001',
                '101001',
                '101001',
                '152653',
                '101251',
                '131906',
                '161701',
                '161703',
                '161704',
                '161542',
                '161702',
                '161759',
                '161708',
                '161761',
                '161763',
                '161753',
                '161751',
                '201381',
                '101142',
                '101004',
                '101003',
                '101002',
                '101001',
                '101012',
                '101013',
                '101027',
                '101028',
                '101015',
                '101014',
                '101016',
                '101017',
                '101051',
                '101024',
                '101059',
                '101042',
                '101020',
                '101021',
                '101019',
                '101018',
                '101029',
                '101030',
                '131921',
                '111577',
                '181584',
                '101151',
                '131953',
                '161707',
                '161577',
                '161579',
                '161583',
                '201387',
                '161588',
                '161689',
                '161690',
                '161691',
                '161692',
                '101693',
                '181583',
                '151587',
                '101205',
                '101201',
                '101202',
                '101212',
                '101230',
                '101216',
                '101217',
                '101261',
                '101261',
                '101261',
                '101261',
                '101261',
                '151580',
                '181361',
                '181363',
                '181368',
                '181367',
                '151587',
                '101016',
                '101017',
                '131948',
                '151578',
                '101583',
                '111579',
                '111578',
                '111580',
                '131583',
                '161578',
                '161580',
                '161586',
                '131579',
                '881577',
                '881578',
                '881579',
                '881580',
                '881583',
                '881584',
                '881587',
                '661320',
                '661321',
                '661303',
                '661301',
                '661302',
                '661304',
                '661306',
                '661305',
                '661312',
                '661313',
                '661330',
                '661316',
                '661317',
                '661318',
                '661319',
                '661361',
                '661307',
                '661577',
                '661579',
                '661583',
                '661584',
                '161583',
                '161583',
                '161583',
                '161583',
                '161583',
                '161583',
                '161583',
                '111313',
                '151579',
                '151580',
                '152602',
                '152632',
                '152631',
                '152616',
                '152617',
                '152610',
                '152661',
                '152629',
                '151587',
                '111350',
                '181423',
                '111350',
                '181583'
            ];

        $sys_goods_encode = [
                '881347',
                '881361',
                '881353',
                '881363',
                '881307',
                '881311',
                '881324',
                '881359',
                '881333',
                '881320',
                '881321',
                '881301',
                '881302',
                '881335',
                '881304',
                '881344',
                '881327',
                '881334',
                '881316',
                '881317',
                '881329',
                '881330',
                '881318',
                '881319',
                '881305',
                '881310',
                '881583',
                '881584',
                '881587',
                '881577',
                '881578',
                '881579',
                '881580',
                '881689',
                '881690',
                '881691',
                '881692',
                '881693',
                '101001',
                '101002',
                '101003',
                '101004',
                '101012',
                '101016',
                '101017',
                '101005',
                '101142',
                '101106',
                '101107',
                '101124',
                '101108',
                '101133',
                '101120',
                '101121',
                '101101',
                '101102',
                '101135',
                '101103',
                '101104',
                '101112',
                '101113',
                '101114',
                '101115',
                '101151',
                '101127',
                '101128',
                '101134',
                '101116',
                '101117',
                '101129',
                '101130',
                '101118',
                '101119',
                '101105',
                '101261',
                '101260',
                '101271',
                '101272',
                '101263',
                '101264',
                '101262',
                '101259',
                '101201',
                '101202',
                '101235',
                '101203',
                '101204',
                '101213',
                '101265',
                '101266',
                '101229',
                '101267',
                '101268',
                '101269',
                '101270',
                '101205',
                '101583',
                '101584',
                '101577',
                '101578',
                '101579',
                '101580',
                '101693',
                '101689',
                '101690',
                '101691',
                '101692',
                '111350',
                '111342',
                '111352',
                '111306',
                '111361',
                '111353',
                '111363',
                '111364',
                '111307',
                '111324',
                '111359',
                '111320',
                '111321',
                '111301',
                '111302',
                '111335',
                '111303',
                '111304',
                '111312',
                '111313',
                '111314',
                '111315',
                '111351',
                '111327',
                '111334',
                '111316',
                '111317',
                '111329',
                '111330',
                '111318',
                '111319',
                '111305',
                '111310',
                '111325',
                '111326',
                '111583',
                '111584',
                '111586',
                '111587',
                '111577',
                '111578',
                '111579',
                '111580',
                '111689',
                '111690',
                '111691',
                '111692',
                '111693',
                '122320',
                '122321',
                '122301',
                '122302',
                '122303',
                '122304',
                '122353',
                '122305',
                '122330',
                '122329',
                '122312',
                '122313',
                '122327',
                '122328',
                '122314',
                '122315',
                '122316',
                '122317',
                '122318',
                '122319',
                '122354',
                '122355',
                '122420',
                '122421',
                '122401',
                '122402',
                '122403',
                '122404',
                '122447',
                '122453',
                '122451',
                '122442',
                '122424',
                '122430',
                '122429',
                '122412',
                '122413',
                '122427',
                '122428',
                '122414',
                '122415',
                '122416',
                '122417',
                '122434',
                '122459',
                '122407',
                '122461',
                '122418',
                '122419',
                '122409',
                '122446',
                '122463',
                '122464',
                '122454',
                '122455',
                '121577',
                '121578',
                '121579',
                '121580',
                '121586',
                '121583',
                '121584',
                '121689',
                '121690',
                '121691',
                '121692',
                '121693',
                '131820',
                '131821',
                '131801',
                '131803',
                '131802',
                '131853',
                '131852',
                '131842',
                '131813',
                '131812',
                '131826',
                '131825',
                '131805',
                '131819',
                '131818',
                '131921',
                '131920',
                '131938',
                '131947',
                '131904',
                '131902',
                '131903',
                '131901',
                '131948',
                '131949',
                '131940',
                '131939',
                '131953',
                '131930',
                '131929',
                '131951',
                '131924',
                '131913',
                '131912',
                '131915',
                '131914',
                '131910',
                '131933',
                '131942',
                '131934',
                '131906',
                '131952',
                '131928',
                '131927',
                '131905',
                '131917',
                '131916',
                '131919',
                '131918',
                '131907',
                '131911',
                '131919',
                '131918',
                '131961',
                '132016',
                '132034',
                '132007',
                '132061',
                '132063',
                '132064',
                '132104',
                '132102',
                '132135',
                '132101',
                '132106',
                '132112',
                '132116',
                '132160',
                '132169',
                '132107',
                '132172',
                '132171',
                '132163',
                '132164',
                '131583',
                '131577',
                '131584',
                '131579',
                '131580',
                '131586',
                '131587',
                '131689',
                '131690',
                '131691',
                '131692',
                '131693',
                '201621',
                '201620',
                '201603',
                '201601',
                '201604',
                '201602',
                '201635',
                '201653',
                '201651',
                '201642',
                '201629',
                '201630',
                '201624',
                '201605',
                '201610',
                '201613',
                '201612',
                '201615',
                '201614',
                '201634',
                '201628',
                '201627',
                '201633',
                '201606',
                '201617',
                '201616',
                '201607',
                '201611',
                '201644',
                '201619',
                '201618',
                '201661',
                '201663',
                '201664',
                '201383',
                '201384',
                '201387',
                '201386',
                '201377',
                '201379',
                '201380',
                '201381',
                '201489',
                '201490',
                '201491',
                '201492',
                '201493',
                '151342',
                '151343',
                '151361',
                '151353',
                '151363',
                '151307',
                '151361',
                '151324',
                '151320',
                '151321',
                '151301',
                '151302',
                '151303',
                '151304',
                '151312',
                '151313',
                '151314',
                '151315',
                '151351',
                '151327',
                '151316',
                '151317',
                '151329',
                '151330',
                '151318',
                '151319',
                '151305',
                '151310',
                '151583',
                '151584',
                '151587',
                '151577',
                '151578',
                '151579',
                '151580',
                '161742',
                '161706',
                '161761',
                '161753',
                '161763',
                '161707',
                '161724',
                '161759',
                '161708',
                '161733',
                '161722',
                '161723',
                '161701',
                '161702',
                '161703',
                '161704',
                '161712',
                '161713',
                '161714',
                '161715',
                '161751',
                '161727',
                '161728',
                '161734',
                '161716',
                '161717',
                '161730',
                '161718',
                '161719',
                '161705',
                '161583',
                '161584',
                '161586',
                '161587',
                '161588',
                '161573',
                '161574',
                '161575',
                '161576',
                '161577',
                '161578',
                '161579',
                '161580',
                '161581',
                '161582',
                '161693',
                '161689',
                '161690',
                '161691',
                '161692',
                '171320',
                '171321',
                '171301',
                '171302',
                '171303',
                '171304',
                '171312',
                '171313',
                '171327',
                '171328',
                '171314',
                '171315',
                '171331',
                '171316',
                '171318',
                '171319',
                '171342',
                '171353',
                '171329',
                '171330',
                '171334',
                '171346',
                '171347',
                '171348',
                '171395',
                '171351',
                '171305',
                '171310',
                '171324',
                '171307',
                '171359',
                '171361',
                '171306',
                '171309',
                '171363',
                '171573',
                '171577',
                '171583',
                '171584',
                '181342',
                '181306',
                '181361',
                '181353',
                '181371',
                '181372',
                '181363',
                '181307',
                '181324',
                '181301',
                '181302',
                '181303',
                '181304',
                '181312',
                '181313',
                '181314',
                '181315',
                '181327',
                '181328',
                '181367',
                '181368',
                '181305',
                '181336',
                '181337',
                '181421',
                '181422',
                '181423',
                '181401',
                '181402',
                '181403',
                '181404',
                '181412',
                '181583',
                '181584',
                '181573',
                '181577',
                '181578',
                '181579',
                '181580',
                '181581',
                '661306',
                '661361',
                '661363',
                '661307',
                '661324',
                '661333',
                '661320',
                '661321',
                '661301',
                '661302',
                '661335',
                '661303',
                '661304',
                '661312',
                '661313',
                '661327',
                '661328',
                '661334',
                '661316',
                '661317',
                '661329',
                '661330',
                '661318',
                '661319',
                '661305',
                '661583',
                '661584',
                '661577',
                '661578',
                '661579',
                '661580',
                '661689',
                '661690',
                '661691',
                '661692',
                '661693',
                '191320',
                '191321',
                '191301',
                '191302',
                '191303',
                '191304',
                '191335',
                '191353',
                '191351',
                '191352',
                '191305',
                '191310',
                '191324',
                '191312',
                '191313',
                '191327',
                '191314',
                '191315',
                '191316',
                '191317',
                '191359',
                '191307',
                '191318',
                '191319',
                '191361',
                '191346',
                '191363',
                '191354',
                '191396',
                '191397',
                '191356',
                '191398',
                '191357',
                '191358',
                '191394',
                '191583',
                '191584',
                '191587',
                '191586',
                '191573',
                '191577',
                '191579',
                '191690',
                '191692',
                '201583',
                '201584',
                '201577',
                '201578',
                '201579',
                '201580',
                '201689',
                '201690',
                '201691',
                '201692',
                '201693'
            ];
        dump(count($goo_sd_goods_encode));
        $goo_sd_goods_encode = array_unique($goo_sd_goods_encode);
        // dump($goo_sd_goods_encode);
        $diff_goo_encode = [];
        foreach ($goo_sd_goods_encode as $key => $value) {
            if (!in_array($value, $sys_goods_encode)) {
                $diff_goo_encode[] = $value;
            }
        }
        dump($diff_goo_encode);
    }

    // 销售统计商品成本与订单商品成本不一致
    public function diffOrderStatistical()
    {
        ignore_user_abort();
        set_time_limit(0);

        $find_dast_data = DB::table('data_statistical')
                ->where('dast_cid', 1)
                ->where('dast_shop_id', 1)
                ->where('dast_superior_shop_id', 1)
                // ->where('dast_id', '>', 0)
                // ->where('dast_id', '<=', 20000)
                // ->where('dast_id', '>', 20000)
                // ->where('dast_id', '<=', 30000)
                // ->where('dast_id', '>', 30000)
                // ->where('dast_id', '<=', 35000)
                // ->where('dast_id', '>', 35000)
                // ->where('dast_id', '<=', 40000)
                // ->where('dast_id', '>', 40000)
                // ->where('dast_id', '<=', 50000)
                // ->where('dast_id', '>', 50000)
                // ->where('dast_id', '<=', 60000)
                // ->where('dast_id', '>', 60000)
                // ->where('dast_id', '<=', 70000)
                ->where('dast_id', '>', 70000)
                ->select('dast_id', 'dast_ord_id', 'dast_order_number', 'dast_goo_type', 'dast_goo_cost', 'dast_goo_id', 'dast_actual_goo_id', 'dast_orgo_id')
                ->get()->toArray();
        $diff_order_data = [];
        foreach ($find_dast_data as $key => $value) {
            // 查询订单商品表的数据
            $orgo_goo_cost = DB::table('order_goods')
                ->where('orgo_id', $value->dast_orgo_id)
                ->where('orgo_ord_id', $value->dast_ord_id)
                ->where('orgo_order_number', $value->dast_order_number)
                ->value('orgo_goo_cost');
            if ($value->dast_goo_cost != $orgo_goo_cost) {
                // $diff_data['dast_id'] = $value->dast_id;
                $diff_data['dast_ord_id'] = $value->dast_ord_id;
                $diff_data['dast_order_number'] = $value->dast_order_number;
                $diff_data['dast_orgo_id'] = $value->dast_orgo_id;
                $diff_data['dast_goo_id'] = $value->dast_goo_id;
                $diff_data['dast_goo_type'] = $value->dast_goo_type;
                $diff_data['dast_goo_cost'] = $value->dast_goo_cost;
                $diff_data['dast_goo_price'] = $orgo_goo_cost;//订单商品成本
                // $res = DB::table('data_statistical_order_diff')->insert($diff_data);
                // $update_data['orgo_goo_cost'] = $value->dast_goo_cost;
                // $res = DB::table('order_goods')
                //     ->where('orgo_id', $value->dast_orgo_id)
                //     ->where('orgo_ord_id', $value->dast_ord_id)
                //     ->where('orgo_order_number', $value->dast_order_number)
                //     ->update($update_data);
                // unset($update_data);
                if ($orgo_goo_cost) {
                    $diff_order_data[] = $diff_data;
                    // dump($diff_data);
                }
                unset($diff_data);
            }
            unset($orgo_goo_cost);
        }
        echo 111;
        dump($diff_order_data);
    }

    // 比较销售统计的数据
    private function diffDataStatistical()
    {
        set_time_limit(0);
        $find_data = DB::table('data_statistical_210311')
                // ->where('dast_id', '>', 0)
                // ->where('dast_id', '<=', 20000)
                // ->where('dast_id', '>', 20000)
                // ->where('dast_id', '<=', 30000)
                // ->where('dast_id', '>', 30000)
                // ->where('dast_id', '<=', 35000)
                // ->where('dast_id', '>', 35000)
                // ->where('dast_id', '<=', 40000)
                // ->where('dast_id', '>', 40000)
                // ->where('dast_id', '<=', 50000)
                // ->where('dast_id', '>', 50000)
                // ->where('dast_id', '<=', 60000)
                // ->where('dast_id', '>', 60000)
                // ->where('dast_id', '<=', 70000)
                // ->where('dast_id', '>', 70000)
                ->select('dast_id', 'dast_ord_id', 'dast_order_number', 'dast_goo_id', 'dast_orgo_id', 'dast_goo_cost', 'dast_goo_quantity', 'dast_goo_quantitys')
                ->get()->toArray();
        // dump($find_data);
        $diff_data = [];
        foreach ($find_data as $key => $value) {
            $find_goods = DB::table('data_statistical')
                ->where('dast_ord_id', $value->dast_ord_id)
                ->where('dast_orgo_id', $value->dast_orgo_id)
                ->where('dast_goo_id', $value->dast_goo_id)
                ->select('dast_id', 'dast_ord_id', 'dast_order_number', 'dast_goo_id', 'dast_goo_cost', 'dast_goo_quantity', 'dast_goo_quantitys')
                ->first();
            if (!empty($find_goods)) {
                if ($find_goods->dast_goo_cost != $value->dast_goo_cost) {
                    $data = (array)$value;
                    $data['original_dast_goo_cost'] = $find_goods->dast_goo_cost;
                    $diff_data[] = $data;
                    unset($data);
                }
            } else {
                dump($value);
            }
        }
        dump($diff_data);
    }

    // 订单商品表没有订单号的数据处理
    private function noOrderNumber()
    {
        set_time_limit(0);
        $find_order_goods = DB::table('order_goods as og')
                ->leftjoin('order as o', 'og.orgo_ord_id', '=', 'o.ord_id')
                ->where('orgo_order_number', '')
                ->select('orgo_id', 'orgo_ord_id', 'ord_order_number')
                ->get()->toArray();
        foreach ($find_order_goods as $key => $value) {
            $order_data['orgo_order_number'] = $value->ord_order_number;
            $res = DB::table('order_goods')
                ->where('orgo_id', $value->orgo_id)
                ->where('orgo_ord_id', $value->orgo_ord_id)
                ->update($order_data);
            dump($res);
            unset($order_data);
        }
        dump($find_order_goods);
    }

    // 导出统计的仓库商品进销存
    private function exportWarehousePirce()
    {
        ignore_user_abort();
        set_time_limit(0);
        $find_enter_price = DB::table('enters_sells_saves_price')
                ->select('ense_goo_id', 'ense_goo_number', 'ense_goo_name', 'ense_end_price', 'ense_goo_warehouse', 'ense_end_inventory', 'ense_end_amount')
                ->get()->toArray();
        $find_ware_data = DB::table('warehouse')
            ->where('ware_shop_id', 1)
            ->where('ware_type', 1)
            // ->whereNotIn('ware_id', [96,121,150])
            ->whereIn('ware_id', [9,10,11,13,14,150,156])
            ->pluck('ware_name', 'ware_id')->toArray();
        dump($find_ware_data);
        $first_columns = ['检索编码','商品名称'];
        $list_columns = array_merge($first_columns, $find_ware_data);
        $total_columns = ['平均价'];
        $list_columns = array_merge($list_columns, $total_columns);
        dump($list_columns);

        $find_enter_price = json_decode(json_encode($find_enter_price, true), true);
        $list_data = [];
        $export_data = [];
        foreach ($find_enter_price as $key => $value) {
            $excel_data['ense_goo_number'] = $value['ense_goo_number'];
            $excel_data['ense_goo_name'] = $value['ense_goo_name'];
            if (isset($list_data[$value['ense_goo_id']])) {
                $ense_goo_warehouse = 'ense_goo_warehouse_'.$value['ense_goo_warehouse'];
                $export_data[$value['ense_goo_id']][$ense_goo_warehouse] = $value['ense_end_price'];//商品所在仓库对应的平均价

                $total_price = $value['ense_end_amount'] + $list_data[$value['ense_goo_id']]['ense_end_amount'];
                $total_ense_end_inventory = $value['ense_end_inventory'] + $list_data[$value['ense_goo_id']]['ense_end_inventory'];
                if ($total_ense_end_inventory) {
                    $new_end_price=sprintf("%.4f", $total_price/$total_ense_end_inventory);
                    $export_data[$value['ense_goo_id']]['ense_end_price'] = $new_end_price;//平均价
                }

                $list_data[$value['ense_goo_id']]['ense_end_amount'] = $total_price;
                $list_data[$value['ense_goo_id']]['ense_end_inventory'] = $total_ense_end_inventory;
                unset($total_price);
                unset($total_ense_end_inventory);
            } else {
                foreach ($find_ware_data as $ware_id => $ware_value) {
                    $ense_goo_warehouse = 'ense_goo_warehouse_'.$ware_id;
                    if ($ware_id == $value['ense_goo_warehouse']) {
                        $excel_data[$ense_goo_warehouse] = $value['ense_end_price'];//商品所在仓库对应的平均价
                    } else {
                        $excel_data[$ense_goo_warehouse] = 0;//商品所在仓库对应的平均价
                    }
                }
                $excel_data['ense_end_price'] = $value['ense_end_price'];//平均价

                $list_data[$value['ense_goo_id']] = $value;
                $export_data[$value['ense_goo_id']] = $excel_data;
            }
            unset($excel_data);
        }

        foreach ($export_data as $key => $value) {
            $enters_price_total['ense_goo_number'] = $value['ense_goo_number'];
            $enters_price_total['ense_goo_name'] = $value['ense_goo_name'];
            // $enters_price_total['ense_end_price'] = $value['ense_end_price'];
            $enters_price_total['ense_new_price'] = $value['ense_end_price'];
            $ense_id = DB::table('enters_sells_saves_price_total')
                ->where('ense_goo_number', $value['ense_goo_number'])
                ->value('ense_id');
            if ($ense_id) {
                $enter_edit['ense_new_price'] = $value['ense_end_price'];
                DB::table('enters_sells_saves_price_total')
                ->where('ense_id', $ense_id)
                ->update($enter_edit);
            } else {
                $res = DB::table('enters_sells_saves_price_total')->insert($enters_price_total);
            }
            unset($enters_price_total);
            unset($enter_edit);
        }
        // echo 333;die;
        dump($export_data);
        die;
        $pathName = storage_path()."/app/public/excel";//获取上传excel路径
        // 创建文件夹
        if (!file_exists($pathName)) {
            mkdir($pathName, 0775, true);
            chmod($pathName, 0775);
        }

        $streamFileRand = '仓库商品金额' . time() . rand(1000, 9999).'.xls';
        // 产生一个随机文件名（因为你base64上来肯定没有文件名，这里你可以自己设置一个也行）
        $streamFilename = $pathName . '/' .$streamFileRand;

        $where['action_name'] = '仓库商品金额';
        $where['field_name'] = $list_columns;
        // 调用导出的公共方法
        export::createExport(
            $streamFilename, //路径
            $where,    //sheet名及其每一行的标题
            $export_data      //导出数据
        );
        // $file_name = 'http://mk.bluearp.com/storage/excel/'.$streamFileRand;
        $file_name = 'http://mktest.bluearp.com/storage/excel/'.$streamFileRand;
        dump($file_name);
    }

    // 统计的仓库平均金额不相等的
    private function enterPirceDiff()
    {
        ignore_user_abort();
        set_time_limit(0);
        $find_enter_price = DB::table('enters_sells_saves_price_total')
                ->select('ense_id', 'ense_goo_number', 'ense_goo_name', 'ense_end_price', 'ense_new_price')
                ->get()->toArray();
        $find_enter_price = json_decode(json_encode($find_enter_price, true), true);
        $diff_data = [];
        foreach ($find_enter_price as $key => $value) {
            $value['ense_new_price'] = empty($value['ense_new_price']) ? 0 : $value['ense_new_price'];
            $diff_price = $value['ense_end_price'] - $value['ense_new_price'];
            // if (abs($diff_price) > 1) {
            //     $diff_data[] = $value;
            // }
            if ($value['ense_end_price'] != $value['ense_new_price']) {
                if ($value['ense_new_price'] == '') {
                    $enter_edit['ense_end_inventory'] = 1;
                } else {
                    $enter_edit['ense_end_inventory'] = 2;
                }
                $enter_edit['ense_out_price'] = $diff_price;
                DB::table('enters_sells_saves_price_total')
                ->where('ense_id', $value['ense_id'])
                ->update($enter_edit);
            }
        }
        echo 444;
        dump($diff_data);
    }

    // 统计所有仓库的商品进销存价格
    private function entersWarehousePirce()
    {
        set_time_limit(0);
        $find_ware_data = DB::table('warehouse')
            ->where('ware_shop_id', 1)
            ->where('ware_type', 1)
            ->select('ware_id', 'ware_type')
            ->get()->toArray();
        $search_data['sssg_waon_class'] = 1;
        foreach ($find_ware_data as $key => $value) {
            // 厦门调整仓、财务仓跳过
            if (in_array($value->ware_id, [9,10,11,13,14,150,156])) {
                // if (!in_array($value->ware_id, [9,10,11,13,14])) {
                //     continue;
                $search_data['sssg_ware_id'] = $value->ware_id;
                // dump($search_data);
                $this->entersPirce($search_data);
            }
        }
    }

    // 统计仓库商品进销存金额
    private function entersPirce($request)
    {
        $shop_id = 1;//门店id
        $search_data = $request;
        $list_data = DB::table('enters_sells_saves')
                ->where('ense_shop_id', $shop_id)
                ->where('ense_goo_warehouse', $request['sssg_ware_id'])
                ->where('ense_goo_waretype', $request['sssg_waon_class'])
                ->select('ense_goo_id')
                ->orderBy('ense_id', 'asc')
                ->groupBy('ense_goo_id')
                ->get()->toArray();
        $ids=array_column($list_data, 'ense_goo_id');
        unset($list_data);
        $list = DB::table('enters_sells_saves')
            ->where('ense_shop_id', $shop_id)
            ->where('ense_goo_warehouse', $request['sssg_ware_id'])
            ->where('ense_goo_waretype', $request['sssg_waon_class'])
            ->whereIn('ense_goo_id', $ids)
            ->select('ense_id', 'ense_goo_id', 'ense_goo_name', 'ense_goo_number', 'ense_goo_unit', 'ense_goo_specifications', 'ense_goo_waretype', 'ense_goo_warehouse', 'ense_new_inventory', 'ense_new_price', 'ense_new_amount', 'ense_end_inventory', 'ense_end_price', 'ense_end_amount', 'ense_out_num', 'ense_out_price', 'ense_out_amount', 'ense_in_num', 'ense_in_price', 'ense_in_amount', 'ense_order_number', 'ense_out_in', 'ense_type', 'ense_time')
            ->orderBy('ense_id', 'asc')
            ->get()->toArray();
        unset($ids);
        $dataayyar=array();
        if ($list) {
            // 查询仓库数据
            $listarray=array();
            $list=json_decode(json_encode($list), true);
            foreach ($list as $k=>$v) {
                unset($v['ense_id']);

                if (isset($listarray[$v['ense_goo_id']])) {
                    $listarray[$v['ense_goo_id']]['ense_end_inventory']=$v['ense_end_inventory'];
                    $listarray[$v['ense_goo_id']]['ense_end_price']=sprintf("%.4f", $v['ense_end_price']);
                    $listarray[$v['ense_goo_id']]['ense_end_amount']=sprintf("%.4f", $v['ense_end_amount']);
                    if (substr($v['ense_order_number'], 0, 2)=='DB') {
                        $listarray[$v['ense_goo_id']]['mouthnums']=$listarray[$v['ense_goo_id']]['mouthnums']+$v['ense_in_num']-$v['ense_out_num'];
                        $listarray[$v['ense_goo_id']]['mouthprice']=sprintf("%.4f", $listarray[$v['ense_goo_id']]['mouthprice']+$v['ense_in_amount']-$v['ense_out_amount']);
                    } else {
                        $listarray[$v['ense_goo_id']]['ense_out_num']=$v['ense_out_num']+$listarray[$v['ense_goo_id']]['ense_out_num'];
                        $listarray[$v['ense_goo_id']]['ense_out_amount']=sprintf("%.4f", $v['ense_out_amount']+$listarray[$v['ense_goo_id']]['ense_out_amount']);
                        $listarray[$v['ense_goo_id']]['ense_in_num']=$v['ense_in_num']+$listarray[$v['ense_goo_id']]['ense_in_num'];
                        $listarray[$v['ense_goo_id']]['ense_in_amount']=sprintf("%.4f", $v['ense_in_amount']+$listarray[$v['ense_goo_id']]['ense_in_amount']);
                    }
                } else {
                    if (substr($v['ense_order_number'], 0, 2)=='DB') {
                        $v['mouthnums']=$v['ense_in_num']-$v['ense_out_num'];
                        $v['mouthprice']=sprintf("%.4f", $v['ense_in_amount']-$v['ense_out_amount']);
                        $v['ense_out_num']=0;
                        $v['ense_out_amount']=0;
                        $v['ense_in_num']=0;
                        $v['ense_in_amount']=0;
                    } else {
                        $v['mouthnums']=0;
                        $v['mouthprice']=0;
                    }
                    $listarray[$v['ense_goo_id']]=$v;
                }
            }
            $i="0";
            foreach ($listarray as $k=>$v) {
                $dataayyar[$i]=$v;
                $ce=sprintf("%.0f", $v['ense_end_price']-$v['ense_new_price']);
                $dataayyar[$i]['new_end_price']=$ce;
                if ($v['ense_out_num']=='0') {
                    $dataayyar[$i]['ense_out_price']='0';
                } else {
                    $dataayyar[$i]['ense_out_price']=sprintf("%.4f", $v['ense_out_amount']/$v['ense_out_num']);
                }
                if ($v['ense_in_num']=='0') {
                    $dataayyar[$i]['ense_in_price']='0';
                } else {
                    $dataayyar[$i]['ense_in_price']=sprintf("%.4f", $v['ense_in_amount']/$v['ense_in_num']);
                }
                
                $i=$i+1;
            }
        }
        unset($list);

        $res = DB::table('enters_sells_saves_price')->insert($dataayyar);
        dump($res);
        // dump($dataayyar);die;
        unset($dataayyar);
        unset($listarray);
    }

    // 订单、工单结算金额不一致数据统计
    private function diffOrderWorkPirce()
    {
        set_time_limit(0);
        $find_order_data = DB::table('order as o')
            ->leftjoin('order_client as oc', 'oc.orcl_ord_id', '=', 'o.ord_id')
            ->where('ord_superior_shop_id', 1)
            ->where('ord_shop_id', 1)
            ->where('ord_delete', 1)
            ->where('ord_collection_bill', 1)
            // ->whereIn('ord_service_type', [1,7])
            ->select('ord_id', 'ord_order_number', 'ord_goods_quantity', 'ord_shop_id', 'ord_type', 'ord_actual_price', 'ord_order_price', 'ord_collection_price', 'orcl_shipment_party')
            ->get()->toArray();
        $diff_order = [];
        $diff_key = 0;
        foreach ($find_order_data as $key => $value) {
            if ($value->orcl_shipment_party == 4) {
                continue;
            }
            // 查询工单金额
            $find_wor_data = DB::table('work_order')
                ->where('wor_shop_id', $value->ord_shop_id)
                ->where('wor_order_id', $value->ord_id)
                ->where('wor_delete', 1)
                ->where('wor_state', '<>', 11)
                ->where('wor_collection_bill', 1)
                ->select('wor_id', 'wor_number', 'wor_goo_amount', 'wor_actual_price', 'wor_collection_price', 'wor_type')
                ->first();
            // 订单金额与工单金额不一致的
            if (!empty($find_wor_data->wor_actual_price) && $find_wor_data->wor_actual_price != $value->ord_actual_price
             && $find_wor_data->wor_goo_amount == $value->ord_goods_quantity) {
                $diff_order[$diff_key]['order'] = $value;
                $diff_order[$diff_key]['work'] = $find_wor_data;
                $diff_key++;
            }
            unset($value);
            unset($find_wor_data);

            // 查询应收应付的金额
            // $find_wor_data = DB::table('receivable_credit')
            //     ->where('recr_shop_id', $value->ord_shop_id)
            //     ->where('recr_original_id', $value->ord_id)
            //     ->where('recr_original_number', $value->ord_order_number)
            //     ->select('recr_id', 'recr_type', 'recr_account_type', 'recr_plus_minus', 'recr_original_id', 'recr_original_number')
            //     ->first();
        }
        dump($diff_order);
    }

    // 同步仓库中赠品商品数据
    private function synchronizeWarehouseGift()
    {
        set_time_limit(0);
        $find_wago_data = DB::table('warehouse_goods as wg')
            ->leftjoin('warehouse as w', 'w.ware_id', '=', 'wg.wago_ware_id')
            ->where('ware_shop_id', 1)
            ->where('ware_type', 1)
            ->where('wago_class', 1)
            ->select('wago_ware_id', 'wago_class', 'wago_goo_id')
            ->get()->toArray();
        $diff_wago_data = [];
        foreach ($find_wago_data as $key => $value) {
            $goo_id = DB::table('goods')
                ->where('goo_fid', $value->wago_goo_id)
                ->where('goo_type', 2)
                ->value('goo_id');
            if ($goo_id) {
                $find_wago_id = DB::table('warehouse_goods')
                ->where('wago_class', 2)
                ->where('wago_ware_id', $value->wago_ware_id)
                ->where('wago_goo_id', $goo_id)
                ->value('wago_id');
                if (empty($find_wago_id)) {
                    dump($value);
                    // $wago_data['wago_ware_id'] = $value->wago_ware_id;
                    // $wago_data['wago_goo_id'] = $goo_id;
                    // $wago_data['wago_class'] = 2;
                    // $res = DB::table('warehouse_goods')->insert($wago_data);
                    // unset($wago_data);
                    // dump($res);
                }
            }
        }
        // dump($find_wago_data);die;
        dump($diff_wago_data);
        die;
    }

    //同步产品商品属性单位
    private function synchronizationGoodsUnit()
    {
        set_time_limit(0);
        $find_goods = DB::table('goods')
            ->where('goo_attribute', '<>', '')
            ->select('goo_id', 'goo_attribute', 'goo_unit')
            ->get()->toArray();
        // dump($find_goods);
        foreach ($find_goods as $key => $value) {
            $goo_attribute=json_decode($value->goo_attribute, true);
            foreach ($goo_attribute as $attr_key => $attr_value) {
                if ($attr_value['key'] == '单位') {
                    $goo_res =  DB::table('goods')
                        ->where('goo_id', $value->goo_id)
                        ->update(['goo_unit'=>$attr_value['value']]);
                    dump($goo_res);
                }
            }
            unset($goo_attribute);
        }
        echo 999;
    }

    // 统计单位类型数量
    public function totalChannelType()
    {
        $find_data = DB::table('channel_unit')
            ->where('chun_shop_id', 1)
            ->groupBy('chun_chty_id')
            ->select(DB::raw('count(chun_id) as chun_id_count'), 'chun_chty_id')
            ->get()->toArray();
        foreach ($find_data as $key => $value) {
            DB::table('channel_type')
            ->where('chty_id', $value->chun_chty_id)
            ->update(['chty_channel_number'=>$value->chun_id_count]);
        }
        dump($find_data);
        die;
    }

    // 更新客户单位数据
    public function updateChannleExcelData()
    {
        set_time_limit(0);
        $find_data = DB::table('excel_data_cache')
            ->where('exdc_type', 6)
            ->get()->toArray();
        $diff_adm_id = [];
        $diff_prec_id = [];
        $diff_unit = [];
        $diff_unit_name = [];
        $now_time = date('Y-m-d H:i:s');
        foreach ($find_data as $key => $value) {
            $exdc_data = json_decode($value->exdc_data, true);
            if (empty($exdc_data)) {
                continue;
            }

            //业务员
            $adm_id = DB::table('admin')
                ->leftJoin('admin_shop_role as asr', 'asr.adm_id', '=', 'admin.adm_id')
                ->where('asr.shop_id', 1)
                ->where('admin.adm_phone', $exdc_data['chun_adm_phone'])
                ->value('admin.adm_id');
            if (empty($adm_id)) {
                continue;
                $diff_adm_id[] = $exdc_data;
            }

            //业务划区
            $prec_id = DB::table('precincts')
                ->where('prec_shop_id', 1)
                ->where('prec_name', $exdc_data['chun_zoning'])
                ->value('prec_id');
            if (empty($adm_id)) {
                $diff_prec_id[] = $exdc_data;
            }

            // 查找客户单位类型
            $find_chty_id = DB::table('channel_type')
                ->where('chty_shop_id', 1)
                ->where('chty_name', $exdc_data['chun_chty_id'])
                ->value('chty_id');
            if (empty($find_chty_id)) {
                dump($exdc_data);
                $diff_unit[] = $exdc_data;
            }

            // 查找客户单位名称
            $find_chun_id = DB::table('channel_unit')
                ->where('chun_shop_id', 1)
                ->where('chun_unit_name', $exdc_data['chun_unit_name'])
                ->value('chun_id');
            if (empty($find_chun_id)) {
                $diff_unit_name[] = $exdc_data['chun_unit_name'];
            }
            $chin_data = [];
            $json_arr = [];
            if (!empty($exdc_data['name_phone'])) {
                $name_phone_arr = explode(', ', $exdc_data['name_phone']);
                foreach ($name_phone_arr as $phone_key => $phone_value) {
                    $phone_arr = explode('：', $phone_value);
                    if ($phone_key == 0) {
                        $chun_name = $phone_arr[0];
                        $chun_phone = $phone_arr[1];
                        $json_arr[$phone_key]['key'] = $phone_arr[0];
                        $json_arr[$phone_key]['value'] = $phone_arr[1];
                        $json_arr[$phone_key]['default'] = 1;
                    } else {
                        $json_arr[$phone_key]['key'] = $phone_arr[0];
                        $json_arr[$phone_key]['value'] = $phone_arr[1];
                        $json_arr[$phone_key]['default'] = 2;
                    }
                    unset($phone_arr);
                }
                unset($name_phone_arr);
            }
            $chin_phone_data = json_encode($json_arr);

            $chin_data['chin_main_brand'] = ''; //主营品牌
            $chin_data['chin_second_brand'] = ''; //    次营品牌
            $chin_data['chin_owe_day'] = $exdc_data['chin_owe_day']; //可欠
            $chin_data['chin_caution_day'] = $exdc_data['chin_caution_day'];//警戒
            $chin_data['chin_level'] = $exdc_data['chin_level'];//警戒
            $chin_data['chin_type'] = 2;//铺货类型：1是铺货 2不是铺货
            $chin_data['chin_owe_money'] = $exdc_data['chin_owe_money'];//  可欠金额
            $chin_data['chin_prec_id'] = $prec_id; //业务划区id
            $chin_data['chin_zoning'] = $exdc_data['chun_zoning']; //业务划区
            $chin_data['chin_remarks'] = $exdc_data['chin_remarks']; //备注
            $chin_data['chin_data'] = $chin_phone_data; //联系人电话json数据
            $chin_data['chin_update_time'] = $now_time; //更新时间
            $res = DB::table('channel_info')->where('chin_chun_id', $find_chun_id)->update($chin_data);

            $chun_data['chun_adm_id'] = $adm_id; //业务员账号id
            $chun_data['chun_search_letter'] = $exdc_data['chun_search_letter'];//检索字母
            $chun_data['chun_unit_name'] = $exdc_data['chun_unit_name'];//客户单位名称
            $chun_data['chun_name'] = $chun_name;//联系人姓名
            $chun_data['chun_phone'] = $chun_phone;//联系人电话
            $chun_data['chun_chty_id'] = $find_chty_id;//渠道类型id
            $chun_data['chun_payment_way'] = $exdc_data['chun_payment_way'];//结算方式1.账期 2.现结
            $chun_data['chun_province'] = $exdc_data['chun_province'];//结算方式1.账期 2.现结
            $chun_data['chun_province'] = $exdc_data['chun_province'];//省
            $chun_data['chun_city'] = $exdc_data['chun_city'];//    市
            $chun_data['chun_county'] = $exdc_data['chun_county'];//区县
            $chun_data['chun_address'] = $exdc_data['chun_address'];//详细地址
            $chun_data['chun_update_time'] = $now_time; //更新时间
            $chun_res = DB::table('channel_unit')->where('chun_id', $find_chun_id)->update($chun_data);
            dump($res.'--'.$chun_res);
            unset($exdc_data);
            unset($find_unit);
            unset($chin_data);
            unset($chun_data);
        }
        dump($diff_adm_id);
        dump($diff_prec_id);
    }

    // 导入客户单位Excel数据
    public function importChannleExcelData()
    {
        $path = public_path('img/客户单位（20.12.28 18：00）最新.xlsx');
        if (is_file($path)) {
            $spreadsheet = \PhpOffice\PhpSpreadsheet\IOFactory::load($path);//如果文件存在则直接载入
            $sheet = $spreadsheet->getActiveSheet();//获取活动的工作sheet
            $highest_row = $sheet->getHighestRow(); // 取得总行数

            $n = 0;
            $exdc_data = [];
            $exdc_update_time = date('Y-m-d H:i:s');
            for ($row = 2; $row <= $highest_row; $row++) {
                // 厦门客户单位
                $excel_data['chun_search_letter'] = trim($sheet->getCellByColumnAndRow(1, $row)->getValue());//检索字母
                $excel_data['chun_unit_name'] = trim($sheet->getCellByColumnAndRow(2, $row)->getValue());//客户单位名称
                $excel_data['chun_chty_id'] = trim($sheet->getCellByColumnAndRow(3, $row)->getValue());//单位类型
                $excel_data['name_phone'] = trim($sheet->getCellByColumnAndRow(4, $row)->getValue());//联系人和电话
                $excel_data['chin_caution_day'] = trim($sheet->getCellByColumnAndRow(5, $row)->getValue());//警示天数
                $excel_data['chin_owe_day'] = trim($sheet->getCellByColumnAndRow(6, $row)->getValue());//可欠天数
                $excel_data['chin_owe_money'] = trim($sheet->getCellByColumnAndRow(7, $row)->getValue());//可欠金额
                $excel_data['chin_level'] = trim($sheet->getCellByColumnAndRow(8, $row)->getValue());//客户等级
                $excel_data['chun_payment_way'] = trim($sheet->getCellByColumnAndRow(9, $row)->getValue());//结算方式1.账期 2.现结
                $excel_data['chun_adm_id'] = trim($sheet->getCellByColumnAndRow(10, $row)->getValue());//业务员账号id
                $excel_data['chun_adm_phone'] = trim($sheet->getCellByColumnAndRow(11, $row)->getValue());//业务员电话
                $excel_data['chun_zoning'] = trim($sheet->getCellByColumnAndRow(12, $row)->getValue());//业务员电话
                $excel_data['chun_province'] = trim($sheet->getCellByColumnAndRow(13, $row)->getValue());//省
                $excel_data['chun_city'] = trim($sheet->getCellByColumnAndRow(14, $row)->getValue());//市
                $excel_data['chun_county'] = trim($sheet->getCellByColumnAndRow(15, $row)->getValue());//区县
                $excel_data['chun_address'] = trim($sheet->getCellByColumnAndRow(16, $row)->getValue());//详细地址
                $excel_data['chin_remarks'] = trim($sheet->getCellByColumnAndRow(17, $row)->getValue());//备注
                // dump($excel_data);
                // die;

                $exdc_data[$n]['exdc_type'] = 6;
                $exdc_data[$n]['exdc_update_time'] = $exdc_update_time;
                $exdc_data[$n]['exdc_data'] = json_encode($excel_data);
                $n++;
                unset($excel_data);
            }
            // dump($exdc_data);
            // die;
            // $res = DB::table('excel_data_cache')->insert($exdc_data);
            $res = DB::table('excel_data_cache')->insert($exdc_data);
            dump($res);
            // die;
        }
        echo 999;
        die;
    }
    
    // 其他订单的没有图片模板的，添加图片模板
    private function otherOrderImage()
    {
        // 速电工单未完成的
        // $find_wor_data = DB::table('work_client as wc')
        //     ->leftjoin('work_order as wo', 'wo.wor_id', '=', 'wc.wocl_wor_id')
        //     ->where('wor_type', 3)
        //     // ->where('wocl_shit_id', 1)
        //     ->where('wor_service_state', '<', 6)
        //     ->select('wor_order_id', 'wocl_wor_id', 'wocl_shit_id')
        //     ->get()->toArray();
        // dump($find_wor_data);
        // die;
        // $find_order_data = DB::table('order as o')
        //     ->leftjoin('order_client as oc', 'oc.orcl_ord_id', '=', 'o.ord_id')
        //     ->whereIn('ord_service_type', [1,7])
        //     ->where('orcl_shit_id', 0)
        //     ->select('ord_id', 'orcl_id', 'ord_type')
        //     ->get()->toArray();
        // dump($find_order_data);
        // die;
        // foreach ($find_order_data as $key => $value) {
        //     if ($value->ord_type == 3) {
        //         $shit_id = 2;
        //     }else{
        //         $shit_id = 1;
        //     }
        //     $res = DB::table('order_client')->where('orcl_ord_id', $value->ord_id)->update(['orcl_shit_id'=>$shit_id]);
        //     dump($res);
        // }
        // $find_wor_data = DB::table('work_client')
        //     ->where('wocl_shit_id', 0)
        //     ->select('wocl_id', 'wocl_wor_id')
        //     ->get()->toArray();
        // dump($find_wor_data);
        // die;
        // foreach ($find_wor_data as $key => $value) {
        //     $find_wor = DB::table('work_order')
        //         ->where('wor_id', $value->wocl_wor_id)
        //         ->select('wor_order_id', 'wor_type')
        //         ->first();
        //     if (empty($find_wor)) {
        //         continue;
        //     }
        //     if ($find_wor->wor_type == 3) {
        //         $shit_id = 2;
        //     }else{
        //         $shit_id = 1;
        //     }
        //     // 更改工单客户表的图片模板id
        //     $res = DB::table('work_client')->where('wocl_wor_id', $value->wocl_wor_id)->update(['wocl_shit_id'=>$shit_id]);
        //     // 更改订单客户表的图片模板id
        //     $res = DB::table('order_client')->where('orcl_ord_id', $find_wor->wor_order_id)->update(['orcl_shit_id'=>$shit_id]);
        //     dump($res);
        //     unset($find_wor);
        // }
    }

    // 工单表保存的图片路径同步到图片路径表
    private function workImageAdjust()
    {
        set_time_limit(0);
        $shit_id = 1;
        // 根据图片上传模板判断上传图片
        $find_image_template = DB::table('shop_image_template')
                ->where('shit_id', $shit_id)
                ->value('shit_template_set');
        $find_image_template = json_decode($find_image_template, true);
        // dump($find_image_template);

        $find_work_image = DB::table('work_order')
            // ->where('wor_cid', 1)
            // ->where('wor_shop_id', 1)
            // ->where('wor_create_time', '<', '2020-11-01 00:00:00')
            // ->where('wor_create_time', '>=', '2020-11-01 00:00:00')
            // ->where('wor_create_time', '<', '2020-12-28 00:00:00')
            ->where('wor_create_time', '>=', '2020-12-28 00:00:00')
            ->select('wor_id', 'wor_cid', 'wor_superior_shop_id', 'wor_shop_id', 'wor_order_id', 'wor_type', 'wor_img', 'wor_achieve_time')
            ->get()->toArray();
        $now_time = date('Y-m-d H:i:s');
        foreach ($find_work_image as $key => $value) {
            if (!empty($value->wor_img)) {
                // $wor_img = json_decode($value->wor_img, true);
                // foreach ($wor_img as $img_key => $img_path) {
                //     $imup_data[$img_key]['imup_cid'] = $value->wor_cid;
                //     $imup_data[$img_key]['imup_shop_id'] = $value->wor_shop_id;
                //     $imup_data[$img_key]['imup_superior_shop_id'] = $value->wor_superior_shop_id;
                //     $imup_data[$img_key]['imup_ord_id'] = $value->wor_order_id;
                //     $imup_data[$img_key]['imup_wor_id'] = $value->wor_id;
                //     $imup_data[$img_key]['imup_path'] = empty($img_path) ? '' : $img_path;
                //     $imup_data[$img_key]['imup_image_name'] = $find_image_template[$img_key]['show_word'];
                //     $imup_data[$img_key]['imup_create_time'] = $value->wor_achieve_time;
                //     $imup_data[$img_key]['imup_update_time'] = $now_time;
                // }
                // $res = DB::table('image_upload')->insert($imup_data);
                // 更改工单客户表的图片模板id
                $res = DB::table('work_client')->where('wocl_wor_id', $value->wor_id)->update(['wocl_shit_id'=>$shit_id]);
                // 更改订单客户表的图片模板id
                $res = DB::table('order_client')->where('orcl_ord_id', $value->wor_order_id)->update(['orcl_shit_id'=>$shit_id]);
                // dump($res);
                unset($imup_data);
                unset($wor_img);
                unset($res);
            }
        }
        echo 111;
        die;
    }

    // 将盘库单加入到出入库记录
    private function stocktakeGoodsRecord()
    {
        $find_stocktake = DB::table('stocktake')
            ->where('stoc_cid', 1)
            ->where('stoc_shop_id', 1)
            ->where('stoc_state', 3)
            ->get()->toArray();
        foreach ($find_stocktake as $key => $value) {
            $find_stoc_goods = DB::table('stocktake_goods')
                ->where('stgo_stoc_id', $value->stoc_id)
                ->get()->toArray();
            $out_goods = [];//出库商品
            $in_goods = [];//入库商品
            $out_goods_count = 0;
            $in_goods_count = 0;
            $out_key = 0;
            $in_key = 0;
            foreach ($find_stoc_goods as $stoc_key => $stoc_value) {
                // 良品差异数量 = 良品库存数量 - 良品盘点数量
                $diff_stock_number = $stoc_value->stgo_stock_number - $stoc_value->stgo_stocktake_number;
                if ($diff_stock_number != 0) {
                    if ($diff_stock_number > 0) {
                        // 库存数量减少，属于出库
                        $out_goods[$out_key]['goo_id'] = $stoc_value->stgo_goo_id;
                        $out_goods[$out_key]['oude_goo_number'] = abs($diff_stock_number);
                        $out_goods[$out_key]['oude_type'] = 1;
                        $out_goods_count += $out_goods[$out_key]['oude_goo_number'];
                        $out_key++;
                    } else {
                        // 库存数量增加，属于入库
                        $in_goods[$in_key]['goo_id'] = $stoc_value->stgo_goo_id;
                        $in_goods[$in_key]['oude_goo_number'] = abs($diff_stock_number);
                        $in_goods[$in_key]['oude_type'] = 1;
                        $in_goods_count += $in_goods[$in_key]['oude_goo_number'];
                        $in_key++;
                    }
                }
                // 优先差异数量 = 优先库存数量 - 优先盘点数量
                $diff_priority_stock_number = $stoc_value->stgo_priority_stock_number - $stoc_value->stgo_priority_stocktake_number;
                if ($diff_priority_stock_number != 0) {
                    if ($diff_priority_stock_number > 0) {
                        // 库存数量减少，属于出库
                        $out_goods[$out_key]['goo_id'] = $stoc_value->stgo_goo_id;
                        $out_goods[$out_key]['oude_goo_number'] = abs($diff_priority_stock_number);
                        $out_goods[$out_key]['oude_type'] = 2;
                        $out_goods_count += $out_goods[$out_key]['oude_goo_number'];
                        $out_key++;
                    } else {
                        // 库存数量增加，属于入库
                        $in_goods[$in_key]['goo_id'] = $stoc_value->stgo_goo_id;
                        $in_goods[$in_key]['oude_goo_number'] = abs($diff_priority_stock_number);
                        $in_goods[$in_key]['oude_type'] = 2;
                        $in_goods_count += $in_goods[$in_key]['oude_goo_number'];
                        $in_key++;
                    }
                }
                // 待检测差异数量 = 待检测库存数量 - 待检测盘点数量
                $diff_unchecked_stocktake_number = $stoc_value->stgo_unchecked_stock_number - $stoc_value->stgo_unchecked_stocktake_number;
                if ($diff_unchecked_stocktake_number != 0) {
                    if ($diff_unchecked_stocktake_number > 0) {
                        // 库存数量减少，属于出库
                        $out_goods[$out_key]['goo_id'] = $stoc_value->stgo_goo_id;
                        $out_goods[$out_key]['oude_goo_number'] = abs($diff_unchecked_stocktake_number);
                        $out_goods[$out_key]['oude_type'] = 3;
                        $out_goods_count += $out_goods[$out_key]['oude_goo_number'];
                        $out_key++;
                    } else {
                        // 库存数量增加，属于入库
                        $in_goods[$in_key]['goo_id'] = $stoc_value->stgo_goo_id;
                        $in_goods[$in_key]['oude_goo_number'] = abs($diff_unchecked_stocktake_number);
                        $in_goods[$in_key]['oude_type'] = 3;
                        $in_goods_count += $in_goods[$in_key]['oude_goo_number'];
                        $in_key++;
                    }
                }
            }
            // if ($value->stoc_storage_number == 'P0112241606540122529') {
            //     dump($find_stoc_goods);
            dump($out_goods);
            //     dump($in_goods);
            //     die;
            // }
            if ($out_goods) {
                // 生成出入库记录
                $number = time().rand(10000, 99999); //共15位
                // 出入库记录表新增数据
                $record['oure_cid'] = $value->stoc_cid; //公司id
                $record['oure_shop_id'] = $value->stoc_shop_id; //门店id
                $record['oure_superior_shop_id'] = $value->stoc_superior_shop_id; //门店id
                $record['oure_adm_id'] = $value->stoc_adm_id; //操作人
                $record['oure_number'] = $number; //单号
                $record['oure_original_correlation_id'] = $value->stoc_id; //原始单的关联id
                $record['oure_original_correlation_number'] = $value->stoc_storage_number; //原始单的关联单号
                $record['oure_original_correlation_type'] = 8; //原始单的关联类型1.订单2.调拨单3.采购单4.销售单5.旧货回收6.退货入库7.售后
                $record['oure_client_type'] = 0; //买家类型：1.会员零售2.客户单位3.速电派单4.第三方派单
                $record['oure_client_id'] = 0; //选择的客户id,会员id/单位id
                $record['oure_original_number'] = $value->stoc_storage_number; //原始单号
                $record['oure_in_ware_id'] = 0; //入库仓库id
                $record['oure_out_ware_id'] = $value->stoc_ware_id; //出库仓库id
                $record['oure_count'] = $out_goods_count; //出库的商品总量
                $record['oure_type'] = 15; //类型1.入库单 2.出库单 3.调货单 4.旧货回收单 5.退换回收单 6.订单出库 7.部分入库 8.部分出库
                $record['oure_operation_type'] = 2; //操作类型：1锁定库存2出库3入库4调货5发货
                // $record['oure_all_stock'] = $out_goods_count; //良品总库存
                // $record['oure_lock_quantity'] = $oure_lock_quantity; //良品锁定数量
                // $record['oure_priority_all_stock'] = $oure_priority_all_stock; //优先总库存
                // $record['oure_priority_lock_quantity'] = $oure_priority_lock_quantity; //优先锁定数量
                // $record['oure_unchecked_all_stock'] = $oure_unchecked_all_stock; //待检测总库存
                $record['oure_create_time'] = $value->stoc_update_time;
                $record['oure_update_time'] = $value->stoc_update_time;
                $record['oure_out_in_type'] = 1;//出入库类型：1出库，2入库
                $record['oure_waon_class'] = $value->stoc_waon_class;//仓库类别
                $record_add = DB::table('outin_record')->insertGetId($record);

                foreach ($out_goods as $out_key => $out_value) {
                    // 出库记录详情
                    $oude_data[$out_key]['oude_oure_id'] = $record_add;
                    $oude_data[$out_key]['oude_update_time'] = $value->stoc_update_time;
                    $oude_data[$out_key]['oude_goo_id'] = $out_value['goo_id'];
                    $oude_data[$out_key]['oude_goo_number'] = $out_value['oude_goo_number'];//实际出库数量
                    $oude_data[$out_key]['oude_type'] = $out_value['oude_type'];//类型1良品2优先
                }
                // dump($record);
                // dump($oude_data);die;
                $outde_res  = DB::table('outin_details')->insert($oude_data);
                unset($oude_data);
                unset($record);
                unset($out_goods);
            }
            if ($in_goods) {
                // 生成出入库记录
                $number = time().rand(10000, 99999); //共15位
                // 出入库记录表新增数据
                $record['oure_cid'] = $value->stoc_cid; //公司id
                $record['oure_shop_id'] = $value->stoc_shop_id; //门店id
                $record['oure_superior_shop_id'] = $value->stoc_superior_shop_id; //门店id
                $record['oure_adm_id'] = $value->stoc_adm_id; //操作人
                $record['oure_number'] = $number; //单号
                $record['oure_original_correlation_id'] = $value->stoc_id; //原始单的关联id
                $record['oure_original_correlation_number'] = $value->stoc_storage_number; //原始单的关联单号
                $record['oure_original_correlation_type'] = 8; //原始单的关联类型1.订单2.调拨单3.采购单4.销售单5.旧货回收6.退货入库7.售后
                $record['oure_client_type'] = 0; //买家类型：1.会员零售2.客户单位3.速电派单4.第三方派单
                $record['oure_client_id'] = 0; //选择的客户id,会员id/单位id
                $record['oure_original_number'] = $value->stoc_storage_number; //原始单号
                $record['oure_in_ware_id'] = $value->stoc_ware_id; //入库仓库id
                $record['oure_out_ware_id'] = 0; //出库仓库id
                $record['oure_count'] = $in_goods_count; //出库的商品总量
                $record['oure_type'] = 15; //类型1.入库单 2.出库单 3.调货单 4.旧货回收单 5.退换回收单 6.订单出库 7.部分入库 8.部分出库
                $record['oure_operation_type'] = 3; //操作类型：1锁定库存2出库3入库4调货5发货
                // $record['oure_all_stock'] = $out_goods_count; //良品总库存
                // $record['oure_lock_quantity'] = $oure_lock_quantity; //良品锁定数量
                // $record['oure_priority_all_stock'] = $oure_priority_all_stock; //优先总库存
                // $record['oure_priority_lock_quantity'] = $oure_priority_lock_quantity; //优先锁定数量
                // $record['oure_unchecked_all_stock'] = $oure_unchecked_all_stock; //待检测总库存
                $record['oure_create_time'] = $value->stoc_update_time;
                $record['oure_update_time'] = $value->stoc_update_time;
                $record['oure_out_in_type'] = 2;//出入库类型：1出库，2入库
                $record['oure_waon_class'] = $value->stoc_waon_class;//仓库类别
                $record_add = DB::table('outin_record')->insertGetId($record);

                foreach ($in_goods as $out_key => $out_value) {
                    // 出库记录详情
                    $oude_data[$out_key]['oude_oure_id'] = $record_add;
                    $oude_data[$out_key]['oude_update_time'] = $value->stoc_update_time;
                    $oude_data[$out_key]['oude_goo_id'] = $out_value['goo_id'];
                    $oude_data[$out_key]['oude_goo_number'] = $out_value['oude_goo_number'];//实际出库数量
                    $oude_data[$out_key]['oude_type'] = $out_value['oude_type'];//类型1良品2优先
                }
                // dump($record);
                // dump($oude_data);die;
                $outde_res  = DB::table('outin_details')->insert($oude_data);
                unset($oude_data);
                unset($record);
                unset($in_goods);
            }
        }
    }

    // 更改绑定商品，速电商品与厦门的商品绑定，
    // 出入库记录里不是厦门商品，与出入库记录相关的单子商品数据
    private function changeBoundGoods()
    {
        $find_record_data = DB::table('outin_details as od')
            ->leftjoin('outin_record as or', 'od.oude_oure_id', '=', 'or.oure_id')
            ->leftjoin('goods as g', 'od.oude_goo_id', '=', 'g.goo_id')
            ->where('oure_cid', 1)
            ->where('oure_shop_id', 1)
            ->where('goo_class', 2)
            ->select('oure_number', 'oure_original_number', 'goo_name', 'goo_goods_encode', 'oude_goo_number', 'goo_id', 'goo_type', 'oure_waon_class', 'oure_create_time')
            ->get()->toArray();
        // dump($find_record_data);
        // die;
        // $goo_arr = [8355,7992,8473,8473,7674,7776,8472,7992,7992,7992,7872,7773,7671,7992,7992,8091,8097,8097,8091,8106,7992,7992,7674,7671,7675,7675,7675,8124,8124,8124,7671,8473,8473,8473,8067,7905,7905,7905,7689,7671,7671,7870,7870,7870,7870,7903,7903,7660,7660];
        // $goo_arr = array_unique($goo_arr);
        // 去重后的商品id
        $goo_unique_arr = [8355,7992,8473,7674,7776,8472,7872,7773,7671,8091,8097,8106,7675,8124,8067,7905,7689,7870,7903,7660];
        // dump($goo_unique_arr);
        $before_bound = [];//原来的绑定关系
        $now_bound = [];//现在速电商品的绑定关系
        // 查询系统商品是否与速电商品有绑定关系
        foreach ($find_record_data as $key => $value) {
            $find_correlation =DB::table('goods_correlation')
                ->where('goco_cid', 1)
                ->where('goco_shop_id', 1)
                ->where('goco_goo_id', $value->goo_id)
                ->value('goco_system_goo_id');
            if ($find_correlation) {
                dump($find_correlation);
                dump($value);
                $before_bound[$value->goo_id] = $find_correlation;
            }

            // 根据商品编码查询速电商品的绑定商品
            $find_now_goods =DB::table('system_goods as sg')
                ->leftjoin('goods_correlation as gc', 'sg.sygo_system_goo_id', '=', 'gc.goco_system_goo_id')
                ->leftjoin('goods as g', 'g.goo_id', '=', 'gc.goco_goo_id')
                ->where('goco_cid', 1)
                ->where('goco_shop_id', 1)
                ->where('sygo_delete', 1)
                ->where('sygo_goods_code', $value->goo_goods_encode)
                ->select('goo_name', 'goo_goods_encode', 'goo_id', 'sygo_system_goo_id')
                ->first();
            if ($find_now_goods) {
                $now_bound[$value->goo_id]['now_goo_id'] = $find_now_goods->goo_id;
                $now_bound[$value->goo_id]['value'] = $value;
                // dump($value);
                // dump($find_now_goods);
            }
        }
        dump($now_bound);
        echo 333;
        die;
    }

    // 统计锁定商品库存
    private function lockGoodsOrder2()
    {
        $shop_id = 1;
        $find_ware = DB::table('warehouse')
            ->where('ware_cid', 1)
            ->where('ware_shop_id', 1)
            ->select('ware_id')
            ->get()->toArray();
        // $ware_id = array_column($find_ware, 'ware_id');
        $ware_id = [9,10,11,13,14];
        // 查询仓库有锁定数量的
        $waog_stock_type = 1;
        $find_goods = DB::table('warehouse_goods as a')
                        ->where(function ($query) use ($waog_stock_type) {
                            $query->where('wago_lock_quantity', '>', 0)
                                  ->orWhere('wago_priority_lock_quantity', '>', 0);
                        })
                        ->whereIn('wago_ware_id', $ware_id)
                        ->select('wago_stock_number', 'wago_lock_quantity', 'wago_priority_stock_number', 'wago_priority_lock_quantity', 'wago_unchecked_stock_number', 'wago_ware_id', 'wago_class', 'wago_goo_id', 'wago_id')
                        ->get()->toArray();
        foreach ($find_goods as $key => $value) {
            $wago_data['wago_ware_id'] = $value->wago_ware_id;
            $wago_data['wago_class'] = $value->wago_class;
            $wago_data['wago_goo_id'] = $value->wago_goo_id;
            $wago_data['wago_lock_quantity'] = $value->wago_lock_quantity;
            $wago_data['wago_priority_lock_quantity'] = $value->wago_priority_lock_quantity;
            $res = DB::table('warehouse_goods_lock_tset')->insert($wago_data);
            unset($wago_data);
            dump($res);
        }
        unset($find_goods);
    }

    // 统计锁定商品库存
    private function lockGoodsOrder()
    {
        $shop_id = 1;
        // DB::beginTransaction();

        $order_data = DB::table('order')
            ->where('ord_delete', 1)
            ->where('ord_state', 1)
            ->where('ord_shop_id', $shop_id)
            ->where('ord_wor_state', '!=', 4)
            ->whereIn('ord_wor_state', [1,2,5,7])
            ->whereNotIn('ord_type', [3,4])
            ->where('ord_service_type', '!=', 4)
            ->get(['ord_id','ord_service_type','ord_ware_id','ord_shop_id','ord_order_number','ord_create_time']);

        $arr = [];
        $big = [];
        foreach ($order_data as $key => $value) {
            $orcl_id = DB::table('order_client')
                ->where('orcl_ord_id', $value->ord_id)
                ->where('orcl_shipment_party', 1)
                ->value('orcl_id');
            if (empty($orcl_id)) {
                continue;
            }
            if ($value->ord_service_type == 5) {
                $dego = DB::table('dispatch_bill')
                    ->where('dego_order_type', 1)
                    ->whereIn('dego_type', [1,4])
                    ->where('dego_wor_id', $value->ord_id)
                    ->first(['dego_id','dego_out_ware_id']);
                if (!empty($dego)) {
                    $ware = DB::table('warehouse')
                        ->where('ware_id', $dego->dego_out_ware_id)
                        ->first();
                    $digo = DB::table('dispatch_goods')
                        ->where('digo_dego_id', $dego->dego_id)
                        ->whereNotIn('digo_state', [2,3,4])
                        ->get();
                    foreach ($digo as $k => $v) {
                        $wago = DB::table('warehouse_goods')
                            ->where('wago_ware_id', $value->ord_ware_id)
                            ->where('wago_class', $v->digo_wago_class)
                            ->where('wago_goo_id', $v->digo_goo_id)
                            ->first();
                        if (empty($wago->wago_id)) {
                            continue;
                        }
                        if (isset($arr[$value->ord_ware_id][$v->digo_wago_class][$v->digo_goo_inventory][$wago->wago_id])) {
                            $arr[$value->ord_ware_id][$v->digo_wago_class][$v->digo_goo_inventory][$wago->wago_id] += $v->digo_goo_quantity;
                        } else {
                            $arr[$value->ord_ware_id][$v->digo_wago_class][$v->digo_goo_inventory][$wago->wago_id] = $v->digo_goo_quantity;
                        }
                        $small['wagl_ware_id'] = $value->ord_ware_id;
                        $small['wagl_shop_id'] = $value->ord_shop_id;
                        $small['wagl_wago_id'] = $wago->wago_id;
                        $small['wagl_original_correlation_id'] = $dego->dego_id;
                        $small['wagl_correlation_type'] = 2;
                        $small['wagl_state'] = 1;
                        $small['wagl_type'] = 1;
                        $small['wagl_original_id'] = $value->ord_id;
                        $small['wagl_original_number'] = $value->ord_order_number;
                        $small['wagl_lock_quantity'] = $v->digo_goo_quantity;
                        $small['wagl_create_time'] = $value->ord_create_time;
                        array_push($big, $small);
                    }
                }
            } else {
                $work_data = DB::table('work_order')
                    ->where('wor_delete', 1)
                    ->where('wor_order_id', $value->ord_id)
                    ->where('wor_collection_bill', 1)
                    ->whereNotIn('wor_state', [6,7,8,9,10,13])
                    ->first();
                if (!empty($work_data)) {
                    $dego_id = DB::table('dispatch_bill')
                        ->where('dego_order_type', 2)
                        ->where('dego_wor_id', $work_data->wor_id)
                        ->where('dego_type', 1)
                        ->value('dego_id');
                    if (empty($dego_id)) {
                        continue;
                    }
                }

                $order_goods = DB::table('order_goods')
                    ->where('orgo_ord_id', $value->ord_id)
                    ->whereNotIn('orgo_state', [2,3,4])
                    ->get();
                if (!empty($order_goods)) {
                    foreach ($order_goods as $k => $v) {
                        $wago = DB::table('warehouse_goods')
                            ->where('wago_ware_id', $value->ord_ware_id)
                            ->where('wago_class', $v->orgo_waon_class)
                            ->where('wago_goo_id', $v->orgo_actual_goo_id ?:$v->orgo_goo_id)
                            ->first();
                        if (empty($wago)) {
                            continue;
                        }
                        if (isset($arr[$value->ord_ware_id][$v->orgo_waon_class][$v->orgo_goo_inventory][$wago->wago_id])) {
                            $arr[$value->ord_ware_id][$v->orgo_waon_class][$v->orgo_goo_inventory][$wago->wago_id] += $v->orgo_goo_quantity;
                        } else {
                            $arr[$value->ord_ware_id][$v->orgo_waon_class][$v->orgo_goo_inventory][$wago->wago_id] = $v->orgo_goo_quantity;
                        }
                        // $wago = DB::table('warehouse_goods')
                        //     ->where('wago_ware_id',$value->ord_ware_id)
                        //     ->where('wago_class',$v->orgo_waon_class)
                        //     ->where('wago_goo_id',$v->orgo_actual_goo_id ?: $v->orgo_goo_id)
                        //     ->first();
                        $small['wagl_ware_id'] = $value->ord_ware_id;
                        $small['wagl_shop_id'] = $value->ord_shop_id;
                        $small['wagl_wago_id'] = $wago->wago_id;
                        $small['wagl_original_correlation_id'] = $value->ord_id;
                        $small['wagl_correlation_type'] = 1;
                        $small['wagl_state'] = 1;
                        $small['wagl_type'] = 1;
                        $small['wagl_original_id'] = $value->ord_id;
                        $small['wagl_original_number'] = $value->ord_order_number;
                        $small['wagl_lock_quantity'] = $v->orgo_goo_quantity;
                        $small['wagl_create_time'] = $value->ord_create_time;
                        array_push($big, $small);
                    }
                }
            }
        }

        $sd_order_data = DB::table('order')
            ->where('ord_delete', 1)
            ->where('ord_state', 1)
            ->where('ord_shop_id', $shop_id)
            ->where('ord_wor_state', '!=', 4)
            ->where('ord_wor_state', '!=', 11)
            ->where('ord_type', 3)
            ->get(['ord_id','ord_service_type','ord_ware_id','ord_shop_id','ord_order_number','ord_create_time']);

        foreach ($order_data as $key => $value) {
            $orcl_id = DB::table('order_client')
                ->where('orcl_ord_id', $value->ord_id)
                ->where('orcl_shipment_party', 1)
                ->value('orcl_id');
            if (empty($orcl_id)) {
                continue;
            }
            $work_data = DB::table('work_order')
                ->where('wor_delete', 1)
                ->where('wor_order_id', $value->ord_id)
                ->where('wor_collection_bill', 1)
                ->whereNotIn('wor_state', [6,7,8,9,10,13])
                ->first();
            if (empty($work_data)) {
                continue;
            }

            $dego_id = DB::table('dispatch_bill')
                ->where('dego_order_type', 2)
                ->where('dego_wor_id', $work_data->wor_id)
                ->where('dego_type', 1)
                ->value('dego_id');
            if (empty($dego_id)) {
                continue;
            }

            $order_goods = DB::table('work_good')
                ->where('wogo_wor_id', $work_data->wor_id)
                ->whereNotIn('wogo_state', [2,3,4])
                ->get(['wogo_waon_class as orgo_waon_class','wogo_wago_id as orgo_wago_id','wogo_goo_amount as orgo_goo_quantity', 'wogo_goo_id','wogo_actual_goo_id','wogo_goo_inventory as orgo_goo_inventory']);
            if (!empty($order_goods)) {
                foreach ($order_goods as $k => $v) {
                    $wago = DB::table('warehouse_goods')
                        ->where('wago_ware_id', $value->ord_ware_id)
                        ->where('wago_class', $v->orgo_waon_class)
                        ->where('wago_goo_id', $v->wogo_actual_goo_id ?: $v->wogo_goo_id)
                        ->first();
                    if (empty($wago)) {
                        continue;
                    }
                    if (isset($arr[$value->ord_ware_id][$v->orgo_waon_class][$v->orgo_goo_inventory][$wago->wago_id])) {
                        $arr[$value->ord_ware_id][$v->orgo_waon_class][$v->orgo_goo_inventory][$wago->wago_id] += $v->orgo_goo_quantity;
                    } else {
                        $arr[$value->ord_ware_id][$v->orgo_waon_class][$v->orgo_goo_inventory][$wago->wago_id] = $v->orgo_goo_quantity;
                    }

                    // $wago = DB::table('warehouse_goods')
                    //     ->where('wago_ware_id',$value->ord_ware_id)
                    //     ->where('wago_class',$v->orgo_waon_class)
                    //     ->where('wago_goo_id',$v->orgo_actual_goo_id ?: $v->orgo_goo_id)
                    //     ->first();
                    $small['wagl_ware_id'] = $value->ord_ware_id;
                    $small['wagl_shop_id'] = $value->ord_shop_id;
                    $small['wagl_wago_id'] = $wago->wago_id;
                    $small['wagl_original_correlation_id'] = $value->ord_id;
                    $small['wagl_correlation_type'] = 1;
                    $small['wagl_state'] = 1;
                    $small['wagl_type'] = 1;
                    $small['wagl_original_id'] = $value->ord_id;
                    $small['wagl_original_number'] = $value->ord_order_number;
                    $small['wagl_lock_quantity'] = $v->orgo_goo_quantity;
                    $small['wagl_create_time'] = $value->ord_create_time;
                    array_push($big, $small);
                }
            }
        }

        $tror = DB::table('transferring_order')
            ->where('tror_state', 2)
            ->where('tror_delete', 1)
            ->where('tror_shop_id', $shop_id)
            ->get();

        if (!empty($tror)) {
            foreach ($tror as $key => $value) {
                if (!empty($value->tror_goo_fine_amount)) {
                    $goo_inventory = 1;
                }
                $trog_goo = DB::table('transferring_order_goods')
                    ->where('trog_tror_id', $value->tror_id)
                    ->get();
                foreach ($trog_goo as $k => $v) {
                    if (!empty($v->trog_stock_number)) {
                        if (isset($arr[$value->tror_out_ware_id][$v->trog_waon_class][1][$v->trog_wago_id])) {
                            $arr[$value->tror_out_ware_id][$v->trog_waon_class][1][$v->trog_wago_id] += $v->trog_stock_number;
                        } else {
                            $arr[$value->tror_out_ware_id][$v->trog_waon_class][1][$v->trog_wago_id] = $v->trog_stock_number;
                        }
                    }
                    if (!empty($v->trog_priority_stock_number)) {
                        if (isset($arr[$value->tror_out_ware_id][$v->trog_waon_class][2][$v->trog_wago_id])) {
                            $arr[$value->tror_out_ware_id][$v->trog_waon_class][2][$v->trog_wago_id] += $v->trog_priority_stock_number;
                        } else {
                            $arr[$value->tror_out_ware_id][$v->trog_waon_class][2][$v->trog_wago_id] = $v->trog_priority_stock_number;
                        }
                    }

                    $num = $v->trog_priority_stock_number + $v->trog_stock_number;

                    $small['wagl_ware_id'] = $value->tror_out_ware_id;
                    $small['wagl_shop_id'] = $value->tror_shop_id;
                    $small['wagl_wago_id'] = $v->trog_wago_id;
                    $small['wagl_original_correlation_id'] = $value->tror_id;
                    $small['wagl_correlation_type'] = 3;
                    $small['wagl_state'] = 1;
                    $small['wagl_type'] = 2;
                    $small['wagl_original_id'] = $value->tror_id;
                    $small['wagl_original_number'] = $value->tror_number;
                    $small['wagl_lock_quantity'] = $num;
                    $small['wagl_create_time'] = $value->tror_create_time;
                    array_push($big, $small);
                }
            }
        }

        $ware = DB::table('warehouse')
            ->where('ware_shop_id', $shop_id)
            ->get(['ware_id']);
        $ware_id = [];
        foreach ($ware as $key => $value) {
            $ware_id[] = $value->ware_id;
        }

        // DB::table('warehouse_goods')
        //     ->whereIn('wago_ware_id',$ware_id)
        //     ->where('wago_lock_quantity','>',0)
        //     ->where('wago_priority_lock_quantity','>',0)
        //     ->update(['wago_update_time'=>date('Y-m-d H:i:s'),'wago_lock_quantity'=>0,'wago_priority_lock_quantity'=>0]);

        $datas=[];
        foreach ($arr as $key => $value) {
            foreach ($value as $kk => $vv) {
                foreach ($vv as $k => $v) {
                    if ($k == 1) {
                        foreach ($v as $b => $a) {
                            $wago = DB::table('warehouse_goods')
                                ->where('wago_id', $b)
                                ->first(['wago_lock_quantity','wago_ware_id','wago_goo_id']);
                            if ($wago->wago_lock_quantity != $a) {
                                DB::table('warehouse_goods')
                                    ->where('wago_id', $b)
                                    ->update(['wago_lock_quantity'=>$a]);

                                $ware_name = DB::table('warehouse')
                                    ->where('ware_id', $wago->wago_ware_id)
                                    ->value('ware_name');

                                $goo_name = DB::table('goods')
                                    ->where('goo_id', $wago->wago_goo_id)
                                    ->value('goo_goods_encode');

                                if ($kk == 1) {
                                    $wago_class = '货物仓';
                                } elseif ($kk == 2) {
                                    $wago_class = '非货物仓';
                                } elseif ($kk == 3) {
                                    $wago_class = '旧货仓';
                                } elseif ($kk == 4) {
                                    $wago_class = '临时仓';
                                }

                                $sql = '仓库:'.$ware_name.' 类别:'.$wago_class.' 检索编码:'.$goo_name.' 原来锁定库存:'.$wago->wago_lock_quantity.' 新的锁定库存:'.$a.' 仓库商品表id :'.$b;
                                array_push($datas, $sql);

                                $wago_data['wago_ware_id'] = $wago->wago_ware_id;
                                $wago_data['wago_class'] = $kk;
                                $wago_data['wago_goo_id'] = $wago->wago_goo_id;
                                $wago_data['wago_lock_quantity'] = $a;
                                $res = DB::table('warehouse_goods_lock_tset')->insert($wago_data);
                                unset($wago_data);
                            }
                        }
                    } else {
                        foreach ($v as $b => $a) {
                            $wago = DB::table('warehouse_goods')
                                ->where('wago_id', $b)
                                ->first(['wago_priority_lock_quantity','wago_ware_id','wago_goo_id']);
                            if ($wago->wago_priority_lock_quantity != $a) {
                                DB::table('warehouse_goods')
                                    ->where('wago_id', $b)
                                    ->update(['wago_lock_quantity'=>$a]);
                                $ware_name = DB::table('warehouse')
                                    ->where('ware_id', $wago->wago_ware_id)
                                    ->value('ware_name');

                                $goo_name = DB::table('goods')
                                    ->where('goo_id', $wago->wago_goo_id)
                                    ->value('goo_goods_encode');

                                if ($kk == 1) {
                                    $wago_class = '货物仓';
                                } elseif ($kk == 2) {
                                    $wago_class = '非货物仓';
                                } elseif ($kk == 3) {
                                    $wago_class = '旧货仓';
                                } elseif ($kk == 4) {
                                    $wago_class = '临时仓';
                                }

                                $sql = '仓库:'.$ware_name.' 类别:'.$wago_class.' 检索编码:'.$goo_name.' 原来锁定库存:'.$wago->wago_priority_lock_quantity.' 新的锁定库存:'.$a.' 仓库商品表id :'.$b;
                                array_push($datas, $sql);

                                $wago_data['wago_ware_id'] = $wago->wago_ware_id;
                                $wago_data['wago_class'] = $kk;
                                $wago_data['wago_goo_id'] = $wago->wago_goo_id;
                                $wago_data['wago_priority_lock_quantity'] = $a;
                                $res = DB::table('warehouse_goods_lock_tset')->insert($wago_data);
                                unset($wago_data);
                            }
                        }
                    }
                }
            }
        }
        dump($datas);
        die;
    }

    // 更改库存数量
    private function updateWareData()
    {
        set_time_limit(0);
        $find_ware_data = DB::table('warehouse_goods_record_tset')
        ->whereIn('wago_ware_id', [9,10,11,13,14])
        ->whereNotIn('wago_class', [3,4])
        ->whereNotIn('wago_goo_id', ['4527','37831','37832','37833','37834','37835','37836','37837','37838','37839','37840','37841','37842','37843','37844','37845','37846','37847','37848','37849','37850','37851','37852','37853','37854','37855','37856'])
        ->get()->toArray();
        // dump($find_ware_data);die;
        foreach ($find_ware_data as $key => $value) {
            if ($value->wago_stock_number < 0 || $value->wago_priority_stock_number < 0) {
                $ware_data['wago_unchecked_stock_number'] = 0;
                $ware_data['wago_stock_number'] = 0;
                $ware_data['wago_priority_stock_number'] = 0;
            } else {
                if ($value->wago_stock_number) {
                    $ware_data['wago_stock_number'] = $value->wago_stock_number;
                    $ware_data['wago_priority_stock_number'] = 0;
                    $ware_data['wago_unchecked_stock_number'] = 0;
                }
                if ($value->wago_priority_stock_number) {
                    $ware_data['wago_priority_stock_number'] = $value->wago_priority_stock_number;
                    $ware_data['wago_stock_number'] = 0;
                    $ware_data['wago_unchecked_stock_number'] = 0;
                }
                if ($value->wago_unchecked_stock_number) {
                    $ware_data['wago_unchecked_stock_number'] = $value->wago_unchecked_stock_number;
                    $ware_data['wago_stock_number'] = 0;
                    $ware_data['wago_priority_stock_number'] = 0;
                }
                if (empty($ware_data)) {
                    $ware_data['wago_unchecked_stock_number'] = 0;
                    $ware_data['wago_stock_number'] = 0;
                    $ware_data['wago_priority_stock_number'] = 0;
                }
            }
            $res = DB::table('warehouse_goods')
                ->where('wago_ware_id', $value->wago_ware_id)
                ->where('wago_class', $value->wago_class)
                ->where('wago_goo_id', $value->wago_goo_id)
                ->update($ware_data);
            dump($res);
            unset($ware_data);
        }
        // dump($find_ware_data);
    }

    // 更改仓库库存数据，将计算后的库存更改为现在的库存
    private function updateWareInventory()
    {
        set_time_limit(0);
        // 查询仓库id
        $find_ware = DB::table('warehouse')
            ->where('ware_cid', 1)
            ->where('ware_shop_id', 1)
            ->select('ware_id')
            ->get()->toArray();
        // $ware_id = array_column($find_ware, 'ware_id');
        $ware_id = [9,10,11,13,14];
        // 查询仓库有商品库存数量的
        $waog_stock_type = 1;
        $find_goods = DB::table('warehouse_goods as a')
                        // ->leftJoin('goods as b', 'b.goo_id', '=', 'a.wago_goo_id')
                        ->where(function ($query) use ($waog_stock_type) {
                            $query->where('wago_stock_number', '>', 0)
                                  ->orWhere('wago_lock_quantity', '>', 0)
                                  ->orWhere('wago_priority_stock_number', '>', 0)
                                  ->orWhere('wago_priority_lock_quantity', '>', 0)
                                  ->orWhere('wago_unchecked_stock_number', '>', 0);
                        })
                        ->whereIn('wago_ware_id', $ware_id)
                        // ->select('goo_name', 'goo_goods_encode', 'goo_bra_name', 'goo_cate_name', 'wago_stock_number', 'wago_lock_quantity', 'wago_priority_stock_number', 'wago_priority_lock_quantity', 'wago_unchecked_stock_number', 'wago_ware_id', 'wago_class', 'wago_goo_id', 'wago_id', 'goo_type')
                        ->select('wago_stock_number', 'wago_lock_quantity', 'wago_priority_stock_number', 'wago_priority_lock_quantity', 'wago_unchecked_stock_number', 'wago_ware_id', 'wago_class', 'wago_goo_id', 'wago_id')
                        ->get()->toArray();
        $ware_class_type_goo = [];
        foreach ($find_goods as $key => $value) {
            // wago_class 仓库类别：1货物仓2非货物仓3旧货仓4临时仓
            // 如果是非货物仓，要调整到货物仓
            if ($value->wago_class == 2) {
                $value->wago_class = 1;
            }

            // 良品正常商品库存
            if ($value->wago_stock_number) {
                $ware_stock_type = 1;
                // [仓库id][仓库类别][类型:良品/优先/待检测][1正常2锁定][商品id]
                if (isset($ware_class_type_goo[$value->wago_ware_id][$value->wago_class][$ware_stock_type][1][$value->wago_goo_id])) {
                    $ware_class_type_goo[$value->wago_ware_id][$value->wago_class][$ware_stock_type][1][$value->wago_goo_id] += $value->wago_stock_number;
                } else {
                    $ware_class_type_goo[$value->wago_ware_id][$value->wago_class][$ware_stock_type][1][$value->wago_goo_id] = $value->wago_stock_number;
                }
            }

            // 良品锁定商品库存
            if ($value->wago_lock_quantity) {
                $ware_stock_type = 1;
                // [仓库id][仓库类别][类型:良品/优先/待检测][1正常2锁定][商品id]
                if (isset($ware_class_type_goo[$value->wago_ware_id][$value->wago_class][$ware_stock_type][2][$value->wago_goo_id])) {
                    $ware_class_type_goo[$value->wago_ware_id][$value->wago_class][$ware_stock_type][2][$value->wago_goo_id] += $value->wago_lock_quantity;
                } else {
                    $ware_class_type_goo[$value->wago_ware_id][$value->wago_class][$ware_stock_type][2][$value->wago_goo_id] = $value->wago_lock_quantity;
                }
            }

            // 优先正常商品库存
            if ($value->wago_priority_stock_number) {
                $ware_stock_type = 2;
                // [仓库id][仓库类别][类型:良品/优先/待检测][1正常2锁定][商品id]
                if (isset($ware_class_type_goo[$value->wago_ware_id][$value->wago_class][$ware_stock_type][1][$value->wago_goo_id])) {
                    $ware_class_type_goo[$value->wago_ware_id][$value->wago_class][$ware_stock_type][1][$value->wago_goo_id] += $value->wago_priority_stock_number;
                } else {
                    $ware_class_type_goo[$value->wago_ware_id][$value->wago_class][$ware_stock_type][1][$value->wago_goo_id] = $value->wago_priority_stock_number;
                }
            }

            // 优先锁定商品库存
            if ($value->wago_priority_lock_quantity) {
                $ware_stock_type = 2;
                // [仓库id][仓库类别][类型:良品/优先/待检测][1正常2锁定][商品id]
                if (isset($ware_class_type_goo[$value->wago_ware_id][$value->wago_class][$ware_stock_type][2][$value->wago_goo_id])) {
                    $ware_class_type_goo[$value->wago_ware_id][$value->wago_class][$ware_stock_type][2][$value->wago_goo_id] += $value->wago_priority_lock_quantity;
                } else {
                    $ware_class_type_goo[$value->wago_ware_id][$value->wago_class][$ware_stock_type][2][$value->wago_goo_id] = $value->wago_priority_lock_quantity;
                }
            }

            // 待检测正常商品库存
            if ($value->wago_unchecked_stock_number) {
                $ware_stock_type = 3;
                // [仓库id][仓库类别][类型:良品/优先/待检测][1正常2锁定][商品id]
                if (isset($ware_class_type_goo[$value->wago_ware_id][$value->wago_class][$ware_stock_type][1][$value->wago_goo_id])) {
                    $ware_class_type_goo[$value->wago_ware_id][$value->wago_class][$ware_stock_type][1][$value->wago_goo_id] += $value->wago_unchecked_stock_number;
                } else {
                    $ware_class_type_goo[$value->wago_ware_id][$value->wago_class][$ware_stock_type][1][$value->wago_goo_id] = $value->wago_unchecked_stock_number;
                }
            }
        }
        unset($find_goods);

        // 查询商品计算后统计的数据
        $find_total_data = DB::table('warehouse_goods_tset')
                        ->select('wago_stock_number', 'wago_lock_quantity', 'wago_priority_stock_number', 'wago_priority_lock_quantity', 'wago_unchecked_stock_number', 'wago_ware_id', 'wago_class', 'wago_goo_id', 'wago_id')
                        ->get()->toArray();
        $total_ware_class_type_goo = [];
        foreach ($find_total_data as $key => $value) {
            // wago_class 仓库类别：1货物仓2非货物仓3旧货仓4临时仓
            // 如果是非货物仓，要调整到货物仓
            if ($value->wago_class == 2) {
                $value->wago_class = 1;
            }

            // 良品正常商品库存
            if ($value->wago_stock_number) {
                $ware_stock_type = 1;
                // [仓库id][仓库类别][类型:良品/优先/待检测][1正常2锁定][商品id]
                if (isset($total_ware_class_type_goo[$value->wago_ware_id][$value->wago_class][$ware_stock_type][1][$value->wago_goo_id])) {
                    $total_ware_class_type_goo[$value->wago_ware_id][$value->wago_class][$ware_stock_type][1][$value->wago_goo_id] += $value->wago_stock_number;
                } else {
                    $total_ware_class_type_goo[$value->wago_ware_id][$value->wago_class][$ware_stock_type][1][$value->wago_goo_id] = $value->wago_stock_number;
                }
            }

            // 良品锁定商品库存
            if ($value->wago_lock_quantity) {
                $ware_stock_type = 1;
                // [仓库id][仓库类别][类型:良品/优先/待检测][1正常2锁定][商品id]
                if (isset($total_ware_class_type_goo[$value->wago_ware_id][$value->wago_class][$ware_stock_type][2][$value->wago_goo_id])) {
                    $total_ware_class_type_goo[$value->wago_ware_id][$value->wago_class][$ware_stock_type][2][$value->wago_goo_id] += $value->wago_lock_quantity;
                } else {
                    $total_ware_class_type_goo[$value->wago_ware_id][$value->wago_class][$ware_stock_type][2][$value->wago_goo_id] = $value->wago_lock_quantity;
                }
            }

            // 优先正常商品库存
            if ($value->wago_priority_stock_number) {
                $ware_stock_type = 2;
                // [仓库id][仓库类别][类型:良品/优先/待检测][1正常2锁定][商品id]
                if (isset($total_ware_class_type_goo[$value->wago_ware_id][$value->wago_class][$ware_stock_type][1][$value->wago_goo_id])) {
                    $total_ware_class_type_goo[$value->wago_ware_id][$value->wago_class][$ware_stock_type][1][$value->wago_goo_id] += $value->wago_priority_stock_number;
                } else {
                    $total_ware_class_type_goo[$value->wago_ware_id][$value->wago_class][$ware_stock_type][1][$value->wago_goo_id] = $value->wago_priority_stock_number;
                }
            }

            // 优先锁定商品库存
            if ($value->wago_priority_lock_quantity) {
                $ware_stock_type = 2;
                // [仓库id][仓库类别][类型:良品/优先/待检测][1正常2锁定][商品id]
                if (isset($total_ware_class_type_goo[$value->wago_ware_id][$value->wago_class][$ware_stock_type][2][$value->wago_goo_id])) {
                    $total_ware_class_type_goo[$value->wago_ware_id][$value->wago_class][$ware_stock_type][2][$value->wago_goo_id] += $value->wago_priority_lock_quantity;
                } else {
                    $total_ware_class_type_goo[$value->wago_ware_id][$value->wago_class][$ware_stock_type][2][$value->wago_goo_id] = $value->wago_priority_lock_quantity;
                }
            }

            // 待检测正常商品库存
            if ($value->wago_unchecked_stock_number) {
                $ware_stock_type = 3;
                // [仓库id][仓库类别][类型:良品/优先/待检测][1正常2锁定][商品id]
                if (isset($total_ware_class_type_goo[$value->wago_ware_id][$value->wago_class][$ware_stock_type][1][$value->wago_goo_id])) {
                    $total_ware_class_type_goo[$value->wago_ware_id][$value->wago_class][$ware_stock_type][1][$value->wago_goo_id] += $value->wago_unchecked_stock_number;
                } else {
                    $total_ware_class_type_goo[$value->wago_ware_id][$value->wago_class][$ware_stock_type][1][$value->wago_goo_id] = $value->wago_unchecked_stock_number;
                }
            }
        }
        unset($find_total_data);

        // 查询订单、调拨锁定商品库存数据
        $find_lock_data = DB::table('warehouse_goods_lock_tset')
                        ->select('wago_stock_number', 'wago_lock_quantity', 'wago_priority_stock_number', 'wago_priority_lock_quantity', 'wago_unchecked_stock_number', 'wago_ware_id', 'wago_class', 'wago_goo_id', 'wago_id')
                        ->get()->toArray();
        $lock_ware_class_type_goo = [];
        foreach ($find_lock_data as $key => $value) {
            // wago_class 仓库类别：1货物仓2非货物仓3旧货仓4临时仓
            // 如果是非货物仓，要调整到货物仓
            if ($value->wago_class == 2) {
                $value->wago_class = 1;
            }

            // 良品正常商品库存
            // if ($value->wago_stock_number) {
            //     $ware_stock_type = 1;
            //     // [仓库id][仓库类别][类型:良品/优先/待检测][1正常2锁定][商品id]
            //     if (isset($total_ware_class_type_goo[$value->wago_ware_id][$value->wago_class][$ware_stock_type][1][$value->wago_goo_id])) {
            //         $lock_ware_class_type_goo[$value->wago_ware_id][$value->wago_class][$ware_stock_type][1][$value->wago_goo_id] += $value->wago_stock_number;
            //     }else{
            //         $lock_ware_class_type_goo[$value->wago_ware_id][$value->wago_class][$ware_stock_type][1][$value->wago_goo_id] = $value->wago_stock_number;
            //     }
            // }

            // 良品锁定商品库存
            if ($value->wago_lock_quantity) {
                $ware_stock_type = 1;
                // [仓库id][仓库类别][类型:良品/优先/待检测][1正常2锁定][商品id]
                if (isset($lock_ware_class_type_goo[$value->wago_ware_id][$value->wago_class][$ware_stock_type][2][$value->wago_goo_id])) {
                    $lock_ware_class_type_goo[$value->wago_ware_id][$value->wago_class][$ware_stock_type][2][$value->wago_goo_id] += $value->wago_lock_quantity;
                } else {
                    $lock_ware_class_type_goo[$value->wago_ware_id][$value->wago_class][$ware_stock_type][2][$value->wago_goo_id] = $value->wago_lock_quantity;
                }
            }

            // 优先正常商品库存
            // if ($value->wago_priority_stock_number) {
            //     $ware_stock_type = 2;
            //     // [仓库id][仓库类别][类型:良品/优先/待检测][1正常2锁定][商品id]
            //     if (isset($lock_ware_class_type_goo[$value->wago_ware_id][$value->wago_class][$ware_stock_type][1][$value->wago_goo_id])) {
            //         $lock_ware_class_type_goo[$value->wago_ware_id][$value->wago_class][$ware_stock_type][1][$value->wago_goo_id] += $value->wago_priority_stock_number;
            //     }else{
            //         $lock_ware_class_type_goo[$value->wago_ware_id][$value->wago_class][$ware_stock_type][1][$value->wago_goo_id] = $value->wago_priority_stock_number;
            //     }
            // }

            // 优先锁定商品库存
            if ($value->wago_priority_lock_quantity) {
                $ware_stock_type = 2;
                // [仓库id][仓库类别][类型:良品/优先/待检测][1正常2锁定][商品id]
                if (isset($lock_ware_class_type_goo[$value->wago_ware_id][$value->wago_class][$ware_stock_type][2][$value->wago_goo_id])) {
                    $lock_ware_class_type_goo[$value->wago_ware_id][$value->wago_class][$ware_stock_type][2][$value->wago_goo_id] += $value->wago_priority_lock_quantity;
                } else {
                    $lock_ware_class_type_goo[$value->wago_ware_id][$value->wago_class][$ware_stock_type][2][$value->wago_goo_id] = $value->wago_priority_lock_quantity;
                }
            }

            // 待检测正常商品库存
            // if ($value->wago_unchecked_stock_number) {
            //     $ware_stock_type = 3;
            //     // [仓库id][仓库类别][类型:良品/优先/待检测][1正常2锁定][商品id]
            //     if (isset($lock_ware_class_type_goo[$value->wago_ware_id][$value->wago_class][$ware_stock_type][1][$value->wago_goo_id])) {
            //         $lock_ware_class_type_goo[$value->wago_ware_id][$value->wago_class][$ware_stock_type][1][$value->wago_goo_id] += $value->wago_unchecked_stock_number;
            //     }else{
            //         $lock_ware_class_type_goo[$value->wago_ware_id][$value->wago_class][$ware_stock_type][1][$value->wago_goo_id] = $value->wago_unchecked_stock_number;
            //     }
            // }
        }
        unset($find_lock_data);

        // 计算统计的商品库存、锁定的商品库存
        foreach ($lock_ware_class_type_goo as $ware_id => $ware_value) {
            // [仓库id][仓库类别][类型:良品/优先/待检测][1正常2锁定][商品id]
            foreach ($ware_value as $wago_class => $wago_class_value) {
                // [类型:良品/优先/待检测]
                foreach ($wago_class_value as $ware_stock_type => $normal_lock_value) {
                    // [1正常2锁定]
                    foreach ($normal_lock_value as $normal_lock => $goo_value) {
                        // [商品id]
                        foreach ($goo_value as $goo_id => $stock_number) {
                            // 查询统计的商品存数据
                            if (isset($total_ware_class_type_goo[$ware_id][$wago_class][$ware_stock_type][1][$goo_id])) {
                                // 正常库存减少
                                $normal_stock_number = $total_ware_class_type_goo[$ware_id][$wago_class][$ware_stock_type][1][$goo_id];
                                $total_ware_class_type_goo[$ware_id][$wago_class][$ware_stock_type][1][$goo_id] = $normal_stock_number - $stock_number;
                                // 锁定库存增加
                                // 判断是否有锁定库存
                                if (isset($total_ware_class_type_goo[$ware_id][$wago_class][$ware_stock_type][2][$goo_id])) {
                                    $lock_stock_number = $total_ware_class_type_goo[$ware_id][$wago_class][$ware_stock_type][2][$goo_id];
                                    $total_ware_class_type_goo[$ware_id][$wago_class][$ware_stock_type][2][$goo_id] = $lock_stock_number + $stock_number;
                                } else {
                                    $total_ware_class_type_goo[$ware_id][$wago_class][$ware_stock_type][2][$goo_id] = $stock_number;
                                }
                            } else {
                                // 正常库存减少
                                $total_ware_class_type_goo[$ware_id][$wago_class][$ware_stock_type][1][$goo_id] = '-'.$stock_number;
                                // 锁定库存增加
                                // 判断是否有锁定库存
                                if (isset($total_ware_class_type_goo[$ware_id][$wago_class][$ware_stock_type][2][$goo_id])) {
                                    $lock_stock_number = $total_ware_class_type_goo[$ware_id][$wago_class][$ware_stock_type][2][$goo_id];
                                    $total_ware_class_type_goo[$ware_id][$wago_class][$ware_stock_type][2][$goo_id] = $lock_stock_number + $stock_number;
                                } else {
                                    $total_ware_class_type_goo[$ware_id][$wago_class][$ware_stock_type][2][$goo_id] = $stock_number;
                                }
                            }
                        }
                    }
                }
            }
        }
        unset($lock_ware_class_type_goo);
        
        $compute_goods_data = [];
        // 比较计算的库存与仓库的库存
        foreach ($total_ware_class_type_goo as $ware_id => $ware_value) {
            // [仓库id][仓库类别][类型:良品/优先/待检测][1正常2锁定][商品id]
            foreach ($ware_value as $wago_class => $wago_class_value) {
                // ware_stock_type [类型:良品/优先/待检测]
                foreach ($wago_class_value as $ware_stock_type => $normal_lock_value) {
                    // normal_lock [1正常2锁定]
                    foreach ($normal_lock_value as $normal_lock => $goo_value) {
                        // goo_id [商品id]
                        foreach ($goo_value as $goo_id => $normal_stock_number) {
                            // 查询仓库的商品存数据
                            if (isset($ware_class_type_goo[$ware_id][$wago_class][$ware_stock_type][$normal_lock][$goo_id])) {
                                // 判断仓库的库存与计算的库存是否一样，不一样的是需要更改的
                                $stock_number = $ware_class_type_goo[$ware_id][$wago_class][$ware_stock_type][$normal_lock][$goo_id];
                                if ($normal_lock == 2) {
                                    $string = '计算：'.$normal_stock_number.'仓库：'.$stock_number;
                                    dump($string);
                                }
                                if ($normal_stock_number != $stock_number) {
                                    $compute_goods_data[$ware_id][$wago_class][$ware_stock_type][$normal_lock][$goo_id] = $normal_stock_number;
                                    $compute_data['wago_ware_id'] = $ware_id;
                                    $compute_data['wago_class'] = $wago_class;
                                    $compute_data['wago_goo_id'] = $goo_id;
                                    // 更改后的数据
                                    if ($ware_stock_type == 1) {
                                        if ($normal_lock == 1) {
                                            $compute_data['wago_stock_number'] = $normal_stock_number;
                                        } else {
                                            $compute_data['wago_lock_quantity'] = $normal_stock_number;
                                        }
                                    } elseif ($ware_stock_type == 2) {
                                        if ($normal_lock == 1) {
                                            $compute_data['wago_priority_stock_number'] = $normal_stock_number;
                                        } else {
                                            $compute_data['wago_priority_lock_quantity'] = $normal_stock_number;
                                        }
                                    } else {
                                        $compute_data['wago_unchecked_stock_number'] = $normal_stock_number;
                                    }
                                    // 更改前的数据
                                    if ($ware_stock_type == 1) {
                                        if ($normal_lock == 1) {
                                            $compute_data['wago_before_fine_stock'] = $stock_number;
                                        } else {
                                            $compute_data['wago_before_fine_lock'] = $stock_number;
                                        }
                                    } elseif ($ware_stock_type == 2) {
                                        if ($normal_lock == 1) {
                                            $compute_data['wago_before_priority_stock'] = $stock_number;
                                        } else {
                                            $compute_data['wago_before_priority_lock'] = $stock_number;
                                        }
                                    } else {
                                        $compute_data['wago_before_unchecked_stock_number'] = $stock_number;
                                    }
                                    $res = DB::table('warehouse_goods_record_tset')->insert($compute_data);
                                    unset($compute_data);
                                }
                            } else {
                                // 如果不存在，就改成计算后的商品
                                $compute_goods_data[$ware_id][$wago_class][$ware_stock_type][$normal_lock][$goo_id] = $normal_stock_number;
                                $compute_data['wago_ware_id'] = $ware_id;
                                $compute_data['wago_class'] = $wago_class;
                                $compute_data['wago_goo_id'] = $goo_id;
                                // 更改后的数据
                                if ($ware_stock_type == 1) {
                                    if ($normal_lock == 1) {
                                        $compute_data['wago_stock_number'] = $normal_stock_number;
                                    } else {
                                        $compute_data['wago_lock_quantity'] = $normal_stock_number;
                                    }
                                } elseif ($ware_stock_type == 2) {
                                    if ($normal_lock == 1) {
                                        $compute_data['wago_priority_stock_number'] = $normal_stock_number;
                                    } else {
                                        $compute_data['wago_priority_lock_quantity'] = $normal_stock_number;
                                    }
                                } else {
                                    $compute_data['wago_unchecked_stock_number'] = $normal_stock_number;
                                }
                                $stock_number = 0;
                                // 更改前的数据
                                if ($ware_stock_type == 1) {
                                    if ($normal_lock == 1) {
                                        $compute_data['wago_before_fine_stock'] = $stock_number;
                                    } else {
                                        $compute_data['wago_before_fine_lock'] = $stock_number;
                                    }
                                } elseif ($ware_stock_type == 2) {
                                    if ($normal_lock == 1) {
                                        $compute_data['wago_before_priority_stock'] = $stock_number;
                                    } else {
                                        $compute_data['wago_before_priority_lock'] = $stock_number;
                                    }
                                } else {
                                    $compute_data['wago_before_unchecked_stock_number'] = $stock_number;
                                }
                                $res = DB::table('warehouse_goods_record_tset')->insert($compute_data);
                                unset($compute_data);
                            }
                        }
                    }
                }
            }
        }
        dump($compute_goods_data);
        die;
        dump($total_ware_class_type_goo);
        die;
        echo 132456;
        die;
    }

    // 统计计算后的库存数量
    private function totalInventory()
    {
        set_time_limit(0);
        // 出入库记录计算后的数据
        $find_compute_data = DB::table('outin_record_compute_tset')->get();
        foreach ($find_compute_data as $key => $value) {
            // [仓库id][仓库类别][类型][商品id]
            if (isset($ware_class_type_goo[$value->ware_id][$value->wago_class][$value->oure_goo_type][$value->wago_goo_id])) {
                $ware_class_type_goo[$value->ware_id][$value->wago_class][$value->oure_goo_type][$value->wago_goo_id] += $value->oure_goo_number;
            } else {
                $ware_class_type_goo[$value->ware_id][$value->wago_class][$value->oure_goo_type][$value->wago_goo_id] = $value->oure_goo_number;
            }
        }
        unset($find_compute_data);

        // 期初库存
        $find_initial_data = DB::table('outin_record_initial_tset')->get();
        foreach ($find_initial_data as $key => $value) {
            // [仓库id][仓库类别][类型][商品id]
            if (isset($ware_class_type_goo[$value->ware_id][$value->wago_class][$value->oure_goo_type][$value->wago_goo_id])) {
                $ware_class_type_goo[$value->ware_id][$value->wago_class][$value->oure_goo_type][$value->wago_goo_id] += $value->oure_goo_number;
            } else {
                $ware_class_type_goo[$value->ware_id][$value->wago_class][$value->oure_goo_type][$value->wago_goo_id] = $value->oure_goo_number;
            }
        }
        unset($find_initial_data);
        // 将计算后库存数据存入数据表
        foreach ($ware_class_type_goo as $ware_id => $ware_value) {
            foreach ($ware_value as $wago_class => $ware_type_value) {
                foreach ($ware_type_value as $oure_goo_type => $goo_value) {
                    foreach ($goo_value as $wago_goo_id => $oure_goo_number) {
                        $wago_data['wago_ware_id'] = $ware_id;
                        $wago_data['wago_class'] = $wago_class;
                        $wago_data['wago_goo_id'] = $wago_goo_id;
                        if ($oure_goo_type == 1) {
                            $wago_data['wago_stock_number'] = $oure_goo_number;
                        } elseif ($oure_goo_type == 2) {
                            $wago_data['wago_priority_stock_number'] = $oure_goo_number;
                        } elseif ($oure_goo_type == 3) {
                            $wago_data['wago_unchecked_stock_number'] = $oure_goo_number;
                        }
                        dump($wago_goo_id);
                        dump($wago_data);
                        $res = DB::table('warehouse_goods_tset')->insert($wago_data);
                        // dump($res);
                        unset($wago_data);
                        unset($wago_goo_id);
                        unset($oure_goo_number);
                    }
                    unset($goo_value);
                    unset($oure_goo_type);
                }
                unset($ware_type_value);
                unset($wago_class);
            }
            unset($ware_value);
            unset($ware_id);
        }
        unset($ware_class_type_goo);
    }

    // 计算商品流水库存
    private function computeWaterInventory()
    {
        set_time_limit(0);
        $shop_id = 1;//门店id
        // 查询出库记录流水
        $out_record = DB::table('outin_details as od')
                    ->leftjoin('outin_record as or', 'or.oure_id', '=', 'od.oude_oure_id')
                    ->where('oure_cid', 1)
                    ->where('oure_shop_id', $shop_id)
                    ->where('oure_out_in_type', 1)//出入库类型：1出库，2入库
                    ->get();
        // dump($out_record);die;
        $ware_class_type_goo = [];
        foreach ($out_record as $key => $value) {
            // [仓库id][仓库类别][类型][商品id]
            // oure_waon_class 仓库类别：1货物仓2非货物仓3旧货仓4临时仓
            // 如果是非货物仓，要调整到货物仓
            if ($value->oure_waon_class == 2) {
                $value->oure_waon_class = 1;
            }
            if (isset($ware_class_type_goo[$value->oure_out_ware_id][$value->oure_waon_class][$value->oude_type][$value->oude_goo_id])) {
                $ware_class_type_goo[$value->oure_out_ware_id][$value->oure_waon_class][$value->oude_type][$value->oude_goo_id] += $value->oude_goo_number;
            } else {
                $ware_class_type_goo[$value->oure_out_ware_id][$value->oure_waon_class][$value->oude_type][$value->oude_goo_id] = $value->oude_goo_number;
            }
        }
        
        unset($out_record);
        foreach ($ware_class_type_goo as $ware_id => $ware_value) {
            foreach ($ware_value as $wago_class => $ware_type_value) {
                foreach ($ware_type_value as $oure_goo_type => $goo_value) {
                    foreach ($goo_value as $wago_goo_id => $oure_goo_number) {
                        $oure_data['oure_shop_id'] = $shop_id;
                        $oure_data['ware_id'] = $ware_id;
                        $oure_data['wago_class'] = $wago_class;
                        $oure_data['wago_goo_id'] = $wago_goo_id;
                        $oure_data['oure_out_in_type'] = 1;
                        $oure_data['oure_goo_number'] = '-'.$oure_goo_number;
                        $oure_data['oure_goo_type'] = $oure_goo_type;
                        $res = DB::table('outin_record_compute_tset')->insert($oure_data);
                        dump($res);
                        unset($oure_data);
                        unset($wago_goo_id);
                        unset($oure_goo_number);
                    }
                    unset($goo_value);
                    unset($oure_goo_type);
                }
                unset($ware_type_value);
                unset($wago_class);
            }
            unset($ware_value);
            unset($ware_id);
        }
        unset($ware_class_type_goo);
        echo 8888888;

        // 查询入库记录流水
        $out_record = DB::table('outin_details as od')
                    ->leftjoin('outin_record as or', 'or.oure_id', '=', 'od.oude_oure_id')
                    ->where('oure_cid', 1)
                    ->where('oure_shop_id', $shop_id)
                    ->where('oure_out_in_type', 2)//出入库类型：1出库，2入库
                    ->get();
        $ware_class_type_goo = [];
        foreach ($out_record as $key => $value) {
            // [仓库id][仓库类别][类型][商品id]
            // oure_waon_class 仓库类别：1货物仓2非货物仓3旧货仓4临时仓
            // 如果是非货物仓，要调整到货物仓
            if ($value->oure_waon_class == 2) {
                $value->oure_waon_class = 1;
            }
            if (isset($ware_class_type_goo[$value->oure_in_ware_id][$value->oure_waon_class][$value->oude_type][$value->oude_goo_id])) {
                $ware_class_type_goo[$value->oure_in_ware_id][$value->oure_waon_class][$value->oude_type][$value->oude_goo_id] += $value->oude_goo_number;
            } else {
                $ware_class_type_goo[$value->oure_in_ware_id][$value->oure_waon_class][$value->oude_type][$value->oude_goo_id] = $value->oude_goo_number;
            }
        }
        unset($out_record);
        foreach ($ware_class_type_goo as $ware_id => $ware_value) {
            foreach ($ware_value as $wago_class => $ware_type_value) {
                foreach ($ware_type_value as $oure_goo_type => $goo_value) {
                    foreach ($goo_value as $wago_goo_id => $oure_goo_number) {
                        $oure_data['oure_shop_id'] = $shop_id;
                        $oure_data['ware_id'] = $ware_id;
                        $oure_data['wago_class'] = $wago_class;
                        $oure_data['wago_goo_id'] = $wago_goo_id;
                        $oure_data['oure_out_in_type'] = 2;
                        $oure_data['oure_goo_number'] = $oure_goo_number;
                        $oure_data['oure_goo_type'] = $oure_goo_type;
                        $res = DB::table('outin_record_compute_tset')->insert($oure_data);
                        dump($res);
                        unset($oure_data);
                        unset($wago_goo_id);
                        unset($oure_goo_number);
                    }
                    unset($goo_value);
                    unset($oure_goo_type);
                }
                unset($ware_type_value);
                unset($wago_class);
            }
            unset($ware_value);
            unset($ware_id);
        }
        unset($ware_class_type_goo);
        echo 999;
        die;
    }

    // 导入期初库存
    private function importInitial()
    {
        set_time_limit(0);
        $shop_id = 147;//门店id

        $find_excel_data = DB::table('excel_data_cache')->get();
        foreach ($find_excel_data as $key => $value) {
            $exdc_data = json_decode($value->exdc_data, true);
            // exdc_type 类型1主仓库2东站前置仓3城西仓
            if ($value->exdc_type == 1) {
                $ware_id = 256;
            } elseif ($value->exdc_type == 2) {
                $ware_id = 257;
            } elseif ($value->exdc_type == 3) {
                $ware_id = 258;
            } else {
                echo 'error';die;
            }

            $wago_stock_number = 0;
            $exdc_data_test['hwcl'] = trim($exdc_data['hwcl'], '=');
            if (stristr($exdc_data_test['hwcl'], '+')) {
                $test_data = explode('+', $exdc_data_test['hwcl']);
                $exdc_data['hwcl'] = array_sum($test_data);
                unset($test_data);
            } else {
                $exdc_data['hwcl'] = $exdc_data_test['hwcl'];
            }

            $exdc_data_test['fspcl'] = trim($exdc_data['fspcl'], '=');
            if (stristr($exdc_data_test['fspcl'], '+')) {
                $test_data = explode('+', $exdc_data_test['fspcl']);
                $exdc_data['fspcl'] = array_sum($test_data);
                unset($test_data);
            } else {
                $exdc_data['fspcl'] = $exdc_data_test['fspcl'];
            }
            if (empty($exdc_data['hwcl'])) {
                $exdc_data['hwcl'] = 0;
            }
            if (empty($exdc_data['fspcl'])) {
                $exdc_data['fspcl'] = 0;
            }
            $wago_stock_number = $exdc_data['hwcl'] + $exdc_data['fspcl'];//货物仓，商品库存数量

            // 货物仓，商品库存数量
            if ($wago_stock_number) {
                // 查询商品数据
                $find_goo_id = DB::table('goods')
                            ->where('goo_cid', 1)
                            ->where('goo_shop_id', 1)
                            ->where('goo_delete', 1)
                            ->where('goo_goods_encode', $exdc_data['goo_goods_encode'])
                            ->where('goo_type', 1)
                            ->value('goo_id');
                $oure_data['oure_shop_id'] = $shop_id;
                $oure_data['ware_id'] = $ware_id;
                $oure_data['wago_class'] = 1;
                $oure_data['wago_goo_id'] = $find_goo_id;
                $oure_data['oure_out_in_type'] = 2;
                $oure_data['oure_goo_number'] = $wago_stock_number;
                $oure_data['oure_goo_type'] = 1;
                $res = DB::table('outin_record_initial_tset')->insert($oure_data);
                dump($res);
                unset($oure_data);
            }

            // 旧货仓良品库存，商品库存数量
            if ($exdc_data['jhcl']) {
                // 查询商品数据
                $find_goo_id = DB::table('goods')
                            ->where('goo_cid', 1)
                            ->where('goo_shop_id', 1)
                            ->where('goo_delete', 1)
                            ->where('goo_goods_encode', $exdc_data['goo_goods_encode'])
                            ->where('goo_type', 4)
                            ->value('goo_id');
                $oure_data['oure_shop_id'] = $shop_id;
                $oure_data['ware_id'] = $ware_id;
                $oure_data['wago_class'] = 3;
                $oure_data['wago_goo_id'] = $find_goo_id;
                $oure_data['oure_out_in_type'] = 2;
                $oure_data['oure_goo_number'] = $exdc_data['jhcl'];
                $oure_data['oure_goo_type'] = 1;
                $res = DB::table('outin_record_initial_tset')->insert($oure_data);
                dump($res);
                unset($oure_data);
            }
            $exdc_data_test['jhcy'] = trim($exdc_data['jhcy'], '=');
            if (stristr($exdc_data_test['jhcy'], '+')) {
                $test_data = explode('+', $exdc_data_test['jhcy']);
                $exdc_data['jhcy'] = array_sum($test_data);
                unset($test_data);
            } else {
                $exdc_data['jhcy'] = $exdc_data_test['jhcy'];
            }
            // 旧货仓优先库存，商品库存数量
            if ($exdc_data['jhcy']) {
                // 查询商品数据
                $find_goo_id = DB::table('goods')
                            ->where('goo_cid', 1)
                            ->where('goo_shop_id', 1)
                            ->where('goo_delete', 1)
                            ->where('goo_goods_encode', $exdc_data['goo_goods_encode'])
                            ->where('goo_type', 4)
                            ->value('goo_id');
                $oure_data['oure_shop_id'] = $shop_id;
                $oure_data['ware_id'] = $ware_id;
                $oure_data['wago_class'] = 3;
                $oure_data['wago_goo_id'] = $find_goo_id;
                $oure_data['oure_out_in_type'] = 2;
                $oure_data['oure_goo_number'] = $exdc_data['jhcy'];
                $oure_data['oure_goo_type'] = 2;
                $res = DB::table('outin_record_initial_tset')->insert($oure_data);
                dump($res);
                unset($oure_data);
            }

            // 临时仓待检测，商品库存数量
            if (isset($exdc_data['lscdjc']) && $exdc_data['lscdjc']) {
                // 查询商品数据
                $find_goo_id = DB::table('goods')
                            ->where('goo_cid', 1)
                            ->where('goo_shop_id', 1)
                            ->where('goo_delete', 1)
                            ->where('goo_goods_encode', $exdc_data['goo_goods_encode'])
                            ->where('goo_type', 4)
                            ->value('goo_id');
                $oure_data['oure_shop_id'] = $shop_id;
                $oure_data['ware_id'] = $ware_id;
                $oure_data['wago_class'] = 4;
                $oure_data['wago_goo_id'] = $find_goo_id;
                $oure_data['oure_out_in_type'] = 2;
                $oure_data['oure_goo_number'] = $exdc_data['lscdjc'];
                $oure_data['oure_goo_type'] = 3;
                $res = DB::table('outin_record_initial_tset')->insert($oure_data);
                dump($res);
                unset($oure_data);
            }
            unset($exdc_data);
        }
    }

    // 导入Excel数据
    private function importExcelData()
    {
        $path = public_path('img/库存商品数据.xls');
        if (is_file($path)) {
            $spreadsheet = \PhpOffice\PhpSpreadsheet\IOFactory::load($path);//如果文件存在则直接载入
            $sheet = $spreadsheet->getActiveSheet();//获取活动的工作sheet
            $highest_row = $sheet->getHighestRow(); // 取得总行数

            $n = 0;
            $exdc_data = [];
            $exdc_update_time = date('Y-m-d H:i:s');
            for ($row = 2; $row <= $highest_row; $row++) {
            // for ($row = 3; $row <= $highest_row; $row++) {
                // 杭州石总仓库的期初导入
                $excel_data['ware_name'] = trim($sheet->getCellByColumnAndRow(1, $row)->getValue());//仓库名称
                $excel_data['ware_class'] = trim($sheet->getCellByColumnAndRow(2, $row)->getValue());//仓库类别
                $excel_data['goo_goods_encode'] = trim($sheet->getCellByColumnAndRow(3, $row)->getValue());//检索编码
                $excel_data['goo_name'] = trim($sheet->getCellByColumnAndRow(4, $row)->getValue());//商品名称
                $excel_data['goo_price'] = trim($sheet->getCellByColumnAndRow(5, $row)->getValue());//期初金额
                $excel_data['wago_stock_number'] = trim($sheet->getCellByColumnAndRow(6, $row)->getValue());//良品库存
                $excel_data['wago_priority_stock_number'] = trim($sheet->getCellByColumnAndRow(7, $row)->getValue());//优先库存

                // 仙岳仓库存（截止9.11日早上8：30前）.xlsx和（新）前埔店库存（截止9.9日24：00）.xlsx
                // $excel_data['goo_cate_name'] = trim($sheet->getCellByColumnAndRow(2, $row)->getValue());//品类
                // $excel_data['goo_bra_name'] = trim($sheet->getCellByColumnAndRow(3, $row)->getValue());//品牌
                // $excel_data['goo_brse_name'] = trim($sheet->getCellByColumnAndRow(4, $row)->getValue());//系列
                // $excel_data['goo_goods_encode'] = trim($sheet->getCellByColumnAndRow(5, $row)->getValue());//鑫世进商品编码
                // $excel_data['goo_sd_goods_encode'] = trim($sheet->getCellByColumnAndRow(6, $row)->getValue());//速电快保商品编码
                // $excel_data['goo_name'] = trim($sheet->getCellByColumnAndRow(7, $row)->getValue());//商品名称
                // $excel_data['guige'] = trim($sheet->getCellByColumnAndRow(8, $row)->getValue());//规格
                // $excel_data['danwei'] = trim($sheet->getCellByColumnAndRow(9, $row)->getValue());//单位
                // $excel_data['hwcl'] = trim($sheet->getCellByColumnAndRow(10, $row)->getValue());//货物仓良品
                // $excel_data['fspcl'] = trim($sheet->getCellByColumnAndRow(11, $row)->getValue());//非商品仓良品
                // $excel_data['jhcl'] = trim($sheet->getCellByColumnAndRow(12, $row)->getValue());//旧货仓良品
                // $excel_data['jhcy'] = trim($sheet->getCellByColumnAndRow(13, $row)->getValue());//旧货仓优品
                // $excel_data['lscdjc'] = trim($sheet->getCellByColumnAndRow(14, $row)->getValue());//临时仓待检测
                // $excel_data['chengben'] = trim($sheet->getCellByColumnAndRow(15, $row)->getValue());//成本
                // $excel_data['goo_wholesale_price'] = trim($sheet->getCellByColumnAndRow(16, $row)->getValue());//批发价
                // $excel_data['goo_price'] = trim($sheet->getCellByColumnAndRow(17, $row)->getValue());//零售价
                // $excel_data['goo_remark'] = trim($sheet->getCellByColumnAndRow(18, $row)->getValue());//备注
                dump($excel_data);
                die;

                $exdc_data[$n]['exdc_type'] = 1;
                $exdc_data[$n]['exdc_update_time'] = $exdc_update_time;
                $exdc_data[$n]['exdc_data'] = json_encode($excel_data);
                $n++;
                unset($excel_data);
            }
            // dump($exdc_data);
            // die;
            // $res = DB::table('excel_data_cache')->insert($exdc_data);
            $res = DB::table('excel_data_cache')->insert($exdc_data);
            dump($res);
            // die;
        }
        echo 999;
        die;
    }

    // 比较数据表字段注释
    private function comparisonFieldComment()
    {
        // 查询表注释数据
        $table_field = DB::table('table_field')->get();
        $table_field_two = DB::table('table_field_two')->get();
        $one_table_field = [];
        $one_table = [];
        $two_table = [];
        // 处理数据
        foreach ($table_field as $key => $value) {
            // $one_table['数据表名']['数据字段名'] = 字段注释
            $one_table[$value->TABLE_NAME][$value->COLUMN_NAME] = $value->COLUMN_COMMENT;
            $one_table_field[$value->TABLE_NAME][$value->COLUMN_NAME] = $value;
        }
        foreach ($table_field_two as $key => $value) {
            $two_table[$value->TABLE_NAME][$value->COLUMN_NAME] = $value->COLUMN_COMMENT;
        }

        // change 可以更改列名 和 列类型 (每次都要把新列名和旧列名写上, 即使两个列名没有更改,只是改了类型)
        // modify 只能更改列属性 只需要写一次列名, 比change 省事点
        // alter table test modify name_1 int(10);
        $one_not_field = [];//第一个表中没有的字段
        $different_field = [];//字段注释不一样的
        $different_alter_sql = '';//更改字段注释sql
        foreach ($two_table as $table_key => $table_value) {
            foreach ($table_value as $field_key => $field_value) {
                if (isset($one_table[$table_key][$field_key])) {
                    if ($one_table[$table_key][$field_key] != $field_value) {
                        $alter_value = (array)$one_table_field[$table_key][$field_key];
                        $is_null = '';
                        $is_default = '';
                        if ($alter_value['IS_NULLABLE'] == 'NO') {
                            $is_null = ' not null ';
                        }
                        if ($alter_value['COLUMN_DEFAULT'] != 'NULL') {
                            $is_default = ' default "'.$alter_value['COLUMN_DEFAULT'].'" ';
                        }
                        $different_alter_sql .= 'alter table '.$table_key.' modify '.$field_key.' '.$alter_value['COLUMN_TYPE'].$is_null.$is_default.' comment "'.$alter_value['COLUMN_COMMENT'].'";'."\r\n";
                        // dump($alter_value);
                        // dump($different_alter_sql);
                        // dump($one_table_field[$table_key][$field_key]);die;
                        $different_field[$table_key][$field_key] = 'one:'.$one_table[$table_key][$field_key]."\r\n".'two:'.$field_value;
                    }
                } else {
                    $one_not_field[$table_key][$field_key] = $field_value;
                }
            }
        }
        dump($different_alter_sql);
        dump($different_field);
        die;
        dump($one_not_field);
        die;
        dump($one_table);
        die;
    }

    // 将数据中的数据表及字段查询出来，并导出markdown语法格式
    private function databaseFieldComment()
    {
        /*$find_table = DB::select("SELECT t.TABLE_NAME as '表名',t.TABLE_COMMENT as '表注释',c.COLUMN_NAME as '字段名',c.COLUMN_TYPE as '数据类型',
        CASE c.IS_NULLABLE WHEN 'YES' THEN 'YES' ELSE 'NO' END AS 'NULL',
        c.column_key as 索引,
        CASE IFNULL(COLUMN_DEFAULT,'Null')
                WHEN '' THEN '空字符串'
                WHEN 'Null' THEN 'NULL'
                ELSE COLUMN_DEFAULT END  AS 默认值,
        c.COLUMN_COMMENT as 字段说明
        FROM information_schema.TABLES t,INFORMATION_SCHEMA.Columns c
        WHERE c.TABLE_NAME=t.TABLE_NAME AND t.`TABLE_SCHEMA`='wash_store'");*/

        $find_table = DB::select("SELECT t.TABLE_NAME as '表名',t.TABLE_COMMENT as '表注释',c.COLUMN_NAME as '字段名',c.COLUMN_TYPE as '数据类型',
        CASE c.IS_NULLABLE WHEN 'YES' THEN 'YES' ELSE 'NO' END AS 'NULL',
        c.column_key as 索引,
        c.COLUMN_DEFAULT as '默认值',
        c.COLUMN_COMMENT as 字段说明
        FROM information_schema.TABLES t,INFORMATION_SCHEMA.Columns c 
        WHERE c.TABLE_NAME=t.TABLE_NAME AND t.`TABLE_SCHEMA`='wash_store'");
        /*
                $find_table = DB::select("SELECT t.TABLE_NAME,t.TABLE_COMMENT,c.COLUMN_NAME,c.COLUMN_TYPE,
        CASE c.IS_NULLABLE WHEN 'YES' THEN 'YES' ELSE 'NO' END as 'IS_NULLABLE',
        c.column_key,
        CASE IFNULL(COLUMN_DEFAULT,'Null')
                WHEN '' THEN '空字符串'
                WHEN 'Null' THEN 'NULL'
                ELSE COLUMN_DEFAULT END as 'COLUMN_DEFAULT',
        c.COLUMN_COMMENT
        FROM information_schema.TABLES t,INFORMATION_SCHEMA.Columns c
        WHERE c.TABLE_NAME=t.TABLE_NAME AND t.`TABLE_SCHEMA`='gt_bluearp_com'");

         */
        $contents = '';
        $field_string = '|字段 | 类型 | NULL | 索引 | 默认 | 注释 |'."\r\n".
        '|---|---|---|---|---|---| '."\r\n";
        $table_name = '';
        foreach ($find_table as $key => $value) {
            if ($value->表名 == $table_name) {
                $contents .= '| '.$value->字段名.' | '.$value->数据类型.' | '.$value->NULL.' | '.$value->索引.' | '.$value->默认值.' | '.$value->字段说明.' |'."\r\n";
            } else {
                $table_name = $value->表名;
                $table_mark = "\r\n\r\n".'### '.$value->表注释.' '.$value->表名."\r\n\r\n";
                $contents .= $table_mark.$field_string.'| '.$value->字段名.' | '.$value->数据类型.' | '.$value->NULL.' | '.$value->索引.' | '.$value->默认值.' | '.$value->字段说明.' |'."\r\n";
            }
        }
        // 将字符串写入到文件中
        $list = file_put_contents("test.txt", $contents);
        dump($contents);
        die;
    }

    // 查询一个订单有多个发货单的
    private function selectOrderDispatch()
    {
        $find_bill = DB::table('dispatch_bill')
            ->where('dego_cid', 1)
            ->where('dego_shop_id', 1)
            ->where('dego_type', '<>', 3)
            ->get();
        dump(count($find_bill));
        $ord_id_arr = [];//发货单对应的订单id
        foreach ($find_bill as $key => $value) {
            $ord_id = $value->dego_wor_id;
            // 如果是工单发货单，查看工单对应的订单
            if ($value->dego_order_type == 2) {
                $ord_id = DB::table('work_order')
                    ->where('wor_id', $value->dego_wor_id)
                    ->value('wor_order_id');
            }

            $ord_id_arr[] = $ord_id;
        }
        // 获取去掉重复数据的数组
        $unique_arr = array_unique($ord_id_arr);
        // 获取重复数据的数组
        $repeat_arr = array_diff_assoc($ord_id_arr, $unique_arr);
        $unique_arr = array_filter(array_unique($repeat_arr));
        foreach ($unique_arr as $key => $value) {
            $find_order = DB::table('order')
                    ->where('ord_id', $value)
                    ->select('ord_order_number', 'ord_create_time')
                    ->first();
            $ord_data['dego_wor_id'] = $value;
            $ord_data['dego_original_number'] = $find_order->ord_order_number;
            $ord_data['dego_create_time'] = $find_order->ord_create_time;
            $res = DB::table('dispatch_bill_order_test')->insert($ord_data);
            dump($res);
            unset($ord_data);
        }
    }

    // 查询账单下是否有明细数据
    private function selectBill()
    {
        // 账单生成类型1订单账单2速电同步生成3工单账单4期初账单5采购账单
        $find_bill = DB::table('order_bill')
            ->where('orbi_cid', 1)
            ->where('orbi_shop_id', 1)
            // ->where('orbi_state', 3)
            ->where('orbi_create_type', 1)
            ->get();
        foreach ($find_bill as $key => $value) {
            if ($value->orbi_create_type == 1) {
                $find_order = DB::table('order')
                    ->where('ord_orbi_id', $value->orbi_id)
                    ->where('ord_delete', 1)
                    ->first();
                if (empty($find_order)) {
                    dump($value->orbi_number);
                }
            } elseif ($value->orbi_create_type == 3) {
                $find_order = DB::table('work_order')
                    ->where('wor_wobi_id', $value->orbi_id)
                    ->where('wor_delete', 1)
                    ->first();
                if (empty($find_order)) {
                    dump($value->orbi_number);
                }
            } elseif ($value->orbi_create_type == 5) {
                $find_order = DB::table('purchase_orde')
                        ->where('is_del', 1)
                        ->where('cg_zdnumber', $value->orbi_number)
                        ->first();
                if (empty($find_order)) {
                    dump($value->orbi_number);
                }
            }
        }
    }

    // 删除权限
    private function deleteRole()
    {
        /*
            2020.12.07下线权限
            销售出库单、出入库记录（下线）、
            订单售后、活动列表、加盟门店、售后标签（无限期下线）、
            换货单、旧货回收--编辑回收、销售利润（暂时下线）
            订单列表中“添加售后”按钮下了
            销售出库单：141,142,143,144,145,146,147,148,179,180,189
            出入库记录：104,105,106
            订单售后：171,172,173,174,175,176
            订单售后：429,430,431,432,433,434,435,436,437,438,439,440,441,442,458
            活动列表：356,357,358,359,360,361,362,363,373,392
            实体加盟店：182,183,184,185,186
            售后标签：422,423,424,425,426,427
            旧货回收-编辑回收：152
            销售利润：230
            订单列表-添加售后：133
        */

        // $edit_pri_id = [141,142,143,144,145,146,147,148,179,180,189,104,105,106,171,172,173,174,175,176,356,357,358,359,360,361,362,363,373,392,182,183,184,185,186,422,423,424,425,426,427,152,230,133,429,430,431,432,433,434,435,436,437,438,439,440,441,442,458];

        // 542 删除权限 12.11日

        /**
            2020.01.06
            拜访任务、竞品展示、铺货更换权限下掉
            拜访任务：381,382,383,384,385,389,393
            竞品展示：386
            铺货更换：387,388
         */
        /*
            2021.01.16
            改版系统删除订单标签、品牌列表、品牌系列、品类列表相关权限
            订单标签：214,215,216,217,218,219
            品牌列表：16,17,18,20,21,22
            品牌系列：477,478,479,480,481,482
            品类列表：10,11,12,13,14,15
         */
        // $edit_pri_id = [214,215,216,217,218,219,16,17,18,20,21,22,477,478,479,480,481,482,10,11,12,13,14,15];
        /*
            2021.06.27
            取消车型查询、网单查询权限
            车型查询：418
            网单查询：487
         */
        $edit_pri_id = [418, 487];

        $list = DB::table('role')
        // ->where('rol_shop_id', 1)
        ->select('rol_id', 'rol_privilege')
        ->get();
        // 更改权限表权限id
        foreach ($list as $key => $value) {
            $rol_privilege = explode(',', $value->rol_privilege);
            // dump($rol_privilege);die;
            foreach ($edit_pri_id as $edit_key => $pri_id) {
                // 判断权限id是否在角色id数组中
                if (in_array($pri_id, $rol_privilege)) {
                    $rol_key = array_search($pri_id, $rol_privilege);
                    // 删除角色id数组中的权限id值
                    unset($rol_privilege[$rol_key]);
                }
            }
            // 更改新的权限
            $edit_data['rol_privilege'] = implode(',', $rol_privilege);
            $edit_data['rol_update_time'] = date('Y-m-d H:i:s');
            $edit_res =  DB::table('role')
                ->where('rol_id', $value->rol_id)
                ->update($edit_data);
            dump($edit_res);
            unset($edit_data);
            unset($edit_res);
        }
    }

    // 删除门店数据
    private function delteteData()
    {
        echo 444;
        exit;
        $cid = 1;
        $superior_shop_id = 42;
        // die;
        // 清空仓库商品库存数量
        $wago_edit['wago_stock_number'] = 0;
        $wago_edit['wago_lock_quantity'] = 0;
        $wago_edit['wago_priority_stock_number'] = 0;
        $wago_edit['wago_priority_lock_quantity'] = 0;
        $wago_edit['wago_unchecked_stock_number'] = 0;
        $wago_edit['wago_refuse_fine_stock'] = 0;
        $wago_edit['wago_refuse_fine_lock'] = 0;
        $wago_edit['wago_refuse_priority_stock'] = 0;
        $wago_edit['wago_refuse_priority_lock'] = 0;
        $wago_res = DB::table('warehouse_goods as b')
            ->leftjoin('warehouse as a', 'b.wago_ware_id', '=', 'a.ware_id')
            ->where('ware_cid', $cid)
            // ->where('ware_superior_shop_id', $superior_shop_id)
            ->where('ware_shop_id', $superior_shop_id)
            ->update($wago_edit);
        dump($wago_res);

        // 清空仓库总的商品数量
        $waon_edit['waon_all_amount'] = 0;
        $waon_edit['waon_stock_fine_amount'] = 0;
        $waon_edit['waon_lock_fine_amount'] = 0;
        $waon_edit['waon_stock_priority_amount'] = 0;
        $waon_edit['waon_lock_priority_amount'] = 0;
        $waon_edit['waon_stock_unchecked_amount'] = 0;
        $wago_res = DB::table('warehouse_onhand as b')
            ->leftjoin('warehouse as a', 'b.waon_ware_id', '=', 'a.ware_id')
            ->where('ware_cid', $cid)
            // ->where('ware_superior_shop_id', $superior_shop_id)
            ->where('ware_shop_id', $superior_shop_id)
            ->update($waon_edit);
        dump($wago_res);

        // 删除仓库锁定表数据
        $wagl_res = DB::table('warehouse_goods_lock')
            ->where('wagl_shop_id', $superior_shop_id)
            ->delete();
        dump($wagl_res);
        die;
        // 删除工单商品表数据
        /* $wago_res = DB::table('work_good as b')
            ->leftjoin('work_order as a', 'a.wor_id', '=', 'b.wogo_wor_id')
            ->where('wor_cid', $cid)
            // ->where('wor_superior_shop_id', $superior_shop_id)
            ->where('wor_shop_id', $superior_shop_id)
            ->delete();
        dump($wago_res);

        // 删除工单客户表数据
        $wago_res = DB::table('work_client as b')
            ->leftjoin('work_order as a', 'a.wor_id', '=', 'b.wocl_wor_id')
            ->where('wor_cid', $cid)
            // ->where('wor_superior_shop_id', $superior_shop_id)
            ->where('wor_shop_id', $superior_shop_id)
            ->delete();
        dump($wago_res);
        // 删除工单表数据
        $wago_res = DB::table('work_order')
            ->where('wor_cid', $cid)
            // ->where('wor_superior_shop_id', $superior_shop_id)
            ->where('wor_shop_id', $superior_shop_id)
            ->delete();
        dump($wago_res);

        // 删除订单商品表数据
        $wago_res = DB::table('order_goods as b')
            ->leftjoin('order as a', 'a.ord_id', '=', 'b.orgo_ord_id')
            ->where('ord_cid', $cid)
            // ->where('ord_superior_shop_id', $superior_shop_id)
            ->where('ord_shop_id', $superior_shop_id)
            ->delete();
        dump($wago_res);
        // 删除订单客户表数据
        $wago_res = DB::table('order_client as b')
            ->leftjoin('order as a', 'a.ord_id', '=', 'b.orcl_ord_id')
            ->where('ord_cid', $cid)
            // ->where('ord_superior_shop_id', $superior_shop_id)
            ->where('ord_shop_id', $superior_shop_id)
            ->delete();
        dump($wago_res);
        // 删除订单表数据
        $wago_res = DB::table('order')
            ->where('ord_cid', $cid)
            // ->where('ord_superior_shop_id', $superior_shop_id)
            ->where('ord_shop_id', $superior_shop_id)
            ->delete();
        dump($wago_res);

        // 删除订单操作记录
        $wago_res = DB::table('order_log')
            ->where('orlo_cid', $cid)
            ->where('orlo_shop_id', $superior_shop_id)
            ->delete();
        dump($wago_res);
        // 删除操作日志
        $wago_res = DB::table('operation_log')
            ->where('oplo_shop_id', $superior_shop_id)
            ->delete();
        dump($wago_res);

        // 删除订单备注
        $wago_res = DB::table('order_remarks')
            ->where('orre_shop_id', $superior_shop_id)
            ->delete();
        dump($wago_res);
        die; */
        // 删除盘库单商品表
        /*$wago_res = DB::table('stocktake_goods as b')
            ->leftjoin('stocktake as a', 'a.stoc_id', '=', 'b.stgo_stoc_id')
            ->where('stoc_cid', $cid)
            // ->where('stoc_superior_shop_id', $superior_shop_id)
            ->where('stoc_shop_id', $superior_shop_id)
            ->delete();
        dump($wago_res);
        // 删除盘库单表
        $wago_res = DB::table('stocktake')
            ->where('stoc_cid', $cid)
            // ->where('stoc_superior_shop_id', $superior_shop_id)
            ->where('stoc_shop_id', $superior_shop_id)
            ->delete();
        dump($wago_res);

        // 删除出入库记录表
        $wago_res = DB::table('outin_details as b')
            ->leftjoin('outin_record as a', 'a.oure_id', '=', 'b.oude_oure_id')
            ->where('oure_cid', $cid)
            // ->where('oure_superior_shop_id', $superior_shop_id)
            ->where('oure_shop_id', $superior_shop_id)
            ->delete();
        dump($wago_res);
        // 删除出入库记录表
        $wago_res = DB::table('outin_record')
            ->where('oure_cid', $cid)
            // ->where('oure_superior_shop_id', $superior_shop_id)
            ->where('oure_shop_id', $superior_shop_id)
            ->delete();
        dump($wago_res);

        // 删除发货单商品表
        $wago_res = DB::table('dispatch_goods as b')
            ->leftjoin('dispatch_bill as a', 'a.dego_id', '=', 'b.digo_dego_id')
            ->where('dego_cid', $cid)
            // ->where('dego_superior_shop_id', $superior_shop_id)
            ->where('dego_shop_id', $superior_shop_id)
            ->delete();
        dump($wago_res);
        // 删除发货单表
        $wago_res = DB::table('dispatch_bill')
            ->where('dego_cid', $cid)
            // ->where('dego_superior_shop_id', $superior_shop_id)
            ->where('dego_shop_id', $superior_shop_id)
            ->delete();
        dump($wago_res);

        // 删除旧货回收商品表
        $wago_res = DB::table('junk_goods as b')
            ->leftjoin('junk_recycle as a', 'a.jur_id', '=', 'b.jugo_jur_id')
            ->where('jur_cid', $cid)
            // ->where('jur_superior_shop_id', $superior_shop_id)
            ->where('jur_shop_id', $superior_shop_id)
            ->delete();
        dump($wago_res);
        // 删除旧货回收客户表
        $wago_res = DB::table('junk_client as b')
            ->leftjoin('junk_recycle as a', 'a.jur_id', '=', 'b.jucl_jur_id')
            ->where('jur_cid', $cid)
            // ->where('jur_superior_shop_id', $superior_shop_id)
            ->where('jur_shop_id', $superior_shop_id)
            ->delete();
        dump($wago_res);
        // 删除旧货回收单表
        $wago_res = DB::table('junk_recycle')
            ->where('jur_cid', $cid)
            // ->where('jur_superior_shop_id', $superior_shop_id)
            ->where('jur_shop_id', $superior_shop_id)
            ->delete();
        dump($wago_res);

        // 删除退换回收商品表
        $wago_res = DB::table('recede_goods as b')
            ->leftjoin('recede_recycle as a', 'a.rec_id', '=', 'b.rego_rec_id')
            ->where('rec_cid', $cid)
            // ->where('rec_superior_shop_id', $superior_shop_id)
            ->where('rec_shop_id', $superior_shop_id)
            ->delete();
        dump($wago_res);
        // 退换回收客户表
        $wago_res = DB::table('recede_client as b')
            ->leftjoin('recede_recycle as a', 'a.rec_id', '=', 'b.recl_rec_id')
            ->where('rec_cid', $cid)
            // ->where('rec_superior_shop_id', $superior_shop_id)
            ->where('rec_shop_id', $superior_shop_id)
            ->delete();
        dump($wago_res);
        // 删除退换回收单表
        $wago_res = DB::table('recede_recycle')
            ->where('rec_cid', $cid)
            // ->where('rec_superior_shop_id', $superior_shop_id)
            ->where('rec_shop_id', $superior_shop_id)
            ->delete();
        dump($wago_res);

        // 删除结款明细表
        $wago_res = DB::table('accounting_settlement')
            ->where('acset_adm_cid', $cid)
            // ->where('acset_superior_shop_id', $superior_shop_id)
            ->where('acset_shop_id', $superior_shop_id)
            ->delete();
        dump($wago_res);

        // 删除应收账款表
        $wago_res = DB::table('receivable_credit')
            ->where('recr_cid', $cid)
            // ->where('recr_shop_superior_id', $superior_shop_id)
            ->where('recr_shop_id', $superior_shop_id)
            ->delete();
        dump($wago_res);
        die; */
        // 删除银行卡查询表
        $wago_res = DB::table('account_select')
            ->where('acti_shop_id', $superior_shop_id)
            ->delete();
        dump($wago_res);
        // 删除银行卡表
        $wago_res = DB::table('account_title')
            ->where('acti_shop_id', $superior_shop_id)
            ->delete();
        dump($wago_res);

        // 删除销售明细表
        $wago_res = DB::table('sell_detail')
            ->where('sede_cid', $cid)
            // ->where('sede_superior_shop_id', $superior_shop_id)
            ->where('sede_shop_id', $superior_shop_id)
            ->delete();
        dump($wago_res);

        // 删除销售统计表
        $dast_res = DB::table('data_statistical')
            ->where('dast_cid', $cid)
            // ->where('sede_superior_shop_id', $superior_shop_id)
            ->where('dast_shop_id', $superior_shop_id)
            ->delete();
        dump($dast_res);

        // 删除账单列表
        $orbi_res = DB::table('order_bill')
            ->where('orbi_cid', $cid)
            ->where('orbi_shop_id', $superior_shop_id)
            ->delete();
        dump($orbi_res);

        // 删除进销存查询数据
        $ense_res = DB::table('enters_sells_saves')
            ->where('ense_shop_id', $superior_shop_id)
            ->delete();
        dump($ense_res);

        // 删除凭证列表
        $volo_res = DB::table('voucher_loan as volo')
            ->leftjoin('voucher_receipts as vore', 'vore.vore_id', '=', 'volo.volo_vore_id')
            ->where('volo_shop_id', $superior_shop_id)
            ->delete();
        dump($volo_res);
        $vore_res = DB::table('voucher_receipts')
            ->where('vore_shop_id', $superior_shop_id)
            ->delete();
        dump($vore_res);

        // 删除销售出库商品表
        $wago_res = DB::table('sell_goods as b')
            ->leftjoin('sell as a', 'a.sell_id', '=', 'b.sego_sell_id')
            ->where('sell_cid', $cid)
            ->where('sell_shop_id', $superior_shop_id)
            ->delete();
        dump($wago_res);
        // 销售出库客户表
        $wago_res = DB::table('sell_client as b')
            ->leftjoin('sell as a', 'a.sell_id', '=', 'b.secl_sell_id')
            ->where('sell_cid', $cid)
            ->where('sell_shop_id', $superior_shop_id)
            ->delete();
        dump($wago_res);
        // 销售出库表
        $wago_res = DB::table('sell')
            ->where('sell_cid', $cid)
            ->where('sell_shop_id', $superior_shop_id)
            ->delete();
        dump($wago_res);

        // 调拨单商品表
        $wago_res = DB::table('transferring_order_goods as b')
            ->leftjoin('transferring_order as a', 'a.tror_id', '=', 'b.trog_tror_id')
            ->where('tror_cid', $cid)
            ->where('tror_shop_id', $superior_shop_id)
            ->delete();
        dump($wago_res);
        // 调拨单详情表
        $wago_res = DB::table('transferring_order_details as b')
            ->leftjoin('transferring_order as a', 'a.tror_id', '=', 'b.trod_tror_id')
            ->where('tror_cid', $cid)
            ->where('tror_shop_id', $superior_shop_id)
            ->delete();
        dump($wago_res);
        // 调拨单
        $wago_res = DB::table('transferring_order')
            ->where('tror_cid', $cid)
            ->where('tror_shop_id', $superior_shop_id)
            ->delete();
        dump($wago_res);

        // 采购进销存数据删除
        $wago_res = DB::table('purchase_record_goods as b')
            ->leftjoin('purchase_record as a', 'a.pure_id', '=', 'b.purg_pure_id')
            ->where('a.pure_cid', $cid)
            // ->where('a.pure_superior_shop_id', $superior_shop_id)
            ->where('a.pure_shop_id', $superior_shop_id)
            ->delete();
        dump($wago_res);
        // 采购进销存记录表
        $wago_res = DB::table('purchase_record')
            ->where('pure_cid', $cid)
            // ->where('pure_superior_shop_id', $superior_shop_id)
            ->where('pure_shop_id', $superior_shop_id)
            ->delete();
        dump($wago_res);
        // 采购表
        $wago_res = DB::table('purchase_order')
            ->where('company_id', $cid)
            // ->where('cg_superior_shop_id', $superior_shop_id)
            ->where('cg_shop_id', $superior_shop_id)
            ->delete();
        dump($wago_res);
        // 入库商品表
        $wago_res = DB::table('storage_goods')
            ->where('company_id', $cid)
            // ->where('stgo_superior_shop_id', $superior_shop_id)
            ->where('stgo_shop_id', $superior_shop_id)
            ->delete();
        dump($wago_res);
        // 出入库表
        $wago_res = DB::table('ware_inorder')
            ->where('company_id', $cid)
            // ->where('rk_superior_shop_id', $superior_shop_id)
            ->where('rk_shop_id', $superior_shop_id)
            ->delete();
        dump($wago_res);
        die;

        /* // 售后客户表
        $wago_res = DB::table('order_after_client as b')
            ->leftjoin('order_after as a', 'a.oraf_id', '=', 'b.orac_oraf_id')
            ->where('oraf_cid', $cid)
            ->where('oraf_shop_id', $superior_shop_id)
            ->delete();
        dump($wago_res);
        // 售后商品表
        $wago_res = DB::table('order_after_goods as b')
            ->leftjoin('order_after as a', 'a.oraf_id', '=', 'b.orag_oraf_id')
            ->where('oraf_cid', $cid)
            ->where('oraf_shop_id', $superior_shop_id)
            ->delete();
        dump($wago_res);
        // 订单售后备注表
        $wago_res = DB::table('order_after_note as b')
            ->leftjoin('order_after as a', 'a.oraf_id', '=', 'b.oran_oraf_id')
            ->where('oraf_cid', $cid)
            ->where('oraf_shop_id', $superior_shop_id)
            ->delete();
        dump($wago_res);
        // // 售后日常反馈表
        $wago_res = DB::table('order_after_pic as b')
            ->leftjoin('order_after as a', 'a.oraf_id', '=', 'b.orap_oraf_id')
            ->where('oraf_cid', $cid)
            ->where('oraf_shop_id', $superior_shop_id)
            ->delete();
        dump($wago_res); */

        /* // 活动折扣表
        $wago_res = DB::table('activity_discount as ad')
            ->leftjoin('activity as a', 'a.acti_id', '=', 'ad.acdi_acti_id')
            ->where('acti_shop_id', $superior_shop_id)
            ->delete();
        dump($wago_res);

        // 活动商品表
        $acgo_data['acgo_acti_id'] = '';
        $wago_res = DB::table('activity_goods')
            ->where('acgo_shop_id', $superior_shop_id)
            ->update($acgo_data);
        dump($wago_res);
        // 活动表
        $wago_res = DB::table('activity')
            ->where('acti_shop_id', $superior_shop_id)
            ->delete();
        dump($wago_res); */
        die;
    }

    // 查看仓库重复商品
    private function inquireWarehouseRepeatGoods()
    {
        $find_ware = DB::table('warehouse')
            ->where('ware_shop_id', 1)
            ->get();
        $wago_class = [1,2,3,4];//仓库类别
        foreach ($wago_class as $class_key => $class_value) {
            foreach ($find_ware as $key => $value) {
                // 查找重复商品id相关数据
                $find_data = DB::table('warehouse_goods as wg')
                    ->leftjoin('goods as g', 'g.goo_id', '=', 'wg.wago_goo_id')
                    ->where('wago_ware_id', $value->ware_id)
                    ->where('wago_class', $class_value)
                    ->groupBy('wago_goo_id')
                    ->having(DB::raw('count(wago_id)'), '>', 1)
                    ->select('wago_id', 'wago_ware_id', 'wago_class', 'wago_goo_id', 'wago_stock_number', 'wago_priority_stock_number', 'wago_update_time', 'goo_name', 'goo_goods_encode')
                    ->get()->toArray();
                if ($find_data) {
                    $find_data = json_decode(json_encode($find_data), true);
                    foreach ($find_data as $wg_key => $wg_value) {
                        $wg_value['ware_name'] = $value->ware_name;
                        $res = DB::table('warehouse_goods_adjust')->insert($wg_value);
                        dump($res);
                    }
                }
            }
        }
    }

    // 统计技师退回的商品数据
    private function technicianBackGoods()
    {
        $find_rec = DB::table('recede_recycle')
            ->where('rec_shop_id', 1)
            ->where('rec_create_time', '>', '2020-11-20')
            ->where('rec_create_time', '<', '2020-11-27')
            ->where('rec_source_type', 5)
            ->where('rec_state', 2)
            ->get()->toArray();
        // dump($find_rec);
        foreach ($find_rec as $key => $value) {
            $find_rego_data = DB::table('recede_goods')
                ->where('rego_rec_id', $value->rec_id)
                ->where('rego_wago_id', '=', 0)
                ->get()->toArray();
            if ($find_rego_data) {
                $find_rego_data = json_decode(json_encode($find_rego_data), true);
                dump($find_rego_data);
                foreach ($find_rego_data as $wg_key => $wg_value) {
                    $wg_value['rec_id'] = $value->rec_id;
                    $wg_value['rec_number'] = $value->rec_number;
                    $wg_value['rec_ord_id'] = $value->rec_ord_id;
                    $wg_value['rec_ord_order_number'] = $value->rec_ord_order_number;
                    $res = DB::table('recede_goods_back')->insert($wg_value);
                    dump($res);
                }
            }
        }
    }

    // 新增仓库商品
    private function addWarehouseGoods()
    {
        // 查询固定仓库
        $find_ware = DB::table('warehouse')
            ->where('ware_shop_id', 1)
            ->where('ware_type', 1)
            ->get();
        foreach ($find_ware as $key => $value) {
            $ware_add_data['wago_ware_id'] = $value->ware_id;
            $ware_add_data['wago_class'] = 1;
            $ware_add_data['wago_goo_id'] = 96011;
            $ware_add_data['wago_stock_number'] = 9999;
            $ware_add_res = DB::table('warehouse_goods')->insert($ware_add_data);
            dump($ware_add_res);
            $res = DB::table('warehouse_onhand')
            ->where('waon_ware_id', $value->ware_id)
            ->where('waon_class', 1)
            ->increment('waon_all_amount', 9999);
            dump($res);

            $res = DB::table('warehouse_onhand')
            ->where('waon_ware_id', $value->ware_id)
            ->where('waon_class', 1)
            ->increment('waon_stock_fine_amount', 9999);
            dump($res);
        }
    }
}
